<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'h5p', language 'pt_br', version '4.4'.
 *
 * @package     h5p
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['a11yTitle:label'] = 'Rótulo de Tecnologias Assistivas';
$string['acceptTerms'] = 'Eu aceito os <a href=":url" target="_blank">termos de uso</a>';
$string['accountDetailsLinkText'] = 'aqui';
$string['actions'] = 'Ações';
$string['add'] = 'Adicionar';
$string['addedandupdatedpp'] = 'Adicionadas {$a->%new} novas bibliotecas H5P e atualizadas {$a->%old} bibliotecas antigas.';
$string['addedandupdatedps'] = 'Adicionadas {$a->%new} novas bibliotecas H5P e atualizada {$a->%old} biblioteca antiga.';
$string['addedandupdatedsp'] = 'Adicionadas {$a->%new} nova biblioteca H5P e atualizada {$a->%old} bibliotecas antigas.';
$string['addedandupdatedss'] = 'Adicionadas {$a->%new} nova biblioteca H5P e atualizada {$a->%old} biblioteca antiga.';
$string['addednewlibraries'] = 'Adicionadas {$a->%new} novas bibliotecas H5P.';
$string['addednewlibrary'] = 'Adicionada {$a->%new} nova biblioteca H5P.';
$string['additionallicenseinfo'] = 'Qualquer informação adicional sobre a licença';
$string['address'] = 'Endereço';
$string['age'] = 'Idade típica';
$string['ageDescription'] = 'O público-alvo deste conteúdo. Possíveis formatos de entrada separados por vírgulas: "1,34-45,-50,59-".';
$string['altText'] = 'Texto alternativo';
$string['atto_h5p'] = 'Inserir botão H5P';
$string['atto_h5p_description'] = 'O botão Inserir H5P no editor Atto permite aos usuários inserir o conteúdo do H5P digitando uma URL ou código de incorporação ou carregando um arquivo H5P.';
$string['author'] = 'Autor';
$string['authorcomments'] = 'Comentários do autor';
$string['authorcommentsdescription'] = 'Comentários para o editor do conteúdo. (Este texto não será publicado como parte das informações de direitos autorais.)';
$string['authorname'] = 'Nome do autor';
$string['authorrole'] = 'Papel do autor';
$string['back'] = 'Voltar';
$string['by'] = 'por';
$string['cancelCrop'] = 'Cancelar corte';
$string['cancelPublishConfirmationDialogCancelButtonText'] = 'Não';
$string['cancelPublishConfirmationDialogConfirmButtonText'] = 'Sim';
$string['cancelPublishConfirmationDialogDescription'] = 'Tem certeza de que deseja cancelar o processo de compartilhamento?';
$string['cancelPublishConfirmationDialogTitle'] = 'Cancelar compartilhamento';
$string['cancellabel'] = 'Cancelar';
$string['ccattribution'] = 'Atribuição (CC BY)';
$string['ccattributionnc'] = 'Atribuição-NãoComercial (CC BY-NC)';
$string['ccattributionncnd'] = 'Atribuição-SemDerivações-SemDerivados (CC BY-NC-ND)';
$string['ccattributionncsa'] = 'Atribuição-NãoComercial-CompartilhaIgual (CC BY-NC-SA)';
$string['ccattributionnd'] = 'Atribuição-SemDerivações (CC BY-ND)';
$string['ccattributionsa'] = 'Atribuição-CompartilhaIgual (CC BY-SA)';
$string['ccpdd'] = 'Domínio Público (CC0)';
$string['changeHasBeenSubmitted'] = 'Uma alteração foi enviada para';
$string['changedby'] = 'Alterado por';
$string['changedescription'] = 'Descrição da alteração';
$string['changelog'] = 'Log de alterações';
$string['changeplaceholder'] = 'Foto cortada, texto alterado etc.';
$string['city'] = 'Cidade';
$string['close'] = 'Fechar';
$string['confirmCrop'] = 'Confirmar corte';
$string['confirmdialogbody'] = 'Por favor, confirme que você deseja prosseguir. Essa ação não pode ser desfeita.';
$string['confirmdialogheader'] = 'Confirmar ação';
$string['confirmlabel'] = 'Confirmar';
$string['connectionLost'] = 'Conexão perdida. Os resultados serão armazenados e enviados quando a conexão for restabelecida.';
$string['connectionReestablished'] = 'Conexão restabelecida.';
$string['contactPerson'] = 'Pessoa de contato';
$string['contactPersonDescription'] = 'O H5P entrará em contato com a pessoa de contato caso haja algum problema com o conteúdo compartilhado pelo editor. O nome da pessoa de contato ou outras informações não serão publicadas ou compartilhadas com terceiros';
$string['contentAvailable'] = 'Seu conteúdo normalmente estará disponível no Hub em um dia útil.';
$string['contentCopied'] = 'O conteúdo é copiado para a área de transferência';
$string['contentLicenseTitle'] = 'Informações sobre a licença de conteúdo';
$string['contentUpdateSoon'] = 'Seu conteúdo será atualizado em breve';
$string['contentchanged'] = 'Este conteúdo foi alterado desde a última vez que você o usou.';
$string['contentinuse'] = 'Este conteúdo pode estar em uso em outros lugares.';
$string['contenttype'] = 'Tipo de conteúdo';
$string['copyright'] = 'Direitos de uso';
$string['copyrightWarning'] = 'O material protegido por direitos autorais não pode ser compartilhado no H5P Content Hub. Se o conteúdo for licenciado com uma licença compatível com OER, como Creative Commons, escolha a licença apropriada. Caso contrário, este conteúdo não pode ser compartilhado.';
$string['copyrightinfo'] = 'Informações sobre direitos autorais';
$string['copyrightstring'] = 'Direitos autorais';
$string['copyrighttitle'] = 'Ver informações de direitos autorais deste conteúdo.';
$string['couldNotParseJSONFromZip'] = 'Não foi possível analisar o JSON do pacote: {$a->%fileName}';
$string['couldNotReadFileFromZip'] = 'Não foi possível ler o arquivo do pacote: {$a->%fileName}';
$string['country'] = 'País';
$string['creativecommons'] = 'Creative Commons';
$string['cropImage'] = 'Cortar imagem';
$string['currentStep'] = 'Etapa :step de :total';
$string['date'] = 'Data';
$string['deletelibraryconfirm'] = '<p>Tem certeza de que deseja excluir a versão <em>\'{$a->version}\'</em> da biblioteca <em>\'{$a->name}\'</em>? Isso removerá a biblioteca e tudo que a utiliza.</p><p>Esta operação não pode ser desfeita.</p>';
$string['deletelibraryversion'] = 'Excluir versão';
$string['deleting'] = 'Excluindo uma biblioteca';
$string['description'] = 'Descrição';
$string['disablefullscreen'] = 'Desabilitar tela cheia';
$string['discipline:dropdownButton'] = 'Botão suspenso';
$string['discipline:in'] = 'em';
$string['discipline:searchPlaceholder'] = 'Digite para buscar as disciplinas';
$string['disciplineDescription'] = 'Você pode selecionar múltiplas disciplinas';
$string['disciplineLabel'] = 'Disciplinas';
$string['disciplineLimitReachedMessage'] = 'Você pode selecionar até :numDisciplines disciplinas';
$string['disciplines'] = 'Disciplinas';
$string['download'] = 'Baixar';
$string['downloadtitle'] = 'Baixar esse conteúdo como um arquivo H5P.';
$string['editInfoTitle'] = 'Editar informação para <strong>:title</strong>';
$string['editcontent'] = 'Editar conteúdo H5P';
$string['editingFailed'] = 'Falha na edição.';
$string['editor'] = 'Editor';
$string['emailAddress'] = 'Endereço de e-mail';
$string['emailAddressDescription'] = 'O endereço de e-mail será usado pelo H5P para entrar em contato com o editor em caso de problemas com o conteúdo ou caso o editor precise recuperar sua conta. Não será publicado ou compartilhado com terceiros';
$string['embed'] = 'Incorporar';
$string['embedtitle'] = 'Ver o código de incorporação para este conteúdo.';
$string['error:emptycontentid'] = 'A URL fornecida é inválida ou você não pode editar esse arquivo.';
$string['eventh5pdeleted'] = 'H5P excluído';
$string['eventh5pviewed'] = 'Conteúdo H5P visualizado';
$string['feature'] = 'Recurso';
$string['fetchtypesfailure'] = 'Não foi possível obter informações sobre os tipos de conteúdo H5P disponíveis. Falha na conexão com o repositório H5P';
$string['fileExceedsMaxSize'] = 'Um dos arquivos dentro do pacote excede o tamanho máximo permitido.  ({$a->%file} {$a->%used} > {$a->%max})';
$string['filter_displayh5p'] = 'Exibir filtro H5P';
$string['filter_displayh5p_description'] = 'Converte as URLs em conteúdo H5P incorporado.';
$string['fullscreen'] = 'Tela cheia';
$string['gpl'] = 'Licença Pública Geral GPLv3';
$string['h5p'] = 'H5P';
$string['h5pcustomcss'] = 'CSS personalizado';
$string['h5pcustomcss_help'] = 'CSS personalizado para aplicar ao seu conteúdo H5P.';
$string['h5peditor'] = 'Editor H5P';
$string['h5pfilenotfound'] = 'Arquivo H5P não encontrado';
$string['h5pinvalidurl'] = 'URL de conteúdo H5P inválida.';
$string['h5plibraryhandler'] = 'Manipulador do framework H5P';
$string['h5plibraryhandler_help'] = 'O framework H5P usado para exibir conteúdo H5P. A última versão é recomendada';
$string['h5pmanage'] = 'Gerenciar tipos de conteúdo H5P';
$string['h5poverview'] = 'Visão geral do H5P';
$string['h5ppackage'] = 'Tipo de conteúdo H5P';
$string['h5ppackage_help'] = 'Um tipo de conteúdo H5P é um arquivo com uma extensão H5P ou ZIP contendo todas as bibliotecas necessárias para exibir o conteúdo.';
$string['h5pprivatefile'] = 'Este conteúdo H5P não pode ser exibido porque você não tem acesso ao arquivo .h5p.';
$string['h5psettings'] = 'Configurações H5P';
$string['h5ptitle'] = 'Visite h5p.org para conferir mais conteúdo.';
$string['height'] = 'altura';
$string['helpChoosingLicense'] = 'Ajude-me a escolher uma licença';
$string['hideadvanced'] = 'Ocultar avançado';
$string['icon'] = 'Ícone';
$string['iconDescription'] = '640x480px. Se não for selecionado, o conteúdo usará o ícone de categoria';
$string['installedcontentlibraries'] = 'Bibliotecas H5P instaladas';
$string['installedcontenttypes'] = 'Tipos de conteúdo H5P instalados';
$string['installedh5p'] = 'H5P instalado';
$string['invalidAge'] = 'Formato de entrada inválido para idade típica. Possíveis formatos de entrada separados por vírgulas: "1, 34-45, -50, -59-".';
$string['invalidcontextid'] = 'Arquivo H5P não encontrado (contextid inválido)';
$string['invalidfile'] = 'Arquivo "{$a->%filename}" não permitido. Apenas arquivos contendo as seguintes extensões são permitidos: {$a->%files-allowed}.';
$string['invalidlanguagefile'] = 'Arquivo de idioma inválido {$a->%file} na biblioteca {$a->%library}';
$string['invalidlanguagefile2'] = 'Arquivo de idioma inválido {$a->%languageFile} foi incluido na biblioteca {$a->%name}';
$string['invalidlibrarydata'] = 'Dado inválido fornecido para {$a->%property} para {$a->%library}';
$string['invalidlibrarydataboolean'] = 'Dado inválido fornecido para {$a->%property} para {$a->%library}. Booleano esperado.';
$string['invalidlibraryname'] = 'Nome de biblioteca inválido: {$a->%name}';
$string['invalidlibrarynamed'] = 'A biblioteca H5P {$a->%library} usada no conteúdo não é válida';
$string['invalidlibraryoption'] = 'Opção ilegal {$a->%option} na {$a->%library}';
$string['invalidlibraryproperty'] = 'Não foi possível ler a propriedade {$a->%property} na {$a->%library}';
$string['invalidmainjson'] = 'Um arquivo principal h5p.json válido está faltando';
$string['invalidmultiselectoption'] = 'Opção selecionada inválida na seleção múltipla.';
$string['invalidpackage'] = 'Tipo de conteúdo H5P inválido';
$string['invalidselectoption'] = 'Opção selecionada inválida na seleção.';
$string['invalidsemanticsjson'] = 'Arquivo semantics.json inválido foi incluído na biblioteca {$a->%name}';
$string['invalidsemanticstype'] = 'Erro interno do H5P: tipo de conteúdo desconhecido "{$a->@type}" no semantics. Removendo conteúdo!';
$string['invalidstring'] = 'A string fornecida não é válida de acordo com a regexp no semantics. (valor: "{$a->%value}", regexp: "{$a->%regexp}")';
$string['isNowSubmitted'] = 'Enviado agora para H5P Hub';
$string['keywordExists'] = 'A palavra-chave já existe!';
$string['keywords'] = 'Palavras-chave';
$string['keywordsDescription'] = 'Você pode adicionar várias palavras-chave separadas por vírgulas. Pressione "Enter" ou "Adicionar" para confirmar as palavras-chave';
$string['keywordsExits'] = 'As palavras-chave já existem!';
$string['keywordsPlaceholder'] = 'Adicionar palavras-chave';
$string['language'] = 'Linguagem';
$string['level'] = 'Nível';
$string['librariesmanagerdescription'] = '<p>O H5P permite que os usuários criem conteúdo interativo, fornecendo uma variedade de tipos de conteúdo.</p><p>Para garantir que apenas tipos de conteúdo H5P confiáveis sejam usados em seu site, você precisa <i>ou</i></p><ul><li>Carregar tipos de conteúdo H5P do h5p.org <i>ou</i></li><li>Habilitar a tarefa agendada \'Baixar os tipos de conteúdo H5P disponíveis em h5p.org\'</li></ul><p>Observe que os usuários poderão usar apenas os tipos de conteúdo H5P instalados no seu site.</p>';
$string['librarydirectoryerror'] = 'O nome do diretório da biblioteca deve corresponder a machineName ou machineName-majorVersion.minorVersion (da library.json). (Diretório: {$a->%directoryName} , machineName: {$a->%machineName}, majorVersion: {$a->%majorVersion}, minorVersion: {$a->%minorVersion})';
$string['license'] = 'Licença';
$string['licenseCC010'] = 'CC0 1.0 Universal (CC0 1.0) Domínio Público';
$string['licenseCC010U'] = 'CC0 1.0 Universal';
$string['licenseCC10'] = '1.0 Genérico';
$string['licenseCC20'] = '2.0 Genérico';
$string['licenseCC25'] = '2.5 Genérico';
$string['licenseCC30'] = '3.0 Não portado';
$string['licenseCC40'] = '4.0 Internacional';
$string['licenseDescription'] = 'Selecione uma licença para seu conteúdo';
$string['licenseDetails'] = 'Detalhes da licença';
$string['licenseDialogDescription'] = 'Clique em uma licença específica para obter informações sobre o uso adequado';
$string['licenseGPL'] = 'Licença Pública Geral';
$string['licenseV1'] = 'Versão 1';
$string['licenseV2'] = 'Versão 2';
$string['licenseV3'] = 'Versão 3';
$string['licenseVersionDescription'] = 'Selecione uma versão de licença';
$string['licensee'] = 'Licenciado';
$string['licenseextras'] = 'Informações extras da licença';
$string['licenseversion'] = 'Versão da licença';
$string['lockh5pdeploy'] = 'Este conteúdo H5P não pode ser acessado porque está sendo implantado. Por favor, tente novamente mais tarde.';
$string['logoUploadText'] = 'Logotipo ou avatar da organização';
$string['longDescription'] = 'Descrição longa';
$string['longDescriptionPlaceholder'] = 'Descrição longa do seu conteúdo';
$string['mainTitle'] = 'Compartilhando <strong>:title</strong>';
$string['mainlibrarydisabled'] = 'Este arquivo não pode ser mostrado porque seu tipo de conteúdo está desabilitado. Por favor, contacte seu administrador para pedir que o tipo de conteúdo seja habilitado.';
$string['maxLength'] = ':length é o número máximo de caracteres';
$string['missingcontentfolder'] = 'Uma pasta de conteúdo válida está faltando';
$string['missingcoreversion'] = 'O sistema não pôde instalar o componente {$a->%component} do pacote, pois ele requer uma versão mais recente do plugin H5P. Atualmente este site está executando a versão {$a->%current}, enquanto a versão necessária é {$a->%required} ou superior. Por favor, atualize e tente novamente.';
$string['missingdependency'] = 'Dependência ausente {$a->@dep} exigida por {$a->@lib}.';
$string['missinglibrary'] = 'Biblioteca necessária ausente {$a->@library}';
$string['missinglibraryfile'] = 'O arquivo "{$a->%file}" está faltando na biblioteca: "{$a->%name}"';
$string['missinglibraryjson'] = 'Não foi possível encontrar o arquivo library.json com um formato json válido para a biblioteca {$a->%name}';
$string['missinglibraryproperty'] = 'A propriedade necessária {$a->%property} está ausente em {$a->%library}';
$string['missingmainlibrary'] = 'Biblioteca principal {$a->@library} ausente';
$string['missingmbstring'] = 'A extensão mbstring do PHP não está carregada.  Ela é necessária para que o H5P funcione corretamente.';
$string['missinguploadpermissions'] = 'Observe que as bibliotecas podem existir no arquivo que você enviou, mas você não tem permissão para carregar novas bibliotecas. Por favor, entre em contato com seu administrador.';
$string['next'] = 'Próximo';
$string['nocopyright'] = 'Nenhuma informação de direitos autorais disponível para este conteúdo.';
$string['noextension'] = 'O arquivo que você enviou não é um pacote HTML5 válido. (Não possui a extensão de arquivo .h5p.)';
$string['noh5plibhandlerdefined'] = 'Não há nenhum manipulador do framework do H5P instalado; portanto, o conteúdo do H5P não pode ser exibido.';
$string['nojson'] = 'O arquivo principal h5p.json não é válido';
$string['nopermissiontodeploy'] = 'Este arquivo não pode ser exibido porque foi enviado por um usuário sem a permissão necessária para disponibilizar conteúdo do H5P.';
$string['nopermissiontoedit'] = 'Você não tem permissão para editar conteúdo H5P.';
$string['notrustablefile'] = 'Este arquivo não pode ser exibido porque foi enviado por um usuário sem a permissão necessária para atualizar tipos de conteúdo H5P. Por favor, entre em contato com seu administrador para solicitar a instalação do tipo de conteúdo.';
$string['nounzip'] = 'O arquivo que você enviou não é um pacote HTML5 válido. (Não é possível descompactá-lo.)';
$string['offlineDialogBody'] = 'Não foi possível enviar as informações sobre sua conclusão dessa tarefa. Por favor, verifique sua conexão à internet.';
$string['offlineDialogHeader'] = 'Sua conexão com o servidor foi perdida';
$string['offlineDialogRetryButtonLabel'] = 'Tentar novamente agora';
$string['offlineDialogRetryMessage'] = 'Tentando novamente em :num....';
$string['offlineSuccessfulSubmit'] = 'Resultados enviados com sucesso.';
$string['optionalInfo'] = 'Informações opcionais';
$string['originator'] = 'Criador';
$string['pd'] = 'Domínio Público';
$string['pddl'] = 'Dedicação e Licença de Domínio Público';
$string['pdm'] = 'Marca de domínio público (PDM)';
$string['phone'] = 'Telefone';
$string['pleaseWait'] = 'Por favor, aguarde...';
$string['pluginname'] = 'Pacote H5P';
$string['privacy:metadata'] = 'O subsistema H5P não armazena nenhum dado pessoal.';
$string['publisherDescription'] = 'Descrição do editor';
$string['publisherDescriptionText'] = 'Isso será exibido em "Informações do editor" no conteúdo compartilhado';
$string['publisherFieldDescription'] = 'Isso será exibido como o "Nome do editor" no conteúdo compartilhado';
$string['publisherFieldTitle'] = 'Editor';
$string['registerOnHub'] = 'Registrar-se no H5P Hub';
$string['registrationFailed'] = 'Ocorreu um erro';
$string['registrationFailedDescription'] = 'Não conseguimos criar uma conta neste momento. Algo deu errado. Tente novamente mais tarde.';
$string['registrationTitle'] = 'Registro do Hub H5P';
$string['remove'] = 'Remover';
$string['removeChip'] = 'Remover :chip da lista';
$string['removeImage'] = 'Remover imagem';
$string['requiredInfo'] = 'Informação necessária';
$string['resizescript'] = 'Inclua este script no seu site se você desejar o dimensionamento dinâmico do conteúdo incorporado:';
$string['resubmitScores'] = 'Tentando enviar os resultados armazenados.';
$string['reuse'] = 'Reusar';
$string['reuseContent'] = 'Reusar conteúdo';
$string['reuseDescription'] = 'Reusar este conteúdo';
$string['reviewAndSave'] = 'Revisar e Salvar';
$string['reviewAndShare'] = 'Revisar e Compartilhar';
$string['reviewInfo'] = 'Revisar informações';
$string['reviewMessage'] = 'Por favor, revise as informações abaixo antes de compartilhar';
$string['rotateLeft'] = 'Girar para a esquerda';
$string['rotateRight'] = 'Girar para a direita';
$string['saveChanges'] = 'Salvar alterações';
$string['screenshots'] = 'Capturas de tela';
$string['screenshotsDescription'] = 'Adicione até cinco capturas de tela do seu conteúdo';
$string['share'] = 'Compartilhar';
$string['shareFailed'] = 'Falha no compartilhamento.';
$string['shareTryAgain'] = 'Algo deu errado, tente compartilhar novamente.';
$string['shared'] = 'Compartilhado';
$string['sharingNote'] = 'Todos os detalhes do conteúdo podem ser editados após o compartilhamento';
$string['shortDescription'] = 'Descrição curta';
$string['shortDescriptionPlaceholder'] = 'Descrição curta do seu conteúdo';
$string['showadvanced'] = 'Mostrar avançado';
$string['showless'] = 'Mostrar menos';
$string['showmore'] = 'Mostrar mais';
$string['size'] = 'Tamanho';
$string['someKeywordsExits'] = 'Algumas dessas palavras-chave já existem';
$string['source'] = 'Fonte';
$string['startingover'] = 'Você começará denovo';
$string['status'] = 'Status';
$string['subContentWarning'] = 'O subconteúdo (imagens, questões, etc.) será compartilhado sob :license, a menos que especificado de outra forma na ferramenta de autoria';
$string['sublevel'] = 'Subnível';
$string['submitted'] = 'Enviado!';
$string['successfullyRegistred'] = 'Você registrou uma conta com sucesso no Hub H5P';
$string['successfullyRegistredDescription'] = 'Os detalhes da sua conta podem ser alterados';
$string['successfullyUpdated'] = 'As configurações da sua conta H5P Hub foram alteradas com sucesso';
$string['task_h5p'] = 'Tarefa agendada H5P';
$string['task_h5p_description'] = 'A tarefa agendada do H5P baixa os tipos de conteúdo H5P disponíveis em h5p.org.';
$string['thumbnail'] = 'Miniatura';
$string['title'] = 'Título';
$string['undisclosed'] = 'Não divulgado';
$string['unpackedFilesExceedsMaxSize'] = 'O tamanho total do arquivo descompactado excede o tamanho máximo permitido. ({$a->%used} > {$a->%max})';
$string['updateRegistrationOnHub'] = 'Salvar configurações da conta';
$string['updatedlibraries'] = 'Bibliotecas H5P atualizadas {$a->%old}.';
$string['updatedlibrary'] = 'Biblioteca H5P atualizada {$a->%old}.';
$string['uploadlibraries'] = 'Enviar tipos de conteúdo H5P';
$string['uploadsuccess'] = 'Tipos de conteúdo H5P enviados com sucesso';
$string['width'] = 'largura';
$string['wrongversion'] = 'A versão da biblioteca H5P {$a->%machineName} usada neste conteúdo é inválida. Conteúdo contêm {$a->%contentLibrary}, mas deve ser {$a->%semanticsLibrary}.';
$string['year'] = 'Ano';
$string['years'] = 'Ano(s)';
$string['yearsfrom'] = 'Anos (de)';
$string['yearsto'] = 'Anos (para)';
$string['zip'] = 'Zip';
