<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'questionnaire', language 'uk', version '4.4'.
 *
 * @package     questionnaire
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Дія';
$string['activityoverview'] = 'У вас є анкети, які необхідно заповнити';
$string['additionalinfo'] = 'Додаткова інформація';
$string['additionalinfo_help'] = 'Текст, що розташований у верхній частині першої сторінки анкети (наприклад, вказівки, довідкова інформація тощо.)';
$string['addnewquestion'] = 'Додавання {$a} нових запитань';
$string['addnewsection'] = 'Додати нову секцію';
$string['addquestion'] = 'Додати запитання...';
$string['addquestions'] = 'Додайте запитання';
$string['addquestiontosection'] = 'Додайте питання до розділу';
$string['addselqtype'] = 'Додати обраний вид запитання';
$string['alignment'] = 'Кнопка регулювання';
$string['alignment_help'] = 'Натиснути кнопку регулювання: вертикальні (за замовчуванням) або горизонтальні';
$string['alignment_link'] = 'mod/questionnaire/questions#Radio_Buttons';
$string['all'] = 'Усі';
$string['allnameddegrees'] = 'Названі ступені';
$string['allnameddegrees_help'] = 'Вкажіть текст, який відображатиметься для значень оцінок замість числа. Залиште значення пустим, щоб не використовувати.';
$string['alreadyfilled'] = 'Ви впоралися із заповненням анкети {$a}. Щиро вдячні!';
$string['andaveragevalues'] = 'та середні значення';
$string['anonymous'] = 'Анонімний';
$string['answer'] = 'Відповідь';
$string['answergiven'] = 'Ця відповідь надана';
$string['answernotgiven'] = 'Ця відповідь не надана';
$string['answerquestions'] = 'Дайте відповіді на запитання...';
$string['answers'] = 'Відповіді';
$string['attempted'] = 'Ця анкета подана.';
$string['attemptstillinprogress'] = 'В процесі. Збережено:';
$string['autonumbering'] = 'Авто нумерація';
$string['autonumbering_help'] = 'Автоматична нумерація питань та сторінок. Можливо, ви захочете відключити автоматичну нумерацію
  для анкет з умовним розгалуженням.';
$string['autonumberno'] = 'Не нумерувати запитання чи сторінки';
$string['autonumberpages'] = 'Автонумерація сторінок';
$string['autonumberpagesandquestions'] = 'Автонумерація сторінок та питань';
$string['autonumberquestions'] = 'Автонумерація питань';
$string['average'] = 'В середньому';
$string['averageposition'] = 'Середня позиція';
$string['averagerank'] = 'Середній клас';
$string['averagesrow'] = 'Середні значення (де це можливо):';
$string['bodytext'] = 'Основний текст';
$string['boxesnbexact'] = 'квадратик (-и) {$a} для позначки точно';
$string['boxesnbmax'] = 'квадратик (-и) {$a} для позначки максимум';
$string['boxesnbmin'] = 'квадратик (-и) {$a} для позначки мінімум';
$string['boxesnbreq'] = 'Для цих запитань Вам потрібно обрати';
$string['by'] = 'за допомогою';
$string['cannotviewpublicresponses'] = 'Ви не можете переглянути відповіді на цю публічну анкету.';
$string['chart:bipolar'] = 'Біполярний графік';
$string['chart:hbar'] = 'Горизонтальний графік';
$string['chart:radar'] = 'Радар';
$string['chart:rose'] = 'Роза';
$string['chart:type'] = 'Тип діаграми';
$string['chart:type_help'] = 'Виберіть тип діаграми, який ви хочете використовувати для цього відгуку';
$string['chart:vprogress'] = 'Вертикальна панель прогресу';
$string['checkallradiobuttons'] = '';
$string['checkboxes'] = 'Кнопка-прапорець';
$string['checkboxes_help'] = 'Вводити по одному варіанту у рядку, щоб користувач міг обрати одну чи декілька відповідей.';
$string['checkboxes_link'] = 'mod/questionnaire/questions#Check_Boxes';
$string['checkbreaksadded'] = 'Нові розриви сторінок, вставлені в позиції:';
$string['checkbreaksok'] = 'Усі необхідні розриви сторінок присутні!';
$string['checkbreaksremoved'] = 'Вилучено додаткові розриви сторінки ({$a}).';
$string['checknotstarted'] = 'Вибір не розпочато';
$string['checkstarted'] = 'Вибір розпочато';
$string['clicktoswitch'] = '(натисніть для перемикання)';
$string['closebeforeopen'] = 'Ви вказали дату закриття меншу ніж дата відкриття.';
$string['closed'] = 'Опитування було завершено {$a}. Дякуємо!';
$string['closedate'] = 'Дозволити відповіді допоки';
$string['closeson'] = 'Опитування припиняється у {$a}';
$string['completionsubmit'] = 'Студент повинен подати цю анкету, щоб заповнити її';
$string['condition'] = 'Умови';
$string['confalts'] = 'Сторінка підтвердження';
$string['configemailreporting'] = 'Дозволити звіти електронною поштою';
$string['configemailreportinglong'] = 'Дозволяє параметри деяких звітів надсилати електронною поштою безпосередньо на вказані адреси електронної пошти.';
$string['configmaxsections'] = 'Максимальна кількість розділів зворотного зв\'язку';
$string['configusergraph'] = 'Відобразити діаграми для зворотного зв\'язку "Тест особистості"';
$string['configusergraphlong'] = 'Використовуйте бібліотеку <a href="http://www.rgraph.net/">Rgraph</a>, щоб відобразити діаграми зворотного зв’язку «Тест особистості».';
$string['confirmdelallresp'] = 'Ви впевнені, що хочете видалити УСІ відповіді з анкети?';
$string['confirmdelchildren'] = 'Якщо ви видалите це запитання, його дочірні запитання також буде видалено:';
$string['confirmdeletesection'] = 'Ви впевнені, що хочете видалити розділ відгуків "{$a}"?';
$string['confirmdelgroupresp'] = 'Ви впевнені, що хочете видалити усі відповіді із {$a}?';
$string['confirmdelquestion'] = 'Ви впевнені, що хочете видалити питання на позиції {$a}?';
$string['confirmdelquestionresps'] = 'Це також видалить {$a} відповідь(-дей) , на вже дані запитання.';
$string['confirmdelresp'] = 'Ви впевнені, що хочете видалити відповіді &nbsp;{$a}&nbsp;?';
$string['confirmremovequestion'] = 'Ви впевнені, що хочете видалити питання "{$a->qname}" з розділу "{$a->sname}"?';
$string['confpage'] = 'Заголовок';
$string['confpage_help'] = 'Заголовок (жирним шрифтом) та основний текст сторінки "Підтвердження", що відображається після того, як користувач заповнив цю анкету. (URL-адреса, якщо вона присутня, має перевагу над текстом підтвердження.) Якщо залишити це поле порожнім, після заповнення анкети відображатиметься повідомлення за замовчуванням (Дякуємо за заповнення цієї анкети).';
$string['confpagedesc'] = 'Текст заголовку (виділений жирним) та основний текст для "Підтвердження";сторінка, яка з\'являється після того, як користувач заповнює цю анкету. (URL-адреса, якщо вона вказана, має перевагу над текстом підтвердження.)';
$string['contentoptions'] = 'Зміст';
$string['couldnotcreatenewsurvey'] = 'Неможливо створити нове опитування!';
$string['couldnotdelresp'] = 'Неможливо видалити відповідь!';
$string['createcontent'] = 'Визначте новий зміст';
$string['createcontent_help'] = 'Оберіть одну з кнопок опцій. "Створити новий" буде обрано за замовчуванням.';
$string['createcontent_link'] = 'mod/questionnaire/mod#Content_Options';
$string['createnew'] = 'Створити новий';
$string['crontask'] = 'Завдання очищення анкети';
$string['date'] = 'Дата';
$string['date_help'] = 'Використовуйте цей вид запитання якщо Ви бажаєте, щоб відповіді були записані у правильному форматі.';
$string['date_link'] = 'mod/questionnaire/questions#Date';
$string['dateformatting'] = 'Використовуйте формат день.місяць.рік, напр. <strong>04.03.1945</strong>';
$string['deleteallresponses'] = 'Видалити УСІ відповіді';
$string['deletecurrentquestion'] = 'Видалити запитання {$a}';
$string['deletedallgroupresp'] = 'Видалити УСІ відповіді у групі {$a}';
$string['deletedallresp'] = 'Відповіді на анкету видалено';
$string['deletedisabled'] = 'Цей елемент не можна видалити';
$string['deletedresp'] = 'Видалена відповідь';
$string['deleteresp'] = 'Видалити цю відповідь';
$string['deletesection'] = 'Видалити цей розділ';
$string['deletingresp'] = 'Видалення відповіді';
$string['dependencies'] = 'Залежності';
$string['dependquestion'] = 'Батьківське питання';
$string['dependquestion_help'] = 'Ви можете вибрати батьківське запитання та варіант вибору для цього запитання. Дочірнє запитання відображатиметься лише
                 студенту, якщо його батьківське питання було попередньо обрано.';
$string['dependquestion_link'] = 'mod/questionnaire/questions#Parent_Question';
$string['didnotrespondtoquestion'] = 'Не відповів на запитання';
$string['directwarnings'] = 'Прямі залежності від цього питання будуть видалені. Це вплине на:';
$string['displaymethod'] = 'Метод відображення не визначений для запитання.';
$string['download'] = 'Скачати';
$string['downloadpdf'] = 'Завантажити PDF';
$string['downloadtextformat'] = 'Завантажити';
$string['downloadtextformat_help'] = 'Ця функція дає змогу зберігати всі відповіді на анкету у форматі файлу, який підтримується на вибір. Ви можете включити додаткові елементи даних в експорт, а також вибрати автоматичне надсилання файлу вибраним користувачам.';
$string['downloadtextformat_link'] = 'mod/questionnaire/report#Download_in_text_format';
$string['downloadtypes'] = 'Тип звіту';
$string['dropdown'] = 'Спадне вікно';
$string['dropdown_help'] = 'Немає реальної переваги у використанні випадаючого вікна перед використанням перемикачів
  крім, можливо, довгих списків опцій, щоб заощадити місце на екрані.';
$string['dropdown_link'] = 'mod/questionnaire/questions#Dropdown_Box';
$string['edit'] = 'Редагувати';
$string['editingfeedback'] = 'Редагування налаштувань зворотного зв\'язку';
$string['editingquestionnaire'] = 'Редагування налаштувань анкети';
$string['editquestion'] = 'Редагування {$a} запитання';
$string['email'] = 'Електронна пошта';
$string['emailextra'] = 'Надіслати завантаження на електронну пошту';
$string['emailextra_help'] = 'Файл завантаження буде надіслано на вказані адреси електронної пошти, розділені комами. Зверніть увагу, що НЕ проводиться перевірка безпеки та конфіденційності.
  Щоб отримати доступ до цього, у налаштуваннях модуля потрібно ввімкнути \'allowemailreporting\'.';
$string['emailroles'] = 'Надіслати завантаження за ролями';
$string['emailroles_help'] = 'Надішле файл завантаження всім ролям із можливістю "mod/questionnaire:submissionnotification" електронною поштою. «allowemailreporting» має бути ввімкнено в налаштуваннях модуля, щоб отримати доступ до цього.';
$string['emailsend'] = 'Надсилати звіти';
$string['emailsnotspecified'] = 'Не вказано електронні адреси.';
$string['emailssent'] = 'Завантаження надіслано на вказані електронні адреси.';
$string['errnewname'] = 'Вибачте, таке ім\'я вже існує. оберіть, будь ласка, інше ім\'я.';
$string['erroropening'] = 'Помилка при запуску анкети.';
$string['errortable'] = 'Пошкодження системної таблиці.';
$string['essaybox'] = 'Поле для відповіді без обмежень обсягу';
$string['essaybox_help'] = 'Це запитання відобразить звичайне текстове поле з x стовпцями Textarea (або шириною області) і y рядками Textarea (кількістю рядків тексту). Якщо ви залишите для x і y значення 0 за замовчуванням (або якщо ви встановите його на 0), то редактор HTML moodle буде відображатися зі стандартною висотою та шириною (якщо доступно в контексті курсу/користувача та профілі користувача).';
$string['event_all_responses_deleted'] = 'Усі відповіді видалено';
$string['event_all_responses_saved_as_text'] = 'Усі відповіді збережено як текст';
$string['event_all_responses_viewed'] = 'Звіт про всі відповіді переглянуто';
$string['event_individual_responses_viewed'] = 'Звіт про індивідуальні відповіді переглянуто';
$string['event_non_respondents_viewed'] = 'Переглянуто нереспонденти';
$string['event_previewed'] = 'Попередній перегляд анкети';
$string['event_question_created'] = 'Питання створено';
$string['event_question_deleted'] = 'Питання видалено';
$string['event_response_deleted'] = 'Індивідуальну відповідь видалено';
$string['event_resumed'] = 'Спроба відновилася';
$string['event_saved'] = 'Відповіді збережено';
$string['event_submitted'] = 'Відповіді подано';
$string['feedback'] = 'Зворотній зв\'язок';
$string['feedback_help'] = 'Зворотній зв\'язок Допомога';
$string['feedback_link'] = 'mod/questionnaire/personality_test#Editing_Questionnaire_Feedback_Messages';
$string['feedbackaddmorefeedbacks'] = 'Додайте ще {no} полів відгуку';
$string['feedbackbysection'] = 'Розділи Зворотній зв\'язок';
$string['feedbackdefaultlabel'] = '[Новий розділ]';
$string['feedbackeditingglobal'] = 'Редагування анкети Глобальний відгук';
$string['feedbackeditingmessages'] = 'Редагування повідомлень зворотного зв\'язку анкети';
$string['feedbackeditingsections'] = 'Редагування розділів відгуків анкети';
$string['feedbackeditmessages'] = 'Збережіть налаштування розділів та відредагуйте повідомлення зворотного зв’язку';
$string['feedbackeditsections'] = 'Збережіть налаштування та відредагуйте розділи відгуків';
$string['feedbackerrorboundaryformat'] = 'Межі оцінки зворотного зв’язку мають бути або відсотками, або числом. Значення, яке ви ввели в межу {$a}, не розпізнається.';
$string['feedbackerrorboundaryoutofrange'] = 'Межі оцінки відгуків мають бути від 0% до 100%. Значення, яке ви ввели в межу {$a}, виходить за межі діапазону.';
$string['feedbackerrorjunkinboundary'] = 'Ви повинні заповнити межі оцінки відгуків, не залишаючи пропусків.';
$string['feedbackerrorjunkinfeedback'] = 'Ви повинні заповнити поля відгуків, не залишаючи прогалин.';
$string['feedbackerrororder'] = 'Межі оцінки зворотного зв’язку мають бути в порядку, спочатку найвищий. Значення, яке ви ввели в межі {$a}, не є послідовним.';
$string['feedbackglobal'] = 'Глобальний зворотній зв\'язок';
$string['feedbackglobalheading'] = 'Заголовок глобального зворотного зв\'язку';
$string['feedbackglobalmessages'] = 'Глобальні повідомлення зворотного зв\'язку';
$string['feedbackhdr'] = 'Відгуки';
$string['feedbackheading'] = 'Заголовок зворотного зв\'язку';
$string['feedbackheading_help'] = 'У полі заголовка зворотного зв’язку можна використовувати 2 змінні: $scorepercent і $oppositescorepercent.';
$string['feedbackmessages'] = 'Повідомлення розділу {$a}';
$string['feedbacknextsection'] = 'Наступний розділ {$a}';
$string['feedbacknone'] = 'Немає повідомлень зворотного зв\'язку';
$string['feedbacknotes'] = 'Примітки для зворотнього зв’язку';
$string['feedbacknotes_help'] = 'Введений тут текст буде відображатися респондентам в кінці їхнього звіту про відгуки';
$string['feedbackoptions'] = 'Варіанти зворотного зв\'язку';
$string['feedbackoptions_help'] = 'Варіанти зворотного зв’язку доступні, якщо ваша анкета містить такі типи запитань і налаштування запитань: Перемикач; Розкривне вікно; Так ні; або Шкала (нормальна шкала або шкала Осгуда). Ці запитання мають бути встановлені як обов’язкові, їх поле «Назва запитання» НЕ повинно бути порожнім, а варіанти можливих відповідей мають містити значення.';
$string['feedbackoptions_link'] = 'mod/questionnaire/personality_test';
$string['feedbackremovequestionfromsection'] = 'Це питання є частиною розділу відгуків [{$a}]';
$string['feedbackremovesection'] = 'Якщо видалити це запитання, розділ відгуку [{$a}] буде повністю видалено';
$string['feedbackreport'] = 'Звіт про зворотній зв\'язок';
$string['feedbackscore'] = 'Оцінка відгуку';
$string['feedbackscoreboundary'] = 'Межа оцінки зворотного зв’язку';
$string['feedbackscores'] = 'Відображення балів';
$string['feedbackscores_help'] = 'Відобразіть таблицю оцінок відгуків';
$string['feedbacksection'] = 'Розділ';
$string['feedbacksectionheading'] = 'Заголовок розділу {$a}';
$string['feedbacksectionheadingmissing'] = 'Ви повинні ввести заголовок для цього розділу відгуків!';
$string['feedbacksectionheadingtext'] = 'Заголовок';
$string['feedbacksectionlabel'] = 'Позначка';
$string['feedbacksectionlabel_help'] = 'Ця позначка буде використовуватися в діаграмах/діаграмах. Будь ласка, зробіть це якомога коротшим!';
$string['feedbacksectionquestions'] = 'Запитання розділу {$a}';
$string['feedbacksections'] = 'Розділи відгуків';
$string['feedbacksectionsselect'] = 'Розділи';
$string['feedbacksectionsselect_help'] = 'Розмістіть свої запитання в цих розділах';
$string['feedbacksectionsselect_link'] = 'mod/questionnaire/personality_test#Editing_Questionnaire_Feedback_Sections_2';
$string['feedbacksettingssaved'] = 'Налаштування відгуків збережено';
$string['feedbacktype'] = 'Тип зворотного зв\'язку';
$string['field'] = 'Запитання {$a}';
$string['fieldlength'] = 'Довжина поля вводу';
$string['fieldlength_help'] = 'Для типу запитань, що передбачають відповідь у "Текстовому полі" використайте закладку "Довжина поля вводу" і "Максимальна довжина тексту" для тексту, що потрібно ввести респондентом.
Параметри за замовчуванням становлять: ширина - 20 символів у Полі вводу з максимальною довжиною у 25 символів тексту, що вводиться.';
$string['finished'] = 'Ви відповіли на всі запитання цієї анкети!';
$string['firstrespondent'] = 'Перший відповідач';
$string['formateditor'] = 'Редактор HTML';
$string['formatplain'] = 'Простий текст';
$string['grade'] = 'Оцінка подання';
$string['gradesdeleted'] = 'Оцінки анкети видалено';
$string['headingtext'] = 'Текст заголовку';
$string['horizontal'] = 'Горизонтальний';
$string['id'] = 'Пароль';
$string['includechoicecodes'] = 'Включіть коди вибору';
$string['includechoicetext'] = 'Включити текст вибору';
$string['includeincomplete'] = 'Включіть неповні відповіді';
$string['includerankaverages'] = 'Включіть середні значення запитань про рейтинг';
$string['incorrectcourseid'] = 'Неправильно вказаний пароль';
$string['incorrectmodule'] = 'Ідентифікатор модуля курсу був неправильним';
$string['incorrectquestionnaire'] = 'Анкета є неправильною';
$string['indirectwarnings'] = 'Цей список показує непрямі залежні запитання та решту залежностей для прямих залежних питань:';
$string['invalidresponse'] = 'Неправильно вказана відповідь';
$string['invalidresponserecord'] = 'Вказана відповідь записана неправильно.';
$string['invalidsectionid'] = 'Указано недійсний розділ відгуку.';
$string['invalidsurveyid'] = 'Неправильний пароль анкети.';
$string['kindofratescale'] = 'Тип шкали розцінок';
$string['kindofratescale_help'] = 'Клацніть правою кнопкою миші посилання «Додаткова допомога».';
$string['kindofratescale_link'] = 'mod/questionnaire/questions#Type_of_rate_scale';
$string['lastrespondent'] = 'Останній респондент';
$string['length'] = 'Довжина';
$string['managequestions'] = 'Керуйте питаннями';
$string['managequestions_help'] = 'У розділі Керування запитаннями на сторінці Редагування запитань ви можете виконати ряд операцій із запитаннями Анкети.';
$string['managequestions_link'] = 'mod/questionnaire/questions#Manage_questions';
$string['mandatory'] = 'Обов’язковий – усі ці залежності мають бути виконані.';
$string['maxdigitsallowed'] = 'Максимум цифр дозволено';
$string['maxdigitsallowed_help'] = 'Використовуйте **Макс. дозволені цифри**, щоб встановити обмеження на кількість символів, введених для числового запитання. Зауважте, що десяткова кома також вважається одним символом!';
$string['maxdigitsallowed_link'] = 'mod/questionnaire/questions#Numeric';
$string['maxforcedresponses'] = 'Макс. вимушені відповіді';
$string['maxforcedresponses_help'] = 'Використовуйте ці параметри, щоб змусити респондента поставити прапорці мінімум **Мін.** і максимум **Макс.**. До примусово встановити точну кількість прапорців, установіть **Мін.** і **Макс.** однакове значення. Якщо потрібно лише мінімальне або максимальне значення, просто залиште інше значення за замовчуванням **0**. Якщо ви установите **Мін.** або **Макс.** значення, відмінні від значення за замовчуванням **0**, з’явиться попередження, якщо респондент не відповідає вашим вимогам. Очевидно, що будь-які вимоги повинні бути чіткими для респондента або в загальних інструкціях Вашої Анкети або в тексті відповідних питань.';
$string['maxtextlength'] = 'Максимальна довжина тексту';
$string['maxtextlength_help'] = 'Для типу запитання «Текстове поле» введіть довжину поля введення та максимальну довжину тексту, який має ввести респондент. Значення за замовчуванням – це 20 символів для ширини поля введення та 25 символів для максимальної довжини введеного тексту.';
$string['messageprovider:message'] = 'Нагадування про анкету';
$string['messageprovider:notification'] = 'Подача анкети';
$string['minforcedresponses'] = 'Хв. вимушені відповіді';
$string['minforcedresponses_help'] = 'Використовуйте ці параметри, щоб змусити респондента поставити прапорці мінімум **Мін.** і максимум **Макс.**. До примусово встановити точну кількість прапорців, установіть **Мін.** і **Макс.** однакове значення. Якщо потрібно лише мінімальне або максимальне значення, просто залиште інше значення за замовчуванням **0**. Якщо ви установите **Мін.** або **Макс.** значення, відмінні від значення за замовчуванням **0**, з’явиться попередження, якщо респондент не відповідає вашим вимогам. Очевидно, що будь-які вимоги повинні бути чіткими для респондента або в загальних інструкціях Вашої Анкети або в тексті відповідних питань.';
$string['misconfigured'] = 'Неправильно визначений курс';
$string['missingname'] = 'Питання {$a} не можна використовувати в цьому розділі відгуку, оскільки воно не має назви.';
$string['missingnameandrequired'] = 'Питання {$a} не можна використовувати в цьому розділі відгуку, оскільки воно не має назви та не є обов’язковим.';
$string['missingquestion'] = 'Будь ласка, дайте відповідь на необхідне запитання';
$string['missingquestions'] = 'Будь ласка, дайте відповіді на необхідні запитання:';
$string['missingrequired'] = 'Питання {$a} не можна використовувати в цьому розділі відгуків, оскільки воно не є обов’язковим.';
$string['modulename'] = 'Анкета';
$string['modulename_help'] = '<p>Даний елемент представляє собою один із методів збору та аналізу даних від користувачів. Анкетування не призначене для перевірки знань студентів, тому відповіді не оцінюються як правильні або неправильні.</p>
<p>Отримання даних відбувається шляхом опитування за допомогою різних типів питань, яких в анкетному опитуванні передбачено набагато більше ніж в інших варіантах отримання зворотного зв’язку. Функціонал діяльності дозволяє створювати умовно розгалужені питання, в яких наступне питання залежить від відповіді на попереднє питання (заздалегідь продумані сценарії).</p>
<p>Створені питання можна зберігати як шаблони і використовувати в подальшому в інших курсах. Або скопіювати вже готову анкету з іншого курсу та відредагувати за потреби.</p>
<p>Анкетне опитування може бути анонімним, а результати можуть бути показані всім учасникам або лише викладачу.</p>';
$string['modulename_link'] = 'mod/questionnaire/view';
$string['modulenameplural'] = 'Анкети';
$string['movedisabled'] = 'Цей елемент не можна перемістити';
$string['myresponses'] = 'Всі Ваші відповіді';
$string['myresponsetitle'] = 'Ваша (-і) {$a} відповідь (-і)';
$string['myresults'] = 'Ваші результати';
$string['name'] = 'Ім\'я';
$string['navigate'] = 'Дозволити розгалуження питань';
$string['navigate_help'] = 'Увімкніть запитання «Так/Ні» та «Радіо-кнопки», щоб запитання дітей залежали від їхнього вибору у вашій анкеті.';
$string['navigate_link'] = 'mod/questionnaire/conditional_branching';
$string['navigatetosection'] = 'Перейдіть до розділу відгуків';
$string['next'] = 'Наступне';
$string['nextpage'] = 'Наступна сторінка';
$string['nlines'] = '{$a} рядків';
$string['noanswer'] = 'Немає відповіді';
$string['noattempts'] = 'Жодних спроб заповнити цю анкету не було';
$string['nodata'] = 'Дату не вказано';
$string['noduplicates'] = 'Запасні варіанти відсутні';
$string['noduplicateschoiceserror'] = 'Ви повинні ввести принаймні 2 можливих відповіді для параметра «Без повторюваних варіантів»!';
$string['non_respondents'] = 'Користувачі, які ще не надіслали свої відповіді на цю анкету';
$string['noneinuse'] = 'Ця анкета не містить запитань.';
$string['nopublicsurveys'] = 'Загальнодоступні анкети відсутні.';
$string['noresponsedata'] = 'Відповіді на це запитання відсутні.';
$string['noresponses'] = 'Відповіді відсутні';
$string['normal'] = 'Нормально';
$string['not_started'] = 'не розпочато';
$string['notanumber'] = '<strong>{$a}</strong> є неправильним числовим форматом.';
$string['notapplicable'] = 'Не застосовно';
$string['notapplicablecolumn'] = 'Не застосовна графа';
$string['notavail'] = 'Ця анкета більше не доступна. Попросіть свого вчителя видалити його.';
$string['noteligible'] = 'Ви не підходите для заповнення цієї анкети.';
$string['notemplatesurveys'] = 'Зразки анкет відсутні.';
$string['notenoughscaleitems'] = 'Ви повинні ввести мінімум 2 елементи шкали!';
$string['notificationfull'] = 'Повне подання';
$string['notifications'] = 'Надсилати сповіщення про подання';
$string['notifications_help'] = 'Повідомляйте ролі за допомогою функції "mod/questionnaire:submissionnotification" під час подання.';
$string['notifications_link'] = 'mod/questionnaire/mod#Submission_Notifications';
$string['notificationsimple'] = 'Лише сповіщення';
$string['notopen'] = 'Ця анкета буде недоступною до {$a}.';
$string['notrequired'] = 'Відповідь не потрібна';
$string['notset'] = 'не встановлено';
$string['nousersselected'] = 'Користувачів не вибрано';
$string['num'] = '#';
$string['numattemptsmade'] = 'Зроблено {$a} спроб у цій анкеті';
$string['numberfloat'] = 'Число, яке ви ввели <strong>{$a->number}</strong>, було переформатовано/округлено з <strong>{$a->precision</strong> десятковими знаками.';
$string['numberofdecimaldigits'] = 'Число десяткових знаків після коми';
$string['numberofdecimaldigits_help'] = 'Використовуйте **Nb десяткових цифр**, щоб указати формат середнього значення, що підраховується та відображається на сторінці звіту з анкетою.';
$string['numberofdecimaldigits_link'] = 'mod/questionnaire/questions#Numeric';
$string['numberscaleitems'] = 'Число елементів шкали';
$string['numberscaleitems_help'] = 'Число елементів шкали - це число елементів яке використовується у Вашій шкалі розцінок. Ви можете використати від 3 до 5 значень. Значення за замовчуванням: **5**.';
$string['numeric'] = 'Числовий';
$string['numeric_help'] = 'Використовуйте цей тип запитань, якщо Ви хочете, щоб відповідь була записана у правильному числовому форматі.';
$string['of'] = 'з';
$string['openafterclose'] = 'Ви вказали дату відкриття після дати закриття';
$string['opendate'] = 'Дозволити відповіді від';
$string['option'] = 'варіант відповіді {$a}';
$string['optional'] = 'Необов’язково – має бути виконана принаймні одна з цих залежностей.';
$string['optionalname'] = 'Назва запитання';
$string['optionalname_help'] = 'Назва запитання використовується лише під час експорту відповідей у формат CSV/Excel. Якщо ви ніколи не експортуєте в CSV, то вам не потрібно турбуватися про назви запитань. Якщо ви плануєте регулярно експортувати дані анкети в CSV, у вас є два варіанти назви запитання.';
$string['optionalname_link'] = 'mod/questionnaire/questions#Question_Name';
$string['or'] = '-АБО-';
$string['order_ascending'] = 'Висхідний порядок';
$string['order_default'] = 'Переглянути порядок за замовчуванням';
$string['order_descending'] = 'Низхідний порядок';
$string['orderresponses'] = 'Розташувати відповіді';
$string['orderresponses_help'] = 'Під час відображення Усі відповіді ви можете впорядкувати варіанти за кількістю відповідей (стовпець «Середнє») для наступних 4 типів запитань.

* перемикач одиничних варіантів
* розкривний список одиничних варіантів
* кілька варіантів (прапорці)
* оцінюйте запитання (включаючи шкали Лайкерта).

Коли ви перейдете на сторінку Усі відповіді, за замовчуванням усі відповіді впорядковуються в порядку, у якому розробник анкети ввів варіанти запитання. Ви можете впорядкувати їх у порядку зростання або спадання.';
$string['orderresponses_link'] = 'mod/questionnaire/report#Order_Responses';
$string['osgood'] = 'Осгуд';
$string['other'] = 'Інші:';
$string['otherempty'] = 'Якщо Ви поставите тут відмітку, Вам потрібно буде ввести деякий текст у поле!';
$string['overviewnumresplog'] = 'Відповіді';
$string['overviewnumresplog1'] = 'Відповідь';
$string['overviewnumrespvw'] = 'Відповіді';
$string['overviewnumrespvw1'] = 'Відповідь';
$string['owner'] = 'Власник';
$string['page'] = 'Сторінка';
$string['pageof'] = 'Сторінка {$a->page} - {$a->totpages}';
$string['parent'] = 'Основний';
$string['participant'] = 'Учасник';
$string['pleasecomplete'] = 'Будь ласка, заповніть цей вибір.';
$string['pluginadministration'] = 'Адміністрація анкети';
$string['pluginname'] = 'Анкета';
$string['position'] = 'позиція';
$string['possibleanswers'] = 'Можливі варіанти відповідей';
$string['posteddata'] = 'досягнута сторінка із встановленою датою:';
$string['preview_label'] = 'Попередній вигляд';
$string['preview_questionnaire'] = 'Попередній перегляд анкети';
$string['previewing'] = 'Попередній переглянути анкету';
$string['previous'] = 'Попередній';
$string['previouspage'] = 'Попередня сторінка';
$string['print'] = 'Друкувати цю відповідь';
$string['printblank'] = 'Друкувати бланк';
$string['printblanktooltip'] = 'Відкриває довідкове вікно друку із бланком анкети';
$string['printtooltip'] = 'Відкриває довідкове вікно друку із поточними відповідями';
$string['privacy:metadata:questionnaire_resp_multiple'] = 'Відповідь на запитання з кількома варіантами.';
$string['privacy:metadata:questionnaire_resp_multiple:choice_id'] = 'Ідентифікатор запису вибору для цієї відповіді.';
$string['privacy:metadata:questionnaire_resp_multiple:question_id'] = 'Ідентифікатор запису запитання для цієї відповіді.';
$string['privacy:metadata:questionnaire_resp_multiple:response_id'] = 'Ідентифікатор запису відповіді для цієї відповіді.';
$string['privacy:metadata:questionnaire_resp_single'] = 'Відповідь на запитання з одним вибором.';
$string['privacy:metadata:questionnaire_resp_single:choice_id'] = 'Ідентифікатор запису вибору для цієї відповіді.';
$string['privacy:metadata:questionnaire_resp_single:question_id'] = 'Ідентифікатор запису запитання для цієї відповіді.';
$string['privacy:metadata:questionnaire_resp_single:response_id'] = 'Ідентифікатор запису відповіді для цієї відповіді.';
$string['privacy:metadata:questionnaire_response'] = 'Відповідь триває або надіслано';
$string['privacy:metadata:questionnaire_response:complete'] = 'Статус завершення відповіді.';
$string['privacy:metadata:questionnaire_response:grade'] = 'Оцінка за цю відповідь.';
$string['privacy:metadata:questionnaire_response:questionnaireid'] = 'Ідентифікатор запису анкети для цієї відповіді.';
$string['privacy:metadata:questionnaire_response:submitted'] = 'Позначка часу для останнього збереження для цієї відповіді.';
$string['privacy:metadata:questionnaire_response:userid'] = 'Ідентифікатор користувача для цієї відповіді.';
$string['privacy:metadata:questionnaire_response_bool'] = 'Відповідь на логічне запитання (так/ні).';
$string['privacy:metadata:questionnaire_response_bool:choice_id'] = 'Конкретна булева відповідь.';
$string['privacy:metadata:questionnaire_response_bool:question_id'] = 'Ідентифікатор запису запитання для цієї відповіді.';
$string['privacy:metadata:questionnaire_response_bool:response_id'] = 'Ідентифікатор запису відповіді для цієї відповіді.';
$string['privacy:metadata:questionnaire_response_date'] = 'Відповідь на питання про дату.';
$string['privacy:metadata:questionnaire_response_date:question_id'] = 'Ідентифікатор запису запитання для цієї відповіді.';
$string['privacy:metadata:questionnaire_response_date:response'] = 'Відповідь про конкретну дату.';
$string['privacy:metadata:questionnaire_response_date:response_id'] = 'Ідентифікатор запису відповіді для цієї відповіді.';
$string['privacy:metadata:questionnaire_response_other'] = 'Текстова відповідь на вибір "інший".';
$string['privacy:metadata:questionnaire_response_other:choice_id'] = 'Ідентифікатор запису вибору для цієї відповіді.';
$string['privacy:metadata:questionnaire_response_other:question_id'] = 'Ідентифікатор запису запитання для цієї відповіді.';
$string['privacy:metadata:questionnaire_response_other:response'] = 'Конкретна текстова відповідь.';
$string['privacy:metadata:questionnaire_response_other:response_id'] = 'Ідентифікатор запису відповіді для цієї відповіді.';
$string['privacy:metadata:questionnaire_response_rank'] = 'Відповідь на запитання про ранг.';
$string['privacy:metadata:questionnaire_response_rank:choice_id'] = 'Ідентифікатор запису вибору для цієї відповіді.';
$string['privacy:metadata:questionnaire_response_rank:question_id'] = 'Ідентифікатор запису запитання для цієї відповіді.';
$string['privacy:metadata:questionnaire_response_rank:rankvalue'] = 'Відповідь конкретного рангу.';
$string['privacy:metadata:questionnaire_response_rank:response_id'] = 'Ідентифікатор запису відповіді для цієї відповіді.';
$string['privacy:metadata:questionnaire_response_text'] = 'Текстова відповідь на запитання.';
$string['privacy:metadata:questionnaire_response_text:question_id'] = 'Ідентифікатор запису запитання для цієї відповіді.';
$string['privacy:metadata:questionnaire_response_text:response'] = 'Конкретна текстова відповідь.';
$string['privacy:metadata:questionnaire_response_text:response_id'] = 'Ідентифікатор запису відповіді для цієї відповіді.';
$string['private'] = 'Приватний';
$string['progressbar'] = 'Показати індикатор виконання';
$string['progressbar_info'] = 'Анкета {$a} заповнена.';
$string['progresshelp'] = 'Індикатор виконання';
$string['progresshelp_help'] = 'Перейдіть до наступної сторінки, щоб заповнити панель перебігу';
$string['public'] = 'Загальнодоступний';
$string['publiccopy'] = 'Копія:';
$string['publicoriginal'] = 'Оригінал:';
$string['qtype'] = 'Тип';
$string['qtype_help'] = 'Встановити можливість користувачів відповідати: один раз, кожен день, кожен тиждень, кожен місяць або необмежена кількість разів (багато).';
$string['qtypedaily'] = 'відповідати щоденно';
$string['qtypemonthly'] = 'відповідати щомісячно';
$string['qtypeonce'] = 'відповісти один раз';
$string['qtypeunlimited'] = 'відповісти багато разів';
$string['qtypeweekly'] = 'відповідати кожного тижня';
$string['questionnaire:addinstance'] = 'Додайте нову анкету';
$string['questionnaire:copysurveys'] = 'Копіювати шаблонні та приватні анкети';
$string['questionnaire:createpublic'] = 'Створити загальнодоступні анкети';
$string['questionnaire:createtemplates'] = 'Створити шаблонні анкети';
$string['questionnaire:deleteresponses'] = 'видалити усі відповіді';
$string['questionnaire:downloadresponses'] = 'Скачати відповіді у форматі CVS';
$string['questionnaire:editquestions'] = 'Створити та редагувати запитання для анкети';
$string['questionnaire:manage'] = 'Створити та редагувати анкети';
$string['questionnaire:message'] = 'Надіслати повідомлення нереспондентам';
$string['questionnaire:preview'] = 'Попередній перегляд анкет';
$string['questionnaire:printblank'] = 'Роздрукувати бланк анкети';
$string['questionnaire:readallresponseanytime'] = 'Читати усі відповіді коли завгодно';
$string['questionnaire:readallresponses'] = 'Читати підсумки відповідей, в залежності від часу відкриття';
$string['questionnaire:readownresponses'] = 'Читати власні відповіді';
$string['questionnaire:submissionnotification'] = 'Отримувати сповіщення для кожного подання';
$string['questionnaire:submit'] = 'Заповнити анкету та подати її на розгляд';
$string['questionnaire:view'] = 'Переглянути анкету';
$string['questionnaire:viewsingleresponse'] = 'Переглянути заповнені особисті відповіді';
$string['questionnaireadministration'] = 'Адміністрація Анкети';
$string['questionnairecloses'] = 'Анкетування завершується';
$string['questionnaireopens'] = 'Анкетування розпочинається';
$string['questionnairereport'] = 'Звіт анкети';
$string['questionnum'] = 'Запитання #';
$string['questions'] = 'Запитання';
$string['questionsinsection'] = 'Питання в цьому розділі:';
$string['questiontypes'] = 'Типи запитань';
$string['questiontypes_help'] = 'Дивитись Документацію Moodle нижче';
$string['questiontypes_link'] = 'mod/questionnaire/questions#Question_Types';
$string['radiobuttons'] = 'Кнопка вибору';
$string['radiobuttons_help'] = 'Цей тип запитання передбачає вибір однієї відповіді із кількох запропонованих.';
$string['radiobuttons_link'] = 'mod/questionnaire/questions#Radio_Buttons';
$string['rank'] = 'Розташувати у певному порядку';
$string['ratescale'] = 'Оцінка (шкала 1..5)';
$string['ratescale_help'] = 'Дивитись Документацію Moodle нижче';
$string['ratescale_link'] = 'mod/questionnaire/questions#Rate_.28scale_1..5.29';
$string['realm'] = 'Тип опитування';
$string['realm_help'] = '*  ** Є три види анкет:**
* Приватні - є доступними лише в межах лише одного конкретного курсу.
* Шаблонні - можуть копіюватися та редагуватися.
* Загальнодоступні - є доступними для усіх  курсів.';
$string['realm_link'] = 'mod/questionnaire/qsettings#Questionnaire_Type';
$string['redirecturl'] = 'URL-адреса на яку користувач переадресовується після заповнення цієї анкети.';
$string['remove'] = 'Видалити';
$string['removeallquestionnaireattempts'] = 'Видалити всі відповіді на анкету';
$string['removenotinuse'] = 'Раніше ця анкета залежала від загальнодоступної анкети, яку було видалено. Його більше не можна використовувати, і його слід видалити.';
$string['required'] = 'Відповідь обов\'язкова';
$string['required_help'] = 'Якщо ви виберете ***Так***, буде потрібно відповідь на це запитання, тобто. респондент не зможе подати анкету поки на це питання не буде отримано відповіді.';
$string['required_link'] = 'mod/questionnaire/questions#Response_Required';
$string['requiredparameter'] = 'Обов\'язкові параметри не було встановлено.';
$string['reset'] = 'Повернути в початкове положення';
$string['respeligiblerepl'] = '(замінено заміною ролей)';
$string['respondent'] = 'Респондент';
$string['respondenteligibleall'] = 'усі';
$string['respondenteligiblestudents'] = 'лише студенти';
$string['respondenteligibleteachers'] = 'лише викладачі';
$string['respondents'] = 'Респонденти';
$string['respondenttype'] = 'Тип респондента';
$string['respondenttype_help'] = 'Ви можете показувати повні імена Ваших користувачів, встановивши налаштування "повне ім\'я".
Ви можете приховати особисті дані Ваших користувачів, використавши налаштування "анонімно".';
$string['respondenttype_link'] = 'mod/questionnaire/mod#Respondent_Type';
$string['respondenttypeanonymous'] = 'конфіденційний';
$string['respondenttypefullname'] = 'повне ім\'я';
$string['response'] = 'Відповідь';
$string['responsefieldlines'] = 'Розмір поля введення';
$string['responseformat'] = 'Формат відповіді';
$string['responseoptions'] = 'Варіанти відповіді';
$string['responses'] = 'Відповіді';
$string['responseview'] = 'Студент може бачити УСІ відповіді';
$string['responseview_help'] = 'Ви маєте можливість вказати хто може бачити відповіді усіх респондентів поданих на розгляд анкет (таблиці із загальними статистичними даними).';
$string['responseview_link'] = 'mod/questionnaire/mod#Response_viewing';
$string['responseviewstudentsalways'] = 'Завжди';
$string['responseviewstudentsnever'] = 'Ніколи';
$string['responseviewstudentswhenanswered'] = 'Після заповнення анкети';
$string['responseviewstudentswhenclosed'] = 'Після того як анкета закрита';
$string['restrictedtoteacher'] = 'Ці функції є обмеженими для редагування лише викладачами!';
$string['resume'] = 'Зберегти/Обновити відповіді';
$string['resume_help'] = 'Налаштування цієї опції дозволяє користувачам зберігати свої відповіді на анкету перед їх поданням. Користувачі можуть залишити анкету незаповненою та відновити її з точки збереження пізніше.';
$string['resume_link'] = 'mod/questionnaire/mod#Save/Resume_answers';
$string['resumesurvey'] = 'Обновити анкету';
$string['return'] = 'Повернутися';
$string['save'] = 'Зберегти';
$string['saveasnew'] = 'Зберегти як нове запитання';
$string['savedbutnotsubmitted'] = 'Цю анкету збережено, але ще не надіслано.';
$string['savedprogress'] = 'Ваш прогрес збережено. Ви можете повернутися в будь-який час, щоб заповнити цю анкету.';
$string['saveeditedquestion'] = 'Зберегти запитання {$a}';
$string['savesettings'] = 'Зберегти налаштування';
$string['search:activity'] = 'Анкета - інформація про діяльність';
$string['search:question'] = 'Анкета - питання';
$string['section'] = 'Опис';
$string['sectionbreak'] = '----- Розрив сторінки -----';
$string['sectionbreak_help'] = '----- Розрив сторінки -----';
$string['sectionsnotset'] = 'Ви повинні вибрати принаймні ОДНЕ запитання для кожного розділу!<br />Розділ(и) не вибрано: {$a}';
$string['sectiontext'] = 'Текстові дані';
$string['sectiontext_help'] = 'Це не запитання а (короткий ) текст, який буде виведено на екран для представлення серії запитань.';
$string['selecttheme'] = 'Оберіть стиль (вкладені таблиці стилів) для цієї анкети.';
$string['send'] = 'Надіслати';
$string['send_message'] = 'Надіслати повідомлення вибраним користувачам';
$string['send_message_to'] = 'Надіслати повідомлення на адресу:';
$string['sendemail'] = 'Надіслати електронне повідомлення';
$string['sendemail_help'] = 'Надсилає копію кожного подання за вказаною адресою чи адресами. Ви можете вказати більше однієї адреси, розділяючи їх комами. Залиште пустим, якщо листи не потрібні.';
$string['set'] = 'встановити';
$string['settings'] = 'Налаштування';
$string['settingssaved'] = 'Налаштування збережено';
$string['show_nonrespondents'] = 'Нереспонденти';
$string['started'] = 'почався';
$string['strfdate'] = '%d.%m.%Y';
$string['strfdateformatcsv'] = 'd/m/Y H:i:s';
$string['strictdateformatting'] = 'Введіть дату за допомогою засобу вибору дати нижче або у форматі «РРРР-ММ-ДД».';
$string['subject'] = 'Тема';
$string['submissionnotificationhtmlanon'] = 'Існує нова <a href="{$a->submissionurl}">подача</a> анкети "{$a->name}".';
$string['submissionnotificationhtmluser'] = '<a href="{$a->profileurl}">{$a->username}</a> має нове <a href="{$a->submissionurl}">подання</a> до " {$a->name}" анкети в курсі "{$a->coursename}".';
$string['submissionnotificationsubject'] = 'Нова подача анкети';
$string['submissionnotificationtextanon'] = 'З’явилася нова заявка ({$a->submissionurl}) до анкети "{$a->name}".';
$string['submissionnotificationtextuser'] = '{$a->username} ({$a->profileurl}) має новий запит ({$a->submissionurl}) до анкети "{$a->name}" в курсі "{$a-> назва курсу}".';
$string['submitoptions'] = 'Опції подачі на розгляд';
$string['submitpreview'] = 'Надіслати попередній перегляд';
$string['submitpreviewcorrect'] = 'Ця заявка буде прийнята як правильно заповнена.';
$string['submitsurvey'] = 'Подати анкету на розгляд';
$string['submitted'] = 'Підписатися на:';
$string['subtitle'] = 'Підзаголовок';
$string['subtitle_help'] = 'Підзаголовок цієї анкети. З\'являється під заголовком лише на першій сторінці.';
$string['summary'] = 'Резюме';
$string['summaryreportattached'] = 'Підсумковий звіт анкети додається';
$string['surveynotexists'] = 'Анкета не існує.';
$string['surveyowner'] = 'Ви повинні бути власником анкети для того, щоб здійснити цю операцію.';
$string['surveyresponse'] = 'Відповідь з анкети';
$string['template'] = 'Шаблон';
$string['templatenotviewable'] = 'Шаблонні анкети є прихованими.';
$string['text'] = 'Текст запитання';
$string['textareacolumns'] = 'Стовпці для вводу тексту';
$string['textareacolumns_help'] = 'Це запитання виведе на екран текстове вікно для читання з **x** *Область текстових стовпців* (або область *ширина*) та **y** *Область текстових рядків* (число *рядків* тексту).
Якщо Ви залишите параметри x та y за замовчуванням (або поставите для них значення **0**), то редактор HTML встановить стандартну висоту та ширину.';
$string['textarearows'] = 'Рядки для вводу тексту';
$string['textbox'] = 'Текстове вікно';
$string['textbox_help'] = 'Для запитань, що передбачають відповідь у текстовому полі, задайте параметри тексту, який має ввести респондент. Використайте параметри довжина Поля вводу та Максимальна довжина тексту.
Параметри за замовчуванням становлять: 20 символів - ширина Поля вводу та 25 символів - максимальна довжина тексту, що вводиться.';
$string['textdownloadoptions'] = 'Параметри завантаження CSV';
$string['thank_head'] = 'Дякуємо за заповнення цієї анкети.';
$string['theme'] = 'Тема';
$string['thismonth'] = 'цього місяця';
$string['thisresponse'] = 'Ця відповідь';
$string['thisweek'] = 'цього тижня';
$string['thousands'] = 'Не використовуйте роздільники тисяч.';
$string['title'] = 'Заголовок';
$string['title_help'] = 'Заголовок цієї анкети, який буде з\'являтися на кожній сторінці у верхній частині. За замовчуванням Заголовок встановлено як Ім\'я анкети, але Ви можете редагувати його за власним бажанням.';
$string['today'] = 'сьогодні';
$string['total'] = 'Сумарний';
$string['totalofnumbers'] = 'Загальна кількість введених чисел';
$string['totalresponses'] = 'Загальна кількість відповідей на запитання';
$string['type'] = 'Тип запитання';
$string['undefinedquestiontype'] = 'Невизначено тип запитання!';
$string['unknown'] = 'Невідомий';
$string['unknownaction'] = 'Вказано невідому операцію анкети...';
$string['url'] = 'Підтвердження URL';
$string['url_help'] = 'Адреса URL на яку користувача спрямовують після заповнення анкети.';
$string['useprivate'] = 'Копіювати наявні';
$string['usepublic'] = 'Скористатися загальнодоступним';
$string['usetemplate'] = 'Використовати шаблон';
$string['vertical'] = 'Вертикальний';
$string['view'] = 'Переглянути';
$string['viewallresponses'] = 'Переглянути усі відповіді';
$string['viewallresponses_help'] = 'Якщо для анкети встановлено **Режим групи**: *Видимі групи*, або встановлено на *Окремі групи* і поточний користувач
  має можливість *moodle/site:accessallgroups* (у поточному контексті), а групи були визначені в поточному курсі,
  тоді користувач має доступ до випадаючого списку груп. Цей спадний список дозволяє користувачеві «фільтрувати» відповіді на анкету за групами.
  Якщо параметр **Режим групи**: *Окремі групи*, то користувачі, які не мають можливості *moodle/site:accessallgroups*
  (зазвичай студенти або викладачі, які не редагують, тощо) зможуть переглядати відповіді лише групи (груп), до якої вони належать.';
$string['viewallresponses_link'] = 'Viewing_Questionnaire_responses#Group_filtering';
$string['viewbyresponse'] = 'Список відповідей';
$string['viewindividualresponse'] = 'Індивідуальні відповіді';
$string['viewindividualresponse_help'] = 'Натисніть на імена респондентів у списку нижче, щоб переглянути їхні індивідуальні відповіді.';
$string['viewresponses'] = 'Усі відповіді ({$a})';
$string['viewyourresponses'] = 'Ваші відповіді - переглянути {$a}';
$string['warning'] = 'Застереження, може виникнути помилка.';
$string['wronganswers'] = 'З вашими відповідями щось не так (див. нижче)';
$string['wrongdateformat'] = 'Введена дата: <strong>{$a}</strong> не відповідає зразку вказаному у прикладі';
$string['wrongdaterange'] = 'Помилка! Потрібно вказати рік у межах від 1902 по 2037.';
$string['wrongformat'] = 'З вашою відповіддю на запитання щось не так:&nbsp;';
$string['wrongformats'] = 'Щось не так з вашою відповіддю на запитання:&nbsp;';
$string['yesno'] = 'Так/Ні';
$string['yesno_help'] = 'Загальні запитання';
$string['yourresponse'] = 'Ваша відповідь';
$string['yourresponses'] = 'Ваші відповіді';
