<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'qtype_musictheory', language 'ru', version '4.4'.
 *
 * @package     qtype_musictheory
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abmajor'] = 'Ля&#9837;(-бемоль) мажор';
$string['abminor'] = 'Ля&#9837;(-бемоль) минор';
$string['acc_b'] = '&#9837;';
$string['acc_bb'] = '&#9837;&#9837;';
$string['acc_n'] = '&#9838;';
$string['acc_sharp'] = '&#9839;';
$string['acc_x'] = 'x';
$string['alto'] = 'Альт';
$string['altoclef'] = 'Альтовый ключ';
$string['anmajor'] = 'Ля мажор';
$string['anminor'] = 'Ля минор';
$string['answerlbl'] = 'Ответ';
$string['asharpminor'] = 'Ля&#9839;(-диез) минор';
$string['aug10'] = 'Увеличенная Децима';
$string['aug11'] = 'Увеличенная Ундецима';
$string['aug12'] = 'Увеличенная Дуодецима';
$string['aug13'] = 'Увеличенная Терцдецима';
$string['aug2'] = 'Увеличенная секунда';
$string['aug3'] = 'Увеличенная Терция';
$string['aug4'] = 'Увеличенная Кварта';
$string['aug5'] = 'Увеличенная Квинта';
$string['aug6'] = 'Увеличенная Секста';
$string['aug6thfr'] = 'Французский дополненный шестой';
$string['aug6thgr'] = 'Немецкий дополненный шестой';
$string['aug6thit'] = 'Итальянский дополненный шестой';
$string['aug7'] = 'Увеличенная Септима';
$string['aug8'] = 'Увеличенная Октава';
$string['aug9'] = 'Увеличенная Нона';
$string['augmented'] = 'Увеличенная';
$string['bass'] = 'Бас';
$string['bassclef'] = 'Басовый ключ';
$string['bbmajor'] = 'Си&#9837;(-бемоль) мажор';
$string['bbminor'] = 'Си&#9837;(-бемоль) минор';
$string['bnmajor'] = 'Си мажор';
$string['bnminor'] = 'Си минор';
$string['cbmajor'] = 'До&#9837;(-бемоль) мажор';
$string['chordquality'] = 'Качество аккорда';
$string['chordquality-random'] = 'Возможные аккордовые качества';
$string['chordquality_write_questionastext'] = 'Ввод наклонения аккорда';
$string['chordquality_write_questionastext_help'] = '<p>Введите список нот, разделенных запятыми,
  без пробелов, используя следующий синтаксис: </p><p>[Имя прописной буквой] [Случайный знак альтерации ("n" = бекар, "#" = диез,
 "b" = бемоль, "x" = дубль-диез, "bb" = дубль-бемоль)]4, ...</p>
 <p>Случайный пример: <b>answer=>Cn4,En4,G#4</b></p>';
$string['chordquality_write_questionasui'] = 'Ввод гармонической функции';
$string['chordquality_write_questionasui_help'] = '<p>Введите ноты, щелкнув по нотному стану, после выбора
 типа знаков альтерации на правой панели инструментов. Чтобы удалить ноту, нажмите на нее еще раз.</p>';
$string['chordroot'] = 'Корень аккорда';
$string['clef'] = 'Ключ';
$string['clef-random'] = 'Возможные ключи';
$string['cnmajor'] = 'До мажор';
$string['cnminor'] = 'До минор';
$string['considerregister'] = 'Включить регистр';
$string['considerregister_help'] = 'Указывает, должен ли регистр ноты быть
 включен как часть вопроса.';
$string['correctansweris'] = 'Правильный ответ:';
$string['correctansweris_morethanone'] = 'Один из возможных правильных ответов:';
$string['csharpmajor'] = 'До&#9839;(-диез) мажор';
$string['csharpminor'] = 'До&#9839;(-диез) минор';
$string['dbmajor'] = 'Ре&#9837;(-бемоль) мажор';
$string['dim10'] = 'Уменьшенная Децима';
$string['dim11'] = 'Уменьшенная Ундецима';
$string['dim12'] = 'Уменьшенная Дуодецима';
$string['dim13'] = 'Уменьшенная Терцдецима';
$string['dim2'] = 'Уменьшенная секунда';
$string['dim3'] = 'Уменьшенная Терция';
$string['dim4'] = 'Уменьшенная Кварта';
$string['dim5'] = 'Уменьшенная Квинта';
$string['dim6'] = 'Уменьшенная Секста';
$string['dim7'] = 'Уменьшенная Септима';
$string['dim8'] = 'Уменьшенная Октава';
$string['dim9'] = 'Уменьшенная Нона';
$string['diminished'] = 'Уменьшенная';
$string['dirasc'] = 'Выше данной ноты';
$string['dirdesc'] = 'Ниже данной ноты';
$string['direction'] = 'Направление';
$string['displaykeysignature'] = 'Показать подпись ключа';
$string['dnmajor'] = 'Ре мажор';
$string['dnminor'] = 'Ре минор';
$string['dsharpminor'] = 'Ре&#9839;(-диез) минор';
$string['ebmajor'] = 'Ми&#9837;(-бемоль) мажор';
$string['ebminor'] = 'Ми&#9837;(-бемоль) минор';
$string['emptykeysignature'] = 'Пустая подпись ключа';
$string['enmajor'] = 'Ми мажор';
$string['enminor'] = 'Ми минор';
$string['fnmajor'] = 'Фа мажор';
$string['fnminor'] = 'Фа минор';
$string['fsharpmajor'] = 'Фа&#9839;(-диез) мажор';
$string['fsharpminor'] = 'Фа&#9839;(-диез) минор';
$string['gbmajor'] = 'Соль&#9837;(-бемоль) мажор';
$string['givennoteelementgroup'] = 'Дана нота';
$string['gnmajor'] = 'Соль мажор';
$string['gnminor'] = 'Соль минор';
$string['grandstaff'] = 'Гранд Штаб';
$string['gsharpminor'] = 'Соль&#9839;(-диез) минор';
$string['harmonicfunction_write_questionastext'] = 'Запись ответа гармонической функции';
$string['harmonicfunction_write_questionastext_help'] = '<p>Введите список нот через запятую,
  без пробелов, используя следующий синтаксис:</p><p>[Uppercase letter name][Accidental
 ("n" = natural, "#" = sharp, "b" = flat, "x" = double-sharp, "bb" = double-flat)]4, ... </p>
 <p>Случайный пример: <b>answer=>Cn4,En4,G#4</b></p>';
$string['harmonicfunction_write_questionasui'] = 'Ввод гармонической функции';
$string['harmonicfunction_write_questionasui_help'] = '<p>Введите ноты, щелкнув по нотному стану, после выбора
 типа знаков альтерации на правой панели инструментов. Чтобы удалить ноту, нажмите на нее еще раз.</p>';
$string['harmonicfunctiontype-random'] = 'Возможные гармонические функции';
$string['hfidentifyresponsetypes'] = 'Возможные гармонические функции в ответ';
$string['hftype_aug6th'] = 'Увеличенный Секстакко́рд';
$string['hftype_diatonictriad'] = 'Диатоническое трезвучие';
$string['hftype_dom7th'] = 'Доминантсептаккорд';
$string['hftype_extendeddom'] = 'Расширенная доминанта (9, 11 или 13)';
$string['hftype_leadingtone7thfullydim'] = 'Вводный тон Септаккорд (Уменьшенный)';
$string['hftype_leadingtone7thhalfdim'] = 'Вводный тон Септаккорд (Малый)';
$string['hftype_neapolitan'] = 'Неаполитанский аккорд';
$string['hftype_nondom7th'] = 'Субдоминанта Септаккорд';
$string['hftype_secdom7th'] = 'Побочная доминанта (Септаккорд)';
$string['hftype_secdomtriad'] = 'Побочная доминанта (Трезвучие)';
$string['hftype_secltfullydim'] = 'Побочный вводный тон Септаккорд (Уменьшенный)';
$string['hftype_seclthalfdim'] = 'Побочный вводный тон Септаккорд (Малый)';
$string['hftype_seclttriad'] = 'Побочный вводный тон (Трезвучие)';
$string['hftype_secnondom7th'] = 'Побочная субдоминанта (Септаккорд)';
$string['hftype_secnondomtriad'] = 'Побочная субдоминанта (Трезвучие)';
$string['includealterations'] = 'Включить изменения';
$string['includealterations_help'] = 'Указывает, должен ли регистр ноты быть
 включен как часть вопроса.';
$string['includestaticnote'] = 'Включить данную ноту';
$string['interval_write_questionastext'] = 'Интервальный ввод ответа';
$string['interval_write_questionastext_help'] = '<p>Введите ответную ноту без пробелов, используя
 следующий синтаксис:</p><p>[Uppercase letter name] [Accidental ("n" = natural, "#" = sharp,
 "b" = flat, "x" = double-sharp, "bb" = double-flat)] [Register (a digit between 1 and 6, following
 the scientific pitch notation)]</p><p>Примеры:
 </p><ul><li><b>Gn5</b></li><li><b>A#4</b></li><li><b>Ebb3</b></li></ul>';
$string['interval_write_questionasui'] = 'Ввод интервала';
$string['interval_write_questionasui_help'] = '<p>Введите ноту, нажав на перечень, после
 выбор типа знака альтерации на правой панели инструментов. Чтобы удалить ноту, нажмите на нее еще раз.</p>';
$string['javascriptrequired'] = 'Этот текст должен быть заменен графическим пользовательским
интерфейсом, для которого в вашем браузере должен быть включен Javascript.';
$string['keyboard_input_questionasui'] = 'Ввод с клавиатуры';
$string['keyboard_input_questionasui_help'] = '<p>Вводите ноты, нажимая на клавиатуре. Чтобы удалить ноту, нажмите на нее еще раз.</p>';
$string['keymode'] = 'Ключ';
$string['keysignature_write_questionastext'] = 'Ввод ключевой подписи';
$string['keysignature_write_questionastext_help'] = '<p>Введите список знаков альтерации, разделенных запятыми.
 (от 1 до 7 из них) без пробелов, используя следующий синтаксис:</p><p>[Uppercase letter name]
 [Accidental ("#" = sharp, "b" = flat)] [Register (a digit between 2 and 5, following the scientific
 pitch notation)], ... </p><p>Пример: <b>A#4,F#4,G#4</b></p>';
$string['keysignature_write_questionasui'] = 'Ввод ключевой подписи';
$string['keysignature_write_questionasui_help'] = '<p>Введите знаки альтерации, нажав на перечень,
 после выбора типа знаков альтерации на правой панели инструментов. Чтобы удалить случайное, нажмите на
 это снова.</p>';
$string['lbl_harmonicfunction'] = 'Гармоническая функция';
$string['maj10'] = 'Большая Децима';
$string['maj13'] = 'Большая Терцдецима';
$string['maj2'] = 'Большая секунда';
$string['maj3'] = 'Большая Терция';
$string['maj6'] = 'Большая Секста';
$string['maj7'] = 'Большая Септима';
$string['maj9'] = 'Большая Нона';
$string['major'] = 'Большая';
$string['min10'] = 'Малая Децима';
$string['min13'] = 'Малая Терцдецима';
$string['min2'] = 'Малая секунда';
$string['min3'] = 'Малая Терция';
$string['min6'] = 'Малая Секста';
$string['min7'] = 'Малая Септима';
$string['min9'] = 'Малая Нона';
$string['minor'] = 'Малая';
$string['mode-random'] = 'Возможные режимы';
$string['musicqtype'] = 'Тип вопроса о музыке';
$string['musictheory_gradingstrategy'] = 'Стратегия выставления оценок';
$string['musictheory_gradingstrategy_help'] = '<p> Стратегия выставления оценок определяет,
как будет оцениваться вопрос. </p>
 <p><b> Все или ничего </b>: ответ сравнивается с правильным ответом. Если ответ
 правильный, выставляются полные оценки. Если ответ неверен, ставится ноль. </p>';
$string['musictheory_gradingstrategy_scale-write'] = 'Стратегия выставления оценок';
$string['musictheory_gradingstrategy_scale-write_help'] = '<p> Стратегия выставления оценок определяет, как вопрос будет оценен. </p>
 <p> <b> Все или ничего </b>: ответ сравнивается с правильным ответом. Если ответ правильный, выставляется максимальная оценка. Если ответ неверен, ставится ноль. </p>
 <p> <b> Частичное вознаграждение за каждую правильную ноту </b>:
 Стратегия выставления оценок, при которой оценка равномерно распределяется по гамме нот, вводимых пользователем и присуждает частичную оценку за
каждую правильную ноту. </p>';
$string['musictheory_intervalelementgroup'] = 'Интервал';
$string['musictheory_intervalelementgroup_help'] = 'Указывает тип интервала.';
$string['musictheory_intervalelementgroup_random'] = 'Возможные интервалы';
$string['nosectonic'] = '[Нет вторичного тоника]';
$string['note_write_questionastext'] = 'Ввод нот';
$string['note_write_questionastext_help'] = '<p>Введите ответ - ноту без пробелов, используя
 следующий синтаксис:</p><p>[Имя прописной буквой] [Случайный знак альтерации ("n" = бекар, "#" = диез,
 "b" = бемоль, "x" = дубль-диез, "bb" = дубль-бемоль)] [Регистр (цифра от 1 до 6, обозначает высоту тона)]</p><p>Примеры:
 </p><ul><li><b>Gn5</b></li><li><b>A#4</b></li><li><b>Ebb3</b></li></ul>';
$string['note_write_questionasui'] = 'Ввод нот';
$string['note_write_questionasui_help'] = '<p>Введите ноту, нажав на перечень, после
 выбор типа знаков альтерации в правой панели инструментов. Чтобы удалить ноту, нажмите на нее еще раз.</p>';
$string['notea'] = 'Ля';
$string['noteb'] = 'Си';
$string['notec'] = 'До';
$string['noted'] = 'Ре';
$string['notee'] = 'Ми';
$string['notef'] = 'Фа';
$string['noteg'] = 'Соль';
$string['notelbl'] = 'Нота';
$string['per11'] = 'Чистая Ундецима';
$string['per12'] = 'Чистая Дуодецима';
$string['per4'] = 'Чистая Кварта';
$string['per5'] = 'Чистая Квинта';
$string['per8'] = 'Чистая Октава';
$string['perfect'] = 'Чистая';
$string['pluginname'] = 'Теория музыки';
$string['pluginname_help'] = 'Этот тип вопросов позволяет создавать несколько типов упражнений
по теории музыки с использованием графического пользовательского интерфейса.';
$string['pluginname_link'] = 'вопрос / тип / музыкальная теория';
$string['pluginnameadding'] = 'Добавление вопроса по теории музыки';
$string['pluginnameediting'] = 'Редактирование вопроса по теории музыки';
$string['pluginnamesummary'] = 'Позволяет создавать несколько типов упражнений по теории музыки.';
$string['possiblescalesinresponse'] = 'Возможные типы шкал в ответе';
$string['privacy:metadata'] = 'Плагин типа вопросов "Теория музыки" не хранит личных личных данных.';
$string['qtype_chordquality-identify'] = 'Определение качества аккорда';
$string['qtype_chordquality-identify-random'] = 'Определение качества аккорда (случайное)';
$string['qtype_chordquality-write'] = 'Написание аккордового качества';
$string['qtype_chordquality-write-random'] = 'Качество аккордов (случайное)';
$string['qtype_harmonicfunction-identify'] = 'Идентификация гармонической функции';
$string['qtype_harmonicfunction-identify-random'] = 'Идентификация гармонической функции (случайная)';
$string['qtype_harmonicfunction-write'] = 'Запись гармонической функции';
$string['qtype_harmonicfunction-write-random'] = 'Запись гармонической функции (случайная)';
$string['qtype_interval-identify'] = 'Интервальная идентификация';
$string['qtype_interval-identify-random'] = 'Интервальная идентификация (случайная)';
$string['qtype_interval-write'] = 'Интервальная запись';
$string['qtype_interval-write-random'] = 'Интервальная запись (случайная)';
$string['qtype_keyboard-input'] = 'Ввод с клавиатуры';
$string['qtype_keysignature-identify'] = 'Идентификация ключевой подписи';
$string['qtype_keysignature-identify-random'] = 'Идентификация ключевой подписи (случайная)';
$string['qtype_keysignature-write'] = 'Написание ключевой подписи';
$string['qtype_keysignature-write-random'] = 'Написание ключевой подписи (случайное)';
$string['qtype_musictheory_strategy_all_or_nothing'] = 'Все или ничего';
$string['qtype_musictheory_strategy_chordqualitywrite_allornothing'] = 'Все или ничего';
$string['qtype_musictheory_strategy_harmonicfunctionid_allornothing'] = 'Все или ничего';
$string['qtype_musictheory_strategy_harmonicfunctionwrite_allornothing'] = 'Все или ничего';
$string['qtype_musictheory_strategy_keyboard_allornothing'] = 'Все или ничего';
$string['qtype_musictheory_strategy_note_allornothing'] = 'Все или ничего';
$string['qtype_musictheory_strategy_scale_creditbynote'] = 'Частичный зачет за каждую правильную ноту';
$string['qtype_note-identify'] = 'Идентификация ноты';
$string['qtype_note-identify-random'] = 'Идентификация ноты (случайная)';
$string['qtype_note-write'] = 'Написание нот';
$string['qtype_note-write-random'] = 'Написание нот (случайное)';
$string['qtype_scale-identify'] = 'Идентификация шкалы';
$string['qtype_scale-identify-random'] = 'Идентификация шкалы (случайная)';
$string['qtype_scale-write'] = 'Масштабное письмо';
$string['qtype_scale-write-random'] = 'Написание шкалы (случайное)';
$string['quality-random'] = 'Возможные качества';
$string['qualityaug'] = 'Увеличенная';
$string['qualitydim'] = 'Уменьшенная';
$string['qualitymaj'] = 'Большая';
$string['qualitymin'] = 'Малая';
$string['qualityper'] = 'Чистая';
$string['questionoptions'] = 'Варианты вопросов';
$string['questiontext'] = 'Текст вопроса';
$string['questiontext_chordquality_identify'] = 'Определите основной тон и наклонение следующего аккорда';
$string['questiontext_chordquality_write'] = 'Введите следующий аккорд';
$string['questiontext_harmonicfunction_identify'] = 'Определите следующую гармоническую функцию';
$string['questiontext_harmonicfunction_write'] = 'Введите следующую гармоническую функцию';
$string['questiontext_help'] = 'Это поле не является обязательным. Если оставить пустым, то
текст вопроса, соответствующий данному типу музыки, будет автоматически отображаться в активном элементе. Если вы введете текст в это поле, он заменит автоматически
сгенерированный текст вопроса.';
$string['questiontext_interval_identify'] = 'Определите следующий интервал';
$string['questiontext_interval_write_above'] = 'Введите следующий интервал <b> над </b> данной нотой';
$string['questiontext_interval_write_below'] = 'Введите следующий интервал <b> под </b> данной нотой';
$string['questiontext_keyboard_input'] = 'Введите следующую ноту на клавиатуре';
$string['questiontext_keysignature_identify_major'] = 'Определите мажорный ключ, представленный
следующей подписью ключа';
$string['questiontext_keysignature_identify_minor'] = 'Определите минорный ключ, представленный
следующей подписью ключа';
$string['questiontext_keysignature_write'] = 'Введите следующую подпись клавиши';
$string['questiontext_note_identify'] = 'Определите следующую ноту';
$string['questiontext_note_write'] = 'Введите следующую ноту';
$string['questiontext_scale_identify'] = 'Определите следующий масштаб';
$string['questiontext_scale_write'] = 'Напишите следующий масштаб по возрастанию';
$string['questiontext_scale_write_melodic'] = 'Напишите следующую шкалу как по возрастанию,
так и по убыванию';
$string['rootposition'] = '[корень]';
$string['scale_write_questionastext'] = 'Ввод ответа по шкале';
$string['scale_write_questionastext_help'] = '<p>Введите список нот, разделенных запятыми, включая
 заданную тонику, без пробелов, используя следующий синтаксис:</p><p>[Имя прописной буквой] [Случайный знак альтерации ("n" = бекар, "#" = диез,
 "b" = бемоль, "x" = дубль-диез, "bb" = дубль-бемоль)] [Регистр (цифра от 2 до 6, обозначает высоту тона)], ... </p>
 <p>Случайный пример: <b>Тоника = An4 ответ=>An4,Bb4,C#5,D#5,E#5,F#5,G#5,An5</b></p>';
$string['scale_write_questionasui'] = 'Ввод ответа по шкале';
$string['scale_write_questionasui_help'] = '<p>Введите ноты, щелкнув по нотному стану, после выбора
 типа знака альтерации на правой панели инструментов. Чтобы удалить ноту, нажмите на нее еще раз. </p>
 <p> Обратите внимание, что случайные совпадения переносятся на последующие примечания.</p>';
$string['scaletype'] = 'Тип шкалы';
$string['scaletype-random'] = 'Возможные типы масштабов';
$string['scaletype_harmonic'] = 'Гармонический минор';
$string['scaletype_major'] = 'Мажор';
$string['scaletype_melodic'] = 'Мелодический минор';
$string['scaletype_natural'] = 'Минор';
$string['selectakey'] = 'Выберите ключ';
$string['selectanoption'] = 'Выбирать';
$string['selectaquality'] = 'Выберите наклонение';
$string['selectasize'] = 'Выберите размер';
$string['size-random'] = 'Возможные размеры';
$string['size10'] = 'Децима';
$string['size11'] = 'Ундецима';
$string['size12'] = 'Дуодецима';
$string['size13'] = 'Терцдецима';
$string['size2'] = 'Секунда';
$string['size3'] = 'Терция';
$string['size4'] = 'Кварта';
$string['size5'] = 'Квинта';
$string['size6'] = 'Секста';
$string['size7'] = 'Септима';
$string['size8'] = 'Октава';
$string['size9'] = 'Нона';
$string['tenor'] = 'Тенор';
$string['tenorclef'] = 'Теноровый ключ';
$string['tonic'] = 'Тоник';
$string['treble'] = 'Сопрано';
$string['trebleclef'] = 'Сопрано ключ';
$string['updatemusicqtype'] = 'Параметры обновления';
$string['validation_harmonicfunctionnotsupported'] = 'Эта гармоническая функция не поддерживается или недействительна.';
$string['validation_harmonicfunctiontypenotselected'] = 'Должен быть выбран тип функции для указанной гармонической функции.';
$string['validation_interval_novalidcombo'] = 'Выбранные возможные наклонения и размеры не дают по крайней мере одного допустимого интервала.';
$string['validation_intervaloutsidestaff'] = 'Регистр данной ноты создает интервал, который не умещается в нотном стане данного ключа.';
$string['validation_invalidchordquality'] = 'Этот тип аккорда не может быть построен на указанном корне.';
$string['validation_invalidinterval_above'] = 'Этот интервал нельзя писать над данной нотой.';
$string['validation_invalidinterval_below'] = 'Этот интервал нельзя писать под данной нотой.';
$string['validation_noteoutsidekeyboard'] = 'Эта нота выходит за пределы диапазона фортепианной клавиатуры.';
$string['validation_noteoutsidestaff'] = 'Регистр этой ноты не помещается в нотный
стан в указанном ключе.';
$string['validation_possiblescaletypenotselected'] = 'Должен быть выбран тип шкалы для указанного типа шкалы.';
$string['validation_possiblescaletypesnotselected_random'] = 'Возможные типы шкал в ответе должны включать все возможные типы шкал в вопросе.';
$string['validation_qualitymismatch'] = 'Эта комбинация размера интервала и наклонения недопустима.';
$string['validation_samestaticandgivennote'] = 'Данная нота и ответ не могут соответствовать одной и той же клавише на клавиатуре.';
$string['validation_scale_invalidtonic'] = 'Недопустимый тоник для указанного типа звукоряда.';
$string['validation_scaleoutsidestaff'] = 'Регистр данного тоника производит масштаб, который не помещается в нотоносце в данном ключе.';
$string['validationerror_chordquality_identify'] = 'Неполный ответ. Необходимо выбрать букву, случайность и качество аккорда.';
$string['validationerror_empty'] = 'Ответа не было.';
$string['validationerror_harmonicfunction_identify'] = 'Неполный ответ. Должны быть выбраны все раскрывающиеся меню.';
$string['validationerror_incompletechordquality'] = 'Неполный ответ. Количество нот в этом аккорде';
$string['validationerror_incompleteharmonicfunction'] = 'Неполный ответ. Количество нот в этой гармонической функции';
$string['validationerror_interval_identify'] = 'Неполный ответ. Наклонение и размер
должны быть выбраны';
$string['validationerror_invalidsyntax'] = 'Неверный синтаксис ответа.';
$string['validationerror_note_identify'] = 'Неполный ответ. И название буквы,
знаки альтерации и регистр должен быть выбраны.';
$string['validationerror_note_identify_ltr_acc'] = 'Неполный ответ. И название буквы и знаки
альтерации должен быть выбраны.';
$string['validationerror_note_identify_ltr_reg'] = 'Неполный ответ. И название буквы
и регистр должен быть выбраны.';
$string['validationerror_notewrite_twonotesingrandstaff'] = 'Были внесены две ноты. Пожалуйста, введите только одну ноту.';
$string['validationerror_scale_identify'] = 'Неполный ответ. Должны быть выбраны все раскрывающиеся меню.';
$string['validationerror_scale_incomplete'] = 'Неполный ответ. Требуется 8 нот, включая данный тоник.';
$string['validationerror_scale_incomplete_melodic'] = 'Неполный ответ. Требуется 15 нот, включая данный тоник.';
$string['validationerror_whitespace'] = 'Неверный синтаксис ответа: удалите все пробелы из ответа.';
