<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'qtype_coderunner', language 'af', version '4.4'.
 *
 * @package     qtype_coderunner
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['HIDE'] = 'Versteek';
$string['HIDE_IF_FAIL'] = 'Versteek indien misluk';
$string['HIDE_IF_SUCCEED'] = 'Versteek indien suksesvol';
$string['SHOW'] = 'Vertoon';
$string['aborted'] = 'Toetsing is weens \'n fout gestaak.';
$string['ace-language'] = 'Ace-taal';
$string['ace_ui_notready'] = 'Ace-wysiger is nie gereed nie. Herlaai moontlik die bladsy?';
$string['addingcoderunner'] = '\'n Nuwe CodeRunner-vraag word bygevoeg';
$string['advanced_customisation'] = 'Gevorderde aanpassing';
$string['ajax_error'] = '*** AJAX-FOUT. MOET DIT NIE STOOR NIE! ***';
$string['allok'] = 'Alle toetse is geslaag!';
$string['allornone'] = 'Toetskode moet verskaf word vir alle of geen toetsgevalle.';
$string['allornothing'] = 'Alles-of-niks-merk';
$string['allornothing_help'] = 'As "Alles-of-niks" gemerk is, moet daar aan alle toetsgevalle voldoen word vir die indiening om enige punte te kan verdien. Andersins word die punt verkry deur die punte van al die geslaagde toetsgevalle op te som en dit as \'n breuk van die maksimum moontlike punt uit te druk.

Die per-toetsgeval-punte kan slegs gespesifiseer word as die "Alles-of-niks"-boksie nie gemerk is nie.

As \'n templaatmerker gebruik word wat gedeeltelike punte aan toetsgevalle toeken, behoort "Alles-of-niks" gewoonlik nie gemerk te wees nie.';
$string['allowattachments'] = 'Laat aanhegsels toe';
$string['allowattachments_help'] = 'Of studente toegelaat moet word om aanhegsels by hul indienings te sit en, indien wel, hoeveel. Aanhegsels word in die looptyd-werkgids gekopieer en \'n komma-geskeide lys van die name van die aanhegsels word verskaf aan die templaat in die Twig-veranderlike {{ ATTACHMENTS }}. Waarskuwing: die toelaat van aanhegsels kan implikasies vir prestasie of skyfspasie inhou vir die Moodle- en Jube-bedieners met groot klasse en/of groot aanhegsels. Die Moodle-bediener en Jube-bedieners voor Februarie 2019 berg alle aanhegsels vir \'n onbepaalde tydperk.';
$string['allowedfilenames'] = 'Toegelate dokumentname';
$string['allowedfilenames_help'] = 'Alle opgelaaide dokumentname moet by die gegewe PHP (Perl) reguliere uitdrukking pas, indien nie leeg nie. Byvoorbeeld, gebruik \'.+\\\\.cpp\' om enige C++ file dokument toe te laat, of \'(?!Prog)\\\\.java\' om enige Java-dokument behalwe \'Prog.java\' toe te laat . Bykomend moet dokumentname slegs alfanumeriese karakters plus die onderstreepkarakter, koppelteken en punt bevat, dit moet nie met dubbel-onderstreepkarakter (\'\\_\\_\') begin nie en moet nie in stryd wees met enige van die ondersteundokumentname nie. Die Beskrywing is \'n teksboodskap wat aan die student vertoon word om te verduidelik watter dokument(e) verwag word. Laat die spasie leeg om die reguliere uitdrukking self te vertoon. Los beide leeg om die reguliere uitdrukking-kontrole te omseil.';
$string['allowedfilenamesregex'] = 'Toegelate dokumentname (reguliere uitdrukking)';
$string['allowmultiplestdins'] = 'Laat veelvoudige stdins toe';
$string['answer'] = 'Antwoord';
$string['answer_help'] = '\'n Voorbeeld-antwoord kan hier ingevoer word en gebruik word vir die kontrolering van die vraagskrywer, en opsioneel aan studente tydens hersiening vertoon word. Dit word ook deur die grootmaattoetser-teks gebruik. Die korrektheid van \'n nie-leë antwoord word nagegaan wanneer daar geberg word, tensy \'Valideer tydens berging\' nie gemerk is nie';
$string['answerbox_group'] = 'Antwoordboks';
$string['answerbox_group_help'] = 'Stel die aantal rye om aan die antwoordboksie toe te ken. Dit stel die minimumhoogte van die Gebruikerkoppelvlakelement (bv. Ace) wat die antwoordboks beheer. Die breedte word gestel om in die venster te pas. As die antwoord vertikaal of horisontaal uit die boksgrense beweeg, sal rolstawe verskyn.';
$string['answerboxlines'] = 'Rye';
$string['answerpreload'] = 'Antwoordboks vooraflaai';
$string['answerpreload_help'] = 'Teks wat hier verskaf is, sal vooraf in die student se antwoordboks gelaai word.';
$string['answerprompt'] = 'Antwoord:';
$string['answerrequired'] = 'Verskaf asseblief \'n nie-leë antwoord';
$string['answertooshort'] = 'Antwoord is te kort. Dit moet minstens {$a} karakters hê.';
$string['asolutionis'] = 'Vraagskrywer se oplossing:';
$string['atleastonetest'] = 'Jy moet minstens een toetsgeval vir hierdie vraag verskaf.';
$string['attachmentoptions'] = 'Aanhegselopsies (eksperimenteel)';
$string['attachmentsoptional'] = 'Aanhegsels is opsioneel';
$string['attachmentsrequired'] = 'Vereis aanhegsels';
$string['attachmentsrequired_help'] = 'Hierdie opsie spesifiseer die minimumaantal aanhegsels vereis vir \'n antwoord om gemerk te word.';
$string['autotagbycategoryindextitle'] = 'CodeRunner-vraag outomerker';
$string['autotagbycategorytitle'] = 'CodeRunner-outomerk volgens kategorie';
$string['bad_dotdotdot'] = 'Misbruik van \'...\'. Moet aan die einde wees, ná twee verhogende numeriese straftoekennings';
$string['bad_empty_splitter'] = 'Toetsverdeler kan nie leeg wees wanneer \'n kombinatortemplaat gebruik word nie';
$string['bad_new_prototype_name'] = 'Onwettige naam vir nuwe prototipe: reeds in gebruik';
$string['badacelangstring'] = 'Swak Ace-taalstring';
$string['badcputime'] = 'CPU-tydbeperking moet oopgelaat word of \'n heelgetal groter as nul wees';
$string['bademptyprecheck'] = 'Voorafkontrole misluk met die volgende onverwagte afvoer.';
$string['badfilenamesregex'] = 'Ongeldige reguliere uitdrukking';
$string['badfiles'] = 'Dokumentnaam(name) nie toegelaat: {$a}';
$string['badjson'] = 'Swak JSON-afvoer van kombinator-merkerafvoer. Afvoer was {$a->output}';
$string['badjsonfunc'] = 'Onbekende JSON-vasgelegde func ({$a->func})';
$string['badmemlimit'] = 'Geheuebeperking moet leeg gelaat word of \'n nienegatiewe heelgetal wees';
$string['badpenalties'] = 'Strafregime moet \'n komma-geskeide lys nommers in die reeks [0, 100] wees';
$string['badquestion'] = 'Fout in vraag';
$string['badrandomintarg'] = 'Swak argument tot JSON @randomint-funksie';
$string['badrandompickarg'] = 'Swak argument tot JSON @randompic-funksie';
$string['badsandboxparams'] = '\'Ander\' veld (sandbox params) moet of blanko of \'n geldige JSON-rekord wees';
$string['badtemplateparams'] = 'Templaatparameters moet óf blanko wees, óf \'n geldige JSON-rekord.';
$string['brokencombinator'] = 'Verwagte {$a->numtests} toetsuitslae, het {$a->numresults} gekry. Moontlik uitermatige afvoer of fout in vraag?';
$string['brokentemplategrader'] = 'Swak afvoer van merker: {$a->output}. Jou programuitvoering kon gestaak het (bv. \'n tydafsnyding of geheueperk oorskry).';
$string['bulkquestiontester'] = 'Die  <a href="{$a->link}">grootmaat toetserteks</a> toets dat die voorbeeld-antwoorde vir alle vrae in die huidige konteks reg gemerk word. Nuttig slegs sodra \'n aantal vrae met voorbeeld-antwoorde bygevoeg is; die aanvanklike installasie het geen.';
$string['bulktestallincontext'] = 'Toets alles';
$string['bulktestcontinuefromhere'] = 'Loop weer of hervat van hier af';
$string['bulktestindextitle'] = 'CodeRunner grootmaattoetsing';
$string['bulktestrun'] = 'Loop al die vraagtoetse vir al die vrae in die stelsel (stadig, slegs admin)';
$string['bulktesttitle'] = 'Toetsvrae in {$a}';
$string['coderunner'] = 'Programkode';
$string['coderunner_help'] = 'In antwoord op \'n vraag, wat \'n spesifikasie van \'n programfragment, funksie of volledige program is, voer die respondent bronkode in \'n gespesifiseerde rekenaartaal in wat aan die spesifikasie voldoen.';
$string['coderunner_install_testsuite_failures'] = 'Toetse wat misluk het';
$string['coderunner_install_testsuite_intro'] = 'Hierdie bladsy laat toe dat jy toets of die CodeRunner-vrae met eenvoudige antwoorde reg funksioneer.';
$string['coderunner_install_testsuite_noanswer'] = 'Vrae sonder eenvoudige antwoorde';
$string['coderunner_install_testsuite_title'] = '\'n Toetssuite vir CodeRunner voorbeeld-antwoorde';
$string['coderunner_install_testsuite_title_desc'] = 'Die <a href="{$a->link}">voorbeeld-antwoord toetsteks</a> verifieer dat die vrae met voorbeeld-antwoorde korrek werk.';
$string['coderunner_link'] = 'question/type/coderunner';
$string['coderunner_question_type'] = 'CodeRunner-vraagtipe:';
$string['coderunnercategories'] = 'Kategorieë met CodeRunner-vrae';
$string['coderunnercontexts'] = 'Kontekste met CodeRunner-vrae';
$string['coderunnersettings'] = 'Code-Runner-verstellings';
$string['coderunnersummary'] = 'Antwoord is programkode wat uitgevoer word in die konteks van \'n stel toetsgevalle om die korrektheid daarvan te bepaal.';
$string['coderunnertype'] = 'Vraagtipe';
$string['coderunnertype_help'] = 'Kies die programmeringstaal en -vraagtipe. Wanner \'n tipe gekies is, kan besonderhede in die Vraagtipe-besonderhedepaneel hieronder besigtig word.';
$string['columncontrols'] = 'Uitslagtabel';
$string['columncontrols_help'] = 'Die merkbokse wat kies watter kolomme van die Uitslaetabel aan die student ná indiening vertoon behoort te word';
$string['confirm_proceed'] = 'As jy hierdie vraag stoor sonder om "Doelgemaak" te merk, sal enige aanpassings wat gemaak is, verlore gaan. Gaan voort?';
$string['confirmreset'] = 'Verwerp al jou werk op hierdie vraag en herstel antwoordboks na oorspronklike, voorafgelaaide waarde?';
$string['cputime'] = 'Tydsbeperking (sekondes)';
$string['customisation'] = 'Doelmaking';
$string['customisationcontrols'] = 'Doelmaking';
$string['customise'] = 'Doelmaak';
$string['datafiles'] = 'Ondersteuningsdokumente';
$string['datafiles_help'] = 'Enige dokumente wat hier opgelaai is, sal by die werkgids gevoeg word wanneer die oopgevoude templaatprogram uitgevoer word. Dit laat toe dat groot data- of ondersteuningsdokumente gemaklik bygevoeg word.';
$string['default_penalty_regime'] = 'Verstekstrafregime';
$string['default_penalty_regime_desc'] = 'Die verstekstrafregime vir toepassing op nuwe vrae, bestaande uit \'n komma-geskeide lys strafpersentasies, en opsioneel eindig met ", ..." om \'n voortgaande rekenkundige progressie aan te toon.';
$string['display'] = 'Vertoon';
$string['downloadquizattempts'] = 'Laai vasvrapogings af';
$string['downloadquizattemptshelp'] = 'Kliek die geskikte kursus en/of aflaaiknoppie
vir die kursus en vasvra wat jy wil aflaai. Getalle in parentese
ná kursusse is die aantal vasvrae in die kursus met minstens
een indiening. Die getalle in parentese ná die vasvranaam
is die aantal indienings.';
$string['editingcoderunner'] = '\'n CodeRunner-vraag word gewysig';
$string['empty_new_prototype_name'] = 'Nuwe vraagtipenaam kan nie leeg wees nie';
$string['emptypenaltyregime'] = 'Strafregime moet gedefinieer word (sedert weergawe 3.1)';
$string['enable'] = 'Ontsper';
$string['enable_diff_check'] = 'Ontsper \'Vertoon verskille\'-knoppie';
$string['enable_diff_check_desc'] = 'Verskaf aan studente \'n \'Vertoon verskille\'-knoppie as hul antwoord verkeerd is en \'n presies ooreenstemming-validator gebruik word';
$string['enable_sandbox_desc'] = 'Laat gebruik van die gespesifiseerde sandbox vir die loop van studentindienings toe';
$string['enablecombinator'] = 'Ontsper kombinator';
$string['equalitygrader'] = 'Pas presies';
$string['error_loading_prototype'] = 'Fout met die laai van prototipe. Moontlik netwerkprobleme of bediener wat af is?';
$string['errorstring-accessdenied'] = 'Toegang tot sandbox is geweier';
$string['errorstring-autherror'] = 'Nie gemagtig om sandbox te gebruik nie';
$string['errorstring-jobe400'] = 'Fout vanaf Jobe sandbox-bediener:';
$string['errorstring-ok'] = 'OK';
$string['errorstring-overload'] = 'Werkstuk kon nie geloop word nie weens bedieneroorlading. Probeer dalk binnekort weer?';
$string['errorstring-pastenotfound'] = 'Status van niebestaande werkstuk word versoek';
$string['errorstring-submissionfailed'] = 'Indiening by sandbox het misluk';
$string['errorstring-submissionlimitexceeded'] = 'Sandbox-indieningsperk bereik';
$string['errorstring-unknown'] = 'Onverwagte fout terwyl jou kode uitgevoer is. Die sandbox-bediener kan buite werking of oorlaai wees. Probeer dalk binnekort weer?';
$string['errorstring-wronglangid'] = 'Niebestaande taal is versoek';
$string['expand'] = 'Vou oop';
$string['expandtitle'] = 'Vertoon vraagkategorieë';
$string['expected'] = 'Verwagte afvoer';
$string['expected_help'] = 'Die verwagte afvoer van die toets. Word deur templaat gesien as {{TEST.expected}}.';
$string['expectedcolhdr'] = 'Verwagte';
$string['exportthisquestion'] = 'Voer hierdie vraag uit';
$string['exportthisquestion_help'] = 'Dit sal \'n Moodle XML-uitvoerdokument skep wat slegs hierdie een vraag bevat. Een voorbeeld van waar dit nuttig is, is wanneer jy vermoed hierdie vraag demonstreer \'n fout in CodeRunner wat jy aan die ontwikkelaars wil rappoerteer.';
$string['extra'] = 'Ekstra templaatdata';
$string['extra_help'] = '\'n Soms-nuttige ekstra teksveld vir gebruik deur die templaat, verkry as {{TEST.extra}}';
$string['fail'] = 'Misluk';
$string['failedhidden'] = 'Jou kode het een of meer versteekte toetse nie geslaag nie.';
$string['failedntests'] = 'Nie geslaag {$a->numerrors} test(s)';
$string['failedtesting'] = 'Toetsing nie geslaag.';
$string['fails'] = 'Mislukkings';
$string['feedback'] = 'Terugvoer';
$string['feedback_help'] = 'Kies \'Gestel deur vasvra\' om vasvraterugvoerverstellings toe te laat om vertoon van die uitslagtabel te beheer, \'Forseer vertoon\' om die uitslagtabel ongeag te vertoon en \'Forseer versteek\' om dit ongeag te versteek';
$string['feedback_hide'] = 'Forseer versteek';
$string['feedback_quiz'] = 'Gestel deur vasvra';
$string['feedback_show'] = 'Forseer vertoon';
$string['fileheader'] = 'Ondersteuningsdokumente';
$string['filenamesexplain'] = 'Beskrywing';
$string['filenamesregex'] = 'Reguliere uitdrukking';
$string['filloutoneanswer'] = 'Jy moet bronkode invoer wat aan die spesifikasie voldoen. Die kode wat jy invoer sal uitgevoer word om die korrektheid daarvan te bepaal en \'n punt sal dienooreenkomstig toegeken word.';
$string['firstfailure'] = 'Eerste gedruipte toetsgeval: {$a}';
$string['forexample'] = 'Byvoorbeeld';
$string['globalextra'] = 'Globale ekstra';
$string['globalextra_help'] = '\'n Teksveld vir algemene gebruik deur templaatouteurs, soos die ekstra veld van elke toetsgeval, maar globaal vir alle toetse. Aan templaatouteur beskikbaar as {{ QUESTION.globalextra }}.';
$string['goodemptyprecheck'] = 'Geslaag';
$string['gotcolhdr'] = 'Verkry';
$string['grader'] = 'Merker';
$string['grading'] = 'Merk';
$string['gradingcontrols'] = 'Merkkontroles';
$string['gradingcontrols_help'] = 'Die verstek \'pas presies\' merker ken slegs punte toe as die afvoer van die lopie presies by die verwagte waarde, wat deur die toetsgeval gedefinieer is, pas. Slepende witspasie word van alle lyne verwyder en enige slepende blankolyne word uitgewis voordat die gelykheidstoets gedoen word.

Die byna-gelyke merker is soortgelyk, behalwe dat dit ook etlike spasies en oortjies tot \'n enkele spasie toevou, alle blankolyne uitwis en die stringe na kleinletters verander.

Die \'reguliere uitdrukking\' merker gebruik die \'verwagte\' veld van die toetsgeval as \'n reguliere uitdrukking, en toets die afvoer om te sien of enige deel binne die afvoer wat by die verwagte uitslag pas, gevind kan word. Om die bypassing van die hele afvoer te forseer, begin en eindig die reguliere uitdrukking met onderskeidelik \'\\A\' en \'\\Z\'. Reguliere uitdrukking-bypassing gebruik MULTILINE- en DOTALL-opsies.

Die \'templaatmerker\'-opsies aanvaar dat die afvoer van die program eintlik \'n
merkuitslag is, d.w.s. dat die templaat die student se antwoord nie toets *of merk* nie. Die enigste afvoer uit so \'n templaatprogram moet \'n JSON-geënkodeerde rekord wees.

As die templaat \'n per toets-templaat is (d.w.s. nie \'n kombinator nie) moet die JSON-string \'n ry van die uitslagtable beskryf en minstens \'n \'breuk\'-veld bevat, wat vermenigvuldig word deur TEST.mark om te besluit hoeveel punte aan die toetsgeval toegeken word. Dit behoort gewoonlik ook \'n \'verkry\'-veld te hê, wat die waarde is wat in die \'Verkry\'-kolom van die uitslagtabel is. Die ander kolomme van die uitslagtabel (testcode, stdin, expected) kan ook gedefinieer word deur die templaat-merkprogram en sal gebruik word, eerder as die waardes van die toetsgeval. As \'n voorbeeld, as die afvoer van die program die string <code>{"fraction":0.5, "got": "Helfte van die antwoorde was korrek!"}</code> is, sal halfpunte vir daardie spesifieke toetsgeval gegee word en die \'Verkry\'-kolom sal die teks "Helfte van die antwoorde was korrek!" vertoon. Ander kolomme kan by die uitslagtabel gevoeg word deur ekstra eienskappe by die JSON-rekord te voeg en ook by die vraag se Uitslagkolom-veld.

As die templaat \'n kombinator is, behoort die JSON-stringafvoer deur die templaatmerker weer \'n \'breuk\'-veld te bevat, hierdie keer vir die totale punt, en kan dit nul of meer van \'prologuehtml\', \'testresults\', \'epiloguehtml\', \'columnformats\', \'showoutputonly\' en \'showdifferences\' bevat. Die \'prologuehtml\'- en \'epiloguehtml\'-velde is html wat onderskeidelik voor en ná die (opsionele) uitslagtabel vertoon word. Die \'testresults\'-veld, indien verskaf, is \'n lys van lyste wat gebruik word om \'n tipe uitslagtabel te vertoon. Die eerste ry is die kolomopskrif-ry en alle ander rye definieer die hoof-tabeldeel. Twee spesiale kolomopskrif-waardes bestaan: \'iscorrect\' en \'ishidden\'. Die \'iscorrect\'-kolom(me) word gebruik om regmerkies of kruisies vir 1 of 0 rywaardes onderskeidelik te vertoon. Die \'ishidden\'-kolom word nie werklik vertoon nie, maar 0 of 1 waardes in dié kolom kan gebruik word om rysigbaarheid aan- en af te skakel. Studente sien nie versteekte rye nie, maar merkers en ander personeel sien dit wel. As \'n \'testresults\'-tabel verskaf word, kan \'n opsionele \'columnformats\'-veld ook verskaf word. Dit behoort \'n lys van stringe te wees, een per kolom, behalwe die \'iscorrect\'- en \'ishidden\'-kolomme. Die stringe spesifiseer die formaat wat gebruik moet word om die selwaardes te vertoon; tans is die enigste formate wat ondersteun word \'%s\' vir \'n normale stringvertoon (wat gesanitieer is en in \'n \'pre\'-element gedraai is) en \'%h\' vir \'n html-waarde wat nie verder voor vertoon verwerk behoort te word nie. Die \'showdifferences\'-veld skakel die vertoon van \'n \'Vertoon Verskille\'-knoppie ná die uitslagtabel aan, indien die toegekende puntbreuk nie 1.0 is nie.
Die \'showoutputonly\'-veld, indien waar, word gebruik wanneer die vraag slegs gebruik gaan word om die afvoer en moontlik prente uit \'n lopie te vertoon, met geen punt nie.';
$string['graph_ui_invalidserialisation'] = 'GraphUI: ongeldige dinamisering';
$string['graphhelp'] = '- Dubbelkliek op \'n blankospasie om \'n nuwe nodus/staat te skep.
- Dubbelkliek \'n bestaande nodus om dit te "merk", d.w.s as \'n aanvaarstaat vir eindigetoestand-masjiene (ETM\'e). Dubbelkliek weer om dit te ontmerk.
- Kliek en sleep om \'n nodus te skuif.
- Alt kliek (of Ctrl Alt kliek) en sleep om \'n (sub)grafiek te skuif.
- Shift kliek in een nodus en sleep na \'n ander om \'n skakel te skep.
- Shift kliek op \'n blankospasie, sleep na \'n nodus om \'n beginskakel te skep (slegs ETM\'e).
- Kliek en sleep \'n skakel om die kurwe daarvan te verander.
- Kliek op \'n skakel/nodus om die teks daarvan te wysig.
- Tik _ gevolg deur \'n syfer om die syfer \'n onderskrif te maak.
- Tik \\epsilon om \'n epsilonkarakter te skep (dieselfde kan vir \\alpha, \\beta, ens. gedoen word).
- Kliek op \'n skakel/nodus en druk dan die Delete-knoppie om dit te verwyder (of function-delete op \'n Mac).';
$string['hidden'] = 'Versteek';
$string['hidedifferences'] = 'Versteek verskille';
$string['hiderestiffail'] = 'Versteek res indien misluk';
$string['hoisttemplateparams'] = 'Hys templaatparameters';
$string['howtogetmore'] = 'Vir meer inligting, berg die vraag met \'Valideer op berging\' nie gemerk nie en toets per hand';
$string['ideone_pass'] = 'Ideone-bedienerwagwoord';
$string['ideone_pass_desc'] = 'Die wagwoord om te gebruik wanneer jy aan die verouderde Ideone-bediener koppel (as die ideone sandbox ontsper is)';
$string['ideone_user'] = 'Ideone-bedienergebruiker';
$string['ideone_user_desc'] = 'Die intekennaam om te gebruik wanneer jy aan die verouderde Ideone-bediener koppel (as die ideone sandbox ontsper is)';
$string['illegalformat'] = 'Onwettige formaat ({$a->format}) in kolomformate';
$string['info_unavailable'] = 'Vraagtipe-inligting is nie vir doelgemaakte vrae beskikbaar nie.';
$string['inputcolhdr'] = 'Toevoer';
$string['insufficientattachments'] = 'Nie genoeg aangehegsels nie, {$a} vereis.';
$string['is_prototype'] = 'Gebruik as prototipe';
$string['iscombinatortemplate'] = 'Is kombinator';
$string['jobe_apikey'] = 'Jobe API-sleutel';
$string['jobe_apikey_desc'] = 'Die API-sleutel moet in alle REST-versoeke aan die Jobe-bediener ingesluit word (indien vereis). Maks. 40 karakters. Los blanko om die API-sleutel uit versoeke te laat.';
$string['jobe_canterbury_html'] = '<p style=\'color:gray; font-style:italic; font-size:smaller\'>Loop op die Universiteit van Canterbury se Jobe-bediener.</p>';
$string['jobe_host'] = 'Jobe-bediener';
$string['jobe_host_desc'] = 'Die gasheernaam van die Jobe-bediener plus die poortnommer as dit enigiets anders as poort 80 s, bv. jobe.somewhere.edu:4010. Die URL vir die Jobe-versoek word by verstek verkry deur hierdie string deur http:// vooraf te laat gaan en /jobe/index.php/restapi/<REST_METHOD> by te voeg. Jy kan die https://-protokol voor die gasheernaam spesifiseer (bv. https://jobe.somewhere.edu) as die Jobe-bediener agter \'n omgekeerde instaanbediener is wat as \'n SSL-beëindiging dien.';
$string['jobe_warning_html'] = '<p style=\'background-color:yellow\'>Voer uit met die Universiteit van Canterbury se Jobe-bediener. Dit is slegs vir aanvanklike toetsing. Stel asseblief so gou as moontlik jou eie Jobe-bediener op. Sien <a href=\'https://github.com/trampgeek/moodle-qtype_coderunner/blob/master/Readme.md#sandbox-configuration\' target=\'_blank\'>here</a>.</p>';
$string['language'] = 'Sandboks-taal';
$string['languages'] = 'Tale';
$string['languages_help'] = 'Die sandboks-taal is die rekenaartaal wat gebruik word om die indiening uit te voer.
Die moet aan die gekose sandboks bekend wees (as \'n spesifieke een gekies is) of  (andersins) aan minstens een van die ontsperde sandbokse.
Dit behoort gewoonlik nie verandering van die waarde in die moedertemplaat te benodig nie; wysig dit op eie risiko.

Ace-taal is die taal wat deur die Ace-kodewysiger gebruik word (indien ontsper) vir die student se antwoord.
By verstek is die diesellfde as die sandbox-taal; voer slegs \'n ander waarde hier in as die templaattaal anders is as die taal waarin die student moet skryf (bv. as \'n Python-voorverwerker gebruik word om \'n student se C-program te valideer voordat dit geloop word).

Veeltalige vrae, d.w.s. vrae wat studente in meer as een taal kan antwoord, word ontsper deur die Ace-taal op \'n kommageskeide lys van tale te stel. Studente kry dan \'n aftrekkieslys om die taal te kies waarin hul antwoord geskryf word. As presies een van die tale \'n asterisk (\'\\*\') bygevoeg het, word daardie taal as die verstektaal gekies, wat gekies word as die aanvanklike staat van die aftrekkieslys. Byvoorbeeld, \'n Ace-taalwaarde van "C,C++,Java\\*,Python3" sal studente toelaat om in C, C++, Java of Python3 in te dien, maar die aftrekkieslys sal aanvanklik Java vertoon, wat die verstek is. As geen verstek gespesifiseer is nie, is die aanvanklike staat van die aftrekkieslys leeg en moet die student \'n taal kies.
Veeltalige vrae vereis \'n spesiale templaat wat die {{ANSWER\\_LANGUAGE}} templaatveranderlike gebruik om te beheer hoe om die studentkode uit te voer. Sien ingeboude voorbeeld-veeltalige vraagtipe. Die {{ANSWER\\_LANGUAGE}} veranderlike is <i>slegs</i> vir veeltalige vrae gedefinieer.

As die outeur \'n voorbeeld-antwoord aan \'n veeltalige vraag wil verskaf, moet hy dit in die verstektaal skryf, indien dit gespesifiseer is, of andersins die eerste van die toegelate tale.';
$string['languageselectlabel'] = 'Taal';
$string['mark'] = 'Punt';
$string['marking'] = 'Punttoekenning';
$string['markinggroup'] = 'Merk';
$string['markinggroup_help'] = 'As \'Alles-of-niks\' gemerk is, moet aan alle toetsgevalle voldoen word vir die indiening om enige punte te verdien. Anders word die punt verkry deur die punte van al die toetsgevalle wat geslaag het, op te som en dit as \'n breuk van die maksimum moontlike punt uit te druk.
Die per-toetsgeval punte kan slegs gespesifiseer word as die alles-of-niks-merkboks nie gemerk is nie. As \'n templaatmerker gebruik word wat gedeeltelike punte aan toetsgevalle toeken, behoort \'Alles-of-niks\' gewoonlik nie gemerk te word nie.

Die verpligte strafregime is \'n komma-geskeide lys straftoekennings (elkeen \'n persent) van toepassing op daaropvolgende indienings. Hierdie is absoluut en nie kumulatief nie. As \'n spesiale geval kan die laaste straftoekenning \'...\' wees, om te beteken "verleng die vorige twee straftoekennings as rekenkundige progressie tot en met 100". Byvoorbeeld: <tt>0,5,10,30,...</tt> is ekwivalent aan <tt>0,5,10,30,50,70,90,100</tt>.
As daar meer indienings as gedefinieerde straftoekennings is, word die laaste waarde gebruik.
Spasies kan in die plek van kommas as skeier gebruik word.

Die verstek strafregime kan vir regoor die werf gestel word deur \'n stelseladministrateur deur Werfadministrasie > Invoegtoepassings > Vraagtipes > CodeRunner te gebruik.

Stel die strafregime na \'0\' vir geen straftoekennings op alle indienings.';
$string['maxfilesize'] = 'Maks. toegelate dokumentgrootte (grepe)';
$string['maxfilesize_help'] = 'Kies die maksimum dokument-oplaaigrootte (grepe). Deur die oplaai van groot dokumente vir groot klasse toe te laat, kan die prestasie en skyfspasie op beide Moodle- en Jobe-bedieners geaffekteer word.';
$string['memorylimit'] = 'MemLimit (MB)';
$string['missinganswers'] = 'ontbrekende antwoorde';
$string['missingorbadfraction'] = 'Swak of ontbrekende breuk in afvoer vanaf kombinator-merkerafvoer. Afvoer was: {$a->output}';
$string['missingoutput'] = 'Jy moet die verwagte afvoer van hierdie toetsgeval verskaf.';
$string['missingprototype'] = 'Hierdie vraag is gedefinieer om tipe \'{$a->crtype}\' te wees, maar die prototipe bestaan nie of is nie uniek nie, of is nie in hierdie konteks beskikbaar nie. Jy behoort te Kanselleer en weer te probeer om die prototipe te (her)installeer. Gaan slegs voort met wysiging as jy weet wat jy doen!';
$string['missingprototypes'] = 'Ontbrekende prototipes';
$string['missingprototypewhenrunning'] = 'Stukkende vraag (ontbrekende prototipe \'{$a->crtype}\').';
$string['morehidden'] = 'Sommige versteekte toetsgevalle het ook misluk.';
$string['multipledefaults'] = 'Maksimum een taal kan as verstek gekies word';
$string['multipleprototypes'] = 'Veelvoudige prototipes vir \'{$a->crtype}\' gevind';
$string['mustrequirefewer'] = 'Jy kan nie meer aanhegsels vereis as wat jy toelaat nie.';
$string['nearequalitygrader'] = 'Byna presies ooreenstemmend';
$string['negativeorzeromark'] = 'Punt moet groter as nul wees';
$string['nodetailsavailable'] = 'Kies \'n vraagtipe om gedetailleerde hulp te besigtig.';
$string['noerrorsallowed'] = 'Jou kode moet alle toetse slaag om enige punte te verdien. Probeer weer.';
$string['nonnumericmark'] = 'Nienumeriese punt';
$string['noqtype'] = 'Geen vraagtipe is gekies nie';
$string['nosampleanswer'] = 'Geen voorbeeld-antwoord';
$string['options'] = 'Opsies';
$string['ordering'] = 'Ordening';
$string['pass'] = 'Deurgang';
$string['passes'] = 'Deurgange';
$string['penaltyregime'] = '(strafregime: {$a} %)';
$string['penaltyregimelabel'] = 'Strafregime:';
$string['pluginname'] = 'CodeRunner';
$string['pluginname_help'] = 'Gebruik die \'Vraagtipe\' komboboks om die rekenaartaal en vraagtipe te kies wat gebruik sal word om die student se indiening te loop.
Spesifiseer die probleem waarvoor die student kode moet skryf en definieer dan \'n stel toetse wat geloop moet word wanneer die student sy werk indien';
$string['pluginname_link'] = 'question/type/coderunner';
$string['pluginnameadding'] = '\'n CodeRunner-vraag word bygevoeg';
$string['pluginnameediting'] = '\'n CodeRunner-vraag word gewysig';
$string['pluginnamesummary'] = 'CodeRunner: loop student-ingediende kode in \'n sandbox';
$string['precheck'] = 'Vooraf nagaan';
$string['precheck_all'] = 'Alle';
$string['precheck_disabled'] = 'Versper';
$string['precheck_empty'] = 'Leeg';
$string['precheck_examples'] = 'Voorbeelde';
$string['precheck_help'] = 'As Vooraf Nagaan ontsper is, sal studente \'n ekstra knoppie links van die gewone nagaanknoppie hê om \'n strafvrye lopie te kry om hul kode met \'n onderafdeling van die vraagtoetsgevalle te vergelyk.

As \'Leeg\' gekies is, sal \'n enkele lopie met die per-toets-templaat gedoen word, met \'n toetsgeval waarin al die velde (testcode, stdin, expected, ens.) die leë string is. Nie-leë afvoer word as \'n mislukte vooraf-nagaan beskou. Gebruik versigtig: sommige vraagtipes sal dit nie korrek hanteer nie, bv. skryf-\'n-program-vrae wat afvoer genereer.

As \'Voorbeelde\' gekies is, sal die kode teen al die toetse waarvoor \'gebruik_as_voorbeeld\' gemerk is, getoets word.

As \'Gekies\' gekies is, sal \'n ekstra UI-element by elke toetsgeval gevoeg word om die outeur toe te laat om \'n spesifieke onderafdeling van die toetse te kies.

As \'Alle\' gekies is, word alle toetsgevalle geloop (alhoewel hul gedrag anders as die normale Nagaan kan wees, as die templaatkode dit verkies).

Die templaat kan nagaan of die lopie \'n vooraf-nagaan-lopie is d.m.v. die Twig-parameter {{ IS_PRECHECK }}, wat "1" tydens vooraf-nagaan-lopies is en "0" andersins is.';
$string['precheck_only'] = 'Slegs vooraf nagaan';
$string['precheck_selected'] = 'Gekies';
$string['precheckingemptyset'] = 'Voorbeelde word vooraf nagegaan, maar daar is geen!';
$string['privacy:metadata'] = 'Die invoegtoepassing van CodeRunner-vraagtipe berg geen persoonlike data nie.';
$string['proceed_at_own_risk'] = 'Wysig jy \'n ingeboude vraag-prototipe? Doen dit op eie risiko!';
$string['prototypeQ'] = 'Is prototipe?';
$string['prototype_error'] = '*** LAAI VAN PROTOTIPE MISLUK. MOET DIT NIE BERG NIE! ***';
$string['prototype_load_failure'] = 'Fout met die laai van prototipe:';
$string['prototypecontrols'] = 'Prototipering';
$string['prototypecontrols_help'] = 'As \'Is prototipe\' waar is, word hierdie vraag \'n prototipe vir ander vrae. Ná berging sal die gespesifiseerde vraagtipe-naam in die aftreklys van vraagtipes verskyn. Nuwe vrae, gebaseer op hierdie tipe, sal dan by verstek al die doelgemaakte eienskappe wat vir hierdie vraag gespesifiseer is, erf. Daaropvolgende veranderinge aan hierdie vraag sal dan alle afkomstige vrae affekteer, behalwe as hulle self doelgemaak word, wat die konneksie verbreek.

Prototipiese oorerwing is slegs enkelvlak, dus sal hierdie vraag, wanneer dit as prototipe geberg word, sy konneksie met die oorspronklike basistipe verloor, en \'n nuwe basistipe in eie reg word.
Wees gewaarsku dat, wanneer jy afgeleide vrae uitvoer, jy moet verseker dat hierdie vraag ook in die uitvoer ingesluit is, of die afgeleide vraag sal wees wees wanneer dit in \'n ander stelsel ingevoer word. Jy is ook verantwoordelik om tred te hou van watter vrae jy as prototipes gebruik; jy word ten sterkste aangeraai om die vraag te herbenoem na iets soos \'PROTOTIPE_vir_my_nuwe_vraagtipe\' om daaropvolgende instandhouding makliker te maak.';
$string['prototypeusage'] = 'CodeRunner-vraag prototipegebruik vir kursus {$a}';
$string['prototypeusageindex'] = 'Beskikbare kursusse';
$string['qWrongBehaviour'] = 'Gebruik asseblief Aanpassende Gedrag vir alle CodeRunner-vrae, of daar kan massiewe prestasietrefslae wees. Byvoorbeeld: alle vrae op \'n bladsy sal oorgemerk moet word wanneer die bladsy weer vertoon word.';
$string['qtype_c_function'] = '<p>\'n Vraagtipe vir C skryf-\'n-funksie-vrae.
Daar word van die student se antwoord verwag om \'n vollgedige C-funksie te wees, maar dit kan (opsioneel) voorafgegaan word deur ander selfstandige C-kode, soos voorverwerkerriglyne en ondersteuningsfunksies.</p>
<p>Die toetskode vir sulke vrae noem gewoonlike die studentefunksie met enkele toetsargumente en druk die resultaat af, soos
<pre>printf("%d\\n", someIntFunction(blah1, blah2))</pre>
Die toetsgeval se <i>Verwagte</i> veld is die verwagte afvoer van die toets.</p>
<p>
As daar geen standaard toevoer vir enige van die toetsgevalle verskaf is nie, word \'n enkele toetsprogram gebou, bestaande uit:</p>
<ol>
<li>Die volgende standaard #sluit in: stdlib.h, ctype.h, string.h, stdbool.h, math.h</li>
<li>Die student antwoord.</li>
<li>\'n Reeks blokke word in krulhakies gesit vir elk van die gegewe toetsgevalle.
Elke blok bevat slegs die toetsgeval se toetskode. Daar is ook \'n <i>drukf</i> stelling tussen kodeblokke ingevoeg om \'n spesiale skeier te druk, wat gebruik word om die afvoer terug in die individuele toetsgeval-afvoere te verdeel.</li>
</ol>
<p>As enige van die toetsgevalle egter nie-leë standaard toevoer het, word etlike toetsprogramme geloop, een vir elke toetsgeval.
</p><p>Die toetsgeval se <i>ekstra</i> veld word geïgnoreer.</p>';
$string['qtype_c_program'] = '<p>Gebruik vir C skryf-\'n-program-vrae, waar daar geen per-toetsgeval-kode is nie en waar die verskillende toetse net verskillende standaard toevoer (stdin) data gebruik. Daar word van die student se antwoord verwag om \'n volledige loopbare program te wees, wat netso geloop word, sonder wysiging deur CodeRunner, een maal vir elke toetsgeval. Die waardes van die toetskode en ekstra velde van elke toetsgeval word geïgnoreer.</p><p>As jy \'n spesifieke kompileer of skakelargumente vir die vraag wil stel, kan jy dit doelmaak (kliek die Doelmaak-merkboks), maak die <i>Gevorderde doelmaking</i> afdeling oop en voer geskikte waardes in die <i>Sandbox &gt; Parameters</i> veld in. Byvoorbeeld:<pre>
{"linkargs":["-lm"]}</pre>om met die wiskundebiblioteek te koppel.';
$string['qtype_cpp_function'] = '<p>\'n Vraagtipe vir C++ skryf-\'n-funksie-vrae.
Daar word van die student se antwoord verwag om \'n volledige C++ funksie te wees, maar dit kan (opsioneel) voorafgegaan word deur ander selfstandige C++ kode, soos voorverwerker direktiewe en ondersteuningsfunksies.</p>
<p>In elke toetsgeval noem die toetskode vir sulke vrae gewoonlik die studentfunksie met \'n aantal toetsargumente en druk die resultaat uit, soos
<pre>cout << someIntFunction(blah1, blah2))</pre>
Die toetsgeval se <i>Verwagte</i> veld is die verwagte afvoer van die toets.
<p>
As daar geen standaard toevoer vir enige van die toetsgevalle verskaf is nie, word \'n enkele toetsprogram geskep, wat bestaan uit:</p>
<ol>
<li>Die volgende standaard #sluit in: iostream, fstream, string, math, vector and algorithm</li>
<li><code>gebruik naamspasie std;</code></li>
<li>Die student se antwoord</li>
<li>Die volgorde van blokke wat in hakies gesit is vir elk van die gegewe toetsgevalle. Elke blok bestaan uit die toetsgeval se <i>ekstra</i> veld (gewoonlik leeg) gevolg deur die toetskode. Daar is ook \'n <i>drukf</i>
stelling tussen kodeblokke ingevoeg om \'n spesiale skeier te druk wat gebruik word om die afvoer terug in individuele toetsgevalafvoere in te verdeel.</li>
</ol>
<p>As enige van die toetsgevalle egter nie-leë standaardtoevoer het, word etlike toetsprogramme geloop, een vir elke toetsgeval.
</p>';
$string['qtype_cpp_program'] = '<p>Gebruik vir C++ skryf-\'n-program-vrae, waar daar geen per-toetsgeval-kode is nie, en die verskillende toetse net verskillende standaard toevoer (stdin) data gebruik. Daar word van die student se antwoord verwag om \'n volledige, loopbare program te wees, wat netso geloop word, sonder verandering deur CodeRunner, een maal vir elke toetsgeval. Die waardes van die toetskode en ekstra velde van elke toetsgeval word geïgnoreer.</p>';
$string['qtype_directed_graph'] = '<p>\'n Python3-vraagtipe wat vereis dat die student \'n gerigte grafiek trek om aan \'n sekere spesifikasie te voldoen. Die vraagouteur moet
Python3-kode skryf om die gevolglike grafiek na te gaan.</p><p>Let daarop dat dit nie werklik nodig is om hierdie vraagtipe vir gerigte grafieke te gebruik nie, aangesien die funksionaliteit hoofsaaklik deur die GraphUI-invoegtoepassing verskaf word. As die grafiek-voorverwerking wat deur hierdie vraagtipe gedoen word nie by jou behoeftes pas nie, kan jy net \'n normale Python3-vraag (of enige ander taal) gebruik om die UI na GraphUI te stel en die JSON-geordende weergawe van die grafiek (die Twig STUDENT_ANSWER&nbsp; verandelike) self te stel. Hierdie vraagtipe verskaf egter nie \'n voorbeeld van hoe om die GraphUI-invoegtoepassing te gebruik nie. Kliek <i>Doelmaak</i>&nbsp; om die templaatkode te besigtig.</p>
<p>Die spesifikasie sal die student vra om \'n gerigte grafiek te trek om aan
sekere vereistes te voldoen. Dit kan, byvoorbeeld, \'n DET (deterministiese eindigetoestand outomaat) of \'n Draaimasjien wees. Die toetsgevalkode en/of die ekstra kode sal dan die grafiek analiseer en \'n boodskap aan die student druk, soos OK as die grafiek korrek is of andersins \'n geskikte leersame foutboodskap.</p>
<p>Die templaat vir hierdie vraag analiseer die JSON-geordende grafiek, en pak
die topologie daarvan uit in die vorm van \'n aanliggende woordeboek&nbsp;<i>grafiek</i>. Hierdie veranderlike is beskikbaar aan die toets of ekstra kode in die toetsgeval. Sleutels in die woordeboek is nodusname, indien verskaf, of andersins arbitrêre nodusidentifiserende etikette van die vorm #1, #2, ensovoorts. Waardes in die woordeboek is lyste van uitgaande rante, georden deur buurnodusnaam of -identifiseerder, waar elke rant \'n tal is (buurID,edgeLabel).</p><o>Elke invoer in die noduslys is die vorm (nodeNameOrId, bure) waar bure \'n lys talle is
(neighbourNodeNameOrId, edgeLabel). As nodusse name gegee word, word dit gebruik as nodusidentifiseerders, anders word die name #1, #2, ens. gebruik. Die noduslys en die buurlys word beide volgens nodusnaam of -identifiseerder georden.</p>
<p>Die templaat is \'n kombinator-een: die <i>toetskode</i>&nbsp;en
<i>ekstra</i>&nbsp;kode word beide vir elke toetsgeval uitgevoer.</p><p>As \'n eenvoudige voorbeeld: as die spesifikasie net "Trek \'n gerigte grafiek met twee nodusse geëtiketteer A en B, met \'n rant van A tot B" was, sou \'n geskikte toetsgeval (alhoewel met niehulpvaardige foutafvoer) kon wees:</p><pre>
indien gestel (graph.keys()) == {\'A\', \'B\'} en len(graph[\'A\']) == 1 en len(graph[\'B\']) == 0 and graph[\'A\'][0][0] == \'B\':
druk(\'OK\')
anders:
druk(\'Nee\')
</pre>
<p>Alternatiewelik kan daar \'n stel toetsgevalle wees, wat elkeen een van die aspekte van die spesifikasie kontroleer. Byvoorbeeld: die eerste toetsgeval kan
die geordende sleutels druk en verwag om \'A\', \'B\' te sien. Die tweede toetsgeval kan
die uitgaande rante van nodus \'A\' druk, ensovoorts.</p>
<p>Die vraag neem die volgende templaatparameters, wat almal deur die GraphUI-invoegtoepassing herken word en die gedrag daarvan beheer.</p>
<p><ul>
<li>isfsm. Waar as die grafiek \'n Eindigetoestand-masjien is. Indien waar, kan die grafiek \'n inkomende rant van nêrens bevat (die beginrant) en nodusse kan
gemerk word as aanvaar-state (vertoon met \'n dubbele sirkel) deur te dubbelkliek. Verstek: waar.</li>
<li>isgerig. Waar as rante gerig is. Verstek: waar.</li>
<li>nodusradius. Die radius van \'n nodus, in beeldelemente (pixels). Verstek: 26.</li>
<li>fontgrootte. Die fontgrootte wat gebruik word vir nodus- en rantetikette. Verstek: 20 punte.</li>
<li>teksverrekening. \'n Verrekening in beeldelemente (pixels) gebruik wanneer skakeletiketteks geposisioneer word. Verstek 4.</li>
<li>helpkieslysteks. \'n String om in stede van die verstek Help info te gebruik, indien verskaf. Geen verstek.</li>
<li>sluitnodusposisies. Waar om te verhoed dat gebruiker nodusse skuif. Nuttig wanneer die antwoordboks vooraf gelaai is met \'n grafiek wat die student moet annoteer deur nodus- of rantetikette te verander of deur rante by te voeg/te verwyder. Let daarop dat nodusse egter steeds bygevoeg en uitgewis kan word</li>
<li>sluitnodusstel. Waar om gebruiker te verhoed om nodusse by te voeg of te verwyder of te wip van die aanvaar-staat (van etm-grafieke).</li>
<li>sluitnodusetikette. Waar om gebruiker te verhoed om nodusetikette te wysig (insluitende nuut-bygevoegde etikette).</li>
<li>geslotegeposisies. Waar om gebruiker te verhoed om rante te sleep om hul kromming te verander. Moontlik nuttig as die antwoordboks vooraf gelaai is met \'n grafiek wat die student moet annoteer deur nodus- of rantetikette te verander of deur rante by te voeg/te verwyder. Verseker ook dat rante wat deur \'n student bygevoeg word, reguit is, bv. om \'n poligoon op \'n stel gegewe punte te teken. Let daarop dat rante egter steeds bygevoeg en uitgewis kan word.</li>
<li>geslotegestel. Waar om gebruiker te verhoed om rante by te voeg of te verwyder.</li>
<li>geslotegeetikette. Waar om gebruiker te verhoed om rantetikette te wysig (insluitende nuut-bygevoegde etikette)</li>
</ul></p>';
$string['qtype_java_class'] = '<p>\'n Java skryf-\'n-klas-vraag waar die studente \'n volledige klas as antwoord indien. Elke toets sal gewoonlik \'n voorwerp van die gespesifiseerde klas installeer en een of meer toetse daarop uitvoer. Dit is nie \'n kombinator-vraagtipe nie, wat beteken dat elke toetsgeval as aparte sandbox-program geloop word.</p><p>Die program wat vir elke toetsgeval gegenereer word, bestaan uit die student se antwoord, met die <i>publieke</i>&nbsp;eienskap verwyder indien teenwoordig. Daardie (nou lokale) klasdefinisie word gevolg deur \'n publieke <i>__Toetser__&nbsp;</i>&nbsp;klas wat \'n <i>hoof</i>&nbsp;metode het wat die Toetserklas instansieer en die <i>loopToetse</i>&nbsp;metode noem. Die <i>loopToetse</i>&nbsp;metode bevat eenvoudig die toetsgevalkode. Sien templaat vir duidelikheid.</p><p>Daar behoort op gelet te word dat die algoritme wat gebruik word om die publieke eienskap van die student-verskafde klas te verwyder, eenvoudig is; dit werk slegs as die woorde <i>publieke klas</i>&nbsp;presies een maal in die studentkode voorkom, geskei deur \'n enkele spasie.</p>
<p>Die toetsgeval ekstra veld word geïgnoreer.</p>
<p>Hierdie vraagtipe is ondoeltreffend as daar baie toetse is, aangesien \'n aparte saamstel-en-uitvoer-werkstuk vir elke toetsgeval na die sandbox gestuur word. Dit kan opgelos word deur \'n kombinator-styl vraagtipe te skryf. Sien die coderunner-dokumentasie (coderunner.org.nz) vir meer inligting.</p>';
$string['qtype_java_method'] = '<p>Gebruik vir Java skryf-\'n-metode-vrae waar daar van die student vereis word om \'n metode te skryf wat hoofsaaklik \'n alleenstaande funksie is. Die outeur-verskafde toets is gewoonlik net een of twee lyne kode wat (oënskynlik) net die student-verskafde metode noem, soos in C. In werklikheid skep die templaat \'n Hoofklas wat die student-verskafde metode (en enige ander ondersteuningsmetodes, as hulle dit sou skryf) bevat, plus \'n \'loopToetse\'-metode wat die toetsgeval(le) omvou. Die hooffunksie van die klas konstrueer \'n instansie van Meester en noem die loopToetse-metode. Sien die templaatkode vir besonderhede.</p>';
$string['qtype_java_program'] = '<p>\'n Java skryf-\'n-program-vraag waar die student \'n volledige program as antwoord indien. Die program word vir elke toetsgeval saamgestel en uitgevoer. Daar is geen toetskode nie, net stdin-toetsdata, alhoewel dit nie werklik gekontroleer word nie: caveat emptor. Die ekstra velde van die toetsgevalle word insgelyks geïgnoreer.</p>
<p>Hierdie vraagtipe word baie ondoeltreffend as daar baie toetsgevalle is, aangesien elkeen \'n volledige saamstel-en-uitvoer-siklus op die Jobe-bediener noodsaak. Dit is moontlik om alle toetse in \'n enkele Python-werkstuk te omvou, wat na die sandbox-bediener gestuur word en die program slegs een maal saamstel en dit dan op elke toetsgeval laat loop. Vir besonderhede oor hierdie benadering, sien die vraagouteurforum op coderunner.org.nz.</p>';
$string['qtype_multilanguage'] = '<p>\'n "Skryf-\'n-program"-vraagstyl waarin die student \'n antwoord in enige van die volgende tale kan indien: C, C++, Java, Python3. Die student se vraag-antwoord-boks het \'n aftrekkieslys aan die bokant, waarmee die student die taal waarin die antwoord geskryf moet word, moet kies.</p>
<p>Verdere tale kan bygevoeg word, indien dit deur die Jobe-bediener ondersteun word, deur die taalnaam by die <i>AceLang</i>-veld van die vraagwysigvorm te voeg en dan die templaat uit te brei (q.v.) om die nuwe taal te hanteer.</p>
<p>Die ingediende programkode word vir elke toetsgeval netso geloop. Die toetskode en ekstra velde van elke toetsgeval word geïgnoreer.</p>';
$string['qtype_nodejs'] = '<p>\'n JavaScript-vraagtipe, geloop met nodejs. Die toetsprogram wat uitgevoer moet word, begin met die student se antwoord. Dit word gevolg deur elk van die toetskodes op hul beurt, met \'n skeierstring wat daartussen gedruk word. As daar egter enige standaard invoer vir enige van die toetsgevalle teenwoordig is, sal \'n aparte toetslopie vir elkeen van die toetsgevalle gedoen word.</p><p>As daar enige risiko is van newe-effekte van \'n toetsgeval wat latere toetsgevalle affekteer, kan jy standaard toevoer by enige van die toetsgevalle voeg om die een-lopie-per-toetsgeval-modus te forseer.</p>';
$string['qtype_octave_function'] = '<p>\'n Vraagtipe wat \'n Octave-funksie spesifiseer wat die student in die geheel moet indien. Elke toetsgeval sal gewoonlik die studentfunksie met toetsargumente noem en die uitslag of \'n waarde, wat van die uitslag afgelei is, druk. As daar geen standaard toevoer in enige van die vrae teenwoordig is nie, bestaan die program uit die student se antwoord, die stelling <code>formaat gratis</code> en die toetskode van elke toetsgeval, plus \'n ekstra <i>disp</i> stelling om \'n skeierstring tussen toetsgevalafvoere te druk.</p><p>As daar enige standaard toevoer teenwoordig is, word elke toetsgeval apart geloop.</p>';
$string['qtype_pascal_function'] = '<p>\'n Pascal-vraagtipe waar daar van die student verwag word om \'n prosedure of funksie te skryf. Die program wat geloop moet word, bestaan uit die student se antwoord gevolg deur die CodeRunner <i>toetskode</i> in <code>begin ... einde.</code> gevou.<br>
Dit is nie \'n kombinator-vraagtipe nie, dus sal \'n aparte jobe-lopie vir elke toetsgeval gedoen word.</p>';
$string['qtype_pascal_program'] = '<p>\'n Pascal-vraagtipe waar die student se antwoord \'n volledige Pascal-program is. Die program word een maal vir elke toetsgeval saamgestel en geloop met die standaard toevoer wat in die toetsgeval verskaf is en die <i>toetskode</i> en <i>ekstra</i> velde word geïgnoreer.</p>';
$string['qtype_php'] = '<p>\'n Php-vraag waarin die student se indiening php-kode is. In die eenvoudigste geval sal die student se kode met</p><pre>
&lt;?php
</pre>begin maar <i>sal die PHP-merker nie gesluit wees nie</i>. Die rede vir die niesluiting kan gesien word deur die templaat na te gaan: die student se antwoord gevolg deur elk van die toetsgeval-toetskodes. As jy eerder die studentkode wil laat eindig deur die PHP-merker te sluit, behoort jy die templaat te wysig om die PHP-merker voor die toetsreeks te heropen.
</p><p>Die afvoer van elke toetsgeval, wat by die toetsgeval <i>verwagte</i> veld behoort te pas, sal die afvoer van die student se PHP-kode (insluitende enige inhoud buite die bestek van &lt;?php...?&gt; merkers) plus die afvoer van die toetskode wees.</p><p>Inspekteer die templaatkode (deur <i>Doelmaak</i> te kliek) om dit te verstaan.</p>';
$string['qtype_python2'] = '<p>\'n Python2-vraagtipe, wat skryf-\'n-funksie-, skryf-\'n-klas- of skryf-\'n-program-vraagtipes kan hanteer. Vir elke toetsgeval word die student-antwoordkode uitgevoer, gevolg deur \'n toetskode. Dus, as die student byvoorbeeld gevra word om \'n funksiedefinisie te skryf, sal hul definisie eerste uitgevoer word, gevolg deur die outeur-verskafde toetskode, wat gewoonlik die funksie sal noem en die uitslag of \'n waarde wat van die uitslag afgelei is, sal druk.</p>
<p>As daar geen standaard toevoere vir alle toetsgevalle gedefinieer is nie, vou die vraag al die toetse in \'n enkele lopie toe en druk dit \'n skeierstring tussen elke toetsgevalafvoer. Wees asseblief daarvan bewus dat dit nie noodwendig dieselfde is as om elke toetsgeval afsonderlik te laat loop nie. Byvoorbeeld: as daar enige globale waardes deur die studentkode gedefinieer is, sal dié hul waardes oor veelvoudige lopies hou. As dit problematies kan wees, is die maklikste manier om daar rondom te werk om een van die toetsgeval-standaard toevoervelde as \'n nie-leë waarde te definieer - dit dwing CodeRunner in \'n terugvalmodus om elke toetsgeval afsonderlik te laat loop.</p>';
$string['qtype_python3'] = '<p>\'n Python3-vraagtipe, wat skryf-\'n-funksie-, skryf-\'n-klas- of skryf-\'n-program-vraagtipes kan hanteer. Vir elke toetsgeval word die student-antwoordkode uitgevoer, gevolg deur \'n toetskode. Dus, as die student byvoorbeeld gevra word om \'n funksiedefinisie te skryf, sal hul definisie eerste uitgevoer word, gevolg deur \'n outeur-verskafde toetskode, wat gewoonlik die funksie sal noem en die uitslag of \'n waarde, wat van die uitslag afgelei is, sal druk.</p>
<p>As daar geen standaard toevoere vir alle toetsgevalle gedefinieer is nie, vou die vraag al die toetse in \'n enkele lopie toe en druk dit \'n skeierstring tussen elke toetsgevalafvoer. Wees asseblief daarvan bewus dat dit nie noodwendig dieselfde is as om elke toetsgeval afsonderlik te laat loop nie. Byvoorbeeld: as daar enige globale veranderlikes deur die studentkode gedefinieer is, sal dié hul waardes oor veelvoudige lopies hou. As dit problematies kan wees, is die maklikste manier om daar rondom te werk om een van die toetsgeval-standaard toevoervelde as \'n nie-leë waarde te definieer - dit dwing CodeRunner in \'n terugvalmodus om elke toetsgeval afsonderlik te laat loop.</p>';
$string['qtype_python3_w_input'] = '<p>\'n Python3-vraagtipe wat skryf-\'n-funksie-, skryf-\'n-klas- of skryf-\'n-program-vraagtipes kan hanteer. Dit verskil van die ietwat eenvoudiger <i>python3</i> vraagtipe daarin dat die gewoonlike python3 <i>toevoer</i> funksie vervang word met \'n doelgemaakte weergawe, wat standaard toevoer na standaard afvoer eggo soos wat dit opgebruik word. Dit het tot gevolg dat die afvoer dit wat deur studente gesien word wanneer met sleutelbordtoevoer getoets word, naboots.
Die aanbeveling is eerder vir die <i>python3</i> vraagtipe vir enige vrae wat oproepe tot <i>toevoer</i> in inleidende programmeringskursusse behels, waar studente waarskynlik verwar sal word deur die nie-eggo van standaard toevoer wanneer dit uit \'n dokument geneem word.</p><p>\'n Geringe nadeel van hierdie vraagtipe in vergelyking met die <i>python3</i> vraagtipe is dat enige foutboodskappe in die studentkode verwarrende lynnommers sal hê, aangesien die vervangende toevoerfunksie voor die studentkode ingevoeg word.</p>
<p>Vir elke
toetsgeval word die student-antwoordkode uitgevoer, gevolg deur die toetskode.
Dus, as die student byvoorbeeld gevra word om \'n funksiedefinisie te skryf,
sal hul definisie eerste uitgevoer word, gevolg deur die outeur-verskafde
toetskode, wat gewoonlik die funksie sal noem en die uitslag of \'n waarde, wat van die uitslag afgelei is, sal druk.</p>
<p>As daar geen standaard toevoere vir alle toetsgevalle gedefinieer is nie, vou die vraag al die toetse
in \'n enkele lopie toe en druk \'n stringskeier tussen elke toetsgeval-afvoer.
Wees asseblief bewus dat dit nie noodwendig dieselfde is as om elke toetsgeval
afsonderlik te laat loop nie. Byvoorbeeld: as daar enige globale veranderlikes deur die studentkode gedefinieer is, sal dié hul waardes oor die veelvoudige lopies behou.
As dit problematies kan wees, is die maklikste manier om daar rondom te werk deur een van die toetsgeval standaard toevoervelde as nie-leë waarde te definieer - dit dwing CodeRunner na \'n terugvalmodus om elke toetsgeval afsonderlik te laat loop.</p>';
$string['qtype_sql'] = '<p>\'n SQL-vraagtipe wat sqlite3 gebruik, geloop vanaf Python3. sqlite3 moet vir hierdie vraagtipe op die Jobe-bediener geïnstalleer wees.</p>
<p>Die werkgids word vir dokumente met \'n uitbreiding \'.db\' deursoek. As daar net een so \'n dokument is, word dit as die sqlite3-databasis vir alle toetse gebruik. Veelvuldige .db-dokumente reik tans \'n foutboodskap uit; \'n moontlike uitbreiding is om verskillende db-dokumente vir elke toets te gebruik, bv. in gesorteerde volgorde.</p>
<p>Vir elke toets word \'n sqlite3 bevelteks van die vorm </p>
 <pre>.mode column<br>.headers op<br>&lt;code in extra&gt;<br>&lt;student answer&gt;<br>&lt;testcode&gt;</pre>
 <p>geloop.</p>
<p>\'n Vars kopie van die db-dokument word vir elke toetsgeval gebruik.&nbsp;</p>
<p>\'n Templaatparameter <i>kolombreedtes</i>&nbsp;kan gebruik word om die verslag se kolombreedtes te stel. By verstek stel sqlite3 elke kolombreedte om die maksimum van drie getalle te wees: 10, die breedte van die opskrif, en die breedte van die eerste ry data. \'n Templaatstring soos </p><pre><code>{"columnwidths": [10, 50, 10, 5]}
</code></pre>
<p>sal in plaas daarvan kolombreedtes van 10, 50, 10 en 5 vir die eerste vier kolomme gebruik.</p>';
$string['qtype_undirected_graph'] = '<p>\'n Python3-vraagtipe wat van die student vereis om \'n ongerigte grafiek volgens \'n sekere spesifikasie te teken. Die vraagouteur moet Python3-kode skryf om die gevolglike grafiek te kontroleer.</p><p>Let daarop dat dit nie nodig is om hierdie vraagtipe vir ongerigte grafieke te gebruik nie, aangesien die funksionaliteit hoofsaaklik deur die GraphUI-invoegtoepassing verskaf word. As die grafiek-voorafverwerking, wat deur hierdie vraagtipe gedoen word, nie aan jou behoeftes voldoen nie, kan jy eerder \'n normale Python3-vraag (of enige ander taal) gebruik, die UI na GraphUI stel en die JSON-geordende weergawe van die grafiek (dieTwig STUDENT_ANSWER&nbsp; veranderlike) self analiseer. Hierdie vraagtipe verskaf egter \'n voorbeeld van hoe om die GraphUI-invoegtoepassing te gebruik. Kliek <i>Doelmaak</i>&nbsp;om die templaatkode te besigtig.</p><p>Die spesifikasie sal van die student vereis om \'n ongerigte grafiek te trek wat aan sekere vereistes voldoen, bv. \'n grafiese voorstelling van \'n stel dorpe wat deur tweerigtingpaaie verbind is. Die toetsgevalkode en/of die ekstra kode sal dan die grafiek ontleed en \'n boodskap aan die student druk, soos OK as die grafiek korrek is, of andersins \'n geskikte, leersame foutboodskap.</p><p>Die templaat vir hierdie vraag analiseer die JSON-geordende grafiek, onttrek die topologie in die vorm van \'n noduswoordeboek&nbsp;<i>grafiek</i>. Hierdie veranderlike is beskikbaar aan die toets of ekstra kode in die toetsgeval. Sleutels in die woordeboek is nodusname, indien verskaf, of andersins arbitrêre nodusidentifiserende etikette in die vorm van #1, #2, ens. Waardes in die woordeboek is lyste rante, gesorteer deur buurnodusnaam of -identifiseerder, met elke rant \'n tal (buurtID, rantetiket).</p><p>Elke inskrywing in die noduslys is van die vorm
(nodusNaamOrld, bure) waar bure \'n lys talle is (buurNodusNaamOrld, rantetiket). As nodusse name gegee word, word dit as nodusidentifiseerders gebruik, anders word die name #1, #2, ens. gebruik. Die noduslys en die buurlys word beide in volgorde van nodusnaam of -identifiseerder gesorteer.</p><p>Die templaat is \'n kombinator: die <i>toetskode</i>&nbsp;en <i>ekstra</i>&nbsp;kode word beide vir elke toetsgeval uitgevoer.</p><p>As \'n eenvoudige voorbeeld: as die spesifikasie slegs "Trek \'n ongerigte grafiek met twee nodusse genaamd A en B, met \'n rant tussen die twee nodusse" is, sou \'n geskikte toetsgeval (al is dit met onbehulpsame foutafvoer) kon wees:</p><pre>
indien gestel(grafieksleutels()) == {\'A\', \'B\'} en len(graf[\'A\']) == 1 en len(graf[\'B\']) == 1 en graf[\'A\'][0][0] == \'B\':
druk(\'OK\')
andersins:
druk(\'Nee\')
</pre>
<p>Alternatiewelik kan daar \'n stel toetsgevalle wees wat elkeen aan een van die aspekte van die spesifikasie voldoen. Byvoorbeeld: die eerste toetsgeval kan die gesorteerde sleutels druk en verwag om \'A\', \'B\' te sien. Die tweede toetsgeval kan die rante wat aan node \'A\' verbind is, druk, ensovoorts.</p>
<p>Die vraag neem die volgende templaatparameters, wat almal deur die GraphUI-invoegtoepassing herken word en die gedrag daarvan beheer.</p>
<p><ul>
<li>isfsm. Waar as die grafiek van \'n Eindigetoestand-masjien is. Indien waar, kan die grafiek \'n inkomende rant uit nêrens bevat (die beginrant) en nodusse kan gemerk word as ontvangende state (vertoon met \'n dubbele sirkel) deur te dubbelkliek. Verstek: vals.</li>
<li>is gerig. Waar as rante gerig is. Verstek: vals</li>
<li>nodusradius. Die radius van \'n nodus, in beeldelemente (pixels). Verstek: 26.</li>
<li>fontgrootte. Die fontgrootte wat gebruik word vir nodus- en rantetikette. Verstek: 20 punte.</li>
<li>teksverplasing. \'n Verplasing in beeldelemente (pixels) wat gebruik word wanneer skakeletiketteks geposisioneer word. Verstek: 4.</li>
<li>hulpkieslysteks. \'n String om te gebruik in stede van die verstek Hulp info, indien verskaf.
Geen verstek.</li>
<li>slotnodusse. Waar om te verhoed dat die gebruiker nodusse skuif. Nuttig wanneer die
antwoordboks vooraf gelaai is met \'n grafiek wat die student moet annoteer deur
nodus- of rantetikette te verander, of deur rante by te voeg/te verwyder. Let egter daarop dat nodusse steeds bygevoeg en uitgewis kan word.</li>
<li>sluitrante. Waar om te verhoed dat die gebruiker rante sleep om hul kromming
 te verander. Moontlik nuttig as die antwoordboks vooraf gelaai is met \'n grafiek wat die student moet annoteer deur die nodus- of rantetikette te verander, of deur rante by te voeg/te verwyder. Verseker ook dat rante wat deur \'n student bygevoeg word, reguit is, bv. om \'n poligoon op \'n stel gegewe punte te teken. Let daarop dat rante egter steeds bygevoeg en uitgewis kan word.</li>
</ul></p>';
$string['qtypehelp'] = 'Hulp met vraagtipe';
$string['question_type_changed'] = 'Vraagtipe word verander. Kliek OK om doelmaakvelde te herlaai, Kanselleer om jou doelgemaaktes te hou.';
$string['questioncheckboxes'] = 'Doelmaking';
$string['questioncheckboxes_help'] = 'Om die vraagtipe te doelmaak, bv. om die vraagtemplate of sandbox-parameters te wysig, kliek die \'Doelmaak\'-merkboks en lees die hulp wat op die nuut-sigbare vormelemente beskikbaar is vir meer inligting.

As die templaatontfouting-merkboks gekliek word, sal die program wat vir elke toetsgeval gegenereer word, in die afvoer vertoon word.';
$string['questionloaderror'] = 'Vraag is nie gelaai nie';
$string['questionpreview'] = 'Vraagvoorskou';
$string['questiontype'] = 'Vraagtipe';
$string['questiontype_help'] = 'Kies die spesifieke vraagtipe.

Die komboboks kies een van die ingeboude tipes, wat elkeen \'n spesifieke taal spesifiseer en, soms, \'n sandbox waarin die program uitgevoer sal word. Elke vraagtipe het \'n templaat wat definieer hoe die uitvoerbare program van die toetsgevaldata gebou word en die student se antwoord.

Die templaat kan besigtig en opsioneel doelgemaak word deur die \'Doelmaak\'-merkboks
te kliek.

As die templaatontfouting-merkboks gekliek word, sal die program wat vir elke toetsgeval gegenereer is, in die afvoer vertoon word.';
$string['questiontype_required'] = 'Jy moet die tipe vraag kies';
$string['questiontypedetails'] = 'Vraagtipebesonderhede';
$string['regexgrader'] = 'Reguliere uitdrukking';
$string['replacedollarscount'] = 'Hierdie kategorie bevat {$a} CodeRunner-vrae.';
$string['replaceexpectedwithgot'] = 'Kliek op die &lt;&lt; knoppie om die verwagte afvoer van hierdie toetsgeval met werklike afvoer te vervang.';
$string['reset'] = 'Herstel antwoord';
$string['resethover'] = 'Verwerp veranderinge en herstel antwoord na oorspronklike, vooraf gelaaide waarde';
$string['resultcolumnheader'] = 'Uitslag';
$string['resultcolumns'] = 'Uitslagkolomme';
$string['resultcolumns_help'] = 'By verstek vertoon die uitslagtabel die toetskode, stdin, verwag- en verkry-kolomme, indien die kolomme nie leeg is nie. Jy kan die verstek en/of die kolomopskrifte verander deur \'n waarde vir die uitslagkolomme in te voer (laat blanko vir die verstek gedrag).

Indien verskaf, moet die uitslagkolommeveld \'n JSON-geënkodeerde lys van kolomspesifiseerders wees. Elke kolomspesifiseerder is self \'n lys, gewoonlik met net twee of drie elemente. Die eerste element is die kolomopskrif, die tweede element is die veld van die ToetsUitslag-voorwerk wat in die kolom vertoon word en die opsionele derde element is \'n sprintf formaatstring wat gebruik word om die veld te vertoon.

Die velde beskikbaar in die standaard ToetsUitslagvoorwerp is: toetskode, stdin, verkry, ekstra, toegeken, en punt.
Toetskode, stdin, verwag en ekstra is die velde van die toetsgeval, terwyl verkry die werklike afvoer is wat gegenereer is, en toegeken en punt onderskeidelik die werklike punt wat toegeken is en die maksimum punt vir die toetsgeval is.

Per-toets templaatmerkers kan hul eie velde byvoeg, wat ook gekies kan word om vertoon te word. Dit is ook moontlik om veelvuldige velde in \'n kolom te kombineer deur ekstra velde by die spesifiseerder te voeg: dit moet die sprintf-formaatspesifiseerder voorafgaan, wat dan verpligtend word. Byvoorbeeld: om \'n Puntbreukkolom in die vorm 0.74/1.00 te vertoon, kan, byvoorbeeld, \'n kolomformaatspesifiseerder van ["Puntbreuk", "toegeken", "punt", "%.2f/%.2f"] gebruik word.

As \'n verdere spesiale geval, beteken \'n formaat van %h dat die toetsuitslagveld as gereed-vir-afvoer-HTML geneem behoort te word en nie aan verdere verwerking onderwerp behoort te word nie; dit is slegs nuttig met doelgemaakte-merkertemplate wat HTML-afvoer genereer, soos SVG-grafika.

Die verstek waarde van uitslagkolomme is [["Toets", "toetskode"], ["toevoer", "stdin"], ["Verwag", "verwag"], ["Verkry", "verkry"]].

Die verstelling van die uitslagkolomveld het geen effek as \'n kombinator-templaatmerker gebruik word nie. Die vraagouteur is dan verantwoordelik vir formatering van die uitslagtabel op enige verkose manier.';
$string['resultcolumnsnotjson'] = 'Uitslagkolomveld is nie \'n geldige JSON-string nie';
$string['resultcolumnsnotlist'] = 'Uitslagkolomveld moet \'n JSON-geënkodeerde lys kolomspesifiseerders wees';
$string['resultcolumnspecbad'] = 'Ongeldige kolomspesifiseerder gevind: elkeen moet \'n lys van twee of meer stringe wees';
$string['resultstring-abnormaltermination'] = 'Abnormale beëndiging';
$string['resultstring-compilationerror'] = 'Samestellingsfout';
$string['resultstring-illegalsyscall'] = 'Onwettige funksie-oproep';
$string['resultstring-internalerror'] = 'CoderRunner-fout (IE): lig asseblief \'n tutor in';
$string['resultstring-memorylimit'] = 'Geheueperk oorskry';
$string['resultstring-norun'] = 'Geen lopie';
$string['resultstring-outputlimit'] = 'Uitermatige afvoer';
$string['resultstring-runtimeerror'] = 'Fout';
$string['resultstring-sandboxoverload'] = 'Sandbox-bediener is oorlaai. Probeer moontlik binnekort weer?';
$string['resultstring-sandboxpending'] = 'CodeRunner-fout (PD): lig asseblief \'n tutor in';
$string['resultstring-sandboxpolicy'] = 'CodeRunner-fout (BP): lig asseblief \'n tutor in';
$string['resultstring-success'] = 'OK';
$string['resultstring-timelimit'] = 'Tydsbeperking oorskry';
$string['run_failed'] = 'Toetse kon nie geloop word nie';
$string['sampleanswerattachments'] = 'Voorbeeld-antwoordaanhegsels';
$string['sampleanswerattachments_help'] = 'As die voorbeeld-antwoord aanhegseldokumente benodig, laai dit hier op';
$string['sandboxcontrols'] = 'Sandbox';
$string['sandboxcontrols_help'] = 'Kies watter sandbox om vir die loop van studentindienings te gebruik.
VERSTEK gebruik die hoogste prioriteit sandbox beskikbaar vir die gekose taal.
Sedert Jobe alle sandbox-tipes behalwe die verouderde \'ideonesandbox\' vervang het, word die waarde \'jobesandbox\' vir normale gebruik aanbeveel en het dit beter foutboodskappe as die Jobe-bediener af is.

Jy kan ook die maksimum CPU-tyd in sekondes stel vir elke toetsgevallopie en die maksimum geheue wat \'n enkele toetsgevallopie kan gebruik (MB). \'n Blanko inskrywing gebruik die sandbox se verstek waarde (gewoonlik 5 sekondes vir die CPU-tydbeperking en \'n taalafhanklike hoeveelheid geheue), maar die verstek kan moontlik nie geskik wees vir hulpbron-veeleisende programme nie. \'n Waarde van nul vir die maksimum geheue het tot gevolg dat geen beperking toegepas word nie. Die hoeveelheid geheue wat hier gespesifiseer is, is die totale hoeveelheid wat nodig is vir die lopie, insluitende alle biblioteke, interpreteerders, VM\'s, ensovoorts.

Die \'Parameters\'-invoer word gebruik om verdere sandbox-spesifieke data deur te gee, soos kompileeropsies en API-sleutels. Dit behoort gewoonlik oopgelaat word, maar indien dit nie oopgelaat is nie, moet dit \'n geldige JSON-rekord wees. In die geval van die jobe sandbox sluit beskikbare eienskappe in: skyflimiet, stroomgrootte, numprocs, compileargs, linkargs en interpreterargs. Byvoorbeeld: <code>{"compileargs":["-std=c89"]}</code> vir \'n C-vraag sal C89-nakoming afdwing en geen ander C-opsies sal gebruik word nie. Sien die jobe-dokumentasie vir besonderhede. Sommige sandboxes (bv. die verouderde Ideone sandbox) kan stilweg enige of al hierdie verstellings ignoreer.

As die sandbox op \'jobesandbox\' gestel is, is die jobe-gasheer om vir toetsing van die vraag
te gebruik gewoonlik soos deur die administrateurverstellings vir die CodeRunner-invoegtoepassing gestel.
Dit is egter moontlik om \'n ander jobe-bediener te kies deur \'n \'jobeserver\'-parameter te definieer en ook (opsioneel) \'n \'jobeapikey\'-parameter te definieer. Byvoorbeeld: as die
\'Parameters\'-veld op <code>{"jobeserver": "myspecialjobe.com"}</code> gestel is, sal die lopie in stede aan die bediener "myspecialjobe.com" ingedien word.';
$string['sandboxerror'] = 'Fout van die sandbox [{$a->sandbox}]: {$a->message}';
$string['sandboxparams'] = 'Parameters';
$string['seethisquestioninthequestionbank'] = 'Sien hierdie vraag in die vraagbank';
$string['showcolumns'] = 'Vertoon kolomme:';
$string['showcolumns_help'] = 'Kies watter kolomme van die uitslagtabel aan studente vertoon moet word. Leë kolomme sal ongeag versteek word. Die verstek is vir meeste gebruike geskik.';
$string['showdifferences'] = 'Vertoon verskille';
$string['showsource'] = 'Templaatontfouting';
$string['sourcecodeallruns'] = 'Ontfout: bronkode uit alle toetslopies';
$string['stdin'] = 'Standaard Toevoer';
$string['stdin_help'] = 'Die standaard toevoer tot die toets, gesien deur die templaat as {{TEST.stdin}}';
$string['student_answer'] = 'Student se antwoord';
$string['supportscripts'] = 'Ondersteuningtekste';
$string['syntax_errors'] = 'Sintaksisfout(e)';
$string['table_ui_invalidjson'] = 'Tabel UI: ongeldige JSON-dinamiserig';
$string['table_ui_invalidserialisation'] = 'Tabel UI: ongeldige dinamisering';
$string['table_ui_missingparams'] = 'Tabel UI benodig templaatparameters tabel_nom_kolomme en
tabel_nom_rye.';
$string['template'] = 'Templaat';
$string['template_changed'] = 'Per-toets templaat verander - versper kombinator? [\'Kanselleer\' laat dit ontsper.]';
$string['template_help'] = 'Die templaat definieer die program(me) wat in die sandbox vir \'n gegewe studentantwoord en -toets(e) geloop word. Daar is twee tipes templaat:

 *\'n per-toets-templaat, wat \'n program definieer wat vir \'n enkele toets geloop moet word, en
*\'n \'kombinator\'-templaat, wat \'n program definieer wat al die verskillende gevalle in \'n enkele program kombineer.

Die \'is_kombinator\'-merkboks word ongemerk gelaat vir \'n per-toets-templaat en word
gemerk vir \'n kombinator-templaat. Die res van hierdie hulppaneel aanvaar dat jy \'n per-toets-templaat gebruik; sien die volledige dokumentasie vir die gebruik van kombinator-template.

Die templaat word deur die Twig-templaatenjin verwerk (sien http://twig.sensiolabs.org) in \'n konteks waarin STUDENT_ANSWER die student se antwoord is en TEST.testcode die kode vir die huidige toetsgeval is. Hierdie waardes (en ander toetsgevalwaardes soos TEST.expected, TEST.stdin, TEST.mark) kan in die templaat gevoeg word deur hulle in dubbelhakies te omvou, bv. <code>{{TEST.testcode}}</code>. Vir gebruik binne karakterkonstante stringe, behoort \'n gepaste ontsnapfunksie toegepas te word, bv. <code>{{STUDENT_ANSWER | e(\'py\')}}</code> is die studentantwoord ontsnap op \'n manier geskik vir gebruik binne Python-trippel-dubbel-aangehaalde
stringe. Ander ontsnapfunksies is <code>e(\'c\')</code>, <code>e(\'java\')</code>,
<code>e(\'matlab\')</code>. Die program wat deur Twig afgevoer word, word dan gekompileer en uitgevoer met die taal van die gekose ingeboude tipe en met stdin gestel
op TEST.stdin. Afvoer van daardie program word dan oorgedra na die gekose merker.
Sien die hulp onder \'Merkkontroles\' vir meer daaroor.

Let daarop dat, as \'n doelgemaakte per-toets-templaat gebruik word, sal daar \'n saamstel-en-uitvoer-siklus vir elke toetsgeval wees, terwyl die meeste ingeboude vraagtipes eerder \'n kombinator-templaat definieer wat alle toetsgevalle in \'n enkele lopie kombineer.


As die templaatontfouting-merkboks gekliek word, sal die program wat vir elke toetsgeval gegenereer is, in die afvoer vertoon word.';
$string['templatecontrols'] = 'Templaatkontroles';
$string['templatecontrols_help'] = 'Deur die \'Is kombinator\'-merkboks te merk, spesifiseer dat die templaat \'n kombinator-templaat is, wat die student se antwoord plus alle toetsgevalle in \'n enkele lopie kombineer (of probeer kombineer). As hierdie merkboks gemerk is, sal jy ook die waarde van die test_splitter_re -veld moet definieer, wat die PHP-reguliere uitdrukking is wat gebruik word om die afvoer van die program te skei, terug na \'n stel individuele toetslopies. Jy hoef dit egter nie te definieer as jy ook \'n templaatmerker gebruik nie, aangesien die
templaatkode in daardie geval verantwoordelik is vir die verdeling van die afvoer self, asook die merk daarvan.

Kombinator-template ontvang nie \'n TEST Twig-veranderlike nie. In plaas daarvan ontvang hulle \'n veranderlike TESTCASES, wat \'n lys van al die toetse in die vraag is. Die program word geproduseer deur die templaat wat algemeen aanvaar word om die
STUDENT_ANSWER en al die TESTCASES in \'n enkele program te kombineer, wat – wanneer dit geloop word – die toetsuitslae van elke toetsgeval afvoer, geskei deur \'n unieke string.
Die skeierstring word gedefinieer deur \'n reguliere uitdrukking gegee deur die vorm-veld \'test_splitter_re\' hieronder.

As toetsgevalle egter standaard toevoer gedefinieer het, word kombinator-template problematies. As die templaat \'n enkele program bou, wat behoort die standaard toevoer te wees? Die eenvoudigste (en verstek) oplossing is om die toetsgevalle een op \'n slag te laat loop, met die kombinator-templaat wat gebruik word om elke program te bou, deur \'n TESTCASES-veranderlike te gee wat slegs een toets bevat.
Hierdie \'truuk\' laat toe dat die kombinator-templaat \'n dubbele rol speel: dit tree op as \'n per-toetsgeval-templaat (met \'n 1-element TESTCASES-opstelling) wanneer die vraagouteur standaard toevoer verskaf, maar as \'n egte kombinator (met \'n n-element TESTCASES-opstelling) andersins. Om hierdie gedrag te verander, sodat die kombinator alle toetsgevalle ontvang, selfs wanneer stdin teenwoordig is, merk die \'Laat veelvoudige stdins\' merkboks.

As \'n lopie van die kombinator-program enige afvoer na stderr tot gevolg het, word dit as \'n lopiefout geïnterpreteer. Om te verseker dat die student punte vir soveel geldige toetse as moontlik kry, tree die stelsel op soos wat dit optree wanneer standaard toevoer teenwoordig is, en val daarop terug om elke toets afsonderlik te laat loop. Dit is egter nie toepaslik op kombinator-merkers nie, van wie vereis word om alle looptydfoute
self te hanteer en altyd \'n geldige JSON-resultaat teruggee.';
$string['templateerror'] = 'TEMPLAATFOUT';
$string['templategrader'] = 'Templaatmerker';
$string['templateparams'] = 'Templaatparameters';
$string['templateparams_help'] = 'Met die templaatparametersveld kan jy stringparameters aan \'n vraagtemplaat(e) stuur. Indien nie leeg nie, moet hierdie \'n JSON-formaatrekord wees. Die velde van die rekord kan dan binne die templaat gebruik word, waar hulle as QUESTION.parameters.&lt;&lt;param&gt;&gt; voorkom. Byvoorbeeld: as die templaatparameters

{"age": 23}

 is, sal die waarde 23 in die templaat in die plek van die templaatveranderlike ingevoer word <code>{{ QUESTION.parameters.age }}</code>.

Die stel templaatparameters wat aan die templaat oorgedra word, bestaan uit enige templaatparameters wat in die prototipe gedefinieer is met die vraagtemplaatparameters
wat saamgevoeg is. Vraagparameters kan dus prototipeparameters oorskryf, maar dit nie
uitwis nie.

Templaatparameters kan ook gebruik word om ewekansigheid met \'n vraag te verskaf.
Wanneer die vraag eerste geïnstansieer word, word die templaatparameters deur die Twig-templaatenjin gevoer om die finale JSON-weergawe te bied.
Twig se "lukrake" funksie kan gebruik word om lukrake waardes aan templaatparameters toe te ken. As die "Twig All"-merkboks gemerk is, word alle ander velde van die vraag (vraagteks, antwoord, toetsgevalle, ens.) ook deur Twig verwerk, met die templaatparameters as \'n omgewing. Dit kan tot gevolg hê dat verskillende studente verskillende lukrake variante van die vraag sien. Sien die dokumentasie vir besonderhede.';
$string['testallincategory'] = 'Toets alle vrae in hierdie kategorie';
$string['testalltitle'] = 'Toets alle vrae in hierdie konteks';
$string['testcase'] = 'Toetsgeval {$a}';
$string['testcasecontrols'] = 'Toetseienskappe:';
$string['testcasecontrols_help'] = 'As \'Gebruik as voorbeeld\' gemerk is, sal hierdie toets outomaties in die vraag se \'Byvoorbeeld:\' uitslagtabel ingesluit word.

Die \'Vertoon\' komboboks bepaal wanneer hierdie toetsgeval aan die student in die uitslagtabel vertoon word.

As \'Versteek res indien misluk\' gemerk is en die toets misluk, sal alle daaropvolgende toetse van die student versteek word, ongeag die verstelling in die \'Vertoon\' komboboks.

\'Punt\' stel die waarde van hierdie toetsgeval; slegs van betekenis as dit nie \'n \'Alles-of-niks\'-vraag is nie.

\'Sortering\' kan gebruik word om die volgorde van die toetsgevalle te verander wanneer die vraag geberg word: toetsgevalle word volgens hierdie veld gesorteer.';
$string['testcases'] = 'Toetsgevalle';
$string['testcode'] = 'Toetskode';
$string['testcode_help'] = 'Die kode vir die toets, gesien deur die templaat as {{TEST.testcode}}';
$string['testcolhdr'] = 'Toets';
$string['testingquestion'] = 'Toetsvraag {$a}';
$string['testsplitterre'] = 'Toetsverdeler (regex)';
$string['testtype'] = 'Kontroleer toetstipe vooraf';
$string['testtype_both'] = 'Beide';
$string['testtype_help'] = 'As Vooraf Nagaan ontsper is en na \'gekies\' gestel is, beheer hierdie verstelling of die toets slegs met \'n normale lopie gebruik word, slegs met \'n vooraf-nagaan-lopie, of in beide lopies.
As Vooraf Nagaan na enigiets anders as \'gekies\' gestel is, word hierdie verstelling geïgnoreer.';
$string['testtype_normal'] = 'Kontroleer slegs';
$string['testtype_precheck'] = 'Kontroleer slegs vooraf';
$string['tooshort'] = 'Antwoord is te kort om betekenisvol te wees en is sonder straftoekenning geïgnoreer';
$string['twigall'] = 'Twig almal';
$string['twigcontrols'] = 'Twig kontroles';
$string['twigcontrols_help'] = 'Daar word gewoonlik tydens Twig-uitbreiding na templaatparameters verwys in die vorm van {{QUESTION.parameters.someparam}} As die Hystemplaatparameters se merkboksie egter gemerk is, word die parameters in die Twig globale naamspasie ingehys en kan eenvoudig as {{someparam}} na verwys word.

Die Twig-makroverwerker is tradisioneel slegs op die templaat toegepas. Dit word nou ook op die templaatparameters toegepas en, as TwigAll gemerk is, op die vraagteks, voorbeeld-antwoord, voorafgelaaide antwoord en alle toetsgevalvelde, met die Twig-uitgebreide templaatparameters as omgewing. Jy sal gewoonlik TwigAll moet aansit as ewekansigheid binne die templaatparameters gebruik word.';
$string['twigerror'] = 'Twig-fout {$a}';
$string['twigerrorintest'] = 'Twig-fout wanneer hierdie toets verwerk word {$a}';
$string['type_header'] = 'CodeRunner-vraagtipe';
$string['typename'] = 'Vraagtipe';
$string['typerequired'] = 'Kies asseblief die vraagtipe (taal, formaat, ens.)';
$string['ui_fallback'] = 'Val terug op onverwerkte teksarea.';
$string['uicontrols'] = 'Toevoer UI\'s';
$string['uicontrols_help'] = 'Kies die Gebruikerkoppelvlakbeheerders vir die student en die vraagouteur se templaat.

Die Student Antwoord-aftreklys vertoon \'n lys van beskikbare invoegtoepassings. Die Ace-wysiger word gewoonlik vir koderingsvrae gebruik.
\'n Waarde van \'Geen\' kan gebruik word om slegs \'n onverwerkte teksboks te verskaf.

Die waarde \'Grafiek\' verskaf aan die gebruiker \'n eenvoudige grafiekteken-gebruikerkoppelvlak vir gebruik met vrae wat van die student vereis om \'n grafiek volgens \'n sekere spesifikasie te trek; sulke vrae sal gewoonlik \'n enkele toetsgeval hê, gemerk met \'n templaat wat reeksvoorstelling van die grafiek analiseer en \'n boodskap soos "OK" druk as die antwoord korrek is, of andersins \'n toepaslik insiggewende foutboodskap.
Templaatparameters kan óf in die prototipe, óf in die vraag gestel word om die gedrag van die Grafiekinvoegtoepassing as volg te verander: {"isdirected": false} vir niegerigte grafieke; {"isfsm": true} om inkomende rante sonder \'n beginnodus en die dubbelkliek van \'n nodus,
om dit as \'n aanvaar-staat te definieer, toe te laat; {"noderadius": 30} om, byvoorbeeld, \'n ander nodusradius in beeldelemente (pixels) te stel; {"helpmenutext": "Line1\\nLine2\\nLine3"} om die verstek hulpkieslys met \'n doelgemaakte weergawe te vervang. Ander templaatparameters word in die ingeboude directed\\_graph and undirected\\_graph vraagtipes gedokumenteer.
Die templaatparameters uit die vraag word met dié van die prototipe saamgesmelt (en oorskryf laasgenoemde) (sedert CodeRunner V3.2.2).

Die \'Tabel\'-gebruikerskoppelvlakelement, wat \'n tabel teksareas vertoon wat die student moet invul. Dit word deur die \'python3_program_testing\' vraagtipe gebruik, wat ingesluit is in die monstervrae op github. Dit neem templaatparameters van table_num_rows en table_num_columns (beide word vereis) en opsionele table_column_headers (\'n lys stringe waarmee kolomme geëtiketteer word), table_row_labels (\'n lys stringe waarmee rye geëtiketteer word) en table_column_width_percents (\'n lys van die persentasies van die tabelbreedte om aan alle kolomme toe te wys, insluitende die ry-etiketkolom, indien gespesifiseer) en table_locked_cells (\'n lys van [ry, kolom] selpare wat die gebruiker nie kan wysig nie – die ry- en kolomindekse is 0-oorsprong, maar sluit nie die ry-etiketkolom of die kolomopskrifry in nie).

Die \'Gapfiller\'- en \'Html\'-gebruikerkoppelvlakke word in die hoof CodeRunner-dokumentasie by https://github.com/trampgeek/moodle-qtype_coderunner#code-runner gedokumenteer.

Studente met swak sig of outeurs wat ordenings wil nagaan (om, byvoorbeeld, die verteenwoordiging wat deur die GraphUI gebruik word, te verstaan), kan die gebruik van alle UI-invoegtoepassings op die huidige bladsy tokkel deur Ctrl-Alt-M te tik.

Watter waarde ook al vir die student se antwoord gekies is, sal ook binne die wysigervorm van die Voorbeeld-antwoord- en die Vooraf gelaaide Antwoord-velde gebruik word.

As \'Templaat gebruik ace\' gemerk is, sal die Ace-kodewysiger beide die templaat- en die templaatparameterbokse bestuur. Andersins sal \'n onverwerkte teksboks gebruik word.';
$string['unauthorisedbulktest'] = 'Jy het nie geskikte toegang tot enige CodeRunner-vrae nie';
$string['unauthoriseddbaccess'] = 'Jy het nie magtiging om hierdie teks te gebruik nie';
$string['unknowncombinatorgraderfield'] = 'Onbekende veldnaam ({$a->fieldname}) in kombinator-merkerafvoer';
$string['unknownerror'] = '\'n Onverwagte fout het voorgekom. Die sandbox kan af wees. Probeer binnekort weer.';
$string['unserializefailed'] = 'Gebergde toetsuitslae kon nie ontorden word nie. Probeer miskien hermerk?';
$string['useace'] = 'Templaat gebruik ace';
$string['useasexample'] = 'Gebruik as voorbeeld';
$string['validateonsave'] = 'Bepaal geldigheid met berging';
$string['wrongnumberofformats'] = 'Verkeerde aantal toetsuitslae kolomformate. Verwag {$a->expected}, verkry {$a->got}';
$string['xmlcoderunnerformaterror'] = 'XML-formaatfout in coderunner-vraag';
