<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'grades', language 'af', version '4.4'.
 *
 * @package     grades
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activities'] = 'Aktiwiteite';
$string['addcategory'] = 'Voeg kategorie by';
$string['addcategoryerror'] = 'Kon nie kategorie byvoeg nie.';
$string['addexceptionerror'] = 'Iets het skeefgeloop onderwyl uitsondering vir userid:gradeitem bygevoeg is';
$string['addfeedback'] = 'Voeg terugvoer by';
$string['addgradeletter'] = 'Voeg puntletter by';
$string['addidnumbers'] = 'Voeg ID-nommers by';
$string['additem'] = 'Voeg puntitem by';
$string['additionalfeedback'] = 'Addisionele terugvoer';
$string['addoutcome'] = 'Voeg \'n uitkoms by';
$string['addoutcomeitem'] = 'Voeg \'n uitkomsitem by';
$string['addscale'] = 'Voeg \'n skaal by';
$string['adjustedweight'] = 'Gewig aangepas';
$string['aggregateextracreditmean'] = 'Gemiddeld van punte (met ekstra krediete)';
$string['aggregatemax'] = 'Hoogste punt';
$string['aggregatemean'] = 'Gemiddeld van punte';
$string['aggregatemedian'] = 'Mediaan van punte';
$string['aggregatemin'] = 'Laagste punt';
$string['aggregatemode'] = 'Modus van punte';
$string['aggregatenotonlygraded'] = 'Sluit leë punte in';
$string['aggregateonlygraded'] = 'Sluit leë punte uit';
$string['aggregateonlygraded_help'] = '\'n Leë punt is \'n punt wat in die punteboek ontbreek. Dit kan wees weens \'n opdrag wat ingedien is maar nog nie nagesien is nie of \'n toets-jou-kennis-oefening wat nog nie voltooi is nie, ensovoorts.

Hierdie instelling bepaal of leë punte nie by die aggregasie ingesluit word nie en of hulle as minimale punte getel word,  byvoorbeeld 0 vir \'n opdrag wat tussen 0 en 100 tel.';
$string['aggregateoutcomes'] = 'Sluit uitkomste by aggregasie in';
$string['aggregateoutcomes_help'] = 'Indien geaktiveer word uitkomste by die aggregasie ingesluit. Dit kan \'n onverwagte kategorietotaal tot gevolg hê.';
$string['aggregatesonly'] = 'Verander na slegs aggregate';
$string['aggregatesubcatsupgradedgrades'] = 'Let wel: Die aggregasie-instelling "Aggregaat insluitend subkategorieë" is as deel van \'n webwerfopgradering verwyder. Aangesien "Aggregaat insluitend subkategorieë" voorheen in hierdie kursus gebruik is, word daar aanbeveel dat jy hierdie verandering in die punteboek hersien.';
$string['aggregatesum'] = 'Natuurlik';
$string['aggregateweightedmean'] = 'Geweegde gemiddeld van punte';
$string['aggregateweightedmean2'] = 'Eenvoudige geweegde gemiddeld van punte';
$string['aggregation'] = 'Aggregasie';
$string['aggregation_help'] = 'Die aggregasie bepaal hoe punte in \'n kategorie gekombineer word, soos

* Gemiddeld van punte - Die som van alle punte gedeel deur die totale aantal punte
* Mediaan van punte - Die medium punt wanneer punte volgens grootte georden word
* Laagste punt
* Hoogste punt
* Puntmodus - Die punt wat die dikwelste voorkom
* Natuurlik - Die som van alle puntwaardes volgens gewig gemeet';
$string['aggregation_link'] = 'grade/aggregation';
$string['aggregationcoef'] = 'Aggregrasie-koëffisiënt';
$string['aggregationcoefextra'] = 'Ekstra krediet';
$string['aggregationcoefextra_help'] = 'As die aggregasie \'Natuurlik\' of \'Eenvoudige geweegde gemiddeld\' en die blokkie vir ekstra krediet gemerk is, word die puntitem se maksimum punt nie by die kategorie se maksimum punt getel nie. Dit kan moontlik daartoe aanleiding gee dat die maksimum punt in die kategorie behaal word sonder dat die maksimum punt in alle puntitems behaal is. As die webwerfadministrateur punte bó die maksimum ontsper het, kan daar dalk punte bó die maksimum wees.

As die aggregasie op \'Gemiddeld van punte (met ekstra krediete)\' gestel is en die ekstra krediete se waarde op groter as zero gestel is, is die ekstra krediet die faktor waarvolgens die punt vermenigvuldig word voordat dit by die totaal getel word nadat die gemiddeld bereken is.';
$string['aggregationcoefextra_link'] = 'grade/aggregation';
$string['aggregationcoefextrasum'] = 'Ekstra krediet';
$string['aggregationcoefextrasum_help'] = 'As die blokkie vir ekstra krediet gemerk is, word die puntitem se maksimum punt nie by die kategorie se maksimum punt gevoeg nie. Dit kan moontlik daartoe aanleiding gee dat die maksimum punt (of  punt bó die maksimum indien deur die webwerfadministrateur ontsper)  in die kategorie behaal word sonder dat die maksimum punt in alle puntitems behaal is.';
$string['aggregationcoefextrasum_link'] = 'grade/aggregation';
$string['aggregationcoefextrasumabbr'] = '+';
$string['aggregationcoefextraweight'] = 'Ekstra krediet se gewig';
$string['aggregationcoefextraweight_help'] = 'As die gewig van die ekstra krediet op \'n waarde hoër as zero gestel is, fungeer die punt as \'n ekstra krediet tydens aggregasie. Die getal is die faktor wat gebruik word om die punt te vermenigvuldig voordat dit by die totaal gevoeg word ten einde die gemiddeld te bereken.';
$string['aggregationcoefextraweight_link'] = 'grade/aggregation';
$string['aggregationcoefweight'] = 'Item se gewig';
$string['aggregationcoefweight_help'] = 'Die item se gewig word in die kategorie-aggregasie gebruik om die belangrikheid te bepaal van die item vergeleke met ander puntitems in dieselfde kategorie.';
$string['aggregationcoefweight_link'] = 'grade/aggregation';
$string['aggregationhintdropped'] = '( Laat val )';
$string['aggregationhintexcluded'] = '( Uitgesluit )';
$string['aggregationhintextra'] = '( Ekstra krediet )';
$string['aggregationhintnovalue'] = '( Leeg )';
$string['aggregationofa'] = 'Aggregasie van {$a}';
$string['aggregationposition'] = 'Aggregasieposisie';
$string['aggregationposition_help'] = 'Hierdie instelling bepaal of die kolomme kategorie- en kursustotaal eerste of laaste in die punteboekverslae gewys word.';
$string['aggregationsvisible'] = 'Beskikbare aggregasietipes';
$string['aggregationsvisiblehelp'] = 'Kies alle aggregasietipes wat beskikbaar moet wees. Hou die Ctrl-sleutel in om veelvoudige items te kies.';
$string['allgrades'] = 'Alle punte per kategorie';
$string['allstudents'] = 'Alle studente';
$string['allusers'] = 'Alle gebruikers';
$string['autosort'] = 'Outo-sorteer';
$string['availableidnumbers'] = 'Beskikbare ID-nommers';
$string['average'] = 'Gemiddeld';
$string['averagesdecimalpoints'] = 'Desimale in kolomgemiddelde';
$string['averagesdecimalpoints_help'] = 'Hierdie instelling bepaal die aantal desimale wat vir elke gemiddeld gewys word en of die oorkoepelende instelling vir desimale vir die kategorie of punt gebruik (geërf) is.';
$string['averagesdisplaytype'] = 'Uitbeelding van kolomgemiddelde';
$string['averagesdisplaytype_help'] = 'Hierdie instelling bepaal of die gemiddeld as werklike punte, persentasies of letters gewys word, en of die uitbeeldingstipe vir die kategorie- of puntitem gebruik (geërf) word.';
$string['backupwithoutgradebook'] = 'Rugsteun bevat nie punteboekkonfigurasie nie';
$string['badgrade'] = 'Verskafde punt is ongeldig';
$string['badlyformattedscale'] = 'Tik asseblief \'n kommageskeide lys waardes in. (Ten minste twee waardes verlang.)';
$string['baduser'] = 'Verskafde gebruiker is ongeldig';
$string['bonuspoints'] = 'Bonuspunte';
$string['bulkcheckboxes'] = 'Massa-merkblokkies';
$string['calculatedgrade'] = 'Berekende punt';
$string['calculation'] = 'Berekening';
$string['calculation_help'] = '\'n Puntberekening is \'n formule wat gebruik word om \'n punt te bepaal. Die formule moet met \'n gelykaanteken (=) begin en kan algemene wiskundige operators soos maksimum, minimum en som gebruik. Indien verlang kan ander puntitems by die berekening ingesluit word deur die ID-nommers in dubbele blokhakies in te tik.';
$string['calculation_link'] = 'grade/calculation';
$string['calculationadd'] = 'Voeg berekening by';
$string['calculationedit'] = 'Redigeer berekening';
$string['calculationsaved'] = 'Berekening gestoor';
$string['calculationview'] = 'Bekyk berekening';
$string['cannotaccessgroup'] = 'Kan nie toegang tot punte van geselekteerde groep verkry nie, jammer.';
$string['categories'] = 'Kategorieë';
$string['category'] = 'Kategorie';
$string['categoryedit'] = 'Redigeer kategorie';
$string['categoryname'] = 'Kategorienaam';
$string['categorytotal'] = 'Kategorietotaal';
$string['categorytotalfull'] = '{$a->category}-totaal';
$string['categorytotalname'] = 'Kategorietotaal se naam';
$string['changedefaults'] = 'Verander verstekinstellings';
$string['changereportdefaults'] = 'Verander verslagverstekinstellings';
$string['chooseaction'] = 'Kies \'n aksie ...';
$string['choosecategory'] = 'Kies kategorie';
$string['collapsecriterion'] = 'Vou kriteria toe';
$string['compact'] = 'Kompak';
$string['componentcontrolsvisibility'] = 'Of hierdie puntitem verskuil is al dan nie hang af van die aktiwiteitinstellings.';
$string['contract'] = 'Kontrakkategorie';
$string['contributiontocoursetotal'] = 'Bydrae tot kursustotaal';
$string['controls'] = 'Kontroles';
$string['courseavg'] = 'Kursusgemiddeld';
$string['coursegradecategory'] = 'Kursuspuntkategorie';
$string['coursegradedisplaytype'] = 'Hoe kursuspunte uitgebeeld word';
$string['coursegradedisplayupdated'] = 'Uitbeelding van kursuspunte is bygewerk.';
$string['coursegradesettings'] = 'Kursuspuntinstellings';
$string['coursename'] = 'Kursusnaam';
$string['coursescales'] = 'Kursusskale';
$string['coursesettings'] = 'Kursusinstellings';
$string['coursesettingsexplanation'] = 'Kursuspuntinstellings bepaal hoe die punteboek vir alle deelnemers aan die kursus lyk.';
$string['coursesiamtaking'] = 'Kursusse wat ek neem';
$string['coursesiamteaching'] = 'Kursusse wat ek onderrig';
$string['coursetotal'] = 'Kursustotaal';
$string['createcategory'] = 'Skep kategorie';
$string['createcategoryerror'] = 'Kon nie \'n nuwe kategorie skep nie';
$string['creatinggradebooksettings'] = 'Skep punteboekinstellings';
$string['csv'] = 'Kommageskeide waardes';
$string['currentparentaggregation'] = 'Huidige voorsaataggregasie';
$string['curveto'] = 'Kromming tot';
$string['decimalpoints'] = 'Totale desimale plekke';
$string['decimalpoints_help'] = 'Hierdie instelling bepaal die aantal desimale plekke wat vir elke punt gewys moet word. Dit het geen impak op die berekening van punte nie, wat met \'n akkuraatheid van 5 desimale plekke bereken word.';
$string['default'] = 'Verstek';
$string['defaultprev'] = 'Verstek ({$a})';
$string['deletecategory'] = 'Skrap kategorie';
$string['disablegradehistory'] = 'Skakel puntegeskiedenis af';
$string['disablegradehistory_help'] = 'Skakel historiese naspeuring van veranderings in puntverwante tabelle af. Dit kan die bediener dalk bietjie vinniger maak en spasie in die databasis spaar.';
$string['displaylettergrade'] = 'Wys letterpunte';
$string['displaypercent'] = 'Wys persentasies';
$string['displaypoints'] = 'Wys punte';
$string['displayweighted'] = 'Wys geweegde punte';
$string['droplow'] = 'Laat val die laagste';
$string['droplow_help'] = 'Hierdie instelling maak dit moontlik om \'n gespesifiseerde aantal van die laagste punte by die aggregasie uit te sluit.';
$string['droplowestvalue'] = 'Stel waarde vir laagste punte wat laat val moet word';
$string['droplowestvalues'] = 'Laat val {$a} laagste waardes';
$string['dropped'] = 'Laat val';
$string['dropxlowest'] = 'Laat val X laagstes';
$string['dropxlowestwarning'] = 'Let wel: As jy "Laat val X laagstes" gebruik, gaan puntetoekenning van die aanname uit dat alle items in die kategorie dieselfde puntwaarde het. As puntwaardes verskil, sal die resultate onberekenaar wees.';
$string['duplicatedgradeitem'] = '({$a}) (kopieer)';
$string['duplicatescale'] = 'Duplikaatskaal';
$string['edit'] = 'Redigeer';
$string['editcalculation'] = 'Redigeer berekening';
$string['editcalculationverbose'] = 'Redigeer berekening vir {$a->category} {$a->itemmodule} {$a->itemname}';
$string['editfeedback'] = 'Redigeer terugvoer';
$string['editgrade'] = 'Redigeer punt';
$string['editgradeletters'] = 'Redigeer puntletters';
$string['editoutcome'] = 'Redigeer uitkoms';
$string['editoutcomes'] = 'Redigeer uitkomste';
$string['editscale'] = 'Redigeer skaal';
$string['edittree'] = 'Opstelling';
$string['editverbose'] = 'Redigeer {$a->category} {$a->itemmodule} {$a->itemname}';
$string['enableajax'] = 'Aktiveer AJAX';
$string['enableajax_help'] = 'Voeg \'n laag AJAX-funksionaliteit by die gradeerder se verslag om sodoende algemene berekeninge te vereenvoudig en vinniger te laat loop. Afhanklik daarvan dat Javascript op die vlak van die gebruiker se blaaier aangeskakel is.';
$string['enableoutcomes'] = 'Aktiveer uitkomste';
$string['enableoutcomes_help'] = 'Indien aangeskakel kan punte aan items toegeken word deur een of meer skale te gebruik wat aan uitkomsverklarings gekoppel is.';
$string['encoding'] = 'Enkodering';
$string['encoding_help'] = 'Kies die karakterenkodering wat vir die data gebruik word. (Die standaardenkodering is UTF-8.) As die verkeerde enkodering per ongeluk gekies is, sal dit merkbaar wees wanneer data vóór intrek bekyk word.';
$string['errorcalculationbroken'] = 'Waarskynlik sirkulêre verwysing of onderbroke berekeningsformule';
$string['errorcalculationnoequal'] = 'Formule moet met gelykaanteken begin (=1+2)';
$string['errorcalculationunknown'] = 'Ongeldige formules';
$string['errorgradevaluenonnumeric'] = 'Nie-numeries vir lae of hoë punt ontvang vir';
$string['errornocalculationallowed'] = 'Berekeninge word nie vir hierdie item toegelaat nie';
$string['errornocategorisedid'] = 'Kon nie ID vind wat nie gekategoriseer is nie!';
$string['errornocourse'] = 'Kon nie kursusinligting kry nie';
$string['errorreprintheadersnonnumeric'] = 'Nie-numeriese waardes vir herdruk-opskrfte ontvang';
$string['errorsavegrade'] = 'Kon nie punt stoor nie, jammer.';
$string['errorsettinggrade'] = 'Kon nie "{$a->itemname}" punt vir gebruiker-ID {$a->userid} stoor nie';
$string['errorupdatinggradecategoryaggregateonlygraded'] = 'Kon nie die instelling "Voeg slegs punte saam wat nie leeg is nie" vir puntkategorie {$a->id} bywerk nie.';
$string['errorupdatinggradecategoryaggregateoutcomes'] = 'Kon nie die instelling "sluit uitkomste by aggegasie in" vir puntkategorie-ID {$a->id} bywerk nie';
$string['errorupdatinggradecategoryaggregation'] = 'Kon nie die aggregasietipe van puntkategorie-ID {$a->id} bywerk nie';
$string['errorupdatinggradeitemaggregationcoef'] = 'Kon nie die aggregasiekoëffisiënt (gewig of ekstra krediet) van puntitem {$a->id} bywerk nie';
$string['eventgradedeleted'] = 'Punt geskrap';
$string['eventgradeitemcreated'] = 'Puntitem geskep';
$string['eventgradeitemdeleted'] = 'Puntitem geskrap';
$string['eventgradeitemupdated'] = 'Puntitem bygewerk';
$string['eventgradelettercreated'] = 'Puntletter geskep';
$string['eventgradeletterdeleted'] = 'Puntletter geskrap';
$string['eventgradeletterupdated'] = 'Puntletter bygewerk';
$string['eventgradeviewed'] = 'Punte is in die punteboek bekyk';
$string['eventscalecreated'] = 'Skaal geskep';
$string['eventscaledeleted'] = 'Skaal geskrap';
$string['eventscaleupdated'] = 'Skaal opgegradeer';
$string['eventusergraded'] = 'Punte aan gebruiker toegeken';
$string['excluded'] = 'Uitgesluit';
$string['excluded_help'] = 'Indien gemerk sal die punt nie by enige aggregasie ingesluit word nie.';
$string['expand'] = 'Brei kategorie uit';
$string['expandcriterion'] = 'Brei kriteria uit';
$string['export'] = 'Voer uit';
$string['exportalloutcomes'] = 'Voer alle uitkomste uit';
$string['exportfeedback'] = 'Sluit terugvoer by uitvoer in';
$string['exportfeedback_desc'] = 'Hierdie kan nie tydens uitvoer oorheers word nie.';
$string['exportformatoptions'] = 'Voer formaatopsies uit';
$string['exportonlyactive'] = 'Sluit gesuspendeerde gebruikers uit';
$string['exportonlyactive_help'] = 'Sluit slegs studente by die uitvoer in wie se inskrywing aktief en nie gesuspendeer is nie';
$string['exportplugins'] = 'Voer inproppe uit';
$string['exportsettings'] = 'Voer instellings uit';
$string['exportto'] = 'Voer uit na';
$string['externalurl'] = 'Eksterne URL';
$string['externalurl_desc'] = 'As \'n eksterne punteboek gebruik word, moet die URL hier gespesifiseer word.';
$string['extracreditvalue'] = 'Ekstra kredietwaarde vir {$a}';
$string['extracreditwarning'] = 'Let wel: Om alle items vir \'n kategorie as ekstra krediet in te stel, sal hulle vir alle praktiese doeleindes van die puntberekening verwyder aangesien daar geen punttotaal sal wees nie.';
$string['feedback'] = 'Terugvoer';
$string['feedback_help'] = 'Hierdie blokkie maak dit moontlik om enige opmerkings oor die punt by te voeg.';
$string['feedbackadd'] = 'Voeg terugvoer by';
$string['feedbackedit'] = 'Redigeer terugvoer';
$string['feedbackfiles'] = 'Terugvoerlêers';
$string['feedbackforgradeitems'] = 'Terugvoer vir {$a}';
$string['feedbackhistoryfiles'] = 'Historiese terugvoerlêers';
$string['feedbacks'] = 'Terugvoere';
$string['feedbacksaved'] = 'Terugvoer gestoor';
$string['feedbackview'] = 'Bekyk terugvoer';
$string['finalgrade'] = 'Finale punt';
$string['finalgrade_help'] = 'As die oorheersblokkie gemerk is, kan \'n punt bygevoeg of gewysig word.';
$string['fixedstudents'] = 'Statiese studentekolom';
$string['fixedstudents_help'] = 'Maak dit moontlik om horisontaal deur punte te rol sonder om studente uit die oog te verloor deur die kolom staties te maak.';
$string['forceimport'] = 'Forseer invoer';
$string['forceimport_help'] = 'Forseer invoer van punte selfs al is die punte opgegradeer nadat die intreklêer uitgevoer is.';
$string['forceoff'] = 'Forseer: Af';
$string['forceon'] = 'Forseer: Aan';
$string['forelementtypes'] = 'vir die geselekteerde {$a}';
$string['forstudents'] = 'Vir studente';
$string['full'] = 'Vol';
$string['fullmode'] = 'Verander na volle besigtiging';
$string['generalsettings'] = 'Algemene instellings';
$string['grade'] = 'Punt';
$string['grade_help'] = 'Die punt om die student vir sy/haar werk te beloon';
$string['gradeadministration'] = 'Puntadministrasie';
$string['gradealreadyupdated'] = '{$a} punte is nie ingetrek nie omdat die punte in die intreklêer ouer is as dié in die nasiener se verslag. Om desondanks voort te gaan met die intrek van punte, gebruik die "forseer intrek"-opsie.';
$string['gradeanalysis'] = 'Puntontleding';
$string['gradebook'] = 'Punteboek';
$string['gradebookcalculationsfixbutton'] = 'Aanvaar puntveranderings en maak berekeningsfoute reg';
$string['gradebookcalculationsuptodate'] = 'Die berekeninge in die punteboek is op datum. Jy sal dalk hierdie bladsy moet herlaai om die veranderinge te sien.';
$string['gradebookcalculationswarning'] = 'Let wel: \'n Paar foute is bespeur in die berekening van die punte wat in die punteboek gewys word. As jou kursus nog nie begin het nie of tans aan die gang is, word daar aanbeveel dat die foute reggestel word deur op die knoppie hieronder te klik. Dit sal egter tot gevolg hê dat sommige punte verander word. As jou kursus reeds ten einde geloop het en punte reeds ingedien is, sal jy waarskynlik verkies om nie aandag aan hierdie probleem te skenk nie.

Die nuwer weergawe is {$a->currentversion}; jy gebruik tans punteboekweergawe {$a->gradebookversion}. Om \'n lys van veranderings te sien, gaan na  <a href="{$a->url}">Gradebook calculation changes</a>.';
$string['gradebookhiddenerror'] = 'Die punteboek is tans gestel om enigiets komende van studente te verberg.';
$string['gradebookhistories'] = 'Historiese punte';
$string['gradebooksetup'] = 'Opstelling van punteboek';
$string['gradeboundary'] = 'Letterpuntgrens';
$string['gradeboundary_help'] = 'Hierdie instelling bepaal die minimum persentasie waarbo die toegewese puntletter aan punte toegeken sal word.';
$string['gradecategories'] = 'Puntkategorieë';
$string['gradecategory'] = 'Puntkategorie';
$string['gradecategoryonmodform'] = 'Puntkategorie';
$string['gradecategoryonmodform_help'] = 'Hierdie instelling beheer die kategorie waarin hierdie aktiwiteit se punte in die punteboek geplaas word.';
$string['gradecategorysettings'] = 'Puntkategorie-instellings';
$string['gradedisplay'] = 'Puntuitbeelding';
$string['gradedisplaytype'] = 'Puntuitbeeldingstipe';
$string['gradedisplaytype_help'] = 'Hierdie instelling bepaal hoe punte in die nasiener- en gebruikerverslae vertoon word.

* Letter - Letters of woorde word gebruik om \'n reeks punte te verteenwoordig, soos omskryf in \'Letters\' in die opstelling van die punteboek
* Persentasie - Relatief tot maksimum en minimum punte
* Werklik - Werklike punte of skaalwaardes';
$string['gradedon'] = 'Bepunt: {$a}';
$string['gradeexport'] = 'Punteverslag';
$string['gradeexportcolumntype'] = '{$a->name} ({$a->extra})';
$string['gradeexportcustomprofilefields'] = 'Doelgemaakte profielvelde vir uitvoer van punte';
$string['gradeexportcustomprofilefields_desc'] = 'Sluit hierdie doelgemaakte profielvelde by die uitvoer van punte in, geskei deur kommas.';
$string['gradeexportdecimalpoints'] = 'Desimale plekke vir uitvoer van punte';
$string['gradeexportdecimalpoints_desc'] = 'Die getal desimale plekke wat vir eksportering gewys moet word. Dit kan tydens eksportering oorheers word.';
$string['gradeexportdisplaytype'] = 'Tipe uitbeelding vir uitvoer van punte';
$string['gradeexportdisplaytype_desc'] = 'Punte kan gewys word as werklike punte, as persentasies (in verhouding tot die minimum en maksimum punte) of as letters (A, B, C ens.) tydens eksportering. Dit kan tydens eksportering oorheers word.';
$string['gradeexportdisplaytypes'] = 'Tipes uitbeelding vir uitvoer van punte';
$string['gradeexportuserprofilefields'] = 'Gebruikerprofielvelde vir punteksportering';
$string['gradeexportuserprofilefields_desc'] = 'Sluit hierdie gebruikerprofielvelde, geskei deur kommas, by punteksportering in.';
$string['gradeforstudent'] = '{$a->student}<br />{$a->item}{$a->feedback}';
$string['gradegrademinmax'] = 'Aanvanklike minimum en maksimum punte';
$string['gradehelp'] = 'Hulp met punte';
$string['gradehistorylifetime'] = 'Historiese punte se leeftyd';
$string['gradehistorylifetime_help'] = 'Dit bepaal vir hoe lank jy historiese veranderings aan puntverwante tabelle wil hou. Daar word aanbeveel om dit vir so lank as moontlik te hou. As jy verrigtingsprobleme ervaar of beperkte spasie vir databasisse het, probeer om \'n laer waarde in te stel.';
$string['gradeimport'] = 'Intrek van punte';
$string['gradeimportfailed'] = 'Kon nie punte tydens vaslegging invoer nie. Details:';
$string['gradeitem'] = 'Puntitem';
$string['gradeitemaddusers'] = 'Moenie by bepunting insluit nie';
$string['gradeitemadvanced'] = 'Gevorderde opsies vir puntitems';
$string['gradeitemadvanced_help'] = 'Kies alle elemente wat as gevorderd  voorgehou moet word wanneer puntitems geredigeer word.';
$string['gradeitemislocked'] = 'Hierdie aktiwiteit is vasgesluit in die punteboek. Veranderings aan punte wat in hierdie aktiwiteit gedoen word, sal nie na die punteboek gekopieer word tot tyd en wyl dit ontsluit is nie.';
$string['gradeitemlocked'] = 'Bepunting gesluit';
$string['gradeitemmembersselected'] = 'Moenie by bepunting insluit nie';
$string['gradeitemminmax'] = 'Minimum en maksimum punte soos gespesifiseer in instellings vir puntitems';
$string['gradeitemnonmembers'] = 'By bepunting ingesluit';
$string['gradeitemremovemembers'] = 'Sluit in by bepunting';
$string['gradeitems'] = 'Puntitems';
$string['gradeitemsettings'] = 'Puntiteminstellings';
$string['gradeitemsinc'] = 'Puntitems wat ingesluit moet word';
$string['gradeletter'] = 'Puntletters';
$string['gradeletter_help'] = 'Puntletters is letters, A, B, C, ..., of woorde, byvoorbeeld Onderskeiding, Meriete, Slaag, ..., wat gebruik word om \'n reeks punte te verteenwoordig.';
$string['gradeletternote'] = 'Om \'n puntletter te skrap, maak bloot enige van die <br /> drie teksareas vir daardie letter skoon en klik op dien in.';
$string['gradeletteroverridden'] = 'Die verstekpuntletters is tans oorheers.';
$string['gradeletters'] = 'Puntletters';
$string['gradelocked'] = 'Punt is gesluit';
$string['gradelong'] = '{$a->grade} / {$a->max}';
$string['grademax'] = 'Maksimum punt';
$string['grademax_help'] = 'Hierdie instelling bepaal die maksimum punt wanneer waarde as punttipe gebruik word. Die maksimum punt vir \'n aktiwiteitgebaseerde item word op aktiwiteitinstellingsblad ingestel.';
$string['grademin'] = 'Minimum punt';
$string['grademin_help'] = 'Hierdie instelling bepaal die minimum punt wanneer waarde as punttipe gebruik word.';
$string['gradenotificationmessage'] = 'Jy het nuwe terugvoer oor jou werk vir "{$a}"';
$string['gradenotificationsubject'] = '';
$string['gradeoutcomeitem'] = 'Puntuitkomsitem';
$string['gradeoutcomes'] = 'Uitkomste';
$string['gradeoutcomescourses'] = 'Kursusuitkomste';
$string['gradepass'] = 'Punt om te slaag';
$string['gradepass_help'] = 'Hierdie instelling bepaal die minimum punt wat nodig is om te slaag. Die waarde word gebruik in aktiwiteit- en kursusvoltooiing, en in die punteboek, waar slaagpunte in groen en druippunte in rooi uitgelig word.';
$string['gradepassgreaterthangrade'] = 'Die punt om te slaag kan nie groter wees as die maksimum moontlike punt {$a} nie';
$string['gradepointdefault'] = 'Verstekpuntwaarde';
$string['gradepointdefault_help'] = 'Hierdie instelling bepaal die verstekwaarde van die punt wat in \'n puntitem beskikbaar is.';
$string['gradepointdefault_validateerror'] = 'Hierdie instelling moet \'n heelgetal tussen 1 en die maksimum puntwaarde wees.';
$string['gradepointmax'] = 'Maksimum puntwaarde';
$string['gradepointmax_help'] = 'Hierdie instelling bepaal die maksimum puntwaarde wat in \'n aktiwiteit beskikbaar is.';
$string['gradepointmax_validateerror'] = 'Hierdie instelling moet \'n heelgetal tussen 1 en 10 000 wees.';
$string['gradepreferences'] = 'Puntvoorkeure';
$string['gradepreferenceshelp'] = 'Hulp met puntvoorkeure';
$string['gradepublishing'] = 'Ontsper publisering';
$string['gradepublishing_help'] = 'Puntpublisering is \'n manier om punte via \'n URL in en uit te voer sonder om by Moodle aangemeld te wees. Indien ontsper, word administrateurs en gebruikers met toestemming om punte te publiseer (by verstek slegs gebruikers met die rol bestuurder) van publiseringsinstellings vir die uitvoer van punte in elke kursus se punteboek voorsien.';
$string['gradepublishinglink'] = 'Aflaai: {$a}';
$string['gradereport'] = 'Puntverslag';
$string['graderreport'] = 'Puntverslag';
$string['grades'] = 'Punte';
$string['gradesforuser'] = 'Punte vir {$a->user}';
$string['gradesmoduledeletionpendingwarning'] = 'Waarskuwing: Aktiwiteite word tans geskrap! Sommige punte gaan verwyder word.';
$string['gradesmoduledeletionprefix'] = '[Skrapping vind tans plaas]';
$string['gradesonly'] = 'Slegs punte word verander';
$string['gradessettings'] = 'Punte-instellings';
$string['gradetype'] = 'Punttipe';
$string['gradetype_help'] = 'Daar is 4 tipes punte:

* Geen - Geen puntetoekenning moontlik nie
* Waarde - \'n Numeriese waarde met \'n maksimum en minimum
* Skaal - \'n Item in \'n lys
* Teks - Slegs terugvoer

\'n Aggregaat kan slegs vir die waarde- en skaalpunte bereken word. Die tipe punt vir \'n aktiwiteitgebaseerde puntitem word op die aktiwiteitinstellingsblad ingestel.';
$string['gradevaluetoobig'] = 'Een van die puntwaardes is groter as die toegelate maksimum punt van {$a}';
$string['gradeview'] = 'Bekyk punt';
$string['gradewasmodifiedduringediting'] = 'Die punt wat vir {$a->itemname} vir {$a->username} ingetik is, is geïgnoreer omdat dit meer onlangs deur iemand anders bygewerk is.';
$string['gradeweighthelp'] = 'Hulp met punte se gewig';
$string['gradingmodulename'] = 'Bepunting ({$a})';
$string['groupavg'] = 'Groepgemiddeld';
$string['hidden'] = 'Verskuil';
$string['hidden_help'] = 'Indien gemerk, word punte vir studente verskuil. \'n "Verskuil tot"-datum kan, indien verlang, gestel word sodat punte eers na afhandeling van die merkproses vrygestel word.';
$string['hiddenasdate'] = 'Wys indieningsdatum vir verskuilde punte';
$string['hiddenasdate_help'] = 'As gebruiker nie verskuilde punte kan sien nie, wys indieningsdatum in plaas van  \'-\'.';
$string['hiddenuntil'] = 'Verskuil tot';
$string['hiddenuntildate'] = 'Verskuil tot: {$a}';
$string['hideadvanced'] = 'Verskuil gevorderde kenmerke';
$string['hideaverages'] = 'Verskuil gemiddelde';
$string['hidecalculations'] = 'Verskuil berekeninge';
$string['hidecategory'] = 'Verskuil';
$string['hideeyecons'] = 'Verberg vertoon/verberg ikone';
$string['hidefeedback'] = 'Verskuil terugvoer';
$string['hideforcedsettings'] = 'Verskuil geforseerde instellings';
$string['hideforcedsettings_help'] = 'Moenie geforseerde instellings in bepuntings UI wys nie.';
$string['hidegroups'] = 'Verskuil groepe';
$string['hidelocks'] = 'Verberg slotte';
$string['hidenooutcomes'] = 'Wys uitkomste';
$string['hidequickfeedback'] = 'Verberg blitsterugvoer';
$string['hideranges'] = '';
$string['hidetotalifhiddenitems'] = 'Verskuil totale as hulle verskuilde items bevat';
$string['hidetotalifhiddenitems_help'] = 'Hierdie instelling bepaal of totale wat verskuilde puntitems bevat aan studente gewys of met \'n koppelteken (-) vervang word. Indien gewys, kan die totaal bereken word deur die verskuilde items óf in óf uit te sluit.

As verskuilde items uitgesluit word, sal die totaal verskil van die totaal wat deur die onderwyser in die nasienerverslag gesien word, aangesien die onderwyser altyd totale sien wat vanuit alle items bereken is, ongeag of hulle verskuil is of nie. As verskuilde items ingesluit word, kan studente dalk in staat wees om die verskuilde items te bereken.';
$string['hidetotalshowexhiddenitems'] = 'Wys totale, uitgeslote verskuilde items';
$string['hidetotalshowinchiddenitems'] = 'Wys totale, verskuilde items ingeslote';
$string['hideverbose'] = 'Verskuil {$a->category} {$a->itemmodule} {$a->itemname}';
$string['highgradeascending'] = 'Orden volgens hoë punt toenemend';
$string['highgradedescending'] = 'Orden volgens hoë punt dalend';
$string['highgradeletter'] = 'Hoog';
$string['identifier'] = 'Identifiseer gebruiker deur';
$string['idnumbers'] = 'ID nommers';
$string['ignore'] = 'Ignoreer';
$string['import'] = 'Trek in';
$string['importcsv'] = 'Trek kommageskeide waardes in';
$string['importcsv_help'] = 'Punte kan ingetrek word via \'n CSV-lêer wat as volg geformateer is:

* Elke lyn van die lêer bevat slegs een rekord
* Elke rekord is \'n reeks data geskei deur kommas of \'n alternatiewe skeikarakter
* Die eerste rekord bevat \'n lys veldname wat die formaat van die res van die lêer omskryf
* \'n Veldnaam wat data oor die gebruiker se identiteit bevat, word vereis - of gebruikernaam of ID-nommer of e-posadres

\'n Lêer met die korrekte formaat kan bekom word deur eers \'n paar punte uit te voer. Die lêer kan dan geredigeer en gestoor word as \'n CSV-lêer.';
$string['importcsv_link'] = 'grade/import/csv/index';
$string['importcustom'] = 'Trek in as doelgemaakte uitkomste (slegs hierdie kursus)';
$string['importerror'] = 'Iets het skeefgeloop. Hierdie skrip is nie met die regte parameters opgeroep nie.';
$string['importfailed'] = 'Intrek het misluk. Geen data is ingetrek nie.';
$string['importfeedback'] = 'Terugvoer oor intrek';
$string['importfile'] = 'Trek lêer in';
$string['importfilemissing'] = 'Geen lêer is ontvang nie. Gaan terug na die vorm en maak seker dat \'n geldige lêer opgelaai is.';
$string['importfrom'] = 'Trek in vanaf';
$string['importoutcomenofile'] = 'Die opgelaaide lêer is leeg of gekorrupteer. Maak asseblief seker dat dit \'n geldige lêer is. Die probleem is bespeur by lyn {$a}; dit het ontstaan weens datalyne wat nie soveel kolomme as die eerste lyn (die opskriflyn) bevat nie of omdat verwagte opskrifte in die ingetrekte lêer ontbreek. Kyk na die uitgevoerde lêer vir \'n voorbeeld van \'n lêer met geldige opskrif.';
$string['importoutcomes'] = 'Resultate van intrek';
$string['importoutcomes_help'] = 'Uitkomste kan ingetrek word via \'n CSV-lêer met \'n formaat soortgelyk aan dié van die CSV-lêer wat vir die uitvoer van uitkomste gebruik word.';
$string['importoutcomes_link'] = 'grade/outcome';
$string['importoutcomesuccess'] = 'Trek uitkomste "{$a->name}" met ID #{$a->id} in';
$string['importplugins'] = 'Trek inproppe in';
$string['importpreview'] = 'Trek voorskou in';
$string['importsettings'] = 'Trek instellings in';
$string['importskippednomanagescale'] = 'Jy het nie toestemming om \'n nuwe skaal by te voeg nie; derhalwe is uitkomste "{$a}"oorgeslaan omdat \'n nuwe skaal hiervoor geskep moet word.';
$string['importskippedoutcome'] = '\'n Uitkoms met die verkorte naam "{$a}" bestaan reeds in hierdie konteks;, die een in die ingevoerde lêer is oorgeslaan.';
$string['importstandard'] = 'Trek in as standaarduitkomste';
$string['importsuccess'] = 'Geslaagdheid met intrekking van punte';
$string['importxml'] = 'Trek XML in';
$string['includescalesinaggregation'] = 'Sluit skale by aggregasie in';
$string['includescalesinaggregation_help'] = 'Jy kan verander of skale as syfers by alle saamgevoegde punte oor alle punteboeke in alle kursusse ingesluit moet word. WAARSKUWING: Verandering van hierdie instelling sal tot gevolg hê dat alle saamgevoegde punte herbereken word.';
$string['incorrectcourseid'] = 'Kursus-ID was verkeerd';
$string['incorrectcustomscale'] = '(Verkeerde doelgemaakte skaal. Verander asseblief.)';
$string['incorrectminmax'] = 'Die minimum moet laer as die maksimum wees';
$string['inherit'] = 'Geërf';
$string['intersectioninfo'] = 'Student/Puntinligting';
$string['invalidgradeexporteddate'] = 'Die uitvoerdata is ongeldig omdat dit meer as \'n jaar gelede is, of in die toekoms is, of omdat die formaat ongeldig is.';
$string['item'] = 'Item';
$string['iteminfo'] = 'Item-info';
$string['iteminfo_help'] = 'Hierdie instelling bied ruimte om inligting oor die item in te voer. Die inligting word nêrens anders gewys nie.';
$string['itemname'] = 'Itemnaam';
$string['itemnamehelp'] = 'Die naam van hierdie item, afgedruk deur die module';
$string['items'] = 'Items';
$string['itemsedit'] = 'Redigeer puntitems';
$string['keephigh'] = 'Hou die hoogste';
$string['keephigh_help'] = 'Indien ingestel, sal hierdie opsie slegs die X hoogste punte behou, X synde die waarde wat vir hierdie opsie gekies is.';
$string['keephighestvalues'] = 'Hou die {$a} hoogste waardes';
$string['keymanager'] = 'Sleutelbestuurder';
$string['lessthanmin'] = 'Die punt wat vir {$a->itemname} vir {$a->username} ingetik is, is minder as die toegelate minimum.';
$string['letter'] = 'Letter';
$string['lettergrade'] = 'Letterpunt';
$string['lettergradenonnumber'] = 'Lae en/of hoë punt was nie-numeries vir';
$string['letterpercentage'] = 'Letter (persentasie)';
$string['letterreal'] = 'Letter (werklik)';
$string['letters'] = 'Letters';
$string['linkedactivity'] = 'Gekoppelde aktiwiteit';
$string['linkedactivity_help'] = 'Hierdie instelling spesifiseer \'n aktiwiteit waarmee hierdie uitkomste-item verbind word. Dit kan gebruik word om \'n student se prestasie te meet aan die hand van kriteria wat nie in die bepunting vir die aktiwiteit geassesseer word nie.';
$string['linktoactivity'] = 'Koppel {$a->name} aan aktiwiteit {$a->title}';
$string['lock'] = 'Sluit';
$string['locked'] = 'Gesluit';
$string['locked_help'] = 'Indien gemerk, kan punte nie meer outomaties deur die verbandhoudende aktiwiteit bygewerk word nie.';
$string['locktime'] = 'Sluit ná';
$string['locktimedate'] = 'Gesluit ná: {$a}';
$string['lockverbose'] = 'Sluit {$a->category} {$a->itemmodule} {$a->itemname}';
$string['lowest'] = 'Laagste';
$string['lowgradeletter'] = 'Lae';
$string['manualitem'] = 'Handmatige item';
$string['mapfrom'] = 'Bind vanaf';
$string['mapfrom_help'] = 'Kies die kolom in die sigblad wat die data bevat wat die gebruiker identifiseer, soos gebruikernaam, gebruiker-ID of e-posadres.';
$string['mappings'] = 'Binding van puntitems';
$string['mappings_help'] = 'Vir elke kolom punte in die sigblad, kies die ooreenstemmende puntitem waarheen die punte ingetrek moet word.';
$string['mapto'] = 'Bind na';
$string['mapto_help'] = 'Kies dieselfde identifiserende data soos in \'Bind vanaf\' gekies';
$string['max'] = 'Hoogste';
$string['maxgrade'] = 'Maksimum punt';
$string['meanall'] = 'Alle punte';
$string['meangraded'] = 'Nie-leë punte';
$string['meanselection'] = 'Punte gekies vir kolomgemiddelde';
$string['meanselection_help'] = 'Hierdie instelling bepaal of selle wat geen punte bevat nie, ingesluit moet word wanneer die gemiddeld (mediaan) vir elke kategorie of puntitem bereken word.';
$string['median'] = 'Mediaan';
$string['min'] = 'Laagste';
$string['minimum_show'] = 'Wys minimum punt';
$string['minimum_show_help'] = 'Minimum punte word gebruik om punte en gewigte te bereken. As dit nie gewys word nie, sal zero as die verstek vir die minimum punt gestel word en kan nie geredigeer word nie.';
$string['minmaxtouse'] = 'Minimum en maksimum punte gebruik in berekening';
$string['minmaxtouse_desc'] = 'Hierdie instelling bepaal of die aanvanklike minimum en maksimum punte van toe die punt toegeken is, of die minimum en maksimum punte soos gespesifiseer in die instellings vir die puntitem, gebruik moet word wanneer die punt bereken word wat in die punteboek gewys gaan word. Daar word aanbeveel dat hierdie instelling buite spitstyd gemodifiseer word aangesien alle punte herbereken sal word, wat \'n hoë las op die bediener tot gevolg kan hê.';
$string['minmaxtouse_help'] = 'Hierdie instelling bepaal of die aanvanklike minimum en maksimum punte van toe die punt toegeken is, of die minimum en maksimum punte soos gespesifiseer in die instellings vir die puntitem, gebruik moet word wanneer die punt bereken word wat in die punteboek gewys gaan word.';
$string['minmaxtouse_link'] = 'Grades_min_max';
$string['minmaxupgradedgrades'] = 'Neem kennis: Sommige punte is verander ten einde \'n inkonsekwentheid op te los wat veroorsaak is deur \'n verandering aan die minimum en maksimum punte wat gebruik is in die berekening van die punt wat gewys word. Daar word aanbeveel dat die veranderings hersien en aanvaar word.';
$string['minmaxupgradefixbutton'] = 'Los inkonsekwenthede op';
$string['minmaxupgradewarning'] = 'Neem kennis: \'n Inkonsekwentheid is bespeur in sommige punte weens \'n verandering aan die minimum en maksimum punte wat gebruik is om die punt te bereken wat in die punteboek gewys word. Daar word aanbeveel dat die inkonsekwentheid opgelos word deur op die knoppie hieronder te klik, maar dit sal tot gevolg hê dat sommige punte verander word.';
$string['missingitemtypeoreid'] = 'Skikkingsleutel (itemtype of eid) ontbreek in 2de parameter van grade_edit_tree_column_select::get_item_cell($item, $params)';
$string['missingscale'] = 'Skaal moet gekies wees';
$string['mode'] = 'Modus';
$string['modgrade'] = 'Punt';
$string['modgrade_help'] = 'Kies die tipe bepunting wat vir hierdie aktiwiteit gebruik word. As "skaal" gekies is, kan jy daarna die skaal vanuit die aftrekkieslys kies. As punte gebruik word, kan jy daarna die maksimum beskikbare punt vir hierdie aktiwiteit intik.';
$string['modgradecantchangegradetype'] = 'Jy kan nie die tipe verander nie aangesien punte reeds vir hierdie item bestaan.';
$string['modgradecantchangegradetypemsg'] = 'Sommige punte is reeds toegeken, daarom kan die punttipe nie verander word nie. As jy die maksimum punt wil verander, moet jy eers kies of bestaande punte se skale herbereken moet word of nie.';
$string['modgradecantchangegradetyporscalemsg'] = 'Sommige punte is reeds toegeken; dus kan die punttipe en skaal nie verander word nie.';
$string['modgradecantchangeratingmaxgrade'] = 'Jy kan nie die maksimum punt verander wanneer punte reeds bestaan vir \'n aktiwiteit met waardebepalings nie.';
$string['modgradecantchangescale'] = 'Jy kan nie die skaal verander nie omdat punte vir hierdie item reeds bestaan.';
$string['modgradecategorycantchangegradetypemsg'] = 'Hierdie kategorie het verbandhoudende puntitems wat oorheers is. Gevolglik is sommige punte reeds toegeken en daarom kan die tipe punt nie verander word nie. As jy die maksimum punt wil verander, moet jy eers kies of die skale van bestaande punte herbereken moet word of nie.';
$string['modgradecategorycantchangegradetyporscalemsg'] = 'Hierdie kategorie het verbandhoudende puntitems wat oorheers is. Gevolglik is sommige punte reeds toegeken en daarom kan die tipe punt en skaal nie verander word nie.';
$string['modgradecategoryrescalegrades'] = 'Herbereken skale van oorheersde punte';
$string['modgradecategoryrescalegrades_help'] = 'Wanneer die maksimum punte in \'n punteboekitem verander word, moet jy spesifiseer of dit sal veroorsaak dat die bestaande persentasiepunte ook gaan verander of nie.

As dit op "Ja" gestel word, sal die skale van enige oorheersde punte herbereken word sodat die persentasiepunt dieselfde bly.

Byvoorbeeld, as hierdie opsie as "Ja" gestel is, sal die verandering van \'n item se maksimum punt van 10 tot 20 veroorsaak dat \'n punt van 6/10 (60%) se skaal herbereken word as 12/20 (60%). As hierdie opsie as "Nee" gestel is, sal die punt onveranderd bly wat sal vereis dat die puntitems handmatig aangepas moet word om die korrekte punte te verseker.';
$string['modgradedonotmodify'] = 'Moenie bestaande punte modifiseer nie';
$string['modgradeerrorbadpoint'] = 'Ongeldige puntwaarde. Dit moet \'n heelgetal tussen 1 en {$a} wees.';
$string['modgradeerrorbadscale'] = 'Ongeldige skaal gekies. Maak asseblief seker dat jy \'n skaal vanuit die keuses hieronder kies.';
$string['modgrademaxgrade'] = 'Maksimum punt';
$string['modgraderescalegrades'] = 'Herbereken bestaande punte se skale';
$string['modgraderescalegrades_help'] = 'Wanneer die maksimum punte in \'n punteboekitem verander word, moet jy spesifiseer of dit sal veroorsaak dat die bestaande persentasiepunte ook gaan verander of nie.

As dit op "Ja" gestel word, sal die skale van enige bestaande punte herbereken word sodat die persentasiepunt dieselfde bly.

Byvoorbeeld, as hierdie opsie as "Ja" gestel is, sal die verandering van \'n item se maksimum punt van 10 tot 20 veroorsaak dat \'n punt van 6/10 (60%) se skaal herbereken word as 12/20 (60%). As hierdie opsie as "Nee" gestel is, sal die punt van 6/10 (60%) na 6/20 (30%) verander wat sal vereis dat die puntitems handmatig aangepas moet word om die korrekte punte te verseker.';
$string['modgradetype'] = 'Tipe';
$string['modgradetypenone'] = 'Niks';
$string['modgradetypepoint'] = 'Punt';
$string['modgradetypescale'] = 'Skaal';
$string['morethanmax'] = 'Die punt wat vir {$a->itemname} vir {$a->username} ingetik is, is meer as die toegelate maksimum.';
$string['moveselectedto'] = 'Verskuif geselekteerde items na';
$string['movingelement'] = 'Verskuif {$a} tans';
$string['multfactor'] = 'Vermenigvuldiger';
$string['multfactor_help'] = '\'n Vermenigvuldiger is die faktor waarvolgens alle punte vir hierdie puntitem vermenigvuldig sal word, met \'n maksimum waarde van die maksimum punt. Byvoorbeeld, as die vermenigvuldiger 2 is en die maksimum punt 100 is, sal alle punte onder 50 met 2 vermenigvuldig word, en all punte bó 50 na 100 verander word.';
$string['multfactorvalue'] = 'Waarde van vermenigvuldiger vir {$a}';
$string['mustchooserescaleyesorno'] = 'Jy moet kies of die skale van bestaande punte herbereken moet word of nie.';
$string['mygrades'] = 'Gebruikerkieslys se skakels na punte';
$string['mygrades_desc'] = 'Hierdie instelling maak die opsie om vanuit die gebruikerkieslys met \'n eksterne punteboek te verbind moontlik.';
$string['mypreferences'] = 'My voorkeure';
$string['myreportpreferences'] = 'My verslagvoorkeure';
$string['neverdeletehistory'] = 'Moet nooit historiese data skrap nie';
$string['newcategory'] = 'Nuwe kategorie';
$string['newitem'] = 'Nuwe puntitem';
$string['newoutcomeitem'] = 'Nuwe uitkomste-item';
$string['no'] = 'Nee';
$string['nocategories'] = 'Puntkategorieë kon nie vir hierdie kursus bygevoeg of gevind word nie';
$string['nocategoryname'] = 'Geen kategorienaam verstrek nie';
$string['nocategoryview'] = 'Geen kategorie vir besigtiging nie';
$string['nocourses'] = 'Daar is nog nie enige kursusse nie';
$string['noforce'] = 'Moenie forseer nie';
$string['nogradeletters'] = 'Geen puntletters ingestel nie';
$string['nogradesreturned'] = 'Geen punte ingedien nie';
$string['noidnumber'] = 'Geen ID nommer';
$string['nolettergrade'] = 'Geen letterpunt vir';
$string['nomode'] = 'n.v.t.';
$string['nonnumericweight'] = 'Nie-numeriese waarde ontvang vir';
$string['nonunlockableverbose'] = 'Hierdie punt kan nie ontsluit word alvorens {$a->itemname} ontsluit is nie.';
$string['nonweightedpct'] = 'nie-geweegde %';
$string['nooutcome'] = 'Geen uitkomste nie';
$string['nooutcomes'] = 'Uitkomsitems moet met \'n kursus se uitkomste verbind word, maar daar is geen uitkomste vir hierdie kursus nie. Wil jy een byvoeg?';
$string['nopermissiontoresetweights'] = 'Geen toestemming om beswaring terug te stel nie';
$string['nopublish'] = 'Moenie publiseer nie';
$string['noreports'] = 'Jy is nie ingeskryf vir of onderrig nie enige kursusse op hierdie webwerf nie.';
$string['norolesdefined'] = 'Geen rolle omskryf in Administrasie > Punte > Algemene instellings > Gegradeerde rolle';
$string['noscales'] = 'Uitkomste moet gekoppel wees aan \'n kursusskaal of globale skaal, maar daar is geen. Wil jy een byvoeg?';
$string['noselectedcategories'] = 'geen kategorieë is gekies nie';
$string['noselecteditems'] = 'geen items is gekies nie';
$string['notenrolled'] = 'Jy is nie tans vir enige kursusse ingeskryf nie';
$string['notteachererror'] = 'Jy moet \'n onderwyser wees om hierdie kenmerk te gebruik.';
$string['nousersloaded'] = 'Geen gebruikers gelaai nie';
$string['nouserstograde'] = 'Geen gebruikers om te bepunt nie';
$string['numberofgrades'] = 'Aantal punte';
$string['onascaleof'] = 'op \'n skaal van {$a->grademin} tot {$a->grademax}';
$string['operations'] = 'Bewerkings';
$string['options'] = 'Opsies';
$string['others'] = 'Andere';
$string['outcome'] = 'Uitkoms';
$string['outcome_help'] = 'Hierdie instelling bepaal die uitkoms wat hierdie puntitem in die punteboek sal verteenwoordig.';
$string['outcomeassigntocourse'] = 'Wys nog \'n uitkoms aan hierdie kursus toe';
$string['outcomecategory'] = 'Skep uitkomste in kategorie';
$string['outcomecategorynew'] = 'Nuwe kategorie';
$string['outcomeconfirmdelete'] = 'Is jy seker jy wil die uitkoms "{$a}" skrap?';
$string['outcomecreate'] = 'Voeg \'n nuwe uitkoms by';
$string['outcomedelete'] = 'Skrap uitkoms';
$string['outcomefullname'] = 'Volle naam';
$string['outcomeitem'] = 'Uitkomsitem';
$string['outcomeitemsedit'] = 'Redigeer uitkomsitem';
$string['outcomereport'] = 'Uitkomsverslag';
$string['outcomes'] = 'Uitkomste';
$string['outcomescourse'] = 'Uitkomste gebruik in verslag';
$string['outcomescoursecustom'] = 'Doelmaking gebruik (nie verwyderbaar nie)';
$string['outcomescoursenotused'] = 'Standaar nie gebruik nie';
$string['outcomescourseused'] = 'Standaard gebruik (kan nie verwyder word nie)';
$string['outcomescustom'] = 'Doelmaak uitkomste';
$string['outcomeshortname'] = 'Verkorte naam';
$string['outcomesstandard'] = 'Standaarduitkomste';
$string['outcomesstandardavailable'] = 'Beskikbare standaarduitkomste';
$string['outcomestandard'] = 'Standaarduitkoms';
$string['outcomestandard_help'] = '\'n Standaarduitkomste is beskikbaar oral op die webwerf, vir alle kursusse.';
$string['overallaverage'] = 'Algehele gemiddeld';
$string['overridden'] = 'Oorheers';
$string['overridden_help'] = 'Indien gemerk, kan die punt nie meer van binne die verwante aktiwiteit verander word nie.

Wanneer \'n punt in die nasiener se verslag geredigeer word, word die oorheersde merkblokkie outomaties gemerk. Dié merkie kan egter ontdoen word sodat die punt via die verwante aktiwiteit verander kan word.';
$string['overriddennotice'] = 'Jou finale punt voortspruitend uit hierdie aktiwiteit is handmatig aangepas.';
$string['overridecat'] = 'Laat handmatige oorheersing van kategoriepunte toe';
$string['overridecat_help'] = 'Versperring van hierdie instelling maak dit onmoontlik om die kategoriepunte te oorheers.';
$string['overridesitedefaultgradedisplaytype'] = 'Oorheers webwerf se verstekinstellings';
$string['overridesitedefaultgradedisplaytype_help'] = 'Indien gemerk, kan punt-letters en begrensings vir die kursus gestel word, eerder as om van die webwerf se verstekinstellings gebruik te maak.';
$string['overrideweightofa'] = 'Oorheers gewig van {$a}';
$string['parentcategory'] = 'Moederkategorie';
$string['pctoftotalgrade'] = '% van totale punt';
$string['percent'] = 'Persent';
$string['percentage'] = 'Persentasie';
$string['percentageletter'] = 'Persentasie (letter)';
$string['percentagereal'] = 'Persentasie (werklik)';
$string['percentascending'] = 'Orden stygend volgens persentasie';
$string['percentdescending'] = 'Orden dalend volgens persentasie';
$string['percentshort'] = '%';
$string['plusfactor'] = 'Kompensering';
$string['plusfactor_help'] = 'Kompensering is \'n syfer wat by elke punt vir hierdie puntitem getel word, nadat die vermenigvuldiger toegepas is.';
$string['plusfactorvalue'] = 'Kompensasiewaarde vir {$a}';
$string['points'] = 'punte';
$string['pointsascending'] = 'Orden stygend volgens punte';
$string['pointsdescending'] = 'Orden dalend volgens punte';
$string['positionfirst'] = 'Eerste';
$string['positionlast'] = 'Laaste';
$string['preferences'] = 'Voorkeure';
$string['prefgeneral'] = 'Algemeen';
$string['prefletters'] = 'Puntletters en grense';
$string['prefrows'] = 'Spesiale rye';
$string['prefshow'] = 'Wys/verberg wipkringe';
$string['previewrows'] = 'Kry \'n voorskou van rye';
$string['privacy:metadata:categorieshistory'] = '\'n Rekord van vorige weergawes van puntkategorieë';
$string['privacy:metadata:filepurpose'] = 'Terugvoerlêers in die punteboek vir \'n gebruiker gestoor.';
$string['privacy:metadata:grade_import_newitem'] = 'Tydelike tabel vir berging van new grade_item names vanuit ingetrekde grade';
$string['privacy:metadata:grade_import_newitem:importcode'] = '\'n Unieke bondelkode vir die identifisering van een bondel invoere';
$string['privacy:metadata:grade_import_newitem:importer'] = 'Gebruiker trek die data in';
$string['privacy:metadata:grade_import_newitem:itemname'] = 'Nuwe puntitem se naam';
$string['privacy:metadata:grade_import_values'] = 'Tydelike tabel vir die intrek van punte';
$string['privacy:metadata:grade_import_values:feedback'] = 'Terugvoer oor punte';
$string['privacy:metadata:grade_import_values:finalgrade'] = 'Rou waarde van punt';
$string['privacy:metadata:grade_import_values:importcode'] = '\'n Unieke bondelkode vir die identifisering van een bondel invoere';
$string['privacy:metadata:grade_import_values:importer'] = 'Gebruiker trek die data in';
$string['privacy:metadata:grade_import_values:importonlyfeedback'] = 'Merk indien slegs terugvoer ingetrek is';
$string['privacy:metadata:grade_import_values:userid'] = 'Gebruiker wie se punt ingetrek is';
$string['privacy:metadata:grades'] = '\'n Rekord van punte';
$string['privacy:metadata:grades:aggregationstatus'] = 'Die aggregasiestatus';
$string['privacy:metadata:grades:aggregationweight'] = 'Die gewig in samevoeging';
$string['privacy:metadata:grades:feedback'] = 'Die terugvoer';
$string['privacy:metadata:grades:finalgrade'] = 'Die punt';
$string['privacy:metadata:grades:information'] = 'Bykomende inligting oor die punt';
$string['privacy:metadata:grades:timemodified'] = 'Die tyd toe die punt laas gemodifiseer is';
$string['privacy:metadata:grades:userid'] = 'Die ID van die gebruiker aan wie die punt behoort';
$string['privacy:metadata:grades:usermodified'] = 'Die ID van die gebruiker wat laas die rekord gemodifiseer het';
$string['privacy:metadata:gradeshistory'] = '\'n Rekord van die vorige punte';
$string['privacy:metadata:history:loggeduser'] = 'Die ID van die gebruiker wat aangemeld was toe weergawe geskep is';
$string['privacy:metadata:history:timemodified'] = 'Die tyd toe die puntweergawe geskep is';
$string['privacy:metadata:itemshistory'] = '\'n Rekord van vorige weergawes van puntitems';
$string['privacy:metadata:outcomes'] = '\'n Rekord van uitkomste';
$string['privacy:metadata:outcomes:timemodified'] = 'Die tyd toe die rekord gemodifiseer is';
$string['privacy:metadata:outcomes:usermodified'] = 'Die gebruiker wat die rekord laas gemodifiseer het';
$string['privacy:metadata:outcomeshistory'] = '\'n Rekord van vorige weergawes van uitkomste';
$string['privacy:metadata:scale'] = '\'n Rekord van skale';
$string['privacy:metadata:scale:timemodified'] = 'Die tyd toe die rekord laas gemodifiseer is';
$string['privacy:metadata:scale:userid'] = 'Die gebruiker wat die rekord laas gemodifiseer het';
$string['privacy:metadata:scalehistory'] = '\'n Rekord van vorige weergawes van skale';
$string['privacy:path:relatedtome'] = '';
$string['privacy:request:historyactiondelete'] = 'Skrap';
$string['privacy:request:historyactioninsert'] = 'Voeg in';
$string['privacy:request:historyactionupdate'] = 'Werk by';
$string['privacy:request:unknowndeletedgradeitem'] = 'Onbekend (die puntitem is geskrap)';
$string['profilereport'] = 'Gebruikerprofielverslag';
$string['profilereport_help'] = 'Punteverslag gebruik op gebruikerprofielblad';
$string['publishing'] = 'Publisering';
$string['publishingoptions'] = 'Puntpubliseringsopsies';
$string['quickfeedback'] = 'Snelterugvoer';
$string['quickgrading'] = 'Snelbepunting';
$string['quickgrading_help'] = 'Indien ontsper, wanneer redigering aangeskakel is, verskyn \'n tekstoevoerkassie vir elke punt wat dit moontlik maak om baie punte terselfdertyd te redigeer. Veranderings word gestoor en uitgelig wanneer daar op die "Werk by"-knoppie geklik word.

Neem kennis dat wanneer \'n punt in die nasiener se verslag geredigeer word, dit as oorheers gemerk word wat daarop neerkom dat die punt nie meer van binne die verwante aktiwiteit verander kan word nie.';
$string['range'] = 'Reeks';
$string['rangedecimals'] = 'Reeks se desimale plekke';
$string['rangedecimals_help'] = 'Die getal desimale plekke wat vir die reeks gewys moet word';
$string['rangesdecimalpoints'] = 'Desimale gewys in reekse';
$string['rangesdecimalpoints_help'] = 'Hierdie instelling bepaal die getal desimale plekke wat vir elke reeks gebruik moet word en of die oorkoepelende instelling vir desimale plekke vir die kategorie of puntitem gebruik (oorgeërf) moet word.';
$string['rangesdisplaytype'] = 'Uitbeeldingstipe vir reekse';
$string['rangesdisplaytype_help'] = 'Hierdie instelling bepaal of die reeks as werklike punte, persentasies of letters gewys word en of die uitbeeldingstipe vir die kategorie of puntitem gebruik (oorgeërf) moet word.';
$string['rank'] = 'Orden';
$string['rawpct'] = 'Rou %';
$string['real'] = 'Werklik';
$string['realletter'] = 'Werklik (letter)';
$string['realpercentage'] = 'Werklik (persentasie)';
$string['recalculatinggrades'] = 'Herberekening van punte';
$string['recovergradesdefault'] = 'Herwin punte se verstrek';
$string['recovergradesdefault_help'] = 'By verstek herwin ou punte wanneer \'n gebruiker weer vir \'n kursus ingeskryf word.';
$string['refreshpreview'] = 'Verfris voorskou';
$string['regradeanyway'] = 'Herbereken punte desondanks';
$string['removeallcoursegrades'] = 'Wis alle punte uit';
$string['removeallcoursegrades_help'] = 'Indien gemerk sal alle puntitems wat handmatig by die punteboek gevoeg is, geskrap word tesame met punte en data oor oorheersde, uitgesluite, verskuilde en gesluite punte. Slegs puntitems wat met aktiwiteite geassosieer word, sal bly.';
$string['removeallcourseitems'] = 'Wis alle items en kategorieë uit';
$string['removeallcourseitems_help'] = 'Indien gemerk sal alle kategorieë en puntitems wat handmatig by die punteboek gevoeg is, geskrap word tesame met punte en data oor oorheersde, uitgesluite, verskuilde en gesluite punte. Slegs puntitems wat met aktiwiteite geassosieer word, sal bly.';
$string['report'] = 'Verslag';
$string['reportdefault'] = 'Verstekverslag ({$a})';
$string['reportplugins'] = 'Verslaginproppe';
$string['reportsettings'] = 'Verslaginstellings';
$string['reprintheaders'] = 'Verslagopskrifte';
$string['resetweights'] = 'Stel {$a->itemname} se gewigte terug';
$string['resetweightsshort'] = 'Stel gewigte terug';
$string['respectingcurrentdata'] = 'laat huidige konfigurasie onveranderd';
$string['rowpreviewnum'] = 'Kry \'n voorskou van rye';
$string['rowpreviewnum_help'] = 'Data wat vir intrek bestem is, moet eers bekyk word voordat die intrek bevestig word. Hierdie instelling bepaal hoeveel rye in die voorskou gewys word.';
$string['savechanges'] = 'Stoor veranderings';
$string['savepreferences'] = 'Stoor voorkeure';
$string['scaleconfirmdelete'] = 'Is jy seker jy wil die skaal "{$a}" skrap?';
$string['scaledpct'] = 'Skaal %';
$string['seeallcoursegrades'] = 'Sien alle kursuspunte';
$string['select'] = 'Kies {$a}';
$string['selectalloroneuser'] = 'Kies alle of een gebruiker';
$string['selectauser'] = 'Kies \'n gebruiker';
$string['selectdestination'] = 'Kies bestemming van {$a}';
$string['separator'] = 'Skeier';
$string['separator_help'] = 'Kies die skeier wat in die CSV-lêer gebruik word. (In die reël is dit \'n komma.)';
$string['sepcolon'] = 'Dubbelpunt';
$string['sepcomma'] = 'Komma';
$string['sepsemicolon'] = 'Kommapunt';
$string['septab'] = 'Tabulasie';
$string['setcategories'] = 'Stel kategorieë';
$string['setcategorieserror'] = 'Jy moet eers die kategorieë vir jou kursus instel voordat jy gewigte aan hulle kan toeken.';
$string['setgradeletters'] = 'Stel puntletters';
$string['setpreferences'] = 'Stel voorkeure';
$string['setting'] = 'Instelling';
$string['settings'] = 'Instellings';
$string['setweights'] = 'Stel gewigte';
$string['showactivityicons'] = 'Wys aktiwiteit-ikone';
$string['showactivityicons_help'] = 'Indien ontsper, word ikone langs aktiwiteitname gewys';
$string['showallhidden'] = 'Wys verskuilde';
$string['showallstudents'] = 'Wys alle studente';
$string['showanalysisicon'] = 'Wys ikoon vir puntontleding';
$string['showanalysisicon_desc'] = 'Of die puntontledingsikoon by verstek gewys moet word. As die aktiwiteitsmodule dit ondersteun, verbind die puntontledingsikoon met \'n blad waarop \'n meer gedetailleerde verduideliking van die punt en hoe dit verwerf is, verskaf word.';
$string['showanalysisicon_help'] = 'As die aktiwiteitsmodule dit ondersteun, verbind die puntontledingsikoon met \'n blad waarop \'n meer gedetailleerde verduideliking van die punt en hoe dit verwerf is, verskaf word.';
$string['showaverage'] = 'Wys gemiddeld';
$string['showaverage_help'] = 'Of \'n gemiddeldekolom gewys moet word. Let daarop dat deelnemers dalk ander se punte kan skat as die gemiddeld vanuit \'n klein aantal punte bereken word. Vir verrigtingsredes is die gemiddeld benaderd indien dit afhanklik is van enige verskuilde items.';
$string['showaverages'] = 'Wys kolomgemiddelde';
$string['showaverages_help'] = 'Indien ontsper, sal die nasiener se verslag \'n addisionele ry bevat wat die gemiddeld vir elke kategorie en puntitem bevat.';
$string['showcalculations'] = 'Wys berekeninge';
$string['showcalculations_help'] = 'Indien geaktiveer, sal \'n rekenmasjienikoon vir elke puntitem en kategorie ten tyde van redigering gewys word met \'n visuele aanwyser dat \'n puntitem bereken is.';
$string['showcontributiontocoursetotal'] = 'Wys bydrae tot kursustotaal';
$string['showcontributiontocoursetotal_help'] = 'Of \'n kolom met persentasies gewys moet word wat aantoon hoeveel elke puntitem tot die gebruiker se totale kursuspersentasie bydra (nadat weging toegepas is).';
$string['showeyecons'] = 'Wys/verberg ikone';
$string['showeyecons_help'] = 'Indien ontsper, word \'n wys/verberg-ikoon ten tyde van redigering gewys vir elke punt om die sigbaarheid daarvan vir die student te beheer.';
$string['showfeedback'] = 'Wys terugvoer';
$string['showfeedback_help'] = 'Of \'n kolom vir terugvoer gewys moet word';
$string['showgrade'] = 'Wys punte';
$string['showgrade_help'] = 'Of \'n kolom vir punte gewys moet word';
$string['showgroups'] = 'Wys groepe';
$string['showhiddenitems'] = 'Wys verskuilde items';
$string['showhiddenitems_help'] = 'Of verskuilde puntitems heeltemaal verberg word en of die name van verskuilde graaditems sigbaar is vir studente.

* Wys verskuilde - Verskuilde graaditems se name word gewys maar studente se punte is verberg
* Verskuil slegs tot - Puntitems waarvoor \'n "verskuil tot"-datum gestel is, word heeltemal verskuil tot die gestelde datum, waarna die hele item gewys word
* Moenie wys nie - Verskuilde items word geheel en al verberg';
$string['showhiddenuntilonly'] = 'Slegs verskuil tot';
$string['showingaggregatesonly'] = 'Wys slegs aggregaat';
$string['showingfullmode'] = 'Wys tans volle aansig';
$string['showinggradesonly'] = 'Wys slegs punte';
$string['showlettergrade'] = 'Wys letterpunte';
$string['showlettergrade_help'] = 'Of \'n kolom vir letterpunte gewys moet word';
$string['showlocks'] = 'Wys geslote';
$string['showlocks_help'] = 'Indien geaktiveer, wanneer redigering aangeskakel is, word \'n sluit/ontsluit-ikoon vir elke punt gewys om te bepaal of die punt outomaties aan die hand van die tersaaklike aktiwiteit bygewerk kan word of nie.';
$string['shownohidden'] = 'Moenie wys nie';
$string['shownooutcomes'] = 'Verskuil uitkomste';
$string['shownumberofgrades'] = 'Wys aantal punte in gemiddelde';
$string['shownumberofgrades_help'] = 'Indien ontsper sal die getal grade wat vir die berekening van die gemiddeld gebruik is in hakies na elke gemiddeld gewys word.';
$string['showonlyactiveenrol'] = 'Wys slegs aktiewe inskrywings';
$string['showonlyactiveenrol_help'] = 'Hierdie instelling bepaal of slegs aktiewe ingeskrewe gebruikers in die punteboekverslag gewys word. Indien geaktiveer sal opgeskorte gebruikers nie in die punteboek gewys word nie.';
$string['showpercentage'] = 'Wys persentasie';
$string['showpercentage_help'] = 'Of die persentasiewaarde van elke puntitem gewys moet word';
$string['showquickfeedback'] = 'Wys blitsterugvoer';
$string['showquickfeedback_help'] = 'Indien geaktiveer, wanneer redigering aangeskakel is, verskyn \'n teksinvoerblokkie met \'n stippellynraam vir elke punt wat dit moontlik maak om baie punte tegelyk te redigeer. Veranderings word gestoor en uitgelig wanneer die "Werk by"-knoppie geklik word.

Let daarop dat wanneer terugvoer in die nasienervlag geredigeer word, word \'n oorheersingmerker gestel wat beteken dat die terugvoer nie meer vanuit die verwante aktiwiteit geredigeer kan word nie.';
$string['showrange'] = 'Wys reekse';
$string['showrange_help'] = 'Of \'n kolom vir die reeks gewys moet word';
$string['showranges'] = 'Wys reekse';
$string['showranges_help'] = 'Indien geaktiveer, sal die nasiener se verslag \'n addisionele ry bevat wat die omvang van elke kategorie en graaditem bevat.';
$string['showrank'] = 'Wys rangorde';
$string['showrank_help'] = 'Of die posisie van die student in verhouding tot die res van die klas vir elke puntitem gewys moet word';
$string['showuserimage'] = 'Wys gebruikersprofielfoto\'s';
$string['showuserimage_help'] = 'Of gebruikersprofielfoto\'s langs name in die nasiener se verslag gewys moet word.';
$string['showverbose'] = 'Wys {$a->category} {$a->itemmodule} {$a->itemname}';
$string['showweight'] = 'Wys gewigstoekennings';
$string['showweight_help'] = 'Of \'n kolom vir die punt se gewig gewys moet word';
$string['simpleview'] = 'Enkelaansig';
$string['sitewide'] = 'Webwerfwyd';
$string['sort'] = 'orden';
$string['sortasc'] = 'Orden stygend';
$string['sortbyfirstname'] = 'Sorteer volgens voornaam';
$string['sortbylastname'] = 'Orden volgens van';
$string['sortdesc'] = 'Orden dalend';
$string['standarddeviation'] = 'Standaardafwyking';
$string['stats'] = 'Statistiek';
$string['statslink'] = 'Stats';
$string['student'] = 'Student';
$string['studentsperpage'] = 'Studente per bladsy';
$string['studentsperpage_help'] = 'Hierdie instelling bepaal die getal studente wat per blad in die nasiener se verslag gewys word.';
$string['studentsperpagereduced'] = 'Maksimum studente per blad van {$a->originalstudentsperpage} na {$a->studentsperpage} verminder. Neem in aanmerking dat die PHP-instelling dalk na max_input_vars van {$a->maxinputvars} verstel moet word.';
$string['subcategory'] = 'Normale kategorie';
$string['submissions'] = 'Indienings';
$string['submittedon'] = 'Ingedien: {$a}';
$string['sumofgradesupgradedgrades'] = 'Neem kennis: Die aggregasiemetode "Totaal van punte" is verander na "Natuurlik" as deel van \'n webwerfbywerking. Aangesien "Totaal van punte" voorheen in hierdie kursus gebruik is, word daar aanbeveel dat jy hierdie verandering in die punteboek hersien.';
$string['switchtofullview'] = 'Verwissel na volle aansig';
$string['switchtosimpleview'] = 'Verwissel na enkelaansig';
$string['topcategory'] = 'Superkategorie';
$string['total'] = 'Totaal';
$string['totalweight100'] = 'Die totale gewig is gelyk aan 100';
$string['totalweightnot100'] = 'Die totale gewig is nie gelyk aan 100 nie';
$string['turnfeedbackoff'] = 'Skakel terugvoer af';
$string['turnfeedbackon'] = 'Skakel terugvoer aan';
$string['typenone'] = 'Niks';
$string['typescale'] = 'Skaal';
$string['typescale_help'] = 'Hierdie instelling bepaal die skaal wat gebruik word wanneer die skaalpunttipe gebruik word. Die skaal vir \'n aktiwiteitgebaseerde puntitem word op die aktiwiteit se instellingsblad gestel.';
$string['typetext'] = 'Teks';
$string['typevalue'] = 'Waarde';
$string['uncategorised'] = 'Nie gekategoriseer nie';
$string['unchangedgrade'] = 'Punt onveranderd';
$string['unenrolledusersinimport'] = 'Hierdie intrek sluit die volgende punte in vir gebruikers wat nie tans vir hierdie kursus ingeskryf is nie: {$a}';
$string['unlimitedgrades'] = 'Onbeperkte punte';
$string['unlimitedgrades_help'] = 'By verstek word punte begrens deur die maksimum en minimum waardes van die puntitem. Aktivering van hierdie instelling verwyder hierdie begrensing, en maak dit moontlik om punte van meer as 100% direk in die punteboek in te tik.';
$string['unlock'] = 'Ontsluit';
$string['unlockverbose'] = 'Ontsluit {$a->category} {$a->itemmodule} {$a->itemname}';
$string['unused'] = 'Ongebruik';
$string['updatedgradesonly'] = 'Voer slegs nuwe of bygewerkde punte uit';
$string['upgradedgradeshidemessage'] = 'Wys kennisgewing van die hand';
$string['upgradedminmaxrevertmessage'] = 'Ontdoen veranderings';
$string['uploadgrades'] = 'Laai punte op';
$string['useadvanced'] = 'Gebruik gevorderde kenmerke';
$string['usedcourses'] = 'Kursusse gebruik';
$string['usedgradeitem'] = 'Puntitems gebruik';
$string['usenooutcome'] = 'Gebruik geen uitkoms nie';
$string['usenoscale'] = 'Gebruik geen skaal nie';
$string['usepercent'] = 'Gebruik persentasie';
$string['user'] = 'Gebruiker';
$string['userenrolmentsuspended'] = 'Gebruikerinskrywing opgeskort';
$string['userfields_show'] = 'Wys gebruikervelde';
$string['userfields_show_help'] = 'Wys addisionele gebruikervelde soos e-posadres in die nasienerverslag. Die spesifieke velde wat gewys word, word beheer deur die webwerfinstelling "showuseridentity".';
$string['usergrade'] = 'Gebruiker {$a->fullname} ({$a->useridnumber}) op item {$a->gradeidnumber}';
$string['userid'] = 'Gebruiker-ID';
$string['useridnumberwarning'] = 'Gebruikers sonder \'n ID-nommer word uitgesluit van die uitvoer aangesien hulle nie ingetrek kan word nie.';
$string['usermappingerror'] = 'Gebruikerbindingsfout: Kon nie gebruiker met {$a->field} van "{$a->value}" vind nie.';
$string['usermappingerrorcurrentgroup'] = 'Gebruiker is nie \'n lid van huidige groep nie.';
$string['usermappingerrormultipleusersfound'] = 'Gebruikerbindingsfout: Vele gebruikers gevind met {$a->field} van "{$a->value}". Gebruik asseblief \'n meer unieke bindingsveld.';
$string['usermappingerrorusernotfound'] = 'Gebruikerbindingsfout: Kon nie gebruiker vind nie.';
$string['userpreferences'] = 'Gebruiker se voorkeure';
$string['useweighted'] = 'Gebruik beswaarde';
$string['verbosescales'] = 'Omslagtige skale';
$string['verbosescales_help'] = '\'n Omslagtige skaal gebruik woorde eerder as syfers. Stel dit op \'Ja\' as beide numeriese en omslagtige skale ingetrek moet word. Stel dit op \'Nee\' as slegs numeriese skale ingetrek moet word.';
$string['viewbygroup'] = 'Groep';
$string['viewgrades'] = 'Bekyk punte';
$string['weight'] = 'Gewig';
$string['weight_help'] = '\'n Waarde wat gebruik word om die relatiewe waarde van velerlei  puntitems in \'n kategorie of kursus te bereken.';
$string['weightcourse'] = 'Gebruik beswaarde punte vir kursus';
$string['weightedascending'] = 'Orden stygend volgens beswaarde persentasie';
$string['weighteddescending'] = 'Orden afnemend volgens beswaarde persentasie';
$string['weightedpct'] = 'beswaarde %';
$string['weightedpctcontribution'] = 'beswaarde %-bydrae';
$string['weightofa'] = 'Gewig van {$a}';
$string['weightorextracredit'] = 'Gewig of ekstra krediet';
$string['weightoverride'] = 'gewigaanpassing';
$string['weightoverride_help'] = 'Ontmerk hierdie om \'n puntitem se gewig terug te stel na sy outomatiesberekende waarde. As hierdie gemerk word, sal dit verhoed dat die gewig outomaties aangepas word.';
$string['weights'] = 'Gewigte';
$string['weightsadjusted'] = 'Jou gewigte is aangepas tot \'n totaal van 100.';
$string['weightsedit'] = 'Redigeer gewigte en ekstra krediete';
$string['weightuc'] = 'Berekende gewig';
$string['writinggradebookinfo'] = 'Skryf punteboekinskrywings';
$string['xml'] = 'XML';
$string['yes'] = 'Ja';
$string['yourgrade'] = 'Jou punt';
