<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'block_opencast', language 'es', version '4.4'.
 *
 * @package     block_opencast
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accesspolicies'] = 'Políticas de acceso';
$string['acl_settingcontrol'] = 'Activar el control de visibilidad';
$string['acl_settingcontrol_desc'] = 'Si se activa, los profesores pueden controlar la visibilidad de un episodio de Opencast al cargarlo.';
$string['acl_settingcontrolafter'] = 'Permitir el control de la visibilidad de los episodios tras el tratamiento';
$string['acl_settingcontrolafter_desc'] = 'Si se activa, los profesores pueden controlar la visibilidad de un episodio de Opencast después de que el episodio se haya procesado en Opencast.';
$string['acl_settingcontrolgroup'] = 'Permitir restricción de grupo de episodios';
$string['acl_settingcontrolgroup_desc'] = 'Si se activa, los profesores no sólo pueden controlar la visibilidad de un episodio de Opencast para todos los usuarios del curso, sino que también pueden restringir la visibilidad a determinados grupos del curso.';
$string['acl_settingcontrolwaitingtime'] = 'Tiempo de espera para el cambio de visibilidad programado (Minutos)';
$string['acl_settingcontrolwaitingtime_desc'] = 'Define un tiempo de espera mínimo (en minutos) que debe esperar el proceso de cambio de visibilidad programado. Este lapso de tiempo se añadirá a la hora actual para la fecha de cambio de vídeo programada archivada en el formulario de añadir vídeo, también se utilizará para validar ese campo. En función de la rapidez con la que la instancia de Opencast procese los vídeos, este tiempo de espera podría configurarse .<br />NOTA: Cuando está vacío o (cero) "0", se utiliza el valor por defecto.';
$string['acl_settingheader'] = 'Controlar la visibilidad de los episodios';
$string['aclgroupdeleted'] = 'Acceso suprimido para vídeo: {$a->title}';
$string['aclnothingtobesaved'] = 'No se han introducido cambios en la visibilidad.';
$string['aclownerrole'] = 'Función de rol propietario de ACL';
$string['aclownerrole_desc'] = 'Nombre del rol que identifica al propietario de un vídeo/serie. El rol también debe especificarse en la tabla de roles. El rol debe ser permanente e incluir un marcador de posición relacionado con el usuario, por ejemplo ROLE_OWNER_[USER_EMAIL]. No debe incluir ningún marcador de posición relacionado con el curso. Si está vacío, las funcionalidades del plugin relacionadas con el propietario están deshabilitadas.';
$string['aclrolesadded'] = 'El cambio de visibilidad se ha activado para que todos los alumnos del curso puedan acceder al vídeo {$a->title}<br />Por favor, actualice el sitio después de algún tiempo para ver el estado de visibilidad actual.';
$string['aclrolesaddedgroup'] = 'El cambio de visibilidad se ha activado para que los alumnos de los grupos seleccionados puedan acceder al vídeo: {$a->title}<br />Por favor, actualice el sitio después de algún tiempo para ver el estado de visibilidad actual.';
$string['aclroleschangeerror'] = 'Error durante el cambio de visibilidad del vídeo: {$a->title}<br />Es posible que algunos cambios no se hayan guardado. Si esto ocurre repetidamente, ponte en contacto con tu equipo de soporte.';
$string['aclrolesdeleted'] = 'El cambio de visibilidad se ha activado para evitar que todos los alumnos del curso accedan al vídeo: {$a->title}<br />Por favor, actualice el sitio después de algún tiempo para ver el estado de visibilidad actual.';
$string['aclrolesname'] = 'Roles';
$string['aclrolesnamedesc'] = 'Puede utilizar marcadores de posición en el nombre del rol que se sustituyen automáticamente (<a target="_blank" href="https://moodle.docs.opencast.org/#block/general_settings/#placeholders">lista de marcadores de posición</a>). La lista de acciones debe estar separada por comas.';
$string['actions'] = 'Lista de acciones separadas por comas';
$string['addactivity_addbuttonexplanation'] = 'Los vídeos que se añaden y están disponibles en este curso no se proporcionan a sus alumnos automáticamente.<br />Usando los botones "Proporcionar", puede añadir actividades a su curso que proporcionen todos los vídeos de una serie o vídeos individuales a sus alumnos.';
$string['addactivity_addbuttontitle'] = 'Añadir actividad de proveedor de vídeo Opencast al curso';
$string['addactivity_addbuttontitlereturncourse'] = 'Añadir módulo y volver al curso';
$string['addactivity_addbuttontitlereturnoverview'] = 'Añadir módulo y volver a la vista general';
$string['addactivity_defaulttitle'] = 'Vídeos Opencast';
$string['addactivity_formactivityavailability'] = 'Restricciones de acceso a los módulos de la serie Opencast';
$string['addactivity_formactivityintro'] = 'Introducción del módulo de la serie Opencast';
$string['addactivity_formactivitysection'] = 'Sección de destino del módulo de series Opencast';
$string['addactivity_formactivitytitle'] = 'Título del módulo de la serie Opencast';
$string['addactivity_header'] = 'Proporcionar vídeos (Embebidos)';
$string['addactivity_modulecreated'] = 'El módulo de la serie \'{$a}\' ha sido añadido a este curso.';
$string['addactivity_moduleexists'] = 'Ya hay un módulo de la serie Opencast añadido a este curso. No es necesario añadir otro.';
$string['addactivity_modulenotcreated'] = 'No se ha podido crear el módulo de la serie \'{$a}\'. Por favor, inténtelo de nuevo o póngase en contacto con su administrador de Moodle.';
$string['addactivity_noemptytitle'] = 'Tiene que establecer un título para el módulo de la serie Opencast o utilizar el título por defecto ("{$a}")';
$string['addactivity_settingavailability'] = 'Configurar la disponibilidad del módulo de series';
$string['addactivity_settingavailability_desc'] = 'Si se activa, los profesores pueden establecer las condiciones de disponibilidad cuando se añade a un curso una nueva actividad de Proveedor de Vídeo Opencast para series.';
$string['addactivity_settingavailability_note'] = 'Nota: Esta función sólo está disponible si la disponibilidad está activada globalmente en la página de configuración del administrador de {$a}.';
$string['addactivity_settingdefaulttitle'] = 'Título por defecto del módulo de actividad de las series Opencast';
$string['addactivity_settingdefaulttitle_desc'] = 'El título por defecto que se utilizará cuando se añada a un curso una nueva actividad Proveedor de Vídeo Opencast para series.';
$string['addactivity_settingenabled'] = 'Activar "Añadir módulo de actividad de series Opencast"';
$string['addactivity_settingenabled_desc'] = 'Si se activa, los profesores pueden añadir un módulo de actividad de series Opencast a un curso. Este módulo de actividad apuntará a la serie Opencast del curso.';
$string['addactivity_settingheader'] = 'Añadir módulos de actividades Opencast a los cursos';
$string['addactivity_settingintro'] = 'Añadir introducción del módulo de serie';
$string['addactivity_settingintro_desc'] = 'Si se activa, los profesores pueden añadir una introducción al módulo de actividad de las series Opencast. Esta introducción se mostrará en la página de resumen del curso.';
$string['addactivity_settingsection'] = 'Elija la sección del módulo de serie';
$string['addactivity_settingsection_desc'] = 'Si está activada, los profesores pueden elegir la sección a la que se añadirá el módulo de actividad de las series Opencast.';
$string['addactivity_viewbuttonexplanation'] = 'Ha sido añadido al curso un módulo de la serie Opencast para proporcionar los vídeos disponibles en este curso.';
$string['addactivity_viewbuttontitle'] = 'Ver módulo de la serie Opencast en el curso';
$string['addactivityepisode_addbuttontitlereturncourse'] = 'Añadir módulo y volver al curso';
$string['addactivityepisode_addbuttontitlereturnoverview'] = 'Añadir módulo y volver a la vista general';
$string['addactivityepisode_addicontitle'] = 'Añadir módulo de episodio Opencast al curso';
$string['addactivityepisode_defaulttitle'] = 'Episodio Opencast';
$string['addactivityepisode_explanation'] = 'Adicionalmente, en la tabla de vídeos anterior, puede añadir módulos de episodios Opencast individuales a su curso que proporcionen una única actividad de vídeo a sus alumnos.';
$string['addactivityepisode_formactivityavailability'] = 'Restricciones de acceso al módulo de episodios Opencast';
$string['addactivityepisode_formactivityintro'] = 'Introducción del módulo Opencast';
$string['addactivityepisode_formactivitysection'] = 'Sección de destino del módulo de episodios Opencast';
$string['addactivityepisode_formactivitytitle'] = 'Título del módulo de episodios de Opencast';
$string['addactivityepisode_modulecreated'] = 'El módulo de episodio \'{$a}\' ha sido añadido a este curso.';
$string['addactivityepisode_moduleexists'] = 'Ya hay un módulo de episodios Opencast añadido a este curso. No es necesario añadir otro.';
$string['addactivityepisode_modulenotcreated'] = 'No se ha podido crear el módulo de episodio \'{$a}\'. Por favor, inténtelo de nuevo o póngase en contacto con su administrador de Moodle.';
$string['addactivityepisode_noemptytitle'] = 'Tiene que establecer un título para el módulo de episodios de Opencast o utilizar el título por defecto ("{$a}")';
$string['addactivityepisode_settingavailability'] = 'Establecer la disponibilidad del módulo de episodios';
$string['addactivityepisode_settingavailability_desc'] = 'Si se activa, los profesores pueden establecer las condiciones de disponibilidad cuando se añade un nuevo módulo de actividad de episodio Opencast a un curso.';
$string['addactivityepisode_settingenabled'] = 'Activar "Añadir módulo de actividad de episodio  Opencast"';
$string['addactivityepisode_settingenabled_desc'] = 'Si se activa, los profesores pueden añadir una actividad de proveedor de vídeo Opencast para episodios a un curso. Este módulo de actividad de episodio de Opencast apuntará a un episodio de Opencast.';
$string['addactivityepisode_settingintro'] = 'Añadir la introducción del módulo de episodios';
$string['addactivityepisode_settingintro_desc'] = 'Si se activa, los profesores pueden añadir una introducción al módulo de la actividad de episodios Opencast. Esta introducción se mostrará en la página de resumen del curso.';
$string['addactivityepisode_settingsection'] = 'Seleccione la sección del módulo de episodios';
$string['addactivityepisode_settingsection_desc'] = 'Si se activa, los profesores pueden elegir la sección a la que se añadirá el módulo de actividad de episodios Opencast.';
$string['addactivityepisode_viewicontitle'] = 'Ver módulo de episodios Opencast en el curso';
$string['addcatalog'] = 'Añadir nuevos metadatos';
$string['additional_settings'] = 'Características adicionales';
$string['addlti_addbuttonexplanation'] = 'Los vídeos que se añaden y están disponibles en este curso no se proporcionan a sus estudiantes automáticamente.<br />Aquí, puede añadir un módulo de serie Opencast LTI a su curso que proporciona todos los vídeos disponibles como una lista de serie Opencast a sus estudiantes.';
$string['addlti_addbuttontitle'] = 'Añadir módulo de la serie Opencast LTI al curso';
$string['addlti_addbuttontitlereturncourse'] = 'Añadir módulo y volver al curso';
$string['addlti_addbuttontitlereturnoverview'] = 'Añadir módulo y volver a la vista general';
$string['addlti_defaulttitle'] = 'Vídeos Opencast';
$string['addlti_errornotenabledorworking'] = 'La función "Añadir módulo de serie Opencast" no está activada o no funciona';
$string['addlti_formltiavailability'] = 'Restricciones de acceso a los módulos de la serie Opencast';
$string['addlti_formltiintro'] = 'Introducción al módulo de series Opencast';
$string['addlti_formltisection'] = 'Sección de destino del módulo de series Opencast';
$string['addlti_formltititle'] = 'Título del módulo de series Opencast';
$string['addlti_header'] = 'Proporcionar vídeos (LTI)';
$string['addlti_modulecreated'] = 'El módulo de la serie \'{$a}\' ha sido añadido a este curso.';
$string['addlti_moduleexists'] = 'Ya hay un módulo de la serie Opencast añadido a este curso. No es necesario añadir otro.';
$string['addlti_modulenotcreated'] = 'No se ha podido crear el módulo de la serie \'{$a}\'. Por favor, inténtelo de nuevo o póngase en contacto con su administrador de Moodle.';
$string['addlti_noemptytitle'] = 'Tiene que establecer un título para el módulo de la serie Opencast o utilizar el título por defecto ("{$a}")';
$string['addlti_settingavailability'] = 'Establecer la disponibilidad de los módulos de la serie';
$string['addlti_settingavailability_desc'] = 'Si se activa, los profesores pueden establecer las condiciones de disponibilidad cuando se añade un nuevo módulo de la serie Opencast LTI a un curso.';
$string['addlti_settingavailability_note'] = 'Nota: Esta función sólo está disponible si la disponibilidad está activada globalmente en la página de configuración del administrador de {$a}.';
$string['addlti_settingdefaulttitle'] = 'Título por defecto del módulo de la serie LTI';
$string['addlti_settingdefaulttitle_desc'] = 'El título predeterminado que se utilizará cuando se añada un nuevo módulo de la serie Opencast LTI a un curso.';
$string['addlti_settingenabled'] = 'Activar "Añadir módulo de la serie LTI"';
$string['addlti_settingenabled_desc'] = 'Si se activa, los profesores pueden añadir un módulo de serie LTI de Opencast a un curso. Este módulo de serie LTI apuntará a la serie Opencast del curso.';
$string['addlti_settingheader'] = 'Añadir módulos de la serie Opencast LTI a los cursos';
$string['addlti_settingintro'] = 'Añadir introducción del módulo de serie';
$string['addlti_settingintro_desc'] = 'Si se activa, los profesores pueden añadir una introducción al módulo de la serie Opencast LTI. Esta introducción se mostrará en la página de resumen del curso.';
$string['addlti_settingpreconfiguredtool'] = 'Herramienta LTI preconfigurada para módulos en serie';
$string['addlti_settingpreconfiguredtool_desc'] = 'La herramienta LTI preconfigurada que se utilizará cuando se añada un nuevo módulo de la serie Opencast LTI a un curso.';
$string['addlti_settingpreconfiguredtool_notools'] = 'No se han encontrado herramientas LTI preconfiguradas. Cree primero una herramienta LTI de la serie Opencast en la página de configuración del administrador de {$a}.';
$string['addlti_settingsection'] = 'Seleccione la sección del módulo de serie';
$string['addlti_settingsection_desc'] = 'Si está activada, los profesores pueden elegir la sección a la que se añadirá el módulo de la serie Opencast LTI.';
$string['addlti_viewbuttonexplanation'] = 'Antes se ha añadido al curso un módulo de la serie Opencast para proporcionar los vídeos disponibles en este curso.';
$string['addlti_viewbuttontitle'] = 'Ver módulo de la serie Opencast LTI en el curso';
$string['addltiepisode_addbuttontitlereturncourse'] = 'Añadir módulo y volver al curso';
$string['addltiepisode_addbuttontitlereturnoverview'] = 'Añadir módulo y volver a la vista general';
$string['addltiepisode_addicontitle'] = 'Añadir módulo de episodios Opencast al curso';
$string['addltiepisode_defaulttitle'] = 'Episodio Opencast';
$string['addltiepisode_errorepisodeuuidnotvalid'] = 'El UUID del episodio indicado no es válido';
$string['addltiepisode_errornotenabledorworking'] = 'La función "Añadir módulo de episodios Opencast" no está activada o no funciona';
$string['addltiepisode_explanation'] = 'Adicionalmente, en la tabla de vídeos anterior, puede añadir módulos de episodios Opencast individuales a su curso que proporcionen una única actividad de vídeo a sus alumnos.';
$string['addltiepisode_formltiavailability'] = 'Restricciones de acceso al módulo de episodios Opencast';
$string['addltiepisode_formltiintro'] = 'Introducción del módulo Opencast';
$string['addltiepisode_formltisection'] = 'Sección de destino del módulo de episodios Opencast';
$string['addltiepisode_formltititle'] = 'Título del módulo de episodios de Opencast';
$string['addltiepisode_modulecreated'] = 'El módulo de episodios \'{$a}\' ha sido añadido a este curso.';
$string['addltiepisode_moduleexists'] = 'Ya hay un módulo de episodios Opencast añadido a este curso. No es necesario añadir otro.';
$string['addltiepisode_modulenotcreated'] = 'No se ha podido crear el módulo de episodio \'{$a}\'. Por favor, inténtelo de nuevo o póngase en contacto con su administrador de Moodle.';
$string['addltiepisode_noemptytitle'] = 'Tiene que establecer un título para el módulo de episodios de Opencast o utilizar el título por defecto ("{$a}")';
$string['addltiepisode_settingavailability'] = 'Establecer la disponibilidad del módulo de episodios';
$string['addltiepisode_settingavailability_desc'] = 'Si se activa, los profesores pueden establecer las condiciones de disponibilidad cuando se añade un nuevo módulo de episodios de Opencast LTI a un curso.';
$string['addltiepisode_settingenabled'] = 'Habilitar "Añadir módulo de episodios LTI"';
$string['addltiepisode_settingenabled_desc'] = 'Si se activa, los profesores pueden añadir un módulo de episodio LTI de Opencast a un curso. Este módulo de episodio LTI apuntará a un episodio Opencast.';
$string['addltiepisode_settingheader'] = 'Añadir módulos de episodios de Opencast LTI a los cursos';
$string['addltiepisode_settingintro'] = 'Añadir introducción al módulo de episodios';
$string['addltiepisode_settingintro_desc'] = 'Si se activa, los profesores pueden añadir una introducción al módulo de episodios de Opencast LTI. Esta introducción se mostrará en la página de resumen del curso.';
$string['addltiepisode_settingpreconfiguredtool'] = 'Herramienta LTI preconfigurada para módulos de episodios';
$string['addltiepisode_settingpreconfiguredtool_desc'] = 'La herramienta LTI preconfigurada que se utilizará cuando se añada un nuevo módulo de episodios LTI de Opencast a un curso.';
$string['addltiepisode_settingpreconfiguredtool_notools'] = 'No se han encontrado herramientas LTI preconfiguradas. Cree primero una herramienta LTI de episodio de Opencast en la página de configuración del administrador de {$a}.';
$string['addltiepisode_settingsection'] = 'Seleccione la sección del módulo de episodios';
$string['addltiepisode_settingsection_desc'] = 'Si se activa, los profesores pueden elegir la sección a la que se añadirá el módulo de episodios de Opencast LTI.';
$string['addltiepisode_viewicontitle'] = 'Ver el módulo de episodios de Opencast en el curso';
$string['addnewcatalogfield'] = 'Se ha añadido un nuevo campo al catálogo de metadatos.';
$string['addnewtranscription'] = 'Añadir nueva transcripción';
$string['addnewtranscription_desc'] = 'Seleccione un tipo de servicio en el que su transcripción deba estar representada y, a continuación, cargue el archivo con las extensiones requeridas.<br> NOTA: Al cargar una nueva transcripción con un tipo de servicio ya cargado, se sustituye dicha transcripción, lo que puede resultar útil para editar las actuales.';
$string['addrole'] = 'Añadir nuevo rol';
$string['addvideo'] = 'Añadir vídeo';
$string['addvideonotallowed'] = 'No está permitido subir un vídeo a esta serie.';
$string['adhocfiledeletion'] = 'Eliminar archivo de vídeo de moodle';
$string['adhocfiledeletiondesc'] = 'Si está activado, el plugin intenta eliminar el archivo de vídeo del sistema de archivos de moodle justo después de que se haya cargado en el servidor de opencast. Tenga en cuenta que el archivo permanecerá en el sistema de archivos, si se utiliza dentro de otros lugares en moodle.';
$string['adminchoice_noconnection'] = '-- No se pudieron recuperar los flujos de trabajo --';
$string['adminchoice_noworkflow'] = '- Sin flujo de trabajo --';
$string['allowdownloadtranscriptionsetting'] = 'Permitir la descarga de transcripciones';
$string['allowdownloadtranscriptionsetting_desc'] = 'Cuando esté activado, el botón de descarga de transcripciones aparecerá en la página de gestión de transcripciones, mediante el cual los profesores podrán descargar el archivo de la transcripción.<br> <b>Aviso:</b>En caso de que esté utilizando Opencast 13 o posterior, debe asegurarse de que todos los requisitos previos, incluidas las funciones de LTI y los permisos de acceso a /assets/endpoint para los usuarios de LTI, estén configurados correctamente, ya que es obligatorio para realizar la llamada de LTI.';
$string['allowunassign'] = 'Permitir desasignar del curso';
$string['allowunassigndesc'] = 'Elimine la asignación de una serie de cursos para controlar la visibilidad en el selector de archivos y en las listas de cursos. Esta función sólo está disponible cuando es posible tener eventos sin series en opencast. Consulte al administrador del sistema opencast antes de activarla.';
$string['appearance_overview_settingheader'] = 'Página principal';
$string['appearance_overview_settingshowenddate'] = 'Mostrar fecha de finalización';
$string['appearance_overview_settingshowenddate_desc'] = 'Si está activada, la tabla de vídeos disponibles en la página de resumen contendrá una columna que mostrará la fecha de finalización del episodio Opencast.';
$string['appearance_overview_settingshowlocation'] = 'Mostrar ubicación';
$string['appearance_overview_settingshowlocation_desc'] = 'Si se activa, la tabla de vídeos disponibles en la página de resumen contendrá una columna que mostrará la ubicación del episodio Opencast.';
$string['appearance_overview_settingshowpublicationchannels'] = 'Mostrar canales de publicación';
$string['appearance_overview_settingshowpublicationchannels_desc'] = 'Si está activada, la tabla de vídeos disponibles en la página de resumen contendrá una columna que mostrará el canal de publicación del episodio Opencast. La misma información se ofrecerá también en la página de eliminación de episodios Opencast.';
$string['appearance_settings'] = 'Apariencia';
$string['backupopencastvideos'] = 'Incluir vídeos de la instancia Opencast {$a} en este curso';
$string['blocksettings'] = 'Configuración de una instancia de bloque';
$string['cachedef_videodata'] = 'Almacena en caché el resultado de la api opencast para el bloque opencast.';
$string['cachevalidtime'] = 'Tiempo de validez de la caché';
$string['cachevalidtime_desc'] = 'Tiempo en segundos antes de que se actualice la caché de los datos de vídeo de cada curso.';
$string['cantdeletedefaultseries'] = 'No puede borrar la serie por defecto. Por favor, elija otra serie por defecto antes de eliminar esta serie.';
$string['catalog_params_noarray'] = 'Los parámetros deben estar vacíos o ser una representación JSON de una matriz o un objeto.';
$string['catalog_static_params_empty'] = 'Los campos de sólo lectura necesitan definir un texto en el campo de parámetros.';
$string['catalogparam'] = 'Parámetros en formato JSON';
$string['catalogparam_help'] = '<b>Formato JSON:</b>{"param1":"value1", "param2":"value2"}<br> <b>Cadena (texto), Texto largo (textarea):</b> Los parámetros se definirán como atributos del elemento, es decir, {"style":"min-width: 27ch;"}, que define el atributo de estilo del elemento. <br> <b>Desplegar (seleccionar):</b> Los parámetros se definirán como opciones del elemento select, es decir, {"en": "Inglés", "de": "Alemán"}, que toma el lado izquierdo como valor y el lado derecho como texto a mostrar.<b>(Filtros multilingües)</b> Para que cada valor de <i>Desplegar (seleccionar)</i> se traduzca utilizando filtros como  <a target="_blank" href="https://moodle.org/plugins/filter_multilang2">Contenido Multilingües (v2)</a>, cada valor debe contener el marcador de posición definido por ese filtro, es decir, "{mlang en}No option selected{mlang}{mlang de}Keine Option ausgewählt{mlang}" o "{mlang en}English{mlang}{mlang de}Englisch{mlang}".<br><b>Arrays (autocompletar):</b> Los parámetros se definirán como  <a target="_blank" href="https://docs.moodle.org/dev/lib/formslib.php_Form_Definition#autocomplete">sugerencias</a>, es decir, {"1": "Dr. Doe", "2": "Johnson"}, que muestra (Dr. Doe y Johnson) como sugerencias.<br> <b>Selector de fecha y hora (datetime):</b> Los parámetros se definirán como <a target="_blank" href="https://docs.moodle.org/dev/lib/formslib.php_Form_Definition#date_selector">variables date_selector</a>, es decir,  {"startyear": "1990", "stopyear": "2020"} , que define el intervalo de fechas que debe seleccionarse entre 1990 y 2020.';
$string['changeowner'] = 'Cambiar propietario';
$string['changeowner_explanation'] = 'Actualmente, usted es el propietario del vídeo {$a}.<br>Puede transferir la propiedad a otra persona.<br><b>Aviso:</b> Usted podría perder el derecho a acceder al vídeo.';
$string['changeownerseries_explanation'] = 'Actualmente, usted es el propietario de la serie {$a}.<br>Puede transferir la propiedad a otra persona.<br><b>Aviso:</b> Usted podría perder el derecho a acceder a la serie.';
$string['changescheduledvisibility'] = 'Cambiar la visibilidad programada para {$a}';
$string['changescheduledvisibilityfailed'] = 'Incapaz de cambiar la visibilidad programada';
$string['changescheduledvisibilityheader'] = 'Cambio de visibilidad programado';
$string['changescheduledvisibilitysuccess'] = 'Visibilidad programada modificada correctamente';
$string['changevisibility'] = 'Alterar la visibilidad';
$string['changevisibility_group'] = 'El vídeo es visible para todos los alumnos pertenecientes a los grupos seleccionados. Haga clic para modificar la visibilidad.';
$string['changevisibility_header'] = 'Cambiar la visibilidad de {$a->title}';
$string['changevisibility_hidden'] = 'El vídeo no es visible para ningún alumno. Haga clic para modificar la visibilidad.';
$string['changevisibility_mixed'] = 'La visibilidad del vídeo está en un estado no válido. Haga clic para elegir la visibilidad correcta.';
$string['changevisibility_visible'] = 'El vídeo es visible para todos los alumnos del curso. Haga clic para modificar la visibilidad.';
$string['changingownerfailed'] = 'Se ha producido un error. No se ha podido transferir la propiedad.';
$string['changingownersuccess'] = 'La propiedad se ha transferido con éxito.';
$string['claimowner_explanation'] = 'Actualmente, nadie es propietario del vídeo {$a}.<br>Puede reclamar la propiedad o establecer a otra persona como propietario.<br><b>Aviso:</b> Puede perder el derecho a acceder al vídeo si no reclama usted mismo la propiedad.';
$string['claimownerseries_explanation'] = 'Actualmente, nadie posee la serie {$a}.<br>Puede reclamar la propiedad o establecer a otra persona como propietario.<br><b>Aviso:</b> Usted puede perder el derecho a acceder a la serie si no reclama usted mismo la propiedad.';
$string['connection_failure'] = 'No se ha podido contactar con el servidor Opencast.';
$string['contributor'] = 'Colaborador(es)';
$string['coursefullnameunknown'] = 'Nombre desconocido';
$string['created'] = 'Creado en';
$string['createdby'] = 'Subido por';
$string['createseriesforcourse'] = 'Crear una nueva serie';
$string['creator'] = 'Presentador(es)';
$string['cronsettings'] = 'Configuración de trabajos cargados';
$string['date'] = 'Fecha de inicio';
$string['dcmitermsnotice'] = '<br /><strong>IMPORTANTE</strong>: Opencast soporta el conjunto estandarizado de metadatos Dublin Core, por lo que todos los campos de metadatos deben seguir los términos DCMI, de lo contrario, al intentar añadir un campo de metadatos desconocido se producirá un error.<br /> Puede consultar la lista de todos los términos disponibles para su uso en <a target="_blank" href="https://www.dublincore.org/specifications/dublin-core/dcmi-terms/">Términos de metadatos CDMI</a>.';
$string['default'] = 'Por defecto';
$string['defaultssaved'] = 'Los valores por defecto están guardados.';
$string['delete_confirm_metadata'] = '¿Está seguro de que desea eliminar este campo de metadatos?';
$string['delete_confirm_role'] = '¿Está seguro de que desea eliminar este rol?';
$string['delete_confirm_series'] = '¿Seguro que quiere borrar estas series? <br/><b>Aviso:</b>Las series sólo están desvinculadas de este curso pero no borradas en Opencast.';
$string['delete_metadata'] = 'Borrar campo de metadatos';
$string['delete_role'] = 'Borrar rol';
$string['delete_series'] = 'Borrar series';
$string['delete_series_failed'] = 'El borrado de la serie ha fallado. Inténtalo de nuevo más tarde o ponte en contacto con un administrador.';
$string['deleteaclgroup'] = 'Borrar vídeo de esta lista.';
$string['deletedraft'] = 'Borrar un vídeo antes de transferirlo a Opencast';
$string['deletedraftdesc'] = 'Está a punto de eliminar este vídeo antes de transferirlo a Opencast.<br />Se eliminará de la cola de transferencia y no se procesará. Por favor, no continúe a menos que esté absolutamente seguro.';
$string['deleteevent'] = 'Eliminar un evento en Opencast';
$string['deleteeventdesc'] = 'Está a punto de eliminar este vídeo de forma permanente e irreversible de Opencast.<br />Todos los enlaces incrustados al mismo quedarán invalidados. Por favor, no continúe a menos que esté absolutamente seguro.';
$string['deletegroupacldesc'] = 'Está a punto de eliminar el acceso a este vídeo de este curso.<br />Si se elimina el acceso, el vídeo no se muestra en el selector de archivos ni en la lista de vídeos disponibles. Esto no afecta a los vídeos que ya están incrustados.<br />El vídeo no se borrará en Opencast.';
$string['deletetranscription'] = 'Borrar transcripción';
$string['deletetranscription_desc'] = 'Está a punto de borrar la transcripción.<br>¿Está seguro de que desea borrarla?';
$string['deletetranscriptionworkflow'] = 'Flujo de trabajo para la transcripción borrada';
$string['deletetranscriptionworkflow_desc'] = 'Este flujo de trabajo se activa cuando se elimina una transcripción, es necesario proporcionar la función de eliminación para que el evento se procese correctamente.<br>NOTA: Si está vacío, la función estará desactivada.';
$string['deleteworkflow'] = 'El flujo de trabajo debe iniciarse antes de que se elimine el evento';
$string['deleteworkflowdesc'] = 'Antes de eliminar un vídeo, se puede definir un flujo de trabajo, que se llama para retirar el evento de todos los canales de publicación.';
$string['deleting'] = 'Va a ser eliminado';
$string['description'] = 'Descripción';
$string['descriptionmddefaultable'] = 'Predeterminado';
$string['descriptionmddefaultable_help'] = 'Cuando está activado, los usuarios pueden añadir un valor por defecto para este campo.';
$string['descriptionmdfd'] = 'Descripción del campo';
$string['descriptionmdfd_help'] = 'El contenido de este campo se presenta como un icono de ayuda cerca del campo de metadatos.';
$string['descriptionmdfn'] = 'Nombre del campo';
$string['descriptionmdfn_help'] = 'Este es el nombre real del campo que pasa como metadatos (id); el nombre presentado de acuerdo con este nombre de campo debe establecerse en la cadena de idioma.';
$string['descriptionmdpj'] = 'El valor debe tener formato de cadena JSON y se utiliza para definir los parámetros del campo.';
$string['descriptionmdreadonly'] = 'De sólo lectura';
$string['descriptionmdreadonly_help'] = 'Por favor tenga en cuenta que, si un campo es obligatorio, la opción de sólo lectura estará desactivada. Ésto significa que un campo sólo puede ser de sólo lectura u obligatorio a la vez.';
$string['directaccess_copy_success'] = 'El enlace de acceso directo se ha copiado correctamente en el portapapeles.';
$string['directaccess_copytoclipboard_unavialable'] = 'Parece que su navegador no soporta la funcionalidad de copiar al portapapeles, intente copiar el enlace manualmente desde el elemento desplegable.';
$string['directaccess_setting'] = 'Canal de acceso directo';
$string['directaccess_settingdesc'] = 'Canal de publicación abierto desde el que se sirven los vídeos cuando se accede a ellos directamente. Si deja esta opción vacía, se desactivará la función. <br/><strong>Aviso:</strong> Se recomienda tener más precaución al utilizar esta función, ya que revela los datos directos del vídeo en el servidor de Opencast al acceder al enlace.';
$string['directaccesscopylink'] = 'Copiar enlace de acceso directo al vídeo';
$string['directaccesstovideo'] = 'Acceso directo al vídeo';
$string['dodeleteaclgroup'] = 'Eliminar el acceso a los vídeos de este curso';
$string['dodeletedraft'] = 'Borrar vídeo antes de transferirlo a Opencast';
$string['dodeleteevent'] = 'Eliminar un vídeo de forma permanente';
$string['download_setting'] = 'Canal de descarga';
$string['download_settingdesc'] = 'Canal de publicación Opencast desde donde se sirven los vídeos al descargarlos.';
$string['download_settingheader'] = 'Descargar vídeos';
$string['downloadtranscription'] = 'Descargar transcripción';
$string['downloadvideo'] = 'Descargar vídeo';
$string['duplicateworkflow'] = 'Flujo de trabajo para la duplicación de eventos';
$string['duplicateworkflowdesc'] = 'Este flujo de trabajo es necesario para importar eventos Opencast de un curso a otro. Si no se establece, no es posible importar eventos Opencast.';
$string['duration'] = 'Duración';
$string['editorbaseurl'] = 'URL base del editor Opencast';
$string['editorbaseurl_desc'] = 'La URL base que se utilizará para llamar al Editor Opencast, la url base de la instancia opencast se utiliza si está vacía.';
$string['editorendpointurl'] = 'Endpoint del editor de Opencast';
$string['editorendpointurl_desc'] = 'El endpoint del editor para acceder al editor. El ID del mediapackage se añadirá al final de la url.';
$string['editseries'] = 'Editar series';
$string['embeddedasactivity'] = 'Integrado como una actividad';
$string['embeddedasactivitywolink'] = 'Integrado como una actividad sin series enlazadas';
$string['empty_catalogname'] = 'Este campo no debe estar vacío';
$string['emptyvideouploaderror'] = 'Debe cargar un vídeo del presentador o un archivo de vídeo de la presentación.';
$string['emptyvisibilitygroups'] = 'Debe seleccionarse al menos un grupo.';
$string['enablechunkupload'] = 'Habilitar Chunkupload';
$string['enablechunkupload_desc'] = 'Si Chunkupload está activado será posible subir vídeos utilizando el plugin chunkupload';
$string['enableopencasteditorlink'] = 'Mostrar el enlace al Editor opencast en el menú de acciones';
$string['enableopencasteditorlink_desc'] = 'Esta opción muestra un botón para abrir el editor en el contenido del bloque y en la vista general del bloque. También deben configurarse las siguientes opciones, así como las credenciales lti.';
$string['enableopencaststudiolink'] = 'Mostrar el enlace a opencast studio';
$string['enableopencaststudiolink_desc'] = 'Esta opción muestra un botón a opencast studio en el contenido del bloque y en la vista general del bloque. Opencast studio debe ejecutarse en su nodo de administración de opencast y también deben configurarse los siguientes ajustes de lti.';
$string['enableopencaststudioreturnbtn'] = 'Mostrar un botón de redirección hacia atrás en Studio';
$string['enableopencaststudioreturnbtn_desc'] = 'Cuando está activado, Studio muestra un botón adicional "Salir y volver" después de subir o bajar la grabación.';
$string['enableschedulingchangevisibility'] = 'Programar un cambio de visibilidad';
$string['enableschedulingchangevisibilitydesc'] = 'Establezca una fecha y un estado de visibilidad para el evento en el futuro, que se realizará mediante una tarea programada.';
$string['engageplayerintegration'] = 'Integración de Engage player';
$string['engageredirect'] = 'Redirigir a engage player';
$string['engageurl'] = 'URL del servidor Opencast Engage';
$string['engageurl_desc'] = 'Si está vacío, los títulos de vídeo de la vista general no están vinculados al reproductor engage.';
$string['error_duplicated_event_acl_change'] = 'El cambio de visibilidad del evento duplicado ha fallado. Tarea de cambio de visibilidad del evento duplicado opencast ({$a->taskid}) para el curso {$a->coursefullname} (ID: {$a->courseid}).';
$string['error_duplicated_event_id_not_ready'] = 'El evento duplicado aún no está disponible. Tarea de cambio de visibilidad del evento duplicado opencast ({$a->taskid}) para el curso {$a->coursefullname} (ID: {$a->courseid}).';
$string['error_eventid_taskdata_missing'] = 'Los datos de la tarea no contienen ningún id de evento. Tarea de evento duplicado opencast ({$a->taskid}) para el curso {$a->coursefullname} (ID: {$a->courseid}).';
$string['error_no_duplicate_origin_event_id'] = 'Falta el id del evento de origen. Opencast duplicó la tarea de cambio de visibilidad del evento ({$a->taskid}) para el curso {$a->coursefullname} (ID: {$a->courseid}).';
$string['error_no_duplicate_workflow_id'] = 'Falta el id de flujo de trabajo duplicado. Opencast duplicó la tarea de cambio de visibilidad del evento ({$a->taskid}) para el curso {$a->coursefullname} (ID: {$a->courseid}).';
$string['error_seriesid_missing_course'] = 'El curso {$a->coursefullname} (ID: {$a->courseid}) no tiene series de cursos. El evento ({$a->eventid}) no se ha podido restaurar.';
$string['error_seriesid_missing_opencast'] = 'Las series del curso {$a->coursefullname} (ID: {$a->courseid}) no se pueden encontrar en el sistema opencast. El evento ({$a->eventid}) no se ha podido restaurar.';
$string['error_seriesid_not_matching'] = 'El curso {$a->coursefullname} (ID: {$a->courseid}) tiene unas series de curso que no coinciden con el seriesid de la tarea. El evento ({$a->eventid}) no se ha podido restaurar.';
$string['error_seriesid_taskdata_missing'] = 'Los datos de la tarea no contienen ningún id de serie. Tarea de evento duplicado opencast ({$a->taskid}) para el curso {$a->coursefullname} (ID: {$a->courseid}).';
$string['error_workflow_not_exists'] = 'El flujo de trabajo {$a->duplicateworkflow} no se encuentra en el sistema opencast. El evento ({$a->eventid}) no se ha podido restaurar para el curso {$a->coursefullname} (ID: {$a->courseid}).';
$string['error_workflow_not_started'] = 'No se ha podido iniciar el flujo de trabajo para copiar el vídeo ({$a->eventid}) asignado al curso {$a->coursefullname} (ID: {$a->courseid}).';
$string['error_workflow_setup_missing'] = 'El plugin block_opencast no está configurado correctamente. Falta el flujo de trabajo de duplicación.';
$string['errorduplicatedeventvisibilitytaskretry'] = 'Se ha producido un error al ejecutar una tarea para establecer la visibilidad del evento duplicado: {$a} Se intentará iniciar de nuevo el flujo de trabajo con la siguiente tarea cron.';
$string['errorduplicatedeventvisibilitytaskterminated'] = 'Se ha producido un error al ejecutar una tarea para establecer la visibilidad del evento duplicado: {$a} Después de intentarlo varias veces la tarea terminará ahora.';
$string['errorduplicatetaskretry'] = 'Se ha producido un error al ejecutar una tarea de duplicación de un evento: {$a} Se intentará iniciar de nuevo el flujo de trabajo mediante la siguiente tarea cron.';
$string['errorduplicatetaskterminate'] = 'Se ha producido un error al ejecutar una tarea de duplicación de un evento: {$a} Después de intentarlo varias veces la tarea terminará ahora.';
$string['erroremailbody'] = '{$a->errorstr} Detalles: {$a->message}.';
$string['erroremailsubj'] = 'Error al ejecutar la tarea duplicada del proceso opencast';
$string['errorgetblockvideos'] = 'No se puede cargar la lista (Error: {$a})';
$string['errorrestorefailedeventsaclchange_body'] = 'Se ha producido un problema en el proceso de restauración del curso {$a->coursefullname} (ID: {$a->courseid}). No se ha podido cambiar la visibilidad de los vídeos con los siguientes identificadores. Este(os) vídeo(s) no estará(n) accesible(s) en el nuevo curso:';
$string['errorrestorefailedeventsaclchange_subj'] = 'Error de Opencast durante el proceso de restauración';
$string['errorrestorefailedseriesaclchange_body'] = 'Se ha producido un problema en el proceso de restauración del curso {$a->coursefullname} (ID: {$a->courseid}). No se ha podido modificar la serie ACL (serie: {$a->seriesid}).';
$string['errorrestorefailedseriesaclchange_subj'] = 'Error de Opencast durante el proceso de restauración';
$string['errorrestorefailedseriesmapping_body'] = 'Se ha producido un problema en el proceso de restauración del curso {$a->coursefullname} (ID: {$a->courseid}). Ha fallado la asignación de la serie {$a->seriesid} al nuevo curso.';
$string['errorrestorefailedseriesmapping_subj'] = 'Error de Opencast durante el proceso de restauración';
$string['errorrestoremissingevents_body'] = 'Se ha producido un problema en el proceso de restauración del curso {$a->coursefullname} (ID: {$a->courseid}). El/los vídeo(s) con el/los siguiente(s) identificador(es) no pudo(n) ser encontrado(s) en el sistema opencast. Este(os) vídeo(s) no se restaurará(n):';
$string['errorrestoremissingevents_subj'] = 'Error de Opencast durante el proceso de restauración';
$string['errorrestoremissingimportmode_body'] = 'Se ha producido un problema en el proceso de restauración del curso {$a->coursefullname} (ID: {$a->courseid}). No se ha podido identificar el modo de importación, por lo que la tarea de restauración ha fallado.';
$string['errorrestoremissingimportmode_subj'] = 'Error de Opencast durante el proceso de restauración';
$string['errorrestoremissingseries_body'] = 'Se ha producido un problema en el proceso de restauración del curso {$a->coursefullname} (ID: {$a->courseid}). No se pudo crear ninguna serie abierta. Por lo tanto, los siguientes eventIDs no pudieron ser duplicados:';
$string['errorrestoremissingseries_subj'] = 'Error de Opencast durante el proceso de restauración';
$string['errorrestoremissingseriesid_body'] = 'Se ha producido un problema en el proceso de restauración del curso {$a->coursefullname} (ID: {$a->courseid}). No se pudo encontrar el id de la serie.';
$string['errorrestoremissingseriesid_subj'] = 'Error de Opencast durante el proceso de restauración';
$string['errorrestoremissingsourcecourseid_body'] = 'Se ha producido un problema en el proceso de restauración del curso {$a->coursefullname} (ID: {$a->courseid}). No se ha podido encontrar el ID del curso de origen.';
$string['errorrestoremissingsourcecourseid_subj'] = 'Error de Opencast durante el proceso de restauración';
$string['eventdeleted'] = 'El vídeo ha sido eliminado.';
$string['eventdeletedfailed'] = 'Error al borrar el evento';
$string['eventdeletionstarted'] = 'El vídeo se borrará próximamente.';
$string['eventuploadfailed'] = 'Error de carga';
$string['eventuploadsucceeded'] = 'Carga efectuada';
$string['exists_catalogname'] = 'El campo ya existe';
$string['expirydate'] = 'Fecha de expiración';
$string['failedtogetvideo'] = 'No se pueden obtener datos del evento Opencast.';
$string['failedtransferattempts'] = 'Intentos de transferencia fallidos: {$a}';
$string['filetypes'] = 'Tipos de archivo aceptados';
$string['form_seriesid'] = 'ID de las series';
$string['form_seriestitle'] = 'Título de las series';
$string['functionalitydisabled'] = 'Esta funcionalidad está desactivada.';
$string['general_settings'] = 'Ajustes generales';
$string['gotooverview'] = 'Ir al resumen...';
$string['group_name_empty'] = 'El nombre del grupo no debe estar vacío si se desea crear un grupo.';
$string['groupcreation'] = 'Crear un grupo';
$string['groupcreationdesc'] = 'Si está marcada, se crea un grupo durante la carga.';
$string['groupname'] = 'Nombre del grupo';
$string['groupnamedesc'] = 'Grupo al que se añade el vídeo. Importante: La longitud del nombre del grupo está restringida a 128 Bytes. Puede utilizar los marcadores de posición [COURSEID] y [COURSENAME] que se sustituyen automáticamente.';
$string['groupseries_header'] = 'Grupo y Series';
$string['haction'] = 'Acción';
$string['heading_actions'] = 'Acciones';
$string['heading_datatype'] = 'Tipo de campo';
$string['heading_defaultable'] = 'Predeterminado';
$string['heading_delete'] = 'Borrar';
$string['heading_description'] = 'Descripción del campo';
$string['heading_lti'] = 'Ajustes para la configuración de LTI';
$string['heading_name'] = 'Nombre del Campo';
$string['heading_params'] = 'Parámetros (JSON)';
$string['heading_permanent'] = 'Permanente';
$string['heading_position'] = 'Posición';
$string['heading_readonly'] = 'Sólo lectura';
$string['heading_required'] = 'Requerido';
$string['heading_role'] = 'Rol';
$string['hend_date'] = 'Fecha de finalización';
$string['hlocation'] = 'Ubicación';
$string['hprovide'] = 'Proporcionar';
$string['hprovidelti'] = 'Proporcionar (LTI)';
$string['hpublished'] = 'Publicado';
$string['hscheduledvisibility'] = 'Visibilidad programada';
$string['hstart_date'] = 'Fecha de inicio';
$string['htitle'] = 'Título';
$string['hvisibility'] = 'Visibilidad';
$string['hworkflow_state'] = 'Estado';
$string['identifier'] = 'Identificador';
$string['importfailed'] = 'No se ha podido importar la serie.';
$string['importmode'] = 'Modo de importación';
$string['importmodedesc'] = 'Para definir un método de importación de vídeos en un curso, debe seleccionarse un modo. El modo por defecto es Duplicación de Eventos en el que se creará una nueva serie y los eventos estarán disponibles en la serie utilizando un flujo de trabajo de duplicación.<br /> Por otro lado, el enfoque de Modificación de ACL utilizará el mismo seriesid entre cursos, pero las ACL de series y eventos se modificarán para conceder acceso desde el curso que importa los vídeos.';
$string['importseries'] = 'Importar series';
$string['importvideos_aclprocessingexplanation'] = 'El seriesid del curso seleccionado se utilizará en este curso y la ACL de la serie, así como las ACL de sus vídeos, se modificarán en consecuencia.';
$string['importvideos_errornotenabledorworking'] = 'La función de importar vídeos no está habilitada o no funciona';
$string['importvideos_importbuttontitle'] = 'Importar vídeos';
$string['importvideos_importepisodecleanupfailed'] = 'No se ha podido limpiar al menos uno de los módulos de episodios Opencast existentes en este curso. Por favor, inténtelo de nuevo o póngase en contacto con su administrador de Moodle.';
$string['importvideos_importheading'] = 'Importar vídeos de otros cursos';
$string['importvideos_importjobaclchangealleventsfailed'] = 'La importación ha fallado parcialmente, porque la modificación de ACL para todos los vídeos ha fallado.<br />Sin embargo, la serie está ahora asignada a este curso y se ha cambiado su ACL.';
$string['importvideos_importjobaclchangedone'] = 'La importación de la serie seleccionada con sus vídeos a este curso se ha realizado correctamente. Ahora puede acceder a los vídeos desde la lista.';
$string['importvideos_importjobaclchangeeventsfailed'] = 'La importación ha fallado parcialmente, porque la modificación de ACL para algunos de los vídeos ha fallado.<br />Sin embargo, la serie está ahora asignada a este curso y su ACL ha sido cambiada.<br />La ACL de los siguientes eventIDs no pudo ser cambiada:';
$string['importvideos_importjobaclchangeseriesfailed'] = 'Importación fallida, porque la modificación de ACL para la serie seleccionada ha fallado.';
$string['importvideos_importjobaclchangeseriesmappingfailed'] = 'La importación ha fallado, porque la asignación de la serie al curso ha fallado.';
$string['importvideos_importjobcreated'] = 'Se programó la importación de los vídeos seleccionados a este curso. Este proceso se realizará en segundo plano. No es necesario que espere en esta página. En cuanto se inicie el proceso, los vídeos aparecerán en la sección <em>Vídeos disponibles en este curso.</em><br><b>Aviso:</b>También se ejecutará un proceso de ajuste de la visibilidad de los vídeos importados justo después de que finalice el proceso de importación, por lo que se sugiere dar más tiempo a la duración total del procesamiento.';
$string['importvideos_importjobcreationfailed'] = 'Al menos uno de los vídeos no ha podido ser importado a este curso. Por favor, inténtelo de nuevo o póngase en contacto con su administrador de Moodle.';
$string['importvideos_importseriescleanupfailed'] = 'No se ha podido limpiar al menos uno de los módulos de la serie Opencast existentes en este curso. Por favor, inténtelo de nuevo o póngase en contacto con su administrador de Moodle.';
$string['importvideos_processingexplanation'] = 'Estos archivos de vídeo se duplicarán en Opencast y luego estarán disponibles en este curso.';
$string['importvideos_progressbarstep'] = 'Etapa {$a->current} de {$a->last}';
$string['importvideos_sectionexplanation'] = 'En esta sección, puede importar archivos de vídeo existentes de otros cursos Moodle a este curso Moodle.';
$string['importvideos_settingcoredefaultvalue'] = 'Valor por defecto de la casilla de verificación para la importación de vídeos de opencast';
$string['importvideos_settingcoredefaultvalue_desc'] = 'Seleccionar un valor predeterminado de la casilla de verificación para incluir vídeos de opencast en <b>Asistente de importación del núcleo de Moodle</b>, que al final se utilizará para incluir o no los vídeos. Esta opción está pensada para ayudar a los profesores que prefieren utilizar el botón "Saltar al paso final" y saltarse los pasos del asistente de importación del núcleo de Moodle.';
$string['importvideos_settingcoredefaultvalue_false'] = 'Sin verificar';
$string['importvideos_settingcoredefaultvalue_true'] = 'Verificado';
$string['importvideos_settingcoreenabled'] = 'Permitir la importación de vídeo en el asistente de importación de cursos del núcleo de Moodle';
$string['importvideos_settingcoreenabled_desc'] = 'Si se activa, los profesores pueden importar archivos de vídeo existentes de otros cursos Moodle a su curso Moodle utilizando el asistente de importación del curso principal de Moodle. Dentro del asistente, se muestra una opción adicional para importar los vídeos que se han cargado dentro del bloque Opencast en el otro curso. Utilizando esta función, el profesor puede importar todos los vídeos de otro curso en bloque, pero no puede seleccionar vídeos individuales.<br />Cuando se selecciona Duplicación de Eventos como modo de importación, los vídeos se duplican en Opencast mediante una tarea ad hoc en Moodle y aparecerán en la lista de vídeos del curso con un breve retraso.<br />En el caso de la Modificación de ACL como modo de importación, se utiliza el ID de serie del curso que se está importando, pero se cambiará la ACL de la serie y sus vídeos para permitir el acceso dentro del nuevo curso.';
$string['importvideos_settingenabled'] = 'Permitir la importación de vídeo';
$string['importvideos_settingenabled_desc'] = 'Si se activa, los profesores pueden importar archivos de vídeo existentes de otros cursos Moodle a su curso Moodle. Además, debe seleccionar un modo de importación entre Duplicación eventos o Modificación de ACL. En ambos modos, debe activar una o las dos opciones siguientes para importar vídeos manualmente o para importar vídeos con el asistente de importación del curso principal de Moodle. Si no activas ninguna de ellas, esta configuración no tendrá ningún efecto.<br />En el modo de Duplicación de Eventos, es necesario establecer además un flujo de trabajo de duplicación.';
$string['importvideos_settinghandleepisodeenabled'] = 'Gestión de los módulos de episodios de Opencast durante la importación manual de vídeo';
$string['importvideos_settinghandleepisodeenabled_desc'] = 'Si se activa, los profesores pueden gestionar los módulos de episodios de Opencast que se crearon con la función "Añadir módulo de episodio LTI" y que están relacionados con los vídeos que se importan. Esto limpia especialmente los módulos que se han importado de un curso a otro pero que siguen enlazados a vídeos del curso antiguo. Los módulos de episodios se gestionan mediante una tarea ad-hoc en Moodle y se fijarán en el curso con un breve retraso.<br />Por favor tenga en cuenta que este mecanismo se basa en el hecho de que el flujo de trabajo de duplicación de Opencast establece un campo de configuración de instancia de flujo de trabajo \'duplicate_media_package_1_id\' que contiene el ID del episodio duplicado. Si el flujo de trabajo no establece este campo de configuración, esta función fallará siempre.';
$string['importvideos_settinghandleseriesenabled'] = 'Gestión de los módulos de la serie Opencast durante la importación manual de vídeo';
$string['importvideos_settinghandleseriesenabled_desc'] = 'Si se activa, los profesores pueden gestionar los módulos de series Opencast que se crearon con la función "Añadir módulo de serie LTI" y que están relacionados con los vídeos que se importan. Esto limpia especialmente los módulos que se han importado de un curso a otro, pero que siguen vinculados a la serie del curso antiguo. El módulo de serie se gestiona instantáneamente una vez finalizado el asistente de importación.';
$string['importvideos_settingheader'] = 'Importar vídeos de otros cursos';
$string['importvideos_settingmanualenabled'] = 'Permitir la importación manual de vídeo';
$string['importvideos_settingmanualenabled_desc'] = 'Si está habilitado, los profesores pueden importar archivos de vídeo existentes de otros cursos Moodle a su curso Moodle utilizando un asistente de importación de vídeo Opencast dedicado. Esta función se ofrece en la página de descripción general del bloque Opencast.<br /> En el modo de importación Duplicación de Eventos, el profesor puede importar todos o un subconjunto de vídeos de otro curso en bloque. Los vídeos seleccionados en el asistente de importación se duplican en Opencast mediante una tarea ad hoc en Moodle y aparecerán en la lista de vídeos del curso con un breve retraso.<br />En el modo de importación Modificación de ACL, el seriesid del curso de destino se utilizará en el nuevo curso. Además, se modificarán las ACL de la propia serie y de todos sus vídeos para permitir el acceso a los mismos en el nuevo curso.<br />A diferencia del modo de Duplicación de Eventos, el asistente no permite la selección manual de vídeos.<br />Por favor tenga en cuenta que existen las capacidades correspondientes block/opencast:manualimporttarget y block/opencast:manualimportsource para esta función, que controlan quién puede importar qué cursos a qué cursos. Por defecto, los administradores y los profesores editores tienen esta capacidad y pueden utilizar la función en cuanto se habilite aquí.';
$string['importvideos_settingmodeacl'] = 'Modificación de ACL';
$string['importvideos_settingmodeduplication'] = 'Duplicación de Eventos';
$string['importvideos_settings'] = 'Características de importación de vídeos';
$string['importvideos_wizard_availableseries'] = 'Series disponibles en {$a}';
$string['importvideos_wizard_seriesimported'] = 'Series a importar';
$string['importvideos_wizardstep1coursevideos'] = 'Vídeos a importar';
$string['importvideos_wizardstep1heading'] = 'Seleccionar curso de origen';
$string['importvideos_wizardstep1intro'] = 'Seleccione el curso de origen desde el que se deben importar los vídeos de la siguiente lista de cursos.<br />Puede elegir entre todos los cursos desde los que se le permite importar vídeos.';
$string['importvideos_wizardstep1series'] = 'Series por defecto de este curso';
$string['importvideos_wizardstep1seriesnotfound'] = 'El curso de origen no tiene un id de serie válido, por favor asegúrese de que el curso que ha seleccionado tiene una serie por defecto.';
$string['importvideos_wizardstep1sourcecourse'] = 'Importar vídeos de este curso';
$string['importvideos_wizardstep1sourcecoursenone'] = 'No hay ningún otro curso aparte de éste del que se te permita importar vídeos.';
$string['importvideos_wizardstep2aclheading'] = 'Seleccionar series';
$string['importvideos_wizardstep2aclintro'] = 'Seleccione las series que desea importar del curso de origen.<br/>Se importan todos los vídeos de esta serie.';
$string['importvideos_wizardstep2coursevideos'] = 'Importar estos vídeos';
$string['importvideos_wizardstep2coursevideosnone'] = 'No hay ningún vídeo en el curso seleccionado.';
$string['importvideos_wizardstep2coursevideosnoneselected'] = 'Debe seleccionar al menos un vídeo para importarlo.';
$string['importvideos_wizardstep2heading'] = 'Seleccionar vídeos';
$string['importvideos_wizardstep2intro'] = 'Seleccione los vídeos que desea importar del curso de origen.<br />Puede elegir entre todos los vídeos que se han procesado completamente en la serie del curso fuente.<br/><b>Aviso: </b>Todos los vídeos seleccionados se importarán en una única serie.';
$string['importvideos_wizardstep3aclheading'] = 'Resumen';
$string['importvideos_wizardstep3aclintro'] = 'Compruebe que el resumen de la importación de vídeo coincide con sus expectativas antes de ejecutar la importación.';
$string['importvideos_wizardstep3episodemoduleexplanation'] = 'Hay al menos un módulo de episodio Opencast en este curso que apunta a un vídeo en el curso desde el que va a importar los vídeos ahora. Después de la importación, esto será limpiado para que apunte a vídeo importado dentro de este curso.';
$string['importvideos_wizardstep3episodemodulelabel'] = 'Sí, limpie el/los módulo(s) del episodio Opencast relacionado(s) con esta importación';
$string['importvideos_wizardstep3episodemodulesubheading'] = 'Limpiar el/los módulo(s) existente(s) del episodio Opencast';
$string['importvideos_wizardstep3heading'] = 'Gestionar los módulos Opencast en este curso';
$string['importvideos_wizardstep3intro'] = 'En este curso existen módulos Opencast relacionados con los vídeos que va a importar. Estos módulos se gestionarán después de la importación del vídeo.<br /><strong>Si no está seguro de si necesita esta gestión, acepte los valores predeterminados.</strong>';
$string['importvideos_wizardstep3seriesmoduleexplanation'] = 'Hay al menos un módulo de la serie Opencast en este curso que apunta al curso desde el que va a importar los vídeos ahora. Después de la importación, se limpiará para que sólo quede el módulo de la serie Opencast que muestra todos los vídeos (preexistentes y por importar) de este curso.';
$string['importvideos_wizardstep3seriesmodulelabel'] = 'Sí, limpie los módulos de la serie Opencast relacionados con esta importación';
$string['importvideos_wizardstep3seriesmodulesubheading'] = 'Limpiar el/los módulo(s) existente(s) de la serie Opencast';
$string['importvideos_wizardstep3skipintro'] = 'No hay ningún módulo Opencast existente en este curso que se relacione con los vídeos que va a importar.<br />No es necesario manipular nada, por favor continúe con el siguiente paso.';
$string['importvideos_wizardstep4coursevideosnone'] = 'No había ningún vídeo seleccionado para la importación.';
$string['importvideos_wizardstep4heading'] = 'Resumen';
$string['importvideos_wizardstep4intro'] = 'Por favor compruebe que el resumen de la importación de vídeo coincide con sus expectativas antes de ejecutar la importación.<br/>Los vídeos se importan en la serie predeterminada.';
$string['importvideos_wizardstep4sourcecoursenone'] = 'No había ningún curso fuente seleccionado para la importación.';
$string['importvideos_wizardstepbuttontitlecontinue'] = 'Continuar';
$string['importvideos_wizardstepbuttontitlerunimport'] = 'Importar vídeos y volver a la vista general';
$string['ingest_endpoint_notfound'] = 'El punto final ingets no está disponible, esto tiene que ser arreglado por el administrador del sistema.';
$string['ingeststateaddingacls'] = 'Añadiendo derechos y permisos ...';
$string['ingeststateaddingcatalog'] = 'Añadiendo catálogo de eventos ...';
$string['ingeststateaddingfirsttrack'] = 'Añadiendo la primera pista ...';
$string['ingeststateaddingsecondtrack'] = 'Añadiendo segunda pista ...';
$string['ingeststatecreatingmedispackage'] = 'Creando un paquete multimedia ...';
$string['ingeststateingesting'] = 'Cargando...';
$string['ingestupload'] = 'Cargando datos';
$string['ingestuploaddesc'] = 'Utilice el servicio de carga Opencast para subir vídeos.';
$string['initialvisibilitystatus'] = 'Visibilidad inicial del vídeo';
$string['invalidacldata'] = 'Datos acl no válidos';
$string['invalidmetadatafield'] = 'Se ha encontrado un campo de metadatos no válido: {$a}';
$string['language'] = 'Idioma';
$string['legendalt'] = 'Más detalles sobre todos los valores posibles de esta columna.';
$string['legenddeletingdesc'] = 'El vídeo está siendo borrado, y será eliminado en breve.';
$string['legendocstatecapturingdesc'] = 'Captura en directo en curso.';
$string['legendocstatefaileddesc'] = 'Algo ha ido mal al procesar este vídeo y ha fallado. Por favor, póngase en contacto con el soporte/administrador para resolver este problema.';
$string['legendocstateneedscuttingdesc'] = 'El vídeo requiere más atención para terminar la fase de procesamiento.';
$string['legendocstateprocessingdesc'] = 'El vídeo se ha cargado y está siendo procesado por Opencast.';
$string['legendocstatesucceededdesc'] = 'El vídeo se ha procesado y está listo.';
$string['legendplanneddesc'] = 'El vídeo ha sido programado para su procesamiento.';
$string['legendtitle'] = 'Tabla de detalles';
$string['legendvisibility_group'] = 'Visibilidad del grupo';
$string['legendvisibility_groupdesc'] = 'El vídeo es visible para todos los alumnos pertenecientes a los grupos seleccionados.';
$string['legendvisibility_hidden'] = 'Oculto';
$string['legendvisibility_hiddendesc'] = 'El vídeo no es visible para ningún alumno.';
$string['legendvisibility_mixed'] = 'Invalid';
$string['legendvisibility_mixeddesc'] = 'La visibilidad del vídeo se encuentra en un estado no válido.';
$string['legendvisibility_visible'] = 'Visible';
$string['legendvisibility_visibledesc'] = 'El vídeo es visible para todos los alumnos del curso.';
$string['license'] = 'Licencia';
$string['limituploadjobs'] = 'Limitar el trabajo de carga mediante cron';
$string['limituploadjobsdesc'] = 'Limitar el número de uploadjobs realizados por un cronjob. El cronjob puede programarse aquí: {$a}';
$string['limitvideos'] = 'Número de vídeos';
$string['limitvideosdesc'] = 'Número máximo de vídeos a mostrar en bloque';
$string['linkedinblock'] = 'Vinculado en bloque';
$string['liveupdate_fail_notification_message'] = 'No se ha podido actualizar el estado en directo de el/los siguiente(s) evento(s):<br> <ul><li>{$a}</li></ul>';
$string['liveupdate_reloadtimeout'] = 'Tiempo de espera de recarga de la página (en segundos)';
$string['liveupdate_reloadtimeout_desc'] = 'El tiempo de espera en segundos con el que se recargará la página cuando se identifique un estado actualizado. Si está vacío o es inferior a 0, se considerará un valor por defecto de 3 segundos.<br>NOTA: Antes de recargar la página se notificará a los profesores. La recarga es importante, para que todos los procesos backend requeridos tengan lugar.';
$string['liveupdate_settingenabled'] = 'Activar la función de actualización de estado en directo';
$string['liveupdate_settingenabled_desc'] = 'Cuando está habilitado, el estado de carga y los estados de procesamiento del flujo de trabajo se observarán cuando estén en un proceso en curso,<br>Esto se hace extrayendo la información de estado para esos procesos en un intervalo de 1 segundo.';
$string['liveupdate_settingheader'] = 'Actualización de estado en directo';
$string['liveupdate_toast_notification'] = 'Evento: ({$a->títle}) se actualiza. La página se recargará en {$a->timeout} segundos.';
$string['loading'] = 'Cargando ...';
$string['location'] = 'Ubicación';
$string['ltimodule_settings'] = 'Características del módulo LTI';
$string['managedefaultredirectlinkwithexp'] = 'Puede añadir valores por defecto para estos campos de metadatos, utilizando:';
$string['managedefaultsforuser'] = 'Gestionar los valores por defecto';
$string['managedefaultsforuser_desc'] = 'Aquí puede gestionar los valores predeterminados de los campos de metadatos utilizados para añadir vídeos y crear nuevas series. Si añade aquí un valor por defecto para un campo, se insertará automáticamente en el campo como valor predefinido (por defecto) dentro de las páginas mencionadas.<br /> NOTA: En caso de que esta página esté vacía, o si busca un campo que no existe aquí, póngase en contacto con el administrador del sistema y pídale que configure los campos de metadatos como predeterminables.';
$string['manageseriesforcourse'] = 'Gestionar series';
$string['managetranscriptions'] = 'Gestionar transcripciones';
$string['managetranscriptions_header'] = 'Gestión de transcripciones de eventos';
$string['maxseries'] = 'Número máximo de series';
$string['maxseriesdesc'] = 'Especifica cuántas series pueden asignarse a un curso. Los profesores no podrán añadir/importar más series si se alcanza el número máximo.';
$string['maxseriesreached'] = 'No puede añadir otra serie a este curso porque el curso ya contiene el número máximo de series.';
$string['maxseriesreachedimport'] = 'Actualmente, no puede importar otra serie porque el curso ya contiene el número máximo de series.';
$string['mediatype'] = 'Medios de comunicación';
$string['messageprovider:error'] = 'Notificación de error de procesamiento';
$string['messageprovider:opencasteventstatus_notification'] = 'Notificación del estado de un evento de Opencast';
$string['messageprovider:reportproblem_confirmation'] = 'Copia de los problemas reportados para los vídeos de Opencast';
$string['metadata'] = 'Metadatos de eventos';
$string['metadata_autocomplete_noselectionstring'] = '¡No se proporciona {$a}!';
$string['metadata_autocomplete_placeholder'] = 'Introduzca {$a}';
$string['metadatadesc'] = 'Aquí puede definir qué campos de metadatos pueden o deben establecerse al cargar vídeos en Opencast. Puede arrastrar y soltar filas para reordenarlas definiendo la posición de los campos en el formulario.';
$string['metadataexplanation'] = 'Al cargar archivos de vídeo existentes en Opencast, puede establecer varios campos de metadatos. Éstos se almacenarán junto con el vídeo.';
$string['metadataseries'] = 'Metadatos de la serie';
$string['metadataseriesdesc'] = 'Aquí puede definir qué campos de metadatos pueden o deben establecerse para crear series Opencast. Puede arrastrar y soltar filas para reordenarlas definiendo la posición de los campos en el formulario.';
$string['metadataseriesupdatefailed'] = 'Error al actualizar los metadatos de la serie.';
$string['missingevent'] = 'Error en la creación del evento';
$string['missinggroup'] = 'Falta un grupo en opencast';
$string['missingseries'] = 'Faltan series en opencast';
$string['missingseriesassignment'] = 'Falta la asignación de series';
$string['morethanonedefaultserieserror'] = 'Este curso tiene más de una serie predeterminada. Póngase en contacto con el administrador del sistema.';
$string['morevideos'] = 'Más vídeos ...';
$string['mstatecreatingevent'] = 'Cargando ...';
$string['mstatecreatinggroup'] = 'Creando Grupo Opencast ...';
$string['mstatecreatingseries'] = 'Creando Series Opencast...';
$string['mstatereadytoupload'] = 'Listo para la transferencia';
$string['mstatetransferred'] = 'Transferido';
$string['mstateunknown'] = 'Estado desconocido';
$string['mstateuploaded'] = 'Procesamiento de tareas posteriores a la carga ...';
$string['no_ingest_services'] = 'No se han encontrado nodos de entrada disponibles.';
$string['noconnectedseries'] = 'Aún no se ha definido ninguna serie.';
$string['noseriesid'] = 'El ID de la serie aún no está definido.';
$string['nothingtodisplay'] = 'En esta sección, puede ver los vídeos que se han subido a este curso.<br />Actualmente, aún no se ha subido ningún vídeo a este curso.';
$string['notificationcleanupimportedmodules_subj'] = 'Notificación de tareas de limpieza de módulos importados de Opencast';
$string['notificationcleanupimportedmodulescleanupfailed_body'] = 'El trabajo de limpieza con id de flujo de trabajo: ({$a->workflowid}) para el curso {$a->coursefullname} (ID: {$a->courseid}) falló durante la actualización de las actividades del episodio y se elimina.';
$string['notificationcleanupimportedmodulesexpired_body'] = 'Se ha eliminado el trabajo de limpieza con id de flujo de trabajo: ({$a->workflowid}) para el curso {$a->coursefullname} (ID: {$a->courseid}), ya que hemos esperado 5 días sin éxito para obtener el ID de episodio duplicado de OC.';
$string['notificationcleanupimportedmodulesgeneralexception_body'] = 'El trabajo de limpieza con id de flujo de trabajo: ({$a->workflowid}) para el curso {$a->coursefullname} (ID: {$a->courseid}) ha fallado y ha sido eliminado. El mensaje de excepción contiene: {$a->mensajedeexcepción}';
$string['notificationcleanupimportedmodulesnoeposideid_body'] = 'Se ha eliminado el trabajo de limpieza con el id de flujo de trabajo: ({$a->workflowid}) para el curso {$a->coursefullname} (ID: {$a->courseid}) ya que el flujo de trabajo OC almacenado no existe o no tiene ni tendrá un ID de episodio duplicado.';
$string['notificationeventstatus'] = 'Permitir la notificación del estado del proceso del evento';
$string['notificationeventstatus_body'] = 'El estado del proceso del vídeo subido: {$a->videotitle} (ID: {$a->videoidentifier}) en el curso: {$a->coursefullname} (ID: {$a->courseid}) se ha cambiado a: {$a->statusmessage}';
$string['notificationeventstatus_desc'] = 'Esta opción permite al sistema enviar notificaciones sobre el estado del vídeo subido desde Opencast durante el proceso a los usuarios. Esta opción sólo incluye al uploader del vídeo en la lista de usuarios. Para notificar a todos los profesores del curso, debe activarse la siguiente opción.<br />Esta función se realiza a través de una tarea programada que se recomienda ejecutar cada minuto.';
$string['notificationeventstatus_subj'] = 'Notificación del estado del evento de Opencast';
$string['notificationeventstatusdeletion'] = 'Trabajos de notificación de limpieza después de (Días)';
$string['notificationeventstatusdeletion_desc'] = 'Este ajuste establece una fecha límite en día para los trabajos que aún no se han completado. Una vez cumplido el plazo, el trabajo se eliminará a pesar de su estado de proceso. <br />Esta función ayuda a eliminar las tareas de notificación pendientes de la lista y se realiza mediante una tarea programada que se recomienda ejecutar una vez al día.<br />NOTA: El valor "0" (cero) desactiva el ajuste.';
$string['notificationeventstatusteachers'] = 'Notificar a todos los profesores del curso el estado del proceso del evento';
$string['notificationeventstatusteachers_desc'] = 'Con esta opción, además de quien ha subido el vídeo, todos los profesores del curso desde el que se ha subido el vídeo reciben una notificación sobre el estado de procesamiento de Opencast.';
$string['notifications_settings_header'] = 'Notificaciones';
$string['notificationuploaduqeuestatus_body'] = 'El tratamiento de este vídeo: {$a->videotitle} en el curso {$a->coursefullname} (ID: {$a->courseid}) está en cola, pero aún no ha comenzado. El vídeo está actualmente esperando detrás de {$a->waitingnum} otro(s) vídeo(s) en la cola de procesamiento.';
$string['notificationuploaduqeuestatus_subj'] = 'Notificación de carga de eventos de Opencast';
$string['notpublished'] = 'No publicado';
$string['notranscription'] = 'Este vídeo aún no tiene transcripción.';
$string['nouserselected'] = 'Debe seleccionar un usuario.';
$string['novideosavailable'] = 'No hay vídeos disponibles';
$string['novisibilitychange'] = 'No se identifican cambios, por favor asegúrese de que todo está correcto.';
$string['novisibilityrecordfound'] = 'No se ha podido encontrar el registro de visibilidad.';
$string['ocstatecapturing'] = 'Capturando';
$string['ocstatefailed'] = 'Falló';
$string['ocstateneedscutting'] = 'Necesita ser cortado';
$string['ocstateprocessing'] = 'Procesamiento';
$string['ocstatesucceeded'] = 'Con éxito';
$string['offerchunkuploadalternative'] = 'Ofrecer filepicker como alternativa';
$string['offerchunkuploadalternative_desc'] = 'Si esta opción está activada, se mostrará una casilla de verificación etiquetada como \'{$a}\' debajo del widget de subida de fragmentos. Tan pronto como esta casilla esté marcada, el widget de subida de fragmentos se ocultará y se mostrará el selector de archivos por defecto de Moodle, dando acceso a todos los repositorios de Moodle.';
$string['opencast:addactivity'] = 'Añadir actividad de proveedor de vídeo Opencast al curso';
$string['opencast:addactivityepisode'] = 'Añadir actividad de proveedor de vídeo Opencast para un episodio al curso';
$string['opencast:addinstance'] = 'Añadir un nuevo bloque de subida a opencast';
$string['opencast:addlti'] = 'Añadir módulo de la serie Opencast LTI al curso';
$string['opencast:addltiepisode'] = 'Añadir el módulo de episodios Opencast LTI al curso';
$string['opencast:addvideo'] = 'Añadir un nuevo vídeo al bloque de subida de opencast';
$string['opencast:canchangeownerforallvideos'] = 'Poder cambiar el propietario de todos los vídeos';
$string['opencast:createseriesforcourse'] = 'Crear una nueva serie en opencast para un curso moodle';
$string['opencast:deleteevent'] = 'Borrar por fin un vídeo (evento) en opencast';
$string['opencast:directaccessvideolink'] = 'Acceso directo al vídeo a través de un enlace compartido';
$string['opencast:downloadvideo'] = 'Descargar vídeos procesados';
$string['opencast:importseriesintocourse'] = 'Importar una serie opencast existente a un curso moodle';
$string['opencast:manageseriesforcourse'] = 'Gestionar la serie opencast de un curso moodle';
$string['opencast:manualimportsource'] = 'Importar manualmente vídeos de este curso';
$string['opencast:manualimporttarget'] = 'Importar manualmente vídeos de otros cursos';
$string['opencast:myaddinstance'] = 'Añadir un nuevo bloque de subida de opencast al panel de control';
$string['opencast:sharedirectaccessvideolink'] = 'Comparte el enlace de acceso directo al vídeo';
$string['opencast:startworkflow'] = 'Iniciar manualmente flujos de trabajo para vídeos';
$string['opencast:unassignevent'] = 'Desasignar un vídeo del curso, donde se cargó el vídeo.';
$string['opencast:viewunpublishedvideos'] = 'Ver todos los vídeos del servidor de opencast, aunque no estén publicados';
$string['opencast:viewusers'] = 'Ver todos los usuarios para poder cambiar el propietario de la serie/evento en el panel de control.';
$string['opencasteditorintegration'] = 'Integración del Editor Opencast';
$string['opencastseries'] = 'Series Opencast';
$string['opencaststudiobaseurl'] = 'URL base de Opencast Studio';
$string['opencaststudiobaseurl_desc'] = 'La URL base que se utilizará para llamar al estudio Opencast. Si está vacía, se utiliza la URL base de la instancia de opencast.';
$string['opencaststudiocustomsettingsfilename'] = 'Nombre de archivo de configuración personalizada de Studio';
$string['opencaststudiocustomsettingsfilename_desc'] = 'Este nombre de archivo de configuración personalizada se añadirá a la consulta cuando se redirija a Studio; posteriormente, Studio buscará este nombre de archivo en relación con su directorio y leerá la configuración de ese archivo.<br> <b>NOTA</b>: Requiere Opencast 14.2 o posterior.';
$string['opencaststudiointegration'] = 'Integración de Opencast Studio';
$string['opencaststudionewtab'] = 'Redirigir a Studio en una pestaña nueva';
$string['opencaststudionewtab_desc'] = 'Cuando está activado, el estudio se abre en una nueva pestaña.';
$string['opencaststudioreturnbtnlabel'] = 'Etiqueta para el botón de retorno de Studio';
$string['opencaststudioreturnbtnlabel_desc'] = 'Esta etiqueta funciona como una breve descripción a donde el enlace de retorno conduce. Esta etiqueta se añadirá al texto del botón de retorno de Studio, cuando esté vacía, el nombre del sitio moodle se pasará como etiqueta.';
$string['opencaststudioreturnurl'] = 'URL de retorno de Studio personalizada';
$string['opencaststudioreturnurl_desc'] = 'Cuando está vacía, la url de retorno redirige al mismo bloque de Moodle de donde proviene la petición. Una URL personalizada será pasada a Studio como url de retorno cuando se configure, en este caso, el administrador puede usar 2 marcadores de posición incluyendo [OCINSTANCEID] y [COURSEID]. NOTA: la URL debe ser relativa a wwwroot.';
$string['overview'] = 'Visión general';
$string['ownedvideosoverview'] = 'Sus vídeos';
$string['ownedvideosoverview_explanation'] = 'Aquí puede ver todos los vídeos que le pertenecen pero a cuyas series no tiene acceso.';
$string['owner'] = 'Propietario';
$string['planned'] = 'Planificado';
$string['pluginname'] = 'Vídeos Opencast';
$string['presentation'] = 'Vídeo de presentación';
$string['presentationdesc'] = 'Utilice el vídeo de presentación si tiene un archivo de vídeo de la grabación de una presentación de diapositivas o un screencast.';
$string['presentationfile'] = 'Archivo de presentación';
$string['presenter'] = 'Vídeo del presentador';
$string['presenterdesc'] = 'Utilice el vídeo del presentador si dispone de un archivo de vídeo de una persona hablando ante el público o de una imagen en movimiento.';
$string['presenterfile'] = 'Fichero del presentador';
$string['privacy:metadata:block_opencast_uploadjob'] = 'Información sobre las cargas del vídeo.';
$string['privacy:metadata:block_opencast_uploadjob:courseid'] = 'ID del curso en el que se ha cargado el vídeo';
$string['privacy:metadata:block_opencast_uploadjob:fileid'] = 'ID del archivo/vídeo cargado';
$string['privacy:metadata:block_opencast_uploadjob:opencasteventid'] = 'ID del evento opencast que se creó durante la carga';
$string['privacy:metadata:block_opencast_uploadjob:status'] = 'Estado del proceso de carga';
$string['privacy:metadata:block_opencast_uploadjob:timecreated'] = 'La fecha en que se creó el trabajo de carga.';
$string['privacy:metadata:block_opencast_uploadjob:timemodified'] = 'La fecha en que se modificó por última vez el trabajo de carga.';
$string['privacy:metadata:block_opencast_uploadjob:userid'] = 'ID del usuario que subió el vídeo';
$string['privacy:metadata:core_files'] = 'El bloque opencast almacena archivos (vídeos) que han sido cargados por el usuario.';
$string['privacy:metadata:opencast'] = 'El bloque interactúa con una instancia de opencast y, por tanto, es necesario intercambiar datos.';
$string['privacy:metadata:opencast:file'] = 'El archivo seleccionado se carga en opencast.';
$string['processattachment'] = 'Procesar trabajos de carga de archivos adjuntos';
$string['processdelete'] = 'Proceso de eliminación de trabajos para Opencast';
$string['processdeletenotification'] = 'Procesar tareas de notificación de supresión';
$string['processepisodecleanup'] = 'Proceso de limpieza de episodios de Opencast Video Provider/LTI tras la importación de cursos';
$string['processltimodulecleanup'] = 'Proceso de limpieza rutinaria del episodio LTI de Opencast Video';
$string['processltimodulecleanup_error'] = 'Algo ha ido mal durante el proceso de limpieza del módulo LTI: {$a}';
$string['processnotification'] = 'Procesar las tareas de notificación del estado de los eventos tras la carga';
$string['processupload'] = 'Proceso de carga';
$string['processvisibility'] = 'Procesar los trabajos de cambio de visibilidad programados';
$string['publisher'] = 'Editor';
$string['publishtoengage'] = 'Publicar para captar la atención';
$string['publishtoengagedesc'] = 'Seleccione esta opción para publicar el vídeo después de cargarlo en engage player. El flujo de trabajo de configuración debe admitir esta opción.';
$string['readonly_disabled_tooltip_text'] = 'No se puede establecer la opción de sólo lectura cuando es obligatoria.';
$string['recordvideo'] = 'Grabar vídeo';
$string['reportproblem_email'] = 'Esta es una notificación automática del plugin Moodle Opencast.<br>Alguien ha informado de un problema con un vídeo.<br><br><b>Usuario: </b>{$a->username}<br><b>Email del usuario: </b>{$a->useremail}<br><b>Curso de Moodle:  </b><a href="{$a->courselink}">{$a->course}</a><br><b>Series opencast: </b>{$a->series} (Id: {$a->seriesid})<br><b>Id del evento Opencast: </b>{$a->event} (Id: {$a->eventid})<br><b>Mensaje:</b><br><hr>{$a->message}<hr>';
$string['reportproblem_failure'] = 'No se ha podido enviar el correo electrónico. Póngase en contacto con el equipo de soporte manualmente.';
$string['reportproblem_modal_body'] = 'Si tiene algún problema con un vídeo, puede informar al equipo de soporte.';
$string['reportproblem_modal_placeholder'] = 'Por favor, explique el problema.';
$string['reportproblem_modal_required'] = 'Por favor, introduzca un mensaje.';
$string['reportproblem_modal_submit'] = 'Informar de un problema';
$string['reportproblem_modal_title'] = 'Informar de un problema';
$string['reportproblem_notification'] = '#### Esta es una copia del correo electrónico enviado al equipo de soporte. ####<br>';
$string['reportproblem_subject'] = 'Plugin Moodle Opencast: Problema notificado';
$string['reportproblem_success'] = 'El correo electrónico se ha enviado correctamente al equipo de soporte.';
$string['restoreopencastvideos'] = 'Restaurar vídeos de la instancia de Opencast {$a}';
$string['reuseexistingupload'] = 'Reutilizar cargas existentes';
$string['reuseexistinguploaddesc'] = 'Si se activa, varios vídeos con el mismo hash de contenido se suben a opencast una sola vez. Esto ahorra almacenamiento y capacidad de procesamiento, pero puede causar problemas cuando se utilizan políticas de acceso específicas basadas en series de opencast.';
$string['rightsHolder'] = 'Derechos';
$string['role_not_defined'] = 'El rol no está definido en la tabla de roles ACL.';
$string['role_not_permanent'] = 'El rol no está definido como permanente en la tabla de roles ACL.';
$string['role_not_user_related'] = 'La función no contiene un marcador de posición de usuario y, por lo tanto, no puede utilizarse para identificar usuarios.';
$string['rolename'] = 'Nombre del rol';
$string['savedefaults'] = 'Guardar valores predeterminados';
$string['scheduledvisibilitychangecreated'] = 'Está previsto un nuevo cambio de visibilidad';
$string['scheduledvisibilitychangedeleted'] = 'Se ha suprimido el cambio de visibilidad programado';
$string['scheduledvisibilitychangefailed'] = 'No se ha podido programar un cambio de visibilidad. Puede programar uno nuevo o desactivarlo para eliminar su tarea.';
$string['scheduledvisibilitychangeskipped'] = '<br>NOTA: La tarea para programar el cambio de visibilidad se omite y no se llevaría a cabo.';
$string['scheduledvisibilitychangeupdated'] = 'Se actualiza el cambio de visibilidad programado.';
$string['scheduledvisibilitycreatefailed'] = 'Imposible programar un cambio de visibilidad.';
$string['scheduledvisibilitydeletefailed'] = 'No se puede eliminar el cambio de visibilidad programado.';
$string['scheduledvisibilityicontitle'] = 'Haga clic aquí para modificar el cambio de visibilidad programado para este evento';
$string['scheduledvisibilitystatus'] = 'Cambiar la visibilidad del vídeo a';
$string['scheduledvisibilitystatuserror'] = 'La visibilidad programada y la visibilidad inicial deben ser diferentes.';
$string['scheduledvisibilitytime'] = 'Cambiar la visibilidad del vídeo en';
$string['scheduledvisibilitytimeerror'] = 'La fecha programada para cambiar la visibilidad debe fijarse al menos {$a} minutos después de los datos y la hora actuales.';
$string['scheduledvisibilitytimehi'] = 'Fecha de programación';
$string['scheduledvisibilitytimehi_help'] = 'Esta fecha debe establecerse en un futuro próximo y, como se recomienda, al menos {$a} minutos después de la hora de la fecha actual; sin embargo, cuanto más rápido procese el vídeo su servidor de opencast, más cerca podrá establecerse esta fecha.';
$string['scheduledvisibilityupdatefailed'] = 'No se puede actualizar el cambio de visibilidad programado.';
$string['series'] = 'Series';
$string['series_already_exists'] = 'Este curso ya se ha asignado a una serie.';
$string['series_does_not_exist'] = 'La serie asignada a este curso no es válida. ¡Por favor, póngase en contacto con su administrador!';
$string['series_does_not_exist_admin'] = 'La serie con el identificador \'{$a}\' no se ha podido recuperar de Opencast.';
$string['series_name_empty'] = 'El nombre de las series no debe estar vacío.';
$string['series_not_found'] = 'Las series {$a} no se han podido encontrar en el sistema opencast.';
$string['series_used'] = 'Utilizado en {$a} cursos';
$string['seriescreated'] = 'Se han creado las series';
$string['seriesidnotvalid'] = 'Las series {$a} no existe.';
$string['seriesidsaved'] = 'Se ha guardado el ID de las series.';
$string['seriesidunset'] = 'Se ha eliminado el identificador de las series.';
$string['serieslinkedinblock'] = 'Series enlazadas en bloque';
$string['seriesname'] = 'Nombre de las series';
$string['seriesnamedesc'] = 'Serie a la que se añade el vídeo. Puede utilizar marcadores de posición que se sustituyen automáticamente (<a target="_blank" href="https://moodle.docs.opencast.org/#block/general_settings/#placeholders">lista de marcadores de posición</a>).';
$string['seriesnotcreated'] = 'No se ha podido crear las series';
$string['seriesonedefault'] = 'Debe haber exactamente una serie por defecto.';
$string['seriesoverview'] = 'Visión general de las series';
$string['seriesoverviewexplanation'] = 'Aquí puede ver todas las series que se utilizan en cualquier curso en el que tenga permiso para gestionar vídeos.<br>Las series podrían ser gestionables por el bloque en el curso y/o podrían proporcionarse como actividad a los alumnos.';
$string['seriesoverviewof'] = 'Vista general de las series de {$a} instancia';
$string['setdefaultseries'] = '¿De verdad quiere usar esta serie como nueva serie por defecto?';
$string['setdefaultseries_heading'] = 'Establecer series por defecto';
$string['setdefaultseriesfailed'] = 'No se ha podido cambiar la serie predeterminada. Vuelva a intentarlo más tarde o póngase en contacto con un administrador.';
$string['setting_permanent'] = 'Es permanente';
$string['settings'] = 'Vídeos Opencast';
$string['shared_settings'] = 'Ajustes compartidos';
$string['showvideos'] = 'Mostrar vídeos';
$string['source'] = 'Fuente';
$string['space_catalogname'] = 'Este campo no debe contener espacios';
$string['startDate'] = 'Fecha';
$string['startTime'] = 'Tiempo';
$string['startworkflow'] = 'Comenzar flujo de trabajo';
$string['startworkflow_modal_body'] = 'Elija el flujo de trabajo que desea iniciar.';
$string['startworkflow_modal_configpanel_title'] = 'Panel de Configuración del Flujo de Trabajo';
$string['startworkflow_modal_description_title'] = 'Descripción del Flujo de Trabajo';
$string['subjects'] = 'Temas';
$string['submit'] = 'Guardar cambios';
$string['support_setting'] = 'Correo electrónico del soporte';
$string['support_setting_notset'] = 'El correo electrónico de soporte no está configurado. Póngase en contacto con el administrador y vuelva a enviar el informe.';
$string['support_settingdesc'] = 'Dirección de correo electrónico a la que se envían los informes si los usuarios informan de problemas con los vídeos.';
$string['swprivacynotice_settingheader'] = 'Aviso sobre la privacidad del flujo de trabajo';
$string['swprivacynotice_settinginfotext'] = 'Texto informativo del aviso de privacidad del flujo de trabajo';
$string['swprivacynotice_settinginfotext_desc'] = 'Esta entrada se utiliza para proporcionar información sobre el aviso de privacidad para los flujos de trabajo en el diálogo de inicio de flujo de trabajo.<br><strong>NOTA:</strong> Si está vacía, no se mostrará ningún aviso.';
$string['swprivacynotice_settingtitle'] = 'Título del aviso de privacidad de flujo de trabajo';
$string['swprivacynotice_settingtitle_desc'] = 'Título que se mostrará en el diálogo de inicio del flujo de trabajo. Se pretende que sea configurable para que pueda ser ajustado por los usuarios. Cuando está vacío, se utiliza la cadena por defecto.';
$string['swprivacynotice_settingwfds'] = 'Lista de definición de flujos de trabajo';
$string['swprivacynotice_settingwfds_desc'] = 'Una lista separada por comas de definiciones de flujos de trabajo, por las que se muestra el aviso de privacidad. Si está vacía, el aviso de privacidad se mostrará para todos los flujos de trabajo.';
$string['swprivacynoticedefaulttitle'] = 'Aviso de privacidad';
$string['termsofuse'] = 'Condiciones de uso';
$string['termsofuse_accept'] = 'He leído y acepto el {$a}.';
$string['termsofuse_accept_toggle'] = 'condiciones de uso';
$string['termsofuse_desc'] = 'Si introduce algún texto, aparecerá una casilla con las condiciones de uso en la página "Subir vídeo". Los usuarios deben aceptar las condiciones de uso introducidas antes de poder subir el vídeo.';
$string['title'] = 'Título';
$string['tool_requirement_not_fulfilled'] = 'La versión necesaria de tool_opencast no está instalada.';
$string['transcriptionaction_thead'] = 'Acciones';
$string['transcriptionaddnewbtn'] = 'Añadir más juego de transcripción';
$string['transcriptiondeletebtn'] = 'Borrar juego de transcripción';
$string['transcriptiondeletionfailed'] = 'Error al borrar la transcripción';
$string['transcriptiondeletionsucceeded'] = 'Transcripción eliminada con éxito.';
$string['transcriptionfileextensions'] = 'Extensiones de archivo de transcripción permitidas';
$string['transcriptionfileextensions_desc'] = 'Lista separada por comas de las extensiones de archivo de transcripción permitidas (las extensiones deben existir en la lista de <a href="{$a}">Tipos de archivos</a> de Moodle). Si se deja en blanco, se permiten todas las extensiones con el tipo \'Archivos de seguimiento HTML\' (de nuevo, véase <a href="{$a}">Tipos de archivo</a>).';
$string['transcriptionfilefield'] = 'Archivo de transcripción';
$string['transcriptionheader'] = 'Cargar archivos de transcripción';
$string['transcriptionheaderexplanation'] = 'En esta sección puede cargar un archivo de transcripción para cada tipo de servicio, con la extensión de archivo especificada, que se cargará junto con el vídeo y se procesará en consecuencia para proporcionar la capacidad (voz a texto).';
$string['transcriptionltidownloadcompleted'] = 'La transcripción se ha descargado correctamente. {$a}';
$string['transcriptionreturntomanagement'] = 'Volver a la página de gestión de transcripciones';
$string['transcriptionsettingsheader'] = 'Ajustes para la transcripción';
$string['transcriptionworkflow'] = 'Flujo de trabajo para la transcripción (voz a texto)';
$string['transcriptionworkflow_desc'] = 'Este flujo de trabajo se activa cuando se adjuntan archivos de transcripción al vídeo. Si no se define, no se podrán cargar ni gestionar las transcripciones.<br>Al establecer este flujo de trabajo, se proporciona una nueva sección para cargar archivos de transcripción en la página de añadir vídeo, así como un nuevo elemento de menú de acción en la página de resumen, para cargar/gestionar los archivos de transcripción nuevos/actuales.';
$string['type'] = 'Tipo de soporte';
$string['unabletoaddnewtranscription'] = 'No se puede añadir una nueva transcripción';
$string['unabletodeletetranscription'] = 'No se puede eliminar la transcripción';
$string['unabletodownloadtranscription'] = 'No se puede descargar la transcripción';
$string['unabletomanagetranscriptions'] = 'Debido a un estado de procesamiento activo o a un flujo de trabajo en curso, no es posible gestionar las transcripciones del evento por el momento.';
$string['unexpected_api_response'] = 'Respuesta inesperada de la API.';
$string['updatemetadata'] = 'Actualizar metadatos para este evento';
$string['updatemetadata_short'] = 'Actualizar metadatos';
$string['updatemetadatafailed'] = 'No se han podido guardar los metadatos.';
$string['updatemetadatasaved'] = 'Se guardan los metadatos.';
$string['upload'] = 'Carga de archivos';
$string['uploadexplanation'] = 'Tiene la opción de cargar un archivo de vídeo del presentador y/o un archivo de vídeo de la presentación.<br /> Lo más probable es que solo cargue un archivo, pero Opencast también es capaz de gestionar dos vídeos a la vez que se combinarán en un paquete multimedia.';
$string['uploadfileextensions'] = 'Extensiones de archivo permitidas';
$string['uploadfileextensionsdesc'] = 'Lista separada por comas de las extensiones de archivo de vídeo permitidas (las extensiones deben existir en la lista <a href="{$a}">Tipos de archivos</a> de Moodle). Si se deja en blanco, se permiten todas las extensiones con el grupo de tipos \'video\' (de nuevo, véase <a href="{$a}">Tipos de archivo</a>).';
$string['uploadfilelimit'] = 'Límite de tamaño del vídeo';
$string['uploadfilelimitdesc'] = 'Limita el tamaño del archivo de los vídeos subidos mediante el chunkupload.';
$string['uploadingeventfailed'] = 'Error en la creación del evento';
$string['uploadjobssaved'] = 'Carga de vídeo correcta.<br />El vídeo está programado para ser transferido a Opencast ahora. No es necesario que espere en esta página a que finalice esta transferencia.';
$string['uploadprocessingexplanation'] = 'Estos archivos de vídeo se procesarán en Opencast y luego estarán disponibles en este curso.';
$string['uploadqueuetoopencast'] = 'Vídeos programados para transferir a Opencast';
$string['uploadqueuetoopencastexplanation'] = 'En esta sección, usted ve los vídeos que han sido subidos a este curso Moodle por usted o algún otro usuario. Estos vídeos están programados para ser transferidos a Opencast ahora.<br />La transferencia se realiza automáticamente en el servidor Moodle en segundo plano. No es necesario que espere en esta página a que finalice la transferencia.';
$string['uploadrecordvideos'] = 'Cargar o grabar vídeos';
$string['uploadrecordvideosexplanation'] = 'En esta sección, puede cargar archivos de vídeo existentes en Moodle. Además, puede grabar archivos de vídeo directamente con Opencast Studio.';
$string['uploadsettings'] = 'Configuración del chunkuploader';
$string['uploadtimeout'] = 'Tiempo de carga de Moodle a Opencast';
$string['uploadtimeoutdesc'] = 'Configure el tiempo en segundos que puede tardar la carga de un solo vídeo durante la tarea de carga en segundo plano.';
$string['uploadtranscritpion'] = 'Cargar juego de transcripción';
$string['uploadvideos'] = 'Subir vídeos';
$string['uploadvideosexplanation'] = 'En esta sección, puede cargar archivos de vídeo existentes en Moodle.';
$string['uploadworkflow'] = 'Flujo de trabajo a iniciar tras la carga';
$string['uploadworkflowdesc'] = 'Establece el nombre corto único del flujo de trabajo, que debe iniciarse después de subir con éxito un archivo de vídeo a opencast. Si se deja en blanco, se utilizará el flujo de trabajo estándar (ng-schedule-and-upload). Pregunte por flujos de trabajo adicionales que pueda haber creado el administrador de opencast.';
$string['usedefaultfilepicker'] = 'Utilizar el selector de archivos por defecto de Moodle para acceder a todos los repositorios';
$string['userisntowner'] = 'Sólo el propietario del vídeo puede cambiar la propiedad.';
$string['video'] = 'Vídeo';
$string['video_already_uploaded'] = 'Vídeo ya subido';
$string['video_not_accessible'] = 'Este vídeo no se publicó en el canal de acceso directo.';
$string['video_not_downloadable'] = 'Este vídeo no se ha publicado en el canal de descargas.';
$string['video_notallowed'] = 'El vídeo no forma parte de las series de cursos.';
$string['video_retrieval_failed'] = 'No se ha podido recuperar el vídeo. Compruebe la conexión con el servidor Opencast.';
$string['videodraftdeletionsucceeded'] = 'El vídeo se ha eliminado correctamente';
$string['videodraftnotdeletable'] = 'El vídeo ya no se puede eliminar antes de la transferencia a Opencast, puesto que el estado de procesamiento ya es "{$a}".';
$string['videodraftnotfound'] = 'No se ha encontrado el vídeo que debía eliminarse antes de la transferencia a Opencast.';
$string['videoeditor_short'] = 'Editor de Vídeo';
$string['videoeditorinvalidconfig'] = 'Actualmente, no es posible utilizar Opencast Editor para editar el evento.';
$string['videonotfound'] = 'Vídeo no encontrado';
$string['videosavailable'] = 'Vídeos disponibles en este curso';
$string['videosoverviewexplanation'] = 'Aquí puede ver en qué cursos se proporcionan los vídeos como actividad a los alumnos.<br>La segunda columna muestra las actividades de los cursos en los que la serie está gestionada por el bloque Opencast. La tercera columna muestra los cursos en los que el vídeo está incrustado sin que la serie sea gestionada por el bloque.';
$string['videostoupload'] = 'Vídeos para subir a opencast';
$string['viewviedeosnotallowed'] = 'No tiene permiso para ver los vídeos de esta serie.';
$string['visibility'] = 'Visibilidad del vídeo';
$string['visibility_group'] = 'Permitir el acceso al vídeo a todos los alumnos pertenecientes a los grupos seleccionados';
$string['visibility_hide'] = 'Impedir que cualquier alumno acceda al vídeo';
$string['visibility_show'] = 'Permitir el acceso al vídeo a todos los alumnos del curso';
$string['visibilityheader'] = 'Visibilidad del evento';
$string['visibilityheaderexplanation'] = 'Puede establecer el estado de visibilidad inicial del vídeo antes de cargarlo, así como programar un cambio de visibilidad cuando esté configurado para ello.';
$string['workflow_invalid'] = 'Este flujo de trabajo no existe o no está habilitado.';
$string['workflow_not_existing'] = 'Este flujo de trabajo no existe en Opencast.';
$string['workflow_opencast_invalid'] = 'Este flujo de trabajo no existe en Opencast o está restringido. Póngase en contacto con el administrador.';
$string['workflow_settings_opencast'] = 'Configuración del flujo de trabajo';
$string['workflow_started_failure'] = 'Error al iniciar el flujo de trabajo.';
$string['workflow_started_success'] = 'Flujo de trabajo iniciado con éxito.';
$string['workflownotdefined'] = 'El flujo de trabajo para actualizar los metadatos no está definido.';
$string['workflowrolesdesc'] = 'Este flujo de trabajo se activa al actualizar metadatos de eventos o al eliminar/añadir reglas ACL no permanentes. Si no se establece, no será posible cambiar la visibilidad de los vídeos subidos a través del bloque.';
$string['workflowrolesname'] = 'Flujo de trabajo para actualizar metadatos';
$string['workflowtags_setting'] = 'Etiquetas de flujo de trabajo';
$string['workflowtags_settingdesc'] = 'Lista separada por comas de etiquetas para los flujos de trabajo de Opencast que pueden ser configurados por el administrador e iniciados manualmente por los profesores.';
$string['worklowisrunning'] = 'Se está ejecutando un flujo de trabajo. No se puede cambiar la visibilidad en este momento';
$string['wrongmimetypedetected'] = 'Se ha utilizado un mimetype no válido al subir el vídeo {$a->filename} del curso {$a->coursename}. Sólo se permiten archivos de vídeo.';
