<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_intelliboard', language 'eu', version '4.4'.
 *
 * @package     local_intelliboard
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['a0'] = 'Konpententzien aginte-panela';
$string['a1'] = 'Konpetentziak';
$string['a10'] = 'Matrikulatutako ikasleak';
$string['a11'] = 'Ikastarora esleitutako konpetentzien zerrenda';
$string['a12'] = 'Ikasle-egoera';
$string['a13'] = 'Konpetentziaren izena';
$string['a14'] = 'Noiz sortua';
$string['a15'] = 'Noiz esleituta';
$string['a16'] = 'Erakutsitako gaitasuna';
$string['a17'] = 'Puntuazioa';
$string['a18'] = 'Gaitasuna erakutsitako konpetentziak';
$string['a19'] = 'Konpetentzia puntuatutako data';
$string['a2'] = 'Gaitasuna';
$string['a20'] = 'Konpetentziaren ebaluatzailea';
$string['a21'] = 'Esleitutako jarduerak';
$string['a22'] = 'Lortutako gaitasuna';
$string['a23'] = 'Puntuatutako konpetentziak';
$string['a24'] = 'Ebidentzia kopurua';
$string['a25'] = 'Osatu duten ikasleak';
$string['a26'] = 'Taula honek ikastaro batekin lotutako konpetentziak, kalifikatuak izan diren ikasleak (gai izan ala ez) eta konpetentzian gaitasuna lortutzat emandako ikasleak erakusten ditu.';
$string['a27'] = 'guztirako hauetatik';
$string['a28'] = 'Xehetasunak';
$string['a29'] = 'Gaitu konpetentzien aginte-panela';
$string['a3'] = 'Esleitutako jarduerak';
$string['a30'] = 'Gaitu konpetentzien txostenak';
$string['a31'] = 'Markoak';
$string['a32'] = 'Ikasketa-planak';
$string['a33'] = 'Puntuatua, gai da';
$string['a34'] = 'Puntuatua, ez da gai';
$string['a35'] = 'Puntuatu gabea';
$string['a36'] = 'Konpetentzien aurrebista';
$string['a37'] = 'Ez da konpetentziarik sortu. Jarri zaitez harremanetan zure sistemako kudeatzailearekin.';
$string['a38'] = 'Konpetentziekin lotutako Ikastaroak';
$string['a39'] = 'Konpetentziak guztira';
$string['a4'] = 'Gaitasunaren aurrerapena';
$string['a40'] = 'Estekatutako ikastaroak';
$string['a5'] = 'Puntuatutako konpetentziak';
$string['a6'] = 'Ebidentzia kopurua';
$string['a7'] = 'Puntuatutako ikasleak';
$string['a8'] = 'Aurrerapena';
$string['a9'] = 'Gai diren ikasleak';
$string['account'] = 'Harpidetzaren informazioa';
$string['actions'] = 'Ekintzak';
$string['active'] = 'Aktiboa';
$string['activities'] = 'Jarduerak';
$string['activities_resources'] = 'Jarduerak/Baliabideak';
$string['activity'] = 'Jarduera';
$string['activity_grades'] = 'Jardueren kalifikazioak';
$string['activity_name'] = 'Jardueraren izena';
$string['activity_participation'] = 'Jarduerako partehartzea';
$string['activity_progress'] = 'Jarduerako aurrerapena';
$string['address'] = 'Helbidea';
$string['adm_dshb_adm_dashb_totals'] = 'Guztirakoak';
$string['adm_dshb_course_enrollments_types'] = 'Ikastaroko matrikulazio-metodoak';
$string['adm_dshb_report_activity_stats_summary'] = 'Jarduera-estatistiken Laburpen-txostena';
$string['adm_dshb_report_quiz_activity_detail'] = 'Galdetegi-jardueraren Xehetasunen Txostena';
$string['adm_dshb_report_user_status'] = 'Erabiltzaileen Egoeraren Txostena';
$string['adm_dshb_user_enr_sess_compl_act_lvls'] = 'Erabiltzaile-matrikulazioa, saioa, jardueren osaketa-mailak';
$string['adm_dshb_user_enrol_with_compl_overview'] = 'Ikastaro-matrikulazioak osaketaren aurrebistarekin';
$string['adm_dshb_user_map'] = 'Erabiltzaileen mapa';
$string['adm_dshb_user_site_summary_details'] = 'Guneko erabiltzaileen laburpenaren xehetasunak';
$string['admin_dashboard'] = 'Kudeatzaileen aginte-panela';
$string['adv_settings'] = 'Ezarpen aurreratuak';
$string['ajax'] = 'Maiztasuna';
$string['ajax_desc'] = 'AJAX bidezko saioaren gordetze-maiztasuna (segundotan). 0 ezarriz gero AJAX desgaitukoda';
$string['all_cohorts'] = 'Kohorte guztiak';
$string['all_courses'] = 'Ikastaro guztiak';
$string['all_data'] = 'Datu guztiak';
$string['all_fields_required'] = 'Eremu guztiak beharrezkoak dira';
$string['all_modules'] = 'Modulu guztiak';
$string['all_time'] = 'Denbora guztia';
$string['allmod'] = 'Jarduera guztiak';
$string['analityc_3_name'] = 'Galdetegien aurrebista eta galderen xehetasunak';
$string['analytics'] = 'Analitikak';
$string['answers'] = 'Erantzunak';
$string['api'] = 'Ordezko APIa';
$string['api_desc'] = 'Erabili ordezko API zerbitzaria (firewall-blokea saihesteko)';
$string['assignment_name'] = 'Zereginaren izena';
$string['assignments'] = 'Zereginak';
$string['attendance'] = 'Bertaratzea';
$string['attendanceapibase'] = 'Bertaratzearen APIaren oinarrizko bidea';
$string['attendanceapikey'] = 'Bertaratzearen APIaren gakoa';
$string['attendanceapisecret'] = 'Bertaratzearen APIaren sekretua';
$string['attendanceconsumerkey'] = 'Kontsumitzaile-gakoa';
$string['attendancesharedsecret'] = 'Partekatutako sekretua';
$string['attendancetoolurl'] = 'Erremintaren URLa';
$string['authentication'] = 'Kontu-sorrera';
$string['authorized_user_descr'] = 'IntelliBoardek Baimendutako erabiltzaile bat behar du. Baimendutako erabiltzailea ziur aski Guneko Kudeatzailea izango da eta web zerbitzuak, protokoloak eta token-ak kudeatzeko baimena izan behar du. Berrikuspen gehiagorako, joan Gunearen Kudeaketa > Pluginak > Web zerbitzuak > Kanpoko zerbitzuak > Intelliboard zerbitzua > Baimendutako erabiltzailea';
$string['average_grade'] = 'batez besteko kalifikazioa';
$string['avg_score'] = 'Batez besteko puntuazioa';
$string['avg_time_spent_per_stud'] = 'Ikasleko batez beste igarotako denbora';
$string['avg_visits_per_stud'] = 'Ikasleko batez besteko bisita kopurua';
$string['bb_col_api_endpoint'] = 'BlackBoard Collaborate APIaren amaiera-puntua';
$string['bb_col_consumer_key'] = 'BlackBoard Collaborate-ko kontsumitzaile-gakoa';
$string['bb_col_meetings'] = 'BlackBoard Collaborate bilerak';
$string['bb_col_secret'] = 'BlackBoard Collaborate-ko sekretua';
$string['bbbapiendpoint'] = 'BBB APIaren amaiera-puntua';
$string['bbbmeetings'] = 'BigBlueButton bilerak';
$string['bbbserversecret'] = 'BBB zerbitzariaren sekretua';
$string['billingcycles'] = 'Fakturatze-zikloak';
$string['cache_compresstracking'] = 'Gorde Moodleko cachean';
$string['cachedef_bb_collaborate_access_token'] = 'BB Collaborate sarbide-tokena';
$string['cachedef_instructor_course_data'] = 'Ikastaro-datuen cachea';
$string['cachedef_reports_list'] = 'Txosten-zerrendarako cache';
$string['cachedef_track_config'] = 'Intelliboard Jarraipenararen guztirako datuak';
$string['cachedef_tracking'] = 'Intelliboardeko jarraipeneko datuak';
$string['cancel_subscription'] = 'Bertan behera utzi harpidetza';
$string['canceled'] = 'Bertan behera utzi da';
$string['categories'] = 'Kategoriak';
$string['category'] = 'Kategoria';
$string['check_active_bb_col_meetings'] = 'Egiaztatu BlackBoard Collaborate bilera aktiboak';
$string['check_active_meetings'] = 'Egiaztatu bilera aktiboak';
$string['cipherlist'] = 'CURLOPT SSL ZIFRATZE-ZERRENDA';
$string['cipherlist_desc'] = 'Zehaztu TLS-rako erabiltzeko zifratze-metodoak';
$string['city'] = 'Hiria/Herria';
$string['class_average'] = 'Taldearen batez bestekoa';
$string['click_link_below_support_pages'] = 'Egin klik azpiko estekan IntelliBoardeko laguntza-orrietan sartzeko:';
$string['close'] = 'Itxi';
$string['closed'] = 'Itxita';
$string['cohorts'] = 'Kohorteak';
$string['completed'] = 'Osatuta';
$string['completed_activities'] = 'Osatutako Jarduerak';
$string['completed_activities_resources'] = 'Osatutako Jarduerak/Baliabideak';
$string['completed_activities_resourses'] = 'Osatutako Jarduerak/Baliabideak';
$string['completed_courses'] = 'Osatutako ikastaroak';
$string['completed_on'] = 'Osatze-data:  {$a}';
$string['completion'] = 'Osaketa';
$string['completion_is_not_enabled'] = 'Osaketa ez dago gaituta ikastaro honetan';
$string['completion_not_enabled'] = 'Osaketa Ez Gaituta';
$string['completion_status'] = 'Osaketaren egoera';
$string['completions'] = 'Jardueraren osaketaren egoera';
$string['completions_completed'] = 'Osaketaren egoera (osatuta)';
$string['completions_desc'] = '1) Erabiltzaileak jarduera hau osatu du. Ez da zehazten gainditu duen ala ez. <br>
 2) Erabiltzaileak jarduera hau osatu du gainditzeko kalifikazioa gaindituta. <br>
 3) Erabiltzaileak jarduera hau osatu du baina bere kalifikazioa ez da gainditzeko kalifikaziora heldu.';
$string['completions_fail'] = 'Osaketaren egoera (gainditu gabea)';
$string['completions_pass'] = 'Osaketaren egoera (gaindituta)';
$string['compresstracking'] = 'Osaketaren Konprimatzea';
$string['compresstracking_desc'] = 'Idatzi Denboraren Jarraipenaren datuak fitxategira edo redis-era eta bidali datuak datu-basera cron atazaren bidez (15 minutuan behin modu lehenetsian)';
$string['confirm_and_sign_up'] = 'Baieztatu eta Eman Izena';
$string['congratulations_intb_register'] = 'Zorionak';
$string['congratulations_intb_register_msg'] = 'Eskerrik asko IntelliBoardeko 15 eguneko doako proba hasteagatik! Egiaztatu ezazu mesedez zure posta elektronikoko buzoia zure IntelliBoard kontua baieztatzeko. Hasteko, Single Sign On (SSO) Esteka erabili ezazu, Gunearen Kudeaketa > IntelliBoard atalean gaituta badago edo hasi saioa <a href="https://app.intelliboard.net/signin">hemen</a>. SSO Estekak “INTELLIBOARD.NET” izena du eta Aginte-paneleko goiko eskuineko ertzean dago. Galderetarako, jarri zaitez harremanetan gurekin Support@IntelliBoard.net helbidean.';
$string['cor_incor_answers'] = 'Erantzun Zuzen/Okerrak';
$string['correct'] = 'Zuzen';
$string['correct_number'] = '{$a} zuzen';
$string['correlations'] = 'Korrelazioak';
$string['country'] = 'Herrialdea';
$string['course'] = 'Ikastaroa';
$string['course_activities'] = 'Gaitu ikastaroko jarduerak';
$string['course_category'] = 'Ikastaro-kategoria';
$string['course_chart'] = 'Gaitu ikastaroko grafikoa';
$string['course_completion_status'] = 'Ikastaroko Osaketaren Egoera';
$string['course_completions'] = 'Ikastaro-osaketak';
$string['course_enrollment_types'] = 'Ikastaroko Matrikulazio-metodoak';
$string['course_enrollments_with_completion_overview'] = 'Ikastaro-matrikulazioak Osaketaren Aurrebistarekin';
$string['course_grade'] = 'Ikastaroko Kalifikazioa';
$string['course_idnumber'] = 'ID zenbakia';
$string['course_max_grade'] = 'Ikastaroko gehieneko kalifikazioa';
$string['course_name'] = 'Ikastaroaren Izena';
$string['course_name_a'] = 'Ikastaroa: {$a}';
$string['course_overview'] = 'Ikastaroen ikuspegi orokorra';
$string['course_progress'] = 'Ikastaro-aurrerapena';
$string['course_short_name'] = 'Ikastaroaren Izen Laburra';
$string['course_start_date'] = 'Ikastaroaren hasiera-data';
$string['course_started'] = 'Ikastaroa Hasita';
$string['course_status'] = 'Egoera';
$string['course_success'] = 'Ikastaroaren arrakasta';
$string['courseaverage'] = 'Ikastaroaren batez bestekoa';
$string['coursecontainer_filter'] = 'Gaitu ikastaro-edukiontziaren iragazkia';
$string['courses'] = 'Ikastaroak';
$string['courses_avg_grade'] = 'Ikastaroen batez besteko kalifikazioa';
$string['courses_in_progress'] = 'Martxan dauden ikastaroak';
$string['courses_sum_grade'] = 'Ikastaroko Guztirako Kalifikazioa Eskala-balioen arabera';
$string['coursessessions'] = 'Ikastaroko Saioak';
$string['coursessessionspage'] = 'Ikastaroko Saioen Orria';
$string['created'] = 'Sortuta';
$string['criteria_all_courses'] = 'Hurrengo ikastaro hauetako guztiak osatuta egon behar dira';
$string['criteria_any_course'] = 'Hurrengo ikastaro hauetako edozein osatuta egon behar dira';
$string['criteria_method'] = 'Irizpide-metodoa';
$string['csv'] = 'CSV';
$string['current_grade'] = 'Oraingo kalifikazioa';
$string['customod'] = 'Jarduera pertsonalizatuak';
$string['daily'] = 'Azken 10 Egunak';
$string['dashboard'] = 'Aginte-panela';
$string['dashboard_settings'] = 'Aginte-panelaren ezarpenak';
$string['date_created'] = 'Sorrera-Data';
$string['date_format'] = 'Dataren formatua';
$string['debug'] = 'Araztu CURL eskerak';
$string['debug_desc'] = '';
$string['delete_message'] = 'Ezabatu SQL txsotena?';
$string['department'] = 'Arloa';
$string['details'] = 'Xehetasunak';
$string['disable_time_and_visits_users_overview'] = 'Desgaitu igarotako denbora eta bisitak Erabiltzailearen Aurrebistan';
$string['disabled'] = 'Desgaituta';
$string['do_not_use_compresstracking'] = 'Ez erabili Osaketaren Konprimatzea';
$string['done'] = 'Eginda!';
$string['downloadinvoice'] = 'Jaitsi Faktura';
$string['due_date'] = 'Entregatze Data';
$string['email'] = 'Helbide elektronikoa';
$string['email_is_required'] = 'Helbide elektronikoa derrigorrezkoa da';
$string['email_subscr'] = 'Harpidetzarako helbide elektronikoa';
$string['enable_badges_report'] = 'Gaitu "Dominak" txostena';
$string['enable_bb_col_debug'] = 'Gaitu BlackBoard Collaborate-ko arazketa';
$string['enable_bb_col_meetings'] = 'Gaitu BlackBoard Collaborate-ko bilerak';
$string['enable_sso'] = 'Gaitu Single Sign On (SSO) Esteka';
$string['enable_sso_descr'] = 'Gaitu Single Sign On Esteka Guneko Kudeatzaileek app.IntelliBoard.net webgunean IntelliBoardeko SuperKudeatzaileko sarrera klik bakarrarekin egin ahal izan dezaten.';
$string['enable_time_and_visits_users_overview'] = 'Gaitu igarotako denbora eta bisitak Erabiltzailearen Aurrebistan';
$string['enable_time_tracking'] = 'Gaitu Denboraren Jarraipena';
$string['enable_time_tracking_descr'] = 'Denboraren Jarraipena gaitu ezazu erabiltzaileen sarrera, bisitak eta igarotako denboraren informazio gehigarria izan ahal izateko. IntelliBoardek igarotako denboraren informazio gehigarria Moodleko igarotako denboraren tauletatik banatuta eskaintzen du.';
$string['enable_transcripts'] = 'Gaitu Transkripzioak';
$string['enable_webservice'] = 'Gaitu web zerbitzuak';
$string['enableattendance'] = 'Gaitu bertaratzea';
$string['enablebbbdebug'] = 'BigBlueButton arazte-modua';
$string['enablebbbmeetings'] = 'Gaitu monitorizatzea BigBlueButton bileretan';
$string['enabled'] = 'Jarraipena Gaituta';
$string['enabled_desc'] = 'Gaitu Jarraipena';
$string['enableexportcustomfont'] = 'Japoniera/Txinerarekin letra-mota bateragarria';
$string['enablesyncattendance'] = 'Gaitu BB Collaborate saioen eta InAttendance-ren sinkronizazioa';
$string['enroled_on'] = 'Matrikulazio-data';
$string['enrolled'] = 'Matrikulatuta';
$string['enrolled_completed'] = 'Matrikulatuta: {$a->courses}, Osatutakoak: {$a->completed_courses}';
$string['enrolled_completed_learners'] = 'Matrikulatutako/Osatu duten Ikasleak';
$string['enrolled_date'] = 'Matrikulazio-data';
$string['enrolled_users_completed'] = 'Matrikulatutako erabiltzaileak: {$a->users}, Osatu dutenak: {$a->completed}';
$string['enrollments'] = 'Matrikulazioak';
$string['enrolment_expiration'] = 'Matrikulazioaren Iraungitzea';
$string['enrolment_method'] = 'Matrikulazio-metodoa';
$string['enter_course_and_quiz'] = 'Aukeratu ezazu mesedez zure ikastaro eta galdetegia.';
$string['enter_quiz'] = 'Aukeratu ezazu mesedez zure galdetegia.';
$string['excel'] = 'Excel';
$string['expired'] = 'Iraungita';
$string['failed'] = 'Gainditu gabea';
$string['failed_on'] = 'Osatze-data (gainditu gabea): {$a}';
$string['file_compresstracking'] = 'Gorde MoodleData-n';
$string['filter1'] = 'Ezabatutako erabiltzaileak';
$string['filter1_desc'] = 'Erakutsi ezabatutako erabiltzaileak';
$string['filter2'] = 'Etendako erabiltzaileak';
$string['filter2_desc'] = 'Erakutsi etendako erabiltzaileak';
$string['filter3'] = 'Erabiltzaile gonbidatua';
$string['filter3_desc'] = 'Erakutsi [guest] erabiltzailea txostenetan';
$string['filter4'] = 'Ikastaro-iragazkia';
$string['filter4_desc'] = 'Erakutsi ezkutatutako ikastaroak';
$string['filter5'] = 'Matrikulazio-metodoaren iragazkia';
$string['filter5_desc'] = 'Erakutsi matrikulazio-metodo ez-aktiboak';
$string['filter6'] = 'Erabiltzaile-matrikulazioaren iragazkia';
$string['filter6_desc'] = 'Erakutsi matrikulazio egoera ez-aktiboa duten erabiltzaileak';
$string['filter7'] = 'Jarduera/Baliabideen iragazkia';
$string['filter7_desc'] = 'Erakutsi ezkutuan dauden Jarduera/Baliabideak';
$string['filter8'] = 'Matrikulatutako erabiltzaileen iragazkia';
$string['filter8_desc'] = 'Erakutsi soilik matrikulatutako erabiltzaileak (ez gomendatua)';
$string['filter_all_time'] = 'Denbora-iragazkia: Denbora guztia';
$string['filter_dates'] = 'Iragazi datak:';
$string['filter_last_year'] = 'Denbora-iragazkia: Azken Urtea';
$string['filter_this_year'] = 'Denbora-iragazkia: Aurten';
$string['filters'] = 'Aginte-panelaren iragazkiak';
$string['first_access'] = 'Lehen sarrera';
$string['first_name'] = 'Izena';
$string['firstname_lastname'] = '{First Name} {Last Name}';
$string['goal_grade'] = 'Helburuko Kalifikazioa';
$string['grade'] = 'Kalifikazioa';
$string['grade_activities_overview'] = 'Kalifikatutako Jardueren Aurrebista';
$string['graded'] = 'Kalifikatuta';
$string['grades'] = 'Kalifikazioak';
$string['grades_alt_text'] = 'Ordezko testua nabigazio-menurako';
$string['grid_view'] = 'Sare-ikuspegia';
$string['group_aggregation'] = 'Talde-agregazioa';
$string['help'] = 'Laguntza Behar duzu?';
$string['highest_grade'] = 'Kalifikazio Altuena';
$string['hosting_provider'] = 'Ostalaritza Hornitzailea';
$string['ianalytics'] = 'IntelliBoard Analytics';
$string['id_number'] = 'ID Zenbakia';
$string['import'] = 'Inportatu';
$string['importing_logs'] = 'Inportatze-erregistroak';
$string['importing_totals'] = 'Inportatze-guztirakoak';
$string['importtrackingtask'] = 'Inportatu Jarraipen Ataza';
$string['in1'] = 'Aurrebista';
$string['in10'] = 'Jarduera-moten Erabilera';
$string['in11'] = 'Ikaslearen Aurrerapena';
$string['in12'] = 'Kalifikazioen Aurrerapena';
$string['in13'] = 'Igarotako Denbora (%)';
$string['in14'] = 'Aurrerapena (%)';
$string['in15'] = 'Ikasleen Osatzeak';
$string['in16'] = 'Azken Sarrera';
$string['in17'] = 'Igarotako Denbora Guztia';
$string['in18'] = 'Bisita Kopurua';
$string['in19'] = 'Batez besteko Kalifikazioa';
$string['in2'] = 'Oraingo Aurrerapena';
$string['in20'] = 'Itzuli Ikasleetara';
$string['in201'] = 'Itzuli Jardueretara';
$string['in21'] = 'Ikastaroko Batez besteko Kalifikazioa';
$string['in22'] = 'Gaituta';
$string['in23'] = 'Ez daukazu erakusteko ikaslerik.';
$string['in24'] = 'Modulua';
$string['in25'] = 'Gainditzeko Kalifikazioa';
$string['in26'] = 'Ikasleen Konpromisoa';
$string['in27'] = 'Ikasle Kopurua';
$string['in28'] = 'Batez beste Igarotako Denbora';
$string['in29'] = 'Ikasle Aktiboak';
$string['in3'] = 'Ikastaroak Guztira';
$string['in30'] = 'Ikasle Ez-Aktiboak';
$string['in31'] = 'Jardueren Erabilera';
$string['in32'] = 'Batez besteko denbora aukeratutako epean';
$string['in33'] = 'Atalen Erabilera';
$string['in34'] = 'Ikasleek Kalifikazioen Eboluzioa';
$string['in4'] = 'Ikasle kopurua';
$string['in5'] = 'Ikastaro-kalifikazio kopurua';
$string['in6'] = 'Osatu duten Ikasleak';
$string['in7'] = 'Osatu ez duten Ikasleak';
$string['in8'] = 'Ikasleen Batez besteko Kalifikazioa';
$string['in9'] = 'Korrelazioak';
$string['inactivity'] = 'Jarduera-eza';
$string['inactivity_desc'] = 'Erabiltzaileen jarduerarik gabeko denbora (segundutan)';
$string['incomplete'] = 'Osatu gabe';
$string['incorrect'] = 'Okerra';
$string['incorrect_number'] = '{$a} oker';
$string['initial_reports'] = 'Hasierako Txostenak';
$string['initial_reports_warning'] = 'Txosten hauek posta elektronikoz bidali, programatu eta pertsonalizatzeko, egin klik hemen:  “<a href="{$a}">Konektatu eta Eguneratu</a>”.';
$string['inprogress'] = 'Abian';
$string['institution'] = 'Erakundea';
$string['instructor_course_shortname'] = 'Erakutsi ikastaroaren izen laburra izen luzearen ordez';
$string['instructor_course_visibility'] = 'Erakutsi ezkutatutako/etendako ikastaroak [instructor] rolari';
$string['instructor_courses_table_name'] = 'Ikastaroko Kalifikazioak';
$string['instructor_courses_table_name_activities'] = '{$a->fullname} ikastaroa, Jarduerak';
$string['instructor_courses_table_name_activity'] = '{$a->course} ikastaroa, {$a->name} jarduera, Kalifikazioak';
$string['instructor_courses_table_name_learner'] = '{$a->course} ikastaroa, {$a->learner} ikaslea, Kalifikazioak';
$string['instructor_courses_table_name_learners'] = '{$a->fullname} ikastaroa, Ikasleak';
$string['instructor_custom_groups'] = 'Irakaslearen talde pertsonalizatuak';
$string['instructor_hide_need_help'] = 'Ezkutatu "Laguntza behar duzu" botoia';
$string['instructor_hide_suspended_enrollments'] = 'Ezkutatu etendako matrikulazioak';
$string['instructor_mode'] = 'Erakutsi eskuragarri dauden ikastaro guztiak [instructor] rolari';
$string['instructor_mode_access'] = 'Erakutsi eskuragarri dauden ikastaro guztiak edizio baimenak dituen [instructor] rolari';
$string['instructor_redirect'] = 'Irakasleen berbideraketa';
$string['instructor_show_suspended_enrollments'] = 'Erakutsi etendako matrikulazioak';
$string['intb_settings_descr'] = 'IntelliBoardek harpidetzarako helbide elektroniko nagusi bat behar du. Idatzi ezazu mesedez azpiko harpidetzarako erabili nahi duzun helbide elektronikoa. Helbide elektronikoa erabili aurretik baieztapen-emailaren bidez baieztatu beharko da. Galderetarako, jarri zaitez gurekin harremanetan mesedez <a href=\'mailto:Support@IntelliBoard.net\'>Support@IntelliBoard.net</a> helbidearen bitartez. IntelliBoardeko Ezarpenen zerrenda osoa ikusteko joan zaitez Gunearen Kudeaketa > Pluginak > Plugin lokalak > IntelliBoard atalera';
$string['intelliBoard_migration_tool'] = 'IntelliBoard Migratze Tresna';
$string['intelliBoard_migration_tool_info'] = 'IntelliBoard Migratze Tresna Moodleko erregistroen tauletako datu historikoak formatu berrira migratzeko erabiltzen da. Moodleren erregistroak gordetzeko prozedura ez da aldatuko. Behin datu historikoak formatu berrira migratuta daudenean, \'Igarotako Denbora\' eta \'Bisitak\' moduko balio historikoak eskuragarri egongo dira IntelliBoard.net webgunean.';
$string['intelliboard:attendanceadmin'] = 'Bertaratzearen Kudeaketa';
$string['intelliboard:browseallcohorts'] = 'IntelliBoard [Browse All Cohorts]';
$string['intelliboard:competency'] = 'IntelliBoard [competency]';
$string['intelliboard:instructors'] = 'IntelliBoard [instructor]';
$string['intelliboard:manage'] = 'IntelliBoard [manage]';
$string['intelliboard:students'] = 'IntelliBoard [student]';
$string['intelliboard:view'] = 'IntelliBoard [view]';
$string['intelliboard_logs'] = 'IntelliBoard erregistroak';
$string['intelliboard_reports'] = 'IntelliBoard Txostenak';
$string['intelliboard_settings'] = 'IntelliBoard ezarpenak';
$string['intelliboard_start_tracking'] = 'IntelliBoard jarraipenaren hasiera';
$string['intelliboard_terms'] = 'IntelliBoard Onespenak';
$string['intelliboard_totals'] = 'Agreements guztirakoak';
$string['intelliboard_tracking'] = 'Agreements jarraipena';
$string['intelliboardaccess'] = 'Ez duzu orri hau ikusteko baimenik. Laguntza lortzeko jarri zaitez mesedez harremanetan zure Kudeatzailearekin.';
$string['intelliboardnet'] = 'IntelliBoard.net';
$string['intelliboardroot'] = 'IntelliBoard';
$string['intellicart'] = 'IntelliCart Integrazioa';
$string['intellicart_app_reports_integration'] = 'Integrazioa IntelliBoard Txostenekin';
$string['intellicart_desc'] = 'Baimendu ikasleek IntelliCart txostenak ikusteko.';
$string['intellicart_instructor_integration'] = 'Integrazioa Irakaslearen Aginte-panelarekin';
$string['intellicart_student_integration'] = 'Integrazioa Ikaslearen Aginte-panelarekin';
$string['invalid_email'] = 'Helbide elektroniko baliogabea';
$string['invalid_user'] = 'Erabiltzaile baliogabea';
$string['issuer'] = 'Emailea';
$string['items_per_query'] = 'Elementuak kontsultako';
$string['join_a_webinar'] = 'Sartu Webinar batera';
$string['key'] = 'Gakoa';
$string['last_access'] = 'Azken sarrera';
$string['last_access_on_course'] = 'Azken sarrera ikastarora: {$a}';
$string['last_day'] = 'egun';
$string['last_hour'] = 'ordu';
$string['last_month'] = 'Azken 30 egunak';
$string['last_name'] = 'Abizena';
$string['last_quarter'] = 'Azken 3 Hilabeteak';
$string['last_semester'] = 'Azken 6 Hilabeteak';
$string['last_week'] = 'Azken 7 Egunak';
$string['last_year'] = 'Azken Urtea';
$string['lastname_firstname'] = '{Last Name} {First Name}';
$string['learner_menu'] = 'Erakutsi "Ikaslearen Aginte-panela" Nabigazio-blokean soilik matrikulatutako ikasleei';
$string['learner_name'] = 'Ikaslearen Izena';
$string['learner_tf_last_week'] = 'Denbora-iragazkia: 7 Egun';
$string['learners'] = 'Ikasleak';
$string['learners_enrolled'] = 'Matrikulatutako Ikasleak';
$string['learners_enrolled_period'] = 'Aukeratutako epean matrikulatutako ikasleak';
$string['learning'] = 'Ikaskuntza';
$string['learning_plan_filter'] = 'Ikasketa-planen Iragazkia';
$string['learning_plan_viewer_role'] = '"Ikasketa-planen Ikusle" rola';
$string['learning_progress'] = 'Ikaskuntzaren Eboluzioa';
$string['letter'] = 'Letra';
$string['list_view'] = 'Zerrenda-ikuspegia';
$string['load'] = 'Errendimendua';
$string['loading'] = 'Kargatzen...';
$string['loading2'] = 'Itxaron mesedez, kargatzen...';
$string['local_intelliboard_bb_collaborate_api_request_finished'] = 'BB collaborate-ren API eskaera amaitu da';
$string['local_intelliboard_bb_collaborate_session_tracking_finished'] = 'BB collaborate saioaren jarraipena amaitu da';
$string['local_intelliboard_bb_collaborate_session_tracking_started'] = 'BB collaborate saioaren jarraipena hasi da';
$string['log_values_include'] = 'Erregistroen balioek egun bakoitzeko erabiltzaile bakoitzarenak barne ditu.';
$string['logs'] = 'Migratze Tresna';
$string['logs_to_process'] = 'Prozesatu beharreko erregistroak: {$a}';
$string['lowest_grade'] = 'Kalifikazio Baxuena';
$string['messageprovider:intelliboard_notification'] = 'Intelliboard jakinarazpena';
$string['messages'] = 'Mezuak';
$string['modulename'] = 'Moduluaren Izena';
$string['modules'] = 'Moduluak';
$string['monitors'] = 'Monitoreak';
$string['monitorselect'] = 'Aukeratu ezazu mesedez App.IntelliBoard.net webguneko monitore bat gutxienez. Egin klik Monitoreak aukeran, gero Monitoreen Ezarpenak aukeran eta aukeratu ezazu "Ikusgai Moodlen".';
$string['monthly'] = 'Azken 365 Egunak';
$string['moodle'] = 'Moodle';
$string['moodle_logs'] = 'Moodle erregistroak';
$string['moodle_settings'] = 'Moodle Ezarpenak';
$string['more_courses'] = 'Ikastaro gehiago';
$string['more_users'] = 'Erabiltzaile gehiago';
$string['my_course_average_all'] = 'ikastaroetako nire batez bestekoa (ikastaro guztiak)';
$string['mygrade'] = 'Nire Kalifikazioa';
$string['myorders'] = 'Ordenatzeak';
$string['myprogress'] = 'Nire kalifikazioen eboluzioa';
$string['myseats'] = 'Eserlekuak';
$string['mysqldaymonth'] = '%d %b %Y';
$string['mysqldayshortmonthyear'] = '%d %b, %Y';
$string['mysqlhour'] = '%h:%i %p';
$string['mysqlmonth'] = '%c';
$string['mysqlmonthdayyear'] = '%m/%d/%Y';
$string['mysqlmonthyear'] = '%M %Y';
$string['mysqlmonthyearday'] = '%M %Y, %d';
$string['mysqlquarter'] = 'lauhilekoa';
$string['mysqltimedate'] = '%h:%i%p, %d %b %Y';
$string['mysqltimemonthdayyear'] = '%H %m/%d/%Y';
$string['mysqlweek'] = '%Y, %v astea';
$string['mysqlyear'] = '%Y';
$string['mysubscriptions'] = 'Harpidetzak';
$string['mywaitlist'] = 'Itxaron-zerrenda';
$string['n1'] = 'Aurrebista [Learner Progress]';
$string['n10'] = 'Irakaslearen Aginte-panela';
$string['n101'] = 'Gaitu Irakaslearen Aginte-panela';
$string['n11'] = 'Ordezko testua Nabigazio-blokeok menurako';
$string['n12'] = 'Ikuspegi orokorra [Course Overview]';
$string['n13'] = 'Ikasle kopurua';
$string['n14'] = 'Widgeta: Ikasleen Konpromisoa';
$string['n15'] = 'Widgeta: Jarduera Erabilera';
$string['n16'] = 'Widgeta: Atalen Erabilera';
$string['n17'] = 'Analitiken Orria';
$string['n18'] = 'Widgeta: Ikasleen Kalifikazioaren Eboluzioa';
$string['n19'] = 'Ikastaroko Nabigazio Estekak Txostenetarako';
$string['n2'] = 'Aurrebista [Grade Progress]';
$string['n3'] = 'Aurrebista [Activity Progress]';
$string['n4'] = 'Aurrebista [Totals]';
$string['n5'] = 'Oraingo Aurrerapena';
$string['n6'] = 'Widgeta: Korrelazioak';
$string['n7'] = 'Widgeta: Jarduera-moten Erabilera';
$string['n8'] = 'Ikastaroak Orria';
$string['n9'] = 'Txostenak Orria';
$string['name'] = 'Izena';
$string['names_order'] = 'Izenen ordena';
$string['next'] = 'Hurrengoa';
$string['no_competency'] = 'Dirudienez zure Moodle gunean ez daude konpetentziak gaituta.';
$string['no_data'] = 'Daturik ez';
$string['no_data_notification'] = 'Ez dago daturik [date]-rako';
$string['not_connected'] = 'Konektatu gabe';
$string['not_quiz'] = 'Ups, dirudienez aukeratutako ikastaroan ez dago galdetegirik sortuta.';
$string['notstarted'] = 'Hasi gabea';
$string['num_attempts'] = 'Saiakera kopurua';
$string['num_completed_activity'] = 'Jarduera Hau Osatu Duen Erabiltzaile Kopurua';
$string['number_of_completed_learners'] = 'Osatu Duen Erabiltzaile Kopurua';
$string['number_of_learners'] = 'Matrikulatutako Erabiltzaile Kopurua';
$string['number_of_modules'] = 'Jarduera Kopurua';
$string['number_of_sessions'] = 'Saio kopurua';
$string['number_of_visits'] = 'Bisita';
$string['number_this_week'] = '{$a} aste honetan';
$string['number_today'] = '{$a} gaur';
$string['numberofseats'] = 'Eserleku kopurua';
$string['ok'] = 'Ados';
$string['overall_course_average'] = 'ikastaroetako guztirako batez bestekoa (ikasle guztiak; ikastaro guztiak)';
$string['participation'] = 'Partehartzea';
$string['passed'] = 'Gaindituta';
$string['passed_on'] = 'Osatze-data (gaindituta):  {$a}';
$string['passing_score_for'] = '{$a} gainditzeko kalifikazioa';
$string['password'] = 'Pasahitza';
$string['pdf'] = 'PDF';
$string['percentage_completed_learners'] = 'Osatu Duten Ikasleen Ehunekoa';
$string['please_accept_terms_and_conditions'] = 'Onartu itzazu mesedez arau eta baldintzak';
$string['please_wait_or_cancel'] = 'Jarraitzeko itxaron ezazu mesedez edo bestela <a href="{$a}">Utzi</a>';
$string['pluginname'] = 'IntelliBoard.net Plugina';
$string['postgredaymonth'] = 'DD Mon YYYY';
$string['postgredayshortmonthyear'] = 'DD Mon, YYYY';
$string['postgrehour'] = 'HH12:MI AM';
$string['postgremonth'] = 'MM';
$string['postgremonthdayyear'] = 'MM/DD/YYYY';
$string['postgremonthyear'] = 'Month YYYY';
$string['postgremonthyearday'] = 'Month YYYY, DD';
$string['postgrequarter'] = 'lauhilekoa';
$string['postgrequarteryear'] = 'Q YYYY';
$string['postgretimedate'] = 'HH12:MIAM, DD Mon YYYY';
$string['postgretimemonthdayyear'] = 'HH24 MM/DD/YYYY';
$string['postgreweek'] = 'YYYY, WW "astea"';
$string['postgreyear'] = 'YYYY';
$string['powered_by'] = '<a href="https://intelliboard.net/">IntelliBoard.net</a>-ek garatua';
$string['price'] = 'Prezioa';
$string['privacy:metadata:local_intelliboard_assign'] = 'Intelliboardeko zereginak-azpikontuak taula';
$string['privacy:metadata:local_intelliboard_assign:instance'] = 'Konektatutako Moodle Instantziaren IDa';
$string['privacy:metadata:local_intelliboard_assign:rel'] = 'Erregistroaren rel mota';
$string['privacy:metadata:local_intelliboard_assign:timecreated'] = 'Erregistroen aldatze-unea';
$string['privacy:metadata:local_intelliboard_assign:type'] = 'Moodle Instantzia-mota';
$string['privacy:metadata:local_intelliboard_assign:userid'] = 'Erregistroaren erabiltzailearen IDa';
$string['privacy:metadata:local_intelliboard_att_sync'] = 'Sinkronizatutako saioen zerrenda';
$string['privacy:metadata:local_intelliboard_att_sync:data'] = 'Sinkronizatze-datu gehigarriak';
$string['privacy:metadata:local_intelliboard_att_sync:id'] = 'Sinkronizatze-erregistroen IDa';
$string['privacy:metadata:local_intelliboard_att_sync:instance'] = 'Moodle saioaren IDa';
$string['privacy:metadata:local_intelliboard_att_sync:type'] = 'Saio-mota';
$string['privacy:metadata:local_intelliboard_bb_partic'] = 'Collaborate saioaren partaideen zerrenda';
$string['privacy:metadata:local_intelliboard_bb_partic:display_name'] = 'Erabiltzaile-izena';
$string['privacy:metadata:local_intelliboard_bb_partic:duration'] = 'Saioan igarotako denbora';
$string['privacy:metadata:local_intelliboard_bb_partic:external_user_id'] = 'Erabiltzaile IDa (Moodle)';
$string['privacy:metadata:local_intelliboard_bb_partic:first_join_time'] = 'Saiorako lehen sarrera';
$string['privacy:metadata:local_intelliboard_bb_partic:id'] = 'Partehartze-saioaren IDa';
$string['privacy:metadata:local_intelliboard_bb_partic:last_left_time'] = 'Saioaren azken uztea';
$string['privacy:metadata:local_intelliboard_bb_partic:rejoins'] = 'Saiora berriz konektatuen kopurua';
$string['privacy:metadata:local_intelliboard_bb_partic:role'] = 'Saioaren rola';
$string['privacy:metadata:local_intelliboard_bb_partic:sessionuid'] = 'Saioaren UUIDa';
$string['privacy:metadata:local_intelliboard_bb_partic:useruid'] = 'Erabiltzailearen UUIDa (BlackBoard Collaborate zerbitzua)';
$string['privacy:metadata:local_intelliboard_bb_trck_m'] = 'Jarraitutako saioen zerrenda';
$string['privacy:metadata:local_intelliboard_bb_trck_m:id'] = 'Jarraipen-erregistroaren IDa';
$string['privacy:metadata:local_intelliboard_bb_trck_m:sessionuid'] = 'Saioaren UUIDa';
$string['privacy:metadata:local_intelliboard_bb_trck_m:track_time'] = 'Jarraipen denbora';
$string['privacy:metadata:local_intelliboard_bbb_atten'] = 'BigBlueButton bileretako partaideen inguruko erregistroak';
$string['privacy:metadata:local_intelliboard_bbb_atten:arrivaltime'] = 'Erabiltzailea bilerara konektatu zeneko unea';
$string['privacy:metadata:local_intelliboard_bbb_atten:departuretime'] = 'Erabiltzailea bileratik deskonektatu zeneko unea';
$string['privacy:metadata:local_intelliboard_bbb_atten:fullname'] = 'Bilerako partaidearen izen osoa';
$string['privacy:metadata:local_intelliboard_bbb_atten:hasjoinedvoice'] = 'Marka. Partaideak mikrofonoa konektatu du';
$string['privacy:metadata:local_intelliboard_bbb_atten:hasvideo'] = 'Marka. Partaideak kamera konektatu du';
$string['privacy:metadata:local_intelliboard_bbb_atten:id'] = 'Partaidearen IDa';
$string['privacy:metadata:local_intelliboard_bbb_atten:islisteningonly'] = 'Marka. Partaideak ez dauka mikrofonoa edo kamera konektatuta';
$string['privacy:metadata:local_intelliboard_bbb_atten:ispresenter'] = 'Marka. Partaidea aurkezlea';
$string['privacy:metadata:local_intelliboard_bbb_atten:localmeetingid'] = 'Bileraren IDa (local_intelliboard_bbb_meet taulako IDa)';
$string['privacy:metadata:local_intelliboard_bbb_atten:meetingid'] = 'Bileraren IDa (BigBlueButton zerbitzariko IDa)';
$string['privacy:metadata:local_intelliboard_bbb_atten:role'] = 'Bilerako partaidearen rola';
$string['privacy:metadata:local_intelliboard_bbb_atten:userid'] = 'Erabiltzailearen IDa ("user" taulako errenkada)';
$string['privacy:metadata:local_intelliboard_bbb_meet'] = 'BigBlueButton bileren inguruko erregistroa';
$string['privacy:metadata:local_intelliboard_bbb_meet:attendeepw'] = 'Partaideak bileran sartzeko eskatu den pasahitza';
$string['privacy:metadata:local_intelliboard_bbb_meet:bigbluebuttonbnid'] = 'bigbluebuttonbn taulako errenkadaren IDa';
$string['privacy:metadata:local_intelliboard_bbb_meet:cmid'] = 'Ikastaro-moduluaren IDa';
$string['privacy:metadata:local_intelliboard_bbb_meet:courseid'] = 'Ikastaroaren IDa';
$string['privacy:metadata:local_intelliboard_bbb_meet:createdate'] = 'Sorrera-data (string)';
$string['privacy:metadata:local_intelliboard_bbb_meet:createtime'] = 'Sorrera-data (timestamp)';
$string['privacy:metadata:local_intelliboard_bbb_meet:dialnumber'] = 'Telefono arrunta erabiltzen duten partaideek deitu dezaketen sarbide-zenbakia.';
$string['privacy:metadata:local_intelliboard_bbb_meet:duration'] = 'Bileraren iraupena';
$string['privacy:metadata:local_intelliboard_bbb_meet:endtime'] = 'Bileraren amaiera-unea';
$string['privacy:metadata:local_intelliboard_bbb_meet:hasbeenforciblyended'] = 'Marka. Bilera indarrez amaitua izan da.';
$string['privacy:metadata:local_intelliboard_bbb_meet:hasuserjoined'] = 'Marka. Erabiltzaileak bilerara sartu dira';
$string['privacy:metadata:local_intelliboard_bbb_meet:id'] = 'Bilera-erregistroaren IDa';
$string['privacy:metadata:local_intelliboard_bbb_meet:internalmeetingid'] = '(BBB zerbitzari) barruko Bileraren IDa';
$string['privacy:metadata:local_intelliboard_bbb_meet:listenercount'] = 'Entzule kopurua';
$string['privacy:metadata:local_intelliboard_bbb_meet:maxusers'] = 'Gehieneko partaide kopurua';
$string['privacy:metadata:local_intelliboard_bbb_meet:meetingid'] = 'Bileraren IDa';
$string['privacy:metadata:local_intelliboard_bbb_meet:meetingname'] = 'Bileraren izena';
$string['privacy:metadata:local_intelliboard_bbb_meet:moderatorcount'] = 'Moderatzaile kopurua';
$string['privacy:metadata:local_intelliboard_bbb_meet:moderatorpw'] = 'Moderatzaileei bileran sartzeko edo kudeaketa-ekintza zehatz batzuk egiteko eskatuko zaien pasahitza';
$string['privacy:metadata:local_intelliboard_bbb_meet:ownerid'] = 'Jabearen IDa (bilera sortu zuen erabiltzailea)';
$string['privacy:metadata:local_intelliboard_bbb_meet:participantcount'] = 'Bertaratutakoen kopurua';
$string['privacy:metadata:local_intelliboard_bbb_meet:recording'] = 'Marka. Bilera grabatua izango da';
$string['privacy:metadata:local_intelliboard_bbb_meet:running'] = 'Bileraren egoera (active|stopped)';
$string['privacy:metadata:local_intelliboard_bbb_meet:starttime'] = 'Bileraren hasiera-unea';
$string['privacy:metadata:local_intelliboard_bbb_meet:videocount'] = 'Kamerarekin konektatutako partaide kopurua';
$string['privacy:metadata:local_intelliboard_bbb_meet:voicebridge'] = 'Ahots-zubirako luzapen-zenbakia (telefono-sistemaren bidez konektatuz gero erabilia)';
$string['privacy:metadata:local_intelliboard_bbb_meet:voiceparticipantcount'] = 'Mikrofonoarekin konektatutako partaide kopurua';
$string['privacy:metadata:local_intelliboard_details'] = 'Intelliboard-eko alt/logs/by-hour taula';
$string['privacy:metadata:local_intelliboard_details:logid'] = '[local_intelliboard_logs] taularen IDa';
$string['privacy:metadata:local_intelliboard_details:timepoint'] = 'Ordua';
$string['privacy:metadata:local_intelliboard_details:timespend'] = 'Orduko igarotako denbora';
$string['privacy:metadata:local_intelliboard_details:visits'] = 'Bisita eta saguko klik kopurua eguneko';
$string['privacy:metadata:local_intelliboard_logs'] = 'Intelliboard-eko alt/logs/by-daytaula';
$string['privacy:metadata:local_intelliboard_logs:timepoint'] = 'Urteko egunaren unea';
$string['privacy:metadata:local_intelliboard_logs:timespend'] = 'Igarotako denbora eguneko';
$string['privacy:metadata:local_intelliboard_logs:trackid'] = '[local_intelliboard_tracking] taularen IDa';
$string['privacy:metadata:local_intelliboard_logs:visits'] = 'Bisita eta saguko klik kopurua eguneko';
$string['privacy:metadata:local_intelliboard_ntf'] = 'Intelliboard-eko jakinarazpenen taula nagusia';
$string['privacy:metadata:local_intelliboard_ntf:attachment'] = 'Jakinarazpenaren eranskina';
$string['privacy:metadata:local_intelliboard_ntf:cc'] = 'Jakinarazpenaren cc-a';
$string['privacy:metadata:local_intelliboard_ntf:email'] = 'Jakinarazpenaren helbide elektronikoa';
$string['privacy:metadata:local_intelliboard_ntf:externalid'] = 'Jakinarazpenaren ExternalNID-a';
$string['privacy:metadata:local_intelliboard_ntf:id'] = 'Jakinarazpenaren IDa';
$string['privacy:metadata:local_intelliboard_ntf:message'] = 'Jakinarazpenaren mezua';
$string['privacy:metadata:local_intelliboard_ntf:state'] = 'Jakinarazpenaren egoera';
$string['privacy:metadata:local_intelliboard_ntf:subject'] = 'Jakinarazpenaren gaia';
$string['privacy:metadata:local_intelliboard_ntf:tags'] = 'Jakinarazpenaren etiketak';
$string['privacy:metadata:local_intelliboard_ntf:type'] = 'Jakinarazpen-mota';
$string['privacy:metadata:local_intelliboard_ntf:userid'] = 'Jakinarazpenaren ExternalAppIDa';
$string['privacy:metadata:local_intelliboard_ntf_hst'] = 'Intelliboard jakinarazpenen historiaren taula';
$string['privacy:metadata:local_intelliboard_ntf_hst:email'] = 'Jakinarazpenen historiaren helbide elektronikoa';
$string['privacy:metadata:local_intelliboard_ntf_hst:id'] = 'Jakinarazpenen historiaren IDa';
$string['privacy:metadata:local_intelliboard_ntf_hst:notificationid'] = 'Jakinarazpenaren ID';
$string['privacy:metadata:local_intelliboard_ntf_hst:notificationname'] = 'Jakinarazpenaren izena';
$string['privacy:metadata:local_intelliboard_ntf_hst:timesent'] = 'Jakinarazpenaren historiaren unea';
$string['privacy:metadata:local_intelliboard_ntf_hst:userid'] = 'Jakinarazpenaren ExteranAppID-a';
$string['privacy:metadata:local_intelliboard_ntf_pms'] = 'Intelliboard jakinarazpen dinamikoen parametroen taula';
$string['privacy:metadata:local_intelliboard_reports'] = 'Intelliboard SQL txosten pertsonalizatuen taula';
$string['privacy:metadata:local_intelliboard_reports:name'] = 'Txosten pertsonalizatuaren izena';
$string['privacy:metadata:local_intelliboard_reports:sqlcode'] = 'BASE64 kodetzeko SQL kodea';
$string['privacy:metadata:local_intelliboard_reports:status'] = 'Txostenaren egoera - activated/not activated';
$string['privacy:metadata:local_intelliboard_reports:timecreated'] = 'Sorrera-unea';
$string['privacy:metadata:local_intelliboard_totals'] = 'Intelliboard-eko alt/logs/total taula';
$string['privacy:metadata:local_intelliboard_totals:courses'] = 'Moodleko ikastaro kopurua guztira';
$string['privacy:metadata:local_intelliboard_totals:sessions'] = 'Moodleko erabiltzaile-saio kopurua guztira';
$string['privacy:metadata:local_intelliboard_totals:timepoint'] = 'Urteko egunaren unea';
$string['privacy:metadata:local_intelliboard_totals:timespend'] = 'Erabiltzaileek Moodlen igarotako Denbora guztira';
$string['privacy:metadata:local_intelliboard_totals:visits'] = 'Moodleko Erabiltzaile guztien Bisitak guztira';
$string['privacy:metadata:local_intelliboard_tracking'] = 'Intelliboard-eko alt/logs/all-time taula';
$string['privacy:metadata:local_intelliboard_tracking:courseid'] = 'Erabiltzaileak bisitatutako ikastaroaren IDa';
$string['privacy:metadata:local_intelliboard_tracking:firstaccess'] = 'Erabiltzaileen Lehen Sarrera';
$string['privacy:metadata:local_intelliboard_tracking:lastaccess'] = 'Erabiltzaileen Azken Sarrera';
$string['privacy:metadata:local_intelliboard_tracking:page'] = 'Orri Mota [course,module,profile,site]';
$string['privacy:metadata:local_intelliboard_tracking:param'] = 'Orri-motaren IDa';
$string['privacy:metadata:local_intelliboard_tracking:timespend'] = 'Erabiltzaileek Orrian Igarotako Denbora';
$string['privacy:metadata:local_intelliboard_tracking:useragent'] = 'Erabiltzaileen Nabigatzaile-mota';
$string['privacy:metadata:local_intelliboard_tracking:userid'] = 'Moodle Orria bisitatzen duen erabiltzailearen IDa.';
$string['privacy:metadata:local_intelliboard_tracking:userip'] = 'Erabiltzaileen Azken IP Helbidea';
$string['privacy:metadata:local_intelliboard_tracking:userlang'] = 'Erabiltzaileen Nabigatzailearen Hizkuntza';
$string['privacy:metadata:local_intelliboard_tracking:useros'] = 'Erabiltzaileen Sistema Eragilea';
$string['privacy:metadata:local_intelliboard_tracking:visits'] = 'Erabiltzaileen Bisitak Orrian';
$string['privacy:metadata:local_intelliboard_trns_c'] = 'Ikastaroko transkripzioen erregistroak';
$string['privacy:metadata:local_intelliboard_trns_c:completeddate'] = 'Osatze-data';
$string['privacy:metadata:local_intelliboard_trns_c:courseid'] = 'Ikastaroaren IDa';
$string['privacy:metadata:local_intelliboard_trns_c:coursename'] = 'Ikastaroaren izen osoa';
$string['privacy:metadata:local_intelliboard_trns_c:enroldate'] = 'Matrikulazio-data';
$string['privacy:metadata:local_intelliboard_trns_c:enrolid'] = 'Matrikulazio-erregistroaren IDa';
$string['privacy:metadata:local_intelliboard_trns_c:enroltype'] = 'Matrikulazio-metodoa';
$string['privacy:metadata:local_intelliboard_trns_c:finalgrade'] = 'Amaierako kalifikazioa';
$string['privacy:metadata:local_intelliboard_trns_c:firstname'] = 'Erabiltzailearen izena';
$string['privacy:metadata:local_intelliboard_trns_c:formattedgrade'] = 'Kalifikazio formatuduna';
$string['privacy:metadata:local_intelliboard_trns_c:gradeid'] = 'Kalifikazioaren IDa';
$string['privacy:metadata:local_intelliboard_trns_c:gradeitemid'] = 'Kalifikazio-elementuaren IDa';
$string['privacy:metadata:local_intelliboard_trns_c:grademax'] = 'Gehieneko kalifikazioa';
$string['privacy:metadata:local_intelliboard_trns_c:grademin'] = 'Gutxieneko kalifikazioa';
$string['privacy:metadata:local_intelliboard_trns_c:groupsids'] = 'Erabiltzaile-Taldeak';
$string['privacy:metadata:local_intelliboard_trns_c:lastname'] = 'Erabiltzailearen abizena';
$string['privacy:metadata:local_intelliboard_trns_c:rolesids'] = 'Erabiltzaile-Rolak';
$string['privacy:metadata:local_intelliboard_trns_c:status'] = 'Transkripzioen Egoera';
$string['privacy:metadata:local_intelliboard_trns_c:timecreated'] = 'Erregistroa sortu zeneko unea';
$string['privacy:metadata:local_intelliboard_trns_c:timemodified'] = 'Erregistroa azkenengoz eguneratu zeneko unea';
$string['privacy:metadata:local_intelliboard_trns_c:unenroldate'] = 'Desmatrikulazio-data';
$string['privacy:metadata:local_intelliboard_trns_c:useremail'] = 'Erabiltzailearen helbide elektronikoa';
$string['privacy:metadata:local_intelliboard_trns_c:userenrolid'] = 'Transkripzio-erabiltzailearen matrikulatze IDa';
$string['privacy:metadata:local_intelliboard_trns_c:userid'] = 'Erabiltzailearen IDa';
$string['privacy:metadata:local_intelliboard_trns_m'] = 'Ikastaroko transkripzioen erregistroak';
$string['privacy:metadata:local_intelliboard_trns_m:cmid'] = 'Ikastaro-moduluaren IDa';
$string['privacy:metadata:local_intelliboard_trns_m:completeddate'] = 'Osatze-data';
$string['privacy:metadata:local_intelliboard_trns_m:courseid'] = 'Ikastaroaren IDa';
$string['privacy:metadata:local_intelliboard_trns_m:finalgrade'] = 'Amaierako kalifikazioa';
$string['privacy:metadata:local_intelliboard_trns_m:formattedgrade'] = 'Kalifikazio formatuduna';
$string['privacy:metadata:local_intelliboard_trns_m:gradeid'] = 'Kalifikazioaren IDa';
$string['privacy:metadata:local_intelliboard_trns_m:gradeitemid'] = 'Kalifikazio-elementuaren IDa';
$string['privacy:metadata:local_intelliboard_trns_m:grademax'] = 'Gehieneko kalifikazioa';
$string['privacy:metadata:local_intelliboard_trns_m:grademin'] = 'Gutxieneko kalifikazioa';
$string['privacy:metadata:local_intelliboard_trns_m:moduleid'] = 'Moduluaren IDa';
$string['privacy:metadata:local_intelliboard_trns_m:modulename'] = 'Jardueraren Izena';
$string['privacy:metadata:local_intelliboard_trns_m:moduletype'] = 'Modulu-mota';
$string['privacy:metadata:local_intelliboard_trns_m:startdate'] = 'Hasiera-data';
$string['privacy:metadata:local_intelliboard_trns_m:status'] = 'Egoera';
$string['privacy:metadata:local_intelliboard_trns_m:timecreated'] = 'Erregistroa sortu zeneko unea';
$string['privacy:metadata:local_intelliboard_trns_m:timemodified'] = 'Erregistroa azkenengoz eguneratu zeneko unea';
$string['privacy:metadata:local_intelliboard_trns_m:userenrolid'] = 'Transkripzio-erabiltzailearen matrikulatze IDa';
$string['privacy:metadata:local_intelliboard_trns_m:userid'] = 'Erabiltzailearen IDa';
$string['privacy_msg'] = 'Laukitxo hau markatuta Pribatutasun Politika irakurri eta onartzen dituzula baieztatzen duzu.';
$string['privacy_policy'] = 'Pribatutasun Politika';
$string['privacy_shield_policy'] = 'Datu-prozesatzearen Addendum-a';
$string['process'] = 'Prozesua';
$string['product'] = 'Produktua';
$string['progress'] = 'Aurrerapena';
$string['protocol'] = 'Protokoloa';
$string['protocol_descr'] = 'IntelliBoard-ek REST edo SOAP protokoloa gaituta egotea behar du. Segurtasun-arrazoiak direla-eta, soilik erabiltzen diren protokoloak gaitu beharko lirateke. Berrikuspen gehigarri baterako, joan zaitez Gunearen Kudeaketa > Pluginak > Web zerbitzuak > Kudeatu protokoloak';
$string['protocols_descr'] = 'IntelliBoard-ek REST edo SOAP protokoloa gaituta egotea behar du. Segurtasun-arrazoiak direla-eta, soilik erabiltzen diren protokoloak gaitu beharko lirateke. Berrikuspen gehigarri baterako, joan zaitez Gunearen Kudeaketa > Pluginak > Web zerbitzuak > Kudeatu protokoloak';
$string['ques_breakdown'] = 'Galderen Analisia';
$string['quiz_finished'] = 'Galdetegia amaituta';
$string['quiz_grades'] = 'Galdetegiko kalifikazioak';
$string['quiz_name'] = 'Galdetegiaren Izena';
$string['quiz_name_a'] = 'Galdetegia: {$a}';
$string['quizzes'] = 'Galdetegiak';
$string['recurringperiod'] = 'Epe errepikakorra';
$string['registered'] = 'Erregistratuta';
$string['registrations'] = 'Erregistroak';
$string['remove_message'] = 'SQL txostena ezabatua izan da';
$string['report'] = 'Txostena';
$string['report1_name'] = 'Erabiltzaile-egoera';
$string['report2_name'] = 'Ikastaroko Estatistikak';
$string['report3_name'] = 'Jarduera-estatistiken Laburpena';
$string['report45_name'] = 'Galdetegiko Aktibitatearen Xehetasunak';
$string['report_activity_stats_summary'] = 'Jarduera-estatistiken Laburpena';
$string['report_user_profile_information'] = 'Erabiltzaile-profilaren Informazioa';
$string['reports'] = 'Txostenak';
$string['reportselect'] = 'Aukeratu ezazu mesedez App.IntelliBoard.net-eko txostenetako bat gutxienez. Egin klik Txosten batean, ondoren Txostenaren Ezarpenetan, eta aukeratu ezazu "Ikusgai Moodlen".';
$string['rest'] = 'REST';
$string['return_to_courses'] = 'Itzuli Ikastaroetara';
$string['return_to_grades'] = 'Itzuli Kalifikazioetara';
$string['return_to_home'] = 'Itzuli hasierara';
$string['return_to_sessions'] = 'Itzuli Saioetara';
$string['review_support_doc'] = 'Berrikusi Laguntzarako Dokumentazioa';
$string['role1'] = 'Lehen Rola';
$string['role2'] = 'Bigarren Rola';
$string['s25'] = 'Jardueran igarotako denbora';
$string['s45'] = 'Jarduera';
$string['s46'] = 'Saiakera egin duten ikasleen ehunekoa';
$string['s47'] = 'Gaia';
$string['s48'] = 'Gaian igarotako denbora';
$string['save'] = 'Gorde';
$string['scale_percentage'] = 'Ehunekoa';
$string['scale_percentage_round'] = 'Ehuneko borobildua';
$string['scale_raw'] = 'Desgaitu eskala';
$string['scale_real'] = 'Erakutsi benetako kalifikazioa ehunekoaren ordez';
$string['scale_total'] = 'Guztirako Kalifikazioa';
$string['scale_value'] = 'Balioa';
$string['scales'] = 'Gauitu eskala pertsonalizatua';
$string['scalesettings'] = 'Eskalen ezarpenak';
$string['score'] = 'Kalifikazioa';
$string['seatnumber'] = 'Eserleku Kopurua';
$string['seatscode'] = 'Eserleku-kodea';
$string['seatsused'] = 'Erabilitako Eserlekuak';
$string['section'] = 'Gaia';
$string['sections'] = 'Gaiak';
$string['select'] = 'Aukeratu';
$string['select_course'] = 'Aukeratu ikastaroa';
$string['select_date'] = 'Aukeratu Data';
$string['select_manager_role'] = 'Aukeratu kudeatzaile rola';
$string['select_quiz'] = 'Aukeratu galdetegia';
$string['select_user'] = 'Aukeratu erabiltzailea';
$string['selectall'] = 'Aukeratu Guztiak';
$string['self_hosted'] = 'Norberak ostatua';
$string['server'] = 'IntelliBoard Zerbitzaria';
$string['server_au'] = 'IntelliBoard Australia';
$string['server_error'] = 'Ups! Ezustekoren bat gertatu da. Mesedez jarri zaitez gurekin harremanetan support@intelliboard.net helbidean';
$string['server_eu'] = 'IntelliBoard Europa';
$string['server_usa'] = 'IntelliBoard AEB';
$string['session_name'] = 'Saioaren Izena';
$string['session_time'] = 'Saioaren Unea';
$string['settings'] = 'Ezarpenak';
$string['setup'] = 'Konektatu Orain';
$string['setup_subheading'] = 'Konektatu ezazu zure datuen boterea sentitzeko. Kreditu-txartelik gabe. Konpromisorik gabe. 15 eguneko datu-poztasuna baino ez.';
$string['shield_msg'] = 'Laukitxo hau markatuta Datu-prozesatzearen Addendum-a irakurri eta onartzen dituzula baieztatzen duzu.';
$string['show_dashboard_tab'] = 'Aginte-panela Orria';
$string['showing_1_to_10'] = '1etik 10era erakusten';
$string['sign_in'] = 'Hasi Saioa';
$string['sign_up'] = 'Erregistratu';
$string['sizemode'] = 'Tamaina: Handia (5.000 erabiltzailetik gora)';
$string['soap'] = 'SOAP';
$string['sqlreport'] = 'SQL txostena';
$string['sqlreportactive'] = 'Aktibatuta';
$string['sqlreportcode'] = 'SQL';
$string['sqlreportcreate'] = 'Sortu txostena';
$string['sqlreportdate'] = 'Noiz sortuta';
$string['sqlreportinactive'] = 'Desaktibatuta';
$string['sqlreportname'] = 'Txostenaren izena';
$string['sqlreports'] = 'SQL txostenak';
$string['sslversion'] = 'CURLOPT SSLVERSION';
$string['sslversion_desc'] = 'Idatzi ezazu erabili beharreko SSL/TLS bertsioa kontrolatzeko parametroa';
$string['sso'] = 'SSO esteka';
$string['sso_desc'] = 'SSO Esteka IntelliBoard.net-era';
$string['ssodomain'] = 'Azpidomeinuko SSO';
$string['ssodomain_desc'] = 'Single Sign On banatutako Zerbitzari/Kontuarekin';
$string['ssomenu'] = 'SSO Menu-Elementua';
$string['ssomenu_desc'] = 'SSO Esteka Nabigazio-blokearen menuan (ikasle edo irakasle ez direnentzat)';
$string['status'] = 'Egoera';
$string['student_course_visibility'] = 'Erakutsi ezkutuan/bertan behera utzitako ikastaroak [student] rolari';
$string['student_grades'] = 'Ikasleek kalifikazioak';
$string['student_redirect'] = 'Ikasleen berbideratzea';
$string['subscriptiondate'] = 'Harpidetza-data';
$string['success_message'] = 'SQL txostena gorde da';
$string['successfull_connected'] = 'Ondo konektatuta';
$string['support'] = 'Laguntza';
$string['support_close'] = 'Itxi';
$string['support_connect'] = 'Egin klik azpiko laukizuzenaren barruko txosten-botoiak. Bota begirada azkar bat IntelliBoard-en indarrari: botoi bakarraren bidez zure LMSaren analisirako sarbidea. Gehiago nahi duzu? Egin klik "Egin klik Analisiak ikusteko". Oraindik gehiago nahi duzu? <a href="{$a->connect_link}">“Konektatu eta Eguneratu”</a> goiko eskuinaldean, edo esteka ikusten duzun edozein lekutan.';
$string['support_demo'] = 'Programatu Erakusketa bat';
$string['support_info1'] = 'Gure <a target=\'_blank\' href=\'https://intelliboard.net/events\'>Webinar</a>-etara konektatu zaitezke eta bertan IntelliBoard 5.0 bertsioko txosten eta analitiken inguruko ibilibide bat egingo dizugu.';
$string['support_info2'] = 'Gure <a target=\'_blank\' href=\'https://intelliboard.net/events\'>Webinar</a>-etara konektatu zaitez, edo zure datuen inguruko ibilibide pertsonalizatu bat programatu ezazu. Gure mundu mailako laguntza eta zerbitzuarekin, zure LMSa argi berri batekin ikusiko duzu.';
$string['support_page'] = 'Berrikusi Dokumentazioa';
$string['support_terms'] = 'Eskubide guztiak erreserbatuta.';
$string['support_text1'] = 'Zure Moodleko datu guztiak: erraza, partekagarria, ulergarria, eta ikusgarria. IntelliBoard-ek <strong>120</strong> txosten eta monitore baino gehiago zure eskuetan jartzen duen Moodleko plugina da.';
$string['support_text2'] = 'Zure Moodleko datu guztiak: erraza, partekagarria, ulergarria, eta ikusgarria. IntelliBoard zure Moodleko txosten eta analitiketarako soluzioa da, 120 txosten eta monitore baino gehiago eskaintzen dizuna zure hezkuntza-negozioko erabaki-hartzaileak informatzen laguntzeko.';
$string['support_text3'] = 'Ongi etorri IntelliBoard-era! Mundu osoko erakundeek IntelliBoard erabiltzen dute atxikipena, aurrerapena, osatzea eta konpromisoa monitorizatzeko. Zure LMSaren datu guztiak txosten eta grafiko eskuragarri, intuitibo eta partekatzen errazetan.';
$string['support_text4'] = 'IntelliBoard pluginak zure hezkuntza-negozioko erabaki-hartzaileak zure LMSko datuetatik zuzenean informatzen du, denbora errealean.';
$string['support_text6'] = 'Informazio gehiago behar duzu? Egin klik edozein botoi urdinetan gurekin harremanetan jartzeko.';
$string['support_trial'] = 'Konektatu eta Eguneratu';
$string['suspended'] = 'Bertan behera';
$string['sync_data_with_attendance'] = 'Sinkronizatu datuak bertaratzearekin';
$string['synctranscriptstask'] = 'Sinkronizatu Transkripzioak Ataza';
$string['t01'] = 'Denbora-iragazkia: Azken 30 Egunak';
$string['t02'] = 'Denbora-iragazkia: Azken 3 Hilabeteak';
$string['t03'] = 'Denbora-iragazkia: Azken 6 Hilabeteak';
$string['t04'] = 'Gaitu [header] Osatutako ikastaroak';
$string['t05'] = 'Gaitu [header] Abian dauden Ikastaroak';
$string['t06'] = 'Gaitu [header] Ikastaroen batez besteko kalifikazioa';
$string['t07'] = 'Gaitu [header] Mezuak';
$string['t08'] = 'Gaitu [header] Ikastaroen guztirako kalifikazioa';
$string['t09'] = 'Irakasleak bere ikasleak ikusi ahal ditu';
$string['t1'] = 'Gaitu Ikaslearen Aginte-panela';
$string['t10'] = 'Gaitu [Quizzes] widget-a';
$string['t11'] = 'Gaitu [Course Progress] widget-a';
$string['t12'] = 'Gaitu [Activity participation] widget-a';
$string['t13'] = 'Gaitu [Learning] widget-a';
$string['t14'] = 'Gaitu [Course success] widget-a';
$string['t15'] = 'Gaitu [Correlations] widget-a';
$string['t16'] = 'Gaitu ikastaroko irakaslea';
$string['t17'] = 'Gaitu ikastaro-kategoria';
$string['t18'] = 'Gaitu ikastaro-osaketa';
$string['t19'] = 'Gaitu ikastaroko kalifikazioa';
$string['t2'] = 'Gaitu Aginte-panela';
$string['t20'] = 'Gaitu ikastaroko partaideen batez bestekoa';
$string['t21'] = 'Gaitu ikastaroan igarotako denbora';
$string['t22'] = 'Gaitu matrikulazio-data';
$string['t23'] = 'Gaitu [Course start date] zutabea';
$string['t24'] = 'Gaitu [Enrolled date] zutabea';
$string['t25'] = 'Gaitu [Progress] zutabea';
$string['t26'] = 'Gaitu [Letter] zutabea';
$string['t27'] = 'Gaitu [Completed Activities] zutabea';
$string['t28'] = 'Gaitu [Grade] zutabea';
$string['t29'] = 'Gaitu [Course Completion Status] zutabea';
$string['t3'] = 'Gaitu Ikastaroak';
$string['t30'] = 'Gaitu [Activity Grades] zutabea';
$string['t31'] = 'Gaitu [Assignments][Grade] widget-aren zutabea';
$string['t32'] = 'Gaitu [Assignments][Due Date] widget-aren zutabea';
$string['t33'] = 'Gaitu [Quizzes][Grade] widget-aren zutabea';
$string['t34'] = 'Gaitu [Quizzes][Due Date] widget-aren zutabea';
$string['t35'] = 'Gaitu [Course Progress][Progress] widget-aren zutabea';
$string['t36'] = 'Gaitu [Course Progress][Grade] widget-aren zutabea';
$string['t37'] = 'Gaitu [Course Progress][Enrolled] widget-aren zutabea';
$string['t38'] = 'Gaitu [Course Progress][Completed] widget-aren zutabea';
$string['t39'] = 'Gaitu [Progress][Goal Grade] aukera';
$string['t4'] = 'Gaitu Kalifikazioak';
$string['t40'] = 'Gaitu [Progress][Class Avg.] aukera';
$string['t41'] = 'Gaitu [Activity Grades header] Noiz osatuta';
$string['t42'] = 'Gaitu [Activity Grades header] Azken sarrera ikastarora';
$string['t43'] = 'Gaitu [Activity Grades] Mota zutabea';
$string['t44'] = 'Gaitu [Activity Grades] Kalifikazioa zutabea';
$string['t45'] = 'Gaitu [Activity Grades] Kalifikatuta zutabea';
$string['t46'] = 'Gaitu [Activity Grades] Osatuta zutabea';
$string['t47'] = 'Ikastaroen [grid] atzeko planoko kolorea';
$string['t48'] = 'Gaitu Txostenak';
$string['t49'] = 'Txosten-iragazkiaren zutabeak';
$string['t5'] = 'Gaitu [Activity progress] grafikoa';
$string['t50'] = 'Irakasle rolak';
$string['t51'] = 'Ikasle rolak';
$string['t52'] = 'Gaitu [Course Progress][Category] widget-aren errenkadak';
$string['t53'] = 'Gaitu [Activity progress](e)ko grafikoaren batez besteko lerroa';
$string['t54'] = 'Gaitu  [Activity Grades] Igarotako Denbora zutabea';
$string['t6'] = 'Gaitu [Course progress] grafikoa';
$string['t7'] = 'Gaitu [My course average]';
$string['t8'] = 'Gaitu [Overall course average]';
$string['t9'] = 'Gaitu [Assignments] widget-a';
$string['table_set_iag'] = 'Irakaslearen Ikastaroak > Jarduerak';
$string['table_set_iag1'] = 'Irakaslearen Ikastaroak > Jarduerak > Kalifikazioak';
$string['table_set_iag1_c1'] = 'Ikaslearen Izena';
$string['table_set_iag1_c2'] = 'Helbide elektronikoa';
$string['table_set_iag1_c3'] = 'Egoera';
$string['table_set_iag1_c4'] = 'Kalifikazioa';
$string['table_set_iag1_c5'] = 'Kalifikatuta';
$string['table_set_iag1_c6'] = 'Bisitak';
$string['table_set_iag1_c7'] = 'Igarotako Denbora';
$string['table_set_iag_c1'] = 'Jardueraren izena';
$string['table_set_iag_c2'] = 'Mota';
$string['table_set_iag_c3'] = 'Osatu duten Ikasleak';
$string['table_set_iag_c4'] = 'Batez besteko kalifikazioa';
$string['table_set_iag_c5'] = 'Bisitak';
$string['table_set_iag_c6'] = 'Igarotako Denbora';
$string['table_set_iag_c7'] = 'Ekintzak';
$string['table_set_icg'] = 'Irakaslearen Ikastaroak';
$string['table_set_icg_c1'] = 'Ikastaroaren izena';
$string['table_set_icg_c11'] = 'Ekintzak – Jarduerak';
$string['table_set_icg_c12'] = 'Ekintzak - Ikasleak';
$string['table_set_icg_c2'] = 'Izen laburra';
$string['table_set_icg_c3'] = 'Kategoria';
$string['table_set_icg_c4'] = 'Matrikulatutako/Osatu duten Ikasleak';
$string['table_set_icg_c5'] = 'Ikastaroko Batez besteko kalifikazioa';
$string['table_set_icg_c6'] = 'Atalak';
$string['table_set_icg_c7'] = 'Jarduerak/Baliabideak';
$string['table_set_icg_c8'] = 'Bisitak';
$string['table_set_icg_c9'] = 'Igarotako Denbora';
$string['table_set_ilg'] = 'Irakaslearen Ikastaroak > Ikasleak';
$string['table_set_ilg1'] = 'Irakaslearen Ikastaroak > Ikasleak > Kalifikazioa';
$string['table_set_ilg1_c1'] = 'Jardueraren izena';
$string['table_set_ilg1_c2'] = 'Mota';
$string['table_set_ilg1_c3'] = 'Kalifikazioa';
$string['table_set_ilg1_c4'] = 'Kalifikatuta';
$string['table_set_ilg1_c5'] = 'Egoera';
$string['table_set_ilg1_c6'] = 'Bisitak';
$string['table_set_ilg1_c7'] = 'Igarotako Denbora';
$string['table_set_ilg_c1'] = 'Ikaslearen Izena';
$string['table_set_ilg_c10'] = 'Ekintzak';
$string['table_set_ilg_c2'] = 'Helbide elektronikoa';
$string['table_set_ilg_c3'] = 'Matrikulatuta';
$string['table_set_ilg_c4'] = 'Azken sarrera';
$string['table_set_ilg_c5'] = 'Egoera';
$string['table_set_ilg_c6'] = 'Kalifikazioa';
$string['table_set_ilg_c7'] = 'Osatutako Jarduerak/Baliabideak';
$string['table_set_ilg_c8'] = 'Bisitak';
$string['table_set_ilg_c9'] = 'Igarotako Denbora';
$string['te1'] = 'Helbide elektronikoa';
$string['te12'] = 'Izena';
$string['te13'] = 'Abizena';
$string['te1_desc'] = 'Idatzi ezazu IntelliBoard.net-eko harpidetza egiteko erabilitako helbide elektronikoa. Ez baduzu harpidetza aktibo bat erregistratu zaitez <a target="_blank" href="https://intelliboard.net">IntelliBoard.net</a> webgunean. Ikaslearen eta Irakaslearen Aginte-panelak 4. mailako edo goragoko harpidetza batekin daude eskuragarri.';
$string['teacher'] = 'Irakaslea';
$string['telephone1'] = 'Telefonoa 1';
$string['telephone2'] = 'Telefonoa 2';
$string['term_of_use'] = 'Erabilera-baldintzak';
$string['terms_msg'] = 'Laukitxo hau markatuta Erabilera-baldintzak irakurri eta onartzen dituzula baieztatzen duzu.';
$string['tex1'] = 'IntelliBoard Ikaslearen Aginte-panela ez dago gaituta.';
$string['this_year'] = 'Urte Honetan';
$string['time'] = 'Ordua';
$string['time_1'] = 'Goizean';
$string['time_2'] = 'Arratsaldean';
$string['time_3'] = 'Gauean';
$string['time_4'] = 'Orduz kanpo';
$string['time_period_due'] = 'Denbora-tartea';
$string['time_spent'] = 'Igarotako Denbora';
$string['timespent'] = '------ Igarotako Denbora ----';
$string['tls12'] = 'TLS v1.2';
$string['tls12_desc'] = 'Ezarpen aurreratuak: TLS v1.2';
$string['topics'] = 'Gaiak';
$string['total'] = 'Guztira';
$string['total_activities_resources'] = 'Jarduerak/Baliabideak guztira';
$string['total_numbers'] = 'Data: {$a->timepoint}, Saioak: {$a->sessions}, Bisitak: {$a->visits},  Igarotako denbora: {$a->timespend}';
$string['total_numbers2'] = 'ERABILTZAILEA: {$a->userid}, Orria: {$a->page}, Param:{$a->param}, Bisitak: {$a->visits}, Igarotako Denbora: {$a->timespend}';
$string['total_numbers3'] = '----Data: {$a->timecreated}, Jarraipen IDa: {$a->trackid}, Bisitak: {$a->visits},  Igarotako Denbora: {$a->timespend}';
$string['total_time_spent'] = 'Igarotako Denbora Guztira';
$string['total_time_spent_enrolled_learners'] = 'Matrikulatutako Erabiltzaileek Ikastaroan Igarotako Denbora Guztira';
$string['total_values_include'] = 'Guztirako balioek saio bakarrak, ikastaroak, bisitak eta igarotako denbora barne hartzen dute.';
$string['total_visits_enrolled_learners'] = 'Matrikulatutako Erabiltzaileek Ikastarorako Bisitak Guztira';
$string['totara'] = 'Totara';
$string['trackadmin'] = 'Kudeatzaileen Jarraipena';
$string['trackadmin_desc'] = 'Gaitu Kudeatzaileen Denboraren Jarraipena (ez gomendatua)';
$string['trackdetails'] = 'Denboraren Jarraipena Erabiltzaileko - Orduro';
$string['tracking'] = 'Saioaren Jarraipena';
$string['tracking_title'] = 'Denboraren Jarraipena';
$string['tracklogs'] = 'Denboraren Jarraipena Erabiltzaileko - Egunero';
$string['trackmedia'] = 'Jarraitu HTML5 multimedia';
$string['trackmedia_desc'] = 'Jarraitu HTML5 bideo eta audioa';
$string['tracktotals'] = 'Jarraipen Denboraren Agregatua - Egunero';
$string['transcripts'] = 'Transkripzioak';
$string['transcriptssyncrecordsnum'] = 'Transkripzioen Prozesatzearen Tamaina';
$string['transcriptssyncrecordsnum_desc'] = 'Batera prozesatuko den erabiltzaile-matrikula kopurua';
$string['ts1'] = 'Ikaslearen Aginte-panela';
$string['ts2'] = 'Ikaslearen Aginte-panela Orria';
$string['ts3'] = 'Ikaslearen Aginte-panela Ikastaroak';
$string['ts4'] = 'Ikaslearen Aginte-panela Kalifikazioak';
$string['ts5'] = 'Ikaslearen Aginte-panela Txostenak';
$string['type'] = 'Mota';
$string['type_here'] = 'Idatzi hemen...';
$string['used'] = 'Erabilita';
$string['user_enrollments_sessions_completion'] = 'Erabiltzaile-matrikula, Saioa, Jardueren Osaketa-mailak';
$string['user_enrolments'] = 'Matrikulatutako Erabiltzaileak';
$string['user_grade_avg'] = '{$a->user} kalifikazioa: {$a->grade}, Batez besteko kalifikazioa: {$a->avg_grade_site})';
$string['user_map'] = 'Erabiltzaileen Mapa';
$string['user_site_summary_detail'] = 'Guneko Erabiltzaileen Laburpenaren Xehetasunak';
$string['user_time_avg'] = '{$a->user} denbora: {$a->timespend}, Batez besteko denbora: {$a->avg_timespend_site}';
$string['user_visit_avg'] = '{$a->user} bisitak: {$a->visits}, Batez besteko bisitak: {$a->avg_visits_site}';
$string['username'] = 'Erabiltzailearen Izena';
$string['users'] = 'Erabiltzaileak';
$string['users_activity'] = 'Erabiltzaileen jarduera';
$string['users_overview'] = 'Erabiltzaileen Aurrebista';
$string['verifyhost'] = 'CURLOPT SSL VERIFYHOST';
$string['verifyhost_desc'] = 'Aukera honek libcurl-ek zerbitzariaren ziurtagiria zerbitzariaren izenerako den egiaztatuko duen edo ez zehazten du.';
$string['verifypeer'] = 'CURLOPT SSL VERIFYPEER';
$string['verifypeer_desc'] = 'Aukera honek libcurl-ek pareen ziurtagirien benetakotasuna egiaztatuko duen edo ez zehazten du.';
$string['view_course_details'] = 'Ikusi ikastaroko xehetasunak';
$string['viewed'] = 'Ikusita';
$string['visits'] = 'Bisitak';
$string['web_services_descr'] = 'IntelliBoard-ek Web zerbitzuak gaituta egotea behar du. Web zerbitzuek beste zerbitzuek (IntelliBoard adibidez) LMS sistemara sartu eta ekintzak burutzea ahalbidetzen dute. Segurtasun-arrazoiak direla-eta, aukera hau erabili ezean desgaitu beharko litzateke. Berrikuspen gehigarri baterako, joan zaitez Gunearen Kudeaketa > Funtzio Aurreratuak > Web zerbitzuak';
$string['weekday_0'] = 'Astelehena';
$string['weekday_1'] = 'Asteartea';
$string['weekday_2'] = 'Asteazkena';
$string['weekday_3'] = 'Osteguna';
$string['weekday_4'] = 'Ostirala';
$string['weekday_5'] = 'Larunbata';
$string['weekday_6'] = 'Igandea';
$string['weekly'] = 'Azken 90 Egunak';
$string['widget_name27'] = 'Guztirako Saio-hasierak';
$string['widget_name28'] = 'Konpromisoa';
$string['widget_name29'] = 'Saio-haste bakarrak';
$string['widget_name30'] = 'Matrikulazioak ikastaroko';
$string['widget_name31'] = 'Erregistroen eta Ikuskatzaileen erabilera';
$string['x_completions'] = '{$a} Osatze';
$string['you_have_certificates'] = '{$a} ziurtagiri dituzu';
$string['you_need_to_enable_at_least_one_protocol'] = 'Gutxienez protokolo bat gaitu behar duzu';
