<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'editor_tinymce', language 'sk', version '4.4'.
 *
 * @package     editor_tinymce
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['advanced:address'] = 'Adresa';
$string['advanced:anchor_delta_height'] = '';
$string['advanced:anchor_delta_width'] = '';
$string['advanced:anchor_desc'] = 'Vložiť/upraviť názov kotvy';
$string['advanced:backcolor_desc'] = 'Vyber farbu pozadia';
$string['advanced:block'] = '- Formát -';
$string['advanced:blockquote'] = 'Bloková citácia';
$string['advanced:blockquote_desc'] = 'Bloková citácia';
$string['advanced:bold_desc'] = 'Tučný text (Ctrl+B)';
$string['advanced:bullist_desc'] = 'Vložiť/odobrať zoznam s odrážkami';
$string['advanced:charmap_delta_height'] = '';
$string['advanced:charmap_delta_width'] = '';
$string['advanced:charmap_desc'] = 'Vložiť špeciálny znak';
$string['advanced:cleanup_desc'] = 'Vyčistiť kód';
$string['advanced:clipboard_msg'] = 'Funkcie Kopírovať/vystrihnúť/vložiť nie sú podporované prehliadačmi Mozilla a Firefox.
Chceš viac informácií o tomto probléme?';
$string['advanced:code'] = 'Kód';
$string['advanced:code_desc'] = 'Upraviť HTML zdroj';
$string['advanced:colorpicker_delta_height'] = '';
$string['advanced:colorpicker_delta_width'] = '';
$string['advanced:copy_desc'] = 'Kopírovať';
$string['advanced:custom1_desc'] = 'Zadajte sem Váš voliteľný opis';
$string['advanced:cut_desc'] = 'Vystrihnúť';
$string['advanced:dd'] = 'Definícia opisu';
$string['advanced:div'] = 'DIV';
$string['advanced:dt'] = 'Definícia podmienky';
$string['advanced:font_size'] = '- Veľkosť písma  -';
$string['advanced:fontdefault'] = '- Typ písma -';
$string['advanced:forecolor_desc'] = 'Vyber farbu textu';
$string['advanced:h1'] = 'Nadpis 1 [h1]';
$string['advanced:h2'] = 'Nadpis 2 [h2]';
$string['advanced:h3'] = 'Nadpis 3 [h3]';
$string['advanced:h4'] = 'Nadpis 4 [h4]';
$string['advanced:h5'] = 'Nadpis 5 [h5]';
$string['advanced:h6'] = 'Nadpis 6 [h6]';
$string['advanced:help_desc'] = 'Nápoveda';
$string['advanced:help_shortcut'] = 'Pre lištu nástrojov stlačte ALT-F10. Pre pomocníka stlačte ALT-0';
$string['advanced:hr_desc'] = 'Vložiť vodorovný oddeľovač';
$string['advanced:image_delta_height'] = '';
$string['advanced:image_delta_width'] = '';
$string['advanced:image_desc'] = 'Vložiť/upraviť obrázok';
$string['advanced:image_props_desc'] = 'Vlastnosti obrázka';
$string['advanced:indent_desc'] = 'Zväčšiť odsadenie';
$string['advanced:italic_desc'] = 'Šikmý text (kurzivá) (Ctrl+I)';
$string['advanced:justifycenter_desc'] = 'Zarovnať na stred';
$string['advanced:justifyfull_desc'] = 'Zarovnať do bloku';
$string['advanced:justifyleft_desc'] = 'Zarovnať vľavo';
$string['advanced:justifyright_desc'] = 'Zarovnať vpravo';
$string['advanced:link_delta_height'] = '';
$string['advanced:link_delta_width'] = '';
$string['advanced:link_desc'] = 'Vložiť/upraviť odkaz';
$string['advanced:more_colors'] = 'Ďalšie farby';
$string['advanced:newdocument'] = 'Naozaj chcete vyčistiť všetok obsah?';
$string['advanced:newdocument_desc'] = 'Nový dokument';
$string['advanced:numlist_desc'] = 'Vložiť/odobrať číslovaný zoznam';
$string['advanced:outdent_desc'] = 'Zmenšiť odsadenie';
$string['advanced:paragraph'] = 'Odstavec';
$string['advanced:paste_desc'] = 'Vložiť';
$string['advanced:path'] = 'Cesta';
$string['advanced:pre'] = 'Predformátované';
$string['advanced:redo_desc'] = 'Znovu (Ctrl+Y)';
$string['advanced:removeformat_desc'] = 'Odstrániť formátovanie';
$string['advanced:rich_text_area'] = 'Formátovaná oblasť textu';
$string['advanced:samp'] = 'Ukážka kódu';
$string['advanced:shortcuts_desc'] = 'Pomoc pri prístupnosti';
$string['advanced:striketrough_desc'] = 'Preškrtnutý text';
$string['advanced:style_select'] = 'Štýly';
$string['advanced:sub_desc'] = 'Dolný index';
$string['advanced:sup_desc'] = 'Horný index';
$string['advanced:toolbar'] = 'Lišta nástrojov';
$string['advanced:toolbar_focus'] = 'Prechod na lištu nástrojov - Alt+Q, prechod na editor - Alt-Z, prechod na cestu prvkov - Alt-X';
$string['advanced:underline_desc'] = 'Podčiarknutý text (Ctrl+U)';
$string['advanced:undo_desc'] = 'Späť (Ctrl+Z)';
$string['advanced:unlink_desc'] = 'Zrušiť odkaz';
$string['advanced:visualaid_desc'] = 'Zobraziť/skryť pomocné/skryté prvky';
$string['advanced_dlg:about_author'] = 'Autor';
$string['advanced_dlg:about_general'] = 'O Programe';
$string['advanced_dlg:about_help'] = 'Nápoveda';
$string['advanced_dlg:about_license'] = 'Licencia';
$string['advanced_dlg:about_loaded'] = 'Načítané pluginy';
$string['advanced_dlg:about_plugin'] = 'Plugin';
$string['advanced_dlg:about_plugins'] = 'Pluginy';
$string['advanced_dlg:about_title'] = 'O TinyMCE';
$string['advanced_dlg:about_version'] = 'Verzia';
$string['advanced_dlg:accessibility_help'] = 'Pomoc pri prístupnosti';
$string['advanced_dlg:accessibility_usage_title'] = 'Všeobecné použitie';
$string['advanced_dlg:anchor_invalid'] = 'Prosím, určte platný názov kotvy.';
$string['advanced_dlg:anchor_name'] = 'Názov kotvy';
$string['advanced_dlg:anchor_title'] = 'Vložiť/upraviť názov kotvy';
$string['advanced_dlg:charmap_title'] = 'Vybrať špeciálny znak';
$string['advanced_dlg:charmap_usage'] = 'Na navigáciu použite ľavú a pravú šípku.';
$string['advanced_dlg:code_title'] = 'Editor HTML kódu';
$string['advanced_dlg:code_wordwrap'] = 'Zalamovať riadky';
$string['advanced_dlg:colorpicker_color'] = 'Farba:';
$string['advanced_dlg:colorpicker_name'] = 'Názov:';
$string['advanced_dlg:colorpicker_named_tab'] = 'Názvoslovia';
$string['advanced_dlg:colorpicker_named_title'] = 'Názvy farieb';
$string['advanced_dlg:colorpicker_palette_tab'] = 'Paleta';
$string['advanced_dlg:colorpicker_palette_title'] = 'Paleta farieb';
$string['advanced_dlg:colorpicker_picker_tab'] = 'Miešač';
$string['advanced_dlg:colorpicker_picker_title'] = 'Miešač farieb';
$string['advanced_dlg:colorpicker_title'] = 'Vyber farbu';
$string['advanced_dlg:image_align'] = 'Usporiadanie';
$string['advanced_dlg:image_align_baseline'] = 'Základňa';
$string['advanced_dlg:image_align_bottom'] = 'Dolu';
$string['advanced_dlg:image_align_left'] = 'Vľavo';
$string['advanced_dlg:image_align_middle'] = 'Uprostred';
$string['advanced_dlg:image_align_right'] = 'Vpravo';
$string['advanced_dlg:image_align_textbottom'] = 'Text dolu';
$string['advanced_dlg:image_align_texttop'] = 'Text hore';
$string['advanced_dlg:image_align_top'] = 'Hore';
$string['advanced_dlg:image_alt'] = 'Opis obrázku';
$string['advanced_dlg:image_border'] = 'Okraj';
$string['advanced_dlg:image_dimensions'] = 'Rozmery';
$string['advanced_dlg:image_hspace'] = 'Horizontálna medzera';
$string['advanced_dlg:image_list'] = 'Zoznam obrázkov';
$string['advanced_dlg:image_src'] = 'URL obrázka';
$string['advanced_dlg:image_title'] = 'Vložiť/editovať obrázok';
$string['advanced_dlg:image_vspace'] = 'Vertikálna medzera';
$string['advanced_dlg:invalid_color_value'] = 'Neplatná hodnota farby';
$string['advanced_dlg:link_is_email'] = 'Zdá sa, že zadaná URL je emailová adresa. Chceš vložiť povinný prefix mailto: ?';
$string['advanced_dlg:link_is_external'] = 'Zdá sa, že zadaná URL je externý odkaz. Chceš vložiť povinný prefix http:// ?';
$string['advanced_dlg:link_list'] = 'Zoznam odkazov';
$string['advanced_dlg:link_target'] = 'Cieľ odkazu';
$string['advanced_dlg:link_target_blank'] = 'Otvoriť odkaz v novom okne';
$string['advanced_dlg:link_target_same'] = 'Otvoriť odkaz v rovnakom okne';
$string['advanced_dlg:link_title'] = 'Vložiť/editovať odkaz';
$string['advanced_dlg:link_titlefield'] = 'Názov';
$string['advanced_dlg:link_url'] = 'URL odkazu';
$string['advhr:advhr_desc'] = 'Vložiť horizontálny oddeľovač';
$string['advhr:delta_height'] = '';
$string['advhr:delta_width'] = '';
$string['advhr_dlg:normal'] = 'Normálny';
$string['advhr_dlg:noshade'] = 'Bez tieňa';
$string['advhr_dlg:size'] = 'Výška';
$string['advhr_dlg:width'] = 'Šírka';
$string['advhr_dlg:widthunits'] = 'Jednotky';
$string['advimage:delta_height'] = '';
$string['advimage:delta_width'] = '';
$string['advimage:image_desc'] = 'Vložiť/editovať obrázok';
$string['advimage_dlg:align'] = 'Usporiadanie';
$string['advimage_dlg:align_baseline'] = 'Základňa';
$string['advimage_dlg:align_bottom'] = 'Dolu';
$string['advimage_dlg:align_left'] = 'Vľavo';
$string['advimage_dlg:align_middle'] = 'Uprostred';
$string['advimage_dlg:align_right'] = 'Vpravo';
$string['advimage_dlg:align_textbottom'] = 'Text dolu';
$string['advimage_dlg:align_texttop'] = 'Text hore';
$string['advimage_dlg:align_top'] = 'Hore';
$string['advimage_dlg:alt'] = 'Opis obrázku';
$string['advimage_dlg:alt_image'] = 'Alternatívny obrázok';
$string['advimage_dlg:border'] = 'Okraj';
$string['advimage_dlg:classes'] = 'CSS Trieda';
$string['advimage_dlg:constrain_proportions'] = 'Zachovať pomer strán';
$string['advimage_dlg:dialog_title'] = 'Vložiť/editovať obrázok';
$string['advimage_dlg:dimensions'] = 'Rozmery';
$string['advimage_dlg:example_img'] = 'Vzhľad náhľad obrázka';
$string['advimage_dlg:general'] = 'Hlavné nastavenia';
$string['advimage_dlg:height'] = 'Výška';
$string['advimage_dlg:hspace'] = 'Horizontálna medzera';
$string['advimage_dlg:id'] = 'ID';
$string['advimage_dlg:image_list'] = 'Zoznam obrázkov';
$string['advimage_dlg:langcode'] = 'Kód jazyka';
$string['advimage_dlg:langdir'] = 'Smer textu';
$string['advimage_dlg:list'] = 'Zoznam obrázkov';
$string['advimage_dlg:long_desc'] = 'Dlhý opis odkazu';
$string['advimage_dlg:ltr'] = 'Z ľava do prava';
$string['advimage_dlg:map'] = 'Obrázková mapa';
$string['advimage_dlg:misc'] = 'Rôzne';
$string['advimage_dlg:missing_alt'] = 'Naozaj chcete pokračovať bez vloženého opisu obrázka? Bez opisu sa bude obrázok nesprávne zobrazovať v textových prehliadačoch. Rovnako ak má užívateľ vypnuté zobrazenie obrázkov, alebo ak je užívateľ nevidiaci, bude mať problémy rozpoznať obrázok.';
$string['advimage_dlg:mouseout'] = 'ak kurzor odíde z obrázka';
$string['advimage_dlg:mouseover'] = 'ak je kurzor nad obrázkom';
$string['advimage_dlg:preview'] = 'Náhľad';
$string['advimage_dlg:rtl'] = 'Sprava doľava';
$string['advimage_dlg:src'] = 'URL obrázka';
$string['advimage_dlg:style'] = 'CSS Štýl';
$string['advimage_dlg:swap_image'] = 'Zmena obrázka';
$string['advimage_dlg:tab_advanced'] = 'Rozšírené';
$string['advimage_dlg:tab_appearance'] = 'Vzhľad';
$string['advimage_dlg:tab_general'] = 'Hlavné';
$string['advimage_dlg:title'] = 'Titulok';
$string['advimage_dlg:vspace'] = 'Vertikálna medzera';
$string['advimage_dlg:width'] = 'Šírka';
$string['advlink:delta_height'] = '';
$string['advlink:delta_width'] = '';
$string['advlink:link_desc'] = 'Vložiť/editovať odkaz';
$string['advlink_dlg:accesskey'] = 'Klávesová skratka';
$string['advlink_dlg:advanced_props'] = 'Rozšírené vlastnosti';
$string['advlink_dlg:advanced_tab'] = 'Rozšírené';
$string['advlink_dlg:anchor_names'] = 'Kotvy';
$string['advlink_dlg:classes'] = 'Trieda';
$string['advlink_dlg:encoding'] = 'Znakové kódovanie cieľa';
$string['advlink_dlg:event_props'] = 'Akcie';
$string['advlink_dlg:events_tab'] = 'Akcie';
$string['advlink_dlg:general_props'] = 'Hlavné nastavenia';
$string['advlink_dlg:general_tab'] = 'Hlavné';
$string['advlink_dlg:height'] = 'Výška';
$string['advlink_dlg:id'] = 'ID';
$string['advlink_dlg:is_email'] = 'Zdá sa, že zadaná URL je emailová adresa. Chcete vložiť povinný prefix mailto: ?';
$string['advlink_dlg:is_external'] = 'Zdá sa, že zadaná URL je externý odkaz. Chcete vložiť povinný prefix http:// ?';
$string['advlink_dlg:langcode'] = 'Kód jazyka cieľa';
$string['advlink_dlg:langdir'] = 'Smer textu';
$string['advlink_dlg:link_list'] = 'Zoznam odkazov';
$string['advlink_dlg:list'] = 'Zoznam odkazov';
$string['advlink_dlg:ltr'] = 'Zľava doprava';
$string['advlink_dlg:mime'] = 'MIME typ cieľa';
$string['advlink_dlg:popup'] = 'JavaScript popup';
$string['advlink_dlg:popup_dependent'] = 'Závislosť (iba Mozilla/Firefox)';
$string['advlink_dlg:popup_location'] = 'Zobrazovať lištu umiestnení';
$string['advlink_dlg:popup_menubar'] = 'Zobrazovať menu';
$string['advlink_dlg:popup_name'] = 'Názov okna';
$string['advlink_dlg:popup_opts'] = 'Vlastnosti';
$string['advlink_dlg:popup_position'] = 'Pozícia (X/Y)';
$string['advlink_dlg:popup_props'] = 'Vlastnosti popup okna';
$string['advlink_dlg:popup_resizable'] = 'Povoliť zmenu veľkosti okna';
$string['advlink_dlg:popup_return'] = 'Vložiť \'return false\'';
$string['advlink_dlg:popup_scrollbars'] = 'Zobrazovať posuvníky';
$string['advlink_dlg:popup_size'] = 'Veľkosť';
$string['advlink_dlg:popup_statusbar'] = 'Zobrazovať stavový riadok';
$string['advlink_dlg:popup_tab'] = 'Popup';
$string['advlink_dlg:popup_toolbar'] = 'Zobrazovať ovládaciu lištu';
$string['advlink_dlg:popup_url'] = 'Popup URL';
$string['advlink_dlg:rel'] = 'Vzťah stránky k cieľu';
$string['advlink_dlg:rev'] = 'Vzťah cieľa k stránke';
$string['advlink_dlg:rtl'] = 'Sprava doľava';
$string['advlink_dlg:style'] = 'CSS štýl';
$string['advlink_dlg:tabindex'] = 'Poradie pre tabulátor';
$string['advlink_dlg:target'] = 'Cieľ';
$string['advlink_dlg:target_blank'] = 'Otvoríť v novom okne';
$string['advlink_dlg:target_langcode'] = 'Jazyk cieľa';
$string['advlink_dlg:target_name'] = 'Názov cieľa';
$string['advlink_dlg:target_parent'] = 'Otvoríť v rodičovském okne/ráme';
$string['advlink_dlg:target_same'] = 'Otvoríť v rovnakom okne/ráme';
$string['advlink_dlg:target_top'] = 'Otvoriť v najvyššom ráme (prepíše všetky rámy)';
$string['advlink_dlg:title'] = 'Vložiť/editovať odkaz';
$string['advlink_dlg:titlefield'] = 'Názov';
$string['advlink_dlg:url'] = 'URL odkazu';
$string['advlink_dlg:width'] = 'Šírka';
$string['advlist:circle'] = 'Kruh';
$string['advlist:def'] = 'Východzí';
$string['advlist:disc'] = 'Ovál';
$string['advlist:lower_alpha'] = 'Malé písmená';
$string['advlist:lower_greek'] = 'Malé grécke písmená';
$string['advlist:lower_roman'] = 'Malé rímske číslice';
$string['advlist:square'] = 'štvorec';
$string['advlist:types'] = 'Typy';
$string['advlist:upper_alpha'] = 'Veľké písmená';
$string['advlist:upper_roman'] = 'Veľkéé rímske číslice';
$string['aria:rich_text_area'] = 'Formátovaná oblasť textu';
$string['autosave:restore_content'] = 'Obnoviť automaticky uložený obsah';
$string['autosave:unload_msg'] = 'Vykonané zmeny budú stratené, ak opustíš túto stránku.';
$string['autosave:warning_message'] = 'Ak obnovíte uložený obsah, stratíte všetok obsah, ktorý sa práve nachádza v editore.

Naozaj chcete obnoviť uložený obsah?';
$string['availablebuttons'] = 'Dostupné tlačidlá';
$string['colors:000000'] = 'Čierna';
$string['colors:000080'] = 'Tmavomodrá';
$string['colors:0000FF'] = 'Modrá';
$string['colors:003300'] = 'Tmavozelená';
$string['colors:003366'] = 'Tmavoazúrová';
$string['colors:008000'] = 'Zelená';
$string['colors:008080'] = 'Tmavomodrozelená';
$string['colors:00CCFF'] = 'Nebovo modrá';
$string['colors:00FF00'] = 'Limetkovo zelená';
$string['colors:00FFFF'] = 'Bledomodrozelená';
$string['colors:333300'] = 'Tmavoolivová';
$string['colors:333333'] = 'Tmavošedá';
$string['colors:333399'] = 'Indigovomodrá';
$string['colors:3366FF'] = 'Kráľovská modrá';
$string['colors:339966'] = 'Morská zeleň';
$string['colors:33CCCC'] = 'Tyrkysová';
$string['colors:666699'] = 'Šedomodrá';
$string['colors:800000'] = 'Gaštanovo hnedá';
$string['colors:800080'] = 'Purpurová';
$string['colors:808000'] = 'Olivová';
$string['colors:808080'] = 'Sivá';
$string['colors:993300'] = 'Tmavooranžová';
$string['colors:993366'] = 'Hnedá';
$string['colors:999999'] = 'Strednošedá';
$string['colors:99CC00'] = 'Žltozelená';
$string['colors:99CCFF'] = 'Svetlomodrá';
$string['colors:C0C0C0'] = 'Strieborná';
$string['colors:CC99FF'] = 'Slivkovomodrá';
$string['colors:CCFFCC'] = 'Bledozelená';
$string['colors:CCFFFF'] = 'Bledá azúrová';
$string['colors:FF0000'] = 'Červená';
$string['colors:FF00FF'] = 'Fialovopurpurová';
$string['colors:FF6600'] = 'Oranžová';
$string['colors:FF9900'] = 'Jantárovožltá';
$string['colors:FF99CC'] = 'Ružová';
$string['colors:FFCC00'] = 'Zlatá';
$string['colors:FFCC99'] = 'Marhuľová';
$string['colors:FFFF00'] = 'Žltá';
$string['colors:FFFF99'] = 'Svetložltá';
$string['colors:FFFFFF'] = 'Biela';
$string['common:apply'] = 'Použiť';
$string['common:browse'] = 'Prechádzať';
$string['common:cancel'] = 'Zrušiť';
$string['common:class_name'] = 'Trieda';
$string['common:clipboard_msg'] = 'Funkcie Kopírovať/vysrihnúť/vložiť nie sú podporované prehliadačmi Mozilla a Firefox. Chcete získať viac informácií o tomto probléme?';
$string['common:clipboard_no_support'] = 'Momentálne nie je podporované vaším prehliadačom. Miesto toho použite klávesovú skratku.';
$string['common:close'] = 'Zavrieť';
$string['common:edit_confirm'] = 'Chcete použiť WYSIWYG mód pre tento text?';
$string['common:insert'] = 'Vložiť';
$string['common:invalid_data'] = 'Chyba: Zadané neplatné hodnoty (zvýraznené červenou)';
$string['common:invalid_data_min'] = '{#field} musí byť číslo väčšie ako {#min}';
$string['common:invalid_data_number'] = '{#field} musí byť číslo';
$string['common:invalid_data_size'] = '{#field} musí byť číslo alebo percento';
$string['common:more_colors'] = 'Ďalšie farby';
$string['common:not_set'] = '-- Nezadané --';
$string['common:popup_blocked'] = 'Ospravedlňujeme sa, ale blokovač vyskakovacích okien neumožnil otvoriť okno, ktoré zprostredkováva funkčnosť aplikáce. Musíte vypnuť blokovanie vyskakovacích okien na tomto webe, aby bolo možné využiť jeho plnú funkčnosť.';
$string['common:update'] = 'Aktualizovať';
$string['common:value'] = '(hodnota)';
$string['contextmenu:align'] = 'Umiestnenie';
$string['contextmenu:center'] = 'Na stred';
$string['contextmenu:full'] = 'Do bloku';
$string['contextmenu:left'] = 'Vľavo';
$string['contextmenu:right'] = 'Vpravo';
$string['customconfig'] = 'Vlastná konfigurácia';
$string['customconfig_desc'] = 'Vlastná pokročilá konfigurácia TinyMCE vo formáte JSON, napríklad: {"možnosť1" : "hodnota1", "možnosť2" : "hodnota2"}. Akékoľvek možnosti tu špecifikované prepíšu štandardné nastavenia a nastavenia doplnkov.';
$string['customtoolbar'] = 'Lišta nástrojov editora';
$string['customtoolbar_desc'] = 'Každý riadok obsahuje zoznam čiarkami oddelených názvov tlačidiel, použite "obal" ako oddeľovač skupín, prázdne riadky sú ignorované. Zoznam štandardných TinyMCE tlačidiel nájdete na <a href="{$a}" target="_blank">{$a}</a> .<br />Prvý riadok sa zobrazí vždy, pričom viditeľnosť druhej a tretej lišty nástrojov je možné prepínať.';
$string['directionality:ltr_desc'] = 'Smer zľava doprava';
$string['directionality:rtl_desc'] = 'Smer sprava doľava';
$string['emotions:delta_height'] = '';
$string['emotions:delta_width'] = '';
$string['emotions:emotions_desc'] = 'Emotikony';
$string['emotions_dlg:cool'] = 'Cool';
$string['emotions_dlg:cry'] = 'Cry';
$string['emotions_dlg:desc'] = 'Emotikony';
$string['emotions_dlg:embarassed'] = 'Embarassed';
$string['emotions_dlg:foot_in_mouth'] = 'Foot in mouth';
$string['emotions_dlg:frown'] = 'Frown';
$string['emotions_dlg:innocent'] = 'Innocent';
$string['emotions_dlg:kiss'] = 'Kiss';
$string['emotions_dlg:laughing'] = 'Laughing';
$string['emotions_dlg:money_mouth'] = 'Money mouth';
$string['emotions_dlg:sealed'] = 'Sealed';
$string['emotions_dlg:smile'] = 'Smile';
$string['emotions_dlg:surprised'] = 'Surprised';
$string['emotions_dlg:title'] = 'Vložiť emotikon';
$string['emotions_dlg:tongue_out'] = 'Tongue out';
$string['emotions_dlg:undecided'] = 'Undecided';
$string['emotions_dlg:usage'] = 'Na navigáciu použite ľavú a pravú šípku.';
$string['emotions_dlg:wink'] = 'Wink';
$string['emotions_dlg:yell'] = 'Yell';
$string['fontselectlist'] = 'Zoznam dostupných fontov';
$string['fullpage:delta_height'] = '';
$string['fullpage:delta_width'] = '';
$string['fullpage:desc'] = 'Vlastnosti dokumentu';
$string['fullpage_dlg:active_color'] = 'Farba aktívneho odkazu';
$string['fullpage_dlg:add'] = 'Pridať nový prvok';
$string['fullpage_dlg:add_base'] = 'Base element';
$string['fullpage_dlg:add_comment'] = 'Comment node';
$string['fullpage_dlg:add_link'] = 'Link element';
$string['fullpage_dlg:add_meta'] = 'Meta element';
$string['fullpage_dlg:add_script'] = 'Script element';
$string['fullpage_dlg:add_style'] = 'Style element';
$string['fullpage_dlg:add_title'] = 'Title element';
$string['fullpage_dlg:advanced_props'] = 'Rozšírené';
$string['fullpage_dlg:advanced_tab'] = 'Rozšírené';
$string['fullpage_dlg:appearance_bgprops'] = 'Vlastnosti pozadia';
$string['fullpage_dlg:appearance_linkprops'] = 'Farba odkazov';
$string['fullpage_dlg:appearance_marginprops'] = 'Odsadenie tela';
$string['fullpage_dlg:appearance_style'] = 'Stylesheet and style properties';
$string['fullpage_dlg:appearance_tab'] = 'Vzhľad';
$string['fullpage_dlg:appearance_textprops'] = 'Vlastnosti textu';
$string['fullpage_dlg:author'] = 'Autor';
$string['fullpage_dlg:base_element'] = 'Base element';
$string['fullpage_dlg:bgcolor'] = 'Farba pozadia';
$string['fullpage_dlg:bgimage'] = 'Obrázok pozadia';
$string['fullpage_dlg:bottom_margin'] = 'Odsadenie zo spodu';
$string['fullpage_dlg:charset'] = 'Kódovanie';
$string['fullpage_dlg:comment_element'] = 'Poznámka';
$string['fullpage_dlg:content'] = 'Obsah';
$string['fullpage_dlg:copyright'] = 'Autorské práva';
$string['fullpage_dlg:defer'] = 'Defer';
$string['fullpage_dlg:doctypes'] = 'Doctype';
$string['fullpage_dlg:encoding'] = 'Znaková sada';
$string['fullpage_dlg:font_face'] = 'Tvar fontu';
$string['fullpage_dlg:font_size'] = 'Veľkosť fontu';
$string['fullpage_dlg:fontface'] = 'Rodina fontov';
$string['fullpage_dlg:fontsize'] = 'Veľkosť fontu';
$string['fullpage_dlg:general_props'] = 'Hlavné';
$string['fullpage_dlg:head_elements'] = 'Prvky hlavičky';
$string['fullpage_dlg:hover_color'] = 'Farba pri nabehnutí na odkaz';
$string['fullpage_dlg:href'] = 'HREF';
$string['fullpage_dlg:hreflang'] = 'Jazyk odkazu';
$string['fullpage_dlg:info'] = 'Informácie';
$string['fullpage_dlg:langcode'] = 'Kód jazyka';
$string['fullpage_dlg:langdir'] = 'Smer textu';
$string['fullpage_dlg:langprops'] = 'Jazyk a kódovanie';
$string['fullpage_dlg:language'] = 'Jazyk';
$string['fullpage_dlg:left_margin'] = 'Odsadenie zľava';
$string['fullpage_dlg:link_color'] = 'Farba odkazu';
$string['fullpage_dlg:link_element'] = 'Link element';
$string['fullpage_dlg:ltr'] = 'Zľava doprava';
$string['fullpage_dlg:media'] = 'Media';
$string['fullpage_dlg:meta_description'] = 'Opis';
$string['fullpage_dlg:meta_element'] = 'Meta element';
$string['fullpage_dlg:meta_index_follow'] = 'Index and follow the links';
$string['fullpage_dlg:meta_index_nofollow'] = 'Index and don\'t follow the links';
$string['fullpage_dlg:meta_keywords'] = 'Kľúč. slová';
$string['fullpage_dlg:meta_noindex_follow'] = 'Do not index but follow the links';
$string['fullpage_dlg:meta_noindex_nofollow'] = 'Neindexovať a nesledovať odkazy';
$string['fullpage_dlg:meta_props'] = 'Meta informácie';
$string['fullpage_dlg:meta_robots'] = 'Roboty';
$string['fullpage_dlg:meta_tab'] = 'Hlavné';
$string['fullpage_dlg:meta_title'] = 'Nádpis';
$string['fullpage_dlg:movedown'] = 'Move selected element down';
$string['fullpage_dlg:moveup'] = 'Move selected element up';
$string['fullpage_dlg:name'] = 'Názov';
$string['fullpage_dlg:properties'] = 'Vlastnosti';
$string['fullpage_dlg:rel'] = 'Rel';
$string['fullpage_dlg:remove'] = 'Odstrániť označený prvok';
$string['fullpage_dlg:rev'] = 'Rev';
$string['fullpage_dlg:right_margin'] = 'Odsadenie sprava';
$string['fullpage_dlg:rtl'] = 'Sprava doľava';
$string['fullpage_dlg:script_element'] = 'Script element';
$string['fullpage_dlg:src'] = 'Zdroj';
$string['fullpage_dlg:style'] = 'Štýl';
$string['fullpage_dlg:style_element'] = 'Style element';
$string['fullpage_dlg:stylesheet'] = 'CSS Štýl';
$string['fullpage_dlg:target'] = 'Cieľ';
$string['fullpage_dlg:text_color'] = 'Farba textu';
$string['fullpage_dlg:textcolor'] = 'Farba';
$string['fullpage_dlg:title'] = 'Vlastnosti dokumentu';
$string['fullpage_dlg:title_element'] = 'Title element';
$string['fullpage_dlg:top_margin'] = 'Odsadenie zhora';
$string['fullpage_dlg:type'] = 'Typ';
$string['fullpage_dlg:value'] = 'Hodnota';
$string['fullpage_dlg:visited_color'] = 'Farba navštíveného odkazu';
$string['fullpage_dlg:xml_pi'] = 'Deklarácia XML';
$string['fullscreen:desc'] = 'Prepnúť zobrazenie na celej obrazovke';
$string['iespell:download'] = 'ieSpell nebol nájdený. Chcete ho nainštalovať?';
$string['iespell:iespell_desc'] = 'Spustiť kontrolu pravopisu';
$string['insertdatetime:date_fmt'] = '%Y-%m-%d';
$string['insertdatetime:day_long'] = 'Nedeľa,Pondelok,Utorok,Streda,Štvrtok,Piatok,Sobota,Nedeľa';
$string['insertdatetime:day_short'] = 'Ned,Pon,Ut,Str,Štvr,Pia,Sob,Ned';
$string['insertdatetime:insertdate_desc'] = 'Vložiť dátum';
$string['insertdatetime:inserttime_desc'] = 'Vložiť čas';
$string['insertdatetime:months_long'] = 'Január,Február,Marec,Apríl,Máj,Jún,Júl,August,September,Október,November,December';
$string['insertdatetime:months_short'] = 'Jan,Feb,Mar,Apr,Máj,Jún,Júl,Aug,Sep,Okt,Nov,Dec';
$string['insertdatetime:time_fmt'] = '%H:%M:%S';
$string['layer:absolute_desc'] = 'Prepnúť na absolútne poziciovanie';
$string['layer:backward_desc'] = 'Posunúť dozadu';
$string['layer:content'] = 'Nová vrstva...';
$string['layer:forward_desc'] = 'Posunúť dopredu';
$string['layer:insertlayer_desc'] = 'Vložiť novú vrstvu';
$string['media:delta_height'] = '';
$string['media:delta_width'] = '';
$string['media:desc'] = 'Vložiť / editovať vnorené médiá';
$string['media:edit'] = 'Editovať vnorené médiá';
$string['media_dlg:advanced'] = 'Pokročilé';
$string['media_dlg:align'] = 'Zarovnať';
$string['media_dlg:align_bottom'] = 'Bottom';
$string['media_dlg:align_bottom_left'] = 'Bottom left';
$string['media_dlg:align_bottom_right'] = 'Bottom right';
$string['media_dlg:align_center'] = 'Center';
$string['media_dlg:align_left'] = 'Left';
$string['media_dlg:align_right'] = 'Vpravo';
$string['media_dlg:align_top'] = 'Top';
$string['media_dlg:align_top_left'] = 'Top left';
$string['media_dlg:align_top_right'] = 'Top right';
$string['media_dlg:altsource1'] = 'Alternatívny zdroj 1';
$string['media_dlg:altsource2'] = 'Alternatívny zdroj 2';
$string['media_dlg:audio'] = 'HTML5 audio';
$string['media_dlg:autogotourl'] = 'Auto goto URL';
$string['media_dlg:autohref'] = 'Auto HREF';
$string['media_dlg:autostart'] = 'Samospúšťanie';
$string['media_dlg:balance'] = 'Rovnováha';
$string['media_dlg:base'] = 'Základ';
$string['media_dlg:baseurl'] = 'Základná URL';
$string['media_dlg:bgcolor'] = 'Pozadie';
$string['media_dlg:cache'] = 'Záloha';
$string['media_dlg:captioningid'] = 'ID popisky média';
$string['media_dlg:center'] = 'Center';
$string['media_dlg:class_name'] = 'Trieda';
$string['media_dlg:console'] = 'Konzola';
$string['media_dlg:constrain_proportions'] = 'Zachovať proporcie';
$string['media_dlg:controller'] = 'Controller';
$string['media_dlg:controls'] = 'Controls';
$string['media_dlg:correction'] = 'Bez opravy';
$string['media_dlg:currentmarker'] = 'Current marker';
$string['media_dlg:currentposition'] = 'Current position';
$string['media_dlg:defaultframe'] = 'Predvolený rámec';
$string['media_dlg:embedded_audio_options'] = 'Možnosti vloženého audia';
$string['media_dlg:embeddedaudio'] = 'Vložené audio';
$string['media_dlg:enabled'] = 'Povoliť';
$string['media_dlg:enablejavascript'] = 'Povoliť JavaScript';
$string['media_dlg:endtime'] = 'Konečný čas';
$string['media_dlg:file'] = 'Súbor/URL';
$string['media_dlg:flash'] = 'Flash';
$string['media_dlg:flash_options'] = 'Vlastnosti Flash';
$string['media_dlg:flashvars'] = 'Parametre (Flashvars)';
$string['media_dlg:fullscreen'] = 'Celá obrazovka';
$string['media_dlg:general'] = 'Základné';
$string['media_dlg:hidden'] = 'Skrytý';
$string['media_dlg:href'] = 'HREF';
$string['media_dlg:hspace'] = 'Hor. medzera';
$string['media_dlg:html5_audio_options'] = 'Možnosti audia';
$string['media_dlg:html5_video_options'] = 'Možnosti videa HTML5';
$string['media_dlg:id'] = 'ID';
$string['media_dlg:iframe'] = 'Iframe';
$string['media_dlg:imagestatus'] = 'Image status';
$string['media_dlg:invokeurls'] = 'Invoke URLs';
$string['media_dlg:kioskmode'] = 'Kiosk mode';
$string['media_dlg:list'] = 'Zoznam';
$string['media_dlg:liveconnect'] = 'SWLiveConnect';
$string['media_dlg:loop'] = 'Slučka';
$string['media_dlg:maintainaspect'] = 'Maintain aspect';
$string['media_dlg:menu'] = 'Zobraziť menu';
$string['media_dlg:mute'] = 'Umlčať';
$string['media_dlg:name'] = 'Názov';
$string['media_dlg:nojava'] = 'Nespúšťať Javu';
$string['media_dlg:numloop'] = 'Num loops';
$string['media_dlg:play'] = 'Samospúšťanie';
$string['media_dlg:playcount'] = 'Počítadlo prehratí';
$string['media_dlg:playeveryframe'] = 'Prehrať každý frame';
$string['media_dlg:poster'] = 'Plagát';
$string['media_dlg:prefetch'] = 'Prefetch';
$string['media_dlg:preload'] = 'Vopred načítať';
$string['media_dlg:preload_auto'] = 'Nech rozhodne prehliadač používateľa';
$string['media_dlg:preload_metadata'] = 'Vopred načítať metadáta videa';
$string['media_dlg:preload_none'] = 'Nenačítať vopred';
$string['media_dlg:preview'] = 'Náhľad';
$string['media_dlg:progress'] = 'Progress';
$string['media_dlg:qt_options'] = 'Vlastnosti Quicktime';
$string['media_dlg:qt_stream_warn'] = 'Streamované rtsp zdroje môžu byť pridané do poľa \'Súbor/URL streamu pre QT\' na záložke \'Rozšírené\'.
Môžete tiež pridať nestreamovanú verziu do poľa zdroja.';
$string['media_dlg:qtsrc'] = 'QT zdroj';
$string['media_dlg:qtsrcchokespeed'] = 'Choke speed';
$string['media_dlg:quality'] = 'Kvalita';
$string['media_dlg:quicktime'] = 'QuickTime';
$string['media_dlg:rate'] = 'Pomer';
$string['media_dlg:realmedia'] = 'Real Media';
$string['media_dlg:rmp_options'] = 'Vlastnosti prehrávača Real media';
$string['media_dlg:salign'] = 'Zarovnanie okna';
$string['media_dlg:scale'] = 'Mierka';
$string['media_dlg:scriptcallbacks'] = 'Script callbacks';
$string['media_dlg:shockwave'] = 'Shockwave';
$string['media_dlg:shockwave_options'] = 'Vlastnosti Shockwave';
$string['media_dlg:shuffle'] = 'Shuffle';
$string['media_dlg:size'] = 'Rozmery';
$string['media_dlg:sound'] = 'Zvuk';
$string['media_dlg:source'] = 'Zdroj';
$string['media_dlg:starttime'] = 'Počiatočný čas';
$string['media_dlg:stretchtofit'] = 'Stretch to fit';
$string['media_dlg:swstretchhalign'] = 'Stretch H-Align';
$string['media_dlg:swstretchstyle'] = 'Štýl roztiahnutia';
$string['media_dlg:swstretchvalign'] = 'Stretch V-Align';
$string['media_dlg:target'] = 'Cieľ';
$string['media_dlg:targetcache'] = 'Cieľová medzipamäť';
$string['media_dlg:title'] = 'Vloženie / editovanie vnorených médií';
$string['media_dlg:type'] = 'Typ';
$string['media_dlg:uimode'] = 'Režim ovládacieho panelu';
$string['media_dlg:video'] = 'HTML5 video';
$string['media_dlg:volume'] = 'Hlasitosť zvuku';
$string['media_dlg:vspace'] = 'Vertikálna medzera';
$string['media_dlg:windowlessvideo'] = 'Windowless video';
$string['media_dlg:windowsmedia'] = 'Windows Media';
$string['media_dlg:wmode'] = 'WMode';
$string['media_dlg:wmp_options'] = 'Vlastnosti prehrávača Windows media player';
$string['nonbreaking:nonbreaking_desc'] = 'Vložiť znak non-breaking space';
$string['pagebreak:desc'] = 'Vložiť zalomenie stránky';
$string['paste:paste_text_desc'] = 'Vložiť ako neformátovaný text';
$string['paste:paste_word_desc'] = 'Vložiť text z aplikáce Word';
$string['paste:plaintext_mode'] = 'Vloženie zo schránky je teraz v obyčajnom textovom móde. Kliknite opäť na prepnutie do regulárneho módu vkladania.';
$string['paste:plaintext_mode_stick'] = 'Funkcia "Vložiť" je teraz v režime vkladania jednoduchého textu. Kliknite znovu, aby ste  sa prepli späť do normálneho režimu vkladania.';
$string['paste:selectall_desc'] = 'Označiť všetko';
$string['paste_dlg:text_linebreaks'] = 'Zachovať zalamovanie riadkov';
$string['paste_dlg:text_title'] = 'Použiť CTRL+V na klávesnici pre vloženie textu do okna.';
$string['paste_dlg:word_title'] = 'Použiť CTRL+V na klávesnici pre vloženie textu do okna.';
$string['pluginname'] = 'TinyMCE editor';
$string['preview:preview_desc'] = 'Náhľad';
$string['print:print_desc'] = 'Vytlačiť';
$string['privacy:metadata'] = 'Zásuvný modul editor_tinymce neukladá žiadne osobné údaje.';
$string['save:cancel_desc'] = 'Zrušiť všetky zmeny';
$string['save:save_desc'] = 'Uložiť';
$string['searchreplace:delta_height'] = '';
$string['searchreplace:delta_width'] = '';
$string['searchreplace:replace_desc'] = 'Nájsť/Nahradiť';
$string['searchreplace:search_desc'] = 'Nájsť';
$string['searchreplace_dlg:allreplaced'] = 'Všetky výskyty reťazca boly zmenené.';
$string['searchreplace_dlg:direction'] = 'Smer';
$string['searchreplace_dlg:down'] = 'Dolu';
$string['searchreplace_dlg:findnext'] = 'Nájsť ďalší';
$string['searchreplace_dlg:findwhat'] = 'Nájsť výraz';
$string['searchreplace_dlg:mcase'] = 'Presná zhoda';
$string['searchreplace_dlg:notfound'] = 'Vyhľadávanie ukončené. Reťazec nemusel byť nájdený.';
$string['searchreplace_dlg:replace'] = 'Nahradiť';
$string['searchreplace_dlg:replace_title'] = 'Nájsť/Nahradiť';
$string['searchreplace_dlg:replaceall'] = 'Nahradiť všetko';
$string['searchreplace_dlg:replacewith'] = 'Nahradiť s';
$string['searchreplace_dlg:search_title'] = 'Nájsť';
$string['searchreplace_dlg:searchnext_desc'] = 'Nájsťi znova';
$string['searchreplace_dlg:up'] = 'Nahor';
$string['settings'] = 'Všeobecné nastavenia';
$string['simple:bold_desc'] = 'Tučný text (Ctrl+B)';
$string['simple:bullist_desc'] = 'Vložiť/odstrániť zoznam s odrážkami';
$string['simple:cleanup_desc'] = 'Vyčistiť neupravený kód';
$string['simple:italic_desc'] = 'Šikmý text (kurzivá) (Ctrl+I)';
$string['simple:numlist_desc'] = 'Vložiť/odstrániť číslovaný zoznam';
$string['simple:redo_desc'] = 'Znovu (Ctrl+Y)';
$string['simple:striketrough_desc'] = 'Preškrtnutý text';
$string['simple:underline_desc'] = 'Podčiarknutý text (Ctrl+U)';
$string['simple:undo_desc'] = 'Späť (Ctrl+Z)';
$string['spellchecker:desc'] = 'Prepnúť kontrolu pravopisu';
$string['spellchecker:ignore_word'] = 'Vynechať slovo';
$string['spellchecker:ignore_words'] = 'Vynechať všetky';
$string['spellchecker:langs'] = 'Jazyky';
$string['spellchecker:learn_word'] = 'Naučiť sa slovo';
$string['spellchecker:menu'] = 'Nastavenia kontroly pravopisu';
$string['spellchecker:no_mpell'] = 'Bez pravopisných chýb.';
$string['spellchecker:no_sug'] = 'Bez návrhov';
$string['spellchecker:sug'] = 'Ponuky';
$string['spellchecker:wait'] = 'Prosím čakajte ...';
$string['style:delta_height'] = '';
$string['style:delta_width'] = '';
$string['style:desc'] = 'Editovať CSS Štýl';
$string['style_dlg:apply'] = 'Aplikovať';
$string['style_dlg:background'] = 'Pozadie';
$string['style_dlg:background_attachment'] = 'Attachment';
$string['style_dlg:background_color'] = 'Background color';
$string['style_dlg:background_hpos'] = 'Horizontal position';
$string['style_dlg:background_image'] = 'Background image';
$string['style_dlg:background_repeat'] = 'Repeat';
$string['style_dlg:background_tab'] = 'Pozadie';
$string['style_dlg:background_vpos'] = 'Vertical position';
$string['style_dlg:block'] = 'Blok';
$string['style_dlg:block_display'] = 'Display';
$string['style_dlg:block_letterspacing'] = 'Letter spacing';
$string['style_dlg:block_tab'] = 'Block';
$string['style_dlg:block_text_align'] = 'Text align';
$string['style_dlg:block_text_indent'] = 'Text indent';
$string['style_dlg:block_vertical_alignment'] = 'Vertical alignment';
$string['style_dlg:block_whitespace'] = 'Whitespace';
$string['style_dlg:block_wordspacing'] = 'Word spacing';
$string['style_dlg:border'] = 'Ohraničenie';
$string['style_dlg:border_tab'] = 'Border';
$string['style_dlg:bottom'] = 'Bottom';
$string['style_dlg:box'] = 'Políčko';
$string['style_dlg:box_clear'] = 'Clear';
$string['style_dlg:box_float'] = 'Float';
$string['style_dlg:box_height'] = 'Výška';
$string['style_dlg:box_tab'] = 'Box';
$string['style_dlg:box_width'] = 'Šírka';
$string['style_dlg:bullet_image'] = 'Bullet image';
$string['style_dlg:clip'] = 'Clip';
$string['style_dlg:color'] = 'Farba';
$string['style_dlg:height'] = 'Výška';
$string['style_dlg:left'] = 'Left';
$string['style_dlg:list'] = 'Zoznam';
$string['style_dlg:list_tab'] = 'List';
$string['style_dlg:list_type'] = 'Type';
$string['style_dlg:margin'] = 'Margin';
$string['style_dlg:overflow'] = 'Overflow';
$string['style_dlg:padding'] = 'Padding';
$string['style_dlg:placement'] = 'Placement';
$string['style_dlg:position'] = 'Position';
$string['style_dlg:positioning_tab'] = 'Positioning';
$string['style_dlg:positioning_type'] = 'Type';
$string['style_dlg:right'] = 'Vpravo';
$string['style_dlg:same'] = 'Same for all';
$string['style_dlg:style'] = 'Style';
$string['style_dlg:text'] = 'Text';
$string['style_dlg:text_blink'] = 'Blikanie';
$string['style_dlg:text_case'] = 'Case';
$string['style_dlg:text_color'] = 'Farba';
$string['style_dlg:text_decoration'] = 'Decoration';
$string['style_dlg:text_font'] = 'Font';
$string['style_dlg:text_lineheight'] = 'Line height';
$string['style_dlg:text_none'] = 'žiadna';
$string['style_dlg:text_overline'] = 'Nadtrhnutie';
$string['style_dlg:text_props'] = 'Text';
$string['style_dlg:text_size'] = 'Veľkosť';
$string['style_dlg:text_striketrough'] = 'Prešktrtnutie';
$string['style_dlg:text_style'] = 'Style';
$string['style_dlg:text_tab'] = 'Text';
$string['style_dlg:text_underline'] = 'Podtrhnutie';
$string['style_dlg:text_variant'] = 'Variant';
$string['style_dlg:text_weight'] = 'Weight';
$string['style_dlg:title'] = 'Upraviť CSS štýl';
$string['style_dlg:toggle_insert_span'] = 'Pri výbere vložte rozsah';
$string['style_dlg:top'] = 'Top';
$string['style_dlg:visibility'] = 'Visibility';
$string['style_dlg:width'] = 'Šírka';
$string['style_dlg:zindex'] = 'Z-index';
$string['subplugintype_tinymce'] = 'Doplnok';
$string['subplugintype_tinymce_plural'] = 'Doplnky';
$string['table:cell'] = 'Bunka';
$string['table:cell_desc'] = 'Vlastnosti bunky tabuľky';
$string['table:cellprops_delta_height'] = '';
$string['table:cellprops_delta_width'] = '';
$string['table:col'] = 'Stĺpec';
$string['table:col_after_desc'] = 'Vložiť stĺpec za';
$string['table:col_before_desc'] = 'Vložiť stĺpec pred';
$string['table:copy_row_desc'] = 'Kopírovať riadok';
$string['table:cut_row_desc'] = 'Vystrihnúť riadok';
$string['table:del'] = 'Odstrániť tabuľku';
$string['table:delete_col_desc'] = 'Odstrániť stĺpec tabuľky';
$string['table:delete_row_desc'] = 'Odstrániť riadok tabuľky';
$string['table:desc'] = 'Vložiť novú tabuľku';
$string['table:merge_cells_delta_height'] = '';
$string['table:merge_cells_delta_width'] = '';
$string['table:merge_cells_desc'] = 'Zlúčiť bunky';
$string['table:paste_row_after_desc'] = 'Vložiť riadok za';
$string['table:paste_row_before_desc'] = 'Vložiť riadok pred';
$string['table:props_desc'] = 'Vlastnosti tabuľky';
$string['table:row'] = 'Riadok';
$string['table:row_after_desc'] = 'Vložiť riadok za';
$string['table:row_before_desc'] = 'Vložiť riadok pred';
$string['table:row_desc'] = 'Vlastnosti riadky tabuľky';
$string['table:rowprops_delta_height'] = '';
$string['table:rowprops_delta_width'] = '';
$string['table:split_cells_desc'] = 'Rozdeliť zlúčené bunky';
$string['table:table_delta_height'] = '';
$string['table:table_delta_width'] = '';
$string['table_dlg:advanced_props'] = 'Rozšírené vlastnosti';
$string['table_dlg:advanced_tab'] = 'Rozšírené';
$string['table_dlg:align'] = 'Poloha';
$string['table_dlg:align_bottom'] = 'Dolu';
$string['table_dlg:align_default'] = 'Predvolene';
$string['table_dlg:align_left'] = 'Vľavo';
$string['table_dlg:align_middle'] = 'Na stred';
$string['table_dlg:align_right'] = 'Vpravo';
$string['table_dlg:align_top'] = 'Hore';
$string['table_dlg:bgcolor'] = 'Farba pozadia';
$string['table_dlg:bgimage'] = 'Obrázok pozadia';
$string['table_dlg:border'] = 'Rámček';
$string['table_dlg:bordercolor'] = 'Farba orámovania';
$string['table_dlg:caption'] = 'Table caption';
$string['table_dlg:cell_all'] = 'Aktualizovať všetky bunky v tebuľke';
$string['table_dlg:cell_cell'] = 'Aktualizovať aktuálnu bunku';
$string['table_dlg:cell_col'] = 'Aktualizovať všetky bunky v stĺpci';
$string['table_dlg:cell_limit'] = 'Bol presiahnutý maximálny počet buniek {$cells}.';
$string['table_dlg:cell_row'] = 'Aktualizovať všetky bunky v riadku';
$string['table_dlg:cell_title'] = 'Vlastnosti buniek tabuľky';
$string['table_dlg:cell_type'] = 'Tyb bunky';
$string['table_dlg:cellpadding'] = 'Odsadenie obsahu';
$string['table_dlg:cellspacing'] = 'Rozostup buniek';
$string['table_dlg:col_limit'] = 'Bol presiahnutý maximálny počet stĺpcov {$cols}.';
$string['table_dlg:colgroup'] = 'Skupina stĺpcov';
$string['table_dlg:cols'] = 'Stĺpce';
$string['table_dlg:frame'] = 'Rámček';
$string['table_dlg:frame_all'] = 'všetky';
$string['table_dlg:frame_cols'] = 'stĺpce';
$string['table_dlg:frame_groups'] = 'groups';
$string['table_dlg:frame_none'] = 'žiadne';
$string['table_dlg:frame_rows'] = 'riadky';
$string['table_dlg:general_props'] = 'Hlavné vlastnosti';
$string['table_dlg:general_tab'] = 'Hlavné';
$string['table_dlg:height'] = 'Výška';
$string['table_dlg:id'] = 'ID';
$string['table_dlg:langcode'] = 'Kód jazyka';
$string['table_dlg:langdir'] = 'Smer textu';
$string['table_dlg:ltr'] = 'Zľava doprava';
$string['table_dlg:merge_cells_title'] = 'Zlúčiť bunky tabuľky';
$string['table_dlg:mime'] = 'Cieľový typ MIME';
$string['table_dlg:missing_scope'] = 'Naozaj chcete pokračovať bez určenia oblasti hlavičky tejto tabuľky? Bez nej môže u niektorých používateľov dochádzať k určitým problémom pri interpretácii a zobrazovaní údajov v tabuľce.';
$string['table_dlg:row_all'] = 'Aktualizovať všetky riadky v tabuľke';
$string['table_dlg:row_even'] = 'Aktualizovať nepárne riadky v tabuľke';
$string['table_dlg:row_limit'] = 'Bol presiahnutý maximálny počet riadkov {$rows}.';
$string['table_dlg:row_odd'] = 'Aktualizovať odd rows in table';
$string['table_dlg:row_row'] = 'Aktualizovať aktuálny riadok';
$string['table_dlg:row_title'] = 'Vlastnosti riadkov tabuľky';
$string['table_dlg:rowgroup'] = 'Skupina riadkov';
$string['table_dlg:rows'] = 'Riadky';
$string['table_dlg:rowtype'] = 'Typ riadku';
$string['table_dlg:rtl'] = 'Sprava doľava';
$string['table_dlg:rules'] = 'Pravidlá';
$string['table_dlg:rules_above'] = 'above';
$string['table_dlg:rules_below'] = 'below';
$string['table_dlg:rules_border'] = 'okraj';
$string['table_dlg:rules_box'] = 'box';
$string['table_dlg:rules_hsides'] = 'hsides';
$string['table_dlg:rules_lhs'] = 'lhs';
$string['table_dlg:rules_rhs'] = 'rhs';
$string['table_dlg:rules_void'] = 'void';
$string['table_dlg:rules_vsides'] = 'vsides';
$string['table_dlg:scope'] = 'Scope';
$string['table_dlg:style'] = 'CSS Štýl';
$string['table_dlg:summary'] = 'Opis tabuľky';
$string['table_dlg:tbody'] = 'Telo tabuľky';
$string['table_dlg:td'] = 'Dáta';
$string['table_dlg:tfoot'] = 'Päta tabuľky';
$string['table_dlg:th'] = 'Hlavčka';
$string['table_dlg:thead'] = 'Hlavička tabuľky';
$string['table_dlg:title'] = 'Vložiť/Upraviť tabuľku';
$string['table_dlg:valign'] = 'Vertikálna poloha';
$string['table_dlg:width'] = 'Šírka';
$string['template:desc'] = 'Vložiť obsah z preddefinovanej šablóny';
$string['template_dlg:cdate_format'] = '%Y-%m-%d %H:%M:%S';
$string['template_dlg:day_long'] = 'Nedeľa,Pondelok,Utorok,Streda,Štvrtok,Piatok,Sobota,Nedeľa';
$string['template_dlg:day_short'] = 'Ned,Pon,Ut,Str,Štvr,Pia,Sob,Ned';
$string['template_dlg:desc'] = 'Vložiť obsah z preddefinovanej šablóny';
$string['template_dlg:desc_label'] = 'Opis';
$string['template_dlg:label'] = 'Šablóna';
$string['template_dlg:mdate_format'] = '%Y-%m-%d %H:%M:%S';
$string['template_dlg:months_long'] = 'Január,Február,Marec,Apríl,Máj,Jún,Júl,August,September,Október,November,December';
$string['template_dlg:months_short'] = 'Jan,Feb,Mar,Apr,Máj,Jún,Júl,Aug,Sep,Okt,Nov,Dec';
$string['template_dlg:preview'] = 'Náhľad';
$string['template_dlg:select'] = 'Výber šablóny';
$string['template_dlg:title'] = 'Šablóny';
$string['template_dlg:warning'] = 'Upozornenie: Aktualizáciou šablóny inou, sa spôsobí strata dát.';
$string['visualblocks:desc'] = 'Zobraziť/skryť prvky bloku';
$string['visualchars:desc'] = 'Zobrazenie skrytých znakov zapnúť/vypnúť.';
$string['wordcount:words'] = 'Slová:';
$string['xhtmlxtras:abbr_delta_height'] = '';
$string['xhtmlxtras:abbr_delta_width'] = '';
$string['xhtmlxtras:abbr_desc'] = 'Skratka';
$string['xhtmlxtras:acronym_delta_height'] = '';
$string['xhtmlxtras:acronym_delta_width'] = '';
$string['xhtmlxtras:acronym_desc'] = 'Acronym';
$string['xhtmlxtras:attribs_delta_height'] = '';
$string['xhtmlxtras:attribs_delta_width'] = '';
$string['xhtmlxtras:attribs_desc'] = 'Vložiť/editovať atribúty';
$string['xhtmlxtras:cite_delta_height'] = '';
$string['xhtmlxtras:cite_delta_width'] = '';
$string['xhtmlxtras:cite_desc'] = 'Citácia';
$string['xhtmlxtras:del_delta_height'] = '';
$string['xhtmlxtras:del_delta_width'] = '';
$string['xhtmlxtras:del_desc'] = 'Zrušenie';
$string['xhtmlxtras:ins_delta_height'] = '';
$string['xhtmlxtras:ins_delta_width'] = '';
$string['xhtmlxtras:ins_desc'] = 'Vloženie';
$string['xhtmlxtras_dlg:attrib_tab'] = 'Attribúty';
$string['xhtmlxtras_dlg:attribs_title'] = 'Vložiť/editovať atribúty';
$string['xhtmlxtras_dlg:attribute_attrib_tab'] = 'Atribúty';
$string['xhtmlxtras_dlg:attribute_events_tab'] = 'Akcie';
$string['xhtmlxtras_dlg:attribute_label_accesskey'] = 'AccessKey';
$string['xhtmlxtras_dlg:attribute_label_cite'] = 'Citácia';
$string['xhtmlxtras_dlg:attribute_label_class'] = 'Trieda';
$string['xhtmlxtras_dlg:attribute_label_datetime'] = 'Dátum/čas';
$string['xhtmlxtras_dlg:attribute_label_id'] = 'ID';
$string['xhtmlxtras_dlg:attribute_label_langcode'] = 'Jazyk';
$string['xhtmlxtras_dlg:attribute_label_langdir'] = 'Smer textu';
$string['xhtmlxtras_dlg:attribute_label_style'] = 'Štýl';
$string['xhtmlxtras_dlg:attribute_label_tabindex'] = 'TabIndex';
$string['xhtmlxtras_dlg:attribute_label_title'] = 'Názov';
$string['xhtmlxtras_dlg:attribute_option_ltr'] = 'Zľava doprava';
$string['xhtmlxtras_dlg:attribute_option_rtl'] = 'Sprava doľava';
$string['xhtmlxtras_dlg:events_tab'] = 'Akcie';
$string['xhtmlxtras_dlg:fieldset_attrib_tab'] = 'Atribúty prvku';
$string['xhtmlxtras_dlg:fieldset_events_tab'] = 'Prvok udalostí';
$string['xhtmlxtras_dlg:fieldset_general_tab'] = 'Všeobecné nastavenia';
$string['xhtmlxtras_dlg:general_tab'] = 'Všeobecné';
$string['xhtmlxtras_dlg:insert_date'] = 'Vložiť aktuálny dátum/čas';
$string['xhtmlxtras_dlg:option_ltr'] = 'Zľava doprava';
$string['xhtmlxtras_dlg:option_rtl'] = 'Sprava doľava';
$string['xhtmlxtras_dlg:remove'] = 'Odstrániť';
$string['xhtmlxtras_dlg:title_abbr_element'] = 'Prvok skratky';
$string['xhtmlxtras_dlg:title_acronym_element'] = 'Akronym';
$string['xhtmlxtras_dlg:title_cite_element'] = 'Prvok citácie';
$string['xhtmlxtras_dlg:title_del_element'] = 'Prvok zrušenia';
$string['xhtmlxtras_dlg:title_ins_element'] = 'Prvok vloženia';
