<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'block_coupon', language 'sk', version '4.4'.
 *
 * @package     block_coupon
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action:coupon:delete'] = 'Vymazať kupón';
$string['action:coupon:delete:confirm'] = 'Ste si istý, že chcete vymazať tento kupón? Tento proces je nezvratný!';
$string['action:error:delete'] = 'Chyba pri vymazávaní';
$string['and'] = 'a';
$string['blockname'] = 'Kupóny';
$string['button:next'] = 'Ďalší';
$string['button:save'] = 'Generovať kupóny';
$string['button:submit_coupon_code'] = 'Potvrdiť kupón';
$string['cohort'] = 'globálna skupina';
$string['confirm_coupons_sent_body'] = 'Dobrý deň,<br /><br /> rád by som Vás informoval, že kupóny, ktoré ste vytvorili {$a->timecreated}, boli odoslané.<br /><br /> S pozdravom,<br /><br /> administrátor Moodle';
$string['confirm_coupons_sent_subject'] = 'Všetky kupóny boli odoslané';
$string['coupon:addinstance'] = 'Pridať nový blok s Kupónmi';
$string['coupon:administration'] = 'Spravovať blok s Kupónmi';
$string['coupon:claim:wronguser'] = 'Tento osobný kupón nie je Váš';
$string['coupon:cleanup:heading'] = 'Vyčistiť kupóny';
$string['coupon:cleanup:info'] = 'Tento formulár použite pre vymazanie kupónov zo systému.<br/> <b>Varovanie</b> Tento proces <i>vymaže</i> kupóny zo systému a nie je možné ich obnoviť.';
$string['coupon:deleted'] = 'Kupón bol vymazaný';
$string['coupon:extendenrol'] = 'Kupóny pre rozšírenie zápisu';
$string['coupon:extendenrolments'] = 'Generovať kupóny na rozšírenie zápisu do kurzov';
$string['coupon:generatecoupons'] = 'Generovať nový kupón';
$string['coupon:inputcoupons'] = 'Použiť kupón pre prihlásenie';
$string['coupon:myaddinstance'] = 'Pridať nový blok s Kupónmi na moju Moodle stránku';
$string['coupon:send:fail'] = 'Odoslanie emailu zlyhalo! Dôvod: {$a}';
$string['coupon:senddate:instant'] = 'Okamžite';
$string['coupon:timeframe'] = 'Typ';
$string['coupon:type'] = 'Typ';
$string['coupon:type:all'] = 'Všetky';
$string['coupon:type:cohort'] = 'Zapísanie do cohort';
$string['coupon:type:course'] = 'Zapísanie do kurzu';
$string['coupon:type:enrolext'] = 'Rozšírenie zápisu';
$string['coupon:used'] = 'Odstránenie';
$string['coupon:used:all'] = 'Všetky kupóny';
$string['coupon:used:no'] = 'Len nepoužité kupóny';
$string['coupon:used:yes'] = 'Len použité kupóny';
$string['coupon:viewallreports'] = 'Zobraziť reporty (pre všetky kupóny)';
$string['coupon:viewreports'] = 'Zobraziť reporty (pre moje kupóny)';
$string['coupon_mail_subject'] = 'Vygenerovaný Moodle kupón';
$string['coupons_ready_to_send'] = 'Kupón(y) bol(i) generované a budú odoslané v zadaný deň.<br /> Keď budú kupóny odoslané, emailom dostanete potvrdenie.';
$string['coupons_sent'] = 'Kupón(y) boli vygenerované. Za niekoľko minút dostanete email s kupónmi v prílohe.';
$string['course'] = 'kurz';
$string['days_access'] = '{$a} dní';
$string['default-coupon-page-template-botleft'] = '<ol> <li>Zaregistrujte sa na stránke {site_url}.</li> <li>Na Váš email dostanete link pre potvrdenie Vašej registrácie. Pre aktiváciu Vášho konta otvorte link pre potvrdenie Vašej registrácie.</li> <li>Zadajte kód z Vášho kupónu.</li> <li>Príjemné vzdelávanie!</li> </ol>';
$string['default-coupon-page-template-botright'] = '<ol> <li>Prihláste sa na stránku {site_url}.</li> <li>Zadajte kód z Vášho kupónu.</li> <li>Príjemné vzdelávanie!</li> </ol>';
$string['default-coupon-page-template-main'] = 'Pomocou tohto kupónu sa môžete prihlásiť do kurzu:<br/> {courses}<br/><br/> Na prihlásenie do kurzu máte {accesstime}.<br/><br/> Prosím, pre aktiváciu prístupu použite nasledujúci kód:<br/> {coupon_code}';
$string['download-sample-csv'] = 'Stiahnuť vzor CSV súboru';
$string['enrolperiod:extension'] = 'počas trvania {$a}';
$string['enrolperiod:indefinite'] = '<i>neobmedzená</i>';
$string['error:alternative_email_invalid'] = 'Ak ste zvolili možnosť "použiť alternatívny email", toto pole musí obsahovať platnú emailovú adresu.';
$string['error:alternative_email_required'] = 'Ak ste zvolili možnosť "použiť alternatívny email", toto pole je povinné.';
$string['error:cohort_sync'] = 'Vyskytla sa chyba pri synchronizácii cohorts. Prosím kontaktujte podporu.';
$string['error:coupon_already_used'] = 'Kupón s týmto kódom už bol použitý.';
$string['error:coupon_amount-recipients-both-set'] = 'Prosím špecifikujte počet vygenerovaných kupónov alebo CSV zoznam príjemcov.';
$string['error:coupon_amount-recipients-both-unset'] = 'Toto pole alebo pole príjemcu musí byť nastavené.';
$string['error:coupon_amount_too_high'] = 'Prosím zadaj množstvo v rozmedzí od {$a->min} do {$a->max}.';
$string['error:coupon_reserved'] = 'Kupón s týmto kódom už bol rezervovaný pre iného používateľa.';
$string['error:course-not-found'] = 'Kurz sa nenašiel.';
$string['error:invalid_coupon_code'] = 'Zadali ste neplatný kód kupónu.';
$string['error:invalid_email'] = 'Prosím, zadajte správnu emailovú adresu.';
$string['error:no_coupons_submitted'] = 'Žiaden z Vašich kupónov nebol doposiaľ použitý.';
$string['error:nopermission'] = 'Na toto nemáte oprávnenie.';
$string['error:numeric_only'] = 'Zadávajte len číselnú hodnotu.';
$string['error:recipients-empty'] = 'Prosím, zadajte najmenej jedného používateľa.';
$string['error:recipients-extension'] = 'Môžete nahrať len CSV súbor.';
$string['error:required'] = 'Toto pole je povinné.';
$string['error:sessions-expired'] = 'Vaša relácia vypršala. Prosím opakujte Vašu požiadavku znova.';
$string['error:wrong_code_length'] = 'Prosím zadajte číslo v rozmedzí od 6 do 32.';
$string['error:wrong_doc_page'] = 'Pokúšate sa pristúpiť na stránku, ktorá neexistuje.';
$string['error:wrong_image_size'] = 'Nahraté pozadie nemá požadovanú veľkosť. Prosím, nahrajte obrázok s rozmermi 210 mm x 297 mm.';
$string['extendaccess'] = '{$a} extra';
$string['heading:administration'] = 'Spravovať';
$string['heading:amountForm'] = 'Nastavenie množstva';
$string['heading:coupon_type'] = 'Typ kupónu';
$string['heading:csvForm'] = 'Nastavenie CSV';
$string['heading:general_settings'] = 'Posledné nastavenia';
$string['heading:generatecoupons'] = 'Generovať kupóny';
$string['heading:imageupload'] = 'Nahrať obrázok';
$string['heading:info'] = 'Info';
$string['heading:input_cohorts'] = 'Vybrať cohorts';
$string['heading:input_coupon'] = 'Vstupný kupón';
$string['heading:input_course'] = 'Vyberte kurz';
$string['heading:input_groups'] = 'Vyberte skupiny';
$string['heading:inputcoupons'] = 'Vstupný kupón';
$string['heading:label_instructions'] = 'Inštrukcie';
$string['heading:manualForm'] = 'Manuálne nastavenie';
$string['label:alternative_email'] = 'Alternatívny email';
$string['label:alternative_email_help'] = 'Štandardne odoslať kupóny na túto emailovú adresu.';
$string['label:api_enabled'] = 'Povoliť API';
$string['label:api_enabled_desc'] = 'API umožňuje generovať kupóny z externého systému.';
$string['label:api_password'] = 'Heslo API';
$string['label:api_password_desc'] = 'Heslo použíté pri generovaní kupónov cez API.';
$string['label:api_user'] = 'Používateľ API';
$string['label:api_user_desc'] = 'Používateľské meno použité pri generovaní kupónov cez API.';
$string['label:cleanupage'] = 'Maximálna platnosť?';
$string['label:cleanupage_help'] = 'Zadajte maximálnu platnosť nepoužitých kupónov predtým, ako budú vymazané.';
$string['label:cohort'] = 'Cohort';
$string['label:connected_courses'] = 'Spojený kurz/Spojené kurzy';
$string['label:coupon_amount'] = 'Počet kupónov';
$string['label:coupon_amount_help'] = 'Toto je počet kupónov, ktoré budú vygenerované. Prosím, použite toto pole alebo pole príjemcovia, nie obidva súčasne.';
$string['label:coupon_code'] = 'Kód kupónu';
$string['label:coupon_code_help'] = 'Kód kupónu je unikátny kód, ktorý je prepojený na individuálny kupón. Tento kód môžete nájsť na Vašom kupóne.';
$string['label:coupon_code_length'] = 'Dĺžka kódu';
$string['label:coupon_cohorts'] = 'Cohort(s)';
$string['label:coupon_cohorts_help'] = 'Vyberte jeden alebo viac cohort, do ktorých budú používatelia zapísaní.';
$string['label:coupon_connect_course'] = 'Pridať kurz(y)';
$string['label:coupon_connect_course_help'] = 'Vyberte všetky kurzy, ktoré chcete pridať do cohort. <br /><b><i>Note: </i></b>Používatelia, ktorí sú už v tomto cohort pridaný, budú zapísaný do vybraných kurzov!';
$string['label:coupon_courses'] = 'Kurz(y)';
$string['label:coupon_courses_help'] = 'Vyberte kurzy, do ktorých budú používatelia zapísaný.';
$string['label:coupon_email'] = 'Emailová adresa';
$string['label:coupon_email_help'] = 'Toto je emailová adresa, na ktorú budú vygenerované kupóny zaslané.';
$string['label:coupon_groups'] = 'Pridať skupinu(y)';
$string['label:coupon_groups_help'] = 'Vyberte skupiny, do ktorých majú byť používatelia zapísaný pri zapísaní sa do kurzu.';
$string['label:coupon_recipients'] = 'Príjemcovia';
$string['label:coupon_recipients_help'] = 'S týmto poľom môžete nahrať CSV súbor s používateľmi.';
$string['label:coupon_recipients_txt'] = 'Príjemcovia';
$string['label:coupon_recipients_txt_help'] = 'V tomto poli môžete urobiť definitívne zmeny v nahranom CSV súbore.';
$string['label:coupon_type'] = 'Generovať na základe';
$string['label:coupon_type_help'] = 'Kupóny budú generované na základe kurzu alebo cohort';
$string['label:current_image'] = 'Aktuálne pozadie kupónu';
$string['label:date_send_coupons'] = 'Dátum odoslania';
$string['label:date_send_coupons_help'] = 'Dátum, kedy budú kupóny odoslané používateľom.';
$string['label:defaultrole'] = 'Predvolená rola';
$string['label:defaultrole_help'] = 'Táto rola bude predvolená pre používateľov pri uplatnení kupónu.';
$string['label:email_body'] = 'Emailová správa';
$string['label:email_body_help'] = 'Príjemcovia kupónov dostanú emailovú správu.';
$string['label:enablecleanup'] = 'Povoliť vymazávanie nepoužitých kupónov?';
$string['label:enablecleanup_help'] = 'Zvoľte túto možnosť pokiaľ si želáte automatické mazanie nepoužitých kupónov.';
$string['label:enrolment_period'] = 'Obdobie zápisu';
$string['label:enrolment_period_help'] = 'Obdobie (v dňoch), počas ktorého sa používatelia môžu zapísať. Pokiaľ je nastavené "0", nebude stanovené žiadne obdobie.';
$string['label:enter_coupon_code'] = 'Sem zadajte kód z Vášho kupónu';
$string['label:extendperiod'] = 'Obdobie pre predĺženie registrácie';
$string['label:generate_pdfs'] = 'Generovať samostatné PDF súbory';
$string['label:generate_pdfs_help'] = 'Tu si môžete zvoliť, či chcete dostať samostatné súbory za každý kupón alebo jeden súbor za všetky kupóny.';
$string['label:image'] = 'Pozadie kupónu';
$string['label:max_coupons'] = 'Maximálny počet kupónov';
$string['label:max_coupons_desc'] = 'Počet kupónov, ktoré môžu byť vytvorené v jednom okamihu.';
$string['label:no_courses_connected'] = 'S cohort nie je prepojený žiadny kurz.';
$string['label:no_groups_selected'] = 'Ku týmto kurzom nie sú prepojené žiadne skupiny.';
$string['label:redirect_url'] = 'URL pre presmerovanie';
$string['label:redirect_url_help'] = 'URL adresa, na ktorú budú používatelia presmerovaní po zadaní kódu kupónu.';
$string['label:selected_cohort'] = 'Vybraté cohort(s)';
$string['label:selected_courses'] = 'Vybraté kurzy';
$string['label:selected_groups'] = 'Vybratá skupina/Vybraté skupiny';
$string['label:showform'] = 'Možnosti generátora';
$string['label:type_cohorts'] = 'Cohort(s)';
$string['label:type_course'] = 'Kurz';
$string['label:use_alternative_email'] = 'Použiť alternatívny email';
$string['label:use_alternative_email_help'] = 'Pri zvolení tejto možnosti bude štandardne použitá emailová adresa v poli "alternatívny email"';
$string['label:users'] = 'Používateľ/Používatelia';
$string['logo:default'] = 'Štandardné logo';
$string['logo:none'] = 'Nepoužívať logo';
$string['page:generate_coupon.php:title'] = 'Generovať kupóny';
$string['page:generate_coupon_step_five.php:title'] = 'Generovať kupóny';
$string['page:generate_coupon_step_four.php:title'] = 'Generovať kupóny';
$string['page:generate_coupon_step_three.php:title'] = 'Generovať kupóny';
$string['page:generate_coupon_step_two.php:title'] = 'Generovať kupóny';
$string['page:unused_coupons.php:title'] = 'Nepoužité kupóny';
$string['pdf-meta:keywords'] = 'Moodle kupón';
$string['pdf-meta:subject'] = 'Moodle kupón';
$string['pdf-meta:title'] = 'Moodle kupón';
$string['pdf:titlename'] = 'Moodle kupón';
$string['pdf_generated'] = 'Kupóny boli priložené ku tomuto emailu ako PDF súbory.<br /><br />';
$string['pluginname'] = 'Kupóny';
$string['promo'] = 'Moodle plugin pre kupóny';
$string['promodesc'] = 'Tento plugin vytvoril Sebsoft Managed Hosting & Software Development (<a href=\'http://www.sebsoft.nl/\' target=\'_new\'>http://sebsoft.nl</a>).<br /><br /> {$a}<br /><br />';
$string['recipient:none'] = 'Žiadny';
$string['recipient:selected:users'] = 'Vybraní používatelia';
$string['report:cohorts'] = 'Cohort';
$string['report:coupon_code'] = 'Kód predplatného';
$string['report:dateformat'] = '%d-%m-%Y %H:%M:%S';
$string['report:dateformatymd'] = '%d-%m-%Y';
$string['report:download-excel'] = 'Stiahnuť nepoužité kupóny';
$string['report:enrolperiod'] = 'Vlastník';
$string['report:for_user_email'] = 'Plánovaný pre';
$string['report:for_user_name'] = 'Meno príjemcu';
$string['report:heading:action'] = 'Akcia(e)';
$string['report:heading:cohortname'] = 'Cohort(s)';
$string['report:heading:coupon'] = 'Kupón';
$string['report:heading:coursename'] = 'Názov kurzu';
$string['report:heading:coursetype'] = 'Typ kurzu';
$string['report:heading:datecomplete'] = 'Dátum ukončenia';
$string['report:heading:datestart'] = 'Dátum začatia';
$string['report:heading:errormessage'] = 'Chyba';
$string['report:heading:errortype'] = 'Typ';
$string['report:heading:grade'] = 'Známka';
$string['report:heading:status'] = 'Stav';
$string['report:heading:timecreated'] = 'Dátum';
$string['report:heading:type'] = 'Typ';
$string['report:heading:user'] = 'používateľ';
$string['report:immediately'] = 'Okamžite';
$string['report:issend'] = 'Odoslaný';
$string['report:owner'] = 'Vlastník';
$string['report:senddate'] = 'Dátum odoslania';
$string['report:status_completed'] = 'Kurz ukončený';
$string['report:status_not_started'] = 'Kurz ešte nezačal';
$string['report:status_started'] = 'Kurz už začal';
$string['report:timeexpired'] = 'Vyprší';
$string['select:logo'] = 'Vyberte vzor loga';
$string['select:logo:desc'] = 'Toto bude použité len pri generovaní kupónov.';
$string['showform-amount'] = 'Chcem vytvoriť ľubovoľné množstvo kupónov';
$string['showform-csv'] = 'Chcem vytvoriť kupóny pomocou CSV súboru s príjemcami';
$string['showform-manual'] = 'Chcem manuálne konfigurovať príjemcov';
$string['signup:login'] = 'Už mám vytvorený účet a chcem sa prihlásiť';
$string['signup:success'] = 'Boli ste registrovaný a budete presmerovaný na prihlasovaciu stránku.<br/> Prosím overte si, či ste získali prístup ku kurzu.';
$string['str:mandatory'] = 'Povinné';
$string['str:optional'] = 'Voliteľné';
$string['success:coupon_used'] = 'Kupón bol použitý - získali ste prístup ku kurzu (kurzom)';
$string['success:uploadimage'] = 'Váš nový vzor kupónu bol nahratý.';
$string['tab:apidocs'] = 'Dokumenty API';
$string['tab:cleaner'] = 'Vyčistenie';
$string['tab:errors'] = 'Chybové reporty';
$string['tab:report'] = 'Správa o pokroku';
$string['tab:unused'] = 'Nepoužité kupóny';
$string['tab:used'] = 'Použité kupóny';
$string['tab:wzcouponimage'] = 'Obrázok šablóny';
$string['tab:wzcoupons'] = 'Generovať kupón(y)';
$string['task:cleanup'] = 'Vymazať nepoužité staré kupóny';
$string['task:sendcoupons'] = 'Odoslať naplánované kupóny';
$string['tasksettings'] = 'Nastavenie úlohy';
$string['textsettings'] = 'Nastavenie textu';
$string['textsettings_desc'] = 'Tu môžete konfigurovať vlastné texty, ktoré môžu byť zobrazené na viacerých obrazovkách pri generovaní kupónov';
$string['th:action'] = 'Akcia(e)';
$string['th:cohorts'] = 'Cohort';
$string['th:course'] = 'Kurz';
$string['th:enrolperiod'] = 'Obdobie zápisu';
$string['th:for_user_email'] = 'Plánovaný pre';
$string['th:groups'] = 'Skupina(y)';
$string['th:immediately'] = 'Okamžite';
$string['th:issend'] = 'Odoslaný?';
$string['th:owner'] = 'Vlastník';
$string['th:senddate'] = 'Dátum odoslanie';
$string['th:submission_code'] = 'Kód predplatného';
$string['timeafter'] = 'Vytvorený po';
$string['timebefore'] = 'Vytvorený pred';
$string['unlimited_access'] = 'neobmedzený čas';
$string['url:api_docs'] = 'Dokumentácia API';
$string['url:couponsignup'] = 'Registrovať sa pomocou kódu z kupónu';
$string['url:generate_coupons'] = 'Generovať kupón';
$string['url:input_coupon'] = 'Vstupný kupón';
$string['url:managelogos'] = 'Spravovať obrázky kupónov';
$string['url:uploadimage'] = 'Zmeniť obrázok kupónu';
$string['url:view_reports'] = 'Zobraziť reporty';
$string['url:view_unused_coupons'] = 'Zobraziť nepoužité kupóny';
$string['view:api:heading'] = 'API kupónov';
$string['view:api:title'] = 'API kupónov';
$string['view:api_docs:heading'] = 'Dokumentácia pre API kupóny';
$string['view:api_docs:title'] = 'Dokumentácia pre API kupóny';
$string['view:cleanup:heading'] = 'Vymazať kupóny';
$string['view:cleanup:title'] = 'Vymazať kupóny';
$string['view:errorreport:heading'] = 'Report - chybné kupóny';
$string['view:errorreport:title'] = 'Report - chybné kupóny';
$string['view:extendenrolment:heading'] = 'Kupón: predĺženie registrácie';
$string['view:extendenrolment:title'] = 'Kupón: predĺženie registrácie';
$string['view:extendenrolment_step1:heading'] = 'Rozšíriť zápis: vybrať kurz(y)';
$string['view:extendenrolment_step1:title'] = 'Rozšíriť zápis: vybrať kurz(y)';
$string['view:extendenrolment_step2:heading'] = 'Rozšíriť zápis: vybrať používateľov';
$string['view:extendenrolment_step2:title'] = 'Rozšíriť zápis: vybrať používateľov';
$string['view:extendenrolment_step3:heading'] = 'Rozšíriť zápis: potvrdiť';
$string['view:extendenrolment_step3:title'] = 'Rozšíriť zápis: potvrdiť';
$string['view:generate_coupon:heading'] = 'Generovať kupón';
$string['view:generate_coupon:title'] = 'Generovať kupón';
$string['view:input_coupon:heading'] = 'Vstupný kupón';
$string['view:input_coupon:title'] = 'Vstupný kupón';
$string['view:reports-unused:heading'] = 'Report - nepoužité kupóny';
$string['view:reports-unused:title'] = 'Report - nepoužité kupóny';
$string['view:reports-used:heading'] = 'Report - použité kupóny';
$string['view:reports-used:title'] = 'Report - použité kupóny';
$string['view:reports:heading'] = 'Report - pokrok založený na kupónoch';
$string['view:reports:title'] = 'Report - pokrok založený na kupónoch';
$string['view:uploadimage:heading'] = 'Nahrať nové pozadie kupónu';
$string['view:uploadimage:title'] = 'Nahrať pozadie kupónu';
