<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'assign', language 'sk', version '4.4'.
 *
 * @package     assign
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityattachments'] = 'Assignment activity attachments';
$string['activitydate:submissionsdue'] = 'Termín:';
$string['activitydate:submissionsopen'] = 'Otvára sa:';
$string['activitydate:submissionsopened'] = 'Otvorený:';
$string['activityeditor'] = 'Inštrukcie aktivity';
$string['activityeditor_help'] = 'Akcie, ktoré by mal študent pre toto zadanie vykonať. Zobrazuje sa iba na stránke odovzdania, kde študent upraví a odošle svoje riešenie zadania.';
$string['activityoverview'] = 'Máte jeden alebo viac nových zadaní (kliknite sem na ich zobrazenie).';
$string['addattempt'] = 'Povoliť ďalší pokus';
$string['addnewattempt'] = 'Pridajte nový pokus';
$string['addnewattempt_help'] = 'Týmto sa vytvorí nový čistý formulár, na ktorom budete môcť začať pracovať od začiatku.';
$string['addnewattemptfromprevious'] = 'Pridať nový pokus na základe posledného odovzdania';
$string['addnewattemptfromprevious_help'] = 'Týmto sa vytvorí kópia predošlého odovzdaného zadania, na ktorej budete môcť ďalej pracovať.';
$string['addnewgroupoverride'] = 'Pridať prestavenie skupiny';
$string['addnewuseroverride'] = 'Pridať prestavenie používateľa';
$string['addsubmission'] = 'Odovzdať zadanie';
$string['addsubmission_help'] = 'Dosiaľ ste neodovzdali riešenie zadania';
$string['allocatedmarker'] = 'Pridelený hodnotiteľ';
$string['allocatedmarker_help'] = 'Hodnotiteľ pridelený tomuto vypracovanému zadaniu';
$string['allowsubmissions'] = 'Povoliť používateľovi pokračovať v hodnotení odovzdaného zadania';
$string['allowsubmissionsfromdate'] = 'Povoliť odovzdanie zadaní od';
$string['allowsubmissionsfromdate_help'] = 'Ak je povolené, študenti nebudú môcť pred týmto termínom odovzdať zadanie. Ak nie je povolené, študenti budú môcť odovzdávať zadania okamžite.';
$string['allowsubmissionsshort'] = 'Povoliť zmeny odovzdaného zadania';
$string['alwaysshowdescription'] = 'Vždy zobraziť opis zadania';
$string['alwaysshowdescription_help'] = 'Ak nie je povolené, opis zadania zobrazený vyššie bude študentom zobrazený iba po dátume, od ktorého možno vkladať odovzdané zadania.';
$string['applytoteam'] = 'Použiť známky a komentáre pre celú skupinu';
$string['assign:addinstance'] = 'Pridať nové zadanie';
$string['assign:editothersubmission'] = 'Upraviť riešenie ďalšieho študenta';
$string['assign:exportownsubmission'] = 'Exportovať vlastné odovzdané zadanie';
$string['assign:grade'] = 'Ohodnotiť zadanie';
$string['assign:grantextension'] = 'Poskytnúť predĺženie';
$string['assign:manageallocations'] = 'Spravovať hodnotiteľov pridelených k zadaniam';
$string['assign:managegrades'] = 'Revízia a zverejnenie známok';
$string['assign:manageoverrides'] = 'Spravovať prestavenia zadania';
$string['assign:receivegradernotifications'] = 'Posielať učiteľovi oznámenia o odovzdanom zadaní';
$string['assign:releasegrades'] = 'Zverejnenie známok';
$string['assign:revealidentities'] = 'Ukázať identitu študentov';
$string['assign:reviewgrades'] = 'Preskúmanie známok';
$string['assign:showhiddengrader'] = 'Zobrazte totožnosť skrytého hodnotiteľa';
$string['assign:submit'] = 'Odoslať zadanie';
$string['assign:view'] = 'Prezrieť zadanie';
$string['assign:viewblinddetails'] = 'Zobraziť identitu študentov v prípade známkovania naslepo';
$string['assign:viewgrades'] = 'Prezrieť známky';
$string['assign:viewownsubmissionsummary'] = 'Zobraziť súhrn vlastných riešení zadania';
$string['assignfeedback'] = 'Rozšírenie typu dotazník';
$string['assignfeedbackpluginname'] = 'Rozšírenie typu dotazník';
$string['assignmentisdue'] = 'Zadanie treba odovzdať k dátumu';
$string['assignmentmail'] = '{$a->grader} okomentoval  vaše riešenie zadania \'{$a->assignment}\'.

Hodnotenie nájdete pri svojom vypracovanom zadaní na adrese:
{$a->url}.';
$string['assignmentmailhtml'] = '<p>{$a->grader} okomentoval  vaše riešenie zadania  \'<i>{$a->assignment}</i>\'. </p><p>Hodnotenie zájdete pri svojom <a href="{$a->url}">vypracovanom zadaní</a>.</p>';
$string['assignmentmailsmall'] = '{$a->grader} okomentoval vaše riešenie zadania "{$a->assignment}". Hodnotenie nájdete pri svojom vypracovanom zadaní.';
$string['assignmentname'] = 'Názov zadania';
$string['assignmentplugins'] = 'Zásuvné moduly aktivity Zadanie';
$string['assignmentsperpage'] = 'Zadaní na stránku';
$string['assignsubmission'] = 'Zásuvný modul typu odovzdané zadanie';
$string['assignsubmissionpluginname'] = 'Zásuvný modul typu odovzdané zadanie';
$string['assigntimeleft'] = 'Ostávajúci čas';
$string['attemptheading'] = 'Pokus č. {$a->attemptnumber}: {$a->submissionsummary}';
$string['attempthistory'] = 'Predchodzie pokusy';
$string['attemptnumber'] = 'Číslo pokusu';
$string['attemptreopenmethod'] = 'Dodatočné pokusy';
$string['attemptreopenmethod_help'] = 'Toto nastavenie určuje, či študent môže vykonať ďalšie odovzdanie zadania. Pre každý pokus sa známka a spätná väzba uložia a môžu si ich zobraziť učiteľ aj študent.

K dispozícii sú možnosti:
* Nikdy - raz odovzdané zadanie nie je možné znovu otvoriť pre úpravy.
* Ručne - Učiteľ môže odovzdané zadania opäť otvoriť na úpravy.
* Automaticky, kým neuspeje - Odovzdané zadanie je automaticky otvorené na ďalšie úpravy, kým za neho nie je udelená známka potrebná pre splnenie zadania (hodnotu tejto potrebnej známky možno nastaviť vo Výkaze známok).';
$string['attemptreopenmethod_manual'] = 'Manuálne';
$string['attemptreopenmethod_none'] = 'Nikdy';
$string['attemptreopenmethod_untilpass'] = 'Automaticky kým neuspeje';
$string['attemptsettings'] = 'Nastavenie pokusov';
$string['availability'] = 'Dostupnosť';
$string['back'] = 'Späť';
$string['backtoassignment'] = 'Späť k zadaniu';
$string['batchoperationconfirmaddattempt'] = 'Povoliť ďalší pokus pre označené odovzdané riešenia?';
$string['batchoperationconfirmdownloadselected'] = 'Uložiť označené odovzdané zadania?';
$string['batchoperationconfirmgrantextension'] = 'Poskytnúť predĺženie pre všetky vybrané odovzdané zadania?';
$string['batchoperationconfirmlock'] = 'Zamknúť všetky vybrané odovzdané zadania?';
$string['batchoperationconfirmremovesubmission'] = 'Odstrániť vybrané riešenia zadania?';
$string['batchoperationconfirmreverttodraft'] = 'Vrátiť všetky vybrané vypracované zadania do stavu pracovnej verzie?';
$string['batchoperationconfirmsetmarkingallocation'] = 'Nastaviť pridelenie známok pre všetky vybrané odovzdané zadania?';
$string['batchoperationconfirmsetmarkingworkflowstate'] = 'Nastaviť spracovanie známok pre všetky vybrané odovzdané zadania?';
$string['batchoperationconfirmunlock'] = 'Odomknúť všetky vybrané vypracované zadania?';
$string['batchoperationlock'] = 'zamknúť vypracované zadania';
$string['batchoperationreverttodraft'] = 'vrátiť odovzdané zadanie do stavu pracovnej verzie';
$string['batchoperationsdescription'] = 'S vybranými ...';
$string['batchoperationunlock'] = 'odomknúť vypracované zadania';
$string['batchsetallocatedmarker'] = 'Nastaviť pridelenie hodnotiteľa pre {$a} vybraných používateľov.';
$string['batchsetmarkingworkflowstateforusers'] = 'Nastaviť spracovanie známky pre {$a} vybraných používateľov.';
$string['beginassignment'] = 'Začať riešiť zadanie';
$string['blindmarking'] = 'Známkovanie naslepo';
$string['blindmarking_help'] = 'Hodnotenie naslepo skryje pre hodnotiteľov identitu študentov. Nastavenie anonymného hodnotenia bude zamknuté po odovzdaní zadania alebo hodnotenia zadania.';
$string['blindmarkingenabledwarning'] = 'Pre túto aktivitu je povolené známkovanie naslepo. Hodnotenie nebude pridané do známkovania, kým nebudú identifikačné údaje študentov zverejnené prostredníctvom ponuky akcií hodnotenia.';
$string['cachedef_overrides'] = 'Informácie o prepísaní používateľov a skupiny';
$string['calendardue'] = '{$a} má byť hotové do tohto dátumu';
$string['calendargradingdue'] = '{$a} má byť hotové hodnotenie';
$string['caneditsubmission'] = 'Riešenie zadania môžete odoslať/upraviť po uplynutí časového limitu, bude však označené ako oneskorené.';
$string['changefilters'] = 'Zmeniť filtre';
$string['changeuser'] = 'Zmeniť používateľa';
$string['choosegradingaction'] = 'Akcia hodnotenia';
$string['choosemarker'] = 'Vybrať ...';
$string['chooseoperation'] = 'Vybrať operáciu';
$string['clickexpandreviewpanel'] = 'Kliknutím rozbalíte panel revízie známok';
$string['collapsegradepanel'] = 'Zbaliť panel revízie známok';
$string['collapsereviewpanel'] = 'Zbaliť panel revízie známok';
$string['comment'] = 'Komentár';
$string['completiondetail:submit'] = 'Vytvoriť zadanie na odovzdanie';
$string['completionsubmit'] = 'Odovzdať zadanie';
$string['configshowrecentsubmissions'] = 'Zobrazovať každému informáciu o odovzdaných zadaniach v bloku prehľadu nedávnej činnosti.';
$string['confirmbatchgradingoperation'] = 'Naozaj chcete {$a->operation} pre {$a->count} študentov?';
$string['confirmstart'] = 'Vaše riešenie zadania bude mať časový limit {$a}. Keď začnete, časovač začne odpočítavať a nedá sa pozastaviť.';
$string['confirmsubmission'] = 'Naozaj chcete odoslať svoju prácu na hodnotenie? Nebudete môcť urobiť žiadne ďalšie zmeny.';
$string['confirmsubmissionheading'] = 'Potvrdiť odoslanie zadania';
$string['conversionexception'] = 'Nebolo možné konvertovať zadanie. Výnimka je: {$a}.';
$string['couldnotconvertgrade'] = 'Nebolo možné konvertovať hodnotenie zadania pre používateľa {$a}.';
$string['couldnotconvertsubmission'] = 'Nebolo možné konvertovať odovzdané zadania pre používateľa {$a}.';
$string['couldnotcreatecoursemodule'] = 'Nebolo možné vytvoriť modul kurzu.';
$string['couldnotcreatenewassignmentinstance'] = 'Nebolo možné vytvoriť novú inštanciu zadania.';
$string['couldnotfindassignmenttoupgrade'] = 'Nebolo možné nájsť staré inštancie modulov zadanie pre aktualizáciu.';
$string['crontask'] = 'Spracovanie na pozadí pre modul zadanie';
$string['currentassigngrade'] = 'Aktuálna známka v zadaní';
$string['currentattempt'] = 'Toto je pokus č. {$a}.';
$string['currentattemptof'] = 'Toto je pokus č. {$a->attemptnumber} (celkom je povolených {$a->maxattempts} pokusov).';
$string['currentgrade'] = 'Súčasné hodnotenie vo výkaze známok';
$string['cutoffdate'] = 'Dátum ukončenia';
$string['cutoffdate_help'] = 'Ak je nastavené, nebude povolené odovzdávanie zadania po tomto dátume bez predĺženia termínu. Ak nie je nastavené, budú odovzdané zadania vždy akceptované.';
$string['cutoffdatecolon'] = 'Dátum ukončenia: {$a}';
$string['cutoffdatefromdatevalidation'] = 'Dátum ukončenia nemôže byť pred dátumom, ktorým bolo umožnené odovzdávať zadania';
$string['cutoffdatevalidation'] = 'Dátum ukončenia nemôže byť skôr ako dátum odovzdania.';
$string['defaultlayout'] = 'Obnoviť pôvodný vzhľad';
$string['defaultsettings'] = 'Východzie nastavenia zadania';
$string['defaultsettings_help'] = 'Tieto nastavenia definujú východzie hodnoty pre všetky nové zadania.';
$string['defaultteam'] = 'Východzia skupina';
$string['deleteallsubmissions'] = 'Vymazať všetky odovzdané zadania';
$string['description'] = 'Opis';
$string['disabled'] = 'Zakázané';
$string['downloadall'] = 'Stiahnuť všetky odovzdané zadania';
$string['downloadasfolders'] = 'Stiahnuť zadania do adresárov';
$string['downloadasfolders_help'] = 'Odovzdané zadania môžu byť stiahnuté do adresárov. Každé zadanie bude v samostatnom adresári, štruktúra podadresárov bude zachovaná a súbory nebudú premenované.';
$string['downloadselectedsubmissions'] = 'Uložiť vybrané odovzdané zadania';
$string['duedate'] = 'Termín odovzdania';
$string['duedate_help'] = 'Toto určuje dátum, do ktorého je potrebné vypracovať zadanie. Ak sú povolené oneskorené odovzdávania, bude každé zadanie vložené po tomto dátume ako oneskorené. Pre úplné zabránenie odovzdávania po určitom termínu nastavte dátum ukončenia.';
$string['duedateaftersubmissionvalidation'] = 'Dátum odovzdania musí byť po dátume schválenia predloženia zadania.';
$string['duedatecolon'] = 'Termín odovzdania: {$a}';
$string['duedatereached'] = 'Termín pre odovzdanie tohto zadania už uplynul';
$string['duedatevalidation'] = 'Termín odovzdania musí byť po termíne povoľujúcom odovzdanie zadaní.';
$string['duplicateoverride'] = 'Duplikovať prestavenie';
$string['editaction'] = 'Akcie ...';
$string['editattemptfeedback'] = 'Upraviť hodnotenie pre pokus č. {$a}.';
$string['editingpreviousfeedbackwarning'] = 'Upravujete hodnotenie k odovzdanému riešeniu, ktoré nie je najnovšie. Toto je pokus č. {$a->attemptnumber} z celkového počtu {$a->totalattempts}.';
$string['editingstatus'] = 'Stav úprav';
$string['editonline'] = 'Upraviť online';
$string['editoverride'] = 'Upraviť prestavenie';
$string['editsubmission'] = 'Upraviť vypracované zadanie';
$string['editsubmission_help'] = 'Stále môžete vykonávať zmeny vo vašom odovzdanom zadaní.';
$string['editsubmissionother'] = 'Upraviť riešenie zadania {$a}';
$string['enabled'] = 'Povolené';
$string['enabletimelimit'] = 'Povoliť zadania s časovým limitom';
$string['enabletimelimit_help'] = 'Ak je povolené, na stránke nastavení zadania môžete nastaviť časový limit.';
$string['errornosubmissions'] = 'Nie sú žiadne odovzdané zadania na stiahnutie';
$string['errorquickgradingvsadvancedgrading'] = 'Hodnotenia neboli uložené, pretože zadanie v súčasnosti využíva pokročilé hodnotenie.';
$string['errorrecordmodified'] = 'Hodnotenia neboli uložené, pretože niekto iný upravil jeden alebo viacero záznamov potom, ako ste načítali túto stránku.';
$string['eventallsubmissionsdownloaded'] = 'Všetky odovzdané zadania sa sťahujú';
$string['eventassessablesubmitted'] = 'Zadanie bolo odoslané';
$string['eventbatchsetmarkerallocationviewed'] = 'Zobrazené pridelenie hodnotiteľov';
$string['eventbatchsetworkflowstateviewed'] = 'Zobrazenie nastavenia spracovania známok';
$string['eventextensiongranted'] = 'Bolo poskytnuté predĺženie termínu';
$string['eventfeedbackupdated'] = 'Komentár bol aktualizovaný';
$string['eventfeedbackviewed'] = 'Komentár bol zobrazený';
$string['eventgradingformviewed'] = 'Hodnotiaci formulár bol zobrazený';
$string['eventgradingtableviewed'] = 'Tabuľka známok bola zobrazená';
$string['eventidentitiesrevealed'] = 'Identita študentov bola odhalená';
$string['eventmarkerupdated'] = 'Pridelený hodnotiteľ bol aktualizovaný.';
$string['eventoverridecreated'] = 'Prestavenie zadania bolo vytvorené';
$string['eventoverridedeleted'] = 'Prestavenie zadania bolo odstránené';
$string['eventoverrideupdated'] = 'Prestavenie zadania bolo aktualizované';
$string['eventremovesubmissionformviewed'] = 'Zobrazené potvrdenie odstránenia zadania.';
$string['eventrevealidentitiesconfirmationpageviewed'] = 'Bola zobrazená stránka o potvrdení odhalenia identity.';
$string['eventstatementaccepted'] = 'Používateľ prijal prehlásenie o odovzdanom zadaní.';
$string['eventsubmissionconfirmationformviewed'] = 'Bol zobrazený formulár potvrdenia riešenia zadania';
$string['eventsubmissioncreated'] = 'Bolo vytvorené riešenie zadania.';
$string['eventsubmissionduplicated'] = 'Používateľ duplikoval svoje riešenie zadania.';
$string['eventsubmissionformviewed'] = 'Bol zobrazený formulár pre riešenia zadania.';
$string['eventsubmissiongraded'] = 'Odovzdané zadanie bolo hodnotené.';
$string['eventsubmissionlocked'] = 'Odovzdané zadanie bolo pre používateľa zamknuté.';
$string['eventsubmissionremoved'] = 'Riešenie zadania bolo odstránené';
$string['eventsubmissionstatusupdated'] = 'Stav odovzdaného zadania bol aktualizovaný.';
$string['eventsubmissionstatusviewed'] = 'Bol zobrazený stav riešenia zadania.';
$string['eventsubmissionunlocked'] = 'Odovzdané zadanie bolo pre používateľa odomknuté.';
$string['eventsubmissionupdated'] = 'Používateľ aktualizoval svoje zadanie.';
$string['eventsubmissionviewed'] = 'Bolo zobrazené riešenie zadania.';
$string['eventworkflowstateupdated'] = 'Stav spracovania bol aktualizovaný.';
$string['expandreviewpanel'] = 'Rozbaliť panel revízie známok';
$string['extensionduedate'] = 'Predĺžený termín odovzdania';
$string['extensionnotafterduedate'] = 'Predĺžený termín odovzdania musí byť po termíne odovzdania';
$string['extensionnotafterfromdate'] = 'Predĺžený termín odovzdania musí byť po dátume umožňujúcom odovzdanie zadania';
$string['feedback'] = 'Komentár';
$string['feedbackavailableanonhtml'] = 'Máte nové hodnotenie u o Vášho odovzdaného zadania "<i>{$a->assignment}</i>"<br /><br />
Hodnotenie si môžete zobraziť u svojho <a href="{$a->url}">odovzdaného zadania</a>.';
$string['feedbackavailableanonsmall'] = 'Nové hodnotenie zadania {$a->assignment}';
$string['feedbackavailableanontext'] = 'Máte nové hodnotenie u o Vášho odovzdaného zadania "{$a->assignment}"

Hodnotenie si môžete zobraziť u svojho odovzdaného zadania:

  {$a->url}';
$string['feedbackavailablehtml'] = '{$a->username} vložil komentáre na vaše odovzdané zadanie \'<i>{$a->assignment}</i>\'<br /><br /> Môžete si ho prezrieť pripojené k vášmu <a href="{$a->url}">odovzdanému zadaniu</a>.';
$string['feedbackavailablesmall'] = '{$a->username} vložil komentáre k zadaniu {$a->assignment}';
$string['feedbackavailabletext'] = '{$a->username} vložil komentáre na vaše odovzdané zadanie  \'{$a->assignment}\' Môžete si ho prezrieť pripojené k vášmu zadaniu: {$a->url}';
$string['feedbackplugin'] = 'Zásuvný modul pre komentár';
$string['feedbackpluginforgradebook'] = 'Zásuvný modul pre komentáre bude zapisovať komentáre k hodnoteniu';
$string['feedbackpluginforgradebook_help'] = 'Iba jeden zo zásuvných modulov komentárov k zadaniu môže vložiť komentár do výkazu známok.';
$string['feedbackplugins'] = 'Moduly komentárov';
$string['feedbacksettings'] = 'Nastavenia komentára';
$string['feedbacktypes'] = 'Typy hodnotenia';
$string['filesubmissions'] = 'Súbory odovzdaných zadaní';
$string['filter'] = 'Filter';
$string['filterdraft'] = 'Pracovná verzia';
$string['filtergrantedextension'] = 'Predĺženie povolené';
$string['filternone'] = 'Bez filtru';
$string['filternotsubmitted'] = 'Neodovzdané';
$string['filterrequiregrading'] = 'Vyžaduje hodnotenie';
$string['filtersubmitted'] = 'Zadanie bolo odovzdané';
$string['fixrescalednullgrades'] = 'Toto zadania obsahuje niektoré chybné známky. Tieto známky <a href="{$a->link}"> môžete automaticky opraviť </a>. To môže mať vplyv na súčty kurzov.';
$string['fixrescalednullgradesconfirm'] = 'Naozaj chcete opraviť chybné známky? Všetky známky, ktorých sa to týka, budú odstránené. Môže to mať vplyv na súčty kurzov.';
$string['fixrescalednullgradesdone'] = 'Známky boli opravené.';
$string['gradeabovemaximum'] = 'Hodnotenie musí byť menšie alebo rovné ako {$a}.';
$string['gradebelowzero'] = 'Hodnotenie musí byť väčšie alebo rovné ako nule.';
$string['gradebreakdown'] = 'Rozpis známok';
$string['gradecanbechanged'] = 'Známka môže byť zmenená';
$string['gradechangessaveddetail'] = 'Zmeny známky a spätná väzba boli uložené';
$string['graded'] = 'Hodnotené';
$string['gradedby'] = 'Hodnotené kým:';
$string['gradedfollowupsubmit'] = 'Ohodnotené – znova odoslané';
$string['gradedon'] = 'Hodnotené na';
$string['gradeitem:submissions'] = 'Príspevky';
$string['gradelocked'] = 'Táto známka je vo výkaze známok zamknutá alebo prepísaná.';
$string['gradeoutof'] = 'Hodnotené z {$a}';
$string['gradeoutofhelp'] = 'Hodnotenie';
$string['gradeoutofhelp_help'] = 'Sem zadajte známku za vypracované zadanie študenta. Môžete použiť desatinné miesta.';
$string['gradersubmissionupdatedhtml'] = '{$a->username} aktualizoval  vypracované zadanie pre <i>\'{$a->assignment}\' dňa {$a->timeupdated}</i><br /><br />Je <a href="{$a->url}">dostupné na web portáli</a>.';
$string['gradersubmissionupdatedsmall'] = '{$a->username} aktualizoval svoje odovzdané zadanie {$a->assignment}.';
$string['gradersubmissionupdatedtext'] = '{$a->username} aktualizoval svoje vypracované zadanie pre \'{$a->assignment}\' dňa {$a->timeupdated}

Je dostupné tu:

{$a->url}';
$string['gradestudent'] = 'Hodnotenie študenta: (id={$a->id}, fullname={$a->fullname}).';
$string['gradeuser'] = 'Známka {$a}';
$string['grading'] = 'Hodnotenie';
$string['gradingchangessaved'] = 'Zmeny vo známkach boli uložené';
$string['gradingduedate'] = 'Pripomenúť mi termín známkovania';
$string['gradingduedate_help'] = 'Predpokladaný termín, do ktorého by malo byť dokončené hodnotenie odovzdaných zadaní. Tento dátum sa používa pre stanovenie priorít oznámení na Nástenke učiteľov.';
$string['gradingdueduedatevalidation'] = 'Pripomenutie termínu známkovania podľa dátumu nemôže byť skôr, ako je termín odovzdania zadania.';
$string['gradingduefromdatevalidation'] = 'Pripomenutie termínu známkovania podľa dátumu nemôže byť skôr, ako je termín povolenia odovzdania zadania.';
$string['gradingmethodpreview'] = 'Kritériá hodnotenia';
$string['gradingoptions'] = 'Voľby';
$string['gradingstatus'] = 'Stav hodnotenia';
$string['gradingstudent'] = 'Hodnotený študent';
$string['gradingsummary'] = 'Sumár hodnotenia';
$string['grantextension'] = 'Poskytnúť predĺženie';
$string['grantextensionforusers'] = 'Poskytnúť predĺženie pre {$a} študentov';
$string['groupoverrides'] = 'Prestavenie skupiny';
$string['groupoverridesdeleted'] = 'Prestavenie skupiny bolo odstránené';
$string['groupsnone'] = 'V tomto kurze neexistujú žiadne skupiny, ku ktorým máte prístup.';
$string['groupsubmissionsettings'] = 'Nastavenie skupinového riešenia';
$string['hiddenuser'] = 'Účastník';
$string['hidegrader'] = 'Skryť študentom identitu hodnotiteľa';
$string['hidegrader_help'] = 'Ak je povolené, nie je zobrazená totožnosť používateľa, ktorý hodnotí odoslané zadanie, takže študenti nemôžu vidieť, kto hodnotil ich prácu.

Toto nastavenie nemá žiadny vplyv na pole komentárov na stránke známkového výkazu.';
$string['hideshow'] = 'Skryť/zobraziť.';
$string['inactiveoverridehelp'] = '* Toto prepísanie nie je aktívne, pretože prístup používateľa k aktivite je obmedzený. Dôvodom môže byť priradenie skupín alebo rolí, iné obmedzenia prístupu alebo skrytá aktivita.';
$string['indicator:cognitivedepth'] = 'Kognitívne zadanie';
$string['indicator:cognitivedepth_help'] = 'Tento indikátor je založený na študentom získanej kognitívnej hĺbke v aktivite Zadanie.';
$string['indicator:cognitivedepthdef'] = 'Kognitívne zadanie';
$string['indicator:cognitivedepthdef_help'] = 'Počas tohto intervalu analýzy dosiahol účastník tohto percenta kognitivnej angažovanosti ponúkanej aktivitami Zadanie (Úrovne = Bez zobrazenia, Zobrazenie, Odovzdanie, Zobrazenie spätnej väzby, Komentár k spätnej väzbe, Nové odovzdanie po zobrazení spätnej väzby)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Sociálne zadanie';
$string['indicator:socialbreadth_help'] = 'Tento indikátor je založený na študentom získanej sociálnej šírke v aktivite Zadanie.';
$string['indicator:socialbreadthdef'] = 'Sociálne zadanie';
$string['indicator:socialbreadthdef_help'] = 'Počas tohto intervalu analýzy dosiahol účastník tohto percenta sociálnej angažovanosti ponúkanej aktivitou Zadanie (Úrovne = Bez účasti, Účastník sám, Účastník s ostatnými)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['instructionfiles'] = 'Súbory s návodmi';
$string['introattachments'] = 'Ďalšie súbory';
$string['introattachments_help'] = 'V opise zadania môžu byť priložené ďalšie súbory, ako napríklad vzorová šablóna zadania. Odkazy na tieto súbory potom budú zobrazené pod opisom zadania.';
$string['invalidfloatforgrade'] = 'Neplatné hodnotenie: {$a}';
$string['invalidgradeforscale'] = 'Poskytnuté hodnotenie nie je správne pre súčasnú stupnicu';
$string['invalidoverrideid'] = 'Neplatné id prestavenia';
$string['lastmodifiedgrade'] = 'Posledná zmena (hodnotenie)';
$string['lastmodifiedsubmission'] = 'Posledná zmena (odovzdané hodnotenie)';
$string['latesubmissions'] = 'Oneskorené odovzdané zadania';
$string['latesubmissionsaccepted'] = 'Povolené do  {$a}';
$string['loading'] = 'Nahrávam ...';
$string['locksubmissionforstudent'] = 'Zabrániť odovzdaniu hodnotenia študenta: (id={$a->id}, celé meno={$a->fullname}).';
$string['locksubmissions'] = 'Zamknúť odovzdávanie zadaní';
$string['manageassignfeedbackplugins'] = 'Spravovať zásuvné moduly pre komentovanie zadaní';
$string['manageassignsubmissionplugins'] = 'Spravovať zásuvné moduly pre odovzdanie zadaní';
$string['marker'] = 'Hodnotiteľ';
$string['markerfilter'] = 'Filter hodnotiteľa';
$string['markerfilternomarker'] = 'Bez hodnotiteľa';
$string['markingallocation'] = 'Použiť prideľovanie hodnotiteľov';
$string['markingallocation_help'] = 'Ak je povolená postup známkovania, potom môžu mať určití študenti definovaných svojich hodnotiteľov.';
$string['markinganonymous'] = 'Povolenie čiastočného zverejnenia hodnotení v anonymných hodnoteniach';
$string['markinganonymous_help'] = 'Ak je to povolené v spojení s anonymnými podaniami a pracovným postupom hodnotenia, umožňuje to čiastočné zverejnenie hodnotenia počas anonymného hodnotenia.';
$string['markingworkflow'] = 'Použiť postup známkovania';
$string['markingworkflow_help'] = 'Ak je táto možnosť aktivovaná, musia hodnotenia prejsť sériou postupových stavov predtým, ako sú zverejnené študentom. Tým sa umožní viac kôl hodnotenia a všetkým študentom bude hodnotenie zverejnené naraz.';
$string['markingworkflowstate'] = 'Stav postupu známkovania';
$string['markingworkflowstate_help'] = 'Možné postupné stavy hodnotenia sú (v závislosti od vašich oprávnení):

* Neohodnotené - hodnotiteľ ešte nezačal
* Hodnotí sa - hodnotiteľ začal, ale ešte neskončil
* Hodnotenie dokončené - hodnotiteľ skončil, ale možno sa potrebuje k prácam vrátiť na kontrolu/opravy
* Posudzuje sa - hodnotenia sú teraz u učiteľa, ktorý je zodpovedný za kontrolu kvality
* Pripravené na zverejnenie - zodpovedný učiteľ je spokojný s hodnotením, ale čaká, kým dá študentom prístup k hodnoteniu
* Zverejnené - študent má prístup k hodnoteniu/spätnej väzbe';
$string['markingworkflowstateinmarking'] = 'Známkované';
$string['markingworkflowstateinreview'] = 'Revidované';
$string['markingworkflowstatenotmarked'] = 'Bez známky';
$string['markingworkflowstatereadyforrelease'] = 'Pripravené na zverejnenie';
$string['markingworkflowstatereadyforreview'] = 'Známkovanie ukončené';
$string['markingworkflowstatereleased'] = 'Zverejnené';
$string['maxattempts'] = 'Maximálny počet pokusov';
$string['maxattempts_help'] = 'Najvyšší možný počet pokusov na odovzdanie zadania pre každého študenta. Po dosiahnutí tohto počtu už nebude možné opätovne otvoriť odovzdané zadanie pre ďalšie úpravy.';
$string['maxgrade'] = 'Maximálna známka';
$string['maxperpage'] = 'Maximum zadaní na stránku';
$string['maxperpage_help'] = 'Maximálny počet zadaní zobrazených učiteľovi na stránke pre známkovanie. Je to užitočné, aby sa zabránilo prekročeniu časových limitov servera v kurzoch s veľmi veľkým počtom študentov.';
$string['messageprovider:assign_notification'] = 'Notifikácie zadaní';
$string['modulename'] = 'Zadanie';
$string['modulename_help'] = 'Modul Zadanie umožňuje učiteľovi odkomunikovať úlohy, pozbierať práce, ohodnotiť a okomentovať ich v spätnej väzbe.

Študenti môžu odovzdať ľubovoľný digitálny obsah (súbory), ako sú dokumenty textových aplikácií, tabuľky, obrázky alebo audio- a videoklipy. Alternatívne alebo okrem toho môže zadanie požadovať, aby študenti napísali text priamo do textového poľa. Zadanie je možné tiež použiť na to, aby sa študentom pripomenuli úlohy "reálneho sveta", ktoré  potrebujú dokončiť offline - napr. umelecké dielo, a preto si nevyžadujú žiadny digitálny obsah. Študenti môžu prácu odovzdávať individuálne, alebo ako členovia skupiny.

Pri posudzovaní zadaní môžu učitelia vytvárať komentáre a nahrávať súbory, ako sú ohodnotené práce používateľov, dokumenty s komentármi alebo nahovorenú audio spätnú väzbu. Zadania je možné ohodnotiť použitím číselnej alebo vlastnej stupnice alebo rozšírenej hodnotiacej metódy, ako je napr. rubrika. Záverečné hodnotenia sa zaznamenávajú do známkového výkazu';
$string['modulename_link'] = 'mod/assignment/view';
$string['modulenameplural'] = 'Zadania';
$string['moreusers'] = '{$a} viac ...';
$string['multipleteams'] = 'Člen viac ako jednej skupiny';
$string['multipleteams_desc'] = 'Toto zadanie vyžaduje riešenie zadania v skupinách. Ste členom viac ako jednej skupiny. Aby ste mohli odoslať riešenie zadania, musíte byť členom iba jednej skupiny. Kontaktujte svojho učiteľa, aby aktualizoval vaše členstvá v skupinách.';
$string['multipleteamsgrader'] = 'Člen viac ako jednej skupiny, nemôže odovzdať zadanie.';
$string['newsubmissions'] = 'Odovzdané zadania';
$string['nextuser'] = 'Ďalší používateľ';
$string['noattempt'] = 'Neodovzdané';
$string['noclose'] = 'Nie je dátum ukončenia';
$string['nofiles'] = 'Žiadne súbory';
$string['nofilters'] = 'Žiadne filtre';
$string['nograde'] = 'Žiadne hodnotenie.';
$string['nogroupoverrides'] = 'Momentálne neexistujú žiadne prepísania skupiny.';
$string['nomoresubmissionsaccepted'] = 'Povolené je iba pre študentov, ktorým bola predĺžená lehota na odovzdanie.';
$string['none'] = 'Nič';
$string['noonlinesubmissions'] = 'Toto zadanie nevyžaduje odpovedať online';
$string['noopen'] = 'Nie je dátum zahájenia';
$string['nooverridedata'] = 'Musíte prestaviť aspoň jedno nastavenie zadania';
$string['nosavebutnext'] = 'Ďalší';
$string['nosubmission'] = 'V tomto zadaní nebolo nič odovzdané';
$string['nosubmissionyet'] = 'Zatiaľ neboli odovzdané žiadne riešenia zadania.';
$string['noteam'] = 'Nie je členom žiadnej skupiny';
$string['noteam_desc'] = 'Toto zadanie vyžaduje riešenie zadania v skupinách. Nie ste členom žiadnej skupiny, takže nemôžete odoslať riešenie zadania. Kontaktujte svojho učiteľa, aby Vás pridal do nejakej skupiny.';
$string['noteamgrader'] = 'Nie je členom žiadnej skupiny, nemôže odovzdať zadanie.';
$string['notgraded'] = 'Nehodnotené';
$string['notgradedyet'] = 'Ešte neoznámkované';
$string['notifications'] = 'Oznámenia';
$string['nouseroverrides'] = 'Momentálne neexistujú žiadne prepísania používateľov.';
$string['nousers'] = 'Žiadni používatelia';
$string['nousersselected'] = 'Neboli vybraní používatelia';
$string['numberofdraftsubmissions'] = 'Pracovné verzie';
$string['numberofparticipants'] = 'Účastníci';
$string['numberofsubmissionsneedgrading'] = 'Je potrebné ohodnotiť';
$string['numberofsubmissionsneedgradinglabel'] = 'Potrebné hodnotiť: {$a}';
$string['numberofsubmittedassignments'] = 'Odovzdané';
$string['numberofteams'] = 'Skupiny';
$string['offline'] = 'Nie sú požadované online odpovede';
$string['open'] = 'Otvorené';
$string['opensubmissionexists'] = 'Už existuje otvorené zadanie';
$string['outlinegrade'] = 'Hodnotenie: {$a}';
$string['outof'] = '{$a->current} z {$a->total}';
$string['overdue'] = 'Zadanie je oneskorené o: {$a}';
$string['override'] = 'Prestavenie';
$string['overridedeletegroupsure'] = 'Naozaj chcete odstrániť prestavenie pre skupinu {$a}?';
$string['overridedeleteusersure'] = 'Naozaj chcete odstrániť prestavenie pre používateľa {$a}?';
$string['overridegroup'] = 'Prestaviť skupinu';
$string['overridegroupeventname'] = '{$a->assign} - {$a->group}';
$string['overrides'] = 'Prestaviť';
$string['overrideuser'] = 'Prestaviť používateľa';
$string['overrideusereventname'] = '{$a->assign} - Prestaviť';
$string['page-mod-assign-view'] = 'Hlavná stránka modulu zadanie';
$string['page-mod-assign-x'] = 'Ľubovoľná stránka modulu zadanie';
$string['paramtimeremaining'] = '{$a} zostáva';
$string['participant'] = 'Účastník';
$string['pluginadministration'] = 'Administratíva zadania';
$string['pluginname'] = 'Zadanie';
$string['preventsubmissionnotingroup'] = 'Vyžadovať zaradenie do skupiny pre odovzdanie úlohy';
$string['preventsubmissionnotingroup_help'] = 'Ak je táto možnosť aktivovaná, používatelia, ktorí nie sú členmi skupiny, nebudú môcť odovzdať úlohu.';
$string['preventsubmissions'] = 'Zabrániť používateľovi odoslať ďalšie odovzdanie zadania';
$string['preventsubmissionsshort'] = 'Zabrániť zmenám v odovzdaných zadaniach';
$string['previous'] = 'Predchádzajúci';
$string['previoususer'] = 'Predchádzajúci používateľ';
$string['privacy:attemptpath'] = 'pokus {$a}';
$string['privacy:blindmarkingidentifier'] = 'Identifikátor používaný pre hodnotenie naslepo';
$string['privacy:gradepath'] = 'známka';
$string['privacy:metadata:assigndownloadasfolders'] = 'Nastavenie používateľa, či sa viacero odovzdaných riešení zadaní má ukladať do podadresárov.';
$string['privacy:metadata:assignfeedbackpluginsummary'] = 'Údaje spätnej väzby pre zadanie.';
$string['privacy:metadata:assignfilter'] = 'Možnosti filtrov, ako sú napríklad "Odovzdané", "Neodovzdané", "Žiadané hodnotenie" a "Povolené predĺženie"';
$string['privacy:metadata:assigngrades'] = 'Uloží známky používateľa pre zadanie';
$string['privacy:metadata:assignmarkerfilter'] = 'Filtrovanie súhrnu zadania podľa známky.';
$string['privacy:metadata:assignmentid'] = 'Identifikátor zadania';
$string['privacy:metadata:assignmessageexplanation'] = 'Správy sú študentom posielané prostredníctvom systému posielania správ.';
$string['privacy:metadata:assignoverrides'] = 'Uloženie prepíše informáciu zadania';
$string['privacy:metadata:assignperpage'] = 'Počet zadaní zobrazených na stránke.';
$string['privacy:metadata:assignquickgrading'] = 'Nastavenie, či sa používa rýchle hodnotenie alebo nie.';
$string['privacy:metadata:assignsubmissiondetail'] = 'Uloží používateľské informácie o odovzdaných riešeniach zadania';
$string['privacy:metadata:assignsubmissionpluginsummary'] = 'Odovzdané riešenia zadania';
$string['privacy:metadata:assignuserflags'] = 'Uloží používateľské metadáta, ako napríklad dátum predĺženia termínu';
$string['privacy:metadata:assignusermapping'] = 'Mapovanie pre známkovanie naslepo';
$string['privacy:metadata:assignworkflowfilter'] = 'Filtrovanie podľa rôznych stavov pracovného postupu.';
$string['privacy:metadata:grade'] = 'Číselná známka pre odovzdané riešenie zadania. Môže byť určená stupnicou/ pokročilým hodnotením atď., ale vždy bude naspäť konvertovaná na desatinné číslo.';
$string['privacy:metadata:grader'] = 'IP používateľa hodnotiteľa.';
$string['privacy:metadata:groupid'] = 'ID skupiny, ktorej je používateľ členom.';
$string['privacy:metadata:latest'] = 'Výrazne zjednodušuje dotazy, ktoré potrebujú poznať informácie o poslednom pokuse.';
$string['privacy:metadata:mailed'] = 'Bola tomuto používateľovi odoslaná pošta?';
$string['privacy:metadata:timecreated'] = 'Čas vytvorenia';
$string['privacy:metadata:timestarted'] = 'Čas začatia';
$string['privacy:metadata:userid'] = 'ID používateľa';
$string['privacy:studentpath'] = 'odovzdané riešenia zadania študenta';
$string['privacy:submissionpath'] = 'odovzdané zadanie';
$string['quickgrading'] = 'Rýchle hodnotenie';
$string['quickgrading_help'] = 'Rýchle hodnotenie umožňuje priradiť hodnotenia (a očakávané výstupy) priamo v tabuľke odovzdaných úloh. Rýchle hodnotenie nie je kompatibilné s pokročilým hodnotením a neodporúča sa pri hodnotení viacerými hodnotiteľmi.';
$string['quickgradingchangessaved'] = 'Zmeny hodnotenia boli uložené';
$string['quickgradingresult'] = 'Rýchle hodnotenie';
$string['recordid'] = 'Identifikátor';
$string['relativedatessubmissiontimeleft'] = 'Vypočítané pre každého študenta';
$string['removeallgroupoverrides'] = 'Odstrániť všetky prestavenia skupín';
$string['removealluseroverrides'] = 'Odstrániť všetky prestavenia používateľov';
$string['removesubmission'] = 'Odstrániť vložené zadanie';
$string['removesubmissionconfirm'] = 'Naozaj chcete odstrániť svoje riešenie zadania?';
$string['removesubmissionconfirmforstudent'] = 'Naozaj chcete odstrániť vložené riešenie zadania pre študenta {$a}??';
$string['removesubmissionconfirmforstudentwithtimelimit'] = 'Naozaj chcete odstrániť riešenie zadania pre {$a}? Upozorňujeme, že sa tým nevynuluje časový limit študenta. Môžete poskytnúť viac času pridaním prepísania časového limitu používateľom.';
$string['removesubmissionconfirmwithtimelimit'] = 'Naozaj chcete odstrániť svoje riešenie zadania? Upozorňujeme, že týmto sa nevynuluje váš časový limit.';
$string['removesubmissionforstudent'] = 'Odstrániť odovzdané zadania pre študenta: (id={$a->id}, celé meno={$a->fullname}).';
$string['reopenuntilpassincompatiblewithblindmarking'] = 'Možnosť opätovného otvorenia pred dokončením nie je kompatibilná s hodnotením naslepo, pretože hodnotenia nebudú uvoľnené do klasifikačného hárku dovtedy, kým nie sú odhalené identity študentov.';
$string['requireallteammemberssubmit'] = 'Vyžaduje sa potvrdenie všetkých členov skupiny';
$string['requireallteammemberssubmit_help'] = 'Toto nastavenie sa musí používať spolu s nastavením "Vyžadovať od študentov kliknutie na tlačidlo Odoslať" v časti Nastavenia odosielania.

Ak je táto možnosť zapnutá, všetci členovia skupiny musia kliknúť na tlačidlo Odoslať, aby sa skupina považovala za odoslanú. Ak je vypnuté, každý člen skupiny môže kliknúť na tlačidlo Odoslať.ať.';
$string['requiresubmissionstatement'] = 'Požadovať, aby študenti potvrdili predložené vyhlásenie';
$string['requiresubmissionstatement_help'] = 'Požadovať, aby študenti potvrdili predložené vyhlásenie pre všetky dokumenty a texty tohto zadania';
$string['revealidentities'] = 'Odhaliť identitu študentov';
$string['revealidentitiesconfirm'] = 'Skutočne si želáte odhaliť identity používateľov v tomto zadaní Táto operácia je nevratná. Len čo sú odhalené identity študentov, hodnotenia budú zverejnené v známkovom výkaze.';
$string['reverttodefaults'] = 'Vrátiť zadanie na východzie hodnoty';
$string['reverttodraft'] = 'Vrátiť zadanie do stavu pracovnej verzie.';
$string['reverttodraftforgroup'] = 'Vrátiť riešenie zadania do stavu konceptu pre skupinu {$a}.';
$string['reverttodraftforstudent'] = 'Vrátiť zadanie do stavu pracovnej verzie pre študenta: (id={$a->id}, fullname={$a->fullname}).';
$string['reverttodraftshort'] = 'Vrátiť zadanie do stavu pracovnej verzie.';
$string['reviewed'] = 'Kontrolované';
$string['save'] = 'Uložiť';
$string['saveallquickgradingchanges'] = 'Uložiť všetky zmeny v rýchlom hodnotení';
$string['saveandcontinue'] = 'Uložiť a pokračovať';
$string['savechanges'] = 'Uložiť zmeny';
$string['savegradingresult'] = 'Známka';
$string['savenext'] = 'Uložiť a zobraziť ďalší';
$string['saveoverrideandstay'] = 'Uložiť a vložiť ďalšie prestavenie';
$string['savingchanges'] = 'Uložiť zmeny...';
$string['scale'] = 'Mierka';
$string['search:activity'] = 'Zadanie - informácie';
$string['selectedusers'] = 'Vybraní používatelia';
$string['selectlink'] = 'Vybrať ...';
$string['selectuser'] = 'Vybrať  {$a}';
$string['sendlatenotifications'] = 'Poslať oznámenie hodnotiteľom o oneskorených zadaniach';
$string['sendlatenotifications_help'] = 'Ak je povolené, hodnotiteľom (obvykle učiteľom) bude zaslané správa vždy, keď nejaký študent vypracuje zadanie oneskorene. Spôsoby zasielania správ sú konfigurovateľné.';
$string['sendnotifications'] = 'Poslať oznámenie hodnotiteľom';
$string['sendnotifications_help'] = 'Ak je povolené, hodnotiteľom (obvykle učiteľom) bude zaslané správa vždy, keď nejaký študent vypracuje zadanie (načas alebo oneskorene). Spôsoby zasielania správ sú konfigurovateľné.';
$string['sendstudentnotifications'] = 'Upozorniť študenta';
$string['sendstudentnotifications_help'] = 'Ak je táto možnosť aktivovaná, študenti dostanú správu o aktualizovanom hodnotení alebo spätnej väzbe. Ak je v tomto zadaní nastavený pracovný postup, alebo sú známky v známkovom výkaz skryté, nebudú sa upozornenia odosielať, kým nebude známka v stave "Zverejnené".';
$string['sendstudentnotificationsdefault'] = 'Východzie nastavenie pre "Upozorniť študentov"';
$string['sendstudentnotificationsdefault_help'] = 'Nastaviť štandardnú hodnotu pre "Oznámiť študentom" v zaškrtávacom okienku v hodnotiacom formulári?';
$string['sendsubmissionreceipts'] = 'Poslať potvrdenie o odovzdaní zadania študentom';
$string['sendsubmissionreceipts_help'] = 'Tento prepínač umožní povolenie zasielania potvrdení o odovzdaní zadania študentom. Študenti dostanú správu vždy, keď úspešne odovzdajú zadanie.';
$string['setmarkerallocationforlog'] = 'Nastaviť pridelenie hodnotiteľov: (id = {$a->id}, meno = {$a->fullname}, hodnotiteľ = {$a->marker}).';
$string['setmarkingallocation'] = 'Nastaviť hodnotiteľa';
$string['setmarkingworkflowstate'] = 'Nastaviť stav známkovania';
$string['setmarkingworkflowstateforlog'] = 'Nastavenie postupu známkovania: (id = {$a->id}, meno = {$a->fullname}, stav = {$a->state}).';
$string['settings'] = 'Nastavenia zadania';
$string['showrecentsubmissions'] = 'Zobrazovať nedávno odovzdané zadania';
$string['status'] = 'Status';
$string['studentnotificationworkflowstateerror'] = 'Označenie stavu pracovného postupu hodnotenia musí mať hodnotu "Zverejnené" na to, aby boli upozornení študenti.';
$string['submission'] = 'Odovzdané zadanie';
$string['submissionattachments'] = 'Zobrazovať súbory iba pri odovzdávaní zadania.';
$string['submissionattachments_help'] = 'Keď je táto možnosť povolená, súbory sa zobrazia iba na obrazovke odovzdávania.
Keď je táto možnosť zakázaná, súbory sa budú zobrazovať na obrazovke zadania aj na obrazovke odovzdávania.';
$string['submissioncopiedhtml'] = '<p>Vytvorili ste kópiu už odovzdaného zadania \'<i>{$a->assignment}</i>\'.</p>
<p>Stav vášho odovzdaného zadania <a href="{$a->url}">si môžete pozrieť</a>.</p>';
$string['submissioncopiedsmall'] = 'Skopírovali ste predošlé odovzdané zadanie {$a->assignment}';
$string['submissioncopiedtext'] = 'Vytvorili ste kópiu už odovzdaného zadania \'{$a->assignment}\'.

Stav vášho odovzdaného zadania môžete vidieť na:

   {$a->url}';
$string['submissiondrafts'] = 'Požadovať, aby študenti klikli na tlačidlo Odoslať';
$string['submissiondrafts_help'] = 'Ak je povolené, študenti budú musieť kliknúť na tlačidlo Odoslať, aby deklarovali, že toto je finálna verzia. Toto umožní študentom držať pracovnú verziu zadania v systéme. Ak sa toto nastavenie zmení z "Nie" na "Áno" potom, ako študenti už odovzdali svoje zadania, tieto budú chápané ako finálne.';
$string['submissioneditable'] = 'Študent môže upraviť toto zadanie';
$string['submissionempty'] = 'Nič nebolo odovzdané';
$string['submissionlog'] = 'Študent: {$a->fullname}, stav: {$a->status}';
$string['submissionmodified'] = 'Odovzdali ste zadania. Prosím opustite túto stránku a skúste znova.';
$string['submissionmodifiedgroup'] = 'Riešenie tohto zadania bolo niekým upravené. Prosím opustite túto stránku a skúste znova.';
$string['submissionnotcopiedinvalidstatus'] = 'Odovzdané zadanie sa nedá skopírovať, pretože bolo od opätovného otvorenia upravované.';
$string['submissionnoteditable'] = 'Študent nemôže upravovať toto zadanie';
$string['submissionnotopen'] = 'Toto zadanie nie je otvorené pre odovzdávanie riešení';
$string['submissionnotready'] = 'Toto zadanie nie je pripravené k odovzdaniu:';
$string['submissionplugins'] = 'Zásuvné moduly odovzdávania zadania';
$string['submissionreceipthtml'] = '<p>Odoslali ste vypracované zadanie \'<i>{$a->assignment}</i>\'</p> <p>Jeho stav môžete vidieť na stránke <a href="{$a->url}">vášho zadania</a>.</p>';
$string['submissionreceiptotherhtml'] = 'Vaše zadanie "<i>{$a->assignment}</i>" bolo odoslané.<br /><br /> Stav vášho odovzdaného zadania <a href="{$a->url}">si môžete pozrieť</a>.';
$string['submissionreceiptothersmall'] = 'Vaše riešenie zadania {$a->assignment} bolo odoslané.';
$string['submissionreceiptothertext'] = 'Vaše riešenie zadania \'{$a->assignment}\' bolo odoslané.

Stav vášho odovzdaného zadania si môžete zobraziť: {$a->url}';
$string['submissionreceipts'] = 'Odoslať potvrdenie o odovzdaní zadania';
$string['submissionreceiptsmall'] = 'Odovzdali ste svoje vypracované zadanie pre zadanie {$a->assignment}';
$string['submissionreceipttext'] = 'Odovzdali ste svoje vypracované zadanie pre zadanie {$a->assignment}

Stav svojho zadania môžete vidieť na tomto odkaze: {$a->url}';
$string['submissionsclosed'] = 'Odovzdávanie bolo uzavreté';
$string['submissionsettings'] = 'Nastavenie odovzdávania zadaní';
$string['submissionslocked'] = 'Toto zadanie neumožňuje odovzdávať vypracované zadanie';
$string['submissionslockedshort'] = 'Zmeny odovzdaných zadaní nie sú povolené';
$string['submissionstatement'] = 'Vyhlásenie';
$string['submissionstatement_help'] = 'Prehlásenie, ktoré musí študent potvrdiť, aby mohol odovzdať svoju prácu.';
$string['submissionstatementacceptedlog'] = 'Vyhlásenie prijaté používateľom {$a}';
$string['submissionstatementdefault'] = 'Toto zadanie je mojou vlastnou prácou okrem častí, kde som uznal použitie prác iných ľudí';
$string['submissionstatementrequired'] = 'Pred odoslaním musíte súhlasiť s týmto vyhlásením.';
$string['submissionstatementteamsubmission'] = 'Prehlásenie o skupinovom riešení zadania';
$string['submissionstatementteamsubmission_help'] = 'Prehlásenie, ktoré študent musí potvrdiť, aby mohol odovzdať prácu svojej skupiny.';
$string['submissionstatementteamsubmissionallsubmit'] = 'Prehlásenie o skupinovom riešení zadania, ktoré odovzdávajú všetci členovia skupiny';
$string['submissionstatementteamsubmissionallsubmit_help'] = 'Prehlásenie, ktoré študent musí potvrdiť, aby mohol odovzdať prácu ako člen skupiny.';
$string['submissionstatementteamsubmissionallsubmitdefault'] = 'Toto zadanie je mojou vlastnou prácou ako člena skupiny okrem častí, kde som uznal použitie prác iných ľudí';
$string['submissionstatementteamsubmissiondefault'] = 'Prehlasujem, že toto riešenie zadania je prácou mojej skupiny s výnimkou citovaného využitia práce iných autorov.';
$string['submissionstatus'] = 'Stav odovzdávania zadania';
$string['submissionstatus_'] = 'Žiadne odovzdané zadanie';
$string['submissionstatus_draft'] = 'Pracovná verzia (neodovzdaná)';
$string['submissionstatus_marked'] = 'Hodnotené';
$string['submissionstatus_new'] = 'Neodovzdané';
$string['submissionstatus_reopened'] = 'Znovu otvorené';
$string['submissionstatus_submitted'] = 'Odoslané na hodnotenie';
$string['submissionstatusheading'] = 'Stav odovzdávania zadania';
$string['submissionsummary'] = '{$a->status}. Posledná zmena {$a->timemodified}';
$string['submissionteam'] = 'Skupina';
$string['submissiontypes'] = 'Typy zadaní';
$string['submitaction'] = 'Odoslať';
$string['submitassignment'] = 'Odoslať zadanie';
$string['submitassignment_help'] = 'Ak odošlete toto zadanie, už ho nebudete môcť upravovať.';
$string['submitforgrading'] = 'Odoslať na hodnotenie';
$string['submitted'] = 'Zadanie bolo odovzdané';
$string['submittedearly'] = 'Zadanie bolo odovzdané {$a} včas';
$string['submittedlate'] = 'Zadanie bolo odovzdané {$a} po termíne';
$string['submittedlateshort'] = '{$a} neskoro';
$string['submittedovertime'] = 'Riešenie zadania bolo odoslané {$a} mimo časového limitu';
$string['submittedundertime'] = 'Riešenie zadania bolo odoslané {$a} v časovom limite';
$string['subpagetitle'] = '{$a->contextname} - {$a->subpage}';
$string['subplugintype_assignfeedback'] = 'Zásuvný modul spätnej väzby';
$string['subplugintype_assignfeedback_plural'] = 'Zásuvné moduly spätnej väzby';
$string['subplugintype_assignsubmission'] = 'Zásuvný modul vkladania zadania';
$string['subplugintype_assignsubmission_plural'] = 'Zásuvné moduly vkladania zadania';
$string['teamname'] = 'Tím: {$a}';
$string['teamsubmission'] = 'Študenti odovzdávajú zadanie po skupinách';
$string['teamsubmission_help'] = 'Ak je povolené, študenti budú rozdelení do skupín podľa aktuálnych skupín alebo zoskupení. Skupinové zadanie je zdieľané medzi členmi skupiny a všetci jej členovia budú vidieť zmeny od každého.';
$string['teamsubmissiongroupingid'] = 'Zoskupenia pre študentské skupiny';
$string['teamsubmissiongroupingid_help'] = 'Toto je zoskupenie, ktoré zadanie využije na to, aby našlo skupiny pre skupiny študentov. Ak nie je nastavené - použije sa štandardná sada skupín.';
$string['textinstructions'] = 'Inštrukcie k zadaniu';
$string['timelimit'] = 'Časový limit';
$string['timelimit_help'] = 'Ak je povolené, časový limit je uvedený na stránke zadania a počas riešenia zadania sa zobrazuje odpočítavací časovač.';
$string['timelimitnotenabled'] = 'Časový limit nie je pre toto zadanie povolený';
$string['timelimitpassed'] = 'Časový limit uplynul';
$string['timemodified'] = 'Naposledy upravované';
$string['timeremaining'] = 'Ostáva';
$string['timeremainingcolon'] = 'Ostávajúci čas: {$a}';
$string['togglezoom'] = 'Priblížiť/oddialiť oblasť';
$string['ungroupedusers'] = 'Nastavenie "Vyžadovať zaradenie do skupiny" je zapnuté a niektorí používatelia nie sú zaradení do skupiny, takže im to bude brániť v odovzdaní riešenia zadania.';
$string['ungroupedusersoptional'] = 'Nastavenie „Študenti sa prihlásia v skupinách“ je povolené a niektorí používatelia buď nie sú členmi žiadnej skupiny, alebo sú členmi viac ako jednej skupiny. Upozorňujeme, že títo študenti sa prihlásia ako členovia „predvolenej skupiny“.';
$string['unlimitedattempts'] = 'Bez obmedzenia';
$string['unlimitedattemptsallowed'] = 'Počet pokusov nie je obmedzený';
$string['unlimitedpages'] = 'Bez obmedzenia';
$string['unlocksubmissionforstudent'] = 'Povoliť odovzdanie študentom: (id={$a->id}, fullname={$a->fullname}).';
$string['unlocksubmissions'] = 'Odomknúť odovzdané zadania';
$string['unsavedchanges'] = 'Neuložené zmeny';
$string['unsavedchangesquestion'] = 'Niektoré zmeny neboli uložené do známok alebo spätnej väzby. Chcete ich uložiť a pokračovať?';
$string['updategrade'] = 'Aktualizovať hodnotenie';
$string['updatetable'] = 'Uložiť a aktualizovať tabuľku';
$string['upgradenotimplemented'] = 'Aktualizácia nie je implementovaná pre zásuvný modul ({$a->type} {$a->subtype})';
$string['userassignmentdefaults'] = 'Východzie nastavenie priradenia používateľa';
$string['userextensiondate'] = 'Predĺženie bolo poskytnuté do: {$a}';
$string['usergrade'] = 'Známka používateľa';
$string['useridlistnotcached'] = 'Zmeny hodnotenia NEBOLI uložené a nebolo možné určiť, pre ktoré odovzdané úlohy boli vykonané.';
$string['useroverrides'] = 'Prestavenia používateľa';
$string['useroverridesdeleted'] = 'Prestavenia používateľa boli odstránené';
$string['usersnone'] = 'K tomuto zadaniu nemajú prístup žiadni študenti';
$string['usersubmissioncannotberemoved'] = 'Riešenie zadania {$a} nie je možné odstrániť.';
$string['userswhoneedtosubmit'] = 'Používatelia, ktorí potrebujú odovzdať zadanie: {$a}';
$string['validmarkingworkflowstates'] = 'Platné stavy postupu známkovania';
$string['viewadifferentattempt'] = 'Zobraziť iný pokus';
$string['viewbatchmarkingallocation'] = 'Zobrazená stránka pridelených hodnotiteľov';
$string['viewbatchsetmarkingworkflowstate'] = 'Zobrazená stránka nastavenia spracovania známok';
$string['viewfeedback'] = 'Zobraziť komentár';
$string['viewfeedbackforuser'] = 'Zobraziť komentár pre používateľa {$a}';
$string['viewfull'] = 'Kompletné zobrazenie';
$string['viewfullgradingpage'] = 'Otvoriť stránku so všetkými údajmi k hodnoteniu a pre poskytnutie komentárov';
$string['viewgradebook'] = 'Zobraziť známky';
$string['viewgrading'] = 'Zobraziť všetky odovzdané zadania';
$string['viewgradingformforstudent'] = 'Zobraziť známky študenta: (id={$a->id}, fullname={$a->fullname}).';
$string['viewownsubmissionform'] = 'Zobraziť stránku s vlastním odovzdaným zadaním';
$string['viewownsubmissionstatus'] = 'Zobraziť stránku so stavom vlastného odovzdaného zadania.';
$string['viewrevealidentitiesconfirm'] = 'Zobraziť stránku s potvrdením odhalenej identity študentov.';
$string['viewsubmission'] = 'Zobraziť odovzdané zadania';
$string['viewsubmissionforuser'] = 'Zobraziť odovzdané zadania používateľa: {$a}';
$string['viewsubmissiongradingtable'] = 'Zobraziť tabuľku hodnotenia odovzdaných zadaní.';
$string['viewsummary'] = 'Zobraziť prehľad';
$string['workflowfilter'] = 'Filter postupu';
$string['xofy'] = '{$a->x} z {$a->y}';
