<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'scorm', language 'no', version '4.4'.
 *
 * @package     scorm
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activation'] = 'Aktivisering';
$string['activityloading'] = 'Du vil automatisk bli videresent til aktiviteten i';
$string['activityoverview'] = 'Du har SCORM-pakker som trenger gjennomgang';
$string['activitypleasewait'] = 'Aktiviteten laster, vær vennlig vent...';
$string['adminsettings'] = 'Admin-innstillinger';
$string['advanced'] = 'Parametre';
$string['aicchacpkeepsessiondata'] = 'AICC HACP sesjonsdata';
$string['aicchacpkeepsessiondata_desc'] = 'Varighet i dager  som sesjonsdataene fra AICC HACP skal beholdes. (En høy verdi vil fylle opp tabellen, men være til nytte ved debugging)';
$string['aicchacptimeout'] = 'AICC HACP utløpstid';
$string['aicchacptimeout_desc'] = 'Varighet i minutter hvor den den eksterne AICC HACP-sesjonen skal holdes åpen';
$string['aiccuserid'] = 'AICC oversendelse av numerisk brukerid';
$string['aiccuserid_desc'] = 'AICC-standarden for brukernavn er svært restriktiv i forhold til Moodle. Den tillater kun alfanumeriske, bindestrek (-) og understrek (_) i brukernavnet. Punktum, mellomrom og @ -symbolet er ikke tillatt. Når aktivert, vil brukerens ID-numre sendes til AICC-pakken i stedet for brukernavnet.';
$string['aliasonly'] = 'Når du velger en imsmanifest.xml-fil fra filområdet må du bruken en alias/snarvei for denne fila.';
$string['allowapidebug'] = 'Aktiver API debugging og sporing (sett capture mask til apidebugmask)';
$string['allowtypeaicchacp'] = 'Aktiver ekstern AICC HACP';
$string['allowtypeaicchacp_desc'] = 'Dersom aktivert vil det åpne for AICC HACP komminkasjonen uten ytterligere innlogging fra den eksterne AICC-pakken';
$string['allowtypeexternal'] = 'Tillat ekstern pakketype';
$string['allowtypeexternalaicc'] = 'Aktiver direkte AICC URL';
$string['allowtypeexternalaicc_desc'] = 'Hvis aktivert vil dette tillate en direkte URL til en AICC-pakke';
$string['allowtypelocalsync'] = 'Tillat nedlastet pakketype';
$string['apidebugmask'] = 'API debug capture mask - bruker en enkel regex på  &lt;username&gt;:&lt;activityname&gt; F.eks. admin:.* vil bare debugge for adminbrukere.';
$string['areacontent'] = 'Innholdsfiler';
$string['areapackage'] = 'Pakkefil';
$string['asset'] = 'Ressurs';
$string['assetlaunched'] = 'Ressurs - Sett';
$string['attempt'] = 'Forsøk';
$string['attempt1'] = '1 forsøk';
$string['attempts'] = 'Forsøk';
$string['attemptsmanagement'] = 'Administrere forsøk';
$string['attemptstatusall'] = 'Min start- og inngangsside';
$string['attemptstatusentry'] = 'Bare statusside';
$string['attemptstatusmy'] = 'Bare startside';
$string['attemptsx'] = '{$a} forsøk';
$string['attr_error'] = 'Gal verdi for attributt ({$a->attr}) i taggen {$a->tag}.';
$string['autocommit'] = 'Auto-commit';
$string['autocommit_help'] = 'Når aktivert så vil SCORM-data automatisk lagres i databasen. Dette er nyttig for SCORM-pakker som ikke lagrer data regelmessig.';
$string['autocommitdesc'] = 'Lagre SCORM-data automatisk hvis SCORM-pakken ikke lagrer det.';
$string['autocontinue'] = 'Fortsett automatisk';
$string['autocontinue_help'] = '<p>Dersom "Fortsett automatisk" er satt til "Ja", vil læringsobjektet lukke gjeldende kurspakke og automatisk starte den neste.</p>

<p>Dersom denne er satt til "Nei" må brukeren selv klikke på "Fortsett"-knappen for å gå videre.</p>';
$string['autocontinuedesc'] = 'Denne innstillingen bestemmer om aktiviteten skal fortsette automatisk. Ellers må brukeren klikke på Fortsett-knappen.';
$string['averageattempt'] = 'Gjennomsnittsforsøk';
$string['badarchive'] = 'Du må benytte en gyldig zip-fil';
$string['badimsmanifestlocation'] = 'En imsmanifest.xml-fil er funnet, men den var ikke i rotmappen i zip-pakken. Vennligst pakk SCORM-fila om igjen.';
$string['badmanifest'] = 'Noen manifest feil: se feillogg';
$string['browse'] = 'Forhåndsvis';
$string['browsed'] = 'Lest';
$string['browsemode'] = 'Forhåndsvisningsmodus';
$string['browserepository'] = 'Bla gjennom lagringssted';
$string['cachedef_elements'] = 'Elementbuffer';
$string['calculatedweight'] = 'Beregnet vekt';
$string['calendarend'] = '{$a} stenges';
$string['calendarstart'] = '{$a} åpnes';
$string['cannotaccess'] = 'Du kan ikke kalle dette skriptet på den måten';
$string['cannotfindsco'] = 'Kunne ikke finne SCO';
$string['chooseapacket'] = 'Velg eller oppdater en pakke';
$string['closebeforeopen'] = 'Du har oppgitt en sluttdato som er før startdatoen.';
$string['collapsetocwinsize'] = 'Skjul beskrivelsesfeltet nå vindusfeltet under økes.';
$string['collapsetocwinsizedesc'] = 'Denne innstillingen lar deg angi en vindusstørrelse for når beskrivelsesfeltet automatisk skal skjules.';
$string['compatibilitysettings'] = 'Kompatibilitetsinnstillinger';
$string['completed'] = 'Fullført';
$string['completiondetail:allscos'] = 'Gjør alle deler av denne aktiviteten';
$string['completiondetail:completionscore'] = 'Motta et resultat på {$a} eller mer';
$string['completiondetail:completionstatuscompleted'] = 'Fullfør aktiviteten';
$string['completiondetail:completionstatuscompletedorpassed'] = 'Fullfør og bestå aktiviteten';
$string['completiondetail:completionstatuspassed'] = 'Bestå aktiviteten';
$string['completionscorerequired'] = 'Krev minimumsresultat';
$string['completionscorerequired_help'] = 'Aktivering av denne innstillingen vil kreve et minimumsresultat før SCORM-aktiviteten blir registrert som fullført. Dette kommer i tillegg til andre fullføringskrav som kan settes.';
$string['completionscorerequireddesc'] = 'En minimumscore på {$a} kreves for fullføring';
$string['completionstatus_completed'] = 'Fullført';
$string['completionstatus_passed'] = 'Godkjent';
$string['completionstatusallscos'] = 'Krev at alle SCO´s sender fullførtstatus';
$string['completionstatusallscos_help'] = 'Noen SCORM-pakker inneholder flere komponenter eller "sco\'er". Når denne innstillingen aktiveres må alle sco\'ene i pakka returnere den relevante lesson_status for at aktiviteten skal merkes som fullført.';
$string['completionstatusrequired'] = 'Krev status';
$string['completionstatusrequired_help'] = 'Når du merker av for en eller flere statuser vil det kreve at brukeren oppfyller minst enn av de avmerkede statuskravene for at SCORM-aktiviteten skal registreres som fullført. Dette kommer i tillegg tl andre fullføringskrav som kan settes.';
$string['completionstatusrequireddesc'] = 'Deltakeren må oppnå minst en av følgende statuser: {$a}';
$string['confirmloosetracks'] = 'ADVARSEL: Pakken ser ut til å være endret eller modifisert. Hvis pakkestrukturen er endret, kan noen brukerspor ha blitt borte under oppdateringsprosessen.';
$string['contents'] = 'Innhold';
$string['coursepacket'] = 'Kurspakke';
$string['coursestruct'] = 'Innholdsstruktur';
$string['crontask'] = 'Bakgrunnsprossessering for SCORM.';
$string['currentwindow'] = 'Gjeldende vindu';
$string['datadir'] = 'Filsystemfeil: Kan ikke opprette kursets filområde';
$string['defaultdisplaysettings'] = 'Standard visningsinnstillinger';
$string['defaultgradesettings'] = 'Standard resultatinnstillinger';
$string['defaultothersettings'] = 'Andre standardinnstillinger';
$string['deleteallattempts'] = 'Slett alle SCORM-forsøk';
$string['deleteattemptcheck'] = 'Er du helt sikker på at du vil slette fullstendig alle disse forsøkene?';
$string['deleteselected'] = 'Slett valgte forsøk';
$string['deleteuserattemptcheck'] = 'Er du helt sikker på at du vil slette alle dine forsøk?';
$string['details'] = 'Spor detaljer';
$string['directories'] = 'Vis mappelenkene';
$string['disabled'] = 'Deaktivert';
$string['display'] = 'Vis pakke';
$string['displayattemptstatus'] = 'Vis forsøksstatus';
$string['displayattemptstatus_help'] = 'Denne innstillingen er for å vise et sammendrag av brukerforsøkene i kursets oversiktsblokk på Dashbord og/eller på SCORM-aktivitetens startside.';
$string['displayattemptstatusdesc'] = 'Hvorvidt et sammendrag av brukerens forsøk skal vises i kursoversiktsblokken på Dashbord og/eller på SCORM-pakkens startside.';
$string['displaycoursestructure'] = 'Vis innholdsstrukturen på startsiden';
$string['displaycoursestructure_help'] = 'Dersom aktivert blir innholdsfortegnelsen vist på SCORM-pakkens oversiktsside.';
$string['displaycoursestructuredesc'] = 'Når aktivert vil kursets struktur vises på SCORM-pakkens startside.';
$string['displaydesc'] = 'Denne innstillingen bestemmer om SCORM-pakken skal vises i et nytt vindu.';
$string['displaysettings'] = 'Visningsinnstillinger';
$string['dnduploadscorm'] = 'Legg til en SCORM-pakke';
$string['domxml'] = 'DOMXML eksternt bibliotek';
$string['element'] = 'Element';
$string['enter'] = 'Start';
$string['entercourse'] = 'Start kurs';
$string['errorlogs'] = 'Feil-logg';
$string['eventattemptdeleted'] = 'Forsøk slettet';
$string['eventinteractionsviewed'] = 'Interaksjoner vist';
$string['eventreportviewed'] = 'Rapport vist';
$string['eventscolaunched'] = 'Sco lansert';
$string['eventscorerawsubmitted'] = 'Rapportert SCORM-rådata';
$string['eventstatussubmitted'] = 'Rapportert SCORM-status';
$string['eventtracksviewed'] = 'Sporinger vist';
$string['eventuserreportviewed'] = 'Brukerrapport sett';
$string['everyday'] = 'Hver dag';
$string['everytime'] = 'Hver gang den brukes';
$string['exceededmaxattempts'] = 'Du har nådd maksimalt antall forsøk.';
$string['exit'] = 'Gå ut av kurset';
$string['exitactivity'] = 'Gå ut av aktiviteten';
$string['expired'] = 'Beklager, aktiviteten ble stengt {$a} og er ikke lenger tilgjengelig.';
$string['external'] = 'Oppdater eksterne pakkers timing';
$string['failed'] = 'Feilet';
$string['finishscorm'] = 'Dersom du får opp denne siden uten å ha åpnet SCORM-pakken, skyldes det vanligvis at nettleseren din har blokkert pop-up vinduer. <br />
Dersom du er ferdig med denne ressursen, {$a}';
$string['finishscormlinkname'] = 'klikk her for å gå tilbake til kurssiden';
$string['firstaccess'] = 'Etter første visning';
$string['firstattempt'] = 'Første forsøk';
$string['floating'] = 'Flytende';
$string['forceattemptalways'] = 'Alltid';
$string['forceattemptoncomplete'] = 'Når tidligere forsøk er fullført, bestått eller ikke bestått';
$string['forcecompleted'] = 'Tving fullføring';
$string['forcecompleted_help'] = 'Dersom aktivert, vil status for gjeldende forsøk bli satt som "completed". Denne innstillingen er bare tilgjengelig i SCORM 1.2-pakker.  Innstillingen er nyttig dersom SCORM-pakken har en feil som gjør at den ikke sender fullførtstatus på riktig måte.';
$string['forcecompleteddesc'] = 'Denne preferansen angir standard verdi for innstillingen "Tving fullføring"';
$string['forcejavascript'] = 'Tving brukere til å aktivere Javascript';
$string['forcejavascript_desc'] = 'Hvis aktivert (anbefales) vil dette forhindre tilgang til SCORM-objekter når Javascript-støtten er deaktivert i brukerens nettleser. Hvis deaktivert vil brukeren kunne se SCORM-aktiviteten, men API-kommunikasjonen vil ikke fungere og ingen resultater lagres.';
$string['forcejavascriptmessage'] = 'Javascript kreves for å se dette objektet, vennligst aktiver Javascript i nettleseren din og forsøk en gang til.';
$string['forcenewattempts'] = 'Tving nytt forsøk';
$string['forcenewattempts_help'] = 'Det er 3 valg:

* Nei - Dersom ingen tidligere forsøk er fullført, godkjent eller feilet vil studenten få valget mellom å åpne i se-over modus eller starte et nytt forsøk.
* Dersom tidligere forsøk er fullført, godkjent eller feilet - Dette krever at SCORM-pakken har satt statusen til \'Fullført\', \'Godkjent\' eller \'feilet\'.
* Alltid - Hver gang studenten åpner SCORM-pakken vil det registreres som et nytt forsøk og studenten vil ikke kunne fortsette der de avsluttet forrige forsøk.';
$string['found'] = 'Liste funnet';
$string['frameheight'] = 'Denne innstillingen setter standard høyde for hovedramme eller vindu';
$string['framewidth'] = 'Denne innstillingen setter standard bredde for hovedramme eller vindu';
$string['fromleft'] = 'Fra venstre';
$string['fromtop'] = 'Fra toppen';
$string['fullscreen'] = 'Fyll hele skjermen';
$string['general'] = 'Generelle data';
$string['gradeaverage'] = 'Gjennomsnittlig karakter';
$string['gradeforattempt'] = 'Resultat';
$string['gradehighest'] = 'Beste forsøk';
$string['grademethod'] = 'Vurderingsmetode';
$string['grademethod_help'] = 'Karaktermetoden definerer hvordan karakteren for et enkelt forsøk på aktiviteten bestemmes.

Det er fire graderingsmetoder:

* Læringsobjekter - Antall fullførte / beståte læringsobjekter
* Høyeste karakter - Den høyeste poengsummen oppnådd i alle beståte læringsobjekter
* Gjennomsnittlig karakter - Gjennomsnittet av alle poengene
* Sumkarakter - Summen av alle poengene';
$string['grademethoddesc'] = 'Denne innstillingen setter standard karaktersetting for aktiviteten.';
$string['gradereported'] = 'Lagret resultat';
$string['gradescoes'] = 'Læringsobjekter';
$string['gradesettings'] = 'Resultatinnstillinger';
$string['gradesum'] = 'Sum karakter';
$string['height'] = 'Høyde';
$string['hidden'] = 'Skjult';
$string['hidebrowse'] = 'Slå av forhåndsvisning';
$string['hidebrowse_help'] = 'Forhåndsvisningsmodus lar en bruker se over leksjonen før den tas. Dersom forhåndsvisning er deaktivert skjules denne knappen.';
$string['hidebrowsedesc'] = 'Denne innstillingen bestemmer om en skal slå av/på forhåndsvisning.';
$string['hideexit'] = 'Skjul Avsluttknappen';
$string['hidereview'] = 'Skjul Se gjennom-knappen';
$string['hidetoc'] = 'Vise innholdsstruktur';
$string['hidetoc_help'] = 'Denne innstillingen angir om innholdsoversikten skal vises før kurset åpnes.';
$string['hidetocdesc'] = 'Denne innstillingen bestemmer om en skal  vise innholdsfortegnelse eller ikke.';
$string['highestattempt'] = 'Beste forsøk';
$string['identifier'] = 'Spøsmålsidentifikator';
$string['incomplete'] = 'Ufullstendig';
$string['indicator:cognitivedepth'] = 'Kognitiv SCORM';
$string['indicator:cognitivedepth_help'] = 'Denne indikatoren er basert på den kognintive dybden vist av studenten i en SCORM-aktivitet.';
$string['indicator:cognitivedepthdef'] = 'SCORM - kognitivt engasjement';
$string['indicator:cognitivedepthdef_help'] = 'Deltakeren har nådd denne prosentandelen av det kognitive engasjementet som tilbys av SCORM-aktivitetene i løpet av dette analyseintervallet (Nivåer = Ingen visning, Vis, Send inn, Se tilbakemelding)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Sosial SCORM';
$string['indicator:socialbreadth_help'] = 'Denne indikatoren er basert på den sosiale bredden vist av studenten i en SCORM-aktivitet.';
$string['indicator:socialbreadthdef'] = 'SCORM - Sosialt engasjement';
$string['indicator:socialbreadthdef_help'] = 'Deltakeren har nådd denne prosentandelen av det sosiale engasjementet som tilbys av SCORM-aktivitetene i løpet av dette analyseintervallet (Nivåer = Ingen deltakelse, deltaker alene)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['interactions'] = 'Samhandlinger';
$string['invalidactivity'] = 'SCORM-aktiviteten har feil';
$string['invalidhacpsession'] = 'Ugyldig HACP-sesjon';
$string['invalidmanifestname'] = 'Du kan bare velge imsmanifest.xml eller .zip-filer.';
$string['invalidmanifestresource'] = 'ADVARSEL: Følgende ressurser er referert i manifestet, men kunne ikke finnes:';
$string['invalidstatus'] = 'Ugyldig status';
$string['invalidurl'] = 'Ugyldig URL angitt';
$string['invalidurlhttpcheck'] = 'Ugyldig URL angitt. Debug melding: <pre>{$a->cmsg}</pre>';
$string['largetrackupgrade'] = 'Dette neste oppgraderingstrinnet kan ta litt tid å fullføre, portalen ditt har {$a} SCORM-sporposter som må migreres til den nye tabellstrukturen. Vær tålmodig, siden en fremdriftslinje ikke kan vises.';
$string['last'] = 'Sist brukt';
$string['lastaccess'] = 'Siste bruk';
$string['lastattempt'] = 'Siste fullførte forsøk';
$string['lastattemptlock'] = 'Lås etter siste forsøk';
$string['lastattemptlock_help'] = 'Dersom aktivert vil studenten bli nektet å åpne SCORM-pakken etter å ha brukt opp alle sine forsøk.';
$string['lastattemptlockdesc'] = 'Hvis denne innstillingen aktiveres vil brukeren ikke kunne starte SCORM-pakken når alle tillatte forsøk er oppbrukt.';
$string['location'] = 'Vis på navigeringslinjen';
$string['masteryoverride'] = 'Status for overstyring av godkjentgrense';
$string['masteryoverride_help'] = 'Hvis aktivert og det er satt en godkjentgrense vil denne godkjentgrensen brukes i stedet for godkjentgrensen satt i SCORM-pakken. Dette krever at SCORM-pakken sender en rådatapoengsum, og det er på bakgrunn av denne grensen at statusen blir satt.';
$string['masteryoverridedesc'] = 'Denne innstillingen setter standardvalget for oversstyring av godkjentgrensen.';
$string['max'] = 'Maks poengsum';
$string['maximumattempts'] = 'Antall forsøk';
$string['maximumattempts_help'] = '<p>Dette bestemmer hvor mange forsøk en bruker har.<br />Dette fungerer BARE med SCORM 1.2 og AICC-pakker. SCORM2004 har sin egen innstilling for maks antall forsøk.</p>';
$string['maximumattemptsdesc'] = 'Denne innstillingen setter maks antall forsøk på en aktivitet';
$string['maximumgradedesc'] = 'Denne innstillinge setter maksimal karakter for en aktivitet';
$string['menubar'] = 'Vis på menylinjen';
$string['min'] = 'Minimumskarakter';
$string['minimumscoregreater'] = 'Minimumsscore må være større enn 0';
$string['missing_attribute'] = 'Manglende attributt {$a->attr} i tag {$a->tag}';
$string['missing_tag'] = 'Manglende tag {$a->tag}';
$string['missingparam'] = 'En nødvendig parameter mangler eller er feil';
$string['mode'] = 'Modus';
$string['modulename'] = 'SCORM-pakke';
$string['modulename_help'] = 'En SCORM-pakke er en samling filer som er pakket i tråd med en felles standard for læringsobjekter. SCORM-aktiviteten tillater at både SCORM- og AICC-pakker kan lastes opp som zip-filer og legges til kurs.

Innholdet blir vanligvis vist over flere sider og med intern navigasjon mellom sidene. Det er mange valg for visning av innhold i popup-vindu, med innholdsfortegnelse, med navigasjonsknapper osv. SCORM-aktiviteter har som regel spørsmål, der resultatet fra disse spørsmålene kan lagres i karakterboka.

SCORM-aktiviteter kan brukes

* Til å presentere multimedia-innhold og animasjoner
* Som et vurderingsverktøy';
$string['modulename_link'] = 'mod/scorm/view';
$string['modulenameplural'] = 'SCORM/AICC-pakker';
$string['myaiccsessions'] = 'Mine AICC-sesjoner';
$string['myattempts'] = 'Mine forsøk';
$string['nav'] = 'Vis navigasjon';
$string['nav_help'] = 'Denne instillingen bestemmer om man skal vise eller skjule navigasjonsknapper og deres posisjoner.

Det er 3 valg:

* Skjul - Ikke vis navigasjonsknappene
* Under innhold - Vis navigasjonsknappene under SCORM-pakkens innhold
* Flytende - Tillat å manuelt spesifisere navigasjonsknappenes posisjon fra venstre og fra toppen av vinduet.';
$string['navdesc'] = 'Denne instillingen bestemmer om man skal vise eller skjule navigasjonsknapper og deres posisjoner.';
$string['navigation'] = 'Navigering';
$string['navpositionleft'] = 'Navigasjonsknappenes posisjon fra venstre i piksler.';
$string['navpositiontop'] = 'Posisjon for navigasjonsknapper - i pixler fra toppen av siden.';
$string['networkdropped'] = '<p>OBS! Forbindelsen til kurset er brutt og fremgangen din lagres ikke. Bruddet kan skyldes at du tar tatt en lengere pause eller at din internettforbindelse er ustabil. </p>
<p>LUKK KURSET OG ÅPNE DET PÅ NYTT FØR DU FORTSETTER.</p>';
$string['newattempt'] = 'Begynn et nytt forsøk';
$string['next'] = 'Fortsett';
$string['no_attributes'] = 'Taggen {$a->tag} må ha egenskaper/attributter';
$string['no_children'] = 'Taggen {$a->tag} må ha barn/undertagger';
$string['noactivity'] = 'Ingenting å rapportere';
$string['noattemptsallowed'] = 'Maksimum antall forsøk';
$string['noattemptsmade'] = 'Antall forsøk du har gjort til nå';
$string['nolimit'] = 'Ubegrensede forsøk';
$string['nomanifest'] = 'Ugyldig pakkefil - mangler imsmanifest.xml eller AICC-struktur.';
$string['noprerequisites'] = 'Beklager men du har ikke gjennomgått nok til å ha tilgang til aktiviteten.';
$string['noreports'] = 'Ingen rapport å vise';
$string['normal'] = 'Normal';
$string['noscriptnoscorm'] = 'Nettleseren din støtter ikke javascript eller har ikke aktivert javastøtte. Ingen spor vil bli lagret.';
$string['not_corr_type'] = 'Typen er feil for {$a->tag}';
$string['notattempted'] = 'Ikke forsøkt';
$string['notopenyet'] = 'Beklager, denne aktiviteten er ikke tilgjengelig før {$a}';
$string['objectives'] = 'Mål';
$string['openafterclose'] = 'Startdatoen er eller avslutningsdatoen.';
$string['optallstudents'] = 'alle brukere';
$string['optattemptsonly'] = 'bare brukere som har forsøkt';
$string['options'] = 'Valg (Forhindres av noen nettlesere)';
$string['optionsadv'] = 'Avanserte valg';
$string['optionsadv_desc'] = 'Hvis avmerket vil vindusvalgene bli angitt som avanserte valg.';
$string['optnoattemptsonly'] = 'bare brukere som ikke har forsøkt';
$string['organization'] = 'Organisasjon';
$string['organizations'] = 'Organisasjoner';
$string['othersettings'] = 'Andre innstillinger';
$string['package'] = 'Pakkefil';
$string['package_help'] = '<p>En kurspakke er en bestemt fil med filendelsen <b>zip</b> som inneholder et gyldig AICC eller SCORM-kurs med definisjonsfiler.</p>

<p>En <b>SCORM</b> pakke har en mengde filer i en mappestruktur. På rotnivå finnes alltid en fil kalt <b>imsmanifest.xml</b> som angir SCORM strukturen på materialet, hvor ressurser er lagret og mange andre ting.</p>

<p>En <b>AICC</b> pakke defineres i flere filer (fra 4 til 7). Filene har disse endelsene, som betyr:</p>
   <ul>
    <li>CRS - Course Description file (påkrevd)</li>
    <li>AU  - Assignable Unit file (påkrevd)</li>
    <li>DES - Descriptor file (påkrevd)</li>
    <li>CST - Course Structure file (påkrevd)</li>
    <li>ORE - Objective Relationship file (valgfri)</li>
    <li>PRE - Prerequisites file (valgfri)</li>
    <li>CMP - Completition Requirements file (valgfri)</li>
   </ul>';
$string['packagedir'] = 'Filsystemfeil: Kan ikke lage pakkemappe';
$string['packagefile'] = 'Ingen pakke spesifisert';
$string['packagehdr'] = 'Pakke';
$string['packageurl'] = 'URL';
$string['packageurl_help'] = 'Denne innstillingen tillater at det angis en URL til  SCORM-pakken - i stedet for at den velges i filvelgeren.';
$string['page-mod-scorm-x'] = 'En SCORM modulside';
$string['pagesize'] = 'Sidestørrelse';
$string['passed'] = 'Bestått';
$string['php5'] = 'PHP 5 (DOMXML native library)';
$string['pluginadministration'] = 'SCORM pakkeadministrasjon';
$string['pluginname'] = 'SCORM-pakke';
$string['popup'] = 'Nytt vindu';
$string['popuplaunched'] = 'Denne SCORM-pakken har blitt lastet i et popup-vindu. Hvis du er ferdig med å se på denne ressursen kan du klikke her for å gå tilbake til kurssiden.';
$string['popupmenu'] = 'I en nedtrekksmeny';
$string['popupopen'] = 'Åpne pakken i nytt vindu';
$string['popupsblocked'] = 'Det virker som om popup-vinduet blir blokkert - og det forhindrer visning av denne SCORM-pakken. Vennligst sjekk nettleserinnstillingene og prøv igjen.';
$string['position_error'] = '{$a->tag} taggen kan ikke være en undertag av {$a->parent} taggen';
$string['preferencespage'] = 'Preferanser kun for denne siden';
$string['preferencesuser'] = 'Preferanser for denne rapporten';
$string['prev'] = 'Forrige';
$string['privacy:metadata:aicc:data'] = 'Persondata sendt gjennom undersystemet AICC/SCORM.';
$string['privacy:metadata:aicc:externalpurpose'] = 'Denne modulen bruker AICC HACP for å sende data eksternt.';
$string['privacy:metadata:aicc_session:lessonstatus'] = 'Leksjonsstatusen som skal spores';
$string['privacy:metadata:aicc_session:scormmode'] = 'Modusen til elementet som skal spores';
$string['privacy:metadata:aicc_session:scormstatus'] = 'Statusen på elementet som skal spores';
$string['privacy:metadata:aicc_session:sessiontime'] = 'Sesjonstiden som skal spores';
$string['privacy:metadata:aicc_session:timecreated'] = 'Når det sporede elementet ble opprettet';
$string['privacy:metadata:attempt'] = 'Forsøk nummer';
$string['privacy:metadata:scoes_track:element'] = 'Navnet på elementet som skal spores';
$string['privacy:metadata:scoes_track:value'] = 'Verdien på det gitte elementet';
$string['privacy:metadata:scorm_aicc_session'] = 'Sesjonsinformasjonen';
$string['privacy:metadata:scorm_attempt'] = 'SCORM-forsøkene gjort av en bruker';
$string['privacy:metadata:timemodified'] = 'Tidspunktet det sporede elem';
$string['privacy:metadata:userid'] = 'IDen til brukeren som åpnet SCORM aktiviteten';
$string['protectpackagedownloads'] = 'Beskytt pakkenedlastinger';
$string['protectpackagedownloads_desc'] = 'Hvis aktivert kan SCORM-pakker bare lastes ned hvis brukeren tillatelsen course:manageactivities. Hvis deaktivert kan SCORM-pakker alltids lastes ned.';
$string['raw'] = 'Råpoengsum';
$string['regular'] = 'Standard manisfest';
$string['report'] = 'Rapport';
$string['reportcountallattempts'] = '{$a->nbattempts} forsøk for {$a->nbusers} brukere, av {$a->nbresults} resultater';
$string['reportcountattempts'] = '{$a->nbresults} resultater ({$a->nbusers} brukere)';
$string['reports'] = 'Rapporter';
$string['repositorynotsupported'] = 'Denne mappen støtter ikke direkte lenking til en lmsmanifest.xml-fil';
$string['response'] = 'Respons';
$string['result'] = 'Resultat';
$string['results'] = 'Resultater';
$string['review'] = 'Se over';
$string['reviewmode'] = 'Repetisjonsvisning';
$string['rightanswer'] = 'Riktig svar';
$string['scoes'] = 'Læringsobjekter';
$string['score'] = 'Poengsum';
$string['scorm:addinstance'] = 'Legg til en ny SCORM-pakke';
$string['scorm:deleteownresponses'] = 'Slett egne forsøk';
$string['scorm:deleteresponses'] = 'Slett SCORM-forsøk';
$string['scorm:savetrack'] = 'Lagre spor';
$string['scorm:skipview'] = 'Hopp over oversikt';
$string['scorm:viewreport'] = 'Se rapporter';
$string['scorm:viewscores'] = 'Se resultater';
$string['scormclose'] = 'Tilgjengelig inntil';
$string['scormcourse'] = 'Læringskurs';
$string['scormloggingoff'] = 'API logging er AV';
$string['scormloggingon'] = 'API logging er PÅ';
$string['scormopen'] = 'Tilgjengelig fra';
$string['scormresponsedeleted'] = 'Slettede brukerforsøk';
$string['scormstandard'] = 'SCORM standardmodus';
$string['scormstandarddesc'] = 'Når aktivert vil Moodle tillate at SCORM 1.2-pakker lagrer mer enn spesifikasjonene tillater og at Moodle vil bruke fullt navneformatinnstillinger når navnene overføres til SCORM-pakken.';
$string['scormtype'] = 'Type';
$string['scormtype_help'] = 'Denne innstillingen bestemmer hvordan pakken skal hentes inn i kurset. Det finnes inntil fire muligheter:

* Opplastet pakke - Tillater at en SCORM-pakke velges via filvelgeren.
* Eksternt SCORM manifest - Tillater at det oppgis en url til en fil:  imsmanifest.xml. Merk at dersom URL-en har et annet domenenavn enn din portal, er "Nedlastet pakke" et bedre alternativ, siden du risikerer at karakterer ikke lagres.
* Nedlastet pakke - Tillater at det angis en URL til en pakkefil. Pakken blir pakket opp og lagret lokalt og siden oppdatert hver gang den eksterne SCORM-pakken oppdateres.
* Lokalt IMS-innholdsfilområde - TIllater en pakke å bli valgt fra et IMS-filområde
* Ekstern AICC URL -  denne URL-en er startlenken for en enkelt AICC-aktivitet. Det lages da en pseudopakke rundt dette.';
$string['scrollbars'] = 'Tillat å bla i vinduet (scrolling)';
$string['search:activity'] = 'SCORM-pakke - aktivitetsinformasjon';
$string['selectall'] = 'Velg alle';
$string['selectnone'] = 'Angre velg alle';
$string['show'] = 'Vis';
$string['sided'] = 'På siden';
$string['skipview'] = 'Skjul innholdsoversikten';
$string['skipview_help'] = '<p>Hvis du legger til en pakke med bare ett læringsobjekt, kan du velge å hoppe over siden med innholdsstrukturen når brukere starter SCORM-aktiviteten fra kurssiden.</p>

<p>Du kan velge mellom å:</p>

   <ul>
       <li><strong>Aldri</strong> hoppe over innholdsstruktursiden</li>
       <li><strong>Første forsøk</strong> hoppe over innholdstruktursiden bare første gangen.</li>
       <li><strong>Alltid</strong> hopp bestandig over innholdsstruktursiden</li>
   </ul>';
$string['skipviewdesc'] = 'Denne innstillingen bestemmer om en ikke skal bruke pakkens innholdsstruktur';
$string['slashargs'] = 'ADVARSEL: Brytere (eks. /A) er slått av på denne portalen og det kan hende at enkelte ting ikke virker som det var tenkt!';
$string['stagesize'] = 'Vindusstørrelse';
$string['stagesize_help'] = '<p>Disse to innstillingene angir høyde og bredde på vinduet læringsobjektet vises i.</p>';
$string['started'] = 'Startet';
$string['status'] = 'Status';
$string['statusbar'] = 'Vis statuslinjen';
$string['student_response'] = 'Svar';
$string['subplugintype_scormreport'] = 'Rapport';
$string['subplugintype_scormreport_plural'] = 'Rapporter';
$string['suspended'] = 'Avbrutt';
$string['syntax'] = 'Syntaksfeil';
$string['tag_error'] = 'Ukjent tag ({$a->tag}) med innhold: {$a->value}';
$string['time'] = 'Tid';
$string['title'] = 'Tittel';
$string['toc'] = 'TOC';
$string['too_many_attributes'] = 'Taggen {$a->tag} har for mange egenskaper';
$string['too_many_children'] = 'Taggen {$a->tag} har for mange underverdier';
$string['toolbar'] = 'Vis verktøylinjen';
$string['totaltime'] = 'Tid';
$string['trackcorrectcount'] = 'Korrekt antall';
$string['trackcorrectcount_help'] = 'Antall korrekte svar på spørsmålet';
$string['trackid'] = 'ID';
$string['trackid_help'] = 'Dette er den identifikatoren som angis av SCORM-pakke for dette spørsmålet. SCORM-spesifikasjonen tillater ikke at full spørsmålstekst tas med.';
$string['trackingloose'] = 'ADVARSEL: Sporingsdata for denne pakken vil bli slettet!';
$string['tracklatency'] = 'Forsinkelse';
$string['tracklatency_help'] = 'Tiden som har gått mellom tiden interaksjonen<br /> ble tilgjengelig for brukeren<br /> og tiden for første respons.';
$string['trackpattern'] = 'Mønster';
$string['trackpattern_help'] = 'Dette er hva korrekt tilbakemelding på dette spørsmålet burde være, den viser ikke studentens tilbakemelding.';
$string['trackresponse'] = 'Respons';
$string['trackresponse_help'] = 'Dette er tilbakemeldingen fra studenten på dette spørsmålet';
$string['trackresult'] = 'Resultat';
$string['trackresult_help'] = 'Basert på studenters respons og <br /> korrekt resultat';
$string['trackscoremax'] = 'Høyeste resultat';
$string['trackscoremax_help'] = 'Maksverdi i skalaen for råskår';
$string['trackscoremin'] = 'Laveste resultat';
$string['trackscoremin_help'] = 'Minimumsverdi i skalaen for råskår';
$string['trackscoreraw'] = 'Råskår';
$string['trackscoreraw_help'] = 'Tall som reflekterer brukeren resultat<br /> relativt til skalen avgrenset av verdiene minimum og maksimum';
$string['tracksuspenddata'] = 'Suspendere data';
$string['tracksuspenddata_help'] = 'Gir plass for å lagre og hente data<br /> mellom brukerforsøkene.';
$string['tracktime'] = 'Tid';
$string['tracktime_help'] = 'Tidspunktet for når forsøket startet';
$string['tracktype'] = 'Type';
$string['tracktype_help'] = 'Spørsmålstype, f.eks. "flervalg" eller "kortsvar"';
$string['trackweight'] = 'Vekting';
$string['trackweight_help'] = 'Vekting av elementet';
$string['type'] = 'Type';
$string['typeaiccurl'] = 'Ekstern AICC URL';
$string['typeexternal'] = 'Eksternt SCORM manifest';
$string['typelocal'] = 'Opplasted pakke';
$string['typelocalsync'] = 'Nedlastet pakke';
$string['undercontent'] = 'Under innholdet';
$string['unziperror'] = 'Det oppstår en feil under utpakking av zip-fila';
$string['updatefreq'] = 'Intervall for automatisk oppdatering';
$string['updatefreq_error'] = 'Frekvens for autooppdatering kan bare angis når pakkefila hostes eksternt.';
$string['updatefreq_help'] = 'Dette tilater at en ekstern pakke automatisk lastes ned og oppdateres';
$string['updatefreqdesc'] = 'Denne innstillingen setter standardverdi for hvor ofte aktiviteten skal auto-oppdatere seg.';
$string['validateascorm'] = 'Valider en pakke';
$string['validation'] = 'Valider resultat';
$string['validationtype'] = 'Dette valget angir DOMXML biblioteket som brukes for å godkjenne SCORM Manifest. Hvis du ikke vet la det angitte valget stå.';
$string['value'] = 'Verdi';
$string['versionwarning'] = 'Manifestversjonen er eldre enn 1.3, advarsel om {$a->tag} taggen';
$string['viewallreports'] = 'Se på rapporter for {$a} forsøk';
$string['viewalluserreports'] = 'Vis rapportene for {$a} brukere';
$string['whatgrade'] = 'Karaktersetting av forsøk';
$string['whatgrade_help'] = 'Hvis mange forsøk er tillatt, kan du angi i denne innstillingen hvorvidt det er beste forsøk, gjennomsnitt, første eller siste fullførte forsøk som skal lagres i karakterboka. Alternativet "siste fullførte forsøk" gjelder ikke forsøk som har statusen "mislykket".

Håndtering av flere forsøk

* Muligheten til å starte et nytt forsøk styres av en avkrysningsboks over Start-knappen på innholdssiden - så sjekk at alle ser denne siden dersom du vil tillate mer enn ett forsøk.
* Noen SCORM-pakker har intelligent håndtering av nye forsøk, mange ikke. Det betyr at dersom brukeren fortsetter på et påbegynt forsøk ved en senere anledning og SCORM-pakken ikke har noen intern logikk for å unngå overskriving av tidligere forsøk, kan de tidligere forsøkene overskrives selv om forsøkene var fullført eller bestått.
* Innstillingen "Tving fullføring", "Tving nytt forsøk" og "Lås etter siste forsøk" kan også brukes til å administrere gjentatte forsøk.';
$string['whatgradedesc'] = 'Hvorvidt høyeste, gjennomsnitt, første eller siste fullførte forsøk skal lagres i karakterboka når en tillater flere forsøk.';
$string['width'] = 'Bredde';
$string['window'] = 'Vindu';
$string['youmustselectastatus'] = 'Du må velge en påkrevd status';
