<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'readaloud', language 'no', version '4.4'.
 *
 * @package     readaloud
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accadjust'] = 'Fast justering';
$string['accadjust_details'] = 'Dette er antallet lesefeil som skal kompensere for WPM-poeng. Hvis WPM-justering er satt til "Fast", vil denne verdien bli brukt til å kompensere for WPM-poeng. Dette er en metode for å redusere maskintranskripsjonsfeil.';
$string['accadjust_help'] = 'Denne raten bør samsvare så nært som mulig med den estimerte gjennomsnittlige maskintranskripsjonsfeilen for en tekst.';
$string['accadjustmethod'] = 'WPM justering (AI)';
$string['accadjustmethod_details'] = 'Juster WPM-poenget ved å ignorere eller redusere noen lese feil funnet av AI. Standardinnstillingen \'Ingen justering\' trekker fra alle lese feil fra det endelige WPM-poenget';
$string['accadjustmethod_help'] = 'For WPM-justering kan vi: aldri justere, justere med et fast beløp, eller ignorere feil når vi beregner WPM';
$string['accmethod_auto'] = 'Autojustering';
$string['accmethod_fixed'] = 'Juster med fast verdi';
$string['accmethod_noerrors'] = 'Ignorer alle feil';
$string['accmethod_none'] = 'Ingen justering';
$string['accuracy'] = 'Nøyaktighet';
$string['accuracy_p'] = 'Nøyaktighet(%)';
$string['actions'] = 'Handlinger';
$string['activitydate:submissionsdue'] = 'Innen:';
$string['activitydate:submissionsopen'] = 'Åpner:';
$string['activitydate:submissionsopened'] = 'Åpnet:';
$string['activityisclosed'] = 'Aktiviteten er stengt.';
$string['activityisnotopenyet'] = 'Aktiviteten er ikke åpnet.';
$string['activitylink'] = 'Lenke til neste aktivitet';
$string['activitylink_help'] = 'For å legge til en lenke etter forsøket til en annen aktivitet i kurset, velg aktiviteten fra nedtrekkslisten.';
$string['activitylinkname'] = 'Forsett til neste aktivitet:  {$a}';
$string['activityname'] = 'RA. Navn,';
$string['activityopenscloses'] = 'Aktivitet åpner/stenger datoer';
$string['activitywords'] = 'Antall ord i teksten';
$string['addingitem'] = 'Legger til et nytt spørsmål';
$string['addnewitem'] = 'Legg til et nytt spørsmål';
$string['addpassage'] = 'Oppsett aktivitet';
$string['addtextpromptshortitem'] = 'Legg til element';
$string['adjustedaccuracy_p'] = 'Justert nøyaktighet (%)';
$string['adjustedgrade_p'] = 'Juster karakter(%)';
$string['adjustedwpm'] = 'Juster ord pr. minutt';
$string['admintabinstructions'] = 'På denne siden kan du redigere alternativene for teksten mens du ser en oppsummering av feiltolkningene. Når du lagrer, vil alle forsøk bli evaluert på nytt og de justerte karakterene vil bli lagt til karakterboken.';
$string['advancedheader'] = 'Avansert';
$string['aigradenow'] = 'AI karakter';
$string['aitextutilshide'] = 'Skjul AI Tekstverktøy (Beta)';
$string['aitextutilsshow'] = 'Vis AI Tekstverktøy (Beta)';
$string['allowearlyexit'] = 'Kan avslutte tidlig';
$string['allowearlyexit_defaultdetails'] = 'Angir standardinnstillingen for tillat_tidlig_avslutning. Kan overstyres på aktivitetsnivå. Hvis sant, betyr tillat_tidlig_avslutning at studenter kan fullføre før tidsfristen ved å trykke på en fullfør-knapp. WPM beregnes ved å bruke deres opptakstid.';
$string['allowearlyexit_details'] = 'Hvis krysset, kan studenter fullføre før tidsfristen ved å trykke på en fullfør-knapp. WPM beregnes ved å bruke deres opptakstid.';
$string['alternatives'] = 'Alternativer';
$string['alternatives_descr'] = 'Angi samsvarsalternativer for spesifikke ord i teksten. 1 ordsett per linje. f.eks. their|there|they\'re Se <a href="https://support.poodll.com/support/solutions/articles/19000096937-tuning-your-read-aloud-activity">dokumentasjon</a> for mer informasjon.';
$string['alternatives_help'] = 'Angi samsvarsalternativer for spesifikke ord i teksten. 1 ordsett per linje. f.eks. their|there|they\'re Se <a href="https://support.poodll.com/support/solutions/articles/19000096937-tuning-your-read-aloud-activity">dokumentasjon</a> for mer informasjon.';
$string['answer'] = 'Svar';
$string['apply_activity'] = 'denne aktiviteten';
$string['apply_course'] = 'disse kursaktivitetene';
$string['apply_site'] = 'dette nettstedets aktiviteter';
$string['applysettingsrange'] = 'Bruk innstilling på:';
$string['appnotauthorised'] = 'Poodll Read Aloud er IKKE autorisert for dette nettstedet.';
$string['article-topic-here'] = 'f.eks. fordeler og ulemper med sosiale medier';
$string['attemptno'] = 'Forsøk  {$a}';
$string['attemptsheading'] = 'Forsøksrapport';
$string['attemptsperpage'] = 'Antall forsøk vist pr. side';
$string['attemptsreport'] = 'Forsøksrapport';
$string['attemptssummary_explanation'] = 'En oppsummering av ReadAloud-forsøk per bruker i denne aktiviteten.';
$string['attemptssummaryheading'] = 'Oppsummeringsrapport for forsøk';
$string['attemptssummaryreport'] = 'Oppsummeringsrapport for forsøk';
$string['audiofile'] = 'Lyd';
$string['audioresponse'] = 'Lydrespons';
$string['av_accuracy_p'] = 'Gj.snitt nøyaktighet(%)';
$string['av_grade_p'] = 'Gj.snitt karakter (%)';
$string['av_wpm'] = 'Gjennomsnitt ord pr. minutt';
$string['averages'] = 'Gjennomsnitt';
$string['avgcorrect'] = 'Gj.snitt korrekt';
$string['avgtotaltime'] = 'Gj.snitt varighet';
$string['awsregion_details'] = 'Velg regionen nærmest deg. Dine data vil forbli innenfor den regionen. Capetown-regionen støtter kun engelsk og tysk.';
$string['backtotop'] = 'Sjekk resultater';
$string['basicheading'] = 'Basisrapport';
$string['basicreport'] = 'Basisrapport';
$string['beginreading'] = 'Start lesing';
$string['chartexplainer'] = 'Diagrammet nedenfor viser din fremgang over tid i å lese denne teksten.';
$string['checking'] = '...sjekker...';
$string['close'] = 'Steng';
$string['confirm_cancel_recording'] = 'Avbryte opptak og avslutte forsøket?';
$string['confirmitemdelete'] = 'Er du sikker du vil SLETTE elementet?';
$string['confirmitemdeletetitle'] = 'Virkelig SLETTE elementet?';
$string['corpuspushed'] = 'Korpusguide pushet';
$string['corpusrange'] = 'Korpusområde';
$string['corpusrange_course'] = 'Dette kurset';
$string['corpusrange_site'] = 'Dette nettstedet';
$string['correct'] = 'Riktig';
$string['correctanswer'] = 'Riktig svar';
$string['correcttranslationtitle'] = 'Riktig oversettelse';
$string['courseattempts_explanation'] = 'Alle forsøk på ReadAloud-aktiviteter innenfor dette kurset';
$string['courseattemptsheading'] = 'Kursforsøksrapport';
$string['courseattemptsreport'] = 'Kursforsøksrapport';
$string['createaitem'] = 'Lag et spørsmål';
$string['credentialsinvalid'] = 'API-brukeren og hemmeligheten som ble angitt kunne ikke brukes for å få tilgang. Vennligst sjekk dem.';
$string['currenterrorestimate'] = 'Nåværende feilestimat: {$a}';
$string['customfont'] = 'Egendefinert skrift';
$string['customfont_help'] = 'Et fontnavn som vil overstyre nettstedets standard for denne teksten når den vises. Må være nøyaktig i stavemåte og store/små bokstaver. f.eks. Andika eller Comic Sans MS';
$string['datatables_aria_sortascending'] = 'aktiver for å sortere kolonnen stigende';
$string['datatables_aria_sortdescending'] = 'aktiver for å sortere kolonnen synkende';
$string['datatables_emptytable'] = 'Ingen tilgjengelige data i tabellen';
$string['datatables_info'] = 'Viser_START_til_END_of_TOTAL_oppføringer';
$string['datatables_infoempty'] = 'Viser 0 til 0 av 0 oppføringer';
$string['datatables_infofiltered'] = '(filtrert fra totalt MAX oppføringer)';
$string['datatables_paginate_first'] = 'Først';
$string['datatables_paginate_last'] = 'Sist';
$string['datatables_paginate_next'] = 'Neste';
$string['datatables_paginate_previous'] = 'Forrige';
$string['datatables_search'] = 'Søk:';
$string['datatables_zerorecords'] = 'Ingen matchende opptak funnet';
$string['defaultfeedback'] = 'Takk for at du leste!';
$string['defaultrecorder'] = 'Standard opptaker';
$string['defaultrecorder_details'] = 'Velg den standardopptakeren som skal vises for studentene.';
$string['defaultwelcome'] = 'I denne aktiviteten skal du lese en tekst høyt. Du kan bli bedt om å teste mikrofonen din først. Du bør se lydopptakeren nedenfor. Etter at du har startet opptaket, vil teksten vises. Les teksten høyt så klart du kan.';
$string['deletealluserdata'] = 'Slett alle brukerdata';
$string['deleteattemptconfirm'] = 'Er du sikker du vil slette dette forsøket?';
$string['deleteitem'] = 'Slett element';
$string['developer'] = 'Utvikler';
$string['disableshadowgrading'] = 'Deaktiver skyggemodus karaktersetting';
$string['disableshadowgrading_details'] = 'Hvis krysset av, vil forsøk gjort i skyggemodus bli evaluert, men ingen oppføring vil bli sendt til karakterboken.';
$string['doclear'] = 'Fjern alle markører';
$string['done'] = 'Ferdig';
$string['edit'] = 'Rediger';
$string['editingitem'] = 'Rediger et spørsmål';
$string['edititem'] = 'Rediger element';
$string['enableai'] = 'Aktiver AI';
$string['enableai_details'] = 'Read Aloud kan evaluere resultater fra et studentforsøk ved bruk av AI. Kryss av for å aktivere.';
$string['enablelandr'] = 'Aktiver øvemodus (lytt og gjenta)';
$string['enablelandr_details'] = 'Aktiverer lytt og gjenta-modus. Linje for linje lytter og leser studenten vekselvis.';
$string['enablepreview'] = 'Aktiver lyttemodus';
$string['enablepreview_details'] = 'Lyttemodus viser lesingen og modelllyden til studenten før aktiviteten starter.';
$string['enablesetuptab'] = 'Aktiver oppsettfane';
$string['enablesetuptab_details'] = 'Vis en fane som inneholder aktivitetsinstillingene til administratorer. Ikke super nyttig i de fleste tilfeller.';
$string['enableshadow'] = 'Aktiver øvingsmodus (skygge)';
$string['enableshadow_details'] = 'Aktiverer skyggemodus. Dette spiller modelllyden mens elevene leser hele teksten høyt. Elevene vil trenge hodetelefoner for dette.';
$string['enabletts'] = 'Aktiver TTS (eksperimentell)';
$string['enabletts_details'] = 'TTS er foreløpig ikke implementert';
$string['entersomething'] = 'Vennligst skriv inn et tema for å generere en tekst';
$string['errorcount'] = 'Antall feil';
$string['errorheader'] = 'Feil';
$string['evaluatedmessage'] = 'Ditt siste forsøk er mottatt, og evalueringen vises nedenfor.';
$string['evaluationview'] = 'Evalueringsvisning';
$string['evaluationview_details'] = 'Hva som skal vises til studentene etter at de har forsøkt og mottatt en evaluering';
$string['eventreadaloudattemptsubmitted'] = 'ReadAloud forsøk levert';
$string['exceededallattempts'] = 'Du har brukt alle dine forsøk.';
$string['exceededattempts'] = 'Du har fullført maks antall forsøk: {$a}';
$string['expiredays'] = 'Antall dager å lagre fil';
$string['exportexcel'] = 'Eksporter til CSV';
$string['extraslowspeed'] = 'Ekstra sakte';
$string['feedbacklabel'] = 'Instruksjoner etter forsøk';
$string['feedbacklabel_details'] = 'Standardteksten som skal vises i tilbakemeldingsfeltet når du oppretter en ny Read Aloud-aktivitet.';
$string['freetrial'] = 'Få Cloud Poodll API-legitimasjon og en gratis prøveperiode';
$string['freetrial_desc'] = 'En dialogboks skal vises som lar deg registrere deg for en gratis prøveperiode med Poodll. Etter registrering bør du logge inn på medlemspanelet for å få din API-bruker og hemmelighet. Og for å registrere nettstedets URL.';
$string['fullreport'] = 'Vis full rapport';
$string['fullreportnoeval'] = 'Vis tekst';
$string['generate-text'] = 'Generer tekst';
$string['gotnosound'] = 'Vi kunne ikke høre deg. Vennligst sjekk tillatelser og innstillinger for mikrofonen og forsøk igjen.';
$string['grade'] = 'Karakter';
$string['grade_p'] = 'Karakter(%)';
$string['gradeaverage'] = 'gjennomsnittlig poengsum av alle forsøk';
$string['gradehighest'] = 'høyeste poengsum forsøk';
$string['gradelatest'] = 'resultat siste forsøk';
$string['gradelowest'] = 'laveste poengsum forsøk';
$string['gradenone'] = 'Ingen karakter';
$string['gradenow'] = 'Vurder nå';
$string['gradeoptions'] = 'Vurderingsinnstillinger';
$string['gradeoptions_details'] = 'NB Dette bestemmer karakterbokoppføringen. ReadAloud-vurderingssiden påvirkes ikke og vil vise det siste forsøket.';
$string['gradeoptions_help'] = 'Når en bruker har flere forsøk på en lesing, avgjør denne innstillingen hvilket forsøk som skal brukes ved vurdering';
$string['grader'] = 'Vurdert av';
$string['grader_ai'] = 'AI';
$string['grader_human'] = 'Menneske';
$string['grader_ungraded'] = 'Ikke vurdert';
$string['gradethisattempt'] = 'Vurder dette forsøket';
$string['grading'] = 'Vurdering';
$string['gradingbutton'] = 'Vurderingsmodus';
$string['gradingbyuserheading'] = 'Vurder alle forsøk for: {$a}';
$string['gradingheading'] = 'Vurdering av siste forsøk for hver bruker.';
$string['guidedtrans_corpus'] = 'Bruk korpus (alle ReadAloud-tekster)';
$string['guidedtrans_passage'] = 'Bruk denne aktivitetsteksten';
$string['guidedtranscriptionadmin'] = 'Administrasjon av veiledet transkripsjon';
$string['guidedtransinstructions'] = 'Når du bruker veiledet transkripsjon, vil transkribenten styre transkripsjonen mot veiledningen, dvs. ordene/setningene i denne aktivitetens tekst, eller ordene/setningene i hele korpuset av ReadAloud-tekster. Bruk av hele korpuset av ReadAloud-tekster vil fange opp flere lese feil.';
$string['h_accuracy_p'] = 'Maks nøyaktighet (%)';
$string['h_grade_p'] = 'Maks karakter (%)';
$string['h_wpm'] = 'Maks ord pr. minutt';
$string['hiddenevaluationmessage'] = 'Ditt forsøk er mottatt. Takk.';
$string['highest'] = 'Høyeste';
$string['humanpostattempt'] = 'Evaluering visning (menneskelig)';
$string['humanpostattempt_details'] = 'Hva som skal vises til studentene etter at de har forsøkt og mottatt en menneskelig evaluering';
$string['item'] = 'Element';
$string['itemcontents'] = 'Spørsmålsbeskrivelse';
$string['itemdetails'] = 'Elementdetaljer: {$a}';
$string['iteminuse'] = 'Dette elementet er en del av brukerens forsøkslogg. Det kan ikke slettes.';
$string['itemname'] = 'Spørsmålsnavn';
$string['itemorder'] = 'Rekkefølge elementer';
$string['itemsperpage'] = 'Elementer pr. side';
$string['itemsperpage_details'] = 'Dette angir antall rader som skal vises i rapporter eller lister over forsøk.';
$string['itemsummary'] = 'Sammendrag for element: {$a}';
$string['itemtitle'] = 'Spørsmålstittel';
$string['itemtype'] = 'Element-type';
$string['landrhelp'] = 'Lytt til høyttaleren. Gjenta etter hver setning og sjekk uttalen din.';
$string['landrreading'] = 'Øving';
$string['letsaddpassage'] = 'Det er ennå ikke satt noen lesetekst for denne aktiviteten. La oss legge til en';
$string['machinegradehybrid'] = 'Bruk menneskelig eller maskinell evaluering for karakter';
$string['machinegrademachineonly'] = 'Bruk alltid maskinell vurdering for karakter';
$string['machinegrademethod'] = 'Menneske/maskin vurdering';
$string['machinegrademethod_details'] = 'Bruk maskinelle vurderinger eller menneskelige vurderinger som karakterer i karakterboken';
$string['machinegrademethod_help'] = 'Bruk maskinelle vurderinger eller menneskelige vurderinger som karakterer i karakterboken';
$string['machinegradenone'] = 'Aldri bruk maskinevaluering';
$string['machinegradespushed'] = 'Vurderinger sendt til karakterbok';
$string['machinegrading'] = 'Maskinevaluering';
$string['machinegradingbyuserheading'] = 'Maskinevaluerte forsøk for: {$a}';
$string['machinegradingheading'] = 'Maskinevaluert siste forsøk for hver bruker.';
$string['machinepostattempt'] = 'Evalueringsvisning (maskin)';
$string['machinepostattempt_details'] = 'Hva som skal vises til studentene etter at de har forsøkt og mottatt en maskinell evaluering';
$string['machineregradeall'] = 'Lagre og reevaluere alle forsøk';
$string['machineregraded'] = 'Vellykket revurdert {a->done} forsøk. Hoppet over {a->skipped} forsøk.';
$string['managersquestions'] = 'Administrer spørsmål';
$string['manualbreaktiming'] = 'Manuell pausestyring';
$string['masterinstance'] = 'Hovedinstand';
$string['masterinstance_details'] = 'Hovedinstans lar forfatteren overføre de individuelle innstillingene for én ReadAloud til eksisterende kopier av samme aktivitet. De må ha nøyaktig samme navn.';
$string['maxattempts'] = 'Maks forsøk';
$string['mediumspeed'] = 'Medium';
$string['mingrade'] = 'Minimumskarakter';
$string['missed_count'] = 'Manglende antall';
$string['missedwords'] = 'Manglende ord';
$string['missedwords_explanation'] = 'De hyppigste feil ordene i de siste forsøkene';
$string['missedwordsheading'] = 'Manglende ord';
$string['missedwordsreport'] = 'Manglende ord';
$string['mistakes'] = 'Feil';
$string['mistrans_count'] = 'Antall';
$string['mistranscriptions'] = 'Feiltranskripsjoner';
$string['mistranscriptions_summary'] = 'Sammendrag av feiltranskripsjoner.';
$string['modelaudio'] = 'Modell-lyd';
$string['modelaudio_breaksinstructions'] = 'Trykk på ordene i teksten nedenfor for å legge til en pause på det punktet i lydavspillingen i forhåndsvisning og øvingsmodus. Systemet vil automatisk synkronisere lyden og teksten. Kryss av for <i>manuell pausestyring</i> for å sette trykte pauser til gjeldende plassering av spillelyden.';
$string['modelaudio_breakstitle'] = 'Merk modelllyd';
$string['modelaudio_playerinstructions'] = 'Den nåværende modelllyden kan spilles av ved å bruke spilleren nedenfor.';
$string['modelaudio_playertitle'] = 'Spill modell-lyd';
$string['modelaudio_recordinstructions'] = 'Spill inn lyd her som skal brukes som modelllyd. Du kan eventuelt velge å laste opp lyd ved å trykke på knappen for å laste opp lyd. Det vil være en forsinkelse på noen minutter før pauseteksten og lyden synkroniseres automatisk';
$string['modelaudio_recordtitle'] = 'Ta opp modell-lyd';
$string['modelaudiobreaksclear'] = 'Fjern merkingen av modelllyd';
$string['modelaudiobreaksgenerate'] = 'Regenerer modelllydmerking';
$string['modelaudioclear'] = 'Slett lyd';
$string['modelaudiowarning'] = 'Modelllyd ikke merket.';
$string['modulename_help'] = 'ReadAloud er en aktivitet designet for å hjelpe lærere med å evaluere elevenes leseferdighet. Elevene leser en tekst, satt opp av læreren, inn i en mikrofon. Senere kan læreren markere ord som feil og få elevens WCPM (Words Correct Per Minute) poeng.';
$string['moveitemdown'] = 'Ned';
$string['moveitemup'] = 'Opp';
$string['myattemptssummary'] = 'Forsøksoppsummering ({$a} forsøk)';
$string['name'] = 'Navn';
$string['ng'] = 'Ikke ok';
$string['noattemptsregrade'] = 'Ingen forsøk å revurdere';
$string['nocourseid'] = 'Du må spesifisere en kursmodul-ID eller en instans-ID. Sannsynligvis har økten din utløpt.';
$string['nodataavailable'] = 'Ingen data tilgjengelig';
$string['noitems'] = 'Quizzen inneholder ingen spørsmål';
$string['nomistranscriptions'] = 'Ingen feiltranskripsjoner.';
$string['nopassage'] = 'Ingen lesetekst';
$string['normalhelp'] = 'Les teksten høyt. Snakk i et tempo som er naturlig for deg.';
$string['nosubscriptions'] = 'Det er ingen gjeldende abonnement for dette nettstedet/denne pluginen.';
$string['notaddedtogradebook'] = 'Dette var en skyggeøvelse, og ble ikke lagt til karakterboken.';
$string['notgradedyet'] = 'Innleveringen din er mottatt, men har ikke blitt vurdert ennå. Det kan ta noen minutter.';
$string['notimelimit'] = 'Ingen tidsgrense';
$string['notmanuallygradedyet'] = 'Innleveringen din er mottatt, men har ikke blitt vurdert ennå.';
$string['notmasterinstance'] = 'Du kan ikke overføre innstillinger fra denne ReadAloud-aktiviteten med mindre hovedinstans er merket av i aktivitetsinnstillingene.';
$string['notok'] = 'Ikke ok';
$string['notokenincache'] = 'Oppdater for å se lisensinformasjon. Kontakt Poodll-support hvis det er et problem.';
$string['nottsvoice'] = 'Ingen TTS stemme';
$string['numeric'] = 'Må være numerisk';
$string['ok'] = 'OK';
$string['one_simplest'] = 'en (enkleste)';
$string['onemin'] = '1 minutt';
$string['oneminxsecs'] = '1 minutter {$a} sekunder';
$string['open'] = 'Åpen:';
$string['oralreadingscore'] = 'Muntlig leseresultat';
$string['oralreadingscore_p'] = 'Muntlig leseresultat(%)';
$string['overview'] = 'Oversikt';
$string['overview_help'] = 'Oversikt hjelp';
$string['overwrite'] = 'Overskriv';
$string['passage'] = 'Lesetekst';
$string['passage_descr'] = 'Skriv inn leseteksten ovenfor. Den bør ikke være lengre enn 3000 tegn hvis du ønsker at det skal genereres lyd for den.';
$string['passage_help'] = 'Teksten som vil bli vist til studenten for å lese.';
$string['passageindex'] = 'Tekstindeks';
$string['passagekey'] = 'Teksnøkkel';
$string['passagekey_details'] = 'Tekstnøkkelen er bare en tagg som vil bli eksportert til CSV med noen rapporter for å gjøre etterbehandlingen av disse rapportene i et regneark enklere. Det er greit å la den stå tom.';
$string['passagekey_help'] = 'Tekstnøkkelen er bare en tagg som vil bli eksportert til CSV med noen rapporter for å gjøre etterbehandlingen av disse rapportene i et regneark enklere.';
$string['passagelabel'] = 'Lesetekst';
$string['passagepicture'] = 'Tekstillustrasjon';
$string['passagepicture_descr'] = 'Tekstillustrasjon er ikke i bruk ennå. Det er en del av en kommende funksjon';
$string['passageword'] = 'Tekstord';
$string['playbutton'] = 'Spill av';
$string['postattempt_eval'] = 'Vis teksten, og evalueringen (WPM,nøyaktighet, karakter)';
$string['postattempt_evalerrors'] = 'Vis teksten, og evalueringen (WPM,nøyaktighet, karakter) og feil';
$string['postattempt_evalerrorsnograde'] = 'Vis teksten, og evalueringen (WPM,nøyaktighet) og feil';
$string['postattempt_none'] = 'Vis teksten. Ikke vis evaluering eller feil.';
$string['postattemptheader'] = 'Alternativ etter forsøk';
$string['preview'] = 'Forhåndsvisning';
$string['previewhelp'] = 'Lytt til en høyttaler som leser teksten høyt. Du trenger ikke å lese høyt.';
$string['previewitem'] = 'Forhåndsvis element';
$string['previewreading'] = 'Lytt';
$string['privacy:metadata'] = 'Poodll Read Aloud-pluginen lagrer personlig data.';
$string['privacy:metadata:accuracy'] = 'Nøyaktighetspoeng for forsøket';
$string['privacy:metadata:aitable'] = 'Lagrer poengene og andre brukerdata knyttet til et forsøk på høytlesing evaluert av maskin.';
$string['privacy:metadata:attemptid'] = 'Den unike identifikatoren for en brukers høytlesingsforsøk.';
$string['privacy:metadata:attempttable'] = 'Lagrer poengene og andre brukerdata knyttet til et høytlesingsforsøk.';
$string['privacy:metadata:cloudpoodllcom'] = 'ReadAloud-pluginen lagrer opptak i AWS S3-buckets via cloud.poodll.com.';
$string['privacy:metadata:cloudpoodllcom:userid'] = 'ReadAloud-pluginen inkluderer moodle-bruker-ID i URL-ene til opptak og transkripsjoner';
$string['privacy:metadata:errorcount'] = 'Antall lesefeil for forsøket';
$string['privacy:metadata:filename'] = 'Fil-URL-er for innsendte opptak';
$string['privacy:metadata:fulltranscriptpurpose'] = 'De fullstendige transkripsjonene av opptakene.';
$string['privacy:metadata:readaloudid'] = 'Den unike identifikatoren for en Read Aloud-aktivitetsinstans.';
$string['privacy:metadata:sessionendword'] = 'Plasseringen til det siste ordet i forsøket';
$string['privacy:metadata:sessionerrors'] = 'Lesefeilene i forsøket';
$string['privacy:metadata:sessionscore'] = 'Øktpoengsummen for forsøket';
$string['privacy:metadata:sessiontime'] = 'Øktiden (opptakstiden) for forsøket';
$string['privacy:metadata:timemodified'] = 'Sist gang forsøket ble endret for forsøket';
$string['privacy:metadata:transcriptpurpose'] = 'De korte transkripsjonene av opptakene.';
$string['privacy:metadata:userid'] = 'Bruker-ID for Read Aloud-forsøket';
$string['privacy:metadata:wpm'] = 'Ordene per minutt for forsøket';
$string['processing'] = 'Behandler';
$string['progresschart'] = 'fremdriftskart';
$string['push'] = 'Overfør';
$string['pushalltogradebook'] = 'Overfør vurderinger til karakterbok på nytt';
$string['pushalternatives'] = 'Overføringsalternativer';
$string['pushalternatives_desc'] = 'Overfør alternative felt til alle klonede instanser.';
$string['pushalternatives_done'] = 'Alternativene er overført';
$string['pushcanexitearly'] = 'Kan avslutte tidlig';
$string['pushcanexitearly_desc'] = 'Overfør innstillingen \'Kan avslutte tidlig\' til alle klonede instanser. Denne innstillingen lar brukere avslutte aktiviteten før tidsfristen er nådd.';
$string['pushcanexitearly_done'] = 'Kan avslutte tidlige er overført';
$string['pushcorpus_button'] = 'Oppdater og overfør korpus veileder';
$string['pushcorpus_details'] = 'Kurs-/nettstedkorpuset vil bli oppdatert automatisk, men du kan bruke knappen nedenfor for å oppdatere og skyve korpuset hvis du trenger det. Dette vil generere en veiledning fra korpusområdet, og det vil sette alle ReadAloud-aktiviteter (ved bruk av veiledet transkripsjon) innen området til å bruke veiledningen.';
$string['pushgradesettings'] = 'Vurderingsinnstillinger';
$string['pushgradesettings_desc'] = 'Skyv noen av karaktersinnstillingene (fullføringsbetingelse, minimumskarakter, karakterberegning, menneskelig/maskinell vurdering, høyeste/siste forsøk) fra denne instansen til klonede instanser. Dette vil ikke oppdatere maksimumskarakteren eller andre innstillinger som påvirker karakterbokens oppsett, og det vil heller ikke tvinge en ny vurdering av eksisterende forsøk. Det er best å bare bruke dette på kloner som ennå ikke er forsøkt.';
$string['pushgradesettings_done'] = 'Vurderinsinnstillinger er overført';
$string['pushmodes'] = 'Moduler';
$string['pushmodes_desc'] = 'Skyv de valgfrie aktivitetsmodusinnstillingene (forhåndsvisning, lytt og gjenta og skygge) fra denne instansen til klonede instanser.';
$string['pushmodes_done'] = 'Moduler er overført';
$string['pushpage'] = 'Overføringer side';
$string['pushpage_clonecount'] = 'Denne aktiviteten har {$a} kloninger. <br><br>';
$string['pushpage_explanation'] = 'Bruk knappene på denne siden for å skyve innstillinger fra denne ReadAloud-instansen til kloner av den (dvs. aktiviteter med samme navn). Vær forsiktig, det er ingen vei tilbake, så vær sikker på hensikten din før du bruker dem.';
$string['pushpage_noclones'] = 'Denne aktiviteten ER en hovedinstans, men det er ingen andre aktiviteter med samme navn (dvs. kloner). Så det er ingenting å skyve innstillinger til. Sjekk at dette er riktig aktivitet. Hvis du bare tester, dupliser denne aktiviteten og gi det samme navn som denne.<br><br>';
$string['pushpassage'] = 'Overfør tekst (og relaterte innstillinger)';
$string['pushpassage_desc'] = 'Overfør tekst og fonetikk og segmenter og andre elementer som er unike for teksten, til kloner.';
$string['pushpassage_done'] = 'Tekst er overført';
$string['pushquestions'] = 'Overfør spørsmpl';
$string['pushquestions_desc'] = 'Du kunne ha overført forståelsesspørsmål herfra hvis det var noen. De vil bli implementert snart.';
$string['pushquestions_done'] = 'Spørsmål er ikke overført';
$string['pushtargetwpm'] = 'Mål ord pr. minutt';
$string['pushtargetwpm_desc'] = 'Overfør mål for ord pr. minutt til alle klonede instanser.';
$string['pushtargetwpm_done'] = 'Mål ord pr. minutt er overført';
$string['pushtimelimit'] = 'Tidsgrense';
$string['pushtimelimit_desc'] = 'Overfør tidsgrenseinnstillingen til alle klonede instanser.';
$string['pushtimelimit_done'] = 'Tidsgrense er overført';
$string['pushttsmodelaudio'] = 'Overfør TTS og modell-ly';
$string['pushttsmodelaudio_desc'] = 'Overfør TTS- og modelllydrelaterte innstillinger, dette vil ikke skyve noen opplastet/opptatt lyd. Det vil skyve TTS-lyd og metadata inkludert lydpauser.';
$string['pushttsmodelaudio_done'] = 'TTS og modell-lyd er overført';
$string['quickgrade'] = 'Hurtigvurdering';
$string['quiz'] = 'Quiz';
$string['quizcompletedwarning'] = 'Quiz fullført. Trykk for å gå gjennom.';
$string['quizhelp'] = 'Les teksten stille. Svar deretter på spørsmålene om teksten.';
$string['rawaccuracy_p'] = 'Nøaktighet(%)';
$string['rawgrade_p'] = 'Karakter(%)';
$string['rawwpm'] = 'Ord pr. minutt';
$string['readaloud:addinstance'] = 'Legg til ny ReadAloud';
$string['readaloud:itemedit'] = 'Rediger spørsmål';
$string['readaloud:itemview'] = 'Se spørsmål';
$string['readaloud:view'] = 'Forhåndsvis ReadAloud';
$string['readingtime'] = 'Lesetid (sekunder)';
$string['reallyoverwritepassage'] = 'Overskriv den nåværende teksten?';
$string['reattempt'] = 'Forsøk igjen';
$string['rec_once'] = 'Bare start';
$string['rec_readaloud'] = 'Mikrofon-test før start';
$string['recorder'] = 'Type lydopptaker';
$string['recorder_help'] = 'Velg lydopptakertypen som passer best for dine elever og situasjon.';
$string['recordingaiheader'] = 'Opptak og AI innstillinger';
$string['regrade'] = 'Vurder på nytt';
$string['reports'] = 'Rapporter';
$string['reportsmenutoptext'] = 'Gå gjennom forsøk på ReadAloud-aktiviteter ved å bruke rapportene nedenfor';
$string['returnmenu'] = 'Tilbake til meny';
$string['returntogradinghome'] = 'Tilbake til vurdering topp';
$string['returntomachinegradinghome'] = 'Tilbake til maskin-evaluering topp';
$string['returntomenu'] = 'Tilbake til meny';
$string['returntoreports'] = 'Tilbake til rapporter';
$string['review'] = 'Gå gjennom';
$string['rsquestions'] = 'Spørsmål';
$string['saveandnext'] = 'Lagre... og neste';
$string['saveitem'] = 'Lagre element';
$string['savemodelaudio'] = 'Lagre opptak';
$string['savemodelaudiomarkup'] = 'Lagre modellydmerking';
$string['secs_till_check'] = 'Sjekker resultater om:';
$string['sessionscoremethod'] = 'Karakterberegning';
$string['sessionscoremethod_details'] = 'Hvordan verdien (%) for karakterboken beregnes.';
$string['sessionscoremethod_help'] = 'Verdien (%) for karakterboken beregnes som en prosentandel, enten WPM / Mål_WPM (normal) eller (WPM - Feil) / Mål_WPM (streng)';
$string['sessionscorenormal'] = 'Normal: Totalt riktige ord per minutt / Mål_WPM';
$string['sessionscorestrict'] = 'Streng: (Totalt riktige ord - feil) per minutt / Mål_WPM';
$string['setup'] = 'Oppsett';
$string['shadowhelp'] = 'Les teksten høyt, sammen med læreren. Du bør bruke hodetelefoner.';
$string['showingattempt'] = 'Vis forsøk for: {$a}';
$string['showingmachinegradedattempt'] = 'Maskin-evaluert forsøk for: {$a}';
$string['shuffleanswers'] = 'Stokk svar';
$string['shufflequestions'] = 'Stokk spørsmål';
$string['simplify-text'] = 'Forenkle teksten';
$string['slowspeed'] = 'Sakte';
$string['startreading'] = 'Les';
$string['startshadowreading'] = 'Skyggeøving';
$string['stopbutton'] = 'Stopp';
$string['stricttranscribe'] = 'Teksttranskribent';
$string['stricttranscribe_details'] = 'Transkribenten som skal brukes for fullstendige tekstlesinger.';
$string['submitted'] = 'levert';
$string['summaryexplainer'] = 'Tabellen nedenfor viser ditt gjennomsnitt og dine høyeste poengsummer for denne aktiviteten.';
$string['targetwpm'] = 'Mål ord pr. minutt';
$string['targetwpm_details'] = 'Standardmål for WPM. En students karakter beregnes for karakterboken ved å bruke denne verdien som maksimum poengsum. Hvis studentens WPM-poengsum er lik eller høyere enn mål-WPM, vil de få 100%. Mål-WPM kan også settes på aktivitetsnivå.';
$string['targetwpm_help'] = 'Mål-WPM-poengsum. En students karakter beregnes for karakterboken ved å bruke denne verdien som maksimum poengsum. Hvis studentens WPM-poengsum er lik eller høyere enn mål-WPM, vil de få 100%.';
$string['text-too-long-100'] = 'Temaet ditt bør ikke være mer enn 100 tegn. Beskriv bare temaet, skriv ikke en full setning, eller gi ytterligere instruksjoner.';
$string['textboxchoice'] = 'Størrelse tekstboks';
$string['textchoice'] = 'Valg tekstområde';
$string['textgenerator_instructions'] = 'Skriv inn en kort beskrivelse av et ikke-fiksjon tema og trykk på knappen for å generere en tekst. Den vil ofte ikke være faktuelt korrekt. Vær forsiktig med å bruke den med studenter.';
$string['textoverwriteconfirm'] = 'Bekreftelse av overskriving';
$string['textsimplifier_instructions'] = 'Velg forenklingsnivået og trykk på knappen for å forenkle teksten. Teksten vil bli forenklet til omtrent det nivået du velger.';
$string['three'] = 'tre';
$string['timecreated'] = 'Opprettet tif';
$string['timelimit'] = 'Tidsgrense';
$string['timelimit_help'] = 'Angir en tidsbegrensning på lesingen. Lesetiden brukes i WPM-beregningen. Vurder også å sjekke - Tillat tidlig avslutning';
$string['total_mistranscriptions'] = 'Totalt antall feiltranskripsjoner: {$a}';
$string['totalattempts'] = 'Forsøk';
$string['totalwords'] = 'Totalt antall ord';
$string['transcriber'] = 'Linjetranskribent';
$string['transcriber_details'] = 'Transkripsjonsmotoren som skal brukes for linje for linje-lesing.';
$string['transcriber_none'] = 'Ingen transkripsjon';
$string['transcriber_warning'] = 'Du har valgt øyeblikkelig transkripsjon. Merk at dette <strong>kun vil fungere hvis tekstens språk og region er korrekt</strong>.';
$string['transcript'] = 'Transkript';
$string['transcriptcheckbutton'] = 'Transkripsjonssjekkmodus';
$string['ttslanguage'] = 'Tekstspråk';
$string['ttslanguage_details'] = 'Denne verdien brukes for talegjenkjenning og tekst-til-tale.';
$string['ttslanguage_help'] = 'Denne verdien brukes for talegjenkjenning og tekst-til-tale.';
$string['ttsspeed'] = 'TTS hastighet';
$string['ttsspeed_help'] = 'Lesehastigheten for maskinstemmen. Langsom eller Ekstra Langsom er bra for elever, men kan forvrenge lyden.';
$string['ttsvoice_descr'] = 'Maskinstemmen som brukes til å lese teksten høyt. Hvis den er etterfulgt av et + symbol, er det en bedre kvalitetsstemme. Hvis den er etterfulgt av et ! symbol, må du manuelt legge til talepauser i modelllydfanen.';
$string['ttsvoice_help'] = 'Maskinstemmen som brukes til å lese teksten høyt. Du bør velge en stemme som samsvarer med språkfamilien til tekstspråket. Hvis den er etterfulgt av et + symbol, er det en bedre kvalitetsstemme. Hvis den er etterfulgt av et ! symbol, må du manuelt legge til talepauser i modelllydfanen. Bruk modelllydfanen for å spille inn eller laste opp en alternativ modelllyd, eller for å manuelt angi talepauser.';
$string['two'] = 'to';
$string['unit_percent'] = 'prosent';
$string['unit_words'] = 'ord';
$string['unit_wpm'] = 'ord/min';
$string['unlimited'] = 'ubegrenset';
$string['until'] = 'til:';
$string['uploadconverterror'] = 'En feil oppstod under opplasting av filen til serveren. Innleveringen din er IKKE mottatt. Vennligst oppdater siden og prøv igjen.';
$string['uploadmodelaudio'] = 'Last opp lydfil';
$string['usecorpus'] = 'Type veiledet transkripsjon';
$string['usecorpuschanged'] = 'Type veiledet transkripsjon endret';
$string['username'] = 'Bruker';
$string['view'] = 'Vis';
$string['viewadmintab'] = 'Vis admin tab';
$string['viewend'] = 'Aktivitet stengt';
$string['viewend_help'] = 'Hvis satt, forhindres en student fra å gå inn i aktiviteten etter sluttdato/-tid.';
$string['viewgrading'] = 'Vis vurdering';
$string['viewmachinegrading'] = 'Maskinevaluering';
$string['viewmodeltranscript'] = 'Vis modelltranskripsjon';
$string['viewreports'] = 'Vis rapporter';
$string['viewstart'] = 'Aktivitet åpner';
$string['viewstart_help'] = 'Hvis satt, forhindres en student fra å gå inn i aktiviteten før startdato/-tid.';
$string['waitforpassage'] = 'Det er ennå ikke satt noen lesetekst for denne aktiviteten. Du vil ikke kunne utføre aktiviteten før læreren din legger til en.';
$string['waiting'] = '--venter--';
$string['waitingforteacher'] = 'Læreren din vil snart sjekke innlesingen din';
$string['welcomelabel'] = 'Instruksjoner før forsøk';
$string['welcomelabel_details'] = 'Standardinstruksjonene. Kan redigeres når du oppretter en ny Read Aloud-aktivitet.';
$string['welcomemenu'] = 'Velg fra alternativene nedenfor.';
$string['whatdonow'] = 'Hva vil du gjøre?';
$string['wpm'] = 'Ord pr. minutt';
$string['xmins'] = '{$a} minutter';
$string['xminsecs'] = '{$a->minutes} minutter {$a->seconds} sekunder';
$string['xsecs'] = '{$a} sekunder';
