<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'geogebra', language 'no', version '4.4'.
 *
 * @package     geogebra
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityclosed'] = 'Denne aktiviteten er lukket';
$string['activitynotopened'] = 'Denne aktiviteten er ikke tilgjengelig ennå';
$string['attempt'] = 'Forsøk';
$string['attempts'] = 'Forsøk';
$string['attemptsremaining'] = 'Gjenstående forsøk for denne aktiviteten:';
$string['autograde'] = 'Aktivitet med egenvurdering';
$string['availabledate'] = 'Tilgjengelig fra';
$string['average'] = 'Gjennomsnitt';
$string['choosescripttype'] = 'Velg skript';
$string['comment'] = 'Kommentar';
$string['contentheader'] = 'Innhold';
$string['coursewithoutstudents'] = 'Kurs uten studenter';
$string['datestudent'] = 'Sist endret (levering)';
$string['dateteacher'] = 'Sist endret (vurdering)';
$string['deleteallattempts'] = 'Slett alle forsøk';
$string['description'] = 'Beskrivelse';
$string['discardchanges'] = 'Forkast endringer og gå tilbake';
$string['duedate'] = 'Frist';
$string['duration'] = 'Varighet';
$string['enableLabelDrags'] = 'Aktiver flytting av titler';
$string['enableRightClick'] = 'Aktiver høyreklikk';
$string['errorattempt'] = 'Feil: Forsøket kunne ikke lagres.';
$string['event_course_module_viewed'] = 'Kursmodul sett';
$string['event_instances_list_viewed'] = 'Hendelseslisten sett';
$string['expired'] = 'Beklager, denne aktiviteten lukket {$a} og er ikke lenger tilgjengelig';
$string['extractedfromggb'] = 'pakket ut filer fra ggb';
$string['filename'] = 'Filnavn';
$string['filenotfound'] = 'Spesifisert fil eksisterer ikke';
$string['filetype'] = 'Type';
$string['filetype_help'] = 'Denne innstillingen styrer hvordan GeoGebra aktiviteten blir inkludert i kurset. Det er 2 muligheter:

* Opplastet GeoGebra - Gjør det mulig å velge en ".ggb" fil med filvelgeren.
*Ekstern URL - Gjør det mulig å spesifisere en URL. NB: Må starte med http(s) eller www og inneholde en gyldig ".ggb" fil.';
$string['filetypeexternal'] = 'Ekstern URL';
$string['filetypelocal'] = 'Opplastet fil';
$string['firstattempt'] = 'Første forsøk';
$string['for'] = 'for';
$string['functionalityoptionsgrp'] = 'Funksjonalitet';
$string['geogebra:addinstance'] = 'Legg til GeoGebra';
$string['geogebra:grade'] = 'Vurder GeogGebra';
$string['geogebra:submit'] = 'Lever GeoGebra';
$string['geogebra:view'] = 'Vis GeoGebra';
$string['geogebrafile'] = 'GeoGebra fil';
$string['geogebrafile_help'] = '.ggb filen.';
$string['geogebraurl'] = 'URL';
$string['geogebraurl_help'] = 'Denne innstillingen gir mulighet for å spesifisere en URL for GeoGebra fila, heller enn å velge en fil med filvelgeren.';
$string['grade'] = 'Vurdering';
$string['gradeit'] = 'Vurder';
$string['grademethod'] = 'Vurderingsmetode';
$string['height'] = 'Høyde';
$string['highestattempt'] = 'Høyeste forsøk';
$string['httpnotallowed'] = 'For øyeblikket er det ikke tillatt å bruke eksterne filer';
$string['interfaceoptionsgrp'] = 'Brukergrensesnitt';
$string['invalidgeogebrafile'] = 'Ugyldig GeoGebra fil spesifisert. Velg en ".ggb" fil';
$string['invalidurl'] = 'Ugyldig URL. Må starte med http(s) og være en gyldig ".ggb"';
$string['language'] = 'Språk';
$string['lastattempt'] = 'Siste forsøk';
$string['lastattemptremaining'] = 'Dette er ditt siste forsøk for denne aktiviteten';
$string['lastmodifiedgrade'] = 'Sist endrede (vurdering)';
$string['lastmodifiedsubmission'] = 'Sist endrede (innlevering)';
$string['lowestattempt'] = 'Laveste forsøk';
$string['manualgrade'] = 'Manuell vurdering?';
$string['maxattempts'] = 'Max antall forsøk';
$string['modulename'] = 'GeoGebra';
$string['modulename_help'] = '<p><a href="http://www.geogebra.org" target="_blank">GeoGebra</a> is a free and multi-platform dynamic mathematics software for all levels of education that joins geometry, algebra, tables, graphing, statistics and calculus in one easy-to-use package.</p>
<p>Therefore, the <a href="http://www.gencat.cat/ensenyament/" target="_blank">Departament of Education of Catalonia</a> in collaboration with the <a href="http://acgeogebra.cat/" target="_blank">Catalan Association of GeoGebra</a> (ACG) and the GeoGeobra development team have implemented this module that allows the incorporation of GeoGebra activities in Moodle. Its main features are:
<ul>
    <li>Allows embedding easily GeoGebra activities in some Moodle course.</li>
    <li>Facilitates students tracing because it stores the score, date, duration and construction of each of the attempts made by the users.</li>
    <li>Students can save the state of the activities to continue them later.</li>
</ul>
</p>';
$string['modulenameplural'] = 'GeoGebra';
$string['msg_noattempts'] = 'Du har gjennomført denne aktiviteten max antall ganger';
$string['msg_nosessions'] = 'Denne GeoGebra aktiviteten har ikke noen økt enda';
$string['name'] = 'Navn';
$string['noattempts'] = '-';
$string['nograding'] = 'Ingen vurdering';
$string['nomoreattempts'] = 'Ikke flere forsøk igjen for denne aktiviteten';
$string['notopenyet'] = 'Beklager, denne aktiviteten er ikke tilgjengelig før {$a}';
$string['pluginadministration'] = 'GeoGebra administrasjon';
$string['pluginname'] = 'GeoGebra';
$string['preview_geogebra'] = 'Forhåndsvis Geogebra aktivitet';
$string['previewtab'] = 'Forhåndsvisning';
$string['redirecttocourse'] = 'Aktiviteten har blitt lagret. Går tilbake til startsiden for kurset';
$string['report'] = 'Rapport for';
$string['results'] = 'Resultat';
$string['resultstab'] = 'Resultat';
$string['resumeattempt'] = 'Fortsett ufullført forsøk';
$string['review'] = 'Gjennomgang av';
$string['reviewtab'] = 'Gjennomgang';
$string['savechanges'] = 'Lagre endringer';
$string['savewithoutsubmitting'] = 'Lagre uten å levere';
$string['settings'] = 'Innstillinger';
$string['showAlgebraInput'] = 'Vis algebrafelt';
$string['showMenuBar'] = 'Vis menylinje';
$string['showResetIcon'] = 'Vis ikon for å tilbakestille konstruksjon';
$string['showToolBar'] = 'Vis verktøylinje';
$string['showToolBarHelp'] = 'Vis verktøylinjehjelp';
$string['showsubmit'] = 'Vis leveringsknapp';
$string['status'] = 'Status';
$string['submitandfinish'] = 'Lever og avslutt';
$string['timing'] = 'Timing';
$string['total'] = 'Total';
$string['unfinished'] = 'Ikke fullført';
$string['ungraded'] = 'Ikke vurdert';
$string['unlimitedattempts'] = 'Ubegrenset antall forsøk for denne aktiviteten';
$string['urledit'] = 'GeoGebra fil';
$string['urledit_help'] = '".ggb" filen der du finner GeoGebra aktiviteten';
$string['useBrowserForJS'] = 'Bruk JavaSkript fra:';
$string['useBrowserForJS_geogebra'] = 'GeoGebra fil (usann)';
$string['useBrowserForJS_html'] = 'HTML (sann)';
$string['view'] = 'Vis';
$string['viewattempt'] = 'Vis';
$string['viewattempts'] = 'Vis forsøk (fl)';
$string['viewattempttab'] = 'Vis forsøk';
$string['viewtab'] = 'Vis';
$string['weight'] = 'Vekt';
$string['width'] = 'Bredde';
