<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'enrol_ldap', language 'et', version '4.4'.
 *
 * @package     enrol_ldap
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['assignrole'] = 'Rolli „{$a->role_shortname}“ määramine kasutajale „{$a->user_username}“ kursusel „{$a->course_shortname}“ (ID on {$a->course_id})';
$string['assignrolefailed'] = 'Rolli \'{$a->role_shortname}\' määramine kasutajale \'{$a->user_username}\' kursusel \'{$a->course_shortname}\' (id {$a->course_id}) ebaõnnestus';
$string['autocreate'] = 'Kursusi saab luua automaatselt, kui on olemas registreerumised kursustele, mida Moodle’is veel pole. Kui kasutate automaatset kursuse loomist, on soovitatav ülaltoodud kursuseväljade (ID number, lühinimi, täisnimi ja kokkuvõte) muutmise vältimiseks eemaldada sellega seotud rollidest järgmised tegevusload: moodle/course:changeidnumber, moodle/course:changeshortname, moodle/course:changefullname ja moodle/course:changesummary.';
$string['autocreate_key'] = 'Loo automaatselt';
$string['autocreation_settings'] = 'Automaatse kursuseloomise sätted';
$string['autoupdate_settings'] = 'Kursuse automaatse värskendamise sätted';
$string['autoupdate_settings_desc'] = '<p>Valige väljad, mida värskendada sünkroonimisskripti töö ajal (enrol/ldap/cli/sync.php).</p><p>Värskendamine toimub, kui on valitud vähemalt üks väli.</p>';
$string['bind_dn'] = 'Kui soovite kasutajate otsimiseks kasutada seotud kasutajat, määrake see siin, nt „cn=moodle_sync,ou=public,o=org“';
$string['bind_dn_key'] = 'Seotud kasutaja eristusnimi';
$string['bind_pw'] = 'LDAP kasutaja parool';
$string['bind_pw_key'] = 'Parool';
$string['bind_settings'] = 'LDAP kasutaja sätted';
$string['cannotcreatecourse'] = 'Kursust ei saa luua, LDAP kirjest puuduvad nõutavad andmed.';
$string['cannotupdatecourse'] = 'Kursust ei saa värskendada, LDAP kirjest puuduvad nõutavad andmed. Kursuse ID: {$a->idnumber}';
$string['cannotupdatecourse_duplicateshortname'] = 'Kursust ei saa värskendada: Dubleeritud lühinimi. Jäetakse vahele kursus ID-ga {$a->idnumber}...';
$string['category'] = 'Automaatselt loodud kursuste kategooria';
$string['category_key'] = 'Kategooria';
$string['contexts'] = 'LDAP kontekstid';
$string['couldnotfinduser'] = 'Ei leia kasutajat {$a}, jäetakse vahele';
$string['course_fullname'] = 'Valikuline: LDAP atribuut, millest saab täisnime';
$string['course_fullname_key'] = 'Täisnimi';
$string['course_fullname_updateonsync'] = 'Värskenda sünkroonimisskripti töö käigus täisnimi';
$string['course_fullname_updateonsync_key'] = 'Värskenda täisnimi';
$string['course_idnumber'] = 'LDAP-atribuut, millest kursuse ID-number tuuakse. Tavaliselt „cn“ või „uid“.';
$string['course_idnumber_key'] = 'ID-number';
$string['course_search_sub'] = 'Otsi rühma liikmeid allkontekstidest';
$string['course_search_sub_key'] = 'Otsi alamkontekste';
$string['course_settings'] = 'Kursusele registreerumise sätted';
$string['course_shortname'] = 'Valikuline: LDAP atribuut, millest saab lühinime';
$string['course_shortname_key'] = 'Lühinimi';
$string['course_shortname_updateonsync'] = 'Värskenda sünkroonimisskripti töö käigus lühinimi';
$string['course_shortname_updateonsync_key'] = 'Värskenda lühinimi';
$string['course_summary'] = 'Valikuline: LDAP atribuut, millest saab kokkuvõtte';
$string['course_summary_key'] = 'Kokkuvõte';
$string['course_summary_updateonsync'] = 'Värskenda sünkroonimisskripti töö käigus kokkuvõte';
$string['course_summary_updateonsync_key'] = 'Värskenda kokkuvõte';
$string['coursenotexistskip'] = 'Kursust \'{$a}\' ei eksisteeri ja automaatne loomine on keelatud, jäetakse vahele';
$string['courseupdated'] = 'Kursus ID-ga {$a->idnumber} on värskendatud.';
$string['courseupdateskipped'] = 'Kursus {$a->idnumber} ei vaja värskendamist. Jäetakse vahele...';
$string['createcourseextid'] = 'LOOMINE Kasutaja registreerus olematule kursusele „{$a->courseextid}“';
$string['createnotcourseextid'] = 'Kasutaja registreerus olematule kursusele „{$a->courseextid}“';
$string['creatingcourse'] = 'Loon kursuse \'{$a}\'...';
$string['duplicateshortname'] = 'Kursuse loomine nurjus. Dubleeritud lühinimi. Jäetakse vahele kursus ID-ga {$a->idnumber}...';
$string['editlock'] = 'Lukusta väärtus';
$string['emptyenrolment'] = 'Tühi registreerimine rolliga {$a->role_shortname} kursusel {$a->course_shortname}';
$string['enrolname'] = 'LDAP';
$string['enroluser'] = 'Registreeri kasutaja {$a->user_username} kursusele {$a->course_shortname} (ID {$a->course_id})';
$string['enroluserenable'] = 'Lubatud kasutaja {$a->user_username} registreerimine kursusele {$a->course_shortname} (ID {$a->course_id})';
$string['explodegroupusertypenotsupported'] = 'ldap_explode_group() ei toeta valitud kasutajatüüpi: {$a}';
$string['extcourseidinvalid'] = 'Kursuse väline ID ei sobi.';
$string['extremovedsuspend'] = 'Keelatud kasutaja {$a->user_username} registreerimine kursusele {$a->course_shortname} (ID {$a->course_id})';
$string['extremovedsuspendnoroles'] = 'Eemaldatud rollid ja keelatud kasutaja {$a->user_username} registreerimine kursusele {$a->course_shortname} (ID {$a->course_id})';
$string['extremovedunenrol'] = 'Tühista kasutaja {$a->user_username} registreerumine kursusele {$a->course_shortname} (ID {$a->course_id})';
$string['failed'] = 'Nurjus';
$string['general_options'] = 'Üldised valikud';
$string['group_memberofattribute'] = 'Selle atribuudi nimi, mis määrab, millistesse rühmadesse vastav kasutaja või rühm kuulub (nt memberOf, groupMembership jne).';
$string['group_memberofattribute_key'] = 'Liikmesuse atribuut';
$string['host_url'] = 'Täpsusta LDAP host URL-vormis, näiteks „ldap://ldap.myorg.com/“ või „ldaps://ldap.myorg.com/“';
$string['host_url_key'] = 'Hosti URL';
$string['idnumber_attribute'] = 'Kui rühma liikmesus sisaldab eraldi nimesid, määrake sama atribuut, mida kasutate LDAP autentimissätetes kasutaja ID-numbri vastendusena';
$string['idnumber_attribute_key'] = 'ID-numbri atribuut';
$string['ldap:manage'] = 'LDAP registreerimiseksemplaride haldamine';
$string['ldap_encoding'] = 'Saate määrata kodeeringu, mida LDAP-server kasutab. Kõige tõenäolisemalt on see utf-8, MS AD v2 kasutab platvormi vaikekodeeringut, nt cp1252, cp1250 jne.';
$string['ldap_encoding_key'] = 'LDAP kodeering';
$string['memberattribute'] = 'LDAP liikmesuse atribuut';
$string['memberattribute_isdn'] = 'Kui rühma liikmesus sisaldab eraldi nimesid, peate selle siin määrama. Kui jah, peate selles jaotises konfigureerima ka ülejäänud sätted.';
$string['memberattribute_isdn_key'] = 'Liikmesuse atribuut kasutab dn-i';
$string['nested_groups'] = 'Kas soovite registreerimisel kasutada pesastatud rühmi (rühmade rühmi)?';
$string['nested_groups_key'] = 'Pesastatud rühmad';
$string['nested_groups_settings'] = 'Pesastatud rühmade sätted';
$string['nosuchrole'] = 'Sellist rolli \'{$a}\' ei eksisteeri';
$string['objectclass'] = 'objectClass, mida kasutatakse kursuste otsimiseks. Tavaliselt „group“ või „posixGroup“.';
$string['objectclass_key'] = 'Objekti klass';
$string['ok'] = 'OK';
$string['opt_deref'] = 'Kui rühma liikmesus sisaldab eraldi nimesid, määrake, kuidas töödeldakse otsingu käigus pseudonüüme. Valige üks nendest väärtustest: „Ei“ (LDAP_DEREF_NEVER) või „Jah“ (LDAP_DEREF_ALWAYS)';
$string['opt_deref_key'] = 'Tühista aliaste suunamine';
$string['phpldap_noextension'] = '<em>Paistab, et PHP LDAP-moodulit pole. Kui soovite seda kursusele registreerumise lisandmoodulit kasutada, siis veenduge, et see oleks installitud ja sisse lülitatud.</em>';
$string['pluginname'] = 'LDAP-registreerumised';
$string['pluginname_desc'] = '<p>Kursustele registreerumiste haldamiseks saate kasutada LDAP-serverit. Eeldatakse, et teie LDAP-puu sisaldab rühmi, mis vastavad kursustele, ja igaühel neist rühmadest/kursustest on olemas liikmekirjed, mis vastavad õppijatele.</p><p>Eeldatakse, et LDAP-s on kursused määratletud rühmadena ja igal rühmal on liikmeväljad (<em>member</em> või <em>memberUid</em>), mis sisaldavad kasutaja kordumatut ID-d.</p><p>Selleks, et kursustele registreerumiseks LDAP-d kasutada, <strong>peab</strong> kasutajatel olema sobiv ID-numbri väli. Kasutaja kursusele registreerimiseks peab LDAP rühmade liikmeväljadel olema see ID-number. Tavaliselt toimib see hästi, kui te juba kasutate LDAP-autentimist.</p><p>Kursustele registreerumised värskendatakse, kui kasutaja sisse logib. Registreerumiste sünkroonimiseks saab kasutada ka skripti. Vt <em>enrol/ldap/enrol_ldap_sync.php</em>.</p><p>Selle lisandmooduli saab seadistada ka automaatselt uusi kursusi looma, kui LDAP-sse lisatakse uusi rühmi.</p>';
$string['pluginnotenabled'] = 'Lisandmoodul pole lubatud.';
$string['privacy:metadata'] = 'LDAP enrolments plugin ei salvesta isikuandmeid.';
$string['role_mapping'] = '<p>Iga rolli puhul, mille soovite LDAP-st määrata, peate määrama kontekstide loendi, kust rolli kursuste rühmi otsitakse. Eraldage erinevad kontekstid semikooloniga \';\'.</p><p>Samuti peate määrama atribuudi, mida teie LDAP-server kasutab rühma liikmete säilitamiseks. Tavaliselt on see „member“ või „memberUid“</p>';
$string['role_mapping_attribute'] = 'Üksuse {$a} LDAP liikmesuse atribuut';
$string['role_mapping_context'] = 'Üksuse {$a} LDAP kontekstid';
$string['role_mapping_key'] = 'Rollide vastendamine LDAP-st';
$string['roles'] = 'Rollivastendus';
$string['server_settings'] = 'LDAP-serveri sätted';
$string['synccourserole'] = '== Kursuse {$a->idnumber} sünkroonimine rolli {$a->role_shortname} jaoks';
$string['syncenrolmentstask'] = 'Sünkrooni kursustele registreerumiste toiming';
$string['template'] = 'Valikuline: automaatselt loodud kursused saavad oma sätted kopeerida mallkursusest';
$string['template_key'] = 'Mall';
$string['unassignrole'] = 'Rolli eemaldamine \'{$a->role_shortname}\' kasutajalt \'{$a->user_username}\' kursusel\'{$a->course_shortname}\' (id {$a->course_id})';
$string['unassignrolefailed'] = 'Rolli \'{$a->role_shortname}\' eemaldamine kasutajalt \'{$a->user_username}\' kursusel \'{$a->course_shortname}\' (id {$a->course_id}) ebaõnnestus';
$string['unassignroleid'] = 'Rolli ID omistamine \'{$a->role_id}\' kasutaja ID-le\'{$a->user_id}\'';
$string['updatelocal'] = 'Uuenda lokaalseid andmeid';
$string['user_attribute'] = 'Kui rühma liikmesus sisaldab eraldi nimesid, määrake atribuut, mida kasutatakse kasutajate nime määramisel/otsimisel. Kui kasutate LDAP-autentimist, peab see väärtus vastama LDAP-autentimise lisandmooduli vastenduses „ID Number“ määratud atribuudile';
$string['user_attribute_key'] = 'ID-numbri atribuut';
$string['user_contexts'] = 'Kui rühma liikmesus sisaldab eraldi nimesid, määrake loend kontekstidest, kust kasutajaid otsitakse. Eraldage erinevad kontekstid semikooloniga \';\'. Näiteks: \'ou=users,o=org; ou=others,o=org\\';
$string['user_contexts_key'] = 'Kontekstid';
$string['user_search_sub'] = 'Kui rühma liikmesus sisaldab eraldi nimesid, määrake, kas kasutajaid otsitakse ka allkontekstidest';
$string['user_search_sub_key'] = 'Otsi alamkontekste';
$string['user_settings'] = 'Kasutaja otsimise seaded';
$string['user_type'] = 'Kui rühma liikmesus sisaldab eraldi nimesid, määrake, kuidas kasutajad salvestatakse LDAP-sse';
$string['user_type_key'] = 'Kasutaja tüüp';
$string['version'] = 'Teie serveri LDAP protokolli versioon';
$string['version_key'] = 'Versioon';
