<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_xmldb', language 'cs', version '4.4'.
 *
 * @package     tool_xmldb
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actual'] = 'Aktuální';
$string['addpersistent'] = 'Přidat povinné trvalé pole';
$string['aftertable'] = 'Za tabulkou:';
$string['back'] = 'Zpět';
$string['backtomainview'] = 'Zpět na hlavní stránku';
$string['cannotuseidfield'] = 'Nelze vložit pole "id", jeho hodnota se přiřazuje automaticky';
$string['change'] = 'Změnit';
$string['charincorrectlength'] = 'Nesprávná délka znakového pole';
$string['check_bigints'] = 'Vyhledat v DB nesprávný typ celočíselných polí';
$string['check_defaults'] = 'Vyhledat nekonzistentní výchozí hodnoty';
$string['check_foreign_keys'] = 'Vyhledat narušené cizí klíče';
$string['check_indexes'] = 'Vyhledat v DB chybějící indexy';
$string['check_oracle_semantics'] = 'Vyhledat chybné délky sémantik';
$string['checkbigints'] = 'Kontrola celého čísla';
$string['checkdefaults'] = 'Kontrola výchozích hodnot';
$string['checkforeignkeys'] = 'Kontrola cizích klíčů';
$string['checkindexes'] = 'Kontrola indexů';
$string['checkoraclesemantics'] = 'Kontrola sémantiky';
$string['completelogbelow'] = '(viz dále výslednou zprávu o hledání)';
$string['confirmcheckbigints'] = 'Tato funkce vyhledá na vašem serveru Moodle <a href="https://tracker.moodle.org/browse/MDL-11038"> potenciální nesprávná celočíselná pole </a>i a vygeneruje (ale nespustí!) SQL příkazy, aby byly všechna celá čísla v databázi správně definována.

Po vygenerování můžete tyto příkazy zkopírovat a bezpečně je spustit pomocí vašeho oblíbeného rozhraní SQL (před tím nezapomeňte zálohovat svá data).

Výrazně se doporučuje spustit tuto funkci nesprávných polí až po upgrade na poslední stabilní verzi (označované jako "+" verze) vámi používané řady.

Tato funkce žádným způsobem nemění obsah databáze, pouze z ní čte data, takže může být bezpečně prováděna v každém okamžiku.';
$string['confirmcheckdefaults'] = 'Tato funkce vyhledá nekonzistentní výchozí hodnoty ve vaší Moodle databázi a vygeneruje (ale nespustí!) SQL příkazy pro jejich vytvoření.<br />

Po vytvoření můžete kopírovat taková prohlášení a spouštět je bezpečně u vašeho oblíbeného SQL rozhraní (nezapomeňte zálohovat svá data před tím, že).

Výrazně se doporučuje spustit tuto funkci hledání nekonzistentních výchozích hodnot až po upgrade na poslední stabilní verzi (označované jako "+" verze) vámi používané řady.

Tato funkce žádným způsobem nemění obsah databáze, pouze z ní čte data, takže může být bezpečně prováděna v každém okamžiku.';
$string['confirmcheckforeignkeys'] = 'Tato funkce bude hledat potenciální porušení externích klíčů definovaných v definicích souboru install.xml (Moodle momentálně negeneruje žádné externí klíče v databázi, proto se mohou vyskytovat neplatná data.)

Zvláště se doporučuje, abyste používal nejnovější dostupnou (+verzi) vašeho vydání Moodle dříve, než spustíte vyhledávání potencionálně porušených cizích klíčů.

Tato funkce nevykonává žádnou činnost nad databázi (pouze z ní čte), takže ji lze bezpečně spustit kdykoliv.';
$string['confirmcheckindexes'] = 'Tato funkce vyhledá chybějící indexy ve vaší Moodle databázi a vygeneruje (ale nespustí!) SQL příkazy pro jejich vytvoření.<br />

Po vytvoření můžete kopírovat taková prohlášení a spouštět je bezpečně u vašeho oblíbeného SQL rozhraní (nezapomeňte zálohovat svá data před tím, že).

Výrazně se doporučuje spustit tuto funkci  hledání chybějících indexů až po upgrade na poslední stabilní verzi (označované jako "+" verze) vámi používané řady.

Tato funkce žádným způsobem nemění obsah databáze, pouze z ní čte data, takže může být bezpečně prováděna v každém okamžiku.';
$string['confirmcheckoraclesemantics'] = 'Tato funkce bude hledat <a href="https://tracker.moodle.org/browse/MDL-29322">Oracle varchar2 sloupce, které používají BYTE sémantiku</a> na vašem Moodle serveru, vytvářejíc (ale nevykonávajíc!) automaticky potřebné SQL příkazy na konverzi všech sloupců tak, aby namísto toho používaly CHAR sémantiku (lepší pro mezi-databázovou kompatibilitu a větší maximální délku obsahu).

Po vygenerování můžete tyto příkazy zkopírovat a bezpečně je spustit pomocí vašeho oblíbeného rozhraní SQL (před tím nezapomeňte zálohovat svá data).

Zvláště se doporučuje, abyste používal nejnovější dostupnou (+verzi) vašeho vydání Moodle dříve, než spustíte vyhledávání BYTE sémantiky.

Tato funkce nevykonává žádnou činnost na databázi (pouze z ní čte), takže ji lze bezpečně spustit kdykoliv.';
$string['confirmdeletefield'] = 'Jste si úplně jisti, že chcete odstranit pole:';
$string['confirmdeleteindex'] = 'Jste si úplně jisti, že chcete odstranit index:';
$string['confirmdeletekey'] = 'Jste si úplně jisti, že chcete odstranit klíč:';
$string['confirmdeletetable'] = 'Jste si úplně jisti, že chcete odstranit tabulku:';
$string['confirmdeletexmlfile'] = 'Jste si úplně jisti, že chcete odstranit soubor:';
$string['confirmrevertchanges'] = 'Jste si úplně jisti, že chcete vrátit provedené změny:';
$string['create'] = 'Vytvořit';
$string['createtable'] = 'Vytvořit tabulku:';
$string['defaultincorrect'] = 'Nesprávná výchozí hodnota:';
$string['delete'] = 'Odstranit';
$string['delete_field'] = 'Odstranit pole';
$string['delete_index'] = 'Odstranit index';
$string['delete_key'] = 'Odstranit klíč';
$string['delete_table'] = 'Odstranit tabulku';
$string['delete_xml_file'] = 'Odstranit XML soubor';
$string['doc'] = 'Dokumentace';
$string['docindex'] = 'Index dokumentace:';
$string['documentationintro'] = 'Tato dokumentace je automaticky generována z definice XMLDB databáze. Je dostupná pouze v angličtině.';
$string['down'] = 'Dolů';
$string['duplicate'] = 'Duplikovat';
$string['duplicatefieldname'] = 'Již existuje pole s tímto názvem';
$string['duplicatefieldsused'] = 'Duplicitní používané pole';
$string['duplicateindexname'] = 'Duplicitní název indexu';
$string['duplicatekeyname'] = 'Již existuje klíč s tímto názvem';
$string['duplicatetablename'] = 'Již existuje tabulka s tímto názvem';
$string['edit'] = 'Upravit';
$string['edit_field'] = 'Upravit pole';
$string['edit_field_save'] = 'Uložit pole';
$string['edit_index'] = 'Upravit index';
$string['edit_index_save'] = 'Uložit index';
$string['edit_key'] = 'Upravit klíč';
$string['edit_key_save'] = 'Uložit klíč';
$string['edit_table'] = 'Upravit tabulku';
$string['edit_table_save'] = 'Uložit tabulku';
$string['edit_xml_file'] = 'Upravit XML soubor';
$string['enumvaluesincorrect'] = 'Nesprávné hodnoty pro výčtové pole';
$string['expected'] = 'Očekáváno';
$string['extensionrequired'] = 'Promiňte - na tuto činnost je nutné rozšíření PHP "{$a}". Jestliže tuto vlastnost potřebujete, rozšíření nainstalujte.';
$string['extraindexesfound'] = 'Byly nalezeny další indexy';
$string['field'] = 'Pole';
$string['fieldnameempty'] = 'Prázdný název pole';
$string['fields'] = 'Pole';
$string['fieldsnotintable'] = 'Pole v tabulce neexistuje';
$string['fieldsusedinindex'] = 'Toto pole je použito jako index';
$string['fieldsusedinkey'] = 'Toto pole je použité jako klíč.';
$string['filemodifiedoutfromeditor'] = 'UPOZORNĚNÍ: Soubor byl lokálně změněn použitím XMLDB editoru. Uložení přepíše lokální změny.';
$string['filenotwriteable'] = 'Do pole nelze zapisovat';
$string['fkunknownfield'] = 'Externí klíč {$a->keyname} v tabulce {$a->tablename} ukazuje na neexistující pole {$a->reffield} v tabulce odkazů {$a->reftable}.';
$string['fkunknowntable'] = 'Externí klíč {$a->keyname} v tabulce {$a->tablename} ukazuje na neexistující tabulku {$a->reftable}.';
$string['fkviolationdetails'] = 'Cizí klíč{$a->keyname} v tabulce {$a->tablename} je porušený v počtu {$a->numviolations} z celkového počtu řádků: {$a->numrows} ';
$string['float2numbernote'] = 'Poznámka: Ačkoli pole typu "float" jsou podporována na 100% přes XMLDB, doporučujeme je změnit na pole typu "number".';
$string['floatincorrectdecimals'] = 'Nesprávný počet desetinných čísel v poli s plovoucí čárkou';
$string['floatincorrectlength'] = 'Nesprávná délka pole s plovoucí desetinnou čárkou';
$string['generate_all_documentation'] = 'Celá dokumentace';
$string['generate_documentation'] = 'Dokumentace';
$string['gotolastused'] = 'Jdi k posledně použitému souboru';
$string['incorrectfieldname'] = 'Nesprávný název';
$string['incorrectindexname'] = 'Nesprávné název indexu';
$string['incorrectkeyname'] = 'Nesprávné jméno klíče';
$string['incorrecttablename'] = 'Nesprávný název tabulky';
$string['index'] = 'Index';
$string['indexes'] = 'Indexy';
$string['indexnameempty'] = 'Jméno indexu je prázdné';
$string['integerincorrectlength'] = 'Nesprávná délka celočíselného pole';
$string['key'] = 'Klíč';
$string['keynameempty'] = 'Jméno klíče nesní být prázdné';
$string['keys'] = 'Klíče';
$string['listreservedwords'] = 'Seznam rezerovaných slov<br />(používá se k aktualizaci stránky <a href="https://docs.moodle.org/en/XMLDB_reserved_words" target="_blank">XMLDB_reserved_words</a>)';
$string['load'] = 'Nahrát';
$string['main_view'] = 'Hlavní pohled';
$string['masterprimaryuniqueordernomatch'] = 'Pole ve vašem cizím klíči musí být uvedeno ve stejném pořadí, v jakém jsou v UNIQUE KEY v uvedené tabulce.';
$string['missing'] = 'Chybí';
$string['missingindexes'] = 'Nalezeny chybějící indexy';
$string['mustselectonefield'] = 'Musíte vybrat jedno pole, abyste viděli související akce.';
$string['mustselectoneindex'] = 'Musíte vybrat jeden index, abyste viděli související akce.';
$string['mustselectonekey'] = 'Musíte vybrat klíč, abyste viděli související akce.';
$string['new_table_from_mysql'] = 'Nová tabulka z MySQL';
$string['newfield'] = 'Nové pole';
$string['newindex'] = 'Nový index';
$string['newkey'] = 'Nový klíč';
$string['newtable'] = 'Nová tabulka';
$string['newtablefrommysql'] = 'Nová tabulka z MySQL';
$string['nofieldsspecified'] = 'Nebyla určena pole';
$string['nomasterprimaryuniquefound'] = 'Sloupce s odkazy externích klíčů musí být obsaženy v primárním nebo jedinečném klíči KEY v tabulce odkazů. Všimněte si, že sloupec, který je v indexu UNIQUE INDEX, není dost dobrý.';
$string['nomissingorextraindexesfound'] = 'Nebyly nalezeny žádné chybějící nebo extra indexy, takže není nutná žádná další akce.';
$string['noreffieldsspecified'] = 'Nejsou určeny žádná pole odkazů';
$string['noreftablespecified'] = 'Určená tabulka odkazů nebyla nalezena';
$string['noviolatedforeignkeysfound'] = 'Nebyly nalezeny žádné porušené cizí klíče';
$string['nowrongdefaultsfound'] = 'Nebyly nalezeny žádné nekonzistentní definice výchozích hodnot. Není potřeba dalších oprav databáze.';
$string['nowrongintsfound'] = 'Nebyly nalezeny problémy v definici celočíselných polí. Není potřeba dalších oprav databáze.';
$string['nowrongoraclesemanticsfound'] = 'Žádné Oracle sloupce s využitím BYTE sémantiky nebyly nalezeny, vaše databáze nepotřebuje žádné další akce.';
$string['numberincorrectdecimals'] = 'Nesprávný počet desetinných čísel v číselném poli';
$string['numberincorrectlength'] = 'Nesprávná délka číselného pole';
$string['numberincorrectwholepart'] = 'Příliš velké celé číslo pro pole čísel';
$string['pendingchanges'] = 'Poznámka: V tomto souboru jste provedl změny. Můžete je kdykoliv uložit.';
$string['pendingchangescannotbesaved'] = 'V tomto souboru byly provedeny změny, ale nelze je uložit!. Ověřte prosím, zda adresář a v něm soubor install.xml, zdá mají oprávnění k zápisování pro tento webový server.';
$string['pendingchangescannotbesavedreload'] = 'Změny v tomto souboru nelze uložit! Ověřte prosím, zda adresář a v něm soubor install.xml, mají oprávnění k zapisování pro tento webový server. Potom znovu nahrajte tuto stránku a mělo by se vám povést tyto změny uložit.';
$string['persistentfieldscomplete'] = 'Byly přidány následující pole:';
$string['persistentfieldsconfirm'] = 'Chcete přidat následující pole:';
$string['persistentfieldsexist'] = 'Následující pole již existují:';
$string['pluginname'] = 'editor XMLDB';
$string['primarykeyonlyallownotnullfields'] = 'Primární klíč nemůže být nulový (null)';
$string['privacy:metadata'] = 'Modul Editor XMLDB neukládá žádné osobní údaje.';
$string['reconcile_files'] = 'Vyhledat soubory XMLDB, které vyžadují sladění';
$string['reconcile_files_intro'] = 'Tato funkce prohlíží obsah všech souborů XMLDB, aby ověřila, že odpovídají výsledkům jejich generování z editoru XMLDB.

Zobrazí se seznam souborů, které je třeba sladit (regenerovat), a k jejich opravě by měl být použit XMLDB Editor.';
$string['reconcile_files_no'] = 'Všechny soubory jsou v pořádku. Není potřeba žádné sladění.';
$string['reconcile_files_yes'] = 'Nalezené soubory k odsouhlasení:';
$string['reconcilefiles'] = 'Sladit soubory XMLDB';
$string['reserved'] = 'Rezervováno';
$string['reservedwords'] = 'Rezervováná slova';
$string['revert'] = 'Vrátit';
$string['revert_changes'] = 'Vrátit změny';
$string['save'] = 'Uložit';
$string['searchresults'] = 'Výsledky hledání';
$string['selectaction'] = 'Výběr akce:';
$string['selectdb'] = 'Výběr databáze:';
$string['selectfieldkeyindex'] = 'Výběr pole/klíče/indexu:';
$string['selectonecommand'] = 'Vyberte jednu z akcí ze seznamu k zobrazení kódu PHP';
$string['selectonefieldkeyindex'] = 'Vyberte jedno z polí/klíčů/indexů ze seznamu k zobrazení kódu PHP';
$string['selecttable'] = 'Výběr tabulky:';
$string['table'] = 'Tabulka';
$string['tablenameempty'] = 'Název tabulky nemůže být prázdný';
$string['tables'] = 'Tabulky';
$string['unknownfield'] = 'Odkazuje na neznámé pole';
$string['unknowntable'] = 'Odkazuje na neznámou tabulku';
$string['unload'] = 'Zavřít';
$string['up'] = 'Nahoru';
$string['view'] = 'Zobrazit';
$string['view_reserved_words'] = 'Zobrazit rezervovaná slova';
$string['view_structure_php'] = 'Zobrazit strukturu PHP';
$string['view_structure_sql'] = 'Zobrazit strukturu SQL';
$string['view_table_php'] = 'Zobrazit tabulku PHP';
$string['view_table_sql'] = 'Zobrazit tabulku SQL';
$string['viewedited'] = 'Zobrazit upravenou';
$string['vieworiginal'] = 'Zobrazit originální';
$string['viewphpcode'] = 'Zobrazit kód PHP';
$string['viewsqlcode'] = 'Zobrazit kód SQL';
$string['viewxml'] = 'XML';
$string['violatedforeignkeys'] = 'Porušené cizí klíče';
$string['violatedforeignkeysfound'] = 'Byly nalezeny porušené cizí klíče';
$string['violations'] = 'Porušené integritní omezení';
$string['wrong'] = 'Chyby';
$string['wrongdefaults'] = 'Nalezeny chybné výchozí hodnoty';
$string['wrongints'] = 'Nalezeny problémy v definici celočíselných polí';
$string['wronglengthforenum'] = 'Nesprávná délka výčtového pole';
$string['wrongnumberofreffields'] = 'Špatné číslo odkazovaného pole';
$string['wrongoraclesemantics'] = 'Byla nalezena zlá Oracle BYTE sémantika';
$string['wrongreservedwords'] = 'Stávající rezervovaná slova<br />(názvy tabulek nehrajou roli, pokud používáte $CFG->prefix)';
$string['yesextraindexesfound'] = 'Byly nalezeny následující další indexy.';
$string['yesmissingindexesfound'] = 'Ve vaší databázi byly nalezeny chybějící indexy. Následují bližší informace a potřebné SQL příkazy k jejich vytvoření. Před spuštěním těchto příkazů ve vašem oblíbeném SQL klientovi si nezapomeňte vytvořit zálohu celé databáze.<br /><br />Pro jistotu doporučujeme, abyste po provedení uvedených SQL příkazů spustili tuto kontrolu znovu.';
$string['yeswrongdefaultsfound'] = 'Ve vaší databázi byly nalezeny nekonzistentní výchozí hodnoty u některých atributů. Následují bližší informace a potřebné SQL příkazy k jejich korekci. Před spuštěním těchto příkazů ve vašem oblíbeném SQL klientovi si nezapomeňte vytvořit zálohu celé databáze.<br /><br />Pro jistotu doporučujeme, abyste po provedení uvedených SQL příkazů spustili tuto kontrolu znovu.';
$string['yeswrongintsfound'] = 'Ve vaší databázi byly nalezeny nesprávné typy některých celočíselných atributů. Následují bližší informace a potřebné SQL příkazy ke korektní opravě vašich tabulek. Před spuštěním těchto příkazů ve vašem oblíbeném SQL klientovi si nezapomeňte vytvořit zálohu celé databáze.<br /><br />Pro jistotu doporučujeme, abyste po provedení uvedených SQL příkazů spustili tuto kontrolu znovu, aby se zkontrolovalo, zda se nenaleznou žádná další nesprávné typy.';
$string['yeswrongoraclesemanticsfound'] = '<p>Ve vašem DB byly nalezeny některé sloupce Oracle používající sémantiku BYTE. Zde jsou jejich podrobnosti a potřebné SQL příkazy, které mají být spuštěny ve vašem oblíbeném SQL rozhraní a převést je všechny. Nezapomeňte nejdříve udělat zálohu vašich dat!</p> <p>Poté, co to uděláte, je doporučeno provést tento nástroj znovu, abyste zjistili, že nejsou nalezeny žádné další chybné sémantiky.</p>';
