<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'auth_saml2', language 'cs', version '4.4'.
 *
 * @package     auth_saml2
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['allowcreate'] = 'Povolit vytváření';
$string['allowcreate_help'] = 'Povolit vytváření IdP uživatelů na vyžádání';
$string['alterlogout'] = 'Alternativní URL pro odhlášení';
$string['alterlogout_help'] = 'Adresa URL pro přesměrování uživatele po spuštění všech interních mechanismů odhlášení';
$string['anyauth'] = 'Povolen jakýkoli typ ověření';
$string['anyauth_help'] = 'Ano: Povolit přihlášení SAML pro všechny uživatele?  Ne: Pouze uživatelé, kteří mají jako typ saml2.';
$string['anyauthotherdisabled'] = 'Úspěšně jste se přihlásili jako \'{$a->username}\', ale váš typ ověření \'{$a->auth}\' je zakázán.';
$string['assertionsconsumerservices'] = 'Potvrzení spotřebitelských služeb';
$string['assertionsconsumerservices_help'] = 'Seznam vazeb, které by měl SP podporovat';
$string['attemptsignout'] = 'Pokusit se odhlásit IdP';
$string['attemptsignout_help'] = 'Toto se pokusí komunikovat s IdP a odeslat žádost o odhlášení';
$string['attrsimple'] = 'Zjednodušte atributy';
$string['attrsimple_help'] = 'Různí IdP, jako je ADFS, používají dlouhé klíče atributů, jako jsou urny nebo názvy xml schémat s prostorem názvů.  Pokud je nastaveno na Ano, zjednoduší se to, např. namapujte http://schemas.xmlsoap.org/ws/2005/05/identity/claims/givenname na takové \'givenname\'.';
$string['auth_data_mapping'] = 'Mapování dat';
$string['auth_fieldlock_expl'] = '<p><b>Hodnota zámku:</b> Je-li povoleno, zabrání uživatelům a administrátorům Moodle přímo upravovat pole.  Tuto volbu použijte, pokud tato data udržujete v externím autentizačním systému.  </p>';
$string['auth_fieldlockfield'] = 'Zamknout hodnotu ({$a})';
$string['auth_fieldlocks'] = 'Zamknout uživatelská pole';
$string['auth_fieldmapping'] = 'Mapování dat ({$a})';
$string['auth_saml2blockredirectdescription'] = 'Přesměrovat nebo zobrazit zprávu na přihlášení SAML2 na základě nakonfigurovaných skupinových omezení';
$string['auth_saml2description'] = 'Ověřit u poskytovatele identity SAML2 (IdP)';
$string['auth_updatelocalfield'] = 'Aktualizovat místní ({$a})';
$string['auth_updateremotefield'] = 'Aktualizovat externí ({$a})';
$string['authncontext'] = 'AuthnContext';
$string['authncontext_help'] = 'Umožňuje rozšíření tvrzení.  Pokud to není nutné, ponechte prázdné';
$string['autocreate'] = 'Automaticky vytvářet uživatele';
$string['autocreate_help'] = 'Povolit vytváření uživatelů Moodle na vyžádání';
$string['autologin'] = 'Automatické přihlášení';
$string['autologin_help'] = 'Na stránkách, které umožňují přístup hosta bez přihlášení, automaticky přihlašují uživatele do Moodle pomocí skutečného uživatelského účtu, pokud jsou přihlášeni k IdP (pomocí pasivního ověřování).';
$string['autologinbycookie'] = 'Zkontrolujte, kdy zadaný soubor cookie existuje nebo se mění';
$string['autologinbysession'] = 'Zkontrolovat jednou za relaci';
$string['autologincookie'] = 'Soubor cookie automatického přihlášení';
$string['autologincookie_help'] = 'Název souboru cookie použitý k rozhodnutí, kdy se pokusit o automatické přihlášení (relevantní pouze v případě, že je výše vybrána možnost cookie).';
$string['availableidps'] = 'Vybrat dostupné IdP';
$string['availableidps_help'] = 'Pokud XML metadat IdP obsahuje více entit IdP, budete muset vybrat, které entity jsou k dispozici
aby se uživatelé mohli přihlásit.';
$string['blockredirectheading'] = 'Akce blokování účtu';
$string['cannotmapfield'] = 'Byla zjištěna kolize mapování - dvě pole se mapují do stejné položky hodnocení {$a}';
$string['certificate'] = 'Obnovit certifikát';
$string['certificate_help'] = 'Znovu vygenerujte soukromý klíč a certifikát používaný tímto SP.  |  <a href=\'{$a}\'>Zobrazit certifikát SP</a>';
$string['certificatedetails'] = 'Podrobnosti certifikátu';
$string['certificatedetailshelp'] = '<h1>Automaticky generovaný obsah veřejného certifikátu SAML2</h1><p>Cesta k certifikátu je zde:</p>';
$string['certificatelock'] = 'Zamknout certifikát';
$string['certificatelock_help'] = 'Zamknutí certifikátů zabrání jejich přepsání po vygenerování.';
$string['certificatelock_locked'] = 'Certifikát je uzamčen';
$string['certificatelock_lockedmessage'] = 'Certifikáty jsou aktuálně uzamčeny.';
$string['certificatelock_regenerate'] = 'Neobnovuji certifikáty, protože byly uzamčeny!';
$string['certificatelock_unlock'] = 'Odemknout certifikáty';
$string['certificatelock_warning'] = 'Upozornění.  Chystáte se uzamknout certifikáty, jste si jisti, že to chcete provést?  <br> Certifikáty nejsou aktuálně uzamčeny';
$string['checkcertificateexpired'] = 'Platnost certifikátu SAML vypršela před {$a}';
$string['checkcertificateexpiry'] = 'Platnost certifikátu SAML vyprší';
$string['checkcertificateok'] = 'Platnost certifikátu SAML vyprší za {$a}';
$string['checkcertificatewarn'] = 'Platnost certifikátu SAML vyprší za {$a}';
$string['commonname'] = 'Běžný název';
$string['countryname'] = 'Země';
$string['debug'] = 'Ladění';
$string['debug_help'] = '<p>Toto přidává další ladění do normálního logu moodle |  <a href=\'{$a}\'>Zobrazit konfiguraci SSP</a></p>';
$string['duallogin'] = 'Duální přihlášení';
$string['duallogin_help'] = '<p>Je-li zapnuto, uživatelé uvidí tlačítko pro ruční přihlášení a přihlášení do SAML.  Pokud je vypnuto, budou vždy přesměrovány přímo na přihlašovací stránku IdP.</p>
<p>Pokud je pasivní, pak uživatelé, kteří jsou již autentizováni do IDP, budou automaticky přihlášeni, jinak budou přesměrováni na přihlašovací stránku Moodle.</p>
<p>Pokud je vypnuto, administrátoři mohou stále vidět stránku ručního přihlášení přes /login/index.php?saml=off</p>
<p>Pokud je zapnuto, pak externí stránky mohou hluboce odkazovat na moodle pomocí saml, např. /course/view.php?id=45&saml=on</p>';
$string['emailtaken'] = 'Nelze vytvořit nový účet, protože {$a} e-mailová adresa je již zaregistrována';
$string['emailtakenupdate'] = 'Váš e-mail nebyl aktualizován, protože e-mailová adresa {$a} je již zaregistrována';
$string['error'] = 'Chyba přihlášení';
$string['errorinvalidautologin'] = 'Neplatný požadavek na automatické přihlášení';
$string['errorparsingxml'] = 'Chyba při analýze XML: {$a}';
$string['exception'] = 'Výjimka SAML2: {$a}';
$string['expirydays'] = 'Vypršení ve dnech';
$string['fielddelimiter'] = 'Oddělovač polí';
$string['fielddelimiter_help'] = 'Oddělovač, který se má použít, když pole obdrží pole hodnot od IdP.';
$string['flaggedresponsetypemessage'] = 'Zobrazit vlastní zprávu';
$string['flaggedresponsetyperedirect'] = 'Přesměrování na externí URL';
$string['flagmessage'] = 'Zpráva s odpovědí';
$string['flagmessage_default'] = 'Jste přihlášeni ke svému poskytovateli identity, ale tento účet má omezený přístup k Moodle, kontaktujte prosím svého administrátora pro více podrobností.';
$string['flagmessage_help'] = '<p>Zpráva, která se zobrazí, když uživatel nemá povolen přístup k Moodle na základě nakonfigurovaných skupinových omezení.</p>
<p>(Zobrazí se pouze v případě, že \'Typ odpovědi\' je \'Zobrazit vlastní zprávu\'.)</p>';
$string['flagredirecturl'] = 'Adresa URL přesměrování';
$string['flagredirecturl_help'] = '<p>Adresa URL pro přesměrování uživatele nemá povolen přístup k Moodle na základě nakonfigurovaných skupinových omezení.</p>
<p>(Pouze v případě, že \'Typ odpovědi\' je \'Přesměrovat na externí URL\'.)</p>';
$string['flagresponsetype'] = 'Typ odpovědi na blokování účtu';
$string['flagresponsetype_help'] = 'Pokud je přístup blokován na základě nakonfigurovaných skupinových omezení, jak by měl Moodle reagovat?';
$string['grouprules'] = 'Pravidla skupiny';
$string['grouprules_help'] = '<p>Seznam pravidel pro řízení přístupu na základě hodnoty atributu skupiny.</p>
<p>Každý řádek by měl mít jedno pravidlo ve formátu: {allow or deny} {groups atribut}={value}.</p>
<p>První bude použito pravidlo výše v seznamu.</p>
Příklad: <br/>
povolit správcům=ano<br>
odepřít administrátory=ne<br>
povolit examrole=proctor<br>
odepřít knihovnu=po splatnosti<br>';
$string['idpattr'] = 'Mapování IdP';
$string['idpattr_help'] = 'Který atribut IdP by měl být porovnán s uživatelským polem Moodle?';
$string['idpmetadata'] = 'IdP metadata xml NEBO veřejná xml URL';
$string['idpmetadata_badurl'] = 'Neplatná metadata na {$a}';
$string['idpmetadata_help'] = 'Chcete-li použít více IdP, zadejte každou veřejnou metadatovou adresu URL na nový řádek.<br/>Chcete-li přepsat název, umístěte text před http.  např.  "Vynucený název IdP http://ssp.local/simplesaml/saml2/idp/metadata.php"';
$string['idpmetadata_invalid'] = 'IdP XML není platné';
$string['idpmetadata_noentityid'] = 'IdP XML nemá ID entity';
$string['idpmetadatarefresh'] = 'Obnovení metadat IdP';
$string['idpmetadatarefresh_help'] = 'Spustit naplánovanou úlohu pro aktualizaci metadat IdP z adresy URL metadat IdP';
$string['idpname'] = 'Přepsání štítku IdP';
$string['idpname_help'] = 'např. myUNI - toto je detekováno z metadat a zobrazí se na stránce duálního přihlášení (pokud je povoleno)';
$string['idpnamedefault'] = 'Přihlášení přes SAML2';
$string['idpnamedefault_varaible'] = 'Přihlášení přes SAML2 ({$a})';
$string['localityname'] = 'Lokalita';
$string['locked'] = 'Zamčeno';
$string['logdir'] = 'Adresář protokolu';
$string['logdir_help'] = 'Do adresáře log SSPHP bude zapisovat, soubor se bude jmenovat simplesamlphp.log';
$string['logdirdefault'] = '/tmp/';
$string['logtofile'] = 'Povolit protokolování do souboru';
$string['logtofile_help'] = 'Zapnutím bude přesměrován výstup protokolu SSPHP do souboru v adresáři logdir';
$string['manageidpsheading'] = 'Spravovat dostupné poskytovatele identity (IdP)';
$string['mdlattr'] = 'Mapování Moodle';
$string['mdlattr_help'] = 'Kterému uživatelskému poli Moodle má být přiřazen atribut IdP?';
$string['metadatafetchfailed'] = 'Načtení metadat se nezdařilo: {$a}';
$string['metadatafetchfailedstatus'] = 'Načtení metadat se nezdařilo: Stavový kód {$a}';
$string['metadatafetchfailedunknown'] = 'Načítání metadat se nezdařilo: Neznámá chyba cURL';
$string['multiidp:label:active'] = 'Aktivní';
$string['multiidp:label:admin'] = 'Pouze pro administrátory';
$string['multiidp:label:admin_help'] = 'Všichni uživatelé, kteří se přihlásí pomocí tohoto IdP, se automaticky stanou administrátory stránek';
$string['multiidp:label:alias'] = 'Alias';
$string['multiidp:label:defaultidp'] = 'Výchozí IdP';
$string['multiidp:label:displayname'] = 'Zobrazované jméno';
$string['multiidp:label:whitelist'] = 'Přesměrované IP adresy';
$string['multiidp:label:whitelist_help'] = 'Pokud je nastaveno, přinutí klienty k tomuto IdP.  Formát: xxx.xxx.xxx.xxx/bitová maska.  Oddělte více podsítí na novém řádku.';
$string['multiidpbuttons'] = 'Tlačítka s ikonami';
$string['multiidpdisplay'] = 'Typ zobrazení více IdP';
$string['multiidpdisplay_help'] = 'Pokud xml metadat IdP obsahuje více entit IdP, jak se zobrazí každý dostupný IdP?';
$string['multiidpdropdown'] = 'Rozbalovací seznam';
$string['multiidpinfo'] = '<ul>
<li>IdP lze použít, pouze pokud je nastaven jako aktivní</li>
<li>Když je duální přihlášení zapnuto, na přihlašovací stránce se zobrazí všichni aktivní IdP</li>
<li>Když je IdP nastaven jako výchozí a duální přihlášení není zapnuto, bude tento IdP automaticky použit, pokud není předáno ?multiidp=on nebo saml=off na /login/index.php</li>
<li>IdP lze přidělit alias, když přejdete na /login/index.php?idpalias={alias} alias lze předat přímo k použití tohoto IdP</li>
</ul>';
$string['nameidasattrib'] = 'Vystavit NameID jako atribut';
$string['nameidasattrib_help'] = 'Nárok NameID bude vystaven SSPHP jako atribut s názvem nameid';
$string['nameidpolicy'] = 'Zásady ID jmen';
$string['nameidpolicy_help'] = '';
$string['noattribute'] = 'Úspěšně jste se přihlásili, ale nemohli jsme najít váš atribut \'{$a}\', který by vás přiřadil k účtu v Moodle.';
$string['noidpfound'] = 'IdP \'{$a}\' nebyl nalezen jako nakonfigurovaný IdP.';
$string['noredirectips'] = 'Omezit noredirect podle IP';
$string['noredirectips_help'] = 'Když je duální přihlašování vypnuto a jsou nastaveny IP adresy, omezí to použití ?saml=off a ?noredirect=1 během přihlašování SAML na uživatele s odpovídajícími podsítěmi IP.';
$string['nouser'] = 'Úspěšně jste se přihlásili jako \'{$a}\', ale nemáte účet v Moodle.';
$string['nullprivatecert'] = 'Vytvoření soukromého certifikátu se nezdařilo.';
$string['nullpubliccert'] = 'Vytvoření veřejného certifikátu se nezdařilo.';
$string['organizationalunitname'] = 'Organizační jednotka';
$string['organizationname'] = 'Organizace';
$string['passivemode'] = 'Pasivní režim';
$string['phone1'] = 'Telefon';
$string['phone2'] = 'Mobilní telefon';
$string['plugindisabled'] = 'Plugin ověřování SAML2 je zakázán';
$string['pluginname'] = 'SAML2';
$string['privacy:no_data_reason'] = 'Autentizační plugin Saml2 neukládá žádná osobní data.';
$string['privatekeypass'] = 'Heslo klíče soukromého certifikátu';
$string['privatekeypass_help'] = 'Toto se používá pro podepisování lokálního certifikátu Moodle, změna tohoto certifikátu zruší platnost aktuálního certifikátu.';
$string['regenerate_submit'] = 'Obnovit';
$string['regenerateheader'] = 'Obnovit soukromý klíč a certifikát';
$string['regenerateheading'] = 'Obnovit soukromý klíč a certifikát';
$string['regeneratepath'] = 'Cesta k certifikátu: {$a}';
$string['regeneratesuccess'] = 'Soukromý klíč a certifikát úspěšně obnoveny';
$string['regeneratewarning'] = 'Upozornění!  Vygenerování nového certifikátu přepíše aktuální a možná budete muset aktualizovat své IDP';
$string['rememberidp'] = 'Zapamatovat přihlašovací službu';
$string['requestedattributes'] = 'Požadované atributy';
$string['requestedattributes_help'] = 'Někteří IdP potřebují, aby SP deklaroval, které atributy budou požadovány nebo jsou vyžadovány.  Přidejte každý atribut na nový řádek a budou uvedeny v metadatech SP pod značkou <code>AttributeConsumingService</code>.  Pokud chcete, aby bylo pole povinné, vložte za tento řádek mezeru a poté *.  {$a->example}';
$string['required'] = 'Toto pole je povinné';
$string['requireint'] = 'Toto pole je povinné a musí být kladné celé číslo';
$string['selectloginservice'] = 'Vyberte přihlašovací službu';
$string['sha1'] = 'Starší SHA1 (nebezpečné)';
$string['sha256'] = 'SHA256';
$string['sha384'] = 'SHA384';
$string['sha512'] = 'SHA512';
$string['showidplink'] = 'Zobrazit odkaz IdP';
$string['showidplink_help'] = 'Toto zobrazí odkaz na IdP, když je stránka nakonfigurována.';
$string['signaturealgorithm'] = 'Algoritmus podepisování';
$string['signaturealgorithm_help'] = 'Toto je algoritmus, který bude použit k podepisování požadavků SAML.  Varování: Algoritmus SHA1 je poskytován pouze pro zpětnou kompatibilitu, pokud jej nemusíte bezpodmínečně používat, doporučujeme se mu vyhnout a místo něj použít alespoň SHA256.';
$string['source'] = 'Zdroj: {$a}';
$string['spentityid'] = 'ID entity';
$string['spentityid_help'] = 'Přepsat ID entity poskytovatele služeb.  Ve většině případů ponechte prázdné a místo toho bude použito dobré výchozí nastavení.';
$string['spmetadata'] = 'SP Metadata';
$string['spmetadata_help'] = '<a href=\'{$a}\'>Zobrazit metadata poskytovatele služeb</a> |  <a href=\'{$a}?download=1\'>Stáhnout metadata SP</a>
<p>Možná to budete muset předat administrátorovi IdP, aby vás zařadil na seznam povolených.</p>';
$string['spmetadatasign'] = 'Podpis metadat SP';
$string['spmetadatasign_help'] = 'Podepsat metadata SP.';
$string['sspversion'] = 'Jednoduchá verze SAMLphp';
$string['stateorprovincename'] = 'Stát nebo provincie';
$string['status'] = 'Stav';
$string['suspendeduser'] = 'Úspěšně jste se přihlásili jako \'{$a}\', ale váš účet byl pozastaven v Moodle.';
$string['taskmetadatarefresh'] = 'Úloha aktualizace metadat';
$string['tempdir'] = 'SimpleSAMLphp dočasný adresář';
$string['tempdir_help'] = 'Adresář, kam může SimpleSAMLphp ukládat dočasné soubory';
$string['test_auth_button_login'] = 'Přihlášení IdP';
$string['test_auth_button_logout'] = 'Odhlášení IdP';
$string['test_auth_str'] = 'Test je ověřen a přihlaste se';
$string['test_endpoint'] = 'Adresa URL testu připojení';
$string['test_endpoint_desc'] = 'Zadejte adresu URL, podle které chcete otestovat připojení pro přesměrování IdP z klientského prohlížeče. Někteří uživatelé nebo sítě nemusí mít připojení k IdP na základě oprávnění účtu nebo sítě.';
$string['test_idp_conn'] = 'Test připojení IdP';
$string['test_noticetestrequirements'] = 'Aby bylo možné použít tento test, musí být plugin nakonfigurován, povolen a v nastavení pluginu by měl být povolen režim ladění.';
$string['test_passive_str'] = 'Test pomocí isPassive';
$string['testdebuggingdisabled'] = 'Pro použití této testovací stránky musí být zapnuto ladění SAML';
$string['tolower'] = 'Porovnání velkých a malých písmen';
$string['tolower:caseandaccentinsensitive'] = 'Nerozlišují se malá a velká písmena a akcenty';
$string['tolower:caseinsensitive'] = 'Nerozlišují se malá a velká písmena';
$string['tolower:exact'] = 'Přesně';
$string['tolower:lowercase'] = 'Malá písmena';
$string['tolower_help'] = '<p>Přesná: shoda rozlišuje velká a malá písmena (výchozí).</p>
<p>Malá písmena: před přiřazením použije malá písmena na atribut IdP.</p>
<p>Nerozlišují se malá a velká písmena: při porovnávání se ignorují velká a malá písmena.</p>';
$string['unlocked'] = 'Odemčeno';
$string['unlockedifempty'] = 'Odemčeno, pokud je prázdné';
$string['update_never'] = 'Nikdy';
$string['update_oncreate'] = 'Při vytvoření';
$string['update_onlogin'] = 'Při každém přihlášení';
$string['update_onupdate'] = 'Při aktualizaci';
$string['wantassertionssigned'] = 'Chcete podepsat tvrzení';
$string['wantassertionssigned_help'] = 'Zda tvrzení přijatá tímto SP musí být podepsána';
$string['wrongauth'] = 'Úspěšně jste se přihlásili jako \'{$a}\', ale nemáte oprávnění k přístupu do Moodle.';
