<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'format_tiles', language 'de', version '4.4'.
 *
 * @package     format_tiles
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addsections'] = 'Kachel hinzufügen';
$string['admintools'] = 'Administrationstools';
$string['all'] = 'Alle';
$string['allcomplete'] = 'Alle erledigt';
$string['allcoursescomplypalette'] = 'Alle Kurse haben bereits passende Kachelfarben. Es gibt nichts zurückzusetzen. Speichern Sie mögliche Änderungen zu den erlaubten Farben, bevor Sie auf "Zurücksetzen" klicken.';
$string['allowphototiles'] = 'Fotokacheln erlauben';
$string['allowphototiles_desc'] = 'Wenn diese Option ausgewählt ist, kann ein Foto hochladen werden, das als Kachelhintergrund dient. Im selben Kurs können weiterhin Standard-Kachelsymbole verwendet werden. Andernfalls sind nur Kachelsymbole zulässig, und andere Einstellungen für Fotokacheln unten werden ignoriert.';
$string['allowsubtilesview'] = 'Ansicht von Unterkacheln zulassen';
$string['allowsubtilesview_desc'] = 'Kurseinstellung erlauben, die, wenn sie ausgewählt ist, innerhalb einer Kachel Aktivitäten (außer Textfelder) als Unterkacheln anstelle der Standardliste anzeigt.';
$string['alternativelink'] = 'Alternativer Link';
$string['areyousure'] = 'Möchten Sie das wirklich?';
$string['asfraction'] = 'Als Bruch anzeigen';
$string['aspectratiotootallorwide'] = 'Das hochgeladene Bild wurde gespeichert. Überprüfen Sie bitte, ob es <strong>{$a->tallorwide}</strong> ist. Wenn es nicht richtig aussieht, schneiden Sie es auf die Standardgröße (z.B. 300x200 Pixel) im Querformat zu und laden Sie es erneut hoch.';
$string['aspercentagedial'] = 'Mit % im Kreis anzeigen';
$string['assumedatastoreconsent'] = 'Automatische Zustimmung zur lokalen Datenspeicherung';
$string['assumedatastoreconsent_desc'] = 'Wenn diese Option ausgewählt ist, wird die Zustimmung zur lokalen Datenspeicherung im Browser automatisch gegeben. Den Nutzer/innen  wird <b>kein Dialog</b> angezeigt, in dem um eine Zustimmung zur Datenspeicherung gebeten wird.';
$string['backupfailed'] = 'Sicherung fehlgeschlagen';
$string['basecolour'] = 'Kachelfarbe';
$string['basecolour_help'] = 'Die hier festgelegte Farbe wird für alle Kacheln im Kurs angewendet. Die verfügbaren Farben werden von den Administrator/innen in den Einstellungen des Kachelformats festgelegt.';
$string['brandcolour'] = 'Markenfarbe';
$string['cachedef_modalcmids'] = 'Kursmodul-IDs (nach Kurs), die gestartet werden müssen';
$string['cachedef_videocmids'] = 'Kursmodul-IDs (nach Kurs), die Videos sind (URLs, die auf YouTube oder Vimeo verweisen)';
$string['canceltask'] = 'Task abbrechen';
$string['changedcolour'] = 'Kachelfarbe für Kurs {$a} auf Standard zurückgesetzt';
$string['checkforproblemcourses'] = 'Problemkurse prüfen und korrigieren';
$string['clearphoto'] = 'Diese Kachel zurücksetzen';
$string['clickiffailstoload'] = 'Klicken, falls die Seite nicht lädt';
$string['close'] = 'Schließen';
$string['closetopsection'] = 'Obersten Abschnitt schließen';
$string['collapse'] = 'Abschnitt einklappen';
$string['collapsesections'] = 'Alles einklappen';
$string['colourblue'] = 'Blau';
$string['colourdarkgreen'] = 'Dunkelgrün';
$string['colourgreen'] = 'Grün';
$string['colourlightblue'] = 'Hellblau';
$string['colourname_descr'] = 'Anzeigename für die Farbe. Normalerweise werden die Farbnamen nicht angezeigt - zu sehen ist stattdessen ein farbiges Feld.';
$string['colournamegeneral'] = 'Anzeigename für die obige Farbe';
$string['colourpurple'] = 'Violett';
$string['colourred'] = 'Rot';
$string['colours'] = 'Farben';
$string['complete'] = 'Abgeschlossen';
$string['complete-n-auto'] = 'Element ist nicht abgeschlossen. Es wird als abgeschlossen markiert, sobald Sie die Abschlusskriterien erfüllt haben. Sie können dies nicht manuell ändern.';
$string['complete-y-auto'] = 'Element abgeschlossen. Es wurde als abgeschlossen markiert, da Sie die Abschlusskriterien erfüllt haben. Sie können dies nicht manuell ändern.';
$string['completion_help'] = 'Ein Häkchen rechts neben einer Aktivität zeigt an, dass die Aktivität abgeschlossen ist Ein leerer Kreis wird angezeigt, wenn nicht.
Je nach Einstellung erscheint das Häkchen automatisch, wenn die Abschlussbedingung erfüllt ist.
In anderen Fällen können Sie auf den leeren Kreis klicken, um die Aktivität manuell abzuschließen. Im Anschluss wird ein grünes Häkchen angezeigt. Ein erneuter Klick entfernt das Häkchen wieder.';
$string['completionswitchhelp'] = '<p>Sie haben ausgewählt, dass der Abschlussstatus auf jeder Kachel angezeigt wird. Deswegen wurde weiter unten die <i>Abschlussverfolgung</i> aktiviert.</p>
<p>Zusätzlich müssen Sie jetzt bei <b>jeder</b> zu verfolgenden Aktivität die Abschlussverfolgung konfigurieren, z.B. bei einer PDF-Datei, auf "Einstellungen bearbeiten" klicken, und unter Aktivitätsabschluss die gewünschte Einstellung vornehmen.</p>
<p>Sie können dies auch in einer <b>Stapelverarbeitung</b> tun. Details hierzu unter <a href="https://docs.moodle.org/de/Einstellungen_zum_Aktivit%C3%A4tsabschluss" target="_blank">docs.moodle.org</a></p>';
$string['completionwarning'] = 'Sie haben die Abschlussverfolgung auf Kursebene eingeschaltet, aber bei den einzelnen Aktivitäten keine Elemente für die Abschlussverfolgung aktiviert, so dass es nichts zu verfolgen gibt.';
$string['completionwarning_changeinbulk'] = 'Bulk-Veränderung';
$string['completionwarning_help'] = 'Sie müssen die Aktivitäten (unter Aktivitätsabschluss - Abschlussverfolgung) einzeln konfigurieren oder Sie können dies für mehrere unter Kurseinstellungen - Kursabschluss -  Bulk-Bearbeitung von Aktivitätsabschlüssen tun.';
$string['contact'] = 'Kontakt';
$string['contactdeveloper'] = 'Entwickler/in kontaktieren';
$string['contents'] = 'Inhalte';
$string['controls'] = 'Steuerung';
$string['coursephotomigrationincomplete'] = 'Kachelsymbole und -fotos wurden nach einem System-Upgrade noch nicht migriert. Fehlende Elemente sollten einige Zeit nach dem Upgrade automaisch angezeigt werden.';
$string['courseshowtileprogress'] = 'Fortschrittsanzeige auf jeder Kachel';
$string['courseshowtileprogress_error'] = 'Sie haben \'Aktivitätsabschluss > Abschlussverfolgung\' auf \'Nein\' gesetzt (siehe weiter unten auf dieser Seite), was mit dieser Einstellung nicht übereinstimmt. Wenn Sie den Fortschritt der Kacheln anzeigen möchten, stellen Sie bitte \'Aktivitätsabschluss > Abschlussverfolgung\' auf \'Ja\'. Andernfalls verwenden Sie hier für diese Einstellung \'Nein\'.';
$string['courseshowtileprogress_help'] = '<p>Wenn diese Option ausgewählt ist, wird der Fortschritt mit Aktivitäten in jeder Kachel angezeigt, entweder als <em>Bruch</em> (z.B. \'Fortschritt 2/10\' bedeutet 2 von 10 abgeschlossenen Aktivitäten) oder als <em>Prozentsatz</em> in einem Kreis.</p><p>Dies kann nur verwendet werden, wenn  \'Aktivitätsabschluss > Abschlussverfolgung\' eingeschaltet ist.</p><p>Wenn es keine Aktivitätsabschlüsse innerhalb einer bestimmten Kachel gibt, wird der Indikator für diese Kachel nicht angezeigt.</p>';
$string['courseshowtileprogress_link'] = 'Activity_completion_settings#Activity_settings';
$string['coursetoomanysections'] = 'Warnung: Dieser Kurs enthält mehr Kacheln als maximal zulässig. Den Teilnehmer/innen werden maximal {$a->max} angezeigt (nur bis "{$a->tilename}"). Trainer/innen und Administrator/innen können mehr sehen.';
$string['courseusebarforheadings'] = 'Überschriften durch farbige Tabs hervorheben';
$string['courseusebarforheadings_help'] = 'Eine farbiger Tab wird links neben der Überschrift im Kurs angezeigt, wenn ein Überschriftsstil im Texteditor ausgewählt ist';
$string['courseusesubtiles'] = 'Unterkacheln für Aktivitäten verwenden';
$string['courseusesubtiles_help'] = 'Innerhalb jeder Kachel werden Aktivitäten als Unterkacheln angezeigt anstatt als Liste von Aktivitäten im Verlauf der Seite. Dies gilt nicht für Textfelder, die nicht als Unterkacheln angezeigt werden und somit als Überschriften zwischen den Kacheln verwendet werden können.';
$string['currentsection'] = 'Diese Kachel';
$string['customcss'] = 'Angepasstes CSS';
$string['customcssdesc'] = 'Angepasstes CSS für Kursseiten in diesem Kursformat. Das CSS wird nicht überprüft. Achten Sie deswegen darauf, gültigen Code einzugeben. Beispiele: <pre>
.section { color: red; }
li.activity.subtile.resource.pdf { background-color: orange !important; }</pre>';
$string['datapref'] = 'Datenpräferenz';
$string['datapreferror'] = 'Die Datenpräferenz ist nur verfügbar, wenn JavaScript in Ihrem Browser aktiviert ist. Andernfalls kann die Speicherung nicht aktiviert werden.';
$string['dataprefquestion'] = '<p>Um die Nutzung des Kachelformats zu vereinfachen, speichert Moodle funktionale Informationen im Browser ab, z.B. die ID der zuletzt geöffneten Kachel. Diese Kachel wird bei Ihrem nächsten Besuch wieder geöffnet. Wir verwenden dies nicht zum Tracking. Ist das in Ordnung?</p>
<p>Ihre Wahl bleibt gespeichert, bis Sie Ihren Browserverlauf löschen. Zum Deaktivieren der Funktion klicken Sie auf "Abbrechen".</p>';
$string['defaultthiscourse'] = 'Standard für diesen Kurs';
$string['defaulttilecolour'] = 'Standardfarbe für Kacheln';
$string['defaulttileicon'] = 'Kachelsymbol';
$string['defaulttileicon_help'] = 'Das ausgewählte Symbol erscheint in diesem Kurs auf <em>allen</em> Kacheln. Einzelne Kacheln können anschließend in den Kacheleinstellungen mit einem anderen Symbol versehen werden.';
$string['deleteemptytiles'] = 'Leere Kacheln löschen';
$string['deleteimage'] = 'Bild löschen';
$string['deletesection'] = 'Abschnitt löschen';
$string['deletetile'] = 'Kachel löschen';
$string['developedby'] = '"Kachelformat", entwickelt von {$a}';
$string['developer'] = 'Entwickler/in';
$string['disabledbyadmin'] = 'Von Administrator/in deaktiviert';
$string['displayfilterbar'] = 'Filterleiste';
$string['displayfilterbar_error'] = 'Wenn Sie keine Ergebnisse für diesen Kurs eingerichtet haben, können Sie eine Filterleiste nur nach Kachelnummern und nicht nach Ergebnissen anzeigen. Erstellen Sie zuerst einige Ergebnisse, dann kommen Sie hierher zurück.';
$string['displayfilterbar_help'] = '<p>Wenn diese Option ausgewählt ist, wird automatisch eine Reihe von Schaltflächen vor dem Kacheln im Kurs angezeigt. Diese können Nutzer/innen anklicken, um Kacheln zu filtern </p><p>Wurde \'basierend auf Kachelnummern\' ausgewählt, wird eine Reihe von Schaltflächen angezeigt, z.B. eine Schaltfläche für Kacheln 1-4, eine Schaltfläche für Kacheln 5-8 usw. </p><p>Wurde \'basierend auf Kursergebnissen\' ausgewählt, gibt es eine Schaltfläche pro Kursergebnis. Jede Kachel kann auf der Einstellungsseite der jeweiligen Kachel einem bestimmten Ergebnis (und damit einer bestimmten Schaltfläche) zugeordnet werden.</p>';
$string['displayfilterbar_link'] = 'Outcomes';
$string['displaytitle_mod_doc'] = 'Word-Dokument';
$string['displaytitle_mod_html'] = 'Website';
$string['displaytitle_mod_jpeg'] = 'Bild';
$string['displaytitle_mod_mp3'] = 'Audio';
$string['displaytitle_mod_mp4'] = 'Video';
$string['displaytitle_mod_pdf'] = 'PDF';
$string['displaytitle_mod_ppt'] = 'PowerPoint-Präsentation';
$string['displaytitle_mod_txt'] = 'Text';
$string['displaytitle_mod_xls'] = 'Tabellenkalkulation';
$string['displaytitle_mod_zip'] = 'Zip-Datei';
$string['documentation'] = 'Dokumentation';
$string['documentationurl'] = 'Link zur Dokumentation';
$string['documentationurl_descr'] = 'Link zur Dokumentation des Kachelformats';
$string['download'] = 'Download';
$string['editoradvicesubtiles'] = 'In dieser Version des Kachelformats erscheinen die Aktivitäten nur als Unterkacheln, wenn Bearbeiten ausgeschaltet ist.';
$string['editsection'] = 'Abschnitt bearbeiten';
$string['editsectionname'] = 'Abschnittsname bearbeiten';
$string['embeddedurlerror'] = 'Falls die externe Website nicht erreichbar ist, verwenden Sie diesen Link:';
$string['enablelinebreakfilter'] = 'Zeilenumbruchfilter aktivieren';
$string['enablelinebreakfilter_desc'] = 'Kacheltitel nach unsichtbarer Wortverbindung {$a} filtern und, falls vorhanden und der Titel lang ist, durch "-" ersetzen. Das ermöglicht Zeilenumbrüche. Andernfalls ersetzen Sie es durch nichts (d.h. kein Zeilenumbruch).';
$string['entersection'] = 'Abschnitt öffnen';
$string['existingimage'] = 'Existierendes Bild für diese Kachel';
$string['expand'] = 'Aufklappen';
$string['expandall'] = 'Alles aufklappen';
$string['expandsections'] = 'Alle Aktivitäten anzeigen (alle Abschnitte)';
$string['expandtopsection'] = 'Obersten Abschnitt öffnen';
$string['experimental'] = 'experimentell';
$string['experimentalfeatures'] = 'Experimentelle Optionen';
$string['fileaddedtobottom'] = 'Datei am Abschnittsende hinzugefügt';
$string['filterboth'] = 'Schaltflächen basierend auf Kachelnummern und Kursergebnissen anzeigen';
$string['filternumbers'] = 'Schaltflächen basierend auf Kachelnummern anzeigen';
$string['filteroutcomes'] = 'Schaltflächen basierend auf den Kursergebnissen anzeigen';
$string['filteroutcomesrestore'] = 'Der ursprüngliche Kurs verwendet Ergebnisse in der Filterleiste, die während des Wiederherstellungsprozesses noch nicht unterstützt werden. Die Einstellung der Filterleiste wurde daher im wiederhergestellten Kurs geändert. Wenn Sie Ergebnisse verwenden möchten, um Kacheln im wiederhergestellten Kurs zu filtern, richten Sie die Ergebnisse bitte erneut ein. Der ursprüngliche Kurs wurde nicht geändert.';
$string['filters'] = 'Filter';
$string['fittilestowidth'] = 'Kacheln an die Bildschirmbreite anpassen';
$string['fittilestowidth_desc'] = 'Wenn diese Option aktiviert ist und jemand mit einem nicht mobilen Gerät auf einen Kurs zugreift, verzögern die Kacheln das Laden, während eine Berechnung des besten Layouts durchgeführt wird. Vermeiden Sie eine Kachel pro Reihe und zentrieren Sie die Kacheln auf dem Bildschirm. Die Berechnung geschieht, wenn Nutzer/innen den Kurs zum ersten Mal betreten, und wird für die Sitzung oder bis zur Änderung der Fenstergröße gespeichert.';
$string['fixproblems'] = 'Probleme korrigieren';
$string['folderdisplayerror'] = 'Verzeichnisse, die so eingestellt sind, dass sie Inhalte inline anzeigen, sind nicht mit dem Unterkachel-Format kompatibel. Dieses <a href="{$a}">Verzeichnis</a> wurde daher geändert, um auf einer separaten Seite angezeigt zu werden';
$string['followthemecolour'] = 'Folgenden Designfarbe erzwingen';
$string['followthemecolour_desc'] = 'Wenn diese Option auf \'Ja\' gesetzt ist, können die Kachelfarben nicht ausgewählt werden. Stattdessen wird versucht, die Hauptmarkenfarbe des Designs beizuhalten und stattdessen diese zu verwenden.';
$string['guidance'] = 'Orientierungshilfe';
$string['height'] = 'Höhe';
$string['hidden'] = 'Verborgen';
$string['hide'] = 'Verbergen';
$string['hidefromothers'] = 'Verbergen';
$string['highcontrastmode'] = 'Hoher Kontrast';
$string['highcontrastmodeallow'] = 'Hohen Kontrast erlauben';
$string['highcontrastmodeallow_desc'] = 'Diese Option erlaubt es Nutzer/innen, Kachelkurse über einer personenbezogene Einstellung auf hohem Kontrast umzuschalten. Die von den Trainer/innen ausgewählten Kachelfarben werden durch eine dunkle Farbe überschrieben.';
$string['highestsectionnum'] = 'Höchste Abschnittsnummer gefunden';
$string['home'] = 'Kursbeginn';
$string['icontitle-address-book-o'] = 'Adressbuch';
$string['icontitle-assessment_graded'] = 'Bewertung A+';
$string['icontitle-assessment_timer'] = 'Bewertungszeitgeber';
$string['icontitle-asterisk'] = 'Sternchen';
$string['icontitle-award-solid'] = 'Auszeichnung';
$string['icontitle-balance-scale'] = 'Waage';
$string['icontitle-bar-chart'] = 'Balkendiagramm';
$string['icontitle-bell-o'] = 'Glocke';
$string['icontitle-binoculars'] = 'Fernglas';
$string['icontitle-bitcoin'] = 'Bitcoin';
$string['icontitle-book'] = 'Buch';
$string['icontitle-bookmark-o'] = 'Lesezeichen';
$string['icontitle-briefcase'] = 'Aktentasche';
$string['icontitle-building'] = 'Gebäude';
$string['icontitle-bullhorn'] = 'Megaphon';
$string['icontitle-bullseye'] = 'Zielscheibe';
$string['icontitle-calculator'] = 'Taschenrechner';
$string['icontitle-calendar'] = 'Kalender';
$string['icontitle-calendar-check-o'] = 'Kalender mit Haken';
$string['icontitle-check'] = 'Haken';
$string['icontitle-child'] = 'Kind';
$string['icontitle-clock-o'] = 'Uhr';
$string['icontitle-clone'] = 'Kopie';
$string['icontitle-cloud-download'] = 'Cloud (herunterladen)';
$string['icontitle-cloud-upload'] = 'Cloud (hochladen)';
$string['icontitle-comment-o'] = 'Kommentar';
$string['icontitle-comments-o'] = 'Kommentare';
$string['icontitle-compass'] = 'Kompass';
$string['icontitle-diamond'] = 'Diamant';
$string['icontitle-dollar'] = 'Dollar';
$string['icontitle-euro'] = 'Euro';
$string['icontitle-exclamation-triangle'] = 'Achtung!';
$string['icontitle-feed'] = 'Feed';
$string['icontitle-file-text-o'] = 'Textdatei';
$string['icontitle-film'] = 'Film';
$string['icontitle-flag-checkered'] = 'Flagge (kariert)';
$string['icontitle-flag-o'] = 'Flagge';
$string['icontitle-flash'] = 'Blitz';
$string['icontitle-flask'] = 'Kolben';
$string['icontitle-flipchart'] = 'Flipchart';
$string['icontitle-frown-o'] = 'Traurig';
$string['icontitle-gavel'] = 'Hammer';
$string['icontitle-gbp'] = 'Britisches Pfund';
$string['icontitle-globe'] = 'Globus';
$string['icontitle-handshake-o'] = 'Handschlag';
$string['icontitle-headphones'] = 'Kopfhörer';
$string['icontitle-heartbeat'] = 'Herzschlag';
$string['icontitle-history'] = 'Zeitverlauf';
$string['icontitle-home'] = 'Zu Hause';
$string['icontitle-id-card-o'] = 'Ausweis';
$string['icontitle-info'] = 'Info';
$string['icontitle-jigsaw'] = 'Puzzle';
$string['icontitle-key'] = 'Schlüssel';
$string['icontitle-laptop'] = 'Laptop';
$string['icontitle-life-buoy'] = 'Rettungsring';
$string['icontitle-lightbulb-o'] = 'Glühbirne';
$string['icontitle-line-chart'] = 'Liniendiagramm';
$string['icontitle-list'] = 'Liste mit Punkten';
$string['icontitle-list-ol'] = 'Liste mit Zahlen';
$string['icontitle-location-arrow'] = 'Positionspfeil';
$string['icontitle-map-marker'] = 'Kartenmarkierung';
$string['icontitle-map-o'] = 'Landkarte';
$string['icontitle-map-signs'] = 'Wegweiser';
$string['icontitle-microphone'] = 'Mikrofon';
$string['icontitle-mobile-phone'] = 'Smartphone';
$string['icontitle-mortar-board'] = 'Doktorhut';
$string['icontitle-music'] = 'Musik';
$string['icontitle-newspaper-o'] = 'Zeitung';
$string['icontitle-number'] = 'Nummer {$a}';
$string['icontitle-pencil-square-o'] = 'Stift im Quadrat';
$string['icontitle-person'] = 'Person';
$string['icontitle-pie-chart'] = 'Kreisdiagramm';
$string['icontitle-podcast'] = 'Podcast';
$string['icontitle-puzzle-piece'] = 'Puzzleteil';
$string['icontitle-question-circle'] = 'Fragezeichen';
$string['icontitle-random'] = 'Zufällig';
$string['icontitle-refresh'] = 'Aktualisieren';
$string['icontitle-road'] = 'Straße';
$string['icontitle-search'] = 'Lupe';
$string['icontitle-sliders'] = 'Schieberegler';
$string['icontitle-smile-o'] = 'Lächeln';
$string['icontitle-star'] = 'Stern (gefült)';
$string['icontitle-star-half-o'] = 'Stern (halb gefüllt)';
$string['icontitle-star-o'] = 'Stern (nicht gefüllt)';
$string['icontitle-survey'] = 'Umfrage';
$string['icontitle-tags'] = 'Tags';
$string['icontitle-tasks'] = 'Aufgaben';
$string['icontitle-television'] = 'Monitor';
$string['icontitle-thinking-person'] = 'Person mit Glühbirne';
$string['icontitle-thumbs-o-down'] = 'Daumen runter';
$string['icontitle-thumbs-o-up'] = 'Daumen hoch';
$string['icontitle-trophy'] = 'Trophäe';
$string['icontitle-umbrella'] = 'Regenschirm';
$string['icontitle-university'] = 'Universität';
$string['icontitle-user-o'] = 'Person (ungefüllt)';
$string['icontitle-users'] = 'Personen';
$string['icontitle-volume-up'] = 'Lautsprecher';
$string['icontitle-wrench'] = 'Schraubenschlüssel';
$string['imagecannotbeused'] = 'Bild kann nicht verwendet werden';
$string['imagedeletedfrom'] = 'Bild gelöscht von "{$a}"';
$string['imagesavedfor'] = 'Bild gesichert für \'{$a}\'';
$string['imagesize'] = 'Bildgröße';
$string['invalidsectionid'] = 'Ungültige Abschnitts-ID "{$a}"';
$string['jsactivate'] = 'Animierte Navigation ausschalten';
$string['jsdeactivated'] = 'Sie haben die animierte Navigation in Ihrem Konto deaktiviert.';
$string['jsreactivated'] = 'Sie haben die animierte Navigation in Ihrem Konto aktiviert.';
$string['legacytiledata'] = 'Anzahl von alten Kacheldaten';
$string['links'] = 'Links';
$string['loading'] = 'Laden';
$string['maxcoursesectionsallowed'] = 'Die maximal zulässige Anzahl von Kursabschnitten in dieser Umgebung ist {$a}.';
$string['migratecoursedata'] = 'Kursdaten migrieren';
$string['migratedcourseid'] = 'Migrierte Kurs-ID {$a}';
$string['migratenow'] = 'Jetzt migrieren';
$string['modalmodules'] = 'Modale Module';
$string['modalmodules_desc'] = 'Diese Kursmodule in einem Modal-Fenster starten. (Weitere Module könnten in einer zukünftigen Version dazukommen.)';
$string['modalresources'] = 'Modale Ressourcen';
$string['modalresources_desc'] = 'Starten Sie diese Ressourcen in einem Modal-Fenster.
<br>Hinweis: Wenn dies hier erlaubt ist, werden URL-Ressourcen nur in einem modalen Fenster geöffnet, wenn sie auf Aktivitätsebene auf {$a->displayembed} eingestellt sind (z.B. YouTube- oder Vimeo-Videos). Und selbst dann könnte vom originalen Websitebesitzer verhindert worden sein, URL-Ressourcen eingebettet anzuzeigen - siehe {$a->link}';
$string['modalwindows'] = 'Modale Fenster';
$string['newsectionname'] = 'Neuer Name für Abschnitt {$a}';
$string['newtiledata'] = 'Anzahl von neuen Kacheldaten';
$string['nexttopic'] = 'Nächster Abschnitt';
$string['noconnectionerror'] = 'Es ist nicht möglich, Inhalte zu laden. Überprüfen Sie Ihre Internet-Verbindung';
$string['nojswarning'] = 'Ihr Browser scheint kein JavaScript zu unterstützen, oder JavaScript ist deaktiviert. Eine erweiterte Nutzerführung ist verfügbar, wenn Sie JavaScript aktivieren.';
$string['none'] = 'Keine';
$string['noproblemsfound'] = 'Keine Probleme gefunden';
$string['notcomplete'] = 'Nicht abgeschlossen';
$string['notrecommended'] = 'Nicht empfohlen';
$string['notregistered'] = 'Das Plugin \'Kachelformat\' ist bisher nicht bei den Entwickler/innen registriert.';
$string['novaliddefaultcolour'] = 'Keine gültige Farbe für die unten stehende Standardkachelfarbe festgelegt';
$string['numberofsections'] = 'Anzahl der Abschnitte im Kurs';
$string['numbers'] = 'Zahlen';
$string['numbers_desc'] = 'Ein Zahlsymbol für diese Kachel wählen';
$string['off'] = 'Aus';
$string['ok'] = 'OK';
$string['on'] = 'An';
$string['onlywhenediting'] = 'Nur beim Bearbeiten';
$string['other'] = 'Sonstiges';
$string['outcomes'] = 'Ergebnisse';
$string['outcomesunavailable'] = 'Ergebnisse nicht verfügbar';
$string['overall'] = 'Insgesamt';
$string['overallprogress'] = 'Aktivitätsabschluss - Fortschritt insgesamt';
$string['overallprogressshort'] = 'Fortschritt insgesamt';
$string['photoguidance_desc'] = '<p>Laden Sie ein Foto im <strong>Querformat</strong> hoch. Die Breite sollte etwa das 1,35-fache der Höhe betragen, z.B. 270 Breite x 200 Höhe. Die Werte müssen nicht genau sein. </p>
<p>Fotos im Hochformat passen nicht zur Form der Kacheln. Große Bilder oder Dateien werden nach dem Hochladen verkleinert und bei Bedarf komprimiert.</p>';
$string['photolibrary'] = 'Fotobibliothek';
$string['photolibrary_desc'] = 'Diese Fotos haben Sie kürzlich hochgeladen oder verwendet. Klicken Sie darauf, um ein Foto als Hintergrund für diese Kachel zu verwenden. Verwenden Sie die Registerkarte "Hochladen", um neue Fotos hochzuladen.';
$string['phototilesaltstyle'] = 'Alternativer Stil für Fotokacheln';
$string['phototilesaltstyle_desc'] = 'Wenn diese Option nicht ausgewählt (Standardeinstellung) ist, wird auf den Fotokacheln der Titel oben auf der Kachel angezeigt. Der alternative Stil zeigt den Titel unten.';
$string['phototilesettings'] = 'Fotokacheln';
$string['phototiletitletransarency'] = 'Transparenz für Titel';
$string['phototiletitletransarency_desc'] = 'Das Titeloverlay auf einer Fotokachel kann einen transparenten Hintergrund oder einen deckenden Hintergrund (0%) haben.';
$string['phototitletitlelineheight'] = 'Zeilenhöhe für Titel';
$string['phototitletitlepadding'] = 'Vertikaler Seitenabstand für Titel';
$string['picknewicon'] = 'Neues Icon auswählen';
$string['picknewiconphoto'] = 'Neues Icon oder Hintergrundfoto auswählen';
$string['plugin_description'] = 'Im Kachelformat werden Abschnitte und Aktivitäten ansprechend als Kacheln mit anpassbaren Fotos, Symbolen und Farben dargestellt.';
$string['pluginname'] = 'Kachelformat';
$string['previoustopic'] = 'Vorheriger Abschnitt';
$string['privacy:metadata:preference:format_tiles_high_contrast_mode'] = 'Nutzer/in kann den Modus Hoher Kontrast nutzen.';
$string['privacy:metadata:preference:format_tiles_stopjsnav'] = 'Unabhängig davon, ob die animierte JavaScript-Navigation deaktiviert ist.';
$string['privacypolicy'] = 'Datenschutzrichtlinie';
$string['problemcourses'] = 'Problemkurse';
$string['problemcoursesintro'] = 'Die folgenden Kurse haben Abschnittsnummern, die größer sind als erlaubt. Verwenden Sie bitte die nachfolgenden Tasten, um die Fehler zu beheben.';
$string['progress'] = 'Fortschritt';
$string['progresstitle'] = '{$a->numComplete} / {$a->numOutOf} Elemente abgeschlossen ({$a->percent}%)';
$string['reactivate'] = 'Reaktivieren';
$string['reopenlastsection'] = 'Zuletzt besuchte Kachel wieder öffnen';
$string['reopenlastsection_desc'] = 'Wenn diese Option aktiviert ist, wird der letzte Abschnitt, den eine Person geöffnet hatte, bei ihrem nächsten Besuch wieder geöffnet.';
$string['resetallcoursecolours'] = 'Alle Kursfarben zurücksetzen';
$string['resetalltiles'] = 'Kachelsymbole und -fotos zurücksetzen';
$string['resetalltilessure'] = 'Möchten Sie die Kacheln für diesen Kurs wirklich zurücksetzen? Dadurch werden alle Kachelfotos gelöscht und alle Symbole auf die Standardeinstellungen zurückgesetzt. Kursinhalte werden nicht gelöscht. Dies ist eine destruktive Aktion und kann nicht rückgängig gemacht werden. Sichern Sie zunächst Ihren Kurs, wenn Sie unsicher sind.';
$string['resetcolours'] = 'Farben zurücksetzen';
$string['resetcolours_desc'] = 'Drücken Sie diese Taste, um die Kachelfarbe für alle Kurse zurückzusetzen, die die folgenden Farben nicht haben. Die Kurse werden in die angegebene Standardfarbe für Kacheln geändert. Sie können diese Option verwenden, nachdem Sie die Farbpalette geändert haben. Stellen Sie aber sicher, dass Sie alle Änderungen an den Farben gespeichert haben, bevor Sie auf die Taste klicken. Seien Sie vorsichtig, da dies die Farben vieler Kurse verändern kann!';
$string['resetincomplete'] = 'Zurücksetzen unvollständig';
$string['restorefailed'] = 'Wiederherstellung fehlgeschlagen';
$string['restoreincorrectsections'] = 'Fehler: Der Vorgang kann nicht abgeschlossen werden. Der Quellkurs enthält falsch nummerierte Abschnitte (möglicherweise ist die Abschnittsnummer ({$a->sectionnum}) höher als die maximal zulässige Anzahl den Kurseinstellungen der Website. Versuchen Sie, Abschnitte mit hohen Nummern auszuschließen oder zu löschen.';
$string['restoretoomanysections'] = 'Fehler: Der Kurs kann nicht gesichert oder wiederhergestellt werden, da er zu viele Abschnitte enthält ({$a->numsections}) und dies mehr als zulässig ist ({$a->maxallowed}). Versuchen Sie, einige Abschnitte auszuschließen oder zu löschen.';
$string['revealcontents'] = 'Kachelinhalt aufdecken';
$string['scheduleddeleteemptysections'] = 'Die Task, leere Abschnitte aus dem Kurs zu löschen, wurde eingeplant. Versuchen Sie es bitte später noch einmal.';
$string['section0name'] = 'Allgemeines';
$string['sectionerrorstring'] = 'Ihre Sitzung ist möglicherweise abgelaufen. Versuchen Sie, diese Seite zu aktualisieren.';
$string['sectionerrortitle'] = 'Fehler beim Laden von Inhalten';
$string['sectionname'] = 'Kachel';
$string['sectionnumber'] = 'Abschnitts-/Kachelnummer';
$string['seczerocollapsible'] = 'Abschnitt 0 zusammenklappen';
$string['seczerocollapsible_desc'] = 'Nutzer/innen erlauben, den Abschnitt 0 zusammenzuklappen';
$string['selected'] = 'Ausgewählt';
$string['setavailabletilecolours'] = 'Zulässige Kachelfarben (für die Website)';
$string['setbackgroundphoto'] = 'Symbol / Foto setzen';
$string['settings'] = 'Einstellungen zum Kursformat';
$string['show'] = 'Anzeigen';
$string['showalltiles'] = 'Alle Kacheln anzeigen';
$string['showfromothers'] = 'Sichtbar machen';
$string['showoverallprogress'] = 'Gesamtfortschritt anzeigen';
$string['showoverallprogress_desc'] = 'Diese Option zeigt oben rechts im Kurs den Indikator "Gesamtfortschritt %" an. Der angezeigte Wert ist der Gesamtwert in %, basierend auf den Aktivitätsabschlüssen und nicht auf dem Kursabschluss.';
$string['showprogresssphototiles_desc'] = 'Wenn diese Option ausgewählt ist, wird der Bearbeitungsfortschritt (z.B. Fortschritt 2/5) auf den Fotokacheln angezeigt';
$string['showseczerocoursewide'] = 'Anzeige des Abschnitts 0 über allen Abschnitten';
$string['showseczerocoursewide_desc'] = 'Wenn diese Option aktiviert ist, wird der Abschnitt 0 (der oberste Abschnitt) auf der Kursseite und oben auf jeder Seite des Kurses angezeigt (d.h. über dem Inhalt jeder Kachel). Wenn die Option nicht angekreuzt ist (empfohlen), wird es nur auf der Kursseite angezeigt';
$string['showseparatewin'] = 'In einem separaten Fenster anzeigen';
$string['sitename'] = 'Name der Website';
$string['snapwarning'] = 'Es ist möglich, Ihren Kurs im Kachelformat mit einem anderen Design zu bearbeiten und dann nach der Bearbeitung wieder zum \'Snap-Design\' zurückzukehren.';
$string['snapwarning_help'] = 'Designs > Einstellungen > Designwechsel für Nutzer/innen erlauben';
$string['style'] = 'Stil';
$string['subtileiconcolourbackground'] = 'Unterkachelsymbole – verwendet einen einfarbigen Hintergrundkreis';
$string['subtileiconcolourbackground_desc'] = 'Wenn diese Option aktiviert ist, werden die Symbole der untergeordneten Kacheln als weiße Symbole in einem einfarbigen Hintergrundkreis angezeigt. Andernfalls sind die Symbole (1) selbst farbig und (2) in einem farbigen, aber nicht einfarbigen Kreis dargestellt.';
$string['subtileszeczerotoggled'] = 'Der obere Abschnitt wird zwischen Listen- und Unterkachelformat umgeschaltet.';
$string['suremigratelegacyoptions'] = 'Möchten Sie wirklich die {$a} Kachelfoto- oder Symbolauswahl für diesen Kurs migrieren?';
$string['sureresetcolours'] = 'Möchten Sie die Kachelfarben wirklich für alle Kurse zurücksetzen? Dies betrifft insgesamt {$a} Kurse.';
$string['tilearialabel'] = '{$a}, öffnet Details in Popup';
$string['tilecolourgeneral'] = 'Farbpalette - optionale Farbe';
$string['tilecolourgeneral_descr'] = 'Mit diesen Einstellungen wird festgelegt, welche Farben den Trainer/innen in deren Kursen zur Verfügung stehen. Stellen Sie die Farbe auf Schwarz (#000000) ein, um diese Farbe zu deaktivieren. Wenn Sie die Farben nachträglich hier ändern, werden keine Änderungen an vorhandenen Kursen vorgenommen. Für die nächste Kursbearbeitung stehen den Trainer/innen aber nur die Farben zur Verfügung, die Sie hier festgelegt haben.';
$string['tilecolourschanged'] = 'Die Kachelfarben wurden zurückgesetzt. Alle Kacheln haben jetzt Farben aus den angegebenen Bereich.';
$string['tileicon'] = 'Symbol / Foto, das nur auf dieser Kachel angezeigt wird';
$string['tileicon_help'] = 'Das hier ausgewählte Element überschreibt nur für diese Kachel das Kachelsymbol, das auf der Kursebene festgelegt wurde.';
$string['tileicons'] = 'Kachelsymbole';
$string['tileoutcome'] = 'Ergebnis für diese Kachel';
$string['tileoutcome_help'] = 'Wenn Sie ein Ergebnis für diese Kachel auswählen, können Sie dann unter Kurseinstellungen eine Reihe von <em>Filtertasten</em> anzeigen, eine für jedes Ergebnis, die beim Drücken die angezeigten Kacheln nach dem Ergebnis filtern, die ihnen zugewiesen wurde';
$string['tileselecttip'] = 'Um das Kachelsymbol oder das Foto zu ändern, klicken Sie bei aktiviertem Bearbeitungsmodus einfach darauf. Die Symbolauswahl wird angezeigt.';
$string['tilesformatregistration'] = 'Registrierung für Kachelformat';
$string['tilesreset'] = 'Kacheln & Symbole wurden für diesen Kurs zurückgesetzt';
$string['tilestyle'] = 'Kachelstil';
$string['tilestyle_desc'] = 'Stil 1 = Fotokacheln zeigen den Titel oben auf der Kachel.
Stil 2 = Der Titel ist unten.';
$string['togglecompletion'] = 'Klicken Sie zum Umschalten des Abschlussstatus';
$string['togglecompletioncomplete'] = 'Klicken Sie hier, um den Abschlussstatus umzuschalten (abgeschlossen)';
$string['togglecompletionincomplete'] = 'Klicken Sie hier, um den Abschlussstatus umzuschalten (unvollständig)';
$string['tootall'] = 'zu klein für die Kachel';
$string['toowide'] = 'zu groß für die Kachel';
$string['transparenttitleadjustments'] = 'Einstellungen für die Titeltransparenz';
$string['transparenttitleadjustments_desc'] = 'Bei Fotokacheln mit transparentem Titelhintergrund können Sie diese anpassen, damit sich z.B. die transparenten Zeilen des Titels beim Umbrechen nicht überlappen.
Beachten Sie, dass die Darstellung in unterschiedlichen Browsern leicht variiert. Vorgeschlagene Werte für Chrome: Boost- und Clean-basierte Designs: 30.5 und 4 | Adaptable: 32 und 4 | Moove: 32 und 2 | Remui: 32 und 2,5';
$string['unmigratedcoursesintro'] = 'Bei den folgenden Kursen \'{$a}\' wurden nach einem System-Upgrade offenbar nicht alle Kachelsymbole und Fotos migriert. Nach einer gewissen Wartezeit sollte der Hintergrundprozess „cron“ alle diese Schritte automatisch abarbeiten. Wenn Sie einen bestimmten Kurs sofort bearbeiten möchten, klicken Sie auf die Schaltfläche.';
$string['uploadnewphoto'] = 'Neues Foto hochladen';
$string['uploadnewphoto_help'] = 'Neues Foto hochladen, um es für die Kachel zu verwenden';
$string['usecourseindex'] = 'Kursindex verwenden';
$string['usecourseindex_desc'] = 'Soll in einem Kurs im Kachelformat der Kursindex auf der linken Seite gezeigt werden?';
$string['usejavascriptnav'] = 'JavaScript-Navigation auf der Kachelhauptseite verwenden';
$string['usejavascriptnav_desc'] = 'Wenn diese Option aktiviert ist und jemand in der Kursübersicht auf eine Kachel klickt, wird für den Übergang zum Kachelinhalt JavaScript verwendet. Der Kachelinhalt wird gemäß der anderen Einstellungen lokal im Browser gespeichert. Wenn diese Option "JavaScript" nicht aktiviert ist, wird stattdessen wird eine Legacy-Navigation verwendet und alle weiteren JavaScript-Einstellungen werden ignoriert.';
$string['usejseditingexpandcollapse'] = 'Bearbeitungsmodus - JavaScript verwenden, um Kacheln auf- und zuzuklappen';
$string['usejseditingexpandcollapse_desc'] = 'Wenn diese Option ausgewählt ist, können die Kacheln mit animierten Übergängen auf- und zugeklappt werden. Der Kachelinhalt wird beim Aufklappen ohne Neuladen der Seite angezeigt.';
$string['usejsnavforsinglesection'] = 'JavaScript-Navigation für einzelne Abschnittsseiten verwenden';
$string['usejsnavforsinglesection_desc'] = 'Wenn diese Option aktiviert ist, wird jeder Abschnittsaufruf (&section=xx) mithilfe von JavaScript verarbeitet. Die Kurshauptseite wird gestartet, um anschließend über JavaScript animiert den angeforderten Abschnitt zu öffnen.';
$string['usesubtilesseczero'] = 'Unterkacheln im oberen Bereich verwenden';
$string['usesubtilesseczero_help'] = 'Wenn diese Option ausgewählt ist, werden die Unterkacheln im oberen Bereich sowie in allen Kacheln verwendet. Nachteil ist, dass die Subkacheln viel Raum ganz oben einnehmen. Es kann besser sein, diese Option deaktiviert zu lassen, damit alle Elemente im oberen Abschnitt stattdessen im Standardlistenformat angezeigt werden.';
$string['usetooltips'] = 'JavaScript Tooltipps anzeigen';
$string['usetooltips_desc'] = 'JavaScript Tooltipps anzeigen. wenn Nutzer/innen bestimmte Elemente berühren, z.B. Bereiche für die Fertigstellung, Kacheln für den Kachelinhalt';
$string['version'] = 'Version {$a}';
$string['width'] = 'Breite';
