<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'block_opencast', language 'de', version '4.4'.
 *
 * @package     block_opencast
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accesspolicies'] = 'Zugriffsrechte';
$string['acl_settingcontrol'] = 'Aktivieren der Sichtbarkeitskontrolle';
$string['acl_settingcontrol_desc'] = 'Wenn diese Option aktiviert ist, können Trainer/innen die Sichtbarkeit einer Opencast-Episode beim Hochladen kontrollieren.';
$string['acl_settingcontrolafter'] = 'Sichtbarkeit von Episoden nach der Verarbeitung ändern';
$string['acl_settingcontrolafter_desc'] = 'Wenn diese Option aktiv ist, können die Trainer/innen die Sichtbarkeit einer Opencast Episode nach der Verarbeitung der Episode ändern';
$string['acl_settingcontrolgroup'] = 'Beschränkung der Sichtbarkeit auf Gruppen erlauben';
$string['acl_settingcontrolgroup_desc'] = 'Wenn diese Option aktiv ist, können die Trainer/innen nicht nur die Sichtbarkeit einer Opencast Episode für alle Teilnehmer/innen ändern, sondern die Sichtbarkeit auch auf Gruppen einschränken.';
$string['acl_settingcontrolwaitingtime'] = 'Wartezeit für geplante Sichtbarkeitsänderungen (in Minuten)';
$string['acl_settingcontrolwaitingtime_desc'] = 'Definiert eine Mindestwartezeit (in Minuten), die geplante Prozesse zur Sichtbarkeitsänderung warten. Diese Zeitspanne wird zur aktuellen Zeit für das geplante Videoänderungsdatum, das im Formular „Video hinzufügen“ hinterlegt ist, hinzuaddiert und wird auch verwendet, um dieses Feld zu validieren. Basierend darauf, wie schnell die Opencast-Instanz die Videos verarbeitet, kann diese Wartezeit konfiguriert werden. <br />HINWEIS: Wenn leer oder (Null) "0", wird der Standardwert verwendet.';
$string['acl_settingheader'] = 'Sichtbarkeit von Episoden ändern';
$string['aclgroupdeleted'] = 'Zugriff für das Video \'{$a->title}\' wurde eingeschränkt';
$string['aclnothingtobesaved'] = 'Es wurden keine Änderungen an der Sichtbarkeit vorgenommen.';
$string['aclownerrole'] = 'ACL Eigentümerrolle';
$string['aclownerrole_desc'] = 'Name der Rolle, die den/die Eigentümer/in eines Videos/einer Serie identifiziert. Die Rolle muss auch in der Rollentabelle angegeben werden. Die Rolle muss dauerhaft sein und einen benutzerbezogenen Platzhalter enthalten, z.B. ROLE_OWNER_[USER_EMAIL]. Es sollte keine kursbezogenen Platzhalter enthalten. Wenn leer, sind Eigentümer-bezogene Plugin-Funktionalitäten deaktiviert.';
$string['aclrolesadded'] = 'Die Sichtbarkeit wurde geändert, so dass Teilnehmer/innen dieses Kurses Zugriff auf das folgendes Video haben: {$a->title}<br />Laden Sie diese Seite nach einiger Zeit neu, um den aktuellen Status der Sichtbarkeit zu sehen.';
$string['aclrolesaddedgroup'] = 'Die Sichtbarkeit wurde geändert, so dass Teilnehmer/innen der gewählten Gruppe Zugriff auf das folgendes Video haben: {$a->title}<br />Laden Sie diese Seite nach einiger Zeit neu, um den aktuellen Status der Sichtbarkeit zu sehen.';
$string['aclroleschangeerror'] = 'Es ist ein Fehler während der Sichtbarkeitsänderung für folgendes Video aufgetreten: {$a->title}<br />Einige Änderungen wurden möglicherweise nicht gespeichert. Sollte das Problem wiederholt auftreten, wenden Sie an Ihren Support.';
$string['aclrolesdeleted'] = 'Die Sichtbarkeit wurde geändert, so dass keine Teilnehmer/innen mehr Zugriff auf das folgendes Video haben: {$a->title}<br />Laden Sie diese Seite nach einiger Zeit neu, um den aktuellen Status der Sichtbarkeit zu sehen.';
$string['aclrolesname'] = 'Rollen';
$string['aclrolesnamedesc'] = 'Sie können im Rollennamen Platzhalter verwenden, die automatisch ersetzt werden (<a target="_blank" href="https://moodle.docs.opencast.org/#block/general_settings/#placeholders">Liste der Platzhalter</a>). Die Liste der Aktionen muss durch Kommata getrennt sein.';
$string['actions'] = 'kommagetrennte Liste von Aktionen';
$string['addactivity_addbuttonexplanation'] = 'Die Videos, die zu diesem Kurs hinzugefügt werden und in diesem Kurs verfügbar sind, werden Ihren Teilnehmer/innen nicht automatisch zur Verfügung gestellt.<br />Mit den Schaltflächen "Bereitstellen" können Sie Ihrem Kurs Aktivitäten hinzufügen, die Ihren Teilnehmer/innen entweder alle Videos in einer Serie oder einzelne Videos zur Verfügung stellen.';
$string['addactivity_addbuttontitle'] = 'Aktivität "Opencast Video Provider" zum Kurs hinzufügen';
$string['addactivity_addbuttontitlereturncourse'] = 'Aktivität hinzufügen und zurück zum Kurs';
$string['addactivity_addbuttontitlereturnoverview'] = 'Aktivität hinzufügen und zurück zur Übersicht';
$string['addactivity_defaulttitle'] = 'Opencast Videos';
$string['addactivity_formactivityavailability'] = 'Voraussetzungen der Opencast-Serien-Aktivität';
$string['addactivity_formactivityintro'] = 'Beschreibung der Opencast-Serien-Aktivität';
$string['addactivity_formactivitysection'] = 'Kursabschnitt der Opencast-Serien-Aktivität';
$string['addactivity_formactivitytitle'] = 'Titel der Opencast-Serien-Aktivität';
$string['addactivity_header'] = 'Videos zur Verfügung stellen (Aktivität)';
$string['addactivity_modulecreated'] = 'Die Serien-Aktivität \'{$a}\' wurde zum Kurs hinzugefügt.';
$string['addactivity_moduleexists'] = 'Es gibt bereits eine Opencast-Serien-Aktivität in diesem Kurs. Es ist nicht notwendig eine zweite hinzuzufügen.';
$string['addactivity_modulenotcreated'] = 'Die Serien-Aktivität \'{$a}\' konnte nicht zum Kurs hinzugefügt werden. Versuchen Sie es erneut oder kontaktieren Sie Ihren Support.';
$string['addactivity_noemptytitle'] = 'Sie müssen einen Namen für die Opencast-Serien-Aktivität angeben oder den standardmäßigen Namen "{$a}" verwenden.';
$string['addactivity_settingavailability'] = 'Voraussetzungen zur Serien-Aktivität';
$string['addactivity_settingavailability_desc'] = 'Wenn diese Option aktiv ist, können die Trainer/innen die Voraussetzungen für die Aktivität setzen, wenn die Opencast Serien-Aktivität zum Kurs hinzugefügt wird.';
$string['addactivity_settingavailability_note'] = 'Bitte beachten Sie: Diese Funktion steht nur zur Verfügung, wenn Voraussetzungen in Moodle auf der {$a} Einstellungsseite aktiviert sind.';
$string['addactivity_settingdefaulttitle'] = 'Standard-Titel der Serien-Aktivität.';
$string['addactivity_settingdefaulttitle_desc'] = 'Der standardmäßige Titel der Aktivität wird verwendet, wenn eine neue Opencast Serien-Aktivität angelegt wird.';
$string['addactivity_settingenabled'] = '"Serien-Aktivität hinzufügen" aktivieren';
$string['addactivity_settingenabled_desc'] = 'Wenn diese Option aktiv ist, können die Trainer/innen eine Opencast Serien-Aktivität zum Kurs hinzufügen. Diese Serien-Aktivität wird die Opencast-Serie des Kurses anzeigen.';
$string['addactivity_settingheader'] = 'Opencast Serien-Aktivität zum Kurs hinzufügen';
$string['addactivity_settingintro'] = 'Beschreibung zur Serien-Aktivität';
$string['addactivity_settingintro_desc'] = 'Wenn diese Option aktiv ist, können die Trainer/innen eine Beschreibung zur Opencast Serien-Aktivität hinzufügen. Diese Beschreibung wird auf der Kursseite angezeigt werden.';
$string['addactivity_settingsection'] = 'Kursabschnitt der Serien-Aktivität';
$string['addactivity_settingsection_desc'] = 'Wenn diese Option aktiv ist, können die Trainer/innen den Kursabschnitt wählen, zu welchem die Opencast Serien-Aktivität hinzugefügt wird.';
$string['addactivity_viewbuttonexplanation'] = 'Eine Opencast-Serien-Aktivität, die alle verfügbaren Videos im Kurs anzeigt, wurde bereits hinzugefügt.';
$string['addactivity_viewbuttontitle'] = 'Opencast-Serien-Aktivität im Kurs anzeigen';
$string['addactivityepisode_addbuttontitlereturncourse'] = 'Aktivität hinzufügen und zurück zum Kurs';
$string['addactivityepisode_addbuttontitlereturnoverview'] = 'Aktivität hinzufügen und zurück zur Übersicht';
$string['addactivityepisode_addicontitle'] = 'Opencast-Einzelvideo-Aktivität zum Kurs hinzufügen';
$string['addactivityepisode_defaulttitle'] = 'Opencast Einzelvideo';
$string['addactivityepisode_explanation'] = 'Zusätzlich können Sie in der obenstehenden Tabelle Aktivitäten für Opencast Einzelvideos zu Ihrem Kurs hinzufügen um Ihren Teilnehmer/innen ein einzelnes Video bereitzustellen.';
$string['addactivityepisode_formactivityavailability'] = 'Voraussetzungen der Opencast-Einzelvideo-Aktivität';
$string['addactivityepisode_formactivityintro'] = 'Beschreibung der Opencast-Einzelvideo-Aktivität';
$string['addactivityepisode_formactivitysection'] = 'Kursabschnitt der Opencast-Einzelvideo-Aktivität';
$string['addactivityepisode_formactivitytitle'] = 'Titel der Opencast-Einzelvideo-Aktivität';
$string['addactivityepisode_modulecreated'] = 'Die Einzelvideo-Aktivität \'{$a}\' wurde zum Kurs hinzugefügt.';
$string['addactivityepisode_moduleexists'] = 'Es gibt bereits eine Opencast-Einzelvideo-Aktivität in diesem Kurs. Es ist nicht notwendig eine zweite hinzuzufügen.';
$string['addactivityepisode_modulenotcreated'] = 'Die Einzelvideo-Aktivität \'{$a}\' konnte nicht zum Kurs hinzugefügt werden. Versuchen Sie es erneut oder kontaktieren Sie Ihren Support.';
$string['addactivityepisode_noemptytitle'] = 'Sie müssen einen Namen für die Opencast-Einzelvideo-Aktivität angeben oder den standardmäßigen Namen "{$a}" verwenden.';
$string['addactivityepisode_settingavailability'] = 'Voraussetzungen zur Einzelvideo-Aktivität';
$string['addactivityepisode_settingavailability_desc'] = 'Wenn diese Option aktiv ist, können die Trainer/innen die Voraussetzungen für die Aktivität setzen, wenn die Opencast Einzelvideo-Aktivität zum Kurs hinzugefügt wird.';
$string['addactivityepisode_settingenabled'] = '"Einzelvideo-Aktivität hinzufügen" aktivieren';
$string['addactivityepisode_settingenabled_desc'] = 'Wenn diese Option aktiv ist, können die Trainer/innen eine Opencast Einzelvideo-Aktivität zum Kurs hinzufügen. Diese Einzelvideo-Aktivität wird eine einzelne Opencast Episode anzeigen.';
$string['addactivityepisode_settingintro'] = 'Beschreibung zur Einzelvideo-Aktivität';
$string['addactivityepisode_settingintro_desc'] = 'Wenn diese Option aktiv ist, können die Trainer/innen eine Beschreibung zur Opencast Einzelvideo-Aktivität hinzufügen. Diese Beschreibung wird auf der Kursseite angezeigt werden.';
$string['addactivityepisode_settingsection'] = 'Kursabschnitt der Einzelvideo-Aktivität';
$string['addactivityepisode_settingsection_desc'] = 'Wenn diese Option aktiv ist, können die Trainer/innen den Kursabschnitt wählen, zu welchem die Opencast Einzelvideo-Aktivität hinzugefügt wird.';
$string['addactivityepisode_viewicontitle'] = 'Opencast-Einzelvideo-Aktivität im Kurs anzeigen';
$string['addcatalog'] = 'Neues Metadatum hinzufügen';
$string['additional_settings'] = 'Zusätzliche Funktionen';
$string['addlti_addbuttonexplanation'] = 'Die Videos, die zu diesem Kurs hinzugefügt werden bzw. in diesem verfügbar sind, werden den Teilnehmer/innen nicht automatisch angezeigt.</br>Hier können Sie eine Opencast-Serien-Aktivität zum Kurs hinzufügen, welche den Teilnehmer/innen alle sichtbaren Videos anbietet.';
$string['addlti_addbuttontitle'] = 'Opencast-LTI-Serien-Aktivität zum Kurs hinzufügen';
$string['addlti_addbuttontitlereturncourse'] = 'Aktivität hinzufügen und zurück zum Kurs';
$string['addlti_addbuttontitlereturnoverview'] = 'Aktivität hinzufügen und zurück zur Übersicht';
$string['addlti_defaulttitle'] = 'Opencast Videos';
$string['addlti_errornotenabledorworking'] = 'Die \'Opencast-Serien-Aktivität zum Kurs hinzufügen\' Funktion ist entweder nicht aktiviert oder funktioniert nicht.';
$string['addlti_formltiavailability'] = 'Voraussetzungen der Opencast-Serien-Aktivität';
$string['addlti_formltiintro'] = 'Beschreibung der Opencast-Serien-Aktivität';
$string['addlti_formltisection'] = 'Kursabschnitt der Opencast-Serien-Aktivität';
$string['addlti_formltititle'] = 'Titel der Opencast-Serien-Aktivität';
$string['addlti_header'] = 'Videos zur Verfügung stellen (LTI)';
$string['addlti_modulecreated'] = 'Die Serien-Aktivität \'{$a}\' wurde zum Kurs hinzugefügt.';
$string['addlti_moduleexists'] = 'Es gibt bereits eine Opencast-Serien-Aktivität in diesem Kurs. Es ist nicht notwendig eine zweite hinzuzufügen.';
$string['addlti_modulenotcreated'] = 'Die Serien-Aktivität \'{$a}\' konnte nicht zum Kurs hinzugefügt werden. Versuchen Sie es erneut oder kontaktieren Sie Ihren Support.';
$string['addlti_noemptytitle'] = 'Sie müssen einen Namen für die Opencast-Serien-Aktivität angeben oder den standardmäßigen Namen "{$a}" verwenden.';
$string['addlti_settingavailability'] = 'Voraussetzungen zur LTI-Serien-Aktivität';
$string['addlti_settingavailability_desc'] = 'Wenn diese Option aktiv ist, können die Trainer/innen die Voraussetzungen für die Aktivität setzen, wenn die Opencast LTI-Serien-Aktivität zum Kurs hinzugefügt wird.';
$string['addlti_settingavailability_note'] = 'Bitte beachten Sie: Diese Funktion steht nur zur Verfügung, wenn Voraussetzungen in Moodle auf der {$a} Einstellungsseite aktiviert sind.';
$string['addlti_settingdefaulttitle'] = 'Standard-Titel der LTI-Serien-Aktivität.';
$string['addlti_settingdefaulttitle_desc'] = 'Der standardmäßige Titel der LTI-Aktivität wird verwendet, wenn eine neue Opencast LTI-Serien-Aktivität angelegt wird.';
$string['addlti_settingenabled'] = '"LTI-Serien-Aktivität hinzufügen" aktivieren';
$string['addlti_settingenabled_desc'] = 'Wenn diese Option aktiv ist, können die Trainer/innen eine Opencast LTI-Serien-Aktivität zum Kurs hinzufügen. Diese LTI-Serien-Aktivität wird die Opencast-Serie des Kurses anzeigen.';
$string['addlti_settingheader'] = 'Opencast LTI-Serien-Aktivität zum Kurs hinzufügen';
$string['addlti_settingintro'] = 'Beschreibung zur LTI-Serien-Aktivität';
$string['addlti_settingintro_desc'] = 'Wenn diese Option aktiv ist, können die Trainer/innen eine Beschreibung zur Opencast LTI-Serien-Aktivität hinzufügen. Diese Beschreibung wird auf der Kursseite angezeigt werden.';
$string['addlti_settingpreconfiguredtool'] = 'Vorkonfiguriertes LTI-Serien-Tool';
$string['addlti_settingpreconfiguredtool_desc'] = 'Das vorkonfiguriertes LTI-Serien-Tool wird verwendet, wenn eine neue Opencast LTI-Serien-Aktivität zum Kurs hinzugefügt wird.';
$string['addlti_settingpreconfiguredtool_notools'] = 'Kein vorkonfiguriertes LTI-Tool gefunden. Legen Sie zuerst ein Opencast LTI-Serien-Tool über die Einstellungsseite unter {$a} an.';
$string['addlti_settingsection'] = 'Kursabschnitt der LTI-Serien-Aktivität';
$string['addlti_settingsection_desc'] = 'Wenn diese Option aktiv ist, können die Trainer/innen den Kursabschnitt wählen, zu welchem die Opencast LTI-Serien-Aktivität hinzugefügt wird.';
$string['addlti_viewbuttonexplanation'] = 'Eine Opencast-Serien-Aktivität, die alle verfügbaren Videos im Kurs anzeigt, wurde bereits hinzugefügt.';
$string['addlti_viewbuttontitle'] = 'Opencast-Serien-Aktivität im Kurs anzeigen';
$string['addltiepisode_addbuttontitlereturncourse'] = 'Aktivität hinzufügen und zurück zum Kurs';
$string['addltiepisode_addbuttontitlereturnoverview'] = 'Aktivität hinzufügen und zurück zur Übersicht';
$string['addltiepisode_addicontitle'] = 'Opencast-Einzelvideo-Aktivität zum Kurs hinzufügen';
$string['addltiepisode_defaulttitle'] = 'Opencast Einzelvideo';
$string['addltiepisode_errorepisodeuuidnotvalid'] = 'Die vorliegende UUID des Einzelvideos ist nicht gültig';
$string['addltiepisode_errornotenabledorworking'] = 'Die \'Opencast-Einzelvideo-Aktivität zum Kurs hinzufügen\' Funktion ist entweder nicht aktiviert oder funktioniert nicht.';
$string['addltiepisode_explanation'] = 'Zusätzlich können Sie in der obenstehenden Tabelle Aktivitäten für Opencast Einzelvideos zu Ihrem Kurs hinzufügen um Ihren Teilnehmer/innen ein einzelnes Video bereitzustellen.';
$string['addltiepisode_formltiavailability'] = 'Voraussetzungen der Opencast-Einzelvideo-Aktivität';
$string['addltiepisode_formltiintro'] = 'Beschreibung der Opencast-Einzelvideo-Aktivität';
$string['addltiepisode_formltisection'] = 'Kursabschnitt der Opencast-Einzelvideo-Aktivität';
$string['addltiepisode_formltititle'] = 'Titel der Opencast-Einzelvideo-Aktivität';
$string['addltiepisode_modulecreated'] = 'Die Einzelvideo-Aktivität \'{$a}\' wurde zum Kurs hinzugefügt.';
$string['addltiepisode_moduleexists'] = 'Es gibt bereits eine Opencast-Einzelvideo-Aktivität in diesem Kurs. Es ist nicht notwendig eine zweite hinzuzufügen.';
$string['addltiepisode_modulenotcreated'] = 'Die Einzelvideo-Aktivität \'{$a}\' konnte nicht zum Kurs hinzugefügt werden. Versuchen Sie es erneut oder kontaktieren Sie Ihren Support.';
$string['addltiepisode_noemptytitle'] = 'Sie müssen einen Namen für die Opencast-Einzelvideo-Aktivität angeben oder den standardmäßigen Namen "{$a}" verwenden.';
$string['addltiepisode_settingavailability'] = 'Voraussetzungen zur LTI-Einzelvideo-Aktivität';
$string['addltiepisode_settingavailability_desc'] = 'Wenn diese Option aktiv ist, können die Trainer/innen die Voraussetzungen für die Aktivität setzen, wenn die Opencast LTI-Einzelvideo-Aktivität zum Kurs hinzugefügt wird.';
$string['addltiepisode_settingenabled'] = '"LTI-Einzelvideo-Aktivität hinzufügen" aktivieren';
$string['addltiepisode_settingenabled_desc'] = 'Wenn diese Option aktiv ist, können die Trainer/innen eine Opencast LTI-Einzelvideo-Aktivität zum Kurs hinzufügen. Diese LTI-Einzelvideo-Aktivität wird eine einzelne Opencast Episode anzeigen.';
$string['addltiepisode_settingheader'] = 'Opencast LTI-Einzelvideo-Aktivität zum Kurs hinzufügen';
$string['addltiepisode_settingintro'] = 'Beschreibung zur LTI-Einzelvideo-Aktivität';
$string['addltiepisode_settingintro_desc'] = 'Wenn diese Option aktiv ist, können die Trainer/innen eine Beschreibung zur Opencast LTI-Einzelvideo-Aktivität hinzufügen. Diese Beschreibung wird auf der Kursseite angezeigt werden.';
$string['addltiepisode_settingpreconfiguredtool'] = 'Vorkonfiguriertes LTI-Einzelvideo-Tool';
$string['addltiepisode_settingpreconfiguredtool_desc'] = 'Das vorkonfiguriertes LTI-Einzelvideo-Tool wird verwendet, wenn eine neue Opencast LTI-Einzelvideo-Aktivität zum Kurs hinzugefügt wird.';
$string['addltiepisode_settingpreconfiguredtool_notools'] = 'Kein vorkonfiguriertes LTI-Tool gefunden. Legen Sie zuerst ein Opencast LTI-Einzelvideo-Tool über die Einstellungsseite unter {$a} an.';
$string['addltiepisode_settingsection'] = 'Kursabschnitt der LTI-Einzelvideo-Aktivität';
$string['addltiepisode_settingsection_desc'] = 'Wenn diese Option aktiv ist, können die Trainer/innen den Kursabschnitt wählen, zu welchem die Opencast LTI-Einzelvideo-Aktivität hinzugefügt wird.';
$string['addltiepisode_viewicontitle'] = 'Opencast-Einzelvideo-Aktivität im Kurs anzeigen';
$string['addnewcatalogfield'] = 'Ein neues Feld wurde zu den möglichen Metadaten hinzugefügt.';
$string['addnewtranscription'] = 'Neue Transkription hinzufügen';
$string['addnewtranscription_desc'] = 'Bitte wählen Sie eine Serviceart aus, in der Ihre Transkription dargestellt werden soll, und laden Sie dann die Datei mit den erforderlichen Erweiterungen hoch.<br>
    HINWEIS: Das Hochladen einer neuen Transkription mit einem bereits hochgeladenen Servicetyp führt dazu, dass diese Transkription ersetzt wird, was für die Bearbeitung der aktuellen Transkription nützlich sein kann.';
$string['addrole'] = 'Neue Rolle hinzufügen';
$string['addvideo'] = 'Video hinzufügen';
$string['addvideonotallowed'] = 'Sie dürfen kein Video zu dieser Serie hochladen.';
$string['adhocfiledeletion'] = 'Videodatei in Moodle löschen';
$string['adhocfiledeletiondesc'] = 'Wenn die Option aktiviert ist, versucht das Plugin, die Videodatei aus dem Dateisystem von Moodle zu löschen, sobald es auf den Opencast-Server hochgeladen wurde.
    Beachten Sie bitte, dass die Datei weiterhin im Dateisystem verbleibt, wenn sie an anderen Stellen in Moodle verwendet wird.';
$string['adminchoice_noconnection'] = '– Workflows konnten nicht ermittelt werden –';
$string['adminchoice_noworkflow'] = '-- kein Workflow --';
$string['allowdownloadtranscriptionsetting'] = 'Herunterladen von Transkriptionen zulassen';
$string['allowdownloadtranscriptionsetting_desc'] = 'Wenn diese Option aktiviert ist, wird auf der Seite "Transkriptionen verwalten" eine Schaltfläche zum Herunterladen der Transkription angezeigt, über die die Lehrkräfte die Datei der Transkription herunterladen können.<br>
    <b>Hinweis:</b> Wenn Sie Opencast 13 oder höher verwenden, müssen Sie sicherstellen, dass alle Voraussetzungen, einschließlich der LTI-Funktionen und der Berechtigungen für den Zugriff auf /assets/ endpoint für LTI-Benutzer, korrekt eingestellt sind, da dies für die Durchführung eines LTI-Aufrufs zwingend erforderlich ist.';
$string['alloweduploadwfconfigs'] = 'Erlaubte Upload-Workflow-Konfigurationen';
$string['alloweduploadwfconfigsdesc'] = 'Kommagetrennte Liste der zulässigen Upload-Workflow-Konfigurations-IDs, die den Lehrkräften auf der Upload-Seite angezeigt werden sollen und die bereits im Workflow-Konfigurationspanel vorhanden sind.<br />
Zum Beispiel: straightToPublishing,whisper_de,vosk_de
<br /><strong>HINWEIS:</strong> Wenn dieses Feld leer ist, werden den Lehrkräften alle Elemente im Workflow-Konfigurationsbereich wie Eingabe- und Auswahlelemente zur Verfügung gestellt.';
$string['allowunassign'] = 'Erlauben, die Zuordnung zum Kurs aufzuheben';
$string['allowunassigndesc'] = 'Die Zuordnung einer Serie löschen, um die Sichtbarkeit in Datei-Browser und Kurs-Listen zu kontrollieren. Dieses Feature steht nur zur Verfügung, wenn Episoden unabhängig von einer Serie in Opencast möglich sind. Bitte fragen Sie vor der Aktivierung den Administrator Ihres Opencast-Systems.';
$string['appearance_overview_settingheader'] = 'Überblicksseite';
$string['appearance_overview_settingshowenddate'] = 'Enddatum anzeigen';
$string['appearance_overview_settingshowenddate_desc'] = 'Wenn diese Option aktiv ist, wird in der Tabelle verfügbarer Videos auf der Überblicksseite eine Spalte enthalten sein, welche das Enddatum der Opencast Episoden ausgibt.';
$string['appearance_overview_settingshowlocation'] = 'Raum anzeigen';
$string['appearance_overview_settingshowlocation_desc'] = 'Wenn diese Option aktiv ist, wird in der Tabelle verfügbarer Videos auf der Überblicksseite eine Spalte enthalten sein, welche den Raum der Opencast Episoden ausgibt.';
$string['appearance_overview_settingshowpublicationchannels'] = 'Publikationskanäle anzeigen';
$string['appearance_overview_settingshowpublicationchannels_desc'] = 'Wenn diese Option aktiv ist, wird in der Tabelle verfügbarer Videos auf der Überblicksseite eine Spalte enthalten sein, welche die Publikationskanäle der Opencast Episoden ausgibt. Dieselbe Information wird auch auf der Seite, auf der Opencast Episoden gelöscht werden, ausgegeben werden.';
$string['appearance_settings'] = 'Erscheinungsbild';
$string['backupopencastvideos'] = 'Opencast Videos in diesem Kurs einbeziehen';
$string['batchupload'] = 'Videos hinzufügen (Stapelverarbeitung)';
$string['batchupload_emptyvideosuploaderror'] = 'Sie müssen mindestens ein Präsentator-Video hochladen.';
$string['batchupload_errornotenabled'] = 'Leider ist die Funktion Video Upload via Stapelverarbeitung für diese Opencast-Instanz nicht verfügbar. Bitte versuchen Sie, Ihren Systemadministrator zu kontaktieren.';
$string['batchupload_errorsaveuploadjobs'] = 'Fehler beim Hochladen bei {$a->count} von {$a->total} Video(s).';
$string['batchupload_errorseriesmismatched'] = 'Leider ist die Serie in diesem Kurs nicht definiert.';
$string['batchupload_filemanager_presenter_title'] = 'Präsentator-Videos';
$string['batchupload_form_header'] = 'Stapel-Upload von Dateien';
$string['batchupload_jobssaved'] = 'Stapel von {$a} Video(s) erfolgreich hochgeladen. <br> Die Videos befinden sich in der Warteschlange für die Übertragung zu Opencast. Sie brauchen also nicht auf dieser Seite zu warten, bis sie fertig sind.';
$string['batchupload_metadata_desc'] = 'Wenn Sie eine Reihe von Videos auf einmal in Opencast hochladen, werden die folgenden Metadaten für jedes Video festgelegt.';
$string['batchupload_metadata_header'] = 'Stapel-Metadaten';
$string['batchupload_setting'] = 'Stapel-Upload von Videos aktivieren';
$string['batchupload_setting_desc'] = 'Wenn diese Option aktiviert ist, stellt die Opencast-Instanz den Nutzer/innen eine separate Seite zur Verfügung, auf der sie Videos im Stapel auf einmal hochladen können. Bitte beachten Sie, dass das local_chunkupload-Plugin in diesem Upload-Modus nicht funktioniert. Das bedeutet, dass die Dateigröße aufgrund Ihrer Einstellungen begrenzt ist.<br /> Um zu vermeiden, dass die Upload-Warteschlange überfüllt wird, und um die Upload-Zeit zu verkürzen, wird empfohlen, die Option „Upload-Auftrag durch Cron begrenzen“ zu erhöhen.<br /> Um Timeout-Fehler beim Hochladen von Videos zu vermeiden, wird empfohlen, die Timeout-Optionen in den folgenden Einstellungen Ihren Bedürfnissen anzupassen: <br /> {$a->uploadtimeoutlink} <br /> {$a->toolopencastinstancelink}';
$string['batchupload_visibility_desc'] = 'Die Einstellung für die Sichtbarkeit wird auf jedes hochgeladene Video im Stapel angewendet.';
$string['batchupload_visibility_header'] = 'Sichtbarkeit von';
$string['batchuploadexplanation'] = 'In diesem Bereich können Sie mehrere Dateien auf einmal hochladen. <br /><strong>Hinweis</strong>: Bitte beachten Sie, dass der Batch-Video-Upload nur für Präsentator-Videos verfügbar ist.';
$string['blocksettings'] = 'Einstellungen für einen Opencast-Block';
$string['cachedef_videodata'] = 'Speichert die Ergebnisse der Opencast API vom Opencast Block im Cache';
$string['cachevalidtime'] = 'Gültige Cache Zeit';
$string['cachevalidtime_desc'] = 'Zeit in Sekunden bevor die gecachten Videodaten pro Kurs erneuert werden';
$string['cantdeletedefaultseries'] = 'Sie können die Standard-Serie nicht löschen. Wählen Sie bitte eine andere Standard-Serie, bevor Sie diese Serie löschen.';
$string['cantdeletedefaultseries_modaltitle'] = 'Standard-Serien können nicht gelöscht werden';
$string['catalog_params_noarray'] = 'Die Parameter müssen entweder leer sein oder im JSON Format (Array oder Objekt) angegeben werden.';
$string['catalog_static_params_empty'] = 'Schreibgeschützte Felder müssen einen Text im Parameter-Feld definieren';
$string['catalogparam'] = 'Parameter im JSON-Format';
$string['changeowner'] = 'Besitzer/in wechseln';
$string['changeowner_explanation'] = 'Derzeit sind Sie der Eigentümer des Videos {$a}.<br>Sie können die Eigentümerschaft auf eine andere Person übertragen.<br><b>Hinweis:</b> Möglicherweise verlieren Sie das Recht, auf das Video zuzugreifen.';
$string['changeownerseries_explanation'] = 'Derzeit sind Sie der Eigentümer der Serie {$a}.<br>Sie können die Eigentümerschaft auf eine andere Person übertragen.<br><b>Hinweis:</b> Sie verlieren möglicherweise das Recht, auf die Serie zuzugreifen.';
$string['changescheduledvisibility'] = 'Geplante Sichtbarkeit für {$a} ändern';
$string['changescheduledvisibilityfailed'] = 'Unmöglich, die geplante Sichtbarkeit zu ändern';
$string['changescheduledvisibilityheader'] = 'Geplante Änderung der Sichtbarkeit';
$string['changescheduledvisibilitysuccess'] = 'Geplante Sichtbarkeit erfolgreich geändert';
$string['changevisibility'] = 'Sichtbarkeit ändern';
$string['changevisibility_group'] = 'Das Video ist für alle Teilnehmer/innen ausgewählter Gruppen sichtbar. Bitte klicken, um die Sichtbarkeit zu ändern.';
$string['changevisibility_header'] = 'Sichtbarkeit für {$a->title} ändern';
$string['changevisibility_header_massaction'] = 'Sichtbarkeit für ausgewählte Videos ändern';
$string['changevisibility_hidden'] = 'Das Video ist für Teilnehmer/innen nicht sichtbar. Bitte klicken, um die Sichtbarkeit zu ändern.';
$string['changevisibility_massaction'] = 'Ändern Sie die Sichtbarkeit von ausgewählten Videos.';
$string['changevisibility_massaction_aclchangeerror'] = 'Die Änderung der Sichtbarkeit ist fehlgeschlagen.';
$string['changevisibility_massaction_aclchangeerror_noscheduling'] = 'Die Sichtbarkeitsänderung konnte nicht abgeschlossen werden, und die geplante Sichtbarkeitsänderung wurde übersprungen.';
$string['changevisibility_massaction_notification_failed'] = 'Die Sichtbarkeit für folgende(s) Video(s) kann nicht geändert werden: <br><ul><li>{$a}</li></ul>';
$string['changevisibility_massaction_notification_nochanges'] = 'Es wurden keine Änderungen an der Sichtbarkeit des/der ausgewählten Videos vorgenommen, da die aktuelle Sichtbarkeit bereits der gewählten Einstellung entspricht: <br><ul><li>{$a}</li></ul>';
$string['changevisibility_massaction_notification_schedulingfailed'] = 'Die Sichtbarkeitsänderung für folgende(s) Video(s) kann nicht geplant werden: <br><ul><li>{$a}</li></ul>';
$string['changevisibility_massaction_notification_schedulingsucceeded'] = 'Die Änderung der Sichtbarkeit für das/die ausgewählte(n) Video(s) wurde erfolgreich geplant: <br><ul><li>{$a}</li></ul>';
$string['changevisibility_massaction_notification_succeeded'] = 'Die Sichtbarkeit des/der ausgewählten Videos wurde erfolgreich aktualisiert: <br><ul><li>{$a}</li></ul>';
$string['changevisibility_massaction_novideos'] = 'Es ist nicht möglich, ein Video zu finden, um deren Sichtbarkeit zu ändern.';
$string['changevisibility_massaction_report_failed'] = '{$a->title}: {$a->error}';
$string['changevisibility_massaction_videoerror'] = 'Die Änderung der Sichtbarkeit für das Video ({$a->title}) ist derzeit nicht möglich aufgrund von: {$a->Fehler}';
$string['changevisibility_massaction_visibility_status'] = '<strong>{$a->title}</strong>: {$a->vstatusdesc}';
$string['changevisibility_massaction_visibility_status_with_scheduled'] = '<strong>{$a->title}</strong>: {$a->vstatusdesc} geplanter Status "{$a->svstatus}" am {$a->svdatetime}';
$string['changevisibility_mixed'] = 'Der Sichtbarkeitsstatus des Videos ist ungültig. Bitte klicken, um die richtige Sichtbarkeit auszuwählen.';
$string['changevisibility_visible'] = 'Das Video ist für alle Teilnehmer/innen des Kurses sichtbar. Bitte klicken, um die Sichtbarkeit zu ändern.';
$string['changingownerfailed'] = 'Ein Fehler ist aufgetreten. Die Eigentümerschaft konnten nicht übertragen werden.';
$string['changingownersuccess'] = 'Die Eigentümerschaft wurden erfolgreich übertragen.';
$string['claimowner_explanation'] = 'Derzeit ist niemand Eigentümer des Videos {$a}.<br>Sie können die Eigentümerschaft beanspruchen oder eine andere Person als Eigentümer festlegen.<br><b>Hinweis:</b> Möglicherweise verlieren Sie  das Recht, auf das Video zuzugreifen, wenn Sie die Eigentümerschaft nicht selbst beanspruchen.';
$string['claimownerseries_explanation'] = 'Derzeit ist niemand Eigentümer der Serie {$a}.<br>Sie können die Eigentümerschaft beanspruchen oder eine andere Person als Eigentümer festlegen.<br><b>Hinweis:</b> Möglicherweise verlieren Sie  das Recht, auf die Serie zuzugreifen, wenn Sie die Eigentümerschaft nicht selbst beanspruchen.';
$string['configurationpanel_header'] = 'Verarbeitungseinstellungen';
$string['configurationpanelheader_explanation'] = 'Die folgenden Einstellungsoptionen stehen zur Verfügung, um den Upload-Prozess nach Ihren Wünschen anzupassen.';
$string['connection_failure'] = 'Der Opencast Server kann nicht erreicht werden.';
$string['contributor'] = 'Mitwirkende';
$string['coursefullnameunknown'] = 'Unbekannter Kursname';
$string['created'] = 'Erstellt am';
$string['createdby'] = 'Hochgeladen von';
$string['createseriesforcourse'] = 'Neue Serie anlegen';
$string['createseriesforcourse_succeeded'] = 'Eine neue Serie wurde erfolgreich erstellt.';
$string['creator'] = 'Vortragende(r)';
$string['cronsettings'] = 'Einstellungen für das Hochladen';
$string['date'] = 'Startdatum';
$string['dcmitermsnotice'] = '<br /><strong>WICHTIG</strong>: Opencast unterstützt den standardisierten Dublin Core Metadatensatz, daher sollten alle Metadatenfelder DCMI-Begriffen entsprechen, andernfalls führt der Versuch, ein unbekanntes Metadatenfeld hinzuzufügen, zu einem Fehler.<br /> Sie können die Liste aller verfügbaren Begriffe unter <a target=„_blank“ href=„https://www.dublincore.org/specifications/dublin-core/dcmi-terms/“>DCMI Metadata Terms</a> einsehen.';
$string['default'] = 'Standard';
$string['defaultssaved'] = 'Standardwerte wurden gespeichert.';
$string['delete_block_and_mapping'] = 'Block- und Serienzuordnung löschen';
$string['delete_confirm_metadata'] = 'Sind Sie sich sicher, dass Sie dieses Metadaten-Feld löschen möchten?';
$string['delete_confirm_role'] = 'Möchten Sie diese Rolle wirklich löschen?';
$string['delete_confirm_series'] = 'Möchten Sie diese Serie wirklich löschen? <br/><b>Hinweis:</b> Für die Serie wird nur die Verlinkung für diesen Kurs entfernt. Sie wird aber nicht in Opencast gelöscht.';
$string['delete_mapping_explanation'] = 'Der Opencast-Block zeigt an, welche Opencast-Serien dem Kurs zugeordnet sind. Sie können wählen, ob Sie die Zuordnung löschen möchten. Wenn Sie sie löschen, wird die Serie nicht mehr angezeigt, wenn Sie den Opencast-Block erneut erstellen';
$string['delete_metadata'] = 'Metadaten-Feld löschen';
$string['delete_role'] = 'Rolle löschen';
$string['delete_series'] = 'Serie löschen';
$string['delete_series_failed'] = 'Das Löschen der Serie ist fehlgeschlagen. Versuchen Sie es bitte später erneut oder kontaktieren Sie den Administrator.';
$string['delete_series_succeeded'] = 'Die Serie wurde erfolgreich gelöscht.';
$string['deleteaclgroup'] = 'Video aus dieser Liste löschen.';
$string['deletecheck_title_modal'] = 'Opencast-Block entfernen?';
$string['deletedraft'] = 'Ein Video vor der Übertragung nach Opencast löschen';
$string['deletedraftdesc'] = 'Sie sind im Begriff, dieses Video vor der Übertragung nach Opencast zu löschen.<br />Es wird aus der Warteschlange entfernt und nicht verarbeitet werden. Bitte fahren Sie nicht fort, es sei denn, Sie sind sich absolut sicher.';
$string['deleteevent'] = 'Eine Episode in Opencast löschen';
$string['deleteevent_massaction'] = 'Ausgewählte(s) Video(s) in Opencast löschen';
$string['deleteevent_massaction_notification_failed'] = 'Die folgenden Videos konnten nicht gelöscht werden: <br><ul><li>{$a}</li></ul>';
$string['deleteevent_massaction_notification_nochange'] = 'Kein Video kann gelöscht werden, da die Videokennung fehlt.';
$string['deleteevent_massaction_notification_success'] = 'Das folgende ausgewählte Video wird in Kürze gelöscht werden: <br><ul><li>{$a}</li></ul>';
$string['deleteeventdesc'] = 'Sie sind im Begriff, dieses Video dauerhaft und irreversibel aus Opencast zu löschen.<br />Alle eingebetteten Links zu diesem Video werden ungültig. Bitte fahren Sie nicht fort, es sei denn, Sie sind sich absolut sicher.';
$string['deletegroupacldesc'] = 'Sie sind im Begriff, den Zugang zu diesem Video aus diesem Kurs zu löschen.<br />Wenn der Zugang gelöscht ist, wird das Video nicht im Datei-Browser und in der Übersicht der verfügbaren Videos angezeigt. Bereits eingebettete Videos sind davon nicht betroffen.<br />Das Video wird in Opencast nicht gelöscht.';
$string['deletetranscription'] = 'Transkription löschen';
$string['deletetranscription_desc'] = 'Sie sind dabei, die Transkription zu löschen.<br>Sind Sie sicher, dass Sie sie löschen möchten?';
$string['deletetranscriptionworkflow'] = 'Workflow um die Transkription zu löschen';
$string['deletetranscriptionworkflow_desc'] = 'Dieser Workflow wird ausgelöst, wenn eine Transkription gelöscht wird. Damit das Ereignis korrekt verarbeitet werden kann, muss die Löschfunktion vorhanden sein.<br>Hinweis: Wenn die Funktion leer ist, wird sie deaktiviert.';
$string['deleteworkflow'] = 'Bevor eine Episode gelöscht wird, Workflow starten';
$string['deleteworkflowdesc'] = 'Bevor ein Video gelöscht wird, kann ein Workflow definiert werden, der die Verbindungen der Episode zu den verschiedenen Publikationskanälen kappt.';
$string['deleting'] = 'Wird gelöscht';
$string['description'] = 'Beschreibung';
$string['descriptionmdbatchable'] = 'Stapelbar';
$string['descriptionmdbatchable_help'] = 'Wenn diese Option aktiviert ist, kann das Metadatenfeld für den Stapel-Upload von Videos festgelegt werden.';
$string['descriptionmddefaultable'] = 'Voreinstellbar';
$string['descriptionmddefaultable_help'] = 'Wenn diese Option aktiviert ist, können Nutzer/innen einen Standardwert für dieses Feld hinzufügen.';
$string['descriptionmdfd'] = 'Feldbeschreibung';
$string['descriptionmdfd_help'] = 'Der Inhalt dieses Feldes wird als Hilfesymbol neben dem Metadatenfeld angezeigt.';
$string['descriptionmdfn'] = 'Feldname';
$string['descriptionmdfn_help'] = 'Dies ist der tatsächliche Feldname, der als Metadaten (id) übergeben wird; der dargestellte Name sollte entsprechend diesem Feldnamen in der Sprachzeichenkette festgelegt werden.';
$string['descriptionmdpj'] = 'Der Wert sollte im JSON-String-Format sein und wird verwendet, um Parameter für das Feld zu definieren!';
$string['descriptionmdreadonly'] = 'Schreibgeschützt';
$string['descriptionmdreadonly_help'] = 'Bitte beachten Sie, dass die Option „Nur lesen“ deaktiviert wird, wenn ein Feld als „erforderlich“ gekennzeichnet ist. Das bedeutet, dass ein Feld jeweils nur schreibgeschützt oder erforderlich sein kann.';
$string['directaccess_copy_success'] = 'Der Direktzugriffslink wurde erfolgreich in die Zwischenablage kopiert.';
$string['directaccess_copytoclipboard_unavialable'] = 'Es scheint, dass Ihr Browser die Funktion „In die Zwischenablage kopieren“ nicht unterstützt. Versuchen Sie, den Link manuell aus dem Dropdown-Menü zu kopieren.';
$string['directaccess_setting'] = 'Opencast-Publikationskanal';
$string['directaccess_settingdesc'] = 'Opencast-Publikationskanal, über den die Videos beim direkten Zugriff bereitgestellt werden. Wenn Sie diese Option leer lassen, wird die Funktion deaktiviert.<br/><strong>Hinweis:</strong> Es wird empfohlen, bei der Verwendung dieser Funktion besondere Vorsicht walten zu lassen, da sie die direkten Videodaten auf dem Opencast-Server beim Zugriff auf den Link offenlegt.';
$string['dodeleteaclgroup'] = 'Videozugriff aus diesem Kurs löschen';
$string['dodeletedraft'] = 'Video vor der Übertragung nach Opencast löschen';
$string['dodeleteevent'] = 'Video endgültig löschen';
$string['download_setting'] = 'Download Kanal';
$string['download_settingdesc'] = 'Opencast Publikationskanal, aus dem die Videos für den Download zur Verfügung gestellt werden';
$string['download_settingheader'] = 'Videos herunterladen';
$string['downloadtranscription'] = 'Herunterladen der Transkription';
$string['downloadvideo'] = 'Video herunterladen';
$string['duplicateworkflow'] = 'Workflow zum Duplizieren von Opencast Videos';
$string['duplicateworkflowdesc'] = 'Dieser Workflow wird benötigt um Opencast Videos von einem Kurs in einen anderen zu importieren. Solange kein Workflow ausgewählt ist, ist es nicht möglich Opencast Videos zu importieren.';
$string['duration'] = 'Dauer';
$string['editorbaseurl'] = 'Opencast Editor Basis-URL';
$string['editorbaseurl_desc'] = 'Die Basis-URL, die für den Aufruf des Opencast-Editors verwendet werden soll; falls leer, wird die Basis-URL der Opencast-Instanz verwendet.';
$string['editorendpointurl'] = 'Opencast Editor Endpunkt';
$string['editorendpointurl_desc'] = 'Der Editor-Endpunkt für den Zugriff auf den Editor. Die Mediapackage-ID wird am Ende der URL hinzugefügt.';
$string['editseries'] = 'Serie bearbeiten';
$string['editseries_succeeded'] = 'Die Serie ist erfolgreich aktualisiert worden.';
$string['embeddedasactivity'] = 'Eingebettet als Aktivität';
$string['embeddedasactivitywolink'] = 'Eingebettet als Aktivität ohne verknüpfte Serie';
$string['empty_catalogname'] = 'Das Feld darf nicht leer sein';
$string['emptyvideouploaderror'] = 'Sie müssen entweder ein Präsentator-Video oder ein Präsentations-Video hochladen.';
$string['emptyvisibilitygroups'] = 'Es muss mindestens eine Gruppe ausgewählt werden.';
$string['enablechunkupload'] = 'Chunk-Upload aktivieren';
$string['enablechunkupload_desc'] = 'Wenn Chunk-Upload aktiviert ist, ist es möglich, Videos mit dem Chunkupload-Plugin hochzuladen';
$string['enableopencasteditorlink'] = 'Den Link zum Opencast Editor im Aktionsmenü anzeigen';
$string['enableopencasteditorlink_desc'] = 'Mit dieser Option wird im Blockinhalt und in der Blockübersicht eine Schaltfläche zum Öffnen des Opencast-Editors angezeigt. Die folgenden Einstellungen sowie die LTI-Anmeldedaten müssen ebenfalls konfiguriert werden.';
$string['enableopencaststudiolink'] = 'Link zu Opencast Studio anzeigen';
$string['enableopencaststudiolink_desc'] = 'Mit dieser Option wird im Blockinhalt und in der Blockübersicht eine Schaltfläche zu opencast studio angezeigt. Opencast Studio muss auf Ihrem Opencast Admin Node laufen und die folgenden LTI Einstellungen müssen ausgefüllt sein.';
$string['enableopencaststudioreturnbtn'] = 'Eine Zurück-Schaltfläche in Studio anzeigen';
$string['enableopencaststudioreturnbtn_desc'] = 'Wenn diese Option aktiviert ist, zeigt Studio nach dem Hoch- oder Herunterladen der Aufzeichnung eine zusätzliche Schaltfläche "Beenden und zurückgehen" an.';
$string['enableschedulingchangevisibility'] = 'Planen der Sichtbarkeitsänderung';
$string['enableschedulingchangevisibility_massaction'] = 'Planen Sie eine Sichtbarkeitsänderung für das/die ausgewählte(n) Video(s)';
$string['enableschedulingchangevisibilitydesc'] = 'Legen Sie ein Datum und einen Sichtbarkeitsstatus für das Video fest, damit eine geplante Task ausgeführt wird.';
$string['enableschedulingchangevisibilitydesc_massaction'] = 'Legen Sie ein Datum und einen Sichtbarkeitsstatus für das/die ausgewählte(n) Video(s) in der Zukunft fest, die mithilfe einer geplanten Aufgabe ausgeführt werden.';
$string['enableuploadwfconfigpanel'] = 'Workflow-Konfigurationen beim Hochladen anzeigen';
$string['enableuploadwfconfigpaneldesc'] = 'Wenn diese Funktion aktiviert ist, wird das Konfigurationspanel des Upload-Workflows den Lehrkräften während des Video-Uploads auf der Upload-Seite angezeigt. Mit dieser Funktion können Lehrkräfte während des Upload-Prozesses in Opencast je nach Workflow-Struktur weitere Verarbeitungsoptionen oder Eingabewerte festlegen.';
$string['engageplayerintegration'] = 'Engage Player Integration';
$string['engageredirect'] = 'Umleiten zum Engage Player';
$string['engageurl'] = 'URL des Opencast Engage-Servers';
$string['engageurl_desc'] = 'Wenn leer, sind die Videotitel in der Übersicht nicht mit dem Engage Player verknüpft.';
$string['error_block_delete_seriesmapping'] = 'Leider ist beim Löschen der Kurs-Serien-Zuordnung ein Fehler aufgetreten, bitte wenden Sie sich an den Systemadministrator.';
$string['error_duplicated_event_acl_change'] = 'Die Änderung der Sichtbarkeit für den duplizierten Event ist fehlgeschlagen. Opencast-Task ({$a->taskid}) zur Änderung der Sichtbarkeit des duplizierten Events für den Kurs {$a->coursefullname} (ID: {$a->courseid}).';
$string['error_duplicated_event_id_not_ready'] = 'Der duplizierte Event ist noch nicht verfügbar. Opencast Task ({$a->taskid}) zur Änderung der Sichtbarkeit eines duplizierten Events für Kurs {$a->coursefullname} (ID: {$a->courseid}).';
$string['error_eventid_taskdata_missing'] = 'Die Daten des Opencast Tasks enthalten keine Veranstaltungs-ID. Opencast Task zum duplizieren des Events ({$a->taskid}) für Kurs {$a->coursefullname} (ID: {$a->courseid}).';
$string['error_no_duplicate_origin_event_id'] = 'Die ursprüngliche Event-ID fehlt. Opencast dupliziert Event Sichtbarkeit ändern Aufgabe ({$a->taskid}) für Kurs {$a->coursefullname} (ID: {$a->courseid}).';
$string['error_seriesid_missing_course'] = 'Der Kurs {$a->Kursfullname} (ID: {$a->Kursid}) hat keine Kursserie. Die Veranstaltung ({$a->eventid}) konnte nicht wiederhergestellt werden.';
$string['error_seriesid_missing_opencast'] = 'Die Serie des Kurses {$a->coursefullname} (ID: {$a->courseid}) kann im Opencast-System nicht gefunden werden. Das Ereignis ({$a->eventid}) konnte nicht wiederhergestellt werden.';
$string['error_seriesid_not_matching'] = 'Der Kurs {$a->coursefullname} (ID: {$a->courseid}) hat eine Kursserie, die nicht mit der Serien-ID der Aufgabe übereinstimmt. Die Veranstaltung ({$a->eventid}) konnte nicht wiederhergestellt werden.';
$string['error_workflow_not_exists'] = 'Der Workflow {$a->duplicateworkflow} kann im Opencast-System nicht gefunden werden. Das Event ({$a->eventid}) konnte für den Kurs {$a->coursefullname} (ID: {$a->courseid}) nicht wiederhergestellt werden.';
$string['error_workflow_not_started'] = 'Der Workflow zum Kopieren des Videos ({$a->eventid}), das dem Kurs {$a->coursefullname} (ID: {$a->courseid}) zugeordnet ist, konnte nicht gestartet werden.';
$string['error_workflow_setup_missing'] = 'Das Plugin block_opencast ist nicht richtig konfiguriert. Der duplication workflow fehlt!';
$string['errorduplicatedeventvisibilitytaskretry'] = 'Bei der Ausführung eines Events zum Einstellen der Sichtbarkeit des duplizierten Ereignisses ist ein Fehler aufgetreten: {$a} Es wird versuchen, den Workflow mit dem nächsten Cron-Job erneut zu starten.';
$string['errorduplicatedeventvisibilitytaskterminated'] = 'Bei der Ausführung eines Task zum Einstellen der Sichtbarkeit des duplizierten Ereignisses ist ein Fehler aufgetreten: {$a} Nach mehrmaligem Versuch wird der Task jetzt abgebrochen.';
$string['errorduplicatetaskretry'] = 'Bei der Ausführung einer Aufgabe zur Duplizierung eines Events ist ein Fehler aufgetreten: {$a} Es wird versucht, den Workflow mit dem nächsten Cron-Job erneut zu starten.';
$string['errorduplicatetaskterminate'] = 'Bei der Ausführung einer Aufgabe zur Duplizierung eines Events ist ein Fehler aufgetreten: {$a}
    Nach mehrmaligem Versuch wird die Aufgabe jetzt beendet.';
$string['erroremailbody'] = '{$a->errorstr} Details: {$a->message}.';
$string['erroremailsubj'] = 'Fehler beim Ausführen der Task \'Opencast-Prozesses duplizieren\'';
$string['errorgetblockvideos'] = 'Liste kann nicht geladen werden (Error: {$a})';
$string['errorrestorefailedeventsaclchange_body'] = 'Es gab ein Problem bei der Wiederherstellung des Kurses {$a->coursefullname} (ID: {$a->courseid}).
    Die Sichtbarkeit des/der Videos mit der/den folgenden Kennung(en) konnte nicht geändert werden. Diese(s) Video(s) wird/werden im neuen Kurs nicht zugänglich sein:';
$string['errorrestorefailedeventsaclchange_subj'] = 'Opencast-Fehler beim Wiederherstellungsprozess';
$string['errorrestorefailedseriesaclchange_body'] = 'Es gab ein Problem bei der Wiederherstellung des Kurses {$a->coursefullname} (ID: {$a->courseid}).
    Die Zugriffsrechte der Serie konnten nicht geändert werden (series: {$a->seriesid}).';
$string['errorrestorefailedseriesaclchange_subj'] = 'Opencast-Fehler beim Wiederherstellungsprozess';
$string['errorrestorefailedseriesmapping_body'] = 'Es gab ein Problem bei der Wiederherstellung des Kurses {$a->Kursfullname} (ID: {$a->Kursid}). Das Zuordnen der Serie {$a->seriesid} zum neuen Kurs ist fehlgeschlagen.';
$string['errorrestorefailedseriesmapping_subj'] = 'Opencast-Fehler beim Wiederherstellungsprozess';
$string['errorrestoremissingevents_body'] = 'Es ist ein Problem beim Wiederherstellen des Kurses {$a->coursefullname} (ID: {$a->courseid}) aufgetreten. Das Video oder die Videos mit den folgenden Identifiern konnten nicht im Opencast-System gefunden werden. Diese Videos werden nicht wiederhergestellt:';
$string['errorrestoremissingevents_subj'] = 'Opencast-Fehler beim Wiederherstellungsprozess';
$string['errorrestoremissingimportmapping_subj'] = 'Opencast-Fehler beim Wiederherstellungsprozess (Import-Mapping)';
$string['errorrestoremissingimportmode_body'] = 'Es gab ein Problem bei der Wiederherstellung des Kurses {$a->coursefullname} (ID: {$a->courseid}). Der Importmodus konnte nicht identifiziert werden, daher ist die Wiederherstellung fehlgeschlagen.';
$string['errorrestoremissingimportmode_subj'] = 'Opencast-Fehler beim Wiederherstellungsprozess';
$string['errorrestoremissingseries_body'] = 'Es gab ein Problem bei der Wiederherstellung des Kurses {$a->coursefullname} (ID: {$a->courseid}). Es konnte keine Opencast-Serie erstellt werden. Daher konnten die folgenden EventIDs nicht dupliziert werden:';
$string['errorrestoremissingseries_subj'] = 'Opencast-Fehler beim Wiederherstellungsprozess';
$string['errorrestoremissingseriesid_body'] = 'Es gab ein Problem bei der Wiederherstellung des Kurses {$a->coursefullname} (ID: {$a->courseid}). Die Serien-ID konnte nicht gefunden werden.';
$string['errorrestoremissingseriesid_subj'] = 'Opencast-Fehler beim Wiederherstellungsprozess';
$string['errorrestoremissingsourcecourseid_body'] = 'Es gab ein Problem bei der Wiederherstellung des Kurses {$a->coursefullname} (ID: {$a->courseid}). Die Quellkurs-ID konnte nicht gefunden werden.';
$string['errorrestoremissingsourcecourseid_subj'] = 'Opencast-Fehler beim Wiederherstellungsprozess';
$string['eventdeleted'] = 'Das Video wurde gelöscht.';
$string['eventdeletedfailed'] = 'Löschen der Episode fehlgeschlagen';
$string['eventdeletionstarted'] = 'Das Video wird in Kürze gelöscht.';
$string['eventuploadfailed'] = 'Hochladen fehlgeschlagen';
$string['eventuploadsucceeded'] = 'Hochladen erfolgreich';
$string['exists_catalogname'] = 'Das Feld existiert bereits.';
$string['expirydate'] = 'Ablaufdatum';
$string['failedtogetvideo'] = 'Kann keine Eventdaten von Opencast erhalten.';
$string['failedtransferattempts'] = 'Fehlgeschlagene Übertragungsversuche: {$a}';
$string['faileduploadretrylimit'] = 'Begrenzung fehlgeschlagener Upload-Versuche';
$string['faileduploadretrylimitdesc'] = 'Jeder Upload-Auftrag wird archiviert, sobald die maximale Anzahl von Fehlversuchen erreicht ist. Wenn ein Auftrag archiviert wird, müssen die Lehrkräfte entscheiden, ob sie ihn löschen oder manuell erneut in die Warteschlange stellen wollen. <br/>
Der Uploader wird immer benachrichtigt. Wenn die Option „Ereignisstatusbenachrichtigung“ („eventstatusnotificationsabled“) aktiviert ist, werden auch andere Lehrkräfte im Kurs über den Archivierungsstatus informiert.
<br/><strong>HINWEIS:</strong> Ein Wert von 0 (Standard) oder ein leeres Feld bedeutet, dass es keine Begrenzung gibt.';
$string['filetypes'] = 'Akzeptierte Dateitypen';
$string['form_seriesid'] = 'Serien-ID';
$string['form_seriestitle'] = 'Serientitel';
$string['functionalitydisabled'] = 'Diese Funktion ist deaktiviert.';
$string['general_settings'] = 'Allgemeine Einstellungen';
$string['gotooverview'] = 'Zum Überblick...';
$string['group_name_empty'] = 'Das Feld für den Gruppennamen darf nicht leer sein, wenn eine Gruppe angelegt werden soll.';
$string['groupcreation'] = 'Gruppe anlegen';
$string['groupcreationdesc'] = 'Falls ausgewählt, wird eine Gruppe während des Uploads angelegt.';
$string['groupname'] = 'Gruppenname';
$string['groupnamedesc'] = 'Gruppe, zu der das Video hinzugefügt wird. Wichtig: Die Länge des Gruppennamens ist auf 128 Bytes beschränkt. Sie können die Platzhalter [COURSEID] und [COURSENAME] nutzen, die automatisch ersetzt werden.';
$string['groupseries_header'] = 'Gruppe und Serien';
$string['haction'] = 'Aktionen';
$string['heading_actions'] = 'Aktionen';
$string['heading_batchable'] = 'Stapelbar';
$string['heading_datatype'] = 'Feldtyp';
$string['heading_defaultable'] = 'Voreinstellbar';
$string['heading_delete'] = 'Löschen';
$string['heading_description'] = 'Feldbeschreibung';
$string['heading_lti'] = 'Einstellung für LTI Konfiguration';
$string['heading_name'] = 'Feldname';
$string['heading_params'] = 'Parameter (JSON)';
$string['heading_permanent'] = 'Endgültig';
$string['heading_position'] = 'Position';
$string['heading_readonly'] = 'Nur lesen';
$string['heading_required'] = 'Notwendig';
$string['heading_role'] = 'Rolle';
$string['hend_date'] = 'Enddatum';
$string['hlocation'] = 'Ort';
$string['hprovide'] = 'Bereitstellen';
$string['hprovidelti'] = 'Bereitstellen (LTI)';
$string['hpublished'] = 'Veröffentlicht';
$string['hscheduledvisibility'] = 'Geplante Sichtbarkeit';
$string['hstart_date'] = 'Start Datum';
$string['htitle'] = 'Titel';
$string['hvisibility'] = 'Sichtbarkeit';
$string['hworkflow_state'] = 'Status';
$string['identifier'] = 'Kennung';
$string['importfailed'] = 'Die Serie konnte nicht importiert werden.';
$string['importmode'] = 'Import-Modus';
$string['importmodedesc'] = 'Um einen Ansatz für den Import von Videos in einen Kurs zu definieren, sollte ein Modus ausgewählt werden. Der Standardmodus ist „Duplizieren von Events“, bei dem eine neue Serie erstellt wird und Events in der Serie verfügbar sind, indem ein Duplizierungsworkflow verwendet wird. <br /> Beim Modus "Änderung der Zugriffsrechte" hingegen wird die gleiche Seriennummer in den Kursen verwendet, aber die Zugriffsrechte der Serien und Events werden geändert, um den Zugriff von dem Kurs zu gewähren, der die Videos importiert.<br /><strong>HINWEIS:</strong> Derzeit ist die Auswahl von Veranstaltungen in den Import-Assistenten (Kurs und manuell) für „Änderung der Zugriffsrechte“ NICHT möglich, um weitere Komplikationen in Bezug auf die Berechtigungen in Opencast zu vermeiden.';
$string['importseries'] = 'Serie importieren';
$string['importseries_alreadyexists'] = 'Die Serie, die Sie zu importieren versuchen, ist bereits vorhanden. Bitte wählen Sie eine andere Serie.';
$string['importseries_succeeded'] = 'Die Serie wurde erfolgreich importiert.';
$string['importvideos_aclprocessingexplanation'] = 'Die SerienID des ausgewählten Kurses wird in diesem Kurs verwendet und die Zugriffsechte der Serie sowie die Zugriffsrechte ihrer Videos werden entsprechend geändert.';
$string['importvideos_errornotenabledorworking'] = 'Die \'Videos importieren\' Funktion ist entweder nicht aktiviert oder funktioniert nicht.';
$string['importvideos_importbuttontitle'] = 'Videos importieren';
$string['importvideos_importepisodecleanupfailed'] = 'Mindestens eine der bestehenden Opencast-Einzelvideo-Aktivitäten in diesem Kurs konnte nicht angepasst werden. Bitte versuchen Sie es nochmals oder kontaktieren Sie den Moodle Administrator.';
$string['importvideos_importheading'] = 'Videos aus einem anderen Kurs importieren';
$string['importvideos_importjobaclchangealleventsfailed'] = 'Der Import ist teilweise fehlgeschlagen, da die Zugriffsrechte-Änderung für alle Videos fehlgeschlagen ist.<br />Jedoch ist die Serie jetzt diesem Kurs zugeordnet und ihre Zugriffsrechte wurde geändert.';
$string['importvideos_importjobaclchangedone'] = 'Der Import der ausgewählten Serie mit ihren Videos in diesen Kurs war erfolgreich. Sie können nun auf die Videos dieser Liste zugreifen.';
$string['importvideos_importjobaclchangeeventsfailed'] = 'Der Import ist teilweise fehlgeschlagen, da die Zugriffsrechte-Änderung für einige der Videos fehlgeschlagen ist.<br />Die Serie ist nun jedoch diesem Kurs zugeordnet und ihre Zugriffsrechte wurde geändert.<br />Die Zugriffsrechte der folgenden EventIDs konnte nicht geändert werden:';
$string['importvideos_importjobaclchangeseriesfailed'] = 'Der Import ist fehlgeschlagen, weil die Änderung der Zugriffsrechte für die ausgewählte Serie fehlgeschlagen ist.';
$string['importvideos_importjobaclchangeseriesmappingfailed'] = 'Der Import ist fehlgeschlagen, weil die Zuordnung der Serie zum Kurs fehlgeschlagen ist.';
$string['importvideos_importjobcreated'] = 'Der Import der ausgewählten Videos in diesen Kurs wurde in die Warteschlange gestellt. Der Import wird im Hintergrund durchgeführt. Sie müssen nicht auf dieser Seite warten. Sobald der Import angestoßen ist, werden die Videos im Abschnitt <em>Videos, die in diesem Kurs verfügbar sind</em> erscheinen.<br><b>Hinweis:</b> Ein Prozess zur Anpassung der Sichtbarkeit der importierten Videos wird ebenfalls direkt nach Abschluss des Imports ausgeführt, daher wird empfohlen, der Gesamtbearbeitungsdauer mehr Zeit zu geben.';
$string['importvideos_importjobcreationfailed'] = 'Mindestens eines der Videos konnte nicht in diesen Kurs importiert werden. Bitte versuchen Sie es nochmals oder kontaktieren Sie den Moodle Administrator.';
$string['importvideos_importseriescleanupfailed'] = 'Mindestens eine der bestehenden Opencast-Einzelvideo-Aktivitäten in diesem Kurs konnte nicht angepasst werden. Bitte versuchen Sie es nochmals oder kontaktieren Sie den Moodle Administrator.';
$string['importvideos_processingexplanation'] = 'Diese Videos werden in Opencast dupliziert und dann in diesem Kurs verfügbar gemacht werden.';
$string['importvideos_progressbarstep'] = 'Schritt {$a->current} von {$a->last}';
$string['importvideos_sectionexplanation'] = 'In diesem Abschnitt können Sie existierende Videos von anderen Moodle Kursen in diesen Moodle Kurs importieren.';
$string['importvideos_settingcoredefaultvalue'] = 'Standardwert für das Kontrollkästchen "Opencast Videos in diesem Kurs einbeziehen "';
$string['importvideos_settingcoredefaultvalue_desc'] = 'Auswahl eines Standardwerts für das Kontrollkästchen zur Aufnahme von Opencast-Videos im <b>Moodle-Kernimport-Assistenten</b>, mit dem am Ende entschieden wird, ob Videos aufgenommen werden oder nicht. Diese Option soll Trainer/innen helfen, die es vorziehen, die Schaltfläche "Weitere Einstellungen überspringen" zu verwenden und die Schritte des Moodle-Kernimport-Assistenten zu überspringen.';
$string['importvideos_settingcoredefaultvalue_false'] = 'Ungeprüft';
$string['importvideos_settingcoredefaultvalue_true'] = 'Geprüft';
$string['importvideos_settingcoreenabled'] = 'Video Import innerhalb des Moodle Core Kursimports ermöglichen';
$string['importvideos_settingcoreenabled_desc'] = 'Wenn diese Funktion aktiviert ist, können Trainer/innen vorhandene Videodateien aus anderen Moodle-Kursen in ihren Moodle-Kurs importieren, indem sie den Moodle-Assistenten für den Import verwenden. Innerhalb des Assistenten wird eine zusätzliche Option angezeigt, um die Videos zu importieren, die im Opencast-Block des anderen Kurses hochgeladen wurden. Mit dieser Funktion können Trainer/innen alle Videos aus einem anderen Kurs als Bulk importieren, aber sie können keine einzelnen Videos auswählen.<br />
Wenn "Duplizieren von Ereignissen" als Importmodus ausgewählt ist, werden die Videos in Opencast durch eine Ad-hoc-Aufgabe in Moodle dupliziert und erscheinen mit einer kurzen Verzögerung in der Videoliste des Kurses.<br />
Im Importmodus "Änderung der Zugriffsrechte" wird die Seriennummer des zu importierenden Kurses verwendet, aber die ACL der Serie und ihrer Videos wird geändert, um den Zugriff innerhalb des neuen Kurses zu ermöglichen.<br /><strong>Hinweis:</strong> Beim Importmodus "Änderung der Zugriffsrechte" ist die Auswahl der Videos im Assistenten nicht vorgesehen.';
$string['importvideos_settingenabled'] = 'Video-Import ermöglichen';
$string['importvideos_settingenabled_desc'] = 'Wenn diese Option aktiviert ist, können Trainer/innen existierende Videos von anderen Moodle Kursen in ihre Moodle Kurse importieren. Sie müssen über diese Einstellung hinaus noch einen Workflow festlegen mit welchem die Videos dupliziert werden und eine oder beide der folgenden Einstellungen zum manuellen Import oder zum Import innerhalb des Moodle Core Kursimports aktivieren. Falls Sie keine dieser folgenden Einstellungen aktivieren wird auch diese Einstellung hier keine Auswirkung haben.<br />Im Modus "Ereignisse duplizieren" müssen Sie einen Duplizierungsworkflow weiter festlegen.';
$string['importvideos_settinghandleepisodeenabled'] = 'Opencast-Einzelvideo-Aktivitäten während des Video Imports anpassen';
$string['importvideos_settinghandleepisodeenabled_desc'] = 'Wenn diese Option aktiviert ist, können Trainer/innen Opencast-Einzelvideo-Aktivitäten, welche von der "Opencast LTI-Einzelvideo-Aktivität zum Kurs hinzufügen" Funktion erzeugt wurden und sich auf zu importierenden Videos beziehen, anpassen. Dies ist insbesondere hilfreich um Aktivitäten, welche aus einem anderen Kurs importiert wurden aber welche weiterhin auf die Videos im anderen Kurs verweisen, anzupassen. Die Einzelvideo-Aktivitäten werden von einem Moodle Ad-hoc task behandelt und sind nach kurzer Verzögerung angepasst.<br />Bitte beachten Sie dass dieser Mechanismus darauf angewiesen ist, dass der Opencast Duplizier Workflow ein Workflow Instance Configuration Field namens \'duplicate_media_package_1_id\' setzt, welches die Einzelvideo-ID des duplizierten Videos enthält. Falls der Workflow dieses Konfigurationsfeld nicht setzt, wird diese Funktion stets fehlschlagen.';
$string['importvideos_settinghandleseriesenabled'] = 'Opencast-Serien-Aktivitäten während des Video Imports anpassen';
$string['importvideos_settinghandleseriesenabled_desc'] = 'Wenn aktiviert können Trainer/innen Opencast-Serien-Aktivitäten, welche von der "Opencast LTI-Serien-Aktivität zum Kurs hinzufügen" Funktion erzeugt wurden und sich auf zu importierenden Videos beziehen, anpassen lassen. Dies ist insbesondere hilfreich um Aktivitäten, welche aus einem anderen Kurs importiert wurden aber welche weiterhin auf die Serie des anderen Kurs verweisen, anzupassen. Die Serien-Aktivitäten werden direkt nach dem Abschluss des Importassistenten angepasst sein.';
$string['importvideos_settingheader'] = 'Videos aus einem anderen Kurs importieren';
$string['importvideos_settingmanualenabled'] = 'Manuellen Video-Import ermöglichen';
$string['importvideos_settingmanualenabled_desc'] = 'Wenn diese Funktion aktiviert ist, können Trainer/innen vorhandene Videodateien aus anderen Moodle-Kursen in ihren Moodle-Kurs importieren, indem sie einen speziellen Opencast-Videoimport-Assistenten verwenden. Diese Funktion wird auf der Übersichtsseite des Opencast-Blocks angeboten.<br />
Im Importmodus "Duplizieren von Veranstaltungen" können Trainer/innen alle oder eine Teilmenge von Videos aus einem anderen Kurs als Bulk importieren. Die Videos, die im Import-Assistenten ausgewählt werden, werden in Opencast durch eine Ad-hoc-Aufgabe in Moodle dupliziert und erscheinen mit einer kurzen Verzögerung in der Videoliste des Kurses.<br />
Im Importmodus "Änderung der Zugriffsrechte" wird die Seriennummer des Zielkurses im neuen Kurs verwendet. Zusätzlich werden die ACLs der Serie selbst und aller ihrer Videos geändert, um den Zugriff darauf im neuen Kurs zu ermöglichen.<br />
Anders als im Modus "Duplizieren von Veranstaltungen" gibt es im Assistenten keine manuelle Auswahl von Videos.
Beachten Sie bitte, dass es für diese Funktion die entsprechenden Capabilities block/opencast:manualimporttarget und block/opencast:manualimportsource gibt, die steuern, wer welche Kurse in welche Kurse importieren darf. Standardmäßig haben Manager/innen und Trainer/innen diese Fähigkeit und können die Funktion nutzen, sobald sie hier aktiviert ist.<br /><strong>Hinweis:</strong>Beim Importmodus "Änderung der Zugriffsrechte" ist die Auswahl von Videos im Assistenten nicht vorgesehen.';
$string['importvideos_settingmodeacl'] = 'Änderung der Zugriffsrechte';
$string['importvideos_settingmodeduplication'] = 'Duplizieren von Events';
$string['importvideos_settings'] = 'Funktionen zum Import von Videos';
$string['importvideos_wizard_availableseries'] = 'Verfügbare Serien in {$a}';
$string['importvideos_wizard_event_cb_title'] = '{$a->title} (ID: {$a->identifier})';
$string['importvideos_wizard_series_cb_title'] = 'Serie: {$a->title} (ID: {$a->identifier})';
$string['importvideos_wizard_seriesimported'] = 'Zu importierende Serien';
$string['importvideos_wizard_unselectableeventreason'] = 'Videoauswahl';
$string['importvideos_wizard_unselectableeventreason_help'] = 'Der Importmodus für die Opencastinstanz ist auf "Änderung der Zugriffsrechte" eingestellt, was keine Auswahl einzelner Videos ermöglicht. Wenn Sie also diese Serie auswählen, werden alle Videos automatisch importiert.';
$string['importvideos_wizardstep1coursevideos'] = 'Zu importierende Videos';
$string['importvideos_wizardstep1heading'] = 'Quellkurs auswählen';
$string['importvideos_wizardstep1intro'] = 'Wählen Sie den Quellkurs, von dem die Videos importiert werden sollen, aus der folgenden Kursliste aus.<br />Es stehen Ihnen alle Kurse, aus denen Sie Videos importieren dürfen, zur Auswahl.';
$string['importvideos_wizardstep1series'] = 'Standardserie dieses Kurses';
$string['importvideos_wizardstep1seriesnotfound'] = 'Der Quellkurs hat keine gültige Serien-ID, bitte stellen Sie sicher, dass der von Ihnen ausgewählte Kurs eine Standardreihe hat.';
$string['importvideos_wizardstep1sourcecourse'] = 'Videos von diesem Kurs importieren';
$string['importvideos_wizardstep1sourcecoursenone'] = 'Es gibt keinen Kurs außer diesem Kurs von dem Sie Videos importieren dürfen.';
$string['importvideos_wizardstep2aclheading'] = 'Serie auswählen';
$string['importvideos_wizardstep2aclintro'] = 'Wählen Sie die Serie aus, die Sie aus dem Quellkurs importieren möchten.<br/>
Alle Videos aus dieser Serie werden importiert.';
$string['importvideos_wizardstep2coursevideos'] = 'Diese Videos importieren';
$string['importvideos_wizardstep2coursevideosnone'] = 'Im ausgewählten Kurs gibt es keine Videos';
$string['importvideos_wizardstep2coursevideosnoneselected'] = 'Sie müssen mindestens ein Video zum Import auswählen';
$string['importvideos_wizardstep2heading'] = 'Videos auswählen';
$string['importvideos_wizardstep2intro'] = 'Wählen Sie die Videos aus, die Sie aus dem Quellkurs importieren möchten.<br />
Sie können aus allen Videos wählen, die in der Serie des Quellkurses vollständig bearbeitet wurden.<br/><b>Hinweis: </b>Alle ausgewählten Videos werden in eine einzige Serie importiert.';
$string['importvideos_wizardstep3aclheading'] = 'Zusammenfassung';
$string['importvideos_wizardstep3aclintro'] = 'Bitte überprüfen Sie, ob die Zusammenfassung des Videoimports Ihren Erwartungen entspricht, bevor Sie den Import ausführen.';
$string['importvideos_wizardstep3episodemoduleexplanation'] = 'In diesem Kurs existiert mindestens eine Opencast-Einzelvideo-Aktivität, welche sich auf ein Video aus dem Sie die Videos nun importieren, bezieht. Nach dem Import wird diese angepasst werden so dass sie auf das Video in diesem Kurs zeigt.';
$string['importvideos_wizardstep3episodemodulelabel'] = 'Ja, existierende Opencast-Einzelvideo-Aktivitäten für die importierten Videos anpassen';
$string['importvideos_wizardstep3episodemodulesubheading'] = 'Existierende Opencast-Einzelvideo-Aktivität(en) anpassen';
$string['importvideos_wizardstep3heading'] = 'Opencast-Aktivitäten in diesem Kurs anpassen';
$string['importvideos_wizardstep3intro'] = 'In diesem Kurs existieren Opencast-Aktivitäten welche sich auf die zu importierenden Videos beziehen. Diese Aktivitäten werden nach dem Video Import angepasst werden.<br /><strong>Falls Sie sich unsicher sind ob Sie diese Anpassung benötigen, akzeptieren Sie bitte die Voreinstellungen.</strong>';
$string['importvideos_wizardstep3seriesmoduleexplanation'] = 'In diesem Kurs existiert mindestens eine Opencast-Serien-Aktivität, welche sich auf die Serie des Kurses aus dem Sie die Videos nun importieren, bezieht. Nach dem Import wird dies angepasst werden so dass nur noch die Opencast-Serien-Aktivität, welche alle (schon existierenden wie auch jetzt importierten) Videos in diesem Kurs anzeigt, verbleibt.';
$string['importvideos_wizardstep3seriesmodulelabel'] = 'Ja, existierende Opencast-Serien-Aktivitäten für die importierten Videos anpassen';
$string['importvideos_wizardstep3seriesmodulesubheading'] = 'Existierende Opencast-Serien-Aktivität(en) anpassen';
$string['importvideos_wizardstep3skipintro'] = 'In diesem Kurs existieren keine Opencast-Aktivitäten welche sich auf die zu importierenden Videos beziehen.<br />Es muss nichts angepasst werden, bitte gehen Sie zum nächsten Schritt weiter.';
$string['importvideos_wizardstep4coursevideosnone'] = 'Es wurde kein Video zum Import ausgewählt';
$string['importvideos_wizardstep4heading'] = 'Zusammenfassung';
$string['importvideos_wizardstep4intro'] = 'Bitte überprüfen Sie, ob die Zusammenfassung des Videoimports Ihren Erwartungen entspricht, bevor Sie den Import ausführen.<br/>Die Videos werden in die Standardserie importiert.';
$string['importvideos_wizardstep4sourcecoursenone'] = 'Es wurde kein Quellkurs zum Import ausgewählt';
$string['importvideos_wizardstepbuttontitlecontinue'] = 'Weiter';
$string['importvideos_wizardstepbuttontitlerunimport'] = 'Videos importieren und zurück zur Übersicht';
$string['ingest_endpoint_notfound'] = 'Der Ingets-Endpunkt ist nicht verfügbar. Dies muss von der Systemadministration behoben werden.';
$string['ingeststateaddingacls'] = 'Hinzufügen von Rechten und Berechtigungen...';
$string['ingeststateaddingcatalog'] = 'Eventkatalog hinzufügen...';
$string['ingeststateaddingfirsttrack'] = 'Hinzufügen des ersten Tracks...';
$string['ingeststateaddingsecondtrack'] = 'Zweiten Track hinzufügen...';
$string['ingeststatecreatingmedispackage'] = 'Erstellen eines Mediapakets...';
$string['ingeststateingesting'] = 'Ingesting ...';
$string['ingestupload'] = 'Ingest-Upload';
$string['ingestuploaddesc'] = 'Verwenden Sie den Opencast-Ingest-Dienst zum Hochladen von Videos.';
$string['initialvisibilitystatus'] = 'Anfängliche Sichtbarkeit des Videos';
$string['invalidacldata'] = 'Ungültige ACL-Daten';
$string['invalidmetadatafield'] = 'Ungültiges Metadatenfeld gefunden: {$a}';
$string['language'] = 'Sprache';
$string['legendalt'] = 'Weitere Details zu allen möglichen Werten dieser Spalte.';
$string['legenddeletingdesc'] = 'Das Video wird gerade gelöscht und in Kürze entfernt.';
$string['legendocstatecapturingdesc'] = 'Live-Aufnahme in Bearbeitung.';
$string['legendocstatefaileddesc'] = 'Die Verarbeitung dieses Videos ist fehlgeschlagen. Wenden Sie sich an den Support bzw. die Administration, um dieses Problem zu beheben.';
$string['legendocstateneedscuttingdesc'] = 'Das Video erfordert weitere Aufmerksamkeit, um die Verarbeitungsphase abzuschließen.';
$string['legendocstateprocessingdesc'] = 'Das Video wird hochgeladen und von Opencast verarbeitet.';
$string['legendocstatesucceededdesc'] = 'Das Video wurde verarbeitet und ist fertig.';
$string['legendplanneddesc'] = 'Das Video wurde für die Verarbeitung eingeplant.';
$string['legendtitle'] = 'Detailtabelle';
$string['legendvisibility_group'] = 'Gruppensichtbarkeit';
$string['legendvisibility_groupdesc'] = 'Das Video ist für alle Teilnehmer/innen sichtbar, die zu ausgewählten Gruppen gehören.';
$string['legendvisibility_hidden'] = 'Verborgen';
$string['legendvisibility_hiddendesc'] = 'Das Video ist für keine/n Teilnehmer/in sichtbar.';
$string['legendvisibility_mixed'] = 'Ungültig';
$string['legendvisibility_mixeddesc'] = 'Die Sichtbarkeit des Videos befindet sich in einem ungültigen Zustand.';
$string['legendvisibility_visible'] = 'Sichtbar';
$string['legendvisibility_visibledesc'] = 'Das Video ist für alle Kursteilnehmer/innen sichtbar.';
$string['license'] = 'Lizenz';
$string['limituploadjobs'] = 'Uploads durch den Cron-Job begrenzen';
$string['limituploadjobsdesc'] = 'Anzahl der Uploads begrenzen, die von einem Cron-Job vorgenommen werden können. Der Cron-Job kann hier eingestellt werden: {$a}';
$string['limitvideos'] = 'Anzahl von Videos';
$string['limitvideosdesc'] = 'Maximale Anzahl von Videos, die in diesem Block angezeigt werden';
$string['linkedinblock'] = 'Verlinkt im Block';
$string['liveupdate_fail_notification_message'] = 'Für folgende(s) Ereignis(e) kann keine Live-Statusaktualisierung durchgeführt werden:<br> <ul><li>{$a}</li></ul>';
$string['liveupdate_reloadtimeout'] = 'Zeitüberschreitung beim Neuladen der Seite (in Sekunden)';
$string['liveupdate_reloadtimeout_desc'] = 'Die Zeitspanne in Sekunden, nach der die Seite neu geladen wird, wenn ein aktualisierter Status festgestellt wird. Wenn leer oder kleiner als 0, wird ein Standardwert von 3 Sekunden verwendet. <br>HINWEIS: Bevor die Seite neu geladen wird, werden die Trainer/innen benachrichtigt. Das Neuladen ist wichtig, damit alle erforderlichen Backend-Prozesse stattfinden können.';
$string['liveupdate_settingenabled'] = 'Funktion zur Live-Statusaktualisierung aktivieren';
$string['liveupdate_settingenabled_desc'] = 'Wenn diese Funktion aktiviert ist, werden der Status des Hochladens und der Status der Workflow-Verarbeitung überwacht, wenn sie sich in einem laufenden Prozess befinden.<br> Dies geschieht, indem die Statusinformationen für diese Prozesse in einem 1-Sekunden-Intervall abgerufen werden.';
$string['liveupdate_settingheader'] = 'Live-Status-Update';
$string['liveupdate_toast_notification'] = 'Event: ({$a->title}) wird aktualisiert. Die Seite wird in {$a->timeout} Sekunden neu geladen.';
$string['loading'] = 'Loading...';
$string['location'] = 'Raum';
$string['ltimodule_settings'] = 'Funktionen zum Anlegen von Opencast Aktivitäten';
$string['managedefaultredirectlinkwithexp'] = 'Sie können Standardwerte für diese Metadatenfelder hinzufügen, indem Sie:';
$string['managedefaultsforuser'] = 'Standardwerte verwalten';
$string['managedefaultsforuser_desc'] = 'Hier können Sie Standardwerte für Metadatenfelder verwalten, die zum Hinzufügen von Videos und zum Erstellen neuer Serien verwendet werden. Wenn Sie hier einen Standardwert für ein Feld hinzufügen, wird dieser automatisch als vordefinierter Wert (Standard) in das Feld auf den genannten Seiten eingefügt..<br /> HINWEIS: Falls diese Seite leer ist oder Sie nach einem Feld suchen, das hier nicht vorhanden ist, wenden Sie sich bitte an Ihren Systemadministrator und bitten Sie ihn, die Metadatenfelder als vordefinierbar zu konfigurieren.';
$string['manageseriesforcourse'] = 'Serien verwalten';
$string['managetranscription_overwrite_info'] = 'Das Überschreiben von Untertiteln ist nur für manuell hochgeladene Untertitel über dieses Plugin möglich. Automatisch generierte Untertitel und solche, die außerhalb dieses Plugins hochgeladen werden und nicht den gleichen Untertitel flavor haben, können nicht überschrieben werden.';
$string['managetranscriptions'] = 'Transkriptionen verwalten';
$string['managetranscriptions_header'] = 'Transkriptionen von Event\'s verwalten';
$string['massaction_invalidactionparam'] = 'Ungültiger Pfad-Parameter der Aktions-URL';
$string['massaction_invaliddefaultactions'] = 'Unzulässige Aktionen entdeckt!';
$string['massaction_selectedvideos_list'] = 'Sie haben das/die folgende(n) Video(s) ausgewählt: <br><ul><li>{$a}</li></ul>';
$string['massaction_videostatusmismatched'] = 'Ungeeigneter Videoverarbeitungsstatus!';
$string['maxseries'] = 'Maximale Anzahl von Serien';
$string['maxseriesdesc'] = 'Gibt an, wie viele Serien einem Kurs zugewiesen werden können. Trainer können keine weiteren Serien hinzufügen/importieren, wenn die maximale Anzahl erreicht ist.';
$string['maxseriesreached'] = 'Sie können diesem Kurs keine weitere Serie hinzufügen, da der Kurs bereits die maximale Anzahl von Serien enthält.';
$string['maxseriesreachedimport'] = 'Derzeit können Sie keine weitere Serie importieren, da der Kurs bereits die maximale Anzahl von Serien enthält.';
$string['mediatype'] = 'Medienquelle';
$string['messageprovider:error'] = 'Fehlerbenachrichtigung bei der Verarbeitung';
$string['messageprovider:opencasteventstatus_notification'] = 'Benachrichtigung über den Status eines Opencast-Ereignisses';
$string['messageprovider:reportproblem_confirmation'] = 'Kopie der gemeldeten Probleme für Opencast Videos';
$string['metadata'] = 'Event Metadaten';
$string['metadata_autocomplete_noselectionstring'] = 'Kein {$a} angegeben!';
$string['metadata_autocomplete_placeholder'] = '{$a} eingeben';
$string['metadatadesc'] = 'Hier können Sie festlegen, welche Metadatenfelder beim Hochladen von Videos nach Opencast gesetzt werden können oder müssen. Sie können Zeilen per Drag & Drop neu anordnen und die Position der Felder im Formular definieren.';
$string['metadataexplanation'] = 'Beim Hochladen existierender Videodateien nach Opencast können Sie mehrere Metadaten Felder befüllen. Diese werden zusammen mit dem Video gespeichert werden.';
$string['metadataseries'] = 'Serien-Metadaten';
$string['metadataseriesdesc'] = 'Hier können Sie festlegen, welche Metadatenfelder für Opencast-Serien beim Hochladen von Videos gesetzt werden können oder müssen. Sie können Zeilen per Drag & Drop neu anordnen und die Position der Felder im Formular definieren.';
$string['metadataseriesupdatefailed'] = 'Fehler beim Aktualisieren der Serienmetadaten.';
$string['missingevent'] = 'Anlegen des Termins fehlgeschlagen';
$string['missinggroup'] = 'Fehlende Gruppe in Opencast';
$string['missingseries'] = 'Fehlende Serie in Opencast';
$string['missingseriesassignment'] = 'Fehlende Serienzuweisung';
$string['morethanonedefaultserieserror'] = 'Dieser Kurs hat mehr als eine Standardserie. Bitte wenden Sie sich an Ihren Systemadministrator.';
$string['morevideos'] = 'Weitere Videos...';
$string['mstatearchived'] = 'Archiviert';
$string['mstatecreatingevent'] = 'Hochladen...';
$string['mstatecreatinggroup'] = 'Opencast-Gruppe anlegen...';
$string['mstatecreatingseries'] = 'Opencast-Serie anlegen...';
$string['mstatereadytoupload'] = 'Bereit zur Übertragung';
$string['mstatetransferred'] = 'Übertragen';
$string['mstateunknown'] = 'Status unbekannt';
$string['mstateuploaded'] = 'Es werden Post-Upload-Aufgaben verarbeitet...';
$string['no_ingest_services'] = 'Keine verfügbaren Ingest-Knoten gefunden.';
$string['noconnectedseries'] = 'Es ist noch keine Serie definiert.';
$string['noseriesfound'] = 'Keine Serien zu finden.';
$string['noseriesid'] = 'Die Serien-ID ist bisher nicht festgelegt.';
$string['nothingtodisplay'] = 'In diesem Abschnitt sehen Sie die Videos, welche in diesem Kurs hochgeladen wurden.<br />Aktuell wurden in diesem Kurs noch keine Videos hochgeladen.';
$string['notificationcleanupimportedmodules_subj'] = 'Benachrichtigung über importierte Opencast-Module bei Bereinigungsaufgaben';
$string['notificationcleanupimportedmodulescleanupfailed_body'] = 'Der Bereinigungsauftrag mit der Workflow-ID: ({$a->workflowid}) für den Kurs {$a->coursefullname} (ID: {$a->courseid}) schlug bei der Aktualisierung der Episodenaktivitäten fehl und wird entfernt';
$string['notificationcleanupimportedmodulesexpired_body'] = 'Bereinigungsauftrag mit Workflow-ID: ({$a->workflowid}) für Kurs {$a->coursefullname} (ID: {$a->courseid}) wurde entfernt, da wir 5 Tage lang erfolglos gewartet haben, um die duplizierte Episoden-ID von OC zu erhalten.';
$string['notificationcleanupimportedmodulesgeneralexception_body'] = 'Bereinigungsauftrag mit Workflow-ID: ({$a->workflowid}) für Kurs {$a->coursefullname} (ID: {$a->courseid}) ist fehlgeschlagen und wird entfernt. Die Fehlermeldung enthält: {$a->exceptionmessage}';
$string['notificationcleanupimportedmodulesnoeposideid_body'] = 'Bereinigungsauftrag mit Workflow-ID: ({$a->workflowid}) für Kurs {$a->coursefullname} (ID: {$a->courseid}) wurde entfernt, da der gespeicherte OC-Workflow nicht existiert oder keine duplizierte Episoden-ID enthält und auch nicht enthalten wird.';
$string['notificationeventstatus'] = 'Benachrichtigung über den Status von Ereignissen zulassen';
$string['notificationeventstatus_body'] = 'Der Verarbeitungsstatus des hochgeladenen Videos: {$a->videotitle} (ID: {$a->videoidentifier}) im Kurs {$a->coursefullname} (ID: {$a->courseid}) wurde geändert auf: {$a->statusmessage}';
$string['notificationeventstatus_desc'] = 'Diese Option ermöglicht es dem System, Benachrichtigungen über den Status des hochgeladenen Videos von Opencast während des Prozesses an die Benutzer zu senden. Diese Option schließt nur die hochladende Person des Videos in die Nutzerliste ein. Um alle Trainer/innen des Kurses zu benachrichtigen, sollte die folgende Einstellung aktiviert sein.<br />Diese Funktion wird über eine geplante Aufgabe ausgeführt, die jede Minute laufen sollte.';
$string['notificationeventstatus_subj'] = 'Benachrichtigung über den Status von Opencast-Ereignis';
$string['notificationeventstatusdeletion'] = 'Bereinigungsbenachrichtigung nach (Tagen)';
$string['notificationeventstatusdeletion_desc'] = 'Diese Einstellung legt eine Frist in Tagen für die noch nicht abgeschlossenen Aufträge fest. Nach Erreichen der Frist wird der Auftrag trotz seines Bearbeitungsstatus gelöscht. <br />Diese Funktion hilft dabei, die ausstehenden Benachrichtigungsaufträge aus der Liste zu entfernen. Dies geschieht über eine geplante Aufgabe, die am besten einmal täglich ausgeführt wird. <br />HINWEIS: (Null) Der Wert "0" deaktiviert die Einstellung.';
$string['notificationeventstatusteachers'] = 'Benachrichtigung aller Trainer/innen über den Status des Verarbeitungsprozesses';
$string['notificationeventstatusteachers_desc'] = 'Mit dieser Option werden neben der hochladenden Person des Videos auch alle Trainer/innen des Kurses, aus dem das Video hochgeladen wurde, über den Bearbeitungsstatus von Opencast informiert.';
$string['notifications_settings_header'] = 'Benachrichtigungen';
$string['notificationuploadarchived_body'] = 'Der Upload-Auftrag für das Video mit dem Titel „{$a->title}“ im Kurs „{$a->coursefullname}“ (ID: {$a->courseid}) wurde archiviert, da die Anzahl der Fehlversuche erreicht wurde. Sie müssen nun entweder den Auftrag löschen oder ihn manuell wieder in die Warteschlange stellen. Bitte wenden Sie sich an Ihren Systemadministrator, um sicherzustellen, dass das Upload-Problem behoben ist.';
$string['notificationuploadarchived_subj'] = 'Opencast archivierte Event Upload-Benachrichtigung';
$string['notificationuploaduqeuestatus_body'] = 'Der Verarbeitungsstatus dieses Videos: {$a->videotitle} im Kurs: {$a->coursefullname} (ID: {$a->courseid}) ist in der Warteschlange, wurde aber noch nicht gestartet.
Das Video wartet derzeit hinter {$a->waitingnum} anderen Videos in der Verarbeitungswarteschlange.';
$string['notificationuploaduqeuestatus_subj'] = 'Opencast-Ereignis Upload-Benachrichtigung';
$string['notpublished'] = 'Nicht veröffentlicht';
$string['notranscription'] = 'Dieses Video hat noch keine Transkription.';
$string['nouserselected'] = 'Sie müssen einen Benutzer auswählen.';
$string['novideosavailable'] = 'Keine Videos';
$string['novisibilitychange'] = 'Es sind keine Änderungen zu erkennen, bitte stellen Sie sicher, dass alles korrekt ist.';
$string['novisibilityrecordfound'] = 'Sichtbarkeitsdatensatz konnte nicht gefunden werden.';
$string['ocstatecapturing'] = 'Aufzeichnen';
$string['ocstatefailed'] = 'Fehlgeschlagen';
$string['ocstateneedscutting'] = 'Schnitt erforderlich';
$string['ocstateprocessing'] = 'Wird verarbeitet';
$string['ocstatesucceeded'] = 'Erfolgreich';
$string['offerchunkuploadalternative'] = 'Standard Dateiauswahl als Alternative anbieten';
$string['offerchunkuploadalternative_desc'] = 'Wenn diese Einstellung aktiviert ist, wird eine Checkbox mit der Beschriftung \'{$a}\' unterhalb des Chunk-Upload Formularelements angezeigt werden. Sobald die Checkbox aktiviert wird, wird das Chunk-Upload Formularelement verborgen und die standardmäßige Moodle Dateiauswahl wird angezeigt werden, welches den Zugriff auf alle Moodle Repositories ermöglicht.';
$string['only_delete_block'] = 'Block löschen, aber Serienzuordnung beibehalten';
$string['opencast:addactivity'] = 'Opencast Video Provider Aktivität zum Kurs hinzufügen';
$string['opencast:addactivityepisode'] = 'Opencast Video Provider Aktivität für eine Episode zum Kurs hinzufügen';
$string['opencast:addinstance'] = 'Neuen Block \'Opencast Videos\' hinzufügen';
$string['opencast:addlti'] = 'Opencast LTI-Serien-Aktivität zum Kurs hinzufügen';
$string['opencast:addltiepisode'] = 'Opencast LTI-Einzelvideo-Aktivität zum Kurs hinzufügen';
$string['opencast:addvideo'] = 'Neues Video zum Block \'Opencast Videos\' hinzufügen';
$string['opencast:autocompleteteacherroles'] = 'Trainerrollen, die extrahiert und in der Autovervollständigungsliste bereitgestellt werden sollen';
$string['opencast:canchangeownerforallvideos'] = 'Besitzer/in für alle Videos ändern können';
$string['opencast:createseriesforcourse'] = 'In Opencast eine neue Serie für einen Moodle-Kurs anlegen';
$string['opencast:deleteevent'] = 'Video (Episode) endgültig in Opencast löschen';
$string['opencast:directaccessvideolink'] = 'Direkter Zugang zum Video über einen geteilten Link';
$string['opencast:downloadvideo'] = 'Verarbeitete Videos herunterladen';
$string['opencast:importseriesintocourse'] = 'Importieren einer bestehenden Opencast-Serie in einen Moodle-Kurs';
$string['opencast:manageseriesforcourse'] = 'Verwalten Sie die Opencast-Serien eines Moodle-Kurses: Rufen Sie die Datei manageseries.php auf, heben Sie die Verknüpfung zwischen Serien und Kurs auf und wählen Sie die Standard-Serie aus.';
$string['opencast:manualimportsource'] = 'Videos manuell von diesem Kurs importieren';
$string['opencast:manualimporttarget'] = 'Videos manuell von anderen Kursen importieren';
$string['opencast:myaddinstance'] = 'Neuen Block \'Opencast Videos\' im Dashboard hinzufügen';
$string['opencast:sharedirectaccessvideolink'] = 'Direktzugriffslink zum Video teilen';
$string['opencast:startworkflow'] = 'Manuelles Starten der Workflows für Videos';
$string['opencast:unassignevent'] = 'Zuweisung eines Videos im Kurs aufheben, in dem es hochgeladen wurde.';
$string['opencast:viewunpublishedvideos'] = 'Alle Videos auf dem Opencast-Server ansehen, auch wenn sie nicht veröffentlicht sind.';
$string['opencast:viewusers'] = 'Zeigen Sie alle Nutzer/innen an, damit der/die Eigentümer/in der Serie/des Events im Dashboard geändert werden kann.';
$string['opencasteditorintegration'] = 'Opencast Editor Integration';
$string['opencastseries'] = 'Opencast Serien';
$string['opencaststudiobaseurl'] = 'Opencast Studio Basis-URL';
$string['opencaststudiobaseurl_desc'] = 'Die Basis-URL, die für den Aufruf von Opencast Studio verwendet wird. Falls leer, wird die Basis-URL der Opencast-Instanz verwendet.';
$string['opencaststudiocustomsettingsfilename'] = 'Dateiname der benutzerdefinierten Studio-Einstellungen';
$string['opencaststudiocustomsettingsfilename_desc'] = 'Dieser Dateiname für die benutzerdefinierten Einstellungen wird bei der Weiterleitung an Studio an die Abfrage angehängt. Danach sucht das Studio nach diesem Dateinamen relativ zu seinem Verzeichnis und liest seine Einstellungen aus dieser Datei. <br><b>Hinweis</b>: Benötigt Opencast 14.2 oder höher.';
$string['opencaststudiointegration'] = 'Opencast Studio Integration';
$string['opencaststudionewtab'] = 'Weiterleitung zu Studio in einem neuen Tab';
$string['opencaststudionewtab_desc'] = 'Wenn diese Option aktiviert ist, wird das Studio in einem neuen Tab geöffnet.';
$string['opencaststudioreturnbtnlabel'] = 'Label für die Zurück-Taste von Studio';
$string['opencaststudioreturnbtnlabel_desc'] = 'Dieses Label dient als kurze Beschreibung, wohin der Return-Link führt. Dieses Label wird an den Text der Studio-Return-Schaltfläche angehängt, wenn es leer ist, wird der Name der Moodle-Website als Label übergeben.';
$string['opencaststudioreturnurl'] = 'Benutzerdefinierte Studio-Rückgabe-Endpunkt-URL';
$string['opencaststudioreturnurl_desc'] = 'Wenn sie leer ist, leitet die Rückgabe-URL zurück zur gleichen Moodle-Opencast-Blockübersicht, aus der die Anfrage stammt. Eine benutzerdefinierte Endpunkt-URL wird dann an Studio als Rückgabe-URL übergeben, wenn sie konfiguriert ist. In diesem Fall kann der Administrator 2 Platzhalter verwenden, einschließlich [OCINSTANCEID] und [COURSEID]. Bitte beachten Sie: Die URL muss relativ zu wwwroot sein.';
$string['overview'] = 'Überblick';
$string['ownedvideosoverview'] = 'Ihre Videos';
$string['ownedvideosoverview_explanation'] = 'Hier können Sie alle Videos sehen, die Ihnen gehören, auf deren Serien Sie aber keinen Zugriff haben.';
$string['owner'] = 'Besitzer/in';
$string['planned'] = 'Geplant';
$string['pluginname'] = 'Opencast Videos';
$string['presentation'] = 'Präsentations-Video';
$string['presentationdesc'] = 'Nutzen Sie das Präsentations-Video, falls Sie eine Video Datei mit der Aufzeichnung einer Folienpräsentation oder einem Screencast vorliegen haben.';
$string['presentationfile'] = 'Präsentations Datei';
$string['presenter'] = 'Präsentator-Video';
$string['presenterdesc'] = 'Nutzen Sie das Präsentator-Video, falls Sie eine Videodatei mit der Aufzeichnung eines Vortrags oder einen Film vorliegen haben.';
$string['presenterfile'] = 'Präsentator Datei';
$string['privacy:metadata:block_opencast_uploadjob'] = 'Information zu Video-Uploads';
$string['privacy:metadata:block_opencast_uploadjob:courseid'] = 'ID des Kurses, in dem das Video hochgeladen wird';
$string['privacy:metadata:block_opencast_uploadjob:fileid'] = 'ID der Datei/des Videos, das hochgeladen wird';
$string['privacy:metadata:block_opencast_uploadjob:opencasteventid'] = 'ID der Opencast-Episode, die durch den Upload angelegt wird';
$string['privacy:metadata:block_opencast_uploadjob:status'] = 'Status des Upload-Prozesses';
$string['privacy:metadata:block_opencast_uploadjob:timecreated'] = 'Datum des Uploads';
$string['privacy:metadata:block_opencast_uploadjob:timemodified'] = 'Datum der letzten Modifizierung des Uploads';
$string['privacy:metadata:block_opencast_uploadjob:userid'] = 'ID der Person, die das Video hochgeladen hat';
$string['privacy:metadata:core_files'] = 'Der Block \'Opencast Videos\' speichert Dateien (Videos), die von einer Person hochgeladen werden.';
$string['privacy:metadata:opencast'] = 'Der Block \'Opencast Videos\' interagiert mit einer Opencast-Instanz, mit der Daten ausgetauscht werden.';
$string['privacy:metadata:opencast:file'] = 'Die ausgewählte Datei wird nach Opencast hochgeladen.';
$string['processattachment'] = 'Uploadaufträge für Anhänge verarbeiten';
$string['processdelete'] = 'Löschen verarbeiten';
$string['processdeletenotification'] = 'Systemnachricht zur Verarbeitung von Löschaufträgen';
$string['processepisodecleanup'] = 'Opencast LTI-Einzelvideos nach Kursimport bereinigen';
$string['processltimodulecleanup'] = 'Routinebereinigung der Opencast Video LTI-Episode verarbeiten';
$string['processltimodulecleanup_error'] = 'Beim Bereinigungsprozess des LTI-Moduls ist etwas schief gelaufen: {$a}';
$string['processnotification'] = 'Systemnachricht zum Status der Auftragsverarbeitung nach dem Hochladen von Videos';
$string['processupload'] = 'Upload verarbeiten';
$string['processvisibility'] = 'Geplante Aufträge zur Sichtbarkeitsänderung verarbeiten';
$string['publisher'] = 'Herausgeber/in';
$string['publishtoengage'] = 'Zum Engage Player veröffentlichen';
$string['publishtoengagedesc'] = 'Diese Option wählen, um das Video nach dem Upload zum Engage Player zu veröffentlichen. Der eingestellte Workflow muss dies unterstützen.';
$string['readonly_disabled_tooltip_text'] = 'Die Option "Schreibgeschützt" kann nicht gesetzt werden, obwohl sie als erforderlich eingestellt ist.';
$string['recordvideo'] = 'Video aufnehmen';
$string['reportproblem_email'] = 'Dies ist eine automatische Benachrichtigung des Moodle Opencast Plugins.<br>Jemand hat ein Problem mit einem Video gemeldet.<br><br><b>Nutzer/in: </b>{$a->username}<br><b>E-Mail-Adresse: </b>{$a->useremail}<br><b>Moodlekurs: </b><a href="{$a->courselink}">{$a->course}</a><br><b>Opencast Serie: </b>{$a->series} (Id: {$a->seriesid})<br><b>Opencast-Event-ID: </b>{$a->event} (Id: {$a->eventid})<br><b>Nachricht:</b><br><hr>{$a->message}<hr>';
$string['reportproblem_failure'] = 'Die E-Mail konnte nicht gesendet werden. Bitte wenden Sie sich direkt an das Support-Team.';
$string['reportproblem_modal_body'] = 'Wenn Sie ein Problem mit einem Video haben, können Sie es dem Support-Team melden.';
$string['reportproblem_modal_placeholder'] = 'Bitte erläutern Sie das Problem.';
$string['reportproblem_modal_required'] = 'Bitte geben Sie eine Nachricht ein.';
$string['reportproblem_modal_submit'] = 'Problem melden';
$string['reportproblem_modal_title'] = 'Ein Problem melden';
$string['reportproblem_notification'] = '#### Dies ist eine Kopie der E-Mail, die an das Support-Team gesendet wurde. ####<br>';
$string['reportproblem_subject'] = 'Moodle Opencast Plugin: Problem gemeldet';
$string['reportproblem_success'] = 'Die E-Mail wurde erfolgreich an das Support-Team gesendet.';
$string['restoreopencastvideos'] = 'Videos wiederherstellen von Opencast-Instanz {$a}';
$string['reuseexistingupload'] = 'Bereits existierende Uploads nutzen';
$string['reuseexistinguploaddesc'] = 'Falls aktiviert, werden Videos mit demselben content hash nur einmal nach Opencast hochgeladen. Dies spart Speicherplatz und Rechenleistung, aber es könnte Probleme verursachen, wenn Sie mit spezifischen Zugangsrichtlinien zu Opencast-Serien arbeiten.';
$string['rightsHolder'] = 'Rechte';
$string['role_not_defined'] = 'Die Rolle ist nicht in der Tabelle Zugriffsrechte-Rollen definiert.';
$string['role_not_permanent'] = 'Die Rolle ist in der Zugriffsrechte-Rollentabelle nicht als permanent definiert.';
$string['rolename'] = 'Rollenname';
$string['savedefaults'] = 'Standardeinstellungen speichern';
$string['scheduledvisibilitychangefailed'] = 'Das Planen einer Sichtbarkeitsänderung war nicht erfolgreich. Sie können eine neue Änderung planen oder sie deaktivieren, um ihre Aufgabe zu entfernen.';
$string['scheduledvisibilityicontitle'] = 'Klicken Sie hier, um die geplante Sichtbarkeitsänderung für das Event zu bearbeiten.';
$string['scheduledvisibilitystatus'] = 'Ändern der Videosichtbarkeit auf';
$string['scheduledvisibilitystatuserror'] = 'Die geplante Sichtbarkeit und die ursprüngliche Sichtbarkeit müssen sich unterscheiden.';
$string['scheduledvisibilitytime'] = 'Ändern der Videosichtbarkeit';
$string['scheduledvisibilitytimeerror'] = 'Der geplante Zeitpunkt zum Ändern der Sichtbarkeit muss mindestens 20 Minuten nach dem aktuellen Datum und der aktuellen Uhrzeit liegen.';
$string['scheduledvisibilitytimehi'] = 'Geplanter Zeitpunkt';
$string['scheduledvisibilitytimehi_help'] = 'Dieser Zeitpunkt muss in der Zukunft und wie empfohlen mindestens 20 Minuten nach der aktuellen Datumszeit eingestellt werden. Je schneller Ihr Opencast-Server das Video verarbeitet, desto näher kann dieser Zeitpunkt eingestellt werden.';
$string['scheduledvisibilityupdatefailed'] = 'Die geplante Sichtbarkeitsänderung konnte nicht gespeichert werden.';
$string['series'] = 'Serie';
$string['series_already_exists'] = 'Dieser Kurs wurde bereits einer Serie zugewiesen.';
$string['series_does_not_exist'] = 'Die diesem Kurs zugewiesene Serie ist nicht gültig. Bitte kontaktieren Sie den Administrator.';
$string['series_does_not_exist_admin'] = 'Die Serie mit dem Identifier \'{$a}\' konnte nicht von Opencast abgerufen werden.';
$string['series_name_empty'] = 'Serienname darf nicht leer sein.';
$string['series_not_found'] = 'Die Serie {$a} konnte in Opencast nicht gefunden werden.';
$string['series_used'] = 'Wird in {$a} Kursen verwendet';
$string['seriescreated'] = 'Die Serie wurde angelegt.';
$string['seriesidnotvalid'] = 'Die Serie existiert nicht.';
$string['seriesidsaved'] = 'Die Serien-ID wurde gespeichert.';
$string['seriesidunset'] = 'Die Serien-ID wurde entfernt.';
$string['serieslinkedinblock'] = 'Im Block verlinkte Serien';
$string['seriesname'] = 'Serienname';
$string['seriesnamedesc'] = 'Serie, zu der das Video hinzugefügt wird. Sie können Platzhalter nutzen, welche automatisch ersetzt werden (<a target="_blank" href="https://moodle.docs.opencast.org/#block/general_settings/#placeholders">Liste der Platzhalter</a>).';
$string['seriesnotcreated'] = 'Die Serie konnte nicht angelegt werden.';
$string['seriesonedefault'] = 'Es darf nur eine Standard-Serie existieren.';
$string['seriesoverview'] = 'Serienübersicht';
$string['seriesoverviewexplanation'] = 'Hier sehen Sie alle Serien, die in einem Kurs verwendet werden, für den Sie die Berechtigung haben, Videos zu verwalten.<br>Serien können vom Block im Kurs verwaltet werden und/oder werden als Aktivität für die Studierenden bereitgestellt.';
$string['seriesoverviewof'] = 'Serienübersicht der Instanz {$a}';
$string['setdefaultseries'] = 'Möchten Sie diese Serie wirklich als neue Standard-Serie verwenden?';
$string['setdefaultseries_heading'] = 'Als Standard-Serie festlegen';
$string['setdefaultseriesfailed'] = 'Die Änderung der Standard-Serie ist fehlgeschlagen. Versuchen Sie es bitte später erneut oder kontaktieren Sie einen Administrator.';
$string['setdefaultseriessucceeded'] = 'Die Standardserie wurde erfolgreich geändert.';
$string['setting_permanent'] = 'Ist permanent';
$string['settings'] = 'Opencast Videos';
$string['shared_settings'] = 'Geteilte Einstellungen';
$string['showvideos'] = 'Videos anzeigen';
$string['source'] = 'Quelle';
$string['space_catalogname'] = 'Das Feld darf keine Leerzeichen enthalten';
$string['startDate'] = 'Datum';
$string['startTime'] = 'Zeit';
$string['startworkflow'] = 'Starte Workflow';
$string['startworkflow_modal_body'] = 'Wählen Sie den Workflow aus, den Sie starten möchten.';
$string['startworkflow_modal_configpanel_title'] = 'Workflow-Konfigurationspanel';
$string['startworkflow_modal_description_title'] = 'Workflow Beschreibung';
$string['subjects'] = 'Betreff';
$string['submit'] = 'Änderungen speichern';
$string['support_setting'] = 'Support E-Mail-Adresse';
$string['support_setting_notset'] = 'Die Support E-Mail-Adresse wurde nicht definiert. Kontaktieren Sie bitte den Administrator und senden Sie den Bericht erneut.';
$string['support_settingdesc'] = 'E-Mailadresse, an die Berichte gesendet werden, wenn User Probleme mit Videos melden.';
$string['swprivacynotice_settingheader'] = 'Datenschutzhinweis für Workflows';
$string['swprivacynotice_settinginfotext'] = 'Info-Text für Datenschutzhinweise zu Workflows';
$string['swprivacynotice_settinginfotext_desc'] = 'Diese Eingabe wird verwendet, um Informationen über Datenschutzhinweise für Workflows im Dialogfeld Workflow starten bereitzustellen.<br><strong>Hinweis</strong> Wenn sie leer ist, wird kein Hinweis angezeigt.';
$string['swprivacynotice_settingtitle'] = 'Titel Workflow-Datenschutzhinweis';
$string['swprivacynotice_settingtitle_desc'] = 'Ein Titel, der im Start-Workflow-Dialog angezeigt wird. Er soll konfigurierbar sein, damit er von den Benutzern angepasst werden kann. Ist er leer, wird ein Standardwert verwendet.';
$string['swprivacynotice_settingwfds'] = 'Liste der Workflow-Definitionen';
$string['swprivacynotice_settingwfds_desc'] = 'Eine durch Kommata getrennte Liste von Workflow-Definitionen, bei denen der Datenschutzhinweis angezeigt wird. Wenn sie leer ist, wird der Datenschutzhinweis für alle Workflows angezeigt.';
$string['swprivacynoticedefaulttitle'] = 'Datenschutzhinweis';
$string['termsofuse'] = 'Nutzungsbedingungen';
$string['termsofuse_accept'] = 'Ich habe die {$a} gelesen und stimme diesen zu.';
$string['termsofuse_accept_toggle'] = 'Nutzungsbedingungen';
$string['termsofuse_desc'] = 'Wenn Sie einen Text eingeben, wird auf der Seite "Video-Upload" ein Kontrollkästchen mit den Nutzungsbedingungen angezeigt.
Die Nutzer müssen die eingegebenen Nutzungsbedingungen akzeptieren, bevor sie das Video hochladen können.';
$string['title'] = 'Titel';
$string['tool_requirement_not_fulfilled'] = 'Die erforderliche Version von tool_opencast ist nicht installiert.';
$string['transcriptionaction_thead'] = 'Aktionen';
$string['transcriptionaddnewbtn'] = 'Weitere Transkriptionssätze hinzufügen';
$string['transcriptiondeletebtn'] = 'Transkriptionssatz löschen';
$string['transcriptiondeletionfailed'] = 'Transkription konnte nicht gelöscht werden';
$string['transcriptiondeletionsucceeded'] = 'Transkription erfolgreich gelöscht.';
$string['transcriptionfileextensions'] = 'Erlaubte Transkriptions-Dateierweiterungen';
$string['transcriptionfileextensions_desc'] = 'Kommagetrennte Liste der zulässigen Transkriptionsdateierweiterungen (Erweiterungen müssen in der <a href="{$a}">Dateitypenliste</a> von Moodle vorhanden sein).
Wenn diese Option leer gelassen wird, sind alle Erweiterungen vom Typ "HTML-Track-Dateien" erlaubt (siehe auch <a href="{$a}">Dateitypen</a>).';
$string['transcriptionfilefield'] = 'Transkriptionsdatei';
$string['transcriptionheader'] = 'Hochladen von Transkriptionsdateien';
$string['transcriptionheaderexplanation'] = 'In diesem Bereich können Sie für jeden Servicetyp eine Transkriptionsdatei mit einer bestimmten Dateierweiterung hochladen, die dann zusammen mit dem Video hochgeladen und entsprechend verarbeitet wird, um die (Sprache-zu-Text-)Funktion bereitzustellen.';
$string['transcriptionlanguages'] = 'Transkription unterstützte Sprachen';
$string['transcriptionlanguages_desc'] = 'Liste der unterstützten Transkriptionssprachen festlegen. Jede Sprache wird beim Hochladen von Transkriptionen als separater Block angezeigt.<br><strong>HINWEIS:</strong> Wenn keine Sprachen konfiguriert sind, wird die Funktion zum Hochladen von Transkriptionen deaktiviert.<br>Das Format sollte aus Schlüssel-Wert-Paaren bestehen, wobei die Schlüssel von Opencast verwendet werden und die Namen menschenlesbare Sprachbezeichnungen sind.<br><br>(Mehrsprachige Filter)<br> Damit jeder Sprachname mit Hilfe von Filtern wie <a target="_blank" href="https://moodle.org/plugins/filter_multilang2">Multi-Language Content (v2)</a> übersetzt werden kann, sollte jeder Sprachname die entsprechenden Platzhalter enthalten, die von diesem Filter definiert werden, z.B.: "{mlang en}English{mlang}{mlang de}Deutsch{mlang}".';
$string['transcriptionltidownloadcompleted'] = 'Die Transkription wurde erfolgreich heruntergeladen. {$a}';
$string['transcriptionmanual'] = 'Manuell';
$string['transcriptionreturntomanagement'] = 'Zurück zur Seite Transkriptionsverwaltung';
$string['transcriptionsettingsenablemanage'] = 'Transkriptionsmanagement aktivieren';
$string['transcriptionsettingsenablemanage_desc'] = 'Diese Option ermöglicht es Trainer/innen, die Transkriptionen für jedes Video einzeln zu verwalten. Dies umfasst das Hochladen neuer Dateien, das Löschen bestehender Dateien und das Überschreiben aktueller Transkriptionen. Jedem Videoeintrag auf der Übersichtsseite wird ein spezieller Aktionsmenüpunkt hinzugefügt, mit dem die Lehrkräfte die zugehörigen Transkriptionsdateien verwalten können.';
$string['transcriptionsettingsenableupload'] = 'Transkriptionsupload aktivieren';
$string['transcriptionsettingsenableupload_desc'] = 'Diese Option ermöglicht Trainer/innen das Hochladen von Transkriptionsdateien zusammen mit Videoinhalten im Upload-Formular. Nach der Aktivierung wird ein zusätzlicher Bereich angezeigt, in dem die Lehrkräfte Transkriptionsdateien für die ausgewählten Sprachen anhängen können.';
$string['transcriptionsettingsheader'] = 'Einstellungen für die Transkription';
$string['transcriptionworkflow'] = 'Workflow für die Transkription (Sprache zu Text)';
$string['transcriptionworkflow_desc'] = 'Dieser Workflow wird ausgelöst, wenn Transkriptionsdateien an das Video angehängt werden. Wenn nichts eingestellt ist, ist das Hochladen und Verwalten von Transkriptionen nicht möglich.<br>Durch die Einstellung dieses Workflows wird ein neuer Abschnitt zum Hochladen von Transkriptionsdateien auf der Seite "Video hinzufügen" sowie ein neuer Aktionsmenüpunkt auf der Übersichtsseite bereitgestellt, um die neuen/aktuellen Transkriptionsdateien hochzuladen/zu bearbeiten.';
$string['type'] = 'Medientyp';
$string['unabletoaddnewtranscription'] = 'Neue Transkription kann nicht hinzugefügt werden';
$string['unabletodeletetranscription'] = 'Transkription kann nicht gelöscht werden';
$string['unabletodownloadtranscription'] = 'Transkription kann nicht heruntergeladen werden';
$string['unabletomanagetranscriptions'] = 'Aufgrund eines aktiven Bearbeitungsstatus oder eines laufenden Workflows ist die Verwaltung der Transkriptionen des Events im Moment nicht möglich.';
$string['unarchiveuploadjobconfirmbtn_save'] = 'Fortfahren';
$string['unexpected_api_response'] = 'Unerwartete API-Antwort.';
$string['unlimiteduploadfilesize'] = 'Unbegrenzte Videogröße';
$string['unlimiteduploadfilesize_desc'] = 'Wenn diese Option aktiviert ist, gibt es keine Größenbeschränkung für das hochzuladende Video. Wenn Sie die Größenbeschränkung anwenden möchten, stellen Sie sicher, dass Sie diese Option deaktivieren, dann wird Ihnen angeboten, die Video-Größenbeschränkung in den entsprechenden Einstellungen einzugeben.';
$string['updatemetadata'] = 'Metadaten für dieses Video aktualisieren';
$string['updatemetadata_massaction'] = 'Metadaten ausgewählter Videos aktualisieren';
$string['updatemetadata_massaction_emptyformsubmission'] = 'Mindestens ein Feld muss aktiviert sein.';
$string['updatemetadata_massaction_notification_failed'] = 'Die Metadaten der folgenden Videos konnten nicht aktualisiert werden:<br><ul><li>{$a}</li></ul>';
$string['updatemetadata_massaction_notification_nochange'] = 'Es wurden keine Änderungen bezüglich der Aktualisierung der Metadaten für das/die ausgewählte(n) Video(s) vorgenommen.';
$string['updatemetadata_massaction_notification_succeeded'] = 'Die Metadaten des/der ausgewählten Videos wurden erfolgreich aktualisiert: <br><ul><li>{$a}</li></ul>';
$string['updatemetadata_massaction_videoerror'] = 'Die Metadaten für das Video {{$a->title}} können im Moment nicht geändert werden wegen: {$a->error}';
$string['updatemetadata_short'] = 'Metadaten aktualisieren';
$string['updatemetadatafailed'] = 'Die Metadaten konnten nicht gespeichert werden.';
$string['updatemetadatasaved'] = 'Metadaten wurden aktualisiert.';
$string['upload'] = 'Datei hochladen';
$string['uploadexplanation'] = 'Sie haben die Möglichkeit, ein Präsentator-Video und / oder eine Präsentations-Datei hochzuladen.<br />In den meisten Fällen werden Sie nur eine Datei hochladen, Opencast wäre aber auch in der Lage, zwei Videodateien gleichzeitig anzunehmen und in einem Medienpaket zu verarbeiten.';
$string['uploadfileextensions'] = 'Akzeptierte Dateitypen';
$string['uploadfileextensionsdesc'] = 'Kommaseparierte Liste der akzeptierten Dateitypen (die Dateitypen müssen in der <a href="{$a}">Liste der Dateitypen</a> existieren). Falls die Einstellung leer gelassen wird, werden alle Dateitypen der Dateitypgruppe \'Video\' zugelassen (Details siehe wieder in der <a href="{$a}">Liste der Dateitypen</a>).';
$string['uploadfilelimit'] = 'Begrenzung der Videogröße';
$string['uploadfilelimitdesc'] = 'Begrenzen Sie die Dateigröße hochgeladener Videos durch den Chunk-Upload.';
$string['uploadfilesizelimited'] = 'Begrenzte Videogröße';
$string['uploadfilesizelimitmode'] = 'Modus zur Begrenzung der Videodateigröße';
$string['uploadfilesizelimitmode_desc'] = 'Mit dieser Option können Sie festlegen, ob die Größe der Videodatei begrenzt werden soll. Wenn "Begrenzte Videogröße" ausgewählt ist, können Sie die Videogröße in der entsprechenden Einstellung festlegen.';
$string['uploadfilesizeunlimited'] = 'Unbegrenzte Videogröße';
$string['uploadingeventfailed'] = 'Anlegen einer Episode fehlgeschlagen';
$string['uploadjobnotfound'] = 'Der Video-Upload-Auftrag konnte nicht gefunden werden.';
$string['uploadjobssaved'] = 'Das Video wurde erfolgreich hochgeladen.<br />Das Video ist nun zur Übertragung nach Opencast bereit. Sie müssen nicht auf dieser Seite warten bis diese Übertragung abgeschlossen ist.';
$string['uploadprocessingexplanation'] = 'Diese Videos werden in Opencast verarbeitet und dann im Kurs verfügbar sein.';
$string['uploadqueuetoopencast'] = 'Warteschlange zur Übertragung nach Opencast';
$string['uploadqueuetoopencastexplanation'] = 'In diesem Abschnitt sehen Sie die Videos, welche von Ihnen oder jemand anderes in diesen Moodle Kurs hochgeladen wurde. Diese Videos stehen nun in der Warteschlage zur Übertragung nach Opencast.<br />Die Übertragung geschieht automatisiert im Hintergrund auf dem Moodle Server. Sie müssen nicht auf dieser Seite warten bis diese Übertragung abgeschlossen ist.';
$string['uploadrecordvideos'] = 'Videos hochladen oder aufnehmen';
$string['uploadrecordvideosexplanation'] = 'In diesem Abschnitt können Sie existierende Videodateien nach Moodle hochladen. Darüber hinaus können Sie Videos direkt mit Opencast Studio aufzeichnen.';
$string['uploadsettings'] = 'Einstellungen für den Chunk-Uploader';
$string['uploadtimeout'] = 'Zeitüberschreitung beim Hochladen von Moodle zu Opencast';
$string['uploadtimeoutdesc'] = 'Legen Sie die Zeit in Sekunden fest, die ein einzelner Video-Upload während des Hochladens im Hintergrund dauern darf.';
$string['uploadtranscritpion'] = 'Transkriptionssatz hochladen';
$string['uploadvideos'] = 'Videos hochladen';
$string['uploadvideosexplanation'] = 'In diesem Abschnitt können Sie existierende Videodateien nach Moodle hochladen.';
$string['uploadworkflow'] = 'Nach Upload Workflow starten';
$string['uploadworkflowdesc'] = 'Legen Sie den eindeutigen Kurznamen des Workflows fest, der nach erfolgreichem Hochladen einer Videodatei in Opencast gestartet werden soll. Wenn nichts angegeben wird, wird der Standard-Workflow (ng-schedule-and-upload) verwendet. Fragen Sie nach zusätzlichen Workflows, die eventuell vom Opencast-Administrator erstellt wurden.';
$string['usedefaultfilepicker'] = 'Standardmäßige Dateiauswahl nutzen um auf alle Repositories zuzugreifen';
$string['userisntowner'] = 'Nur Eigentümer/innen des Videos kann die Eigentumsrechte ändern.';
$string['video'] = 'Video';
$string['video_already_uploaded'] = 'Video wurde bereits hochgeladen';
$string['video_not_accessible'] = 'Dieses Video wurde nicht im Publikationskanal veröffentlicht.';
$string['video_not_downloadable'] = 'Dieses Video wurde nicht im Download-Kanal veröffentlicht.';
$string['video_notallowed'] = 'Das Video ist nicht Teil der Kurs-Serie.';
$string['video_retrieval_failed'] = 'Das Video konnte nicht abgerufen werden. Bitte überprüfen Sie die Verbindung zum Opencast-Server.';
$string['videodraftdeletionsucceeded'] = 'Das Video wurde erfolgreich gelöscht';
$string['videodraftnotdeletable'] = 'Das Video kann vor der Übertragung nach Opencast nicht mehr gelöscht werden, da sein Verarbeitungsstatus bereits "{$a}" ist';
$string['videodraftnotfound'] = 'Das Video, welches vor der Übertragung nach Opencast gelöscht werden sollte, wurde nicht gefunden.';
$string['videoeditor_short'] = 'Video Editor';
$string['videoeditorinvalidconfig'] = 'Derzeit ist es nicht möglich, den Opencast Editor zu verwenden, um das Ereignis zu bearbeiten.';
$string['videonotfound'] = 'Video nicht gefunden';
$string['videosavailable'] = 'Videos, die in diesem Kurs verfügbar sind';
$string['videosoverviewexplanation'] = 'Hier können Sie sehen, in welchen Kursen die Videos als Aktivität für die Teilnehmer/innen bereitgestellt werden.<br>Die zweite Spalte zeigt die Aktivitäten der Kurse, in denen die Serie vom Opencast-Block verwaltet wird. Die dritte Spalte zeigt Kurse, in denen das Video eingebettet ist, ohne dass die Serie durch den Block verwaltet wird.';
$string['videostable_massaction_changevisibility'] = 'Sichtbarkeit ändern';
$string['videostable_massaction_changevisibility_modal_body'] = 'Sind Sie sicher, dass Sie eine Sichtbarkeitsänderung an folgenden ausgewählten Videos durchführen wollen?<br> <ul><li>{$a}</li></ul>';
$string['videostable_massaction_changevisibility_modal_title'] = 'Sichtbarkeit für ausgewählte Videos ändern';
$string['videostable_massaction_delete'] = 'Löschen';
$string['videostable_massaction_delete_modal_body'] = 'Sind Sie sicher, dass Sie die folgenden ausgewählten Videos löschen wollen?<br><ul><li>{$a}</li></ul>';
$string['videostable_massaction_delete_modal_title'] = 'Ausgewählte Videos löschen';
$string['videostable_massaction_startworkflow'] = 'Workflow starten';
$string['videostable_massaction_startworkflow_info'] = 'Sie haben die folgenden Videos ausgewählt, um den Workflow zu starten:';
$string['videostable_massaction_startworkflow_modal_body'] = 'Sie haben die folgenden Videos ausgewählt, für die Sie den Workflow starten möchten:<br> <ul><li>{$a}</li></ul>Vergewissern Sie sich, dass die ausgewählten Videos korrekt sind, und fahren Sie fort.';
$string['videostable_massaction_startworkflow_modal_title'] = 'Workflow für ausgewählte Videos starten';
$string['videostable_massaction_updatemetadata'] = 'Metadaten aktualisieren';
$string['videostable_massaction_updatemetadata_modal_body'] = 'Sind Sie sicher, dass Sie die Metadaten der folgenden ausgewählten Videos aktualisieren möchten:<br> <ul><li>{$a}</li></ul>';
$string['videostable_massaction_updatemetadata_modal_title'] = 'Metadaten ausgewählter Videos aktualisieren';
$string['videostablemassaction_disabled_item'] = 'Nicht auswählbar';
$string['videostablemassaction_label'] = 'Mit ausgewählten Videos...';
$string['videostoupload'] = 'Videos, die nach Opencast hochgeladen werden können';
$string['viewviedeosnotallowed'] = 'Sie sind nicht berechtigt, die Videos dieser Serie anzusehen.';
$string['visibility'] = 'Sichtbarkeit des Videos';
$string['visibility_group'] = 'Allen Kursteilnehmer/innen ausgewählter Gruppen Zugang zum Video erlauben';
$string['visibility_group_massaction'] = 'Allen Teilnehmer/innen ausgewählter Gruppen den Zugriff auf das/die ausgewählte(n) Video(s) gestatten';
$string['visibility_hide'] = 'Alle Teilnehmer/innen am Zugang zum Video hindern';
$string['visibility_hide_massaction'] = 'Verhindern, dass ein/e Teilnehmer/in auf das/die ausgewählte(n) Video(s) zugreifen kann';
$string['visibility_massaction'] = 'Sichtbarkeit des/der ausgewählten Video(s)';
$string['visibility_show'] = 'Allen Teilnehmer/innen den Zugang zum Video erlauben';
$string['visibility_show_massaction'] = 'Allen Kursteilnehmern/innen den Zugriff auf das/die ausgewählte(n) Video(s) ermöglichen';
$string['visibilityheader'] = 'Sichtbarkeit des Videos';
$string['visibilityheaderexplanation'] = 'Sie können den anfänglichen Sichtbarkeitsstatus des Videos beim Hochladen festlegen und eine geplante Sichtbarkeitsänderung konfigurieren.';
$string['workflow_invalid'] = 'Dieser Workflow existiert nicht oder ist nicht aktiv.';
$string['workflow_not_existing'] = 'Dieser Workflow existiert nicht in Opencast.';
$string['workflow_opencast_invalid'] = 'Dieser Workflow existiert nicht in Opencast oder ist eingeschränkt. Bitte kontaktieren Sie den Administrator.';
$string['workflow_settings_opencast'] = 'Workflow-Einstellungen';
$string['workflow_started_failure'] = 'Start des Workflows ist fehlgeschlagen.';
$string['workflow_started_massaction_nochange'] = 'Workflow kann nicht gestartet werden, da Video(s) fehlen.';
$string['workflow_started_massaction_notification_failed'] = 'Der Workflow kann für die folgenden ausgewählten Videos nicht gestartet werden:<br><ul><li>{$a}</li></ul>';
$string['workflow_started_massaction_notification_success'] = 'Der Workflow wurde für die ausgewählten Videos erfolgreich gestartet:';
$string['workflow_started_success'] = 'Der Workflow wurde erfolgreich gestartet.';
$string['workflownotdefined'] = 'Der Workflow für das Aktualisieren von Metadaten ist nicht definiert.';
$string['workflowrolesdesc'] = 'Dieser Workflow wird in Gang gesetzt, wenn temporäre ACL-Regeln gelöscht oder hinzugefügt werden. Falls nicht gesetzt, ist es nicht möglich, die Sichtbarkeit von hochgeladenen Videos über den Block \'Opencast Videos\' zu ändern.';
$string['workflowrolesname'] = 'Workflow zur Aktualisierung der Metadaten';
$string['workflowtags_setting'] = 'Workflow-Tags';
$string['workflowtags_settingdesc'] = 'Kommagetrennte Liste von Tags für Opencast-Workflows, die von Administrator/innen konfiguriert und von Trainer/innen manuell gestartet werden können.';
$string['worklowisrunning'] = 'Es läuft zur Zeit ein Workflow ab. Sie können die Sichtbarkeit momentan nicht ändern.';
$string['wrongmimetypedetected'] = 'Ein ungültiger MIME-Type wurde beim Upload von Video {$a->filename} aus Kurs {$a->coursename} genutzt.
Nur Video-Dateien sind erlaubt!';
