<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'qtype_combined', language 'da', version '4.4'.
 *
 * @package     qtype_combined
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['correct_choice_embed_code'] = '[[{$a->qid}:{$a->qtype}:{correct choice}]]';
$string['embeddedquestionremovedfromform'] = 'Et eller flere indlejrede spørgsmål er blevet fjernet fra spørgsmålsteksten. Spørgsmålsdata til disse spørgsmål vises stadig nedenfor, men fjernes permanent, når du klikker på \'Bekræft spørgsmålsteksten ...\' eller \'Gem ændringer\'-knappen, med mindre du sætter de indlejrede koder ind i spørgsmålsteksten igen.';
$string['err_accepts_vertical_or_horizontal_layout_param'] = 'I spørgsmålstypen \'{$a}\' kan du angive layoutet til din spørgsmålstype som følger:
<ul>
 <li>[[{question identifier}:{$a}:v]] lodret ELLER</li>
  <li>[[{question identifier}:{$a}:h]] vandret.</li></ul>
  <p>Du skal ikke indsætte noget andet efter det andet kolon.</p>';
$string['err_duplicateids'] = 'De indlejrede spørgsmålseksempler skal have forskellige identifikatorer. Du har brugt følgende indikator(er) til mere end et spørgsmål {$a}\'.';
$string['err_fillinthedetailsforsubq'] = 'Du skal udfylde detaljerne for at beskrive underspørgsmålet "{$a}".';
$string['err_fillinthedetailshere'] = 'Du skal udfylde detaljerne for dette underspørgsmål.';
$string['err_insufficientnoofcodeparts'] = 'Fejl, din kode til at indlejre en spørgsmålskontrol \'{$a->fullcode}\' har for få kolonseparerede dele. Du skal mindst have et spørgsmåls-id, efterfulgt af et spørgsmålstype-id.';
$string['err_invalid_number'] = '\'{$a}\' spørgsmålstypen forventer et nummer efter spørgsmålstype-id\'et. Din indlejringskode bør være [[{your question id}:{$a}:{a number here}]]';
$string['err_invalid_width_specifier_postfix'] = 'I spørgsmålstypen \'{$a}\' kan du angive bredden på dit spørgsmål som følger:
<ul>
 <li>[[{question identifier}:{$a}:____]] hvor bredden på svarboksen afhænger af antallet af underscores eller</li>
  <li>[[{question identifier}:{$a}:__10__]]hvor bredden på svarboksen afhænger af tallet.</li></ul>
  <p>Du skal ikke indtaste noget andet efter det andet kolon.</p>';
$string['err_invalidquestionidentifier'] = 'Din spørgsmåls-idkode består af et eller flere tal eller bogstaver.';
$string['err_questionidentifiertoolong'] = 'Underspørgsmålets navn "{$a}" er for langt. Du må bruge op til 10 alfanumeriske tegn.';
$string['err_subq_not_included_in_question_text'] = 'Det ser ud til, at du har fjernet dette spørgsmål fra spørgsmålsteksten. Hvis du ikke indlejrer spørgsmålet i formularen med koden {$a}, vil det blive fjernet, når du indsender denne formular igen.';
$string['err_thisqtypecannothavemorethanonecontrol'] = 'Du har forsøgt at indlejre mere end en kontrol af spørgsmålstypen \'{$a->qtype}\' med spørgsmålet \'{$a->qid}\'. Denne spørgsmålstype tillader kun en kontrol pr. spørgsmål.';
$string['err_thisqtypedoesnotacceptextrainfo'] = 'Denne spørgsmålstype er indlejres med koden [[{your question id}:{$a}]].
Du skal ikke indsætte noget efter qtype-id\'et, heller ikke et andet kolon.';
$string['err_unrecognisedqtype'] = 'Det spørgsmålstype-id \'{$a->qtype}\', du indsatte i den indlejrede kode \'{$a->fullcode}\' er ikke kendt.';
$string['err_weightingsdonotaddup'] = 'Vægtning for underspørgsmål giver ikke sammenlagt 1.';
$string['err_you_must_provide_third_param'] = 'Du skal angive et tredje parameter til spørgsmålstypen {$a}.';
$string['incorrectfeedback'] = 'Feedback til ethvert ukorrekt svar';
$string['noembeddedquestions'] = 'Du har slettet eller indlejret underspørgsmålselementer fra spørgsmålsteksten!';
$string['nosubquestiontypesinstalled'] = 'Denne spørgsmålstype giver mulighed for kombinationen af funktionalitet fra andre spørgsmålstyper. Du skal installere mindst en af disse spørgsmålstyper, der vil blive brugt som undespørgsmål.

Se <a href="https://moodle.org/plugins/view.php?plugin=qtype_combined">posten i plug-in databasen</a> for flere detaljer og en liste over spørgsmålstyper, der kan bruges som underspørgsmål.';
$string['pluginname'] = 'Kombineret';
$string['pluginname_help'] = 'Opret et spørgsmål med indlejrede svarfelter i spørgsmålsteksten.

Afhængig af de underspørgsmålstyper, der er installeret i din Moodle, kan du bede den studerende indtaste et tal eller et bogstav eller vælge en værdi blandt et antal muligheder. Indlejrede koder i spørgsmålsteksten vil blive erstattet af enten afkrydsningsfelter, valgbokse eller et felt til indtastning af tekst, så den studerende kan indtaste sit svar.

Når du opretter et nyt spørgsmål, vil alle koder til at indlejre tilgængelige underspørgsmålstyper automatisk blive føjet til spørgsmålsteksten som eksempler på koder, du kan bruge. Samtidig vises de tilhørende fomulardele for indstillingerne til hvert spørgsmål under spørgsmålets tekstfelt. Rediger spørgsmålsteksten og ændr koderne i spørgsmålsteksten for at ændre hvilke typer underspørgsmål, der skal medtages i spørgsmålsteksten. Tryk derefter på knappen \'Bekræft spørgsmålsteksten og opdater formularen\' for at få de korrekte dele af formularen vist, så du kan redigere dine indstillinger for underspørgsmål.';
$string['pluginname_link'] = 'question/type/combined';
$string['pluginnameadding'] = 'Tilføjer et kombineret spørgsmål';
$string['pluginnameediting'] = 'Redigerer et kombineret spørgsmål';
$string['pluginnamesummary'] = 'En kombineret spørgsmålstype, der tillader indlejring af svarfelter til forskellige tilgængelige underspørgsmål i spørgsmålsteksten.

Afhængig af hvilke spørgsmålstyper, du har installeret, kan den studerende indsætte et numerisk eller et tekstsvar, eller vælge at svare ved hjælp af en drop down-menu eller afkrydsningsfelter.';
$string['subqheader'] = '\'{$a->qtype}\' input \'{$a->qid}';
$string['subqheader_not_in_question_text'] = '\'{$a->qtype}\' input \'{$a->qid}\' (ikke indlejret i spørgsmålstekst).';
$string['subquestiontypenotinstalled'] = 'Du forsøger at bruge et kombineret spørgsmål med en underspørgsmålstype \'{$a}\', som ikke er installeret.';
$string['updateform'] = 'Kontroller spørgsmålsteksten og opdater formularen';
$string['validationerror'] = 'En del af dit svar kræver opmærksomhed : {$a}';
$string['validationerrors'] = 'Dele af dit svar kræver opmærksomhed: {$a}';
$string['vertical_or_horizontal_embed_code'] = '[[{$a->qid}:{$a->qtype}:v]] eller [[{$a->qid}:{$a->qtype}:h]] afhængig af om du vil have valgmulighederne opstillet lodret eller vandret.';
$string['weighting'] = 'Vægtning';
$string['widthspecifier_embed_code'] = '[[{$a->qid}:{$a->qtype}:{width specifier}]] eller bare [[{$a->qid}:{$a->qtype}]]';
$string['yougot1right'] = '1 af dine svar er korrekte.';
$string['yougotnright'] = '{$a->num}  af dine svar er korrekte.';
