<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'format_topcoll', language 'pt', version '4.4'.
 *
 * @package     format_topcoll
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['arrow'] = 'Seta';
$string['bulb'] = 'Lâmpada';
$string['center'] = 'Centro';
$string['cloud'] = 'Nuvem';
$string['colourrule'] = 'Indique um código RGB válido com seis dígitos hexadecimais ou \'-\' para usar valor predefinido.';
$string['columndynamic'] = 'Dinâmico';
$string['columnhorizontal'] = 'Horizontal';
$string['columnvertical'] = 'Vertical';
$string['configurationheadingsub'] = 'Configuração';
$string['configurationheadingsubdesc'] = 'Opções globais de configuração';
$string['coursesectionactivityfurtherinformation'] = 'Página da disciplina com mais informações';
$string['coursesectionactivityfurtherinformationassign'] = 'Mostrar informação do trabalho';
$string['coursesectionactivityfurtherinformationassigndesc'] = 'Mostrar informações do trabalho. Aos professores/administradores será mostrado o número de submissões.';
$string['coursesectionactivityfurtherinformationchoice'] = 'Mostrar informação da sondagem';
$string['coursesectionactivityfurtherinformationchoicedesc'] = 'Mostrar informações da sondagem. Aos professores/administradores será mostrado o número de submissões.';
$string['coursesectionactivityfurtherinformationdata'] = 'Mostrar informação da base de dados';
$string['coursesectionactivityfurtherinformationdatadesc'] = 'Mostrar informações da base de dados. Aos professores/administradores será mostrado o número de submissões.';
$string['coursesectionactivityfurtherinformationfeedback'] = 'Mostrar informação do feedback';
$string['coursesectionactivityfurtherinformationfeedbackdesc'] = 'Mostrar informações do inquérito. Aos professores/administradores será mostrado o número de submissões.';
$string['coursesectionactivityfurtherinformationforum'] = 'Mostrar informação do fórum';
$string['coursesectionactivityfurtherinformationlesson'] = 'Mostrar informação da lição';
$string['coursesectionactivityfurtherinformationlessondesc'] = 'Mostrar informações da lição. Aos professores/administradores será mostrado o número de submissões.';
$string['coursesectionactivityfurtherinformationquiz'] = 'Mostrar informação do teste';
$string['coursesectionactivityfurtherinformationquizdesc'] = 'Mostrar informações do teste Aos professores/administradores será mostrado o número de submissões.';
$string['ctreset'] = 'Opções da reposição do formato Tópicos Contraídos';
$string['ctreset_help'] = 'Repor predefinições do formato Tópicos Contraídos';
$string['currentsection'] = 'Esta secção';
$string['default'] = 'Predefinição - {$a}';
$string['defaultdisplayblocks'] = 'Blocos a mostrar';
$string['defaultdisplayblocks_desc'] = 'Escolha os blocos a serem exibidos na disciplina. Use a tecla \'Ctrl\' em combinação com o rato para selecionar mais do que um ou nenhum.';
$string['defaultdisplayblocksloc'] = 'Localização da exibição do bloco';
$string['defaultdisplayblocksloc_desc'] = 'Escolha o local para exibir os blocos escolhidos acima.';
$string['defaultdisplayinstructions'] = 'Instruções';
$string['defaultdisplayinstructions_desc'] = 'Mostrar as instruções aos utilizadores informando-os de como usar os botões para alternar o estado da secção entre contraída e expandida. Pode ser sim ou não.';
$string['defaultheadingsub'] = 'Predefinições';
$string['defaultheadingsubdesc'] = 'Configurações predefinidas';
$string['defaultlayoutcolumnorientation'] = 'Disposição predefinida das colunas';
$string['defaultlayoutcolumnorientation_desc'] = 'Disposição predefinida das colunas: Vertical ou Horizontal';
$string['defaultlayoutcolumns'] = 'Número de colunas';
$string['defaultlayoutcolumns_desc'] = 'Número de colunas (uma a quatro).';
$string['defaultlayoutelement'] = 'Configuração predefinida da estrutura';
$string['defaultlayoutelement_desc'] = 'A configuração da estrutura pode ser uma das seguintes:<br />
\'Predefinida\' sendo exibido tudo.<br />
Sem \'Tópico x\' / \'Semana x\' / \'Dia x\'.<br />
Sem número da secção.<br />
Sem \'Tópico x\' / \'Semana x\' / \'Dia x\' e sem número da secção.<br />
Sem texto \'Alternar\'.<br />
Sem texto \'Alternar\' e sem \'Tópico x\' / \'Semana x\' / \'Dia x\'.<br />
Sem texto \'Alternar\', sem \'Tópico x\' / \'Semana x\' / \'Dia x\' e sem número da secção.';
$string['defaultlayoutelement_descpositive'] = 'A configuração da estrutura pode ser uma das seguintes:<br />
Palavra \'Alternar\', \'Tópico x\' / \'Semana x\' / \'Dia x\' e número da secção.<br />
Palavra \'Alternar\' e \'Tópico x\' / \'Semana x\' / \'Dia x\'.<br />
Palavra \'Alternar\' e número da secção.<br />
\'Tópico x\' / \'Semana x\' / \'Dia x\' e número da secção.<br />
Palavra \'Alternar\'.<br />
\'Tópico x\' / \'Semana x\' / \'Dia x\'.<br />
Número da secção.<br />
Apenas designação da secção.';
$string['defaultlayoutstructure'] = 'Configuração da estrutura predefinida';
$string['defaultlayoutstructure_desc'] = 'A definição de estrutura pode ser um das seguintes:<br />Tópicos<br />Semanas<br />Semana atual primeiro<br />Tópico atual primeiro<br />Dias';
$string['defaultonesection'] = 'Uma secção';
$string['defaultonesection_desc'] = 'Indica se, a qualquer momento, apenas uma secção deve estar aberta. Nota: Ignorado ao editar para permitir que atividades e recursos possam ser movidos para outras secções.';
$string['defaultshowadditionalmoddata'] = 'Usar a predefinição \'Mostrar informações adicionais\' se ainda não estiver definido';
$string['defaultshowadditionalmoddatadesc'] = 'Se uma atividade for definida ao nível do site (abaixo) para mostrar informações adicionais, esta configuração indica o estado predefinido da instância específica da respetiva disciplina.';
$string['defaultshowsectionsummary'] = 'Mostrar o resumo quando a secção está contraída';
$string['defaultshowsectionsummary_desc'] = 'Determina se o resumo da seção será sempre exibido independentemente do estado da secção (contraída ou expandida).';
$string['defaulttgbgcolour'] = 'Cor do fundo do botão';
$string['defaulttgbgcolour_desc'] = 'Cor do fundo do botão em RGB hexadecimal';
$string['defaulttgbghvrcolour'] = 'Cor do fundo do botão ao passar rato';
$string['defaulttgbghvrcolour_desc'] = 'Cor do fundo do botão ao passar rato em RGB hexadecimal';
$string['defaulttgbghvropacity'] = 'Alternar a opacidade do plano de fundo ao passar rato';
$string['defaulttgbghvropacity_desc'] = 'Alternar a opacidade do plano de fundo entre 0 e 1 com incrementos de 0,1 ao passar rato.';
$string['defaulttgbgopacity'] = 'Alternar a opacidade do plano de fundo';
$string['defaulttgbgopacity_desc'] = 'Alternar a opacidade do plano de fundo entre 0 e 1 com incrementos de 0,1';
$string['defaulttgfgcolour'] = 'Cor do texto do botão';
$string['defaulttgfgcolour_desc'] = 'Cor do primeiro plano em RGB hexadecimal';
$string['defaulttgfghvrcolour'] = 'Cor do primeiro plano ao passar rato';
$string['defaulttgfghvrcolour_desc'] = 'Cor do texto do botão ao passar rato em RGB hexadecimal';
$string['defaulttgfghvropacity'] = 'Alternar a opacidade do primeiro plano ao passar o rato';
$string['defaulttgfghvropacity_desc'] = 'Alternar a opacidade do primeiro plano, ao passar o rato, entre 0 e 1 com incrementos de 0,1';
$string['defaulttgfgopacity'] = 'Alternar a opacidade do primeiro plano';
$string['defaulttgfgopacity_desc'] = 'Alternar a opacidade do primeiro plano entre 0 e 1 com incrementos de 0,1';
$string['defaulttogglealignment'] = 'Alinhamento do texto do botão';
$string['defaulttogglealignment_desc'] = '\'Esquerdo\', \'Centro\' ou \'Direito\'.';
$string['defaulttoggleallenabled'] = 'Alternar tudo ativado';
$string['defaulttoggleallenabled_desc'] = 'Indica se a funcionalidade Alternar tudo deve estar ativada.';
$string['defaulttoggleallhover'] = 'Alternar todos os ícones ao passar rato';
$string['defaulttoggleallhover_desc'] = '"Não" ou "Sim"';
$string['defaulttoggleborderradiusbl'] = 'Raio do canto inferior esquerdo do botão';
$string['defaulttoggleborderradiusbl_desc'] = 'Raio do canto inferior esquerdo do botão para alternar entre estado contraído e expandido';
$string['defaulttoggleborderradiusbr'] = 'Raio do canto inferior direito do botão';
$string['defaulttoggleborderradiusbr_desc'] = 'Raio do canto inferior direito do botão para alternar entre estado contraído e expandido';
$string['defaulttoggleborderradiustl'] = 'Raio do canto superior esquerdo do botão';
$string['defaulttoggleborderradiustl_desc'] = 'Raio do canto superior esquerdo do botão para alternar entre estado contraído e expandido';
$string['defaulttoggleborderradiustr'] = 'Raio do canto superior direito do botão';
$string['defaulttoggleborderradiustr_desc'] = 'Raio do canto superior direito do botão para alternar entre estado contraído e expandido';
$string['defaulttoggleiconposition'] = 'Posição do ícone';
$string['defaulttoggleiconposition_desc'] = 'Define se o ícone deve estar à esquerda ou à direita do texto do botão';
$string['defaulttoggleiconset'] = 'Ícones do botão';
$string['defaulttoggleiconset_desc'] = '<table>
  <tbody>
    <tr><td>Seta</td><td>{$a->seta}</td></tr>
    <tr><td>Lâmpada</td><td>{$a->lampada}</td></tr>
    <tr><td>Nuvem</td><td>{$a->nuvem}</td></tr>
    <tr><td>Olho</td><td>{$a->olho}</td></tr>
    <tr><td>Pasta</td><td>{$a->pasta}</td></tr>
    <tr><td>Sinal de Solo</td><td>{$a->sinaldesolo}</td></tr>
    <tr><td>Díodo Emissor de Luz</td><td>{$a->led}</td></tr>
    <tr><td>Ponto</td><td>{$a->ponto}</td></tr>
    <tr><td>Alimentação</td><td>{$a->alimentacao}</td></tr>
    <tr><td>Rádio</td><td>{$a->radio}</td></tr>
    <tr><td>Sorriso</td><td>{$a->sorriso}</td></tr>
    <tr><td>Quadrado</td><td>{$a->quadrado}</td></tr>
    <tr><td>Sol / Lua</td><td>{$a->sollua}</td></tr>
    <tr><td>Interruptor</td><td>{$a->interruptor}</td></tr>
    <tr><td>Fonte de Ícones</td><td>{$a->fontedeicones}</td></tr>
  </tbody>
</table>';
$string['defaulttoggleiconsize'] = 'Tamanho do ícone do botão';
$string['defaulttoggleiconsize_desc'] = 'Tamanho do ícone: Pequeno = 16px, Médio = 24px e Grande = 32px.';
$string['defaulttogglepersistence'] = 'Persistência dos botões';
$string['defaulttogglepersistence_desc'] = 'Se não ativar esta opção vai melhorar o desempenho do AJAX mas as seleções do utilizador não serão mantidas quando o utilizador atualiza ou revisita a página.<br />Nota: Se desativar esta opção, remova todas as linhas contendo \'topcoll_toggle_x\' no campo \'name\' da tabela \'user_preferences\' da base de dados. O \'x\' em \'topcoll_toggle_x\' é o ID da disciplina. Útil para poupar espaço se não pretende voltar a ativar esta opção.';
$string['defaultuserpreference'] = 'Estado inicial dos botões';
$string['defaultuserpreference_desc'] = 'Define o modo de exibição dos botões quando o utilizador acede à disciplina pela primeira vez, o estado das novas secções quando estas são adicionadas ou quando a persistência dos botões está desligada.';
$string['defaultviewsinglesectionenabled'] = 'Visualizar secção única ativada';
$string['defaultviewsinglesectionenabled_desc'] = 'Indica se a funcionalidade Visualizar secção única deve estar ativada.';
$string['deletesection'] = 'Apagar secção';
$string['displayinstructions'] = 'Mostrar instruções';
$string['displayinstructions_help'] = 'Estabelece se as instruções são ou não exibidas ao utilizador';
$string['donotshowdate'] = 'Não mostrar a data';
$string['donotshowdate_help'] = 'Não mostrar a data quando utiliza uma estrutura baseada em semanas e a opção "Usar nome predefinido da secção" não está ativa.';
$string['editsection'] = 'Editar secção';
$string['editsectionname'] = 'Editar nome da secção';
$string['em0_0'] = '0,0em';
$string['em0_1'] = '0,1em';
$string['em0_2'] = '0,2em';
$string['em0_3'] = '0,3em';
$string['em0_4'] = '0,4em';
$string['em0_5'] = '0,5em';
$string['em0_6'] = '0,6em';
$string['em0_7'] = '0,7em';
$string['em0_8'] = '0,8em';
$string['em0_9'] = '0,9em';
$string['em1_0'] = '1,0em';
$string['em1_1'] = '1,1em';
$string['em1_2'] = '1,2em';
$string['em1_3'] = '1,3em';
$string['em1_4'] = '1,4em';
$string['em1_5'] = '1,5em';
$string['em1_6'] = '1,6em';
$string['em1_7'] = '1,7em';
$string['em1_8'] = '1,8em';
$string['em1_9'] = '1,9em';
$string['em2_0'] = '2,0em';
$string['em2_1'] = '2,1em';
$string['em2_2'] = '2,2em';
$string['em2_3'] = '2,3em';
$string['em2_4'] = '2,4em';
$string['em2_5'] = '2,5em';
$string['em2_6'] = '2,6em';
$string['em2_7'] = '2,7em';
$string['em2_8'] = '2,8em';
$string['em2_9'] = '2,9em';
$string['em3_0'] = '3,0em';
$string['em3_1'] = '3,1em';
$string['em3_2'] = '3,2em';
$string['em3_3'] = '3,3em';
$string['em3_4'] = '3,4em';
$string['em3_5'] = '3,5em';
$string['em3_6'] = '3,6em';
$string['em3_7'] = '3,7em';
$string['em3_8'] = '3,8em';
$string['em3_9'] = '3,9em';
$string['em4_0'] = '4,0em';
$string['eye'] = 'Olho';
$string['feedbackavailable'] = 'Feedback disponível';
$string['folder'] = 'Pasta';
$string['formatresponsive'] = 'Formato responsivo';
$string['formatresponsive_desc'] = 'Ative esta opção se está a utilizar um tema não responsivo e o formato irá ajustar-se às dimensões do ecrã. Não ative se está a usar um tema responsivo. O suporte para Bootstrap 2.3.2 está contemplado. Para outras frameworks e versões, sobreponha os métodos \'get_row_class()\' e \'get_column_class()\' no ficheiro renderer.php.';
$string['formatsettings'] = 'Repor predefinições do formato';
$string['formatsettingsinformation'] = '<br />Para repor as configurações do formato para os valores predefinidos, clique no ícone à direita.';
$string['four'] = 'Quatro';
$string['groundsignal'] = 'Sinal de massa';
$string['hidefromothers'] = 'Ocultar';
$string['information'] = 'Informação';
$string['informationchanges'] = 'Alterações';
$string['instructions'] = 'Instruções: Clique no nome da secção para mostar/ocultar';
$string['large'] = 'Largo';
$string['layoutstructuredays'] = 'dias';
$string['layoutstructuretopics'] = 'tópicos';
$string['layoutstructureweeks'] = 'semanas';
$string['led'] = 'Diodo emissor de luz';
$string['left'] = 'Esquerda';
$string['maincoursepage'] = 'Página principal da disciplina';
$string['markedthissection'] = 'Esta secção está destacada como a secção atual';
$string['markthissection'] = 'Destacar esta secção como a secção atual';
$string['medium'] = 'Médio';
$string['newsection'] = 'Nova secção';
$string['newsectionname'] = 'Novo nome da secção {$a}';
$string['numbersections'] = 'Número de secções';
$string['off'] = 'Desligado';
$string['on'] = 'Ligado';
$string['one'] = 'Uma';
$string['onesection'] = 'Uma secção';
$string['onesection_help'] = 'Indica se, a qualquer momento, apenas uma secção deve estar aberta. Nota: Ignorado ao editar para permitir que atividades e recursos possam ser movidos para outras secções.';
$string['page-course-view-topcoll'] = 'Qualquer página principal da disciplina no formato Tópicos Contraídos';
$string['page-course-view-topcoll-x'] = 'Qualquer página da disciplina no formato Tópicos Contraídos';
$string['pluginname'] = 'Tópicos Contraídos';
$string['point'] = 'Ponto';
$string['power'] = 'Pólo';
$string['privacy:metadata:preference:toggle'] = 'O estado dos comutadores na disciplina.';
$string['privacy:request:preference:toggle'] = 'O ID da disciplina "{$a->name}" tem o valor "{$a->value}", o que representa "{$a->decoded}" para o estado dos comutadores.';
$string['radio'] = 'Botão Rádio';
$string['readme_desc'] = 'Clique em \'{$a->url}\' para mais informações sobre o formato Tópicos Contraídos.';
$string['readme_title'] = 'Leia-me do Tópicos Contraídos';
$string['resetallcolour'] = 'Cores';
$string['resetallcolour_help'] = 'Repõe as cores e as opacidades de modo a respeitar o valor predefinido do site.';
$string['resetalldisplayinstructions'] = 'Mostrar instruções';
$string['resetalldisplayinstructions_help'] = 'Repõe a exibição das instruções de modo a respeitar o valor predefinido do site.';
$string['resetallgrp'] = 'Repor tudo:';
$string['resetalllayout'] = 'Estruturas';
$string['resetalllayout_help'] = 'Repõe a estrutura, colunas, alternar tudo, ver secção única, posição do ícone, uma secção e a exibição do sumário da secção de modo a respeitarem o valor predefinido do site.';
$string['resetalltogglealignment'] = 'Alinhamento dos botões';
$string['resetalltogglealignment_help'] = 'Repõe o alinhamentos de todos os botões de modo a respeitar o valor predefinido do site.';
$string['resetalltoggleiconset'] = 'Ícones dos botões';
$string['resetalltoggleiconset_help'] = 'Repõe os ícones dos botões de modo a respeitarem o valor predefinido do site.';
$string['resetcolour'] = 'Cor';
$string['resetcolour_help'] = 'Repõe as cores e as opacidades de modo a respeitarem o valor predefinido do site.';
$string['resetdisplayinstructions'] = 'Mostrar instruções';
$string['resetdisplayinstructions_help'] = 'Repõe a exibição das instruções de modo a respeitar o valor predefinido do site.';
$string['resetgrp'] = 'Repor:';
$string['resetlayout'] = 'Estrutura';
$string['resetlayout_help'] = 'Repõe a estrutura, colunas, alternar tudo, ver secção única, posição do ícone, uma secção e a exibição do sumário da secção de modo a respeitarem o valor predefinido do site.';
$string['resettogglealignment'] = 'Alinhamento do botão';
$string['resettogglealignment_help'] = 'Repõe o alinhamento dos botões de modo a respeitar o valor predefinido do site.';
$string['resettoggleiconset'] = 'Ícones do botão';
$string['resettoggleiconset_help'] = 'Repõe os ícones dos botões de modo a respeitarem o valor predefinido do site.';
$string['right'] = 'Direita';
$string['sctcloseall'] = 'Fechar tudo ({$a})';
$string['sctopenall'] = 'Abrir tudo ({$a})';
$string['section0name'] = 'Geral';
$string['sectionname'] = 'Secção';
$string['setcolour'] = 'Cor';
$string['setcolour_help'] = 'Contém as configurações relativas às cores do formato na disciplina.';
$string['setlayout'] = 'Definir estrutura';
$string['setlayout_all'] = 'Palavra “Alternar”, “Tópico x” / “Semana x”/ “Dia x” e o número da secção';
$string['setlayout_default'] = 'Predefinido';
$string['setlayout_help'] = 'Contém as configurações relativas à estrutura do formato na disciplina.';
$string['setlayout_no_additions'] = 'Apenas designação da secção';
$string['setlayout_no_section_no'] = 'Sem número de secção';
$string['setlayout_no_toggle_section_x'] = 'Sem secção x';
$string['setlayout_no_toggle_section_x_section_no'] = 'Sem secção x e número da secção';
$string['setlayout_no_toggle_word'] = 'Sem texto \'Alternar\'';
$string['setlayout_no_toggle_word_toggle_section_x'] = 'Sem texto \'Alternar\' e secção x';
$string['setlayout_no_toggle_word_toggle_section_x_section_no'] = 'Sem texto \'Alternar\', secção x e número da secção';
$string['setlayout_section_number'] = 'Número do tópico';
$string['setlayout_toggle_section_x'] = '\'Tópico x\' / \'Semana x\' / \'Dia x\'';
$string['setlayout_toggle_section_x_section_number'] = '“Tópico x” / “Semana x” / “Dia x” e número da secção';
$string['setlayout_toggle_word'] = 'Palavra “Alternar”';
$string['setlayout_toggle_word_section_number'] = 'Palavra “Alternar” e número da secção';
$string['setlayout_toggle_word_section_x'] = 'Palavra “Alternar” e “Tópico x” / “Semana x” / “Dia x”';
$string['setlayoutcolumnorientation'] = 'Disposição em colunas';
$string['setlayoutcolumnorientation_help'] = 'Vertical - Secções dispostas de cima para baixo.<br />Horizontal - Secções dispostas da esquerda para a direita.';
$string['setlayoutcolumns'] = 'Colunas';
$string['setlayoutcolumns_help'] = 'Números de colunas a utilizar.';
$string['setlayoutelements'] = 'Elementos';
$string['setlayoutelements_help'] = 'Que informação será exibida sobre os botões/secções.';
$string['setlayoutstructure'] = 'Estrutura';
$string['setlayoutstructure_help'] = 'A estrutura da disciplina. Pode escolher entre:<br />
\'Tópicos\' - cada secção é apresentada como um tópico por ordem de n.º da secção.<br />
\'Semanas\' - cada secção é apresentada como uma semana por ordem cronológica, desde a data de início da disciplina.<br />
\'Semana atual primeiro\' - idêntico a \'Semanas\' mas a semana atual é exibida no topo e as semanas anteriores em ordem descendente são apresentadas por baixo, exceto quando o modo de edição está ativo em que se apresentam de modo idêntico a \'Semanas\'.<br />
\'Tópico atual primeiro\' - idêntico a \'Tópicos\' mas o tópico atual, se definido, é exibido no topo.<br />
\'Dias\' - cada secção é apresentada como um dia em ordem cronológica ascendente desde a data de início da disciplina.';
$string['setlayoutstructurecurrenttopicfirst'] = 'Tópico atual primeiro';
$string['setlayoutstructureday'] = 'Dia';
$string['setlayoutstructurelatweekfirst'] = 'Semana atual primeiro';
$string['setlayoutstructuretopic'] = 'Tópico';
$string['setlayoutstructureweek'] = 'Semana';
$string['setshowsectionsummary'] = 'Mostrar resumo da secção quando contraída';
$string['setshowsectionsummary_help'] = 'Define se o resumo da secção é sempre exibido independentemente do estado da secção , contraída ou expandida';
$string['settogglealignment'] = 'Alinhamento do texto do botão';
$string['settogglealignment_help'] = 'Define o alinhamento do texto no botão';
$string['settoggleallenabled'] = 'Alternar todos ativado';
$string['settoggleallenabled_help'] = 'Alternar todas as funcionalidade ativadas.';
$string['settoggleallhover'] = 'Alternar todos os ícones ao passar rato';
$string['settoggleallhover_help'] = 'Define se os ícones dos botões Expandir/Contrair todos mudam quando o rato passa por cima destes.';
$string['settogglebackgroundcolour'] = 'Cor do fundo do botão';
$string['settogglebackgroundcolour_help'] = 'Define a cor do fundo do botão';
$string['settogglebackgroundhovercolour'] = 'Cor do fundo do botão ao passar rato';
$string['settogglebackgroundhovercolour_help'] = 'Define a cor do fundo do botão quando o rato passa por cima.';
$string['settogglebackgroundhoveropacity'] = 'Alternar a opacidade do plano de fundo ao passar com o rato';
$string['settogglebackgroundhoveropacity_help'] = 'Define a opacidade do plano de fundo, ao passar o rato, entre 0 e 1 com incrementos de 0,1';
$string['settogglebackgroundopacity'] = 'Alternar a opacidade do plano de fundo';
$string['settogglebackgroundopacity_help'] = 'Define a opacidade do plano de fundo entre 0 e 1 com incrementos de 0,1';
$string['settoggleforegroundcolour'] = 'Cor do texto do botão';
$string['settoggleforegroundcolour_help'] = 'Define a cor do texto do botão.';
$string['settoggleforegroundhovercolour'] = 'Cor do texto do botão ao passar com o rato';
$string['settoggleforegroundhovercolour_help'] = 'Define a cor do texto do botão quando o rato passa por cima deste.';
$string['settoggleforegroundhoveropacity'] = 'Alternar a opacidade do primeiro plano ao passar com o rato';
$string['settoggleforegroundhoveropacity_help'] = 'Define a opacidade do texto, ao passar o rato, entre 0 e 1 com incrementos de 0,1';
$string['settoggleforegroundopacity'] = 'Alternar a opacidade do primeiro plano';
$string['settoggleforegroundopacity_help'] = 'Define a opacidade do texto entre 0 e 1 com incrementos de 0,1';
$string['settoggleiconposition'] = 'Posição do ícone';
$string['settoggleiconposition_help'] = 'Define se o ícone deve ser posicionado à esquerda ou direita  do texto do botão.';
$string['settoggleiconset'] = 'Ícones';
$string['settoggleiconset_help'] = 'Define o conjunto de ícones a utilizar';
$string['setviewsinglesectionenabled'] = 'Visualizar secção única ativada';
$string['setviewsinglesectionenabled_help'] = 'Funcionalidade Visualizar secção única ativada.';
$string['showadditionalmoddata'] = 'Mostrar informações adicionais de: {$a} na disciplina';
$string['showadditionalmoddata_help'] = 'Permitir que todos os utilizadores vejam o prazo da atividade e os utilizadores com permissão de avaliação vejam o número de submissões na página da disciplina para atividades.';
$string['showfromothers'] = 'Mostrar';
$string['sidepost'] = 'Direita';
$string['sidepre'] = 'Conteúdo';
$string['small'] = 'Pequeno';
$string['smiley'] = 'Sorriso';
$string['square'] = 'Quadrado';
$string['sunmoon'] = 'Sol / Lua';
$string['switch'] = 'Interruptor';
$string['three'] = 'Três';
$string['topcoll:changecolour'] = 'Alterar ou repor a cor';
$string['topcoll:changelayout'] = 'Alterar ou repor a estrutura';
$string['topcoll:changetogglealignment'] = 'Alterar ou repor a definição do alinhamento do botão';
$string['topcoll:changetoggleiconset'] = 'Alterar ou repor a definição dos ícones do botão';
$string['topcollall'] = 'secções.';
$string['topcollclosed'] = 'Contrair tudo';
$string['topcollopened'] = 'Expandir tudo';
$string['topcollsidewidthlang'] = 'en-28px';
$string['topcolltoggle'] = 'Alternar';
$string['two'] = 'Duas';
$string['viewonly'] = 'Ver apenas \'{$a->sectionname}\'';
$string['xanswered'] = '{$a->completed} responderam';
$string['xattempted'] = '{$a->completed} tentaram responder';
$string['xcontributed'] = '{$a->completed} contribuíram';
$string['xofyanswered'] = '{$a->completed} de {$a->participants} responderam';
$string['xofyattempted'] = '{$a->completed} de {$a->participants} tentaram responder';
$string['xofycontributed'] = '{$a->completed} de {$a->participants} contribuíram';
$string['xofysubmitted'] = '{$a->completed} de {$a->participants} submeteram';
$string['xsubmitted'] = '{$a->completed} submeteram';
$string['xungraded'] = '{$a} não avaliada';
