<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'facetoface', language 'hu', version '4.4'.
 *
 * @package     facetoface
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addingsession'] = 'Új hozzáadása {$a} alkalmaihoz';
$string['addmanageremailaddress'] = 'Menedzser email címének hozzáadása';
$string['addmanageremailinstruction'] = 'Korábban még nem adta meg a menedzsere email címét. Kérjük, adja meg alább az alkalomra való jelentkezéshez!';
$string['addnewfield'] = 'Új egyedi mező hozzáadása';
$string['addnewfieldlink'] = 'Új egyedi mező létrehozása';
$string['addnewnotice'] = 'Új portálértesítés hozzáadása';
$string['addnewnoticelink'] = 'Új portálértesítés létrehozása';
$string['addremoveattendees'] = 'Résztvevők hozzáadása/eltávolítása';
$string['addsession'] = 'Új időpont hozzáadása';
$string['addstudent'] = 'Tanuló hozzáadása';
$string['addtoallsessions'] = 'Felhasználók hozzáadás minden (jövőbeli) alkalomhoz';
$string['addtoallsessions_help'] = 'Ezzel az beállítással lehetséges a kiválasztott felhasználókat az összes elkövetkezendő alkalomhoz hozzáadni. Bekapcsolása esetén a kiválasztott felhasználók ehhez és a tevékenység összes többi, jövőbeli alkalmához hozzá lesznek adva.';
$string['alllocations'] = 'Minden helyszín';
$string['allowcancellations'] = 'Lemondás engedélyezése';
$string['allowcancellations_help'] = 'Bekapcsolása esetén a résztvevőknek lehetőségük lesz lemondani a jelentkezéseiket';
$string['allowcancellationsdefault'] = 'Alapértelmezés a lemondás engedélyezéséhez';
$string['allowcancellationsdefault_help'] = 'Bejelölése esetén az alkalmak létrehozásakor alapértelmezetten engedélyezett lesz a jelentkezések lemondása.';
$string['allowoverbook'] = 'Túljelentkezés engedélyezése';
$string['allowoverbook_help'] = 'A "Túljelentkezés engedélyezése" bejelölése esetén a tanulók akkor is jelentkezhetnek egy alkalomra, ha az már megtelt <br />

Amikor egy tanuló egy már megtelt alkalomra jelentkezik, egy e-mailt kap az alkalom várólistájára kerülésről és hogy értesítést fog kapni amennyiben a foglalás elérhetővé válik.';
$string['allsessionsin'] = '{$a} minden alkalma';
$string['alreadysignedup'] = 'Már jelentkezett erre a Személyes alkalom tevékenységre!';
$string['answer'] = 'Bejelentkezés';
$string['answercancel'] = 'Kijelentkezés';
$string['approvalreqd'] = 'Jóváhagyás szükséges';
$string['approvalreqd_help'] = 'A "Jóváhagyás szükséges" bejelölése esetén egy tanuló alkalomra jelentkezését a felettesének jóvá kell hagynia.';
$string['approve'] = 'Jóváhagyás';
$string['assessmentyour'] = 'Az értékelése';
$string['attendance'] = 'Jelenlét';
$string['attendanceinstructions'] = 'Válassza ki a felhasználókat, akik részt vettek az alkalmon:';
$string['attendedsession'] = 'Részt vett az alkalmon';
$string['attendees'] = 'Résztvevők';
$string['attendeesexporttofileheading'] = 'Résztvevők exportálása állományba';
$string['booked'] = 'Foglalva';
$string['bookedvscapacity'] = 'Foglalva / Férőhelyek';
$string['bookingcancelled'] = 'Foglalása törlése került';
$string['bookingcompleted'] = 'Foglalása sikeres volt';
$string['bookingfull'] = 'Megtelt';
$string['bookingopen'] = 'Foglalható';
$string['bookingstatus'] = 'Foglalása van az alábbi foglalásra';
$string['calendareventdescriptionbooking'] = 'Foglalása van erre a <a href="{$a}">Személyes alkalomra</a>.';
$string['calendareventdescriptionsession'] = 'Létrehozta ezt a <a href="{$a}">Személyes alkalmat</a>.';
$string['calendaroptions'] = 'Naptárbeállítások';
$string['cancelbooking'] = 'Foglalás lemondása';
$string['cancelbookingfor'] = '{$a} foglalás lemondása';
$string['cancellation'] = 'Lemondás';
$string['cancellationconfirm'] = 'Biztosan szeretné lemondani ezt a foglalást?';
$string['cancellationinstrmngr'] = '# Értesítés a felettesnek';
$string['cancellationinstrmngr_help'] = 'Az **Értesítés küldése a felettesnek** bejelölése esetén az **Értesítés a felettesnek** szövegmező tartalma alapján egy értesítést kap a tanuló felettese arról, hogy az illető lemondta foglalását az alkalomnál.';
$string['cancellationmessage'] = 'Lemondási üzenet';
$string['cancellationmessage_help'] = 'A felhasználók ezt az üzenet kapják, amikor lemondják foglalásukat egy alkalomnál.';
$string['cancellations'] = 'Lemondások';
$string['cancellationsent'] = 'Rögtön e-mail kell kapjon a foglalás lemondásáról.';
$string['cancellationsentmgr'] = 'Ön és felettese rögtön e-mailt kell kapjanak a foglalás lemondásáról.';
$string['cancellationstablesummary'] = 'A foglalásaikat lemondó felhasználók listája.';
$string['cancelreason'] = 'Indoklás';
$string['cannotapproveatcapacity'] = 'Nincs lehetőség több résztvevő engedélyezésére mert az alkalom megtelt.';
$string['cannotsignupsessioninprogress'] = 'Nem lehetséges jelentkezni, az alkalom már zajlik.';
$string['cannotsignupsessionover'] = 'Nem lehetséges jelentkezni, az alkalom már véget ért.';
$string['capacity'] = 'Férőhelyek';
$string['capacity_help'] = 'A **Férőhelyek** megadja az alkalmon elérhető férőhelyek számát.

Amikor egy alkalomnál elfogynak szabad férőhelyek, az alkalom részletei onnantól nem jelennek meg a kurzusoldalon. A \'Minden alkalom megtekintése\' oldalon ezen részletek már kiszürkítve fognak megjelenni és a tanulók nem tudnak jelentkezni az alkalomra.
&nbsp;';
$string['caseinsensitive'] = 'Nem kis/nagybetű érzékeny';
$string['changemanageremailaddress'] = 'E-mail cím módosítása';
$string['changemanageremailinstruction'] = 'Adja meg jelenlegi felettesének e-mail címét!';
$string['clearall'] = 'Mind törlése';
$string['closed'] = 'Zárva';
$string['completiondetail:attendance'] = 'Részvétel előírása';
$string['completiondetail:attendance_disabled'] = 'A részvétel nem kötelező';
$string['completiondetail:attendance_full'] = 'A részvétel végig kötelező';
$string['completiondetail:attendance_partial'] = 'Kötelező legalább a részleges jelenlét';
$string['conditions'] = 'Feltételek';
$string['conditionsexplanation'] = 'Az alábbi feltételek mindegyikének teljesülnie kell, hogy az értesítés megjelenjen az képzési naptárban:';
$string['confirm'] = 'Megerősít';
$string['confirmanager'] = 'Felettes e-mail címének megerősítése';
$string['confirmation'] = 'Megerősítés';
$string['confirmationinstrmngr'] = '# Értesítés a felettesnek';
$string['confirmationinstrmngr_help'] = 'Az "Értesítés küldése a felettesnek" bejelölése esetén az "Értesítés a felettesnek" szövegmező tartalma alapján egy értesítést kap a munkatárs felettese arról, hogy az illető lemondta foglalását az alkalomnál.';
$string['confirmationmessage'] = 'Megerősítő üzenet';
$string['confirmationmessage_help'] = 'A felhasználók ezt az üzenet kapják, amikor jelentkeznek egy alkalomnál.';
$string['confirmationsent'] = 'A megerősítő üzenetnek rögtön meg kellene érkeznie.';
$string['confirmationsentmgr'] = 'Ön és felettese rögtön e-mailt kell kapjanak a foglalás lemondásáról.';
$string['confirmmanageremailaddress'] = 'Felettes e-mail címének megerősítése';
$string['confirmmanageremailaddressquestion'] = 'Továbbra is <b>{$a}</b> a felettese e-mail címe?';
$string['confirmmanageremailinstruction1'] = 'Korábban az alábbit adta meg felettese e-mail címeként:';
$string['confirmmanageremailinstruction2'] = 'Továbbra is ez a felettese e-mail címe?';
$string['continuetologin'] = 'Kattintson a továbbra a bejelentkezéshez';
$string['copy'] = 'Másolás';
$string['copyingsession'] = 'Másolás {$a} új alkalmaként';
$string['copysession'] = 'Alkalom másolása';
$string['cost'] = 'Részvételi díj';
$string['costheading'] = 'Alkalom részvételi díja';
$string['crontask'] = 'Személyes alkalom karbantartó feladatai';
$string['currentstatus'] = 'Jelenlegi státusz';
$string['customfield_notvisible'] = 'Senki';
$string['customfield_visibility'] = 'Láthatja';
$string['customfield_visibility_help'] = 'Ez a beállítás megadja, hogy ki láthatja az egyedi mező nevét és értékét az alkalmak listájában a moduloldalon vagy egy alkalomra való jelentkezésnél.';
$string['customfield_visibletoall'] = 'Mindenki';
$string['customfield_visibletoteachers'] = 'Tanárok';
$string['customfieldid'] = 'Egyedi mező azonosítója';
$string['customfieldnewshortname'] = 'Egyedi mező új rövid neve';
$string['customfieldoriginalshortname'] = 'Egyedi mező eredeti rövid neve';
$string['customfieldsheading'] = 'Egyedi alkalommezők';
$string['date'] = 'Időpont';
$string['dateadd'] = 'Új Időponthozzáadása';
$string['datebooked'] = 'Időpont lefoglalva';
$string['dateremove'] = 'Időpont törlése';
$string['datesignedup'] = 'Jelentkezés ideje';
$string['datetext'] = 'Ön jelentkezett az alábbi dőpontra';
$string['decidelater'] = 'Döntés később';
$string['decline'] = 'Elutasítás';
$string['delete'] = 'Törlés';
$string['deleteall'] = 'Mind törlése';
$string['deletesession'] = 'Alkalom törlése';
$string['deletesessionconfirm'] = 'Biztos benne, hogy ezt az eseményt és a hozzá tartozó összes jelentkezőt törli?';
$string['deletingsession'] = '{$a} alkalmának törlése';
$string['description'] = 'Leírás';
$string['description_help'] = 'A **Leírás** az a kurzusleírás, mely az alkalomra jelentkezés során jelenik meg a tanuló számára.

A **Leírás** ugyancsak megjelenik a képzési naptárban.';
$string['details'] = 'Részletek';
$string['details_help'] = 'A részletek megadása alkalmaként lehetséges.
Amennyiben a részletek mezőben szerepel érték, akkor az a feliratkozási felületen is megjelenítésre kerül.
Alapértelmezés szerint a részletek szövege megjelenik továbbá a megerősítő, az emlékeztető, a várólistás és a lemondásos e-mail üzenetekben is';
$string['discountcode'] = 'Kuponkód';
$string['discountcode_help'] = 'A Kuponkód az a kód, amellyel a munkatársak képzéséhez kapcsolódó kedvezményes díj biztosítható. Amennyiben a munkatárs nem adja meg a kuponkódot, esetében a normál részvételi díj kerül feltüntetésre a képzésnél.';
$string['discountcodelearner'] = 'Kuponkód';
$string['discountcodelearner_help'] = 'Amennyiben rendelkezik kedvezményre jogosító kuponnal, azt itt adhatja meg. Üresen hagyva az alkalom normál részvételi díja felszámításra kerül.';
$string['discountcost'] = 'Kedvezményes részvételi díj';
$string['discountcost_help'] = 'A Kedvezményes részvételi díj az az összeg, mely a tagság azonosítóval rendelkező munkatársak által fizetendő.
Ha egy munkatárs megadja a tagsági azonosítót az alkalomra jelentkezés során, a kedvezményes díj lesz feltüntetve a kurzus értékelésnaplójának Részvételi díj oszlopában.';
$string['duration'] = 'Hossz';
$string['duration_help'] = 'A **Hossz** a képzés teljes hossza órákban.
Például:
* „2 óra” beállításához **2** vagy **2:00**,
* „1 óra és 30 perc” beállításához **1:30**,
* „45 perc” beállításához **0:45**,
* „20 perc” beállításához **0:20** használandó.

Ha a képzés kettő vagy több időpontból áll, a hossz ezek összessége.';
$string['early'] = '{$a} korábban';
$string['edit'] = 'Szerkesztés';
$string['editingsession'] = '{$a} alkalmának szerkesztése';
$string['editsession'] = 'Alkalom szerkesztése';
$string['email:instrmngr'] = 'Értesítés a felettesnek';
$string['email:message'] = 'Üzenet';
$string['email:subject'] = 'Tárgy';
$string['emailmanager'] = 'Értesítés küldése a felettesnek';
$string['emailmanagercancellation'] = '# Értesítés küldése a felettesnek';
$string['emailmanagercancellation_help'] = 'Az "Értesítés küldése a felettesnek" bejelölése esetén egy e-mailt kap a tanuló felettese arról, hogy az illető lemondta foglalását az alkalomnál.';
$string['emailmanagerconfirmation'] = '# Értesítés küldése a felettesnek';
$string['emailmanagerconfirmation_help'] = 'Az "Értesítés küldése a felettesnek" bejelölése esetén egy megerősítő e-mailt kap a tanuló felettese arról, hogy az illető jelentkezett az alkalomnál.';
$string['emailmanagerreminder'] = '# Értesítés küldése a felettesnek';
$string['emailmanagerreminder_help'] = 'Az "Értesítés küldése a felettesnek" bejelölése esetén egy értesítő e-mailt kap a tanuló felettese néhány nappal az alkalom kezdése előtt.';
$string['emptylocation'] = 'A Helység üres volt';
$string['enrolled'] = 'beiratkozva';
$string['error:addalreadysignedupattendee'] = '{$a} már jelentkezett erre a Személyes alkalom tevékenységre.';
$string['error:addattendee'] = 'Nem sikerült {$a} hozzáadása az alkalomhoz.';
$string['error:bookingsuploadfileerrorsfound'] = '{$a} hiba található a feltöltött állományban. A foglalások feldolgozása nem történhet meg ezek megoldása nélkül.';
$string['error:bookingsuploadfileheaderfieldmismatch'] = 'A mezők száma eltér a feltöltött állomány {$a}. sorában.';
$string['error:cancelbooking'] = 'A foglalás törlése során hiba történt.';
$string['error:cancellationsnotallowed'] = 'Nem törölheti ezt a jelentkezést.';
$string['error:cancellationtooclose'] = 'Nem törölheti ezt a jelentkezést. A foglalások törlése az alkalom előtt ennyivel lehetséges: {$a}';
$string['error:cannotemailmanager'] = 'A {$a->submissionid} azonosítójú leadáshoz az emlékeztető e-mail elküldése {$a->userid} részére megtörtént, de a felettese címére ({$a->manageremail}) nem sikerült.';
$string['error:cannotemailuser'] = 'A {$a->submissionid} azonosítójú leadáshoz az e-mail elküldése {$a->userid} részére nem sikerült ({$a->useremail}).';
$string['error:cannotloadfile'] = 'A feltöltése sikertelen, ellenőrizze az állományt és próbálja újra!';
$string['error:cannotprocessbookingsvalidationerrorsexist'] = 'Az érvényesítés hibákat talált, melyekkel foglalkozni kell az állomány teljes feldolgozása előtt. Kérjük, javítsa ezeket és próbálkozzon újra!';
$string['error:cannotsendconfirmationmanager'] = 'A megerősítő üzenet elküldése az Ön e-mail címére megtörtént, de a felettese számára nem sikerült elküldeni.';
$string['error:cannotsendconfirmationthirdparty'] = 'A megerősítő üzenet elküldése az Ön és felettese e-mail címére megtörtént, de a harmadik számára nem sikerült elküldeni.';
$string['error:cannotsendconfirmationuser'] = 'Hiba történt az Ön e-mail címére szánt megerősítő üzenet elküldése közben.';
$string['error:cannotsendconfirmationusermanager'] = 'A megerősítő üzenet elküldése sem az Ön, sem a felettese e-mail címére nem sikerült.';
$string['error:cannotsendrequestmanager'] = 'A jelentkezési kérelem elküldése a felettese e-mail címére nem sikerült.';
$string['error:cannotsendrequestuser'] = 'A jelentkezési kérelem elküldése az Ön e-mail címére nem sikerült.';
$string['error:canttakeattendanceforunstartedsession'] = 'A jelenlét naplózása nem lehetséges az alkalom kezdése előtt.';
$string['error:couldnotaddfield'] = 'Az egyedi alkalommező hozzáadása nem sikerült';
$string['error:couldnotaddnotice'] = 'Nem sikerült a portálértesítés hozzáadása.';
$string['error:couldnotaddsession'] = 'Az alkalom hozzáadása nem sikerült';
$string['error:couldnotaddtrainer'] = 'A Személyes alkalom előadójának mentése nem sikerült';
$string['error:couldnotcopysession'] = 'Az alkalom másolása nem sikerült';
$string['error:couldnotdeletefield'] = 'Az egyedi alkalommező törlése nem sikerült';
$string['error:couldnotdeletenotice'] = 'Nem sikerült a portálértesítés törlése.';
$string['error:couldnotdeletesession'] = 'Az alkalom törlése nem sikerült';
$string['error:couldnotdeletetrainer'] = 'A Személyes alkalom előadójának törlése nem sikerült';
$string['error:couldnotfindsession'] = 'Az újonnan hozzáadott alkalom nem található';
$string['error:couldnotsavecustomfield'] = 'Az egyedi mező mentése nem sikerült';
$string['error:couldnotupdatecalendar'] = 'Az alkalomhoz tartozó naptáresemény frissítése nem sikerült.';
$string['error:couldnotupdatef2frecord'] = 'A Személyes alkalom jelentkezés rekordját nem sikerült frissíteni az adatbázisban';
$string['error:couldnotupdatefield'] = 'Az egyedi mező frissítése nem sikerült.';
$string['error:couldnotupdatemanageremail'] = 'A felettes e-mail címének frissítése nem sikerült.';
$string['error:couldnotupdatenotice'] = 'Nem sikerült a portálértesítés frissítése.';
$string['error:couldnotupdatesession'] = 'Az alkalom frissítése nem sikerült';
$string['error:coursemisconfigured'] = 'A kurzus beállításai hibásak';
$string['error:cronprefix'] = 'Hiba: Személyes alkalom cron:';
$string['error:emptylocation'] = 'A Helység üres volt.';
$string['error:emptymanageremail'] = 'A felettes e-mail címe üres.';
$string['error:emptyvenue'] = 'A Helyszín üres volt.';
$string['error:enrolmentfailed'] = '{$a} kurzusba íratása sikertelen volt.';
$string['error:eventoccurred'] = 'Nem mondhat le egy eseményt, ami már megtörtént!';
$string['error:f2ffailedupdatestatus'] = 'A Személyes alkalom nem tudta frissíteni a felhasználó állapotát';
$string['error:fieldidincorrect'] = 'Helytelen mezőazonosító: {$a}';
$string['error:fieldselected'] = 'Ennél a mezőnél ki lett választva, hogy az megjelenjen a kurzusoldalon. Válasszon másik mezőt!';
$string['error:incorrectcoursemodule'] = 'Helytelen kurzusmodul';
$string['error:incorrectcoursemoduleid'] = 'Helytelen kurzusmodul-azonosító';
$string['error:incorrectcoursemodulesession'] = 'Helytelen Személyes alkalom kurzusmodul';
$string['error:incorrectfacetofaceid'] = 'Helytelen Személyesalkalom-azonosító';
$string['error:incorrectnotificationtype'] = 'Helytelen a megadott értesítési típus';
$string['error:invalidnotificationtypespecified'] = 'A megadott értesítési típus érvénytelen . A várt érték „ical”, „email”, „both” (mindkettő) vagy „” lehet, de a kapott „{$a}” volt';
$string['error:invalidstatusspecified'] = 'A megadott állapot érvénytelen. A várt érték „booked” (foglalt), „cancelled” (lemondta), „no_show” (nem jelent meg), „partially_attended” (részben jelen volt) vagy „fully_attended” (végig jelen volt) lehet. Üres esetén az alapértelmezett a „booked”. A kapott érték „{$a}” volt';
$string['error:invaliduserid'] = 'Érvénytelen felhasználói azonosító';
$string['error:manageremailaddressmissing'] = 'Jelenleg nincs a rendszerben hozzárendelve feletteshez. Lépjen kapcsolatba a portál kezelőivel!';
$string['error:multipleusersessions'] = '{$a} felhasználó egynél több alkalommal rendelkezik';
$string['error:multipleusersmatched'] = 'Az {$a} azonosító több felhasználóhoz is kapcsolódik';
$string['error:mustspecifycoursemodulefacetoface'] = 'Kötelező megadni egy kurzusmodul vagy Személyes alkalom azonosítót!';
$string['error:nomanageremail'] = 'Nem adta meg a felettese e-mail címét';
$string['error:nomanagersemailset'] = 'Nincs beállítva a felettes e-mail címe';
$string['error:nopermissiontosignup'] = 'Nincs engedélye jelentkezni erre az alkalomra.';
$string['error:noticeidincorrect'] = 'Helytelen értesítésazonosító: {$a}';
$string['error:problemsigningup'] = 'Hiba történt a jelentkezés során.';
$string['error:removeattendee'] = 'Nem sikerült {$a} eltávolítása az alkalomról.';
$string['error:sessionalreadystarted'] = 'Nem lehetséges {$a} alkalom használata, mert az már elkezdődött.';
$string['error:sessiondoesnotexist'] = 'Nem létezik {$a} azonosítójú alkalom.';
$string['error:sessionoverbooked'] = 'A túljelentkezés {$a->amount} személyt érint a {$a} azonosítójú alkalomnál.';
$string['error:sessionstartafterend'] = 'Az alkalom kezdő időpontja a zárás utáni.';
$string['error:shortnametaken'] = 'Ezzel a rövid névvel már létezik egyedi mező.';
$string['error:signedupinothersession'] = 'Már jelentkezett egy másik alkalomra ennél a tevékenységnél. Csak egy alkalomra jelentkezhet ennél a Személyes alkalom tevékenységnél.';
$string['error:tryingtoupdatesessionfromanothermodule'] = 'Nem sikerült frissíteni a(z) {$a->session} azonosítójú alkalmat, mely egy másik Személyes alkalom tevékenységhez tartozik {$a->f} azonosítóval.';
$string['error:unknownbuttonclicked'] = 'Nincs a kattintott gombhoz kapcsolódó művelet';
$string['error:userdoesnotexist'] = '{$a} felhasználó nem létezik';
$string['error:userisnotenrolledintocourse'] = '{$a} felhasználó nincs beiratkozva ebbe a kurzusba.';
$string['eventaddsession'] = 'Alkalom hozzáadva';
$string['eventaddsessionfailed'] = 'Alkalom hozzáadása (SIKERTELEN)';
$string['eventapproverequests'] = 'Alkalom kérelmeinek jóváhagyása';
$string['eventattendancetaken'] = 'Alkalmon jelenlevők naplózva';
$string['eventattendeesviewed'] = 'Alkalom résztvevőinek megtekintve';
$string['eventcancelbooking'] = 'Alkalom foglalásának törlése';
$string['eventcancelbookingfailed'] = 'Alkalom foglalásának törlése (SIKERTELEN)';
$string['eventcoursef2fviewed'] = 'Kurzus Személyes alkalom példányai megtekintve';
$string['eventcoursemoduleviewed'] = 'Személyes alkalom modul példány megtekintve';
$string['eventcsvprocessed'] = 'CSV feldolgozva';
$string['eventdeletesession'] = 'Alkalom törölve';
$string['eventdeletesessionfailed'] = 'Alkalom törlése (SIKERTELEN)';
$string['eventsignup'] = 'Alkalomra jelentkezés';
$string['eventsignupfailed'] = 'Alkalomra jelentkezés (SIKERTELEN)';
$string['eventtakeattendancefailed'] = 'Alkalmon jelenlevők naplózása (SIKERTELEN)';
$string['eventupdatemanageremailfailed'] = 'Felettes e-mail frissítése (SIKERTELEN)';
$string['eventupdatesession'] = 'Alkalom frissítve';
$string['eventupdatesessionfailed'] = 'Alkalom frissítése (SIKERTELEN)';
$string['excelformat'] = 'Excel';
$string['export'] = 'Exportálás';
$string['exportattendance'] = 'Jelenlét exportálása';
$string['exporttofile'] = 'Exportálás állományba';
$string['facetoface'] = 'Személyes alkalom';
$string['facetoface:addattendees'] = 'Résztvevők hozzáadása egy alkalomhoz';
$string['facetoface:addinstance'] = 'Példány hozzáadása';
$string['facetoface:configurecancellation'] = 'A jelentkezéslemondás szabályozásának engedélyezése a Személyes alkalom tevékenység hozzáadásakor/szerkesztésekor.';
$string['facetoface:confirmandprocess'] = 'Megerősít és feldolgoz';
$string['facetoface:createsitewideevent'] = 'Portálszintű naptáresemények létrehozásának engedélyezése';
$string['facetoface:csvprocessed'] = 'Rekordok sikeresen feldolgozva.';
$string['facetoface:editsessions'] = 'Személyes alkalmak hozzáadása, szerkesztése, másolása és törlése';
$string['facetoface:examplecsv'] = 'Minta szöveges állomány';
$string['facetoface:overbook'] = 'Jelentkezés megtelt alkalmakra.';
$string['facetoface:removeattendees'] = 'Résztvevők eltávolítása a Személyes alkalomról';
$string['facetoface:signup'] = 'Jelentkezés egy alkalomra';
$string['facetoface:takeattendance'] = 'Jelenlét naplózása';
$string['facetoface:uploadandpreview'] = 'Foglalások feltöltése és érvényesítése';
$string['facetoface:uploadbookings'] = 'Foglalások feltöltése';
$string['facetoface:uploadbookingsfile'] = 'Foglalások állomány';
$string['facetoface:uploadbookingsfiledesc'] = 'Előírt mezők:
- E-mail cím (kötelező)
- Alkalom száma (kötelező)
- Kuponkód (választható)
- Értesítés típusa (választható - érvényes lehetőségek: „email”, „ical”, „both” (mindkettő))';
$string['facetoface:uploadreadytoprocess'] = 'A feltöltött állomány érvényesítése megtörtént és kész a feldolgozásra.';
$string['facetoface:validatebookings'] = 'Foglalások érvényesítése';
$string['facetoface:view'] = 'Személyes alkalom tevékenységes és alkalmak megtekintése';
$string['facetoface:viewattendees'] = 'Résztvevők és résztvevőlista megtekintése';
$string['facetoface:viewcancellations'] = 'Lemondások megtekintése';
$string['facetoface:viewemptyactivities'] = 'Üres Személyes alkalom tevékenységek megtekintése';
$string['facetofaceattendee'] = 'Személyes alkalom résztvevő';
$string['facetofacebooking'] = 'Személyes alkalom foglalás';
$string['facetofacename'] = 'Személyes alkalom neve';
$string['facetofacesession'] = 'Személyes alkalom';
$string['facetofacesessiondates'] = 'Személyes alkalom Időpontok';
$string['feedback'] = 'Visszajelzés';
$string['feedbackupdated'] = 'Visszajelzés frissítve {$a} személynél.';
$string['field:multiselect'] = 'Többszörös kijelölés';
$string['field:select'] = 'Lehetőségek menü';
$string['field:text'] = 'Szöveg';
$string['fielddeleteconfirm'] = 'Biztosan törli „{$a}” mezőt és minden ahhoz kapcsolódó alkalom adatot?';
$string['floor'] = 'Emelet';
$string['format'] = 'Forma';
$string['full'] = 'Az időpont megtelt';
$string['fullfilter'] = 'Megtelt';
$string['fullybooked'] = 'Teltház';
$string['goback'] = 'Visszalépés';
$string['guestsno'] = 'Sajnáljuk, de a vendégek nem jelentkezhetnek alkalmakra.';
$string['hidden'] = 'Rejtve';
$string['icalendarheading'] = 'iCalendar mellékletek';
$string['import'] = 'Importálás';
$string['info'] = 'Információ';
$string['late'] = '\\{$a} késés';
$string['location'] = 'Helység';
$string['location_help'] = 'A **Helység** megadja az alkalom elhelyezkedését (város, megye, ország stb.)

A **Helység** megjelenik a kurzusoldalon, a „Jelentkezés” oldalon, a „Minden alkalom megtekintése” oldalon és az e-mail értesítésekben.

A „Minden alkalom megtekintése” oldalon a felsorolt alkalmak helység szerint szűrhetők.';
$string['lookfor'] = 'Keresés';
$string['manageradded'] = 'A felettesének e-mail címe elfogadva.';
$string['managerchanged'] = 'A felettesének e-mail címe módosítva.';
$string['manageremail'] = 'Felettes e-mailje';
$string['manageremailaddress'] = 'Felettes e-mail címe';
$string['manageremaildisabled'] = 'A felettes e-mail beállítások nem elérhetők ha a felettesi jóváhagyás nincs bekapcsolva.';
$string['manageremailformat'] = 'Az e-mail címnek „{$a}” formátumúnak kell lennie, hogy elfogadható legyen.';
$string['manageremailheading'] = 'Felettes e-mailek';
$string['manageremailinstruction'] = 'Egy képzési alkalomra jelentkezéshez egy megerősítő e-mailt kell küldeni az Ön és felettese e-mail címére.';
$string['manageremailinstructionconfirm'] = 'Kérjük, erősítse meg, hogy ez a felettese e-mail címe:';
$string['managername'] = 'Felettes neve';
$string['managerupdated'] = 'A felettesének e-mail címe frissítve.';
$string['maximumpoints'] = 'Maximum pontszám';
$string['maximumsize'] = 'Résztvevők maximális száma';
$string['message'] = 'Változás {$a->coursename} kurzus foglalásainál!

{$a->coursename} kurzus {$a->duedate} ({$a->name}) időpontjánál felszabadult egy hely, melyre Ön került most be. Amennyiben mégsem alkalmas már ez az időpont, kérjük, mondja le foglalását itt <a href=\'{$a->url}\'>{$a->url}</a>!';
$string['mods_help'] = 'A Személyes alkalom tevékenységek az előzetes jelentkezéshez kötött, személyes jelenlétet igénylő képzések nyilvántartására szolgálnak.

Egy tevékenység egy vagy több, egymással azonos alkalomként hirdethető meg. Az alkalmak több napot is felölelhetnek.

A rendszer emlékeztető üzenetek küld a felhasználóknak és a feletteseiknek néhány nappal az alkalom kezdete előtt. A felhasználók egy-egy alkalomra jelentkezésnél vagy a foglalás lemondásakor megerősítő e-mailt kapnak.';
$string['modulename'] = 'Személyes alkalom';
$string['modulename_help'] = 'A Személyes alkalom tevékenységmodul lehetővé teszi, hogy a tanár egy vagy több, személyes jelenlétet igénylő alkalomhoz önkéntes jelentkezési rendszert hozzon létre.

Az egyes alkalmakhoz külön-külön beállíthatók olyan jellemzők, mint a helység, helyszín, kezdési és befejezési időpont, részvételi díj, férőhelyek száma stb. Az alkalmak több napot is felölelhetnek, de lehetnek ezek időpont nélküli vagy várólistás alkalmak is.

Egy tevékenység beállítható úgy, hogy felettesi jóváhagyást igényeljen, továbbá a tanárok beállíthatnak automatikus értesítéseket és emlékeztetőket a résztvevőknek.

A tanulók megtekinthetik az elérhető alkalmakat, jelentkezhetnek rájuk, a részvételük pedig rögzítésre kerül az Értékelések területen.';
$string['modulenameplural'] = 'Személyes alkalmak';
$string['moreinfo'] = 'További információ';
$string['multidate'] = '(több időpontos)';
$string['multiple'] = 'Többszörös';
$string['multiplesignupmethod'] = 'Többszörös jelentkezési mód';
$string['multiplesignupmethod_help'] = '„Alkalmanként”-ra állítva a tanulók a Személyes alkalom tevékenység minden egyes alkalmára külön tudnak jelentkezni. „Tevékenységenként”-re állítva a tanulók egyben, egyszerre jelentkeznek a tevékenység összes alkalmára.';
$string['multiplesignupperactivity'] = 'Tevékenységenként';
$string['multiplesignuppersession'] = 'Alkalmanként';
$string['newmanageremailaddress'] = 'Felettes e-mail címe';
$string['noactionableunapprovedrequests'] = 'Nincs jóváhagyásra váró kérelem';
$string['nocustomfields'] = '<p>Nincsenek egyedi mezők meghatározva.</p>';
$string['nofacetofaces'] = 'Nincsenek Személyes alkalom tevékenységek';
$string['none'] = 'Nincs';
$string['noremindersneedtobesent'] = 'Nincs elküldendő értesítés.';
$string['normalcost'] = 'Normál részvételi díj';
$string['normalcost_help'] = 'A Normál részvételi díj az az összeg, mely a tagság azonosítóval nem rendelkező munkatársak által fizetendő.

A normál díj a kurzus értékelésnaplójának Részvételi díj oszlopában fog megjelenni minden olyan munkatársnál, aki részt vesz az alkalmon (kivéve, ha beállításra kerül egy kedvezményes díj, és a munkatárs megadja a tagsági azonosítót az alkalomra jelentkezés során).';
$string['nosignedupusers'] = 'Erre az alkalomra nem jelentkezett egy felhasználó sem.';
$string['nositenotices'] = '<p>Nincs portálértesítés meghatározva.</p>';
$string['note'] = 'Megjegyzés';
$string['notefull'] = 'Még a betelt alkalomra is jelentkezhet. Ilyenkor várólistára kerül (pirossal jelölve). Ha valaki lemondja a részvételét, a várólista első helyezettje automatikusan átkerül a jelentkezettek közé, és erről értesítést kap e-mailben.';
$string['noteinfo'] = 'A legutóbbi rendszerfrissítés során a Személyes alkalom modul módosításra került. Mostantól az egyedi alkalommezőknek egyedi rövid névvel kell rendelkezniük. Mivel néhány egyedi mezője azonos rövid névvel szerepelt, ezek át lettek nevezve az ütközések elkerülése érdekében (lásd az alábbi táblázatot). Ez hatással lehet az e-mail üzenetekre, ha az üzenetsablonokban ezekre a mezőkre hivatkozik.';
$string['noticedeleteconfirm'] = 'Törli a(z) „{$a->name}” portálértesítést?<br/><blockquote>{$a->text}</blockquote>';
$string['noticetext'] = 'Értesítés szövege';
$string['notificationboth'] = 'E-mail értesítés és iCalendar időpont';
$string['notificationemail'] = 'Csak e-mail értesítés';
$string['notificationical'] = 'Csak iCalendar időpont';
$string['notificationtype'] = 'Értesítés típusa';
$string['notificationtype_help'] = 'Az értesítés típusánál kiválasztható, hogy a foglalásról milyen értesítés érkezzen a résztvevőnek.

* Csak iCalendar időpont
* Csak e-mail értesítés
* E-mail értesítés és iCalendar időpont';
$string['notsignedup'] = 'Nem jelentkezett erre az alkalomra.';
$string['notsubmittedyet'] = 'Még nincs értékelve';
$string['noupcoming'] = '<p><i>Nincsenek jövőbeli alkalmak</i></p>';
$string['odsformat'] = 'OpenDocument';
$string['onehour'] = '1 óra';
$string['oneminute'] = '1 perc';
$string['options'] = 'Beállítások';
$string['or'] = 'vagy';
$string['order'] = 'Rendezés';
$string['partiallyfull'] = 'Részlegesen megtelt';
$string['place'] = 'Helyiség';
$string['placeholder:alldates'] = '[mindenidopont]';
$string['placeholder:attendeeslink'] = '[resztvevokhivatkozas]';
$string['placeholder:cost'] = '[dij]';
$string['placeholder:details'] = '[reszletek]';
$string['placeholder:duration'] = '[hossz]';
$string['placeholder:facetofacename'] = '[szemelyesalkalomneve]';
$string['placeholder:finishtime'] = '[zaroidopont]';
$string['placeholder:firstname'] = '[keresztnev]';
$string['placeholder:lastname'] = '[vezeteknev]';
$string['placeholder:reminderperiod'] = '[emlekeztetoidotav]';
$string['placeholder:sessiondate'] = '[alkalomidopont]';
$string['placeholder:starttime'] = '[kezdoidopont]';
$string['pluginadministration'] = 'Személyes alkalom adminisztráció';
$string['pluginname'] = 'Személyes alkalom';
$string['points'] = 'Pontok';
$string['pointsplural'] = 'Pontok';
$string['potentialattendees'] = 'Lehetséges résztvevők';
$string['previoussessions'] = 'Előző alkalmak';
$string['printversionid'] = 'Nyomtatás módja: név nélkül';
$string['printversionname'] = 'Nyomtatás módja: névvel';
$string['privacy:metadata:facetoface_session_roles'] = 'Személyes alkalomnál előadó szereppel bíró felhasználók listázása';
$string['privacy:metadata:facetoface_signups'] = 'Felhasználói jelentkezések a Személyes alkalmakra';
$string['privacy:metadata:facetoface_signups:discountcode'] = 'A felhasználó által megadott kuponkód';
$string['privacy:metadata:facetoface_signups:id'] = 'A jelentkezés azonosítója';
$string['privacy:metadata:facetoface_signups:mailedreminder'] = 'A legutóbbi időpont, amikor egy emlékeztető elküldésre került';
$string['privacy:metadata:facetoface_signups:notificationtype'] = 'A felhasználó által választott értesítési mód.';
$string['privacy:metadata:facetoface_signups:sessionid'] = 'Az alkalom azonosítója';
$string['privacy:metadata:facetoface_signups_status'] = 'Egy alkalomhoz kapcsolódó felhasználói jelentkezés állapota';
$string['privacy:metadata:facetoface_signups_status:grade'] = 'Az alkalmon való részvételhez tartózó értékelés';
$string['privacy:metadata:facetoface_signups_status:note'] = 'Az alkalom lemondásának okát tárolja';
$string['privacy:metadata:facetoface_signups_status:signupid'] = 'A jelentkezés azonosítója';
$string['privacy:metadata:facetoface_signups_status:statuscode'] = 'A jelentkezés állapota, pl. cancelled (lemondva), declined (elutasítva), fully_attended (végig jelen volt)';
$string['privacy:metadata:facetoface_signups_status:timecreated'] = 'A jelentkezés létrehozásának ideje';
$string['privacy:metadata:roleid'] = 'A felhasználó szerepének azonosítója.';
$string['privacy:metadata:userid'] = 'A Személyes alkalom tevékenységhez hozzáférő felhasználó azonosítója';
$string['really'] = 'Biztosan törölni akarja ennek a Személyes alkalomnak minden eredményét?';
$string['registeredon'] = 'Jelentkezett ekkor';
$string['registrations'] = 'Jelentkezések';
$string['reminder'] = 'Emlékeztető';
$string['reminderinstrmngr'] = '# Értesítés a felettesnek';
$string['reminderinstrmngr_help'] = 'Az **Értesítés küldése a felettesnek** bejelölése esetén az **Értesítés a felettesnek** szövegmező tartalmával egy értesítést kap a munkatárs felettese arról, hogy az illető jelentkezett az alkalomnál.';
$string['remindermessage'] = 'Emlékeztető üzenet';
$string['remindermessage_help'] = 'Ez az üzenetet pár nappal az alkalom kezdő időpontja előtt kerül kiküldésre.';
$string['reminderperiod'] = 'A küldés előtti napok száma';
$string['reminderperiod_help'] = 'Az emlékeztető üzenet ennyi nappal az alkalom kezdése előtt kerül kiküldésre.';
$string['requestmessage'] = 'Kérelem üzenet';
$string['requestmessage_help'] = 'A **Jóváhagyás szükséges** bekapcsolása esetén a **Kérelem üzenet** rész elérhető.

A **Kérelem üzenet** rész megjeleníti azokat az értesítéseket, melyeket a tanuló és a felettese kapnak majd a tanuló részvételének jóváhagyási folyamata során.

**Tárgy**: a tanuló és a felettese által a kérelem jóváhagyásához kapcsolódóan kapott e-mailek tárgy mezőjében megjelenő szöveg.

**Üzenet**: annak az e-mailnek a szövege, melyet a tanuló kap arról, hogy az alkalomra jelentkezésük továbbításra került a felettese felé jóváhagyásra.

**Értesítés a felettesnek**: annak az e-mailnek a szövege, melyet a tanuló felettese kap arról, hogy az illető részt kíván venni az alkalmon.';
$string['room'] = 'Helyiség';
$string['room_help'] = 'A **Helyiség** megadja azt a nevet/számot/azonosítót, mellyel az alkalomnak helyet adó helyiség beazonosítható.

A **Helyiség** megjelenik a „Jelentkezés” oldalon, a „Minden alkalom megtekintése” oldalon és az e-mail értesítésekben';
$string['saveallfeedback'] = 'Minden válasz mentése';
$string['saveattendance'] = 'Jelenlét mentése';
$string['scheduledsession'] = 'Ütemezett alkalom';
$string['scheduledsessions'] = 'Ütemezett alkalmak';
$string['search:activity'] = 'Személyes alkalom tevékenységek';
$string['seatsavailable'] = 'Szabad helyek';
$string['seatsbooked'] = 'Foglalt helyek';
$string['seeattendees'] = 'Résztvevők megtekintése';
$string['sentremindermanager'] = 'Emlékeztető e-mail elküldve a felhasználó felettesének';
$string['sentreminderuser'] = 'Emlékeztető e-mail elküldve a felhasználónak';
$string['sessionavailability'] = 'Alkalom elérhetősége';
$string['sessiondate'] = 'Alkalom időpontja';
$string['sessiondateandtime'] = '{$a->startdatetime} - {$a->enddatetime} (időzóna: {$a->timezone})';
$string['sessiondatetime'] = 'Alkalom időpontja';
$string['sessiondatetimeknown'] = 'Az alkalom időpontja ismert';
$string['sessiondatetimeknown_help'] = '**Ha az alkalom időpontja ismert**

„Igen” beállítása esetén az alkalom dátuma és időpontja meg fog jelenni a kurzusoldalon (amennyiben az alkalom a közeljövőben van és elérhető), a „Minden alkalom megtekintése” oldalon, a jelentkezési oldalon, valamint az alkalomhoz kapcsolódó összes e-mail értesítésben.

Amikor egy munkatárs jelentkezik egy ismert időpontú alkalomra:

* A munkatárs és a felettese is kap egy megerősítő e-mailt (a „Megerősítő üzenet” résznél megadott formátumban).
* A munkatárs részére egy emlékeztető e-mail is kiküldésre kerül (az „Emlékeztető üzenet” résznél megadott formátumban), amelyet az alkalom előtt meghatározott számú nappal küld a rendszer – ezt az „A küldés előtti napok száma” beállítás határozza meg.

**Ha az alkalom időpontja nem ismert (vagy várólistás)**

„Nem” beállítása esetén a „várólistás” felirat fog megjelenni a kurzusoldalon, a „Minden alkalom megtekintése” oldalon, a jelentkezési oldalon, valamint az alkalomhoz kapcsolódó összes e-mail értesítésben.

Amikor egy munkatárs jelentkezik egy várólistás alkalomra:

* A munkatárs visszaigazoló e-mailt kap (a „Várólistás üzenet” résznél megadott formátumban).
* A munkatárs nem kap emlékeztető e-mailt.
* A munkatárs felettese nem kap megerősítő vagy lemondási értesítést.';
$string['sessionfinished'] = 'Véget ért';
$string['sessionfinishtime'] = 'Alkalom záró időpontja';
$string['sessionid'] = 'Alkalom azonosító száma';
$string['sessioninprogress'] = 'Az alkalom épp zajlik';
$string['sessionisfull'] = 'Ez az alkalom megtelt. Válasszon másikat vagy lépjen kapcsolatba az előadóval!';
$string['sessionnotstarted'] = 'Nem kezdődött el';
$string['sessionnumber'] = '#';
$string['sessionover'] = 'alkalom véget ért';
$string['sessionrequiresmanagerapproval'] = 'Ennél az alkalomnál felettesi jóváhagyás szükséges a foglaláshoz.';
$string['sessionroles'] = 'Alkalom szerepei';
$string['sessions'] = 'Alkalmak';
$string['sessionsoncoursepage'] = 'A kurzusoldalon megjelenített alkalmak';
$string['sessionsoncoursepage_help'] = 'Ez a kurzusoldalon az egyes Személyes alkalom tevékenységeknél megjelenített alkalmak száma.';
$string['sessionstartdate'] = 'Alkalom kezdő időpontja';
$string['sessionstartdateandtimewithouttimezone'] = '{$a->startdate}, {$a->starttime} - {$a->endtime}';
$string['sessionstarttime'] = 'Alkalom kezdő időpontja';
$string['sessionstatus'] = 'Alkalom állapota';
$string['sessionvenue'] = 'Alkalom helyszíne';
$string['sessionvisibility'] = 'Alkalom láthatósága';
$string['sessionvisibility_help'] = '* Látható: az alkalom megjelenik a listában és a tanulók hozzá tudnak férni.
* Rejtve: a hozzáférés a tanárokra és az alkalmak szerkesztésére jogosult felhasználókra korlátozott.';
$string['setting:addchangemanageremail'] = 'Felhasználók felkérése a feletteseik e-mail címének megadására.';
$string['setting:addchangemanageremail_caption'] = 'Felettes e-mailje:';
$string['setting:addchangemanageremaildefault'] = 'Felhasználók felkérése a feletteseik e-mail címének megadására.';
$string['setting:attendeesexportfields'] = 'Válassza ki, mely mezők kerüljenek bele az alkalom résztvevőinek exportált listájába! Ezek a mezők a résztvevők vezeték- és keresztneve mellett fognak megjelenni.';
$string['setting:attendeesexportfields_caption'] = 'Résztvevők exportált mezői';
$string['setting:cancelrestriction'] = 'Az legrövidebb időtartam, amely előtt a résztvevők még lemondhatják a foglalásukat, de amin belül már nem lehetséges a lemondás.';
$string['setting:cancelrestriction_caption'] = 'Lemondási korlátozás';
$string['setting:defaultcancellationinstrmngr'] = 'A feletteseknek küldendő, alapértelmezett lemondási üzenet.';
$string['setting:defaultcancellationinstrmngr_caption'] = 'Lemondási üzenet (felettesek)';
$string['setting:defaultcancellationinstrmngrdefault'] = '*** Csak értesítés ***

Ez csak egy értesítés arról, hogy [vezeteknev] [keresztnev] foglalása törölve lett az alábbi kurzusnál, és Önt jelölte meg, mint felettesét.

*** [vezeteknev] [keresztnev] foglalásának lemondásának másolatát alább találja ****';
$string['setting:defaultcancellationmessage'] = 'A felhasználónak küldendő, alapértelmezett lemondási üzenet.';
$string['setting:defaultcancellationmessage_caption'] = 'Lemondási üzenet';
$string['setting:defaultcancellationmessagedefault'] = 'Ez egy értesítés arról, hogy az alábbi kurzushoz kapcsolódó foglalása törölve lett:

***FOGLALÁS TÖRÖLVE***

Résztvevő:   [vezeteknev] [keresztnev]
Kurzus:   [szemelyesalkalomneve]

Hossz:   [hossz]
Időpont(ok):
[mindenidopont]

Helység:   [session:location]
Helyszín:   [session:venue]
Helyiség:   [session:room]';
$string['setting:defaultcancellationsubject'] = 'A lemondási üzenetek alapértelmezett tárgya.';
$string['setting:defaultcancellationsubject_caption'] = 'Lemondási üzenet tárgya';
$string['setting:defaultcancellationsubjectdefault'] = 'Kurzusfoglalás lemondása';
$string['setting:defaultconfirmationinstrmngr'] = 'A feletteseknek küldendő, alapértelmezett megerősítő üzenet.';
$string['setting:defaultconfirmationinstrmngr_caption'] = 'Megerősítő üzenet (felettesek)';
$string['setting:defaultconfirmationinstrmngrdefault'] = '*** Csak értesítés ***

Ez csak egy értesítés arról, hogy [vezeteknev] [keresztnev] az alábbi kurzusnál időpontot foglalt és Önt jelölte meg, mint felettesét.

Amennyiben nem Ön a felettese és úgy véli, tévedésből kapta ezt az e-mailt, kérjük, lépjen kapcsolatba a portál kezelőivel! Amennyiben kételyei vannak a beosztottja részvételével kapcsolatban, kérjük, azt közvetlenül vele egyeztesse!

*** [vezeteknev] [keresztnev] foglalásának másolatát alább találja ****';
$string['setting:defaultconfirmationmessage'] = 'A felhasználóknak küldendő, alapértelmezett megerősítő üzenet.';
$string['setting:defaultconfirmationmessage_caption'] = 'Megerősítő üzenet';
$string['setting:defaultconfirmationmessagedefault'] = 'Ez egy megerősítés, hogy foglalása rögzítésre került az alábbi kurzusra:

Résztvevő: [vezeteknev] [keresztnev]
Kurzus: [szemelyesalkalomneve]
Részvételi díj: [dij]

Hossz: [hossz]
Dátum(ok):
[mindenidopont]

Helység: [session:location]
Helyszín: [session:venue]
Helyiség: [session:room]

***Kérjük, érkezzen a kurzus kezdete előtt tíz perccel!***

Foglalás átütemezése vagy lemondása
Az átütemezéshez előbb le kell mondania a jelenlegi foglalást, majd egy új alkalomra kell jelentkeznie. A lemondáshoz lépjen vissza a portálra, nyissa meg a kurzusoldalt, majd a foglalási adatok képernyőjén válassza a lemondás lehetőséget.

[részletek]

Emlékeztetőt fog kapni a kurzus előtt [reminderperiod] nappal.';
$string['setting:defaultconfirmationmessagedefault2'] = '<p><b>Köszönjük a jelentkezést!</b></p>';
$string['setting:defaultconfirmationsubject'] = 'Az alapértelmezett megerősítő üzenet tárgya.';
$string['setting:defaultconfirmationsubject_caption'] = 'Megerősítés tárgya';
$string['setting:defaultconfirmationsubjectdefault'] = 'Kurzusfoglalás adatai: [szemelyesalkalomneve], [kezdoidopont]-[zaroidopont], [alkalomidopont]';
$string['setting:defaultreminderinstrmngr'] = 'A feletteseknek küldendő, alapértelmezett emlékeztető üzenet.';
$string['setting:defaultreminderinstrmngr_caption'] = 'Emlékeztető üzenet (felettesek)';
$string['setting:defaultreminderinstrmngrdefault'] = '*** Csak emlékeztető ****

Az Ön munkatársa, [vezeteknev] [keresztnev], foglalást adott le a fenti kurzusra. Ezt az emlékeztető e-mailt ő is megkapta.

Ha Ön nem a felettese, és úgy véli, hogy tévedésből kapta ezt az üzenetet, kérjük, lépjen kapcsolatba a portál kezelőivel!

*** [vezeteknev] [keresztnev] emlékeztető e-mailjének másolatát alább találja ****';
$string['setting:defaultremindermessage'] = 'A felhasználóknak küldendő, alapértelmezett emlékeztető üzenet.';
$string['setting:defaultremindermessage_caption'] = 'Emlékeztető üzenet';
$string['setting:defaultremindermessagedefault'] = 'Ez egy emlékeztető, hogy foglalása van az alábbi kurzusra:

Résztvevő: [vezeteknev] [keresztnev]
Kurzus: [szemelyesalkalomneve]
Részvételi díj: [dij]

Hossz: [hossz]
Dátum(ok):
[mindenidopont]

Helység: [session:location]
Helszín: [session:venue]
Helyiség: [session:room]

***Kérjük, érkezzen a kurzus kezdete előtt tíz perccel***

Foglalás átütemezése vagy lemondása
Az átütemezéshez először le kell mondania ezt a foglalást, majd új alkalomra kell újból foglalnia. A lemondáshoz lépjen vissza a webhelyre, nyissa meg a kurzusoldalt, majd a foglalási adatok képernyőjén válassza a lemondás lehetőséget.

[reszletek]';
$string['setting:defaultremindersubject'] = 'Az emlékeztető üzenetek alapértelmezett tárgya.';
$string['setting:defaultremindersubject_caption'] = 'Emlékeztető tárgya';
$string['setting:defaultremindersubjectdefault'] = 'Kurzusfoglalás emlékeztető: [szemelyesalkalomneve], [kezdoidopont]-[zaroidopont], [alkalomidopont]';
$string['setting:defaultrequestinstrmngrdefault'] = 'Ez egy értesítés, hogy [vezeteknev] [keresztnev] foglalást kérvényezett az alábbi kurzusra, és a rendszerben Ön szerepel a feletteseként.

Kurzus:   [szemelyesalkalomneve]
Részvételi díj:   [dij]

Hossz:   [hossz]
Dátum(ok):
[mindenidopont]

Helység:   [session:location]
Helyszín:   [session:venue]
Helyiség:   [session:room]

Kérjük, az alábbi hivatkozáson keresztül hagyja jóvá a jelentkezést:
[resztvevokhivatkozas]#unapproved

*** [vezeteknev] [keresztnev] foglalásának másolatát alább találja ****';
$string['setting:defaultrequestmessagedefault'] = 'Az alábbi kurzusra vonatkozó foglalási kérelme elküldésre került felettesének:

Résztvevő:   [keresztnev] [vezeteknev]
Kurzus:   [szemelyesalkalomneve]
Részvételi díj:   [dij]

Hossz:   [hossz]
Dátum(ok):
[mindenidopont]

Helység:   [session:location]
Helyszín:   [session:venue]
Helyiség:   [session:room]';
$string['setting:defaultrequestsubjectdefault'] = 'Kurzusfoglalás kérelem: [szemelyesalkalomneve], [kezdoidopont]-[zaroidopont]';
$string['setting:defaultvalue'] = 'Alapértelmezett érték';
$string['setting:defaultwaitlistedmessage'] = 'A felhasználónak küldendő, várólistás üzenet.';
$string['setting:defaultwaitlistedmessage_caption'] = 'Várólistás üzenet';
$string['setting:defaultwaitlistedmessagedefault'] = 'Ez egy értesítés, hogy az alábbi kurzusnál várólistára került:

Kurzus:   [szemelyesalkalomneve]
Helység:   [session:location]
Résztvevő:    [vezeteknev] [keresztnev]

***Kérjük, vegye figyelembe, hogy ez nem a kurzusfoglalás visszaigazolása!***

A várólistára kerüléssel jelezte érdeklődését a kurzus iránt, és közvetlenül értesítést fog kapni, amint új alkalom válik elérhetővé.

Ha el szeretné távolítani magát a várólistáról, lépjen vissza a kurzushoz, és kattintson a „Foglalás lemondása” lehetőségre.
Kérjük, vegye figyelembe, hogy a várólistáról való eltávolításról nem küld a rendszer külön megerősítő e-mailt.';
$string['setting:defaultwaitlistedsubject'] = 'A várólistás üzenetek alapértelmezett tárgya.';
$string['setting:defaultwaitlistedsubject_caption'] = 'Várólistás tárgy';
$string['setting:defaultwaitlistedsubjectdefault'] = '[szemelyesalkalomneve] várólistás értesítése';
$string['setting:disableicalcancel'] = 'iCalendar mellékletes lemondási üzenetek kikapcsolása.';
$string['setting:disableicalcancel_caption'] = 'iCalendar lemondások kikapcsolása:';
$string['setting:enableapprovals'] = 'Kikapcsolása esetén nem lehetséges a tevékenységek beállításainál a megerősítések adása.';
$string['setting:enableapprovals_caption'] = 'Felettesi jóváhagyások bekapcsolása:';
$string['setting:fromaddress'] = 'A modul által küldött emlékeztető e-mailek Feladó mezőjében megjelenő érték.';
$string['setting:fromaddress_caption'] = 'Küldő címe:';
$string['setting:fromaddressdefault'] = 'moodle@example.com';
$string['setting:hidecost'] = 'Részvételi díj és kuponkód mezők elrejtése';
$string['setting:hidecost_caption'] = 'Részvételi díj és kuponkód elrejtése:';
$string['setting:hidediscount'] = 'Csak a kuponkód mező elrejtése.';
$string['setting:hidediscount_caption'] = 'Kuponkód elrejtése:';
$string['setting:isfilter'] = 'Megjelenítés szűrőként';
$string['setting:limit_candidates'] = 'Jelöltek korlátozása a kurzusba beiratkozott felhasználókra';
$string['setting:limit_candidates_caption'] = 'Jelöltek korlátozása';
$string['setting:manageraddressformat'] = 'Az e-mail címben kötelezően szereplő utótag, amelynek megléte szükséges az e-mail cím érvényességéhez.';
$string['setting:manageraddressformat_caption'] = 'Kötelező utótag:';
$string['setting:manageraddressformatreadable'] = 'A felettesek e-mail címére vonatkozó korlátozás rövid leírása. Ennek a beállításnak nincs hatása, ha az előző nincs beállítva.';
$string['setting:manageraddressformatreadable_caption'] = 'Minta formátum:';
$string['setting:manageraddressformatreadabledefault'] = 'keresztnev.vezeteknev@cegneve.hu';
$string['setting:oneemailperday'] = 'Több megerősítő e-mail küldése a többnapos események esetén.';
$string['setting:oneemailperday_caption'] = 'Naponként egy üzenet:';
$string['setting:possiblevalues'] = 'Lehetséges értékek listája';
$string['setting:sessioncompletiondate'] = 'Bekapcsolása esetén az alkalom záró időpontja lesz a teljesítés ideje a jelenlétek naplózásakor.';
$string['setting:sessioncompletiondate_caption'] = 'Az alkalom záróideje legyen a teljesítés ideje:';
$string['setting:sessionroles'] = 'A kurzusban a kiválasztott szerepekkel bíró felhasználók nyomon követése lehetséges a Személyes alkalom tevékenységeknél';
$string['setting:sessionroles_caption'] = 'Alkalom szerepei:';
$string['setting:showinsummary'] = 'Megjelenítés az exportálásnál';
$string['setting:type'] = 'Mezőtípus';
$string['setting:visiblefield'] = 'A mező megjelenítése egy további oszlopként az alkalmak listanézeténél.';
$string['setting:visiblefield_caption'] = 'A kurzusoldalon látható mező';
$string['shortname'] = '#Rövid név';
$string['shortname_help'] = 'A **Rövid név** az alkalom azon rövid leírása ami a képzési naptárban a **Mutatás a naptárban** bekapcsolása esetén megjelenik';
$string['showbylocation'] = 'Mutatás helyszín szerint';
$string['showoncalendar'] = 'Naptármegjelenés beállításai';
$string['showoncalendar_help'] = '**Portál**-t választva a tevékenység minden alkalma globális eseményként jelenik meg a portál Naptárában. Ezeket az alkalmakat a portál minden felhasználója láthatja.

**Kurzus**-t választva a tevékenység minden alkalma megjelenik a kurzusnaptárban, valamint kurzuseseményként a portál Naptárában is, és minden kurzusra beiratkozott felhasználó számára látható lesz.

**Nincs**-t  választva a tevékenység alkalmai csak a sikeresen foglaló résztvevők személyes naptárában jelennek meg, feltéve, hogy a **Megjelenítés a felhasználó naptárában** be van kapcsolva.';
$string['sign-ups'] = 'Jelentkezések';
$string['signup'] = 'Jelentkezés';
$string['signupfor'] = 'Jelentkezés erre: {$a}';
$string['signupforsession'] = 'Jelentkezés egy elérhető, jövőbeli alkalomra';
$string['signupforthissession'] = 'Jelentkezés erre a személyes alkalomra';
$string['signups'] = 'Jelentkezések';
$string['signuptype'] = 'Jelentkezés típusa';
$string['signuptype_help'] = '„Egyetlen”-re állítva a tanuló a csak egyetlen alkalomra jelentkezhet az adott Személyes alkalom tevékenységnél. „Többszörös” esetén a tevékenységen belül több alkalomra is jelentkezhet.';
$string['signuptypemismatch'] = 'A jelentkezési típusnak „Többszörös”-nek kell lennie, ha a jelentkezési mód tevékenységenkénti';
$string['single'] = 'Egyetlen';
$string['sitenoticesheading'] = 'Portálértesítések';
$string['status'] = 'Állapot';
$string['status_approved'] = 'Jóváhagyva';
$string['status_booked'] = 'Foglalva';
$string['status_declined'] = 'Lemondva';
$string['status_fully_attended'] = 'Végig jelen volt';
$string['status_no_show'] = 'Nem jelent meg';
$string['status_partially_attended'] = 'Részleges részvétel';
$string['status_requested'] = 'Kérelmezve';
$string['status_session_cancelled'] = 'Alkalom lemondva';
$string['status_user_cancelled'] = 'A felhasználó lemondta';
$string['status_waitlisted'] = 'Várólistás';
$string['subject'] = 'Változás {$a->coursename} ({$a->duedate}) kurzus foglalásainál';
$string['submissions'] = 'Leadások';
$string['submit'] = 'Leadás';
$string['submitted'] = 'Leadva';
$string['summary'] = 'Összefoglalás';
$string['suppressemail'] = 'E-mail értesítés némítása';
$string['takeattendance'] = 'Jelenlét naplózása';
$string['thirdpartyemailaddress'] = 'További értesítési e-mail cím(ek)';
$string['thirdpartyemailaddress_help'] = 'A **További értesítési e-mail cím(ek)** egy választható mező harmadik fél típusú e-mail címek megadására (például egy külső oktatóé), aki szintén értesítést kap egy-egy felhasználó jelentkezésekor.
**Több e-mail-cím** megadása esetén az egyes címeket vesszővel válassza el. Például: bela@minta.hu, eva@minta.hu';
$string['thirdpartywaitlist'] = 'További értesítések küldése várólistás alkalmakról';
$string['thirdpartywaitlist_help'] = 'A **További értesítések küldése várólistás alkalmakról** bekapcsolása esetén a rendszer értesítés küld a megadott további értesítési cím(ek)re egy-egy tanuló várólistás alkalomra jelentkezéséről.

Kikapcsolása esetén csak akkor kap(nak) értesítést, amikor egy felhasználó egy ütemezett alkalomra jelentkezik vagy azt lemondja.';
$string['time'] = 'Idő';
$string['timecancelled'] = 'Lemondás ideje';
$string['timedue'] = 'Jelentkezési határidő';
$string['timefinish'] = 'Záró időpont';
$string['timefinish_help'] = 'A záró időpont az alkalom befejezésének ideje.';
$string['timerequested'] = 'Kérelmezés ideje';
$string['timesignedup'] = 'Jelentkezés ideje';
$string['timestart'] = 'Kezdő időpont';
$string['timestart_help'] = 'A kezdő időpont az alkalom megkezdésének ideje.';
$string['unapprovedrequests'] = 'Kérelmek jóváhagyás nélkül';
$string['unknowndate'] = '(ismeretlen időpont)';
$string['unknowntime'] = '(ismeretlen idő)';
$string['upcomingsessions'] = 'Jövőbeli alkalmak';
$string['upcomingsessionslist'] = 'Ezen Személyes alkalom tevékenység összes jövőbeli alkalmának listája';
$string['updaterequests'] = 'Kérelmek frissítése';
$string['upgradeinfofacetoface'] = '{$a}: Személyes jelenlét frissítési információ';
$string['upgradeprocessinggrades'] = 'Személyes alkalom eredmények feldolgozása, ha sok alkalom van, ez eltarthat egy darabig...';
$string['uploadbookings'] = 'Foglalások feltöltése';
$string['usercalentry'] = 'Bejegyzés mutatása a felhasználó naptárában';
$string['usercalentry_help'] = 'Bekapcsolása esetén a résztvevő naptárában létrejön egy felhasználói esemény bejegyzés az alkalomról. Kikapcsolása esetén elkerülhető az esemény többszörös megjelenítése a résztvevőnaptárában, ha a naptármegjelenési beállításoknál a Kurzus vagy Portál lett kiválasztva.';
$string['usercancelledon'] = 'Felhasználó lemondta ezt: {$a}';
$string['userdeletedcancel'] = 'Felhasználó törölve';
$string['usernotsignedup'] = 'Állapot: nem jelentkezett';
$string['usersignedup'] = 'Állapot: jelentkezett';
$string['usersignedupon'] = 'Felhasználó jelentkezett ide: {$a}';
$string['userwillbewaitlisted'] = 'Az alkalmon jelenleg nincs több hely. A "Jelentkezés" gomb megnyomásával az alkalom várólistájára fog kerülni.';
$string['validation:needatleastonedate'] = 'Legalább egy időpont megadása kötelező vagy az alkalom megjelölése várólistásként.';
$string['venue'] = 'Helyszín';
$string['venue_help'] = 'A **Helyszín** megadja azt az épületet, ahol az alkalomra sor fog kerülni.

A **Helyszín** megjelenik a „Jelentkezés” oldalon, a „Minden alkalom megtekintése” oldalon és az e-mail értesítésekben.';
$string['viewallsessions'] = 'Minden alkalom megtekintése';
$string['viewsubmissions'] = 'Leadások megtekintése';
$string['wait-list'] = 'Várolista';
$string['wait-listed'] = 'Várolistás';
$string['waitlistedmessage'] = 'Várólistás üzenet';
$string['waitlistedmessage_help'] = 'A felhasználók ezt az üzenet kapják, amikor jelentkeznek egy várólistás alkalomnál.';
$string['waitliststatus'] = 'A várólistában szerepel az alábbi alkalomnál';
$string['xhours'] = '{$a} órák';
$string['xminutes'] = '{$a} percek';
$string['youarebooked'] = 'Foglalása van az alábbi foglalásra';
$string['youremailaddress'] = 'Az ön e-mail címe';
