<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_usertours', language 'sr_lt', version '4.4'.
 *
 * @package     tool_usertours
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['above'] = 'Iznad';
$string['actions'] = 'Akcije';
$string['appliesto'] = 'Odnosi se na';
$string['backdrop'] = 'Prikaži sa zasenčenom pozadinom';
$string['backdrop_help'] = 'Možete da koristite zasenčenu pozadinu kako biste istakli deo stranice na koji ukazujete.

Napomena! Zasenčene pozadine nisu kompatibilne sa pojedinim delovima stranice kao što je navigaciona traka.';
$string['below'] = 'Ispod';
$string['block'] = 'Blok';
$string['block_named'] = 'Blok pod nazivom \'{$a}\'';
$string['cachedef_stepdata'] = 'Spisak koraka korisničkog vodiča';
$string['cachedef_tourdata'] = '
Spisak omogućenih informacija korisničkih vodiča koji se učitava na svakoj stranici.';
$string['confirmstepremovalquestion'] = 'Da li ste sigurni da želite da uklonite ovaj korak?';
$string['confirmstepremovaltitle'] = 'Potvrdite uklanjanje koraka';
$string['confirmtourremovalquestion'] = 'Da li ste sigurni da želite da uklonite ovaj vodič?';
$string['confirmtourremovaltitle'] = 'Potvrdi uklanjanje vodiča';
$string['content'] = 'Sadržaj';
$string['content_heading'] = 'Sadržaj';
$string['content_help'] = 'Sadržaj koji opisuje korak može biti dodat kao običan tekst, ograđen višejezičkim oznakama (u situaciji kada se koristi filter za višejezički sadržaj) ako je to potrebno.';
$string['content_type'] = 'Tip sadržaja';
$string['content_type_help'] = '* Uputstvo - sadržaj se unosi pomoću editora teksta
* ID oznaka jezičkog stringa - u formatu identifier,component (identifikator stringa, komponenta), bez razmaka nakon zareza';
$string['content_type_langstring'] = 'ID oznaka jezičkog stringa';
$string['content_type_manual'] = 'Uputstvo';
$string['cssselector'] = 'CSS selektor';
$string['defaultvalue'] = 'Podrazumevano ({$a})';
$string['delay'] = 'Kašnjenje pre prikazivanja koraka';
$string['delay_help'] = 'Možete opciono izabrati da dodate kašnjenje pre nego što korak bude prikazan.

Ovo kašnjenje je u milisekundama.';
$string['description'] = 'Opis';
$string['description_help'] = 'Opis vodiča može biti dodat kao običan tekst, ograđen višejezičkim oznakama (u situaciji kada se koristi filter za višejezički sadržaj) ako je to potrebno.

Alternativno, može se uneti ID oznaka jezičkog stringa u formatu identifier,component (identifikator stringa,komponenta), bez uglastih zagrada ili razmaka nakon zareza.';
$string['displaystepnumbers'] = 'Prikaži brojeve koraka';
$string['displaystepnumbers_help'] = 'Da li da se prikaže broj koraka, npr. 1/4, 2/4 itd. za označavanje dužine korisničkog vodiča.';
$string['done'] = 'Gotovo';
$string['duplicatetour'] = 'Kreiraj duplikat vodiča';
$string['duplicatetour_name'] = '{$a} (kopija)';
$string['editstep'] = 'Uređivanje "{$a}"';
$string['enabled'] = 'Omogućeno';
$string['endonesteptour'] = 'Razumeo sam';
$string['endtour'] = 'Kraj vodiča';
$string['endtourlabel'] = 'Natpis na dugmetu za kraj vodiča';
$string['endtourlabel_help'] = 'Opciono možete da navedete prilagođeni natpis na dugmetu za kraj vodiča. Standardni natpis je \'Razumeo sam\' za jednostavne vodiče (u jednom koraku) i \'Kraj vodiča\' za vodiče u više koraka.

Alternativno, može se uneti ID oznaka jezičkog stringa u formatu identifier,component (identifikator stringa,komponenta) bez uglastih zagrada ili razmaka nakon zareza.';
$string['event_step_shown'] = 'Korak prikazan';
$string['event_tour_ended'] = 'Vodič završen';
$string['event_tour_reset'] = 'Vodič resetovan';
$string['event_tour_started'] = 'Vodič započet';
$string['exporttour'] = 'Izvezi vodič';
$string['filter_accessdate'] = 'Datum pristupa';
$string['filter_accessdate_enabled'] = 'Omogući filter za datum pristupa';
$string['filter_accessdate_enabled_help'] = 'Pokažite vodič samo novim korisnicima ili onim korisnicima koji su tek nedavno pristupili sajtu.';
$string['filter_category'] = 'Kategorija';
$string['filter_category_help'] = 'Prikažite korisnički vodič na stranici koja je povezana sa kursom u izabranoj kategoriji.';
$string['filter_course'] = 'Kursevi';
$string['filter_course_help'] = 'Prikažite korisnički vodič na stranici koja je povezana sa izabranim kursom.';
$string['filter_courseformat'] = 'Format kursa';
$string['filter_courseformat_help'] = 'Prikažite korisnički vodič na stranici koja je povezana sa kursom koji koristi izabrani format kursa.';
$string['filter_cssselector'] = 'CSS selector';
$string['filter_cssselector_help'] = 'Prikažite korisnički vodič samo kada se na stranici nalazi navedeni CSS selektor.';
$string['filter_date_account_creation'] = 'Datum kreiranja korisničkog naloga unutar';
$string['filter_date_first_login'] = 'Datum prvog pristupa korisnika unutar';
$string['filter_date_last_login'] = 'Datum poslednjeg pristupa korisnika unutar';
$string['filter_header'] = 'Filteri vodiča';
$string['filter_help'] = 'Izaberete uslove pod kojima će vodič biti prikazan. Svi filteri moraju da se poklapaju kako bi vodič bio prikazan korisniku.';
$string['filter_role'] = 'Uloga';
$string['filter_role_help'] = 'Vodič može da se ograniči samo na korisnike sa izabranim ulogama, u kontekstu u kojem se vodič prikazuje. Na primer, ograničenje vodiča za \'Kontrolni panel\' samo za korisnike sa ulogom polaznika, neće funkcionisati ako korisnici imaju ulogu polaznika na kursu (što je generalno slučaj). Vodič \'Kontrolni panel\' može se ograničiti samo za korisnike sa sistemskom ulogom.';
$string['filter_theme'] = 'Tema';
$string['filter_theme_help'] = 'Prikazuje vodič kada korisnik koristi jednu od izabranih tema.';
$string['importtour'] = 'Uvezi vodič';
$string['invalid_lang_id'] = 'Neispravna ID oznaka jezičkog stringa';
$string['left'] = 'Levo';
$string['modifyshippedtourwarning'] = 'Ovo je korisnički vodič koji se isporučuje zajedno sa osnovnom instalacijom Moodlea. Sve promene koje unesete biće poništene prilikom sledeće nadogradnje sajta.';
$string['moodle_language_identifier'] = 'ID oznaka jezičkog stringa';
$string['movestepdown'] = 'Premesti korak nadole';
$string['movestepup'] = 'Premesti korak nagore';
$string['movetourdown'] = 'Premesti vodič nadole';
$string['movetourup'] = 'Premesti vodič nagore';
$string['name'] = 'Naziv';
$string['name_help'] = 'Naziv vodiča može biti dodat kao običan tekst, ograđen višejezičkim oznakama (u situaciji kada se koristi filter za višejezički sadržaj) ako je to potrebno.

Alternativno, može se uneti ID oznaka jezičkog stringa u formatu identifier,component (identifikator stringa,komponenta) bez uglastih zagrada ili razmaka nakon zareza.';
$string['newstep'] = 'Novi korak';
$string['newtour'] = 'Kreiraj novi vodič';
$string['next'] = 'Sledeće';
$string['nextstep'] = 'Sledeći';
$string['nextstep_sequence'] = 'Sledeće ({$a->position}/{$a->total})';
$string['options_heading'] = 'Opcije';
$string['orphan'] = 'Prikaži ako odredište nije pronađeno';
$string['orphan_help'] = 'Prikazuje korak ako odredište nije moglo biti pronađeno na stranici.';
$string['pathmatch'] = 'URL stranice na koju se odnosi vodič';
$string['pathmatch_help'] = 'Vodič će biti prikazan na svakoj stranici čija URL adresa odgovara ovoj vrednosti.

Možete koristiti znak % kao džoker znak. Neki od primera vrednosti su:

* /my/% - odgovara Kontrolnom panelu
* /course/view.php?id=2 - odgovara određenom kursu
* /mod/forum/view.php% - odgovara spisku diskusija na forumu
* /user/profile.php% - odgovara stranici korisničkog profila

Ako želite da prikažete vodič na naslovnoj stranici sajta možete da koristite vrednost: "FRONTPAGE".';
$string['pausetour'] = 'Pauza';
$string['placement'] = 'Pozicija koraka';
$string['placement_help'] = 'Korak može da se postavi iznad, ispod, levo ili desno od odredišta. Preporučuju se opcije su \'iznad\' ili \'ispod\', pošto su bolje prilagođene za prikaz koraka na mobilnim uređajima.

Ako se korak ne uklapa u određenu stranicu, na navedenom mestu, automatski će biti postavljen na neko drugo mesto.';
$string['pluginname'] = 'Korisnički vodiči';
$string['privacy:metadata:preference:completed'] = 'Vreme kada je korisnik poslednji put završio korisnički vodič.';
$string['privacy:metadata:preference:requested'] = 'Vreme kada je korisnik poslednji put ručno zatražio korisnički vodič.';
$string['privacy:request:preference:completed'] = 'Poslednji put ste označili korisničku turu  "{$a->name}" kao završenu {$a->time}';
$string['privacy:request:preference:requested'] = 'Poslednji put ste zatražili korisničku turu  "{$a->name}" {$a->time}';
$string['reflex'] = 'Nastavi na klik';
$string['reflex_help'] = 'Pređite na sledeći korak kada se klikne na odredište.';
$string['resettouronpage'] = 'Resetujte korisnički vodič na ovoj stranici';
$string['resumetour'] = 'Nastavi';
$string['right'] = 'Desno';
$string['select_block'] = 'Izaberi blok';
$string['selector_defaulttitle'] = 'Unesite deskriptivni naslov';
$string['selectordisplayname'] = 'CSS selektor koji se poklapa sa \'{$a}\'';
$string['selecttype'] = 'Izaberi tip koraka';
$string['sharedtourslink'] = 'Repozitorijum vodiča';
$string['showtoureachtime'] = 'svaki put kada se podudara sa filterom';
$string['showtouruntilcomplete'] = 'dok se ne zatvori';
$string['showtourwhen'] = 'Prikaži vodič';
$string['skip'] = 'Preskoči';
$string['skip_tour'] = 'Preskoči vodič';
$string['target'] = 'Odredište';
$string['target_block'] = 'Blok';
$string['target_heading'] = 'Odredište koraka';
$string['target_selector'] = 'Selektor';
$string['target_selector_targetvalue'] = 'CSS selektori';
$string['target_selector_targetvalue_help'] = 'CSS selektor može da se koriste kako biste izabrali skoro bilo koji element na stranici. Odgovarajući selektor se može lako naći pomoću razvojnih alata za vaš veb čitač.

Mozilla pruža [vrlo dobru
dokumentaciju](https://developer.mozilla.org/en/docs/Web/Guide/CSS/Getting_started/Selectors)
za selektore koja vam može pomoći da kreirate svoje selektore.

Takođe, možete naći razvojne alate za svoj veb čitač koji mogu da budu veoma korisni u kreiranju ovih selektora:

* [Google Chrome](https://developer.chrome.com/devtools#dom-and-styles)
* [Mozilla Firefox](https://developer.mozilla.org/en-US/docs/Tools/DOM_Property_Viewer)
* [Microsoft Edge](https://developer.microsoft.com/en-us/microsoft-edge/platform/documentation/f12-devtools-guide/)
* [Apple Safari](https://developer.apple.com/library/iad/documentation/AppleApplications/Conceptual/Safari_Developer_Guide/ResourcesandtheDOM/ResourcesandtheDOM.html#//apple_ref/doc/uid/TP40007874-CH3-SW1)';
$string['target_unattached'] = 'Prikaži na sredini stranice';
$string['targettype'] = 'Tip odredišta';
$string['targettype_help'] = 'Svaki korak je povezan sa delom stranice - odredištem. Postoji nekoliko tipova odredišta (delova stranice):

* Blok - za prikazivanje koraka koji objašnjava funkciju datog bloka
* CSS selektor - za precizno definisanje odredišta unutar stranice pomoću CSS-a
* Prikaz na sredini stranice - za korak koji ne traži da bude povezan sa određenim delom stranice';
$string['title'] = 'Naslov';
$string['title_help'] = 'Naslov korak može biti dodat kao običan tekst, ograđen višejezičkim oznakama (u situaciji kada se koristi filter za višejezički sadržaj) ako je to potrebno.

Alternativno, može se uneti ID oznaka jezičkog stringa u formatu identifier,component (identifikator stringa,komponenta) bez uglastih zagrada ili razmaka nakon zareza.';
$string['tour1_content_addingblocks'] = 'Zapravo, razmislite dobro hoćete li na svojim stranicama uključiti bilo koji blok. Blokovi se ne prikazuju unutar Moodle aplikacije, tako da je, generalno, mnogo bolje da proverite da li vaš sajt dobro funkcioniše bez ikakvih blokova.';
$string['tour1_content_blockregion'] = 'Ovde još uvek postoji region blokova. Preporučujemo da potpuno uklonite blokove \'Navigacija\' i \'Administracija\' pošto sve funkcionalnosti ovih blokova već postoje na drugim mestima u temi Boost.';
$string['tour1_content_customisation'] = 'Da biste prilagodili izgled svog sajta i naslovne stranice, koristite meni za podešavanja u uglu ovog zaglavlja. Pokušajte sada da uključite uređivanje.';
$string['tour1_content_end'] = 'Ovo je kraj vašeg korisničkog vodiča. Vodič neće biti ponovo prikazan, osim ako ga ne resetujete pomoću linka u podnožju. Kao administrator možete, takođe, da kreirate svoje vodiče poput ovog!';
$string['tour1_content_navigation'] = 'Glavni način navigacija je sada uz pomoć ove navigacione fioke. Sadržaj navigacione fioke se ažurira zavisno od toga gde se nalazite na sajtu. Koristite dugme na vrhu kako biste je sakrili ili prikazali.';
$string['tour1_content_welcome'] = 'Dobro došli u Boost temu. Ako ste prešli sa neke od starijih verzija Moodlea, primetićete da neke stvari izgledaju malo drugačije sa ovom temom.';
$string['tour1_title_addingblocks'] = 'Dodavanje blokova';
$string['tour1_title_blockregion'] = 'Region blokova';
$string['tour1_title_customisation'] = 'Prilagođavanje';
$string['tour1_title_end'] = 'Kraj vodiča';
$string['tour1_title_navigation'] = 'Navigacija';
$string['tour1_title_welcome'] = 'Dobro došli';
$string['tour2_content_addblock'] = 'Ako uključite režim uređivanja blokove možete dodati iz navigacione fioke. Ipak, razmislite dobro hoćete li na stranicama svog kursa uključiti bilo koji blok. Blokovi se ne prikazuju unutar Moodle aplikacije, tako da je, imajući u vidu najbolji korisnički doživljaj, bolje da proverite da li vaš kurs dobro funkcioniše bez ikakvih blokova.';
$string['tour2_content_addingblocks'] = 'Pomoću ovog dugmeta možete da dodate blokove na ovu stranicu. Ipak, razmislite dobro hoćete li na stranicama svog kursa uključiti bilo koji blok. Blokovi se ne prikazuju unutar Moodle aplikacije, tako da je, imajući u vidu najbolji korisnički doživljaj, bolje da proverite da li vaš kurs dobro funkcioniše bez ikakvih blokova.';
$string['tour2_content_customisation'] = 'Da biste promenili podešavanje kursa, koristite meni za podešavanja u uglu ovog zaglavlja. Sličan meni za podešavanja naći ćete, takođe, na početnoj stranici svake aktivnosti. Pokušajte sada da uključite uređivanje.';
$string['tour2_content_end'] = 'Ovo je kraj vašeg korisničkog vodiča. Vodič neće biti ponovo prikazan, osim ako ga ne resetujete pomoću linka u podnožju. Administrator sajta može, takođe, da kreira dodatne vodiče za ovaj sajt, ukoliko je to potrebno.';
$string['tour2_content_navigation'] = 'Navigacija se sada odvija uz pomoć ove navigacione fioke. Koristite dugme na vrhu kako biste je sakrili ili prikazali. Videćete da postoje linkovi za sekcije vašeg kursa.';
$string['tour2_content_opendrawer'] = 'Pokušajte da otvorite navigacionu fioku sada.';
$string['tour2_content_participants'] = 'Pogledajte ovde ko su učesnici kursa. Ovo je, takođe, mesto gde možete da dodate ili uklonite polaznike.';
$string['tour2_content_welcome'] = 'Dobro došli u Boost temu. Ako ste prešli sa neke od starijih verzija Moodlea, primetićete da stvari izgledaju malo drugačije ovde na stranici kursa.';
$string['tour2_title_addblock'] = 'Dodaj blok';
$string['tour2_title_addingblocks'] = 'Dodavanje blokova';
$string['tour2_title_customisation'] = 'Prilagođavanje';
$string['tour2_title_end'] = 'Kraj vodiča';
$string['tour2_title_navigation'] = 'Navigacija';
$string['tour2_title_opendrawer'] = 'Otvori navigacionu fioku';
$string['tour2_title_participants'] = 'Učesnici kursa';
$string['tour2_title_welcome'] = 'Dobro došli';
$string['tour3_content_dashboard'] = 'Vaš novi Kontrolni panel ima mnoge funkcije koje će vam pomoći da lakše pristupite informacijama koje su vam najvažnije.';
$string['tour3_content_displayoptions'] = 'Kursevi se mogu sortirati prema nazivu kursa, skraćenom nazivu kursa ili datumu poslednjeg pristupa.

Možete, takođe, izabrati kako da prikažete sve kurseve - kao običan spisak, u formi spiska sa sažetim informacijama ili kao \'kartice\' što je i podrazumevani način prikaza.';
$string['tour3_content_overview'] = 'Blok \'Pregled kurseva\' prikazuje sve kurseva na koje ste upisani.

Možete izabrati da prikažete kurseve koji su trenutno u toku, prošle ili buduće, ili kurseve koje ste označili zvezdicom.';
$string['tour3_content_recentcourses'] = 'Blok \'Skorašnji kursevi\' prikazuje kurseve koje ste poslednje posetili, omogućavajući vam da odmah odete na njih.';
$string['tour3_content_starring'] = 'Možete izabrati da označite zvezdicom kurs kako biste ga istakli ili da sakrijete kurs koji vam više nije važan.

Ovo utiče samo na vaš prikaz kurseva.

Kursevi se mogu sortirati po nazivu kursa ili prema datumu poslednjeg pristupa.

Možete, takođe, izabrati kako da u bloku prikažete sve kurseve - kao običan spisak, u formi spiska sa sažetim informacijama ili kao \'kartice\' što je i podrazumevani način prikaz.';
$string['tour3_content_timeline'] = 'Blok \'Hronologija\' prikazuje važne predstojeće događaje.

Možete izabrati da prikažete aktivnosti u narednoj sedmici, mesecu ili dalje u budućnosti.

Takođe možete prikazati stavke čiji je rok za završetak istekao.';
$string['tour3_title_dashboard'] = 'Vaš kontrolni panel';
$string['tour3_title_displayoptions'] = 'Opcije prikaza';
$string['tour3_title_overview'] = 'Pregled kurseva';
$string['tour3_title_recentcourses'] = 'Skorašnji kursevi';
$string['tour3_title_starring'] = 'Skriveni i kursevi sa zvezdicima';
$string['tour3_title_timeline'] = 'Blok \'Hronologija\'';
$string['tour4_content_groupconvo'] = 'Ako ste član grupe, a grupno slanje poruka je omogućeno, ovde ćete videti prepiske unutar grupe.

Prepiske unutar grupa na kursu pružaju vam mogućnost da sa drugima članovima svoje grupe komunicirate na privatnom i pogodnom mestu.';
$string['tour4_content_icon'] = 'Svojim porukama možete pristupiti sa bilo koje stranice pomoću ove ikonice.

Ako imate nepročitane poruke, njihov broj će takođe ovde biti prikazan.

Kliknite na ikonicu kako biste otvorili fioku sa porukama i nastavili vodič.';
$string['tour4_content_messaging'] = 'Nove funkcije za slanje poruka uključuju mogućnost grupnog slanja poruka u okviru kursa i bolju kontrolu ko vam može slati poruke.';
$string['tour4_content_settings'] = 'Podešavanjima za slanje poruka možete pristupiti preko ikonice zupčanika. Novo podešavanje privatnosti dajem vam mogućnost da ograničite ko može da vam šalje poruke.';
$string['tour4_content_starred'] = 'Možete izabrati da označite određene prepiske kako biste ih lakše pronašli.';
$string['tour4_title_groupconvo'] = 'Grupne poruke';
$string['tour4_title_icon'] = 'Slanje poruka';
$string['tour4_title_messaging'] = 'Novi interfejs za slanje poruka';
$string['tour4_title_settings'] = 'Podešavanja za slanje poruka';
$string['tour4_title_starred'] = 'Označen zvezdicom';
$string['tour_activityinfo_activity_student_content'] = 'Datumi aktivnosti, kao i informacija o tome šta treba da uradite kako biste završili aktivnost prikazani su na stranici aktivnosti.';
$string['tour_activityinfo_activity_student_title'] = 'Novo: informacije o aktivnostima';
$string['tour_activityinfo_activity_teacher_content'] = 'Datumi i uslovi za završetak aktivnosti se sada prikazuju polaznicima na svakoj stranici aktivnosti (i opciono na stranici kursa).

Za aktivnosti koje zahtevaju od polaznika da ručno označe aktivnost kao završenu, prikazuje se dugme \'Označi kao završeno\'  na stranici aktivnosti.';
$string['tour_activityinfo_activity_teacher_title'] = 'Novo: informacije o aktivnostima';
$string['tour_activityinfo_course_student_content'] = 'Na stranici kursa prikazani su datumi aktivnosti i/ili šta treba uraditi da bi  se aktivnost završila.';
$string['tour_activityinfo_course_student_title'] = 'Novo: informacije o aktivnostima';
$string['tour_activityinfo_course_teacher_content'] = 'Nova podešavanja kursa \'Prikaži uslove za završetak\' i \'Prikaži datume aktivnosti\' omogućavaju vam da izaberete da li će uslovi za završetak aktivnosti (ako su postavljeni) i/ili datumi aktivnosti biti prikazani studentima na stranici kursa.';
$string['tour_activityinfo_course_teacher_title'] = 'Novo: informacije o aktivnostima';
$string['tour_final_step_content'] = 'Ovo je kraj vašeg korisničkog vodiča. Vodič neće biti ponovo prikazan, osim ako ga ne resetujete pomoću linka u podnožju.';
$string['tour_final_step_title'] = 'Kraj vodiča';
$string['tour_gradebook_action_content'] = '<div class="text-center">@@PIXICON::tour/tour_grader_report_action_menu::tool_usertours@@</div>Sortirajte kolone i izaberite one koje želite da prikažete. U režimu za uređivanje, koristite ovu prečicu kako biste pristupili čestim zadacima koji se odnose na pregled i uređivanje stavki ocena.';
$string['tour_gradebook_action_title'] = 'Brzi linkovi do akcija';
$string['tour_gradebook_filter_content'] = '<div class="text-center">@@PIXICON::tour/tour_grader_report_initials::tool_usertours@@</div>Filtrirajte polaznike prema inicijalima njihovog imena ili prezimena.';
$string['tour_gradebook_filter_title'] = 'Filtrirajte po imenu';
$string['tour_gradebook_search_content'] = '<div class="text-center">@@PIXICON::tour/tour_grader_report_search::tool_usertours@@</div>Upotrebite polje za pretragu kako biste brzo pronašli određenog polaznika.';
$string['tour_gradebook_search_title'] = 'Lako pronađite polaznike';
$string['tour_gradebook_tour_description'] = 'Funkcije pretrage i navigacije u izveštaju ocenjivača u knjizi ocena';
$string['tour_gradebook_tour_name'] = 'Izveštaj ocenjivača u knjizi ocena';
$string['tour_navigation_course_announcements_teacher_content'] = '@@PIXICON::tour/tour_course_admin_3::tool_usertours@@<br>Objavite važne vesti ovde.';
$string['tour_navigation_course_announcements_teacher_title'] = 'Želite svima nešto da  saopštite?';
$string['tour_navigation_course_edit_teacher_content'] = '@@PIXICON::tour/tour_course_admin_1::tool_usertours@@<br>Dodajte novi ili uredite postojeći sadržaj.';
$string['tour_navigation_course_edit_teacher_title'] = 'Aktivirajte režim uređivanja';
$string['tour_navigation_course_index_student_content'] = '@@PIXICON::tour/tour_course_student::tool_usertours@@<br>Pregledajte aktivnosti i pratite svoj napredak.';
$string['tour_navigation_course_index_student_title'] = 'Snađite se na kursu';
$string['tour_navigation_course_index_teacher_content'] = '@@PIXICON::tour/tour_course_admin_2::tool_usertours@@<br>Prevucite i spustite aktivnosti kako biste promenili redosled sadržaja na kursu.';
$string['tour_navigation_course_index_teacher_title'] = 'Indeks kursa';
$string['tour_navigation_course_student_tour_des'] = 'Gde da pregledate aktivnosti na kursu';
$string['tour_navigation_course_student_tour_name'] = 'Indeks kursa';
$string['tour_navigation_course_teacher_tour_des'] = 'Režim za uređivanje, prevlačenje i spuštanje aktivnosti i postavljanje najava na kursu';
$string['tour_navigation_course_teacher_tour_name'] = 'Uređivanje kursa';
$string['tour_navigation_dashboard_content'] = '@@PIXICON::tour/tour_dashboard::tool_usertours@@<br>Ovaj bočni panel može da sadrži više funkcija.';
$string['tour_navigation_dashboard_title'] = 'Proširite kako biste istražili';
$string['tour_navigation_dashboard_tour_des'] = 'Gde se mogu naći blokovi';
$string['tour_navigation_dashboard_tour_name'] = 'Fioka sa blokovima';
$string['tour_navigation_mycourses_content'] = '@@PIXICON::tour/tour_mycourses::tool_usertours@@<br>Dodajte, kopirajte, obrišite i sakrijte kurseve iz ovog menija.';
$string['tour_navigation_mycourses_endtourlabel'] = 'Razumem';
$string['tour_navigation_mycourses_title'] = 'Kursevi i kategorije';
$string['tour_navigation_mycourses_tour_des'] = 'Opcije za upravljanje kursevima na stranici Moji kursevi';
$string['tour_navigation_mycourses_tour_name'] = 'Upravljanje kursom';
$string['tour_resetforall'] = 'Status vodiča je resetovan. Vodič će biti ponovo prikazan svim korisnicima.';
$string['tourconfig'] = 'Konfiguraciona datoteka vodiča za uvoz';
$string['tourisenabled'] = 'Vodič je omogućen';
$string['tourlist_explanation'] = 'Možete da kreirate onoliko vodiča koliko želite i omogućiti ih za različite delove Moodlea. Za svaku stranicu može biti kreiran samo jedan vodič.';
$string['tours'] = 'Vodiči';
$string['usertours'] = 'Korisnički vodiči';
$string['usertours:managetours'] = 'Kreiranje, uređivanje i uklanjanje korisničkih vodiča';
$string['viewtour_edit'] = 'Možete da<a href="{$a->editlink}">uredite podrazumevana podešavanja vodiča</a> i da ga<a href="{$a->resetlink}">resetujete kako bi bio prikazan ponovo</a> svim korisnicima.';
$string['viewtour_info'] = 'Ovo je vodič \'{$a->tourname}\'. Vodič se odnosi na putanju \'{$a→path}\'.';
