<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'oublog', language 'sr_lt', version '4.4'.
 *
 * @package     oublog
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessdenied'] = 'Žao nam je: nemate pristup da biste videli ovu stranicu.';
$string['addcomment'] = 'Dodaj komentar';
$string['addlink'] = 'Dodaj link';
$string['addpost'] = 'Dodaj blog članak';
$string['allowcomments'] = 'Dozvoli komentare';
$string['allowcomments_help'] = '&lsquo;Da, od prijavljenog korisnika&rsquo; dozvoljava komentare korisnika koji imaju pristup blogu. &lsquo;Da, od svih&rsquo; dozvoljava komentare korisnika, kako prijavljenih tako i opšte publike. Dobijaćete e-poruku da biste odobrili ili odbili komentare korisnika koji nisu prijavljeni. &lsquo;Ne&rsquo; sprečava da bilo ko komentariše ovaj post.';
$string['allowcommentsmax'] = 'Dozvoli komentare (ako su izabrani za objavljivanje)';
$string['atom'] = 'Atom';
$string['atomfeed'] = 'Atom izvor vesti';
$string['attachments'] = 'Prilozi';
$string['attachments_help'] = 'Uz blog članak možete, opciono, da priložite jednu ili više datoteka. Ako prilažete sliku ona će biti prikazana na kraju poruke.';
$string['blogfeed'] = 'Blog izvori vesti';
$string['bloginfo'] = 'blog informacije';
$string['blogname'] = 'Naziv bloga';
$string['blogoptions'] = 'Opcije bloga';
$string['blogsummary'] = 'Rezime bloga';
$string['comment'] = 'Dodaj svoj komentar';
$string['commentonby'] = 'Komentar na  <u>{$a->title}</u> autora <u>{$a->author}</u>';
$string['comments'] = 'Komentari';
$string['commentsby'] = 'Komentari koje je napisao/la {$a}';
$string['commentsfeed'] = 'Samo komentari';
$string['commentsnotallowed'] = 'Komentari nisu dozvoljeni';
$string['completioncomments'] = 'Korisnik mora da dâ komentar na blog članke:';
$string['completioncommentsgroup'] = 'Zahteva komentare';
$string['completioncommentsgroup_help'] = 'Ako omogućite ovu opciju, blog će biti obeležen kao završen za studenta, onog trenutka kada on ostavi navedeni broj komentara.';
$string['completionposts'] = 'Korisnik mora da napiše blog članke:';
$string['completionpostsgroup'] = 'Zahteva blog članke';
$string['completionpostsgroup_help'] = 'Ako omogućite ovu opciju, blog će biti obeležen kao završen za studenta, onog trenutka kada on napiše navedeni broj blog članaka.';
$string['computingguide'] = 'Priručnik za OU blogove';
$string['computingguideurl'] = 'URL adresa priručnika';
$string['computingguideurlexplained'] = 'Unesite URL adresu priručnika za OU blogove';
$string['configmaxattachments'] = 'Podrazumevani maksimalni broj priloga dozvoljenih po jednom blogu članku';
$string['configmaxbytes'] = 'Podrazumevana maksimalna veličina za sve priloge blogu na sajtu (podložno ograničenjima kursa i ostalim lokalnim podešavanjima)';
$string['confirmdeletecomment'] = 'Da li ste sigurni da želite da obrišete ovaj komentar?';
$string['confirmdeletelink'] = 'Da li ste sigurni da želite da obrišete ovaj link?';
$string['confirmdeletepost'] = 'Da li ste sigurni da želite da obrišete ovaj blog članak?';
$string['couldnotaddcomment'] = 'Nije moguće dodati komentar';
$string['couldnotaddlink'] = 'Nije moguće dodati link';
$string['defaultpersonalblogname'] = 'Blog korisnika {$a}';
$string['delete'] = 'Obriši';
$string['deletedby'] = 'Obrisao/la {$a->fullname}, {$a->timedeleted}';
$string['deleteglobalblog'] = 'Ne možete da obrišete globalni blog';
$string['details'] = 'Detaljne informacije';
$string['displayversion'] = 'OU blog verzija: <strong>{$a}</strong>';
$string['downloadas'] = 'Preuzmi podatke kao';
$string['edit'] = 'Uredi';
$string['editlink'] = 'Uredi link';
$string['editonsummary'] = 'Izmenjeno {$a->editdate}';
$string['editpost'] = 'Ažuriraj blog članak';
$string['editsummary'] = 'Uredio/la {$a->editby}, {$a->editdate}';
$string['error_alreadyapproved'] = 'Komentar je već odobren ili odbijen';
$string['error_grouppubliccomments'] = 'Ne možete da dozvolite javne komentare kada je blog u grupnom modu';
$string['error_moderatednotallowed'] = 'Moderisani komentari nisu više dozvoljeni za ovaj blog ili blog članak';
$string['error_noconfirm'] = 'Unesite gornji podebljani tekst, tačno onako kako je dato, u ovo polje.';
$string['error_toomanycomments'] = 'Napravili ste previše komentara na blog u poslednjih sat vremena, sa ove internet adresi. Molimo sačekajte malo, a zatim pokušajte ponovo.';
$string['error_unspecified'] = 'Sistem ne može da završi ovaj zahtev zato što je došlo do ({$a})';
$string['error_wrongkey'] = 'Neispravan ključ komentara';
$string['exportedpost'] = 'Izvezeni blog članak';
$string['exportpostscomments'] = 'svi trenutno vidljivi članci i njihovi komentari';
$string['exportuntitledpost'] = 'Članak bez naslova';
$string['externaldashboardadd'] = 'Dodaj blog u kontrolni panel';
$string['externaldashboardremove'] = 'Ukloni blog iz kontrolnog panela';
$string['extranavolderposts'] = 'Stariji blog članci: {$a->from}-{$a->to}';
$string['extranavtag'] = 'Oznaka: {$a}';
$string['feedhelp'] = 'Izvori vesti';
$string['feedhelp_help'] = 'Ako koristite izvore vesti možete da dodate Atom ili RSS linkove kako biste bili u toku sa ovim blogom. Većina čitača izvora vesti podržava Atom ili RSS.

Ako blog dozvoljava komentare postoje izvori za &lsquo;Samo komentari&rsquo;.';
$string['feeds'] = 'Izvori vesti';
$string['feedsnotenabled'] = 'Izvori vesti nisu omogućeni';
$string['foruser'] = 'za {$a}';
$string['globalblogmissing'] = 'Globalni blog nedostaje';
$string['gradesupdated'] = 'Ocene su ažurirane';
$string['guestblog'] = 'Ako imate nalog na sistemu, molimo <a href=\'{$a}\'>prijavite se za puni pristup blogu</a>';
$string['individualblogs'] = 'Individualni blogovi';
$string['individualblogs_help'] = '<p><strong>Ne (blog zajedno ili u grupama)</strong>: <em>Individualni blogovi se ne koriste</em> &ndash; - ne postoje individualni blogovi, svako je deo šire zajednice (zavisno od podešavanja  \'Grupni režim\').</p>
<p><strong>Odvojeni individualni blogovi </strong>: <em>Individualni blogovi se koriste privatno</em> &ndash; individualni korisnici mogu da pišu i vice samo svoje blogove , osim ako nemaju ovlašćenje ("viewindividual") pa da mogu da vide individualne blogove drugih.</p> <p><strong> Vidljivi individualni blogovi </strong>: <em> Individualni blogovi se koriste  javno</em> &ndash; individualni korisnici mogu da pišu samo na svojim blogovima, ali mogu da vide individualne blogove drugih.</p>';
$string['invalidblog'] = 'Neispravan id bloga';
$string['invalidblogdetails'] = 'Ne mogu da se pronađu podaci za blog članak {$a}';
$string['invalidcomment'] = 'Neispravan Id komentara';
$string['invalidedit'] = 'Neispravan Id uređivanja';
$string['invalidformat'] = 'Format mora da bude Atom ili RSS';
$string['invalidlink'] = 'Neispravan Id linka';
$string['invalidpost'] = 'Neispravan Id blog članka';
$string['invalidpostid'] = 'Neispravan Postid';
$string['invalidvisbilitylevel'] = 'Neispravan nivo vidljivosti {$a}';
$string['invalidvisibility'] = 'Neispravan nivo vidljivosti';
$string['lastcomment'] = '(poslednji komentar napisao/la {$a->fullname}, {$a->timeposted})';
$string['links'] = 'Povezani linkovi';
$string['logincomments'] = 'Da, od prijavljenih korisnika';
$string['maxattachments'] = 'Maksimalan broj priloga';
$string['maxattachments_help'] = 'Ovo podešavanje određuje najveći broj datoteka koje mogu biti priložene uz blog članak.`';
$string['maxattachmentsize'] = 'Maksimalna veličina priloga';
$string['maxattachmentsize_help'] = 'Ovo podešavanje određuje najveću veličinu datoteke koja može biti priložena uz blog članak.';
$string['maxvisibility'] = 'Maksimalna vidljivost';
$string['maxvisibility_help'] = '<p><em> Na ličnom blogu:</em> <strong>vidljivo samo vlasniku/autoru bloga (privatno)</strong> &ndash; niko* drugi ne može da vidi ovaj članak.</p>
<p><em>Na blogu kursa:</em> <strong>vidljivo učesnicima ovog kursa </strong> &ndash; da biste videli članak mora vam biti odobren pristup blogu, obično, tako što ćete se upisati na kurs na kojem se blog nalazi.</p>

<p><strong> Vidljiva svima koji su prijavljeni na sistem </strong> &ndash; svi koji su prijavljeni mogu da vidi blog članak, čak i ako nisu upisani na određeni kurs.</p> <p><strong>Vidljivo svima u svetu </strong> &ndash; bilo koji korisnik interneta može da vidi ovaj članak ako mu date adresu bloga.</p>

<p>Ova opcija postoji na celom blogu, kao i na pojedinačnim člancima. Ako je opcija  podešena na nivou čitavog bloga  onda to postaje maksimum vidljivosti. Na primer, ako je ceo blog podešen na prvi nivo, onda uopšte ne možete da menjate nivo pojedinačnog članka.</p>';
$string['maybehiddenposts'] = 'Ovaj blog može da sadrži članke koji su vidljivi samo prijavljenim korisnicima, ili članke gde samo prijavljeni korisnici mogu da pišu komentare. Ako imate nalog na sistemu, molimo vas, <a href=\'{$a}\'>prijavite se za puni pristup blogu</a>';
$string['message'] = 'Poruka';
$string['moderated_addedcomment'] = 'Hvala što ste dodali svoj komentar, koji je uspešno primljen. Vaš komentar se neće pojaviti sve dok ga ne odobri autor ovog članka.';
$string['moderated_approve'] = 'Odobri ovaj komentar';
$string['moderated_authorname'] = 'Vaše ime';
$string['moderated_awaiting'] = 'Komentari koji čekaju odobrenje';
$string['moderated_awaitingnote'] = 'Ovi komentari nisu vidljivi drugim korisnicima ukoliko ih odobrite. Imajte na umu da sistem ne raspoznaje identitet komentatora i da komentari mogu da sadrže linkove koji, ako se prate, mogu ozbiljno  da <strong>oštete vaš računar</strong>. Ukoliko ste u nedoumici, odbijte komentare <strong>i nemojte  slediti bilo kakav link</strong>.';
$string['moderated_confirm'] = 'Potvrda';
$string['moderated_confirminfo'] = 'Molimo upišite ispod <strong>da</strong> kako biste potvrdili da ste vi ta osoba.';
$string['moderated_confirmvalue'] = 'da';
$string['moderated_emailhtml'] = '<p>(Ovo je automatski generisana elektronska poruka. Molimo vas da ne odgovarate na nju.)</p> <p>Neko je dodao komentar na vaš blog članak: {$a->postlink}</p>
<p>Potrebno je da <strong>odobrite komentar</strong> pre njegovog objavljivanja..</p>
<p>Sistem ne raspoznaje identitet komentatora, a komentari mogu da sadrže linkove. koji, ako se prate, mogu ozbiljno  da <strong>oštete vaš računar.</strong>. Ukoliko ste u nedoumici, odbijte komentare i <strong>nemojte  slediti bilo kakav link.</strong>
</p>
<p>Ako odobrite komentar, vi preuzimate odgovornost za  njegovo objavljivanje. Proverite da komentar ne sadrži ništa što je protivno pravilima/</p>
<hr/>
<p>Ime: {$a->commenter}</p>
<hr/>
<h3>{$a->commenttitle}</h3> {$a->comment}
<hr/>
<ul class=\'oublog-approvereject\'> <li><a href=\'{$a->approvelink}\'>{$a->approvetext}</a></li>
<li><a href=\'{$a->rejectlink}\'>{$a->rejecttext}</a></li>
</ul>
<p> Možete, takođe, da ignorišete ovu poruku. Komentar će automatski biti odbijen nakon 30 dana.
</p>
<p>Ako dobijate previše ovakvih poruka, možda ćete hteti da ograničite mogućnost komentarisanja samo na prijavljene korisnike.
</p>
<ul class=\'oublog-restrict\'>
<li><a href=\'{$a->restrictpostlink}\'>{$a->restrictposttext}</a></li>
<li><a href=\'{$a->restrictbloglink}\'>{$a->restrictblogtext}</a></li>
</ul>';
$string['moderated_emailsubject'] = 'Komentar čeka odobrenje na: {$a->blog} ({$a->commenter})';
$string['moderated_emailtext'] = 'Ovo je automatski generisana elektronska poruka. Molimo vas da ne odgovarate na nju.

Neko je dodao komentar na vaš blog članak:
{$a->postlink}

Potrebno je da odobrite komentar pre njegovog objavljivanja.

Sistem ne raspoznaje identitet komentatora, a komentari mogu da sadrže linkove. koji, ako se prate, mogu ozbiljno  da oštete vaš računar. Ukoliko ste u nedoumici, odbijte komentare i nemojte  slediti bilo kakav link.

Ako odobrite komentar, vi preuzimate odgovornost za  njegovo objavljivanje. Proverite da komentar ne sadrži ništa što je protivno pravilima.

---------------------------------------------------------
Ime: {$a->commenter}
---------------------------------------------------------
{$a->commenttitle}
{$a->comment}
---------------------------------------------------------

* {$a->approvetext}:
  {$a->approvelink}

* {$a->rejecttext}:
  {$a->rejectlink}

Možete, takođe, da ignorišete ovu poruku. Komentar će automatski biti odbijen nakon 30 dana.

Ako dobijate previše ovakvih poruka, možda ćete hteti da ograničite mogućnost komentarisanja samo na prijavljene korisnike.

* {$a->restrictposttext}:
  {$a->restrictpostlink}

* {$a->restrictblogtext}:
  {$a->restrictbloglink}';
$string['moderated_info'] = 'Pošto niste prijavljeni na sistem, vaš komentar će se pojaviti tek nakon što bude odobren. Ako imate nalog na sistemu, molimo vas <a href=\'{$a}\'>prijavite se za puni pristup blogu</a>.';
$string['moderated_postername'] = 'koristeći ime <strong>{$a}</strong>';
$string['moderated_reject'] = 'Odbij ovaj komentar';
$string['moderated_rejectedon'] = 'Odbijen {$a}:';
$string['moderated_restrictblog'] = 'Ograničite komentarisanje svih vaših članaka na ovom blogu';
$string['moderated_restrictblog_info'] = 'Želite li da ograničite komentare na sve vaše članke na ovom blogu, tako da samo ljudi koji su prijavljeni na sistem mogu da dodaju svoje komentare?';
$string['moderated_restrictpage'] = 'Ograniči komentarisanje';
$string['moderated_restrictpost'] = 'Ograničite komentarisanje ovog članka';
$string['moderated_restrictpost_info'] = 'Želite li da ograničite komentare na ovaj članke, tako da samo ljudi koji su prijavljeni na sistem mogu da dodaju svoje komentare?';
$string['moderated_submitted'] = 'Čeka na moderisanje';
$string['moderated_typicaltime'] = 'U prethodnom periodu, ovo je obično trajalo oko {$a}.';
$string['modulename'] = 'OU blog';
$string['modulename_help'] = 'Modul aktivnosti \'Blog\' dozvoljava kreiranje blogova unutar kursa
(ovi blogovi su nezavisni od blog sistema Moodlea). Možete imati blogove na nivou kurs (svaki učesnik kursa može da objavljuje članke na istom blogu), grupne blogove ili individualne blogove.';
$string['modulenameplural'] = 'OU blogovi';
$string['mustprovidepost'] = 'Mora biti obezbeđen id članka (postid)';
$string['myparticipation'] = 'Moje učešće';
$string['ncomments'] = '{$a} komentar/a';
$string['newblogposts'] = 'Novi blog članak';
$string['newcomment'] = 'Novi komentari bloga';
$string['newerposts'] = 'Noviji članci';
$string['newpost'] = 'Novi blog članak';
$string['no'] = 'Ne';
$string['no_blogtogetheroringroups'] = 'Ne (blog zajedno ili u grupama)';
$string['noblogposts'] = 'Nema blog članaka';
$string['nocomments'] = 'Komentari nisu dozvoljeni';
$string['noposts'] = 'Ne postoji vidljivi članci na ovom blogu';
$string['notaddpost'] = 'Nije moguće dodati članak';
$string['notaddpostnogroup'] = 'Ne možete da dodate post bez grupe';
$string['nousercomments'] = 'Ovaj korisnik nije imao nijedan komentar na ovom blogu';
$string['nouserposts'] = 'Ovaj korisnik nije imao nijedan članak na ovom blogu';
$string['npending'] = '{$a} komentar(a) čeka odobrenje';
$string['npendingafter'] = ', {$a} čeka odobrenje';
$string['numposts'] = 'broj članaka {$a}';
$string['olderposts'] = 'Stariji članci';
$string['onecomment'] = '{$a} komentar';
$string['onepending'] = '{$a} komentar čeka odobrenje';
$string['onependingafter'] = ', {$a} čeka odobrenje';
$string['onlyworkspersonal'] = 'Radi samo za lične blogove';
$string['oublog'] = 'OU blog';
$string['oublog:addinstance'] = 'Dodaj novi OU blog';
$string['oublog:audit'] = 'Pogledaj obrisane članke i starije verzije';
$string['oublog:comment'] = 'Komentar na članak';
$string['oublog:contributepersonal'] = 'Članci i komentari u ličnim blogovima';
$string['oublog:exportownpost'] = 'Izvezi sopstveni članak';
$string['oublog:exportpost'] = 'Izvezi članak';
$string['oublog:exportposts'] = 'Izvoz članaka';
$string['oublog:grade'] = 'Oceni učešće korisnika na OU blogu';
$string['oublog:managecomments'] = 'Upravljanje komentarima';
$string['oublog:managelinks'] = 'Upravljanje linkovima';
$string['oublog:manageposts'] = 'Upravljanje člancima';
$string['oublog:post'] = 'Kreiraj novi članak';
$string['oublog:view'] = 'Pogledaj članke';
$string['oublog:viewindividual'] = 'Pogledaj individualne blogove';
$string['oublog:viewparticipation'] = 'Pogledaj učešće korisnika na OU blogu';
$string['oublog:viewpersonal'] = 'Pogledajte članke u ličnim blogovima';
$string['oublogintro'] = 'Uvod';
$string['overviewnumentrylog'] = 'članci od poslednje prijave na sistem';
$string['overviewnumentrylog1'] = 'članak od poslednje prijave na sistem';
$string['overviewnumentryvw'] = 'članci od poslednjeg pregleda';
$string['overviewnumentryvw1'] = 'članak od poslednjeg pregleda';
$string['participation'] = 'Učešće';
$string['participationbyuser'] = 'Učešće od strane korisnika';
$string['permalink'] = 'Permanentni link';
$string['personalblognotsetup'] = 'Lični blogovi nisu podešeni';
$string['pluginadministration'] = 'Administracija OU bloga';
$string['pluginname'] = 'OU Blog';
$string['postauthor'] = 'Autor članka';
$string['postdate'] = 'Datum članka';
$string['postedby'] = 'napisao/la {$a}';
$string['postedbymoderated'] = 'napisao/la {$a->commenter} (odobrio/la {$a->approver}, {$a->approvedate})';
$string['postedbymoderatedaudit'] = 'napisao/la {$a->commenter} [{$a->ip}] (odobrio/la {$a->approver}, {$a->approvedate})';
$string['posts'] = 'Članci';
$string['postsby'] = 'Članci autora {$a}';
$string['posttime'] = 'Vreme objavljivanja članka';
$string['posttitle'] = 'Naslov članka';
$string['publiccomments'] = 'Da, od svih (čak i ako nisu prijavljeni na sistem)';
$string['publiccomments_info'] = 'Ako neko dodaje komentar, kada nije prijavljen na sistem, dobićete obaveštenje e-poštom i moći ćete da odobrite komentar za prikazivanje ili da ga odbijete. Ovo je neophodno kako bi se sprečilo zatrpavanje neželjenim komentarima (spam).';
$string['re'] = 'Odgovor: {$a}';
$string['rss'] = 'RSS';
$string['rssfeed'] = 'RSS izvor vesti';
$string['savegrades'] = 'Sačuvaj ocene';
$string['searchthisblog'] = 'Pretraži ovaj blog';
$string['separateindividual'] = 'Odvojeni&nbsp;individualni';
$string['separateindividualblogs'] = 'Odvojeni individualni blogovi';
$string['siteentries'] = 'Pregled članaka na nivou sajta';
$string['subscribefeed'] = 'Pretplatite se na izvor vesti (potreban je odgovarajući softver), kako biste dobijali obaveštenja o promenama na ovom blogu.';
$string['summary'] = 'Rezime';
$string['tags'] = 'Oznake';
$string['tags_help'] = 'Tagovi (oznake) su oznake koje vam pomažu da lakše pronađete i kategorišite blog članke.';
$string['tagsfield'] = 'Oznake (odvojene zarezima)';
$string['tagupdatefailed'] = 'Ažuriranje oznaka nije uspelo';
$string['title'] = 'Naslov';
$string['unsupportedbrowser'] = '<p>Vaš veb čitač ne može da prikaže Atom ili RSS izvor vesti direktno.</p> <p>Izvori vesti su najkorisniji kada se  za njihovo prikazivanje upotrebljavaju posebni kompjuterski programi (RSS čitači ) ili veb sajtovi. Ako želite da koristite ovaj izvor vesti kopirajte njegovu adresu iz adresne trake svog veb čitača i nalepite je u neki od tih RSS čitača odnosno veb sajtova.</p>';
$string['url'] = 'Puna veb adresa';
$string['usergrade'] = 'Ocena korisnika';
$string['userparticipation'] = 'Učešće korisnika';
$string['viewallusers'] = 'Pogledaj sve korisnike';
$string['viewallusersingroup'] = 'Pogledaj sve korisnike u grupi';
$string['viewblogdetails'] = 'Pogledaj detaljne informacije o blogu';
$string['viewblogposts'] = 'Povratak na blog';
$string['viewedit'] = 'Pogledaj izmene';
$string['views'] = 'Ukupan broj poseta ovom blogu:';
$string['visibility'] = 'Ko može da čita ovo?';
$string['visibility_help'] = '<p><strong> Vidljivo učesnicima ovog kursa </strong> &ndash; da biste videli članak mora vam biti odobren pristup blogu, obično, tako što ćete se upisati na kurs na kojem se blog nalazi.</p>

<p><strong> Vidljiva svima koji su prijavljeni na sistem </strong> &ndash; svi koji su prijavljeni mogu da vidi blog članak, čak i ako nisu upisani na određeni kurs.</p> <p><strong>Vidljivo svima u svetu </strong> &ndash; bilo koji korisnik interneta može da vidi ovaj članak ako mu date adresu bloga.';
$string['visibleblogusers'] = 'Vidljivo samo članovima ovog bloga';
$string['visiblecourseusers'] = 'Vidljivo učesnicima ovog kursa';
$string['visibleindividual'] = 'Vidljivi&nbsp;individualni';
$string['visibleindividualblogs'] = 'Vidljivi individualni blogovi';
$string['visibleloggedinusers'] = 'Vidljivo svakome ko je prijavljen na sistem';
$string['visiblepublic'] = 'Vidljivo svima u svetu';
$string['visibleyou'] = 'Vidljivo samo vlasniku/autoru bloga (privatno)';
$string['yes'] = 'Da';
