<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'auth', language 'sr_lt', version '4.4'.
 *
 * @package     auth
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actauthhdr'] = 'Dostupni dodaci za proveru identiteta';
$string['allowaccountssameemail'] = 'Dozvoli naloge sa istom elektronskom adresom';
$string['allowaccountssameemail_desc'] = 'Ako je omogućeno, više od jednog korisničkog naloga može imati istu elektronsku adresu. To može dovesti do bezbednosnih problema ili problema sa privatnošću, na primer, prilikom slanja e-poruke za potvrdu promene lozinke.';
$string['alternatelogin'] = 'Ako ovde unesete URL adresu, onda će ona biti korišćena kao stranica za prijavljivljnje na ovaj sajt. Stranica treba da sadržati obrazac koji ima svojstvo akcije podešeno na <strong>\'{$a}\'</strong> i vraća polja <strong>username</strong> i <strong>password</strong>.<br />Budite oprezni da ne biste slučajno uneli pogrešnu URL adresu i time sami sebi onemogućili pristup sajtu.<br />Ostavite ovo podešavanje prazno da biste koristili podrazumevanu stranicu za prijavljivanje.';
$string['alternateloginurl'] = 'Alternativna URL adresa za prijavu na sistem';
$string['auth_changepasswordhelp'] = 'Pomoć pri promeni lozinke';
$string['auth_changepasswordhelp_expl'] = 'Prikaz pomoći za slučaj izgubljene lozinke korisnicima koji su izgubili svoju {$a} lozinku. To će biti prikazano umesto <strong>URL adrese za promenu lozinke</strong> ili interne promene Moodle lozinke, ili pak uz nju.';
$string['auth_changepasswordurl'] = 'URL za promenu lozinke';
$string['auth_changepasswordurl_expl'] = 'Navedite URL adresu koja će biti poslata korisnicima koji izgube svoje {$a} lozinke. Podesite<strong>Koristiti standardnu stranicu za promenu lozinke</strong> na <strong>Ne</strong>.';
$string['auth_changingemailaddress'] = 'Zatražili ste da staru adrese e-pošte  {$a->oldemail} promenite u novu {$a->newemail}. Iz razloga bezbednosti, šaljemo vam e-poruku na novu adresu kako biste potvrdili da ona zaista pripada vama. Vaša adresa e-pošte biće ažurirana čim otvorite URL adresu koja vam je poslat u toj poruci. Link za potvrdu će isteći za 10 minuta.';
$string['auth_common_settings'] = 'Opšta podešavanja';
$string['auth_data_mapping'] = 'Mapiranje podataka';
$string['auth_fieldlock'] = 'Zaključavanje vrednosti';
$string['auth_fieldlock_expl'] = '<p>Zaključaj vrednost: Ako je omogućeno, sprečiće korisnike da direktno uređuju polje. Koristite ovu opciju ako održavate ove podatke u eksternom sistemu za proveru identiteta.</p>';
$string['auth_fieldlockfield'] = 'Zaključaj vrednost ({$a})';
$string['auth_fieldlocks'] = 'Zaključaj korisnička polja';
$string['auth_fieldlocks_help'] = '<p>Možete zaključati polja sa korisničkim podacima. To je korisno za sajtove na kojima korisničke podatke ručno održavaju administratori uređivanjem korisničkih zapisa u bazi podataka ili postavljanjem podataka korišćenjem opcije  \'Postavljanje korisnika\'. Ako zaključavate polja koja su neophodna za rad Moodle sistema, proverite da li ste, prilikom kreiranja korisničkih naloga, popunili ta polja odgovarajućim podacima, jer se u suprotnom nalozi neće moći koristiti.</p><p>Podesite vrednost za zaključavanje na \'Otključano ako je prazno\' da biste izbegli navedeni problem.</p>';
$string['auth_fieldmapping'] = 'Mapiranje podataka ({$a})';
$string['auth_invalidnewemailkey'] = 'Greška: ako pokušavate da potvrdite promenu adrese e-pošte, možda ste napravili grešku pri kopiranju URL adrese koju smo Vam poslali putem e-pošte. Molimo, kopirajte adresu i pokušajte ponovo.';
$string['auth_loginpasswordtoggle'] = 'Prekidač vidljivosti lozinke';
$string['auth_loginpasswordtoggle_desc'] = 'Dodajte ikonicu uz polje za lozinku na ekranu za prijavu, koja omogućava korisnicima da prikažu ili sakriju svoju unetu lozinku.';
$string['auth_loginrecaptcha'] = 'Omogući reCAPTCHA za prijavu';
$string['auth_loginrecaptcha_desc'] = 'Dodajte vizuelni/audio obrazac za potvrdu na stranicu za prijavu. Ovo smanjuje rizik od neovlašćenih pokušaja prijave na sistem. Za više informacija pogledajte <a target ="_blank"href ="https://www.google.com/recaptcha">Google reCAPTCHA</a>.';
$string['auth_multiplehosts'] = 'Određivanje više domaćina ili adresa (npr. host1.com;host2.com;host3.com) ili (npr. xxx.xxx.xxx.xxx;xxx.xxx.xxx.xxx)';
$string['auth_notconfigured'] = 'Metod provere identiteta {$a} nije konfigurisan.';
$string['auth_outofnewemailupdateattempts'] = 'Potrošili ste dozvoljeni broj pokušaja za promenu adrese e-pošte. Vaš zahtev za promenu je odbijen.';
$string['auth_passwordisexpired'] = 'Vaša lozinka je istekla. Promenite je odmah.';
$string['auth_passwordwillexpire'] = 'Vaša lozinka ističe za {$a} dan/a.  Da li želite da je promenite sada?';
$string['auth_remove_delete'] = 'Potpuno brisanje internih podataka';
$string['auth_remove_keep'] = 'Zadržavanje internih podataka';
$string['auth_remove_suspend'] = 'Suspendovanje internih podataka';
$string['auth_remove_user'] = 'Odredite šta raditi sa unutrašnjim korisničkim nalogom za vreme masovne sinhronizacije kada je korisnik uklonjen od strane spoljnog izvora. Samo suspendovani korisnici se automatski obnavljaju ako se ponovo pojavljuju u spoljnom izvoru.';
$string['auth_remove_user_key'] = 'Uklonjen spoljni korisnik';
$string['auth_sync_script'] = 'Sinhronizacija korisničkog naloga';
$string['auth_sync_suspended'] = 'Kada je ova opcija omogućena, suspendovani atribut će biti korišćen za ažuriranje statusa suspenzije lokalnog korisničkog naloga.';
$string['auth_sync_suspended_key'] = 'Sinhronizuj status suspenzije lokalnog korisnika';
$string['auth_updatelocal'] = 'Ažuriranje lokalnih podataka';
$string['auth_updatelocal_expl'] = '<p><b>Ažuriranje lokalnih podataka:</b> Ako je omogućeno, polje će biti ažurirano (koristi se eksterni auth) svaki put kada korisnik pristupi sistemu ili dođe do korisničke sinhronizacije. Polja za koja je podešeno lokalno ažuriranje treba da budu zaključana.</p>';
$string['auth_updatelocalfield'] = 'Ažuriraj lokalna polja ({$a})';
$string['auth_updateremote'] = 'Ažuriranje eksternih podataka';
$string['auth_updateremote_expl'] = '<p><b>Ažuriranje eksternih podataka:</b> Ako je omogućeno, eksterni auth će biti ažuriran pri ažuriranju zapisa o korisnicima. Polja bi trebala biti otključana da bi se dozvolile promene.</p>';
$string['auth_updateremote_ldap'] = '<p><b>Napomene:</b> Ažuriranje eksternih LDAP podataka zahteva da podesite povezivanje binddn i bindpw za bind-korisnika sa privilegijama korigovanja svih korisničkih zapisa. Ovo trenutno ne čuva viševrednosne atribute i ukloniće dodatne vrednosti nadogradnje.</p>';
$string['auth_updateremotefield'] = 'Ažuriraj eksterna polja ({$a})';
$string['auth_user_create'] = 'Omogućiti kreiranje korisnika';
$string['auth_user_creation'] = 'Novi (anonimni) korisnici mogu napraviti korisničke naloge na spoljašnjem izvoru za proveru identiteta i izvršiti potvrdu putem e-pošte. Ako omogućite ovu opciju, konfigurišite i specifične opcije modula koje služe za kreiranje korisnika.';
$string['auth_usernameexists'] = 'Odabrano korisničko ime već postoji. Molimo izaberite drugo korisničko ime.';
$string['auth_usernotexist'] = 'Nije moguće ažurirati nepostojećeg korisnika: {$a}';
$string['authenticationoptions'] = 'Opcije za proveru identiteta';
$string['authinstructions'] = 'Ostavite ovo polje prazno ako želite da se korisnicima prikazuju podrazumevane instrukcije za prijavu na sistem na naslovnoj strani. Ako želite da im ponudite neke posebne instrukcije unesite ih ovde.';
$string['authloginviaemail'] = 'Dozvoli prijavu putem e-pošte';
$string['authloginviaemail_desc'] = 'Dozvoli korisnicima da za prijavljivanje na sajt koriste i korisničko ime i adresu e-pošte (ako je jedinstvena).';
$string['auto_add_remote_users'] = 'Automatsko dodavanje udaljenih korisnika';
$string['cannotmapfield'] = 'Polje "{$a->fieldname}" ne može da bude mapirano zato što je njegov skraćeni naziv "{$a->shortname}" predug. Kako biste omogućili mapiranje potrebno je da redukujete skraćeni naziv polja profila na {$a->charlimit} znak(ov)a. <a href="{$a->link}">Uredi polja korisničkog profila</a>';
$string['changepassword'] = 'URL za promenu lozinke';
$string['changepasswordhelp'] = 'URL adresa stranice na kojoj korisnici mogu da obnove izgubljenu ili zaboravljenu lozinku, koja će im biti poslata elektronskom poštom. Imajte na umu da ovo podešavanje neće imati efekta ukoliko je URL adresa stranice za promenu zaboravljene lozinke postavljena u zajedničkim podešavanjima za proveru identiteta.';
$string['chooseauthmethod'] = 'Izaberite metod provere identiteta';
$string['chooseauthmethod_help'] = 'Ovo podešavanje određuje metod provere identiteta koji se koristi kada se korisnik prijavljuje na sistem. Treba da odaberete samo dodatke za proveru identitet koji su uključeni, u suprotnom korisnici neće više moći da se prijave. Da biste blokirali prijavu korisnika, izaberite "Nema prijave".';
$string['createpassword'] = 'Generiši lozinku i obavesti korisnika';
$string['createpasswordifneeded'] = 'Kreirajte lozinku ako je to potrebno i pošaljite je e-poštom';
$string['emailchangecancel'] = 'Otkaži promenu elektronske adrese';
$string['emailchangepending'] = 'Promena na čekanju. Otvorite link koji Vam je poslata na {$a->preference_newemail}.';
$string['emailnowexists'] = 'Adresa e-pošte koju ste pokušali da dodelite Vašem profilu je već dodeljenlj drugom korisniku. Zato je Vaš zahtev za promenu elektornske adrese poništen, ali možete pokušati sa drugom adresom.';
$string['emailupdate'] = 'Ažuriranje elektronske adrese';
$string['emailupdatemessage'] = 'Poštovani/a {$a->fullname},

Tražili ste promenu e-adrese za svoj korisnički nalog na sajtu {$a->site}. Da biste potvrdili ovu promenu, idite na sledeću veb adresu:

{$a->url}

{$a->supportemail}';
$string['emailupdatesuccess'] = 'E-adresa korisnika <em>{$a->fullname}</em> je uspešno promenjena u <em>{$a->email}</em>.';
$string['emailupdatetitle'] = 'Potvrda ažuriranja e-adrese na {$a->site}';
$string['errormaxconsecutiveidentchars'] = 'Maksimalan broj uzastopnih istovetnih znakova koje lozinka mora da sadrži: {$a}';
$string['errorminpassworddigits'] = 'Minimalan broj cifara koji lozinka mora sadržati je: {$a}.';
$string['errorminpasswordlength'] = 'Minimalan broj znakova koje lozinka mora da sadrži: {$a}.';
$string['errorminpasswordlower'] = 'Minimalan broj malih slova koji lozinka mora sadržati je: {$a}.';
$string['errorminpasswordnonalphanum'] = 'Minimalan broj specijalnih znakova (kao što su *, - ili #) koje lozinka mora da sadrži: {$a}.';
$string['errorminpasswordupper'] = 'Minimalan broj velikih slova koji lozinka mora sadržati je: {$a}.';
$string['errorpasswordreused'] = 'Ova lozinka je ranije već korišćena, i nije dozvoljena koristiti je ponovo';
$string['errorpasswordupdate'] = 'Greška u ažuriranju lozinke, lozinka nije promenjena.';
$string['eventuserloggedin'] = 'Korisnik se prijavio';
$string['eventuserloggedinas'] = 'Korisnik prijavljen kao drugi korisnik';
$string['eventuserloginfailed'] = 'Prijava korisnika nije uspela';
$string['forcechangepassword'] = 'Obavezna promena lozinke';
$string['forcechangepassword_help'] = 'Primoraj korisnike da promene lozinku prilikom njihove sledeće prijave na Moodle.';
$string['forcechangepasswordfirst_help'] = 'Primoraj korisnike da promene lozinku prilikom njihove prve prijave na Moodle.';
$string['forgottenpassword'] = 'Ukoliko ovde unesete URL adresu, ona će biti korišćena za stranicu za obnavljanje izgubljene/zaboravljene lozinke, na ovom sajtu. Ovo je namenjeno sajtovima na kojima se lozinkama, u potpunosti, upravlja izvan Moodlea. Ostavite ovo polje prazno da biste koristili uobičajeni način za obnavljanje lozinke.';
$string['forgottenpasswordurl'] = 'URL adresa za obnavljanje zaboravljene lozinke';
$string['getrecaptchaapi'] = 'Da bi se koristio reCAPTCHA morate nabaviti API ključ na sajtu <a href=\'https://www.google.com/recaptcha/admin\'>https://www.google.com/recaptcha/admin</a>';
$string['guestloginbutton'] = 'Dugme za prijavu gostiju';
$string['incorrectpleasetryagain'] = 'Neispravno. Molimo pokušajte ponovo';
$string['infilefield'] = 'Polje zahtevano u datoteci';
$string['informminpassworddigits'] = 'minimalan broj cifara: {$a}';
$string['informminpasswordlength'] = 'minimalan broj znakova: {$a}';
$string['informminpasswordlower'] = 'minimalan broj malih slova: {$a}';
$string['informminpasswordnonalphanum'] = 'minimalan broj specijalnih znakova (kao što su *, - ili #) : {$a}';
$string['informminpasswordreuselimit'] = 'Lozinke se mogu ponovo koristiti nakon {$a} promene/a';
$string['informminpasswordupper'] = 'minimalan broj velikih slova: {$a}';
$string['informpasswordpolicy'] = 'Lozinka mora imati {$a}';
$string['instructions'] = 'Uputstva';
$string['internal'] = 'Interno';
$string['limitconcurrentlogins'] = 'Ograniči istovremene prijave';
$string['limitconcurrentlogins_desc'] = 'Ako je ova opcija omogućena, broj prijava konkurentnih veb čitača za svakog korisnika biće ograničen. Najstarije sesije se prekidaju nakon što se dostigne ograničenje. Imajte u vidu da korisnik može da izgubi sve što nije sačuvao Ovo podešavanje nije kompatibilno sa SSO (single sign on - jednostruko prijavljivanje) dodacima za proveru identiteta.';
$string['locked'] = 'Zaključano';
$string['md5'] = 'MD5 heš';
$string['nopasswordchange'] = 'Nije moguće promeniti lozinku';
$string['nopasswordchangeforced'] = 'Niste u mogućnosti da nastavite dalje bez promene lozinke, međutim ne postoji stranica za njenu promenu. Molimo kontaktirajte Moodle administratora.';
$string['noprofileedit'] = 'Nije moguće uređivati profil';
$string['ntlmsso_attempting'] = 'Pokušava se SSO (Single Sign On) preko NTLM...';
$string['ntlmsso_failed'] = 'Automatsko prijavljivanje nije uspelo, pokušajte sa običnom stranicom za prijavljivljnje...';
$string['ntlmsso_isdisabled'] = 'NTLM SSO (jedinstvena prijava) nije uključenа.';
$string['passwordhandling'] = 'Upravljenje poljem lozinke';
$string['plaintext'] = 'Običan tekst';
$string['pluginnotenabled'] = 'Dodatak za proveru identiteta \'{$a}\' nije omogućen.';
$string['pluginnotinstalled'] = 'Dodatak za proveru identiteta \'{$a}\' nije instaliran.';
$string['potentialidps'] = 'Prijavite se koristeći svoj nalog na:';
$string['privacy:metadata:userpref:createpassword'] = 'Označava da treba generisati lozinku za korisnika';
$string['privacy:metadata:userpref:forcepasswordchange'] = 'Označava da li korisnik treba da promeni lozinku prilikom prijave na sistem';
$string['privacy:metadata:userpref:loginfailedcount'] = 'Broj neuspešnih pokušaja pristupu sistemu od strane korisnika';
$string['privacy:metadata:userpref:loginfailedcountsincesuccess'] = 'Broj neuspešnih pokušaja pristupu sistemu od strane korisnika od poslednje uspešne prijave';
$string['privacy:metadata:userpref:loginfailedlast'] = 'Datum kad je zabeležen poslednji neuspešan pokušaj pristupa sistemu';
$string['privacy:metadata:userpref:loginlockout'] = 'Označava da li je nalog korisnika zaključan zbog neuspešnih pokušaja pristupa sistemu, kao i datum kad je nalog zaključan';
$string['privacy:metadata:userpref:loginlockoutignored'] = 'Označava da korisnikov nalog nikad ne treba da bude podvrgnut zaključavanju';
$string['privacy:metadata:userpref:loginlockoutsecret'] = 'Kada je nalog zaključan, ovo je lozinka koju korisnik mora iskoristiti da ga otključa';
$string['recaptcha'] = 'reCAPTCHA';
$string['recaptcha_help'] = 'CAPTCHA služi za sprečavanje zloupotreba od strane automatizovanih programa. Pratite uputstva da biste potvrdili da ste osoba. To može biti klik na kvadratno polje, unos znakova prikazanih na slici u tekstualno polje, ili odabir slika sa određenim motivom od više ponuđenih.

Ako niste sigurni šta je prikazano na slikama, možete da zatražite novi CAPTCHA ili da poslušate zvučni CAPTCHA.';
$string['recaptcha_link'] = 'auth/email';
$string['security_question'] = 'Bezbednosno pitanje';
$string['selfregistration'] = 'Samoregistracija';
$string['selfregistration_help'] = 'Ako je izabran dodatak za proveru identiteta, kao što je samostalna registracija putem e-pošte, onda će ovo omogućiti potencijalnim korisnicima da se sami registruju i kreiraju korisničke naloge. Ovo za posledicu ima mogućnost da spameri kreiraju korisničke naloge kako bi koristili forume, blog članke i slično za slanje neželjenih poruka. Kako biste izbegli ovaj rizik, samostalna registracija treba da bude onemogućena ili ograničena pomoću podešavanja <em>Dozvoljeni domeni e-pošte</em>.';
$string['settingmigrationmismatch'] = 'Prilikom ispravke podešavanja naziva dodatka otkriveno je neslaganje između naziva. Dodatak za proveru identiteta plugin \'{$a->plugin}\' imao je opciju \'{$a->setting}\' koje je konfigurisana kao \'{$a->legacy}\', pod starim nazivom, i kao \'{$a->current}\', pod tekućim, novim nazivom. Druga vrednost je uzeta kao ispravna, ali potrebno je da to proverite i potvrdite.';
$string['sha1'] = 'SHA-1 heš kod';
$string['showguestlogin'] = 'Možete sakriti ili prikazati dugme za prijavu gostiju na stranici za prijavljivljnje.';
$string['stdchangepassword'] = 'Koristi standardnu stranicu za promenu lozinke';
$string['stdchangepassword_expl'] = 'Ako spoljašnji sistem za proveru identiteta dozvoljava promenu lozinke iz Moodle sistema, uključite ga. Ovo podešavanje zaobilazi \'URL za promenu lozinke\'.';
$string['stdchangepassword_explldap'] = 'Napomena: Preporučuje se da koristite LDAP pre nego SSL šifrovanje tunela (ldaps://) ako je LDAP server udaljen.';
$string['suspended'] = 'Suspendovani nalog';
$string['suspended_help'] = 'Korisnici kojima je suspendovan nalog ne mogu da se prijave na sistem ili da koriste veb servise, niti im se šalju poruke sa sistema.';
$string['testsettings'] = 'Testiranje podešavanja';
$string['testsettingsheading'] = 'Podešavanja  testa za proveru  identiteta  - {$a}';
$string['unlocked'] = 'Otključano';
$string['unlockedifempty'] = 'Otključano ako je prazno';
$string['update_never'] = 'Nikad';
$string['update_oncreate'] = 'Pri kreiranju';
$string['update_onlogin'] = 'Pri svakom pristupu sistemu';
$string['update_onupdate'] = 'Pri ažuriranju';
$string['user_activatenotsupportusertype'] = 'auth: ldap user_activate() ne podržava izabrani tip korisnika: {$a}';
$string['user_disablenotsupportusertype'] = 'auth: ldap user_activate() ne podržava izabrani tip korisnika (...još)';
$string['username'] = 'Korisničko ime';
$string['username_help'] = 'Imajte na umu da vam neki dodaci za proveru identiteta neće dozvoliti da promenite korisničko ime.';
