<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'mnet', language 'sl', version '4.4'.
 *
 * @package     mnet
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['RPC_HTTPS_SELF_SIGNED'] = 'HTTPS (samo-podpisan)';
$string['RPC_HTTPS_VERIFIED'] = 'HTTPS (podpisan)';
$string['RPC_HTTP_PLAINTEXT'] = 'HTTP nekriptiran';
$string['RPC_HTTP_SELF_SIGNED'] = 'HTTP (samo-podpisan)';
$string['RPC_HTTP_VERIFIED'] = 'HTTP (podpisan)';
$string['aboutyourhost'] = 'O vašem strežniku';
$string['accesslevel'] = 'Raven dostopa';
$string['addhost'] = 'Dodaj gostitelja';
$string['addnewhost'] = 'Dodaj novega gostitelja';
$string['addtoacl'] = 'Dodaj k nadzoru dostopa';
$string['allhosts'] = 'Vsi gostitelji';
$string['allhosts_no_options'] = 'Pri ogledu več gostiteljev ni na voljo nobenig možnosti';
$string['allow'] = 'Dovoli';
$string['applicationtype'] = 'Tip aplikacije';
$string['authfail_nosessionexists'] = 'Avtorizacija ni uspela: seja mnet ne obstaja.';
$string['authfail_sessiontimedout'] = 'Avtorizacija ni uspela: seja mnet je potekla.';
$string['authfail_usermismatch'] = 'Avtorizacija ni uspela: uporabnik se ne ujema.';
$string['authmnetdisabled'] = 'Overitveni vtičnik za MNet je <strong>onemogočen</strong>.';
$string['badcert'] = 'To ni veljaven certifikat.';
$string['certdetails'] = 'Podrobnosti certifikata';
$string['configmnet'] = 'MNet vam omogoča komunikacijo strežnika z ostalimi strežniki ali storitvami.';
$string['couldnotgetcert'] = 'Certifikat na <br />{$a} ni bil najden. <br />Gostitelj ne deluje ali pa je napačno konfiguriran.';
$string['couldnotmatchcert'] = 'To se ne ujema s certifikatom, trenutno objavljenim na spletnem strežniku.';
$string['courses'] = 'predmeti';
$string['courseson'] = 'predmeti na';
$string['current_transport'] = 'Trenutni transport';
$string['currentkey'] = 'Trenutni javni ključ';
$string['databaseerror'] = 'Ni mogoče shraniti podrobnosti v podatkovno bazo.';
$string['deleteaserver'] = 'Brisanje strežnika';
$string['deletedhostinfo'] = 'Gostitelj je bil izbrisan. Če želite ta korak razveljaviti, spremenite izbrisano stanje nazaj na \'Ne\'.';
$string['deletedhosts'] = 'Izbrisani gostitelji: {$a}';
$string['deletehost'] = 'Izbriši gostitelja';
$string['deletekeycheck'] = 'Ali ste popolnoma prepričani, da želite izbrisati ta ključ?';
$string['deleteoutoftime'] = 'Poteklo je 60 sekund, ki jih imate na voljo za brisanje ključa. Začnite znova.';
$string['deleteuserrecord'] = 'SSO ACL: brisanje zapisa za uporabnika \'{$a->user}\' iz {$a->host}.';
$string['deletewrongkeyvalue'] = 'Prišlo je do napake. Če niste poskušali brisati ključa SSL na vašem strežniku, obstaja možnost, da ste bili žrtev zlonamernega napada. Izveden ni bil noben ukaz.';
$string['deny'] = 'Zavrni';
$string['description'] = 'Opis';
$string['duplicate_usernames'] = 'Poskus tvorjenja kazala na stolpcih "mnethostid" in "username" v vaši tabeli uporabnikov ni bil uspešen.<br />To se lahko zgodi, kadar imate <a href="{$a}" target="_blank">podvojene zapise v uporabniški tabeli</a>.<br />Vaša nadgradnja bi se vseeno morala uspešno zaključiti. Kliknite na zgornjo povezavo za navodila, kako odpraviti te težave. Navodila se pokažejo v svojem oknu, to pa lahko storite po zaključku nadgradnje.<br />';
$string['enabled_for_all'] = '(Ta storitev je bila omogočena za vse gostitelje).';
$string['enterausername'] = 'Vnesite uporabniško ime ali seznam uporabniških imen, ločenih z vejicami.';
$string['error7020'] = 'Ta napaka se običajno pojavi v primeru, da je oddaljeno spletno mesto ustvarilo zapis za vas z napačnim naslovom - denimo http://vašstrežnik.com namesto http://www.vašstrežnik.com. Sporočite pravilni naslov skrbniku oddaljenega spletnega mesta (naveden je v datoteki config.php) in ga prosite, da posodobi zapis za vašega gostitelja.';
$string['error7022'] = 'Sporočilo, ki ste ga poslali na oddaljeno spletno mesto, je bilo pravilno zakodirano, a ne podpisano. To je zelo nepričakovano; predlagamo, da v tem primeru prijavite napako. Prosimo, da nam sporočite tudi čim več informacij o aplikaciji (različica itn.).';
$string['error7023'] = 'Oddaljeno spletno mesto je poskusilo odkodirati vaše sporočilo z vsemi ključi, a nobeno ni uspelo. Težavo mogoče lahko rešite tako, da sprožite novo izmenjavo ključev z oddaljenim strežnikom. Ta napaka se ponavadi lahko pojavi samo v primeru, da z oddaljenim strežnikom niste komunicirali že več mesecev.';
$string['error7024'] = 'Na oddaljeno spletno mesto ste poslali nekodirano sporočilo, vendar pa ta ne podpira nekodiranega prenosa informacij z vašim spletnim mestom. To je zelo nepričakovano; predlagamo, da v tem primeru prijavite napako. Prosimo, da nam sporočite tudi čim več informacij o aplikaciji (različica itn.).';
$string['error7026'] = 'Ključ, s katerim je bilo podpisano vaše sporočilo, se ne ujema s ključem, ki ga ima oddaljeni gostitelj shranjenega za vaš strežnik. Oddaljeni gostitelj je tudi poskusil pridobiti vaš trenutni ključ, a ni bil uspešen. Sprožite novo izmenjavo ključev z oddaljenim gostiteljem.';
$string['error709'] = 'Oddaljeno spletno mesto ni uspelo pridobiti SSL ključa z vašega strežnika.';
$string['eventaccesscontrolcreated'] = 'Nadzor dostopa ustvarjen';
$string['eventaccesscontrolupdated'] = 'Nadzor dostopa posodobljen';
$string['expired'] = 'Ključ je potekel dne';
$string['expires'] = 'Veljavno do';
$string['expireyourkey'] = 'Izbriši ta ključ';
$string['expireyourkeyexplain'] = 'Moodle samodejno rotira vaše ključe vsakih 28 dni (privzeto), vendar pa imate ob vsakem času možnost, da ključ <em>ročno</em> označite za poteklega. To je lahko koristno v primeru, da verjamete, da ključ ni več varen. Po ročnem poteki ključa bo takoj samodejno generiran nadomestni ključ.<br />Brisanje tega ključa bo onemogočilo drugim aplikacijam komunikacijo z vami, dokler ročno ne stopite v stik z vsemi skrbniki in jim ne posredujete novega ključa.';
$string['exportfields'] = 'Polja za izvoz';
$string['failedaclwrite'] = 'Napaka pri pisanju v MNET seznam dostopa za uporabnika \'{$a}\'.';
$string['findlogin'] = 'Najdi prijavo';
$string['forbidden-function'] = 'Ta funkcija ni bila omogočena za RPC.';
$string['forbidden-transport'] = 'Način transporta, ki ga želite uporabiti, ni dovoljen.';
$string['forcesavechanges'] = 'Vsili shranjenje sprememb';
$string['helpnetworksettings'] = 'Konfigurirajte komunikacijo MNet';
$string['hidelocal'] = 'Skrij lokalne uporabnik';
$string['hideremote'] = 'Skrij oddaljene uporabnike';
$string['host'] = 'gostitelj';
$string['hostcoursenotfound'] = 'Gostitelj ali predmet ni bil najden';
$string['hostdeleted'] = 'V redu - gostitelj izbrisan';
$string['hostexists'] = 'Zapis za gostitelja s tem naslovom že obstaja (morda je bil izbrisan). <a href="{$a}">Kliknite sem</a> za urejanje tega zapisa.';
$string['hostlist'] = 'Seznam omreženih gostiteljev';
$string['hostname'] = 'Naslov gostitelja';
$string['hostnamehelp'] = 'Celoten domenski naslov oddaljenega gostitelja, denimo www.example.com';
$string['hostnotconfiguredforsso'] = 'Ta strežnik ni konfiguriran za oddaljeno prijavo.';
$string['hostsettings'] = 'Nastavitve gostitelja';
$string['http_self_signed_help'] = 'Dovoli povezave z uporabo samo-podpisanih DIY SSL certifikatov na oddaljenem gostitelju.';
$string['http_verified_help'] = 'Dovoli povezave s preverjenim certifikatom SSL v PHP na oddaljenem gostitelju, vendar prek http (ne https).';
$string['https_self_signed_help'] = 'Dovoli povezave z uporabo samo-podpisanih DIY SSL certifikatov v PHP na oddaljenem gostitelju prek http.';
$string['https_verified_help'] = 'Dovoli povezave z uporabo preverjenega SSL cerfitikata na oddaljenem gostitelju.';
$string['id'] = 'ID';
$string['idhelp'] = 'Ta vrednost je dodeljena samodejno in je ni moč spreminjati.';
$string['importfields'] = 'Polja za uvoz';
$string['inspect'] = 'Preglejte';
$string['installnosuchfunction'] = 'Napaka pri kodiranju! Nekaj posluša namestiti mnet xmlrpc funkcijo ({$a->method}) iz datoteke ({$a->file}) in ne more biti najdena!';
$string['installnosuchmethod'] = 'Napaka pri kodiranju! Nekaj posluša namestiti mnet xmlrpc metodo ({$a->method}) na razred ({$a->class}) in ne more biti najdena!';
$string['installreflectionclasserror'] = 'Napaka pri kodiranju! MNet introspekcija spodletela za metodo \'{$a->method}\' v razredu \'{$a->class}‘. Izvirno sporočilo o napaki, če vam kaj pomaga, je: \'{$a->error}';
$string['installreflectionfunctionerror'] = 'Napaka pri kodiranju! MNet introspekcija spodletela za funkcijo \'{$a->method}\' v datoteki \'{$a->file}‘. Izvirno sporočilo o napaki, če vam kaj pomaga, je: \'{$a->error}';
$string['invalidaccessparam'] = 'Neveljaven parameter za dostop.';
$string['invalidactionparam'] = 'Neveljaven parameter za ukaz.';
$string['invalidhost'] = 'Vnesti morate veljaven naslov gostitelja';
$string['invalidpubkey'] = 'Ta ključ ni veljaven SSL ključ. ({$a})';
$string['invalidurl'] = 'Neveljaven parameter URL.';
$string['ipaddress'] = 'Naslov IP';
$string['is_in_range'] = 'Naslov IP &nbsp;<code>{$a}</code>&nbsp; je veljaven in zaupanja vreden gostitelj.';
$string['ispublished'] = 'Strežnik {$a} Moodle je za vas omogočil to storitev.';
$string['issubscribed'] = 'Strežnik {$a} Moodle je naročnik na to storitev vašega gostitelja.';
$string['keydeleted'] = 'Vaš ključ je bil uspešno izbrisan in zamenjan.';
$string['keymismatch'] = 'Vaš javni ključ tega gostitelja je različen od javnega ključa, ki ga trenutno objavlja. Trenutno objavljeni ključ je:';
$string['last_connect_time'] = 'Čas zadnje povezave';
$string['last_connect_time_help'] = 'Čas vaše zadnje povezave s tem gostiteljem';
$string['last_transport_help'] = 'Vrsta transporta, uporabljenega za zadnjo povezavo s tem gostiteljem';
$string['leavedefault'] = 'Namesto tega uporabi privzete nastavitve';
$string['listservices'] = 'Seznam storitev';
$string['loginlinkmnetuser'] = '<br />Če ste oddaljeni MNet uporabnik in lahko <a href="{$a}">tu potrdite svoj e-poštni naslov</a>, boste preusmerjeni na vašo stran za prijavo.<br />';
$string['logs'] = 'dnevniki';
$string['managemnetpeers'] = 'Upravljajte istoredne elemente';
$string['method'] = 'Metoda';
$string['methodhelp'] = 'Pomoč za metodo {$a}';
$string['methodsavailableonhost'] = 'Metoda je na voljo na {$a}';
$string['methodsavailableonhostinservice'] = 'Metode so na voljo za {$a->service} na {$a->host}';
$string['methodsignature'] = 'Metodin podpis za {$a}';
$string['mnet'] = 'MNet omrežje';
$string['mnet_concatenate_strings'] = 'Združi do tri (3) nize in vrne rezultat';
$string['mnet_session_prohibited'] = 'Uporabnikom vašega domačega strežnika trenutno ni dovoljena uporaba storitev {$a}.';
$string['mnetdisabled'] = 'MNet omrežje je <strong>onemogočeno</strong>.';
$string['mnetidprovider'] = 'Mnet ID ponudnik';
$string['mnetidproviderdesc'] = 'S to funkcijo lahko pridobite povezavo, na katero se lahko prijavite, če navedete ustrezen e-poštni naslov, ki se ujema z uporabniškim imenom, s katerim ste se že skušali prijaviti.';
$string['mnetidprovidermsg'] = 'Prijava pri vašem ponudniku {$a} bi sedaj morala uspeti.';
$string['mnetidprovidernotfound'] = 'Oprostite, nadaljnjih informacij ni bilo mogoče najti.';
$string['mnetpeers'] = 'Istoredni elementi';
$string['mnetservices'] = 'Storitve';
$string['mnetsettings'] = 'Nastavitve MNet omrežja';
$string['moodle_home_help'] = 'Pot do domače strani Mnet aplikacije na oddaljenem gostitelju, denimo /moodle/.';
$string['name'] = 'Ime';
$string['net'] = 'Moodle omrežje';
$string['networksettings'] = 'Nastavitve omrežja';
$string['never'] = 'Nikoli';
$string['noaclentries'] = 'Ni vnosov v seznamu nadzora dostopov SSO';
$string['noaddressforhost'] = 'Oprostite, toda ta naslov gostitelja ({$a}) ne more biti razrešen!';
$string['nocurl'] = 'Knjižnica PHP cURL ni nameščena';
$string['nolocaluser'] = 'Za oddaljenega uporabnika ni lokalnih zapisov in jih ni bilo mogoče ustvariti, saj ta gostitelj samodejno ne ustvarja uporabnikov. Obrnite se na skrbnika!';
$string['nomodifyacl'] = 'Nimate dovoljenja za spreminjanje seznama nadzora dostopov Mnet.';
$string['nonmatchingcert'] = 'Zadeva certifikata: <br /><em>{$a->subject}</em><br />se ne ujema s podatki gostitelja, od katerega je prišel:<br /><em>{$a->host}</em>.';
$string['nopubkey'] = 'Prišlo je do težav pri prenašanju javnega ključa.<br />Gostitelj mogoče ne dovoljuje Mnet ali pa je ključ neveljaven.';
$string['nosite'] = 'Ni bilo mogoče najti predmeta na ravni spletnega mesta';
$string['nosuchfile'] = 'Datoteka ali funkcija {$a} ne obstaja.';
$string['nosuchfunction'] = 'Nisem našel funkcije ali pa je funkcija prepovedana za RPC.';
$string['nosuchmodule'] = 'Funkcija je bila napačno naslovljena in je ni moč najti. Prosimo, uporabite
format mod/modulename/lib/functionname.';
$string['nosuchpublickey'] = 'Ni bilo moč prenesti javnega ključa za preverjanje podpisa.';
$string['nosuchservice'] = 'Storitev RPC ni omogočena na tem gostitelju.';
$string['nosuchtransport'] = 'Transport s tem ključem ne obstaja.';
$string['notBASE64'] = 'Niz ni v obliki Base64, zato ne more predstavljati veljavnega ključa.';
$string['notPEM'] = 'Ta ključ ni v obliki PEM, zato ne bo deloval.';
$string['not_in_range'] = 'Naslov IP &nbsp;<code>{$a}</code>&nbsp; ne predstavlja veljavnega zaupanja vrednega gostitelja.';
$string['notenoughidpinfo'] = 'Vaš ponudnik identitete nam ne posreduje dovolj informacij, da lahko lokalno ustvarimo ali posodobimo vaš račun. Oprostite!';
$string['notinxmlrpcserver'] = 'Poskušajte dostopati do MNet oddaljenega odjemalca, ne med XMLRPC strežniško izvršbo';
$string['notmoodleapplication'] = 'OPOZORILO: To ni Moodle aplikacija, tako da nekatere inspekcijske metode morda ne bodo delovale.';
$string['notpermittedtojump'] = 'Nimate dovoljenja za pričetek oddaljene seje s tega Moodle strežnika.';
$string['notpermittedtojumpas'] = 'Ko ste prijavljeni kot drug uporabnik, ne morete začeti oddaljene seje.';
$string['notpermittedtoland'] = 'Nimate dovoljenja za pričetek oddaljene seje.';
$string['off'] = 'Izključeno';
$string['on'] = 'Vključeno';
$string['options'] = 'Možnosti';
$string['peerprofilefielddesc'] = 'Tukaj lahko preglasite globalne nastavitve, katera profilna polja se pošlje in uvozi, ko se ustvarjajo novi uporabniki';
$string['permittedtransports'] = 'Dovoljeni transporti';
$string['phperror'] = 'Vaše zahteve ni bilo moč izvršiti zaradi notranje napake PHP.';
$string['position'] = 'Pozicija';
$string['postrequired'] = 'Funkcija brisanja potrebuje zahtevo POST.';
$string['privacy:metadata'] = 'Vtičnik MNet ne shranjuje osebnih podatkov.';
$string['profileexportfields'] = 'Polja za poslati';
$string['profilefielddesc'] = 'Tukaj lahko konfigurirate seznam profilnih polj, ki so poslana ali prejeta preko Mnet, ko je ustvarjen sli posodobljen uporabniški račun. To lahko preglasite za vsak istoredni element Mnet posebej. Opomba: sledeča polja so vedno poslana in niso neobvezna: {$a}';
$string['profilefields'] = 'Profilna polja';
$string['profileimportfields'] = 'Polja za uvoz';
$string['promiscuous'] = 'Promiskuiteten';
$string['publickey'] = 'Javni ključ';
$string['publickey_help'] = 'Javni ključ se samodejno prenese z oddaljenega strežnika.';
$string['publickeyrequired'] = 'Vnesti morate javni ključ.';
$string['publish'] = 'Objavi';
$string['reallydeleteserver'] = 'Ali ste prepričani, da želite izbrisati ta strežnik?';
$string['receivedwarnings'] = 'Prejeta so bila naslednje opozorila';
$string['recordnoexists'] = 'Zapis ne obstaja.';
$string['reenableserver'] = 'Ne - izberite to možnost za ponovno vključitev strežnika.';
$string['registerallhosts'] = 'Registriraj vse gostitelje (\'promiscuous\' način)';
$string['registerallhostsexplain'] = 'Lahko se odločite za samodejno registracijo vseh gostiteljev, ki se bodo poskusili povezati z vami. To pomeni, da se bo v vašem seznamu gostiteljev pojavil zapis za vsako spletno mesto Mnet, ki se bo povezalo z vami in zahtevalo vaš javni ključ.<br />Spodaj imate možnost konfiguracije storitev za "Vse gostitelje". Z vklopom storitev tam lahko zagotavljate storitve vsem strežnikom Moodle brez razlikovanja.';
$string['registerhostsoff'] = 'Registracija vseh gostiteljev je trenutno <b>izklopljena</b>';
$string['registerhostson'] = 'Registracija vseh gostiteljev je trenutno <b>vklopljena</b>';
$string['remotecourses'] = 'Oddaljeni predmeti';
$string['remotehost'] = 'Oddaljeni gostitelj';
$string['remotehosts'] = 'Oddaljeni gostitelji';
$string['remoteuser'] = 'Oddaljeni uporabnik {$a->remotetype}';
$string['remoteuserinfo'] = 'Profil pridobljen iz <a href="{$a->remoteurl}">{$a->remotename}</a>';
$string['requiresopenssl'] = 'Omrežne funkcije zahtevajo razširitev OpenSSL';
$string['restore'] = 'Obnovi';
$string['returnvalue'] = 'Vrni vrednost';
$string['reviewhostdetails'] = 'Pregled podrobnosti gostitelja';
$string['reviewhostservices'] = 'Pregled storitev gostitelja';
$string['selectaccesslevel'] = 'Izberite raven dostopa s seznama.';
$string['selectahost'] = 'Izberite oddaljenega gostitelja.';
$string['service'] = 'Ime storitve';
$string['serviceid'] = 'ID storitve';
$string['servicesavailableonhost'] = 'Soritve, ki so na voljo na {$a}';
$string['serviceswepublish'] = 'Storitve, ki jih objavljamo {$a}';
$string['serviceswesubscribeto'] = 'Storitve na {$a}, na katere smo naročeni.';
$string['settings'] = 'Nastavitve';
$string['showlocal'] = 'Prikaži lokalne uporabnike';
$string['showremote'] = 'Prikaži oddaljene uporabnike';
$string['ssl_acl_allow'] = 'SSO ACL: Dovoli uporabnika \'{$a->user}\' iz \'{$a->host}';
$string['ssl_acl_deny'] = 'SSO ACL: Zavrni uporabnika \'{$a->user}\' iz \'{$a->host}';
$string['sslverification'] = 'SSL preverjanje';
$string['sslverification_help'] = 'S to možnostjo lahko konfigurirate raven varnosti, ko se povezujete z istorednim elementom prek HTTPS.

* Brez: brez ravni varnosti
* Preverite samo gostitelja: potrdi domeno SSL certifikata
* Preverite gostitelja in istoredni element (priporočeno): potrdi domeno in izdajatelja SSL certifikata';
$string['ssoaccesscontrol'] = 'SSO nadzor dostopa';
$string['ssoacldescr'] = 'Uporabite to stran za omogočanje ali onemogočanje dostopa specifičnim uporabnikom z oddaljenih gostiteljev Moodle omrežja. To je uporabno v primeru, da ponujate SSO storitve oddaljenim uporabnikom. Za nadzor nad tem, ali imajo vaši <em>lokalni</em> uporabniki možnost povezovanja z oddaljenimi gostitelji Mnet, uporabite sistem vlog in jim dovolite možnost <em>mnetlogintoremote</em>.';
$string['ssoaclneeds'] = 'Za delovanje te funkcije morate imeti vključeno Moodle omrežje in omogočen vtičnik Mnet za preverjanje pristnosti.';
$string['strict'] = 'Strogo';
$string['subscribe'] = 'Naročite se';
$string['system'] = 'Sistem';
$string['testclient'] = 'Mnet testni odjemalec';
$string['testtrustedhosts'] = 'Preverjanje naslov';
$string['testtrustedhostsexplain'] = 'Vnesite naslov IP in preverite, če gre za zaupanja vrednega gostitelja.';
$string['theypublish'] = 'Oni objavijo';
$string['theysubscribe'] = 'Oni se naročijo';
$string['transport_help'] = 'Te možnosti so obojestranske. To pomeni, da lahko oddaljenega gostitelja prisilite k uporabi podpisanega SSL certifikata samo v primeru, da ima tudi vaš strežnik podpisan SSL certifikat.';
$string['trustedhosts'] = 'Gostitelji XML-RPC';
$string['trustedhostsexplain'] = '<p>Mehanizem zaupanja vrednih gostiteljev omogoča določenim računalnikom izvajanje klicev celotnega Moodle API prek XML-RPC. To omogoča nadzor nad vedenjem strežnika Moodle in je potencialno zelo nevarno, če je omogočeno. Če niste prepričani, da jo potrebujete, je ne vklapljajte.</p>
<p>Za uporabo Moodle omrežja ta funkcionalnost <strong>ni nujna</strong>.</p>
<p>Za vklop te funkcionalnosti vnesite seznam naslovov IP ali omrežij - po
eno v vsaki vrstici. Primeri:</p>
Vaš strežnik:<br />127.0.0.1<br />Vaš strežnik z blokado omrežja:<br />127.0.0.1/32<br />Samo strežnik z IP naslovom 192.168.0.7:<br />192.168.0.7/32<br />Vsak strežnik z IP naslovom med 192.168.0.1 in 192.168.0.255:<br />192.168.0.0/24<br />Vsak strežnik brez omejitev:<br />192.168.0.0/0<br />Zadnji primer <strong>ni</strong> je seveda priporočena konfiguracija.';
$string['turnitoff'] = 'Izklopi';
$string['turniton'] = 'Vklopi';
$string['type'] = 'Tip';
$string['unknown'] = 'Neznano';
$string['unknownerror'] = 'Neznana napaka med pogajanjem.';
$string['usercannotchangepassword'] = 'Ker ste oddaljeni uporabnik, na tej strani ne morete spremeniti gesla.';
$string['userchangepasswordlink'] = '<br /> Mogoče lahko geslo spremenite na naslovu<a href="{$a->wwwroot}/login/change_password.php">{$a->description}</a>.';
$string['usernotfullysetup'] = 'Vaš uporabniški račun je nepopoln. Iti morate <a href="{$a}">nazaj k vašemu ponudniku</a> in zagotoviti, da je vaš profil tam zaključen. Morda se boste morali odjaviti in ponovno vpisati, da bodo spremembe veljale.';
$string['usersareonline'] = 'Opozorilo: {$a} uporabnikov s tega strežnika je trenutno prijavljenih na vaše spletno mesto.';
$string['validated_by'] = 'Potrjeno s strani omrežja: &nbsp; <code>{$a}</code>';
$string['verifyhostandpeer'] = 'Preverite gostitelja in istoredni element';
$string['verifyhostonly'] = 'Preverite samo gostitelja';
$string['verifysignature-error'] = 'Preverjanje podpisa ni uspelo. Prišlo je do napake.';
$string['verifysignature-invalid'] = 'Preverjanje podpisa ni uspelo. Vsebina ne nosi vašega podpisa.';
$string['version'] = 'Različica';
$string['warning'] = 'Opozorilo';
$string['wrong-ip'] = 'Vaš naslov IP se ne ujema s tistim v naših zapisih.';
$string['xmlrpc-missing'] = 'Vaš PHP potrebuje nameščeno knjižnico XML-RPC za uporabo te funkcije.';
$string['yourhost'] = 'Vaš gostitelj';
$string['yourpeers'] = 'Vaši istoredni elementi';
