<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'hvp', language 'sl', version '4.4'.
 *
 * @package     hvp
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Dejanje';
$string['addedandupdatedpp'] = 'Dodanih {$a->%new} novih H5P knjižnic in posodobljenih {$a->%old} starih.';
$string['addedandupdatedps'] = 'Dodanih {$a->%new} novih H5P knjižnic in posodobljena {$a->%old} stara.';
$string['addedandupdatedsp'] = 'Dodana {$a->%new} nova H5P knjižnica in posodobljenih {$a->%old} starih.';
$string['addedandupdatedss'] = 'Dodana {$a->%new} nova H5P knjižnica in posodobljena {$a->%old} stara.';
$string['addednewlibraries'] = 'Dodanih {$a->%new} novih H5P knjižnic.';
$string['addednewlibrary'] = 'Dodana {$a->%new} nova H5P knjižnica.';
$string['additionalinfo'] = 'Dodatne informacije';
$string['additionallicenseinfo'] = 'Dodatne informacije o licenci';
$string['addlibraries'] = 'Dodaj knjižnice';
$string['ajaxfailed'] = 'Podatkov ni bilo mogoče naložiti.';
$string['anunexpectedsave'] = 'Prišlo je do nepričakovanega zapleta. Vsebine ni bilo mogoče shraniti.';
$string['attribution'] = 'Priznanje avtorstva 4.0';
$string['attributionnc'] = 'Priznanje avtorstva-Nekomercialno 4.0';
$string['attributionncnd'] = 'Priznanje avtorstva-Nekomercialno-Brez predelav 4.0';
$string['attributionncsa'] = 'Priznanje avtorstva-Nekomercialno-Deljenje pod enakimi pogoji 4.0';
$string['attributionnd'] = 'Priznanje avtorstva-Brez predelav 4.0';
$string['attributionsa'] = 'Priznanje avtorstva-Deljenje pod enakimi pogoji 4.0';
$string['author'] = 'Avtor';
$string['authorcomments'] = 'Komentarji avtorja';
$string['authorcommentsdescription'] = 'Komentar uredniku vsebin (ta zapis ne bo objavljen kot del informacij o avtorskih pravicah)';
$string['authorname'] = 'Ime avtorja';
$string['authorrole'] = 'Vloga avtorja';
$string['by'] = 'od';
$string['cancellabel'] = 'Prekliči';
$string['ccattribution'] = 'Priznanje avtorstva (CC BY)';
$string['ccattributionnc'] = 'Priznanje avtorstva-Nekomercialno (CC BY-NC)';
$string['ccattributionncnd'] = 'Priznanje avtorstva-Nekomercialno-Brez predelav (CC BY-NC-ND)';
$string['ccattributionncsa'] = 'Priznanje avtorstva-Nekomercialno-Deljenje pod enakimi pogoji (CC BY-NC-SA)';
$string['ccattributionnd'] = 'Priznanje avtorstva-Brez predelav (CC BY-ND)';
$string['ccattributionsa'] = 'Priznanje avtorstva-Deljenje pod enakimi pogoji (CC BY-SA)';
$string['ccpdd'] = 'Javna domena (CC0)';
$string['ccpdm'] = 'Oznaka javne domene (PDM)';
$string['changedby'] = 'Spremenjeno s strani';
$string['changedescription'] = 'Opis spremembe';
$string['changelog'] = 'Dnevnik sprememb';
$string['changeplaceholder'] = 'Slika obrezana, besedilo spremenjeno itd.';
$string['close'] = 'Zapri';
$string['confirmdialogbody'] = 'Prosimo, potrdite, če želite nadaljevati. To dejanje ni povratno.';
$string['confirmdialogheader'] = 'Potrdi dejanje';
$string['confirmlabel'] = 'Potrdi';
$string['connectionlost'] = 'Povezava je bila izgubljena. Rezultati bodo shranjeni in poslani takrat, ko se bo povezava vnovič vzpostavila.';
$string['connectionreestablished'] = 'Povezava ponovno vzpostavljena.';
$string['contentchanged'] = 'Ta vsebina je bila spremenjena, odkar ste jo zadnjič uporabljali.';
$string['contentcopied'] = 'Vsebina kopirana v odložišče';
$string['contentstatefrequency'] = 'Shrani pogostost stanja vsebine';
$string['contentstatefrequency_help'] = 'Kako pogosto želite, da se uporabnikom samodejno shrani njihov napredek (v sekundah)? Povečajte to število, če imate težave s številčnostjo AJAX zahtevkov';
$string['contenttype'] = 'Tip vsebine';
$string['contenttypecacheheader'] = 'Predpomnilnik tipa vsebin';
$string['copyright'] = 'Pravice do uporabe';
$string['copyrightinfo'] = 'Informacije o avtorskih pravicah';
$string['copyrightstring'] = 'Avtorske pravice';
$string['copyrighttitle'] = 'Preglej informacije o avtorskih pravicah.';
$string['couldnotcopy'] = 'Datoteke ni mogoče kopirati.';
$string['couldnotparsejsonfromzip'] = 'Ni bilo mogoče prebrati JSON podatkov iz arhiva: %fileName';
$string['couldnotparsepostdata'] = 'Ni bilo mogoče prebrati podatkov objave.';
$string['couldnotreadfilefromzip'] = 'Ni bilo mogoče prebrati datoteke iz arhiva: %fileName';
$string['couldnotsave'] = 'Datoteke ni mogoče shraniti.';
$string['create'] = 'Ustvari';
$string['creativecommons'] = 'Creative Commons';
$string['ctcachebuttonlabel'] = 'Posodobi predpomnilnik tipa vsebin';
$string['ctcacheconnectionfailed'] = 'Komunikacija s središčem H5P Hub ni mogoča. Prosimo, poskusite kasneje.';
$string['ctcachedescription'] = 'Posodobljen predpomnilnik tipa vsebin bo zagotovil ogled, prenos in uporabo najnovejših knjižnic. To ni enako kot posodabljanje knjižnic samih.';
$string['ctcachelastupdatelabel'] = 'Zadnja posodobitev';
$string['ctcacheneverupdated'] = 'Nikoli';
$string['ctcachenolibraries'] = 'S središča H5P Hub ni bil prejet noben tip vsebine. Prosimo, poskusite kasneje.';
$string['ctcachesuccess'] = 'Knjižnica se je uspešno posodobila!';
$string['ctcachetaskname'] = 'Posodobi predpomnilnik tipa vsebin';
$string['currentpage'] = 'Stran $current od $total';
$string['dataviewreportlabel'] = 'Poglej odgovore';
$string['date'] = 'Datum';
$string['disablefileextensioncheck'] = 'Onemogoči preverjanje končnic datotek';
$string['disablefileextensioncheckwarning'] = 'Opozorilo! Z onemogočanjem preverjanja končnic datotek vplivate na varnost vašega spletnega mesta, saj dovoljujete tudi nalaganje "php" datotek. Slednje omogočijo napadalcem izvajanje zlonamerne kode, zato se prepričajte, da točno veste, kaj delate.';
$string['disablefullscreen'] = 'Prepreči celozaslonski način';
$string['disablehubconfirmationmsg'] = 'Ali še vedno želite omogočiti središče H5P Hub?';
$string['disablehubdescription'] = 'Priporočamo, da to možnost omogočite. Središče H5P Hub omogoča enostavno pridobivanje novih in posodabljanje obstoječih tipov vsebin. V prihodnosti bo tudi olajšalo skupno rabo in ponovno uporabo vsebine. Če je ta možnost onemogočena, boste morali tipe vsebin nameščati in posodabljati z obrazci za nalaganje datotek.';
$string['displayoptionalwaysshow'] = 'Vedno pokaži';
$string['displayoptionauthoroff'] = 'Nadzorovano s strani avtorja - primarno onemogočeno';
$string['displayoptionauthoron'] = 'Nadzorovano s strani avtorja - primarno omogočeno';
$string['displayoptiondownloadalways'] = 'Vedno';
$string['displayoptiondownloadnever'] = 'Nikoli';
$string['displayoptiondownloadpermission'] = 'Samo, če ima uporabnik pravice za izvoz H5P vsebin.';
$string['displayoptionnevershow'] = 'Nikoli ne pokaži';
$string['displayoptionpermissions'] = 'Pokaži samo, če ima uporabnik pravice za izvoz H5P vsebin';
$string['displayoptionpermissionsembed'] = 'Pokaži samo, če ima uporabnik pravice za vdelavo H5P vsebin';
$string['displayoptions'] = 'Možnosti prikaza';
$string['download'] = 'Prenesi';
$string['downloadfailed'] = 'Prenos zahtevane knjižnice ni uspel.';
$string['downloadtitle'] = 'Prenesi vsebino kot datoteko H5P.';
$string['editor'] = 'Urejevalnik';
$string['embed'] = 'Vdelaj';
$string['embedloginfailed'] = 'Nimate dostopa do vsebin. Poskusite se prijaviti.';
$string['embedtitle'] = 'Ogled kode za vdelavo te vsebine.';
$string['empty'] = 'Rezultati niso na voljo';
$string['enableabout'] = 'Gumb "Več o H5P"';
$string['enablecopyright'] = 'Gumb "Avtorske pravice"';
$string['enabledlrscontenttypes'] = 'Omogoči LRS odvisne tipe vsebin';
$string['enabledlrscontenttypes_help'] = 'Omogoča uporabo tipov vsebin, ki se za pravilno delovanje nanašajo na LRS (ang. Learning Record Store). Takšen tip vsebin so na primer vprašalniki.';
$string['enabledownload'] = 'Gumb za prenos vsebin';
$string['enableembed'] = 'Gumb za vdelavo vsebin';
$string['enableframe'] = 'Prikaži akcijsko vrstico in okvir';
$string['enablehublabel'] = 'Uporabi središče H5P Hub';
$string['enablejavascript'] = 'Prosimo, omogočite JavaScript.';
$string['enablesavecontentstate'] = 'Shrani stanje vsebine';
$string['enablesavecontentstate_help'] = 'Samodejno shrani stanje interaktivne vsebine uporabnika. Uporabnik bo lahko nadaljeval, kjer je končal.';
$string['failedtodownloadh5p'] = 'Zahtevane datoteke H5P ni bilo mogoče prenesti.';
$string['fileexceedsmaxsize'] = 'Datoteka znotraj arhiva presega največjo dovoljeno velikost. (%file %used > %max)';
$string['filenotfoundonserver'] = 'Datoteke ni mogoče najti na strežniku. Preverite nastavitve nalaganja.';
$string['filenotimage'] = 'Datoteka ni slika.';
$string['filetypenotallowed'] = 'Nedovoljen tip datoteke.';
$string['finished'] = 'Končano';
$string['fullscreen'] = 'Celozaslonski način';
$string['gpl'] = 'Splošno dovoljenje GNU (različica št. 3)';
$string['h5pfile'] = 'Datoteka H5P';
$string['h5ptitle'] = 'Za ogled ostalih zanimivih vsebin obiščite spletno stran "H5P.org".';
$string['hide'] = 'Skrij';
$string['hideadvanced'] = 'Skrij napredno';
$string['hubcommunicationdisabled'] = 'Komunikacija s središčem H5P Hub je bila onemogočena, ker ena ali več zahtev ni bilo izpolnjenih.';
$string['hubisdisabled'] = 'Središče H5P Hub je onemogočeno. Znova ga lahko omogočite v nastavitvah H5P.';
$string['hubisdisableduploadlibraries'] = 'Središče H5P Hub je onemogočeno, dokler se težava ne odpravi. Knjižnice lahko še vedno naložite na strani "Knjižnice H5P".';
$string['hubsettingsheader'] = 'Tipi vsebin';
$string['hvp:addinstance'] = 'Ustvari nove dejavnosti H5P';
$string['hvp:getcachedassets'] = 'Zahtevano za ogled dejavnosti H5P';
$string['hvp:getembedcode'] = 'Ogled H5P kode za vdelavo, če je nastavljena možnost "nadzorovano z dovoljenjem"';
$string['hvp:getexport'] = 'Prenos datoteke ".h5p", če je nastavljena možnost "nadzorovano z dovoljenjem"';
$string['hvp:installrecommendedh5plibraries'] = 'Namesti nove varne tipe vsebin, ki jih priporoča H5P.org';
$string['hvp:manage'] = 'Uredi obstoječe dejavnosti H5P';
$string['hvp:restrictlibraries'] = 'Onemogoči dostop do izbranih tipov vsebin H5P';
$string['hvp:savecontentuserdata'] = 'Shrani napredek uporabnikov za dejavnosti H5P';
$string['hvp:saveresults'] = 'Shrani rezultate za zaključene dejavnosti H5P';
$string['hvp:updatelibraries'] = 'Namesti nove tipe vsebin H5P ali posodobi obstoječe';
$string['hvp:userestrictedlibraries'] = 'Uporabi omejene tipe vsebin H5P';
$string['hvp:view'] = 'Ogled in sodelovanje v dejavnostih H5P';
$string['hvp:viewallresults'] = 'Prikaz vseh rezultatov za zaključene dejavnosti H5P';
$string['hvp:viewresults'] = 'Prikaz mojih rezultatov za zaključene dejavnosti H5P';
$string['installdenied'] = 'Nimate dovoljenja za namestitev tipov vsebin. Obrnite se na skrbnika spletnega mesta.';
$string['installedlibraries'] = 'Nameščene knjižnice';
$string['intro'] = 'Uvodna predstavitev';
$string['invalidaudioformat'] = 'Neveljaven format avdio datoteke. Uporabi MP3 ali WAV format.';
$string['invalidcontentfolder'] = 'Neveljavna mapa vsebine';
$string['invalidcontenttype'] = 'Izbran tip vsebine ni veljaven.';
$string['invalidfieldtype'] = 'Neveljaven tip polja.';
$string['invalidfile'] = 'Datoteka "{$a->%filename}" ni dovoljena. Dovoljene so le datoteke z naslednjimi končnicami: {$a->%files-allowed}.';
$string['invalidh5ppost'] = 'Do objavljene H5P vsebine ni možno dostopati.';
$string['invalidimageformat'] = 'Neveljaven format slikovne datoteke. Uporabi JPG, PNG ali GIF format.';
$string['invalidlanguagefile'] = 'Neveljavna jezikovna datoteka {$a->%file} v knjižnici {$a->%library}';
$string['invalidlanguagefile2'] = 'V knjižnico {$a->%name} je bila vključena neveljavna jezikovna datoteka {$a->%languageFile}';
$string['invalidlibrary'] = 'Neveljavna knjižnica';
$string['invalidlibrarydata'] = 'V {$a->%library} so navedeni neveljavni podatki za {$a->%property}';
$string['invalidlibrarydataboolean'] = 'V {$a->%library} so navedeni neveljavni podatki za {$a->%property}. Pričakovani so logični operatorji.';
$string['invalidlibraryname'] = 'Neveljavno ime knjižnice: {$a->%name}';
$string['invalidlibrarynamed'] = 'Knjižnica {$a->%library}, ki je uporabljena v vsebini, ni veljavna';
$string['invalidlibraryoption'] = 'Neveljavna izbira {$a->%option} v {$a->%library}';
$string['invalidlibraryproperty'] = 'Lastnosti {$a->%property} v {$a->%library} ni mogoče prebrati';
$string['invalidmainjson'] = 'Veljavna glavna datoteka "h5p.json" manjka';
$string['invalidmultiselectoption'] = 'Neveljavna izbira v možnosti "multi-select".';
$string['invalidparameters'] = 'Neveljavni parametri';
$string['invalidselectoption'] = 'Neveljavna izbira v možnosti "select".';
$string['invalidsemanticsjson'] = 'V knjižnico {$a->%name} je bila vključena neveljavna datoteka "semantics.json"';
$string['invalidsemanticstype'] = 'Notranja napaka v H5P: v semantiki je neznan tip vsebine "{$a->@type}". Odstranjevanje vsebine!';
$string['invalidstring'] = 'Dani niz ni veljaven glede na regexp v semantiki. (vrednost: \\"{$a->%value}\\", regexp: \\"{$a->%regexp}\\")';
$string['invalidtoken'] = 'Neveljaven varnostni žeton.';
$string['invalidvideoformat'] = 'Neveljaven format video datoteke. Uporabi MP4 ali WEBM format.';
$string['invalidxapiresult'] = 'Za dano kombinacijo ID-ja vsebine in uporabnika ni bilo najdenih rezultatov xAPI';
$string['javascriptloading'] = 'JavaScript se še izvaja ...';
$string['libraries'] = 'Knjižnice H5P';
$string['librarydirectoryerror'] = 'Knjižnični imenik se mora ujemati z machineName ali machineName-majorVersion.minorVersion (iz library.json). (Imenik: {$a->%directoryName} , machineName: {$a->%machineName}, majorVersion: {$a->%majorVersion}, minorVersion: {$a->%minorVersion})';
$string['librarylistactions'] = 'Dejanja';
$string['librarylistinstancedependencies'] = 'Primeri odvisnosti';
$string['librarylistinstances'] = 'Primeri';
$string['librarylistlibrarydependencies'] = 'Odvisnosti knjižnic';
$string['librarylistrestricted'] = 'Omejeno';
$string['librarylisttitle'] = 'Naslov';
$string['librarynotselected'] = 'Izbrati je potrebno tip vsebine.';
$string['license'] = 'Licenca';
$string['licenseCC010'] = 'CC0 1.0 Univerzalna (CC0 1.0) Posvetilo javni domeni';
$string['licenseCC010U'] = 'CC0 1.0 Univerzalna';
$string['licenseCC10'] = '1.0 Generična';
$string['licenseCC20'] = '2.0 Generična';
$string['licenseCC25'] = '2.5 Generična';
$string['licenseCC30'] = '3.0 Nedoločena';
$string['licenseCC40'] = '4.0 Mednarodna';
$string['licenseGPL'] = 'Splošno dovoljenje GNU';
$string['licenseV1'] = 'Različica št. 1';
$string['licenseV2'] = 'Različica št. 2';
$string['licenseV3'] = 'Različica št. 3';
$string['licensee'] = 'Imetnik licence';
$string['licenseextras'] = 'Posebnosti licence';
$string['licenseversion'] = 'Različica licence';
$string['loadingdata'] = 'Nalaganje podatkov.';
$string['lookforupdates'] = 'Preveri posodobitve za H5P';
$string['maximumgrade'] = 'Najvišja ocena';
$string['maximumgradeerror'] = 'Vnesite pozitivno celo število kot največje število možnih točk, ki so na voljo za to dejavnost';
$string['maxpostsizetoosmall'] = 'Vaša dovoljena velikost prispevkov v PHP je majhna. S trenutnimi nastavitvami, ne bo mogoče naložiti datotek večjih od {$a->%number} MB. Slednje bi znalo predstavljati težavo v primeru nalaganja datotek H5P, slik ali videoposnetkov, zato razmislite o razširitvi na več kot 5 MB.';
$string['maxscore'] = 'Najvišji rezultat';
$string['maxuploadsizetoosmall'] = 'Vaša dovoljena velikost prenosov v PHP je majhna. S trenutnimi nastavitvami, ne bo mogoče naložiti datotek večjih od {$a->%number} MB. Slednje bi znalo predstavljati težavo v primeru nalaganja datotek H5P, slik ali videoposnetkov, zato razmislite o razširitvi na več kot 5 MB.';
$string['missingcontentfolder'] = 'Manjka veljavna mapa vsebine';
$string['missingcontentuserdata'] = 'Napaka: podatkov uporabnika ni bilo mogoče najti';
$string['missingcoreversion'] = 'Sistem ni mogel namestiti komponente  <em>{$a->%component}</em> iz paketa, saj je zahtevana novejša različica vtičnika H5P. To spletno mesto se trenutno izvaja na različici {$a->%current}, medtem ko je zahtevana različica {$a->%required} ali višja. Razmislite o nadgradnji in poskusite znova.';
$string['missingdependency'] = 'Manjka odvisnost {$a->@dep}, ki jo zahteva {$a->@lib}.';
$string['missinglibrary'] = 'Manjka zahtevana knjižnica {$a->@library}';
$string['missinglibraryfile'] = 'Datoteke "{$a->%file}" ni mogoče najti v knjižnici "{$a->%name}"';
$string['missinglibraryjson'] = 'Datoteke "library.json" v veljavnem formatu "json" ni mogoče najti v knjižnici {$a->%name}';
$string['missinglibraryproperty'] = 'Zahtevana lastnost {$a->%property} manjka za knjižnico {$a->%library}';
$string['missingmbstring'] = 'PHP razširitev "mbstring" ni naložena. H5P jo potrebuje za pravilno delovanje';
$string['missingparameters'] = 'Manjkajo parametri';
$string['missinguploadpermissions'] = 'Upoštevajte, da knjižnice lahko obstajajo v naloženi datoteki, vendar nimate pravice za nalaganje novih knjižnic. Obrnite se na skrbnika spletnega mesta.';
$string['modulename'] = 'Interaktivna vsebina';
$string['modulename_help'] = 'Učna dejavnosti H5P omogoča ustvarjanje interaktivnih vsebin, kot so interaktivni videoposnetki, kartice dialogov, vprašanja povleci in spusti, vprašanja z več izbirami, predstavitve in še veliko več.

Ob možnosti avtorskega ustvarjanja bogatih vsebin, vam H5P omogoča tudi uvoz in izvoz datotek H5P za učinkovito ponovno uporabo ali deljenje vsebine z drugimi uporabniki.

Uporabniške interakcije in rezultati se spremljajo z uporabo xAPI in so na voljo tudi v Moodlovi redovalnici. Upoštevajte le, da trenutna različica ne preprečuje goljufanja, zato uporaba modula H5P ni priporočljiva za izvedbo izpitov ali podobnih aktivnosti.

Interaktivno vsebino H5P dodate tako, da jo ustvarite z vgrajenim orodjem ali uvozite že pripravljene datoteke H5P, ki jih najdete na drugih mestih s podporo za H5P.';
$string['modulename_link'] = 'https://h5p.org/moodle-more-help';
$string['modulenameplural'] = 'Interaktivna vsebina';
$string['nextpage'] = 'Naslednja stran';
$string['noanswersubmitted'] = 'Ta uporabnik še ni oddal odgovora na vsebino v H5P';
$string['nocontent'] = 'Datoteke "content.json" ni bilo mogoče najti ali razčleniti';
$string['nocontenttype'] = 'Tip vsebine ni bil podan.';
$string['nocopyright'] = 'Informacije o avtorskih pravicah za to vsebino niso na voljo.';
$string['nodata'] = 'Na voljo ni podatkov, ki bi ustrezali izbranim kriterijem.';
$string['noextension'] = 'Naložena datoteka ni veljaven paket HTML5. Nima končnice ".h5p".';
$string['noh5ps'] = 'Za to učno enoto ni na voljo interaktivne vsebine.';
$string['nojson'] = 'Glavna datoteka "h5p.json" ni veljavna';
$string['nombstringexteension'] = 'PHP razširitev "mbstring" ni naložena. Ta razširitev je potrebna za pravilno delovanje H5P.';
$string['noparameters'] = 'Ni parametrov';
$string['noparse'] = 'Glavne datoteke "h5p.json" ni bilo mogoče razčleniti';
$string['nopermissiontogettranslations'] = 'Nimate dovoljenja za prevajanje.';
$string['nopermissiontorestrict'] = 'Nimate dovoljenja za omejevanje knjižnic.';
$string['nopermissiontosavecontentuserdata'] = 'Nimate dovoljenja za shranjevanje uporabnikovih podatkov vsebine.';
$string['nopermissiontosaveresult'] = 'Nimate dovoljenja za shranjevanje rezultatov za to vsebino.';
$string['nopermissiontoupgrade'] = 'Nimate dovoljenja za nadgradnjo knjižnic.';
$string['nopermissiontouploadcontent'] = 'Nimate dovoljenja za nalaganje vsebine na tem mestu.';
$string['nopermissiontouploadfiles'] = 'Nimate dovoljenja za nalaganje datotek na tem mestu.';
$string['nopermissiontoviewcontenttypes'] = 'Nimate dovoljenja za ogled tipov vsebin.';
$string['nopermissiontoviewresult'] = 'Nimate dovoljenja za ogled rezultatov za to vsebino.';
$string['nosuchlibrary'] = 'Knjižnica ne obstaja';
$string['notapplicable'] = 'Ni na voljo';
$string['nounzip'] = 'Naložena datoteka ni veljaven paket HTML5. Ni ga mogoče razširiti.';
$string['noversionattribution'] = 'Priznanje avtorstva';
$string['noversionattributionnc'] = 'Priznanje avtorstva-Nekomercialno';
$string['noversionattributionncnd'] = 'Priznanje avtorstva-Nekomercialno-Brez predelav';
$string['noversionattributionncsa'] = 'Priznanje avtorstva-Nekomercialno-Deljenje pod enakimi pogoji';
$string['noversionattributionnd'] = 'Priznanje avtorstva-Brez predelav';
$string['noversionattributionsa'] = 'Priznanje avtorstva-Deljenje pod enakimi pogoji';
$string['nowriteaccess'] = 'Zaznana je bila težava strežnika z dostopom za pisanje. Poskrbite, da bo strežnik lahko pisal v vašo podatkovno mapo.';
$string['noziparchive'] = 'Vaša različica PHP ne podpira funkcije ZipArchive.';
$string['offlinedialogbody'] = 'Vaših podatkov o dokončanju naloge ni bilo mogoče poslati. Prosimo, preverite povezavo s spletom.';
$string['offlinedialogheader'] = 'Vaša povezava s strežnikom je bila prekinjena';
$string['offlinedialogretrybuttonlabel'] = 'Poskusi ponovno';
$string['offlinedialogretrymessage'] = 'Ponovno poskušanje v :num....';
$string['offlinesuccessfulsubmit'] = 'Podatki uspešno posredovani';
$string['oldphpversion'] = 'Vaša različica PHP je zastarela. H5P za delovanje potrebuje vsaj različico 5.2, priporočena pa je različica 5.6 ali novejša.';
$string['olduploadoldcontent'] = 'Poskušate naložiti vsebino starejše različice H5P. Poskusite ponovno, ko boste nadgradili strežnik, na katerem je bila vsebina, ali omogočite središče H5P Hub za samodejno nadgradnjo.';
$string['onlyupdate'] = 'Posodobi le obstoječe knjižnice';
$string['options'] = 'Možnosti';
$string['originator'] = 'Izvirnik';
$string['pd'] = 'Javna domena';
$string['pddl'] = 'Posvetilo javni domeni in licenca';
$string['pdm'] = 'Oznaka javne domene';
$string['pluginadministration'] = 'H5P';
$string['pluginname'] = 'H5P';
$string['postmessagerequired'] = 'Za dostop do zaključka je potrebno oddati sporočilo';
$string['previouspage'] = 'Prejšnja stran';
$string['privacy:metadata:core_files'] = 'Dejavnost H5P shranjuje datoteke, ki so bile naložene kot del vsebine H5P.';
$string['privacy:metadata:core_grades'] = 'Dejavnost H5P shranjuje ocene uporabnikov, ki so odgovorili na vsebino H5P.';
$string['privacy:metadata:hvp_content_user_data'] = 'Opisuje trenutno stanje, v katerem je vsebina uporabnika. Uporablja se za obnovitev vsebine v prejšnje stanje.';
$string['privacy:metadata:hvp_content_user_data:data'] = 'Shranjeni podatki uporabnika.';
$string['privacy:metadata:hvp_content_user_data:data_id'] = 'Identifikator tipa podatkov.';
$string['privacy:metadata:hvp_content_user_data:delete_on_content_change'] = 'Zastavica označuje predlog izbrisa podatkov, ko se je spremenila vsebina.';
$string['privacy:metadata:hvp_content_user_data:hvp_id'] = 'ID H5P vsebine, ki ji pripadajo podatki.';
$string['privacy:metadata:hvp_content_user_data:id'] = 'ID razmerja med vsebino uporabniških podatkov.';
$string['privacy:metadata:hvp_content_user_data:preloaded'] = 'Zastavica označuje predlog prednaložitve podatkov v vsebino.';
$string['privacy:metadata:hvp_content_user_data:sub_content_id'] = 'Podvsebina H5P. "0", če ne gre za podvsebino.';
$string['privacy:metadata:hvp_content_user_data:user_id'] = 'ID uporabnika, ki mu pripadajo podatki.';
$string['privacy:metadata:hvp_events'] = 'Sledi zabeleženim dogodkom H5P.';
$string['privacy:metadata:hvp_events:content_id'] = 'ID vsebine, kjer je bilo izvršeno dejanje. "0", če vsebine ni ali gre za novo.';
$string['privacy:metadata:hvp_events:content_title'] = 'Naslov vsebine.';
$string['privacy:metadata:hvp_events:created_at'] = 'Čas nastanka dogodka.';
$string['privacy:metadata:hvp_events:id'] = 'Edinstven ID dogodka.';
$string['privacy:metadata:hvp_events:library_name'] = 'Knjižnica, na katero je vplival dogodek.';
$string['privacy:metadata:hvp_events:library_version'] = 'Različica knjižnice, na katero je vplival dogodek.';
$string['privacy:metadata:hvp_events:sub_type'] = 'Podtip dogodka ali dejanja dogodka.';
$string['privacy:metadata:hvp_events:type'] = 'Tip dogodka.';
$string['privacy:metadata:hvp_events:user_id'] = 'ID uporabnika, ki je izvedel dejanje.';
$string['privacy:metadata:hvp_xapi_results'] = 'Hrani dogodke xAPI v vsebini H5P.';
$string['privacy:metadata:hvp_xapi_results:additionals'] = 'Dodatne informacije, ki jih lahko pošlje H5P.';
$string['privacy:metadata:hvp_xapi_results:content_id'] = 'ID vsebine, na kateri je bil izveden dogodek.';
$string['privacy:metadata:hvp_xapi_results:correct_responses_pattern'] = 'Vzorec pravilnega odgovora.';
$string['privacy:metadata:hvp_xapi_results:description'] = 'Opis, opravilo ali vprašanje vsebine, na kateri je bilo dejanje izvedeno.';
$string['privacy:metadata:hvp_xapi_results:id'] = 'Edinstven ID dogodka xAPI.';
$string['privacy:metadata:hvp_xapi_results:interaction_type'] = 'Tip interakcije.';
$string['privacy:metadata:hvp_xapi_results:max_score'] = 'Najvišji možni rezultat za dogodek.';
$string['privacy:metadata:hvp_xapi_results:parent_id'] = 'ID nadrejene vsebine, na kateri je bil izveden dogodek . "Null", če ni nadrejene vsebine.';
$string['privacy:metadata:hvp_xapi_results:raw_score'] = 'Dosežen rezultat za dogodek.';
$string['privacy:metadata:hvp_xapi_results:response'] = 'Odziv, ki ga je uporabnik poslal.';
$string['privacy:metadata:hvp_xapi_results:user_id'] = 'ID uporabnika, ki je izvedel dejanje.';
$string['question'] = 'Vprašanje';
$string['removeoldlogentries'] = 'Odstrani stare vnose dnevnika H5P';
$string['removeoldmobileauthentries'] = 'Odstrani stare vnose za mobilno avtorizacijo H5P';
$string['removetmpfiles'] = 'Odstrani stare začasne datoteke H5P';
$string['reportingquestionsremaininglabel'] = 'preostala neocenjena vprašanja';
$string['reportingscaledscoredelimiter'] = ',';
$string['reportingscaledscorelabel'] = 'Rezultat v redovalnici:';
$string['reportingscoredelimiter'] = 'od';
$string['reportingscorelabel'] = 'Rezultat:';
$string['reportnotsupported'] = 'Ni podprto';
$string['reportsubmitgradelabel'] = 'Objavi oceno';
$string['resizescript'] = 'Vključite to skripto na svojo spletno stran, če želite dinamično določanje velikosti vdelane vsebine:';
$string['resubmitscores'] = 'Poskus posredovanja shranjenih podatkov.';
$string['reuse'] = 'Ponovno uporabi';
$string['reusecontent'] = 'Ponovno uporabi vsebino';
$string['reusedescription'] = 'Ponovno uporabi to vsebino';
$string['reveal'] = 'Razkrij';
$string['reviseserversetupandretry'] = 'Ko boste preverili nastavitve strežnika, lahko v nastavitvah H5P znova omogočite komunikacijo s središčem H5P Hub.';
$string['score'] = 'Rezultat';
$string['search'] = 'Išči';
$string['sendusagestatistics'] = 'Prispevaj statistične podatke o uporabi';
$string['sendusagestatistics_help'] = 'Statistični podatki o uporabi bodo samodejno poslani razvijalcem. Na podlagi podatkov bodi ti lažje razumeli načine uporabe H5P in določili področja izboljšav. O vrsti podatkov, ki se zbirajo, lahko več preberete <a {$a}>na h5p.org</a>.';
$string['settings'] = 'Nastavitve H5P';
$string['showadvanced'] = 'Pokaži napredne možnosti';
$string['showless'] = 'Prikaži manj ...';
$string['showmore'] = 'Prikaži več ...';
$string['sitecouldnotberegistered'] = 'Spletnega mesta ni bilo mogoče registrirati v središču H5P Hub. Obrnite se na skrbnika.';
$string['sitekey'] = 'Ključ spletnega mesta';
$string['sitekeydescription'] = 'Ključ spletnega mesta je geslo, ki enolično identificira to spletno mesto s središčem H5P Hub.';
$string['sitekeyregistered'] = 'Prejeli ste edinstven ključ, ki vas identificira s središčem H5P Hub ob novih posodobitvah. Ogled ključa je na voljo na strani »Nastavitve H5P«.';
$string['size'] = 'Velikost';
$string['source'] = 'Vir';
$string['sslnotenabled'] = 'Vaš strežnik ne omogoča SSL. Ta mora biti omogočen, da zagotovi varno povezavo s središčem H5P Hub.';
$string['startingover'] = 'Začeli boste ponovno.';
$string['sublevel'] = 'Podstopnja';
$string['successfullyregisteredwithhub'] = 'Vaše spletno mesto je bilo uspešno registrirano v središču H5P Hub.';
$string['thumbnail'] = 'Predogledna sličica';
$string['title'] = 'Naslov';
$string['unabletocreatedir'] = 'Imenika ni mogoče ustvariti.';
$string['unabletogetfieldtype'] = 'Tipa polja ni mogoče dobiti.';
$string['undisclosed'] = 'Neobjavljeno';
$string['unpackedfilesexceedsmaxsize'] = 'Skupna velikost datotek razširjenega arhiva presega največjo dovoljeno velikost. (%used > $max)';
$string['updatedlibraries'] = 'H5P knjižnice {$a->%old} so posodobljene.';
$string['updatedlibrary'] = 'Posodobljenih {$a->%old} H5P knjižnic.';
$string['updatelibraries'] = 'Posodobitev vseh knjižnic';
$string['upgrade'] = 'Nadgradnja H5P';
$string['upgradebuttonlabel'] = 'Nadgradnja';
$string['upgradedone'] = 'Uspešno ste nadgradili naslednje število primerov vsebin: {$a}.';
$string['upgradeerror'] = 'Pri obdelavi parametrov je prišlo do napake:';
$string['upgradeerrorcontent'] = 'Vsebine ni mogoče nadgraditi %id:';
$string['upgradeerrordata'] = 'Podatkov za knjižnico %lib ni bilo mogoče naložiti.';
$string['upgradeerrormissinglibrary'] = 'Manjka zahtevana knjižnica %lib.';
$string['upgradeerrornotsupported'] = 'Neveljavni parametri %used.';
$string['upgradeerrorparamsbroken'] = 'Parametri so neveljavni.';
$string['upgradeerrorscript'] = 'Skripte nadgradenj ni bilo mogoče naložiti za %lib.';
$string['upgradeerrortoohighversion'] = 'Parametri vsebujejo %used, medtem ko so podprti le %supported ali predhodni.';
$string['upgradeheading'] = 'Nadgradi vsebino {$a}';
$string['upgradeinprogress'] = 'Nadgradnja na %ver ...';
$string['upgradeinvalidtoken'] = 'Napaka: Neveljaven varnostni žeton!';
$string['upgradelibrarycontent'] = 'Nadgradi vsebino knjižnice';
$string['upgradelibrarymissing'] = 'Napaka: manjka knjižnica!';
$string['upgrademessage'] = 'Nadgradili boste {$a} primere vsebine. Izberite različico nadgradnje.';
$string['upgradenoavailableupgrades'] = 'Posodobitve za to knjižnico niso na voljo.';
$string['upgradenothingtodo'] = 'Za nadgradnjo ni na voljo novih primerov vsebine.';
$string['upgradereturn'] = 'Nazaj';
$string['upload'] = 'Naloži';
$string['uploadlibraries'] = 'Naloži knjižnice';
$string['uploadsizelargerthanpostsize'] = 'V vašem PHP je največja dovoljena velikost nalaganja večja od dovoljenega obsega objav. Ta nastavitev pogosto povzroča težave.';
$string['user'] = 'Uporabnik';
$string['validatingh5pfailed'] = 'Preverjanje veljavnosti paketa H5P ni uspelo.';
$string['validationfailed'] = 'Zahtevani H5P ni bil veljaven';
$string['viewreportlabel'] = 'Poročilo';
$string['welcomecommunity'] = 'Upamo, da boste v H5P uživali in da se boste vključili tudi v našo skupnost, ki nastaja ob podpori <a {$a->forums}>forumov</a>.';
$string['welcomecontactus'] = '<a {$a}>Pišite nam</a>, če imate kakršnekoli povratne informacije. Sporočila vzamemo zelo resno, saj si prizadevamo, da bi bil H5P vsak dan boljši!';
$string['welcomegettingstarted'] = 'Pred začetkom uporabe H5P v Moodlu vam svetujemo ogled naših <a {$a->moodle_tutorial}>vodičev</a>. Za navdih vam bodo tudi <a {$a->example_content}>primeri vsebin</a> na H5P.org.';
$string['welcomeheader'] = 'Dobrodošli v svetu H5P!';
$string['wrongversion'] = 'V tej vsebini uporabljena različica knjižnice {$a->%machineName} ni veljavna. Vsebina vsebuje {$a->%contentLibrary}, morala pa bi {$a->%semanticsLibrary}.';
$string['year'] = 'Leto';
$string['years'] = 'Let/-a';
$string['yearsfrom'] = 'Let (od)';
$string['yearsto'] = 'Let (do)';
