<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_boost_magnific', language 'ru', version '4.3'.
 *
 * @package     theme_boost_magnific
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['background_color'] = 'Цвет фона';
$string['background_color_desc'] = 'Цвет фона верхнего и нижнего колонтитулов';
$string['background_color_random'] = 'Случайная тема {$a}';
$string['background_text_color'] = 'Цвет текста';
$string['background_text_color_desc'] = 'Цвет верхнего и нижнего колонтитулов';
$string['choosereadme'] = 'Boost Magnific — это тема, созданная с желанием привнести яркие цвета в Moodle.';
$string['contact_address'] = 'Адрес';
$string['contact_email'] = 'Электронная почта';
$string['contact_phone'] = 'Телефон';
$string['content_type_default'] = 'Стандартный Moodle';
$string['content_type_empty'] = '(Нет контента)';
$string['content_type_footer'] = 'Тип контента для нижнего колонтитула';
$string['content_type_footer_desc'] = 'Выберите тип контента, который хотите отображать в нижнем колонтитуле.';
$string['content_type_home'] = 'Тип контента для главной страницы';
$string['content_type_home_desc'] = 'Выберите тип контента, который хотите отображать на главной странице.';
$string['content_type_html'] = 'Страница, которую нужно создать с помощью редактора';
$string['continuar'] = 'Продолжить учебу';
$string['countlesson'] = '{$a} урок';
$string['countlessons'] = '{$a} уроков';
$string['course_access'] = 'Доступ к курсу';
$string['course_moore'] = 'Подробнее';
$string['customcss'] = 'Пользовательский CSS';
$string['customcss_desc'] = 'Любые CSS-правила, которые вы добавите в эту текстовую область, будут применяться ко всем страницам, что облегчает настройку этой темы.';
$string['custommenuitems'] = 'Пользовательские элементы верхнего меню';
$string['custommenuitems_desc'] = 'Вы можете создать собственное меню рядом с верхними меню. Главное меню должно начинаться от края, а подменю должны быть предварены дефисом (-). Количество дефисов определяет глубину элемента. Таким образом, элементы с одним дефисом появляются в подменю ниже предыдущего элемента верхнего уровня, а элементы с двумя дефисами появляются в подменю ниже предыдущего подменю.
Содержимое каждого пункта меню должно состоять из трех элементов (<strong>метка</strong> | <strong>ссылка</strong> | <strong>всплывающая подсказка</strong> | <strong>язык</strong>), разделенных символом "|".
<ul>
<li><strong>метка</strong>: Это текст, который будет отображаться в пункте меню. Вы должны указать метку для каждого пункта меню.</li>
<li><strong>ссылка</strong>: Это URL, по которому пользователь будет перенаправлен при нажатии на пункт меню. Это необязательно; если не указано, элемент не будет связан с ни одним URL.<br>
Другие атрибуты, такие как "target", могут быть добавлены в конец URL.</li>
<li><strong>всплывающая подсказка</strong>: Если вы укажете URL, вы также можете предоставить всплывающую подсказку для ссылки, созданной с помощью URL. Это необязательно, и если не определено, в качестве подсказки будет использоваться метка для пункта меню.</li>
<li><strong>язык</strong>: Вы можете добавить код языка (или список кодов через запятую) как четвертый элемент строки. Строка будет отображаться только в том случае, если пользователь выбрал указанный язык(и).</li>
</ul>
Ниже приведен пример того, как создать собственное меню:
<blockquote><pre>
Курсы
-Все курсы | /course/
-Мои курсы
--Пример курса
---Пример курса 7 | /course/view.php?id=7
---Пример курса 9 | /course/view.php?id=9
--Тестовый курс
---Тестовый курс 2 | /course/view.php?id=2
---Тестовый курс 5 | /course/view.php?id=5
Google
-Гугл на любом языке | https://google.com/" target="_blank
-Гугл в Мексике | https://www.google.com.mx/" target="_blank|Google Label|en
-Гугл на португальском | https://google.com.br/" target="_blank|Google Label|pt,pt_br,pt_br_kids
Страница поддержки | https://support.com/" target="_blank
</pre></blockquote>
Для Moodle с поддержкой нескольких языков, значение <strong>метки</strong> должно быть отформатировано как <strong>"langstringname,componentname"</strong>.
<blockquote><pre>
profile,moodle | /user/profile.php
messages,message | /message/index.php
</pre></blockquote>
<a href="https://docs.moodle.org/404/en/Advanced_theme_settings" target="_blank">Дополнительная информация о меню</a>';
$string['editor_link_footer'] = 'Редактировать блок нижнего колонтитула для языка {$a}';
$string['editor_link_footer_all'] = 'Редактировать блок нижнего колонтитула для всех языков';
$string['editor_link_home'] = 'Редактировать главную страницу для языка {$a}';
$string['editor_link_home_all'] = 'Редактировать главную страницу для всех языков';
$string['favicon'] = 'Фавикон';
$string['favicon_desc'] = 'Фавикон отображается рядом с заголовком страницы на вкладке браузера. Если пользователь не предоставил собственный фавикон, отображается стандартный фавикон Moodle.';
$string['fontfamily'] = 'Шрифты для текста сайта';
$string['fontfamily_desc'] = 'Выберите шрифт, который хотите использовать для текста на вашем сайте Moodle.';
$string['fontfamily_menus'] = 'Шрифты для меню';
$string['fontfamily_menus_desc'] = 'Выберите шрифт, который хотите использовать для меню на вашем сайте Moodle.';
$string['fontfamily_sitename'] = 'Шрифт для названия сайта';
$string['fontfamily_sitename_desc'] = 'Шрифт, который будет применен к названию сайта, если логотип не предоставлен.';
$string['fontfamily_title'] = 'Шрифты для заголовков';
$string['fontfamily_title_desc'] = 'Выберите шрифт, который хотите использовать для заголовков на вашем сайте Moodle.';
$string['fontpreview'] = 'Предпросмотр списка шрифтов';
$string['footer_contact_title'] = 'Заголовок блока контактов';
$string['footer_contact_title_default'] = 'Свяжитесь с нами';
$string['footer_contact_title_desc'] = 'Введите заголовок блока, который будет отображаться в нижнем колонтитуле с контактной информацией.';
$string['footer_description'] = 'Описание';
$string['footer_description_desc'] = 'Опишите ваш Moodle (что вы делаете) и эта информация будет показана под логотипом в нижнем колонтитуле Moodle';
$string['footer_frontpage_blockcourses_instructor'] = 'Показать имя преподавателя';
$string['footer_frontpage_blockcourses_instructor_desc'] = 'Если отмечено, то имена преподавателей отображаются в списке курсов.';
$string['footer_frontpage_blockcourses_text'] = 'Краткий текст, объясняющий блок «{$a}»';
$string['footer_frontpage_blockcourses_text_desc'] = 'Добавьте текст, рассказывающий о «{$a}»';
$string['footer_links_title'] = 'Заголовок блока с ссылками';
$string['footer_links_title_default'] = 'Важные ссылки';
$string['footer_show_copywriter'] = 'Показать «Сделано с ❤️»';
$string['footer_show_copywriter_desc'] = 'Снимите отметку, если хотите скрыть «Сделано с ❤️»';
$string['footer_social_title'] = 'Заголовок блока социальных ссылок';
$string['footer_social_title_default'] = 'Следите за нами в социальных сетях';
$string['footer_social_title_desc'] = 'Введите заголовок блока, который появится в нижнем колонтитуле с данными из ваших социальных сетей.';
$string['footerblink'] = 'Ссылки нижнего колонтитула';
$string['footerblink_desc'] = 'Вы можете настроить ссылки для нижнего колонтитула, чтобы они отображались в темах.<br>Каждая строка состоит из текста меню или языкового ключа или текста, URL-адреса ссылки (необязательно), разделённых вертикальными чертами. Например:<br><pre>Поддержка Moodle|https://moodle.org/support</pre>';
$string['footerblock_contact'] = 'Блок контактов';
$string['footerblock_copywriter'] = 'Сделано с ❤️';
$string['footerblock_description'] = 'Блок с описанием';
$string['footerblock_links'] = 'Блок с ссылками';
$string['footerblock_social'] = 'Социальный блок';
$string['free_name'] = 'Бесплатно';
$string['frontpage_about_description'] = 'Опишите, чем вы занимаетесь';
$string['frontpage_about_description_desc'] = 'Опишите в максимум 5 строках цель вашего Moodle';
$string['frontpage_about_enable'] = 'Включить блок «О нас»';
$string['frontpage_about_enable_desc'] = 'Если отмечено, блок «О нас» появится под баннером!';
$string['frontpage_about_info'] = 'Блок данных {$a}';
$string['frontpage_about_logo'] = 'Здесь будет показан другой логотип';
$string['frontpage_about_logo_desc'] = 'Если установлено, этот логотип будет использоваться здесь вместо логотипа вверху.<br>При отсутствии используется верхний логотип!';
$string['frontpage_about_number'] = 'Количество данных';
$string['frontpage_about_number_desc'] = 'Введите объем информации, указанный выше';
$string['frontpage_about_text'] = 'Наименование данных';
$string['frontpage_about_text_1_defalt'] = 'Курсы';
$string['frontpage_about_text_2_defalt'] = 'Преподаватели';
$string['frontpage_about_text_3_defalt'] = 'Студенты';
$string['frontpage_about_text_4_defalt'] = 'Уроки';
$string['frontpage_about_text_desc'] = 'Введите наименование данных, которое будет отображаться на главной странице';
$string['frontpage_about_title'] = 'Заголовок блока «О нас»';
$string['frontpage_about_title_default'] = 'Наше глобальное сообщество';
$string['heart'] = 'Если вам нравится эта тема, не забудьте нажать ❤️ на странице тем <a href="{$a}" target="_blank">нажмите здесь</a>';
$string['instructor'] = 'Инструктор';
$string['login_backgroundcolor'] = 'Цвет фона';
$string['login_backgroundcolor_desc'] = 'Выберите цвет фона для страницы восстановления пароля';
$string['login_backgroundfoto'] = 'Фоновое изображение';
$string['login_backgroundfoto_desc'] = 'Выберите фоновое изображение для страницы входа/восстановления пароля/создания аккаунта. Изображение по умолчанию: {$a}';
$string['login_forgot_description'] = 'Текст сбоку на странице восстановления пароля';
$string['login_forgot_description_desc'] = 'Текст, который будет отображаться только на странице восстановления пароля';
$string['login_login_description'] = 'Текст сбоку на странице входа';
$string['login_login_description_desc'] = 'Текст, который будет отображаться только на странице входа';
$string['login_signup_description'] = 'Текст сбоку на странице создания аккаунта';
$string['login_signup_description_desc'] = 'Текст, который будет отображаться только на странице создания аккаунта';
$string['login_theme'] = 'Тема входа';
$string['login_theme_block'] = 'Центральный белый блок с необязательным фоном';
$string['login_theme_desc'] = 'Выберите тему для области входа';
$string['login_theme_image_login'] = 'Фоновое изображение и вход сбоку';
$string['login_theme_imagetext_login'] = 'Фоновое изображение, текст на изображении и вход сбоку';
$string['login_theme_login'] = 'Только экран входа, без изображения сбоку';
$string['logo_color'] = 'Цветной логотип';
$string['logo_color_desc'] = 'Загрузите свой цветной логотип, если вы хотите добавить его в верхнюю часть. Этот логотип будет отображаться при прокрутке страницы, а меню будет отображаться на белом фоне.';
$string['logo_write'] = 'Логотип верхнего меню при прокрутке';
$string['logo_write_desc'] = 'Загрузите свой логотип, если хотите добавить его в верхнюю часть. Этот логотип будет отображаться при прокрутке страницы и меню будет отображаться на цветном фоне.';
$string['matricular'] = 'Записаться';
$string['mycourses_color'] = 'Цвет фона блока';
$string['mycourses_color_desc'] = 'Цвет фона для блока.';
$string['mycourses_icon'] = 'Иконка';
$string['mycourses_icon_desc'] = 'Представительная иконка для блока. Размер иконки должен быть 48x48 пикселей.';
$string['mycourses_info'] = 'Блок {$a}';
$string['mycourses_numblocos'] = 'Нет блоков';
$string['mycourses_numblocos_desc'] = 'Сколько изображений вы хотите в слайдшоу?';
$string['mycourses_numblocos_nenhum'] = 'Нет слайдов на главной странице';
$string['mycourses_title'] = 'Краткое название блока';
$string['mycourses_title_desc'] = 'Краткое и описательное название для блока.';
$string['mycourses_url'] = 'Ссылка блока';
$string['mycourses_url_desc'] = 'URL-адрес, на который нужно перейти при нажатии на блок. Это может быть внешняя ссылка или внутренняя ссылка на платформе.';
$string['pluginname'] = 'Boost Magnific';
$string['privacy:metadata'] = 'Тема Boost Magnific не сохраняет персональные данные пользователей.';
$string['settings_about_heading'] = 'О вашем Moodle';
$string['settings_css_heading'] = 'Шрифты и CSS';
$string['settings_footer_heading'] = 'Блок нижнего колонтитула';
$string['settings_icons_change_icons'] = 'Изменить стандартную иконку в списке курсов';
$string['settings_login_heading'] = 'Экран входа';
$string['settings_mycourses_heading'] = 'Блоки моих курсов';
$string['settings_slideshow_heading'] = 'Слайд-шоу';
$string['settings_theme_heading'] = 'Тема';
$string['settings_top_heading'] = 'Верхнее меню';
$string['sitefonts'] = 'Дополнительные шрифты Google';
$string['sitefonts_desc'] = 'Вставьте код @import из Google Fonts, как указано на изображении ниже. После сохранения поле "Шрифт сайта" будет обновлено, и эти шрифты появятся. Вы можете добавить несколько @import по мере необходимости.';
$string['slidecaption_desc'] = 'Введите текст подписи для слайда';
$string['slideshow_image'] = 'Изображение слайда';
$string['slideshow_image_desc'] = 'Изображение должно быть 1250px X 400px.';
$string['slideshow_info'] = 'Слайд {$a}';
$string['slideshow_numslides'] = 'Сколько изображений в слайд-шоу';
$string['slideshow_numslides_desc'] = 'Сколько изображений вы хотите в слайд-шоу?';
$string['slideshow_numslides_nenhum'] = 'Нет слайдов на главной странице';
$string['slideshow_text'] = 'Краткий описательный текст для слайда';
$string['slideshow_text_desc'] = 'Вставьте короткий текст о слайде.';
$string['slideshow_url'] = 'Ссылка для кнопки слайда';
$string['slideshow_url_desc'] = 'Вставьте ссылку назначения для кнопки изображения слайда';
$string['social_facebook'] = 'Ваш Facebook';
$string['social_facebook_desc'] = 'URL Facebook-аккаунта вашей организации.';
$string['social_instagram'] = 'Ваш Instagram';
$string['social_instagram_desc'] = 'URL Instagram-аккаунта вашей организации.';
$string['social_linkedin'] = 'Ваш Linkedin';
$string['social_linkedin_desc'] = 'URL Linkedin-аккаунта вашей организации.';
$string['social_twitter'] = 'Ваш Twitter';
$string['social_twitter_desc'] = 'URL Twitter-аккаунта вашей организации.';
$string['social_youtube'] = 'Ваш Youtube';
$string['social_youtube_desc'] = 'URL Youtube-канала вашей организации.';
$string['theme_boost_magnific_about_editbooton'] = 'Редактировать блок «О нас»';
$string['theme_boost_magnific_frontpage_bloco'] = 'Блок «{$a}»';
$string['theme_boost_magnific_frontpage_home'] = 'Блоки на главной странице';
$string['theme_boost_magnific_mycourses_editbooton'] = 'Редактировать блоки';
$string['theme_boost_magnific_slideshow_editbooton'] = 'Редактировать слайд-шоу';
$string['theme_color'] = 'Выбор цвета';
$string['theme_color-color_buttons'] = 'Цвет кнопок';
$string['theme_color-color_buttons_desc'] = 'Цвет, используемый для кнопок, придающий визуальную целостность и подчеркивающий интерактивные действия.';
$string['theme_color-color_primary'] = 'Основной цвет';
$string['theme_color-color_primary_desc'] = 'Основной цвет темы, обычно используется для выделения и акцентов.';
$string['theme_color-color_secondary'] = 'Вторичный цвет';
$string['theme_color-color_secondary_desc'] = 'Вторичный цвет, дополняющий основной цвет, используется для выделения вторичных элементов или контраста с основным цветом.';
$string['theme_color_desc'] = 'Выберите цвета текстов и кнопок Moodle или нажмите на строку ниже:';
$string['theme_color_heading'] = 'Выбор цвета для окружения';
$string['theme_color_sugestion'] = 'Предложение цвета';
$string['theme_color_sugestion_text'] = 'Нажмите на строку, чтобы применить цвет к полям ниже:';
$string['theme_login_branco'] = 'Только страница входа, без бокового изображения, с формой на белом фоне';
$string['top_color_heading'] = 'Цвет кнопки «Наверх»';
$string['top_scroll'] = 'Закрепить меню при прокрутке страницы';
$string['top_scroll_background_color'] = 'Цвет фона верхнего меню при прокрутке';
$string['top_scroll_background_color_desc'] = 'Установите цвет фона при прокрутке страницы.';
$string['top_scroll_desc'] = 'Если включено, меню будет закреплено в верхней части экрана при прокрутке страницы, обеспечивая легкий доступ к пунктам меню.';
$string['top_scroll_text_color'] = 'Цвет текста меню при прокрутке';
$string['top_scroll_text_color_desc'] = 'Установите цвет текста меню при прокрутке страницы.';
$string['vvveb_footer_contact_title_default'] = 'Свяжитесь с нами';
$string['vvveb_home_access'] = 'Доступ к курсу';
$string['vvveb_home_automatically_catalogo'] = 'Не редактируйте. Этот блок будет автоматически заменен на каталог курсов.';
$string['vvveb_home_automatically_category'] = 'Не редактируйте. Этот блок будет автоматически заменен на категории курсов.';
$string['vvveb_home_automatically_my_course'] = 'Не редактируйте. Этот блок будет автоматически заменен на курсы, на которые записан студент.';
$string['vvveb_home_automatically_popular'] = 'Не редактируйте. Этот блок будет автоматически заменен на самые популярные курсы.';
$string['vvveb_home_catalogo_heading'] = 'Каталог курсов';
$string['vvveb_home_category_heading'] = 'Категории курсов';
$string['vvveb_home_mycourses_heading'] = 'Мои курсы';
$string['vvveb_home_popular_course'] = 'Популярные курсы';
$string['vvveb_home_team_subtitle'] = 'Мы группа профессионалов, преданных своему делу';
$string['vvveb_home_team_title'] = 'Познакомьтесь с нашей командой';
