<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'hotpot', language 'da', version '4.3'.
 *
 * @package     hotpot
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abandoned'] = 'Uafsluttet';
$string['abandonhotpot'] = 'Dine resultater indtil nu vil blive gemt, men du kan ikke genoptage eller genstarte denne aktivitet senere.';
$string['activitycloses'] = 'Aktiviteten lukker';
$string['activitygrade'] = 'Aktivitetsbedømmelse';
$string['activityopens'] = 'Aktiviteten åbner';
$string['added'] = 'Tilføjet';
$string['addquizchain'] = 'Tilføj kæde af quizzer';
$string['addquizchain_help'] = 'Skal alle quizzer i en quizkæde tilføjes? **Nej**: Kun en quiz til blive føjet til kurset **Ja**: Hvis kildefilen er en **quizfil**, betragtes den som starten på en quizkæde og alle quizzer i kæden vil blive tilføjet kurset med identiske indstillinger. Hver quiz i kæden skal have et link til den næste fil i kæden. Hvis kildefilen er en **mappe**, vil alle genkendelige quizzer i mappen tilføjes kurset som en quizkæde med ens indstillinger. Er kildefilen en **enhedsfil** så som en "Hot Pot masher"-fil eller index.html, vil quizzer oplistet i enheden føjes til kurset som en kæde af quizzer med ens indstillinger.';
$string['allowpaste'] = 'Tillad indsæt';
$string['allowpaste_help'] = 'Er indstillingen aktiveret, kan studerende kopiere, indsætte og trække tekst til tekstbokse.';
$string['allowreview'] = 'Tillad gennemsyn';
$string['allowreview_help'] = 'Hvis aktiveret, kan studerende gennemse deres quizbesvarelser efter at quizzen er lukket.';
$string['attempted'] = 'Forsøgt besvaret';
$string['attemptlimit'] = 'Grænse for forsøg på besvarelse';
$string['attemptlimit_help'] = 'Det maksimale antal besvarelsesforsøg en studerende har';
$string['attemptnumber'] = 'Besvarelse nummer';
$string['attempts'] = 'Besvarelsesforsøg';
$string['attemptscore'] = 'Besvarelsesresultat';
$string['attemptsunlimited'] = 'Ubegrænsede forsøg på besvarelse';
$string['average'] = 'Gennemsnitlig';
$string['averagescore'] = 'Gennemsnitlig score';
$string['bodystylesbackground'] = 'Baggrundsfarve og billede';
$string['bodystylescolor'] = 'Tekstfarve';
$string['bodystylesfont'] = 'Skrifttypestørrelse og -familie';
$string['bodystylesmargin'] = 'Venstre og højre margin';
$string['cacherecords'] = 'HotPot-cache-poster';
$string['canrestarthotpot'] = 'Dine resultater indtil nu vil blive gemt og du kan prøve igen "{$a}" senere';
$string['canresumehotpot'] = 'Dine foreløbige resultater vil blive gemt og du kan fortsætte "{$a}" senere';
$string['checks'] = 'Tjek';
$string['checksomeboxes'] = 'Marker venligst nogle bokse';
$string['clearcache'] = 'Tøm HotPots cache';
$string['cleardetails'] = 'Ryd HotPot-data';
$string['clearedcache'] = 'HotPots cache er tømt';
$string['cleareddetails'] = 'HotPot-data er ryddet';
$string['clickreporting'] = 'Aktiver rapportering af klik';
$string['clickreporting_help'] = 'Hvis indstillingen er aktieret vil en særlig post blive gemt hver gang der klikkes på en "hint", "tip" eller "tjek"-knap. Dette gør det muligt for læreren at se en meget detaljeret rapport, der viser status på quizzen ved hvert klik. Ellers er det kun én post per besvarelse af en quiz, der gemmes';
$string['clicktrailreport'] = 'Klikspor';
$string['closed'] = 'Denne aktivitet er lukket';
$string['clues'] = 'Tip';
$string['completed'] = 'Gennemført';
$string['completioncompleted'] = 'Kræv status som gennemført';
$string['completionmingrade'] = 'Kræv minimumskarakter';
$string['completionpass'] = 'Kræv beståelseskarakter';
$string['completionwarning'] = 'Disse felter er deaktiverede hvis karaktergrænsen er "Ingen karakter" eller karaktervægtningen er "Ingen vægtning"';
$string['configbodystyles'] = 'Som udgangspunkt vil Moodles layout overskrive HotPots. Imidlertid vil de styles du vælger her blive prioriteret over Moodles layout-styles.';
$string['configenablecache'] = 'Vedligeholdelse af cachen for HotPot-quizzer kan markant øge leveringshastigheden af quizzer til de studerende.';
$string['configenablecron'] = 'Angiv de klokketimer i din tidszone HotPots cron-script kan køre';
$string['configenablemymoodle'] = 'Disse indstillinger kontrollerer om HotPot-aktiviteter vises på betjeningspanelsiden';
$string['configenableobfuscate'] = 'Sløring af tekststrenge og URL\'er i javascript-kode gør det sværere at gætte svar ved at se kilden til HTML-siden i browseren.';
$string['configenableswf'] = 'Tillad indlejring af swf-filer i HotPot-quizzer. Er indstillingen aktiveret, overskrives filter_mediaplugin_enable_swf.';
$string['configfile'] = 'Konfigurationsfil';
$string['configframeheight'] = 'Når en quiz vises i en ramme, angiver denne værdi højden i pixel af top-rammen, der indeholder Moodles navigationslinje.';
$string['configlocation'] = 'Placering af konfigurationsfil';
$string['configlockframe'] = 'Hvis denne indstilling er aktiveret, vil navigationsrammen, hvis den bruges, blive låst, så den ikke kan scrolles, ikke kan ændres i størrelse og ikke har nogen ramme.';
$string['configmaxeventlength'] = 'Hvis en HotPot har både et åbne- og lukketidspunkt og forskellen mellem de to er større end det antal dage der er angivet her, vil to separate kalenderbegivenheder blive tilføjet kursuskalenderen. For kortere varighed, eller når blot et tidspunkt er angivet, vil kun en kalenderbegivenhed blive tilføjet. Hvis ingen tid er angivet, vil der ikke blive tilføjet en begivenhed i kalenderen.';
$string['configstoredetails'] = 'Er indstillingen aktiveret, vil de rå xml-data om HotPot-quizbesvarelser gemmes i tabellen hotpot_details. Det betyder at quizbesvarelser kan revurderes fremover og reflektere ændringer i scoringssystemt. På sider med stor aktivitet vil aktivering af denne mulighed imidlertid hurtigt forårsage en hurtigt voksende hotpot_details-tabel.';
$string['confirmdeleteattempts'] = 'Bekræft at du vil slette disse besvarelser.';
$string['confirmstop'] = 'Er du sikker på at du vil forlade denne side?';
$string['correct'] = 'Rigtigt';
$string['couldnotinsertsubmissionform'] = 'Kunne ikke indsætte afleveringsformular';
$string['delay1'] = 'Forsinkelse 1';
$string['delay1_help'] = 'Minimumsforsinkelse mellem første og anden besvarelse';
$string['delay1summary'] = 'Forsinkelse mellem første og anden besvarelse';
$string['delay2'] = 'Forsinkelse 2';
$string['delay2_help'] = 'Minimumsforsinkelse mellem første og anden besvarelse';
$string['delay2summary'] = 'Forsinkelse mellem senere besvarelser';
$string['delay3'] = 'Forsinkelse 3';
$string['delay3afterok'] = 'Vent til den studerende klikker OK';
$string['delay3disable'] = 'Fortsæt ikke automatisk';
$string['delay3specific'] = 'Brug specifik forsinkelse';
$string['delay3summary'] = 'Forsinkelse i slutningen af quizzen';
$string['delay3template'] = 'Brug indstillingerne i kilde/skabelonfilen';
$string['deleteallattempts'] = 'Slet alle besvarelser';
$string['deleteattempts'] = 'Slet besvarelser';
$string['detailsrecords'] = 'HotPot-dataposter';
$string['duration'] = 'Varighed';
$string['enablecache'] = 'Aktiver HotPots cache';
$string['enablecron'] = 'Aktiver HotPots cron';
$string['enablemymoodle'] = 'Vis HotPots på MinMoodle';
$string['enableobfuscate'] = 'Aktiver tilsløring af tekst og medieafspillere';
$string['enableswf'] = 'Tillad indlejring af swf-filer i HotPots';
$string['entry_attempts'] = 'Besvarelser';
$string['entry_dates'] = 'Datoer';
$string['entry_grading'] = 'Vurdering';
$string['entry_title'] = 'Aktivitetens navn som titel';
$string['entrycm'] = 'Foregående aktivitet';
$string['entrycm_help'] = 'Denne indstilling specificerer en Moodle-aktivitet og et krævet minimumsresultat før aktiviteten kan påbegyndes.

Læreren kan vælge en bestemt aktivitet eller en af de følgende generelle indstillinger:

* Forrige aktivitet på dette kursus
* Forrige aktivitet i denne sektion
* Forrige HotPot på dette kursus
* Forrige HotPot i denne sektion';
$string['entrycmcourse'] = 'Foregående aktivitet på dette kursus';
$string['entrycmsection'] = 'Foregående aktivitet i denne kursussektion';
$string['entrycompletionwarning'] = 'Inden du starter på denne aktivitet skal du kigge på {$a}.';
$string['entrygrade'] = 'Det opnåede resultat for forrige aktivitet';
$string['entrygradewarning'] = 'Du kan ikke starte denne aktivitet før du scorer {$a->entrygrade}% på {$a->entryactivity}. I øjeblikket er du oppe på {$a->usergrade}%';
$string['entryhotpotcourse'] = 'Forrige HotPot på dette kursus';
$string['entryhotpotsection'] = 'Foregående HotPot i denne kursussektion';
$string['entryoptions'] = 'Forsideindstillinger';
$string['entryoptions_help'] = 'Her aktiveres og deaktiveres elementer på HotPot\'ens forside **Titel**: Hvis denne indstilling aktiveres vises HotPot\'ens navn som sidens titel **Vurdering**: Hvis denne indstilling aktiveres vises information om HotPots vurdering på forsiden **Datoer**: Hvis denne indstilling aktiveres vises åbne- og lukkedatoerne **Besvarelser**: Hvis denne indstilling aktiveres vises en tabel med brugerens tidligere besvarelser af denne HotPot på forsiden. Besvarelser der kan genoptages vil få en "fortsæt"-knap i kolonnen længst til højre.';
$string['entrypage'] = 'Vis en forside';
$string['entrypage_help'] = 'Skal den studerende præsenteres for en forside før HotPot-aktiviteten begynder?

**Ja**
: den studerende vil få vist en forside inden HotPot\'en starter. Indholdet bestemmes af HotPot\'s forsideindstillinger.

**Nej**
: HotPot starter med det samme, den studerende vil ikke først få vist en forside.

Læreren ser altid en forside for at give adgang til rapporter og redigering af quizsider';
$string['entrypagehdr'] = 'Forside';
$string['entrytext'] = 'Forsidetekst';
$string['event_attempt_reviewed'] = 'HotPot-besvarelse gennemset';
$string['event_attempt_reviewed_description'] = 'Brugeren med id\'et "{$a->userid}" gennemså en besvarelse på "hotpot"-aktiviteten med kursusmodul-id\'et "{$a->cmid}"';
$string['event_attempt_reviewed_explanation'] = 'En bruger har lige gennemset en HotPot-besvarelse';
$string['event_attempt_started'] = 'HotPot-besvarelse påbegyndt';
$string['event_attempt_started_description'] = 'Brugeren med id\'et "{$a->userid}" startede en besvarelse af "hotpot"-aktiviteten med kursusmodul-id\'et "{$a->cmid}"';
$string['event_attempt_started_explanation'] = 'En bruger har lige påbegyndt besvarelse af en HotPot-aktivitet';
$string['event_attempt_submitted'] = 'HotPot-besvarelse afleveret';
$string['event_attempt_submitted_description'] = 'Brugeren med id\'et "{$a->userid}" afleverede sin besvarelse af "hotpot"-aktiviteten med kursusmodul-id\'et "{$a->cmid}"';
$string['event_attempt_submitted_explanation'] = 'En bruger har lige afleveret en besvarelse af en HotPot-aktivitet';
$string['event_base_description'] = 'Brugeren med id\'et "{$a->userid}" indledte en begivenhed i "hotpot"-aktiviteten med kursusmodul-id\'et "{$a->cmid}"';
$string['event_report_viewed'] = 'HotPot-rapport set';
$string['event_report_viewed_description'] = 'Brugeren med id\'et "{$a->userid}" så en rapport over besvarelser af "hotpot"-aktiviteten med kursusmodul-id\'et "{$a->cmid}"';
$string['event_report_viewed_explanation'] = 'En bruger har lige gennemset en rapport over besvarelser af en HotPot-aktivitet';
$string['exit_areyouok'] = 'Hallo, er du der?';
$string['exit_attemptscore'] = 'Din score for denne besvarelse var {$a}';
$string['exit_course'] = 'Kursus';
$string['exit_course_text'] = 'Returner til kursets forside';
$string['exit_encouragement'] = 'Opmuntring';
$string['exit_excellent'] = 'Fremragende!';
$string['exit_feedback'] = 'Feedback afsluttende side';
$string['exit_feedback_help'] = 'Disse indstillinger aktiverer og deaktiverer feedback på en HotPot\'s afsluttende side. **Titel**: marker her hvis HotPot\'ens titel skal vises som titel på den afsluttende side. **Opmuntring**: marker her hvis den afsluttende side skal indeholde en opmuntring. Opmuntringen afhænger af HotPot-resultatet: : > 90%: Fremragende! : > 60%: Godt gået! : > 0%: Godt forsøgt! : = 0%: Hallo, er du der? **Din score for denne besvarelse var...**: marker her hvis resultatet af besvarelsen skal vises på den afsluttende side. **Din karakter for denne aktivitet er...**: marker her hvis resultatet af denne HotPot skal vises på den afsluttende side. Hvis bedømmelsesmetoden er sat til højeste resultat vil Moodle herudover fortælle om dette resultat er lige så højt eller højere end det bedste resultat i tidligere besvarelser.';
$string['exit_goodtry'] = 'Godt forsøgt!';
$string['exit_grades'] = 'Karakterer';
$string['exit_grades_text'] = 'Se dine foreløbige resultater på dette kursus';
$string['exit_hotpotgrade'] = 'Din karakter for denne aktivitet er {$a}';
$string['exit_hotpotgrade_average'] = 'Din gennemsnitlige karakter for denne aktivitet er indtil nu {$a}';
$string['exit_hotpotgrade_highest'] = 'Din højeste karakter for dene aktivitet er {$a}';
$string['exit_hotpotgrade_highest_equal'] = 'Du er nået op på din hidtidige rekord i denne aktivitet!';
$string['exit_hotpotgrade_highest_previous'] = 'Din højeste karakter for denne aktivitet indtil nu: {$a}';
$string['exit_hotpotgrade_highest_zero'] = 'Du har ikke scoret højere end {$a} for denne aktivitet endnu';
$string['exit_index'] = 'Indeks';
$string['exit_index_text'] = 'Gå til aktivitetsoversigten';
$string['exit_links'] = 'Afsluttende sides links';
$string['exit_links_help'] = 'Her aktiveres og deaktiveres navigationslinks på HotPot\'ens afsluttende side. **Prøv igen**: Hvis flere besvarelser er tilladt og den studerende har flere tilbage, vil der være et link til at gentage HotPot\'en **Indeks**: Hvis denne indstilling aktiveres vises et link til HotPots indeksside. **Kursus**: Hvis denne indstilling aktiveres vises et link til kursets forside. **Karakterbog**: Hvis denne indstilling aktiveres vises et link til Moodles karakterbog';
$string['exit_next'] = 'Næste';
$string['exit_next_text'] = 'Prøv den næste aktivitet';
$string['exit_noscore'] = 'Du har med succes gennemført denne aktivitet!';
$string['exit_retry'] = 'Prøv igen';
$string['exit_retry_text'] = 'Prøv denne aktivitet igen';
$string['exit_welldone'] = 'Godt gået!';
$string['exit_whatnext_0'] = 'Hvad vil du nu?';
$string['exit_whatnext_1'] = 'Vælg næste side...';
$string['exit_whatnext_default'] = 'Vælg venligst en af følgende:';
$string['exitcm'] = 'Næste aktivitet';
$string['exitcm_help'] = 'Denne indstilling bestemmer hvilken Moodleaktivitet der skal komme efter at denne er gennemført. Den valgfrie karakter er den minimumskarakter der kræves i denne HotPot-aktivitet før næste aktivitet vises.

En lærer kan vælge en specifik aktivitet eller en af de følgende generelle muligheder:

* Næste aktivitet på dette kursus
* Næste aktivitet i denne sektion
* Næste HotPot på dette kursus
* Næste HotPot i denne sektion

Hvis andre muligheder på den afsluttende side er deaktiverede, vil den studerende føres direkte til den næste aktivitet. Ellers vil den afsluttende side indeholde et link til den næste aktivitet når den studerende er klar.';
$string['exitcmcourse'] = 'Næste aktivitet på kurset';
$string['exitcmsection'] = 'Næste aktivitet i denne kursussektion';
$string['exithotpotcourse'] = 'Næste HotPot på kurset';
$string['exithotpotsection'] = 'Næste HotPot i denne kursussektion';
$string['exitoptions'] = 'Indstillinger for afsluttende side';
$string['exitpage'] = 'Vis afsluttende side';
$string['exitpage_help'] = 'Skal der vises en afsluttende side for den studerende efter HotPot\'en er gennemført?

**Ja**: den studerende vil få vist en afslutningsside når HotPot\'en er gennemført. Indholdet af siden bestemmes af indstillingerne for HotPots afslutningssides feedback og links.

**Nej**: den studerende vises ikke en afslutningsside. I stedet vil enten den næste aktivitet eller kursusforsiden vises.';
$string['exitpagehdr'] = 'Afsluttende side';
$string['exittext'] = 'Tekst afsluttende side';
$string['feedbackdiscuss'] = 'Debatter quizzen i et forum';
$string['feedbackformmail'] = 'Feedbackformular';
$string['feedbackmoodleforum'] = 'Forum';
$string['feedbackmoodlemessaging'] = 'Besked';
$string['feedbacknone'] = 'Ingen';
$string['feedbacksendmessage'] = 'Send en besked til din lærer';
$string['feedbackwebpage'] = 'Webside';
$string['firstattempt'] = 'Første besvarelse';
$string['forceplugins'] = 'Tving medieplugins';
$string['forceplugins_help'] = 'Hvis denne indstilling er aktiveret, vil Moodle-kompatible medieafspillere afspille filer som AVI, MPEG, MPG, mp3, mov og wmv. Ellers vil Moodle ikke ændre indstillingerne af medieafspillere i quizzen.';
$string['frameheight'] = 'Rammehøjde';
$string['giveup'] = 'Giv op';
$string['grademethod'] = 'Metode til karaktergivning';
$string['grademethod_help'] = 'Denne indstilling styrer hvordan HotPot-karakterer beregnes fra score på besvarelser. **Højeste score**: Karakteren vil sættes til højeste score for en besvarelse af denne HotPot-aktivitet. **Gennemsnitlig score**: Karakteren vil sættes til gennemsnitlig score for en besvarelse af denne HotPot-aktivitet. **Første besvarelse**: Karakteren vil sættes til scoren for den første besvarelse af denne HotPot-aktivitet.';
$string['gradeweighting'] = 'Karaktervægtning';
$string['gradeweighting_help'] = 'Denne HotPots karakterer vil blive skaleret til dette tal i Moodles karakterbog';
$string['highestscore'] = 'Højeste score';
$string['hints'] = 'Hint';
$string['hotpot:addinstance'] = 'Tilføj en ny HotPot';
$string['hotpot:attempt'] = 'Prøv en Hotpot og aflever resultaterne';
$string['hotpot:deleteallattempts'] = 'Slet alle brugeres besvarelser af en HotPot-aktiviitet';
$string['hotpot:deletemyattempts'] = 'Slet dine egne besvarelser af denne HotPot';
$string['hotpot:ignoretimelimits'] = 'Ignorerer tidsbegrænsning i en HotPot';
$string['hotpot:manage'] = 'Skift indstillinger for en HotPot-aktivitet';
$string['hotpot:preview'] = 'Forhåndsvis en HotPot-aktivitet';
$string['hotpot:reviewallattempts'] = 'Se alle brugeres besvarelser i en HotPot-aktivitet';
$string['hotpot:reviewmyattempts'] = 'Vis dine egne besvarelser af en HotPot-aktivitet';
$string['hotpot:view'] = 'Se forsiden for en HotPot';
$string['hotpotname'] = 'HotPot-navn';
$string['ignored'] = 'Ignoreret';
$string['inprogress'] = 'I gang';
$string['isgreaterthan'] = 'er større end';
$string['islessthan'] = 'er mindre end';
$string['lastaccess'] = 'Seneste adgang';
$string['lastattempt'] = 'Sidste besvarelse';
$string['lockframe'] = 'Lås frame';
$string['maxeventlength'] = 'Højeste antal dage til en enkelt kalenderbegivenhed';
$string['mediafilter_hotpot'] = 'HotPots medie-filter';
$string['mediafilter_moodle'] = 'Moodle\'s standard medie-filtre';
$string['migratingfiles'] = 'Migrering af HotPot-filer';
$string['migratinglogs'] = 'Migrerer HotPot-logs';
$string['missingsourcetype'] = 'HotPot-post mangler kildetype';
$string['modulename'] = 'HotPot';
$string['modulename_help'] = 'Med HotPot-modulet kan lærere levere interaktive undervisningsmaterialer til de studerende via Moodle og se rapporter med de studerendes svar og resultater.

En enkelt HotPot-aktivitet består af en valgfri startside, en enkelt e-lærningsøvelse og eventuelt en slutside. Øvelsen kan være en statisk eller en interaktiv webside med tekst, lyd- og/eller visuelt indhold og gemmer de studerendes svar. Øvelsen oprettes på lærerens computer med et redigeringsprogram og uploades derefter til Moodle.

En HotPot-aktivitet kan håndtere øvelser oprettet med følgende programmer:

* Hot Potatoes (version 6)
* Qedoc
* Xerte
* iSpring
* en vilkårlig HTML-editor';
$string['modulename_link'] = 'mod/hotpot/view';
$string['modulenameplural'] = 'HotPots';
$string['nameadd'] = 'Navn';
$string['nameadd_help'] = 'Navnet kan være et læreren skriver eller et automatisk genereret navn. **Brug kildefilens**: Navnet vil indlæses fra kildefilen **Brug kilde-filnavn**: Navnet kan være filnavnet på kildefilen **Brug kildefilstien**: Kildefilstien vil blive brugt. Skråstreger vil blive erstattet af mellemrum. **Specifik tekst**: Læreren kan skrive et navn.';
$string['nameedit'] = 'Navn';
$string['nameedit_help'] = 'Den specifikke tekst der vises for de studerende';
$string['navigation'] = 'Navigation';
$string['navigation_embed'] = 'Indlejret webside';
$string['navigation_frame'] = 'Moodles navigationsramme';
$string['navigation_give_up'] = 'En enkelt &quot;Giv Op&quot; knap';
$string['navigation_help'] = 'Denne indstilling bestemmer hvilken navigation der skal bruges i quizzen: **Moodles navigationslinje**: Moodles navigationslinje vises i samme vindue som quizzen øverst på siden **Moodles navigations-frame** Moodles navigationslinje vises i en separat <em>frame</em> øverst på quizzen **Indlejret webside**: Moodles navigationslinje vises med quizzen indlejret nedenunder **Oprindelige navigationsknapper**: Quizzen vil blive vist med de navigationsknapper, der måtte være defineret i quizzen **En enkelt "Giv op"-knap**: Quizzen vil blive vist med en enkelt "Giv op"-knap øverst på siden **Ingen**: Quizzen vil blive vist uden hjælp til navigation, så når alle spørgsmål er besvaret korrekt, afhængigt af indstillingen "Vis næste quiz?", vil Moodle enten returnere til kursets forside eller vise den næste quiz';
$string['navigation_moodle'] = 'Moodles standard navigationslinjer (top- og sidepanel)';
$string['navigation_none'] = 'Ingen';
$string['navigation_original'] = 'Oprindelige navigationsknapper';
$string['navigation_topbar'] = 'Kun Moodles top-navigationslinje (uden sidepanel)';
$string['noactivity'] = 'Ingen aktivitet';
$string['nohotpots'] = 'Der blev ikke fundet nogen HotPot';
$string['nomoreattempts'] = 'Beklager, du har ikke flere besvarelsesforsøg tilbage i denne aktivitet';
$string['noresponses'] = 'Der blev ikke fundet nogen information om individuelle spørgsmål og svar.';
$string['noreview'] = 'Beklager, du har ikke tilladelse til at se oplysninger om denne quizbesvarelse.';
$string['noreviewafterclose'] = 'Beklager, quizzen er lukket. Du kan ikke længere se oplysninger om denne quizbesvarelse.';
$string['noreviewbeforeclose'] = 'Beklager, du har ikke tilladelse til at se oplysninger om denne quizbesvarelse før {$a}';
$string['nosourcefilesettings'] = 'HotPot-post mangler information om kildefil';
$string['notattemptedyet'] = 'Endnu ikke forsøgt besvaret';
$string['notavailable'] = 'Desværre, aktiviteten er pt. ikke tilgængelig.';
$string['outputformat'] = 'Output-format';
$string['outputformat_best'] = 'Bedste';
$string['outputformat_help'] = 'Denne indstilling angiver i hvilket format quizzen skal vises.

Hvilke formater der er tilgængelige, afhænger af typen på kildefilen. Nogle typer har kun et output-format, andre har flere.

Indstillingen "Bedste" vil vise indholdet i det mest optimale format for den aktuelle browser.';
$string['outputformat_hp_6_jcloze_html'] = 'JCloze (v6) fra html';
$string['outputformat_hp_6_jcloze_html_findit_a'] = 'FindIt (a) fra html';
$string['outputformat_hp_6_jcloze_html_findit_b'] = 'FindIt (b) fra html';
$string['outputformat_hp_6_jcloze_xml_anctscan'] = 'ANCT-Scan fra HP6 JCloze xml';
$string['outputformat_hp_6_jcloze_xml_dropdown'] = 'DropDown fra HP6 JCloze xml';
$string['outputformat_hp_6_jcloze_xml_findit_a'] = 'FindIt (a) fra HP6 JCloze xml';
$string['outputformat_hp_6_jcloze_xml_findit_b'] = 'FindIt (b) fra HP6 JCloze xml';
$string['outputformat_hp_6_jcloze_xml_jgloss'] = 'JGloss fra HP6 JCloze xml';
$string['outputformat_hp_6_jcloze_xml_v6'] = 'JCloze (v6) fra HP6 xml';
$string['outputformat_hp_6_jcloze_xml_v6_autoadvance'] = 'JCloze (v6) fra HP6 xml (Auto-fremrykning)';
$string['outputformat_hp_6_jcross_html'] = 'JCross (v6) fra html';
$string['outputformat_hp_6_jcross_xml_v6'] = 'JCross (v6) fra xml';
$string['outputformat_hp_6_jmatch_html'] = 'JMatch (v6) fra html';
$string['outputformat_hp_6_jmatch_html_sort'] = 'JMatch Sort fra html';
$string['outputformat_hp_6_jmatch_xml_flashcard'] = 'JMatch (flashcard) fra xml';
$string['outputformat_hp_6_jmatch_xml_jmemori'] = 'JMemori fra xml';
$string['outputformat_hp_6_jmatch_xml_sort'] = 'JMatch Sort fra xml';
$string['outputformat_hp_6_jmatch_xml_v6'] = 'JMatch (v6) fra xml';
$string['outputformat_hp_6_jmatch_xml_v6_plus'] = 'JMatch (v6+) fra xml';
$string['outputformat_hp_6_jmix_html'] = 'JMix (v6) fra html';
$string['outputformat_hp_6_jmix_xml_v6'] = 'JMix (v6) fra xml';
$string['outputformat_hp_6_jmix_xml_v6_plus'] = 'JMix (v6+) fra xml';
$string['outputformat_hp_6_jmix_xml_v6_plus_deluxe'] = 'JMix (v6+ med prefix, suffix med distraktion) fra xml';
$string['outputformat_hp_6_jmix_xml_v6_plus_keypress'] = 'JMix (v6+ med tryk på tastatur) fra xml';
$string['outputformat_hp_6_jquiz_html'] = 'JQuiz (v6) fra html';
$string['outputformat_hp_6_jquiz_xml_v6'] = 'JQuiz (v6) fra xml';
$string['outputformat_hp_6_jquiz_xml_v6_autoadvance'] = 'JQuiz (v6) fra xml (Auto-fortsæt)';
$string['outputformat_hp_6_jquiz_xml_v6_exam'] = 'JQuiz (v6) fra xml (Eksamen)';
$string['outputformat_hp_6_rhubarb_html'] = 'Rhubarb (v6) fra html';
$string['outputformat_hp_6_rhubarb_xml'] = 'Rhubarb (v6) fra xml';
$string['outputformat_hp_6_sequitur_html'] = 'Sequitur (v6) fra html';
$string['outputformat_hp_6_sequitur_html_incremental'] = 'Sequitur (v6) fra html, incremental scoring';
$string['outputformat_hp_6_sequitur_xml'] = 'Sequitur (v6) fra xml';
$string['outputformat_hp_6_sequitur_xml_incremental'] = 'Sequitur (v6) fra xml, incremental scoring';
$string['outputformat_html_ispring'] = 'iSpring html-fil';
$string['outputformat_html_xerte'] = 'Xerte html-fil';
$string['outputformat_html_xhtml'] = 'Standard html-fil';
$string['outputformat_qedoc'] = 'Qedoc-fil';
$string['overviewreport'] = 'Oversigt';
$string['penalties'] = 'Stafpoint';
$string['percent'] = 'Procent';
$string['pluginadministration'] = 'HotPot-administration';
$string['pluginname'] = 'Hotpot-modul';
$string['pressoktocontinue'] = 'Tryk på OK for at fortsætte, eller Annuller hvis du vil blive på denne side.';
$string['questionshort'] = 'Q-{$a}';
$string['quizname_help'] = 'hjælpetekst til quiz-navn';
$string['quizzes'] = 'Quizzer';
$string['responses'] = 'Respons';
$string['responsesreport'] = 'Respons';
$string['reviewafterattempt'] = 'Tillad gennemsyn af besvarelse';
$string['reviewafterclose'] = 'Tillad gennemsyn efter at HotPot er lukket';
$string['reviewduringattempt'] = 'Tillad gennemsyn under besvarelse';
$string['reviewoptions'] = 'Gennemsynsmuligheder';
$string['score'] = 'Point';
$string['scoresreport'] = 'Point';
$string['selectattempts'] = 'Vælg besvarelser';
$string['showerrormessage'] = 'Hotpot-fejl: {$a}';
$string['sourcefile'] = 'Kildefilnavn';
$string['sourcefile_help'] = 'Denne indstilling styrer filen med indholdet der vises til de studerende.

Normalt vil kildefilen være oprettet udenfor Moodle og derpå uploadet til filområdet på et kursus.
Det kan være en html-fil eller en anden slags fil oprettet med redigeringssoftware så som Hot Potatoes eller Qedoc.

Kildefilen kan specificeres som en mappe og en filsti i Moodles kursusfilområde, eller det kan være en url der starter med http:// eller https://.

Mht. Qedocmaterialer skal kildefilen være en url til et Qedocmodul uploadet til Qedocserveren

* f.eks. http://www.qedoc.net/library/ABCDE_123.zip
* Se [Qedoc documentation: Uploading_modules](http://www.qedoc.org/en/index.php?title=Uploading_modules) for information om upload af Qedocmoduler';
$string['sourcefilenotfound'] = 'Kildefilen blev ikke fundet (eller den er tom): {$a}';
$string['stopbutton'] = 'Vis en stop-knap';
$string['stopbutton_help'] = 'Hvis denne indstilling er aktiveret vises en stop-knap i quizzen.

Hvis en studerende klikker på stop-knappen vil det hidtidige resultat blive gemt og status vil blive markeret som afbrudt.

Teksten på stop-knappen kan være en af de forudbestemte fraser fra Moodles sprogpakke eller læreren kan skrive sin egen tekst.';
$string['stopbutton_langpack'] = 'Fra sprogpakke';
$string['stopbutton_specific'] = 'Brug en specifik tekst';
$string['stoptext'] = 'Tekst på stop-knap';
$string['storedetails'] = 'Gem de rå xml-data om HotPot-besvarelser';
$string['studentfeedback'] = 'Feedback fra studerende';
$string['studentfeedback_help'] = 'Hvis indstillingen er aktiveret, vil et link til et pop op-vindue med feedback blive vist når den studerende klikker på "Tjek"-knappen. Feedback-vinduet giver de studerende mulighed for debattere quizzen med læreren og hinanden på en af disse måder: **Webside**: kræver URL til websiden, for eksempel http://minskole.dk/feedbackform.html **Feedback-formular**: kræver URL til formular-scriptet, for eksempel http://minskole.dk/cgi-bin/formmail.pl **Moodleforum**: forumindekset på kurset vil blive vist **Moodlebesked**: Moodles beskedvindue vil blive vist. Hvis kurset har flere lærere, vil den studerende blive bedt om at vælge en lærer før beskedvinduet vises.';
$string['submits'] = 'Afleveringer';
$string['subplugintype_hotpotattempt'] = 'Output-format';
$string['subplugintype_hotpotattempt_plural'] = 'Output-formater';
$string['subplugintype_hotpotreport'] = 'Rapport';
$string['subplugintype_hotpotreport_plural'] = 'Rapporter';
$string['subplugintype_hotpotsource'] = 'Kildefil';
$string['subplugintype_hotpotsource_plural'] = 'Kildefiler';
$string['textsourcefile'] = 'Brug kildefilens';
$string['textsourcefilename'] = 'Brug kildefilens navn';
$string['textsourcefilepath'] = 'Brug stien til kildefilen';
$string['textsourcequiz'] = 'Brug quizzens';
$string['textsourcespecific'] = 'Specifik tekst';
$string['timeclose'] = 'Tilgængelig indtil';
$string['timedout'] = 'Udløbet';
$string['timelimit'] = 'Tidsbegrænsning';
$string['timelimit_help'] = 'Her angives den maksimale varighed af en enkelt besvarelse. **Brug indstillingerne i kilde-/skabelonfilen**: varigheden vil indlæses fra kildefilen eller fra skabelonfilerne for dette format **Brug en specifik varighed**: den varighed der er bestemt i HotPots indstillinger vil blive brugt. Indstillingen overskriver tidsbegrænsningen i kildefilen, konfigurationsfilen eller skabelonfiler for dette output-format. **Deaktiver**: ingen tidsbegrænsning. Bemærk at hvis besvarelsen er genoptaget fra tidligere vil timeren fortsætte fra sidst.';
$string['timelimitexpired'] = 'Tidsbegrænsningen for denne besvarelse er udløbet';
$string['timelimitspecific'] = 'Brug en begrænset varighed';
$string['timelimitsummary'] = 'Tidsbegrænsning for en besvarelse';
$string['timelimittemplate'] = 'Brug indstillingerne i kilde-/skabelonfil';
$string['timeopen'] = 'Tilgængelig fra';
$string['timeopenclose'] = 'Åbne- og lukketider';
$string['timeopenclose_help'] = 'Du kan angive et tidsrum hvori quizzen er åben for besvarelser. Quizzen vil ikke være tilgængelig udenfor dette tidsrum.';
$string['title'] = 'Titel';
$string['title_help'] = 'Denne indstilling bestemmer websidens titel.

**HotPot-navn**
: navnet på denne HotPot vises som websidetitlen.

**Indlæs fra kildefilen**
: hvis der er angivet en titel i kildefilen vil den blive brugt som websidetitlen.

**Brug kildefilens navn**
: kildefilens navn uden mappenavne vil blive brugt som websidetitel.

**Brug kildefilens sti**
: kildefilens sti med alle mappenavne vil blive brugt som websidetitel.';
$string['unitname_help'] = 'hjælpetekst til enhedsnavn';
$string['unrecognizedsourcefile'] = 'Beklager, HotPot kunne ikke bestemme filtypen på kildefilen: {$a}';
$string['updated'] = 'Opdateret';
$string['updatinggrades'] = 'Opdaterer HotPot-karakterer';
$string['usefilters'] = 'Brug filtre';
$string['usefilters_help'] = 'Hvis denne indstilling er aktiveret, vil indholdet blive videregivet gennem Moodles filtre, før det sendes til browseren.';
$string['useglossary'] = 'Brug opslagsværk';
$string['useglossary_help'] = 'Hvis denne indstilling er aktiveret vil indholdet blive sendt gennem autolink-filteret i Moodles opslagsværk og derefter blive sendt til browseren.

Bemærk at indstillingen overskriver indstillingen for aktivering/deaktivering af autolink i opslagsværker.';
$string['usemediafilter'] = 'Anvend mediefilter';
$string['usemediafilter_help'] = 'Indstillingen styrer brugen af mediefiltre. **Intet**: indholdet vil ikke køres gennem et filter. **Moodles standard mediefiltre**: indholdet køres gennem Moodles standard mediefiltre. Disse filtre søger efter links til almindelige typer lyd- og videofiler, og konverterer dem til passende afspillere. **HotPots mediefilter**: indholdet køres gennem filtre som finder links, billeder, lyde og videoer der skal specificeres ved brug af firkantede paranteser. Syntaksen er: <code>[url afspillerbredde afspillerhøjde muligheder]</code> **url**: den relative eller absolutte url til mediefilen **afspiller** (valgfri): navn på den afspiller der skal indsættes. Standardværdien her er "moodle". HotPot-modulets standard afspiller tilbyder også de følgende afspillere: : **dew**: en mp3-afspiller : **dyer**: mp3-afspiller af Bernard Dyer : **hbs**: mp3-afspiller fra Half-Baked Software : **image**: indsæt et billede på websiden : **link**: indsæt et link til en anden webside **bredde** (valgfri): ønsket bredde på afspilleren **højde** (valgfri): ønsket højde på afspilleren. Udfyldes feltet ikke bruges samme værdi som på bredde. **ekstra indstillinger** (valgfri) : en kommasepareret liste med valg der skal gives til afspilleren Hvert valg kan være en simpel til/fra-afbryder eller et navnepar. : **navn=værdi : **navn="en værdi med mellemrum"';
$string['viewreports'] = 'Se rapporter for {$a} bruger(e)';
$string['views'] = 'Visninger';
$string['weighting'] = 'Vægtning';
$string['wrong'] = 'Forkert';
$string['zeroduration'] = 'Ingen varighed';
$string['zeroscore'] = 'Nul score';
