<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_snap', language 'es_mx', version '4.3'.
 *
 * @package     theme_snap
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutcourse'] = 'Acerca de este Curso';
$string['accesscalendarstring'] = 'Calendario';
$string['accessforumstringdis'] = 'Opciones de visualización';
$string['accessforumstringmov'] = 'Opciones de mover';
$string['accessglobalsearchstring'] = 'Búsqueda';
$string['action:changeassetvisibility'] = 'cambiar visibilidad de activo';
$string['action:changesectionvisibility'] = 'cambiar visibilidad de sección';
$string['action:duplicateasset'] = 'duplicar activo';
$string['action:highlightsectionvisibility'] = 'resaltar visibilidad de sección';
$string['action:sectiontoc'] = 'obtener tabla de contenido de sección';
$string['activity'] = 'Actividad';
$string['activityedit'] = 'Editar actividad';
$string['activityrestriction'] = 'Restricción de actividad';
$string['addanewsection'] = 'Crear una sección nueva';
$string['addresourceoractivity'] = 'Crear actividad de aprendizaje';
$string['admin'] = 'Admin';
$string['admineventwarning'] = 'Ver eventos de todos los cursos.';
$string['advancedbrandingheading'] = 'Marcado personalizado avanzado';
$string['advancedbrandingheadingdesc'] = '';
$string['ago'] = 'tiempo atrás';
$string['allyears'] = 'Todos los años';
$string['alternativelogin'] = 'Mostrar solamente opciones de ingreso alternativo';
$string['alternativeloginfirst'] = 'Mostrar primeramente opciones de ingreso alternativo';
$string['alternativeloginoptions'] = 'Opciones de ingreso alternativo';
$string['answered'] = 'Contestada';
$string['appendices'] = 'Herramientas';
$string['arialabelnewsarticle'] = 'artículo de noticias';
$string['assigndraft'] = 'Borrador necesita su confirmación';
$string['assignreopened'] = 'Re-abierto';
$string['at'] = 'en';
$string['attempted'] = 'Intentado';
$string['basics'] = 'Básicos';
$string['bothlogin'] = 'Mostrar ambas opciones de ingreso';
$string['brandingheading'] = 'Marcado personalizado';
$string['brandingheadingdesc'] = '';
$string['browse'] = 'Mirar';
$string['browseallcategories'] = 'Mirar todas las categorías';
$string['browseallcourses'] = 'Mirar todos los cursos';
$string['browserepositories'] = 'Subir una nueva imagen';
$string['cachedef_activity_deadlines'] = 'El almacenamiento en caché para las fechas límite de actividad para un usuario.';
$string['cachedef_course_card_bg_image'] = 'Caché para imagen de fondo del curso.';
$string['cachedef_course_card_teacher_avatar'] = 'Caché para avatares del profesor .';
$string['cachedef_course_card_teacher_avatar_index'] = 'Caché para índice de avatares del profesor.';
$string['cachedef_course_completion_progress'] = 'Esto es usado para cachear datos de finalización por curso / usuario.';
$string['cachedef_course_completion_progress_ts'] = 'Esto es usado de tal forma que nosotros podamos invalidar cachés de nivel sesión si las configuraciones de finalización del curso para un curso o para un módulo cambiaran.';
$string['cachedef_generalstaticappcache'] = 'Caché de nivel de aplicación estática general de Snap';
$string['cachedef_profile_based_branding'] = 'Caché para personalización de marca basada en Perfil.';
$string['cachedef_webservicedefinitions'] = 'Cacheando definiciones de servicio web auto generadas.';
$string['card'] = 'Tarjeta';
$string['category_color'] = 'Color de categoría';
$string['category_color_description'] = 'Color de categoría. Los cursos hijos toman la configuración de la categoría paterna más cercana';
$string['category_color_palette'] = 'Paleta de colores';
$string['category_color_palette_description'] = 'Ver el valor hexadecimal correspondiente para el color dado. Esto no afectará ninguna configuración; simplemente es una muestra para ayudarle a los usuarios a construir el valor de configuración.';
$string['categoryedit'] = 'Editar categoría';
$string['catinvalidratio'] = 'Las categorías siguientes no cumplen con el
<a href="https://www.w3.org/TR/WCAG20-TECHS/G18.html" target="_blank">WCAG 2.0 valor mínimo de proporción 4.5:1</a> :
Contra el color del fondo del sitio (blanco): "{$a->white}". Contra el color del fondo de la Barra de nevegación: "{$a->custombar}". Contra el color del fondo del botón de Mis Cursos: "{$a->customnav}"';
$string['changecoverimage'] = 'Cambiar imagen de portada';
$string['changefullname'] = 'Cambiar nombre del sitio';
$string['chapters'] = 'Capítulos';
$string['choosereadme'] = '<div class="clearfix"><div class="theme_screenshot"><h2>Snap</h2><img class=img-polaroid src="snap/pix/screenshot.jpg" /></div></div>';
$string['classic_template'] = 'Plantilla clásica';
$string['close'] = 'Cerrar';
$string['collapseicon'] = 'Colapsar el contenido de';
$string['comingsoon'] = '¡Muy Pronto!';
$string['conditional'] = 'Condicional';
$string['confirmdeletefile'] = 'Esta acción eliminará la imagen de portada. ¿Está seguro de querer eliminar el archivo guardado?';
$string['contents'] = 'Contenidos';
$string['contributed'] = 'Contribuído';
$string['courseactionslabel'] = 'acciones';
$string['courseactivitieslabel'] = 'Actividades de sección';
$string['coursecontacts'] = 'Contactos del Curso';
$string['coursedisplay'] = 'Visualización Curso';
$string['coursefixydefaulttext'] = 'Actualmente Usted no está inscrito en ningun cursos.<br>Los cursos en los que esté inscrito se mostrarán aquí.';
$string['coursefootertoggle'] = 'Pie de Página del Curso';
$string['coursefootertoggledesc'] = 'El Pie de Página del Curso muestra información útil a usuarios en una página del curso, incluyendo contactos del curso, descripción del curso y actividad reciente en el curso.';
$string['courseformatnotification'] = 'El formato actual del curso que Usted está usando no está soportado completamente por el tema Snap. Para la mejor experiencia Open LMS recomienda usar los formatos de Tópicos/Temas o Semanal con el tema Snap. El formato del curso puede ser cambiado en las  <a href="{$a}">configuraciones del curso</a>.';
$string['coursegrade'] = 'Calificación del curso :';
$string['courselimitstrdanger'] = 'Se alcanzó el límite de cursos; no se mostrará la Barra de progreso';
$string['courselimitstrwarning'] = 'Si más de {$a} cursos son listados, la barra de progreso no será mostrada';
$string['coursenavigation'] = 'Navegación del curso';
$string['coursepartialrender'] = 'Habilitar carga floja para secciones de curso';
$string['coursepartialrenderdesc'] = 'Si se habilita, las secciones del curso se cargan bajo demanda cuando sean seleccionadas por un usuario. Esto ayuda para que  cursos  con grandes cantidades de contenido carguen más rápido.';
$string['courses'] = 'Cursos';
$string['coursesummaryfilesunsuitable'] = 'Por favor vacíe sus archivos de resumend el curso antes de intentar cambiar la  imagen de portada';
$string['coursetools'] = 'Tablero del curso';
$string['covercarousel'] = 'Carrusel de cubierta';
$string['covercarouseldescription'] = '<p>El carrusel es un conjunto de banners rotatorios, o una presentación con imágenes, que se muestra en la página inicial de su sitio en sustitución de la imagen de cubierta.</p>
<p>Añada hasta 3 imágenes, un título para cada imagen, y un subtítulo optativo. Las imágenes de 1200 por 600 pixeles funcionan mejor.</p>';
$string['covercarousellabel'] = 'Carrusel';
$string['covercarouselon'] = 'Usar Carrusel de cubierta';
$string['covercarouselpausebutton'] = 'Pausar auto-rotación de imágenes para el carrusel.';
$string['covercarouselplaybutton'] = 'Reanudar auto-rotación de imágenes para el carrusel.';
$string['covercarouselsronly'] = 'Este es un carrusel con imágenes auto-rotantes. Active cualquiera de los botones para deshabilitar la rotación. Use los botones de Siguiente y Anterior para navegar, o salte a una imagen usando los puntos,';
$string['coverdisplay'] = 'Muestrario de cubierta';
$string['coverimage'] = 'Imagen de cubierta';
$string['coverimagecropperdesc'] = 'Usando la caja para recortar, seleccione el área de la imagen que será mostrada.';
$string['coverimagedesc'] = 'Seleccione la imagen a poner en la cubierta del curso, asegurándose que sea, ya bien formatos .JPEG, .PNG o .GIF. No debería exceder del tamaño máximo del archivo permitido a nivel del sitio ({$a}).  Para visualización óptima, trate que la proporción del aspecto sea 4:3 (1024x768 pixeles). Adicionalmente, considere combinaciones de colores que se adhieran a las guías WCAG 2.0, especialmente en relación al título blanco del curso, para una mejor experiencia del usuario.';
$string['coverimagesettingswarning'] = 'Si usted actualiza la imagen de carátula directamente desde la página de configuraciones del curso, la imagen recortada se reiniciará. Por favor recuerde re-seleccionar el recorte deseado después de hacerlo.';
$string['covervideo'] = 'Video de cubierta';
$string['createsection'] = 'Crear sección';
$string['current'] = 'Actual';
$string['customcss'] = 'CSS personalizado';
$string['customcssdesc'] = 'Por favor tome en cuenta que con un gran poder viene una gran responsbilidad. Cualquier problema causado por el CSS aquí añadido es su responsabilidad para resolverlo. El soporte de Open LMS no resolverá problemas ni proporcionará ayuda alguna con el contenido relacionado con CSS.';
$string['customisecustommenu'] = 'Cambiar color de texto de menú personalizado';
$string['customisenavbar'] = 'Cambiar colores de barra de navegación';
$string['customisenavbutton'] = 'Cambiar colores de botones de Mis Cursos';
$string['custommenutext'] = 'Color de texto de menú personalizado';
$string['customtopbar'] = 'Barra de Navegación';
$string['deadlines'] = 'Fechas límites';
$string['deadlinestoggle'] = 'Fechas límite';
$string['deadlinestoggledesc'] = 'Mostrarle a usuarios cualquier fecha-límite de actividades próximas de cursos inscritos.';
$string['debugerrors'] = 'Depurar errores';
$string['defaultintrosummary'] = 'Bienvenido a su nuevo curso {$a}.
<br>Comience por describir de que se trata su curso usando texto, imágenes, audio y video.';
$string['defaultsummary'] = 'Use esta área para describir de que se trata este tópico - con texto, imágenes, audio y video.';
$string['defaulttopictitle'] = 'Tópico sin título';
$string['deleteassetconfirm'] = 'Eliminar {$a}';
$string['deleteimage'] = 'Eliminar imagen de carátula';
$string['deletesectionconfirm'] = 'Eliminar Sección';
$string['deletingasset'] = 'Eliminando {$a}';
$string['deletingassetname'] = 'Eliminando {$a->type} "{$a->name}"';
$string['deletingsection'] = 'Eliminando sección "{$a}"';
$string['disabled'] = 'Deshabilitado';
$string['displaydescription'] = 'Mostrar descripción';
$string['displaydescriptionhelp'] = 'Seleccionar para mostrar una descripción de recurso y actividades en una nueva página primeramente. Los estudiantes accederán al  contenido desde la descripción.';
$string['draft'] = 'No publicado a estudiantes';
$string['dropzonelabel'] = 'Arrastre archivos para anexarlos, o <span class="fake-link">mirarlos</span>';
$string['due'] = 'Esperado para {$a}';
$string['edit'] = 'Editar "{$a}"';
$string['editcoursecontent'] = 'Editar bloques';
$string['editcoursesettings'] = 'Configuraciones del curso';
$string['editcoursetopic'] = 'Editar sección';
$string['editcustomfooter'] = 'Editar pie de página';
$string['editcustommenu'] = 'Editar menú personalizado';
$string['editmodetiles'] = 'Editar contenido';
$string['enableblockmyoverviewwarning'] = 'El bloque de Vista general del curso está deshabilitado. Para mostrar los cursos, por favor habilite el bloque.';
$string['enabledlogin'] = 'Opciones para ingreso mostradas';
$string['enabledlogindesc'] = 'Seleccionar las opciones para  ingreso que deberían ser mostradas.';
$string['enabledloginorder'] = 'Orden de opciones para ingreso';
$string['enabledloginorderdesc'] = 'Seleccionar las opciones para  ingreso que deberían ser mostradas primero.';
$string['enrolme'] = 'Inscribirme';
$string['error'] = 'Error';
$string['error:categorycolorinvalidjson'] = 'Formato JSON incorrecto parea categorías de curso';
$string['error:categorycolorinvalidvalue'] = 'El valor del color o el ID del registro para categoría "{$a}" no son válidos';
$string['error:categorynotfound'] = 'El registro de la categoría con id "{$a}" no ha sido encontrado';
$string['error:coverimageexceedsmaxbytes'] = 'La imagen de portada excede el máximo tamaño de archivo a nivel del sitio ({$a})';
$string['error:coverimageresolutionlow'] = 'Para la mejor calidad, nosotros recomendamos una imagen más grande de al menos 1024 pixeles de ancho.';
$string['error:duplicatedcategoryids'] = 'Formato JSON incorrecto; algunos IDs están duplicados';
$string['error:failedtochangeassetvisibility'] = 'No se pudo ocultar/mostrar activo';
$string['error:failedtochangesectionvisibility'] = 'No se pudo ocultar/mostrar sección';
$string['error:failedtodeleteasset'] = 'No se pudo eliminar recurso';
$string['error:failedtoduplicateasset'] = 'No se pudo duplicar';
$string['error:failedtohighlightsection'] = 'No se pudo resaltar sección';
$string['error:failedtotoc'] = 'No se pudo obtener Tabla de Contenido';
$string['errorgettingfeed'] = 'Ocurrió un error al obtener elementos suministrados';
$string['expandicon'] = 'Expandir el contenido de';
$string['extension'] = 'Extensión {$a}';
$string['extra_section_menu'] = 'Menú sección extra';
$string['facebook'] = 'Facebook';
$string['facebookdesc'] = 'La URL de su página de Facebook.';
$string['favicon'] = 'Favicon';
$string['favicondesc'] = 'El favicon se mostrará junto con el título de la página en la barra de la pestaña del navegador, en los marcapáginas (bookmarks)y atajos de Mobile.';
$string['favorite'] = 'Favorito {$a}';
$string['favorited'] = 'Favorito {$a}';
$string['feature_spot_background_color'] = 'Color del fondo';
$string['feature_spot_description_color'] = 'Color del texto de descripción';
$string['feature_spot_description_color_lower'] = 'color del texto de descripción';
$string['feature_spot_title_color'] = 'Color del texto del título';
$string['feature_spot_title_color_lower'] = 'color del texto del título';
$string['featuredcategories'] = 'Categorías destacadas';
$string['featuredcategoriesandcourses'] = 'Cursos y categorías destacadas';
$string['featuredcategoriesbrowseall'] = 'Mirar todas las categorías';
$string['featuredcategoriesbrowsealldesc'] = 'Añadir un enlace para mirar todas las categorías';
$string['featuredcategoriesedit'] = 'Editar categorías destacadas';
$string['featuredcategorieseven'] = 'Ctaegoría destacada 7';
$string['featuredcategoriesheading'] = 'Encabezado de categorías destacadas';
$string['featuredcategorieshelp'] = 'Resaltar hasta 8 categorías destacadas a la Portada de su sitio. Escriba la ID de categoría para destacar una categoría.';
$string['featuredcategoriesix'] = 'Categoría destacada 6';
$string['featuredcategoryeight'] = 'Categoría destacada 8';
$string['featuredcategoryfive'] = 'Categoría destacada 5';
$string['featuredcategoryfour'] = 'Categoría destacada 4';
$string['featuredcategoryone'] = 'Categoría destacada 1';
$string['featuredcategorythree'] = 'Categoría destacada 3';
$string['featuredcategorytwo'] = 'Categoría destacada 2';
$string['featuredcourseeight'] = 'Curso destacado 8';
$string['featuredcoursefive'] = 'Curso destacado 5';
$string['featuredcoursefour'] = 'Curso destacado 4';
$string['featuredcourseone'] = 'Curso destacado 1';
$string['featuredcourses'] = 'Cursos destacados';
$string['featuredcoursesbrowseall'] = 'Mirar todos los cursos';
$string['featuredcoursesbrowsealldesc'] = 'Añadir un enlace para mirar todos los cursos';
$string['featuredcoursesedit'] = 'Editar cursos destacados';
$string['featuredcourseseven'] = 'Curso destacado 7';
$string['featuredcoursesheading'] = 'Encabezado de cursos destacados';
$string['featuredcourseshelp'] = 'Resaltar hasta 8 cursos destacados en su Portada de su sitio. Escriba la ID del curso para hacer destacado a un curso.';
$string['featuredcoursesix'] = 'Curso destacado 6';
$string['featuredcoursethree'] = 'Curso destacado 3';
$string['featuredcoursetwo'] = 'Curso destacado 2';
$string['featurefiveimage'] = 'Imagen de característica 5';
$string['featurefivetext'] = 'Contenido de característica 5';
$string['featurefivetitle'] = 'Título de característica 5';
$string['featurefivetitlecb'] = 'Característica 5 abre en una nueva ventana';
$string['featurefivetitlelink'] = 'Enlace al título de característica 5';
$string['featurefourimage'] = 'Imagen de característica 4';
$string['featurefourtext'] = 'Contenido de característica 4';
$string['featurefourtitle'] = 'Título de característica 4';
$string['featurefourtitlecb'] = 'Característica 4 abre en una nueva ventana';
$string['featurefourtitlelink'] = 'Enlace al título de característica 4';
$string['featureoneimage'] = 'Imagen destacada 1';
$string['featureonetext'] = 'Contenido destacado 1';
$string['featureonetitle'] = 'Título destacado 1';
$string['featureonetitlecb'] = 'Característica 1 abre en una nueva ventana';
$string['featureonetitlelink'] = 'Enlace al título de Característica 1';
$string['featuresiximage'] = 'Imagen de característica 6';
$string['featuresixtext'] = 'Contenido de característica 6';
$string['featuresixtitle'] = 'Título de característica 6';
$string['featuresixtitlecb'] = 'Característica 6 abre en una nueva ventana';
$string['featuresixtitlelink'] = 'Enlace al título de característica 6';
$string['featurespots'] = 'Puntos de Características Destacadas';
$string['featurespotsedit'] = 'Editar puntos destacados';
$string['featurespotsheading'] = 'Encabezado de Punto de Características Destacadas';
$string['featurespotshelp'] = '<p>Añada hasta 3 puntos destacados a su Portada del sitio para resaltar los principales beneficios para usuarios actuales y potenciales..</p>
<p>Usted puede añadir una imagen, un título y una descripción del  contenido a cada característica. <strong>Para poder ver la característica en la Portada del sitio, usted debe escribir un título.</strong>Las imágenes y las secciones de descripción del contenido son opcionales.</p>
<p>El tamaño recomendado de imagen es de un  cuadrado no mayor de 200px por200px.</p>';
$string['featurethreeimage'] = 'Imagen destacada 3';
$string['featurethreetext'] = 'Contenido destacado 3';
$string['featurethreetitle'] = 'Título destacado 3';
$string['featurethreetitlecb'] = 'Característica 3 abre en una nueva ventana';
$string['featurethreetitlelink'] = 'Enlace al título de Característica 3';
$string['featuretitlecbdesc'] = 'Si se habilita, el enlace añadido al punto destacado será abierto en una ventana nueva';
$string['featuretitlelinkdesc'] = 'Escriba la UR a donde usted quiere enlazar directamente esta característica. Usted puede añadir enlaces externos o internos dentro de sus sitio. Para añadir un enlace interno, por favor cópielo desde la URL del sitio incluyendo la  /. Por ejemplo, para tener un enlace hacia un curso, sería  "/course/view.php?id=160". Para añadir un enlace externo comience el enlace con  https://';
$string['featuretwoimage'] = 'Imagen destacada 2';
$string['featuretwotext'] = 'Contenido destacado 2';
$string['featuretwotitle'] = 'Título destacado 2';
$string['featuretwotitlecb'] = 'Característica 2 abre en una nueva ventana';
$string['featuretwotitlelink'] = 'Enlace al título de Característica 2';
$string['feedbackavailable'] = 'Retroalimentación disponible';
$string['feedbacktoggle'] = 'Retroalimentación y calificación';
$string['feedbacktoggledesc'] = 'Mostrar la retroalimentación reciente a estudiantes y  a los educadores mostrar envíos que necesitan ser calificados.';
$string['footnote'] = 'Pie de página del sitio';
$string['footnotedesc'] = 'Usted puede añadir información del sitio como HTML, y puede incluir enlaces, imágenes, o inclusive listas.';
$string['forcepwdwarningpersonalmenu'] = 'Usted debe <a href="{$a}">cambiar su contraseña</a> antes de usar el menú personal.';
$string['forumauthor'] = 'Autor';
$string['forumlastpost'] = 'Última publicación';
$string['forumpicturegroup'] = 'Grupo';
$string['forumposts'] = 'Publicaciones en foro';
$string['forumpoststoggle'] = 'Publicaciones en foro';
$string['forumpoststoggledesc'] = 'Mostrar a usuarios as 10 publicaciones en foro más recientes de sus cursos';
$string['forumreplies'] = 'Contestciones';
$string['forumtopic'] = 'Tópico/Asunto';
$string['fullname'] = 'Nombre del sitio';
$string['fullnamedesc'] = 'El nombre de sus sitio.';
$string['gotoactivity'] = 'Ir a actividad {$a}';
$string['gotocalendarsnap'] = 'ir al calendario del sitio.';
$string['graderadviseuserreport'] = 'El "reporte del calificador" no funciona bien en dispositivos móviles. En su lugar se le recomienda el "reporte del usuario"';
$string['grading'] = 'Calificar';
$string['headingfont'] = 'Tipo de letra (font) del encabezado';
$string['headingfont_desc'] = 'Este font se usa en los encabezados (elementos h1 - h6) en todo el sitio. Si Usted está incluyendo un font web personalizado, recuerde añadirlo al formato Moodle de HTML extra. Si desea modificar fonts de otros elementos, por favor haga uso de la opción de CSS personalizado; para  ejemplos de  cómo hacer esto, por  favor vea esta <a href="https://help.openlms.net/en/administrator/manage-a-site/snap-font-family-with-custom-css/" target="_blank">documentación</a>.';
$string['help'] = 'Ayuda';
$string['helpguide'] = 'Guía de ayuda';
$string['helpwithlogin'] = 'Ayuda con el ingreso';
$string['helpwithloginandguest'] = 'Ayuda con el ingreso / acceso de invitado';
$string['hiddencoursestoggle'] = 'Cursos ocultos';
$string['hideandshowactioncb'] = 'Acción de ocultar y mostrar casilla de selección de actividad';
$string['highlightedsection'] = 'resaltado';
$string['home'] = 'página inicial';
$string['homepage'] = 'Página inicial';
$string['hvpcustomcss'] = 'CSS personalizado de H5P';
$string['hvpcustomcssdesc'] = 'CSS personalizado para el módulo H5P (moodle.org/plugins/mod_hvp) si estuviera instalado.';
$string['image'] = 'imagen';
$string['imageinvalidratio'] = 'Esta imagen podría tener problemas de contraste debido a que no cumple con WCAG 2.0 para el valor de proporción mínimo 4.5:1. Valor de pixel promedio: "{$a}"';
$string['imageinvalidratiocategory'] = 'Esta imagen podría tener problemas de contraste con el color del tema debido a que no cumple con WCAG 2.0 para el valor de proporción mínimo 4.5:1. Valor de pixel promedio: "{$a}"';
$string['imageproperties'] = 'Propiedades de imagen';
$string['images'] = 'Imágenes';
$string['instagram'] = 'Instagram';
$string['instagramdesc'] = 'La URL de su cuenta de Instagram.';
$string['introduction'] = 'Introducción';
$string['invalidratio'] = 'Esta combinación de colores no cumple con
<a href="https://www.w3.org/TR/WCAG20-TECHS/G18.html" target="_blank">WCAG 2.0 valor de proporciónmínima 4.5:1</a>. Valor: "{$a}"';
$string['jsontext'] = 'Texto JSON';
$string['jsontextdescription'] = 'Elárea de texto valida el JSON dado, para que solamente estén permitidas categorías existentes,
Solamente son aceptados como colores valores numéricos como registros ID (registros de categoría) válidos y solamente valores hexadecimales son aceptados como colores.
Aquí está un ejemplo:<br>
{"1":"#FAAFFF",<br>
"45":"#AFF",<br>
"65":"#FFF228",<br>
"12":"#CC0084",<br>
"56":"#CC0087",<br>
"89":"#CCF084"}';
$string['knowledgebase'] = 'Abrir Base de Conocimiento del LMS';
$string['lazyload_mod_page'] = 'Habilitar carga floja predeterminada para recursos página';
$string['lazyload_mod_page_description'] = 'Si se habilita, esta configuración disminuye significativamente los tiempos de carga de página para cursos con muchas páginas';
$string['leftnav'] = 'Tabla de contenidos';
$string['leftnavdesc'] = 'Seleccionar adonde mostrar la tabla de contenidos. La lista da más espacio para contenido y funciona bien para cursos con muchos tópicos.';
$string['linkedin'] = 'LinkedIn';
$string['linkedindesc'] = 'La URL del LinkedIn de su organización.';
$string['list'] = 'Lista';
$string['loading'] = 'Cargando...';
$string['loadingfeed'] = 'Cargando ... podría tardar un rato';
$string['loggedinasguest'] = 'Usted está ingresado como invitado';
$string['loggedoutfailmsg'] = 'Usted debe estar ingresado para {$a}.';
$string['loggedoutmsg'] = 'Usted actualmente está afuera del sitio, Si desea continuar usando este sitio, por favor vuelva a ingresar.';
$string['loggedoutmsgtitle'] = 'Usted ha salido del sitio';
$string['loginbgimg'] = 'Imagen del fondo para ingreso';
$string['loginbgimgdesc'] = 'Seleccione la imagen que aparecerá en el fondo de la página para ingreso. Para tener una mejor experiencia con las imágenes mostradas, por favor suba archivos con una proporción de aspecto de 16:9 (resolución de 720p o dimensiones de 1280x720 pixeles). Las imágenes subidas necesitan tener las mismas dimensiones para una correcta visualización.';
$string['loginbgimgheading'] = 'Plantilla de página para ingreso';
$string['loginbgimgheadingdesc'] = 'Snap le permite cambiar entre diferentes plantillas a ser mostradas en la página para ingreso. Por favor seleccione entre diferentes opciones en el menú desplegable debajo.';
$string['loginform'] = 'Ingreso';
$string['loginpagetemplate'] = 'Seleccionar plantilla de página para ingreso a usar';
$string['loginrequiredmessage'] = '* indica un campo requerido';
$string['loginsetting'] = 'Página para ingreso';
$string['logo'] = 'Logo';
$string['logodesc'] = 'Su logo es mostrado en el encabezado en todo el sitio.';
$string['menu'] = 'Mis Cursos';
$string['messageread'] = 'Mensaje leído';
$string['messages'] = 'Mensajes';
$string['messagestoggle'] = 'Mensajes';
$string['messagestoggledesc'] = 'Mostrar a usuarios los mensajes más recientes recibidos en las últimas 12 semanas. Para habilitar esta opción, asegúrese que la característica de mensajería de la página de Características avanzadas esté activada.';
$string['moodlelogin'] = 'Mostrar solamente ingreso Moodle';
$string['moodleloginfirst'] = 'Mostrar primero ingreso Moodle';
$string['more'] = 'Más';
$string['morenews'] = 'Más noticias';
$string['moreoptionslabel'] = 'Más Opciones';
$string['move'] = 'Mover "{$a}"';
$string['movefailed'] = 'Falló mover para "{$a}"';
$string['movehere'] = 'Mover aquí';
$string['movesection'] = 'Mover sección';
$string['moving'] = 'Moviendo "{$a}"';
$string['movingcount'] = 'Moviendo {$a} objetos';
$string['movingdropsectionhelp'] = 'Colocar sección "{$a->moving}" antes de la sección "{$a->before}"';
$string['movingstartedhelp'] = 'Navegar hasta  adonde a Usted le gustaría colocar la sección "{$a}"';
$string['multimediacard'] = 'Los archivos multimedia no serán mostrados en las vistas de tarjeta de actividad para el tema Snap. esto será aplicado en la página inicial y páginas de curso solamente para las tarjetas de recurso y actividad pequeñas.';
$string['mycoursessnapfeedsdesc'] = 'Nota: <strong>Canales avanzados</strong> se vuelve disponible solamente cuando al menos una de las opciones  <strong>Fechas límite</strong>, <strong>Retroalimentación y Calificar</strong>, <strong>Mensajes</strong> o <strong>Publicaciones en foro</strong> iestá seleccionada.';
$string['mycoursessnapfeedsheading'] = 'Canales de Snap';
$string['navbarbg'] = 'Color del fondo';
$string['navbarbuttoncolor'] = 'Color del fondo';
$string['navbarbuttonlink'] = 'Color del texto';
$string['navbarlink'] = 'Color del texto';
$string['nextsection'] = 'Sección siguiente';
$string['nodeadlines'] = 'Usted no tiene fechas límites próximas';
$string['noforumposts'] = 'Usted no tiene publicaciones relevantes en foros.';
$string['nograded'] = 'Usted no tiene retroalimentación reciente.';
$string['nograding'] = 'Usted no tiene envíos para calificar.';
$string['nomessages'] = 'Usted no tiene mensajes';
$string['notanswered'] = 'No contestado';
$string['notattempted'] = 'No intentado';
$string['notcontributed'] = 'No contribuído';
$string['notpublished'] = 'No publicado a estudiantes';
$string['notsubmitted'] = 'No Enviado';
$string['opened'] = 'Abierto {$a}';
$string['openmessagedrawer'] = 'Abrir cajón de mensajería';
$string['opens'] = 'Abre {$a}';
$string['overdue'] = 'Retrasado';
$string['pausegraphicsanim'] = 'Pausar animación de GIF';
$string['pbb'] = 'Personalización de la marca basada en Perfil';
$string['pbb_description'] = 'Al habilitar <strong>Marcado basado en el perfil</strong>, usted podrá personalizar la experiencia del marcado para un grupo específico de usuarios basándose en el campo elegido del perfil del usuario .
<ul><li>El valor del campo del usuario estará <em>slugified</em>; convertidos todos los caracteres a minúsculas y separados con un guión (-)</li>
<li>La cadena de caracteres <code>snap-pbb-</code> estará prepended</li>
<li>ESta clase será añadida al <code>body</code> Html tag</li></ul>
Por ejemplo, el valor del campo del usuario <em>Blueberry Extravaganza</em> será slugified para ser <code>snap-pbb-blueberry-extravaganza</code><br /><br />
Esta característica es usada en combinación con CSS personalizado; usted necesitará añadir selectores CSS usando las nuevas clases en la sección
his feature is used in conjunction with Custom CSS, you\'ll need to add CSS selectors using the new classes in the <a class="snap-settings-tab-link" n+h la sección <a class="snap-settings-tab-link" href="#themesnapbranding">Basics</a> .';
$string['pbb_enable'] = 'Habilitar marcado personalizado basado en Perfil';
$string['pbb_enable_description'] = 'Solamente añade la clase a la marca del cuerpo si está activo.';
$string['pbb_field'] = 'Campo del usuario a utilizar';
$string['pbb_field_description'] = 'Este valor del campo será \'slugified\' y usado como un nombre de clase CSS prefijado por  <code>snap-pbb-</code>.';
$string['personalmenu'] = 'Menú personal';
$string['personalmenuadvancedfeedsenable'] = 'Habilitar canales Avanzados';
$string['personalmenuadvancedfeedsenabledesc'] = 'Canales avanzados carga algunos ítems de menú personal que permiten tiempos de carga más rápidos y refrescan contenidos bajo demanda.';
$string['personalmenuadvancedfeedslifetime'] = 'Tiempo de vida de canales avanzados';
$string['personalmenuadvancedfeedslifetimedesc'] = 'Elegir la cantidad de tiempo que serán cacheadas las alimentaciones en el navegador después de ingresar al sitio. Configurar el valor a 0 no cacheará las alimentaciones en el navegador.';
$string['personalmenuadvancedfeedsperpage'] = 'Número de items a mostrar en canales avanzados';
$string['personalmenuadvancedfeedsperpagedesc'] = 'Elija el número de items a ser mostrados en el canal.Los usuarios pueden seleccionar. <strong>Ver más</strong> para mostrar ítems adicionales.';
$string['personalmenuandsnapfeeds'] = 'Menú personal y canales de Snap';
$string['personalmenuenablepersonalmenu'] = 'Habilitar menú personal';
$string['personalmenuenablepersonalmenudesc'] = 'El enlace a Mis cursos abrirá menú personal. Si se deshabilita, redireccionará a la página de Mis Cursos';
$string['personalmenuenablepersonalmenuheading'] = 'Menú personal';
$string['personalmenuenablepersonalmenuheadingdesc'] = 'Nota: Si el Menú Personal está deshabilitado, usted podrá acceder a sus cursos desde la página de Mis Cursos. Por favor asegúrese de que el bloque de Vista General del curso esté habilitado, para que los cursos sean visibles en la página.';
$string['personalmenufeatures'] = 'Características del menú personal';
$string['personalmenulogintoggle'] = 'Mostra menú personal al ingresar';
$string['personalmenulogintoggledesc'] = 'Abrir el menú personal inmediatamente después de ingresar';
$string['personalmenurefreshdeadlines'] = 'Refrescar fechas límite usando trabajos agendados';
$string['personalmenurefreshdeadlinesdesc'] = 'Cuando el trabajo se ejecuta, los datos de fecha límite serán refrescados para tiempos de carga más rápidos.';
$string['pld'] = 'PLD = Personalized Learning Designer';
$string['pluginname'] = 'Snap';
$string['pmadvancedfeed_reload'] = 'Refrescar';
$string['pmadvancedfeed_viewmore'] = 'Ver más';
$string['poster'] = 'Imagen de portada';
$string['posterdesc'] = 'Una imagen de encabezado grande para la Portada de su sitio. Las imágenes de 1200 pixeles de ancho por 600 pixeles de alto, o mayores, en estilo apaisado (acostado), funcionan mejor.';
$string['poweredbyrunby'] = 'Hecho con <a href="https://{$a->subdomain}.openlms.net/" target="_blank" rel="noopener">Open LMS</a>,
    a <a href="https://moodle.com/" target="_blank" rel="noopener">Moodle</a>-based product.<br>
    Copyright © {$a->year} Open LMS, All Rights Reserved.';
$string['previoussection'] = 'sección anterior';
$string['privacy:metadata:theme_snap_course_favorites'] = 'Almacena los favoritos del curso del usuario para Snap';
$string['privacy:metadata:theme_snap_course_favorites:courseid'] = 'La ID del curso que el usuario marcó como favorito';
$string['privacy:metadata:theme_snap_course_favorites:timefavorited'] = 'El sello de tiempo de cuando el usuario marcó como favorito el curso';
$string['privacy:metadata:theme_snap_course_favorites:userid'] = 'La ID del usuario que marcó como  favorito el curso';
$string['problemsfound'] = 'Problemas encontrados';
$string['progress'] = 'Progreso';
$string['quizattemptswarn'] = 'Excluir intentos de usuarios suspendidos';
$string['quizfeedback'] = 'Retroalimentación';
$string['readmore'] = 'Lea máse&nbsp;»';
$string['recentactivity'] = 'Actividad Reciente';
$string['recentfeedback'] = 'Retroalimentación';
$string['refreshdeadlinestask'] = 'Refrescar datos cacheados de fechas límite. Esto debería ejecutarse antes de que ingresen todos los usuarios.';
$string['refreshdeadlinestaskoff'] = 'No se buscaron datos para poblar. Por favor active la configuración "Refrescar fechas límite usando trabajo agendado" en las configuraciones del Menú personal de Snap para permitirle a este trabajo que pueble los datos cacheados de fechas límite.';
$string['refreshdeadlinestasksettingheading'] = 'Refrescar trabajo agendado de fechas límite';
$string['region-main'] = 'Principal';
$string['region-side-main-box'] = 'Principal';
$string['region-side-post'] = 'Derecha';
$string['region-side-pre'] = 'Izquierda';
$string['region-side-top'] = 'Superior';
$string['released'] = 'Liberada: {$a}';
$string['reopened'] = 'Re-abierto';
$string['resetdeadlinesquerycounttask'] = 'Reiniciar número de consultas de fechas límites';
$string['resourcedisplay'] = 'Mostrar recurso';
$string['resourcedisplayhelp'] = 'Seleccionar como aparecerán anexos y enlaces en su curso. El tema Snap no soporta archivos multimedia en la pequeña descripción de tarjetas de actividad y recurso.';
$string['resumegraphicsanim'] = 'Reanudar animación GIF.';
$string['retryfeed'] = 'Este canal actualmente no está disponible; por favor compruebe más tarde. Canal: {$a}';
$string['saveimage'] = 'Guardar imagen';
$string['search'] = 'Buscar contenidos';
$string['selectimage'] = 'Seleccionar imagen';
$string['showallsectionsdisabled'] = 'Debido al lenguaje en el cual está diseñado, "Mostrar todas las secciones en una  página" no está disponible en Snap.';
$string['showappearancedisabled'] = 'El lenguaje en el que está diseñado Snap impide cambios a las configuraciones de "Apariencia",';
$string['showcoursegradepersonalmenu'] = 'Calificaciones';
$string['showcoursegradepersonalmenudesc'] = 'Mostrarle a usuarios las calificaciones del curso en las tarjetas de curso en el menú personal';
$string['sitedescription'] = 'Descripción del sitio';
$string['snapfeedsblocktitle'] = 'Canales de Snap';
$string['snapfooterbgcolor'] = 'Color del fondo del pie de página';
$string['snapfootercolors'] = 'Colores del pie de página del sitio';
$string['snapfootercolorsdesc'] = 'Los colores del pie de página pueden ser cambiados: para cambiar el color del fondo o el color del texto, selecciónelos en los siguientes selectores de color,';
$string['snapfootercustomization'] = 'Personalización del pie de página';
$string['snapfootercustomizationdesc'] = 'Snap permite la personalización de el pie de página del tema, el cual es mostrado en todo el sitio. Mejore la experiencia del usuario al añadir enlaces útiles, recursos de apoyo, o cualquier otra información valiosa  acerca de su organización que usted quisiera compartir con alumnos y educadores.';
$string['snapfootersettings'] = 'Pie de página de Snap';
$string['snapfootertxtcolor'] = 'Color del texto del pie de página';
$string['socialmedia'] = 'Redes sociales';
$string['spotinvalidratio'] = 'El color del fondo no cumple con
<a href="https://www.w3.org/TR/WCAG20-TECHS/G18.html" target="_blank">WCAG 2.0 valor mínimo de proporción 4.5:1</a>.
Contra valor actual {$a->name}: {$a->value}.';
$string['stylish_template'] = 'Plantilla estilizada';
$string['submitted'] = 'Enviado';
$string['subtitle'] = 'Subtítulo';
$string['subtitle_desc'] = 'Describa brevemente su sitio para los usuarios.';
$string['summarylabel'] = 'Resumen de sección';
$string['themecolor'] = 'Color del sitio';
$string['themecolordesc'] = 'Los colores brillantes funcionan mejor y le darán a su sitio un aspecto moderno.';
$string['tiktok'] = 'TikTok';
$string['tiktokdesc'] = 'La URL de su cuenta de TikTok.';
$string['tilesformatcoursehomealttext'] = 'Página inicial del curso';
$string['title'] = 'Título';
$string['togglenavigation'] = 'Alternar navegación';
$string['top'] = 'Superior';
$string['topbarbgcolor'] = 'Color de Barra de Navegación';
$string['topbarbuttoncolor'] = 'Fondo de Mis Cursos';
$string['topbarlinkcolor'] = 'Color del ícono y de  Barra de Navegación';
$string['topicactions'] = 'Acciones sobre tópicos';
$string['totop'] = 'Ir a superior';
$string['unenrolme'] = 'Des-inscribirme';
$string['unread'] = 'no-leído';
$string['unsupportedcoverimagetype'] = 'Tipo de imagen de  portada no soportada ({$a})';
$string['validratio'] = 'Esta combinación de colores no cumple con el mínimo de WCAG 2.0 valor de proporción 4.5:1';
$string['via'] = 'vía';
$string['viewcalendar'] = 'Ver mi calendario';
$string['viewcourse'] = 'Ver curso';
$string['viewforumposts'] = 'Ver mis publicaciones en foro';
$string['viewmessaging'] = 'Ver mis mensajes';
$string['viewmore'] = 'Ver más';
$string['viewmyfeedback'] = 'Ver mi retroalimentación';
$string['vieworiginalimage'] = 'Ver imagen original';
$string['viewyourprofile'] = 'Ver su perfil';
$string['visibility'] = 'Visibilidad';
$string['xakatwitter'] = '𝕏';
$string['xakatwitterdesc'] = 'La URL de su cuenta de 𝕏.';
$string['xofyanswered'] = '{$a->completed} de {$a->participants} Contestados';
$string['xofyattempted'] = '{$a->completed} de {$a->participants} Intentados';
$string['xofycontributed'] = '{$a->completed} de {$a->participants} Contribuídos';
$string['xofysubmitted'] = '{$a->completed} de {$a->participants} Enviados';
$string['xungraded'] = '{$a} No-calificados';
$string['year'] = 'Año';
$string['youtube'] = 'YouTube';
$string['youtubedesc'] = 'La URL de su canal de YouTube';
