<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_intelliboard', language 'es_mx', version '4.3'.
 *
 * @package     local_intelliboard
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['a0'] = 'Tablero de Competencia';
$string['a1'] = 'Competencias';
$string['a10'] = 'Estudiantes Inscritos';
$string['a11'] = 'Lista de competencias asignadas al curso.';
$string['a12'] = 'Estatus del Estudiante';
$string['a13'] = 'Nombre de Competencia';
$string['a14'] = 'Creada En';
$string['a15'] = 'Asignada En';
$string['a16'] = 'Competente experto';
$string['a17'] = 'Valoración';
$string['a18'] = 'Eficiencia en Competencias';
$string['a19'] = 'Fecha de Valoración de Competencia';
$string['a2'] = 'Eficiencia';
$string['a20'] = 'Valorador de Competencia';
$string['a21'] = 'Actividades Asignadas';
$string['a22'] = 'Eficiencia Lograda';
$string['a23'] = 'Competencias Valoradas';
$string['a24'] = '# Evidencias';
$string['a25'] = 'Estudiantes Completados';
$string['a26'] = 'Esta tabla muestra el número de competencias asignadas a un curso, estudiantes que han sido valorados, ya sea eficientes o no), y estudiantes que han sido designados eficientes en la competencia.';
$string['a27'] = 'de un total de';
$string['a28'] = 'Detalles';
$string['a29'] = 'Habilitar Tablero de Competencia';
$string['a3'] = 'Actividades Asignadas';
$string['a30'] = 'Habilitar Teportes de Competencias';
$string['a31'] = 'Estructuras';
$string['a32'] = 'Planes de Aprendizaje';
$string['a33'] = 'Valorada, Eficiente';
$string['a34'] = 'Valorada, No-Eficiente';
$string['a35'] = 'No Valorada';
$string['a36'] = 'Vista General de Competencia';
$string['a37'] = 'No se ha creado una competencia. Por favor contacte a su administrador del sistema';
$string['a38'] = 'Cursos Enlazados a Competencias';
$string['a39'] = 'Totales de Competencias';
$string['a4'] = 'Progreso de Eficiencia';
$string['a40'] = 'Cursos Enlazados';
$string['a5'] = 'Competencias Valoradas';
$string['a6'] = '# Evidencias';
$string['a7'] = 'Estudiantes Valorados';
$string['a8'] = 'Progreso';
$string['a9'] = 'Estudiantes Eficientes';
$string['account'] = 'Información de Suscripción';
$string['actions'] = 'Acciones';
$string['active'] = 'Activo';
$string['activities'] = 'Actividades';
$string['activities_resources'] = 'Actividades/Recursos';
$string['activity'] = 'Actividad';
$string['activity_grades'] = 'Calificaciones de Actividades';
$string['activity_name'] = 'Nombre de Actividad';
$string['activity_participation'] = 'Participación en actividad';
$string['activity_progress'] = 'Progreso de Actividad';
$string['address'] = 'Dirección';
$string['adm_dshb_adm_dashb_totals'] = 'Totales';
$string['adm_dshb_course_enrollments_types'] = 'Tipos de Inscripción al Curso';
$string['adm_dshb_report_activity_stats_summary'] = 'Resumen del Reporte de Estadísticas de Actividad';
$string['adm_dshb_report_quiz_activity_detail'] = 'Detalle del Reporte  de Actividad de Examen';
$string['adm_dshb_report_user_status'] = 'Estado del Reporte del Usuario';
$string['adm_dshb_user_enr_sess_compl_act_lvls'] = 'Inscripción de usuario, Sesión, Niveles de Finalización de Actividad';
$string['adm_dshb_user_enrol_with_compl_overview'] = 'Inscripciones a Curso con Vista General de Finalización';
$string['adm_dshb_user_map'] = 'Mapa del Usuario';
$string['adm_dshb_user_site_summary_details'] = 'Detalles de Resumen del Sitio del Usuario';
$string['admin_dashboard'] = 'Tablero del Admin';
$string['adv_settings'] = 'Configuraciones Avanzadas';
$string['ajax'] = 'Frecuencia';
$string['ajax_desc'] = 'Frecuencia de almacenamiento de sesión via AJAX. 0 - AJAX deshabilitada (en segundos)';
$string['all_cohorts'] = 'Todas las cohortes';
$string['all_courses'] = 'Todos los cursos';
$string['all_data'] = 'Todos los datos';
$string['all_fields_required'] = 'Todos los campos requeridos';
$string['all_modules'] = 'Todos los módulos';
$string['all_selected'] = 'Todos seleccionados';
$string['all_time'] = 'Todo el tiempo';
$string['allmod'] = 'Todas las actividades';
$string['analityc_3_name'] = 'Vista General y Detalle de Pregunta';
$string['analytics'] = 'Analítica';
$string['answers'] = 'Respuestas';
$string['api'] = 'API Alterna';
$string['api_desc'] = 'Usar servidor de API Alterno (para evitar bloqueo por firewall)';
$string['assignment_name'] = 'Nombre de Tarea';
$string['assignments'] = 'Tareas';
$string['attendance'] = 'Asistencia';
$string['attendanceapibase'] = 'Ruta base de API de asistencia';
$string['attendanceapikey'] = 'Clave API de asistencia';
$string['attendanceapisecret'] = 'Secreto API de asistencia';
$string['attendanceconsumerkey'] = 'Clave del consumidor';
$string['attendancesharedsecret'] = 'Secreto compartido';
$string['attendancetoolurl'] = 'URL de Herramienta';
$string['authentication'] = 'Creación de Cuenta';
$string['authorized_user_descr'] = 'IntelliBoard requiere un usuario autorizado. Muy probablemente el usuario autorizado será un Administrador del Sitio y debe tener privilegios para gestionar servicios web, protocolos y tokens.Para una revisión adicional, vaya a ala Administración del sitio > Plugins > Servicios web > Servicios externos > Servicio Intelliboard > Usuario autorizado';
$string['average_grade'] = 'calificación promedio';
$string['avg_score'] = 'Puntaje Promedio';
$string['avg_time_spent_per_stud'] = 'Tiempo Promedio Empleado Por Estudiante';
$string['avg_visits_per_stud'] = 'Visitas Promedio Por Estudiante';
$string['bb_col_api_endpoint'] = 'Punto final de la API de BlackBoard Collaborate';
$string['bb_col_consumer_key'] = 'Clave de consumidor de Blackboard Collaborate';
$string['bb_col_meetings'] = 'Reuniones de Blackboard Collaborate';
$string['bb_col_secret'] = 'Secreto de Blackboard Collaborate';
$string['bbbapiendpoint'] = 'Endpoint de API BBB';
$string['bbbmeetings'] = 'Reuniones de BigBlueButton';
$string['bbbserversecret'] = 'Secreto de servidor BBB';
$string['billingcycles'] = 'Ciclos de Facturación';
$string['cache_compresstracking'] = 'Guardar a Caché de Moodle';
$string['cachedef_bb_collaborate_access_token'] = 'Token de acceso de Blackboard Collaborate';
$string['cachedef_instructor_course_data'] = 'Caché para datos del curso';
$string['cachedef_reports_list'] = 'Caché para lista de reportes';
$string['cachedef_track_config'] = 'Datos totales de Monitoreo Intelliboard';
$string['cachedef_tracking'] = 'Datos de Monitoreo de Intelliboard';
$string['cancel_subscription'] = 'Cancelar suscripción';
$string['canceled'] = 'Cancelado';
$string['categories'] = 'Categorías';
$string['category'] = 'Categoría';
$string['check_active_bb_col_meetings'] = 'Comprobar Reunión Activa de Blackboard Collaborate';
$string['check_active_meetings'] = 'Revisar reuniones activas';
$string['cipherlist'] = 'CURLOPT SSL CIPHER LIST';
$string['cipherlist_desc'] = 'Especificar cifrado a usar para TLS';
$string['city'] = 'Ciudad/Población';
$string['class_average'] = 'Promedio de la clase';
$string['click_link_below_support_pages'] = 'Haga clic en el enlace para acceder a las páginas de soporte de IntelliBoard:';
$string['close'] = 'Cerrar';
$string['closed'] = 'Cerrado';
$string['cohorts'] = 'Cohortes';
$string['completed'] = 'Completado/a';
$string['completed_activities'] = 'Actividades Completadas';
$string['completed_activities_resources'] = 'Actividades/Recursos Completados';
$string['completed_activities_resourses'] = 'Actividades/Recursos Completados';
$string['completed_courses'] = 'Cursos Completados';
$string['completed_on'] = 'Completado en {$a}';
$string['completion'] = 'Finalización';
$string['completion_is_not_enabled'] = 'La finalización no está habilitada para este curso';
$string['completion_not_enabled'] = 'Finalización No Habilitada';
$string['completion_status'] = 'Estatus de finalización';
$string['completions'] = 'Estatus de Finalización de Actividad';
$string['completions_completed'] = 'Estatus de Finalización (completado)';
$string['completions_desc'] = '1) El usuario ha completado esta actividad. No se especificó si la ha aprobado o reprobado. <br>
2) El usuario ha completado esta actividad con una calificación arriba del puntaje aprobatorio. <br>
3) El usuario ha completado esta actividad pero su calificación es menos del puntaje aprobatorio.';
$string['completions_fail'] = 'Estatus de Finalización (reprobado)';
$string['completions_pass'] = 'Estatus de Finalización (aprobado)';
$string['compresstracking'] = 'Monitoreo de Compresión';
$string['compresstracking_desc'] = 'Escribir datos de Monitoreo del Tiempo a archivo, o redis, y transferir datos a base de datos con trabajo cron (predeterminado cada 15 minutos)';
$string['confirm_and_sign_up'] = 'Confirmar y Apuntarse';
$string['congratulations_intb_register'] = 'Felicitaciones';
$string['congratulations_intb_register_msg'] = '¡Gracias por iniciar su prueba gratuita por 15 días con IntelliBoard!  Por favor revise su Email para confirmar su cuenta Intelliboard. Para comenzar, utilice el enlace del Ingreso Único  Single Sign On (SSO) , si estuviera habilitado desde la Administración del sitio > Intelliboard, o ingrese <a href="https://app.intelliboard.net/signin">aquí</a>.  El enlace para Ingreso Único se lee como “INTELLIBOARD.NET” y está en la esquina superior derecha del Tablero. Si usted tiene preguntas, por favor póngase en contacto con  Support@IntelliBoard.net.';
$string['cor_incor_answers'] = 'Respuestas Correctas/Incorrectas';
$string['correct'] = 'Correcta';
$string['correct_number'] = 'Correctas {$a}';
$string['correlations'] = 'Correlaciones';
$string['country'] = 'País';
$string['course'] = 'Curso';
$string['course_activities'] = 'Habilitar actividades del curso';
$string['course_category'] = 'Categoría de Curso';
$string['course_chart'] = 'Habilitar gráfica del curso';
$string['course_completion_status'] = 'Estatus de Finalización de Curso';
$string['course_completions'] = 'Finalizaciones de Curso';
$string['course_enrollment_types'] = 'Tipos de Inscripción al Curso';
$string['course_enrollments_with_completion_overview'] = 'Inscripciones a Curso con Vista General de Finalización';
$string['course_grade'] = 'Calificación del Curso';
$string['course_idnumber'] = 'Número ID';
$string['course_max_grade'] = 'Calificación máxima del curso';
$string['course_name'] = 'Nombre del Curso';
$string['course_name_a'] = 'Curso: {$a}';
$string['course_overview'] = 'Vista General del Curso';
$string['course_progress'] = 'Progreso del curso';
$string['course_short_name'] = 'Nombre Corto del Curso';
$string['course_start_date'] = 'Fecha de inicio del curso';
$string['course_started'] = 'Curso iniciado';
$string['course_status'] = 'Estado';
$string['course_success'] = 'Éxito del Curso';
$string['courseaverage'] = 'Promedio del Curso';
$string['coursecontainer_filter'] = 'Habilitar filtro de contenedor de curso';
$string['courses'] = 'Cursos';
$string['courses_avg_grade'] = 'Calif. promedio del curso';
$string['courses_in_progress'] = 'Cursos en progreso';
$string['courses_sum_grade'] = 'Cursos Sumar Calificación por Valor de Escala de Calificación';
$string['coursessessions'] = 'Sesiones del Curso';
$string['coursessessionspage'] = 'Página de Sesiones del curso';
$string['created'] = 'Creado';
$string['criteria_all_courses'] = 'Todos los cursos siguientes tienen que ser completados';
$string['criteria_any_course'] = 'Cualquiera de los cursos siguientes tiene que ser completado';
$string['criteria_method'] = 'Método del criterio';
$string['csv'] = 'CSV';
$string['current_grade'] = 'Calificación Actual';
$string['custommenuitem'] = 'Mostrar en Menú Personalizado';
$string['customod'] = 'Actividades personalizadas';
$string['daily'] = 'Últimos 10 días';
$string['dashboard'] = 'Tablero';
$string['dashboard_link'] = 'Hacer clic para ver Analítica';
$string['dashboard_settings'] = 'Configuraciones del tablero';
$string['date_created'] = 'Fecha de Creado';
$string['date_format'] = 'Formato de fecha';
$string['debug'] = 'Depurar solicitudes CURL';
$string['debug_desc'] = '';
$string['delete_message'] = '¿Eliminar reporte SQL?';
$string['department'] = 'Departamento';
$string['details'] = 'Detalles';
$string['disable_time_and_visits_users_overview'] = 'Deshabilitar Tiempo empleado y visitas en Vista General de Usuarios';
$string['disabled'] = 'Deshabilitado';
$string['do_not_use_compresstracking'] = 'No usar Monitoreo de Compresión';
$string['done'] = '¡Hecho!';
$string['downloadinvoice'] = 'Descargar Factura';
$string['due_date'] = 'Fecha esperada';
$string['email'] = 'Email';
$string['email_is_required'] = 'Email es requerido';
$string['email_subscr'] = 'Email de suscripción';
$string['enable_badges_report'] = 'Habilitar reporte de "Insignias"';
$string['enable_bb_col_debug'] = 'Habilitar depuración de Blackboard Collaborate';
$string['enable_bb_col_meetings'] = 'Habilitar Reuniones de Blackboard Collaborate';
$string['enable_sso'] = 'Habilitar enlace para Ingreso Único Single Sign On (SSO)';
$string['enable_sso_descr'] = 'Habilite el enlace de inicio de sesión único para que los administradores del sitio puedan acceder con un solo clic al acceso de SuperAdmin de IntelliBoard en app.IntelliBoard.net';
$string['enable_time_and_visits_users_overview'] = 'Habilitar tiempo empleado y visitas en Cista General de Usuarios';
$string['enable_time_tracking'] = 'Habilitar Monitoreo del Tiempo';
$string['enable_time_tracking_descr'] = 'Habilite el seguimiento del tiempo para obtener información adicional sobre el acceso de los usuarios, las visitas y el tiempo empleado. IntelliBoard proporciona información adicional sobre el seguimiento del tiempo de forma independiente de las tablas de tiempo empleado de Moodle.';
$string['enable_transcripts'] = 'Habilitar Transcripciones';
$string['enable_vendor_frontpage_course'] = 'Habilitar el curso en la Portada en los reportes para vendedores';
$string['enable_webservice'] = 'Habilitar Servicios Web';
$string['enableattendance'] = 'Habilitar asistencia';
$string['enablebbbdebug'] = 'Modo depuración de BigBlueButton';
$string['enablebbbmeetings'] = 'Habilitar monitoreo de reuniones BigBlueButton';
$string['enabled'] = 'Seguimiento Habilitado';
$string['enabled_desc'] = 'Habilitar Seguimiento';
$string['enableexportcustomfont'] = 'Font Compatible Chino/Japonés';
$string['enablesyncattendance'] = 'Habilitar sincronización de sesiones de Blackboard Collaborate con InAttendance';
$string['enroled_on'] = 'Fecha de inscripción';
$string['enrolled'] = 'Inscrito';
$string['enrolled_completed'] = 'Inscritos: {$a->courses}, Completados: {$a->completed_courses}';
$string['enrolled_completed_learners'] = 'Estudiantes Inscritos/Completados';
$string['enrolled_date'] = 'Fecha inscrito';
$string['enrolled_users_completed'] = 'Usuarios inscritos: {$a->users}, Completados: {$a->completed}';
$string['enrollments'] = 'Inscripciones';
$string['enrolment_expiration'] = 'Expiración de la Inscripción';
$string['enrolment_method'] = 'Método de Inscripción';
$string['enter_course_and_quiz'] = 'Por favor seleccione su curso y su examen.';
$string['enter_quiz'] = 'Por favor seleccione su examen.';
$string['excel'] = 'Excel';
$string['expired'] = 'Expirado';
$string['failed'] = 'Reprobado';
$string['failed_on'] = 'Completado (reprobado) en {$a}';
$string['file_compresstracking'] = 'Guardar en MoodleData';
$string['filter1'] = 'Usuarios eliminados';
$string['filter1_desc'] = 'Mostrar usuarios eliminados';
$string['filter2'] = 'Usuarios suspendidos';
$string['filter2_desc'] = 'Mostrar usuarios suspendidos';
$string['filter3'] = 'Usuario invitado';
$string['filter3_desc'] = 'Mostrar usuario [invitado] en reportes';
$string['filter4'] = 'Filtro de curso';
$string['filter4_desc'] = 'Mostrar cursos no visibles';
$string['filter5'] = 'Filtro de método de inscripción';
$string['filter5_desc'] = 'Mostrar métodos de inscripción no activos';
$string['filter6'] = 'Filtro de inscripción de usuario';
$string['filter6_desc'] = 'Mostrar usuarios con estatus de inscripción no activa';
$string['filter7'] = 'Filtro de Actividades/Recursos';
$string['filter7_desc'] = 'Mostrar Actividades/Recursos no visibles';
$string['filter8'] = 'Filtro de usuarios inscritos';
$string['filter8_desc'] = 'Mostrar solamente usuarios inscritos (no recomendado)';
$string['filter_all_time'] = 'Filtro de tiempo: Todo el Tiempo';
$string['filter_dates'] = 'Filtrar fechas:';
$string['filter_last_year'] = 'Filtro de tiempo: Año Pasado';
$string['filter_this_year'] = 'Filtro de tiempo: Este Año';
$string['filters'] = 'Filtros de Tablero';
$string['first_access'] = 'Primer Acceso';
$string['first_name'] = 'Nombre';
$string['firstname_lastname'] = '(Nombre) (Apellidos)';
$string['goal_grade'] = 'Calificación Meta';
$string['grade'] = 'Calificación';
$string['grade_activities_overview'] = 'Vista General de Actividades Calificadas';
$string['graded'] = 'Calificado';
$string['grades'] = 'Calificaciones';
$string['grades_alt_text'] = 'Texto alternativo para menú de navegación';
$string['grid_view'] = 'Vista de Rejilla';
$string['group_aggregation'] = 'Agregación de grupo';
$string['help'] = '¿Necesita ayuda?';
$string['highest_grade'] = 'Calificación Más Alta';
$string['hosting_provider'] = 'Proveedor de alojamiento';
$string['ianalytics'] = 'Analítica de Intelliboard';
$string['id_number'] = 'Número ID';
$string['import'] = 'Importar';
$string['importing_logs'] = 'Bitácoras de importación';
$string['importing_totals'] = 'Totales de importación';
$string['importtrackingtask'] = 'Trabajo de Importar Monitoreo';
$string['in1'] = 'Vista General';
$string['in10'] = 'Utilización de Evento';
$string['in11'] = 'Progreso del estudiante';
$string['in12'] = 'Progreso de Calificación';
$string['in13'] = 'Tiempo Empleado (%)';
$string['in14'] = '% Progreso';
$string['in15'] = 'Finalizaciones del estudiante';
$string['in16'] = 'Último Acceso';
$string['in17'] = 'Tiempo Total Empleado';
$string['in18'] = 'Visitas Totales';
$string['in19'] = 'Calificación Promedio';
$string['in2'] = 'Progreso Actual';
$string['in20'] = 'Regresar a Estudiantes';
$string['in201'] = 'Regresar a Actividades';
$string['in21'] = 'Calificación Promedio del Curso';
$string['in22'] = 'Habilitado';
$string['in23'] = 'Usted no tiene estudiantes para mostrar';
$string['in24'] = 'Módulo';
$string['in25'] = 'Calificación Aprobatoria';
$string['in26'] = 'Compromiso del Estudiante';
$string['in27'] = 'Total de Estudiantes';
$string['in28'] = 'Tiempo Empleado Promedio';
$string['in29'] = 'Estudiantes Activos';
$string['in3'] = 'Cursos Totales';
$string['in30'] = 'Estudiantes No Activos';
$string['in31'] = 'Utilización de la Actividad';
$string['in32'] = 'Tiempo promedio dentro del período seleccionado';
$string['in33'] = 'Utilización del tópico';
$string['in34'] = 'Progreso de Calificación del Estudiante';
$string['in4'] = 'Estudiantes Totales';
$string['in5'] = 'Calificaciones Totales de Curso';
$string['in6'] = 'Estudiantes Completados';
$string['in7'] = 'Estudiantes Incompletos';
$string['in8'] = 'Calificación Promedio de estudiante';
$string['in9'] = 'Correlaciones';
$string['inactivity'] = 'Inactividad';
$string['inactivity_desc'] = 'Tiempo de inactividad del usuario (en segundos)';
$string['incomplete'] = 'Incompleto';
$string['incorrect'] = 'Incorrecta';
$string['incorrect_number'] = 'Incorrectas {$a}';
$string['initial_reports'] = 'Reportes Iniciales';
$string['initial_reports_warning'] = 'Para enviar por correo electrónico, programar y personalizar aún más estos informes, haga clic en “<a href="{$a}">Conectar y actualizar</a>”.';
$string['inprogress'] = 'En progreso';
$string['institution'] = 'Institución';
$string['instructor_course_shortname'] = 'Mostrar nombre corto del curso en lugar del nombre completo del curso';
$string['instructor_course_visibility'] = 'Mostrar cursos ocultos/suspendidos para [instructor]';
$string['instructor_courses_table_name'] = 'Calificaciones del Curso';
$string['instructor_courses_table_name_activities'] = 'Curso {$a->fullname}, Actividades';
$string['instructor_courses_table_name_activity'] = 'Curso {$a->course}, Actividad {$a->name}, Calificaciones';
$string['instructor_courses_table_name_learner'] = 'Curso{$a->course}, Estudiante {$a->learner}, Calificaciones';
$string['instructor_courses_table_name_learners'] = 'Currso {$a->fullname}, Estudiantes';
$string['instructor_custom_groups'] = 'Grupos personalizados del instructor';
$string['instructor_hide_need_help'] = 'Ocultar botón "Necesito ayuda"';
$string['instructor_hide_suspended_enrollments'] = 'Ocultar inscripciones suspendidas';
$string['instructor_mode'] = 'Mostrar todos los cursos disponibles para [instructor]';
$string['instructor_mode_access'] = 'Mostrar todos los cursos disponibles para [instructor] con permisos para [update]';
$string['instructor_redirect'] = 'Redirección a Instructor';
$string['instructor_show_suspended_enrollments'] = 'Mostrar inscripciones suspendidas';
$string['intb_settings_descr'] = 'IntelliBoard requiere un correo electrónico de suscripción principal y único. Ingrese el correo electrónico que desea utilizar como correo electrónico de suscripción a continuación. El correo electrónico debe verificarse dos veces mediante una confirmación por correo electrónico antes de su uso. Si tiene preguntas, comuníquese con <a href=\'mailto:Support@IntelliBoard.net\'>Support@IntelliBoard.net</a>. Para obtener una lista completa de las configuraciones de IntelliBoard, vaya a Administración del sitio > Plugins > Plugins locales > IntelliBoard';
$string['intelliBoard_migration_tool'] = 'Herramienta de Migración IntelliBoard';
$string['intelliBoard_migration_tool_info'] = 'La herramienta de migración IntelliBoard es usada para migrar datos históricos desde la tabla de bitácoras de Moodle hacia formatos nuevos. Por favor tenga en cuenta que el procedimiento de Moodle para almacenar bitácoras no cambiará. Una vez que los datos históricos sean migrados al nuevo formato, los valores históricos como \'Tiempo Empleado\' y \'Visitas\' estarán disponibles para vista previa en IntelliBoard.net.';
$string['intelliboard:attendanceadmin'] = 'Administración de Asistencia';
$string['intelliboard:browseallcohorts'] = 'Intelliboard [Mirara Todas las Cohortes]';
$string['intelliboard:competency'] = 'IntelliBoard [competencia]';
$string['intelliboard:instructors'] = 'IntelliBoard [instructor]';
$string['intelliboard:manage'] = 'IntelliBoard [mánager]';
$string['intelliboard:students'] = 'IntelliBoard [estudiante]';
$string['intelliboard:view'] = 'IntelliBoard [ver]';
$string['intelliboard_logs'] = 'Bitácoras de IntelliBoard';
$string['intelliboard_reports'] = 'Reportes de Intelliboard';
$string['intelliboard_settings'] = 'Configuraciones de Intelliboard';
$string['intelliboard_start_tracking'] = 'IntelliBoard iniciar seguimiento';
$string['intelliboard_terms'] = 'Acuerdos de Intelliboard';
$string['intelliboard_totals'] = 'Totales de IntelliBoard';
$string['intelliboard_tracking'] = 'Seguimiento de IntelliBoard';
$string['intelliboardaccess'] = 'Usted no tiene permsiso para ver esta página. Por favor contacte a su Administración para ayuda.';
$string['intelliboardnet'] = 'IntelliBoard.net';
$string['intelliboardroot'] = 'IntelliBoard';
$string['intellicart'] = 'Integración IntelliCart';
$string['intellicart_app_reports_integration'] = 'Integración con Reportes de Intelliboard';
$string['intellicart_desc'] = 'Permitirle a estudiantes ver reportes IntelliCart.';
$string['intellicart_instructor_integration'] = 'Integración con Tablero del Istructor';
$string['intellicart_student_integration'] = 'Integración con Tablero del Estudiante';
$string['invalid_email'] = 'Email inválido';
$string['invalid_user'] = 'Usuario inválido';
$string['issuer'] = 'Emisor';
$string['items_per_query'] = 'Ítems por consulta';
$string['join_a_webinar'] = 'Unirse a un Webinar';
$string['key'] = 'Clave';
$string['last_access'] = 'Último Acceso';
$string['last_access_on_course'] = 'Último acceso al cursoe: {$a}';
$string['last_day'] = 'día';
$string['last_hour'] = 'hora';
$string['last_month'] = 'Últimos 30 días';
$string['last_name'] = 'Apellido(s)';
$string['last_quarter'] = 'Últimos 3 Meses';
$string['last_semester'] = 'Últimos 6 Meses';
$string['last_week'] = 'Últimos 7 Días';
$string['last_year'] = 'Año Pasado';
$string['lastname_firstname'] = '{Apellidos} {Nombre}';
$string['learner_menu'] = 'Mostrar "Tablero del Alumno" en el menú del bloque de navegación solo para alumnos inscritos';
$string['learner_name'] = 'Nombre del Estudiante';
$string['learner_tf_last_week'] = 'Filtro de tiempo: 7 Días';
$string['learners'] = 'Estudiantes';
$string['learners_enrolled'] = 'Estudiantes inscritos';
$string['learners_enrolled_period'] = 'Estudiantes inscritos dentro del período seleccionado';
$string['learning'] = 'Aprendizaje';
$string['learning_plan_filter'] = 'Filtro de Plan de Aprendizaje';
$string['learning_plan_viewer_role'] = 'Rol de "Visor de Plan de Aprendizaje"';
$string['learning_progress'] = 'Progreso del Aprendizaje';
$string['letter'] = 'Carta';
$string['list_view'] = 'Vista de Lista';
$string['load'] = 'Desempeño';
$string['loading'] = 'Cargando...';
$string['loading2'] = 'Por favor espere, cargando...';
$string['local_intelliboard_bb_collaborate_api_request_finished'] = 'Solicitud API terminada para BB Collaborate';
$string['local_intelliboard_bb_collaborate_session_tracking_finished'] = 'Terminó monitoreo de sesión de BB Collaborate';
$string['local_intelliboard_bb_collaborate_session_tracking_started'] = 'Inició monitoreo de sesión de BB Collaborate';
$string['log_values_include'] = 'Valores de bitácoras incluyen bitácoras para cada usuario por día.';
$string['logs'] = 'Herramienta para Migración';
$string['logs_to_process'] = 'Bitácoras a procesar {$a}';
$string['lowest_grade'] = 'Calificación Más Baja';
$string['messageprovider:intelliboard_notification'] = 'Notificación Intelliboard';
$string['messages'] = 'Mensajes';
$string['modulename'] = 'NombreMi Calificación del módulo';
$string['modules'] = 'Módulos';
$string['monitors'] = 'Monitores';
$string['monitorselect'] = 'Por favor seleccione al menos un Monitor de App.Intelliboard.net. Haga clic en Monitores, después en Configuraciones de Monitores, y selecciónelo  en "Visible en Moodle".';
$string['monthly'] = 'Últimos 365 días';
$string['moodle'] = 'Moodle';
$string['moodle_logs'] = 'Bitácoras de Moodle';
$string['moodle_settings'] = 'Configuraciones de Moodle';
$string['more_courses'] = 'Más cursos';
$string['more_users'] = 'Más usuarios';
$string['my_course_average_all'] = 'mi promedio del curso (todos los cursos)';
$string['mygrade'] = 'Mi Calificación';
$string['myorders'] = 'Órdenes';
$string['myprogress'] = 'Mi progreso de calificación';
$string['myseats'] = 'Asientos';
$string['mysqldaymonth'] = '%d %b %Y';
$string['mysqldayshortmonthyear'] = '%d %b, %Y';
$string['mysqlhour'] = '%h:%i %p';
$string['mysqlmonth'] = '%c';
$string['mysqlmonthdayyear'] = '%m/%d/%Y';
$string['mysqlmonthyear'] = '%M %Y';
$string['mysqlmonthyearday'] = '%M %Y, %d';
$string['mysqlquarter'] = 'trimestre';
$string['mysqltimedate'] = '%h:%i%p, %d %b %Y';
$string['mysqltimemonthdayyear'] = '%H %m/%d/%Y';
$string['mysqlweek'] = '%Y, semana %v';
$string['mysqlyear'] = '%Y';
$string['mysubscriptions'] = 'Suscripciones';
$string['mywaitlist'] = 'Lista de espera';
$string['n1'] = 'Vista General [Progreso del Estudiante]';
$string['n10'] = 'Tablero del Instructor';
$string['n101'] = 'Habilitar Tablero del Instructor';
$string['n11'] = 'Texto alterno para Menú del Bloque de Navegación';
$string['n12'] = 'Vista General [Vista General del Curso]';
$string['n13'] = 'Total de Estudiantes';
$string['n14'] = 'Widget: Compromiso del Estudiante';
$string['n15'] = 'Widget: Uso de Actividad';
$string['n16'] = 'Widget: Uso de Tópico';
$string['n17'] = 'Página de analítica';
$string['n18'] = 'Widget: Progreso de Calificación del Estudiante';
$string['n19'] = 'Enlace a Navegación del Curso para Reportes';
$string['n2'] = 'Vista General [Progreso de Calificación]';
$string['n3'] = 'Vista General [Progreso de Actividad]';
$string['n4'] = 'Vista General [Totales]';
$string['n5'] = 'Progreso Actual';
$string['n6'] = 'Widget: Correlaciones';
$string['n7'] = 'Widget: Utilización de Evento';
$string['n8'] = 'Página de Curso';
$string['n9'] = 'Página de Reportes';
$string['name'] = 'Nombre';
$string['names_order'] = 'Ordenamiento de nombres';
$string['next'] = 'Siguiente';
$string['no_competency'] = 'Parece que Usted no tiene competencias habilitadas en su sitioMoodle.';
$string['no_data'] = 'Sin datos';
$string['no_data_notification'] = 'No hay datos nuevos para [fecha]';
$string['not_connected'] = 'No conectado';
$string['not_quiz'] = 'Ups, parece que Usted no tiene ningún examen creado para el curso seleccionado.';
$string['notstarted'] = 'No iniciado';
$string['num_attempts'] = '# de Intentos';
$string['num_completed_activity'] = '# de Usuarios que Completaron Esta Actividad';
$string['number_of_completed_learners'] = '# de Usuario(s) Completados';
$string['number_of_learners'] = '# de Usuario(s) Inscritos';
$string['number_of_modules'] = '# de Actividad(es)';
$string['number_of_sessions'] = 'Número de sesiones';
$string['number_of_visits'] = 'Visita(s)';
$string['number_this_week'] = '{$a} esta semana';
$string['number_today'] = '{$a} hoy';
$string['numberofseats'] = 'Número de asientos';
$string['ok'] = 'OK';
$string['overall_course_average'] = 'promedio general del curso (todos los estudiantes; todos los cursos)';
$string['participation'] = 'Participación';
$string['passed'] = 'Aprobado';
$string['passed_on'] = 'Completado (aprobado) en {$a}';
$string['passing_score_for'] = 'Calificación aprobatoria para {$a}';
$string['password'] = 'Contraseña';
$string['pdf'] = 'PDF';
$string['percentage_completed_learners'] = 'Porcentaje de Estudiantes Completados';
$string['please_accept_terms_and_conditions'] = 'Por favor acepte los términos y condiciones';
$string['please_wait_or_cancel'] = 'Por favor espere para continuar o <a href="{$a}">Cancelar</a>';
$string['pluginname'] = 'Plugin IntelliBoard.net';
$string['postgredaymonth'] = 'DD Mes AAAA';
$string['postgredayshortmonthyear'] = 'DD Mes, AAAA';
$string['postgrehour'] = 'HH12:MI AM';
$string['postgremonth'] = 'MM';
$string['postgremonthdayyear'] = 'MM/DD/AAAA';
$string['postgremonthyear'] = 'Mes AAAA';
$string['postgremonthyearday'] = 'Mes AAAA, DD';
$string['postgrequarter'] = 'trimestre';
$string['postgrequarteryear'] = 'T AAAA';
$string['postgretimedate'] = 'HH12:MIAM, DD Mes AAAA';
$string['postgretimemonthdayyear'] = 'HH24 MM/DD/AAAA';
$string['postgreweek'] = 'AAAA, "semana" SSS';
$string['postgreyear'] = 'AAAA';
$string['powered_by'] = 'Impulsado por  <a href="https://intelliboard.net/">IntelliBoard</a>';
$string['price'] = 'precio';
$string['privacy:metadata:local_intelliboard_assign'] = 'Tabla de subcuentas de Intelliboard assigns';
$string['privacy:metadata:local_intelliboard_assign:instance'] = 'ID de Instancia Moodle Conectada';
$string['privacy:metadata:local_intelliboard_assign:rel'] = 'Tipo de registro rel';
$string['privacy:metadata:local_intelliboard_assign:timecreated'] = 'Graba Sello de Tiempo';
$string['privacy:metadata:local_intelliboard_assign:type'] = 'Tipo de Instancia Moodle';
$string['privacy:metadata:local_intelliboard_assign:userid'] = 'ID del USUARIO del registro';
$string['privacy:metadata:local_intelliboard_att_sync'] = 'Lista de sesiones sincronizadas';
$string['privacy:metadata:local_intelliboard_att_sync:data'] = 'Datos adicionales de sincronización';
$string['privacy:metadata:local_intelliboard_att_sync:id'] = 'ID de bitácora de sincronización';
$string['privacy:metadata:local_intelliboard_att_sync:instance'] = 'ID de sesión Moodle';
$string['privacy:metadata:local_intelliboard_att_sync:type'] = 'Tipo de sesión';
$string['privacy:metadata:local_intelliboard_bb_partic'] = 'Lista de participantes de sesión colaborativa';
$string['privacy:metadata:local_intelliboard_bb_partic:display_name'] = 'Nombre del usuario';
$string['privacy:metadata:local_intelliboard_bb_partic:duration'] = 'Tiempo empleado en sesión';
$string['privacy:metadata:local_intelliboard_bb_partic:external_user_id'] = 'ID del usuario (Moodle)';
$string['privacy:metadata:local_intelliboard_bb_partic:first_join_time'] = 'Primera unión a sesión';
$string['privacy:metadata:local_intelliboard_bb_partic:id'] = 'ID de participación en sesión';
$string['privacy:metadata:local_intelliboard_bb_partic:last_left_time'] = 'Última salida de sesión';
$string['privacy:metadata:local_intelliboard_bb_partic:rejoins'] = 'Número de reingresos a sesión';
$string['privacy:metadata:local_intelliboard_bb_partic:role'] = 'Rol de sesión';
$string['privacy:metadata:local_intelliboard_bb_partic:sessionuid'] = 'UUID sesión';
$string['privacy:metadata:local_intelliboard_bb_partic:useruid'] = 'UUID de usuario (Servicio Collaborate)';
$string['privacy:metadata:local_intelliboard_bb_trck_m'] = 'Lista de sesiones monitoreadas';
$string['privacy:metadata:local_intelliboard_bb_trck_m:id'] = 'ID de bitácora de monitoreo';
$string['privacy:metadata:local_intelliboard_bb_trck_m:sessionuid'] = 'UUID de sesión';
$string['privacy:metadata:local_intelliboard_bb_trck_m:track_time'] = 'Monitorear tiempo';
$string['privacy:metadata:local_intelliboard_bbb_atten'] = 'Bitácora sobre asistentes de reuniones BigBlueButton';
$string['privacy:metadata:local_intelliboard_bbb_atten:arrivaltime'] = 'Hora cuando el usuario se conectó a la reunión';
$string['privacy:metadata:local_intelliboard_bbb_atten:departuretime'] = 'Hora cuando el usuario se desconectó de la reunión';
$string['privacy:metadata:local_intelliboard_bbb_atten:fullname'] = 'Nombre completo de asistente a reunión';
$string['privacy:metadata:local_intelliboard_bbb_atten:hasjoinedvoice'] = 'Bandera: Asistente tiene micrófono conectado';
$string['privacy:metadata:local_intelliboard_bbb_atten:hasvideo'] = 'Bandera: Asistente tiene webcam conectada';
$string['privacy:metadata:local_intelliboard_bbb_atten:id'] = 'ID del asistente';
$string['privacy:metadata:local_intelliboard_bbb_atten:islisteningonly'] = 'Bandera: Asistente no tiene conectado micrófono o webcam';
$string['privacy:metadata:local_intelliboard_bbb_atten:ispresenter'] = 'Bandera: Asistente está presente';
$string['privacy:metadata:local_intelliboard_bbb_atten:localmeetingid'] = 'ID de reunión (ID en table local_intelliboard_bbb_meet)';
$string['privacy:metadata:local_intelliboard_bbb_atten:meetingid'] = 'ID de reunión (ID ien servidor BigBlueButton)';
$string['privacy:metadata:local_intelliboard_bbb_atten:role'] = 'Rol del asistente a la reunión';
$string['privacy:metadata:local_intelliboard_bbb_atten:userid'] = 'ID delusuario (fila en tabla "usuario")';
$string['privacy:metadata:local_intelliboard_bbb_meet'] = 'Bitácora sobre reuniones BigBlueButton';
$string['privacy:metadata:local_intelliboard_bbb_meet:attendeepw'] = 'La contraseña que será exigida para que los asistentes se unan  a la reunión';
$string['privacy:metadata:local_intelliboard_bbb_meet:bigbluebuttonbnid'] = 'ID de fila en tabla bigbluebuttonbn';
$string['privacy:metadata:local_intelliboard_bbb_meet:cmid'] = 'ID del módulo del curso';
$string['privacy:metadata:local_intelliboard_bbb_meet:courseid'] = 'ID del curso';
$string['privacy:metadata:local_intelliboard_bbb_meet:createdate'] = 'Fecha de creación (cadena de caracteres)';
$string['privacy:metadata:local_intelliboard_bbb_meet:createtime'] = 'Hora de creación (sello de tiempo)';
$string['privacy:metadata:local_intelliboard_bbb_meet:dialnumber'] = 'El número a marcar al cual pueden llamar los participantes usando un teléfono regular.';
$string['privacy:metadata:local_intelliboard_bbb_meet:duration'] = 'Duración de la reunión';
$string['privacy:metadata:local_intelliboard_bbb_meet:endtime'] = 'Hora de fin de reunión';
$string['privacy:metadata:local_intelliboard_bbb_meet:hasbeenforciblyended'] = 'Bandera. Reunión fue terminada a la fuerza';
$string['privacy:metadata:local_intelliboard_bbb_meet:hasuserjoined'] = 'Bandera: Usuarios unidos a reunión';
$string['privacy:metadata:local_intelliboard_bbb_meet:id'] = 'ID de bitácora de reunión';
$string['privacy:metadata:local_intelliboard_bbb_meet:internalmeetingid'] = 'ID interna de Reunión (en servidor BBB)';
$string['privacy:metadata:local_intelliboard_bbb_meet:listenercount'] = 'Número de oyentes';
$string['privacy:metadata:local_intelliboard_bbb_meet:maxusers'] = 'Número máximo de participantes';
$string['privacy:metadata:local_intelliboard_bbb_meet:meetingid'] = 'ID de la reunión';
$string['privacy:metadata:local_intelliboard_bbb_meet:meetingname'] = 'Nombre de la reunión';
$string['privacy:metadata:local_intelliboard_bbb_meet:moderatorcount'] = 'Número de moderadores';
$string['privacy:metadata:local_intelliboard_bbb_meet:moderatorpw'] = 'La contraseña que será necesaria para que los moderadores se unan a la reunión o para ciertas acciones administrativas';
$string['privacy:metadata:local_intelliboard_bbb_meet:ownerid'] = 'ID del Propietario (usuario que creó la reunión)';
$string['privacy:metadata:local_intelliboard_bbb_meet:participantcount'] = 'Número de asistentes';
$string['privacy:metadata:local_intelliboard_bbb_meet:recording'] = 'Bandera: Reunión será grabada';
$string['privacy:metadata:local_intelliboard_bbb_meet:running'] = 'Estado de reunión (activa | detenida)';
$string['privacy:metadata:local_intelliboard_bbb_meet:starttime'] = 'Hora de inicio de sesión';
$string['privacy:metadata:local_intelliboard_bbb_meet:videocount'] = 'Número de participantes con video cámara conectada';
$string['privacy:metadata:local_intelliboard_bbb_meet:voicebridge'] = 'El número de la extensión para el conmutador (usar si se conecta a un sistema de conmutador)';
$string['privacy:metadata:local_intelliboard_bbb_meet:voiceparticipantcount'] = 'Número de participantes con micrófono conectado';
$string['privacy:metadata:local_intelliboard_details'] = 'Tabla Intelliboard alt/logs/por-hora';
$string['privacy:metadata:local_intelliboard_details:logid'] = 'ID de Tabla [local_intelliboard_logs]';
$string['privacy:metadata:local_intelliboard_details:timepoint'] = 'La Hora';
$string['privacy:metadata:local_intelliboard_details:timespend'] = 'La cantidad de tiempo invertido por hora';
$string['privacy:metadata:local_intelliboard_details:visits'] = 'En número de visitas, click del ratón, por día';
$string['privacy:metadata:local_intelliboard_logs'] = 'Tabla Intelliboard alt/logs/por-día';
$string['privacy:metadata:local_intelliboard_logs:timepoint'] = 'Sello de Tiempo de día en año';
$string['privacy:metadata:local_intelliboard_logs:timespend'] = 'Tiempo empleado, por día';
$string['privacy:metadata:local_intelliboard_logs:trackid'] = 'La ID de la tabla [local_intelliboard_tracking]';
$string['privacy:metadata:local_intelliboard_logs:visits'] = 'Visitas, clicks del ratón, por día';
$string['privacy:metadata:local_intelliboard_ntf'] = 'Tabla principal de notificaciones de Intelliboard';
$string['privacy:metadata:local_intelliboard_ntf:attachment'] = 'Anexo de notificación';
$string['privacy:metadata:local_intelliboard_ntf:cc'] = 'Notificación CC';
$string['privacy:metadata:local_intelliboard_ntf:email'] = 'Email de notificación';
$string['privacy:metadata:local_intelliboard_ntf:externalid'] = 'ID Externa de Notificación';
$string['privacy:metadata:local_intelliboard_ntf:id'] = 'ID de notificación';
$string['privacy:metadata:local_intelliboard_ntf:message'] = 'Mensaje de notificación';
$string['privacy:metadata:local_intelliboard_ntf:state'] = 'Estado de notificación';
$string['privacy:metadata:local_intelliboard_ntf:subject'] = 'Asunto de notificación';
$string['privacy:metadata:local_intelliboard_ntf:tags'] = 'Marcas de notificación';
$string['privacy:metadata:local_intelliboard_ntf:type'] = 'Tipo de notificación';
$string['privacy:metadata:local_intelliboard_ntf:userid'] = 'ID de App Externa de Notificación';
$string['privacy:metadata:local_intelliboard_ntf_hst'] = 'Tabla de historia de notificaciones de Intelliboard';
$string['privacy:metadata:local_intelliboard_ntf_hst:email'] = 'Email de historia de notificación';
$string['privacy:metadata:local_intelliboard_ntf_hst:id'] = 'ID de historia de notificación';
$string['privacy:metadata:local_intelliboard_ntf_hst:notificationid'] = 'ID de notificación';
$string['privacy:metadata:local_intelliboard_ntf_hst:notificationname'] = 'Nombre de notificación';
$string['privacy:metadata:local_intelliboard_ntf_hst:timesent'] = 'Sello de tiempo de historia de notificación';
$string['privacy:metadata:local_intelliboard_ntf_hst:userid'] = 'ID de App Externa de Notificación';
$string['privacy:metadata:local_intelliboard_ntf_pms'] = 'Tabla de parámetos dinámicos de notificaciones de Intelliboard';
$string['privacy:metadata:local_intelliboard_reports'] = 'Tabla dereportes SQL personalizados de Intelliboard';
$string['privacy:metadata:local_intelliboard_reports:name'] = 'Nombre de reporte personalizado';
$string['privacy:metadata:local_intelliboard_reports:sqlcode'] = 'Código SQL codificado en BASE64';
$string['privacy:metadata:local_intelliboard_reports:status'] = 'Estado de reporte -activado/no activado';
$string['privacy:metadata:local_intelliboard_reports:timecreated'] = 'Hora de creación';
$string['privacy:metadata:local_intelliboard_totals'] = 'Tabla Intelliboard alt/logs/total';
$string['privacy:metadata:local_intelliboard_totals:courses'] = 'Cursos Totales en Moodle';
$string['privacy:metadata:local_intelliboard_totals:sessions'] = 'Número Total de Sesiones de Usuario en Moodle.';
$string['privacy:metadata:local_intelliboard_totals:timepoint'] = 'Sello de Tiempo de día en año';
$string['privacy:metadata:local_intelliboard_totals:timespend'] = 'Tiempo Empleado por Todos los Usuarios en Moodle';
$string['privacy:metadata:local_intelliboard_totals:visits'] = 'Visitas Totales por Todos los Usuarios en Moodle';
$string['privacy:metadata:local_intelliboard_tracking'] = 'Tabla Intelliboard alt/logs/de-todo-el-tiempo';
$string['privacy:metadata:local_intelliboard_tracking:courseid'] = 'ID del curso que visita el usuario';
$string['privacy:metadata:local_intelliboard_tracking:firstaccess'] = 'Primer Acceso de Usuarios';
$string['privacy:metadata:local_intelliboard_tracking:lastaccess'] = 'Último Acceso de Usuarios';
$string['privacy:metadata:local_intelliboard_tracking:page'] = 'Tipo de Página [course,module,profile,site]';
$string['privacy:metadata:local_intelliboard_tracking:param'] = 'ID de Tipo de Página';
$string['privacy:metadata:local_intelliboard_tracking:timespend'] = 'Tiempo Empleado del Usuario en una Página';
$string['privacy:metadata:local_intelliboard_tracking:useragent'] = 'Tipo de Navegador del Usuario';
$string['privacy:metadata:local_intelliboard_tracking:userid'] = 'ID del Usuario que vista Página de Moodle.';
$string['privacy:metadata:local_intelliboard_tracking:userip'] = 'Última dirección IP de usuarios';
$string['privacy:metadata:local_intelliboard_tracking:userlang'] = 'Idioma del Navegador de Usuarios';
$string['privacy:metadata:local_intelliboard_tracking:useros'] = 'Sistema Operativo de Usuarios';
$string['privacy:metadata:local_intelliboard_tracking:visits'] = 'Visitas de Usuarios en una página';
$string['privacy:metadata:local_intelliboard_trns_c'] = 'Transcripciones de registros de cursos';
$string['privacy:metadata:local_intelliboard_trns_c:completeddate'] = 'Fecha de Finalización';
$string['privacy:metadata:local_intelliboard_trns_c:courseid'] = 'ID del curso';
$string['privacy:metadata:local_intelliboard_trns_c:coursename'] = 'Nombre completo del curso';
$string['privacy:metadata:local_intelliboard_trns_c:enroldate'] = 'Fecha de Inscripción';
$string['privacy:metadata:local_intelliboard_trns_c:enrolid'] = 'ID de registro de inscripción';
$string['privacy:metadata:local_intelliboard_trns_c:enroltype'] = 'Método de Inscripción';
$string['privacy:metadata:local_intelliboard_trns_c:finalgrade'] = 'Calificación Final';
$string['privacy:metadata:local_intelliboard_trns_c:firstname'] = 'Nombre del usuario';
$string['privacy:metadata:local_intelliboard_trns_c:formattedgrade'] = 'Calificación Formateada';
$string['privacy:metadata:local_intelliboard_trns_c:gradeid'] = 'ID de Calificación de Calificación';
$string['privacy:metadata:local_intelliboard_trns_c:gradeitemid'] = 'ID del Elemento de Calificación';
$string['privacy:metadata:local_intelliboard_trns_c:grademax'] = 'Calificación Máxima';
$string['privacy:metadata:local_intelliboard_trns_c:grademin'] = 'Calificación Mínima';
$string['privacy:metadata:local_intelliboard_trns_c:groupsids'] = 'Grupos del Usuario';
$string['privacy:metadata:local_intelliboard_trns_c:lastname'] = 'Apellido(s) del usuario';
$string['privacy:metadata:local_intelliboard_trns_c:rolesids'] = 'Roles del Usuario';
$string['privacy:metadata:local_intelliboard_trns_c:status'] = 'Estado de Transcripción';
$string['privacy:metadata:local_intelliboard_trns_c:timecreated'] = 'Sello de tiempo de cuando se creó el registro';
$string['privacy:metadata:local_intelliboard_trns_c:timemodified'] = 'Sello de tiempo de cuando se actualizó por última vez el registro';
$string['privacy:metadata:local_intelliboard_trns_c:unenroldate'] = 'Fecha de des-inscripción';
$string['privacy:metadata:local_intelliboard_trns_c:useremail'] = 'Email del usuario';
$string['privacy:metadata:local_intelliboard_trns_c:userenrolid'] = 'ID de transcripción de inscripción de usuario';
$string['privacy:metadata:local_intelliboard_trns_c:userid'] = 'ID del usuario';
$string['privacy:metadata:local_intelliboard_trns_m'] = 'Transcripción de registros de cursos';
$string['privacy:metadata:local_intelliboard_trns_m:cmid'] = 'ID de módulo de curso';
$string['privacy:metadata:local_intelliboard_trns_m:completeddate'] = 'Fecha de finalización';
$string['privacy:metadata:local_intelliboard_trns_m:courseid'] = 'ID del curso';
$string['privacy:metadata:local_intelliboard_trns_m:finalgrade'] = 'Calificación final';
$string['privacy:metadata:local_intelliboard_trns_m:formattedgrade'] = 'Calificación Formateada';
$string['privacy:metadata:local_intelliboard_trns_m:gradeid'] = 'ID de Califiicación';
$string['privacy:metadata:local_intelliboard_trns_m:gradeitemid'] = 'ID de elemento de calificación';
$string['privacy:metadata:local_intelliboard_trns_m:grademax'] = 'Calificación Máxima';
$string['privacy:metadata:local_intelliboard_trns_m:grademin'] = 'Calificación Mínima';
$string['privacy:metadata:local_intelliboard_trns_m:moduleid'] = 'ID del módulo';
$string['privacy:metadata:local_intelliboard_trns_m:modulename'] = 'Nombre de Actividad';
$string['privacy:metadata:local_intelliboard_trns_m:moduletype'] = 'Tipo de Módulo';
$string['privacy:metadata:local_intelliboard_trns_m:startdate'] = 'Fecha de Inicio';
$string['privacy:metadata:local_intelliboard_trns_m:status'] = 'Estado';
$string['privacy:metadata:local_intelliboard_trns_m:timecreated'] = 'Sello de tiempo de cuando fue creado el registro';
$string['privacy:metadata:local_intelliboard_trns_m:timemodified'] = 'Sello de tiempo de cuando fue actualizado el registropor última vez';
$string['privacy:metadata:local_intelliboard_trns_m:userenrolid'] = 'ID inscripción usuario transcripciones';
$string['privacy:metadata:local_intelliboard_trns_m:userid'] = 'ID del usuario';
$string['privacy_msg'] = 'Al activar esta casilla usted confirma que ha leido y está de acuerdo con nuestra Política de Privacidad.';
$string['privacy_policy'] = 'Política de Privacidad';
$string['privacy_shield_policy'] = 'Adendo de Procesamiento de Datos';
$string['process'] = 'Proceso';
$string['product'] = 'Producto';
$string['progress'] = 'Progreso';
$string['protocol'] = 'Protocolo';
$string['protocol_descr'] = 'Intelliboard requiere, ya sea que el protocolo REST o el protocolo SOAP estén habilitados. Para propósitos de seguridad, solamente deberían estar habilitados los protocolos que estén en uso. Para una revisión adicional, vaya a Administración del sitio > Plugins > Servidios web > Gestionar protocolos';
$string['protocols_descr'] = 'Intelliboard requiere, ya sea que el protocolo REST o el protocolo SOAP estén habilitados. Para propósitos de seguridad, solamente deberían estar habilitados los protocolos que estén en uso. Para una revisión adicional, vaya a Administración del sitio > Plugins > Servidios web > Gestionar protocolos';
$string['ques_breakdown'] = 'Desglose de Pregunta';
$string['quiz_finished'] = 'Examen terminado';
$string['quiz_grades'] = 'Calificaciones del examen';
$string['quiz_name'] = 'Nombre del Examen';
$string['quiz_name_a'] = 'Examen: {$a}';
$string['quizzes'] = 'Exámenes';
$string['recurringperiod'] = 'Período recurrente';
$string['registered'] = 'Registrado';
$string['registrations'] = 'Registros';
$string['remove_message'] = 'Reporte SQL ha sido eliminado';
$string['report'] = 'Reporte';
$string['report1_name'] = 'Estado del Usuario';
$string['report2_name'] = 'Estadísticas del Curso';
$string['report3_name'] = 'Resumen de Estadísticas de Actividad';
$string['report45_name'] = 'Detalles de Actividad de Examen';
$string['report_activity_stats_summary'] = 'Resumen de Estadísticas de Actividad';
$string['report_user_profile_information'] = 'Información del Perfil del Usuario';
$string['reports'] = 'Reportes';
$string['reportselect'] = 'Por favor seleccione al menos un reporte de App.Intelliboard.net. Haga clic en un Reporte, después en Configuraciones de Reporte, y selecciónelo  en "Visible en Moodle".';
$string['rest'] = 'REST';
$string['return_to_courses'] = 'Regresar a Cursos';
$string['return_to_grades'] = 'Regresar a Calificaciones';
$string['return_to_home'] = 'Regresar al inicio';
$string['return_to_sessions'] = 'Regresar a Sesiones';
$string['review_support_doc'] = 'Revisar documentación de Soporte';
$string['role1'] = 'Primer Rol';
$string['role2'] = 'Segundo Rol';
$string['s25'] = 'Tiempo empleado en actividad';
$string['s45'] = 'Actividad';
$string['s46'] = 'Porcentaje de estudiantes intentando';
$string['s47'] = 'Tópico';
$string['s48'] = 'Tiempo empleado en tópico';
$string['save'] = 'Guardar';
$string['scale_percentage'] = 'Porcentaje';
$string['scale_percentage_round'] = 'Porcentaje redondeado';
$string['scale_raw'] = 'Deshabilitar escala';
$string['scale_real'] = 'Mostrar calificación real en sustitución';
$string['scale_total'] = 'Calificación Total';
$string['scale_value'] = 'Valor';
$string['scales'] = 'Habilitar escala personalizada';
$string['scalesettings'] = 'Configuraciones de escala';
$string['score'] = 'Calificación';
$string['seatnumber'] = 'Número de Asientos';
$string['seatscode'] = 'Código de asientos';
$string['seatsused'] = 'Asiento usado';
$string['section'] = 'Sección';
$string['sections'] = 'Secciones';
$string['select'] = 'Seleccionar';
$string['select_course'] = 'Seleccionar curso';
$string['select_date'] = 'Seleccionar Fecha';
$string['select_manager_role'] = 'Seleccionar rol de mánager';
$string['select_quiz'] = 'Seleccionar examen';
$string['select_user'] = 'Seleccionar usuario';
$string['selectall'] = 'Seleccionar todo';
$string['self_hosted'] = 'Auto-Alojado';
$string['server'] = 'Servidor IntelliBoard';
$string['server_au'] = 'IntelliBoard Australia';
$string['server_error'] = '¡Ups! Pasó algo inesperado. Por favor póngase en contacto con nosotros en support@intelliboard.net';
$string['server_eu'] = 'IntelliBoard Europa';
$string['server_usa'] = 'IntelliBoard USA';
$string['session_name'] = 'Nombre de Sesión';
$string['session_time'] = 'Hora de Sesión';
$string['settings'] = 'Configuraciones';
$string['setup'] = 'Conectarse ahora';
$string['setup_subheading'] = 'Conéctese para experimentar el poder de sus datos. Sin tarjeta de crédito. Sin obligación, solo 15 días de un paraíso gratuito de datos.';
$string['shield_msg'] = 'Al activar esta casilla usted confirma que ha leido y está de acuerdo con nuestro Anexo sobre Procesamiento de Datos.';
$string['show_dashboard_tab'] = 'Página del Tablero';
$string['showing_1_to_10'] = 'Mostrando 1 a 10';
$string['sign_in'] = 'Ingresar';
$string['sign_up'] = 'Apuntarse';
$string['sizemode'] = 'Modo Tamaño: Grande ( > 5,000 Usuarios)';
$string['soap'] = 'SOAP';
$string['sqlreport'] = 'Reporte SQL';
$string['sqlreportactive'] = 'Activado';
$string['sqlreportcode'] = 'SQL';
$string['sqlreportcreate'] = 'Crear reporte';
$string['sqlreportdate'] = 'Creado En';
$string['sqlreportinactive'] = 'Desactivada';
$string['sqlreportname'] = 'Nombre del reporte';
$string['sqlreports'] = 'Reportes SQL';
$string['sslversion'] = 'CURLOPT SSLVERSION';
$string['sslversion_desc'] = 'Pase un parámetro long as para controlar qué rango de versiones de SSL/TLS utilizar';
$string['sso'] = 'Enlace SSO';
$string['sso_desc'] = 'Enlace SSO hacia IntelliBoard.net';
$string['ssodomain'] = 'Subdominio SSO';
$string['ssodomain_desc'] = 'Ingreso Único (Single Sign On) con Servidor/Cuenta separada';
$string['ssomenu'] = 'Elemento de Menú SSO';
$string['ssomenu_desc'] = 'Enlace SSO en menú del bloque de navegación (para no-alumnos/no-instructores)';
$string['status'] = 'Estatus';
$string['student_course_visibility'] = 'Mostrar cursos ocultos/suspendidos para [student]';
$string['student_grades'] = 'Calificaciones del estudiante';
$string['student_redirect'] = 'Redirección a Estudiante';
$string['subscriptiondate'] = 'Fecha de suscripción';
$string['success_message'] = 'Reporte SQL ha sido guardado';
$string['successfull_connected'] = 'Conectado exitosamente';
$string['support'] = 'Soporte';
$string['support_close'] = 'Cerrar';
$string['support_connect'] = 'Haga clic en los botones de informes dentro del rectángulo que aparece a continuación. Eche un vistazo al poder de IntelliBoard: acceso con un solo botón a la información de su LMS. ¿Quiere más? Haga clic en "Haga clic para ver Analytics". ¿Aún quiere más? <a href="{$a->connect_link}">“Conectar y actualizar”</a> en la parte superior derecha o en cualquier lugar donde vea el enlace.';
$string['support_demo'] = 'Agendar una Demo';
$string['support_info1'] = '¡Puede unirse a nuestros <a target=\'_blank\' href=\'https://intelliboard.net/events\'>seminarios web</a> mientras lo llevamos a un recorrido por los informes y análisis de IntelliBoard 5.0!';
$string['support_info2'] = 'Participe de nuestros <a target=\'_blank\' href=\'https://intelliboard.net/events\'>seminarios web</a> o programe una visita personal de sus propios datos. Con nuestro servicio y soporte de primera clase, verá su LMS desde una perspectiva completamente nueva.';
$string['support_page'] = 'Revisar Documentación';
$string['support_terms'] = 'Todos los derechos reservados.';
$string['support_text1'] = 'Todos sus datos de Moodle: fácil, se pueden compartir, comprensibles, y atractivos. Intelliboard es un plugin de Moodle que pone <strong>más de 120</strong> reportes y monitoreos en sus manos.';
$string['support_text10'] = 'Cambiar a <a href="{$a->intelliboard_pro_link}"><strong>IntelliBoard Pro</strong></a>';
$string['support_text11'] = '<a href="{$a->intelliboard_pro_onepager}">Haga clic aquí</a> para descargar el folleto de IntelliBoard Pro.';
$string['support_text2'] = 'Todos sus datos de Moodle: fácil, se pueden compartir, comprensibles, y atractivos. Intelliboard es su solución de reporte y análisis de Moodle, que le da más de 120 reportes y análisis para ayudarle a informarse sobre sus decisiones de negocios educativos.';
$string['support_text3'] = '¡Gracias por instalar Intelliboard Lite!';
$string['support_text4'] = 'Encuentre una plataforma de reporte y visualización fácil-de-usar, que le ayudará a lograr sus metas de retención, motivación y cumplimiento.';
$string['support_text6'] = '¿Necesita más información? Haga clic en los botones azules para conectarse con nosotros.';
$string['support_text7'] = 'Para iniciarse con <strong>IntelliBoard Lite</strong>, por favor <a href="{$a->meeting_link}">agende una consulta</a> con uno de nuestros expertos en análisis del aprendizaje.';
$string['support_text8'] = 'Si usted  <strong>ya ha comprado</strong> una licencia y ve esta pantalla, por favor póngase en contacto con su Gestor de Cuenta para asistencia..';
$string['support_text9'] = '¿Necesita modelos predictivos, notificaciones y monitoreo de intervención?';
$string['support_trial'] = 'Conectar y Actualizar';
$string['suspended'] = 'Suspendido';
$string['sync_data_with_attendance'] = 'Sincronizar datos con Asistencia';
$string['synctranscriptstask'] = 'Trabajo de Sincronizar Transcripciones';
$string['t01'] = 'Filtro de tiempo: Últimos 30 días';
$string['t02'] = 'Filtro de tiempo: Últimos 3 Meses';
$string['t03'] = 'Filtro de tiempo: Últimos 6 Meses';
$string['t04'] = 'Habilitar [encabezado] Cursos completados';
$string['t05'] = 'Habilitar [encabezado] Cursos en proceso';
$string['t06'] = 'Habilitar [encabezado] Cursos calificación promedio';
$string['t07'] = 'Habilitar [encabezado] Mensajes';
$string['t08'] = 'Habilitar [header] Suma de curso.calificación';
$string['t09'] = 'Instructor puede ver a sus propios alumnos';
$string['t1'] = 'Habilitar Tablero del Estudiante';
$string['t10'] = 'Habilitar widget [Exámenes]';
$string['t11'] = 'Habilitar widget [Progreso del curso]';
$string['t12'] = 'Habilitar widget [Participación en actividad]';
$string['t13'] = 'Habilitar widget [Aprendizaje]';
$string['t14'] = 'Habilitar widget [Éxito del curso]';
$string['t15'] = 'Habilitar widget [Correlaciones]';
$string['t16'] = 'Habilitar profesor del curso';
$string['t17'] = 'Habilitar categoría del curso';
$string['t18'] = 'Habilitar finalización del curso';
$string['t19'] = 'Habilitar calificación del curso';
$string['t2'] = 'Habilitar Tablero';
$string['t20'] = 'Habilitar promedio de clase dle curso';
$string['t21'] = 'Habilitar tiempo empleado en el curso';
$string['t22'] = 'Habilitar fecha de inscripción';
$string['t23'] = 'Habilitar columna [Fecha de inicio del curso]';
$string['t24'] = 'Habilitar columna [Fecha de inscripción]';
$string['t25'] = 'Habilitar columna [Progreso]';
$string['t26'] = 'Habilitar columna [Carta]';
$string['t27'] = 'Habilitar columna [Actividades completadas]';
$string['t28'] = 'Habilitar columna [Calificación]';
$string['t29'] = 'Habilitar columna [Estatus de Finalización del Curso]';
$string['t3'] = 'Habilitar Cursos';
$string['t30'] = 'Habilitar columna [Calificación de Actividad]';
$string['t31'] = 'Habilitar columna widget [Calificación][Tareas]';
$string['t32'] = 'Habilitar columna widget [Fecha Esperada][Tareas]';
$string['t33'] = 'Habilitar columna widget [Calificación][Exámenes]';
$string['t34'] = 'Habilitar columna widget [Fecha Esperada][Exámenes]';
$string['t35'] = 'Habilitar columna widget [Progreso][Progreso del curso]';
$string['t36'] = 'Habilitar columna widget [Calificación][Progreso del curso]';
$string['t37'] = 'Habilitar columna widget [Inscrito][Progreso del curso]';
$string['t38'] = 'Habilitar columna widget [Completado][Progreso del curso]';
$string['t39'] = 'Habilitar opción [Calificación Meta][Progreso]';
$string['t4'] = 'Habilitar Calificaciones';
$string['t40'] = 'Habilitar opción [Promedio de la clase][Progreso]';
$string['t41'] = 'Habilitar Completado en [Encabezado de Calificaciones de Actividad]';
$string['t42'] = 'Habilitar Último acceso al curso [Encabezado de Calificaciones de Actividad]';
$string['t43'] = 'Habilitar columna  de Tipo [Calificaciones de actividad]';
$string['t44'] = 'Habilitar columna  de Calificación [Calificaciones de Actividad]';
$string['t45'] = 'Habilitar columna  de Calificada [Calificaciones de actividad]';
$string['t46'] = 'Habilitar columna  de Completada [Calificaciones de actividad]';
$string['t47'] = 'Color del fondo de Cursos [rejilla]';
$string['t48'] = 'Habilitar Reportes';
$string['t49'] = 'Habilitar columnas de filtro';
$string['t5'] = 'Habilitar gráfica [Progreso de actividad]';
$string['t50'] = 'Roles de Profesor';
$string['t51'] = 'Roles de estudiante';
$string['t52'] = 'Habilitar columnas widget [Progreso Curso][Categoría]';
$string['t53'] = 'Habilitar la línea promedio del gráfico [Progreso de actividad]';
$string['t54'] = 'Habilitar la columna Tiempo empleado [Calificaciones de actividad]';
$string['t6'] = 'Habilitar gráfica [Progreso de curso]';
$string['t7'] = 'Habilitar [Promedio de mi curso]';
$string['t8'] = 'Habilitar [Promedio general del curso]';
$string['t9'] = 'Habilitar widget [Tareas]';
$string['table_set_iag'] = 'Curso Instructor > Actividades';
$string['table_set_iag1'] = 'Curso Instructor > Actividades > Calificaciones';
$string['table_set_iag1_c1'] = 'Nombre del Estudiante';
$string['table_set_iag1_c2'] = 'Dirección Email';
$string['table_set_iag1_c3'] = 'Estatus';
$string['table_set_iag1_c4'] = 'Calificación';
$string['table_set_iag1_c5'] = 'Calificado';
$string['table_set_iag1_c6'] = 'Visitas';
$string['table_set_iag1_c7'] = 'Tiempo Empleado';
$string['table_set_iag_c1'] = 'Nombre de actividad';
$string['table_set_iag_c2'] = 'Tipo';
$string['table_set_iag_c3'] = 'Alumnos completados';
$string['table_set_iag_c4'] = 'Calificación promedio';
$string['table_set_iag_c5'] = 'Visitas';
$string['table_set_iag_c6'] = 'Tiempo empleado';
$string['table_set_iag_c7'] = 'Acciones';
$string['table_set_icg'] = 'Cursos del Instructor';
$string['table_set_icg_c1'] = 'Nombre del Curso';
$string['table_set_icg_c11'] = 'Acciones - Actividades';
$string['table_set_icg_c12'] = 'Acciones - Estudiantes';
$string['table_set_icg_c2'] = 'Nombre Corto';
$string['table_set_icg_c3'] = 'Categoría';
$string['table_set_icg_c4'] = 'Alumnos Inscritos/Completados';
$string['table_set_icg_c5'] = 'Calificación media del Curso';
$string['table_set_icg_c6'] = 'Secciones';
$string['table_set_icg_c7'] = 'Actividades/Recursos';
$string['table_set_icg_c8'] = 'Visitas';
$string['table_set_icg_c9'] = 'Tiempo Empleado';
$string['table_set_ilg'] = 'Cursos del Instructor > Estudiantes';
$string['table_set_ilg1'] = 'Cursos del Instructor > Estudiantes > Calificaciones';
$string['table_set_ilg1_c1'] = 'Nombre de actividad';
$string['table_set_ilg1_c2'] = 'Tipo';
$string['table_set_ilg1_c3'] = 'Calificación';
$string['table_set_ilg1_c4'] = 'Calificado';
$string['table_set_ilg1_c5'] = 'Estatus';
$string['table_set_ilg1_c6'] = 'Visitas';
$string['table_set_ilg1_c7'] = 'Tiempo Empleado';
$string['table_set_ilg_c1'] = 'Nombre del Estudiante';
$string['table_set_ilg_c10'] = 'Acciones';
$string['table_set_ilg_c2'] = 'Dirección Email';
$string['table_set_ilg_c3'] = 'Inscritro';
$string['table_set_ilg_c4'] = 'Último Acceso';
$string['table_set_ilg_c5'] = 'Estatus';
$string['table_set_ilg_c6'] = 'Calificación';
$string['table_set_ilg_c7'] = 'Actividades Completadas/Recursos';
$string['table_set_ilg_c8'] = 'Visitas';
$string['table_set_ilg_c9'] = 'Tiempo Empleado';
$string['te1'] = 'Email';
$string['te12'] = 'Nombre';
$string['te13'] = 'Apellido(s)';
$string['te1_desc'] = 'Ingresar Email usado con suscripción a  IntelliBoard.net. Si Usted no tiene una suscripción activa, por favor regístrese en <<a target="_blank" href="https://intelliboard.net">IntelliBoard.net</a>.. Los Tableros del Estudiante y del Instructor están disponibles con una suscripción de nivel 4 y mayor.';
$string['teacher'] = 'Profesor';
$string['telephone1'] = 'Teléfono 1';
$string['telephone2'] = 'Teléfono 2';
$string['term_of_use'] = 'Términos de Uso';
$string['terms_msg'] = 'Al activar esta casilla usted confirma que ha leido y está de acuerdo con nuestros Términos de Uso.';
$string['tex1'] = 'El Tablero del Estudiante IntelliBoard no está habilitado.';
$string['this_year'] = 'Este Año';
$string['time'] = 'Tiempo';
$string['time_1'] = 'Mañana';
$string['time_2'] = 'Tarde';
$string['time_3'] = 'Tarde-noche';
$string['time_4'] = 'Horas no laborables';
$string['time_period_due'] = 'Período de Tiempo (Fecha Esperada)';
$string['time_spent'] = 'Tiempo Empleado';
$string['timespent'] = '------ Tiemplo Empleado ----';
$string['tls12'] = 'TLS v1.2';
$string['tls12_desc'] = 'Configuraciones Avanzadas: TLS v1.2';
$string['topics'] = 'Tópicos';
$string['total'] = 'Total';
$string['total_activities_resources'] = 'Total de Actividades/Recursos';
$string['total_numbers'] = 'Fecha: {$a->timepoint}, Sesiones: {$a->sessions}, Visitas: {$a->visits}, Tiempo Empleado: {$a->timespend}';
$string['total_numbers2'] = 'USUARIO: {$a->userid}, Página: {$a->page}, Parám:{$a->param}, Visitas: {$a->visits}, Tiempo Empleado: {$a->timespend}';
$string['total_numbers3'] = '----Fecha: {$a->timecreated}, Seguimiento ID: {$a->trackid}, Visitas: {$a->visits}, Tiempo Empleado: {$a->timespend}';
$string['total_time_spent'] = 'Tiempo empleado total';
$string['total_time_spent_enrolled_learners'] = 'Total de Tiempo empleado por Estudiantes Inscritos en Curso';
$string['total_values_include'] = 'Valores Totales incluyen sesiones únicas, cursos, visitas, tiempo empleado.';
$string['total_visits_enrolled_learners'] = 'Total de visitas por Estudiantes Inscritos en Curso';
$string['totara'] = 'Totara';
$string['trackadmin'] = 'Seguimiento de Admins';
$string['trackadmin_desc'] = 'Habilitar Monitoreo del Tiempo para Usuarios Administradores (no recomendado)';
$string['trackdetails'] = 'Monitorear Tiempo por Usuario - Cada hora';
$string['tracking'] = 'Seguimiento de Sesión';
$string['tracking_title'] = 'Seguimiento del Tiempo';
$string['tracklogs'] = 'Monitorear Tiempo por Usuario - Cada día';
$string['trackmedia'] = 'Monitorear Medios HTML5';
$string['trackmedia_desc'] = 'Monitorear video y audio HTML5';
$string['tracktotals'] = 'Monitorear tiempo agregado - Diario';
$string['transcripts'] = 'Transcripciones';
$string['transcriptssyncrecordsnum'] = 'Tamño de Procesamiento de Trancripciones';
$string['transcriptssyncrecordsnum_desc'] = 'El número de registros de inscripciones de usuarios que serán procesados a la vez.';
$string['ts1'] = 'Tablero del Estudiante';
$string['ts2'] = 'Página del Tablero del Estudiante';
$string['ts3'] = 'Curso del Tablero del Estudiante';
$string['ts4'] = 'Calificaciones del Tablero del Estudiante';
$string['ts5'] = 'Reportes de Tablero del Estudiante';
$string['type'] = 'Escribir';
$string['type_here'] = 'Escribir aquí...';
$string['used'] = 'Usado';
$string['user_enrollments_sessions_completion'] = 'Inscripción de Usuario, Sesión, Niveles de Actividad de finalización';
$string['user_enrolments'] = 'Inscripciones del usuario';
$string['user_grade_avg'] = '{$a->user} calificación: {$a->grade}, Calificación promedio
e: {$a->avg_grade_site})';
$string['user_map'] = 'Mapa del Usuario';
$string['user_site_summary_detail'] = 'Detalle del resumen del Mapa del Usuario';
$string['user_time_avg'] = '{$a->user} tiempo: {$a->timespend}, Promedio de tiempo: {$a->avg_timespend_site}';
$string['user_visit_avg'] = '{$a->user} visitas: {$a->visits}, Promedio de visitas: {$a->avg_visits_site}';
$string['username'] = 'Nombre del Usuario';
$string['users'] = 'Usuarios';
$string['users_activity'] = 'Actividad de usuarios';
$string['users_overview'] = 'Vista Genral de Usuarios';
$string['verifyhost'] = 'CURLOPT SSL VERIFYHOST';
$string['verifyhost_desc'] = 'Esta opción determina si es que libcurl verifica que el certificado del servidor es para el servidor que es conocido como tal.';
$string['verifypeer'] = 'CURLOPT SSL VERIFYPEER';
$string['verifypeer_desc'] = 'Esta opción determina si es que CURL verifica o no la autenticidad del certificado del par.';
$string['view_course_details'] = 'Ver detalles del curso';
$string['viewed'] = 'Visto';
$string['visits'] = 'Visitas';
$string['web_services_descr'] = 'IntelliBoard requiere que los Servicios web estén habilitados. Los Servicios weble permiten a otros sistemas (por ejemplo, IntelliBoard) que accedan a este sistema LMS y realicen operaciones. Para fines de seguridad, esto debería estar deshabilitado cuando no esté en uso. Para una revisión adicional, vaya a Administración del sitio > Características avanzadas > SERVICIOS WEB';
$string['weekday_0'] = 'Lunes';
$string['weekday_1'] = 'Martes';
$string['weekday_2'] = 'Miércoles';
$string['weekday_3'] = 'Jueves';
$string['weekday_4'] = 'Viernes';
$string['weekday_5'] = 'Sábado';
$string['weekday_6'] = 'Domingo';
$string['weekly'] = 'Últimos 90 Días';
$string['widget_name27'] = 'Pre-inscritos Acumulados';
$string['widget_name28'] = 'Compromiso';
$string['widget_name29'] = 'Ingresos Únicos';
$string['widget_name30'] = 'Ingresos por Curso';
$string['widget_name31'] = 'Recepcion de Registrador y Supervisor';
$string['x_completions'] = '{$a} Finalizaciones';
$string['you_have_certificates'] = 'Usted tiene {$a} certificados';
$string['you_need_to_enable_at_least_one_protocol'] = 'Usted necesita habilitar al menos un protocolo';
