<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'reader', language 'af', version '4.3'.
 *
 * @package     reader
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Aksie';
$string['actionblockquizzestext'] = 'Jy sal verbied word om enige verdere vasvrae te doen totdat jou onderwyser die blok verwyder';
$string['actiondelayquizzestext'] = 'Jy sal moet wag om enige verdere vasvrae te doen totdat die wagtyd verstryk het.';
$string['actionemailstudenttext'] = '\'n E-pos sal na jou gestuur word.';
$string['actionemailteachertext'] = '\'n E-pos sal na die onderwyser(s) van hierdie kursus gestuur word.';
$string['activemessages'] = 'Aktiewe boodskappe';
$string['activityoverview'] = 'Kliek hier om inligting oor jou ekstensiewe leesaktiwiteit te besigtig';
$string['add'] = 'Voeg by';
$string['add_phpdoc'] = 'Voeg PHP-dok-kommentaar by';
$string['add_phpdoc_desc'] = 'Voeg PHP-dok-kommentaar by php-, js- en css-dokumente.';
$string['addbookinstance'] = 'Voeg meer boeke by hierdie kursus';
$string['addmoregoals'] = 'Voeg {no} meer doelwitte by';
$string['addmorerates'] = 'Voeg {no} meer beoordelings by';
$string['addonemorerate'] = 'Voeg {no} meer beoordeling by';
$string['addquiztoreader'] = 'Voeg kursusvasvrae by leservasvrae';
$string['adjoiningcomputers'] = 'Op aanliggende rekenaars';
$string['adjustscores'] = 'Pas punte aan';
$string['adminarea'] = 'Adminarea';
$string['all'] = 'Alle';
$string['allbooks'] = 'Laai af/herstel omslae van ALLE boeke wat vir die Reader-module beskikbaar is';
$string['allcourses'] = 'Alle kursusse';
$string['alldone'] = 'Alles klaar';
$string['allgroups'] = 'Alle groepe';
$string['alllevels'] = 'Alle vlakke';
$string['allowpromotion'] = 'Laat bevordering toe';
$string['allparticipants'] = 'Alle deelnemers';
$string['allterms'] = 'alle terme';
$string['anytime'] = 'Enige tyd';
$string['anywhere'] = 'Enige plek';
$string['arrange'] = 'Reël';
$string['assignpointsbookshavenoquizzes'] = 'Ken punte toe vir boeke wat geen vasvrae het nie';
$string['atlevel'] = 'op Vlak';
$string['attemptedbooks'] = 'Laai af/herstel slegs omslae van boeke wat op hierdie werf GEPOOG is';
$string['attempts'] = 'Pogings';
$string['attemptsallowedn'] = 'Pogings toegelaat: {$a}';
$string['attemptscoremanagement'] = 'Poging- en puntbestuur';
$string['attemptsupdated'] = '{$a} pogings is bygewerk';
$string['atttemptsgroupedbybook'] = 'Pogings volgens boek gegroepeer';
$string['atttemptsgroupedbyuser'] = 'Pogings volgens gebruiker gegroepeer';
$string['available'] = 'Beskikbaar';
$string['availablefrom'] = 'Beskikbaar by';
$string['availablefrom_help'] = 'Studente kan slegs toegang tot hierdie aktiwiteit verkry ná die datum en tyd wat hier gespesifiseer is. Dit sal nie voor hierdie datum en tyd beskikbaar wees nie.';
$string['availableitems'] = 'Beskikbare items';
$string['availablenolonger'] = 'Jammer, hierdie aktiwiteit is nie meer beskikbaar nie. Dit het {$a} gesluit.';
$string['availablenotyet'] = 'Jammer, hierdie aktiwiteit is nog nie beskikbaar nie. Dit maak {$a} oop.';
$string['availableuntil'] = 'Beskikbaar tot';
$string['availableuntil_help'] = 'Studente kan slegs toegang tot hierdie aktiwiteit verkry tot en met die datum en tyd wat hier gespesifiseer is. Dit sal nie ná hierdie datum en tyd beskikbaar wees nie.';
$string['averageduration'] = 'Gemiddelde duur';
$string['averageduration_help'] = 'Die gemiddelde duur van pogings tot Reader-vasvrae';
$string['averagefailed'] = 'Gemiddeld gedruip';
$string['averagefailed_help'] = 'Die gemiddelde aantal Reader-vasvrae wat per student gedruip is';
$string['averagegrade'] = 'Gemiddelde punt';
$string['averagegrade_help'] = 'Die gemiddelde punt wat met Reader-vasvrae verkry is';
$string['averagepassed'] = 'Gemiddeld geslaag';
$string['averagepassed_help'] = 'Die gemiddelde aantal Reader-vasvrae wat per student geslaag is';
$string['averagepoints'] = 'Gemiddelde punte';
$string['averagepointsallterms'] = 'Gemiddelde punte (alle termyne)';
$string['averagepointsallterms_help'] = 'Die gemiddelde aantal punte wat deur elke student in hierdie groep verwerf is, alle punte in ag genome wat enigeen van hulle ooit in enige Reader-aktiwiteit van hierdie Moodle-werf verwerf het.';
$string['averagepointsthisterm'] = 'Gemiddelde punte (hierdie termyn)';
$string['averagepointsthisterm_help'] = 'Die gemiddelde aantal punte wat deur elke student in hierdie groep verwerf is, slegs punte in ag genome wat in hierdie Reader-aktiwiteit tydens die huidige termyn verwerf is.';
$string['averagerating'] = 'Gemiddelde gradering';
$string['averagetaken'] = 'Gemiddeld geneem';
$string['averagetaken_help'] = 'Die gemiddelde aantal Reader-vasvrae wat per student geneem is';
$string['averagewords'] = 'Gemiddelde woorde';
$string['averagewordsallterms'] = 'Gemiddelde woorde (alle termyne)';
$string['averagewordsallterms_help'] = 'Die gemiddelde aantal woorde wat deur elke student in hierdie groep verdien is, alle woorde in ag genome wat enigeen van hulle ooit in enige Reader-aktiwiteit op hierdie Moodle-werf verdien het.';
$string['averagewordsthisterm'] = 'Gemiddelde woorde (hierdie termyn)';
$string['averagewordsthisterm_help'] = 'Die gemiddelde aantal woorde wat deur elke student in hierdie groep verdien is, slegs woorde in ag genome wat in hierdie Reader-aktiwiteit gedurende die huidige termyn verdien is.';
$string['awardbookpoints'] = 'Gee krediet vir boeke aan gekose studente';
$string['awardextrapoints'] = 'Ken ekstra punte aan gekose studente toe';
$string['awardpointsmanually'] = 'Daar is geen vasvra vir hierdie boek nie. Vra asseblief jou onderwyser om die woorde/punte per hand toe te ken.';
$string['best'] = 'Beste';
$string['blockquizattempts'] = 'Blokkeer verdere vasvrapogings';
$string['book'] = 'Boek';
$string['bookadded'] = 'Boek bygevoeg: {$a}';
$string['bookcovers'] = 'Vertoon boekomslae';
$string['bookcovers_help'] = '**Ja**
: Vertoon die boekomslae op die hoofblad van hierdie Reader-aktiwiteit.

**Nee**
: Moet NIE die boekomslae op die hoofblad van hierdie Reader-aktiwiteit vertoon nie.';
$string['bookdifficulty'] = 'Boek se moeilikheidsgraad';
$string['bookeditdetails'] = 'Wysig boek se besonderhede';
$string['bookhasnoquiz'] = 'Hierdie boek het geen vasvra nie.';
$string['bookinstances'] = 'Gebruik deelversameling van vasvrae';
$string['bookinstances_help'] = '**Ja**
: Hierdie Reader-aktiwiteit sal slegs \'n deelversameling van die vasvrae wat in die Leservasvrakursus beskikbaar is, gebruik. Ook kan doelgemaakte waardes vir woordtelling en boek se moeiliheidsgraad gespesifiseer word. Let daarop dat die ontsperring van hierdie opsie \'n mate van ekstra lading op jou webbediener sal veroorsaak.

**Nee**
: Hierdie Reader-aktiwiteit sal al die vasvrae in die Reader-vasvrakursus gebruik en sal slegs die standaard Reader-boekdata vir woordtelling en lesersvlak gebruik.';
$string['bookinstancesdisabled'] = 'Hierdie Reader-aktiwiteit gebruik nie \'n deelversameling van vasvrae nie, dus vereis dit nie invoere in die boek_eksemplare-tabel nie.';
$string['booklevelmanagement'] = 'Boek- & Vlakbestuur';
$string['booknotadded'] = 'Boek NIE bygevoeg nie: {$a}';
$string['booknotfound'] = 'Boek nie gevind nie: {$a}';
$string['booknotupdated'] = 'Boek NIE bygewerk nie: {$a}';
$string['bookquiznumber'] = 'Boek-vasvranommer';
$string['bookrating'] = 'Boekgradering';
$string['bookrating0'] = 'Ek het glad nie daarvan gehou nie';
$string['bookrating1'] = 'Dit was so-so';
$string['bookrating2'] = 'Dit was gangbaar';
$string['bookrating3'] = 'Dit was wonderlik';
$string['bookratingslevel'] = 'Vertoon studente se boekgraderings vir elke boekvlak';
$string['books'] = 'Boeke';
$string['booksaddbook'] = 'Voeg nuwe boek by';
$string['booksallwith'] = 'enige boek wat minstens een maal gelees is';
$string['booksavailable'] = '{$a} boek(e) beskikbaar';
$string['booksavailableall'] = 'alle beskikbare boeke';
$string['booksavailablewith'] = 'beskikbare boeke wat minstens een maal gelees is';
$string['booksavailablewithout'] = 'beskikbare boeke wat nog nie gelees is nie';
$string['bookseditcourse'] = 'Wysig boeke (Kursus)';
$string['bookseditcourse_help'] = 'Op hierdie bladsy kan jy spesifiseer watter Reader-boeke in hierdie kursus beskikbaar gestel moet word. Jy kan ook die vlak en woordtelling vir daardie boeke spesifiseer. As \'n vlak of woordtellingwaarde nie hier gespesifiseer is nie, sal die verstek waarde van daardie boek op hierdie Moodle-werf gebruik word.';
$string['bookseditsite'] = 'Wysig boeke (Werf)';
$string['bookseditsite_help'] = 'Op hierdie bladsy kan jy inligting oor Reader-boeke op hierdie Moodle-werf stel, byvoeg, wysig en uitwis. Let daarop dat waardes wat hier vir enige boek gestel word, vervang sal word as data van daardie boek weer vanaf die hoof Moodle-Reader-webwerf afgelaai word. Ook kan die waardes oorheengeskryf in individuele kursusse word.';
$string['booksreadinpreviousterms'] = 'Boeke in vorige termyne gelees';
$string['booksreadsincedate'] = 'Boeke gelees sedert {$a}';
$string['booksreadsincepromotion'] = 'Boeke gelees sedert jou bevordering op {$a}';
$string['booksreadthisterm'] = 'Boeke hierdie termyn gelees';
$string['booksviaapi'] = 'Boekdata (via API)';
$string['bookswithoutquizzes'] = 'Boeke sonder vasvrae';
$string['bookswithquizzes'] = 'Boeke met vasvrae';
$string['booktitle'] = 'Boektitel';
$string['booktype'] = 'Boeke om in te sluit';
$string['bookupdated'] = 'Boek bygewerk: {$a}';
$string['cannotaccesscourse'] = 'Jammer, jy beskik nie oor toestemming om aktiwiteite in die "{$a}" kursus te bestuur nie.';
$string['cannotcreatecourse'] = 'Jammer, die aflaai kan nie voortgaan nie, omdat jy nie oor toestemming beskik om \'n nuwe kursus te skep of om die huidige kursus te wysig nie.';
$string['cannotdownloadata'] = 'Jammer, daar was \'n probleem met die aflaai van data vir die Reader-module';
$string['changeallstoplevelto'] = 'Verander alle maksimum vlakke na';
$string['changeallto'] = 'Verander alles na';
$string['changecurrentlevel'] = 'Verander alle huidige vlakke na';
$string['changedifficultyfrom'] = 'Verander leesvlakke van';
$string['changelevelfrom'] = 'Verander vlaknaam van';
$string['changenumberofsectionsinquiz'] = 'Herstel aantal afdelings in vasvra-bewaarareakursus';
$string['changepointsfrom'] = 'Verander punte vanaf';
$string['changepublisherfrom'] = 'Verander uitgewernaam vanaf';
$string['changequiz'] = 'Verander vasvra';
$string['changereaderlevel'] = 'Verander Leesvlak, Lengte of Woordtelling';
$string['changestartlevel'] = 'Verander alle beginvlak na';
$string['cheated'] = 'Gekul';
$string['cheatedmessage'] = 'Gekul boodskap';
$string['cheatedmessage_help'] = 'Hierdie boodskap sal aan studente gestuur word wat deur die Reader-module beoordeel is dat hulle gekul het.';
$string['cheatedmessagedefault'] = 'Ons is jammer om te sê dat die Moodle Reader-program ontdek het dat jy waarskynlik gekul het toe jy bogemelde vasvra gedoen het. "Kul" beteken dat jy óf \'n ander persoon gehelp het om die vasvra te doen, óf dat jy hulp van iemand anders ontvang het om die vasvra te doen. Beide persone is as "gekul" gemerk.

Soms maak die rekenaar foute. As jy regtig nie hulp ontvang het of iemand anders gehelp het nie, lig asseblief jou onderwyser in, en jou punte sal herstel word.

--Die Moodle Reader-modulebestuurder';
$string['cheatedshort'] = 'C';
$string['cheatsheet'] = 'Verneukvel';
$string['check_email'] = 'Kyk na e-pos';
$string['check_email_desc'] = 'Stuur twee toets-e-posse na die gasstudentgebruiker, een via Moodle-pos en een  via PHP-pos.';
$string['checkbox'] = 'Vertoon merkbokse';
$string['checkbox_help'] = '**Ja**
: Vertoon merkbokse op die onderwyserverslagbladsye in die Adminarea.

**Nee**
: Moet NIE merkbokse op die onderwyserverslagbladsye in die Adminarea vertoon nie.

Hierdie verstelling sal in die toekoms verwyder word, wanneer die Adminarea uitgefaseer is.';
$string['checkcheating'] = 'Kontroleer vir kulwerk';
$string['checkcheating_help'] = 'Hierdie verstelling spesifiseer of IP-adresse gekontroleer moet word wanneer studente Reader-vasvrae poog.

**Af**
: IP-adres sal nie gekontroleer word nie

**Enige plek**
: As twee studente op \'n soortgelyke tyd met dieselfde vasvra begin en albei slaag, sal hulle deur die Reader-module beskou word dat hulle gekul het.

**Op aanliggende rekenaars**
: As twee studente dieselfde vasvra op \'n soortgelyke tyd vanaf \'n soortgelyke IP-adres begin en beide slaag, sal hulle deur die Reader-module beskou word dat hulle gekul het.';
$string['checkonlythiscourse'] = 'Kontroleer slegs hierdie kursus';
$string['checksuspiciousactivity'] = 'Kontroleer logs vir verdagte aktiwiteit';
$string['chooseaction'] = 'Kies \'n aksie en kliek op "Gaan"';
$string['choosedifficulty'] = 'Kies asseblief leesvlak';
$string['chooselevel'] = 'Kies asseblief vlak';
$string['choosepublisher'] = 'Kies asseblief uitgewer';
$string['clearedmessage'] = 'Onskuldig verklaar boodskap';
$string['clearedmessage_help'] = 'Hierdie boodskap word aan studente gestuur wat deur die Reader-module beoordeel is dat hulle gekul het, maar wat later deur die onderwyser onskuldig verklaar is.';
$string['clearedmessagedefault'] = 'Ons is bly om jou te kan inlig dat jou punte vir die bogemelde vasvra herstel is. Jammer vir die fout!

--Die Moodle Reader-modulebestuurder';
$string['clicktocontinue'] = 'Kliek hier om voort te gaan';
$string['complete'] = 'Voltooi';
$string['completequizattempt'] = 'Voordat jy enige nuwe vasvrae doen, moet jy hierdie vasvra vir "{$a}" voltooi. Kliek op die skakel hieronder om jou vorige poging van hierdie vasvra te hervat.';
$string['completionpass'] = 'Vereis slaagpunt';
$string['completiontotalwords'] = 'Vereis leestotaal';
$string['completiontotalwords_help'] = 'Die leestotaal wat \'n student binne hierdie aktiwiteit moet behaal om dit as voltooi te kan merk.';
$string['configbookcovers'] = '';
$string['configcheatedmessage'] = '';
$string['configcheckbox'] = '';
$string['configcheckcheating'] = '';
$string['configclearedmessage'] = '';
$string['configgoal'] = '';
$string['configintro'] = 'Die waardes wat jy hierdie stel, definieer die verstek waardes wat in die verstellingsvorm gebruik word wanneer jy \'n nuwe Reader-aktiwiteit skep.

Jy kan ook konfigureer watter leserverstellings as gevorderd beskou word.';
$string['configkeeplocalbookdifficulty'] = '';
$string['configkeepoldquizzes'] = '';
$string['configlevelcheck'] = '';
$string['configmaxgrade'] = '';
$string['configminpassgrade'] = '';
$string['configmreaderenable'] = 'Ontsper of versper die verstellings van mReader.org';
$string['configmreadersettings'] = 'Hierdie verstellings laat studente van hierdie Moodle-werf toe om toegang tot vasvrae op mReader.org te hê
Om \'n Werf-ID en -Sleutel te kry, moet jy in die volgende kursus ingeskryf wees: https://www.moodlereader.com/moodle4reader/course/view.php?id=2';
$string['configmreadersiteid'] = 'Die numeriese ID waaronder hierdie Moodle-werf op mReader.org geregistreer is';
$string['configmreadersitekey'] = 'Die geheime sleutel wat studente vanaf hierdie Moodle-werf toelaat om toegang tot die vasvrae op mReader.org te hê';
$string['configmreaderurl'] = 'Die URL waarop studente toegang tot die vasvrae op mReader.org kan kry';
$string['confignextlevel'] = '';
$string['confignotifycheating'] = '';
$string['configprevlevel'] = '';
$string['configquestionscores'] = '';
$string['configserverpassword'] = 'Die wagwoord wat vereis word om Moodle Reader-vasvra na hierdie Moodle-werf af te laai.';
$string['configserversettings'] = 'Hierdie verstellings laat \'n onderwyser of admin toe om Moodle Reader-vasvrae na hierdie Moodle-werf af te laai.
Die gebruikersnaam en wagwoord is dié wat jy gebruik om by MoodleReader.org in te teken. Die gebruikersnaam moet eers vir aflaai deur personeel by MoodleReader.org gemagtig word.';
$string['configserverurl'] = 'Die URL waarvan jy die Moodle Reader-vasvrae na hierdie Moodle-werf kan aflaai.';
$string['configserverusername'] = 'Die gebruikersnaam wat vereis word om Moodle Reader-vasvrae na hierdie Moodle-werf af te laai.';
$string['configshowpercentgrades'] = '';
$string['configshowprogressbar'] = '';
$string['configshowreviewlinks'] = '';
$string['configstoplevel'] = '';
$string['configthislevel'] = '';
$string['configupdate'] = '';
$string['configusecourse'] = '';
$string['configwordsorpoints'] = '';
$string['confirmdeleteattempts'] = 'Wil jy regtig hierdie pogings uitwis?';
$string['confirmstartattemptlimit'] = 'Aantal pogings toegelaat: {$a} Jy is op die punt om met \'n nuwe poging te begin. Wil jy voortgaan?';
$string['confirmstartattempttimelimit'] = 'Hierdie vasvra het \'n tydsbeperking en is beperk tot {$a} poging(s). Jy is op die punt om met \'n nuwe poging te begin. Wil jy voortgaan?';
$string['confirmstarttimelimit'] = 'Die vasvra het \'n tydsbeperking. Is jy seker jy wil begin?';
$string['countactive'] = 'Aktiewe studente';
$string['countactive_help'] = 'Die aantal studente wat minstens een Reader-vasvra gedoen het';
$string['countfailed'] = 'Gedruipte vasvrae';
$string['countinactive'] = 'Onaktiewe studente';
$string['countinactive_help'] = 'Aantal studente wat geen Reader-vasvrae gedoen het nie';
$string['countpassed'] = 'Geslaagde vasvrae';
$string['countrating'] = 'Aantal graderings';
$string['courseid'] = 'Kursus-ID';
$string['coursespecificquizselection'] = 'Kursus-spesifieke vasvraseleksie na "Ja" in die module-opstelskerm.';
$string['createcoversets_l'] = 'Skep Omslagstelle volgens Vlak & Uitgewer';
$string['createcoversets_t'] = 'Skep Omslagstelle volgens Uitgewer &amp; Vlak';
$string['credit'] = 'Ekstra krediet';
$string['creditshort'] = 'X';
$string['curlerror'] = 'CURL-fout: {$a}';
$string['current'] = 'Huidige';
$string['currentcourse'] = 'Huidige kursus';
$string['currentlevel'] = 'Huidige vlak';
$string['dataallavailable'] = 'data vir alle {$a} boek(e) is beskikbaar';
$string['dataalldownloaded'] = 'data vir alle {$a} boek(e) is afgelaai';
$string['datasomeavailable'] = 'data vir {$a->new} uit {$a->all} boek(e) is beskikbaar';
$string['defaultcategoryname'] = 'Reader-vasvrae';
$string['defaultcoursename'] = 'Reader-vasvrae';
$string['defaultgoal'] = 'Verstek doelwit';
$string['defaultgoals'] = 'Verstek doelwitte';
$string['defaultquestioncategoryinfo'] = '{$a->category} vrae vir {$a->quiz}';
$string['defaultrates'] = 'Verstek tempo\'s';
$string['definelogindetails'] = 'Definieer asseblief intekenbesonderhede: {$a}';
$string['delayineffect'] = 'Vasvravertraging is tans van krag';
$string['delayquizattempts'] = 'Vertraag verdere vasvrapogings';
$string['delete'] = 'Wis uit';
$string['deleteallattempts'] = 'Wis alle pogings van Reader-vasvrae uit';
$string['deleteallattempts_help'] = 'Gewoonlik behoort jy NIE pogings tot Reader-vasvrae uit te wis nie.

Jy behoort slegs pogings uit te wis as jy absoluut seker is dat studente in hierdie kursus nooit weer op hierdie Moodle-werf Reader-vasvrae sal doen nie.

Dit is omdat, deur pogings van Reader-vasvrae uit te wis, jy toelaat dat studente enige Reader-vasvrae wat hulle voorheen gedoen het, weer kan doen. Dit is NIE hoe die Reader-module veronderstel is om te werk nie. Studente behoort altyd slegs EEN kans te hê om \'n Reader-vasvra te doen.

Die uitwis van pogings tot Reader-vasvrae sal ook die leespunte van alle studente na nul herstel, wat waarskynlik nie is wat jy, of die studente, wil hê nie.';
$string['deleteattempts'] = 'Wis gekose pogings uit';
$string['deletecategories'] = 'Wis kategorieë uit';
$string['deletecourses'] = 'Wis kursusse uit';
$string['deleted'] = 'Uitgewis';
$string['deletedshort'] = 'D';
$string['deletegoals'] = 'Wis doelwitte vir hierdie groepe en vlakke uit';
$string['deletegoals_help'] = 'Die verstek leesdoelwitte vir spesifieke groepe of leesvlakke sal uitgewis word.';
$string['deletemessages'] = 'Wis Reader-boodskappe uit';
$string['deletemessages_help'] = 'Alle boodskappe wat op studente se hoofblad vir Reader-aktiwiteite in hierdie kursus verskyn, sal uitgewis word.';
$string['deleterates'] = 'Wis koerse vir groepe en vlakke uit';
$string['deleterates_help'] = 'Die koerse tussen Reader-vasvrae vir spesifieke groepe of leesvlakke sal verwyder word.';
$string['detect_cheating'] = 'Spoor kullery op';
$string['detect_cheating_desc'] = 'Skandeer die poginglogs en rapporteer verdagte aktiwiteit wat op kullery kan dui.';
$string['difficulty'] = 'Moeilikheidsgraad';
$string['difficultyshort'] = 'RL';
$string['disallowpromotion'] = 'Moet NIE bevordering toelaat nie';
$string['displayoptions'] = 'Vertoon opsies';
$string['downloadbooksviaapi'] = 'Laai boekdata af (via API)';
$string['downloadbookswithoutquizzes'] = 'Laai boekdata af (geen vasvrae)';
$string['downloadbookswithquizzes'] = 'Laai boekdata en vasvrae af';
$string['downloadedbooks'] = 'Data vir die volgende boeke is afgelaai:';
$string['downloadexcel'] = 'Laai Excel af';
$string['downloadextrapoints'] = 'Laai asseblief "Ekstra punte" vasvrae af';
$string['downloadmode'] = 'Modus';
$string['downloadmode_help'] = 'Hierdie bladsy kan in die volgende twee modusse wees:

**Normaal**
: In normale modus sal slegs boeke waarvan die data nog nie afgelaai is nie, of boeke waarvan die data bygewerk is, beskikbaar wees. Boeke waarvan die mees onlangse data reeds afgelaai is, sal nie beskikbaar wees nie.

**Herstel**
: In herstelmodus sal alle boeke vir aflaai beskikbaar wees. As enige data voorheen afgelaai is, sal dit deur die nuut afgelaaide data oorheengeskryf word. Gebruik hierdie modus as jy foutiewe vasvrae of verkeerde data wil herstel. Let daarop dat, selfs al word vasvrae oorheengeskryf, data van studentpogings tot daardie vasvrae behou sal word.';
$string['downloads'] = 'Aflaailêers';
$string['downloadsettings'] = 'Aflaaiverstellings';
$string['duration'] = 'Duur';
$string['edit'] = 'Wysig';
$string['editquiztoreader'] = 'Wis vasvrae uit';
$string['err_regex_float'] = 'Hierdie verstelling moet \'n desimale getal tussen 0.0 en 10.0 wees';
$string['err_regex_integer'] = 'Hierdie verstelling moet \'n skeier tussen 0 en 100 000 wees';
$string['error'] = 'Fout: {$a}';
$string['errorsfound'] = 'Foute gevind';
$string['event_attempt_added'] = 'Reader-vasvrapoging is bygevoeg';
$string['event_attempt_added_description'] = 'Die gebruiker met id "{$a->userid}" het \'n vasvrapoging vir die "reader" aktiwiteit met kursusmodule-id "{$a->cmid}" begin';
$string['event_attempt_added_explanation'] = '\'n Gebruiker het pas \'n poging tot \'n Reader-vasvra begin';
$string['event_attempt_deleted'] = 'Reader-vasvrapoging is uitgewis';
$string['event_attempt_deleted_description'] = 'Die gebruiker met id "{$a->userid}" het \'n vasvrapoging vir die "reader" aktiwiteit met kursusmodule-id "{$a->cmid}" uitgewis';
$string['event_attempt_deleted_explanation'] = '\'n Gebruiker het pas \'n poging tot \'n Reader-vasvra uitgewis';
$string['event_attempt_edited'] = 'Reader-vasvrapoging is gewysig';
$string['event_attempt_edited_description'] = 'Die gebruiker met id "{$a->userid}" het \'n vasvrapoging vir die "reader" aktiwiteit met kursusmodule-id "{$a->cmid}" gewysig';
$string['event_attempt_edited_explanation'] = '\'n Gebruiker het pas \'n poging tot \'n Reader-vasvra gewysig';
$string['event_attempt_submitted'] = 'Reader-vasvrapoging is ingedien';
$string['event_attempt_submitted_description'] = 'Die gebruiker met id "{$a->userid}" het \'n vasvrapoging vir die "reader" aktiwiteit met kursusmodule-id "{$a->cmid}" ingedien';
$string['event_attempt_submitted_explanation'] = '\'n Gebruiker het pas \'n poging tot \'n Reader-vasvra ingedien';
$string['event_base'] = 'Reader-gebeurtenis is opgespoor';
$string['event_base_description'] = 'Die gebruiker met id "{$a->userid}" het \'n vasvrapoging vir die "reader" aktiwiteit met kursusmodule-id "{$a->cmid}" begin';
$string['event_base_explanation'] = '\'n Gebeurtenis is deur die Reader-module opgespoor';
$string['event_book_added'] = 'Reader-boek is bygevoeg';
$string['event_book_added_description'] = 'Die gebruiker met id "{$a->userid}" het \'n boek vir die "reader" aktiwiteit met kursusmodule-id "{$a->cmid}" bygevoeg';
$string['event_book_added_explanation'] = '\'n Gebruiker het pas data oor \'n Reader-boek bygevoeg';
$string['event_book_deleted'] = 'Reader-boek is uitgewis';
$string['event_book_deleted_description'] = 'Die gebruiker met id "{$a->userid}" het \'n boek vir die "reader" aktiwiteit met kursusmodule-id "{$a->cmid}" uitgewis';
$string['event_book_deleted_explanation'] = '\'n Gebruiker het pas data oor \'n Reader-boek uitgewis';
$string['event_book_edited'] = 'Reader-boek is gewysig';
$string['event_book_edited_description'] = 'Die gebruiker met id "{$a->userid}" het \'n boek vir die "reader" aktiwiteit met kursusmodule-id "{$a->cmid}" gewysig';
$string['event_book_edited_explanation'] = '\'n Gebruiker het pas data oor \'n Reader-boek gewysig';
$string['event_books_downloaded'] = 'Reader-boeke afgelaai';
$string['event_books_downloaded_description'] = 'Die gebruiker met id "{$a->userid}" het \'n boek vir die "reader" aktiwiteit met kursusmodule-id "{$a->cmid}" afgelaai';
$string['event_books_downloaded_explanation'] = '\'n Gebruiker het pas data oor Reader-boeke afgelaai';
$string['event_cron_run'] = 'Reader cron-lopie';
$string['event_cron_run_description'] = 'Die Reader cron job is geloop';
$string['event_cron_run_explanation'] = 'Die Reader cron job is pas geloop';
$string['event_downloads_viewed'] = 'Reader-aflaailêers is besigtig';
$string['event_downloads_viewed_description'] = 'Die gebruiker met id "{$a->userid}" het data oor aflaailêers vir die "reader" aktiwiteit met kursusmodule-id "{$a->cmid}" besigtig';
$string['event_downloads_viewed_explanation'] = '\'n Gebruiker het pas data oor Reader-aflaailêers besigtig';
$string['event_message_added'] = 'Reader-boodskap is bygevoeg';
$string['event_message_added_description'] = 'Die gebruiker met id "{$a->userid}" het \'n boodskap vir die "reader" aktiwiteit met kursusmodule-id "{$a->cmid}" bygevoeg';
$string['event_message_added_explanation'] = '\'n Gebruiker het pas \'n boodskap by \'n Reader-aktiwiteit bygevoeg';
$string['event_message_deleted'] = 'Reader-boodskap is uitgewis';
$string['event_message_deleted_description'] = 'Die gebruiker met id "{$a->userid}" het \'n boodskap vir die "reader" aktiwiteit met kursusmodule-id "{$a->cmid}" uitgewis';
$string['event_message_deleted_explanation'] = '\'n Gebruiker het pas \'n boodskap van \'n Reader-aktiwiteit uitgewis';
$string['event_message_edited'] = 'Reader-boodskap is gewysig';
$string['event_message_edited_description'] = 'Die gebruiker met id "{$a->userid}" het \'n boodskap vir die "reader" aktiwiteit met kursusmodule-id "{$a->cmid}" gewysig';
$string['event_message_edited_explanation'] = '\'n Gebruiker het pas \'n boodskap vir \'n Reader-aktiwiteit gewysig';
$string['event_quiz_added'] = 'Reader-vasvra is bygevoeg';
$string['event_quiz_added_description'] = 'Die gebruiker met id "{$a->userid}" het \'n vasvra vir die "reader" aktiwiteit met kursusmodule-id "{$a->cmid}" bygevoeg';
$string['event_quiz_added_explanation'] = '\'n Gebruiker het pas \'n vasvra by Reader-aktiwiteit bygevoeg';
$string['event_quiz_delay_set'] = 'Reader-vasvravertraging is gestel';
$string['event_quiz_delay_set_description'] = 'Die gebruiker met id "{$a->userid}" het \'n vasvravertraging vir die "reader" aktiwiteit met kursusmodule-id "{$a->cmid}" gestel';
$string['event_quiz_delay_set_explanation'] = '\'n Gebruiker het pas \'n vertraging op \'n Reader-vasvra gestel';
$string['event_quiz_deleted'] = 'Reader-vasvra is uitgewis';
$string['event_quiz_deleted_description'] = 'Die gebruiker met id "{$a->userid}" het \'n vasvra vir die "reader" aktiwiteit met kursusmodule-id "{$a->cmid}" uitgewis';
$string['event_quiz_deleted_explanation'] = '\'n Gebruiker het pas \'n Reader-vasvra uitgewis';
$string['event_quiz_edited'] = 'Reader-vasvra is gewysig';
$string['event_quiz_edited_description'] = 'Die gebruiker met id "{$a->userid}" het \'n vasvra vir die "reader" aktiwiteit met kursusmodule-id "{$a->cmid}" gewysig';
$string['event_quiz_edited_explanation'] = '\'n Gebruiker het pas \'n Reader-vasvra gewysig';
$string['event_quiz_finished'] = 'Reader-vasvra is voltooi';
$string['event_quiz_finished_description'] = 'Die gebruiker met id "{$a->userid}" het \'n vasvra vir die "reader" aktiwiteit met kursusmodule-id "{$a->cmid}" voltooi';
$string['event_quiz_finished_explanation'] = '\'n Gebruiker het pas \'n Reader-vasvra voltooi';
$string['event_quiz_selected'] = 'Reader-vasvra is gekies';
$string['event_quiz_selected_description'] = 'Die gebruiker met id "{$a->userid}" het \'n vasvra vir die "reader" aktiwiteit met kursusmodule-id "{$a->cmid}" gekies';
$string['event_quiz_selected_explanation'] = '\'n Gebruiker het pas \'n Reader-vasvra gekies';
$string['event_quiz_started'] = 'Reader-vasvra is begin';
$string['event_quiz_started_description'] = 'Die gebruiker met id "{$a->userid}" het \'n vasvra vir die "reader" aktiwiteit met kursusmodule-id "{$a->cmid}" begin';
$string['event_quiz_started_explanation'] = '\'n Gebruiker het pas \'n Reader-vasvra begin';
$string['event_report_bookdetailed_viewed'] = 'Reader-verslag is besigtig: Boeke (gedetailleerd)';
$string['event_report_bookdetailed_viewed_description'] = 'Die gebruiker met id "{$a->userid}" het die "Boeke (gedetailleerd)" verslag vir die "reader" aktiwiteit met kursusmodule-id "{$a->cmid}" besigtig';
$string['event_report_bookdetailed_viewed_explanation'] = '\'n Gebruiker het pas \'n Reader-verslag: Boeke (gedetailleerd) besigtig';
$string['event_report_booksummary_viewed'] = 'Reader-verslag is besigtig: Boeke (opsomming)';
$string['event_report_booksummary_viewed_description'] = 'Die gebruiker met id "{$a->userid}" het die "Boeke (opsomming)" verslag vir die "reader" aktiwiteit met kursusmodule-id "{$a->cmid}" besigtig';
$string['event_report_booksummary_viewed_explanation'] = '\'n Gebruiker het pas \'n Reader-verslag: Boeke (opsomming) besigtig';
$string['event_report_groups_viewed'] = 'Reader-verslag is besigtig: Groepe (opsomming)';
$string['event_report_groups_viewed_description'] = 'Die gebruiker met id "{$a->userid}" het die "Groepe (opsomming)" verslag vir die "reader" aktiwiteit met kursusmodule-id "{$a->cmid}" besigtig';
$string['event_report_groups_viewed_explanation'] = '\'n Gebruiker het pas \'n Reader-verslag: Groepe (opsomming) besigtig';
$string['event_report_userdetailed_viewed'] = 'Reader-verslag is besigtig: Gebruikers (gedetailleerd)';
$string['event_report_userdetailed_viewed_description'] = 'Die gebruiker met id "{$a->userid}" het die "Gebruikers (gedetailleerd)" verslag vir die "reader" aktiwiteit met kursusmodule-id "{$a->cmid}" besigtig';
$string['event_report_userdetailed_viewed_explanation'] = '\'n Gebruiker het pas \'n Reader-verslag: Gebruikers (gedetailleerd) besigtig';
$string['event_report_usersummary_viewed'] = 'Reader-verslag is besigtig: Gebruikers (opsomming)';
$string['event_report_usersummary_viewed_description'] = 'Die gebruiker met id "{$a->userid}" het die "Gebruikers (opsomming)" verslag vir die "reader" aktiwiteit met kursusmodule-id "{$a->cmid}" besigtig';
$string['event_report_usersummary_viewed_explanation'] = '\'n Gebruiker het pas \'n Reader-verslag: Gebruikers (opsomming) besigtig';
$string['event_tool_run'] = 'Reader-adminhulpmiddellopie';
$string['event_tool_run_description'] = 'Die gebruiker met id "{$a->userid}" het \'n adminhulpmiddel vir die "reader" aktiwiteit met kursusmodule-id "{$a->cmid}" geloop';
$string['event_tool_run_explanation'] = '\'n Gebruiker het pas \'n Reader-hulpmiddel: {$a} geloop';
$string['event_user_goal_set'] = 'Reader-gebruikersdoelwit is gestel';
$string['event_user_goal_set_description'] = 'Die gebruiker met id "{$a->userid}" het \'n studentleesdoelwit vir die "reader" aktiwiteit met kursusmodule-id "{$a->cmid}" gestel';
$string['event_user_goal_set_explanation'] = '\'n Gebruiker het pas \'n leesdoelwit op \'n Reader-aktiwiteit gestel';
$string['event_user_level_set'] = 'Reader-gebruikervlak is gestel';
$string['event_user_level_set_description'] = 'Die gebruiker met id "{$a->userid}" het \'n studentleesvlak vir die "reader" aktiwiteit met kursusmodule-id "{$a->cmid}" gestel';
$string['event_user_level_set_explanation'] = '\'n Gebruiker het pas die leesvlak vir \'n student op \'n Reader-aktiwiteit gestel';
$string['event_users_exported'] = 'Reader-gebruikers is uitgevoer';
$string['event_users_exported_description'] = 'Die gebruiker met id "{$a->userid}" het studentdata vir die "reader" aktiwiteit met kursusmodule-id "{$a->cmid}" uitgevoer';
$string['event_users_exported_explanation'] = '\'n Gebruiker het pas studentdata van \'n Reader-aktiwiteit uitgevoer';
$string['event_users_imported'] = 'Reader-gebruikers is ingevoer';
$string['event_users_imported_description'] = 'Die gebruiker met id "{$a->userid}" het studentdata vir die "reader" aktiwiteit met kursusmodule-id "{$a->cmid}" ingevoer';
$string['event_users_imported_explanation'] = '\'n Gebruiker het pas studentdata na \'n Reader-aktiwiteit ingevoer';
$string['export'] = 'Voer uit';
$string['export_reader_tables'] = 'Voer Reader-tabelle uit';
$string['export_reader_tables_desc'] = 'Voer Reader-databasistabelle uit. Let daarop dat die uitgevoerde data geen kursus- of gebruikersname bevat nie, maar slegs id\'s.';
$string['exportstudentrecords'] = 'Voer studenterekords uit';
$string['extrapoints'] = 'Ekstra Punte';
$string['extrapoints0'] = '0.5 Punte';
$string['extrapoints1'] = '1 Punt';
$string['extrapoints2'] = '2 Punte';
$string['extrapoints3'] = '3 Punte';
$string['extrapoints4'] = '4 Punte';
$string['extrapoints5'] = '5 Punte';
$string['extrapoints6'] = '6 Punte';
$string['extrawords'] = '{$a} woorde';
$string['failed'] = 'Gedruip';
$string['failedshort'] = 'F';
$string['filename'] = 'Dokumentnaam';
$string['fileuploaded'] = 'Dokument is opgelaai';
$string['find_faultyquizzes'] = 'Spoor foutiewe vasvrae op';
$string['find_faultyquizzes_desc'] = 'Spoor vasvrae op wat vrae het met geen korrekte antwoord nie, of vrae wat wees gelaat is.';
$string['finishreview'] = 'Voltooi revisie';
$string['fix_bookcovers'] = 'Stel boekomslae reg';
$string['fix_bookcovers_desc'] = 'Spoor boeke op waarvan \'n boekomslagprent ontbreek, en probeer om die boekomslagprent af te laai.';
$string['fix_bookinstances'] = 'Stel boekeksemplare reg';
$string['fix_bookinstances_desc'] = 'Verseker dat alle boeke \'n geassosieerde rekord in die reader_book_instances-tabel het.';
$string['fix_coursesections'] = 'Stel kursusafdelings reg';
$string['fix_coursesections_desc'] = 'Maak die hoofblad van kursusse wat Reader-vasvrae bevat, netjies.

* sorteer afdelings volgens uitgewernaam en vlak se moeilikheidsgraad
* verseker dat elke afdeling slegs boeke deur een uitgewer bevat
* vleg veelvuldige afdelings van dieselfde uitgewer saam
* verwyder leë afdelings
* herstel aantal kursusafdelings';
$string['fix_installxml'] = 'Stel db/install.xml reg';
$string['fix_installxml_desc'] = 'Maak XML-merkers in db/install.xml versoenbaar met Moodle <=2.5

* voeg VOLGENDE en VORIGE eienskappe by TABEL, VELD, SLEUTEL en INDEKS merkers
* voeg VOLGORDE eienskappe by VELD-merkers met TYPE="int"';
$string['fix_missingquizzes'] = 'Stel ontbrekende vasvrae reg';
$string['fix_missingquizzes_desc'] = 'Verenig duplikaat Reader-boeke en -vasvrae.

* vleg duplikaat boeke saam
* stel boeke wat dieselfde vasvra deel, reg
* vleg duplikaat vasvrae saam
* stel boeke en pogings waarvan die vasvra ontbreek, reg';
$string['fix_questioncategories'] = 'Stel vraagkategorieë reg';
$string['fix_questioncategories_desc'] = 'Maak Reader-vrae en -vraagkategorieë netjies.

* ontmerk alle ongeldige moedervraag-id\'s
* wis Reader-vrae uit wat nie in enige Reader-vasvrae gebruik word nie
* skuif Reader-kursusvraagkategorieë na die geskikte Reader-vasvra
* verwyder skuinsstrepe uit kategoriename en -beskrywings
* standaardiseer name van Sorteringskategorieë';
$string['fix_slashesinnames'] = 'Stel skuinsstrepe in name reg';
$string['fix_slashesinnames_desc'] = 'Verwyder enige skuinsstrepe in die name van Reader-boeke en -vraagkategorieë';
$string['fix_wrongattempts'] = 'Stel verkeerde pogings reg';
$string['fix_wrongattempts_desc'] = 'Spoor enige pogings tot Reader-vasvrae op waar die naam van die vasvra nie ooreenstem met die naam van die boek in die Reader-log nie, en stel dit reg';
$string['fixattempts'] = 'Duplikaat Reader-pogings word reggestel';
$string['fixcontexts'] = 'Foutiewe inhoud in Vasvravraagkategorieë word reggestel';
$string['fixingsumgrades'] = 'Punte op pogings tot Reader-vasvrae word reggestel';
$string['fixinstances'] = 'Reader-vraageksemplare word gekontroleer';
$string['fixmissingquizzes'] = 'Stel ontbrekende vasvrae reg';
$string['fixmissingquizzesinfo'] = 'Die bywerking is tydelik gestaak, sodat jy kan besluit of jy Reader-modulevasvrae, wat op hierdie Moodle-werf ontbreek, wil aflaai en installeer.

As jy "Ja" kies, sal die ontbrekende vasvrae afgelaai en geïnstalleer word.

As jy "Nee" kies, sal enige Reader-boeke waarvan die vasvra ontbreek gemerk word as dat dit geen vasvradata bevat nie.

Let daarop dat, selfs al kies jy "Nee", die woordtelling vir elke student in Reader-aktiwiteite nie deur hierdie operasie geaffekteer sal word nie.

Wil jy steeds ontbrekende Reader-modulevasvrae vir boeke op hierdie Moodle-werf aflaai en installeer?';
$string['fixmultichoice'] = 'Reader-meervoudigekeusevrae word reggestel';
$string['fixordering'] = 'Die sortering van vrae vir Reader-module word bygewerk';
$string['fixquestiontext'] = 'Stel HTML-merkers in Reader-vrae reg';
$string['fixquizslots'] = 'Foutiewe vraaggleuwe in Vasvrapogings word reggestel';
$string['fixslashesinnames'] = 'Verwyder skuinsstrepe uit boektitels';
$string['fixwrongquizid'] = '"{$a->name}" (book id={$a->id}) het \'n onverwagte vasvra-id';
$string['fixwrongquizidinfo'] = 'Die bywerking is tydelik gestaak, sodat jy kan besluit watter vasvra met hierdie boek geassosieer moet word.

Hersien asseblief die inligting hieronder en kies die vasvra wat jy met hierdie boek geassosieer wil hê.';
$string['forcedownload'] = 'Dwing aflaai';
$string['forcedtimedelay'] = 'Stel gedwonge tydsvertraging';
$string['forcedtimerate'] = 'Stel gedwonge leestempo';
$string['fromthistime'] = 'Van hierdie tyd af';
$string['fullreportbybooktitle'] = 'Volledige Verslag volgens Boektitel';
$string['fullreportquiztoreader'] = 'Volledige Verslag volgens Student';
$string['genre'] = 'Genre';
$string['getstarted'] = '**Om te begin**

* Die doelwit van hierdie aktiwiteit is om baie boeke te lees en jou leestotaal te verhoog.
* Jou leestotaal is die totale aantal woorde in al die boeke wat jy gelees het.

**Kies \'n boek**

* Jy behoort boeke te kies wat jy maklik sonder \'n woordeboek kan lees.
* Kies ook boeke waarin jy belangstel, omdat hulle lekkerder is om te lees.

**Doen \'n aanlyn vasvra**

* Nadat jy \'n boek gelees het, doen \'n aanlyn vasvra.
* Gebruik die soekbokse op hierdie bladsy om die vasvra waarna jy op soek is, te vind. Wanneer jy jou vasvra gevind het, kliek die knoppie om met die vasvra te begin.
* Elke vasvra het etlike vrae oor die boek. Die vrae is vir elke student anders.
* As jy die vasvra slaag, sal die aantal woorde in die boek by jou leestotaal gevoeg word. As jy die vasvra druip, verander jou leestotaal nie.
* ***Jy kan nie vasvrae weer doen nie***, doen dus asseblief die vasvrae versigtig.';
$string['goal'] = 'Doelwit';
$string['groupgoals'] = 'Doelwitte vir spesifieke groepe';
$string['grouprates'] = 'Tempo\'s vir spesifieke groepe';
$string['hidden'] = 'Versteek';
$string['ifimagealreadyexists'] = 'As prent reeds in prentelêer (naam) bestaan';
$string['ignoredate'] = 'Termyn begindatum';
$string['ignoredate_help'] = 'Die datum van die begin van die huidige termyn.

Enige pogings tot Reader-vasvrae wat voor hierdie datum gedoen word, sal nie in die verslagtotale vir die huidige termyn ingesluit word nie.

Pogings in vorige termyne word egter nie heeltemal geïgnoreer nie. Dit sal in die verslagtotale vir "Alle termyne" ingesluit word.

Let asseblief ook daarop dat studente nooit Reader-vasvrae weer kan doen nie, dié wat in vorige termyne gedoen is ingesluit, tensy die onderwyser die vorige poging uitwis.';
$string['image'] = 'Prent';
$string['imageadded'] = 'Prent bygevoeg: {$a}';
$string['import'] = 'Voer in';
$string['import_reader_tables'] = 'Voer Reader-tabelle in';
$string['import_reader_tables_desc'] = 'Herskep \'n volledige Moodle-werf net uit die Reader-databasistabelle. Hierdie hulpmiddel sal kursusse, gebruikers, groepe, Reader-aktiwiteite en -vasvrae skep.';
$string['importreadertables'] = 'Voer Reader-tabelle in';
$string['importstudentrecord'] = 'Voer studentrekord in';
$string['in1000sofwords'] = 'in 1000\'e van woorde';
$string['includepublishers'] = 'Soek ook uitgewername?';
$string['incorrect'] = '- verkeerd';
$string['incorrect2'] = '- Jammer, verkry asseblief die korrekte wagwoord van die uitgewer(s). Kliek "Installeer Vasvrae" om jou ander keuses af te laai.';
$string['incorrectbooksreadinpreviousterms'] = 'Besigtig gedruipte vasvrae';
$string['induration'] = 'in';
$string['install_quizzes'] = 'Installeer Vasvrae';
$string['installedbooks'] = 'Laai slegs omslae af vir boeke wat reeds op hierdie werf GEïNSTALLEER is, en stel dit reg';
$string['ipaddress'] = 'IP-adres';
$string['isgreaterthan'] = 'is meer as';
$string['islessthan'] = 'is minder as';
$string['itemsdownloaded'] = '{$a} items afgelaai';
$string['keeplocalbookdifficulty'] = 'Behou plaaslike instellings vir boekmoeilikheidsgraad';
$string['keepoldquizzes'] = 'Behou ou vasvrae';
$string['lastupdatedtime'] = 'Die vasvrae op hierdie werf is laaste op {$a} bygewerk. Wil jy die werf nou bywerk?';
$string['level'] = 'Vlak';
$string['levelcheck'] = 'Beperk leesvlak';
$string['levelcheck_help'] = '**Ja**
: Studente sal slegs toegelaat word om Reader-vasvrae by of naby aan hul huidige leesvlak te doen. Die aantal vasvrae wat studente toegelaat word om te doen, word in die verstellings op hierdie bladsy vir "Vasvrae op huidige/vorige/volgende vlak" gespesifiseer.

**Nee**
: Studente sal altyd toegelaat word om Reader-vasvrae vir boeke op enige leesvlak te doen.';
$string['levelgoal'] = 'Vlak {$a} doelwit';
$string['levelgoals'] = 'Doelwitte vir spesifieke vlakke';
$string['leveli'] = 'Vlak {$a}';
$string['levelrate'] = 'Vlak {$a} tempo';
$string['levelrates'] = 'Tempo\'s vir spesifieke vlakke';
$string['levels'] = 'Vlakke';
$string['likebook'] = 'Hoe het jy van hierdie boek gehou?';
$string['logoutrequired'] = 'Jy kan nie voortgaan nie, omdat jy tans ingeteken is as {$a}.

Om voort te gaan, kliek asseblief die "Teken uit"-knoppie hieronder, en teken dan weer as jyself in.';
$string['mainpagesettings'] = 'Hoofbladverstellings';
$string['makebookavailable'] = 'Stel boeke beskikbaar';
$string['makebookavailableproblem'] = 'Oeps, kon NIE boek in hierdie kursus beskikbaar maak nie: {$a}';
$string['makebookavailablesuccess'] = 'Boek is nou in hierdie kursus beskikbaar: {$a}';
$string['makenewquizzesavailable'] = 'Maak nuwe vasvrae slegs in hierdie kursus beskikbaar';
$string['makenewquizzesavailable2'] = 'Maak nuwe vasvrae in alle kursusse op hierdie vlak beskikbaar [verstek]';
$string['massrename'] = 'Grootmaat veranderinge';
$string['max'] = 'Minder as of gelyk aan';
$string['maxgrade'] = 'Maksimum punt';
$string['maxgrade_help'] = 'Die maksimum punt vir hierdie Reader-aktiwiteit.

Die aantal woorde wat gelees is, as \'n fraksie van die leesdoelwit, sal na hierdie maksimum punt omgereken word en na die punteboek aangestuur word.

Gewoonlik sal die maksimum punt 100 wees, maar as alle studente dieselfde leesdoelwit het, kan dit studente hul punt help verstaan as hierdie verstelling dieselfde is as die leesdoelwit.';
$string['maxquizattemptrate'] = 'Maksimum vasvrapogingkoers';
$string['maxquizattemptrate_help'] = 'Die maksimum koers waarteen studente Reader-vasvrae kan poog. As \'n student probeer om meer as die gespesifiseerde aantal vasvrae binne die gespesifiseerde tydperk te doen, sal die gespesifiseerde aksie toegepas word.';
$string['maxquizattemptratetext'] = 'Moet asseblief nie meer as {$a} doen nie. As jy hierdie hoeveelheid oorskry, sal die volgende stappe gedoen word:';
$string['maxquizfailurerate'] = 'Maksimum vasvradruipkoers';
$string['maxquizfailurerate_help'] = 'Die maksimum koers waarteen studente Reader-vasvrae kan druip. As \'n student meer as die gespesifiseerde aantal vasvrae binne die gespesifiseerde tydperk druip, sal die gespesifiseerde aksie toegepas word.';
$string['maxquizfailureratetext'] = 'As jy meer as {$a} druip, sal die volgende stappe gedoen word:';
$string['maxtimebetweenquizzes'] = 'Maks. tyd tussen vasvrae';
$string['menu'] = 'Kieslys';
$string['mergingtables'] = 'Saamvlegging van tabelle: {$a->old} na {$a->new}';
$string['messagefromyourteacher'] = 'Boodskap vanaf jou onderwyser';
$string['migratinglogs'] = 'Migrerende Reader-logs';
$string['min'] = 'Meer as of gelyk aan';
$string['minimumdelay'] = 'Maksimum vertraging';
$string['minpassgrade'] = 'Vasvraslaagpunt';
$string['minpassgrade_help'] = 'Die minimum slaagpunt, as \'n persentasie, vir vasvrae in hierdie Reader-aktiwiteit.

Pogings met persentasiepunte laer as hierdie waarde sal as gedruip gemerk word.';
$string['minquizattemptrate'] = 'Minimum vasvrapogingkoers';
$string['minquizattemptrate_help'] = 'Die minimum koers waarteen studente Reader-vasvrae kan poog. As \'n student nie aanhou om minstens die gespesifiseerde aantal vasvrae binne die gespesifiseerde tydperk te probeer doen nie, sal die gespesifiseerde aksie toegepas word.';
$string['minquizattemptratetext'] = 'Doen asseblief minstens {$a}. As jy onder hierdie koers val, sal die volgende stappe gedoen word:';
$string['modulename'] = 'Reader';
$string['modulename_help'] = 'Die Reader-module laat onderwysers toe om leesdoelwitte vir studente te stel, en laat studente toe om te demonstreer dat hulle die gespesifiseerde leesdoelwitte bereik het.';
$string['modulename_link'] = 'mod/reader/view';
$string['modulenameplural'] = 'Reader';
$string['morenewattempts'] = '{$a} meer nuwe pogings ...';
$string['move_quizzes'] = 'Skuif vasvrae';
$string['move_quizzes_desc'] = 'Skuif Reader-vasvrae van die huidige kursus na die hoofkursus vir Reader-vasvrae.';
$string['movedquizzes'] = '{$a} vasvrae is suksesvol geskuif';
$string['mreaderenable'] = 'Ontsper mReader-verstellings';
$string['mreadersettings'] = 'Verkry toegang tot mReader-vasvrae';
$string['mreadersiteid'] = 'Werf-ID vir mReader-vasvrae';
$string['mreadersitekey'] = 'Sleutel vir mReader-vasvrae';
$string['mreaderurl'] = 'URL vir mReader-vasvrae';
$string['needdeletethisattemptstoo'] = 'Hierdie pogings moet ook uitgewis word';
$string['needtocheckupdates'] = 'Hierdie werf het in ({$a} dae) nie gekontroleer of daar vasvrabywerkings is nie. Kontroleer nou?';
$string['newdate'] = 'Nuwe datum';
$string['newreaderattempts'] = 'Nuwe Reader-pogings';
$string['newreadinggoal'] = 'Nuwe doelwit';
$string['newreadinglevel'] = 'Nuwe vlak';
$string['newsetting'] = 'Nuwe waarde vir hierdie verstelling';
$string['newtime'] = 'Nuwe tyd';
$string['nextlevel'] = 'Vasvrae op volgende vlak';
$string['nextlevel_help'] = 'Die aantal vasvrae wat \'n student op die volgende vlak kan doen, d.w.s. die leesvlak wat net bokant hul huidige leesvlak is. Let daarop dat hierdie vasvrae NIE vir bevordering tel nie.';
$string['no_password'] = 'Geen wagwoord word vereis nie.';
$string['noaction'] = 'Doen geen stappe nie';
$string['nobooksfound'] = 'Geen boeke is gevind nie';
$string['nobooksinlist'] = 'Geen boeke is vir jou leesvlak gevind nie';
$string['nodownloaditems'] = 'Geen items is vir aflaai beskikbaar nie';
$string['noemailever'] = 'Die stuur van e-pos is versper weens $CFG->noemailever konfig-verstelling';
$string['noincorrectquizzes'] = 'Jy het geen vasvrae gedruip nie';
$string['nomoreattempts'] = 'Geen verdere pogings word toegelaat nie';
$string['noquizzesfound'] = 'Geen vasvrae is gevind nie';
$string['noreaders'] = 'Geen Reader-aktiwiteite is in hierdie kursus gevind nie';
$string['norecordsmatch'] = 'Geen rekords met die huidige filters en vertoonopsies is gekies nie.';
$string['noreview'] = 'Jy het nie toestemming om hierdie vasvra te hersien nie';
$string['noreviewshort'] = 'Nie toegelaat nie';
$string['normalmode'] = 'Normaal';
$string['noscript'] = 'JavaScript moet ontsper wees om voort te gaan!';
$string['nosearchresults'] = 'Geen boeke wat met jou soektog ooreenstem, is beskikbaar nie';
$string['notavailable'] = 'Hierdie vasvra is nie tans beskikbaar nie';
$string['nothavepermissioncreateinstance'] = 'Jammer, jy beskik nie oor toestemming om dit te doen nie';
$string['notifycheating'] = 'Stel bedrieërs in kennis';
$string['notifycheating_help'] = 'As hierdie verstellings ontsper is, sal die "Kul-boodskap" hieronder aan studente, wat geïdentifiseer is dat hulle op Reader-vasvrapogings gekul het, gestuur word.';
$string['numattempts'] = '{$a} pogings';
$string['numberofextrapoints'] = 'Aantal ekstra punte';
$string['off'] = 'Af';
$string['oneattempt'] = '1 poging';
$string['onlybookswithmorethan'] = 'Slegs boeke met meer as';
$string['outputformat'] = 'Afvoerformaat';
$string['pagesettings'] = 'Bladsyverstellings';
$string['passed'] = 'Geslaag';
$string['passedshort'] = 'P';
$string['passworderror'] = 'Die wagwoord wat ingevoer is, is verkeerd';
$string['passwords_list'] = 'Wagwoordlys';
$string['percentactive'] = 'Aktiewe persentasie';
$string['percentactive_help'] = 'Die persentasie studente wat minstens een Reader-vasvra gedoen het';
$string['percentinactive'] = 'Onaktiewe persentasie';
$string['percentinactive_help'] = 'Die persentasie studente wat geen Reader-vasvrae gedoen het nie';
$string['pleaseaskyourinstructor'] = 'Vra asseblief jou instrukteur om jou \'n vlak op te skuif as dit vir jou te maklik is.';
$string['pleaseclose'] = 'Jou versoek is verwerk. Jy kan hierdie venster nou toemaak.';
$string['pleaseselectpublisher'] = 'Kies Asseblief Uitgewer';
$string['pleasespecifyyourclassgroup'] = 'Spesifiseer asseblief jou klasgroep of soek na \'n spesifieke student.';
$string['pleasewait'] = 'Wag asseblief';
$string['pluginadministration'] = 'Reader-administrasie';
$string['pluginname'] = 'Reader';
$string['points'] = 'Punte';
$string['pointsex11'] = 'Lengte (Bv. 1.1)';
$string['popup'] = 'Gebruik "veilige" venster';
$string['popup_help'] = 'As "Ja" gekies is,

* Sal die vasvra slegs begin as die student \'n webblaaier het waarop JavaScript ontsper is
* Die vasvra in \'n volskerm opspringventer verskyn, wat al die ander vensters bedek en geen navigasiekontroles het nie
* Stduente word so ver moontlik verhoed om funksies soos kopieer en plak te gebruik';
$string['prevlevel'] = 'Vasvrae op vorige vlak';
$string['prevlevel_help'] = 'Die aantal vasvrae wat \'n student van die vorige leesvlak kan neem, d.w.s. die leesvlak wat net onder hul huidige leesvlak is. Let daarop dat hierdie vasvrae NIE vir bevordering tel nie.';
$string['print_cheatsheet'] = 'Druk kulblad';
$string['print_cheatsheet_desc'] = 'Vertoon die antwoorde vir enige Reader-vasvra';
$string['process_addquestion'] = '<b>Voeg vrae by vasvra {$a}.</b><br />';
$string['process_courseadded'] = '<b>Kursus bygevoeg.</b><br />';
$string['promotionnotallowed'] = 'Jou onderwyser het outomatiese bevordering vir jou gestaak.';
$string['promotionsettings'] = 'Bevorderingsverstellings';
$string['publisher'] = 'Uitgewer';
$string['publishers'] = 'Uitgewers';
$string['questionscores'] = 'Vertoon vraagpunte';
$string['questionscores_help'] = 'Behoort die maksimum punte vir elke vraag aan studente vertoon te word wanneer hulle \'n Reader-vasvra poog?

**Ja**
: Vertoon die maksimum punte vir vrae in Reader-vasvrae.

**Nee**
: Versteek die maksimum punte vir vrae in Reader-vasvrae.';
$string['quizadd'] = 'Voeg Reader-vasvrae by';
$string['quizadded'] = 'Vasvra bygevoeg: {$a}';
$string['quizarrange'] = 'Reël Reader-vasvrae';
$string['quizattemptinprogress'] = 'Vasvrapoging is aan die gang ...';
$string['quizclosed'] = 'Hierdie vasvra het op {$a} gesluit';
$string['quizcloseson'] = 'Hierdie vasvra sal om {$a} sluit';
$string['quizdelete'] = 'Wis Reader-vasvrae uit';
$string['quizfordays'] = 'Frekwensiebeperking (dae)';
$string['quizhasnoquestions'] = 'Vasvra het geen vrae nie';
$string['quizmanagement'] = 'Vasvrabestuur';
$string['quizname'] = 'Vasvranaam';
$string['quiznotavailable'] = 'Jammer, hierdie vasvra is nie tans aan jou beskikbaar nie';
$string['quiznotavailableuntil'] = 'Die vasvra sal nie beskikbaar wees tot {$a} nie';
$string['quizonmreaderorg'] = '(Vasvra beskikbaar op mreader.org)';
$string['quizopenedon'] = 'Hierdie vasvra het om {$a} oopgemaak';
$string['quizsetrate'] = 'Stel koers van Reader-vasvrae';
$string['quizshowhide'] = 'Vertoon / Versteek Reader-vasvrae';
$string['quiztimelimit'] = 'Tydsbeperking: {$a}';
$string['quizupdate'] = 'Werk Reader-vasvrae by';
$string['quizupdated'] = 'Vasvra bygewerk: {$a}';
$string['quizupdateswillbeapplied'] = 'Bywerkings vir die vasvra sal op alle kursusse wat tans van die vasvra gebruik maak, toegepas word.';
$string['quizzes'] = 'Vasvrae';
$string['quizzesadd'] = 'Voeg vasvrae by';
$string['quizzesadded'] = 'Vasvrae is bygevoeg';
$string['quizzesarrange'] = 'Reël vasvrae';
$string['quizzesdelete'] = 'Wis vasvrae uit';
$string['quizzesmustbeinstalled'] = 'Vasvrae moet in \'n kursus geïnstalleer word wat apart van die kursus is waarop die studente sal inteken wanneer hulle vasvrae doen. Hierdie kursus is vir die studente versteek en word slegs as bergingsarea vir die vasvrae gebruik, en word gewoonlik "Alle Vasvrae" genoem. Die kursus wat jy vir hierdie doel daargestel het, behoort hieronder vertoon te word. As jy nog nie \'n kursus daargestel het nie, kliek asseblief op "Skep nuwe kursus".';
$string['quizzespassedtable'] = 'Vasvrae geslaag op RL-{$a}';
$string['quizzessetrate'] = 'Stel leestempo';
$string['quizzesshowhide'] = 'Vertoon/Versteek vasvrae';
$string['quizzesupdate'] = 'Werk vasvrae by';
$string['rate'] = 'Koers';
$string['rate_help'] = 'Die leeskoers word gespesifiseer as die maksimum toegelate aantal pogings tot Reader-vasvrae, of die minimum vereiste aantal pogings binne \'n gespesifiseerde tydperk.';
$string['rateaction'] = 'Aksie';
$string['rateaction_help'] = 'Dit is die aksie wat geneem sal word as die leeskoersbeperking oorskry word. Die volgende stappe is beskikbaar:

**Vertraag verdere pogings tot vasvra**
: Die student sal daarvan verhoed word om nog \'n Reader-vasvra te poog voordat die tydperk verval het.

**Blokkeer verdere vasvrapogings**
: Die student sal daarvan verhoed word om enige verdere Reader-vasvrae te poog, totdat \'n onderwyser die blok verwyder.

**Stuur e-pos na die student**
: \'n E-pos sal na die student gestuur word om hulle van die koersoorskryding in te lig.

**Stuur e-pos na onderwyser**
: \'n E-pos sal na die onderwyser gestuur word om hulle van die student se koersoorskryding in te lig.';
$string['rategroup'] = 'Groep';
$string['rategroup_help'] = 'die groep waarop hierdie koersbeperking van toepassing is';
$string['ratelevel'] = 'Vlak';
$string['ratelevel_help'] = 'die leesvlak waarop hierdie koersbeperking van toepassing is';
$string['ratemanyconsecutively'] = '{$a->attempts} vasvrae agtereenvolgens';
$string['ratemanyinduration'] = '{$a->attempts} vasvrae in {$a->duration}';
$string['rateoneinduration'] = '{$a->attempts} vasvra in {$a->duration}';
$string['ratetype'] = 'Tipe';
$string['ratetype_help'] = 'Die volgende tipes leeskoerse kan gespesifiseer word:

**Minimum koers van vasvrapogings**
: Die minimum koers waarteen studente Reader-vasvrae mag poog. As \'n student nie aanhou om minstens die gespesifiseerde aantal vasvrae binne die gespesifiseerde tydperk te poog nie, sal die gespesifiseerde stap gedoen word.

**Maksimum koers van vasvrapogings**
: Die maksimum koers waarteen studente Reader-vasvrae kan poog. As \'n student probeer om meer as die gespesifiseerde aantal vasvrae binne die gespesifiseerde tydperk te poog, sal die gespesifiseerde stap gedoen word.

**Maksimum vasvradruipkoers**
: Die maksimum koers waarteen studente Reader-vasvrae kan druip. As \'n student meer as die gespesifiseerde aantal vasvrae binne die gespesifiseerde tydperk druip, sal die gespesifiseerde stap gedoen word.';
$string['ratings'] = 'graderings';
$string['reader:addinstance'] = 'Voeg \'n nuwe Reader-aktiwiteit by';
$string['reader:manageattempts'] = 'Bestuur pogings';
$string['reader:managebooks'] = 'Bestuur boeke';
$string['reader:manageremotesites'] = 'Bestuur afstandswerwe';
$string['reader:managetools'] = 'Bestuur hulpmiddels';
$string['reader:manageusers'] = 'Bestuur gebruikers';
$string['reader:viewallbooks'] = 'Besigtig alle boeke';
$string['reader:viewbooks'] = 'Besigtig boeke';
$string['reader:viewreports'] = 'Besigtig verslae';
$string['reader:viewversion'] = 'Besigtig weergawe';
$string['readerdownload'] = 'Laai Reader-boeke (en -vasvrae) af';
$string['readerid'] = 'Reader-ID';
$string['readerquizsettings'] = 'Reader-vasvraverstellings';
$string['readerreports'] = 'Reader-moduleverslae';
$string['readinglevel'] = 'Leesvlak (RL)';
$string['readinglevelshort'] = 'RL {$a}';
$string['readingreportfor'] = 'Leesverslag vir {$a}';
$string['readonlyfrom'] = 'Leesalleenvorm';
$string['readonlyfrom_help'] = 'Ná hierdie datum en tyd kan studente hul hoof Reader-blad besigtig, maar hulle kan nie enige verdere vasvrae via hierdie Reader-aktiwiteit doen nie.';
$string['readonlymode'] = 'Leesalleenmodus';
$string['readonlymode_desc'] = 'Hierdie aktwiteit is tans in leesalleenmodus. Jy kan die inligting op die eerste bladsy van hierdie Reader-aktiwiteit besigtig, maar jy kan geen Reader-vasvrae doen nie.';
$string['readonlysincedate'] = 'Hierdie aktiwiteit is sedert {$a} in leesalleenmodus.';
$string['readonlyuntil'] = 'Leesalleen tot';
$string['readonlyuntil_help'] = 'Voor hierdie dag en tyd kan studente hul hoof Reader-blad besigtig, maar hulle kan geen vasvrae via hierdie Reader-aktiwiteit doen nie.';
$string['readonlyuntildate'] = 'Hierdie aktiwiteit sal tot {$a} in leesalleenmodus bly.';
$string['recommendedreadingrates'] = 'Beveel leeskoerse aan';
$string['redo_upgrade'] = 'Doen bywerking oor';
$string['redo_upgrade_desc'] = 'Doen \'n bywerking van die Reader-module oor';
$string['remotesitenotaccessible'] = 'Afstandsaflaaiwerf is nie bereikbaar nie';
$string['removebook'] = 'Verwyder boeke';
$string['removebook_help'] = 'Boeke wat "regstreekse" pogings het, kan nie uitgewis word nie. Om sulke boeke uit te wis, sal jy nodig hê om hul "regstreekse" pogings uit te wis.';
$string['removebookerror'] = 'Boek is NIE verwyder nie: {$a}';
$string['removebookinstance'] = 'Verwyder gekose boeke uit hierdie kursus';
$string['removebooksuccess'] = 'Boek is verwyder: {$a}';
$string['repairmode'] = 'Herstel';
$string['reportbookdetailed'] = 'Boeke (volledig)';
$string['reportbookratings'] = 'Boekgraderings';
$string['reportbooksummary'] = 'Boeke (opsomming)';
$string['reporteditsite'] = 'Boeke (alle boekdata)';
$string['reportgroupsummary'] = 'Groepe';
$string['reportquiztoreader'] = 'Opsommingsverslag deur Student';
$string['reports'] = 'Verslae';
$string['reportsettings'] = 'Verslagverstellings';
$string['reportuserdetailed'] = 'Studente (volledig)';
$string['reportusersummary'] = 'Studente (opsomming)';
$string['requirepasswordmessage'] = 'Om hierdie vasvra te poog, moet jy die vasvra se wagwoord ken';
$string['requireqtypeordering'] = 'Die Reader-aktiwiteitmodule kan nie geïnstalleer of bygewerk word nie, omdat die Sorteer-vraagtipe ontbreek. Laai asseblief die Sorteer-vraagtipe af, sit dit by {$a}/vraag/tipe/sorteer, en herlaai hierdie bladsy.';
$string['restoreattempts'] = 'Herstel gekose pogings';
$string['restoredeletedattempt'] = 'Herstel uitgewiste poging';
$string['restrictlocalhost'] = 'Jammer, jy kan nie vasvrae op mreader.org vanaf jou huidige plaaslike gasheer-URL doen nie. Skakel asseblief om na \'n <a href="{$a}">globaal toeganklike URL</a>.';
$string['returntocoursepage'] = 'Keer terug na Kursusbladsy';
$string['returntoreports'] = 'Keer terug na Verslae';
$string['returntostudentlist'] = 'Keer terug na Studentlys';
$string['review'] = 'Hersien';
$string['reviewthisattempt'] = 'Hersien jou antwoorde op hierdie poging';
$string['rowsperpage'] = 'Rye per bladsy';
$string['run_readercron'] = 'Loop Reader-cron';
$string['run_readercron_desc'] = 'Loop die cron job vir die Reader-module.';
$string['safebrowsererror'] = 'Hierdie vasvra is opgestel sodat dit slegs met die Safe Exam Browser gepoog kan word. Jy kan dit nie vanaf hierdie webblaaier poog nie.';
$string['safebrowsernotice'] = 'Hierdie vasvra is gekonfigureer sodat studente dit slegs kan poog met die Safe Exam Browser.';
$string['scanningattempts'] = 'Pogings tot Reader-vasvrae word geskandeer';
$string['search'] = 'Soek';
$string['search_help'] = 'Om na \'n spesifieke boek te soek, voer teks in wat in die titel van die boek voorkom, en kliek die "Gaan"-knoppie';
$string['searchforabook'] = 'Soek na \'n boek';
$string['sectionname'] = 'Afdelingnaam';
$string['sectiontoseparate'] = 'voeg vasvrae by om afdelings vir uitgewer en vlak te skei, voeg vasvrae by bestaande afdelings waar beskikbaar';
$string['sectiontothebottom'] = 'voeg alle vasvrae by onderaan die versteekte kursus in \'n nuwe afdeling';
$string['sectiontothissection'] = 'voeg gekose vasvrae by hierdie afdeling';
$string['sectiontypedefault'] = 'Die verstek afdeling(s)';
$string['sectiontypehidden'] = '\'n Versteekte afdeling';
$string['sectiontypelast'] = 'Die laaste afdeling';
$string['sectiontypenew'] = '\'n Nuwe afdeling';
$string['sectiontypevisible'] = '\'n Sigbare afdeling';
$string['seedetailsbelow'] = 'sien besonderhede hieronder';
$string['select'] = 'Kies';
$string['select_course'] = 'Kies Kursus';
$string['select_help'] = 'Kliek op die tipe items wat jy in die lys hieronder wil laat kies';
$string['selectabook'] = 'Kies \'n boek';
$string['selectalreadyexist'] = 'Keuse bestaan reeds';
$string['selectedbookname'] = 'Gekose boeknaam';
$string['selectipmask'] = 'Kies IP-masker';
$string['selectlevel'] = 'Kies Vlak';
$string['selectpublisher'] = 'Kies Uitgewer';
$string['selectseries'] = 'Kies Reeks';
$string['selectsomeattempts'] = 'Kies een of meer pogings';
$string['selectsomebooks'] = 'Kies een of meer boeke';
$string['selectsomerows'] = 'Merk asseblief \'n paar van die bokse in die kies-kolom.';
$string['selectsomeusers'] = 'Kies een of meer gebruikers';
$string['selectthisquiz'] = 'Kies hierdie vasvra';
$string['sendemailtostudent'] = 'Stuur e-pos na student';
$string['sendemailtoteacher'] = 'Stuur e-pos na onderwyser';
$string['sendmessage'] = 'Stuur boodskap aan geaffekteerde studente';
$string['sentemailmoodle'] = '\'n E-pos is via Moodle na {$a->email} gestuur';
$string['sentemailphp'] = '\'n E-pos is via PHP-pos na {$a->email} gestuur';
$string['sentmessage'] = 'Die boodskap is suksesvol aan {$a} gebruiker(s) gestuur';
$string['separategroups'] = 'Aparte groepe';
$string['separatelevels'] = 'Aparte vlakke';
$string['servererror'] = 'Boodskap vanaf bediener: {$a}';
$string['serverpassword'] = 'Wagwoord vir Reader-vasvrae';
$string['serversettings'] = 'Laai Moodle Reader-vasvrae af';
$string['serverurl'] = 'URL vir Reader-vasvrae';
$string['serverusername'] = 'Gebruikersnaam vir Reader-vasvrae';
$string['setallowpromotion'] = 'Verander bevorderingsverstelling vir gekose studente';
$string['setbookinstances'] = 'Kies vasvrae om aan studente beskikbaar te maak';
$string['setcurrentlevel'] = 'Verander huidige vlak vir gekose studente';
$string['setdifficulty'] = 'Stel moeilikheidsgraad van boek';
$string['setgenre'] = 'Stel genre';
$string['setgoal'] = 'Stel doelwit';
$string['setgoals'] = 'Stel doelwitte';
$string['setgoals_description'] = 'Op hierdie bladsy kan jy die leesdoelwitte vir studente op spesifieke leesvlakke of in spesifieke groepe stel. Let daarop dat die verstellings vir inviduele studente op die verslagbladsye die verstellings op hierdie bladsy sal oorheenskryf.';
$string['setlevel'] = 'Stel vlak';
$string['setlevels'] = 'Stel vlakke';
$string['setlevels_description'] = 'Op hierdie bladsy kan jy die leesvlakke vir studentegroepe stel. Let daarop dat hierdie verstellings die verstelling vir individuele studente op die verslagbladsye sal oorheenskryf.';
$string['setmessage'] = 'Stel boodskap';
$string['setmessagetext'] = 'Boodskapteks';
$string['setmessagetime'] = 'Vertoon tot';
$string['setname'] = 'Stel boektitel';
$string['setpoints'] = 'Stel puntwaarde';
$string['setpromotiontime'] = 'Verander datum en tyd van bevordering';
$string['setpublisher'] = 'Stel uitgewer';
$string['setrates'] = 'Stel koerse';
$string['setrates_description'] = 'Op hierdie bladsy kan jy die leeskoerse vir studente op spesifieke leesvlakke of in spesifieke groepe stel.';
$string['setreadinggoal'] = 'Stel leesdoelwit';
$string['setreadinglevel'] = 'Stel leesvlak';
$string['setstartlevel'] = 'Verander beginvlak vir gekose studente';
$string['setstoplevel'] = 'Verander maksimum vlak vir gekose studente';
$string['settings'] = 'Verstellings';
$string['setuniformgoalinpoints'] = 'Stel eenvormige doelwit in punte';
$string['setuniformgoalinwords'] = 'Stel eenvormige doelwit in woorde';
$string['setwords'] = 'Stel woordtelling';
$string['show'] = 'Vertoon';
$string['show_help'] = 'Kliek op die tipe items wat jy in die lys hieronder wil laat vertoon';
$string['showall'] = 'Vertoon Alle';
$string['showattempts'] = 'Vertoon pogings wat met hierdie voorwaardes ooreenstem';
$string['showdeleted'] = 'Vertoon uitgewiste pogings';
$string['showhidden'] = 'Vertoon versteekte boeke';
$string['showhide'] = 'Vertoon/Versteek';
$string['showhidebook'] = 'Vertoon of versteek';
$string['showhidebooks'] = 'Werk die vertoon-/versteek-verstelling vir gekose boeke by';
$string['showlevel'] = 'Vertoon Vlak';
$string['showpercentgrades'] = 'Vertoon persentasiepunte';
$string['showpercentgrades_help'] = '**Ja**
: Vertoon die punt (as persentasie) vir elke poging tot \'n Reader-vasvra

**Nee**
: Moet NIE die punte vir individuele pogings tot Reader-vasvrae vertoon nie';
$string['showpoints'] = 'Vertoon slegs punte';
$string['showpointsandwordcount'] = 'Vertoon beide punte en woordtelling';
$string['showprogressbar'] = 'Vertoon vorderingsbalk';
$string['showprogressbar_help'] = '**Ja**
: Vertoon die woordtelling-vorderingsbalk op die hoofblad van hierdie Reader-aktiwiteit

**Nee**
: Moet NIE die woordtelling-vorderingsbalk op die hoofblad van hierdie Reader-aktiwiteit vertoon nie';
$string['showreviewlinks'] = 'Vertoon hersieningskakels';
$string['showreviewlinks_help'] = '**Ja**
: Voeg skakels by vanaf waardes op die Reader-verslagbladsye by vasvra-hersieningsbladsye wat toon presies hoeveel elke vraag in \'n poging op \'n Reader-vasvra beantwoord is.

**Nee**
: Moet NIE skakels vanaf die waardes op die Reader-verslagbladsye by vasvra-hersieningsbladsye voeg nie.

Hierdie verstelling affekteer slegs onderwysers. Dit affekteer studente nie omdat hulle nie toegang tot die Reader-verslagbladsye het nie.';
$string['showwordcount'] = 'Vertoon slegs woordtelling';
$string['skipline'] = 'Slaan lyn {$a} oor';
$string['skipped'] = 'Oorgeslaan';
$string['skipquizdownload'] = 'Vasvra "{$a->quizname}" bestaan reeds in afdeling {$a->sectionnum}, "{$a->sectionname}", van "{$a->coursename}", en is oorgeslaan';
$string['sofar'] = 'tot dusver';
$string['sort_strings'] = 'Sorteer stringe';
$string['sort_strings_desc'] = 'Sorteer die stringe wat deur die Reader-module gebruik word.';
$string['sortfields'] = 'Sorteer velde';
$string['startbookdetailed'] = 'Daar is tans geen data vir hierdie verslag beskikbaar nie.';
$string['startbooksummary'] = 'Daar is tans geen data vir hierdie verslag beskikbaar nie.';
$string['startdate'] = 'Aanvangsdatum';
$string['starteditcourse'] = '**Hoe om te begin**

Op hierdie bladsy kan jy Reader-boeke, wat in hierdie kursus beskikbaar is, wysig en verwyder. Jy kan ook nuwe boeke in hierdie kursus beskikbaar stel, mits dit reeds met die aflaaibladsye na hierdie Moodle-werf afgelaai is.';
$string['starteditsite'] = '**Hoe om te begin**

Op hierdie bladsy kan jy Reader-boeke op hierdie Moodle-werf wysig en verwyder. Gebruik asseblief die aflaaibladsye om nuwe Reader-boeke by hierdie werf te voeg.';
$string['startgroupsummary'] = 'Daar is tans geen data vir hierdie verslag beskikbaar nie.';
$string['startlevel'] = 'Begin vlak';
$string['startscan'] = 'Begin skandering';
$string['startuserdetailed'] = 'Daar is tans geen data vir hierdie verslag beskikbaar nie.';
$string['startusersummary'] = 'Daar is tans geen data vir hierdie verslag beskikbaar nie.';
$string['stoplevel'] = 'Maksimum vlak';
$string['stoplevel_help'] = 'Studente kan nie outomaties hoër as hierdie vlak bevorder word nie';
$string['stoplevelforce'] = 'Pas hierdie waarde op ALLE huidige gebruikers toe';
$string['strfattempttime'] = '%Y %b %d (%a) %H:%M';
$string['strfattempttimeshort'] = '%Y/%m/%d %H:%M';
$string['strfdateshort'] = '%Y %b %d (%a)';
$string['strfdatetimeshort'] = '%Y %b %d (%a) %H:%M';
$string['strftimeshort'] = '%H:%M';
$string['studentmanagement'] = 'Studentbestuur';
$string['studentslevels'] = 'Verander Studentvlakke, Bevorderingsbeleid en Doelwitte';
$string['studentuserid'] = 'Student Gebruiker-ID';
$string['studentusername'] = 'Student Gebruikersnaam';
$string['studentview'] = 'Student aansig';
$string['subnetlength'] = 'IP-masker';
$string['subnetwrong'] = 'Hierdie vasvra is net vanaf sekere plekke toeganklik, en hierdie rekenaar is nie op die toegelate lys nie.';
$string['summaryreportbybooktitle'] = 'Opsommingsverslag volgens Boektitel';
$string['summaryreportbyclassgroup'] = 'Opsommingsverslag volgens Klasgroep';
$string['takequizfor'] = 'Doen die vasvra vir "{$a}"';
$string['takethisquiz'] = 'Doen hierdie vasvra';
$string['targetcategory'] = 'Teikenkategorie';
$string['targetcategory_help'] = 'Die kursuskategorie wat die kursus bevat waarin jy die vasvrae vir die gekose boeke wil aflaai.';
$string['targetcourse'] = 'Teikenkursus';
$string['targetcourse_help'] = 'Kies die kursus waarin jy die vasvrae vir die gekose boeke wil aflaai. Gewoonlik behoort jy na \'n versteekte kursus af te laai, wat slegs gebruik word om vasvrae wat deur die Reader-module gebruik word, te berg.

Kies die tipe kursus uit een van die volgende opsies:

**Alle**
: Kies uit \'n lys van al die kursusse op hierdie Moodle-werf.

**Versteek**
: Kies uit \'n lys van kursusse wat aan jou sigbaar is, maar van studente versteek word. Jy behoort gewoonlik hierdie opsie te kies.

**Sigbaar**
: Kies uit \'n lys van kursusse wat aan jou en ingeskrewe studente sigbaar is.

**Huidig**
: Reader-vasvrae sal in die huidige kursus in afgelaai word.

**Nuut**
: Reader-vasvrae sal in \'n nuwe kursus in afgelaai word. Voer \'n naam vir die nuwe kursus in die teksboks in.';
$string['targetsection'] = 'Teikenafdeling';
$string['targetsection_help'] = 'Spesifiseer die kursusafdeling, d.w.s. die week of onderwerp, waarin jy die vasvrae wil aflaai. Die volgende tipes afdeling is beskikbaar:

**Die verstek afdeling(s)**
: Die vasvrae sal gegroepeer word en in afdelings geplaas word volgens die "Uitgewervlak" van hul onderskeie boeke.

**\'n Versteekte afdeling**
: Die vasvrae sal in die gekose versteekte afdeling van die kursus gesit word.

**\'n Sigbare afdeling**
: Die vasvrae sal in die gekose sigbare afdeling van die kursus gesit word.

**Die laaste afdeling**
: Die vasvrae sal by die laaste afdeling van die kursus gesit word.

**\'n Nuwe afdeling**
: Die vasvrae sal by \'n nuwe afdeling gevoeg word. Voer \'n naam vir die nuwe afdeling in die teksboks in.';
$string['termtype'] = 'Termyn';
$string['therehavebeennonewquizzesorupdates'] = 'Daar is geen nuwe vasvrae of bywerkings by die Moodle Reader-vasvrabank gevoeg sedert jy die vorige keer gekyk het nie.';
$string['thisattempt'] = 'hierdie poging';
$string['thisblockunavailable'] = 'Hierdie blok is tans nie aan hierdie student beskikbaar nie';
$string['thislevel'] = 'Vasvrae op huidige vlak';
$string['thislevel_help'] = 'Die aantal vasvrae op die huidige leesvlak wat \'n student moet slaag om na die volgende leesvlak bevorder te word. Let daarop dat slegs vasvrae wat sedert die mees onlangse bevordering geslaag is, vir die volgende bevordering tel.';
$string['thisterm'] = 'hierdie termyn';
$string['timefinish'] = 'Tyd klaargemaak';
$string['timeleft'] = 'Oorblywende Tyd';
$string['timestart'] = 'Tyd begin';
$string['to'] = 'na';
$string['tools'] = 'Hulpmiddels';
$string['totalpoints'] = 'Totale punte';
$string['totalpointsallterms'] = 'Totale punte (alle termyne)';
$string['totalpointsgoal'] = 'Woord-/puntdoelwit';
$string['totalpointsgoal_help'] = 'Die totale aantal woorde/punte wat van studente verwag word om in die huidige termyn te versamel.';
$string['totalpointsthisterm'] = 'Totale punte (hierdie termyn)';
$string['totalwords'] = 'Totale woorde';
$string['totalwordsallterms'] = 'Totale woorde (alle termyne)';
$string['totalwordsthisterm'] = 'Totale woorde (hierdie termyn)';
$string['transferfromcourse'] = 'Dra oor vanaf kursus';
$string['type'] = 'Tipe';
$string['type_help'] = 'Kies die tipe boeke wat jy vertoon wil hê van die lys hieronder:

**Boeke met vasvrae**
: Die bladsy sal \'n lys boeke met vasvrae, wat vir aflaai beskikbaar is, vertoon.

**Boeke sonder vasvrae**
: Die bladsy sal \'n lys boeke vertoon waarvoor data bestaan, soos moeilikheidsgraad en woordtellings, maar waarvoor daar nog geen vasvra geskep is nie.';
$string['uniqueip'] = 'Vereis unieke IP';
$string['update'] = 'Werk by';
$string['updatecheated'] = 'Werk die gekulde verstelling vir gekose pogings by';
$string['updatedon'] = 'Bygewerk op {$a}';
$string['updatepassed'] = 'Werk die slaag/druip-verstelling vir gekose pogings by';
$string['updatequizzes'] = 'Werk vasvrae by';
$string['updates'] = 'Bywerkings';
$string['updatesavailable'] = '{$a} bywerking(s) beskikbaar';
$string['updatinggrades'] = 'Reader-punte word bygewerk';
$string['upgradeoldquizzesinfo'] = 'Die bywerking is tydelik gestaak, sodat jy kan besluit of jy die ou weergawes van die Reader-modulevasvrae op hierdie Moodle-werf wil behou.

As jy "Ja" kies, sal al die ou Reader-vasvrae behou word. Kies hierdie opsie as jy alle statistieke oor antwoorde op individuele vrae van ou Reader-vasvrae wil behou.

As jy "Nee" kies, sal ou, duplikaat weergawes van Reader-vasvrae uitgewis word, en slegs die mees onlangse sigbare weergawe van elke vasvra behou word. Kies hierdie opsie as jy nie bekommerd is oor statistieke van antwoorde op individuele vrae in ou Reader-vasvra nie en jy die Reader-vasvraekursusblad wil opruim.

Let daarop dat, selfs al kies jy "Nee", sal die woordtellings in Reader-aktiwiteite nie deur hierdie operasie geaffekteer word nie.

Wil jy ou weergawes van Reader-modulevasvrae behou?';
$string['upgradestalefiles'] = 'Gemengde Reader-moduleweergawes is opgespoor, bywerking kan nie voortgaan nie';
$string['upgradestalefilesinfo'] = 'Die Moodle-bywerkingsproses is tydelik gestaak, omdat dokumente uit vorige weergawes van die Reader-module in die "mod/reader"-gids gevind is.

Dit kan later probleme skep, dus, om te kan voortgaan, moet jy verseker dat die "mod/reader"-gids slegs dokumente vir \'n enkele weergawe van die Reader-module bevat.

Die aanbevole manier om jou "mod/reader"-gids skoon te maak, is soos volg:

* verwyder die huidige "mod/reader", of skuif dit minstens uit die "mod"-gids
* skep \'n nuwe "mod/reader"-gids wat slegs dokumente bevat uit óf \'n standaard Reader-module zip-aflaai, óf uit die GIT-bewaararea

Alternatiewelik kan jy rekursiewe skryftoegang aan die volgende "mod/reader"-lêer gee; die dokumente kan outomaties uitgewis word terwyl jy voortgaan met die bywerking:

* {$a->dirpath}

Die "mod/reader"-dokumente wat tans die bywerking blokkeer is die volgende:
{$a->filelist}

As jy dit sou verkies, kan jy ook die bogemelde dokument(e) self uitwis.

Kliek die knoppie hieronder om voort te gaan met die Moodle-bywerkingsproses.';
$string['uploaddatanoquizzes'] = 'Laai data af vir boeke wat geen vasvrae het nie.';
$string['uploadquiztoreader'] = 'Laai vasvrae vanaf die Reader-Vasvradatabasis af';
$string['use_this_course'] = 'Gebruik hierdie kursus';
$string['usecourse'] = 'Reader-vasvraekursus';
$string['usecourse_help'] = '\'n Kursus op hierdie Moodle-werf wat die Reader-vasvrae vir hierdie Reader-aktiwiteit bevat. Hierdie kursus behoort van die studente versteek te wees. Dit bevat gewoonlik vasvrae wat deur die Reader-module vanaf \'n eksterne Reader-vasvrabewaararea, bv. moodlereader.net, afgelaai is.';
$string['usedefaultquizid'] = 'Gebruik altyd verstek vasvra';
$string['userexport'] = 'Voer gebruikerdata uit';
$string['userimport'] = 'Voer gebruikerdata in';
$string['userlevel'] = 'Gebruikervlak';
$string['usernamenotfound'] = 'Gebruikernaam is nie gevind nie: {$a}';
$string['users'] = 'Gebruikers';
$string['usersallwith'] = 'alle gebruikers wat minstens een vasvra probeer doen het';
$string['usersenrolledall'] = 'alle ingeskrewe gebruikers';
$string['usersenrolledwith'] = 'ingeskrewe gebruikers wat minstens een vasvra probeer doen het';
$string['usersenrolledwithout'] = 'ingeskrewe gebruikers wat geen vasvrae probeer doen het nie';
$string['usersetgoals'] = 'Stel gebruikerdoelwitte';
$string['usersetlevels'] = 'Stel gebruikervlakke';
$string['usersetmessage'] = 'Stel boodskap aan gebruikers';
$string['usersexport'] = 'Voer data uit';
$string['usersimport'] = 'Voer data in';
$string['userssetgoals'] = 'Stel doelwitte';
$string['userssetlevels'] = 'Stel vlakke';
$string['userssetmessage'] = 'Stel boodskap';
$string['usertype'] = 'Gebruikers om in te sluit';
$string['valueoutofrange'] = 'Hierdie waarde sou tussen {$a->min} en {$a->max} wees';
$string['viewattempts'] = 'Besigtig en Wis Pogings uit';
$string['viewlogsuspiciousactivity'] = 'Besigtig log van verdagte aktiwiteit';
$string['windowclosing'] = 'Hierdie venster gaan binnekort toemaak.';
$string['withoutdayfilter'] = 'Sonder dagfiltreerder';
$string['words'] = 'Woorde';
$string['wordscount'] = 'Woordtelling';
$string['wordsorpoints'] = 'Vertoon woorde of punte';
$string['wordsorpoints_help'] = '**Vertoon slegs woordtelling**
: Op verslagbladsye, vertoon slegs die woordtelling vir pogings.

**Vertoon slegs punte**
: Op verslagbladsye, vertoon slegs die punte wat vir pogings verwerf is.

**Vertoon beide woorde en punte**
: Op verslagbladsye, vertoon beide die woordtelling en die punte wat vir pogings verwerf is.';
$string['youcannottake'] = 'Jy kan NIE meer enige vasvrae op leesvlak {$a} doen nie';
$string['youcannotwait'] = 'Hierdie vasvra sluit voordat jy toegelaat sal word om met nog \'n poging te begin.';
$string['youcantakeaquizafter'] = 'Jy kan jou volgende vasvra ná {$a} doen';
$string['youcantakeaquiznow'] = 'Jy kan \'n vasvra nou doen.';
$string['youcantakeasmanyquizzesasyouwant'] = 'Jy kan soveel vasvrae op Vlak {$a} doen as wat jy wil.';
$string['youcantakeplural'] = 'Jy kan nog {$a->count} vasvrae op leesvlak {$a->level} doen. Hierdie boeke sal vir jou leestotaal tel, maar nie vir jou bevordering nie.';
$string['youcantakesingle'] = 'Jy kan nog EEN vasvra op leesvlak {$a->level} doen. Hierdie boek sal vir jou leestotaal tel, maar nie vir jou bevordering nie.';
$string['youcantakeunlimited'] = 'Jy kan soveel vasvrae op leesvlak {$a} doen as wat jy wil';
$string['youhavebeenpromoted'] = 'Veels geluk! Jy is na Vlak {$a} bevorder.';
$string['youmustpassplural'] = 'Om bevorder te word, moet jy nog {$a->count} vasvrae op leesvlak {$a->level} slaag.';
$string['youmustpasssingle'] = 'Om bevorder te word, moet jy nog EEN vasvra op leesvlak {$a->level} slaag.';
$string['youmustwait'] = 'Jy moet wag voordat jy hierdie vasvra mag probeer oordoen. Jy sal nog \'n poging ná {$a} kan begin.';
$string['yourcurrentlevel'] = 'Jou leesvlak is tans op vlak {$a} gestel.';
$string['youwerepromoted'] = 'Jy is op {$a->date} en {$a->time} bevorder na leesvlak {$a->level}.';
