<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'qtype_stack', language 'af', version '4.3'.
 *
 * @package     qtype_stack
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['ATAlgEquiv_SA_not_equation'] = 'Jou antwoord behoort \'n vergelyking te wees, maar is nie.';
$string['ATAlgEquiv_SA_not_expression'] = 'Jou antwoord behoort \'n uitdrukking te wees, nie \'n vergelyking, ongelykheid, lys, stel of matriks nie.';
$string['ATAlgEquiv_SA_not_function'] = 'Jou antwoord behoort \'n funksie te wees, gedefinieer deur die operateur <tt>:=</tt> te gebruik, maar is nie.';
$string['ATAlgEquiv_SA_not_inequality'] = 'Jou antwoord behoort \'n ongelykheid te wees, maar is nie.';
$string['ATAlgEquiv_SA_not_list'] = 'Jou antwoord behoort \'n lys te wees, maar is nie. Let daarop dat die sintaksis om \'n lys in te voer, is om die komma-geskeide waardes met blokhakies te omvou.';
$string['ATAlgEquiv_SA_not_logic'] = 'Jou antwoord behoort \'n vergelyking, ongelykheid, of \'n logiese kombinasie van etlike daarvan te wees, maar is nie.';
$string['ATAlgEquiv_SA_not_matrix'] = 'Jou antwoord behoort \'n matriks te wees, maar is nie.';
$string['ATAlgEquiv_SA_not_realset'] = 'Jou antwoord behoort \'n onderstel van die ware getalle te wees. Dit kan \'n stel getalle of \'n versameling intervalle wees.';
$string['ATAlgEquiv_SA_not_set'] = 'Jou antwoord behoort \'n stel te wees, maar is nie. Let daarop dat die sintaksis om \'n stel in te voer, is om die komma-geskeide waardes met krulhakies te omvou.';
$string['ATAlgEquiv_SA_not_string'] = 'Jou antwoord behoort \'n string te wees, maar is nie.';
$string['ATAlgEquiv_TA_not_equation'] = 'Jy het \'n vergelyking ingevoer, maar \'n vergelyking word nie hier verwag nie. Jy het moontlik iets soos "y=2*x+1" getik, terwyl jy slegs "2*x+1" hoef te tik.';
$string['ATCompSquare_SA_not_depend_var'] = 'Jou antwoord behoort af te hang van die veranderlike {$a->m0}, maar dit hang nie daarvan af nie!';
$string['ATCompSquare_false'] = '';
$string['ATCompSquare_false_no_summands'] = 'Die voltooide vierkant is van die vorm \\( a(\\cdots\\cdots)^2 + b\\) waar \\(a\\) en \\(b\\) nie van jou veranderlike afhanklik is nie. Meer as een van jou summands blyk van die veranderlike in jou antwoord afhanklik te wees.';
$string['ATCompSquare_not_AlgEquiv'] = 'Jou antwoord blyk om in die korrekte vorm te wees, maar is nie gelyk aan die korrekte antwoord nie.';
$string['ATCompSquare_true'] = '';
$string['ATDiff_error_list'] = 'Die antwoordtoets het misluk. Kontak asseblief jou stelseladministrateur.';
$string['ATDiff_int'] = 'Dit kom voor asof jy eerder geïntegreer het!';
$string['ATEquivFirst_SA_not_list'] = 'Die eerste argument op die Equiv-antwoordtoets behoort \'n lys te wees, maar die toets het misluk. Kontak asseblief jou onderwyser.';
$string['ATEquivFirst_SA_wrong_end'] = 'Jou finale antwoord is nie in die korrekte vorm nie.';
$string['ATEquivFirst_SA_wrong_start'] = 'Die eerste lyn van jou argument moet "{$a->m0}" wees.';
$string['ATEquivFirst_SB_not_list'] = 'Die tweede argument op die Equiv-antwoordtoets behoort \'n lys te wees, maar die toets het misluk. Kontak asseblief jou onderwyser.';
$string['ATEquiv_SA_not_list'] = 'Die eerste argument op die Equiv-antwoordtoets behoort \'n lys te wees, maar die toets het misluk. Kontak asseblief jou onderwyser.';
$string['ATEquiv_SB_not_list'] = 'Die tweede argument op die Equiv-antwoordtoets behoort \'n lys te wees, maar die toets het misluk. Kontak asseblief jou onderwyser.';
$string['ATFacForm_error_list'] = 'Die antwoordtoets het misluk. Kontak asseblief jou stelseladministrateur.';
$string['ATFacForm_isfactored'] = 'Jou antwoord is gefaktoriseer, welgedaan.';
$string['ATFacForm_notalgequiv'] = 'Let daarop dat jou antwoord nie algebraïes ekwivalent aan die korrekte antwoord is nie. Jy het moontlik iets verkeerd gedoen.';
$string['ATFacForm_notfactored'] = 'Jou antwoord is nie gefaktoriseer nie.';
$string['ATFacForm_notpoly'] = 'Daar word verwag dat hierdie term \'n veelterm is, maar dit is nie.';
$string['ATInequality_backwards'] = 'Jou ongelykheid blyk agterstevoor te wees.';
$string['ATInequality_nonstrict'] = 'Jou ongelykheid behoort streng te wees, maar is nie!';
$string['ATInequality_strict'] = 'Jy ongelykheid behoort nie streng te wees nie!';
$string['ATInt_EqFormalDiff'] = 'Die formele afleiding van jou antwoord is gelyk aan die uitdrukking wat jy gevra is om te integreer. Jou antwoord verskil egter op \'n beduidende manier van die korrekte antwoord, dit wil sê nie net, byvoorbeeld, \'n konstante van integrasie nie. Vra asseblief jou onderwyser hieroor.';
$string['ATInt_STACKERROR_OptList'] = 'Die antwoordtoets kon nie korrek uitvoer nie: stel asseblief jou onderwyser in kennis. Wanneer die opsie vir ATInt \'n lys is, moet dit presies twee elemente hê, maar hierdie het nie.';
$string['ATInt_const'] = 'Jy moet \'n konstante van integrasie byvoeg, andersins blyk dit korrek te wees. Welgedaan.';
$string['ATInt_const_int'] = 'Jy moet \'n konstanste van integrasie byvoeg. Dit behoort \'n arbitrêre konstante te wees, nie \'n getal nie.';
$string['ATInt_diff'] = 'Dit lyk of jy eerder gedifferensieer het!';
$string['ATInt_error_list'] = 'Die antwoordtoets het misluk. Kontak asseblief jou stelseladministrateur';
$string['ATInt_generic'] = 'Die afleiding van jou antwoord behoort gelyk aan die uitdrukking te wees wat jy moes integreer, wat was: {$a->m0} In werklikheid die afleiding van jou antwoord, met betrekking tot {$a->m1} is: {$a->m2} dus het jy waarskynlik iets verkeerd gedoen!';
$string['ATInt_logabs'] = 'Die formele afleiding van jou antwoord is wel gelyk aan die uitdrukking wat jy versoek is om te integreer. Jou antwoord verskil egter beduidend van die korrekte antwoord, dit wil sê nie net, byvoorbeeld, \'n konstante van integrasie nie. Jou onderwyser kan van jou verwag om die resultaat \\(\\int\\frac{1}{x} dx = \\log(|x|)+c\\) eerder as (\\int\\frac{1}{x} dx = \\log(x)+c\\) te gebruik. Vra asseblief jou onderwyser hieroor.';
$string['ATInt_logabs_inconsistent'] = 'Daar blyk vreemde inkonsekwensies tussen jou gebruik van \\(\\log(...)\\) en \\(\\log(|...|)\\) te wees. Vra asseblief jou onderwyser hieroor.';
$string['ATInt_weirdconst'] = 'Die formele afleiding van jou antwoord is wel gelyk aan die uitdrukking wat jy versoek is om te integreer. Jy het egter \'n vreemde konstante van integrasie. Vra asseblief jou onderwyser hieroor.';
$string['ATList_wrongentries'] = 'Die invoere wat hieronder met rooi onderstreep is, is dié wat verkeerd is. {$a->m0}';
$string['ATList_wronglen'] = 'Jou lys behoort {$a->m0} elemente te hê, maar het {$a->m1}.';
$string['ATLowestTerms_entries'] = 'Die volgende terme in jou antwoord is nie in laagste terme nie. {$a->m0} Probeer asseblief weer.';
$string['ATLowestTerms_not_rat'] = 'Jy moet die volgende noemer van jou breuk verwyder: {$a->m0}';
$string['ATLowestTerms_wrong'] = 'Jy moet breuke binne jou antwoord kanselleer.';
$string['ATMatrix_wrongentries'] = 'Die invoere wat hieronder met rooi onderstreep is, is dié wat verkeerd is. {$a->m0}';
$string['ATMatrix_wrongsz'] = 'Jou matriks behoort {$a->m0} by {$a->m1} te wees, maar dit is {$a->m2} by {$a->m3}.';
$string['ATNumDecPlacesWrong_OptNotInt'] = 'Vir ATNumDecPlacesWrong moet die toetsopsie \'n positiewe heelgetal wees, in werklikheid is "{$a->m0}" ontvang.';
$string['ATNumDecPlaces_Float'] = 'Jou antwoord moet \'n dryfpunt wees, maar is nie.';
$string['ATNumDecPlaces_NoDP'] = 'Jou antwoord moet \'n desimale getal wees, met \'n desimale punt.';
$string['ATNumDecPlaces_OptNotInt'] = 'Vir ATNumDecPlaces moet die toetsopsie \'n positiewe heelgetal wees, in werklikheid is "{$a->m0}" ontvang.';
$string['ATNumDecPlaces_Wrong_DPs'] = 'Jou antwoord is op die verkeerde aantal desimale plekke gegee.';
$string['ATNumSigFigs_Inaccurate'] = 'Die akkuraatheid van jou antwoord is nie korrek nie. Jy het óf nie reg afgerond nie, óf jy het \'n tussentydse antwoord afgerond, wat \'n fout versprei.';
$string['ATNumSigFigs_NotDecimal'] = 'Jou antwoord behoort \'n desimale getal te wees, maar is nie!';
$string['ATNumSigFigs_WrongDigits'] = 'Jou antwoord bevat die verkeerde aantal belangrike syfers.';
$string['ATNumSigFigs_WrongSign'] = 'Jou antwoord bevat die verkeerde algebraïese teken.';
$string['ATNumSigFigs_error_list'] = 'Die antwoordtoets het misluk. Kontak asseblief jou stelseladministrateur.';
$string['ATNum_OutofRange'] = '\'n Numeriese uitdrukking is buite die ondersteunde omvang. Kontak asseblief jou onderwyser.';
$string['ATNumerical_FAILED'] = 'Jou antwoord behoort \'n dryfpuntgetal te wees, of \'n lys of stel getalle. Dit is nie.';
$string['ATNumerical_SA_not_list'] = 'Jou antwoord behoort \'n lys te wees, maar is nie. Let daarop dat die sintaksis om \'n lys in te voer, is om die komma-geskeide waardes met blokhakies te omvou.';
$string['ATNumerical_SA_not_number'] = 'Jou antwoord behoort \'n dryfpuntgetal te wees, maar is nie.';
$string['ATNumerical_SA_not_set'] = 'Jou antwoord behoort \'n stel te wees, maar is nie. Let daarop dat die sintaksis om \'n stel in te voer, is om die komma-geskeide waardes met krulhakies te omvou.';
$string['ATNumerical_STACKERROR_tol'] = 'Die numeriese toleransie vir ATNumerical behoort \'n dryfpuntgetal te wees, maar is nie. Dit is \'n interne fout met die toets. Vra asseblief jou onderwyser hieroor.';
$string['ATPartFrac_denom_ret'] = 'Vir jou antwoord om as \'n enkele breuk geskryf te word, sou die noemer {$a->m0} wees. Dit behoort, in werklikheid {$a->m1} te wees.';
$string['ATPartFrac_diff_variables'] = 'Die veranderlikes in jou antwoord is anders as dié van die vraag, kontroleer dit asseblief.';
$string['ATPartFrac_error_list'] = 'Die antwoordtoets het misluk. Kontak asseblief jou stelseladministrateur.';
$string['ATPartFrac_ret_expression'] = 'Jou antwoord as \'n enkele breuk is {$a->m0}';
$string['ATPartFrac_single_fraction'] = 'Jou antwoord blyk \'n enkele breuk te wees, dit moet in \'n gedeeltelike breukvorm wees.';
$string['ATPartFrac_true'] = '';
$string['ATSRegExp_SA_not_string'] = 'Die eerste argument tot die SRegExp-antwoordtoets moet \'n string wees. Die toets het misluk. Kontak asseblief jou onderwyser.';
$string['ATSRegExp_SB_not_string'] = 'Die tweede argument tot die SRegExp-antwoordtoets moet \'n string wees. Die toets het misluk. Kontak asseblief jou onderwyser.';
$string['ATSet_wrongentries'] = 'Die volgende invoere is verkeerd, alhoewel dit in \'n vereenvoudigde vorm van dit wat jy ingevoer het, kan verskyn. {$a->m0}';
$string['ATSet_wrongsz'] = 'Jou stel behoort {$a->m0} verskillende elemente te hê, maar het {$a->m1}.';
$string['ATSets_SA_not_set'] = 'Jou antwoord behoort \'n stel te wees, maar is nie. Let daarop dat die sintaksis om \'n stel in te voer, is om die komma-geskeide waardes met krulhakies te omvou.';
$string['ATSets_SB_not_set'] = 'Die "Stelle" antwoordtoets verwag dat die tweede argument \'n stel is. Dit is \'n fout. Kontak asseblief jou onderwyser.';
$string['ATSets_duplicates'] = 'Jou stel blyk duplikaat invoere te bevat!';
$string['ATSets_missingentries'] = 'Die volgende ontbreek uit jou stel: {$a->m0}';
$string['ATSets_wrongentries'] = 'Hierdie invoere behoort nie elemente van jou stel te wees nie. {$a->m0}';
$string['ATSingleFrac_div'] = 'Jou antwoord bevat breuke binne breuke. Jy moet dit uithaal en jou antwoord as \'n enkele breuk skryf.';
$string['ATSingleFrac_error_list'] = 'Die antwoordtoets het misluk. Kontak asseblief jou stelseladministrateur.';
$string['ATSingleFrac_part'] = 'Jou antwoord moet \'n enkele breuk van die vorm \\( {a}\\over{b} \\ wees.';
$string['ATSingleFrac_ret_exp'] = 'Jou antwoord is nie algebraïes ekwivalent aan die korrekte antwoord nie. Jy moes iets verkeerd gedoen het.';
$string['ATSingleFrac_true'] = '';
$string['ATSingleFrac_var'] = 'Die veranderlikes in jou antwoord is anders as dié in die vraag, kontroleer dit asseblief.';
$string['ATSubstEquiv_Opt_List'] = 'Die opsie tot hierdie antwoordtoets moet \'n lys wees. Dit is \'n fout. Kontak asseblief jou onderwyser.';
$string['ATSysEquiv_SA_extra_variables'] = 'Jou antwoord bevat te veel veranderlikes!';
$string['ATSysEquiv_SA_missing_variables'] = 'Jou antwoord kort een of meer veranderlikes!';
$string['ATSysEquiv_SA_not_eq_list'] = 'Jou antwoord behoort \'n lys vergelykings te wees, maar is nie!';
$string['ATSysEquiv_SA_not_list'] = 'Jou antwoord behoort \'n lys te wees, maar is nie!';
$string['ATSysEquiv_SA_not_poly_eq_list'] = 'Een of meer van jou vergelykings is nie \'n veelterm nie!';
$string['ATSysEquiv_SA_system_overdetermined'] = 'Die invoere wat onder met rooi onderstreep is, is dié wat verkeerd is. {$a->m0}';
$string['ATSysEquiv_SA_system_underdetermined'] = 'Die vergelykings in jou stelsel blyk korrek te wees, maar jy benodig steeds ander ook.';
$string['ATSysEquiv_SA_wrong_variables'] = 'Jou antwoord gebruik die verkeerde veranderlikes!';
$string['ATSysEquiv_SB_not_eq_list'] = 'Die onderwyser se antwoord is nie \'n lys vergelykings nie, maar behoort te wees.';
$string['ATSysEquiv_SB_not_list'] = 'Die onderwyser se antwoord is nie \'n lys nie. Kontak asseblief jou onderwyser.';
$string['ATSysEquiv_SB_not_poly_eq_list'] = 'Die Onderwyser se antwoord behoort \'n lys van veeltermvergelykings te wees, maar is nie. Kontak asseblief jou onderwyser.';
$string['ATUnits_SA_bad_units'] = 'Jou antwoord moet eenhede hê, en jy moet vermenigvuldiging gebruik om die eenhede aan \'n waarde te koppel, bv. <code>3.2*m/s</code>.';
$string['ATUnits_SA_errorbounds_invalid'] = 'Jou antwoorde het foutgrense. In hierdie geval moet jy nie foutgrense aandui nie, maar eerder net die hoeveelheid en eenhede gebruik.';
$string['ATUnits_SA_excess_units'] = 'Jou antwoord het eenhede (of veranderlikes) gebruik, maar behoort dit nie te gebruik nie.';
$string['ATUnits_SA_no_units'] = 'Jou antwoord moet eenhede hê.';
$string['ATUnits_SA_not_expression'] = 'Jou antwoord moet \'n getal saam met eenhede wees. Moet nie stelle, lyste, vergelykings of matrikse gebruik nie.';
$string['ATUnits_SA_only_units'] = 'Jou antwoord moet \'n getal saam met eenhede wees. Jou antwoord bevat slegs eenhede.';
$string['ATUnits_SO_wrong_units'] = 'Die eenhede wat vir die numeriese toleransie gespesifiseer is, moet ooreenstem met die eenhede wat vir die onderwyser se antwoord gebruik is. Dit is \'n interne fout met die toets. Vra asseblief jou onderwyser hieroor.';
$string['ATUnits_compatible_units'] = 'Jou eenhede is anders as dié wat deur die onderwyser gebruik is, maar is daarmee versoenbaar. Numeriese waardes word vir vergelyking na SI-basiseenhede omgesit.';
$string['ATUnits_correct_numerical'] = 'Kontroleer asseblief jou eenhede noukeurig.';
$string['ATUnits_incompatible_units'] = 'Jou eenhede is nie versoenbaar met dié wat deur die onderwyser gebruik is nie.';
$string['AT_EmptySA'] = 'Gepoog om \'n antwoordtoets met \'n leë studentantwoord uit te voer, waarskynlik \'n CAS-validasieprobleem toe die vraag geskryf is.';
$string['AT_EmptyTA'] = 'Gepoog om \'n antwoordtoets met \'n leë onderwyserantwoord uit te voer, waarskynlik \'n CAS-validasieprobleem toe die vraag geskryf is.';
$string['AT_InvalidOptions'] = 'Opsieveld is ongeldig. {$a->errors}';
$string['AT_MissingOptions'] = 'Ontbrekende opsie wanneer die toets uitgevoer word.';
$string['AT_NOTIMPLEMENTED'] = 'Hierdie antwoord is nie geïmplementeer nie.';
$string['Bad_assignment'] = 'Wanneer die waardes van \'n veranderlike gelys word, behoort jy dit soos volg te doen: {$a->m0}. Wysig asseblief jou toevoer.';
$string['CommaError'] = 'Jou antwoord bevat kommas wat nie deel van \'n lys, stel of matriks is nie. <ul><li>As jy bedoel het om \'n lys in te tik, gebruik asseblief <tt>{...}</tt>,</li><li>As jy bedoel het om \'n stel in te tik, gebruik asseblief <tt>{...}</tt>.</li></ul>';
$string['Equiv_Illegal_list'] = 'Lyste word nie toegelaat wanneer daar teen ekwivalensie redeneer word nie.';
$string['Equiv_Illegal_matrix'] = 'Matrikse word nie toegelaat wanneer daar teen ekwivalensie redeneer word nie.';
$string['Equiv_Illegal_set'] = 'Stelle word nie toegelaat wanneer daar teen ekwivalensie redeneer word nie.';
$string['FacForm_UnPick_intfac'] = 'Jy moet \'n gemeenskaplike faktor uithaal.';
$string['FacForm_UnPick_morework'] = 'Jy kan nog \'n bietjie werk aan die term {$a->m0} verrig.';
$string['Illegal_control_flow'] = 'Jou antwoord bevat beheervloeibewerings soos die <code>as</code>-voorwaardelike of die <code>do</code>-loop - dit is verbode hier, jy behoort waarskynlik die resultaat van hierdie stellings as die antwoord te verskaf.';
$string['Illegal_floats'] = 'Jou antwoord bevat wisselpuntgetalle, wat nie hier toegelaat word nie. Jy moet getalle as breuke intik. Byvoorbeeld, jy behoort 1/3 in te tik en nie 0.3333 nie, wat per slot van rekening slegs \'n benadering van een derde is.';
$string['Illegal_groupping'] = 'Jou antwoord bevat hakies om bewerkings te groepeer, wat nie hier toegelaat word nie. Jy behoort waarskynlik die uitdrukking te manipuleer om dit te elimineer.';
$string['Illegal_groups'] = 'Jou antwoord bevat evaluasiegroeperings "(a,b,c)" wat nie hier toegelaat word nie.';
$string['Illegal_identifiers_in_units'] = 'Die toevoer bevat \'n veranderlikenaam waar slegs eenhede verwag is.';
$string['Illegal_illegal_operation_in_units'] = 'Die operateur <code>{$a}</code> word nie in hierdie toevoer toegelaat nie.';
$string['Illegal_illegal_power_of_ten_in_units'] = 'Die waarde mag nie nieheelgetal magte van tien bevat nie.';
$string['Illegal_input_form_units'] = 'Hierdie toevoer verwag \'n numeriese waarde, gevolg deur of vermenigvuldig met \'n uitdrukking wat \'n eenheid definieer, bv. e.g. <code>1.23*W/m^2</code>. Let daarop dat die eenheid wat hier vereis word, iets anders kan wees.';
$string['Illegal_lists'] = 'Jou antwoord bevat lyste "[a,b,c]", wat nie hier toegelaat word nie.';
$string['Illegal_sets'] = 'Jou antwoord bevat stelle "{a,b,c}", wat nie hier toegelaat word nie.';
$string['Illegal_singleton_floats'] = 'Hierdie toevoer aanvaar nie desimale getalle in die gegewe vorm nie. Hierdie toevoer vereis \'n numeriese waarde wat in een van die volgende vorms gepresenteer is: <code>{$a->forms}</code>';
$string['Illegal_singleton_integer'] = 'Hierdie toevoer aanvaar nie heelgetalwaardes nie. Hierdie toevoer vereis \'n numeriese waarde wat in een van die volgende vorms gepresenteer word: <code>{$a->forms}</code>';
$string['Illegal_singleton_power'] = 'Hierdie toevoer vereis \'n numeriese waarde wat in een van die volgende vorms gepresenteer word: <code>{$a->forms}</code>';
$string['Illegal_strings'] = 'Jou antwoord bevat "stringe", wat nie hier toegelaat word nie.';
$string['Illegal_x10'] = 'Jou antwoord blyk om die karakter "x" as maalteken te gebruik. Gebruik asseblief <code>*</code> as maalteken.';
$string['Interval_backwards'] = 'Wanneer \'n reële interval gemaak word, moet die eindpunte in volgorde wees.  {$a->m0} behoort  {$a->m1} te wees.';
$string['Interval_illegal_entries'] = 'Die volgende behoort nie met die konstruksie van reële stelle te verskyn nie:  {$a->m0}';
$string['Interval_notinterval'] = '\'n Interval is verwag, maar in plaas daarvan het ons  {$a->m0}.';
$string['Interval_wrongnumargs'] = 'Intervalkonstruksie moet oor presies twee argumente beskik, dus is hierdie waarskynlik \'n fout:  {$a->m0}.';
$string['Lowest_Terms'] = 'Jou antwoord bevat breuke wat nie in die kleinste vorm geskryf is nie. Kanselleer asseblief faktore en probeer weer.';
$string['Maxima_Args'] = 'args: argument moet \'n nieatomiese uitdrukking wees.';
$string['Maxima_DivisionZero'] = 'Deling deur nul.';
$string['Subst'] = 'Jou antwoord sou korrek wees as jy die volgende vervanging van veranderlikes gebruik het:  {$a->m0}';
$string['TEST_FAILED'] = 'Die antwoordtoets is nie korrek uitgevoer nie: stel asseblief jou onderwyser in kennis. {$a->errors}';
$string['TEST_FAILED_Q'] = 'Die antwoordtoets is nie korrek uitgevoer nie: stel asseblief jou onderwyser in kennis.';
$string['Variable_function'] = 'Die volgende verskyn in jou uitdrukking as beide \'n veranderlike en \'n funksie: {$a->m0}. Verklaar asseblief jou toevoer. Voeg óf <code>*</code> in om funksies te verwyder, óf maak alle gebeurtenisse funksies.';
$string['addanothernode'] = 'Voeg nog \'n nodus by';
$string['addanothertestcase'] = 'Voeg nog \'n toetsgeval by ...';
$string['addatestcase'] = 'Voeg \'n toetsgeval by ...';
$string['addingatestcase'] = '\'n toetsgeval word by vraag {$a} gevoeg';
$string['alg_indices_fact'] = 'Die volgende wette reguleer indeksmanipulasie:
\\[a^ma^n = a^{m+n}\\]
\\[\\frac{a^m}{a^n} = a^{m-n}\\]
\\[(a^m)^n = a^{mn}\\]
\\[a^0 = 1\\]
\\[a^{-m} = \\frac{1}{a^m}\\]
\\[a^{\\frac{1}{n}} = \\sqrt[n]{a}\\]
\\[a^{\\frac{m}{n}} = \\left(\\sqrt[n]{a}\\right)^m\\]';
$string['alg_indices_name'] = 'Die Eksponentwet';
$string['alg_inequalities_fact'] = '\\[a>b \\hbox{ means } a \\hbox{ is greater than } b.\\]
\\[ a < b \\hbox{ means } a \\hbox{ is less than } b.\\]
\\[a\\geq b \\hbox{ means } a \\hbox{ is greater than or equal to } b.\\]
\\[a\\leq b \\hbox{ means } a \\hbox{ is less than or equal to } b.\\]';
$string['alg_inequalities_name'] = 'Ongelykhede';
$string['alg_logarithms_fact'] = 'Vir enige basis \\(c>0\\) met \\(c \\neq 1\\):
\\[\\log_c(a) = b \\mbox{, means } a = c^b\\]
\\[\\log_c(a) + \\log_c(b) = \\log_c(ab)\\]
\\[\\log_c(a) - \\log_c(b) = \\log_c\\left(\\frac{a}{c}\\right)\\]
\\[n\\log_c(a) = \\log_c\\left(a^n\\right)\\]
\\[\\log_c(1) = 0\\]
\\[\\log_c(b) = 1\\]
Die formule vir \'n verandering in basis is:
\\[\\log_a(x) = \\frac{\\log_b(x)}{\\log_b(a)}\\]
Logaritmes na basis \\(e\\), aangedui \\(\\log_e\\) of andersins \\(\\ln\\) word natuurlike logaritmes genoem. Die letter \\(e\\) verteenwoordig die eksponensiële konstante wat ongeveer \\(2.718\\) is.';
$string['alg_logarithms_name'] = 'Die Logaritmewette';
$string['alg_partial_fractions_fact'] = 'Egte breuke kom voor met \\[{\\frac{P(x)}{Q(x)}}\\]
wanneer \\(P\\) en \\(Q\\) veelterme is met die graad van \\(P\\) minder as die graad van \\(Q\\). In hierdie geval gaan ons
soos volg voort: skryf \\(Q(x)\\) in gefaktoreerde vorm,
<ul>
<li>
\'n <em>lineêre faktor</em> \\(ax+b\\) in die noemer produseer \'n parsieelbreuk van die vorm \\[{\\frac{A}{ax+b}}.\\]
</li>
<li>
\'n <em>herhaalde lineêre faktore</em> \\((ax+b)^2\\) in die noemer
produseer parsieelbreuke van die vorm \\[{A\\over ax+b}+{B\\over (ax+b)^2}.\\]
</li>
<li>
\'n <em>kwadratiese faktor</em> \\(ax^2+bx+c\\)
in die noemer produseer \'n parsieelbreuk van
die vorm \\[{Ax+B\\over ax^2+bx+c}\\]
</li>
<li>
<em>Onegte breuke}</em> vereis \'n addisionele
term wat \'n veelterm van graad \\(n-d\\) is waar \\(n\\) die
graad van die teller is (d.w.s. \\(P(x)\\)) en \\(d\\) is die graad van
die noemer (d.w.s. \\(Q(x)\\)).
</li></ul>';
$string['alg_partial_fractions_name'] = 'Parsieelbreuke';
$string['alg_quadratic_formula_fact'] = 'As ons \'n kwadratiese vergelyking van die vorm:
\\[ax^2 + bx + c = 0,\\] het
is die oplossing(s) van daardie vergelyking, gegee deur die kwadratiese formule:
\\[x = \\frac{-b \\pm \\sqrt{b^2 - 4ac}}{2a}.\\]';
$string['alg_quadratic_formula_name'] = 'Die Kwadratiese Formule';
$string['all'] = 'Alle';
$string['allnodefeedbackmustusethesameformat'] = 'Al die terugvoer vir al die nodusse in \'n PRT moet dieselfde teksformaat gebruik.';
$string['allowwords'] = 'Toegelate woorde';
$string['allowwords_help'] = 'By verstek word die arbitrêre funksie of veranderlikename van meer as twee karakters in lengte nie toegelaat nie. Dit is \'n komma-geskeide lys van funksie- of veranderlikename wat in \'n student se antwoord toegelaat word.';
$string['allowwords_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Allow_Words';
$string['alreadydeployed'] = '\'n Variant wat ooreenstem met hierdie Vraagnota is reeds ontplooi.';
$string['ansnotemismatch'] = '[Antwoordnota stem nie ooreen nie]';
$string['answernote'] = 'Antwoordnota';
$string['answernote_err'] = 'Antwoordnotas mag nie die karakter | bevat nie. Hierdie karakter word deur STACK ingevoeg en later gebruik om antwoordnotas outomaties te verdeel.';
$string['answernote_err2'] = 'Antwoordnotas mag nie ; of : karakters bevat nie. Hierdie karakters word gebruik om vraagpoging-opsommingstringe in vanlyn verslaghulpmiddels te poog.';
$string['answernote_help'] = 'Dit is \'n merker wat belangrik is vir verslagdoeningsdoeleindes. Dit is ontwerp om die unieke pad deur die boom en die uitslag van elke antwoordtoets aan te teken. Dit word outomaties gegenereer, maar kan na iets betekenisvol verander word.';
$string['answernote_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Potential_response_trees.md#Answer_note';
$string['answernotedefaultfalse'] = '{$a->prtname}-{$a->nodename}-F';
$string['answernotedefaulttrue'] = '{$a->prtname}-{$a->nodename}-T';
$string['answernoterequired'] = 'Antwoordnota moet nie leeg wees nie.';
$string['answernoteunique'] = 'Duplikaat antwoordnotas in hierdie potensiële antwoordboom bespeur.';
$string['answertest'] = 'Antwoordtoets';
$string['answertest_help'] = '\'n Antwoordtoets word gebruik om twee uitdrukkings te vergelyk, om te bepaal of dit aan sommige wiskundige kriteria voldoen.';
$string['answertest_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Answer_Tests/index.md';
$string['assumepositive'] = 'Aanvaar positief';
$string['assumepositive_help'] = 'Hierdie opsie stel die waarde van Maxima se aanvaar_pos veranderlike.';
$string['assumepositive_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Options.md#Assume_Positive';
$string['assumereal'] = 'Aanvaar reëel';
$string['assumereal_help'] = 'Hierdie opsie stel die aanvaar_reëel veranderlike';
$string['assumereal_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Options.md#Assume_Real';
$string['autosimplify'] = 'Outoverveenvoudig';
$string['autosimplify_help'] = 'Stel die veranderlike "simp" binne Maxima vir hierdie vraag. Bv. vraagveranderlikes, vraagteks, ensovoorts. Die waarde wat in elke potensiële antwoordboom gestel word, sal dit vir enige uitdrukkings wat daarna binne die boom gedefinieer word, oorheenskryf.';
$string['autosimplify_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/CAS/Maxima.md#Simplification';
$string['autosimplifyprt'] = 'Outovereenvoudig';
$string['autosimplifyprt_help'] = 'Stel die veranderlike "simp" binne Maxima vir die terugvoerveranderlikes wat in hierdie potensiële antwoordboom gedefinieer is. Let daarop dat dit van die antwoordtoets afhang of uitdrukkings in PRT-notas voor gebruik vereenvoudig word. Byvoorbeeld: argumente tot AlgEquiv word vereenvoudig, terwyl dié vir EqualComAss nie vereenvoudig word nie.';
$string['autosimplifyprt_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/CAS/Maxima.md#Simplification';
$string['basicquestionreport'] = 'Basiese vraaggebruikverslag';
$string['basicquestionreport_help'] = 'Genereer \'n baie basiese verslag oor pogings tot hierdie vraag op die bediener. Nuttig om te besluit watter PRT-toets bygevoeg kan word om terugvoer te verbeter met die oog op wat die student in werklikheid doen. (Die meeste vrae word net op een plek gebruik)';
$string['basicreportinputsummary'] = 'Rou toevoer, ongeag watter variant gebruik is.';
$string['basicreportnotes'] = 'Frekwensie van antwoordnotas, vir elke PRT, ongeag watter variant gebruik is.';
$string['basicreportnotessplit'] = 'Frekwensie van antwoordnotas, vir elke PRT, verdeel met |, ongeag watter variant gebruik is.';
$string['basicreportraw'] = 'Rou data';
$string['basicreportvariants'] = 'Rou toevoere en PRT-antwoordnotas volgens variant.';
$string['booleangotunrecognisedvalue'] = 'Ongeldige toevoer.';
$string['boxsize'] = 'Toevoer-boksgrootte';
$string['boxsize_help'] = 'Breedte van die html-vormveld.';
$string['boxsize_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Box_Size';
$string['branchfeedback'] = 'Nodustak-terugvoer';
$string['branchfeedback_help'] = 'Dit is die CASText wat kan afhang van enige van die vraagveranderlikes, toevoerelemente of die terugvoerveranderlikes. Dit word geëvalueer en aan die student vertoon as hulle met hierdie tak langs beweeg.';
$string['bulktestcontinuefromhere'] = 'Loop weer of hervat, begin hier';
$string['bulktestindexintro'] = 'Deur op enige van die skakels te kliek sal al die vraagtoetse in al die STACK-vrae in daardie konteks geloop word.';
$string['bulktestindexintro_desc'] = 'Die <a href="{$a->link}">loop die vraagtoetse in massaskrif</a> laat jou al die STACK-vrae in \'n gegewe konteks met gemak loop. Nie net toets dit die vrae nie, dit is ook \'n goeie manier om die CAS-kas te herbevolk nadat dit skoongemaak is.';
$string['bulktestindextitle'] = 'Loop die vraagtoetse in grootmaat';
$string['bulktestnodeployedseeds'] = 'Hierdie vraag het lukrake variante, maar geen ontplooide plante nie.';
$string['bulktestnogeneralfeedback'] = 'Hierdie vraag het geen algemene terugvoer nie.';
$string['bulktestnotests'] = 'Hierdie vraag het geen toetse nie.';
$string['bulktestrun'] = 'Loop al die vraagtoetse vir al die vrae in die stelsel (stadig, slegs admin)';
$string['bulktesttitle'] = 'Al die vraagtoetse in {$a} word geloop';
$string['cachedef_parsercache'] = 'STACK-sinsontleding Maxima-uitdrukkings';
$string['calc_chain_rule_fact'] = 'Die volgende reël laat jou toe om die afleiding van \'n samestelling van twee funksies te vind.
Aanvaar ons het \'n funksie \\(f(g(x))\\), dan die definiëring van \\(u=g(x)\\), die afleiding wat betref \\(x\\) word gegee deur:
\\[\\frac{df(g(x))}{dx} = \\frac{dg(x)}{dx}\\cdot\\frac{df(u)}{du}.\\]
Anders kan ons skryf:
\\[\\frac{df(x)}{dx} = f\'(g(x))\\cdot g\'(x).\\]';
$string['calc_chain_rule_name'] = 'Die Kettingreël';
$string['calc_diff_linearity_rule_fact'] = '\\[{{\\rm d}\\,\\oor {\\rm d}x}\\big(af(x)+bg(x)\\big)=a{{\\rm d}f(x)\\oor {\\rm d}x}+b{{\\rm d}g(x)\\oor {\\rm d}x}\\quad a,b {\\rm\\  constant.}\\]';
$string['calc_diff_linearity_rule_name'] = 'Die Lineariteitreël vir Differensiasie';
$string['calc_diff_standard_derivatives_fact'] = 'Die volgende tabel vertoon die afleidings van sommige standaard funksies. Dit is nuttig om hierdie standaard afleidings te leer, aangesien dit dikwels in calculus gebruik word.
<center>
<table>
<tr><th>\\(f(x)\\)               </th><th> \\(f\'(x)\\)</th></tr>
<tr>
<td>\\(k\\), konstante           </td> <td> \\(0\\) </td> </tr> <tr> <td>
\\(x^n\\), enige konstante \\(n\\) </td> <td> \\(nx^{n-1}\\)</td> </tr> <tr> <td>
\\(e^x\\)                   </td> <td> \\(e^x\\)</td> </tr> <tr> <td>
\\(\\ln(x)=\\log_{\\rm e}(x)\\)              </td> <td> \\(\\frac{1}{x}\\)                </td> </tr> <tr> <td>
\\(\\sin(x)\\)                             </td> <td> \\(\\cos(x)\\)                    </td> </tr> <tr> <td>
\\(\\cos(x)\\)                             </td> <td> \\(-\\sin(x)\\)                   </td> </tr> <tr> <td>
\\(\\tan(x) = \\frac{\\sin(x)}{\\cos(x)}\\)   </td> <td>   \\(\\sec^2(x)\\)                </td> </tr> <tr> <td>
\\(cosec(x)=\\frac{1}{\\sin(x)}\\)         </td> <td>   \\(-cosec(x)\\cot(x)\\)        </td> </tr> <tr> <td>
\\(\\sec(x)=\\frac{1}{\\cos(x)}\\)           </td> <td>   \\(\\sec(x)\\tan(x)\\)           </td> </tr> <tr> <td>
\\(\\cot(x)=\\frac{\\cos(x)}{\\sin(x)}\\)     </td> <td>   \\(-cosec^2(x)\\)             </td> </tr> <tr> <td>
\\(\\cosh(x)\\)                            </td> <td>   \\(\\sinh(x)\\)                 </td> </tr> <tr> <td>
\\(\\sinh(x)\\)                            </td> <td>   \\(\\cosh(x)\\)                 </td> </tr> <tr> <td>
\\(\\tanh(x)\\)                            </td> <td>   \\(sech^2(x)\\)               </td> </tr> <tr> <td>
\\(sech(x)\\)                            </td> <td>   \\(-sech(x)\\tanh(x)\\)        </td> </tr> <tr> <td>
\\(cosech(x)\\)                          </td> <td>   \\(-cosech(x)\\coth(x)\\)      </td> </tr> <tr> <td>
\\(coth(x)\\)                            </td> <td>   \\(-cosech^2(x)\\)            </td> </tr>
</table>
</center>

 \\[ \\frac{d}{dx}\\left(\\sin^{-1}(x)\\right) =  \\frac{1}{\\sqrt{1-x^2}}\\]
 \\[ \\frac{d}{dx}\\left(\\cos^{-1}(x)\\right) =  \\frac{-1}{\\sqrt{1-x^2}}\\]
 \\[ \\frac{d}{dx}\\left(\\tan^{-1}(x)\\right) =  \\frac{1}{1+x^2}\\]
 \\[ \\frac{d}{dx}\\left(\\cosh^{-1}(x)\\right) =  \\frac{1}{\\sqrt{x^2-1}}\\]
 \\[ \\frac{d}{dx}\\left(\\sinh^{-1}(x)\\right) =  \\frac{1}{\\sqrt{x^2+1}}\\]
 \\[ \\frac{d}{dx}\\left(\\tanh^{-1}(x)\\right) =  \\frac{1}{1-x^2}\\]';
$string['calc_diff_standard_derivatives_name'] = 'Standaard Afleidings';
$string['calc_int_linearity_rule_fact'] = '\\[\\int \\left(af(x)+bg(x)\\right){\\rm d}x = a\\int\\!\\!f(x)\\,{\\rm d}x
\\,+\\,b\\int \\!\\!g(x)\\,{\\rm d}x, \\quad (a,b \\, \\, {\\rm constant.})
\\]';
$string['calc_int_linearity_rule_name'] = 'Die Lineariteitreël vir Integrasie';
$string['calc_int_methods_parts_fact'] = '\\[
\\int_a^b u{{\\rm d}v\\over {\\rm d}x}{\\rm d}x=\\left[uv\\right]_a^b-
\\int_a^b{{\\rm d}u\\over {\\rm d}x}v\\,{\\rm d}x\\]
or alternatively: \\[\\int_a^bf(x)g(x)\\,{\\rm d}x=\\left[f(x)\\,\\int
g(x){\\rm d}x\\right]_a^b -\\int_a^b{{\\rm d}f\\over {\\rm
d}x}\\left\\{\\int g(x){\\rm d}x\\right\\}{\\rm d}x.\\]';
$string['calc_int_methods_parts_name'] = 'Integrasie deur Dele';
$string['calc_int_methods_substitution_fact'] = '\\[
\\int f(u){{\\rm d}u\\over {\\rm d}x}{\\rm d}x=\\int f(u){\\rm d}u
\\quad\\hbox{and}\\quad \\int_a^bf(u){{\\rm d}u\\over {\\rm d}x}\\,{\\rm
d}x = \\int_{u(a)}^{u(b)}f(u){\\rm d}u.
\\]';
$string['calc_int_methods_substitution_name'] = 'Integrasie deur Vervanging';
$string['calc_int_standard_integrals_fact'] = '\\[\\int k\\ dx = kx +c, \\mbox{ where k is constant.}\\]
\\[\\int x^n\\ dx  = \\frac{x^{n+1}}{n+1}+c, \\quad (n\\ne -1)\\]
\\[\\int x^{-1}\\ dx = \\int {\\frac{1}{x}}\\ dx = \\ln(|x|)+c = \\ln(k*|x|) = \\left\\{\\matrix{\\ln(x)+c & x>0\\cr
\\ln(-x)+c & x<0\\cr}\\right.\\]

<center>
<table>
<tr><th>\\(f(x)\\)</th><th> \\(\\int f(x)\\ dx\\)</th></tr>
<tr><td>\\(e^x\\) </td> <td>  \\(e^x+c\\)</td> <td> </td> </tr>
<tr><td>\\(\\cos(x)\\) </td> <td>  \\(\\sin(x)+c\\)   </td> <td> </td> </tr>
<tr><td>\\(\\sin(x)\\) </td> <td>  \\(-\\cos(x)+c\\)  </td> <td> </td> </tr>
<tr><td>\\(\\tan(x)\\) </td> <td>  \\(\\ln(\\sec(x))+c\\) </td> <td>\\(-\\frac{\\pi}{2} < x < \\frac{\\pi}{2}\\)</td> </tr>
<tr><td>\\(\\sec x\\)  </td> <td>  \\(\\ln (\\sec(x)+\\tan(x))+c\\) </td> <td> \\( -{\\pi\\over 2}< x < {\\pi\\over 2}\\)</td> </tr>
<tr><td>cosec\\(\\, x\\) </td> <td>  \\(\\ln ($cosec$(x)-\\cot(x))+c\\) </td> <td>\\(0 < x < \\pi\\)</td> </tr>
<tr><td>cot\\(\\,x\\) </td> <td>  \\(\\ln(\\sin(x))+c\\) </td> <td>  \\(0< x< \\pi\\) </td> </tr>
<tr><td>\\(\\cosh(x)\\) </td> <td>  \\(\\sinh(x)+c\\)</td> <td></td> </tr>
<tr><td>\\(\\sinh(x)\\) </td> <td>  \\(\\cosh(x) + c\\) </td> <td> </td> </tr>
<tr><td>\\(\\tanh(x)\\) </td> <td>  \\(\\ln(\\cosh(x))+c\\)</td> <td> </td> </tr>
<tr><td>coth\\((x)\\) </td> <td>  \\(\\ln(\\sinh(x))+c \\)</td> <td>   \\(x>0\\)</td> </tr>
<tr><td>\\({1\\over x^2+a^2}\\) </td> <td>  \\({1\\over a}\\tan^{-1}{x\\over a}+c\\)</td> <td> \\(a>0\\)</td> </tr>
<tr><td>\\({1\\over x^2-a^2}\\) </td> <td>  \\({1\\over 2a}\\ln{x-a\\over x+a}+c\\) </td> <td>  \\(|x|>a>0\\)</td> </tr>
<tr><td>\\({1\\over a^2-x^2}\\) </td> <td>  \\({1\\over 2a}\\ln{a+x\\over a-x}+c\\) </td> <td>   \\(|x|<a\\)</td> </tr>
<tr><td>\\({1\\over \\sqrt{x^2+a^2}}\\) </td> <td>  \\(\\sinh^{-1}\\left(\\frac{x}{a}\\right) + c\\) </td> <td> \\(a>0\\) </td> </tr>
<tr><td>\\({1\\over \\sqrt{x^2-a^2}}\\) </td> <td>  \\(\\cosh^{-1}\\left(\\frac{x}{a}\\right) + c\\) </td> <td>  \\(x\\geq a > 0\\) </td> </tr>
<tr><td>\\({1\\over \\sqrt{x^2+k}}\\) </td> <td>  \\(\\ln (x+\\sqrt{x^2+k})+c\\)</td> <td> </td> </tr>
<tr><td>\\({1\\over \\sqrt{a^2-x^2}}\\) </td> <td>  \\(\\sin^{-1}\\left(\\frac{x}{a}\\right)+c\\)</td> <td>  \\(-a\\leq x\\leq a\\)  </td> </tr>
</table></center>';
$string['calc_int_standard_integrals_name'] = 'Standaard Integrale';
$string['calc_product_rule_fact'] = 'Die volgende reël laat \'n mens toe om funksies wat saam vermenigvuldig is, te differensieer. Aanvaar dat ons \\(f(x)g(x)\\) ten opsigte van \\(x\\) wil differensieer.
\\[ \\frac{\\mathrm{d}}{\\mathrm{d}{x}} \\big(f(x)g(x)\\big) = f(x) \\cdot \\frac{\\mathrm{d} g(x)}{\\mathrm{d}{x}}  + g(x)\\cdot \\frac{\\mathrm{d} f(x)}{\\mathrm{d}{x}},\\] of met alternatiewe notasie, \\[ (f(x)g(x))\' = f\'(x)g(x)+f(x)g\'(x). \\]';
$string['calc_product_rule_name'] = 'Die Produkreël';
$string['calc_quotient_rule_fact'] = 'Die kwosiëntreël vir differensiasie stel dat vir enige twee differensieerbare funksies \\(f(x)\\) en \\(g(x)\\),
 \\[\\frac{d}{dx}\\left(\\frac{f(x)}{g(x)}\\right)=\\frac{g(x)\\cdot\\frac{df(x)}{dx}\\ \\ - \\ \\ f(x)\\cdot \\frac{dg(x)}{dx}}{g(x)^2}. \\]';
$string['calc_quotient_rule_name'] = 'Die Kwosiëntreël';
$string['calc_rules_fact'] = '<b>Die Produkreël</b><br />Die volgende reël laat \'n mens toe om funksies wat saam vermenigvuldig is,
te differensieer. Aanvaar dat ons \\(f(x)g(x)\\) ten opsigte van \\(x\\) wil differensieer.
\\[ \\frac{\\mathrm{d}}{\\mathrm{d}{x}} \\big(f(x)g(x)\\big) = f(x) \\cdot \\frac{\\mathrm{d} g(x)}{\\mathrm{d}{x}}  + g(x)\\cdot \\frac{\\mathrm{d} f(x)}{\\mathrm{d}{x}},\\] of met alternatiewe notasie, \\[ (f(x)g(x))\' = f\'(x)g(x)+f(x)g\'(x). \\]
<b>Die Kwosiëntreël</b><br />Die kwosiëntreël vir differensiasie stel dat vir enige twee differensieerbare funksies \\(f(x)\\) en \\(g(x)\\),
\\[\\frac{d}{dx}\\left(\\frac{f(x)}{g(x)}\\right)=\\frac{g(x)\\cdot\\frac{df(x)}{dx}\\ \\ - \\ \\ f(x)\\cdot \\frac{dg(x)}{dx}}{g(x)^2}. \\]
<b>Die Kettingreël</b><br />Die volgende reël laat \'n mens toe om die afleiding van \'n samestelling van twee funksies te vind.
Aanvaar dat ons \'n funksie \\(f(g(x))\\) het, dan definiëring van \\(u=g(x)\\), word die afleiding ten opsigte van \\(x\\) gegee met:
\\[\\frac{df(g(x))}{dx} = \\frac{dg(x)}{dx}\\cdot\\frac{df(u)}{du}.\\]
Anders kan ons skryf:
\\[\\frac{df(x)}{dx} = f\'(g(x))\\cdot g\'(x).\\]';
$string['calc_rules_name'] = 'Calculusreëls';
$string['casdisplay'] = 'CAS vertoon';
$string['cassuitecolerrors'] = 'CAS foute';
$string['castext'] = 'CAS-teks';
$string['casvalid'] = 'V2';
$string['casvalidatemismatch'] = '[CAS valideer mispassing]';
$string['casvalue'] = 'CAS-waarde';
$string['chat'] = 'Stuur na die CAS';
$string['chat_desc'] = 'Die <a href="{$a->link}">CAS kletsskrif</a> laat jou die koppeling met die CAS toets en Maxima-sintaksis probeer.';
$string['chatintro'] = 'Hierdie bladsy ontsper CAS-teks om direk geëvalueer te word. Dit is \'n eenvoudige teks wat \'n nuttige minimale voorbeeld is, en \'n handige manier om te kyk of die CAS werk, en om verskeie toevoere te toets. Die eerste teksboks laat veranderlikes gedefinieer word, die tweede is vir die CAS-teks self.';
$string['chattitle'] = 'Toets die koppeling met die CAS';
$string['checkanswertype'] = 'Kontroleer die tipe antwoord';
$string['checkanswertype_help'] = 'Indien ja, word antwoorde van \'n ander "tipe" (bv. uitdrukking, vergelyking, matriks, lys, stel) as ongeldig verwerp.';
$string['checkanswertype_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Check_Type';
$string['clearedthecache'] = 'CAS-kas is skoongemaak.';
$string['clearingcachefiles'] = 'Gekasde STACK-stiplêers word uitgevee {$a->done}/{$a->total}';
$string['clearingthecache'] = 'Die kas word skoongemaak';
$string['clearthecache'] = 'Maak die kas skoon';
$string['completetestcase'] = 'Vul die res van die vorm in om \'n slagende toetsgeval te skep';
$string['complexno'] = 'Betekenis en vertoon van sqrt(-1)';
$string['complexno_help'] = 'Beheer die betekenis';
$string['complexno_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Options.md#sqrt_minus_one.';
$string['createtestcase'] = 'Skep toetsgeval';
$string['currentlyselectedvariant'] = 'Dit is die variant wat hieronder vertoon word';
$string['ddl_badanswer'] = 'Die modelantwoordveld vir hierdie toevoer is misvormd: <code>{$a}</code>.';
$string['ddl_duplicates'] = 'Duplikaat waardes is gevind met die generasie van die toevoeropsies.';
$string['ddl_empty'] = 'Geen keuses is vir hierdie aftreklys verskaf nie.';
$string['ddl_nocorrectanswersupplied'] = 'Die onderwyser het nie minstens een korrekte antwoord aangedui nie.';
$string['ddl_runtime'] = 'Die toevoer het die volgende looptydfout gegenereer, wat jou verhoed om te antwoord. Kontak asseblief jou onderwyser.';
$string['ddl_unknown'] = 'STACK ontvang <code>{$a}</code> maar dit is nie deur die onderwyser as \'n opsie gelys nie.';
$string['debuginfo'] = 'Ontfoutinligting';
$string['defaultmarkzeroifnoprts'] = 'Die verstek punt moet nul wees as hierdie vraag geen PRT\'s het nie.';
$string['defaultprtcorrectfeedback'] = 'Korrekte antwoord, welgedaan.';
$string['defaultprtincorrectfeedback'] = 'Verkeerde antwoord.';
$string['defaultprtpartiallycorrectfeedback'] = 'Jou antwoord is gedeeltelik korrek.';
$string['deletetestcase'] = 'Wis toetsgeval {$a->no} vir vraag {$a->question} uit';
$string['deletetestcaseareyousure'] = 'Is jy seker jy wil toetsgeval {$a->no} vir vraag {$a->question} uitwis?';
$string['deletethistestcase'] = 'Wis hierdie toetsgeval uit';
$string['deploy'] = 'Ontplooi';
$string['deployedprogress'] = 'Variante word ontplooi';
$string['deployedvariants'] = 'Ontplooide variante';
$string['deployedvariantsn'] = 'Ontplooide variante ({$a})';
$string['deploymanyerror'] = 'Fout in gebruikertoevoer: kan nie "{$a->err}" variante ontplooi nie.';
$string['deploymanynonew'] = 'Te veel herhaalde bestaande vraagnotas is gegenereer.';
$string['deploymanynotes'] = 'Let wel: STACK sal tou opgooi as daar 10 mislukte pogings was om \'n nuwe vraagnota te genereer, of as een vraagtoets misluk.';
$string['deploymanysuccess'] = 'Aantal nuwe variante suksesvol geskep, getoets en ontplooi: {$a->no}.';
$string['deployoutoftime'] = 'Tydbeperking oorskry deur ongeveer {$a->time} sekondes te gebruik. Probeer asseblief weer om meer te ontplooi.';
$string['deployremoveall'] = 'Onontplooi alle variante:';
$string['deploytestall'] = 'Loop alle toetse op alle ontplooide variante (stadig):';
$string['deploytoomanyerror'] = 'STACK sal probeer om op die meeste 100 nuwe variante in enige versoek te ontplooi. Geen nuwe variante is ontplooi nie.';
$string['displaymismatch'] = '[LaTeX mispassing]';
$string['dropdowngotunrecognisedvalue'] = 'Ongeldige toevoer.';
$string['editingtestcase'] = 'Toetsgeval {$a->no} vir vraag {$a->question} word gewysig';
$string['editthistestcase'] = 'Wysig hierdie toetsgeval ...';
$string['equiv_AND'] = 'en';
$string['equiv_ANDOR'] = 'en/of verwarring!';
$string['equiv_ASSUMEPOSREALVARS'] = 'Aanvaar positiewe reële veranderlikes';
$string['equiv_ASSUMEPOSVARS'] = 'Aanvaar positiewe veranderlikes';
$string['equiv_IMPLIES'] = 'impliseer';
$string['equiv_LET'] = 'Laat';
$string['equiv_MISSINGVAR'] = 'Ontbrekende opdragte';
$string['equiv_NAND'] = 'nen';
$string['equiv_NOR'] = 'nóg';
$string['equiv_NOT'] = 'nie';
$string['equiv_OR'] = 'of';
$string['equiv_SAMEROOTS'] = '(Dieselfde stamme)';
$string['equiv_XNOR'] = 'xnóg';
$string['equiv_XOR'] = 'xof';
$string['equivfirstline'] = 'Jy het die verkeerde eerste lyn in jou argument gebruik!';
$string['equivnocomments'] = 'Jy het nie toestemming om kommentaar in hierdie toevoertipe te gebruik nie. Werk asseblief net lyn vir lyn.';
$string['errors'] = 'Foute';
$string['exceptionmessage'] = '{$a}';
$string['expectedanswernote'] = 'Verwagte antwoordnota';
$string['expectedoutcomes'] = 'Verwagte PRT-uitkomste: [toevoere gebruik]';
$string['expectedpenalty'] = 'Verwagte straftoekenning';
$string['expectedscore'] = 'Verwagte punt';
$string['exportthisquestion'] = 'Voer hierdie vraag uit';
$string['exportthisquestion_help'] = 'Dit sal \'n Moodle XML-uitvoerdokument skep wat slegs hierdie vraag bevat. Een voorbeeld van wanneer dit nuttig is, is as jy vermoed dat hierdie vraag \'n fout in STACK demonstreer wat jy aan die ontwikkelaars wil rapporteer.';
$string['false'] = 'Onwaar';
$string['falsebranch'] = 'Onwaar tak';
$string['falsebranch_help'] = 'Hierdie velde beheer wat gebeur wanneer die antwoordtoets nie deurkom nie
### Mod en punt
Hoe die punt aangepas word. = beteken die punt is op sekere waardes gestel, +/- beteken die gegewe punt moet by die huidige totaal bygevoeg of afgetrek word.

### Straftoekenning
In aanpassende of interaktiewe modus, akkumuleer soveel straftoekenning.

### Volgende
Of daar na \'n volgende nodus gegaan moet word, en watter een, indien wel, of ophou.

### Antwoordnota
Dit is \'n merker wat belangrik is vir verslaggewingdoeleindes. Dit is ontwerp om die unieke pad deur die boom aan te teken, asook die uitkoms van elke antwoordtoets. Dit word outomaties gegenereer, maar kan na iets betekenisvol verander word.';
$string['feedbackfromprtx'] = '[ Terugvoer van {$a}. ]';
$string['feedbackstyle'] = 'PRT-terugvoerstyl';
$string['feedbackstyle0'] = 'Vormend';
$string['feedbackstyle1'] = 'Standaard';
$string['feedbackstyle2'] = 'Kompak';
$string['feedbackstyle3'] = 'Slegs simbool';
$string['feedbackstyle_help'] = 'Beheer hoe PRT-terugvoer vertoon word.';
$string['feedbackstyle_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Potential_response_trees.md';
$string['feedbackvariables'] = 'Terugvoerveranderlikes';
$string['feedbackvariables_help'] = 'Die terugvoerveranderlikes laat jou toe om enige van die toevoer te manipuleer, asook die die vraagveranderlikes, voor die boom deurkruis word. Veranderlikes wat hier gedefinieer is, kan op enige ander plek in hierdie boom gebruik word.';
$string['feedbackvariables_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Variables.md#Feedback_variables';
$string['fieldshouldnotcontainplaceholder'] = '{$a->field} behoort geen [[{$a->type}:...]] plekhouers te bevat nie.';
$string['firstnodemusthavelowestnumber'] = 'Die eerste nodus moet die laagste getal hê.';
$string['fixdollars'] = 'Stel dollars vas';
$string['fixdollars_help'] = 'Hierdie opsie is nuttig as TeX met <code>$...$</code> en <code>$$...$$</code> skeiers gekopieer en geplak word. Daardie skeiers sal vervang word met die aanbevole skeiers tydens die bergingsproses.';
$string['fixdollarslabel'] = 'Vervang <code>$...$</code> met <code>\\(...\\)</code>, <code>$$...$$</code> met <code>\\[...\\]</code> en <code>@...@</code> met <code>{@...@}</code> tydens berging.';
$string['forbiddendoubledollars'] = 'Gebruik asseblief die skeiers <code>\\(...\\)</code> vir inlyn Wiskunde en <code>\\[...\\]</code> vir vertoon Wiskunde. <code>$...$</code> en <code>$$...$$</code> word nie toegelaat nie. Daar is \'n opsie aan die einde van die vorm om dit outomaties reg te stel.';
$string['forbidfloat'] = 'Verbied wissel';
$string['forbidfloat_help'] = 'Indien op ja gestel, sal enige antwoord van die student wat oor \'n wisselpunt beskik, as ongeldig verwerp word.';
$string['forbidfloat_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Forbid_Floats';
$string['forbidwords'] = 'Verbode woorde';
$string['forbidwords_help'] = 'Hierdie is \'n komma-geskeide lys teksstringe wat in \'n student se antwoord verbied word.';
$string['forbidwords_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Forbidden_Words';
$string['generalfeedback'] = 'Algemene terugvoer';
$string['generalfeedback_help'] = 'Algemene terugvoer is CASText. Algemene terugvoer, ook bekend as \'n "uitgewerkte oplossing" word aan die student vertoon nadat hulle die vraag probeer doen het. Anders as terugvoer, wat afhang van watter antwoord die student verskaf het, word dieselfde algemene terugvoerteks aan alle studente vertoon. Dit kan afhang van die vraagveranderlikes wat in die vraagvariant gebruik is.';
$string['generalfeedback_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/CASText.md#general_feedback';
$string['greek_alphabet_fact'] = '<center>
<table>
<tr><td>
 Hoofkas, \\(\\quad\\) </td><td>  onderkas, \\(\\quad\\) </td><td>  naam </td> </tr>   <tr> <td>
 \\(A\\)  </td><td>  \\(\\alpha\\)  </td><td>  alpha  </td> </tr>   <tr> <td>
 \\(B\\)  </td><td>  \\(\\beta\\)  </td><td>  beta </td> </tr>   <tr> <td>
 \\(\\Gamma\\)  </td><td>  \\(\\gamma\\)  </td><td>  gamma </td> </tr>   <tr> <td>
 \\(\\Delta\\)  </td><td>  \\(\\delta\\)  </td><td>  delta </td> </tr>   <tr> <td>
 \\(E\\)  </td><td>  \\(\\epsilon\\)  </td><td>  epsilon </td> </tr>   <tr> <td>
 \\(Z\\)  </td><td>  \\(\\zeta\\)  </td><td>  zeta </td> </tr>   <tr> <td>
 \\(H\\)  </td><td>  \\(\\eta\\)  </td><td>  eta </td> </tr>   <tr> <td>
 \\(\\Theta\\)  </td><td>  \\(\\theta\\)  </td><td>  theta </td> </tr>   <tr> <td>
 \\(K\\)  </td><td>  \\(\\kappa\\)  </td><td>  kappa </td> </tr>   <tr> <td>
 \\(M\\)  </td><td>  \\(\\mu\\)  </td><td>  mu </td> </tr>   <tr> <td>
 \\(N\\)  </td><td>  \\( u\\)  </td><td>  nu </td> </tr>   <tr> <td>
 \\(\\Xi\\)  </td><td>  \\(\\xi\\)  </td><td>  xi </td> </tr>   <tr> <td>
 \\(O\\)  </td><td>  \\(o\\)  </td><td>  omicron </td> </tr>   <tr> <td>
 \\(\\Pi\\)  </td><td>  \\(\\pi\\)  </td><td>  pi </td> </tr>   <tr> <td>
 \\(I\\)  </td><td>  \\(\\iota\\)  </td><td>  iota </td> </tr>   <tr> <td>
 \\(P\\)  </td><td>  \\(\\rho\\) </td><td>  rho </td> </tr>   <tr> <td>
 \\(\\Sigma\\)  </td><td>  \\(\\sigma\\)  </td><td>  sigma </td> </tr>   <tr> <td>
 \\(\\Lambda\\)  </td><td>  \\(\\lambda\\)  </td><td>  lambda </td> </tr>   <tr> <td>
 \\(T\\)  </td><td>  \\(\\tau\\)  </td><td>  tau </td> </tr>   <tr> <td>
 \\(\\Upsilon\\)  </td><td>  \\(\\upsilon\\)  </td><td>  upsilon </td> </tr>   <tr> <td>
 \\(\\Phi\\)  </td><td>  \\(\\phi\\)  </td><td>  phi </td> </tr>   <tr> <td>
 \\(X\\)  </td><td>  \\(\\chi\\)  </td><td>  chi </td> </tr>   <tr> <td>
 \\(\\Psi\\)  </td><td>  \\(\\psi\\)  </td><td> psi </td> </tr>   <tr> <td>
 \\(\\Omega\\)  </td><td>  \\(\\omega\\)  </td><td>  omega </td></tr>
</table></center>';
$string['greek_alphabet_name'] = 'Die Griekse Alfabet';
$string['healthautomaxopt'] = 'Skep outomaties \'n geoptimaliseerde Maxima-prent';
$string['healthautomaxopt_failed'] = 'Skep Geoptimaliseerde Maxima-prent het MISLUK: [{$a->errmsg}]';
$string['healthautomaxopt_nolisp'] = 'Kon nie LISP-weergawe bepaal nie, dus is Maxima-prent nie outomaties geskep nie.';
$string['healthautomaxopt_nolisprun'] = 'Kon nie lisp.run outomaties opspoor nie. Probeer "sudo updatedb" vanaf die opdraglyn en verwys na die optimaliseringdokumente.';
$string['healthautomaxopt_notok'] = 'Maxima-prent is nie outomaties geskep nie.';
$string['healthautomaxopt_ok'] = 'Maxima-prent geskep: <tt>{$a->command}</tt>';
$string['healthautomaxopt_succeeded'] = 'Skep Geoptimaliseerde Maxima-prent was SUKSESVOL';
$string['healthautomaxoptintro'] = 'Vir die beste werkverrigting moet ons maxima op \'n linux-masjien optimaliseer. Gebruik die invoegtoepassing "healthcheck" bladsy en sien die dokumentasie oor hierdie kwessie.';
$string['healthcheck'] = 'Stack-healthcheck';
$string['healthcheck_desc'] = 'Die <a href="{$a->link}">healthcheck-teks</a> help jou verifieer dat alle aspekte van STACK reg werk.';
$string['healthcheckcache_db'] = 'CAS-uitslae word in die databasis gekas.';
$string['healthcheckcache_none'] = 'CAS-uitslae word nie gekas nie.';
$string['healthcheckcache_otherdb'] = 'CAS-uitslae word in \'n ander databasis gekas.';
$string['healthcheckcachestatus'] = 'Die kas bevat tans {$a} invoere.';
$string['healthcheckconfigintro1'] = 'Maxima is in die volgende gids gevind en word gebruik:';
$string['healthcheckconnect'] = 'Daar word gepoog om met die CAS te koppel';
$string['healthcheckconnectintro'] = 'Ons probeer die volgende CAS-teks evalueer:';
$string['healthcheckcreateimage'] = 'Skep Maxima-prent';
$string['healthcheckfilters'] = 'Verseker asseblief dat die {$a->filter} ontsper is op die <a href="{$a->url}">Bestuur filters</a> blad.';
$string['healthchecklatex'] = 'Kontroleer of LaTeX korrek omgeskakel word.';
$string['healthchecklatexintro'] = 'STACK genereer LaTeX in die verbygaan, en stel onderwysers in staat om LaTeX in vrae te skryf. Dit aanvaar dat LaTeX deur \'n Moodle-filter omgeskakel gaan word. Hieronder is voorbeelde van vertoonde en inlyn-uitdrukkings in LaTeX wat korrek in jou blaaier behoort te verskyn. Probleme hier dui op verkeerde Moodle-filterverstellings, nie op foute met STACK self nie. STACK self gebruik slegs die enkel- en dubbeldollarnotasie, maar sommige vraagouteurs kan op die ander vorms staatmaak.';
$string['healthchecklatexmathjax'] = 'STACK maak staat op die Moodle MathJax-filter. \'n Alternatief is om javaskrifkode by Moodle se addisionele HTML te voeg. Sien die STACK-installasiedokumente vir meer besonderhede oor hierdie opsie.';
$string['healthcheckmathsdisplaymethod'] = 'Wiskunde vertoonmetode wat gebruik word: {$a}';
$string['healthcheckmaximabat'] = 'Die maxima.bat-dokument ontbreek';
$string['healthcheckmaximabatinfo'] = 'Hierdie teks het probeer om die maxima.bat-teks outomaties vanuit "C:\\Program files\\Maxima-1.xx.y\\bin" in "{$a}\\stack" te kopieer. Dit lyk nie asof dit gewerk het nie. Kopieer asseblief hierdie dokument per hand.';
$string['healthchecknombstring'] = 'STACK v4.3 en nuwer vereis die PHP-module-mbstring, wat ontbreek. Lees asseblief die installasiedokumente.';
$string['healthcheckplots'] = 'Grafiekstippeling';
$string['healthcheckplotsintro'] = 'Daar behoort twee verskillende stippelings te wees. As twee identiese stippelings gesien word, is dit \'n fout in die benaming van die stippelingdokumente. As geen foute terugkeer nie, maar \'n stippeling nie vertoon word nie, kan een van die volgende help. (i) kontroleer leestoestemmings op die twee tydelike gidse. (ii) verander die opsies wat deur GNUPlot gebruik is om die stippeling te skep. Daar is tans geen webkoppelvlak vir hierdie opsies nie.';
$string['healthchecksamplecas'] = 'Die afleiding van {@ x^4/(1+x^4) @} is \\[ \\frac{d}{dx} \\frac{x^4}{1+x^4} = {@ diff(x^4/(1+x^4),x) @}. \\]  Bevestig of unicode ondersteun word: \\(\\forall\\) behoort vertoon te word {@unicode(8704)@}.';
$string['healthchecksampledisplaytex'] = '\\[\\sum_{n=1}^\\infty \\frac{1}{n^2} = \\frac{\\pi^2}{6}.\\]';
$string['healthchecksampleinlinetex'] = '\\(\\sum_{n=1}^\\infty \\frac{1}{n^2} = \\frac{\\pi^2}{6}\\).';
$string['healthchecksampleplots'] = 'Twee voorbeeldstippelings hieronder.  {@plot([x^4/(1+x^4),diff(x^4/(1+x^4),x)],[x,-3,3])@} {@plot([sin(x),x,x^2,x^3],[x,-3,3],[y,-3,3],grid2d)@}  \'n Derde, kleiner stippeling kan hier met tradisionele asse vertoon word. (Slegs nuwer weergawes van Maxima.){@plot([sin(x),x,x^2,x^3],[x,-3,3],[y,-3,3],[box, false],[yx_ratio, 1],[axes, solid],[xtics, -3, 1, 3],[ytics, -3, 1, 3],[size,250,250])@}';
$string['healthchecksstackmaximanotupdated'] = 'Dit lyk asof STACK nie deeglik bygewerk is nie. Besoek asseblief die <a href="{$a}">Stelseladministrasie -> Kennisgewingsblad</a>.';
$string['healthchecksstackmaximatooold'] = 'So oud, die weergawe is onbekend!';
$string['healthchecksstackmaximaversion'] = 'Maxima-weergawe';
$string['healthchecksstackmaximaversionfixoptimised'] = 'Asseblief, <a href="{$a->url}">herbou jou geoptimaliseerde Maxima-uitvoerbare</a>.';
$string['healthchecksstackmaximaversionfixserver'] = 'Herbou asseblief die Maxima-kode op jou MaximaPool-bediener.';
$string['healthchecksstackmaximaversionfixunknown'] = 'Dit is nie duidelik hoe dit gebeur het nie. Jy sal hierdie probleem self moet ontfout. Begin deur die CAS-kasgeheue skoon te maak.';
$string['healthchecksstackmaximaversionmismatch'] = 'Die weergawe van die STACK-Maxima-biblioteke wat gebruik word ({$a->usedversion}) stem nie ooreen met wat verwag word  ({$a->expectedversion}) deur hierdie weergawe van die STACK-vraagtipe nie. {$a->fix}';
$string['healthchecksstackmaximaversionok'] = 'Korrekte en verwagte STACK-Maxima-biblioteekweergawe wat gebruik word ({$a->usedversion}).';
$string['healthunabletolistavail'] = 'Platformtipe nie tans op "linux" gestel nie, dus kon beskikbare weergawes van Maxima nie gelys word nie.';
$string['healthuncached'] = 'Ongekasde CAS-oproep';
$string['healthuncachedintro'] = 'Hierdie afdeling stuur altyd \'n opregte oproep na die CAS, ongeag die huidige kasverstellings. Dit is nodig om te verseker dat die koppeling aan die CAS regtig in werking is.';
$string['healthuncachedstack_CAS_calculation'] = 'Verwagte CAS-berekening: {$a->expected}. Werklike CAS-berekening: {$a->actual}.';
$string['healthuncachedstack_CAS_not'] = 'CAS het data teruggestuur soos verwag, maar daar was foute.';
$string['healthuncachedstack_CAS_ok'] = 'CAS het data teruggestuur soos verwag. Jy het \'n regstreekse koppeling aan die CAS.';
$string['healthuncachedstack_CAS_version'] = 'Verwagte Maxima-weergawe: "{$a->expected}".  Werklike Maxima-weergawe: {$a->actual}.';
$string['healthuncachedstack_CAS_versionnotchecked'] = 'Jy het die "verstek" weergawe van Maxima gekies, dus word geen kontrolering van Maxima-weergawe gedoen nie. Jou onverwerkte koppeling gebruik in werklikheid weergawe {$a->actual}.';
$string['htmlfragment'] = 'Dit lyk assof daar HTML-elemente in jou uitdrukking is.';
$string['hyp_functions_fact'] = 'Hiperboliese funksies het soortgelyke eienskappe as trigonometriese funksies, maar kan in eksponensiële vorm as volg verteenwoordig word:
 \\[ \\cosh(x)      = \\frac{e^x+e^{-x}}{2}, \\qquad \\sinh(x)=\\frac{e^x-e^{-x}}{2} \\]
 \\[ \\tanh(x)      = \\frac{\\sinh(x)}{\\cosh(x)} = \\frac{{e^x-e^{-x}}}{e^x+e^{-x}} \\]
 \\[ {\\rm sech}(x) ={1\\over \\cosh(x)}={2\\over {\\rm e}^x+{\\rm e}^{-x}}, \\qquad  {\\rm cosech}(x)= {1\\over \\sinh(x)}={2\\over {\\rm e}^x-{\\rm e}^{-x}} \\]
 \\[ {\\rm coth}(x) ={\\cosh(x)\\over \\sinh(x)} = {1\\over {\\rm tanh}(x)} ={{\\rm e}^x+{\\rm e}^{-x}\\over {\\rm e}^x-{\\rm e}^{-x}}\\]';
$string['hyp_functions_name'] = 'Hiperboliese Funksies';
$string['hyp_identities_fact'] = 'Die soortgelykheid tussen die manier wat hiperboliese en trigonometriese funksies optree, kan gesien word wanneer sommige basiese hiperboliese identiteite geobserveer word:
  \\[{\\rm e}^x=\\cosh(x)+\\sinh(x), \\quad {\\rm e}^{-x}=\\cosh(x)-\\sinh(x)\\]
  \\[\\cosh^2(x) -\\sinh^2(x) = 1\\]
  \\[1-{\\rm tanh}^2(x)={\\rm sech}^2(x)\\]
  \\[{\\rm coth}^2(x)-1={\\rm cosech}^2(x)\\]
  \\[\\sinh(x\\pm y)=\\sinh(x)\\ \\cosh(y)\\ \\pm\\ \\cosh(x)\\ \\sinh(y)\\]
  \\[\\cosh(x\\pm y)=\\cosh(x)\\ \\cosh(y)\\ \\pm\\ \\sinh(x)\\ \\sinh(y)\\]
  \\[\\sinh(2x)=2\\,\\sinh(x)\\cosh(x)\\]
  \\[\\cosh(2x)=\\cosh^2(x)+\\sinh^2(x)\\]
  \\[\\cosh^2(x)={\\cosh(2x)+1\\over 2}\\]
  \\[\\sinh^2(x)={\\cosh(2x)-1\\over 2}\\]';
$string['hyp_identities_name'] = 'Hiperboliese Identiteite';
$string['hyp_inverse_functions_fact'] = '\\[\\cosh^{-1}(x)=\\ln\\left(x+\\sqrt{x^2-1}\\right) \\quad \\mbox{ for } x\\geq 1\\]
 \\[\\sinh^{-1}(x)=\\ln\\left(x+\\sqrt{x^2+1}\\right)\\]
 \\[\\tanh^{-1}(x) = \\frac{1}{2}\\ln\\left({1+x\\over 1-x}\\right) \\quad \\mbox{ for } -1< x < 1\\]';
$string['hyp_inverse_functions_name'] = 'Invershiperboliese Funksies';
$string['illegalcaschars'] = 'Die karakters @, $ en \\ word nie in CAS-toevoer toegelaat nie.';
$string['inputdisplayed'] = 'Vertoon as';
$string['inputentered'] = 'Waarde ingevoer';
$string['inputexpression'] = 'Toets toevoer';
$string['inputextraoptions'] = 'Ekstra opsies';
$string['inputextraoptions_help'] = 'Sommige toevoertipes vereis ekstra opsies om te werk. Jy kan dit hier invoer. Hierdie waarde is \'n CAS-uitdrukking.';
$string['inputextraoptions_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Extra options';
$string['inputheading'] = 'Toevoer: {$a}';
$string['inputinvalidparamater'] = 'Ongeldige parameter';
$string['inputlanguageproblems'] = 'Daar is inkonsekwenthede in die toevoer en validasiemerkers tussen tale.';
$string['inputname'] = 'Toevoernaam';
$string['inputnameform'] = 'Toevoername moet slegs letters wees gevolg deur nommers (opsioneel). \'{$a}\' is onwettig.';
$string['inputnamelength'] = 'Toevoername kan nie langer as 18 karakters wees nie. \'{$a}\' is te lank.';
$string['inputopterr'] = 'Die waarde van die opsie <code>{$a->opt}</code> kan nie gegee word as <code>{$a->val}</code> nie.';
$string['inputoptionunknown'] = 'Hierdie toevoer ondersteun nie die opsie \'{$a}\' nie.';
$string['inputremovedconfirm'] = 'Ek bevestig dat ek die toevoer van hierdie vraag wil verwyder.';
$string['inputremovedconfirmbelow'] = 'Toevoer \'{$a}\' is verwyder. Bevestig dit asseblief hieronder.';
$string['inputs'] = 'Toevoere';
$string['inputstatus'] = 'Status';
$string['inputstatusname'] = 'Blanko';
$string['inputstatusnameinvalid'] = 'Ongeldig';
$string['inputstatusnamescore'] = 'Punt';
$string['inputstatusnamevalid'] = 'Geldig';
$string['inputtest'] = 'Toevoertoets';
$string['inputtype'] = 'Toevoertipe';
$string['inputtype_help'] = 'Dit bepaal die tipe toevoerelement, bv. vormveld, waar/onwaar, teksarea.';
$string['inputtype_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md';
$string['inputtypealgebraic'] = 'Algebraïese toevoer';
$string['inputtypeboolean'] = 'Waar/Onwaar';
$string['inputtypecheckbox'] = 'Merkboks';
$string['inputtypedropdown'] = 'Aftreklys';
$string['inputtypeequiv'] = 'Ekwivalensieredenering';
$string['inputtypematrix'] = 'Matriks';
$string['inputtypenotes'] = 'Notas';
$string['inputtypenumerical'] = 'Numeries';
$string['inputtyperadio'] = 'Radio';
$string['inputtypesinglechar'] = 'Enkelkarakter';
$string['inputtypestring'] = 'String';
$string['inputtypetextarea'] = 'Teksarea';
$string['inputtypeunits'] = 'Eenhede';
$string['inputtypevarmatrix'] = 'Matriks van veranderlike grootte';
$string['inputwillberemoved'] = 'Daar word nie meer na hierdie toevoer in die vraagteks verwys nie. As jy die vraag nou berg, sal die data van hierdie toevoer verlore gaan. Bevestig asseblief dat jy dit wil doen. Alternatiewelik kan jy die vraagteks wysig om die \'[[input:{$a}]]\' en \'[[validation:{$a}]]\' plekhouers terug te sit.';
$string['insertspaces'] = 'Voeg slegs sterre in vir spasies';
$string['insertstars'] = 'Voeg sterre in';
$string['insertstars_help'] = 'Hierdie opsie bied \'n aantal verskillende opsies vir die invoeg van sterre waar vermenigvuldiging geïmpliseer word. Lees asseblief die meer gedetailleerde dokumentasie.';
$string['insertstars_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Insert_Stars';
$string['insertstarsassumesinglechar'] = 'Voeg sterre in met die veronderstelling dat name van veranderlikes met een karakter bestaan';
$string['insertstarsno'] = 'Moet nie sterre invoeg nie';
$string['insertstarsspaces'] = 'Plaas sterre vir geïmpliseerde vermenigvuldiging en vir spasies';
$string['insertstarsspacessinglechar'] = 'Plaas sterre met die veronderstelling van enkelkarakterveranderlikes, geïmpliseer en vir spasies';
$string['insertstarsyes'] = 'Voeg sterre in slegs vir geïmpliseerde vermenigvuldiging';
$string['inversetrig'] = 'Inverstrigonometriese funksies';
$string['inversetrig_help'] = 'Beheer hoe inverstrigonometriese funksies in CAS-afvoer vertoon word.';
$string['inversetrig_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Options.md#inverse_trig';
$string['irred_Q_commonint'] = 'Jy moet \'n gemeenskaplike faktor uithaal.';
$string['irred_Q_factored'] = 'Die term {$a->m0} behoort onbereken te wees, maar is nie.';
$string['irred_Q_optional_fac'] = 'Jy kan meer werk doen, aangesien {$a->m0} verder bereken kan word. Jy hoef dit egter nie te doen nie.';
$string['logicsymbol'] = 'Logiese simbole';
$string['logicsymbol_help'] = 'Beheer hoe logiese simbole in CAS-afvoer vertoon moet word.';
$string['logicsymbol_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Options.md#logicsymbol';
$string['logicsymbollang'] = 'Taal';
$string['logicsymbolsymbol'] = 'Simbolies';
$string['matrixparens'] = 'Verstek vorm van matrikshakies';
$string['matrixparens_help'] = 'Beheer die verstek vorm van matrikshakies wanneer in CAS-afvoer vertoon word.';
$string['matrixparens_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/CAS/Matrix.md#matrixparens';
$string['mbstringrequired'] = 'Installering van die MBSTRING-biblioteek word vir STACK vereis.';
$string['multcross'] = 'Kruis';
$string['multdot'] = 'Punt';
$string['multiplicationsign'] = 'Maalteken';
$string['multiplicationsign_help'] = 'Beheer hoe maaltekens vertoon word.';
$string['multiplicationsign_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Options.md#multiplication';
$string['mustverify'] = 'Student moet bevestig';
$string['mustverify_help'] = 'Spesifiseer of die student se toevoer weer aan hulle as \'n gedwonge tweestapproses vertoon word, voordat hierdie toevoer aan die punttoekenningmeganisme beskikbaar gestel word. Sintaksisfoute word altyd terug gerapporteer.';
$string['mustverify_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Student_must_verify';
$string['mustverifyshowvalidation'] = 'Jy kan nie kies om tweestapbevestiging te vereis, maar nie die uitslae van die validasie ná die eerste stap aan die student te vertoon nie. Dit plaas die student in \'n onmoontlike posisie.';
$string['namealreadyused'] = 'Jy het reeds hierdie naam gebruik.';
$string['newnameforx'] = 'Nuwe naam vir \'{$a}\'';
$string['next'] = 'Volgende';
$string['nextcannotbeself'] = '\'n Nodus kan nie aan homself as die volgende nodus koppel nie.';
$string['nodehelp'] = 'Antwoordboomnodus';
$string['nodehelp_help'] = '### Antwoordtoets
\'n Antwoordtoets word gebruik om twee uitdrukkings te vergelyk om te bepaal of dit aan wiskundige kriteria voldoen.

### SAns
Dit is die eerste argument vir die antwoordtoetsfunksie. In asimmetriese toetse word dit as die "student se antwoord" beskou, alhoewel dit enige geldige CAS-uitdrukking kan wees, en kan afhang van die vraag- of terugvoerveranderlikes.

##TAns
Dit is die tweede argument vir die antwoordtoetsfunksie. In asimmetriese toetse word dit as die "onderwyser se antwoord" beskou, alhoewel dit vir enige geldige CAS-uitdrukking kan wees, en kan afhang van die vraag- of terugvoerveranderlikes.

### Toetsopsies
Hierdie veld stel antwoordtoetse in staat om \'n opsie te aanvaar, bv. \'n veranderlike of numeriese presisie.

### Stil
Wanneer op ja gestel is, word enige terugvoer wat outomaties deur die antwoordtoetse gegenereer is, onderdruk en nie aan die student vertoon nie. Die terugvoervelde in die vertakkings word nie deur hierdie opsie geaffekteer nie.';
$string['nodeloopdetected'] = 'Hierdie skakel skep \'n siklus in hierdie PRT.';
$string['nodenotused'] = 'Geen ander nodusse in die PRT koppel aan hierdie nodus nie.';
$string['nodex'] = 'Nodus {$a}';
$string['nodexdelete'] = 'Wis nodus {$a} uit';
$string['nodexfalsefeedback'] = 'Nodus {$a} onwaar terugvoer';
$string['nodextruefeedback'] = 'Nodus {$a} waar terugvoer';
$string['nodexwhenfalse'] = 'Nodus {$a} wanneer onwaar';
$string['nodexwhentrue'] = 'Nodus {$a} wanneer waar';
$string['nonempty'] = 'Dit moet nie leeg wees nie.';
$string['noprtsifnoinputs'] = '\'n Vraag met geen toevoere kan nie enige PRT\'s hê nie.';
$string['notanswered'] = '(Geen antwoord verskaf nie)';
$string['notavalidname'] = 'Nie \'n geldige naam nie';
$string['notestcasesyet'] = 'Geen toetsgevalle is tot dusver bygevoeg nie.';
$string['numericalinputdp'] = 'Jy moet presies \\( {$a} \\) desimale plekke verskaf.';
$string['numericalinputmaxdp'] = 'Jy moet \'n maksimum van \\( {$a} \\) desimale plekke verskaf.';
$string['numericalinputmaxsf'] = 'Jy moet \'n maksimum van \\( {$a} \\) beduidende figure verskaf.';
$string['numericalinputmindp'] = 'Jy moet minstens \\( {$a} \\) desimale plekke verskaf.';
$string['numericalinputminmaxerr'] = 'Die vereiste minimum aantal numeriese plekke oorskry die maksimum aantal plekke!';
$string['numericalinputminsf'] = 'Jy moet minstens \\( {$a} \\) beduidende figure verskaf.';
$string['numericalinputminsfmaxdperr'] = 'Moet nie vereistes vir beide desimale plekke en beduidende figure in dieselfde afvoer spesifiseer nie.';
$string['numericalinputmustfloat'] = 'Hierdie toevoer verwag \'n wisselpuntgetal.';
$string['numericalinputmustint'] = 'Hierdie toevoer verwag \'n eksplisiete heelgetal.';
$string['numericalinputmustnumber'] = 'Hierdie toevoer verwag \'n getal.';
$string['numericalinputmustrational'] = 'Hierdie toevoer verwag \'n breuk of rasionale getal.';
$string['numericalinputoptboolerr'] = 'Die waarde van die opsie <code>{$a->opt}</code> behoort boolees te wees, maar in werklikheid is dit <code>{$a->val}</code>.';
$string['numericalinputoptinterr'] = 'Die waarde van die opsie <code>{$a->opt}</code> behoort \'n heelgetal te wees, maar in werklikheid is dit <code>{$a->val}</code>.';
$string['numericalinputsf'] = 'Jy moet presies \\( {$a} \\) beduidende figure verskaf.';
$string['numericalinputvarsforbidden'] = 'Hierdie toevoer verwag \'n getal, en mag dus nie veranderlikes bevat nie.';
$string['options'] = 'Opsies';
$string['optionsnotrequired'] = 'Hierdie toevoertipe vereis geen opsies nie.';
$string['overallresult'] = 'Algehele uitslag';
$string['penalty'] = 'Straftoekenning';
$string['penalty_help'] = 'Die straftoekenningskema trek hierdie waarde af van die uitslag van elke PRT vir elke verskillende en geldige poging, wat nie heeltemal korrek is nie.';
$string['penalty_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Feedback.md';
$string['penaltyerror'] = 'Die straftoekenning moet \'n numeriese waarde tussen 0 en 1 wees.';
$string['penaltyerror2'] = 'Die straftoekenning moet leeg wees, of \'n numeriese waarde tussen 0 en 1.';
$string['phpcasstring'] = 'PHP-afvoer';
$string['phpsuitecolerror'] = 'PHP-foute';
$string['phpvalid'] = 'V1';
$string['phpvalidatemismatch'] = '[PHP-validasie mispassing]';
$string['pleaseananswerallparts'] = 'Antwoord asseblief alle dele van die vraag.';
$string['pleasecheckyourinputs'] = 'Verifieer asseblief dat wat jy ingevoer het, na verwagte geïnterpreteer is.';
$string['pluginname'] = 'STACK';
$string['pluginname_help'] = 'STACK is \'n assesseringstelsel vir Wiskunde.';
$string['pluginnameadding'] = '\'n STACK-vraag word bygevoeg';
$string['pluginnameediting'] = '\'n STACK-vraag word gewysig';
$string['pluginnamesummary'] = 'STACK verskaf wiskundige vrae vir die Moodle-vasvra. Dit gebruik \'n rekenaaralgebrastelsel om die wiskundige eienskappe van die student se antwoorde te bepaal.';
$string['privacy:metadata'] = 'Die invoegtoepassing van STACK-vraagtipe berg geen persoonlike data nie.';
$string['prtcorrectfeedback'] = 'Standaard terugvoer vir korrek';
$string['prtheading'] = 'Potensiële antwoordboom: {$a}';
$string['prtincorrectfeedback'] = 'Standaard terugvoer vir verkeerd';
$string['prtmustbesetup'] = 'Hierdie PRT moet opgestel word voordat die vraag geberg kan word.';
$string['prtname'] = 'PRT-naam';
$string['prtnamelength'] = 'PRT-name kan nie langer as 18 karakters wees nie. \'{$a}\' is te lank.';
$string['prtnodesheading'] = 'Potensiële antwoordboomnodusse ({$a})';
$string['prtpartiallycorrectfeedback'] = 'Standaard terugvoer vir gedeeltelik korrek';
$string['prtremovedconfirm'] = 'Ek bevestig dat ek hierdie potensiële antwoordboom uit hierdie vraag wil verwyder.';
$string['prtremovedconfirmbelow'] = 'Potensiële antwoordboom \'{$a}\' is verwyder. Bevestig dit asseblief hieronder.';
$string['prtruntimeerror'] = 'Nodus {$a->node} vir die volgende looptydfout gegenereer: {$a->error}';
$string['prts'] = 'Potensiële antwoordbome';
$string['prtwillbecomeactivewhen'] = 'Hierdie potensiële antwoordboom sal aktief word wanneer die student {$a} beantwoord het';
$string['prtwillberemoved'] = 'Daar word nie meer in die vraagteks of spesifieke terugvoer na hierdie potensiële antwoordboom verwys nie. As jy die vraag nou berg, sal die data van hierdie potensiële antwoordboom verlore gaan. Bevestig asseblief dat jy dit wil doen. Alternatiewelik, wysig die vraagteks of gespesifiseerde terugvoer om die \'[[feedback:{$a}]]\' plekhouer terug te sit.';
$string['qm_error'] = 'Jou antwoord bevat vraagtekenkarakters, ?, wat nie in antwoorde toegelaat word nie. Jy behoort dit met \'n spesifieke waarde te vervang.';
$string['questiondoesnotuserandomisation'] = 'Hierdie vraag gebruik nie verewekansiging nie.';
$string['questionnotdeployedyet'] = 'Geen variante van hierdie vraag is al ontplooi nie.';
$string['questionnote'] = 'Vraagnota';
$string['questionnote_help'] = 'Hierdie vraagnota is CASText. Die doel van \'n vraagnota is om te onderskei tussen lukrake variante van \'n vraag. Twee vraagvariante is slegs gelyk as die vraagnotas gelyk is. In latere analise is dit nuttig om \'n betekenisvolle vraagnota te los.';
$string['questionnote_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Question_note.md';
$string['questionnotempty'] = 'Die vraagnota kan nie leeg wees wanneer rand() in die vraagveranderlikes verskyn nie. Die vraagnota word gebruik om tussen verskillende lukrake variante van die vraag te onderskei.';
$string['questionpreview'] = 'Vraagvoorskou';
$string['questionsimplify'] = 'Vraagvlak vereenvoudig';
$string['questionsimplify_help'] = 'Stel die globale veranderlike "simp" binne Maxima vir die hele vraag.';
$string['questionsimplify_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/CAS/Maxima.md#Simplification';
$string['questiontests'] = 'Vraagtoetse';
$string['questiontestsdefault'] = '(Verstek)';
$string['questiontestsfor'] = 'Vraagtoetse vir plant {$a}';
$string['questiontestspass'] = 'Alle vraagtoetse deurgekom.';
$string['questiontext'] = 'Vraagteks';
$string['questiontext_help'] = 'Die vraag is CASText. Dit is die "vraag" wat die student werklik sien. Jy moet elemente en validasiestringe slegs in hierdie veld invoeg. Byvoorbeeld: deur`[[input:ans1]] [[validation:ans1]]` te gebruik.';
$string['questiontext_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/CASText.md#question_text';
$string['questiontextfeedbacklanguageproblems'] = 'Daar is inkonsekwenthede in die terugvoermerkers tussen tale.';
$string['questiontextfeedbackonlycontain'] = 'Die vraagteks wat met die spesifieke terugvoer gekombineer is, behoort die teken-\'{$a}\' slegs een maal te bevat.';
$string['questiontextmustcontain'] = 'Die vraagteks moet die teken-\'{$a}\' bevat.';
$string['questiontextnonempty'] = 'Die vraagteks mag nie leeg wees nie.';
$string['questiontextonlycontain'] = 'Die vraagteks behoort die teken-\'{$a}\' slegs een maal te bevat.';
$string['questiontextplaceholderswhitespace'] = 'Plekhouers mag nie witspasie bevat nie. Dit kom voor asof hierdie plekhouer witspasie bevat: \'{$a}\'.';
$string['questionvalue'] = 'Vraagwaarde';
$string['questionvaluepostive'] = 'Vraagwaarde mag nie negatief wees nie.';
$string['questionvariables'] = 'Vraagveranderlikes';
$string['questionvariables_help'] = 'Hierdie veld laat jou toe om CAS-veranderlikes te definieer en manipuleer, bv. om lukrake variante te skep. Dit is aan alle ander dele van die vraag beskikbaar.';
$string['questionvariables_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Variables.md#Question_variables';
$string['questionvariablevalues'] = 'Vraagveranderlikewaardes';
$string['quiet'] = 'Stil';
$string['quiet_help'] = 'Wanneer op ja gestel is, word enige terugvoer wat outomaties deur die antwoordtoets gegenereer is, onderdruk en nie aan die student vertoon nie. Die terugvoervelde in die vertakkings word nie deur hierdie opsie geaffekteer nie.';
$string['renamequestionparts'] = 'Herbenoem dele van die vraag';
$string['replacedollarscount'] = 'Hierdie kategorie bevat {$a} STACK-vrae.';
$string['replacedollarserrors'] = 'Die volgende vrae het foute gegenereer.';
$string['replacedollarsin'] = 'Vaste wiskundeskeiers in veld {$a}';
$string['replacedollarsindex'] = 'Kontekste met STACK-vrae';
$string['replacedollarsindexintro'] = 'Deur op enige van die skakels te kliek, word jy na \'n bladsy geneem waar jy die vrae vir ou-styl wiskundeskeiers kan besigtig, en dit outomaties regstel. As jy te veel vrae (duisende) in een konteks het, sal die hoeveelheid afvoer waarskynlik jou webblaaier oorweldig, in welke geval jy \'n preview=0 parameter by die URL kan voeg en weer kan probeer.';
$string['replacedollarsindextitle'] = 'Vervang $\'s in vraagtekste';
$string['replacedollarsnoproblems'] = 'Geen problematiese skeiers is gevind nie.';
$string['replacedollarstitle'] = 'Vervang $\'s in vraagtekste in {$a}';
$string['requiredfield'] = 'Hierdie veld word vereis!';
$string['requirelowestterms'] = 'Vereis laagste terme';
$string['requirelowestterms_help'] = 'Wanneer hierdie opsie op ja gestel is, moet enige koëffisiënte of ander rasionale getalle in \'n uitdrukking in die laagste terme geskryf word. Andersins sal die antwoord as ongeldig verwerp word.';
$string['requirelowestterms_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Require_lowest_terms';
$string['runquestiontests'] = 'Vraagtoetse en ontplooide variante';
$string['runquestiontests_help'] = 'Die vraagtoetseenheid toets die vrae om te verseker dat die gedrag aan die verwagtinge voldoen wat deur die onderwyser gestel is, en ontplooide variante verseker dat lukrake weergawes wat deur \'n student gesien word, vooraf teen die vraagtoetse getoets is. Dit is hulpmiddels om jou te help om betroubare vrae te skep en te toets en behoort in alle gevalle gebruik te word waar \'n vraag deur studente gebruik sal word.';
$string['runtimeerror'] = 'Hierdie vraag het \'n onverwagte interne fout gegenereer. Kry asseblief hulp, bv. van \'n onderwyser.';
$string['runtimefielderr'] = 'Die veld ""{$a->field}"" het die volgende fout gegenereer: {$a->err}';
$string['sans'] = 'SAns';
$string['sans_help'] = 'Dit is die eerste argument vir die antwoordtoetsfunksie. In asimmetriese toetse word dit as die "student se antwoord" beskou, alhoewel dit enige geldige CAS-uitdrukking kan wees en kan afhang van die vraag- of terugvoerveranderlikes.';
$string['sans_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Answer_Tests/index.md';
$string['sansrequired'] = 'SAns moet nie leeg wees nie.';
$string['score'] = 'Punt';
$string['scoreerror'] = 'Die punt moet \'n numeriese waarde tussen 0 en 1 wees.';
$string['scoremode'] = 'Mod';
$string['seedx'] = 'Plant {$a}';
$string['seethisquestioninthequestionbank'] = 'Sien hierdie vraag in die vraagbank';
$string['settingajaxvalidation'] = 'Onmiddellike geldigheidsbepaling';
$string['settingajaxvalidation_desc'] = 'Met hierdie verstelling aan, sal die student se huidige toevoer se geldigheid bepaal word wanneer ook al hulle tydelik ophou tik. Dit verskaf \'n beter gebruikerervaring, maar sal waarskynlik die bedienerlading verhoog.';
$string['settingcasdebugging'] = 'CAS-ontfouting';
$string['settingcasdebugging_desc'] = 'Of ontfoutinginligting oor die CAS-koppeling geberg moet word.';
$string['settingcasmaximaversion'] = 'Maxima-weergawe';
$string['settingcasmaximaversion_desc'] = 'Die weergawe van Maxima wat gebruik word.';
$string['settingcasresultscache'] = 'CAS-uitslagkasberging';
$string['settingcasresultscache_db'] = 'Kas in die databasis';
$string['settingcasresultscache_desc'] = 'Hierdie verstelling bepaal of die oproepe na die CAS gekas word. Hierdie verstelling behoort aangeskakel te wees, tensy jy ontwikkeling doen wat verandering van die Maxima-kode behels. Die huidige toestand van die kas word op die healthcheck-bladsy vertoon. As jy jou verstellings verander, bv. die gnuplot-opdrag, sal jy die kas moet skoonmaak voordat jy die effekte van hierdie veranderinge sal sien.';
$string['settingcasresultscache_none'] = 'Moet nie kas nie';
$string['settingcastimeout'] = 'CAS-koppelingtydafsnyding';
$string['settingcastimeout_desc'] = 'Die tydafsnyding om te gebruik wanneer met Maxima gekoppel probeer word.';
$string['settingdefaultinputoptions'] = 'Verstek toevoeropsies';
$string['settingdefaultinputoptions_desc'] = 'Gebruik wanneer \'n nuwe vraag geskep word, of \'n nuwe toevoer by \'n bestaande vraag gevoeg word.';
$string['settingdefaultquestionoptions'] = 'Verstek toevoeropsies';
$string['settingdefaultquestionoptions_desc'] = 'Gebruik wanneer \'n nuwe vraag geskep word.';
$string['settingmathsdisplay'] = 'Wiskundefilter';
$string['settingmathsdisplay_desc'] = 'Die metode wat gebruik word om Wiskunde te vertoon. As jy MathJax kies, sal jy die aanwysings op die Healthcheck-blad moet volg om dit op te stel. As jy \'n filter kies, moet jy verseker dat die filter op die Bestuur filters-konfigurasieblad ontsper is.';
$string['settingmathsdisplay_mathjax'] = 'MathJax';
$string['settingmathsdisplay_maths'] = 'Ou OU Wiskundefilter';
$string['settingmathsdisplay_oumaths'] = 'Nuwe OU Wiskundefilter';
$string['settingmathsdisplay_tex'] = 'Moodle TeX-filter';
$string['settingmaximalibraries'] = 'Laai opsionele Maxima-biblioteke:';
$string['settingmaximalibraries_desc'] = 'Hierdie is \'n komma-geskeide lys Maxima-biblioteekname wat outomaties in Maxima gelaai sal word. Slegs ondersteunde biblioteekname kan gebruik word: "stats, distrib, descriptive, simplex". Hierdie biblioteke sal nie gelaai word as jy \'n Maxima-prent geberg het om prestasie te optimaliseer nie.';
$string['settingmaximalibraries_error'] = 'Die volgende pakket word nie ondersteun nie: {$a}';
$string['settingmaximalibraries_failed'] = 'Dit kom voor asof sommige van die Maxima-pakette wat jy versoek het, nie gelaai het nie. Verwys asseblief na die installasie-instruksies vir notas oor hierdie fout.';
$string['settingparsercacheinputlength'] = 'Kas geparseerde uitdrukkings langer as';
$string['settingparsercacheinputlength_desc'] = 'Die uitdrukkingontleder word stadig op lang uitdrukkings (byvoorbeeld gekompliseerde vraagveranderlikes. Daarom kas ons die uitslag van parseringuitdrukkings wat langer as hierdie beperking is. Hierdie verstelling behoort verkieslik op \'n waarde gestel te word waar die naslaan van die kas ongeveer so lank duur as om die ontleding te doen. \'n Ingeligte raaiskoot sou 50 karakters wees. Indien op 0 gestel, word die kas versper.';
$string['settingplatformmaximacommand'] = 'Maxima-opdrag';
$string['settingplatformmaximacommand_desc'] = 'Indien leeg, sal STACK \'n ingeligte raaiskoot maak waar om Maxima te vind. As dit misluk, behoort dit op die volledige pad van die Maxima- of Maxima-geoptimaliseerde uitvoerprogram gestel word. Moet nie op \'n produksiestelsel gebruik nie: gebruik geoptimaliseer, of eerder die Maxima Pool-opsie.';
$string['settingplatformmaximacommandopt'] = 'Geoptimaliseerde Maxima-opdrag';
$string['settingplatformmaximacommandopt_desc'] = 'Dit behoort gestel te word op die volledige pad van die Maxima-geoptimaliseerde uitvoerprogram. Oorweeg om die tydafsnydingopdrag op linux-gebaseerde stelsels te gebruik. Bv. tydafsnyding --kill-after=10s 10s maxima';
$string['settingplatformmaximacommandserver'] = 'URL van die Maxima Pool';
$string['settingplatformmaximacommandserver_desc'] = 'Vir Platformtipe: Bediener, dit moet op die URL van die Maxima Pool-bedienertjie gestel wees.';
$string['settingplatformplotcommand'] = 'Stip opdrag';
$string['settingplatformplotcommand_desc'] = 'Dit kan gewoonlik leeg gelaat word, maar indien grafiekstipwerk nie werk nie, kan dit nodig wees om die volledige pad na die gnuplot-opdrag hier te verskaf.';
$string['settingplatformtype'] = 'Platformtipe';
$string['settingplatformtype_desc'] = 'STACK moet weet op watter soort bedryfstelsel dit loop. Die "Bediener"-opsie verskaf beter prestasie ten koste daarvan om \'n addisionele bediener op te stel. Die opsie "Linux (geoptimaliseer)" word in die Optimalisering van Maxima-blad in die dokumentasie verduidelik.';
$string['settingplatformtypelinux'] = 'Linux';
$string['settingplatformtypelinuxoptimised'] = 'Linux (geoptimaliseer)';
$string['settingplatformtypeserver'] = 'Bediener';
$string['settingplatformtypewin'] = 'Windows';
$string['settingreplacedollars'] = 'Vervang <code>$</code> en <code>$$</code>';
$string['settingreplacedollars_desc'] = 'Vervang <code>$...$</code> en <code>$$...$$</code> skeiers in vraagteks, saam met <code>\\\\[...\\\\]</code> en <code>\\\\(...\\\\)</code>. \'n Beter opsie is om die \'Stel wiskundeskeiers vas\'-teks te gebruik, waarna daar hieronder verwys word.';
$string['settingserveruserpass'] = 'Bediener gebruikernaam:wagwoord';
$string['settingserveruserpass_desc'] = 'As jy Platformtipe gebruik: Bediener, en as jy jou Maxima Pool-bediener met HTTP-geldigheidsvasstelling opgestel het, sit jy die gebruikernaam en wagwoord hier. Dit is ietwat veiliger as om dit in die URL te sit. Die formaat is  gebruikernaam:wagwoord.';
$string['settingsmathsdisplayheading'] = 'Wiskunde vertoonopsies';
$string['settingsmaximasettings'] = 'Koppel aan Maxima';
$string['settingusefullinks'] = 'Nuttige skakels';
$string['showingundeployedvariant'] = 'Onontplooide variant word vertoon: {$a}';
$string['showvalidation'] = 'Vertoon die validasie';
$string['showvalidation_help'] = 'Vertoon enige validasieterugvoer uit hierdie toevoer, insluitende die terugeggo van hul uitdrukking in tradisionele tweedimensionele notasie. Sintaksisfoute word altyd teruggerapporteer.';
$string['showvalidation_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Show_validation';
$string['showvalidationcompact'] = 'Ja, kompakteer';
$string['showvalidationno'] = 'Nee';
$string['showvalidationyes'] = 'Ja, met veranderlikelys';
$string['showvalidationyesnovars'] = 'Ja, sonder veranderlikelys';
$string['singlechargotmorethanone'] = 'Jy kan slegs een karakter hier invoer.';
$string['specificfeedback'] = 'Spesifieke terugvoer';
$string['specificfeedback_help'] = 'By verstek sal terugvoer vir elke potensiële antwoordboom in hierdie blok vertoon word. Dit kan na die vraagteks geskuif word, in welke geval Moodle minder beheer sal hê oor wanneer dit deur verskillende gedrag vertoon word. Let wel: hierdie blok is nie CASText nie.';
$string['sqrtsign'] = 'Wortelvorm vir vierkantswortel';
$string['sqrtsign_help'] = 'Beheer hoe wortelvorms vertoon word.';
$string['sqrtsign_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Options.md#surd';
$string['stack:usediagnostictools'] = 'Gebruik die STACK-hulpmiddels';
$string['stackBlock_elif_after_else'] = '"elif" ná \'n "anders" in \'n as-blok.';
$string['stackBlock_elif_out_of_an_if'] = '"elif" kan nie buite \'n as-blok bestaan nie.';
$string['stackBlock_else_out_of_an_if'] = '"anders" kan nie buite \'n as-blok bestaan nie.';
$string['stackBlock_escapeNeedsValue'] = 'Ontsnap-blok vereis \'n waardetoekenning.';
$string['stackBlock_ifNeedsCondition'] = 'As-blok vereis \'n toetstoekenning.';
$string['stackBlock_jsxgraph_height'] = 'Die hoogte van \'n JSXGraph moet \'n bekende CSS-lengte-eenheid gebruik.';
$string['stackBlock_jsxgraph_height_num'] = 'Die numeriese porsie van die hoogte van \'n KSXGraph moet \'n onverwerkte getal wees en nie enige ekstra karakters bevat nie.';
$string['stackBlock_jsxgraph_param'] = 'Die JSXGraph-blok ondersteun slegs hierdie parameters in hierdie konteks: {$a->param}.';
$string['stackBlock_jsxgraph_ref'] = 'Die jsxgraph-blok ondersteun slegs verwysingtoevoere wat in dieselfde CASText-afdeling teenwoordig is. \'{$a->var}\' bestaan nie hier nie.';
$string['stackBlock_jsxgraph_width'] = 'Die breedte van \'n JSXGraph moet \'n bekende CSS-lengte-eenheid wees.';
$string['stackBlock_jsxgraph_width_num'] = 'Die numeriese deel van die breedte van \'n JSXGraph moet \'n onverwerkte getal wees en nie enige ekstra karakters bevat nie.';
$string['stackBlock_missmatch'] = 'stem met niks ooreen nie.';
$string['stackBlock_multiple_else'] = 'Veelvuldige anders-vertakkings in \'n as-blok.';
$string['stackBlock_unknownBlock'] = 'Die volgende blok is onbekend:';
$string['stackCas_CASError'] = 'Die CAS het die volgende fout(e) teruggestuur:';
$string['stackCas_CASErrorCaused'] = 'het die volgende fout veroorsaak:';
$string['stackCas_MissingAt'] = 'Jy kort \'n <code>@</code> teken.';
$string['stackCas_MissingCloseDisplay'] = 'Ontbrekende <code>\\]</code>.';
$string['stackCas_MissingCloseHTML'] = 'Ontbrekende sluit-html-merker.';
$string['stackCas_MissingCloseInline'] = 'Ontbrekende <code>\\)</code>.';
$string['stackCas_MissingClosingRawCAS'] = 'Ontbrekende <code>#}</code>.';
$string['stackCas_MissingClosingTeXCAS'] = 'Ontbrekende <code>@}</code>.';
$string['stackCas_MissingDollar'] = 'Jy kort \'n <code>$</code> teken.';
$string['stackCas_MissingOpenDisplay'] = 'Ontbrekende <code>\\[</code>.';
$string['stackCas_MissingOpenHTML'] = 'Ontbrekende opening-html-merker.';
$string['stackCas_MissingOpenInline'] = 'Ontbrekende <code>\\(</code>.';
$string['stackCas_MissingOpenRawCAS'] = 'Ontbrekende <code>{#</code>.';
$string['stackCas_MissingOpenTeXCAS'] = 'Ontbrekende <code>{@</code>.';
$string['stackCas_MissingStars'] = 'Dit lyk asof jy * karakters kort. Jy wou moontlik {$a->cmd} tik.';
$string['stackCas_MissingString'] = 'Jy kort \'n aanhalingsteken <code>"</code>.';
$string['stackCas_StringOperation'] = 'Dit lyk asof \'n string op die verkeerde plek is. Hier is die probleem: <code>{$a->issue}</code>.';
$string['stackCas_allFailed'] = 'CAS het geen geëvalueerde uitdrukkings teruggestuur nie. Kontroleer asseblief jou koppeling met die CAS.';
$string['stackCas_apostrophe'] = 'Afkappingstekens word nie in antwoorde toegelaat nie.';
$string['stackCas_applyingnonobviousfunction'] = 'Hierdie funksie-oproep {$a->problem} lyk nie asof dit \'n maklik sigbare funksienaam het nie. Weens sekuriteitsredes kan dit nodig wees dat jy die oproep vereenvoudig, sodat die bekragtiger die funksienaam kan sien.';
$string['stackCas_backward_inequalities'] = 'Nie-streng ongelykhede, bv. \\( \\leq \\) of \\( \\geq \\) moet ingevoer word as <= of >=. Jy het {$a->cmd} in jou uitdrukking, wat agterstevoor is.';
$string['stackCas_badLogIn'] = 'Jy het die uitdrukking <tt>In</tt> getik. Die natuurlike logaritme word as <tt>ln</tt> in kleinletters ingevoer. ("Lima November" nie "India November")';
$string['stackCas_badpostfixop'] = 'Jy het \'n slegte "agtervoeg" operateur in jou uitdrukking.';
$string['stackCas_bracketsdontmatch'] = 'Die hakies is verkeerd in die uitdrukking: {$a->cmd} genes.';
$string['stackCas_callingasfunction'] = 'Die oproep van die uitslag van \'n funksie-oproep is verbode {$a->problem}, lambdas word steeds toegelaat.';
$string['stackCas_chained_inequalities'] = 'Dit lyk asof jy "gekettingde ongelykhede" het, bv. \\(a &lt b &lt c\\). Jy moet individuele ongelykhede met logiese operasies soos \\(and\\) of \\(or\\) koppel.';
$string['stackCas_errorpos'] = 'By ongeveer-lyn {$a->line} karakter {$a->col}.';
$string['stackCas_failedReturn'] = 'CAS het geen data teruggestuur nie.';
$string['stackCas_failedReturnOne'] = 'CAS het sommige data nie teruggestuur nie.';
$string['stackCas_failedValidation'] = 'CASText-validasie het misluk.';
$string['stackCas_finalChar'] = '\'{$a->char}\' is \'n ongeldige finale karakter in {$a->cmd}';
$string['stackCas_forbiddenChar'] = 'CAS-opdragte mag nie die volgende karakters bevat nie: {$a->char}.';
$string['stackCas_forbiddenFunction'] = 'Verbode funksie: {$a->forbid}.';
$string['stackCas_forbiddenOperator'] = 'Verbode operateur: {$a->forbid}.';
$string['stackCas_forbiddenVariable'] = 'Verbode veranderlike of konstante: {$a->forbid}.';
$string['stackCas_forbiddenWord'] = 'Die uitdrukking {$a->forbid} word verbied.';
$string['stackCas_inputsdefined'] = 'Jy mag nie toevoername as veranderlikes gebruik nie. Jy het <code>{$a}</code> probeer definieer.';
$string['stackCas_invalidCommand'] = 'CAS-opdragte nie geldig nie.';
$string['stackCas_missingLeftBracket'] = 'Jy het \'n ontbrekende linkerhakie <span class="stacksyntaxexample">{$a->bracket}</span> in die uitdrukking: {$a->cmd}.';
$string['stackCas_missingRightBracket'] = 'Jy het \'n ontbrekende regterhakie <span class="stacksyntaxexample">{$a->bracket}</span> in die uitdrukking: {$a->cmd}.';
$string['stackCas_newline'] = 'Newline-karakters word nie in antwoorde toegelaat nie.';
$string['stackCas_noFunction'] = 'Die gebruik van die funksie {$a->forbid} in die term {$a->term} word nie in hierdie konteks toegelaat nie.';
$string['stackCas_operatorAsVariable'] = 'Operateur {$a->op} as veranderlike geïnterpreteer, kontroleer sintaksis.';
$string['stackCas_percent'] = '% in uitdrukking {$a->expr} gevind.';
$string['stackCas_qmarkoperators'] = 'Vraagtekens word nie in antwoorde toegelaat nie.';
$string['stackCas_redefinitionOfConstant'] = 'Herdefinisie van sleutelbeperkings is verbode: {$a->constant}.';
$string['stackCas_spaces'] = 'Onwettige spasies in uitdrukking {$a->expr} gevind.';
$string['stackCas_spuriousop'] = 'Onbekende operateur: {$a->cmd}.';
$string['stackCas_trigexp'] = 'Jy kan nie \'n mag van \'n trig-funksie neem deur {$a->forbid} te skryf nie. Die vierkant van die waarde van \\(\\{$a->identifier}(x)\\) word ingetik as <tt>{$a->identifier}(x)^2</tt>. Die inverse van \\(\\{$a->identifier}(x)\\) word geskryf as <tt>a{$a->identifier}(x)</tt> en nie \\(\\{$a->identifier}^{-1}(x)\\) nie.';
$string['stackCas_triginv'] = 'Inverse trig-funksies word geskryf {$a->goodinv} nie as {$a->badinv} nie.';
$string['stackCas_trigop'] = 'Jy moet {$a->trig} op \'n argument toepas. Dit lyk asof jy {$a->forbid} het, wat lyk asof jy {$a->trig} as veranderlikenaam probeer gebruik het.';
$string['stackCas_trigparens'] = 'Wanneer jy \'n trig-funksie op sy argumente toepas, moet jy ronde hakies en nie blokhakies gebruik nie. Bv. {$a->forbid}.';
$string['stackCas_trigspace'] = 'Om \'n trig-funksie op sy argumente toe te pas, moet jy hakies en nie spasies gebruik. Byvoorbeeld: gebruik eerder {$a->trig}.';
$string['stackCas_underscores'] = 'Die volgende gebruik van onderstreepkarakters word nie toegelaat nie: {$a}';
$string['stackCas_unencpsulated_comma'] = '\'n Komma in jou uitdrukking kom vreemd voor. Kommas word gebruik om items in lyste, stelle, ens. te skei. Jy moet \'n desimale punt en nie \'n komma in wisselpuntgetalle gebruik.';
$string['stackCas_unitssynonym'] = 'Dit lyk asof jy eenhede {$a->forbid} gebruik het. Het jy {$a->unit} bedoel?';
$string['stackCas_unknownFunction'] = 'Onbekende funksie: {$a->forbid} in die term {$a->term}.';
$string['stackCas_unknownFunctionCase'] = 'Toevoer is kassensitief: {$a->forbid} is \'n onbekende funksie. Het jy {$a->lower} bedoel?';
$string['stackCas_unknownUnitsCase'] = 'Toevoer van eenhede is kassensitief: {$a->forbid} is \'n onbekende eenheid. Het jy een uit die volgende lys bedoel: {$a->unit}';
$string['stackCas_unknownVariableCase'] = 'Toevoer is kassensitief: {$a->forbid} is \'n onbekende veranderlike. Het jy {$a->lower} bedoel?';
$string['stackCas_unsupportedKeyword'] = 'Nie-ondersteunde sleutelwoord: {$a->forbid}.';
$string['stackCas_useinsteadChar'] = 'Vervang asseblief <span class="stacksyntaxexample">{$a->bad}</span> met \'<span class="stacksyntaxexample">{$a->char}</span>\'.';
$string['stackDoc_404'] = 'Fout 404';
$string['stackDoc_404message'] = 'Dokument nie gevind nie.';
$string['stackDoc_directoryStructure'] = 'Gidsstruktuur';
$string['stackDoc_docs'] = 'STACK-dokumentasie';
$string['stackDoc_docs_desc'] = '<a href="{$a->link}">Dokumentasie vir STACK</a>: \'n plaaslike statiese wiki.';
$string['stackDoc_home'] = 'Dokumentasie tuis';
$string['stackDoc_index'] = 'Kategorie-indeks';
$string['stackDoc_siteMap'] = 'Werfkaart';
$string['stackDoc_siteMap_en'] = 'Engelse werfkaart';
$string['stackDoc_version'] = 'Jou werf loop STACK-weergawe {$a}.';
$string['stackHintOld'] = 'Die CASText bevat ou-styl wenkmerkers. Dit behoort nou in die volgende vorm te wees: <pre>[[facts:tag]]</pre>';
$string['stackInstall_input_intro'] = 'Hierdie blad laat jou toe om te toets hoe STACK verskillende toevoere van \'n student interpreteer. Dit kontroleer tans slegs met die mees liberale verstellings, probeer \'n informele sintaksis aanneem en plaas sterre. <br />\'V\' kolomme teken geldigheid aan soos beoordeeel deur PHP en die CAS. V1 = PHP geldig, V2 = CAS geldig.';
$string['stackInstall_input_title'] = '\'n Toetssuite vir validasie van student se toevoer';
$string['stackInstall_input_title_desc'] = 'Die <a href="{$a->link}">toevoertoetsteks</a> verskaf toetsgevalle van jou STACK wiskundige uitdrukkings interpreteer. Dit is ook nuttig om deur voorbeeld te leer.';
$string['stackInstall_replace_dollars_desc'] = 'Die <a href="{$a->link}">herstel wiskundeskeierteks</a> kan gebruik word om ou-styl skeiers, soos <code>@...@</code>, <code>$...$</code> en <code>$$...$$</code> in jou vrae te vervang met die nuwe aanbevole <code>{@...@}</code>, <code>\\(...\\)</code> en <code>\\[...\\]</code>.';
$string['stackInstall_testsuite_choose'] = 'Kies asseblief \'n antwoordtoets.';
$string['stackInstall_testsuite_errors'] = 'Hierdie vraag het met looptyd die volgende foute gegenereer.';
$string['stackInstall_testsuite_fail'] = 'Nie alle toetse is geslaag nie!';
$string['stackInstall_testsuite_failingtests'] = 'Toetse wat misluk het';
$string['stackInstall_testsuite_failingupgrades'] = 'Vrae wat tydens bywerking misluk het.';
$string['stackInstall_testsuite_intro'] = 'Hierdie bladsy laat jou toe om te toets of die STACK-antwoordtoetse korrek funksioneer. Let daarop dat slegs antwoordtoetse deur die webkoppelvlak gekontroleer kan word. Ander Maxima-opdragte moet uit die opdraglyn gekontroleer word: sien unittests.mac.';
$string['stackInstall_testsuite_nodeployedseeds'] = 'Vrae met lukrake variante, maar geen ontplooide plante nie';
$string['stackInstall_testsuite_nogeneralfeedback'] = 'Vrae met geen algemene terugvoer nie: studente waardeer werklik berekende oplossings!';
$string['stackInstall_testsuite_notests'] = 'Vrae met geen toetse nie: voeg asseblief daarvan in!';
$string['stackInstall_testsuite_pass'] = 'Alle toetse is geslaag!';
$string['stackInstall_testsuite_title'] = '\'n Toetssuite vir STACK-Antwoordtoetse';
$string['stackInstall_testsuite_title_desc'] = 'Die <a href="{$a->link}">antwoordtoetseteks</a> verfieer dat die antwoordtoetse korrek presteer. Hulle is ook nuttig om byvoorbeeld te leer hoe elke antwoordtoets gebruik kan word.';
$string['stackOptions_AnsTest_values_AlgEquiv'] = 'AlgEquiv';
$string['stackOptions_AnsTest_values_AlgEquivNouns'] = 'AlgEquivNouns';
$string['stackOptions_AnsTest_values_CasEqual'] = 'CasEqual';
$string['stackOptions_AnsTest_values_CompSquare'] = 'CompletedSquare';
$string['stackOptions_AnsTest_values_Diff'] = 'Diff';
$string['stackOptions_AnsTest_values_EqualComAss'] = 'EqualComAss';
$string['stackOptions_AnsTest_values_Equiv'] = 'EquivReasoning';
$string['stackOptions_AnsTest_values_EquivFirst'] = 'EquivFirst';
$string['stackOptions_AnsTest_values_Expanded'] = 'Uitgebrei';
$string['stackOptions_AnsTest_values_FacForm'] = 'FacForm';
$string['stackOptions_AnsTest_values_GT'] = 'Num-GT';
$string['stackOptions_AnsTest_values_GTE'] = 'Num-GTE';
$string['stackOptions_AnsTest_values_Int'] = 'Int';
$string['stackOptions_AnsTest_values_LowestTerms'] = 'LowestTerms';
$string['stackOptions_AnsTest_values_NumAbsolute'] = 'NumAbsolute';
$string['stackOptions_AnsTest_values_NumDecPlaces'] = 'NumDecPlaces';
$string['stackOptions_AnsTest_values_NumDecPlacesWrong'] = 'NumDecPlacesWrong';
$string['stackOptions_AnsTest_values_NumRelative'] = 'NumRelative';
$string['stackOptions_AnsTest_values_NumSigFigs'] = 'NumSigFigs';
$string['stackOptions_AnsTest_values_PartFrac'] = 'PartFrac';
$string['stackOptions_AnsTest_values_PropLogic'] = 'PropositionalLogic';
$string['stackOptions_AnsTest_values_SRegExp'] = 'SRegExp';
$string['stackOptions_AnsTest_values_SameType'] = 'SameType';
$string['stackOptions_AnsTest_values_Sets'] = 'Stelle';
$string['stackOptions_AnsTest_values_SigFigsStrict'] = 'SigFigsStrict';
$string['stackOptions_AnsTest_values_SingleFrac'] = 'SingleFrac';
$string['stackOptions_AnsTest_values_String'] = 'String';
$string['stackOptions_AnsTest_values_StringSloppy'] = 'StringSloppy';
$string['stackOptions_AnsTest_values_SubstEquiv'] = 'SubstEquiv';
$string['stackOptions_AnsTest_values_SysEquiv'] = 'SysEquiv';
$string['stackOptions_AnsTest_values_UnitsAbsolute'] = 'UnitsAbsolute';
$string['stackOptions_AnsTest_values_UnitsRelative'] = 'UnitsRelative';
$string['stackOptions_AnsTest_values_UnitsSigFigs'] = 'UnitsSigFigs';
$string['stackOptions_AnsTest_values_UnitsStrictAbsolute'] = 'UnitsStrictAbsolute';
$string['stackOptions_AnsTest_values_UnitsStrictRelative'] = 'UnitsStrictRelative';
$string['stackOptions_AnsTest_values_UnitsStrictSigFigs'] = 'UnitsStrictSigFigs';
$string['stackQuestion_noQuestionParts'] = 'Hierdie item het geen vraagdele vir jou om te beantwoord nie.';
$string['stackversionedited'] = 'Hierdie vraag is geskryf met STACK-weergawe {$a}.';
$string['stackversionerror'] = 'Hierdie vraag gebruik {$a->pat} in die {$a->qfield}, wat in STACK-weergawe {$a->ver} verander het en nie meer ondersteun word nie.';
$string['stackversionerroralt'] = '\'n Alternatief is {$a}.';
$string['stackversionmulerror'] = 'Hierdie vraag het \'n toevoer wat die "mul" opsie gebruik, wat nie ná STACK-weergawe 4.2 ondersteun word nie. Wysig asseblief hierdie vraag.';
$string['stackversionnone'] = 'Hierdie vraag is nie gewysig sedert vraagvariantnommering in STACK 4.2 bekendgestel is nie. Hersien asseblief jou vraag noukeurig.';
$string['stackversionnow'] = 'Die huidige weergawe van STACK is {$a}.';
$string['stackversionregexp'] = 'Die RegExp-antwoordtoets word nie ná STACK-weergawe 4.3 ondersteun nie. Gebruik asseblief eerder die nuwe SRegExp.';
$string['stop'] = '[stop]';
$string['strictsyntax'] = 'Streng sintaksis';
$string['strictsyntax_help'] = 'Hierdie opsie word nie meer gebruik nie en sal verwyder word.';
$string['strictsyntax_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/';
$string['strlengtherror'] = 'Hierdie string mag nie 255 karakters in lengte oorskry nie.';
$string['studentValidation_invalidAnswer'] = 'Hierdie antwoord is ongeldig.';
$string['studentValidation_listofunits'] = 'Die eenhede wat in jou antwoord gevind is, was: {$a}';
$string['studentValidation_listofvariables'] = 'Die veranderlikes wat in jou antwoord gevind is, was: {$a}';
$string['studentValidation_notes'] = '(Hierdie toevoer word nie outomaties deur STACK geassesseer nie.)';
$string['studentValidation_yourLastAnswer'] = 'Jou laaste antwoord is soos volg geïnterpreteer: {$a}';
$string['studentanswer'] = 'Studentantwoord';
$string['switchtovariant'] = 'Skakel na arbitrêre variant';
$string['symbolicprtcorrectfeedback'] = '<span style="font-size: 1.5em; color:green;"><i class="fa fa-check"></i></span>';
$string['symbolicprtincorrectfeedback'] = '<span style="font-size: 1.5em; color:red;"><i class="fa fa-times"></i></span>';
$string['symbolicprtpartiallycorrectfeedback'] = '<span style="font-size: 1.5em; color:orange;"><i class="fa fa-adjust"></i></span>';
$string['syntaxattribute'] = 'Wenkeienskap';
$string['syntaxattribute_help'] = 'Die sintaksiswenk sal as \'n wysigbare *waarde* of niewysigbare *plekhouer* verskyn.';
$string['syntaxattribute_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Syntax_Hint';
$string['syntaxattributeplaceholder'] = 'Plekhouer';
$string['syntaxattributevalue'] = 'Waarde';
$string['syntaxhint'] = 'Sintaksiswenk';
$string['syntaxhint_help'] = 'Die sintaksiswenk sal in die antwoordboks verskyn wanneer dit deur die student leeg gelaat word.';
$string['syntaxhint_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Syntax_Hint';
$string['tans'] = 'TAns';
$string['tans_help'] = 'Dit is die tweede argument tot die antwoordtoetsfunksie. In asimmetriese toetse word dit as die "onderwyser se antwoord" beskou, alhoewel dit enige geldige CAS-uitdrukking kan wees, en kan afhang van die vraag- of terugvoerveranderlikes.';
$string['tans_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Answer_Tests/index.md';
$string['tansrequired'] = 'TAns moet nie leeg wees nie.';
$string['teacheranswer'] = 'Onderwyserantwoord';
$string['teacheranswercase'] = 'Gebruik die onderwyser se antwoord as toetsgeval';
$string['teacheranswerempty'] = 'Hierdie toevoer kan leeg gelaat word.';
$string['teacheranswershow'] = '\'n Korrekte antwoord is \\( {$a->display} \\), wat soos volg ingetik kan word: {$a->value}';
$string['teacheranswershow_disp'] = '\'n Korrekte antwoord is {$a->display}.';
$string['teacheranswershow_mcq'] = '\'n Korrekte antwoord is: {$a->display}.';
$string['teacheranswershownotes'] = '\'n Korrekte antwoord word nie vir hierdie toevoer verskaf nie.';
$string['teachersanswer'] = 'Modelantwoord';
$string['teachersanswer_help'] = 'Die onderwyser moet \'n modelantwoord vir elke toevoer spesifiseer. Dit moet \'n geldige Maxima-string wees, en kan uit die vraagveranderlikes gevorm word.';
$string['teachersanswer_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#model_answer';
$string['testcasexresult'] = 'Toetsgeval {$a->no} {$a->result}';
$string['testingquestion'] = 'Vraag {$a} word getoets';
$string['testingquestionvariants'] = 'Vraagvariante word voorberei';
$string['testinputs'] = 'Toetstoevoere';
$string['testinputsimpwarning'] = 'Let asseblief daarop dat toetstoevoere altyd <em>onvereenvoudig</em> is, ongeag die vraag of PRT-opsieverstelling. Gebruik asseblief <tt>ev(...,simp)</tt> om \'n gedeelte of die hele toetstoevoeruitdrukkings te vereenvoudig.';
$string['testoptions'] = 'Toetsopsies';
$string['testoptions_help'] = 'Hierdie veld ontsper antwoordtoetse om \'n opsie te aanvaar, bv. \'n veranderlike of numeriese presisie.';
$string['testoptions_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Potential_response_trees.md';
$string['testoptionsinvalid'] = 'Die toetsopsies is ongeldig: {$a}';
$string['testoptionsrequired'] = 'Toetsopsies word vir hierdie toets vereis.';
$string['testpassesandfails'] = '{$a->passes} slaag en {$a->fails} druip.';
$string['testsuitecolerror'] = 'CAS-foute';
$string['testsuitecolpassed'] = 'Geslaag?';
$string['testsuitefail'] = 'Druip';
$string['testsuitefeedback'] = 'Terugvoer';
$string['testsuiteknownfail'] = 'Verwagte mislukking';
$string['testsuiteknownfailmaths'] = 'Verwagte mislukking (Wiskunde)';
$string['testsuitenotests'] = 'Aantal toetse: {$a->no}.';
$string['testsuitepass'] = 'Slaag';
$string['testsuiteteststook'] = 'Toets het {$a->time} geneem.';
$string['testsuiteteststookeach'] = 'Gemiddeld per toets: {$a->time} sekondes';
$string['testthisvariant'] = 'Verander om hierdie variant te toets';
$string['texdisplaystyle'] = 'Vertoon-styl vergelyking';
$string['texinlinestyle'] = 'Inlyn-styl vergelyking';
$string['tidyquestion'] = 'Maak STACK-vraaghulpmiddel skoon';
$string['tidyquestionx'] = 'Herbenoem die dele van vraag {$a}';
$string['trig_degrees_radians_fact'] = '\\[
360^\\circ= 2\\pi \\hbox{ radians},\\quad
1^\\circ={2\\pi\\over 360}={\\pi\\over 180}\\hbox{ radians}
\\]
\\[
1 \\hbox{ radian} = {180\\over \\pi} \\hbox{ degrees}
\\approx 57.3^\\circ
\\]';
$string['trig_degrees_radians_name'] = 'Grade en Radiale';
$string['trig_standard_identities_fact'] = '\\[\\sin(a\\pm b)\\ = \\  \\sin(a)\\cos(b)\\ \\pm\\  \\cos(a)\\sin(b)\\]
 \\[\\cos(a\\ \\pm\\ b)\\ = \\  \\cos(a)\\cos(b)\\ \\mp \\sin(a)\\sin(b)\\]
 \\[\\tan (a\\ \\pm\\ b)\\ = \\  {\\tan (a)\\ \\pm\\ \\tan (b)\\over1\\ \\mp\\ \\tan (a)\\tan (b)}\\]
 \\[ 2\\sin(a)\\cos(b)\\ = \\  \\sin(a+b)\\ +\\ \\sin(a-b)\\]
 \\[ 2\\cos(a)\\cos(b)\\ = \\  \\cos(a-b)\\ +\\ \\cos(a+b)\\]
 \\[ 2\\sin(a)\\sin(b) \\ = \\  \\cos(a-b)\\ -\\ \\cos(a+b)\\]
 \\[ \\sin^2(a)+\\cos^2(a)\\ = \\  1\\]
 \\[ 1+{\\rm cot}^2(a)\\ = \\  {\\rm cosec}^2(a),\\quad \\tan^2(a) +1 \\ = \\  \\sec^2(a)\\]
 \\[ \\cos(2a)\\ = \\  \\cos^2(a)-\\sin^2(a)\\ = \\  2\\cos^2(a)-1\\ = \\  1-2\\sin^2(a)\\]
 \\[ \\sin(2a)\\ = \\  2\\sin(a)\\cos(a)\\]
 \\[ \\sin^2(a) \\ = \\  {1-\\cos (2a)\\over 2}, \\qquad \\cos^2(a)\\ = \\  {1+\\cos(2a)\\over 2}\\]';
$string['trig_standard_identities_name'] = 'Standaard Trigonometriese Identiteite';
$string['trig_standard_values_fact'] = '\\[\\sin(45^\\circ)={1\\over \\sqrt{2}}, \\qquad \\cos(45^\\circ) = {1\\over \\sqrt{2}},\\qquad
\\tan( 45^\\circ)=1
\\]
\\[
\\sin (30^\\circ)={1\\over 2}, \\qquad \\cos (30^\\circ)={\\sqrt{3}\\over 2},\\qquad
\\tan (30^\\circ)={1\\over \\sqrt{3}}
\\]
\\[
\\sin (60^\\circ)={\\sqrt{3}\\over 2}, \\qquad \\cos (60^\\circ)={1\\over 2},\\qquad
\\tan (60^\\circ)={ \\sqrt{3}}
\\]';
$string['trig_standard_values_name'] = 'Standaard Trigonometriese Waardes';
$string['true'] = 'Waar';
$string['truebranch'] = 'Ware vertakking';
$string['truebranch_help'] = 'Hierdie velde beheer wat gebeur wanneer die antwoordtoets slaag
### Mod en punt
Hoe die punt aangepas word. = beteken om die punt volgens \'n spesifieke waarde te stel, +/- beteken tel by of trek die gegewe punt van die huidige totaal af.

### Straftoekenning
In aanpassende of interaktiewe modus, voeg soveel straftoekenning by.

### Volgende
Of daar na \'n ander nodus gegaan moet word, en indien wel, watter een, of stop.

### Antwoordnota
Hierdie is \'n merker wat belangrik is vir verslagdoeningsdoeleindes. Dit is ontwerp om die unieke pad deur die boom aan te teken, asook die uitkoms van elke antwoordtoets. Dit word outomaties gegenereer, maar kan na iets betekenisvol verander word.';
$string['undeploy'] = 'On-ontplooi';
$string['unrecognisedfactstags'] = 'Die volgende feitmerker(s) word nie herken nie: {$a->tags}.';
$string['variant'] = 'Variant';
$string['variantsselectionseed'] = 'Lukrake groep';
$string['variantsselectionseed_help'] = 'Gewoonlik kan jy hierdie boks leeg laat. Indien jy egter twee verskillende vrae in \'n vasvra dieselfde lukrake plant wil laat gebruik, tik dieselfde string in hierdie boks vir die twee vrae (en ontplooi dieselfde stel lukrake plante, as jy ontplooide variante gebruik) en die lukrake plante vir die twee vrae sal gesinchroniseer word.';
$string['verifyquestionandupdate'] = 'Verifieer die vraagteks en werk die vorm by';
$string['yamlrecommended'] = 'Om die YAML-biblioteek te installeer, word vir STACK aanbeveel.';
$string['youmustconfirm'] = 'Jy moet hier bevestig.';
