<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'competency', language 'nl', version '4.3'.
 *
 * @package     competency
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['allchildrenarecomplete'] = 'Alle onderliggende zijn volledig';
$string['competencies'] = 'Competenties';
$string['competenciesarenotenabled'] = 'Competenties zijn niet ingesteld.';
$string['competenciessettings'] = 'Competentie-instellingen';
$string['completeplanstask'] = 'Voltooi studieplannen met einddatum';
$string['coursecompetencyoutcome_complete'] = 'Voltooi competentie';
$string['coursecompetencyoutcome_evidence'] = 'Bewijs toevoegen';
$string['coursecompetencyoutcome_none'] = 'Doe niets';
$string['coursecompetencyoutcome_recommend'] = 'Insturen voor beoordeling';
$string['coursemodulecompetencyoutcome_complete'] = 'Voltooi competentie';
$string['coursemodulecompetencyoutcome_evidence'] = 'Bewijs toevoegen';
$string['coursemodulecompetencyoutcome_none'] = 'Doe niets';
$string['coursemodulecompetencyoutcome_recommend'] = 'Insturen voor beoordeling';
$string['deletecompetencyratings'] = 'Verwijder competentiewaarderingen';
$string['duplicateditemname'] = '{$a} (kopie)';
$string['enablecompetencies'] = 'Competenties inschakelen';
$string['enablecompetencies_desc'] = 'Competenties maken het mogelijk om leerlingen te beoordelen volgens studieplannen';
$string['errorcannotchangeapastduedate'] = 'De einddatum is voorbij. Dit kan niet gewijzigd worden.';
$string['errorcannotsetduedateinthepast'] = 'De einddatum kan niet in het verleden liggen.';
$string['errorcannotsetduedatetoosoon'] = 'De einddatum is te vlug.';
$string['errorcompetencyrule'] = 'Cursus competentieregel  \'{$a}\' onbekend';
$string['errorcoursecompetencyrule'] = 'Cursus competentieregel  \'{$a}\' onbekend';
$string['errorinvalidcourse'] = 'Ongeldige cursus';
$string['errornocompetency'] = '{$a} competentie kan niet gevonden worden';
$string['errorplanstatus'] = 'Studieplan \'{$a}\' status onbekend';
$string['errorscalealreadyused'] = 'De schaal kan niet gewijzigd worden, omdat ze al in gebruik is.';
$string['errorscaleconfiguration'] = 'De schaal moet geconfigureerd worden door het selecteren van standaard en gevorderde items.';
$string['errorusercomptencystatus'] = 'Gebruikerscompetentiestatus \'{$a}\' onbekend';
$string['eventcompetencycreated'] = 'Competentie aangemaakt.';
$string['eventcompetencydeleted'] = 'Competentie verwijderd.';
$string['eventcompetencyframeworkcreated'] = 'Competentieframework gemaakt.';
$string['eventcompetencyframeworkdeleted'] = 'Competentieframework verwijderd.';
$string['eventcompetencyframeworkupdated'] = 'Competentieframework aangepast.';
$string['eventcompetencyframeworkviewed'] = 'Competentieframework bekeken.';
$string['eventcompetencyupdated'] = 'Competentie aangepast.';
$string['eventcompetencyviewed'] = 'Competentie bekeken.';
$string['eventevidencecreated'] = 'Bewijs gemaakt.';
$string['eventplanapproved'] = 'Studieplan goedgekeurd.';
$string['eventplancompleted'] = 'Studieplan voltooid.';
$string['eventplancreated'] = 'Studieplan gemaakt.';
$string['eventplandeleted'] = 'Studieplan verwijderd.';
$string['eventplanreopened'] = 'Studieplan heropend.';
$string['eventplanreviewrequestcancelled'] = 'Verzoek om studieplan te bekijken geannuleerd.';
$string['eventplanreviewrequested'] = 'Verzoek om studieplan te bekijken.';
$string['eventplanreviewstarted'] = 'Studieplan bekijken gestart.';
$string['eventplanreviewstopped'] = 'Studieplan bekijken beëindigd.';
$string['eventplanunapproved'] = 'Studieplan niet goedgekeurd';
$string['eventplanunlinked'] = 'Studieplan link ongedaan gemaakt.';
$string['eventplanupdated'] = 'Studieplan aangepast.';
$string['eventplanviewed'] = 'Studieplan bekeken.';
$string['eventtemplatecreated'] = 'Studieplan sjabloon gemaakt.';
$string['eventtemplatedeleted'] = 'Studieplan sjabloon verwijderd.';
$string['eventtemplateupdated'] = 'Studieplan sjabloon aangepast.';
$string['eventtemplateviewed'] = 'Studieplan sjabloon bekeken.';
$string['eventusercompetencyplanviewed'] = 'Gebruikerscompetentieplan bekeken.';
$string['eventusercompetencyrated'] = 'Gebruikerscompetentie beoordeeld.';
$string['eventusercompetencyratedincourse'] = 'Gebruikerscompetentie beoordeeld in cursus.';
$string['eventusercompetencyratedinplan'] = 'Gebruikerscompetentie beoordeeld in studieplan.';
$string['eventusercompetencyreviewrequestcancelled'] = 'Gebruikerscompetentie beoordelingsvraag geannuleerd.';
$string['eventusercompetencyreviewrequested'] = 'Gebruikerscompetentie beoordeling gevraagd.';
$string['eventusercompetencyreviewstarted'] = 'Gebruikerscompetentie beoordeling gestart.';
$string['eventusercompetencyreviewstopped'] = 'Gebruikerscompetentie beoordeling beëindigd.';
$string['eventusercompetencyviewed'] = 'Gebruikerscompetentie bekeken.';
$string['eventusercompetencyviewedincourse'] = 'Gebruikerscompetentie bekeken in een cursus.';
$string['eventusercompetencyviewedinplan'] = 'Gebruikerscompetentie bekeken in een studieplan.';
$string['eventuserevidencecreated'] = 'Bewijs van leren gemaakt.';
$string['eventuserevidencedeleted'] = 'Bewijs van leren verwijderd.';
$string['eventuserevidenceupdated'] = 'Bewijs van leren aangepast.';
$string['evidence_competencyrule'] = 'De competentieregel werd behaald.';
$string['evidence_coursecompleted'] = 'Cursus \'{$a}\' werd voltooid';
$string['evidence_coursemodulecompleted'] = 'Activiteit \'{$a}\' werd voltooid.';
$string['evidence_courserestored'] = 'De waardering was hersteld, samen met cursus \'{$a}\'.';
$string['evidence_evidenceofpriorlearninglinked'] = 'Bewijs van leren \'{$a}\' werd gelinkt.';
$string['evidence_evidenceofpriorlearningunlinked'] = 'Bewijs van leren \'{$a}\' link verwijderd';
$string['evidence_manualoverride'] = 'De competentiebeoordeling werd manueel ingesteld.';
$string['evidence_manualoverrideincourse'] = 'De competentiebeoordeling werd manueel ingesteld in cursus \'{$a}\'.';
$string['evidence_manualoverrideinplan'] = 'De competentiebeoordeling werd manueel ingesteld in studieplan \'{$a}\'.';
$string['invalidevidencedesc'] = 'Ongeldige bewijsbeschrijving';
$string['invalidgrade'] = 'Ongeldige beoordeling';
$string['invalidpersistenterror'] = 'Fout: {$a}';
$string['invalidplan'] = 'Ongeldig studieplan';
$string['invalidtaxonomy'] = 'Ongeldige taxonomie: {$a}';
$string['invalidurl'] = 'De URL is niet geldig. Die moet beginnen met \'http://\' of \'https://\'.';
$string['nouserplanswithcompetency'] = 'Er zijn geen studieplannen die deze competentie bevatten.';
$string['planstatusactive'] = 'Actief';
$string['planstatuscomplete'] = 'Volledig';
$string['planstatusdraft'] = 'Concept';
$string['planstatusinreview'] = 'Wordt beoordeeld';
$string['planstatuswaitingforreview'] = 'Wacht op beoordeling';
$string['pointsrequiredaremet'] = 'Vereiste punten behaald';
$string['privacy:evidence:action:complete'] = 'Voltooi competentie wanneer niet beoordeeld';
$string['privacy:evidence:action:log'] = 'Log actie';
$string['privacy:evidence:action:override'] = 'Overschrijf competentiebeoordeling';
$string['privacy:metadata:competency'] = 'Een gegeven over de competenties';
$string['privacy:metadata:competency_coursecomp'] = 'Deen gegeven over de competenties, gelinkt aan een cursus';
$string['privacy:metadata:competency_coursecompsetting'] = 'Een gegeven van de competentie-instellingen in een cursus';
$string['privacy:metadata:competency_evidence'] = 'Een gegeven van het bewijs dat invloed heeft op de status van een competentie';
$string['privacy:metadata:competency_framework'] = 'Een gegeven van het competentieframework';
$string['privacy:metadata:competency_modulecomp'] = 'Een gegeven van competenties, gelinkt aan een module';
$string['privacy:metadata:competency_plan'] = 'Een gegeven van studieplannen';
$string['privacy:metadata:competency_plancomp'] = 'Een gegeven van de competenties in een leerpllan';
$string['privacy:metadata:competency_relatedcomp'] = 'Een gegeven van de relatie tussen competenties';
$string['privacy:metadata:competency_template'] = 'Een gegeven over de studieplansjablonen';
$string['privacy:metadata:competency_templatecohort'] = 'Een gegeven van de site-groepen geassocieerd met een studieplansjabloon';
$string['privacy:metadata:competency_templatecomp'] = 'Een gegeven van de competenties in het studieplansjabloon';
$string['privacy:metadata:competency_usercomp'] = 'Een gegeven over de status van de competenties van een gebruiker';
$string['privacy:metadata:competency_usercompcourse'] = 'Een gegeven over de status de competenties van een gebruiker in een cursus';
$string['privacy:metadata:competency_usercompplan'] = 'En gegeven over de status van de competenties in een studieplan';
$string['privacy:metadata:competency_userevidence'] = 'Een gegeven over het bewijs van vroeger leren';
$string['privacy:metadata:competency_userevidencecomp'] = 'Een gegeven van de competenties die geassocieerd zijn met bewijs van vroeger leren';
$string['privacy:metadata:core_comments'] = 'Opmerkingen gemaakt over studieplannen en competenties';
$string['privacy:metadata:evidence:action'] = 'Het type actie dat genomen is met het bewijs';
$string['privacy:metadata:evidence:actionuserid'] = 'De gebruiker die de actie doet';
$string['privacy:metadata:evidence:desca'] = 'De optionele parameters van de vertaalbare bewijsbeschrijving';
$string['privacy:metadata:evidence:desccomponent'] = 'De component van de vertaalbare bewijsbeschrijving';
$string['privacy:metadata:evidence:descidentifier'] = 'Een identificatie van de vertaalbare bewijsbeschrijving';
$string['privacy:metadata:evidence:grade'] = 'Het cijfer dat met het bewijs geassocieerd is';
$string['privacy:metadata:evidence:note'] = 'Een niet-gelokaliseerde notitie die bij het bewijs gevoegd is';
$string['privacy:metadata:evidence:url'] = 'Een URL die geassocieerd is met het bewijs';
$string['privacy:metadata:plan:description'] = 'De beschrijving van het studieplan';
$string['privacy:metadata:plan:duedate'] = 'De einddatum van het studieplan';
$string['privacy:metadata:plan:name'] = 'De naam van het studieplan';
$string['privacy:metadata:plan:reviewerid'] = 'De ID van wie het studieplan nagekeken heeft';
$string['privacy:metadata:plan:status'] = 'De status van het studieplan';
$string['privacy:metadata:plan:userid'] = 'De ID van de gebruiker van wie het studieplan is';
$string['privacy:metadata:timecreated'] = 'De datum waarop het gegeven gemaakt is';
$string['privacy:metadata:timemodified'] = 'De datum waarop het gegeven bewerkt is';
$string['privacy:metadata:usercomp:grade'] = 'Het cijfer dat voor de competentie gegeven is';
$string['privacy:metadata:usercomp:proficiency'] = 'Of bekwaamheid bereikt is';
$string['privacy:metadata:usercomp:reviewerid'] = 'De ID van wie het nagekeken heeft';
$string['privacy:metadata:usercomp:status'] = 'De status van de competentie';
$string['privacy:metadata:usercomp:userid'] = 'De ID van de gebruiker tot wie de competentie behoort';
$string['privacy:metadata:userevidence:description'] = 'De beschrijving van het bewijs';
$string['privacy:metadata:userevidence:name'] = 'De naam van het bewijs van vroeger leren';
$string['privacy:metadata:userevidence:url'] = 'Een URL die met het bewijs geassocieerd is';
$string['privacy:metadata:usermodified'] = 'De gebruiker die dit gegeven gemaakt of gewijzigd heeft';
$string['privacy:path:plans'] = 'Studieplannen';
$string['privacy:path:relatedtome'] = 'Aan mij gerelateerd';
$string['privacy:path:userevidence'] = 'Bewijs van vroeger leren';
$string['pushcourseratingstouserplans'] = 'Stuur cursusbeoordelingen naar individuele studieplannen';
$string['pushcourseratingstouserplans_desc'] = 'Standaardwaarde voor cursusinstellingen om individuele studieplannen  aan te passen wanneer curuscompetenties beoordeeld worden.';
$string['syncplanscohorts'] = 'Synchroniseer plannen van studieplannensjabloon voor site-groepen';
$string['taxonomy_behaviour'] = 'Gedrag';
$string['taxonomy_competency'] = 'Competentie';
$string['taxonomy_concept'] = 'Concept';
$string['taxonomy_domain'] = 'Domein';
$string['taxonomy_indicator'] = 'Indicator';
$string['taxonomy_level'] = 'Niveau';
$string['taxonomy_outcome'] = 'Resultaat';
$string['taxonomy_practice'] = 'Toepassing';
$string['taxonomy_proficiency'] = 'Bekwaamheid';
$string['taxonomy_skill'] = 'Vaardigheid';
$string['taxonomy_value'] = 'Waarde';
$string['usercommentedonacompetency'] = '{$a->fullname} heeft een opmerking gemaakt bij competentie "{$a->competency}":

{$a->comment}

Zie: {$a->url}';
$string['usercommentedonacompetencyhtml'] = '<p>{$a->fullname} heeft een opmerking gemaakt bij competentie "{$a->competency}":</p>
<div>{$a->comment}</div>
<p>Zie: <a href="{$a->url}">{$a->urlname}</a>.</p>';
$string['usercommentedonacompetencysmall'] = '{$a->fullname} heeft opmerkingen gemaakt bij competentie "{$a->competency}".';
$string['usercommentedonacompetencysubject'] = '{$a} heeft opmerkingen gemaakt bij een competentie.';
$string['usercommentedonaplan'] = '{$a->fullname} heeft een opmerking gemaakt bij studieplan "{$a->plan}":

{$a->comment}

Zie: {$a->url}';
$string['usercommentedonaplanhtml'] = '<p>{$a->fullname} heeft een opmerking gemaakt bij studieplan "{$a->plan}":</p>
<div>{$a->comment}</div>
<p>Zie: <a href="{$a->url}">{$a->urlname}</a>.</p>';
$string['usercommentedonaplansmall'] = '{$a->fullname} heeft een opmerking gemaakt bij studieplan "{$a->plan}".';
$string['usercommentedonaplansubject'] = '{$a} heeft een opmerking gemaakt bij een studieplan.';
$string['usercompetencystatus_idle'] = 'Niet aan het werk';
$string['usercompetencystatus_inreview'] = 'Wordt beoordeeld';
$string['usercompetencystatus_waitingforreview'] = 'Wacht op beoordeling';
$string['userplans'] = 'Studieplan';
