<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'cachestore_memcached', language 'sr_cr', version '4.3'.
 *
 * @package     cachestore_memcached
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['bufferwrites'] = 'Уписи бафера';
$string['bufferwrites_help'] = 'Ова опција омогућава или онемогућава баферовани I/O (У/И – улаз/излаз). Омогућавање баферованог У/И доводи до складиштења команди у "бафер" (помоћну меморију), уместо да оне буду послате удаљеној конекцији. Било која акција која преузима податке условљава да овај бафер буде послат удаљеној конекцији. Прекидање конекције или њено затварање ће, такође, условити да баферовани подаци буду послати удаљеној конекцији.';
$string['clustered'] = 'Омогући кластере сервера';
$string['clustered_help'] = 'Ова опција се користи за подешавање функционалности која дозвољава једно читање и више постављања.

Намера је да се такво подешавање користи ради креирање напредног складишта за конфигурације са балансираним учитавањем. Складиште ће преузимати садржаје са једног сервера (обично локалног), али ће их смештати на више сервера (све који су одређени као расположиви за балансирање учитавања). За кеш са веома високим односом читања и постављања ово обезбеђује значајно облажавање оптерећења мреже.

Кад је ово подешавање укључено горе наведени сервери се користе за прибављање садржаја.';
$string['clusteredheader'] = 'Дељени сервери';
$string['hash'] = 'Хеш метод';
$string['hash_crc'] = 'CRC';
$string['hash_default'] = 'Подразумевани (један по један)';
$string['hash_fnv1_32'] = 'FNV1_32';
$string['hash_fnv1_64'] = 'FNV1_64';
$string['hash_fnv1a_32'] = 'FNV1A_32';
$string['hash_fnv1a_64'] = 'FNV1A_64';
$string['hash_help'] = 'Ова опција дефинише који хеш алгоритам се користи за ставке кључева. Сваки хеш алгоритам има своје предности и своје мане. Ако не знате или вам није важно, почните са подразумеваним методом.';
$string['hash_hsieh'] = 'Hsieh';
$string['hash_md5'] = 'MD5';
$string['hash_murmur'] = 'Murmur';
$string['isshared'] = 'Дељени кеш';
$string['isshared_help'] = 'Да ли ваш memcached сервер користе и друге апликације?

Ако се кеш дели са другим апликацијама онда ће сваки кључ бити обрисан појединачно како би се осигурало да буду очишћени само подаци у власништву ове апликације (остављајући, истовремено, кеш податке других екстерних апликација неизмењене). Ово може довести до смањене перформансе приликом чишћења кеша, зависно од конфигурације вашег сервера.

Ако користите наменски кеш за ову апликацију онда целокупан кеш може бити  уклоњен без ризика да буду уништени кеш подаци других апликација. Ово би тебало да резултира побољшаним перформансама приликом чишћења кеша.';
$string['pluginname'] = 'Memcached';
$string['prefix'] = 'Префикс кључа';
$string['prefix_help'] = 'Ово може да се користи за креирање "домена" за ставке ваших кључева, дајући вам могућност да креирате више memcached складишта на једној memcached инсталацији. Префикс кључа не може да буде дужи од 16 знакова, како би се избегли проблеми са дужином кључа.';
$string['prefixinvalid'] = 'Префикс није валидан. Можете да користите само a-z A-Z 0-9-_.';
$string['privacy:metadata:memcached'] = 'Додатак за кеширање Memcached кратко чува податке, као део своје функционалности. Ови подаци се чувају на Memcache серверу одакле се редовно уклањају.';
$string['privacy:metadata:memcached:data'] = 'Различити подаци који се чувају у кешу';
$string['serialiser_igbinary'] = 'igbinary серијализатор';
$string['serialiser_json'] = 'JSON серијализатор';
$string['serialiser_php'] = 'Стандардни PHP серијализатор';
$string['servers'] = 'Сервери';
$string['servers_help'] = 'Ова опција подешава сервере које треба да користи овај memcache адаптер.
Сервери треба да буду дефинисани по један у сваком реду, а дефиниција се састоји од адресе сервера, и опционо од порта и тежине.
Ако порт није дефинисан користи се подразумевани порт (11211).

На пример:
<pre>
server.url.com
ipaddress:port
servername:port:weight
</pre>

Ако је опција "Омогући груписане сервере" укључена испод, онда овде мора да буде само један сервер. То је обично име које се односи на локални сервер, нешто попут 127.0.0.1 или localhost.';
$string['serversclusterinvalid'] = 'Потребан је тачно један сервер кад је омогућено кластеровање.';
$string['sessionhandlerconflict'] = 'Упозорење: memcache инстанца ({$a}) је подешена тако да користи исти memcache сервер као сесије. Чишћење кеша ће са собом повући и чишћење сесија.';
$string['setservers'] = 'Подеси сервере';
$string['setservers_help'] = 'Ово је списак сервера који ће бити ажурирани када се измене подаци у кешу. Обично, пун назив сваког сервера у групи расположивих. Списак **мора** да садржи сервер наведен горе под опцијом *Сервери*, чак и ако је дат под другим називом.
Сервери треба да буду дефинисани по један у сваком реду, а дефиниција се састоји од адресе сервера, и опционо од порта.
Ако порт није дефинисан користи се подразумевани порт (11211).

На пример:
<pre>
server.url.com
ipaddress:port
</pre>';
$string['testservers'] = 'Тест сервери';
$string['testservers_desc'] = 'Један или више стрингова за конекцију спрам којих ће се тестирати memcached сервери. Ако је специфициран тестни сервер memcached перформансе се могу тестирати коришћењем странице за кеш перформансе у блоку за администрацију.
На пример: 127.0.0.1:11211';
$string['upgrade200recommended'] = 'Препоручујемо вам да надоградите Memcached PHP екстензију на верзију 2.0.0 или новију.
Верзија Memcached PHP екстензије коју тренутно користите не обезбеђује функционалност коју Moodle користи како би обезбедио кеш у заштићеном окружењу. Док не урадите надоградњу препоручујемо вам да не конфигуришете ниједну другу апликацију која би користила исти Memcached сервер, пошто је Moodle подешен да га користи.';
$string['usecompression'] = 'Користи компресију';
$string['usecompression_help'] = 'Ова опција омогућава или онемогућава коришћење протокола за компресију. Када је омогућена компресија, ставке чија је вредност дужа од одређеног прага (тренутно 100 бајта) биће компримоване у току складиштења и декомпримоване у току преузимања.';
$string['useserialiser'] = 'Користи серијализатор';
$string['useserialiser_help'] = 'Ова опција дефинише серијализатор који се користи за серијализацију (серијски пренос) нескаларних вредности. Важећи серијализатори су Memcached::SERIALIZER_PHP или Memcached::SERIALIZER_IGBINARY. Овај други је је подржан само када је memcached конфигурисан са опцијом --enable-memcached-igbinary и када је igbinary екстензија учитана.';
