<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'badges', language 'sr_cr', version '4.3'.
 *
 * @package     badges
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actions'] = 'Акције';
$string['activate'] = 'Омогући приступ';
$string['activatesuccess'] = 'Приступ беџевима је успешно омогућен';
$string['addalignment'] = 'Додај екстерну вештину или стандард';
$string['addbadge'] = 'Додај беџеве';
$string['addbadge_help'] = 'Изаберите све беџеве које треба додати као услов за добијање овог беџа. Држите CTRL тастер како бисте изабрали више ставки.';
$string['addbadgecriteria'] = 'Додај критеријум за беџ';
$string['addcohort'] = 'Додај кохорту';
$string['addcohort_help'] = 'Изаберите све кохорте које треба додати као услов за добијање овог беџа. Држите CTRL тастер како бисте изабрали више ставки.';
$string['addcompetency'] = 'Додај компетенцију';
$string['addcompetency_help'] = 'Изаберите све компетенције које треба додати као услов за добијање овог беџа. Држите CTRL тастер како бисте изабрали више ставки.';
$string['addcourse'] = 'Додај курсеве';
$string['addcourse_help'] = 'Изаберите све курсеве који треба додати у услове за добијање овог беџа. Држите тастер CTRL да бисте одабрали више курсева.';
$string['addcriteria'] = 'Додај критеријум';
$string['addcriteriatext'] = 'Да бисте започели додавање критеријума изаберите једну од опција из падајућег менија.';
$string['addedtobackpack'] = 'Беџ додат у албум';
$string['addrelated'] = 'Додајте повезани беџ';
$string['addtobackpack'] = 'Додај у албум';
$string['adminonly'] = 'Ова страница је ограничена само на администраторе сајта.';
$string['after'] = 'након датума издавања.';
$string['aggregationmethod'] = 'Метод сумирања';
$string['alignment'] = 'Поравнање';
$string['all'] = 'Сви';
$string['allmethod'] = 'Сви изабрани услови си испуњени';
$string['allmethodactivity'] = 'Све изабране активности се заврше';
$string['allmethodbadges'] = 'Сви изабрани беџеви су освојени';
$string['allmethodcohort'] = 'Чланство у свим изабраним кохортама';
$string['allmethodcompetencies'] = 'Све изабране компетенције су завршене';
$string['allmethodcourseset'] = 'Сви изабрани курсеви су завршени';
$string['allmethodmanual'] = 'Све изабране улоге доделе беџ';
$string['allmethodprofile'] = 'Сва изабрана поља профила су комплетирана';
$string['allowcoursebadges'] = 'Омогући беџеве на курсу';
$string['allowcoursebadges_desc'] = 'Дозволите да се беџеви креирају и додељују у контексту курса.';
$string['allowexternalbackpack'] = 'Веза са екстерним албумима';
$string['allowexternalbackpack_desc'] = 'Ако је ова опција омогућена, корисници могу да се повежу са екстерним албумом и поделе/прикажу своје беџева са овог сајта. Корисници такође могу изабрати да на страници свог профила, на овом сајту, прикажу било коју јавну колекцију беџева из својих екстерних албума. Препоручује се да оставите ову опцију онемогућену ако вашем сајту није могуће приступити са интернета.';
$string['any'] = 'Било која/е/и/у';
$string['anymethod'] = 'Било који од изабраних услова је испуњен';
$string['anymethodactivity'] = 'Било која од изабраних активности се заврши';
$string['anymethodbadges'] = 'Било који од изабраних беџева је освојен';
$string['anymethodcohort'] = 'Чланство у било којој од изабраних кохорти';
$string['anymethodcompetencies'] = 'Било која од изабраних компетенција је завршена';
$string['anymethodcourseset'] = 'Било који од изабраних курсева је завршен';
$string['anymethodmanual'] = 'Било која од изабраних улога додели беџ';
$string['anymethodprofile'] = 'Било које од изабраних поља профила је попуњено.';
$string['apiversion'] = 'API верзија је подржана';
$string['archivebadge'] = 'Да ли желите да обришете беџ \'{$a}\', а да при томе задржите све постојеће, до сада издате, беџеве?';
$string['archiveconfirm'] = 'Обриши и задржи постојеће, до сада издате беџеве';
$string['archivehelp'] = '<p>Ова опција значи да ће беџ бити означен као "повучен" и да се више неће појављивати на списку беџева. Корисници више неће моћи да освоје овај беџ, али ће сви они који су га већ добили моћи да приказују беџ на својој страници профила, као и да га пребаце у своје екстерне албуме беџева. </p>
<p>Уколико желите да ваши корисници задрже приступ освојеним беџевима важно је да изаберете ову опцију уместо потпуног брисања беџева</p>';
$string['attachment'] = 'Приложи беџ уз поруку';
$string['attachment_help'] = 'Ако је ова опција омогућена, издати беџ биће приложен уз е-поруку добитнику, како би он могао да је преузме. Да бисте могли да користите ову опцију, додавање датотека уз е-поруке мора бити омогућено у подешавањима сајта – Администрација сајта / Сервер / Е-пошта / Конфигурација одлазне поште.';
$string['award'] = 'Додели беџ';
$string['awardedto'] = 'Додељено кориснику  {$a}';
$string['awardedtoyou'] = 'Беџеви издати мени';
$string['awardoncron'] = 'Приступ беџу је успешно омогућен. Велики број корисника може одмах освојити овај беџ. Да би се осигурало ефикасно функционисање сајта, биће потребно неко време да ова акција буде процесирана.';
$string['awards'] = 'Добитници беџа';
$string['backpackapiurl'] = 'URL адреса API-ја за албум беџева';
$string['backpackavailability'] = 'Екстерна провера беџа';
$string['backpackavailability_help'] = 'Како би добитници беџева могли да докажу да су своје беџеве добили од вас, потребно је да екстерни албум има могућност приступа вашем сајту и провери беџева које сте издали. Изгледа да ваш сајт тренутно није доступан, што значи да беџеви које сте већ издали или ће тек бити издати, не могу бити проверени.

**Зашто видим ову поруку?**

Постоји могућност да ваш заштитни зид спречава приступ корисницима изван ваше мреже, да је ваш сајт заштићен лозинком, или да се сајт налази на рачунару који није доступан на интернету (као што су локални рачунари који служе за тестирање и развој).

**Да ли ово представља проблем?**

Овај проблем треба решити на сваком продукционом серверу/сајту на којем се планира издавање беџева, иначе добитници неће моћи да докажу да су добили своје беџеве од вас. Ако ваш сајт још није активан, можете да креирате и издате пробне беџеве док је сајт доступан, а пре него што га ставите у функцију.

**Шта ако не могу читав свој сајт да учиним јавно доступним?**

Једина URL адреса која је неопходна за проверу је [url-вашег-сајта]/badges/assertion.php, тако да, уколико сте у могућности да промените подешавања вашег заштитног зида и омогућите приступ овој датотеци, провера беџева ће и даље функционисати без проблема.';
$string['backpackbadgessettings'] = 'Промените подешавања албума';
$string['backpackbadgessummary'] = 'Имате {$a->totalbadges} беџ(ев)а из {$a->totalcollections} колекције/а.';
$string['backpackcannotsendverification'] = 'Није могуће послати е-поруку за потврду';
$string['backpackconnected'] = 'Успостављена је веза са албумом';
$string['backpackconnection'] = 'Повежите се са албумом';
$string['backpackconnection_connected'] = 'Ваш албум са беџевима';
$string['backpackconnection_help'] = 'Сачувајте и поделите своје беџеве са овог сајта и прикажите јавне беџеве са других веб сајтова на свом корисничком профилу.';
$string['backpackconnectioncancelattempt'] = 'Повежи се помоћу друге е-адресе';
$string['backpackconnectionconnect'] = 'Повежи се са албумом';
$string['backpackconnectionnottested'] = 'Веза се не може тестирати за овај албум, пошто га подржавају само Open Badges v2.0 албуми.';
$string['backpackconnectionok'] = 'Веза са албумом је успешно успостављена';
$string['backpackconnectionresendemail'] = 'Пошаљи поново е-поруку за потврду';
$string['backpackconnectionunexpectedmessage'] = 'Албум је вратио грешку: "{$a}".';
$string['backpackconnectionunexpectedresult'] = 'Дошло је до проблема приликом повезивања са албумом. Ваш провајдер албума беџева шаље ову поруку: \'{$a}\'.';
$string['backpackdetails'] = 'Подешавања албума беџева';
$string['backpackdisconnected'] = 'Веза са албумом је прекинута';
$string['backpackemail'] = 'Е-адреса';
$string['backpackemail_help'] = 'Е-адреса повезана са вашим албумом беџева. Док сте повезани, сви беџеви који сте освојили на овом сајту биће придружени уз ову е-адресу.';
$string['backpackemail_required'] = 'Поље за адресу е-поште не може бити празно';
$string['backpackemailverificationpending'] = 'Потврда на чекању';
$string['backpackemailverifyemailbody'] = 'Поштована/и {$a->userfirstname},

Скоро сте завршили са повезивањем са својим албумом са беџевима на \'{$a->sitename}\'.

Да бисте завршили повезивање са албумом, потврдите своју адресу е-поште помоћу следећег дугмета:

{$a->buttonlink}

Ако дугме не ради, можете да прекопирате следећу URL адресу у свој веб читач:
{$a->link}

Ако нисте покушали да се повежете са својим албумом са беџевима, можете безбедно да игноришете ову поруку е-поште.

За било какву додатну помоћ, молимо вас да се контактирате подршку за ваш веб сајт,

{$a->admin}';
$string['backpackemailverifyemailsubject'] = '{$a}: Албум беџева - потврда е-адресе';
$string['backpackemailverifypending'] = 'Послали смо е-поруку на <strong>{$a}</strong>. Кликните на линк за потврду у е-поруци како бисте активирали везу са својим албумом беџева.';
$string['backpackemailverifysuccess'] = 'Сада сте повезани са својим албумом беџева.';
$string['backpackemailverifytokenmismatch'] = 'Токен у линку на који сте кликнули се не поклапа са сачуваним токеном. Проверите да ли сте кликнули на линк који се налази у најновијој поруци коју сте добили.';
$string['backpackexporterror'] = 'Није могуће експортовати беџ у албум';
$string['backpackexporterrorwithinfo'] = 'Није могуће експортовати беџ "{$a->badgename}" у албум. Грешка: {$a->error}';
$string['backpackimport'] = 'Подешавања за увоз беџева';
$string['backpackimport_help'] = 'Након што се веза са албумом беџева успешно успостави, беџеви из вашег албума могу да се прикажу на вашој страници са беџевима, као и на страници вашег профила.

Овде можете да изаберете колекције беџева из свог албума које желите да прикажете у свом профилу.';
$string['backpackprovider'] = 'Провајдер албума';
$string['backpacksettings'] = 'Подешавања албума';
$string['backpackweburl'] = 'URL адреса албума';
$string['badgedetails'] = 'Подаци о беџу';
$string['badgeimage'] = 'Слика';
$string['badgeimage_help'] = 'Величина слике треба да буде најмање 300 x 300 пиксела. Биће приказан као 300 x 300 пиксела на страници са беџом и 100 x 100 пиксела на страници корисничког профила.';
$string['badgeissued'] = 'Беџ издат';
$string['badgeprivacysetting'] = 'Подешавања приватности беџева';
$string['badgeprivacysetting_help'] = 'Беџеви које сте освојили могу бити приказани на вашој страници профила. Ово подешавање вам омогућава да подесите видљивост новоосвојених беџева.

Подешавања приватности појединачних беџева и даље можете да контролишете на својој страници са беџевима';
$string['badgeprivacysetting_str'] = 'Аутоматски прикажи беџеве које сам освојио/ла на страници мог профила';
$string['badges'] = 'Беџеви';
$string['badgesalt'] = 'Насумични стринг (salt) за хеширање е-адреса добитника беџева';
$string['badgesalt_desc'] = 'Коришћење хеш фукнције омогућава албумима да потврде носиоце беџева без откривања њихових е-адреса. Ово подешавање треба да користи само бројеве и слова.

Напомена: Ради успешне провере прималаца молимо избегавајте измене овог подешавања једном кад сте почели са издавањем беџева.';
$string['badgesdisabled'] = 'Беџеви нису омогућени на овом сајту';
$string['badgesearned'] = 'Број освојених беџева: {$a}';
$string['badgesettings'] = 'Подешавања беџева';
$string['badgestatus_0'] = 'Није доступан';
$string['badgestatus_1'] = 'Доступан';
$string['badgestatus_2'] = 'Није доступан (критеријуми закључани)';
$string['badgestatus_3'] = 'Доступан (критеријуми закључани)';
$string['badgestatus_4'] = 'Архивиран';
$string['badgestoearn'] = 'Број доступних беџева: {$a}';
$string['badgesview'] = 'Беџеви курса';
$string['badgetags'] = 'Ознаке беџа';
$string['badgeurl'] = 'Линк за издати беџ';
$string['balignment'] = 'Поравнања ({$a})';
$string['bawards'] = 'Добитници ({$a})';
$string['bcriteria'] = 'Критеријум';
$string['bdetails'] = 'Уреди податке';
$string['bendorsement'] = 'Потврда';
$string['bmessage'] = 'Порука';
$string['boverview'] = 'Преглед';
$string['brelated'] = 'Повезани беџеви ({$a})';
$string['bydate'] = 'завршити до';
$string['claim'] = 'Захтев';
$string['claimcomment'] = 'Коментар потврде';
$string['claimid'] = 'URL адреса захтева';
$string['clearsettings'] = 'Уклони подешавања';
$string['completioninfo'] = 'Овај беџ је издат за завршетак:';
$string['completionnotenabled'] = 'Праћење завршетка није омогућен за овај курс, тако да он не може бити укључен у критеријуме за добијање беџа.Праћење завршетка курса може се омогућити у подешавањима курса.';
$string['configenablebadges'] = 'Ако је омогућено, ова функција вам даје могућност да креирате беџеве и да их додељујете корисницима сајта.';
$string['configuremessage'] = 'Порука о беџу';
$string['connect'] = 'Успостави везу';
$string['connected'] = 'Веза успостављена';
$string['connecting'] = 'Повезивање ...';
$string['contact'] = 'Контакт';
$string['contact_help'] = 'Е-адреса издавачa беџа.';
$string['copy'] = 'Копирај';
$string['copyof'] = 'Копија {$a}';
$string['course'] = 'Курс: {$a}';
$string['coursebadges'] = 'Беџеви';
$string['coursebadgesdisabled'] = 'Беџеви курса нису омогућени на овом сајту.';
$string['coursebadgetitle'] = 'Беџ курса {$a}';
$string['coursecompletion'] = 'Полазници морају да заврше овај курс.';
$string['create'] = 'Нови беџ';
$string['createbutton'] = 'Креирај беџ';
$string['creatorbody'] = '<p>{$a->user} је испунио/ла све услове и освојио/ла је беџ. Погледајте издати беџ на {$a->link} </p>';
$string['creatorsubject'] = '\'{$a}\' је награђен/а!';
$string['criteria_0'] = 'Овај беџ се додељује када...';
$string['criteria_1'] = 'Завршетак активности';
$string['criteria_1_help'] = 'Омогућава да беџ буде додељен корисницима на основу завршетка скупа активности у оквиру курса.';
$string['criteria_2'] = 'Ручно издавања од стране улоге';
$string['criteria_2_help'] = 'Омогућава да беџ буде ручно додељен корисницима од стране корисника са одговарајућом улогом у оквиру сајта или курса.';
$string['criteria_3'] = 'Друштвено учешће';
$string['criteria_3_help'] = 'Друштвено';
$string['criteria_4'] = 'Завршетак курса';
$string['criteria_4_help'] = 'Омогућава да беџ буде додељен корисницима који су завршили курс. Овај критеријум може имати додатне параметре, као што су минимална оцена и датум завршетка курса.';
$string['criteria_5'] = 'Завршетак скупа курсева';
$string['criteria_5_help'] = 'Омогућава да беџ буде додељен корисницима који су завршили скуп курсева. Сваки курс може имати додатне параметре, као што су минимална оцена и датум завршетка курса.';
$string['criteria_6'] = 'Попуњавање профила';
$string['criteria_6_help'] = 'Омогућава да беџ буде додељен корисницима који су попунили одређена поља у свом профилу. Можете да изаберете стандардна и прилагођена поља профила која су доступна корисницима.';
$string['criteria_7'] = 'Додељени беџеви';
$string['criteria_7_help'] = 'Омогућава да беџ буде додељен корисницима на основу других беџева које су освојили.';
$string['criteria_8'] = 'Чланство у кохорти';
$string['criteria_8_help'] = 'Омогућава да беџ буде додељен корисницима на основу чланства у кохорти.';
$string['criteria_9'] = 'Компетенције';
$string['criteria_9_help'] = 'Омогућава додељивање беџа корисницима на основу компетенција које су завршили.';
$string['criteria_descr'] = 'Корисницима се овај беџ додељује када испуне следећи услов:';
$string['criteria_descr_0'] = 'Испуните <strong>{$a}</strong> од наведених услова.';
$string['criteria_descr_1'] = '<strong>{$a}</strong> од следећих активности је завршена:';
$string['criteria_descr_2'] = 'Овај беџ мора да буде додељен од стране корисника који има <strong>{$a}</strong> од следећих улога:';
$string['criteria_descr_4'] = 'Студенти морају да заврше курс';
$string['criteria_descr_5'] = '<strong>{$a}</strong> од следећих курсева мора да буде завршен:';
$string['criteria_descr_6'] = '<strong>{$a}</strong> од следећих поља корисничког профила мора да буду попуњена:';
$string['criteria_descr_7'] = '<strong>{$a}</strong> од следећих беџева мора бити освојен:';
$string['criteria_descr_8'] = 'Потребно је чланство у <strong>{$a}</strong> од следећих кохорти:';
$string['criteria_descr_9'] = '<strong>{$a}</strong> од следећих компетенција мора(ју) бити завршена/е/о:';
$string['criteria_descr_bydate'] = 'до <em>{$a}</em>';
$string['criteria_descr_grade'] = 'са минималном оценом <em>{$a}</em>';
$string['criteria_descr_short0'] = 'Заврши <strong>{$a}</strong> од:';
$string['criteria_descr_short1'] = 'Заврши <strong>{$a}</strong> од:';
$string['criteria_descr_short2'] = 'Беџ је доделио <strong>{$a}</strong> од:';
$string['criteria_descr_short4'] = 'Завршити курс';
$string['criteria_descr_short5'] = 'Заврши <strong>{$a}</strong> од:';
$string['criteria_descr_short6'] = 'Заврши <strong>{$a}</strong> од:';
$string['criteria_descr_short7'] = 'Завршите <strong>{$a}</strong> од:';
$string['criteria_descr_short8'] = 'Чланство у кохорти у <strong>{$a}</strong> од:';
$string['criteria_descr_short9'] = 'Завршене <strong>{$a}</strong> од:';
$string['criteria_descr_single_1'] = 'Следећа активност мора бити завршена:';
$string['criteria_descr_single_2'] = 'Овај беџ мора да додели корисник са следећом улогом:';
$string['criteria_descr_single_4'] = 'Студенти морају да заврше курс';
$string['criteria_descr_single_5'] = 'Следећи курс мора да буде завршен:';
$string['criteria_descr_single_6'] = 'Следеће поље корисничког профила мора да буде попуњено:';
$string['criteria_descr_single_7'] = 'Следећи беџ мора бити освојен:';
$string['criteria_descr_single_8'] = 'Потребно је чланство у следећој кохорти:';
$string['criteria_descr_single_9'] = 'Следеће компетенције морају бити завршене:';
$string['criteria_descr_single_short1'] = 'Завршити:';
$string['criteria_descr_single_short2'] = 'Доделио/ла:';
$string['criteria_descr_single_short4'] = 'Завршити курс';
$string['criteria_descr_single_short5'] = 'Завршити:';
$string['criteria_descr_single_short6'] = 'Завршити:';
$string['criteria_descr_single_short7'] = 'Завршено:';
$string['criteria_descr_single_short8'] = 'Чланство у:';
$string['criteria_descr_single_short9'] = 'Завршене:';
$string['criteriacreated'] = 'Критеријуми за беџ успешно су креирани';
$string['criteriadeleted'] = 'Критеријуми за беџ успешно су обрисани';
$string['criteriasummary'] = 'Резиме критеријума';
$string['criteriaupdated'] = 'Критеријуми за беџ успешно су ажурирани';
$string['criterror'] = 'Тренутни параметри за издавање беџа';
$string['criterror_help'] = 'Овај скуп поља приказује све параметре који су иницајлно додати међу услове за овај беџ. Препоручује се да искључите такве параметре како би осигурали да полазници могу у будућности да добију овај беџ.';
$string['currentimage'] = 'Тренутна слика';
$string['currentstatus'] = 'Тренутни статус:';
$string['dateawarded'] = 'Датум издавања';
$string['dateearned'] = 'Датум: {$a}';
$string['day'] = 'Дан(и)';
$string['deactivate'] = 'Онемогући приступ';
$string['deactivatesuccess'] = 'Приступ беџевима је успешно онемогућен.';
$string['defaultissuercontact'] = 'Е-адреса издавачa беџа';
$string['defaultissuercontact_desc'] = 'Адреса е-поште повезана са издавачем беџа. За Open Badges v2.0 албум, ово се користи за проверу идентитета приликом објављивања беџа у албуму.';
$string['defaultissuername'] = 'Име/назив издавача беџа';
$string['defaultissuername_desc'] = 'Име особе/назив институције надлежне за издавање беџева.';
$string['defaultissuerpassword'] = 'Лозинка издавача беџа';
$string['defaultissuerpassword_help'] = 'Потребан је налог на веб сајту албума са е-адресом која је наведена у подешавању "Е-адреса издавачa беџа", које се налази на страници Администрација сајта / Беџеви / Подешавања беџева. Овде треба унети лозинку за налог.';
$string['delbadge'] = 'Да ли желите да обришете беџ \'{$a}\' и уклоните све постојеће, до сада издате, беџеве?';
$string['delconfirm'] = 'Обриши и уклони постојеће, до сада издате беџеве';
$string['delcritconfirm'] = 'Да ли сте сигурни да желите да обришете овај критеријум?';
$string['deletehelp'] = '<p>Потпуно брисање беџева значи да ће сви подаци о беџу као и критеријуми за његово добијање бити трајно уклоњени. Корисници који су освојили овај беџ више неће моћи да му приступају, нити да га приказују на својим страницама профила.</p>
<p>Напомена: корисници који су већ освојили овај беџ и пребацили га у своје екстерне албуме беџева и даље га имати у тим албумима. Међутим, они више неће моћи да приступе критеријумима за освајање беџа нити страницама  на овом сајту са којима је беџ у екстерном албуму повезан. </p>';
$string['delexternalbackpack'] = 'Избриши сајт са албумом';
$string['delexternalbackpackconfirm'] = 'Обришите сајт са албумом \'{$a}\'?';
$string['delparamconfirm'] = 'Да ли сте сигурни да желите да обришете овај параметар?';
$string['description'] = 'Опис';
$string['disconnect'] = 'Прекини везу';
$string['donotaward'] = 'Тренутно, овај беџ није активан, тако да не може бити додељен полазницима. Ако желите да доделите овај беџ активирајте његов статус.';
$string['enablebadges'] = 'Омогући беџеве';
$string['endorsement'] = 'Потврда';
$string['error:backpackdatainvalid'] = 'Подаци добијени од албума беџева били су неисправни';
$string['error:backpackemailnotfound'] = 'Е-адреса \'{$a}\' није повезана са албумом беџева. Потребно је да <a href="http://backpack.openbadges.org">креирате албум</a> за тај налог или да се пријавите са другом е-адресом.';
$string['error:badgeawardnotfound'] = 'Није могуће потврдити овај додељени беџ. Постоји могућност да је беџ одузет.';
$string['error:badgenotfound'] = 'Беџ није пронађен';
$string['error:cannotact'] = 'Није могуће активирати беџ.';
$string['error:cannotawardbadge'] = 'Није могуће доделити беџ кориснику';
$string['error:cannotdeletecriterion'] = 'Овај критеријум је обрисан';
$string['error:cannotrevokebadge'] = 'Није могуће одузети беџ кориснику.';
$string['error:clone'] = 'Није могуће клонирати беџ.';
$string['error:connectionunknownreason'] = 'Повезивање је било неуспешно из непознатог разлога';
$string['error:duplicatename'] = 'Беџ са таквим називом већ постоји у систему';
$string['error:externalbadgedoesntexist'] = 'Беџ није пронађен';
$string['error:guestuseraccess'] = 'Тренутно приступате систему као гост. Да бисте видели беџеве потребно ја да се пријавите помоћу свог корисничког налога..';
$string['error:invalidcriteriatype'] = 'Неважећи тип критеријум';
$string['error:invalidexpiredate'] = 'Датум истека мора да буде у будућности.';
$string['error:invalidexpireperiod'] = 'Датум истека не може бити негативан или једнак 0.';
$string['error:invalidparambadge'] = 'Беџ не постоји';
$string['error:invalidparamcohort'] = 'Кохорта не постоји.';
$string['error:noactivities'] = 'На овом курсу не постоје активности са омогућеним критеријумом за завршетак.';
$string['error:nobadges'] = 'Тренутно не постоје беџеви са омогућеним приступом који се могу додати као критеријуми. Беџ на нивоу сајта може, као критеријуме, имати само друге беџева на нивоу сајта. Беџ на нивоу курса може, као критеријуме, имати друге беџева на нивоу курса или на нивоу сајта.';
$string['error:nocohorts'] = 'Нема кохорти';
$string['error:nocourses'] = 'Праћење завршетка курса није омогућено ни за један од курсева на овом сајту, тако да нема курса који би могао бити приказан. Праћење завршетка курса може се омогућити у подешавањима курса.';
$string['error:nogroupslink'] = '<p>Приказане су само јавне колекције. <a href="{$a}" target="_blank" rel="nofollow">. Посетите свој албум</a> како бисте креирали јавне колекције беџева.</p>';
$string['error:nogroupssummary'] = '<p>У вашем албуму нема јавних колекција беџева. </p>';
$string['error:nopermissiontoview'] = 'Немате овлашћења да видите добитнике беџева';
$string['error:nosuchbadge'] = 'Беџ са id бројем {$a} не постоји.';
$string['error:nosuchcohort'] = 'Упозорење: ова кохорта више није доступна.';
$string['error:nosuchcourse'] = 'Упозорење! Ова активност више није доступна.';
$string['error:nosuchfield'] = 'Упозорење! Ово корисничко поље више није доступно.';
$string['error:nosuchmod'] = 'Упозорење! Ова активност више није доступна.';
$string['error:nosuchrole'] = 'Упозорење! Ова улога више није доступна.';
$string['error:nosuchuser'] = 'Корисник са овом е-адресом нема налог код текућег провајдера албума беџева.';
$string['error:notifycoursedate'] = 'Упозорење! Беџеви повезани са  завршетком курса и активности неће бити издати до датума почетка курса.';
$string['error:parameter'] = 'Упозорење: Најмање један параметар треба да буде изабран како би се обезбедио исправан процес издавања беџева.';
$string['error:relatedbadgedoesntexist'] = 'Не постоји јавни беџ са овим идентификатором';
$string['error:requesterror'] = 'Захтев за успоставу везе није успео (кôд грешке {$a}).';
$string['error:requesttimeout'] = 'Захтев за успоставу везе је истекао пре него што је могао да се заврши.';
$string['error:save'] = 'Није могуће сачувати беџ.';
$string['error:userdeleted'] = '{$a->user} (Овај корисник више не постоји на сајту {$a->site})';
$string['eventbadgearchived'] = 'Беџ је архивиран';
$string['eventbadgeawarded'] = 'Беџ додељен';
$string['eventbadgecreated'] = 'Беџ је креиран';
$string['eventbadgecriteriacreated'] = 'Критеријуми за беџ су креирани';
$string['eventbadgecriteriadeleted'] = 'Критеријуми за беџ су обрисани';
$string['eventbadgecriteriaupdated'] = 'Критеријуми за беџ су ажурирани';
$string['eventbadgedeleted'] = 'Беџ је обрисан';
$string['eventbadgedisabled'] = 'Беџ је онемогућен';
$string['eventbadgeduplicated'] = 'Направљен је дупликат беџа';
$string['eventbadgeenabled'] = 'Беџ је омогућен';
$string['eventbadgelistingviewed'] = 'Списак беџева приказан';
$string['eventbadgerevoked'] = 'Беџ одузет';
$string['eventbadgeupdated'] = 'Беџ је ажуриран';
$string['eventbadgeviewed'] = 'Беџ приказан';
$string['evidence'] = 'Доказ';
$string['existingrecipients'] = 'Постојећи добитници беџа';
$string['existsinbackpack'] = 'Беџ већ постоји у  албуму';
$string['expired'] = 'Истекло';
$string['expiredate'] = 'Овај беџ истиче {$a}.';
$string['expireddate'] = 'Овај беџ је истекао {$a}.';
$string['expiredin'] = 'Истекао {$a}';
$string['expireperiod'] = 'Овај беџ истиче {$a} дан(а) након што је издат.';
$string['expireperiodh'] = 'Овај беџ истиче {$a} час(ов)а након што је издат.';
$string['expireperiodm'] = 'Овај беџ истиче {$a} минут(а) након што је издат.';
$string['expireperiods'] = 'Овај беџ истиче {$a} секунду/е/и након што је издат.';
$string['expiresin'] = 'Истиче {$a}';
$string['expirydate'] = 'Датум истека';
$string['expirydate_help'] = 'Опционо, беџеви могу истећи одређеног датума, или се датум може израчунати на основу датума када је беџ издат кориснику.';
$string['externalbackpack_required'] = 'Поље за провајдера албума не може бити празно';
$string['externalbadges'] = 'Моји беџеви са других сајтова';
$string['externalbadges_help'] = 'Овде су приказани беџеви уз ваших екстерних албума.';
$string['externalbadgesp'] = 'Беџеви са других сајтова';
$string['externalconnectto'] = 'Да бисте приказали екстерне беџеве потребно је да <a href="{$a}">успоставите везу са албумом</a>.';
$string['fixed'] = 'Фиксни датум';
$string['hidden'] = 'Сакривено';
$string['hiddenbadge'] = 'Нажалост, власник беџа није учинио ове информације доступним.';
$string['hostedurl'] = 'Екстерна URL адреса';
$string['hostedurldescription'] = 'Екстерна URL адреса на којој се беџ хостује';
$string['imageauthoremail'] = 'Адреса е-поште аутора слике беџа';
$string['imageauthoremail_help'] = 'Ако је наведена, адреса е-поште аутора слике беџа приказује се на страници беџа.';
$string['imageauthorname'] = 'Име аутора слике беџа';
$string['imageauthorname_help'] = 'Ако је наведено, име аутора слике беџа приказује се на страници беџа.';
$string['imageauthorurl'] = 'URL адреса аутора слике беџа';
$string['imageauthorurl_help'] = 'Ако је наведен, линк ка веб сајту аутора слике беџа приказује се на страници беџа. URL адреса треба да има префикс http:// или https://.';
$string['imagecaption'] = 'Потпис испод слике';
$string['imagecaption_help'] = 'Ако је наведен, потпис испод слике приказује се на страници беџа.';
$string['includeauthdetails'] = 'Укључите податке за проверу идентитета са албумом';
$string['invalidurl'] = 'Неисправна URL адреса';
$string['issuancedetails'] = 'Беџ истиче';
$string['issuedbadge'] = 'Информације о издатаом беџу';
$string['issuedby'] = 'Издаје {$a}';
$string['issuedon'] = 'Издато {$a}';
$string['issuerdetails'] = 'Подаци о издавачу';
$string['issueremail'] = 'Адреса е-поште';
$string['issueremail_help'] = 'Контакт адреса е-поште организације која издаје потврду.';
$string['issuername'] = 'Име/назив издавача беџа';
$string['issuername_endorsement'] = 'Назив издавача потврде';
$string['issuername_endorsement_help'] = 'Назив организације која је издаје потврду.';
$string['issuername_help'] = 'Име особе/назив институције надлежне за издавање беџева.';
$string['issuerurl'] = 'URL адреса издавача';
$string['issuerurl_help'] = 'Веб сајт организације која издаје потврду.';
$string['language'] = 'Језик';
$string['language_help'] = 'Језик који се користи на страници беџа.';
$string['listbackpacks'] = 'Списак албума';
$string['localbadges'] = 'Моји беџеви са веб сајта {$a}';
$string['localbadgesh'] = 'Моји беџеви са овога сајта';
$string['localbadgesh_help'] = 'Сви беџеви у оквиру овог сајта, добијени на основу завршетка курсева и активности унутар курсева, као и испуњавањем других услова.

Овде можете управљати својим беџевима тако што ћете их учинити јавним или приватним за свој страницу профила.

Можете да преузмете све своје беџеве или сваки беџ засебно, и сачувате их на свом компјутеру. Преузете беџеви можете да додајете у своје екстерне албуме беџева.';
$string['localbadgesp'] = 'Беџеви са {$a}:';
$string['localconnectto'] = 'Да бисте делили беџеве ван овог сајта потребно је да <a href="{$a}">успоставите везу са албумом</a>.';
$string['loginbackpacktitle'] = '<strong>Пријавите се на свој албум</strong>';
$string['makeprivate'] = 'Учини приватним';
$string['makepublic'] = 'Учини јавним';
$string['managebackpacks'] = 'Управљање албумима';
$string['managebadges'] = 'Управљање беџевима';
$string['message'] = 'Тело поруке';
$string['messagebody'] = '<p>Додељен вам је беџ "%badgename%"!</p>
<p>Више информација о овом беџу можете наћи на страници %badgelink%.</p>
<p>Беџом можете управљати и преузети га са своје странице {$a}.</p>';
$string['messagesubject'] = 'Честитамо! Освојили сте беџ!';
$string['method'] = 'Овај критеријум је испуњен када...';
$string['mingrade'] = 'Неопходна је минимална оцена';
$string['month'] = 'Месец(и)';
$string['moredetails'] = 'Више информација';
$string['mybackpack'] = 'Подешавања мог албума беџева';
$string['mybadges'] = 'Моји беџеви';
$string['namewithlink'] = 'Назив са линком';
$string['never'] = 'Никад';
$string['newbackpack'] = 'Додај нови албум';
$string['newbadge'] = 'Додај нови беџ';
$string['newimage'] = 'Нова слика';
$string['noalignment'] = 'Овај беџ нема наведене екстерне вештине или стандарде.';
$string['noawards'] = 'Овај беџ још нико није добио.';
$string['nobackpack'] = 'Не постоји албум беџева који је повезан са овим налогом.<br/>';
$string['nobackpackbadgessummary'] = 'Нема беџева у колекцијама које сте изабрали.';
$string['nobackpackcollectionssummary'] = 'Није изабрана ниједна колекција беџева.';
$string['nobackpacks'] = 'Нема доступних албума';
$string['nobadges'] = 'Тренутно нема доступних беџева које корисници могу да освоје.';
$string['nocompetencies'] = 'Нису изабране компетенције.';
$string['nocriteria'] = 'Критеријуми за овај беџ још нису подешени';
$string['noendorsement'] = 'Овај беџ нема потврду';
$string['noexpiry'] = 'Овај беџ нема датум истека';
$string['nomatchingbadges'] = 'Не постоје одговарајући беџеви које би корисници могли да освоје.';
$string['noparamstoadd'] = 'Нема додатних параметара доступних за додавање услова за добијање овог беџа';
$string['norelated'] = 'Ова беџ нема повезаних беџева.';
$string['notacceptedrole'] = 'Ваша тренутна улога се не налази међу улогама које могу ручно да издају овај беџ.<br/>
Ако желите да видите кориснике који су већ освојили овај беџ , можете да посетите страницу {$a}.';
$string['notconnected'] = 'Веза није успостављена';
$string['notealignment'] = 'Екстерне вештине или стандарди које покрива беџ могу бити наведени. Све екстерне вештине или стандарди приказани су на страници беџа.';
$string['noteendorsement'] = 'Потврда треће стране може се користити за додавање вриедности беџу. На пример, беџ који је издао наставник може бити потврђена од стране школе, или беџ који издаје локално тело за награде може бити потврђен од стране националног тела за доделу награда.';
$string['noterelated'] = 'Беџеви са везом могу бити означени као повезани. На пример, беџеви са истим критеријумима који су приказани на различитим језицима могу бити означени као повезани. Сви повезани беџеви приказују се на страници беџа.';
$string['nothingtoadd'] = 'Не постоје доступни критеријуми за додавање.';
$string['notification'] = 'Обавести креатора беџа';
$string['notification_help'] = 'Ово подешавање управља обавештењима која се шаљу креаторима беџева како би знали да је беџ издата.

Доступне су следеће опције:

* **НИКАД** – Обавештења се не шаљу.

* **СВАКИ ПУТ** – Обавештење се шаље сваки пута када је беџ додељен.

* **ДНЕВНО** – Обавештење се шаље једном дневно.

* **СЕДМИЧНО** – Обавештење се шаље једном седмично.

* **МЕСЕЧНО** – Обавештење се шаље једном месечно.';
$string['notifydaily'] = 'Дневно';
$string['notifyevery'] = 'Сваки пут';
$string['notifymonthly'] = 'Месечно';
$string['notifyweekly'] = 'Седмично';
$string['numawards'] = 'Број корисника којима је издат овај беџ: <a href="{$a->link}">{$a->count}</a>..';
$string['numawardstat'] = 'Број корисника којима је издат овај беџ: {$a}';
$string['oauth2issuer'] = 'OAuth 2 сервиси';
$string['openbadgesv1'] = 'Open Badges v1.0';
$string['openbadgesv2'] = 'Open Badges v2.0';
$string['openbadgesv2p1'] = 'Open Badges v2.1';
$string['othernavigation'] = 'Друга навигација ...';
$string['overallcrit'] = 'од изабраних критеријума су испуњени';
$string['password_required'] = 'Поље за лозинку не може бити празно';
$string['potentialrecipients'] = 'Потенцијални добитници беџева';
$string['preferences'] = 'Параметри беџа';
$string['privacy:metadata:backpack'] = 'Запис корисникове колекције беџева';
$string['privacy:metadata:backpack:backpackuid'] = 'Јединствени идентификатор колекције беџева';
$string['privacy:metadata:backpack:email'] = 'Адреса електронске поште везана за колекцију беџева';
$string['privacy:metadata:backpack:externalbackpackid'] = 'ID ознака албума';
$string['privacy:metadata:backpack:userid'] = 'Идентификатор корисника чији ја је колекција беџева';
$string['privacy:metadata:backpackoauth2'] = 'OAuth 2 информације када се корисник повезује са спољним албумом';
$string['privacy:metadata:backpackoauth2:issuerid'] = 'ID ознака OAuth 2 сервиса';
$string['privacy:metadata:backpackoauth2:scope'] = 'Списак опсега за повезивања са албумом';
$string['privacy:metadata:backpackoauth2:token'] = 'Токен везе са албумом';
$string['privacy:metadata:backpackoauth2:userid'] = 'ID ознака корисника који се повезује са албумом';
$string['privacy:metadata:backpackoauth2:usermodified'] = 'ID ознака корисника који је изменио везу.';
$string['privacy:metadata:badge'] = 'Колекција беџева';
$string['privacy:metadata:badge:timecreated'] = 'Време креирања беџева';
$string['privacy:metadata:badge:timemodified'] = 'Време када је беџ последњи пут измењен';
$string['privacy:metadata:badge:usercreated'] = 'Идентификатор корисника који је креирао беџ';
$string['privacy:metadata:badge:usermodified'] = 'ID ознака корисника који је изменио беџ';
$string['privacy:metadata:criteriamet'] = 'Скуп критеријума који су задовољени';
$string['privacy:metadata:criteriamet:datemet'] = 'Датум кад су критеријуми задовољени';
$string['privacy:metadata:criteriamet:userid'] = 'Идентификатор корисника који је задовољио критеријуме';
$string['privacy:metadata:external:backpacks'] = 'Информације које се деле кад корисници предају своје беџеве у екстерну колекцију беџева';
$string['privacy:metadata:external:backpacks:badge'] = 'Назив беџа';
$string['privacy:metadata:external:backpacks:description'] = 'Опис беџа';
$string['privacy:metadata:external:backpacks:image'] = 'Слика беџа';
$string['privacy:metadata:external:backpacks:issuer'] = 'Неке информације о издавачу';
$string['privacy:metadata:external:backpacks:url'] = 'Moodle URL на ком се могу видети информације о издатом беџу';
$string['privacy:metadata:issued'] = 'Запис о додељеним беџевима';
$string['privacy:metadata:issued:dateexpire'] = 'Датум када истиче беџ';
$string['privacy:metadata:issued:dateissued'] = 'Датум доделе беџа';
$string['privacy:metadata:issued:userid'] = 'Идентификатор корисника којем је додељен беџ';
$string['privacy:metadata:manualaward'] = 'Запис о ручним доделама беџева';
$string['privacy:metadata:manualaward:datemet'] = 'Датум када је кориснику додељен беџ';
$string['privacy:metadata:manualaward:issuerid'] = 'Идентификатор корисника који додељује беџ';
$string['privacy:metadata:manualaward:issuerrole'] = 'Улога корисника који додељује беџ';
$string['privacy:metadata:manualaward:recipientid'] = 'Идентификатор корисника коме је ручно додељен беџ';
$string['recipient'] = 'Добитник беџа';
$string['recipientdetails'] = 'Детаљи о примаоцу';
$string['recipientidentificationproblem'] = 'Није могуће наћи примаоца овог беџа међу постојећим корисницима.';
$string['recipients'] = 'Добитници беџа';
$string['recipientvalidationproblem'] = 'Овај корисник не може бити потврђен као прималац овог беџа.';
$string['relatedbages'] = 'Повезани беџеви';
$string['relative'] = 'Релативни датум';
$string['requiredbadge'] = 'Треба додати најмање један беџ као критеријум.';
$string['requiredcohort'] = 'Критеријуму за кохорте потребно је додати барем једну кохорту.';
$string['requiredcompetency'] = 'Најмање једну компетенцију треба додати критеријуму компетенције.';
$string['requiredcourse'] = 'Најмање један курс треба додати у критеријум за скуп курсева.';
$string['reviewbadge'] = 'Промене у приступ беџу';
$string['reviewconfirm'] = '<p>Ово ће учинити да ваш беџ буде видљив корисницима и омогућити им да га освоје.</p>

<p>Постоји могућност да неки корисници већ испуњавају критеријуме за добијање овог беџа. Њима ће беџ бити додељен одмах након што га учините доступним.</p>

<p>Једном када је беџ додељен он ће бити <strong>закључан</strong> - одређена подешавања, укључујући критеријуме и време истека, више неће моћи да се мењају.</p>

<p>Да ли сте сигутни да желите да омогућите приступ беџу \'{$a}\'?</p>';
$string['revoke'] = 'Одузми беџ';
$string['save'] = 'Сачувај';
$string['searchname'] = 'Претражи по имену';
$string['selectaward'] = 'Изаберите улогу коју желите да користите за додељивање овог беџа:';
$string['selectgroup_end'] = 'Приказане су само јавне колекције. <a href="{$a}">Посетите свој албум</a> како бисте креирали више јавних колекција беџева.';
$string['selectgroup_start'] = 'Изаберите колекције беџева из свог албума за приказ на овом сајту:';
$string['selecting'] = 'Са изабраним беџевима...';
$string['setup'] = 'Подеси везу';
$string['sitebackpackdeleted'] = 'Албум сајта је обрисан.';
$string['sitebackpacknotdeleted'] = 'Овај албум није могуће обрисати, јер је то тренутно подразумевани албум сајта.';
$string['sitebackpackwarning'] = 'Није могуће повезати се са албумом беџева. <br/><br/>Проверите да ли је у подешавању "Е-адреса издавачa беџа" унета исправна е-адреса за налог на веб сајту албума. <br/><br/>Проверите да ли је "Лозинка издавачa беџа" на <a href="{$a->url}">страници за подешавање албума</a>, исправна за налог на веб сајту албума. <br/><br/>Албум је послао следеће упозорење: "{$a->warning}"';
$string['sitebadges'] = 'Беџеви сајта';
$string['sitebadges_help'] = 'Беџеви на нивоу сајта се могу доделити корисницима само за активности који су вези са сајтом. Ово укључује завршетак скупа курсева или делова корисничких профила. Беџеви сајта могу се, такође, ручно доделити од стране једног корисника другом кориснику.

Беџеви за курсеве морају да се креирају на нивоу курса. Беџеви курса могу да се пронађу под Администрација курса> Беџеви.';
$string['sitebadgetitle'] = '{$a} беџ';
$string['status'] = 'Статус беџа';
$string['status_help'] = 'Статус беџа одређује његова понашање у систему

* **ДОСТУПАН** – значи да корисници могу да зараде овај беџ. Док је беџ доступан корисницима, критеријум за његово добијање не могу да се мењају.

* **НИЈЕ ДОСТУПАН** – значи да беџ није доступан корисницима и да не може бити добијен или ручно додељен. Ако овај беџ претходно уопште није издаван, критеријуми за његово добијање могу да се мењају.

Једном када је беџ додељен барем једном кориснику, он аутоматски постаје **ЗАКЉУЧАН**. Корисници и даље могу добијају закључане беџеве, али критеријуми за добијање тих беџева више не могу да се мењају. Ако желите да мењате податке или критеријуме закључаног беџа, можете направити његову копију и унети све неопходне промене.

*Зашто закључавамо беџеве?*

Желимо да се уверимо да су сви корисници испунили исте услове за добијање беџа. Тренутно, није могуће да се беџ опозове. Уколико бисмо дозволили да се услови за добијање беџа мењају у сваком тренутку, то би на крају, највероватније, довело до тога да имамо кориснике који су исти беџ добили за испуњавање потпуно различитих услова.';
$string['statusmessage_0'] = 'Овај беџ тренутно није доступан корисницима. Омогућите пристуо ако желите да корисници освоје овај беџ.';
$string['statusmessage_1'] = 'Овај беџ је тренутно доступан корисницима. Онемогућите приступ како бисте направили промене.';
$string['statusmessage_2'] = 'Овај беџ тренутно није доступан корисницима. а његови критеријум су закључани. Омогућите приступ ако желите да корисници освоје овај беџ.';
$string['statusmessage_3'] = 'Овај беџ је тренутно доступан корисницима, а његови критеријуми су закључани.';
$string['statusmessage_4'] = 'Овај беџ је тренутно архивиран.';
$string['subject'] = 'Тема поруке';
$string['tagarea_badge'] = 'Беџеви';
$string['tags'] = 'Ознаке';
$string['targetcode'] = 'Кôд';
$string['targetcode_help'] = 'Јединствени идентификациони кôд за референцирање екстерне вештине или стандарда унутар њиховог оквира.';
$string['targetdescription'] = 'Опис';
$string['targetdescription_help'] = 'Кратак опис екстерне вештине или стандарда.';
$string['targetframework'] = 'Оквир';
$string['targetframework_help'] = 'Назив оквира екстерне вештине или стандарда.';
$string['targetname'] = 'Назив';
$string['targetname_help'] = 'Екстерна вештина или стандард који покрива беџ.';
$string['targeturl'] = 'URL адреса';
$string['targeturl_help'] = 'Линк ка страници која описује екстерну вештину или стандард. URL адреса треба да има префикс http:// или https://.';
$string['testbackpack'] = 'Тест албум беџева \'{$a}\'';
$string['testsettings'] = 'Тест подешавања';
$string['type'] = 'Тип';
$string['userbadges'] = 'Беџеви корисника';
$string['variablesubstitution'] = 'Замена променљивих у порукама.';
$string['variablesubstitution_help'] = 'У поруку о беџу, могу да се уметну одређене променљиве у тему и/или тело поруке, тако да, када се шаље порука, променљиве буду замењене са реалним вредностима. Променљиве треба уметнути у текст тачно онако како је доле приказано. Могу се користити следеће променљиве:

%badgename%
: Ово ће бити замењено пуним називом беџа.

%username%
: Ово ће бити замењено именом и презименом добитника беџа.

%badgelink%
: Ово ће бити замењено јавном URL адресом са информацијама о издатом беџу.';
$string['verifyemail'] = 'Потврдите е-адресу';
$string['version'] = 'Верзија';
$string['version_help'] = 'Поље верзије се може користити за праћење развоја беџа. Ако је наведена, верзија беџа приказује се на страници беџа.';
$string['viewbadge'] = 'Погледај издате беџеве';
$string['visible'] = 'Видљиво';
$string['warnexpired'] = '(Овај беџ је истекао!)';
$string['year'] = 'Година(е)';
