<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'h5p', language 'pt', version '4.3'.
 *
 * @package     h5p
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['a11yTitle:label'] = 'Etiqueta para Tecnologias de Apoio';
$string['acceptTerms'] = 'Aceito os <a href=":url" target="_blank">termos de utilização</a>';
$string['accountDetailsLinkText'] = 'aqui';
$string['actions'] = 'Ações';
$string['add'] = 'Adicionar';
$string['addedandupdatedpp'] = 'Adicionadas {$a->%new} novas bibliotecas H5P e atualizadas {$a->%old} bibliotecas antigas.';
$string['addedandupdatedps'] = 'Adicionadas {$a->%new} novas bibliotecas H5P e atualizada {$a->%old} biblioteca antiga.';
$string['addedandupdatedsp'] = 'Adicionada {$a->%new} nova biblioteca H5P e atualizadas {$a->%old} bibliotecas antigas.';
$string['addedandupdatedss'] = 'Adicionada {$a->%new} nova biblioteca H5P e atualizada {$a->%old} biblioteca antiga.';
$string['addednewlibraries'] = 'Adicionadas {$a->%new} novas bibliotecas H5P.';
$string['addednewlibrary'] = 'Adicionada {$a->%new} nova biblioteca H5P.';
$string['additionallicenseinfo'] = 'Informações adicionais sobre a licença';
$string['address'] = 'Endereço';
$string['age'] = 'Idade';
$string['ageDescription'] = 'O público-alvo deste conteúdo. Formatos de entrada possíveis separados por vírgulas: "1,34-45,-50,59-".';
$string['altText'] = 'Texto alt';
$string['atto_h5p'] = 'Botão Inserir H5P';
$string['atto_h5p_description'] = 'O botão Inserir H5P no editor Atto permite aos utilizadores inserir conteúdo H5P digitando um URL ou código de incorporação ou carregando um ficheiro H5P.';
$string['author'] = 'Autor';
$string['authorcomments'] = 'Comentários do autor';
$string['authorcommentsdescription'] = 'Comentários para o editor do conteúdo. (Este texto não será publicado como parte das informações de direitos de autor.)';
$string['authorname'] = 'Nome do autor';
$string['authorrole'] = 'Papel do autor';
$string['back'] = 'Voltar';
$string['by'] = 'por';
$string['cancelCrop'] = 'Cancelar o corte';
$string['cancelPublishConfirmationDialogCancelButtonText'] = 'Não';
$string['cancelPublishConfirmationDialogConfirmButtonText'] = 'Sim';
$string['cancelPublishConfirmationDialogDescription'] = 'Tem a certeza de que pretende cancelar o processo de partilha?';
$string['cancelPublishConfirmationDialogTitle'] = 'Cancelar partilha';
$string['cancellabel'] = 'Cancelar';
$string['ccattribution'] = 'Atribuição (CC BY)';
$string['ccattributionnc'] = 'Atribuição-NãoComercial (CC BY-NC)';
$string['ccattributionncnd'] = 'Atribuição-NãoComercial-SemDerivações (CC BY-NC-ND)';
$string['ccattributionncsa'] = 'Atribuição-NãoComercial-PartilhaIgual (CC BY-NC-SA)';
$string['ccattributionnd'] = 'Atribuição-SemDerivações (CC BY-ND)';
$string['ccattributionsa'] = 'Atribuição-PartilhaIgual (CC BY-SA)';
$string['ccpdd'] = 'Dedicação de Domínio Público (CC0)';
$string['changeHasBeenSubmitted'] = 'Foi submetida uma alteração para';
$string['changedby'] = 'Alterado por';
$string['changedescription'] = 'Descrição da alteração';
$string['changelog'] = 'Relatório das alterações';
$string['changeplaceholder'] = 'Foto recortada, texto modificado, etc.';
$string['city'] = 'Cidade';
$string['close'] = 'Fechar';
$string['confirmCrop'] = 'Confirmar o corte';
$string['confirmdialogbody'] = 'Por favor, confirme que pretende prosseguir. Esta ação é irreversível.';
$string['confirmdialogheader'] = 'Confirmar ação';
$string['confirmlabel'] = 'Confirmar';
$string['connectionLost'] = 'Ligação perdida. Os resultados serão armazenados localmente e enviados quando a ligação for restabelecida.';
$string['connectionReestablished'] = 'Ligação restabelecida.';
$string['contactPerson'] = 'Contacto';
$string['contactPersonDescription'] = 'O H5P entrará em contacto com a pessoa responsável caso haja algum problema com o conteúdo partilhado pelo editor. O nome da pessoa de contacto ou outras informações não serão publicadas ou partilhadas com terceiros';
$string['contentAvailable'] = 'Normalmente, o seu conteúdo estará disponível no Hub dentro de um dia útil.';
$string['contentCopied'] = 'O conteúdo foi copiado para a área de transferência';
$string['contentLicenseTitle'] = 'Informações da licença do conteúdo';
$string['contentUpdateSoon'] = 'O seu conteúdo será atualizado em breve';
$string['contentchanged'] = 'Este conteúdo foi alterado desde a última vez que o usou.';
$string['contentinuse'] = 'Este conteúdo pode estar a ser utilizado em outros locais.';
$string['contenttype'] = 'Tipo de conteúdo';
$string['copyright'] = 'Direitos de utilização';
$string['copyrightWarning'] = 'Material protegido por direitos de autor não pode ser partilhado no Hub de conteúdos H5P. Se o conteúdo for licenciado com uma licença amigável OER (Open Educational Resources), como por exemplo, Creative Commons, escolha a licença apropriada. Caso contrário, este conteúdo não pode ser partilhado.';
$string['copyrightinfo'] = 'Informações sobre direitos de autor';
$string['copyrightstring'] = 'Direitos de autor';
$string['copyrighttitle'] = 'Visualizar informações sobre os direitos de autor referentes a este conteúdo.';
$string['couldNotParseJSONFromZip'] = 'Não foi possível analisar o JSON do pacote: {$a->%fileName}';
$string['couldNotReadFileFromZip'] = 'Não foi possível ler o ficheiro do pacote: {$a->%fileName}';
$string['country'] = 'País';
$string['creativecommons'] = 'Creative Commons';
$string['cropImage'] = 'Cortar a imagem';
$string['currentStep'] = 'Passo :step de :total';
$string['date'] = 'Data e hora';
$string['deletelibraryconfirm'] = '<p>Tem a certeza de que pretende apagar a versão \'<em>{$a->version}</em>\' da biblioteca \'<em>{$a->name}</em>\'? A biblioteca será removida assim como todas as utilizações da mesma.</p><p>Esta operação não é reversível.</p>';
$string['deletelibraryversion'] = 'Apagar versão';
$string['deleting'] = 'A apagar biblioteca';
$string['description'] = 'Descrição';
$string['disablefullscreen'] = 'Desativar o modo de ecrã inteiro';
$string['discipline:dropdownButton'] = 'Botão de contexto';
$string['discipline:in'] = 'em';
$string['discipline:searchPlaceholder'] = 'Digite para procurar disciplinas';
$string['disciplineDescription'] = 'Pode selecionar várias disciplinas';
$string['disciplineLabel'] = 'Disciplinas';
$string['disciplineLimitReachedMessage'] = 'Pode selecionar até :numDisciplines disciplinas';
$string['disciplines'] = 'Disciplinas';
$string['download'] = 'Descarregar';
$string['downloadtitle'] = 'Descarregar este conteúdo como ficheiro H5P.';
$string['editInfoTitle'] = 'Editar informações de <strong>:title</strong>';
$string['editcontent'] = 'Editar conteúdo H5P';
$string['editingFailed'] = 'Ocorreu um erro na edição.';
$string['editor'] = 'Editor';
$string['emailAddress'] = 'E-mail';
$string['emailAddressDescription'] = 'O endereço de e-mail será usado pelo H5P para entrar em contacto com o editor em caso de problemas com o conteúdo ou no caso do editor precisar de recuperar a sua conta. Não será publicado ou partilhado com terceiros';
$string['embed'] = 'Incorporar';
$string['embedtitle'] = 'Visualizar o código de incorporação deste conteúdo.';
$string['error:emptycontentid'] = 'O URL indicado está incorreto ou não pode editar este ficheiro.';
$string['eventh5pdeleted'] = 'H5P apagado';
$string['eventh5pviewed'] = 'Conteúdo H5P visualizado';
$string['feature'] = 'Funcionalidade';
$string['fetchtypesfailure'] = 'Não foi possível obter informações sobre os tipos de conteúdo H5P disponíveis. Ocorreu um erro na ligação ao repositório H5P';
$string['fileExceedsMaxSize'] = 'Um dos ficheiros incluídos no pacote excede o tamanho máximo permitido. ({$a->%file} {$a->%used} > {$a->%max})';
$string['filter_displayh5p'] = 'Filtro Mostrar H5P';
$string['filter_displayh5p_description'] = 'O Filtro Mostrar H5P converte URLs em conteúdo H5P incorporado.';
$string['fullscreen'] = 'Ecrã inteiro';
$string['gpl'] = 'Licença Pública Geral v3';
$string['h5p'] = 'H5P';
$string['h5pcustomcss'] = 'CSS personalizado';
$string['h5pcustomcss_help'] = 'CSS personalizado para aplicar ao conteúdo H5P.';
$string['h5peditor'] = 'Editor H5P';
$string['h5pfilenotfound'] = 'Ficheiro H5P não encontrado';
$string['h5pinvalidurl'] = 'URL de conteúdo H5P inválido.';
$string['h5plibraryhandler'] = 'Controlador de framework H5P';
$string['h5plibraryhandler_help'] = 'O framework H5P usado para exibir os conteúdos H5P. Recomenda-se a versão mais recente.';
$string['h5pmanage'] = 'Gerir tipos de conteúdo H5P';
$string['h5poverview'] = 'Visão global H5P';
$string['h5ppackage'] = 'Tipo de conteúdo H5P';
$string['h5ppackage_help'] = 'Um tipo de conteúdo H5P é um arquivo com extensão H5P ou Zip que contém todas as bibliotecas necessárias para exibir o conteúdo.';
$string['h5pprivatefile'] = 'Este conteúdo H5P não pode ser mostrado porque não tem acesso ao arquivo .h5p.';
$string['h5psettings'] = 'Configurações H5P';
$string['h5ptitle'] = 'Visite h5p.org para mais conteúdos.';
$string['height'] = 'altura';
$string['helpChoosingLicense'] = 'Ajude-me a escolher uma licença';
$string['hideadvanced'] = 'Ocultar Avançado';
$string['icon'] = 'Ícone';
$string['iconDescription'] = '640 x 480 píxeis. Se não for selecionado, o conteúdo usará o ícone da categoria';
$string['installedcontentlibraries'] = 'Bibliotecas H5P instaladas';
$string['installedcontenttypes'] = 'Tipos de conteúdo H5P instalados';
$string['installedh5p'] = 'H5P instalados';
$string['invalidAge'] = 'Formato de entrada inválido para idade. Formatos de entrada possíveis separados por vírgulas: "1, 34-45, -50, -59-".';
$string['invalidcontextid'] = 'Ficheiro H5P não encontrado (contextid inválido)';
$string['invalidfile'] = 'O ficheiro "{$a->%filename}" não é permitido. Apenas são permitidos os ficheiros com as seguintes extensões: {$a->%files-allowed}.';
$string['invalidlanguagefile'] = 'Ficheiro de idioma inválido {$a->%file} na biblioteca {$a->%library}';
$string['invalidlanguagefile2'] = 'Um ficheiro de idioma inválido {$a->%languageFile} foi incluído na biblioteca {$a->%name}';
$string['invalidlibrarydata'] = 'Dados inválidos para {$a->%property} em {$a->%library}';
$string['invalidlibrarydataboolean'] = 'Dados inválidos para {$a->%property} em {$a->%library}. Esperado um dado booleano.';
$string['invalidlibraryname'] = 'Nome de biblioteca inválido: {$a->%name}';
$string['invalidlibrarynamed'] = 'A biblioteca H5P {$a->%library} usada no conteúdo não é válida';
$string['invalidlibraryoption'] = 'Opção não permitida {$a->%option} em {$a->%library}';
$string['invalidlibraryproperty'] = 'Não é possível ler a propriedade {$a->%property} em {$a->%library}';
$string['invalidmainjson'] = 'Não foi encontrado um ficheiro h5p.json válido';
$string['invalidmultiselectoption'] = 'Opção selecionada inválida na seleção múltipla.';
$string['invalidpackage'] = 'Tipo de conteúdo H5P inválido';
$string['invalidselectoption'] = 'Opção selecionada inválida.';
$string['invalidsemanticsjson'] = 'Ficheiro semantics.json inválido foi incluído na biblioteca {$a->%name}';
$string['invalidsemanticstype'] = 'Erro interno do H5P: tipo de conteúdo desconhecido "{$a->@type}" na semântica. A remover o conteúdo!';
$string['invalidstring'] = 'Cadeia de caracteres fornecida não está de acordo com a semântica solicitada pela expressão regular. (value: "{$a->%value}", regexp: "{$a->%regexp}")';
$string['isNowSubmitted'] = 'Foi submetido para o Hub H5P';
$string['keywordExists'] = 'Palavra-chave já existente!';
$string['keywords'] = 'Palavras-chave';
$string['keywordsDescription'] = 'Pode adicionar várias palavras-chave separadas por vírgulas. "Enter" ou "Adicionar" para confirmar as palavras-chave';
$string['keywordsExits'] = 'Palavras-chave já existentes!';
$string['keywordsPlaceholder'] = 'Adicionar palavras-chave';
$string['language'] = 'Idioma';
$string['level'] = 'Nível';
$string['librariesmanagerdescription'] = '<p>O H5P fornece um vasto leque de tipos de conteúdo, o que permite que os utilizadores criem conteúdos interativos.</p><p>Para garantir que apenas sejam usados os tipos de conteúdo confiáveis do H5P no seu site, é necessário:</p><ul><li>Carregar tipos de conteúdo H5P obtidos em h5p.org <i>ou</i></li><li>Ativar a tarefa agendada \'Descarregar os tipos de conteúdo H5P disponíveis em h5p.org\'</li ></ul><p>Tenha em atenção que os utilizadores só poderão usar os tipos de conteúdo H5P instalados no site.</p>';
$string['librarydirectoryerror'] = 'O nome da diretoria de bibliotecas deve corresponder a machineName ou machineName-majorVersion.minorVersion (de library.json).(Directory: {$a->%directoryName} , machineName: {$a->%machineName}, majorVersion: {$a->%majorVersion}, minorVersion: {$a->%minorVersion})';
$string['license'] = 'Licença';
$string['licenseCC010'] = 'CC0 1.0 Universal (CC0 1.0) Dedicação ao Domínio Público';
$string['licenseCC010U'] = 'CC0 1.0 Universal';
$string['licenseCC10'] = '1.0 Genérica';
$string['licenseCC20'] = '2.0 Genérica';
$string['licenseCC25'] = '2.5 Genérica';
$string['licenseCC30'] = '3.0 Não Adaptada';
$string['licenseCC40'] = '4.0 Internacional';
$string['licenseDescription'] = 'Selecione uma licença para o seu conteúdo';
$string['licenseDetails'] = 'Detalhes da licença';
$string['licenseDialogDescription'] = 'Clique numa licença específica para obter informações sobre o uso adequado';
$string['licenseGPL'] = 'Licença Pública Geral';
$string['licenseV1'] = 'Versão 1';
$string['licenseV2'] = 'Versão 2';
$string['licenseV3'] = 'Versão 3';
$string['licenseVersionDescription'] = 'Selecione a versão da licença';
$string['licensee'] = 'Licenciados';
$string['licenseextras'] = 'Extras da Licença';
$string['licenseversion'] = 'Versão da Licença';
$string['lockh5pdeploy'] = 'Este conteúdo H5P não pode ser acedido porque está a ser implementado. Por favor, tente novamente mais tarde.';
$string['logoUploadText'] = 'Logótipo ou Avatar da organização';
$string['longDescription'] = 'Descrição alargada';
$string['longDescriptionPlaceholder'] = 'Descrição alargada do seu conteúdo';
$string['mainTitle'] = 'Partilhar <strong>:title</strong>';
$string['mainlibrarydisabled'] = 'Este ficheiro não pode ser exibido porque o tipo de conteúdo a que pertence está desativado. Contacte o administrador para solicitar a ativação do tipo de conteúdo.';
$string['maxLength'] = 'Número máximo de caracteres: :length';
$string['missingcontentfolder'] = 'Está em falta uma pasta de conteúdo válida';
$string['missingcoreversion'] = 'O sistema não conseguiu instalar o componente \'{$a->%component}\' do pacote. É requerida uma versão mais atual do módulo H5P. Neste site está atualmente instalada a versão \'{$a->%current}\' e é requerida a versão \'{$a->%required}\' ou superior. Faça a atualização e tente novamente.';
$string['missingdependency'] = 'A dependência {$a->@dep} está em falta e é requerida por {$a->@lib}.';
$string['missinglibrary'] = 'A biblioteca requerida \'{$a->@library}\' está em falta';
$string['missinglibraryfile'] = 'O ficheiro "{$a->%file}" está em falta na biblioteca: "{$a->%name}"';
$string['missinglibraryjson'] = 'Não foi possível encontrar o ficheiro library.json com formato JSON válido para a biblioteca {$a->%name}';
$string['missinglibraryproperty'] = 'A propriedade obrigatória \'{$a->%property}\' não foi encontrada em {$a->%library}';
$string['missingmainlibrary'] = 'Biblioteca principal em falta {$a->@library}';
$string['missingmbstring'] = 'A extensão \'mbstring\' do PHP não está carregada. H5P precisa desta extensão para funcionar corretamente';
$string['missinguploadpermissions'] = 'Tenha em atenção que as bibliotecas podem existir no ficheiro enviado, mas não tem permissão para carregar novas bibliotecas. Contacte o administrador do site.';
$string['next'] = 'Seguinte';
$string['nocopyright'] = 'Não existe informação sobre direitos de autor para este conteúdo.';
$string['noextension'] = 'O ficheiro carregado não é um pacote HTML5 válido (não tem a extensão .h5p)';
$string['noh5plibhandlerdefined'] = 'Não existe nenhum controlador de framework H5P instalado. O conteúdo H5P não pode ser exibido.';
$string['nojson'] = 'O ficheiro principal h5p.json não é válido';
$string['nopermissiontodeploy'] = 'Este ficheiro não pode ser exibido porque foi carregado por um utilizador sem a permissão requerida para implantar o conteúdo H5P.';
$string['nopermissiontoedit'] = 'Não tem permissão para editar conteúdo H5P.';
$string['notrustablefile'] = 'Este ficheiro não pode ser exibido porque foi carregado por um utilizador sem a permissão para atualizar os tipos de conteúdo H5P. Contacte o administrador do site para solicitar a instalação deste tipo de conteúdo.';
$string['nounzip'] = 'O ficheiro carregado não é um pacote HTML5 válido (não é possível descompactar)';
$string['offlineDialogBody'] = 'Não foi possível enviar informações sobre a conclusão desta tarefa. Por favor, verifique a sua ligação à Internet.';
$string['offlineDialogHeader'] = 'A ligação com o servidor foi perdida';
$string['offlineDialogRetryButtonLabel'] = 'Voltar a tentar agora';
$string['offlineDialogRetryMessage'] = 'Voltar a tentar dentro de :num...';
$string['offlineSuccessfulSubmit'] = 'Resultados submetidos com sucesso.';
$string['optionalInfo'] = 'Info opcional';
$string['originator'] = 'Criador';
$string['pd'] = 'Domínio Público';
$string['pddl'] = 'Dedicação ao Domínio Público e Licença';
$string['pdm'] = 'Marca de Domínio Público (PDM)';
$string['phone'] = 'Telefone';
$string['pleaseWait'] = 'Aguarde...';
$string['pluginname'] = 'Pacote H5P';
$string['privacy:metadata'] = 'O subsistema H5P não armazena quaisquer dados pessoais.';
$string['publisherDescription'] = 'Descrição do editor';
$string['publisherDescriptionText'] = 'Será exibido em "Informações do editor" no conteúdo partilhado';
$string['publisherFieldDescription'] = 'Será exibido como o "Nome do editor" no conteúdo partilhado';
$string['publisherFieldTitle'] = 'Editor';
$string['registerOnHub'] = 'Registar no Hub H5P';
$string['registrationFailed'] = 'Ocorreu um erro';
$string['registrationFailedDescription'] = 'Ocorreu um erro e não foi possível criar uma conta neste momento. Tente mais tarde.';
$string['registrationTitle'] = 'Registo na Hub H5P';
$string['remove'] = 'Remover';
$string['removeChip'] = 'Remover :chip da lista';
$string['removeImage'] = 'Remover imagem';
$string['requiredInfo'] = 'Informação obrigatória';
$string['resizescript'] = 'Incluir este script no seu site se pretender redimensionamento dinâmico do conteúdo incorporado:';
$string['resubmitScores'] = 'Tentativa de envio dos resultados armazenados.';
$string['reuse'] = 'Reutilizar';
$string['reuseContent'] = 'Reutilizar conteúdo';
$string['reuseDescription'] = 'Reutilizar este conteúdo';
$string['reviewAndSave'] = 'Rever & Guarda';
$string['reviewAndShare'] = 'Rever & Partilhar';
$string['reviewInfo'] = 'Rever informações';
$string['reviewMessage'] = 'Reveja as informações abaixo antes de partilhar';
$string['rotateLeft'] = 'Rodar para a esquerda';
$string['rotateRight'] = 'Rodar para a direita';
$string['saveChanges'] = 'Guardar alterações';
$string['screenshots'] = 'Capturas de ecrã';
$string['screenshotsDescription'] = 'Adicione até cinco capturas de ecrã do seu conteúdo';
$string['share'] = 'Partilhar';
$string['shareFailed'] = 'Erro ao partilhar.';
$string['shareTryAgain'] = 'Ocorreu um erro. Tente partilhar novamente.';
$string['shared'] = 'Partilhado';
$string['sharingNote'] = 'Todos os detalhes do conteúdo podem ser editados após a partilha';
$string['shortDescription'] = 'Descrição curta';
$string['shortDescriptionPlaceholder'] = 'Breve descrição do seu conteúdo';
$string['showadvanced'] = 'Mostrar avançado';
$string['showless'] = 'Mostrar menos';
$string['showmore'] = 'Mostrar mais';
$string['size'] = 'Tamanho';
$string['someKeywordsExits'] = 'Algumas destas palavras-chave já existem';
$string['source'] = 'Origem';
$string['startingover'] = 'Irá começar de novo.';
$string['status'] = 'Estado';
$string['subContentWarning'] = 'O subconteúdo (imagens, perguntas etc.) será partilhado através de :license, a menos que especificado de outra forma na ferramenta de autor';
$string['sublevel'] = 'Subnível';
$string['submitted'] = 'Submetido!';
$string['successfullyRegistred'] = 'Registou com sucesso uma conta no Hub H5P';
$string['successfullyRegistredDescription'] = 'Os detalhes da sua conta podem ser alterados';
$string['successfullyUpdated'] = 'As configurações da sua conta no Hub H5P foram alteradas com sucesso';
$string['task_h5p'] = 'Tarefa agendada do H5P';
$string['task_h5p_description'] = 'A tarefa agendada do H5P descarrega os tipos de conteúdo H5P disponíveis em h5p.org.';
$string['thumbnail'] = 'Miniatura';
$string['title'] = 'Título';
$string['undisclosed'] = 'Não divulgado';
$string['unpackedFilesExceedsMaxSize'] = 'O tamanho total dos ficheiros descompactados excede o tamanho máximo permitido. ({$a->%used} > {$a->%max})';
$string['updateRegistrationOnHub'] = 'Guardar configurações da conta';
$string['updatedlibraries'] = 'Foram atualizadas {$a->%old} bibliotecas H5P.';
$string['updatedlibrary'] = 'Foi atualizada {$a->%old} biblioteca H5P.';
$string['uploadlibraries'] = 'Carregar tipos de conteúdo H5P';
$string['uploadsuccess'] = 'Tipos de conteúdo H5P carregados com sucesso';
$string['width'] = 'largura';
$string['wrongversion'] = 'A versão da biblioteca H5P \'{$a->%machineName}\' usada neste conteúdo não é válida. O conteúdo contém {$a->%contentLibrary} mas deve ser {$a->%semanticsLibrary}.';
$string['year'] = 'Ano';
$string['years'] = 'Anos';
$string['yearsfrom'] = 'Anos (desde)';
$string['yearsto'] = 'Anos (até)';
$string['zip'] = 'Zip';
