<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'publication', language 'de', version '4.3'.
 *
 * @package     publication
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['add_uploads'] = 'Datei hochladen';
$string['allfiles'] = 'Dateiabgaben';
$string['allowedfiletypes'] = 'Akzeptierte Dateitypen';
$string['allowedfiletypes_err'] = 'Bitte Eingabe überprüfen! Dateitypen enthalten ungültige Sonder- oder Trennzeichen';
$string['allowedfiletypes_help'] = 'Die akzeptierten Dateitypen können Sie hier einschränken. Entweder als kommagetrennte Liste aus Mimetypes, z.B. \'video/mp4, audio/mp3, image/png, image/jpeg\', oder als kommagtrennte Liste aus Dateiendungen, z.B, \'.png, .jpg\'. Falls das Feld leer ist, sind alle Dateitypen erlaubt.';
$string['allowsubmissionsanddescriptionfromdatesummary'] = 'Aufgabendetails und Abgabeformular sind ab <strong>{$a}</strong> verfügbar';
$string['allowsubmissionsfromdate'] = 'Ab';
$string['allowsubmissionsfromdate_help'] = 'Wenn diese Option aktiviert ist, können Teilnehmer/innen ihre Dateiabgaben nicht vor diesem Datum einreichen. Ist die Option deaktiviert, können Teilnehmer/innen sofort mit der Einreichung beginnen.';
$string['allowsubmissionsfromdate_import'] = 'Zustimmung erteilen von';
$string['allowsubmissionsfromdate_upload'] = 'Hochladen ab';
$string['allowsubmissionsfromdateh'] = 'Bearbeitungszeitraum (Hochladen bzw. Zustimmung)';
$string['allowsubmissionsfromdateh_help'] = 'Im angegebenen Zeitraum können Teilnehmer/innen Dateien hochladen oder die Zustimmung zur Veröffentlichung und Sichtbarkeit von Dateien geben bzw. verweigern (je nach Modus).';
$string['allowsubmissionsfromdatesummary'] = 'Diese Aufgabe akzeptiert Abgaben ab <strong>{$a}</strong>';
$string['alwaysshowdescription'] = 'Beschreibung immer anzeigen';
$string['alwaysshowdescription_help'] = 'Wenn diese Option deaktiviert ist, wird die Aufgabenbeschreibung für Teilnehmer/innen nur während des Bearbeitungszeitraums angezeigt.';
$string['approval_required'] = 'Freigabe ausstehend';
$string['approval_timeover'] = 'Sie können Ihre Zustimmung nur während der Bearbeitungszeit ändern.';
$string['approvalchange'] = 'Status der Veröffentlichung wurde geändert.';
$string['approved'] = 'Zugestimmt';
$string['approveusers'] = 'Zustimmung erteilen';
$string['assignment'] = 'Aufgabe';
$string['assignment_help'] = 'Aufgabe für die Veröffentlichung von Dateiabgaben von Einzel- oder Gruppeneinreichungen auswählen.';
$string['assignment_notfound'] = 'Die Aufgabe aus der Dateien übernommen wurden, konnte nicht mehr gefunden werden.';
$string['assignment_notset'] = 'Es wurde noch keine Aufgabe ausgewählt.';
$string['availability'] = 'Bearbeitungszeit (Hochladen bzw. Zustimmung)';
$string['choose'] = 'Bitte auswählen ...';
$string['completiondetail:upload'] = 'Datei hochladen';
$string['completionupload'] = 'Teilnehmer/in muss eine Datei hochladen';
$string['configautoimport'] = 'Wenn diese Option aktiviert ist, können Dateiabgaben aus Aufgaben automatisch in Studierendenordner importiert werden. Dieses Feature kann für jeden Studierendenordner separat ein-/ausgeschaltet werden.';
$string['configmaxbytes'] = 'Standardmäßige maximale Dateigröße für Dateien im Studierendenordner.';
$string['configmaxfiles'] = 'Standardmäßige maximale Anzahl von Dateien, die pro Teilnehmer/in im Studierendenordner erlaubt sind.';
$string['configobtainstudentapproval'] = 'Dateien werden erst nach Zustimmung von Teilnehmer/innen und Trainer/innen veröffentlicht (d.h. für alle sichtbar geschaltet).';
$string['configobtainteacherapproval'] = 'Dateien von Teilnehmer/innen werden sofort ohne Überprüfung für alle sichtbar geschaltet.';
$string['configrequiremodintro'] = 'Deaktivieren Sie diese Option, wenn die Eingabe von Beschreibungen für jede Aktivität nicht verpflichtend sein soll.';
$string['courseuploadlimit'] = 'Max. Dateigröße Aktivität';
$string['currentlynotapproved'] = '* Aktuell Veröffentlichung nicht zugestimmt oder verweigert.';
$string['cutoffdate'] = 'Letzter Abgabetermin';
$string['cutoffdate_help'] = 'Diese Funktion sperrt die Abgabe von Lösungen ab diesem Termin, sofern keine Terminverlängerung gewährt wird.';
$string['cutoffdate_import'] = 'Letzte Zustimmung bis';
$string['cutoffdate_upload'] = 'Letzten Hochladen bis';
$string['cutoffdatefromdatevalidation'] = 'Der letzte Abgabetermin muss nach der erstmöglichen Abgabe liegen.';
$string['cutoffdatevalidation'] = 'Der letzte Abgabetermin muss nach dem Abgabebeginn liegen.';
$string['details'] = 'Details';
$string['downloadall'] = 'Alle Dateiabgaben herunterladen';
$string['duedate'] = 'Bis';
$string['duedate_help'] = 'Zum Abgabeende wird die Aufgabe fällig. Wenn spätere Abgaben erlaubt sind, wird jede nach diesem Datum eingereichte Abgabe als verspätet markiert. Um eine Abgabe nach einem bestimmten Verspätungsdatum zu verhindern, kann ein letzter Abgabetermin gesetzt werden.';
$string['duedate_import'] = 'Zustimmung erteilen bis';
$string['duedate_upload'] = 'Hochladen bis';
$string['duedatevalidation'] = 'Das Abgabeende muss später als der Abgabebeginn sein.';
$string['edit_timeover'] = 'Dateien können nur während der Bearbeitungszeit geändert werden.';
$string['edit_uploads'] = 'Dateien hochladen + verwalten';
$string['emailstudentsmail'] = '{$a->username} hat den Veröffentlichungsstatus zu \'{$a->filename}\' für \'{$a->publication}\' auf {$a->apstatus} am {$a->dayupdated} um {$a->timeupdated} geändert. Hier verfügbar: {$a->url}';
$string['emailstudentsmailhtml'] = '{$a->username} hat den Veröffentlichungsstatus zu \'{$a->filename}\' für <i>\'{$a->publication}\'</i> auf <b>{$a->apstatus}</b> am {$a->dayupdated} um {$a->timeupdated}</i> geändert.<br /><br /> Verfügbar auf dieser <a href="{$a->url}">Seite</a>.';
$string['emailteachermail'] = '---------------------------------------------------------------------\\n{$a->username} hat \'{$a->filename}\' für \'{$a->publication}\' am {$a->dayupdated} um {$a->timeupdated} hochgeladen.

Hier verfügbar:

    {$a->url}---------------------------------------------------------------------\\n';
$string['emailteachermailhtml'] = '{$a->username} hat \'{$a->filename}\' für <i>\'{$a->publication}\' am {$a->dayupdated} um {$a->timeupdated} hochgeladen</i><br /><br />
Verfügbar auf dieser <a href="{$a->url}">Seite</a>.';
$string['entiresperpage'] = 'Einträge pro Seite';
$string['eventpublicationapprovalchanged'] = 'Studierendenordner: Dateizustimmung wurde geändert';
$string['eventpublicationduedateextended'] = 'Studierendenordner: Abgabeende wurde verlängert';
$string['eventpublicationfiledeleted'] = 'Studierendenordner: Datei wurde gelöscht';
$string['eventpublicationfileimported'] = 'Studierendenordner: Datei wurde importiert';
$string['eventpublicationfileuploaded'] = 'Studierendenordner: Datei wurde hochgeladen';
$string['extensionduedate'] = 'Erweiterung des Abgabeendes';
$string['extensionnotafterduedate'] = 'Das erweiterte Abgabeende muss nach dem (normalen) Abgabeende liegen.';
$string['extensionnotafterfromdate'] = 'Das erweiterte Abgabeende muss nach Abgabeende liegen.';
$string['extensionto'] = 'Erweiterung bis';
$string['filedetails'] = 'Details';
$string['filesofthesetypes'] = 'Dateien dieses Typs können hinzugefügt werden:';
$string['filter'] = 'Filter';
$string['filter:allfiles'] = 'Alle Dateiabgaben';
$string['filter:approvalrequired'] = 'Entscheidung ausstehend';
$string['filter:approved'] = 'Zustimmung erteilt';
$string['filter:nofiles'] = 'Keine Dateiabgabe vorhanden';
$string['filter:nofilter'] = 'Kein Filter';
$string['filter:rejected'] = 'Zustimmung verweigert';
$string['giveapproval'] = 'Zustimmung erteilen';
$string['go'] = 'Start';
$string['grantextension'] = 'Verlängerung zulassen';
$string['groupapprovalmode'] = 'Zustimmung durch Gruppe';
$string['groupapprovalmode_all'] = 'von ALLEN Mitgliedern erforderlich';
$string['groupapprovalmode_help'] = 'Hier legen Sie fest, ob die Zustimmung aller Gruppenmitglieder oder eines einzelnen Gruppenmitglieds notwendig ist, um Dateien aus Gruppeneinreichungen zu veröffentlichen.';
$string['groupapprovalmode_single'] = 'von MINDESTENS EINEM Mitglied erforderlich';
$string['groupapprovalmode_title'] = 'Zustimmung durch Gruppe';
$string['guideline'] = 'Veröffentlichung von Dateiabgaben';
$string['hidden'] = 'Verborgen';
$string['importfrom_err'] = 'Sie müssen eine Aufgabe auswählen, aus welcher Sie Dateiabgaben übernehmen möchten.';
$string['maxbytes'] = 'Maximale Dateigröße';
$string['maxfiles'] = 'Anzahl hochladbarer Dateien';
$string['messageprovider:publication_updates'] = 'Studierendenordner Benachrichtigungen';
$string['mode'] = 'Modus';
$string['mode_help'] = 'Legen Sie fest, ob Teilnehmer/innen hier Dokumente hochladen können oder ob ihre Abgaben aus einer Aufgabe übernommen werden sollen.';
$string['modeimport'] = 'Dateien aus Aufgabe übernehmen';
$string['modeupload'] = 'Dateien direkt hochladen';
$string['modulename'] = 'Studierendenordner';
$string['modulename_help'] = 'Der Studierendenordner bietet folgende Funktionen:<br><ul><li>Teilnehmer/innen können Dateien hochladen, welche veröffentlicht werden, nachdem Trainer/innen diese überprüft und der Veröffentlichung zugestimmt haben.</li><li>Eine Aufgaben-Aktivität kann als Grundlage für einen Studierendenordner genutzt werden. Trainer/innen können entscheiden, welche Dateien der Aufgabe veröffentlicht werden (d.h. für alle Teilnehmer/innen sichtbar sein sollen). Trainer/innen können zusätzlich Teilnehmer/innen der Veröffentlichung zustimmen lassen und so selbst entscheiden, ob deren Dateien für alle sichtbar sind.</li></ul>';
$string['modulenameplural'] = 'Studierendenordner';
$string['myfiles'] = 'Meine Dateien';
$string['mygroupfiles'] = 'Meine Gruppendateien';
$string['name'] = 'Name des Studierendenordners';
$string['noentries'] = 'Keine Einträge';
$string['nofiles'] = 'Keine Dateien vorhanden';
$string['nofilestodisplay'] = 'Aktuell sind noch keine Dateien vorhanden bzw. noch nicht veröffentlicht.';
$string['nofilestozip'] = 'Keine Dateien zu zippen';
$string['nonexistentfiletypes'] = 'Die folgenden Dateitypen konnten nicht erkannt werden: {$a}';
$string['nopublicationsincourse'] = 'In diesem Kurs gibt es keinen Studierendenordner.';
$string['nothing_to_show_groups'] = 'Nichts anzuzeigen - keine Gruppen vorhanden';
$string['nothing_to_show_users'] = 'Nichts anzuzeigen - keine Teilnehmer/innen vorhanden';
$string['nothingtodisplay'] = 'Keine Einträge';
$string['notice'] = '<strong>Hinweis: </strong>';
$string['notice_groupimportrequireallapproval'] = 'Die angezeigten Dateien stammen aus einer Aufgabe mit Gruppeneinreichung. Die Dateien werden erst durch Zustimmung von ALLEN Gruppenmitgliedern und Trainer/innen für alle veröffentlicht. Klären Sie die Veröffentlichung vorab gruppenintern ab.<br>
Änderungen an vorhandenen Dateien sind ausschließlich in der ursprünglichen Aufgabe möglich.';
$string['notice_groupimportrequireoneapproval'] = 'Die angezeigten Dateien stammen aus einer Aufgabe mit Gruppeneinreichung. Die Dateien werden erst durch Zustimmung von EINEM Gruppenmitglied und Trainer/innen für alle veröffentlicht. Klären Sie die Veröffentlichung vorab gruppenintern ab.<br>
Änderungen an vorhandenen Dateien sind ausschließlich in der ursprünglichen Aufgabe möglich.';
$string['notice_importnoapproval'] = 'Alle Dateien die Sie hier hochladen, werden erst nach Zustimmung von Trainer/innen veröffentlicht.';
$string['notice_importrequireapproval'] = 'Alle Dateien werden erst nach Zustimmung von Ihnen und den Trainer/innen veröffentlicht.<br>Änderungen an vorhandenen Dateien sind ausschließlich in der ursprünglichen Aufgabe möglich.';
$string['notice_obtainapproval_import_both'] = 'Als Trainer/in können Sie jederzeit die Zustimmung zur Veröffentlichung verweigern oder aufheben, sollte eine Datei nicht den definierten Anforderungen entsprechen.';
$string['notice_obtainapproval_import_studentonly'] = 'Im Sinne des Urheberrechts bitten wir Sie, die Zustimmung zur Veröffentlichung von Dateien von Teilnehmer/innen auf separatem Weg anzufragen.<br>
Als Trainer/in können Sie jederzeit den Status der Veröffentlichung aufheben, sollte eine Datei nicht den definierten Anforderungen entsprechen.';
$string['notice_obtainapproval_upload_automatic'] = 'Im Sinne des Urheberrechts bitten wir Sie, die Zustimmung zur Veröffentlichung von Dateien von Teilnehmer/innen auf separatem Weg anzufragen.<br>
Als Trainer/in können Sie jederzeit den Status der Veröffentlichung aufheben, sollte eine Datei nicht den definierten Anforderungen entsprechen.';
$string['notice_obtainapproval_upload_teacher'] = 'Im Sinne des Urheberrechts bitten wir Sie, die Zustimmung zur Veröffentlichung von Dateien von Teilnehmer/innen auf separatem Weg anzufragen.<br>
Als Trainer/in können Sie jederzeit den Status der Veröffentlichung aufheben, sollte eine Datei nicht den definierten Anforderungen entsprechen.';
$string['notice_obtainteacherapproval_studentsapproval'] = 'Im Sinne des Urheberrechts bitten wir Sie, die Zustimmung zur Veröffentlichung von Dateien von Teilnehmer/innen auf separatem Weg einzuholen.';
$string['notice_uploadnoapproval'] = 'Alle Dateien, die Sie hier hochladen, werden sofort veröffentlicht (d.h. für alle sichtbar). Trainer/innen behalten sich das Recht vor, die Veröffentlichung von Dateien wieder zurückzunehmen.';
$string['notice_uploadrequireapproval'] = 'Alle Dateien, die Sie hier hochladen, werden erst nach Zustimmung der Trainer/innen veröffentlicht.<br>
Trainer/innen behalten sich das Recht vor, die Veröffentlichung von Dateien wieder zurückzunehmen.';
$string['notifications'] = 'Benachrichtigungen';
$string['notifystudents'] = 'Teilnehmer/innen über Änderungen der Veröffentlichung informieren';
$string['notifystudents_help'] = 'Wenn diese Option aktiviert ist, erhalten Teilnehmer/innen eine Benachrichtigung, sobald sich der Status der Veröffentlichung einer ihrer hochgeladenen Dateien ändert.';
$string['notifyteacher'] = 'Trainer/innen über Dateiabgaben informieren';
$string['notifyteacher_help'] = 'Wenn diese Option aktiviert ist, erhalten Trainer/innen eine Benachrichtigung, sobald Teilnehmer/innen eine Datei hochladen.';
$string['obtainstudentapproval'] = 'Veröffentlichung von Dateiabgaben';
$string['obtainstudentapproval_help'] = 'Diese Option legt fest, wie die Veröffentlichung (Sichtbarkeit) von Dateiabgaben stattfindet: <br><ul><li><strong>Zustimmung von Trainer/innen erforderlich</strong> - Einträge werden von Trainer/innen geprüft und veröffentlicht</li><li><strong>Zustimmung von Teilnehmer/innen und Trainer/innen erforderlich</strong> - Teilnehmer/innen und Trainer/innen müssen der Veröffentlichung von Einträgen zustimmen, sonst sind diese nicht sichtbar</li></ul>';
$string['obtainstudentapproval_participant'] = 'Zustimmung von Teilnehmer/innen und Trainer/innen erforderlich';
$string['obtainstudentapproval_teacher'] = 'Zustimmung von Trainer/innen erforderlich';
$string['obtainstudentapproval_yes'] = 'Zustimmung von Teilnehmer/innen und Trainer/innen erforderlich';
$string['obtainteacherapproval'] = 'Veröffentlichung von Dateiabgaben';
$string['obtainteacherapproval_help'] = 'Diese Option legt fest, wie die Veröffentlichung (Sichtbarkeit) von Dateiabgaben stattfindet: <br><ul><li><strong>Zustimmung von Trainer/innen erforderlich</strong> - Einträge werden von Trainer/innen geprüft und veröffentlicht</li><li><strong>Automatisch Zustimmung erteilen</strong> - keine manuelle Zustimmung von Trainer/innen erforderlich, Veröffentlichung erfolgt direkt nach dem Hochladen</li></ul>';
$string['obtainteacherapproval_no'] = 'Zustimmung von Trainer/innen erforderlich';
$string['obtainteacherapproval_yes'] = 'Automatisch Zustimmung erteilen';
$string['optionalsettings'] = 'Optionen';
$string['overdue'] = 'Bearbeitungszeitraum überschritten';
$string['overview'] = 'Überblick';
$string['pending'] = 'Ausstehend';
$string['pluginadministration'] = 'Studierendenordner Administration';
$string['pluginname'] = 'Studierendenordner';
$string['privacy:metadata:approval'] = 'Speichert, ob das Gruppenmitglied die Zustimmung zur Veröffentlichung erteilt oder verweigert hat.';
$string['privacy:metadata:contenthash'] = 'SHA1 hash des Dateiinhalts, wird zur Feststellung von Dateiänderungen genutzt.';
$string['privacy:metadata:extduedates'] = 'Speichert Informationen über überschriebene/verlängerte Fälligkeitsdaten für das Modul Studierendenordner.';
$string['privacy:metadata:extensionduedate'] = 'Das für Teilnehmer/innen durch die Verlängerung gültige Fälligkeitsdatum.';
$string['privacy:metadata:fileid'] = 'Kennung der Datei.';
$string['privacy:metadata:filename'] = 'Dateiname.';
$string['privacy:metadata:files'] = 'Speichert Informationen über Dateien, die in das Modul Studierendenordner hochgeladen/importiert werden (Kennung, wem sie gehören, woher sie kommen, Hash des Inhalts, Dateiname und Bestätigung durch Lehrende und/oder Teilnehmer).';
$string['privacy:metadata:groupapproval'] = 'Speichert Informationen über die erteilte oder verweigerte Zustimmung von Dateien durch Gruppenmitglieder, importiert aus einer Gruppeneinreichung.';
$string['privacy:metadata:publicationfileexplanation'] = 'Dateien und konvertierte Onlinetextaufgaben für dieses Plugin werden durch die Moodle Datei-API gespeichert.';
$string['privacy:metadata:publicationperpage'] = 'Wie viele Einträge auf einer einzelnen Tabellenseite angezeigt werden sollen!';
$string['privacy:metadata:studentapproval'] = 'Ob die Person ihre Zustimmung zur Veröffentlichung einer Datei erteilt oder verweigert hat.';
$string['privacy:metadata:teacherapproval'] = 'Ob Trainer/innen die Zustimmung zur Veröffentlichung einer Datei gegeben oder verweigert haben';
$string['privacy:metadata:timecreated'] = 'Uhrzeit und Datum, zu dem der Datensatz erzeugt wurde.';
$string['privacy:metadata:timemodified'] = 'Uhrzeit und Datum der letzten Aktualisierung/Änderung des Datensatzes.';
$string['privacy:metadata:type'] = 'Markiert die Originalversion der Datei oder des Onlinetexts, hochgeladen und importiert oder konvertiert aus der Aktivität.';
$string['privacy:metadata:userid'] = 'Nutzerkennung.';
$string['privacy:path:files'] = 'Dateien';
$string['privacy:path:resources'] = 'Ressourcen';
$string['privacy:type:import'] = 'Importierte Datei';
$string['privacy:type:onlinetext'] = 'Importierter Onlinetext';
$string['privacy:type:upload'] = 'Hochgeladene Datei';
$string['publication:addinstance'] = 'Studierendenordner hinzufügen';
$string['publication:approve'] = 'Entscheiden Sie, ob Dateien veröffentlicht (d.h. für alle Teilnehmer/innen sichtbar) sein sollen';
$string['publication:grantextension'] = 'Verlängerung zulassen';
$string['publication:receiveteachernotification'] = 'Benachrichtigung für Trainer/innen empfangen';
$string['publication:upload'] = 'Dateien in den Studierendenordner hochladen';
$string['publication:view'] = 'Studierendenordner anzeigen';
$string['publicationstatus'] = 'Veröffentlichung';
$string['publicationstatus_help'] = 'Der Status der Veröffentlichung stellt die Zustimmung der Trainer/in sowie die endgültige Veröffentlichung dar: <ul><li><i class="fa fa-check text-success fa-fw"></i> Datei ist veröffentlicht und somit für alle Teilnehmer/innen sichtbar</li><li><i class="fa fa-times text-danger fa-fw"></i> Datei ist nicht veröffentlicht (Zustimmung ist noch nicht erfolgt oder wurde verweigert) und somit nicht sichtbar</li></ul>';
$string['publicfiles'] = 'Veröffentlichte Dateien';
$string['published_aftercheck'] = 'Zustimmung von Trainer/innen erforderlich';
$string['published_immediately'] = 'Automatische Zustimmung';
$string['rejected'] = 'Abgelehnt';
$string['rejectusers'] = 'Zustimmung verweigern';
$string['requiremodintro'] = 'Beschreibung notwendig';
$string['reset'] = 'Zurücksetzen';
$string['reset_userdata'] = 'Alle Daten';
$string['resetstudentapproval'] = 'Zustimmung zurücksetzen';
$string['save_changes'] = 'Änderungen speichern';
$string['saveapproval'] = 'Änderungen speichern';
$string['savestudentapprovalwarning'] = 'Möchten Sie diese Änderungen wirklich speichern? Der Status der Veröffentlichung kann im Nachhinein nicht mehr geändert werden.';
$string['saveteacherapproval'] = 'Änderungen speichern';
$string['search:activity'] = 'Studierendenordner - Aktivitätsinformation';
$string['show_details'] = 'Details anzeigen';
$string['status'] = 'Status';
$string['status:approved'] = 'Zustimmung erteilt';
$string['status:approvednot'] = 'Zustimmung verweigert';
$string['status:approvedrevoke'] = 'Zurückgezogen';
$string['student_approve'] = 'Zustimmen';
$string['student_approved'] = 'Zustimmung erteilt';
$string['student_pending'] = 'Entscheidung ausstehend';
$string['student_reject'] = 'Verweigern';
$string['student_rejected'] = 'Zustimmung verweigert';
$string['studentapproval'] = 'Zustimmung (Teilnehmer/innen)';
$string['studentapproval_help'] = 'In der Spalte "Zustimmung (Teilnehmer/innen)" wird die Rückmeldung der Teilnehmer/innen angezeigt:<br><ul><li><i class="fa fa-question fa-fw text-warning"></i> - Entscheidung ausstehend</li><li><i class="fa fa-check text-success fa-fw"></i> - Zustimmung erteilt</li><li><i class="fa fa-times text-danger fa-fw"></i> - Zustimmung verweigert</li></ul>';
$string['teacher_approve'] = 'Zustimmen';
$string['teacher_approved'] = 'Veröffentlicht';
$string['teacher_pending'] = 'Entscheidung ausstehend';
$string['teacher_reject'] = 'Verweigern';
$string['teacher_rejected'] = 'Nicht veröffentlicht (Zustimmung verweigert)';
$string['teacherapproval'] = 'Zustimmung';
$string['teacherapproval_help'] = 'Aktuelle Zustimmung/ Ablehnung von Dateien, d.h. ob diese für alle Teilnehmer/innen sichtbar sind: <br><ul><li><strong>Auswählen...</strong> - Entscheidung ausstehend/ keine Zustimmung erteilt oder verweigert, diese Dateien sind nicht sichtbar.</li><li><strong>Zustimmen</strong> - Zustimmung erteilt, diese Dateien sind veröffentlicht und somit für alle sichtbar.</li><li><strong>Verweigern</strong> - keine Zustimmung erteilt, diese Dateien sind nicht veröffentlicht und somit nicht sichtbar.</li></ul>';
$string['total'] = 'Gesamt';
$string['updatefiles'] = 'Dateien aktualisieren';
$string['updatefileswarning'] = 'Bereits importierte Dateien werden ersetzt oder entfernt, wenn die ursprünglichen Dateien in der Aufgabe geändert oder gelöscht wurden. Die Zustimmung zur Veröffentlichung durch Teinehmer/innen bleibt unverändert.';
$string['uploaded'] = 'Hochgeladen';
$string['visibility'] = 'Veröffentlicht';
$string['visible'] = 'Veröffentlicht';
$string['visibleforstudents'] = 'Veröffentlicht';
$string['visibleforstudents_no'] = 'Diese Datei ist nicht veröffentlicht (d.h. für Teilnehmer/innen nicht sichtbar).';
$string['visibleforstudents_yes'] = 'Diese Datei ist veröffentlicht (d.h. für Teilnehmer/innen sichtbar).';
$string['warning_changefromobtainstudentapproval'] = 'Wenn Sie diese Änderung durchführen, können nur Sie bestimmen welche Dateien für alle Teilnehmer/innen veröffentlicht sind. Die Zustimmung von Teilnehmer/innen wird nicht eingeholt. Alle zur Veröffentlichung gekennzeichneten Dateien werden unabhängig von der Teilnehmer/innen-Zustimmung nach dieser Änderung sofort veröffentlicht und dadurch für alle Teilnehmer/innen sichtbar.';
$string['warning_changefromobtainteacherapproval'] = 'Wenn Sie diese Änderung durchführen, werden hochgeladene Dateien sofort für alle Teilnehmer/innen sichtbar. Alle bisher hochgeladenen Dateien werden ebenfalls veröffentlicht. Sie haben jedoch die Möglichkeit, einzelnen Teilnehmer/innen die Sichtbarkeit aktiv zu entziehen.';
$string['warning_changetoobtainstudentapproval'] = 'Wenn Sie diese Änderung durchführen, wird die Zustimmung der Teilnehmer/innen eingeholt. Nach dieser Änderung wird für alle als "veröffentlicht" gekennzeichneten Dateien, die Zustimmung der jeweiligen Teilnehmer/innen eingeholt. Die Dateien sind dadurch erst deren Rückmeldung für alle veröffentlicht (d.h. sichtbar).';
$string['warning_changetoobtainteacherapproval'] = 'Wenn Sie diese Änderung durchführen werden hochgeladene Dateien nicht sofort für andere Teilnehmer/innen sichtbar. Sie müssen dadurch Dateien von Teilnehmer/innen aktiv sichtbar schalten. Alle bis jetzt hochgeladenen Dateien werden mit diesem Schritt ebenfalls veröffentlicht.';
$string['withselected'] = 'Mit Auswahl...';
$string['zipusers'] = 'Ausgewählte Dateiabgaben herunterladen';
