<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'newsletter', language 'de', version '4.3'.
 *
 * @package     newsletter
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['account_already_confirmed'] = 'Ihr Account wurde bereits aktiviert. Um zum Newsletter zu gelangen, klicken Sie bitte auf folgenden Link:  {$a->newsletterlink}.';
$string['account_confirmed'] = 'Willkommen bei {$a->sitename}, {$a->fullname}!

Ihr Account {$a->username} wurde aktiviert.
Um Ihre Profildetails zu bearbeiten, klicken Sie bitte auf folgenden Link: {$a->editlink}.
Um zum Newsletter zu gelangen, klicken Sie bitte auf folgenden Link:  {$a->newsletterlink}.';
$string['allusers'] = 'Nutzer/innen (inklusive Abgemeldete):';
$string['already_published'] = 'Die Ausgabe wurde veröffentlicht.';
$string['attachments'] = 'Anhänge';
$string['attachments_help'] = 'Laden Sie hier Dateien hoch, die Sie als Anhang mit dieser Ausgabe versenden möchten.';
$string['cohortmanagement'] = 'Globale Gruppen an/abmelden';
$string['cohortsavailable'] = 'Verfügbare Globale Gruppen';
$string['config_activation_timeout_desc'] = 'Wählen Sie hier, für wie viele Tage der per Email versendete Aktivierungslink gültig sein soll.';
$string['config_activation_timeout_label'] = 'Ablaufzeitpunkt für Aktivierungslinks';
$string['config_bounce_email'] = 'Die E-Mail-Adresse an die die Bounces geschickt werden sollen. Benutzen Sie diese E-Mailadresse ausschließlich zum Bounce Handling.';
$string['config_bounce_enable'] = 'Bounce Processing für das Newslettermodul aktivieren';
$string['config_bounceinfo'] = 'Bounce Handling  für Newslettermodul nur dann verwenden, wenn Moodle VERP Bounce Einstellungen wie auf der folgenden Seite beschrieben nicht aktiviert werden können:
https://docs.moodle.org/dev/Email_processing
Die Verwendung der VERP Moodle Methode ist nicht auf jedem System möglich und die Einrichtung kompliziert. Dies ist eine simplere Alternative, die aber nur für das Newslettermodul funktioniert. Nach Speichern der Einstellungen testen Sie diese unter {$a}';
$string['config_bounceprocessing'] = 'Einstellungen für Bounce Handling: Geben Sie hier die Logindaten der Bounce-Mailadresse an.';
$string['config_debug_desc'] = 'Aktivieren Sie diese Checkbox, um den Debug-Output im Cronjob anzuzeigen.';
$string['config_debug_label'] = 'Cron Debug Modus';
$string['config_host'] = 'Mailserver (ex. mail.yourserver.com)';
$string['config_password'] = 'Mailbox Passwort';
$string['config_port'] = 'Der Port über den Sie sich mit der Mailbox verbinden; Standard: 143, andere gängige Möglichkeiten sind 110 (POP3), 995 (Gmail)';
$string['config_send_notifications_desc'] = 'Aktivieren Sie diese Checkbox, um das Senden von Abonnement-spezifischen Benachrichtigungen an Abonnent/inn/en einzuschalten.';
$string['config_send_notifications_label'] = 'Benachrichtigungen senden';
$string['config_service'] = 'zu benutzendes Protokoll';
$string['config_service_option'] = 'Verschlüsselung (keine, tls, notls, ssl)';
$string['config_username'] = 'Mailbox Benutzername';
$string['create_new_issue'] = 'Neue Newsletter-Ausgabe erstellen';
$string['default_stylesheet'] = 'Standard-Stylesheet';
$string['delete_all_subscriptions'] = 'Alle Abonnements löschen';
$string['delete_issue'] = 'Diese Newsletter-Ausgabe löschen';
$string['delete_issue_question'] = 'Sind Sie sicher, dass Sie diese Newsletter-Ausgabe löschen wollen?';
$string['delete_subscription_question'] = 'Sind Sie sicher, dass Sie dieses Newsletter-Abonnement kündigen wollen?';
$string['edit_issue'] = 'Diese Ausgabe bearbeiten';
$string['edit_issue_title'] = 'Newsletter-Ausgabe bearbeiten';
$string['edit_subscription_title'] = 'Abonnement bearbeiten';
$string['emailexists'] = 'Es existiert bereits ein Benutzeraccount mit dieser E-Mailadresse, eine erneute Anlage ist daher nicht nötig. Bitte loggen Sie sich ein, um diesen Newsletter zu abonnieren.

Sollten Sie Ihre Zugangsdaten vergessen haben, benutzen Sie bitte den {$a} Link auf der Login-Seite um Ihr Passwort zurücksetzen zu lassen.';
$string['entries_per_page'] = 'Angezeigte Einträge pro Seite';
$string['eventissuecreated'] = 'Newsletter-Ausgabe wurde erstellt';
$string['eventissueviewed'] = 'Newsletter-Ausgabe wurde angezeigt';
$string['eventsubscriptioncreated'] = 'Neues Newsletter-Abonnement';
$string['eventsubscriptiondeleted'] = 'Newsletter-Abonnement gelöscht';
$string['eventsubscriptionsviewed'] = 'Newsletter-Abonnements angezeigt';
$string['eventsubscriptionunsubscribed'] = 'Abmeldung von Newsletter';
$string['filteredusers'] = 'Benutzer gefiltert:';
$string['guestsubscribe'] = 'Abonnieren Sie jetzt!';
$string['guestsubscriptionsuccess'] = 'Ihre E-Mailadresse wurde erfolgreich registriert. <br /> Um Ihr Abonnement zu bestätigen,  überprüfen Sie bitte Ihre Mailbox ({$a}) und klicken Sie auf den darin enthaltenen Bestätigungslink.';
$string['header_actions'] = 'Aktionen';
$string['header_content'] = 'Inhalt der Newsletter-Ausgabe';
$string['header_email'] = 'E-Mail';
$string['header_health'] = 'Status';
$string['header_name'] = 'Name';
$string['header_publish'] = 'Veröffentlichungsoptionen';
$string['header_publishinfo'] = 'Hat die Veröffentlichung einer Newsletter-Ausgabe einmal begonnen, kann das Veröffentlichungs-Datum nicht mehr verändert werden.';
$string['header_subscriberid'] = 'Angemeldet von';
$string['header_timestatuschanged'] = 'Letzte Statusänderung';
$string['header_timesubscribed'] = 'Abonnement-Anmeldedatum';
$string['header_unsubscriberid'] = 'Abgemeldet von';
$string['health_0'] = 'Aktiv';
$string['health_1'] = 'Problematisch';
$string['health_2'] = 'Blacklisted';
$string['health_4'] = 'Abgemeldet';
$string['issue_htmlcontent'] = 'HTML Inhalt';
$string['issue_stylesheet'] = 'Stylesheet-Datei für HTML Inhalt';
$string['issue_title'] = 'Ausgabentitel';
$string['issue_title_help'] = 'Geben Sie hier den Titel der Ausgabe ein (erforderlich).';
$string['manage_subscriptions'] = 'Abonnements verwalten';
$string['mode_group_by_month'] = 'Ausgaben nach Erscheinungsmonat gruppieren';
$string['mode_group_by_week'] = 'Ausgaben nach Erscheinungswoche gruppieren';
$string['mode_group_by_year'] = 'Ausgaben nach Erscheinungsjahr gruppieren';
$string['modulename'] = 'Newsletter';
$string['modulename_help'] = 'Das Newslettermodul ermöglicht das Veröffentlichen von E-Mail-Newslettern.';
$string['modulenameplural'] = 'Newsletter';
$string['newsletter'] = 'Newsletter';
$string['newsletter:addinstance'] = 'Newsletter hinzufügen';
$string['newsletter:createissue'] = 'Eine neue Newsletter-Ausgabe erstellen';
$string['newsletter:deleteissue'] = 'Eine Newsletter-Ausgabe löschen';
$string['newsletter:deletesubscription'] = 'Newsletter-Abonnements löschen';
$string['newsletter:editissue'] = 'Eine Newsletter-Ausgabe bearbeiten';
$string['newsletter:editsubscription'] = 'Newsletter-Abonnements bearbeiten';
$string['newsletter:manageownsubscription'] = 'Mein Newsletter-Abonnement verwalten';
$string['newsletter:managesubscriptions'] = 'Newsletter-Abonnements verwalten';
$string['newsletter:publishissue'] = 'Eine Newsletter-Ausgabe veröffentlichen';
$string['newsletter:readissue'] = 'Eine Newsletter-Ausgabe lesen';
$string['newsletter:subscribecohort'] = 'Globale Gruppe für den Newsletter anmelden';
$string['newsletter:subscribeuser'] = 'Nutzer/innen für den Newsletter anmelden';
$string['newsletter:unsubscribecohort'] = 'Globale Gruppe vom Newsletter abmelden';
$string['newsletter:viewnewsletter'] = 'Newsletter-Instanz anzeigen';
$string['newsletterintro'] = 'Beschreibung';
$string['newslettername'] = 'Name';
$string['newslettername_help'] = 'Dies ist der Inhalt des Hilfe Werkzeugtipps für das Newsletterfeld. Markdown-Syntax wird unterstützt.';
$string['no_issues'] = 'Zu diesem Newsletter bestehen noch keine Ausgaben.';
$string['page_first'] = 'Erste Seite';
$string['page_last'] = 'Letzte Seite';
$string['page_next'] = 'Nächste';
$string['page_previous'] = 'Vorherige';
$string['pluginadministration'] = 'Newsletter Administration';
$string['pluginname'] = 'Newsletter';
$string['publish_in'] = 'Veröffentlichung in {$a->days} Tagen, {$a->hours} Stunden, {$a->minutes} Minuten, {$a->seconds} Sekunden';
$string['publishon'] = 'Veröffentlichen am';
$string['stylesheets'] = 'Newsletter-Stylesheets hochladen';
$string['stylesheets_help'] = 'Laden Sie hier CSS-Dateien hoch, die als Stylesheets für die Ausgaben des Newsletters Verwendung finden sollen. Sie können mehr als eine Datei hochladen und anschließend aus diesen wählen, wenn Sie neue neue Ausgabe erstellen. Dieses Feld ist optional, da das Modul bereits mit mindestens einer vorhandenen Stylesheet-Datei ausgestattet ist.';
$string['sub_mode_forced'] = 'Verpflichtend (automatisches Abo ohne Abmeldemöglichkeit)';
$string['sub_mode_opt_in'] = 'Opt-in (Abo muss durch Nutzer/in iniitiert werden)';
$string['sub_mode_opt_out'] = 'Opt-out (Automatisches Abonnement, Abmeldung durch Nutzer/in möglich)';
$string['subscribe'] = 'Abonnieren';
$string['subscribe_question'] = 'Möchten Sie den Newsletter "{$a->name}" unter Verwendung der E-Mailadresse "{$a->email}" abonnieren?';
$string['subscribedusers'] = 'Abonnent/inn/en';
$string['subscribedusersmatching'] = 'Passende Abonnent/inn/en für Suchkriterium ({$a})';
$string['subscribercandidates'] = 'Mögliche Abonnent/inn/en';
$string['subscribercandidatesmatching'] = 'Passende Nutzer/innen für ({$a})';
$string['subscription_mode'] = 'Abonnementeinstellung';
$string['subscription_mode_help'] = 'Wählen Sie aus, ob eingeschriebene Nutzer/innen für diesen Newsletter automatisch (opt-out) angemeldet werden, oder sie sich manuell anmelden müssen (opt-in). WARNUNG: Opt-out bedeutet die automatische Anmeldung ALLER Nutzer/innen des Kontexts. Bei auf der Startseite angelegten Newslettern bedeutet dies ein Abo aller NutzerInnen der gesamten Moodle-Plattform!';
$string['toc'] = 'Wählen Sie hier wie die Inhaltsangabe generiert werden soll.';
$string['toc_header'] = 'Inhaltsangabe';
$string['toc_help'] = 'Bis zu welcher Stufe sollen Überschriften inkludiert werden? Beispiel: Sie haben eine Ausgabe mit einer drei-stufigen Überschriftenstruktur (h1, h2, h3). Wenn Sie aber nur die Stufen 1 und 2 (h1 und h2) in die Inhaltsangabe einbeziehen möchten, wählen Sie die "2". Wenn Sie nur die erste Stufe einbezogen haben möchten, wählen Sie die "1".';
$string['toc_no'] = 'Keine Inhaltsangabe generieren';
$string['toc_yes'] = 'Eine {$a}-stufige Inhaltsangabe generieren';
$string['unsubscribe'] = 'Dieses Newsletter-Abonnement kündigen';
$string['unsubscribe_link_text'] = 'Klicken Sie hier, um das Abonnement zu kündigen';
$string['unsubscribe_question'] = 'Möchten Sie das Abonnement der E-Mailadresse "{$a->email}" für den Newsletter "{$a->name}" wirklich kündigen?';
$string['unsubscribedinfo'] = 'Mit (!) markierte Nutzer/innen sind abgemeldet';
$string['unsubscription_succesful'] = 'Ihr Abonnement mit der E-Mailadresse "{$a->email}" wurde für den folgenden Newsletter erfolgreich gekündigt: "{$a->name}"';
$string['welcometonewsletter'] = 'Vielen Dank! Sie erhalten von nun ab diesen Newsletter per E-Mail.';
