<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'auth', language 'sl', version '4.3'.
 *
 * @package     auth
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actauthhdr'] = 'Razpoložljivi vtičniki za preverjanje pristnosti';
$string['allowaccountssameemail'] = 'Dovoli račune z enakim e-poštnim naslovom';
$string['allowaccountssameemail_desc'] = 'Če je ta možnost omogočena, ima lahko več uporabniških računov isti e-poštni naslov, kar lahko povzroči težave pri zagotavljanju varnosti ali varovanju zasebnosti (na primer pri potrditvi zahteve za menjavo gesla).';
$string['alternatelogin'] = 'Če tu vnesete URL, bo uporabljen kot stran za prijavo v to spletno mesto. Stran mora vsebovati obrazec, ki ima lastnost dejanja nastavljeno na <strong>\'{$a}\'</strong> in povratni polji <strong>username</strong> in <strong>password</strong>.<br />Bodite pozorni, da ne vnesete napačnega naslova URL, da se ne zaklenete iz tega spletnega mesta.<br />Pustite to nastavitev prazno, če želite uporabiti privzeto prijavno stran.';
$string['alternateloginurl'] = 'Alternativni URL prijave';
$string['auth_changepasswordhelp'] = 'Pomoč za spreminjanje gesla';
$string['auth_changepasswordhelp_expl'] = 'Uporabnikom, ki so izgubili svoje {$a} geslo, prikaži pomoč ob izgubljenem geslu. Ta se prikaže poleg oziroma namesto <strong>URL za spreminjanje gesla</strong> ali vgrajenega mehanizma spreminjanja gesla.';
$string['auth_changepasswordurl'] = 'URL za spremembo gesla';
$string['auth_changepasswordurl_expl'] = 'Navedite URL, kamor naj bodo preusmerjeni uporabniki, ki so izgubili svoje {$a} geslo. Nastavite <strong>Uporabi privzeto stran za spreminjanje gesla</strong> na <strong>Ne</strong>.';
$string['auth_changingemailaddress'] = 'Zahtevali ste spremembo e-poštnega naslova z {$a->oldemail} na {$a->newemail}. Zaradi varnostnih razlogov smo vam na novi e-poštni naslov poslali sporočilo, s katerim potrdite, da je e-poštni naslov res vaš. Vaš e-poštni naslov bo spremenjen takoj, ko kliknete na URL povezavo v sporočilu.';
$string['auth_common_settings'] = 'Skupne nastavitve';
$string['auth_data_mapping'] = 'Preslikava podatkov';
$string['auth_fieldlock'] = 'Zakleni vrednost';
$string['auth_fieldlock_expl'] = '<p><b>Zakleni vrednost: </b> Če je funkcija omogočena, bo uporabnikom Moodla in skrbnikom preprečila neposredno urejanje tega polja. Uporabite to možnost, če vzdržujete te podatke v zunanjem sistemu preverjanja pristnosti. </p>';
$string['auth_fieldlockfield'] = 'Zakleni vrednost ({$a})';
$string['auth_fieldlocks'] = 'Zakleni uporabniška polja';
$string['auth_fieldlocks_help'] = '<p>Zaklenete lahko polja s podatki o uporabniku. To je uporabno za spletna mesta, kjer takšne podatke ročno vzdržujejo skrbniki, tako da urejajo zapise uporabnikov ali jih nalagajo s funkcijo \'Naloži uporabnike\'. Če zaklenete polja, ki jih Moodle zahteva, poskrbite, da bodo podatki pri ustvarjanju uporabniških računov na voljo, v nasportnem primeru bodo ti računi neuporabni.</p><p>Uporabite lahko nastavitev načina zaklepanja na \'Odkleni prazno\', če se želite izogniti temu problemu.</p>';
$string['auth_fieldmapping'] = 'Preslikava podatkov ({$a})';
$string['auth_invalidnewemailkey'] = 'Napaka: pri potrditvi spremembe e-poštnega naslova je mogoče prišlo do napake pri kopiranju URL naslova, ki ste ga dobili po e-pošti. Ponovno kopirajte naslov in poskusite znova.';
$string['auth_multiplehosts'] = 'Določenih je več gostiteljev ALI naslovov (npr. host1.com; host2.com;host3.com) ali (npr. xxx.xxx.xxx.xxx;xxx.xxx.xxx.xxx)';
$string['auth_notconfigured'] = 'Metoda za preverjanje pristnosti {$a} ni konfigurirana.';
$string['auth_outofnewemailupdateattempts'] = 'Porabili ste vse dovoljene poskuse za posodobitev vašega e-poštnega naslova. Vaša zahteva je bila preklicana.';
$string['auth_passwordisexpired'] = 'Vaše geslo je poteklo. Želite spremeniti geslo zdaj?';
$string['auth_passwordwillexpire'] = 'Vaše geslo bo poteklo čez {$a} dni. Želite spremeniti svoje geslo zdaj?';
$string['auth_remove_delete'] = 'Pobriši lokalni račun';
$string['auth_remove_keep'] = 'Ohrani lokalni račun';
$string['auth_remove_suspend'] = 'Suspendiraj lokalni račun';
$string['auth_remove_user'] = 'Določite, kaj se zgodi z notranjimi uporabniškimi računi med množično sinhronizacijo v primeru, da je bil uporabnik odstranjen iz zunanjega vira. Samo suspendirani uporabniki se avtomatsko obnovijo, če se pojavijo v zunanjem viru.';
$string['auth_remove_user_key'] = 'Odstranjen zunanji uporabnik';
$string['auth_sync_script'] = 'Sinhronizacija uporabniških računov';
$string['auth_sync_suspended'] = 'Če omogočite, bo prekinjen atribut uporabljen za posodobitev statusa suspenza lokalnega uporabniškega računa.';
$string['auth_sync_suspended_key'] = 'Sinhroniziraj status suspenza za lokalnega uporabnika';
$string['auth_updatelocal'] = 'Posodobi lokalno';
$string['auth_updatelocal_expl'] = '<p><b>Posodobi lokalno: </b> Če je omogočeno, bo polje posodobljeno (iz zunanje avtentikacije) vsakič, ko se uporabnik prijavi ali ob sinhronizaciji uporabnikov. Polja, nastavljena za lokalno posodobitev, morajo biti zaklenjena.</p>';
$string['auth_updatelocalfield'] = 'Posodobi lokalno ({$a})';
$string['auth_updateremote'] = 'Posodobi zunanje';
$string['auth_updateremote_expl'] = '<p><b>Posodobi zunanje: </b> Če je omogočeno, bo zunanja avtentikacija posodobljena, ko bo posodobljen zapis uporabnikov. Polja morajo imeti odklenjeno možnost urejanja.</p>';
$string['auth_updateremote_ldap'] = '<p><b>Opomba: </b> Pri posodobitvi zunanjih podatkov LDAP morate uporabniku bind omogočiti nastavitvi binddn in bindpw s pravicami urejanja vseh zapisov uporabnika. Nastavitev trenutno ne ohranja atributov z več vrednostmi, zato bodo ob posodobitvi dodatne vrednosti odstranjene. </p>';
$string['auth_updateremotefield'] = 'Posodobi zunanje ({$a})';
$string['auth_user_create'] = 'Omogoči ustvarjanje uporabnikov';
$string['auth_user_creation'] = 'Novi (anonimni) uporabniki lahko ustvarjajo uporabniške račune na zunanjem viru preverjanja pristnosti in so potrjeni po e-pošti. Če to omogočite, morate konfigurirati tudi specifične možnosti za posamezne module pri ustvarjanju uporabnika.';
$string['auth_usernameexists'] = 'Izbrano uporabniško ime že obstaja. Izberite novega.';
$string['auth_usernotexist'] = 'Ni mogoče posodobiti podatkov neobstoječega uporabnika: {$a}';
$string['authenticationoptions'] = 'Možnosti preverjanja pristnosti';
$string['authinstructions'] = 'Pustite prazno, če želite, da se vam ob prijavi prikažejo privzeta navodila za prijavo. Če želite uporabiti svoja navodila za prijavo, jih vnesite tukaj.';
$string['authloginviaemail'] = 'Dovoli prijavo po e-pošti';
$string['authloginviaemail_desc'] = 'Dovoli prijavo z uporabniškim imenom in e-poštnim naslovom (če je edinstven).';
$string['auto_add_remote_users'] = 'Samodejno dodaj oddaljene uporabnike';
$string['cannotmapfield'] = 'Polja "{$a->fieldname}" ni možno preslikati, ker je njegovo kratko ime "{$a->shortname}" predolgo. Za preslikavo morate kratko ime omejiti na {$a->charlimit} znakov. <a href="{$a->link}">Uredi polja v profilu uporabnika</a>';
$string['changepassword'] = 'URL za spremembo gesla';
$string['changepasswordhelp'] = 'Tu lahko določite URL za pridobivanje izubljenih gesel, ki bo uporabnikom posredovan po e-pošti. Nastavitev ne bo delovala, če ima URL za pozabljeno geslo nastavljene skupne nastavitve za preverjanje pristnosti.';
$string['chooseauthmethod'] = 'Izberite način preverjanja pristnosti';
$string['chooseauthmethod_help'] = 'Ta nastavitev določa način preverjanja pristnosti ob prijavi uporabnika. Izberete lahko le omogočene vtičnike za preverjanje pristnosti, sicer se uporabniki ne bodo več mogli prijaviti. Za blokiranje prijave uporabnika izberite "Onemogoči prijavo".';
$string['createpassword'] = 'Generiraj geslo in obvesti uporabnika';
$string['createpasswordifneeded'] = 'Če je potrebno, ustvari geslo in ga pošlji po e-pošti';
$string['emailchangecancel'] = 'Prekliči spremembo e-poštnega naslova';
$string['emailchangepending'] = 'Sprememba v teku. Kliknite na URL povezavo, ki je bila poslana na naslov {$a->preference_newemail}.';
$string['emailnowexists'] = 'E-poštni naslov, ki ste ga želeli dodati svojemu profilu, je bil v času od vaše izvirne zahteve dodeljen drugemu uporabniku. Vaša zahteva je bila zato preklicana, vendar lahko ponovno poskusite z novim e-poštnim naslovom.';
$string['emailupdate'] = 'Posodobi e-poštni naslov';
$string['emailupdatemessage'] = 'Spoštovani {$a->fullname},

zahtevali ste spremembo e-poštnega naslova za uporabniški račun na strežniku {$a->site}. V vašem brskalniku odprite spodnjo povezavo in potrdite spremembo.

{$a->url}

{$a->supportemail}';
$string['emailupdatesuccess'] = 'E-poštni naslov uporabnika <em>{$a->fullname}</em> je bil uspešno posodobljen na <em>{$a->email}</em>.';
$string['emailupdatetitle'] = 'Potrditev e-poštnega naslova na strežniku {$a->site}';
$string['errormaxconsecutiveidentchars'] = 'Gesla imajo lahko največ {$a} enakih zaporednih znakov.';
$string['errorminpassworddigits'] = 'Geslo mora imeti vsaj {$a} številk.';
$string['errorminpasswordlength'] = 'Geslo mora biti dolgo vsaj {$a} znakov.';
$string['errorminpasswordlower'] = 'Geslo mora imeti najmanj {$a} malih črk.';
$string['errorminpasswordnonalphanum'] = 'Geslo mora imeti vsaj {$a} znakov, ki niso alfanumerični (npr. *, - ali #).';
$string['errorminpasswordupper'] = 'Geslo mora imeti vsaj {$a} velikih črk.';
$string['errorpasswordreused'] = 'To geslo je že bilo uporabljeno, ponovna uporaba ni dovoljena.';
$string['errorpasswordupdate'] = 'Napaka pri zapisovanju novega gesla. Geslo ni spremenjeno';
$string['eventuserloggedin'] = 'Uporabnik se je prijavil';
$string['eventuserloggedinas'] = 'Uporabnik se je prijavil kot drug uporabnik';
$string['eventuserloginfailed'] = 'Prijava uporabnika ni uspela';
$string['forcechangepassword'] = 'Vsili spremembo gesla';
$string['forcechangepassword_help'] = 'Prisili uporabnike v spremembo geslo ob njihovi naslednji prijavi.';
$string['forcechangepasswordfirst_help'] = 'Prisili uporabnike v spremembo geslo ob njihovi prvi prijavi.';
$string['forgottenpassword'] = 'Če vnesete URL naslov, bo ta uporabljen za pridobivanje izgubljenih gesel za to spletno mesto. Funkcija je namenjena spletnim mestom, pri katerih so gesla hranjena zunaj Moodle. Pustite prazno, če želite uporabiti privzeti načina pridobivanja izgubljenih gesel.';
$string['forgottenpasswordurl'] = 'URL za pozabljeno geslo';
$string['getrecaptchaapi'] = 'Če želite uporabiti storitev reCAPTCHA, morate pridobiti ključ API na strani <a href=\'https://www.google.com/recaptcha/admin\'>https://www.google.com/recaptcha/admin</a>';
$string['guestloginbutton'] = 'Gumb za prijavo gosta';
$string['incorrectpleasetryagain'] = 'Nepravilno. Poskusite ponovno.';
$string['infilefield'] = 'Zahtevano polje v datoteki';
$string['informminpassworddigits'] = 'vsaj številk: {$a}';
$string['informminpasswordlength'] = 'najmanjše število znakov: {$a}';
$string['informminpasswordlower'] = 'vsaj malih črk: {$a}';
$string['informminpasswordnonalphanum'] = 'najmanjše število nealfanumeričnih znakov (npr. *, - in #): {$a}';
$string['informminpasswordreuselimit'] = 'Geslo lahko ponovno uporabite, če ste ga že {$a}-krat spremenili.';
$string['informminpasswordupper'] = 'vsaj velikih črk: {$a}';
$string['informpasswordpolicy'] = 'Geslo mora imeti {$a}';
$string['instructions'] = 'Navodila';
$string['internal'] = 'Interno';
$string['limitconcurrentlogins'] = 'Omeji sočasne prijave';
$string['limitconcurrentlogins_desc'] = 'Če je ta možnost omogočena, je število sočasnih prijav za vsakega uporabnika omejeno. Po dosegu omejitve bo najstarejša seja prekinjena. Upoštevajte, da lahko uporabnik pri tem izgubi neshranjeno delo. Ta nastavitev ni združljiva z vtičniki za preverjanje pristnosti z enkratno prijavo (SSO).';
$string['locked'] = 'Zaklenjeno';
$string['md5'] = 'Šifriranje MD5';
$string['nopasswordchange'] = 'Gesla ni mogoče spremeniti.';
$string['nopasswordchangeforced'] = 'Za nadaljevanje morate spremeniti geslo, vendar pa stran, kjer bi to lahko naredili, ni na voljo. Kontaktirajte skrbnika Moodla.';
$string['noprofileedit'] = 'Profila ni mogoče urejati';
$string['ntlmsso_attempting'] = 'Poskušam z enotno prijavo prek NTLM...';
$string['ntlmsso_failed'] = 'Samodejna prijava ni uspela. Poskusite z običajno prijavo.';
$string['ntlmsso_isdisabled'] = 'Enkratna prjava NTLM ni omogočena.';
$string['passwordhandling'] = 'Obravnava polja za geslo';
$string['plaintext'] = 'Golo besedilo';
$string['pluginnotenabled'] = 'Vtičnik za preverjanje pristnosti \'{$a}\' ni omogočen.';
$string['pluginnotinstalled'] = 'Vtičnik za preverjanje pristnosti \'{$a}\' ni nameščen.';
$string['potentialidps'] = 'Prijavite se s svojim računom na:';
$string['privacy:metadata:userpref:createpassword'] = 'Nakaže, da naj bi bilo geslo generirano za uporabnika';
$string['privacy:metadata:userpref:forcepasswordchange'] = 'Sporoči, ali bi moral uporabnik spremeniti geslo ob prijavi';
$string['privacy:metadata:userpref:loginfailedcount'] = 'Število neuspešnih prijav';
$string['privacy:metadata:userpref:loginfailedcountsincesuccess'] = 'Število neuspešnih prijav od zadnje uspešne prijave';
$string['privacy:metadata:userpref:loginfailedlast'] = 'Datum zadnje zabeležene neuspešne prijave';
$string['privacy:metadata:userpref:loginlockout'] = 'Sporoči, ali je uporabniški račun zaklenjen zaradi neuspešne prijave, in izpiše datum, kdaj je bil račun zaklenjen';
$string['privacy:metadata:userpref:loginlockoutignored'] = 'Sporoči, da se uporabniški račun ne bi smel zakleniti';
$string['privacy:metadata:userpref:loginlockoutsecret'] = 'Skrivni ključ, ki ga mora uporabnik vnesti, če želi odkleniti račun';
$string['recaptcha'] = 'reCAPTCHA';
$string['recaptcha_help'] = 'Program CAPTCHA avtomatiziranim programom onemogoči zlorabo. Najprej mora preveriti, ali ste človek. Odkljukajte kvadratek, vnesite izpisano besedo ali izberite pravilne fotografije.

Če niste prepričani, katere fotografije morate izbrati, lahko zahtevate nov CAPTCHA ali zvokovni CAPTCHA.';
$string['recaptcha_link'] = 'avtentikacija/e-pošta';
$string['security_question'] = 'Varnostno vprašanje';
$string['selfregistration'] = 'Samo-registracija';
$string['selfregistration_help'] = 'Če je izbran vtičnik za preverjanje pristnosti (na primer za samoregistracijo po e-pošti), se lahko potencialni uporabniki sami registirarjo in ustvarijo račun. To lahko vodi do ustvarjanja lažnih uporabniških računov, ki dobijo dostop do forumov in blogov, po katerih bodo pošiljali nezaželena sporočila. Če želite to preprečiti, onemogočite samoregistracijo oziroma jo omejite na določene e-poštne domene.';
$string['settingmigrationmismatch'] = 'Med popravljanjem imen za nastavitve vtičnika je bilo odkrito neujemanje vredosti! Vtičnik za preverjanje pristnosti \'{$a->plugin}\' je imel nastavitev \'{$a->setting}\' konfigurirano na podedovano ime \'{$a->legacy}\' in na trenutno ime \'{$a->current}‘. Slednja vrednost je bila nastavljena kot pravilna, vednar vseeno preverite in potrdite, ali so nastavitve pravilne.';
$string['sha1'] = 'SHA-1 zgoščevalna funkcija';
$string['showguestlogin'] = 'Gumb za prijavo gosta na strani za prijavo lahko skrijete ali prikažete.';
$string['stdchangepassword'] = 'Uporabi privzeto stran za spremembo gesla';
$string['stdchangepassword_expl'] = 'Če zunanji sistem preverjanja pristnosti dovoljuje spremembo gesla prek strani Moodle, izberite \'Da\'. Ta nastavitev preglasi \'URL za spremembo gesla\'.';
$string['stdchangepassword_explldap'] = 'Opomba: Priporočljivo je, da uporabite LDAP namesto šifriranega tunela SSL (ldaps: //), če je strežnik LDAP oddaljeni strežnik.';
$string['suspended'] = 'Začasno onemogočen račun';
$string['suspended_help'] = 'Uporabniki z začasno onemogočenim računom se ne morejo prijaviti ali uporabljati spletnih storitev. Vsa odhodna sporočila bodo zavržena.';
$string['testsettings'] = 'Preizkusite nastavitve';
$string['testsettingsheading'] = 'Preizkusi nastavitve preverjanja pristnosti - {$a}';
$string['unlocked'] = 'Odklenjeno';
$string['unlockedifempty'] = 'Odkleni prazno';
$string['update_never'] = 'Nikoli';
$string['update_oncreate'] = 'Ob ustvarjanju';
$string['update_onlogin'] = 'Ob vsaki prijavi';
$string['update_onupdate'] = 'Ob posodobitvi';
$string['user_activatenotsupportusertype'] = 'auth: ldap user_activate() ne podpira izbrane vrste uporabnika: {$a}';
$string['user_disablenotsupportusertype'] = 'auth: ldap user_disable() (še) ne podpira izbranega tipa uporabnika';
$string['username'] = 'Uporabniško ime';
$string['username_help'] = 'Prosimo, zavedajte se, da vam nekateri vtičniki za preverjanje pristnosti ne bodo dovolili spremeniti uporabniškega imena.';
