<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'qtype_musictheory', language 'es', version '4.3'.
 *
 * @package     qtype_musictheory
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abmajor'] = 'La♭Mayor';
$string['abminor'] = 'La ♭ menor';
$string['acc_b'] = '♭';
$string['acc_bb'] = '♭♭';
$string['acc_n'] = '♮';
$string['acc_sharp'] = '♯';
$string['acc_x'] = 'x';
$string['alto'] = 'Contralto';
$string['altoclef'] = 'Clave de Do';
$string['anmajor'] = 'La Mayor';
$string['anminor'] = 'La menor';
$string['answerlbl'] = 'Respuesta';
$string['asharpminor'] = 'La♯ menor';
$string['aug10'] = '10ª Aumentada';
$string['aug11'] = '11ª Aumentada';
$string['aug12'] = '12ª Aumentada';
$string['aug13'] = '13ª Aumentada';
$string['aug2'] = '2ª Aumentada';
$string['aug3'] = '3ª Aumentada';
$string['aug4'] = '4ª Aumentada';
$string['aug5'] = '5ª Aumentada';
$string['aug6'] = '6ª Aumentada';
$string['aug6thfr'] = '6ª Aumentada francesa';
$string['aug6thgr'] = '6ª Aumentada alemana';
$string['aug6thit'] = '6ª Aumentada italiana';
$string['aug7'] = '7ª Aumentada';
$string['aug8'] = '8ª Aumentada';
$string['aug9'] = '9ª Aumentada';
$string['augmented'] = 'Aumentada';
$string['bass'] = 'Bajo';
$string['bassclef'] = 'Clave de Fa';
$string['bbmajor'] = 'Si♭ Mayor';
$string['bbminor'] = 'Si♭ menor';
$string['bnmajor'] = 'Si Mayor';
$string['bnminor'] = 'Si menor';
$string['cbmajor'] = 'Do♭ Mayor';
$string['chordquality'] = 'Tipo de acorde';
$string['chordquality-random'] = 'Posibles tipos de acordes';
$string['chordquality_write_questionastext'] = 'Introducir tipo de acorde';
$string['chordquality_write_questionastext_help'] = '<p> Introduzca una lista de notas separadas por comas,
   sin espacios, utilizando la siguiente sintaxis: </p> <p> [Nombre de la nota en mayúscula] [Accidental
   ("n" = natural, "#" = sostenido, "b" = bemol, "x" = doble sostenido, "bb" = doble bemol)] 4, ... </p>
  <p> Ejemplo aleatorio: <b> respuesta => Don4,Min4,Sol#4</b> </p>';
$string['chordquality_write_questionasui'] = 'Introduzca la función armónica';
$string['chordquality_write_questionasui_help'] = '<p> Introduzca las notas haciendo clic en el pentagrama, después de seleccionar
  la alteración en la barra de herramientas de la derecha. Para eliminar una nota, vuelva a hacer clic en ella. </p>';
$string['chordroot'] = 'Acorde de tónica';
$string['clef'] = 'Clave';
$string['clef-random'] = 'Posibles claves';
$string['cnmajor'] = 'Do Mayor';
$string['cnminor'] = 'Do menor';
$string['considerregister'] = 'Incluir altura (notación científica)';
$string['considerregister_help'] = 'Indicar si la altura (notación científica) de la nota debe ser
  incluido como parte de la pregunta.';
$string['correctansweris'] = 'La respuesta correcta es:';
$string['correctansweris_morethanone'] = 'Otra posible respuesta es:';
$string['csharpmajor'] = 'Do♯ Mayor';
$string['csharpminor'] = 'Do♯ menor';
$string['dbmajor'] = 'Re♭ Mayor';
$string['dim10'] = '10ª Disminuida';
$string['dim11'] = '11ª Disminuida';
$string['dim12'] = '12ª Disminuida';
$string['dim13'] = '13ª Disminuida';
$string['dim2'] = '2ª Disminuida';
$string['dim3'] = '3ª Disminuida';
$string['dim4'] = '4ª Disminuida';
$string['dim5'] = '5ª Disminuida';
$string['dim6'] = '6ª Disminuida';
$string['dim7'] = '7ª Disminuida';
$string['dim8'] = '8ª Disminuida';
$string['dim9'] = '9ª Disminuida';
$string['diminished'] = 'Disminuida';
$string['dirasc'] = 'Por encima de la nota dada';
$string['dirdesc'] = 'Por debajo de la nota dada';
$string['direction'] = 'Dirección';
$string['displaykeysignature'] = 'Mostrar armadura';
$string['dnmajor'] = 'Re Mayor';
$string['dnminor'] = 'Re menor';
$string['dsharpminor'] = 'Re♯ menor';
$string['ebmajor'] = 'Mi♭ Mayor';
$string['ebminor'] = 'Mi♭ menor';
$string['emptykeysignature'] = 'Sin armadura';
$string['enmajor'] = 'Mi Mayor';
$string['enminor'] = 'Mi menor';
$string['fnmajor'] = 'Fa mayor';
$string['fnminor'] = 'Fa menor';
$string['fsharpmajor'] = 'Fa♯ Mayor';
$string['fsharpminor'] = 'Fa♯ menor';
$string['gbmajor'] = 'Sol♭ Mayor';
$string['givennoteelementgroup'] = 'Nota dada';
$string['gnmajor'] = 'Sol Mayor';
$string['gnminor'] = 'Sol menor';
$string['grandstaff'] = 'Pentagrama Doble';
$string['gsharpminor'] = 'Sol♯ menor';
$string['harmonicfunction_write_questionastext'] = 'Introducir la función armónica';
$string['harmonicfunction_write_questionastext_help'] = '<p> Introduzca una lista de notas separadas por comas,
   sin espacios, utilizando la siguiente sintaxis: </p> <p> [Nombre de la nota en mayúscula] [Accidental
   ("n" = natural, "#" = sostenido, "b" = bemol, "x" = doble sostenido, "bb" = doble bemol)] 4, ... </p>
  <p> Ejemplo aleatorio: <b> respuesta => Don4,Min4,Sol#4</b> </p>';
$string['harmonicfunction_write_questionasui'] = 'Introducir la función armónica';
$string['harmonicfunction_write_questionasui_help'] = '<p> Introduzca las notas haciendo clic en el pentagrama, después de seleccionar
  la alteración en la barra de herramientas de la derecha. Para eliminar una nota, vuelva a hacer clic en ella. </p>';
$string['harmonicfunctiontype-random'] = 'Posibles funciones armónicas';
$string['hfidentifyresponsetypes'] = 'Posible función armónica en respuesta';
$string['hftype_aug6th'] = '6ª Aumentada';
$string['hftype_diatonictriad'] = 'Tríada diatónica';
$string['hftype_dom7th'] = '7ª de dominante';
$string['hftype_extendeddom'] = 'Dominante extendida (9, 11 ó 13)';
$string['hftype_leadingtone7thfullydim'] = 'La subtónica (7º grado) del tono (totalmente disminuida)';
$string['hftype_leadingtone7thhalfdim'] = 'La sensible (7º grado) del tono (medio disminuido)';
$string['hftype_neapolitan'] = 'Napolitano';
$string['hftype_nondom7th'] = 'Séptima no dominante';
$string['hftype_secdom7th'] = 'Dominante secundaria (séptima)';
$string['hftype_secdomtriad'] = 'Dominante secundaria (tríada)';
$string['hftype_secltfullydim'] = 'Séptimo tono principal secundario (totalmente disminuido)';
$string['hftype_seclthalfdim'] = 'Tono principal secundario séptimo (medio disminuido)';
$string['hftype_seclttriad'] = 'Tono principal secundario (tríada)';
$string['hftype_secnondom7th'] = 'No dominante secundaria (séptima)';
$string['hftype_secnondomtriad'] = 'No dominante secundario (tríada)';
$string['includealterations'] = 'Incluir alteraciones';
$string['includealterations_help'] = 'Indica si las alteraciones deben ser
 incluidas como parte de la pregunta.';
$string['includestaticnote'] = 'Incluir nota dada';
$string['interval_write_questionastext'] = 'Respuesta - Intervalo';
$string['interval_write_questionastext_help'] = '<p> Ingrese la nota de respuesta, sin espacios, usando
  la siguiente sintaxis: </p> <p> [Nombre de la letra en mayúscula] [Accidente ("n" = natural, "#" = sostenido,
  "b" = bemol, "x" = doble sostenido, "bb" = doble bemol)] [Registro (un dígito entre 1 y 6, después la notación de tono científico)] </p> <p> Ejemplos:
  </p><ul><li><b>Gn5</b></li><li><b>A#4</b></li><li> <b> Ebb3 </b> </li> </ul>';
$string['interval_write_questionasui'] = 'Respuesta - Intervalo';
$string['interval_write_questionasui_help'] = '<p> Ingrese la nota haciendo clic en el pentagrama, después
  seleccionando el tipo de alteración en la barra de herramientas de la derecha. Para eliminar la nota, vuelva a hacer clic en ella. </p>';
$string['javascriptrequired'] = 'Este texto será reemplazado por una interfaz gráfica de usuario, que requiere que Javascript esté habilitado en su navegador.';
$string['keyboard_input_questionasui'] = 'Entrada de respuesta con Teclado';
$string['keyboard_input_questionasui_help'] = '<p> Ingrese notas haciendo clic en el teclado. Para eliminar una nota, vuelva a hacer clic en ella. </p>';
$string['keymode'] = 'Tecla';
$string['keysignature_write_questionastext'] = 'Respuesta - Tonalidad';
$string['keysignature_write_questionastext_help'] = '<p> Ingrese una lista de alteraciones separadas por comas
  (entre 1 y 7 de ellas), sin espacios, utilizando la siguiente sintaxis: </p> <p> [Nombre de la letra en mayúscula]
  [Accidente ("#" = sostenido, "b" = bemol)] [Registro (un dígito entre 2 y 5, siguiendo la notación de tono científico)], ... </p> <p> Ejemplo: <b> A # 4, F # 4, G # 4 </b> </p>';
$string['keysignature_write_questionasui'] = 'Entrada de respuesta de firma clave';
$string['keysignature_write_questionasui_help'] = '<p> Introduzca accidentes haciendo clic en el pentagrama,
  después de seleccionar el tipo de accidente en la barra de herramientas de la derecha. Para eliminar un accidente, vuelva a hacer clic en él. </p>';
$string['lbl_harmonicfunction'] = 'Función armónica';
$string['maj10'] = 'Décima mayor';
$string['maj13'] = 'Trigésima mayor';
$string['maj2'] = 'Segunda mayor';
$string['maj3'] = 'Tercera mayor';
$string['maj6'] = 'Sexta mayor';
$string['maj7'] = 'Séptima mayor';
$string['maj9'] = 'Novena mayor';
$string['major'] = 'Mayor';
$string['min10'] = 'Décima menor';
$string['min13'] = 'Trigésima menor';
$string['min2'] = 'Segunda menor';
$string['min3'] = 'Tercera menor';
$string['min6'] = 'Sexta menor';
$string['min7'] = 'Séptima menor';
$string['min9'] = 'Novena menor';
$string['minor'] = 'Menor';
$string['mode-random'] = 'Modos posibles';
$string['musicqtype'] = 'Tipo de pregunta musical';
$string['musictheory_gradingstrategy'] = 'Estrategia de calificación';
$string['musictheory_gradingstrategy_help'] = '<p> La estrategia de calificación especifica cómo la pregunta
  será calificado. </p>
  <p> <b> Todo o nada </b>: la respuesta se compara con la respuesta correcta. Si la respuesta es correcta, se le da la máxima puntuación. Si la respuesta es incorrecta, se le da un cero. </p>';
$string['musictheory_gradingstrategy_scale-write'] = 'Estrategia de calificación';
$string['musictheory_gradingstrategy_scale-write_help'] = '<p> La estrategia de calificación especifica cómo se calificará la pregunta. </p>
  <p> <b> Todo o nada </b>: la respuesta se compara con la respuesta correcta. Si la respuesta es correcta, se le da la máxima puntuación. Si la respuesta es incorrecta, se le da un cero. </p>
  <p> <b> Crédito parcial por cada nota correcta </b>:
  Una estrategia de calificación que divide la calificación de manera uniforme por la cantidad de notas de escala que el usuario debe ingresar y otorga una calificación parcial por cada nota correcta. </p>';
$string['musictheory_intervalelementgroup'] = 'Intervalo';
$string['musictheory_intervalelementgroup_help'] = 'Indica el tipo de intervalo.';
$string['musictheory_intervalelementgroup_random'] = 'Intervalos posibles';
$string['nosectonic'] = '[Sin tónica secundaria]';
$string['note_write_questionastext'] = 'Respuesta - Nota';
$string['note_write_questionastext_help'] = '<p> Ingrese la nota de respuesta, sin espacios, usando la siguiente sintaxis: </p> <p> [Nombre de la letra mayúscula] [Accidental ("n" = natural, "#" = sostenido, "b" = bemol, " x "= doble sostenido," bb "= doble bemol)] [Registro (un dígito entre 1 y 6, siguiendo la notación científica de tono)] </p> <p> Ejemplos:
  </p><ul><li><b>Gn5</b></li><li><b>A#4</b></li><li> <b> Ebb3 </b> </li> </ul>';
$string['note_write_questionasui'] = 'Respuesta - Nota';
$string['note_write_questionasui_help'] = '<p> Ingrese la nota haciendo clic en el pentagrama, luego de seleccionar el tipo de alteración en la barra de herramientas de la derecha. Para eliminar la nota, vuelva a hacer clic en ella. </p>';
$string['notea'] = 'La';
$string['noteb'] = 'Si';
$string['notec'] = 'Do';
$string['noted'] = 'Re';
$string['notee'] = 'Mi';
$string['notef'] = 'Fa';
$string['noteg'] = 'Sol';
$string['notelbl'] = 'Nota';
$string['per11'] = 'Undécima perfecta';
$string['per12'] = 'Duodécima perfecta';
$string['per4'] = 'Cuarta perfecta';
$string['per5'] = 'Quinta perfecta';
$string['per8'] = 'Octava perfecta';
$string['perfect'] = 'Perfecta';
$string['pluginname'] = 'Teoría musical';
$string['pluginname_help'] = 'Este tipo de pregunta permite la creación de varios tipos de ejercicios de teoría musical utilizando una interfaz gráfica de usuario.';
$string['pluginname_link'] = 'question/type/musictheory';
$string['pluginnameadding'] = 'Agregar una pregunta de teoría musical';
$string['pluginnameediting'] = 'Editar una pregunta de teoría musical';
$string['pluginnamesummary'] = 'Permite la creación de varios tipos de ejercicios de teoría musical.';
$string['possiblescalesinresponse'] = 'Posibles tipos de escala en la respuesta';
$string['privacy:metadata'] = 'El complemento de tipo de pregunta de teoría musical no almacena ningún dato personal.';
$string['qtype_chordquality-identify'] = 'Identificación de la clase de acorde';
$string['qtype_chordquality-identify-random'] = 'Identificación de la clase de acorde (aleatorio)';
$string['qtype_chordquality-write'] = 'Escribir la clase de acorde';
$string['qtype_chordquality-write-random'] = 'Escribir la clase de acorde (aleatorio)';
$string['qtype_harmonicfunction-identify'] = 'Identificación de función armónica';
$string['qtype_harmonicfunction-identify-random'] = 'Identificación de función armónica (aleatorio)';
$string['qtype_harmonicfunction-write'] = 'Escritura de función armónica';
$string['qtype_harmonicfunction-write-random'] = 'Escritura de función armónica (aleatorio)';
$string['qtype_interval-identify'] = 'Identificación de intervalo';
$string['qtype_interval-identify-random'] = 'Identificación de intervalo (aleatorio)';
$string['qtype_interval-write'] = 'Escribir intervalo';
$string['qtype_interval-write-random'] = 'Escribir intervalo (aleatorio)';
$string['qtype_keyboard-input'] = 'Entrada de teclado';
$string['qtype_keysignature-identify'] = 'Identificación de Tonalidad';
$string['qtype_keysignature-identify-random'] = 'Identificación de Tonalidad (aleatorio)';
$string['qtype_keysignature-write'] = 'Escritura de Tonalidad';
$string['qtype_keysignature-write-random'] = 'Escritura de Tonalidad  (aleatorio)';
$string['qtype_musictheory_strategy_all_or_nothing'] = 'Todo o nada';
$string['qtype_musictheory_strategy_chordqualitywrite_allornothing'] = 'Todo o nada';
$string['qtype_musictheory_strategy_harmonicfunctionid_allornothing'] = 'Todo o nada';
$string['qtype_musictheory_strategy_harmonicfunctionwrite_allornothing'] = 'Todo o nada';
$string['qtype_musictheory_strategy_keyboard_allornothing'] = 'Todo o nada';
$string['qtype_musictheory_strategy_note_allornothing'] = 'Todo o nada';
$string['qtype_musictheory_strategy_scale_creditbynote'] = 'Crédito parcial por cada nota correcta';
$string['qtype_note-identify'] = 'Identificación de nota';
$string['qtype_note-identify-random'] = 'Identificación de nota (Aleatorio)';
$string['qtype_note-write'] = 'Escritura de nota';
$string['qtype_note-write-random'] = 'Escritura de nota (aleatorio)';
$string['qtype_scale-identify'] = 'Identificación de escala';
$string['qtype_scale-identify-random'] = 'Identificación de escala (aleatorio)';
$string['qtype_scale-write'] = 'Escritura de escala';
$string['qtype_scale-write-random'] = 'Escritura de escala (aleatorio)';
$string['quality-random'] = 'Posibles cualidades';
$string['qualityaug'] = 'Aumentado';
$string['qualitydim'] = 'Disminuido';
$string['qualitymaj'] = 'Mayor';
$string['qualitymin'] = 'Menor';
$string['qualityper'] = 'Perfecta';
$string['questionoptions'] = 'Opciones de preguntas';
$string['questiontext'] = 'Texto de la pregunta';
$string['questiontext_chordquality_identify'] = 'Identificar la fundamental y la cualidad del siguiente acorde';
$string['questiontext_chordquality_write'] = 'Ingrese el siguiente acorde';
$string['questiontext_harmonicfunction_identify'] = 'Identifique la siguiente función armónica';
$string['questiontext_harmonicfunction_write'] = 'Ingrese la siguiente función armónica';
$string['questiontext_help'] = 'Este campo no es obligatorio. Si se deja vacío, un texto de pregunta apropiado para el tipo de pregunta musical dado se mostrará automáticamente dentro de las actividades. Si ingresa texto en este campo, reemplazará el texto de la pregunta generado automáticamente.';
$string['questiontext_interval_identify'] = 'Identifique el siguiente intervalo';
$string['questiontext_interval_write_above'] = 'Ingrese el siguiente intervalo por <b>encima</b> de la nota dada';
$string['questiontext_interval_write_below'] = 'Ingrese el siguiente intervalo <b>debajo</b> de la nota dada';
$string['questiontext_keyboard_input'] = 'Ingrese la siguiente nota en el teclado';
$string['questiontext_keysignature_identify_major'] = 'Determine la Tonalidad mayor representada por la siguiente Tonalidad';
$string['questiontext_keysignature_identify_minor'] = 'Determine el relativo menor representado en la siguiente Tonalidad';
$string['questiontext_keysignature_write'] = 'Ingrese la siguiente firma de clave';
$string['questiontext_note_identify'] = 'Identifica la siguiente nota';
$string['questiontext_note_write'] = 'Ingrese la siguiente nota';
$string['questiontext_scale_identify'] = 'Identifica la siguiente escala';
$string['questiontext_scale_write'] = 'Escribe la siguiente escala en dirección ascendente';
$string['questiontext_scale_write_melodic'] = 'Escribe la siguiente escala tanto en dirección ascendente como descendente';
$string['rootposition'] = '[raiz]';
$string['scale_write_questionastext'] = 'Entrada de respuesta de escala';
$string['scale_write_questionastext_help'] = '<p>Ingrese una lista de notas separadas por comas, incluida la tónica especificada, sin espacios, utilizando la siguiente sintaxis: </p> <p> [Nombre de la letra en mayúscula] [Alteración ("n" = natural, "#" = sostenido, "b" = bemol, "x" = doble sostenido, "bb" = doble bemol)] [Registro (un dígito entre 2 y 6, siguiendo la notación científica de tono)], ... </p>
  <p> Ejemplo aleatorio: <b> Tonic = An4 answer => An4, Bb4, C#5, D#5, E#5, F#5, G#5, An5 </b > </p>';
$string['scale_write_questionasui'] = 'Entrada de respuesta de escala';
$string['scale_write_questionasui_help'] = '<p>Ingrese notas haciendo clic en el pentagrama, luego seleccionar el tipo de alteración en la barra de herramientas de la derecha. Para eliminar una nota, vuelva a hacer clic en ella. </p>
  <p> Tenga en cuenta que las alteraciones se transfieren a notas posteriores. </p>';
$string['scaletype'] = 'Tipo de escala';
$string['scaletype-random'] = 'Posibles tipos de escala';
$string['scaletype_harmonic'] = 'Menor armónica';
$string['scaletype_major'] = 'Mayor';
$string['scaletype_melodic'] = 'Menor melódico';
$string['scaletype_natural'] = 'Menor natural';
$string['selectakey'] = 'Seleccione una tecla';
$string['selectanoption'] = 'Seleccione';
$string['selectaquality'] = 'Seleccione una cualidad';
$string['selectasize'] = 'Seleccione un tamaño';
$string['size-random'] = 'Posibles tamaños';
$string['size10'] = 'Décima';
$string['size11'] = 'Undécima';
$string['size12'] = 'Duodécima';
$string['size13'] = 'Trigesima';
$string['size2'] = 'Segunda';
$string['size3'] = 'Tercera';
$string['size4'] = 'Cuarta';
$string['size5'] = 'Quinta';
$string['size6'] = 'Sexta';
$string['size7'] = 'Séptima';
$string['size8'] = 'Octava';
$string['size9'] = 'Novena';
$string['tenor'] = 'Tenor';
$string['tenorclef'] = 'Clave tenor';
$string['tonic'] = 'Tónica';
$string['treble'] = 'De sol';
$string['trebleclef'] = 'Clave de sol';
$string['updatemusicqtype'] = 'Opciones de actualización';
$string['validation_harmonicfunctionnotsupported'] = 'Esta función armónica no es soportada o no es válida.';
$string['validation_harmonicfunctiontypenotselected'] = 'Debe seleccionarse el tipo de función para la función armónica especificada.';
$string['validation_interval_novalidcombo'] = 'Las clases y tamaños posibles seleccionados no producen al menos un intervalo válido.';
$string['validation_intervaloutsidestaff'] = 'El registro de la nota dada produce un intervalo que no encaja dentro del pentagrama en la clave dada.';
$string['validation_invalidchordquality'] = 'Este tipo de acorde no se puede construir en la nota raíz especificada.';
$string['validation_invalidinterval_above'] = 'Este intervalo no se puede escribir por encima de la nota dada.';
$string['validation_invalidinterval_below'] = 'Este intervalo no se puede escribir debajo de la nota dada.';
$string['validation_noteoutsidekeyboard'] = 'Esta nota está fuera del rango del teclado del piano.';
$string['validation_noteoutsidestaff'] = 'El registro de esta nota no encaja en el pentagrama de la clave especificada.';
$string['validation_possiblescaletypenotselected'] = 'Se debe seleccionar el tipo de escala para el tipo de escala especificado.';
$string['validation_possiblescaletypesnotselected_random'] = 'Los posibles tipos de escalas en la respuesta deben incluir todos los posibles tipos de escalas en la pregunta.';
$string['validation_qualitymismatch'] = 'Esta combinación de tamaño y cualidad de intervalo no es válida.';
$string['validation_samestaticandgivennote'] = 'La nota dada y la respuesta no pueden corresponder a la misma tecla en el teclado.';
$string['validation_scale_invalidtonic'] = 'Tónica no válida para el tipo de escala especificado.';
$string['validation_scaleoutsidestaff'] = 'El registro de tónica dado produce una escala que no encaja dentro del pentagrama de la clave dada.';
$string['validationerror_chordquality_identify'] = 'Respuesta incompleta. Se debe seleccionar la letra, el accidente y clase acorde.';
$string['validationerror_empty'] = 'No se proporcionó una respuesta.';
$string['validationerror_harmonicfunction_identify'] = 'Respuesta incompleta. Se deben seleccionar todos los menús desplegables.';
$string['validationerror_incompletechordquality'] = 'Respuesta incompleta. Número de notas en este acorde';
$string['validationerror_incompleteharmonicfunction'] = 'Respuesta incompleta. Número de notas en esta función armónica';
$string['validationerror_interval_identify'] = 'Respuesta incompleta. Se debe seleccionar tanto la clase como el tamaño.';
$string['validationerror_invalidsyntax'] = 'Sintaxis de respuesta no válida.';
$string['validationerror_note_identify'] = 'Respuesta incompleta. Se debe seleccionar el nombre de la letra, el accidente y el registro.';
$string['validationerror_note_identify_ltr_acc'] = 'Respuesta incompleta. Deben seleccionarse tanto el nombre de la letra como el accidente.';
$string['validationerror_note_identify_ltr_reg'] = 'Respuesta incompleta. Deben seleccionarse tanto el nombre de la letra como el registro.';
$string['validationerror_notewrite_twonotesingrandstaff'] = 'Se ingresaron dos notas. Ingrese solo una nota.';
$string['validationerror_scale_identify'] = 'Respuesta incompleta. Se deben seleccionar todos los menús desplegables.';
$string['validationerror_scale_incomplete'] = 'Respuesta incompleta. Se requiere un total de 8 notas, incluida la tónica dada.';
$string['validationerror_scale_incomplete_melodic'] = 'Respuesta incompleta. Se requiere un total de 15 notas, incluida la tónica dada.';
$string['validationerror_whitespace'] = 'Sintaxis de respuesta no válida: elimine todos los espacios de su respuesta.';
