<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'kuet', language 'es', version '4.3'.
 *
 * @package     kuet
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abbreviationquestion'] = 'Q';
$string['accessrestrictions'] = 'Restricciones de acceso';
$string['active_sessions'] = 'Sesiones activas';
$string['activesessionmanagement'] = 'Gestión de sesiones activas';
$string['add_questions'] = 'Añadir preguntas';
$string['addquestions'] = 'Añadir preguntas';
$string['addquestions_desc'] = '¿Seguro que quiere añadir {$a} preguntas a la sesión?';
$string['advancemode'] = 'Modo avanzado';
$string['alreadyanswered'] = '¡Un miembro de tu grupo ya ha contestado!';
$string['alreadyteacher'] = 'Ya hay un profesor dirigiendo esta sesión, no puedes conectarte. Por favor, espera a que termine esta sesión para poder entrar.';
$string['anonymiseallresponses'] = 'Anonimizar completamente las respuetas de los estudiantes';
$string['anonymiseresponses'] = 'Anonimizar las respuestas de los estudiantes';
$string['anonymousanswer'] = 'Respuestas anónimas';
$string['anonymousanswer_help'] = 'Elige una opción.';
$string['anonymousanswers'] = 'Las respuestas en este cuestionario son anónimas.';
$string['automaticstart'] = 'Inicio automático';
$string['automaticstart_help'] = 'La sesión comenzará y finalizará automáticamente si se establecen fechas para la misma, por lo que no es necesario iniciarla manualmente.';
$string['average_time'] = 'Tiempo medio';
$string['backtopanelfromsession'] = 'Volver al panel de sesiones';
$string['backtopanelfromsession_desc'] = 'Si vuelve, la sesión no será iniciada pero la podrá volver a iniciar cuando quiera. ¿Quiere volver al panel de sesiones?';
$string['cachedef_grades'] = 'Esta es la descripción de las calificaciones en la caché de Kuet';
$string['certificate'] = 'Certificado';
$string['certificate_desc'] = 'Fichero de certificado SSL válido para el servidor .crt o .pem. Es posible que este archivo ya esté generado en el servidor, o puedes crear archivos únicos para este mod usando herramientas como <a href="https://zerossl.com" target="_blank">zerossl.com</a>.';
$string['changecategory'] = 'Cambiar categoría';
$string['changecategory_desc'] = 'Ha seleccionado preguntas que no se han agregado a la sesión. Si cambia de categoría perderá esta selección. ¿Desea continuar?';
$string['chooseoption'] = 'Elegir una opción';
$string['closequiz'] = 'Abrir cuestionario';
$string['closequizenable'] = 'Permitir';
$string['completed_sessions'] = 'Sesiones completadas';
$string['completionansweralldesc'] = 'Participar en una sesión contestando preguntas';
$string['completionansweralllabel'] = 'Participar en una sesión';
$string['completiondetail:answerall'] = 'Participar en una sesión contestando preguntas';
$string['configtitle'] = 'Kuet';
$string['configuration'] = 'Configuración';
$string['confirm'] = 'Aceptar';
$string['connection_closed'] = 'Conexión Cerrada {$a->reason} - {$a->code}';
$string['connectionclosed'] = 'Conexión cerrada';
$string['control'] = 'Control';
$string['controlpanel'] = 'Panel de control';
$string['copy'] = 'Copiar';
$string['copy_session'] = 'Copiar sesión';
$string['copyquestion'] = 'Copiar una pregunta de la sesión';
$string['copyquestion_desc'] = '¿Seguro que quiere copiar esta pregunta de la sesión?';
$string['copysession'] = 'Copiar sesión';
$string['copysession_desc'] = '¿Seguro que quiere copiar la sesión? Si la sesión tiene fechas de inicio automático o de inicio y finalización, será necesario restablecerlas.';
$string['copysessionerror'] = 'Ha ocurrido un error copiando la sesión. Compruebe que tenga el permiso "mod/kuet:managesessions", o inténtelo más tarde.';
$string['correct'] = 'Correcta';
$string['correct_answers'] = 'Respuestas correctas';
$string['corrects'] = 'Correctas';
$string['countdown'] = 'Mostrar cuenta atrás';
$string['countdown_help'] = 'Habilite esta opción para que los estudiantes vean la cuenta atrás en cada pregunta. (Sólo si la pregunta dispone de tiempo)';
$string['create_session'] = 'Crear sesión';
$string['delete_session'] = 'Eliminar sesión';
$string['deletequestion'] = 'Eliminar pregunta de la sesión';
$string['deletequestion_desc'] = '¿Seguro que quiere eliminar esta pregunta de la sesión?';
$string['deletesession'] = 'Eliminar sesión';
$string['deletesession_desc'] = '¿Seguro que quieres eliminar la sesión?';
$string['deletesessionerror'] = 'Ha ocurrido un error eliminando la sesión. Compruebe que tenga el permiso "mod/kuet:managesessions", o inténtelo más tarde.';
$string['downloadsocket'] = 'Descargar el fichero para ejecutarlo en el servidor externo';
$string['downloadsocket_desc'] = 'Este fichero de descarga es necesario ejecutarlo en el servidor externo.<br>El administrador de la máquina (servidor externo) debe proporcionarle un puerto y los certificados.<br>Es responsabilidad del administrador asegurar que el socket funciona permanentemente.<br>';
$string['edit_session'] = 'Editar sesión';
$string['end'] = 'Fin';
$string['end_session'] = 'Finalizar sesión';
$string['end_session_desc'] = '¿Seguro que quiere finalizar la sesión?';
$string['end_session_error'] = 'La sesión no puede finalizar debido a un error de comunicación con el servidor, por favor, inténtelo más tarde.';
$string['end_session_manual_desc'] = 'Si finaliza la sesión, cerrará la conexión de todos los estudiantes y ya no podrán responder este cuestionario.<br><b>¿Seguro que quiere finalizar la sesión?</b>';
$string['enddate'] = 'Fecha fin de sesión';
$string['enddate_help'] = 'La sesión finalizará automáticamente en esta fecha. La fecha de finalización solo estará disponible con sesiones programadas.';
$string['endsession'] = 'Sesión terminada';
$string['endsession_info'] = 'Has alcanzado el final de la sesión, ahora puedes ver el informe con tus resultados o continuar con el curso.';
$string['error_delete_instance'] = 'Error eliminando una instancia de kuet.';
$string['error_initsession'] = 'Error de inicio de sesión';
$string['error_initsession_desc'] = 'La sesión no puede iniciarse, puede que haya una sesión ya iniciada o debido a un error. Por favor, recarga la página.';
$string['erroreditsessionactive'] = 'No es posible editar una sesión activa';
$string['exitquestion'] = 'Salir de la pregunta';
$string['exitquestion_desc'] = 'Si sale de la pregunta, se marcará como no respondida. ¿Seguro que quiere salir?';
$string['external'] = 'Externo';
$string['externalurl'] = 'URL externa';
$string['externalurl_desc'] = 'URL donde el socket está alojado. Puede ser una IP, pero debe tener protocolo HTTPS.';
$string['fakegroup'] = 'Equipo Kuet {$a}';
$string['fakegroupdescription'] = 'La actividad Kuet ha creado este grupo porque hay participantes en este curso que no
pertenecen a ningun grupo selecionado.';
$string['feedback'] = 'Retroalimentación';
$string['final_ranking'] = 'Clasificación Final';
$string['finishquestion'] = 'Terminar pregunta';
$string['firstsession'] = 'Primera sesión calificable';
$string['gamemode'] = 'Modo de juego';
$string['generalsettings'] = 'Configuración General';
$string['go_questionbank'] = 'Ir al banco de preguntas';
$string['gocourse'] = 'Volver al curso';
$string['gradeaverage'] = 'Media aritmética de las califiaciones de las sesiones';
$string['gradehighest'] = 'Sesión con la calificación más alta';
$string['grademethod'] = 'Método de calificación';
$string['grademethod_help'] = 'Elige el modo para calificar este módulo de actividad. La nota aparecerá en el libro de calificaciones del curso.';
$string['gradesheader'] = 'Calificacón de la pregunta';
$string['groupdisconnected'] = 'El grupo {$a} se ha desconectado.';
$string['groupingid_not_selected'] = 'En modo de grupo, hay que elegir un agrupamiento';
$string['groupingremoved'] = 'Esta agrupamiento se ha eliminado o no tiene participantes. No puedes continuar con esta sesión.';
$string['groupings'] = 'Agrupaciones';
$string['groupmemberdisconnected'] = 'Este miembro del grupo {$a} se ha desconectado.';
$string['groupmode'] = 'Modo equipos';
$string['groupremoved'] = 'Tu grupo ha sido eliminado o no pertenece al agrupamiento de la actividad. No puedes seguir con la sesión.';
$string['groupreport'] = 'Informe de sesión de grupo';
$string['groupreport_info'] = 'Se muestran los resultados de la sesión del grupo.';
$string['groups'] = 'Equipos';
$string['groupsessionrankingreport'] = 'Informe de clasificación de la sesión grupal';
$string['httpsrequired'] = 'Es obligatorio usar protocola HTTPS para poder usar Kuet.';
$string['improvise'] = 'Improvisa';
$string['improvise_cloudtags'] = 'Improvisa Nube de tags';
$string['inactive_manual'] = 'Manual inactivo';
$string['inactive_programmed'] = 'Programado inactivo';
$string['inactivemode'] = 'Inactivo';
$string['incompatible_question'] = 'Pregunta no compatible';
$string['incorrect'] = 'Incorrecta';
$string['incorrect_sessionmode'] = 'Modo de sesión no válida';
$string['incorrects'] = 'Incorrectas';
$string['init_session'] = 'Iniciar sesión';
$string['init_session_desc'] = 'Si inicia una sesión manualmente, puede bloquear las sesiones programadas con inicio automático. Asegúrese de que no haya sesiones próximas antes de comenzar esta sesión.<br>¿Seguro que quieres iniciar la sesión?';
$string['introduction'] = 'Descripción';
$string['invalid'] = 'Incorrecta';
$string['invalidcertificates'] = 'Certificados y Puerto inválidos';
$string['isevaluable'] = '¿Es evaluable?';
$string['jump'] = 'Saltar';
$string['jumpto_error'] = 'Debe ser un número entre 1 y {$a}';
$string['kuet:addinstance'] = 'Añadir un nuevo Kuet';
$string['kuet:managesessions'] = 'Gestionar Sesiones';
$string['kuet:startsession'] = 'Iniciar Sessiones';
$string['kuet:view'] = 'Ver Kuet';
$string['kuet:viewanonymousanswers'] = 'Ver respuestas anónimas';
$string['kuet_header'] = 'Ajustes de Kuet';
$string['kuetnotexist'] = 'Imposible encontrar el kuet con id {$a}';
$string['lastsession'] = 'Última sesión calificable';
$string['local'] = 'Local';
$string['lowspeed'] = 'Your internet connection seems slow or unstable ({$a->downlink} Mbps, {$a->effectiveType}). This may cause unexpected behaviour, or sudden closure of the session.<br>We recommend that you do not init session until you have a good internet connection.';
$string['manualmode'] = 'Manual';
$string['modulename'] = 'Kuet';
$string['modulenameplural'] = 'Kuets';
$string['multiplesessionerror'] = 'Esta sesión no está activa o ya no existe.';
$string['name'] = 'Nombre';
$string['next'] = 'Siguiente';
$string['nextsession'] = 'Próxima sesión:';
$string['no_time'] = 'Sin tiempo';
$string['noanonymiseresponses'] = 'No anonimizar las respuestas de los estudiantes';
$string['noevaluable'] = 'No evaluable';
$string['nograde'] = 'Sin calificar';
$string['nograding'] = 'Ignorar respuesta correcta y calificación';
$string['nogroupingscreated'] = 'Esta actividad está en modo grupos pero no hay agrupamientos creados en este curso.
Es necesario que crees un agrupamiento para poderlo elegir en la actividad.';
$string['noresponse'] = 'Sin responder';
$string['nosession'] = 'No hay sesiones iniciadas por el profesor';
$string['nosocket'] = 'Sin uso de socket';
$string['notactivesession'] = 'Oops, parece que tu profesor no ha iniciado todavía la sesión...';
$string['notactivesessionawait'] = 'Espera a que lo inicie o consulta tus últimos informes.';
$string['notallowedpasting'] = 'No está permitido pegar texto';
$string['notallowedspecialchars'] = 'No se permiten caracteres especiales: ?!<>\\';
$string['notanswers'] = 'Sin contestar';
$string['notimelimit'] = 'Sin límite de tiempo';
$string['notimelimitenabled'] = 'La sesión se fija sin límite de tiempo..<br>Si desea agregar un tiempo por pregunta, debe especificar el modo de sesión en "Tiempo por pregunta", especificar un tiempo predeterminado y luego puede establecer un tiempo para cada pregunta usando este formulario.';
$string['number_select'] = 'Preguntas seleccionadas:';
$string['onlyinactivemodevalid'] = 'Sólo es váido del modo de juego inactivo con modo manual avanzado.';
$string['openquiz'] = 'Abrir cuestionario';
$string['openquizenable'] = 'Habilitar';
$string['otheruserreport'] = 'No puedes ver el informe de otro alumno';
$string['partially'] = 'Parcialmente';
$string['partially_correct'] = 'Parcialmente correcta';
$string['participant'] = 'Participante';
$string['participants'] = 'Participantes';
$string['pause'] = 'Pausa';
$string['percent_correct'] = '% correctas';
$string['percent_incorrect'] = '% incorrectas';
$string['percent_noresponse'] = '% Sin responder';
$string['percent_partially'] = '% Parcialmente correctas';
$string['play'] = 'Play';
$string['pluginadministration'] = 'Administración Kuet';
$string['pluginname'] = 'Kuet';
$string['podium_manual'] = 'Manual podio';
$string['podium_programmed'] = 'Programado Podio';
$string['podiummode'] = 'Podio';
$string['points'] = 'Puntos';
$string['port'] = 'Puerto';
$string['port_desc'] = 'Puerto para realizar la conexión. Este puerto debe estar abierto, por lo que deberá consultar con el administrador del sistema..';
$string['preview'] = 'Previsualización';
$string['previousstarterror'] = 'La fecha de inicio de la sesión no puede ser posterior a la fecha fin.';
$string['privatekey'] = 'Clave privada';
$string['privatekey_desc'] = 'Fichero con la clave privada para el servidor .pem or .key. Es posible que este archivo ya esté generado en el servidor, o puedes crear archivos únicos para este mod usando herramientas como <a href="https://zerossl.com" target="_blank">zerossl.com</a>.';
$string['programmedmode'] = 'Programado';
$string['provisional_ranking'] = 'Clasificación provisional';
$string['qstatus_0'] = 'Incorrecta';
$string['qstatus_1'] = 'Correcta';
$string['qstatus_2'] = 'Parcialmente correcta';
$string['qstatus_3'] = 'Sin responder';
$string['qstatus_4'] = 'No evaluable';
$string['qstatus_5'] = 'Inválida';
$string['qtimelimit_help'] = 'Tiempo para contestar la respuesta. Útil cuando el tiempo de la sesión es la suma de los tiempos de las preguntas.';
$string['question'] = 'Pregunta';
$string['question_actions'] = 'Acciones';
$string['question_index_string'] = '{$a->num} de {$a->total}';
$string['question_isvalid'] = 'Es válida';
$string['question_name'] = 'Nombre';
$string['question_nosuitable'] = 'No compatible con Kuet.';
$string['question_number'] = 'Nº de la pregunta';
$string['question_position'] = 'Posición';
$string['question_time'] = 'Tiempo por pregunta';
$string['question_time_help'] = 'Se configura un tiempo por pregunta (Puedes hacerlo tras añadir una pregunta). A default time will be set to allocate to those questions that do not have a defined time.';
$string['question_type'] = 'Tipo';
$string['question_version'] = 'Versión';
$string['questionid'] = 'Id';
$string['questionidnotsent'] = 'Id de pregunta no enviado';
$string['questionnameheader'] = 'Nombre de la pregunta: "{$a}"';
$string['questionreport'] = 'Informe de pregunta';
$string['questionreport_info'] = 'Se muestra el informe de la pregunta.';
$string['questions'] = 'Preguntas';
$string['questions_bank'] = 'Banco de preguntas';
$string['questions_list'] = 'Preguntas selecionadas';
$string['questions_number'] = 'Nº de preguntas';
$string['questionsconfiguration'] = 'Configuración de la pregunta';
$string['questionsconfiguration_info'] = 'Añade preguntas a la sesión';
$string['questiontime'] = 'Tiempo de Pregunta';
$string['questiontime_desc'] = 'Tiempo para cada pregunta en segundos.';
$string['questiontime_help'] = 'Tiempo para cada pregunta en segundos.';
$string['race_manual'] = 'Manual Carrera';
$string['race_programmed'] = 'Programado Carrera';
$string['racemode'] = 'Carrera';
$string['randomanswers'] = 'Respuestas aleatorias';
$string['randomanswers_help'] = 'Las respuestas aparecerán en orden aleatorio para cada estudiante..';
$string['randomquestions'] = 'Preguntas aleatorias';
$string['randomquestions_help'] = 'Las preguntas aparecerán en orden aleatorio para cada estudiante. Sólo disponible es sesiones programadas.';
$string['ranking'] = 'Clasificación';
$string['ready_groups'] = 'Grupos preparados';
$string['ready_users'] = 'Participantes preparados';
$string['reply_improvise'] = 'Respuesta';
$string['reply_improvise_help'] = 'Sé el primero en añadir una palabra a la nube de tags. (Opcional)';
$string['reply_improvise_student_help'] = 'Intenta responder a la pregunta con una palabra.';
$string['report'] = 'Informe';
$string['reportlink'] = 'Enlace al informe';
$string['reports'] = 'Informes';
$string['reports_info'] = 'Todas las sesiones completadas se muestran para poder acceder a los informes.';
$string['resend'] = 'Reenviar';
$string['response'] = 'Respuesta';
$string['response_number'] = 'Nº de respuestas';
$string['responses'] = 'Respuestas';
$string['results'] = 'Resultados';
$string['score'] = 'Puntuación';
$string['score_moment'] = 'Calificación de la pregunta';
$string['score_obtained'] = 'Puntuación obtenida';
$string['scored_answers'] = 'Puntuación de las respuestas';
$string['scriptphp'] = 'Descargar Archivo PHP';
$string['select_category'] = 'Selecciona una categoría';
$string['selectall'] = 'Seleccionar/Desseleccionar todo';
$string['selectone'] = 'Seleccionar preguntas';
$string['selectone_desc'] = 'Selecciona al menos una pregunta para añadir a la sesión.';
$string['selectvisibles'] = 'Seleccionar/Desseleccionar visibles';
$string['send_response'] = 'Enviar respuestas';
$string['session'] = 'Sesión';
$string['session_actions'] = 'Acciones';
$string['session_closed'] = 'La conexión se ha cerrado.';
$string['session_closed_info'] = 'Esto puede ser debido a la finalización de la sesión o por problemas técnicos con la conexión. Por favor, vuelve a la sesión para reconectar o ponte en contacto con tu profesor.';
$string['session_date'] = 'Fecha';
$string['session_finishingdate'] = 'Fecha fin';
$string['session_gm_combined'] = 'Media calculada entre el cálculo de la situación relativa en el ranking y el cálculo de los puntos obtenidos.';
$string['session_gm_combined_short'] = 'Media entre la situación en el ranking y los puntos obtenidos.';
$string['session_gm_disabled'] = 'Deshabilitado';
$string['session_gm_points'] = 'Cálculo relativo a los puntos obtenidos: [puntuación]/[puntuación máxima]*100%';
$string['session_gm_points_short'] = '[puntuación]/[puntuación máxima]*100%';
$string['session_gm_position'] = 'Cálculo relativo a la situación en el ranking: ([participantes]-[posición]+1)/[participantes]*100%';
$string['session_gm_position_short'] = '([participantes]-[posición]+1)/[participantes]*100%';
$string['session_groupings_error'] = 'Esta actividad está configurada en modo grupos. Cada sesión debe tener seleccionado un agrupamiento.';
$string['session_groupings_no_groups'] = 'El agrupamiento está vacío. Por favor, seleccione un agrupamiento con participantes de grupo.';
$string['session_groupings_no_members'] = 'El agrupamiento está vacio. Por favor, selecciona una agrupamiento con participantes.';
$string['session_groupings_same_user_in_groups'] = 'Cada participante, solo debe pertenecer a un grupo del agrupamiento. Comprueba los siguientes participantes: {$a}';
$string['session_info'] = 'Información de la sesión';
$string['session_name'] = 'Nombre de la Sesion';
$string['session_name_help'] = 'Escribe un nombre de sesión';
$string['session_name_placeholder'] = 'Nombre de la Sesion';
$string['session_time'] = 'Tiempo total de sesión';
$string['session_time_resume'] = 'Tiempo total de sesión: {$a}';
$string['sessionactivated'] = 'Sesión {$a->sessionid} activada para kuetid {$a->kuetid}';
$string['sessionalreadyexists'] = 'El nombre de sesión ya existe';
$string['sessionconfiguration'] = 'Configuración de la sesión';
$string['sessionconfiguration_info'] = 'Configura tu propia sesión';
$string['sessionconflict'] = 'Esta sesión tiene un conflicto de fechas con otras sesiones y no comenzará automáticamente hasta que se resuelva el conflicto.';
$string['sessioncreating'] = 'No has terminado todavía de editar la sesión. Debes alcanzar el paso 3 y pulsar en el botón de Terminar';
$string['sessionended'] = 'Sesión finalizada';
$string['sessionended_desc'] = 'Cuando una sesión finaliza, se lanza un evento para calcular la nota de la sesión del alumno.';
$string['sessionerror'] = 'Esta sesión no está configurada correctamente';
$string['sessionfinished'] = 'Sesión {$a->sessionid} finalizada para kuetid {$a->kuetid}';
$string['sessionfinishedformoreone'] = 'Sesión {$a->sessionid} finalizada para kuetid {$a->kuetid} debido a que ya hay una sesión activa.';
$string['sessionlimittimebyquestionsenabled'] = 'Esta sesión tiene un tiempo limitado de {$a}. El tiempo total de cada pregunta se calculará dividiendo el tiempo total de la sesión por el número de preguntas.<br>Si quiere añadir un tiempo por pregunta, debe configurar el modo de sesión como "Tiempo por pregunta", indicar un valor por defecto y a continuación podrá modificar el tiempo de cada pregunta.';
$string['sessionmanualactivated'] = 'La sesión {$a->sessionid} está activa en kuetid -> {$a->kuetid}. El resto de la sesión se omite hasta el final de esta sesión.';
$string['sessionmode'] = 'Modo de sesión';
$string['sessionmode_help'] = 'Los modos de sesión son distintas formas de mostrar las sesiones.';
$string['sessionnoquestions'] = 'No se han añadido preguntas a la sesión';
$string['sessionquestionsreport'] = 'Informe de preguntas de sesión';
$string['sessionrankingreport'] = 'Informe de clasificación de la sesión';
$string['sessionreport'] = 'Informe de la sesión';
$string['sessionreport_info'] = 'Se muestra el informe de la sesión.';
$string['sessions'] = 'Sesiones';
$string['sessions_info'] = 'Todas las sesiones son mostradas';
$string['sessionsnum'] = 'Number of sessions';
$string['sessionstarted'] = 'Sesión iniciada';
$string['sessionstarted_info'] = 'Ha iniciado la sesión. Ahora, haga seguimiento de las preguntas.';
$string['sessiontime'] = 'Tiempo de sesión';
$string['sessiontime_help'] = 'El tiempo establecido se dividirá entre el número de preguntas, y se asignará el mismo tiempo a todas las preguntas.';
$string['sessionwarning'] = 'Esta sesión debería haber empezado, pero hay una sesión activa que lo impide. En cuanto acabe dicha sesión, comenzará esta automáticamente.';
$string['sgrade'] = 'Calificar la sesión';
$string['sgrade_desc'] = 'Si está habilitado, la nota obtenida se mostrará en el libro de calificaciones.';
$string['sgrade_help'] = 'Compruebe esta opción si quiere que la nota obtenida en la sesión sea parte de la nota de la actividad en el libro de calificaciones del curso.';
$string['showfeedback'] = 'Mostrar retroalimentación';
$string['showfeedback_help'] = 'Después de responder cada pregunta, aparecerán comentarios. En el modo manual, el profesor puede mostrar u ocultar los comentarios de cada pregunta (solo si la pregunta contiene comentarios).';
$string['showfinalgrade'] = 'Mostrar nota final';
$string['showfinalgrade_help'] = 'La nota final aparecerá al finalizar la sesión.';
$string['showgraderanking'] = 'Mostrar clasificación entre preguntas';
$string['showgraderanking_help'] = 'El profesor no verá la clasificación durante una sesión en vivo. Sólo disponible en los modos de sesión de podios.';
$string['showgraderankinghelp'] = 'El profesor no verá la clasificación durante una sesión en vivo. Sólo disponible en los modos de sesión de podios..';
$string['showhide'] = 'Mostrar / Ocultar';
$string['socket'] = 'Socket';
$string['socketclosed'] = 'Socket cerrado';
$string['sockettype'] = 'Tipo de Socket';
$string['sockettype_desc'] = 'Para iniciar sesiones manuales, es necesario tener configuracion un socket. Puede ser local o externo: <ul><li><b>Sin socket: </b>Las sesiones manuales no estarán disponibles</li><li><b>Socket local: </b>EL socket se iniciará en el mismo servidor que esta platafomra Moodle (es necesario tener certificados).</li><li><b>Externo: </b>Puede iniciar el socket en un servidor externo, configurando dicha conexión con una URL y un puerto.</li></ul>';
$string['sslcertificates'] = 'Certificados SSL';
$string['startdate'] = 'Fecha de inicio de sesión';
$string['startdate_help'] = 'La sesión comenzará automáticamente en esta fecha. La fecha de inicio solo estará disponible con sesiones programadas.';
$string['startminorend'] = 'La fecha fin de la sesión no puede ser igual o anterior a la fecha de inicio.';
$string['statement'] = 'Declaración';
$string['statement_improvise'] = 'Statement of the cloud of tags';
$string['statement_improvise_help'] = 'Recuerde que debe ser una pregunta que se pueda responder preferiblemente con una palabra.';
$string['statement_improvising'] = 'Improvisa pregunta Nube de Tags';
$string['statistics'] = 'Estadísticas';
$string['status'] = 'Estado';
$string['student_number'] = 'Nº de alumnos';
$string['students'] = 'Alumnos';
$string['submit'] = 'Enviar';
$string['success'] = 'Correcta';
$string['summarysession'] = 'Resumen de la sesión';
$string['summarysession_info'] = 'Resumen de la sesión';
$string['system_error'] = 'Ha ocurrido un error y la conexión se ha cerrado.<br>No es posible continuar con esta sesión.';
$string['teacherimprovising'] = 'El profesor está improvisando una pregunta "Nube de Etiquetas", en la cual debes responder con una palabra.<br>En cuanto el profesor termine, la pregunta aparecerá en la pantalla, podrás responderla y ver las respuestas de tus compañeros.';
$string['team_grade_average'] = 'Respuesta media';
$string['team_grade_first'] = 'Primera respuesta';
$string['team_grade_last'] = 'Última respuesta';
$string['teamgrade'] = 'Calificación de equipos';
$string['teamgrade_help'] = 'Esta es la forma en que se califica a cada miembro del equipo.';
$string['teamsgradeheader'] = 'Calificación de equipos';
$string['testssl'] = 'Prueba de conexión';
$string['testssl_desc'] = 'Prueba de conexión con certificados SSL';
$string['time'] = 'Tiempo';
$string['timecannotbezero'] = 'El tiempo no puede ser 0';
$string['timelimit'] = 'Tiempo límite';
$string['timelimit_help'] = 'Tiempo total para la sesión';
$string['timemode'] = 'Modo tiempo';
$string['timemode_help'] = 'Hay que tener en cuenta que el tiempo por pregunta corresponde al tiempo permitido para responder. Una vez que se responda, se parará el tiempo <br><br><b> Sin tiempo: </b> No hay limite de tiempo para finalizar la sesión. El tiempo por pregunta se puede configurar en algunas o ninguna desde el panel de preguntas <br><b>Tiempo total por sesión:</b> Cada pregunta tendrá el mismo tiempo para responder (este valor se dividirá entre el número de preguntas) <br><b>Tiempo por pregunta:</b> Este valor será el valor por defecto de cada pregunta. (En cada pregunta se podrá modificar dicho valor) <br><br><b>Importante:</b> Si durante una pregunta con tiempo definido el alumno cierra el navegador o refresca la página, esa pregunta será considerada no enviada (por considerarse un intento de ganar tiempo para contestar).';
$string['timemodemustbeset'] = 'Se debe seleccionar un tiempo de sesión o de pregunta.';
$string['timeperquestion'] = 'Tiempo por pregunta';
$string['timesettings'] = 'Configuración de Tiempos';
$string['total_score'] = 'Puntuación Total';
$string['unit'] = 'Unidad';
$string['units'] = 'Unidades';
$string['userdisconnected'] = 'El usuario {$a} se ha desconectado.';
$string['userreport'] = 'Informe de sesión de usuario';
$string['userreport_info'] = 'Se muestran los resultados de la sesión del alumno.';
$string['validcertificates'] = 'Certificados y Puerto válidos';
$string['viewquestion_user'] = 'Ver respuesta';
$string['viewreport_group'] = 'Informe de grupo';
$string['viewreport_session'] = 'Ver informe';
$string['viewreport_user'] = 'Informe de usuario';
$string['vote'] = 'Vota';
$string['vote_tags'] = 'Vota tags';
$string['waitingroom'] = 'Sala de espera';
$string['waitingroom_info'] = 'Comprueba que todo está correcto antes de empezar la sesión.';
$string['waitingroom_message'] = 'Espera, en seguida comenzamos....';
$string['waitteacher'] = 'Esperando al profesor';
$string['warningtest'] = 'Esto intentará una conexión al socket con la configuración actual. <b>Guarde la configuración antes de realizar la prueba.</b>';
