<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_boosted', language 'fr', version '4.3'.
 *
 * @package     theme_boosted
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['about'] = 'À propos';
$string['aboutsettings'] = 'À propos';
$string['advancedsettings'] = 'Avancé';
$string['backgroundimage'] = 'Image d’arrière-plan';
$string['backgroundimage_desc'] = 'L’image à afficher en arrière-plan du site. L’image d’arrière-plan déposée ici remplacera la couleur d’arrière-plan. Cette image ne s’affiche pas sur les appareils mobiles.';
$string['bannerbutton'] = 'Bouton CTA de la bannière';
$string['bannerbuttondesc'] = 'Texte du bouton CTA situé dans la bannière supérieure. S’il est vide, le bouton ne sera pas affiché.';
$string['bannerbuttonlink'] = 'Lien du bouton CTA de la bannière';
$string['bannerbuttonlinkdesc'] = 'Ajouter le lien pour rediriger les utilisateurs lors d’un clic sur le bouton CTA. Le lien sera toujours ouvert dans un nouvel onglet.';
$string['bannerimage'] = 'Image de la bannière';
$string['bannerimagedesc'] = 'Une image de bannière affichée en haut de la page d’accueil. L’image doit faire au moins 1600×400 pixels (1900×400 pixels pour un meilleur affichage) et peut être au format .jpg, .png et même un .gif animé. L’image est affichée centrée et recadrée.';
$string['bannertext'] = 'Texte de la bannière';
$string['bannertextdesc'] = 'Texte de la bannière. S’il est vide, le texte ne sera pas affiché.<br>Il est possible d’insérer des balises HTML pour formater le texte comme &lt;u&gt;, &lt;em&gt;, &lt;i&gt; ou &lt;br&gt;, ainsi qu’une étiquette &lt;span&gt; pour ajouter des styles par mot ou phrase.';
$string['bannertextvalign'] = 'Alignement vertical du texte de la bannière';
$string['bannertextvaligndesc'] = 'Aligner le texte de la bannière et le bouton verticalement : en haut, au centre ou en bas.';
$string['bottom'] = 'En bas';
$string['brandcolor'] = 'Couleur de la marque';
$string['brandcolor_desc'] = 'Définit la couleur de la marque utilisée dans l’ensemble du site.';
$string['centre'] = 'Centré';
$string['choosereadme'] = 'Boosted est un thème moderne et hautement personnalisable basé sur Boost. Certains éléments peuvent être configurés facilement : couleurs, polices, page d’accueil, page de connexion, et bien d’autres, pour déployer un site en quelques minutes.';
$string['colordesc'] = 'Dans cette section peuvent être choisies les couleurs principales à appliquer dans le thème. Utiliser le format Hex (recommandé) ou tout autre format standard comme RVB ou <a target="_blank" href="https://en.wikipedia.org/wiki/Web_colors#HTML_color_names">Noms de couleurs standard</a>.< br> Comme option alternative, on peut également indiquer les valeurs <i>transparent</i> et <i>inherited</i>';
$string['colorsettings'] = 'Couleurs';
$string['configtitle'] = 'Boosted';
$string['contentwidth'] = 'Largeur du contenu';
$string['contentwidthdesc'] = 'La largeur de la page appliquée à l’ensemble du site. S’il est défini sur 100 %, l’image ou la couleur d’arrière-plan ne s’affichera pas.';
$string['course'] = 'cours';
$string['coursesettings'] = 'Page de cours';
$string['customfontheader'] = 'Police des en-têtes personnalisés';
$string['customfontheaderdesc'] = 'Sélectionner une police à utiliser comme police des en-têtes.';
$string['customfontmain'] = 'Fichier de police principal personnalisé';
$string['customfontmaindesc'] = 'Sélectionner une police à utiliser comme police principale.';
$string['enrollcoursecard'] = 'Inscrire';
$string['favicon'] = 'Icône de favori';
$string['favicondesc'] = 'Déposer une image d’icône de favori pour identifier votre site dans le navigateur. Sinon, la favicon Boosted par défaut sera affiché.';
$string['focusborder'] = 'Couleur de la bordure de la fenêtre active';
$string['focusborderdesc'] = 'Couleur de la bordure lorsqu’un élément a le focus. Ajouter une couleur pour améliorer l’accessibilité. Définir la couleur sur <i>transparent</i> pour masquer l’effet (non recommandé)';
$string['fontdesc'] = 'Cette section permet de sélectionner la police principale et la police des titres utilisées dans le site.';
$string['fontheadercolor'] = 'Couleur de la police des titres';
$string['fontheadercolordesc'] = 'Définit la couleur de la police utilisée dans les en-têtes de thème.';
$string['fontheaderweight'] = 'Poids de la police des titres';
$string['fontheaderweightdesc'] = 'Poids de la police des en-têtes utilisée dans le site. Sélectionner une valeur entre 100 et 900 selon la police. 700 est la valeur commune pour le poids en gras.';
$string['fontmaincolor'] = 'Couleur de la police principale';
$string['fontmaincolordesc'] = 'Définit la couleur de la police principale dans le thème.';
$string['fontsettings'] = 'Polices';
$string['fontsize'] = 'Taille de la police principale';
$string['fontsizedesc'] = 'Sélectionner la taille de police principale par défaut utilisée dans l’ensemble du site (la valeur standard est 1rem = 16px).';
$string['fontweight'] = 'Poids de la police principale';
$string['fontweightdesc'] = 'Poids de police utilisé par la police principale. Sélectionner une valeur entre 100 et 900 selon la police. 400 est la valeur commune pour le poids normal';
$string['footerbgcolor'] = 'Couleur de fond du pied de page';
$string['footerbgcolordesc'] = 'Définit la couleur d’arrière-plan du pied de page.';
$string['footerblocks'] = 'Blocs';
$string['footerblocksdesc'] = 'Ajouter des blocs pour insérer du contenu dans le pied de page. Jusqu’à quatre blocs peuvent être ajoutés pour insérer n’importe quel contenu, texte ou média, et même intégrer une carte.<br>
Sélectionner d’abord le nombre de blocs à afficher, puis appuyez sur le bouton « Enregistrer les modifications » et le nombre de blocs sélectionnés s’affichera.<br><br>
<b>Exemple (copiez l’extrait et collez-le dans l’éditeur HTML à l’aide du bouton </>) :</b>
<pre><code>
&lt;ul&gt;
    &lt;li&gt;À propos de nous&lt;/li&gt;
    &lt;li&gt;Nous trouver&lt;/li&gt;
    &lt;li&gt;Contact&lt;/li&gt;
    &lt;li&gt;Magasin&lt;/li&gt;
&lt;/ul&gt;
</code></pre><br>';
$string['footercontent'] = 'Bloc de contenu';
$string['footercontentdesc'] = 'Ajouter du contenu pour le bloc';
$string['footerdesc'] = 'Ajouter un titre pour le bloc';
$string['footerheader'] = 'Titre du bloc';
$string['footerlayout'] = 'Nombre de blocs';
$string['footerlayoutdesc'] = 'Définit le nombre de blocs. Pour n’afficher aucun bloc, en sélectionner un et laisser le titre et le contenu vides.';
$string['footersettings'] = 'Pied de page';
$string['footertextcolor'] = 'Couleur du texte du pied de page';
$string['footertextcolordesc'] = 'Définit la couleur du texte du pied de page.';
$string['footnote'] = 'note de pied de page';
$string['footnotedesc'] = 'Ajouter un texte de note de pied de page tel que le droit d’auteur, la clause de non-responsabilité, la marque déposée…';
$string['formsbackgroundcolor'] = 'Couleur de fond des formulaires';
$string['formsbackgroundcolordesc'] = 'Définit la couleur d’arrière-plan des éléments de formulaire : zone de texte, zone de texte et sélections.';
$string['formstextcolor'] = 'Couleur de texte des formulaires';
$string['formstextcolordesc'] = 'Définit la couleur du texte pour les éléments de formulaires : zone de texte, fenêtre de texte et sélections.';
$string['frontpagedesc'] = 'Cette section permet de configurer la page d’accueil en ajoutant une bannière d’image, des blocs d’informations et le catalogue des cours';
$string['frontpagesettings'] = 'Page de garde';
$string['generalsettings'] = 'Général';
$string['headerbgcolor'] = 'Couleur de fond de la barre de navigation';
$string['headerbgcolordesc'] = 'Définit la couleur d’arrière-plan de la barre de navigation.';
$string['headerdesc'] = 'Cette section permet de définir la disposition, les styles et le contenu de l’en-tête';
$string['headersettings'] = 'En-tête';
$string['headertextcolor'] = 'Couleur de texte de la barre de navigation et des liens';
$string['headertextcolordesc'] = 'Définit la couleur de texte de la barre de navigation et du lien. Si une couleur sombre est choisie pour l’arrière-plan, ne pas oublier pas de définir une couleur claire pour le texte';
$string['hide'] = 'Masquer';
$string['hidefootersocial'] = 'Afficher les icônes sociales';
$string['hidefootersocialdesc'] = 'Afficher les icônes sociales dans le pied de page sous les blocs.';
$string['homebg'] = 'Image d’arrière-plan';
$string['homebgdesc'] = 'Déposer une image qui sera l’image de fond pour l’ensemble du site.';
$string['infoblock'] = 'Blocs d’informations';
$string['infoblockcontent'] = 'Contenu du bloc d’informations';
$string['infoblockcontentdesc'] = 'Saisir le contenu du bloc d’informations.N’importe quel contenu peut être ajouté en utilisant HTML/CSS comme du texte, des images ou des vidéos.';
$string['infoblockdesc'] = 'Ajouter des blocs d’information dans la page d’accueil. Vous pouvez ajouter une ligne avec jusqu’à quatre blocs et insérer n’importe quel contenu, texte ou média, même intégrer une vidéo.<br>
Sélectionnez d’abord le nombre de blocs à afficher, puis appuyez sur le bouton « Enregistrer les modifications » et le nombre de blocs sélectionnés s’affichera.<br>
Si vous ne souhaitez afficher aucun bloc, sélectionnez-en un et laissez le contenu vide.<br>
<b>Exemple</b> (copiez l’extrait et collez-le dans l’éditeur HTML à l’aide du bouton </>) :
<pre><code>
&lt;div style="width: 100%; height: 16rem; background:#2979a0; color: white; padding: 1rem; border-radius:1rem;"&gt;
    &lt;div style="text-align: center; padding: 10px;"&gt;
    &lt;div style="text-align : center ; padding : 10 px ;"&gt;
        &lt;i class="fa fa-4x fa-wrench" aria-hidden="true" style="text-align: center;"&gt;&lt;/i&gt;
    &lt;/div&gt;
    &lt;h5 style="color: white; text-align: center;"&gt;Entrez le titre&lt;/h5&gt;
    &lt;p style="text-align: center;"&gt;Entrez ici les informations à afficher&lt;/p&gt;
&lt;/div&gt;
</code></pre><br>';
$string['infoblockslayout'] = 'Nombre de blocs d’informations';
$string['infoblockslayoutdesc'] = 'Sélectionner le nombre de blocs d’informations à afficher sur la page d’accueil.<br><br>Pour ne pas afficher les blocs d’informations, en sélectionner simplement un et laisser son contenu vide.';
$string['information'] = '<b>Signaler les bogues et les améliorations :</b><p>Dans notre référentiel Github : <a href="https://github.com/koditik/moodle-theme_boosted" target="_blank">https://github .com/koditik/moodle-theme_theme</a>
<br><u>Veuillez signaler seulement les bugs et les améliorations. Tout autre sujet sera supprimé.</u></p>';
$string['left'] = 'Gauche';
$string['loginbackgroundimage'] = 'Image de fond pour la page de connexion';
$string['loginbackgroundimage_desc'] = 'Déposer l’image à afficher en arrière-plan pour la page de connexion uniquement. L’image ne s’affiche pas sur les appareils mobiles.';
$string['loginboxalign'] = 'Alignement de la fenêtre de connexion';
$string['loginboxaligndesc'] = 'Définit l’alignement horizontal de la fenêtre de connexion sur l’écran.';
$string['logindesc'] = 'Cette section permet de configurer la page de connexion en ajoutant une image de fond et en positionnant la fenêtre de connexion sur l’écran.
<br>Le logo affiché en haut de la fenêtre de connexion est celui définit comme « Logo » dans la <a href="../admin/settings.php?section=logos">section Logos</a>';
$string['loginsettings'] = 'Page de connexion';
$string['next_activity'] = 'Suivant';
$string['noimage'] = 'Image de cours par défaut';
$string['noimage_desc'] = 'L’image du cours affichée dans les cours qui n’ont pas de définition d’image.';
$string['nomycourses'] = 'Pas Mes cours';
$string['othersettings'] = 'Autre';
$string['pagebgcolor'] = 'Couleur d’arrière-plan';
$string['pagebgcolordesc'] = 'Définit la couleur d’arrière-plan pour l’ensemble du site. Ce paramètre ne s’applique pas aux appareils mobiles.';
$string['pluginname'] = 'Boosted';
$string['preset'] = 'Style du thème';
$string['preset_desc'] = 'Sélectionner un style pour modifier l’apparence générale du thème. Après avoir enregistré les modifications, purger le cache sur <a href="../admin/purgecaches.php">Purger les caches</a> pour éviter les problèmes';
$string['prev_activity'] = 'Précédent';
$string['privacy:metadata'] = 'Le thème Boosted n’enregistre aucune donnée personnelle.';
$string['rawscss'] = 'SCSS brut';
$string['rawscss_desc'] = 'Utiliser ce champ pour fournir le code SCSS ou CSS qui sera injecté à la fin de la feuille de style.';
$string['rawscsspre'] = 'SCSS initial brut';
$string['rawscsspre_desc'] = 'Ce champ permet de fournir le code SCSS d’initialisation, qui sera injecté avant tout le reste. La plupart du temps, vous utiliserez ce paramètre pour définir des variables.';
$string['right'] = 'Droite';
$string['searchcourses'] = 'Rechercher des cours';
$string['selectionbg'] = 'Couleur d’arrière-plan de la sélection';
$string['selectionbgdesc'] = 'Définit la couleur d’arrière-plan lorsqu’un texte est sélectionné.';
$string['selectiontext'] = 'Couleur du texte sélectionné';
$string['selectiontextdesc'] = 'Définit la couleur du texte lorsqu’un texte est sélectionné.';
$string['settingsaccesscolors'] = 'Accessibilité';
$string['settingsfootercolors'] = 'Pied de page';
$string['settingsformscolors'] = 'Formulaires';
$string['settingsheadercolors'] = 'En-tête';
$string['settingsheaderfont'] = 'Rubriques';
$string['settingsmaincolors'] = 'Principal';
$string['settingsmainfont'] = 'Principal';
$string['show'] = 'Afficher';
$string['socialheading'] = 'Paramètres des icônes sociales';
$string['socialiconslist'] = 'Liste des icônes sociales';
$string['socialiconslistdesc'] = 'Saisir une liste délimitée pour configurer les icônes sociales dans le pied de page.<br>
Le format est :

URL|titre|icône

<b>Exemple :</b>
<pre>
https://facebook.com/|Facebook|fa-facebook-square
https://twitter.com/|Twitter|fa-twitter-square
https://instagram.com|Instagram|fa-instagram
https://example.com|Mon Web|fa-globe
</pre>
Pour référence des icônes, vous pouvez trouver la liste complète des <a href="https://fontawesome.com/v4.7.0/icons/" target="_blank">icônes de polices Awesome</a> avec la plupart des réseaux sociaux disponibles . Vous pouvez ajouter n’importe quel nombre d’icônes.';
$string['styles'] = 'Styles';
$string['stylesdesc'] = 'Cette section permet de vérifier comment les styles sont appliqués aux différents éléments du thème : texte, arrière-plan, boutons…';
$string['stylessettings'] = 'Styles';
$string['support'] = '<br><b>Assistance :</b><p>postez vos questions dans le <a href="https://moodle.org/mod/forum/view.php?id=46" target="_blank" >Forum des thèmes Moodle</a>.
<br>Veuillez indiquer les informations ci-dessus sur les versions Moodle et Boosted.</p></br>';
$string['top'] = 'En haut';
$string['unaddableblocks'] = 'Blocs inutiles';
$string['unaddableblocks_desc'] = 'Les blocs spécifiés ne sont pas nécessaires lors de l’utilisation de ce thème et ne seront pas répertoriés dans le menu « Ajouter un bloc ».';
