<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'badges', language 'ar', version '4.3'.
 *
 * @package     badges
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actions'] = 'الإجراءات';
$string['activate'] = 'تمكين الوصول';
$string['activatesuccess'] = 'تم تمكين الوصول إلى الشارات بنجاح.';
$string['addalignment'] = 'إضافة مهارة أو معيار خارجي';
$string['addbadge'] = 'إضافة الشارات';
$string['addbadge_help'] = 'حدد جميع الشارات التي يجب إضافتها إلى متطلبات الشارة. اضغط المفتاح CTRL لتحديد عناصر متعددة.';
$string['addbadgecriteria'] = 'أضف معايير الشارة';
$string['addcohort'] = 'إضافة جماعة';
$string['addcohort_help'] = 'حدد جميع المجموعات التي يجب إضافتها إلى متطلبات هذه الشارة. اضغط المفتاح CTRL لتحديد عناصر متعددة.';
$string['addcompetency'] = 'إضافة الكفاءة';
$string['addcompetency_help'] = 'حدد جميع الكفاءات التي يجب إضافتها إلى متطلبات الشارة. اضغط المفتاح CTRL لتحديد عناصر متعددة.';
$string['addcourse'] = 'إضافة مواد';
$string['addcourse_help'] = 'إختر كل المقررات الدراسية التي تنبغي إضافتها إلى متطلبات الشارة. اضغط المفتاح CTRL باستمرار لتحديد عناصر متعددة.';
$string['addcriteria'] = 'إضافة المعايير';
$string['addcriteriatext'] = 'لبدء إضافة معايير ، يرجى تحديد أحد الخيارات من القائمة المنسدلة.';
$string['addedtobackpack'] = 'وأضاف شارة على ظهره';
$string['addrelated'] = 'إضافة شارة ذات الصلة';
$string['addtobackpack'] = 'إضافة إلى ظهره';
$string['adminonly'] = 'هذه الصفحة مقصورة على مسؤولي الموقع فقط.';
$string['after'] = 'بعد تاريخ الاصدار.';
$string['aggregationmethod'] = 'طريقة الإجمال';
$string['alignment'] = 'التوافق';
$string['all'] = 'الجميع';
$string['allmethod'] = 'استيفاء جميع الشروط المحددة';
$string['allmethodactivity'] = 'جميع الأنشطة المحددة كاملة';
$string['allmethodbadges'] = 'تم الحصول على جميع الشارات المختارة';
$string['allmethodcohort'] = 'العضوية في جميع الجماعات المختارة';
$string['allmethodcompetencies'] = 'تم الانتهاء من جميع الكفاءات المختارة';
$string['allmethodcourseset'] = 'كل المقررات الدراسية المحددة مكتملة';
$string['allmethodmanual'] = 'جميع الأدوار المحددة تمنح الشارة';
$string['allmethodprofile'] = 'تم إكمال جميع حقول ملف التعريف المحدد';
$string['allowcoursebadges'] = 'تمكين شارات المقررات الدراسية';
$string['allowcoursebadges_desc'] = 'السماح بإنشاء الشارات ومنحها على مستوى المقررات الدراسية.';
$string['allowexternalbackpack'] = 'الاتصال بحقيبة ظهر خارجية';
$string['allowexternalbackpack_desc'] = 'عند التمكين، سيتاح للمستخدمين الاتصال بحقيبة ظهر خارجية ومشاركة الشارات الخاصة بهم من هذا الموقع. يمكن للمستخدمين أيضاً إختيار عرض أي مجموعات للشارات العامة من حقائبهم تلك في صفحة ملفهم الشخصي لهذا الموقع. يوصى بترك هذا الخيار معطلاً إذا كان موقعك غير منشور على الإنترنت.';
$string['any'] = 'أيّ';
$string['anymethod'] = 'استيفاء أي من الشروط المحددة';
$string['anymethodactivity'] = 'أي من الأنشطة المحددة كاملة';
$string['anymethodbadges'] = 'أي من الشارات المحددة تم الحصول عليها';
$string['anymethodcohort'] = 'العضوية في أي من الجماعات  المختارة';
$string['anymethodcompetencies'] = 'أي من الكفاءات المختارة تم الانتهاء منها';
$string['anymethodcourseset'] = 'أي من المقررات الدراسية المحددة مكتملة';
$string['anymethodmanual'] = 'أي من الأدوار المحددة تمنح الجوائز';
$string['anymethodprofile'] = 'أي من حقول ملف التعريف المحدد تم إكمالها';
$string['apiversion'] = 'نسخة واجهة برمجة التطبيق معتمدة';
$string['archivebadge'] = 'هل ترغب في حذف الشارة \'{$a}\' ، ولكن مع الاحتفاظ بالشارات المصدرة الحالية؟';
$string['archiveconfirm'] = 'الحذف والاحتفاظ بالشارات الصادرة الحالية';
$string['archivehelp'] = '<p>يعني هذا الخيار أنه سيتم وضع علامة على الشارة على أنها "معزولة" ولن تظهر بعد الآن في قائمة الشارات. لن يتمكن المستخدمون بعد الآن من اكتساب هذه الشارة، ولكن لا يزال بإمكان مستلمي الشارة الحاليين عرضها في صفحة ملفهم الشخصي ودفعها إلى حقائب الظهر الخارجية.</p>
<p>إذا أردت لمستخدميك الاحتفاظ بحق الوصول إلى الشارات التي اكتسبوها، من المهم تحديد هذا الخيار بدلاً من حذف الشارات بشكل كامل</p>';
$string['attachment'] = 'إرفاق الشارة بالرسالة';
$string['attachment_help'] = 'في حالة التمكين ، سيتم إرفاق شارة صادرة إلى البريد الإلكتروني للمستلم لتنزيلها. (يجب تمكين المرفقات في تكوين إدارة الموقع / الخادم / البريد الإلكتروني / البريد الصادر لاستخدام هذا الخيار.)';
$string['award'] = 'إمنح الشارة';
$string['awardedto'] = 'الممنوحة إلى {$a}';
$string['awardedtoyou'] = 'صدر لي';
$string['awardoncron'] = 'تم تمكين الوصول إلى الشارات بنجاح. يمكن للعديد من المستخدمين كسب هذه الشارة على الفور. لضمان أداء الموقع ، سيستغرق هذا الإجراء بعض الوقت للمعالجة.';
$string['awards'] = 'المستفيدين';
$string['backpackapiurl'] = 'طهر بظهر API URL';
$string['backpackavailability'] = 'التحقق من الشارة خارجياً';
$string['backpackavailability_help'] = 'لكي يتمكن مستلمو الشارات من إثبات حصولهم على شاراتهم منك، ينبغي تمكين خدمة حقيبة الظهر الخارجية من الوصول إلى موقعك والتحقق من الشارات الصادرة منه. لا يبدو أن موقعك متاح حالياً، مما يعني عدم إمكانية التحقق من الشارات التي أصدرتها بالفعل أو التي ستصدرها مستقبلاً.

**لماذا أرى هذه الرسالة؟**

قد يكون جدار الحماية الخاص بك هو ما يمنع وصول المستخدمين من خارج شبكتك، أو أن موقعك محمي بكلمة مرور، أو أنك تقوم بتشغيل الموقع على جهاز حاسوب غير متاح من الإنترنت (مثل آلة التطوير المحلية).

**هل هذه مشكلة؟**

يجب إصلاح هذه المشكلة في أي موقع إنتاجي تخطط فيه لإصدار الشارات، وإلا فلن يتمكن المستلمون من إثبات حصولهم على شاراتهم منك. إذا لم يكن موقعك معلناً بعد، فيمكنك إنشاء شارات اختبارية وإصدارها، طالما أن الموقع يمكن الوصول إليه قبل إطلاقه للعامة.

**ماذا لو لم أتمكن من جعل موقعي بالكامل متاحاً للجميع؟**

عنوان الرابط الوحيد المطلوب للتحقق هو [your-site-url]/badges/assertion.php ، لذا فإن تمكنتَ من تعديل جدار الحماية الخاص بك للسماح بالوصول الخارجي إلى هذا الملف، سيصير التحقق من الشارة شغالاً.';
$string['backpackbadgessettings'] = 'تغيير إعدادات حقيبة الظهر';
$string['backpackbadgessummary'] = 'لديك {$a-> total badges} badges) التي يتم عرضها من
{{$a> totalcollectionions} Collections$).';
$string['backpackcannotsendverification'] = 'لا يمكن إرسال بريد إلكتروني للتحقق';
$string['backpackconnected'] = 'تم الاتصال بحقيبة الظهر';
$string['backpackconnection'] = 'الاتصال بحقيبة الظهر';
$string['backpackconnection_connected'] = 'حقيبتك';
$string['backpackconnection_help'] = 'حفظ شاراتك ومشاركتها مع الآخرين لهذا الموقع، كذلك عرض شاراتك العامة من المواقع الأخرى في صفحة ملفك الشخصي.';
$string['backpackconnectioncancelattempt'] = 'الاتصال باستخدام عنوان بريد إلكتروني مختلف';
$string['backpackconnectionconnect'] = 'الاتصال بحقيبة الظهر';
$string['backpackconnectionnottested'] = 'يتعذر فحص الاتصال بحقيبة الظهر هذه لأن حقائب الظهر ذات الإصدار 2.0 للشارات المفتوحة تدعم عمليات فحص الاتصال فقط.';
$string['backpackconnectionok'] = 'تم تأسيس الاتصال بحقيبة الظهر بنجاح';
$string['backpackconnectionresendemail'] = 'إعادة ارسال بريد التحقق';
$string['backpackconnectionunexpectedmessage'] = 'حقيبة الظهر أرجعت الخطأ: "{$a}".';
$string['backpackconnectionunexpectedresult'] = 'هناك مشكلة عند الاتصال بحقيبة الظهر العائدة لك. مزود حقيبة الظهر أعاد الرسالة الآتية: \'{$a}\'.';
$string['backpackdetails'] = 'إعدادات حقيبة الظهر';
$string['backpackdisconnected'] = 'الاتصال مقطوع مع حقيبة الظهر';
$string['backpackemail'] = 'عنوان البريد الإلكتروني';
$string['backpackemail_help'] = 'عنوان البريد الإلكتروني المرتبط بحقيبة الظهر العائدة لك. خلال الاتصال، سيتم ربط أيّ شارات تحصل عليها في هذا الموقع بعنوان البريد الإلكتروني هذا.';
$string['backpackemail_required'] = 'عنوان البريد الالكتروني لا يمكن أن يكون فارغًا';
$string['backpackemailverificationpending'] = 'التحقق معلّق';
$string['backpackemailverifyemailbody'] = 'مرحباً {$a->userfirstname}،

أنت على وشك الاتصال مع حقيبة الشارات الخاصة بك في \'{$a->sitename}\'.

لإكمال الاتصال بحقيبة الظهر تلك، يرجى تأكيد عنوان بريدك عبر الزر الآتي:

{$a->buttonlink}

إذا لم يعمل الزر عندك، يمكنك نسخ الرابط الآتي ولصقه في متصفح الويب عندك:
{$a->link}

إذا لم تكن من حاول الاتصال بحقيبة الشارات، فبإمكانك تجاهل هذه الرسالة بآمان.


لأي مساعدة إضافية، يرجى التواصل مع الدعم الفني لموقعك،

{$a->admin}';
$string['backpackemailverifyemailsubject'] = '{$a}: التحقق من حقيبة ظهر الشارات عبر البريد الالكتروني';
$string['backpackemailverifypending'] = 'لقد أرسلنا رسالة بريد الكتروني إلى <strong>{$a}</strong>. أنقر على رابط التحقق فيها لتفعيل اتصالك بحقيبة الظهر.';
$string['backpackemailverifysuccess'] = 'أنت الآن متصل بحقيبة الظهر.';
$string['backpackemailverifytokenmismatch'] = 'لا يتطابق الرمز المميز في الارتباط الذي قمت بالنقر فوقه مع الرمز المميز المخزن. تأكد من النقر فوق الرابط في أحدث رسالة بريد إلكتروني تلقيتها.';
$string['backpackexporterror'] = 'تعذر تصدير الشارة إلى حقيبة الظهر';
$string['backpackexporterrorwithinfo'] = 'يتعذر تصدير الشارة "{$a->badgename}" إلى حقيبة الظهر. الخطأ: {$a->error}';
$string['backpackimport'] = 'إعدادات استيراد الشارات';
$string['backpackimport_help'] = 'بعد إنشاء اتصال ناجح بحقيبة الظهر، يمكن عرض شارات حقيبتك تلك على صفحة الشارات وصفحة ملفك الشخصي.

في هذه المنطقة، يمكنك تحديد مجموعات الشارات من حقيبة الظهر الخاصة بك والتي ترغب بعرضها في ملفك الشخصي.';
$string['backpackprovider'] = 'مزود حقيبة الظهر';
$string['backpacksettings'] = 'إعدادات حقيبة الظهر';
$string['backpackweburl'] = 'رابط حقيبة الظهر';
$string['badgedetails'] = 'تفاصيل الشارة';
$string['badgeimage'] = 'الصورة';
$string['badgeimage_help'] = 'الصورة ينبغي أن تكون بحجم 300 × 300 بكسل على الأقل. سيتم عرضها بحجم 300 × 300 بكسل في صفحة الشارة، وبحجم 100 × 100 بكسل في صفحة الملف الشخصي للمستخدم.';
$string['badgeissued'] = 'الشارة أُصدرت';
$string['badgeprivacysetting'] = 'إعدادات الخصوصية للشارة';
$string['badgeprivacysetting_help'] = 'يمكن عرض الشارات التي تكتسبها على صفحة الملف الشخصي لحسابك. يتيح لك هذا الإعداد ضبط رؤية الشارات المكتسبة حديثاً تلقائياً.

لا يزال بإمكانك التحكم في إعدادات خصوصية الشارة الفردية في صفحة الشارات الخاصة بك.';
$string['badgeprivacysetting_str'] = 'عرض الشارات التي أكسبها على صفحة ملفي الشخصي تلقائياً';
$string['badges'] = 'الشارات';
$string['badgesalt'] = 'الشفرة الفريدة لترميز عنوان البريد الالكتروني للمستلم';
$string['badgesalt_desc'] = 'يتيح استعمال الترميز الرقمي الفريد لخدمات حقائب الظهر تأكيد هوية حامل الشارة دون الحاجة إلى كشف عنوان بريده الالكتروني. هذا الإعداد ينبغي أن يتضمن الأرقام والحروف فقط.

ملاحظة: لأغراض التحقق من المستلم، يرجى تجنب تغيير هذا الإعداد بمجرد الشروع بإصدار الشارات.';
$string['badgesdisabled'] = 'لم يتم تمكين الشارات على هذا الموقع.';
$string['badgesearned'] = 'عدد الشارات المكتسبة: {$a}';
$string['badgesettings'] = 'إعدادات الشارات';
$string['badgestatus_0'] = 'غير متاح';
$string['badgestatus_1'] = 'متاح';
$string['badgestatus_2'] = 'غير متاح (المعيار مؤَّمن)';
$string['badgestatus_3'] = 'متاح (المعيار مؤَّمن)';
$string['badgestatus_4'] = 'أرشفة';
$string['badgestoearn'] = 'عدد الشارات المتاحة: {$a}';
$string['badgesview'] = 'شارات المقرر';
$string['badgetags'] = 'وسوم الشارة';
$string['badgeurl'] = 'تم إصدار رابط الشارة';
$string['balignment'] = 'التوافقات ({$a})';
$string['bawards'] = 'المستلمون ({$a})';
$string['bcriteria'] = 'المعايير';
$string['bdetails'] = 'حرر التفاصيل';
$string['bendorsement'] = 'المصادقة';
$string['bmessage'] = 'الرسالة';
$string['boverview'] = 'نظرة عامة';
$string['brelated'] = 'شارات ذات صلة ({$a})';
$string['bydate'] = 'أكمل بواسطة';
$string['claim'] = 'يطالب';
$string['claimcomment'] = 'تأييد التعليق';
$string['claimid'] = 'رابط المطالبة';
$string['clearsettings'] = 'مسح الإعدادات';
$string['completioninfo'] = 'تم إصدار هذه الشارة لاستكمالها:';
$string['completionnotenabled'] = 'لم يتم تمكين الإكمال لهذا المقرر الدراسي، لذلك لا يمكن تضمينه في معايير الشارة. يمكن تمكين إكمال المقرر في إعداداته.';
$string['configenablebadges'] = 'عند التمكين، تتيح لك هذه الميزة إنشاء الشارات ومنحها لمستخدمي الموقع.';
$string['configuremessage'] = 'رسالة الشارة';
$string['connect'] = 'اتصال';
$string['connected'] = 'متصل';
$string['connecting'] = 'يتصل ...';
$string['contact'] = 'تواصل';
$string['contact_help'] = 'عنوان بريد إلكتروني مرتبط بمصدر الشارة.';
$string['copy'] = 'نسخ';
$string['copyof'] = 'نسخة من {$a}';
$string['course'] = 'المقرر: {$a}';
$string['coursebadges'] = 'الشارات';
$string['coursebadgesdisabled'] = 'لا يتم تمكين شارات المادة على هذا الموقع.';
$string['coursebadgetitle'] = 'شارة المقرر {$a}';
$string['coursecompletion'] = 'يجب على المستخدمين إكمال هذه المادة.';
$string['create'] = 'شارة جديدة';
$string['createbutton'] = 'إنشاء شارة';
$string['creatorbody'] = '<p>{$a->user} قد أكمل كل متطلبات الشارة وتم منحه إياها. عاين الشارة الممنوحة في {$a->link}</p>';
$string['creatorsubject'] = '\'{$a}\' تم منحها!';
$string['criteria_0'] = 'يتم منح هذه الشارة عندما ...';
$string['criteria_1'] = 'اكتمال النشاط';
$string['criteria_1_help'] = 'يسمح بإعطاء شارة للمستخدمين بناءً على إكمال مجموعة من الأنشطة داخل المادة.';
$string['criteria_2'] = 'إصدار يدوي حسب الدور';
$string['criteria_2_help'] = 'يسمح بمنح الشارة يدوياً من قبل المستخدمين الذين لديهم دور معين ضمن الموقع أو المقرر.';
$string['criteria_3'] = 'المشاركة الاجتماعية';
$string['criteria_3_help'] = 'اجتماعي';
$string['criteria_4'] = 'إكمال المادة';
$string['criteria_4_help'] = 'يسمح بمنح شارة للمستخدمين الذين أكملوا المقرر. يمكن أن يكون لهذا المعيار عوامل إضافية مثل الحد الأدنى للتقدير وتاريخ إكمال المقرر.';
$string['criteria_5'] = 'إكمال مجموعة من المقررات الدراسية';
$string['criteria_5_help'] = 'يسمح بمنح شارة للمستخدمين الذين أكملوا مجموعة من المقررات الدراسية. يمكن أن يشتمل كل مقرر على معايير إضافية، مثل الحد الأدنى للعلامة وتاريخ إكمال المقرر.';
$string['criteria_6'] = 'اكتمال الملف الشخصي';
$string['criteria_6_help'] = 'يسمح بإعطاء شارة للمستخدمين لإكمالهم حقول معينة في ملفهم الشخصي. يمكنك الاختيار من حقول الملف الشخصي الافتراضية والمخصصة المتاحة للمستخدمين.';
$string['criteria_7'] = 'الشارات الممنوحة سابقاً';
$string['criteria_7_help'] = 'يسمح بمنح الشارة إلى المستخدمين على أساس الشارات الأخرى التي حصلوا عليها.';
$string['criteria_8'] = 'عضوية الدفعات';
$string['criteria_8_help'] = 'يسمح بإعطاء شارة للمستخدمين على أساس عضويتهم في دفعة.';
$string['criteria_9'] = 'الكفاءات';
$string['criteria_9_help'] = 'يسمح بإعطاء شارة للمستخدمين على أساس الكفاءات التي أكملوها.';
$string['criteria_descr'] = 'يمنح المستخدمون هذه الشارة عند إكمالهم للمتطلبات التالية:';
$string['criteria_descr_0'] = 'إكمال <strong>{$a}</strong> المتطلبات المدرجة.';
$string['criteria_descr_1'] = '{$a} من الأنشطة التالية مكتملة:';
$string['criteria_descr_2'] = 'يجب منح المستخدمين هذه الشارة من خلال {$a} من الأدوار التالية:';
$string['criteria_descr_4'] = 'يجب على المستخدمين إكمال المادة';
$string['criteria_descr_5'] = '<strong>{$a}</strong> من المساقات التالية يجب إكمالها:';
$string['criteria_descr_6'] = '{$a} من حقول ملف تعريف المستخدم التالية يجب أن تكتمل:';
$string['criteria_descr_7'] = 'يجب الحصول على {$a} من الشارات التالية:';
$string['criteria_descr_8'] = 'يتطلوب العضوية في <strong>{$a}</strong> من الدفعات الآتية:';
$string['criteria_descr_9'] = '{$a} من الكفاءات التالية يجب أن تكتمل:';
$string['criteria_descr_bydate'] = 'بواسطة  {$a}';
$string['criteria_descr_grade'] = 'مع الحد الأدنى من الدرجة {$a}';
$string['criteria_descr_short0'] = 'أكمل {$a} من:';
$string['criteria_descr_short1'] = 'أكمل {$a} من:';
$string['criteria_descr_short2'] = 'مُنحت من {$a} من:';
$string['criteria_descr_short4'] = 'أكمل المساق';
$string['criteria_descr_short5'] = 'أكمل {$a} من:';
$string['criteria_descr_short6'] = 'أكمل {$a} من:';
$string['criteria_descr_short7'] = 'أكمل {$a} من:';
$string['criteria_descr_short8'] = 'عضوية الدفعة في <strong>{$a}</strong> من:';
$string['criteria_descr_short9'] = 'أكمل {$a} من:';
$string['criteria_descr_single_1'] = 'يجب إكمال النشاط التالي:';
$string['criteria_descr_single_2'] = 'يجب منح هذه الشارة من قِبل مستخدم له الدور التالي:';
$string['criteria_descr_single_4'] = 'ينبغي على المستخدمين إكمال المساق';
$string['criteria_descr_single_5'] = 'ينبغي إكمال المساق التالي:';
$string['criteria_descr_single_6'] = 'يجب إكمال حقل ملف تعريف المستخدم التالي:';
$string['criteria_descr_single_7'] = 'يجب الحصول على الشارة التالية:';
$string['criteria_descr_single_8'] = 'يتطلب العضوية في الدفعة الآتية:';
$string['criteria_descr_single_9'] = 'يجب الانتهاء من الكفاءات التالية:';
$string['criteria_descr_single_short1'] = 'اكتمال:';
$string['criteria_descr_single_short2'] = 'تمنح من قبل:';
$string['criteria_descr_single_short4'] = 'أكمل المادة';
$string['criteria_descr_single_short5'] = 'اكتمال:';
$string['criteria_descr_single_short6'] = 'اكتمال:';
$string['criteria_descr_single_short7'] = 'اكتمال:';
$string['criteria_descr_single_short8'] = 'العضوية في:';
$string['criteria_descr_single_short9'] = 'اكتمال:';
$string['criteriacreated'] = 'معايير الشارة تم وضعها  بنجاح';
$string['criteriadeleted'] = 'معايير الشارة تم حذفها بنجاح';
$string['criteriasummary'] = 'ملخص المعايير';
$string['criteriaupdated'] = 'معايير الشارة تم تحديثها بنجاح';
$string['criterror'] = 'معايير المعلّمات الحالية';
$string['criterror_help'] = 'تعرض مجموعة الحقول هذه جميع العوامل التي تمت إضافتها مبدئيًا إلى متطلبات هذه الشارة ولكنها لم تعد متاحة. يوصى بإلغاء تحديد هذه العوامل للتأكد من أن المستخدمين يمكنهم اكتساب هذه الشارة مستقبلاً.';
$string['currentimage'] = 'الصورة الحالية';
$string['currentstatus'] = 'الحالة الحالية:';
$string['dateawarded'] = 'تاريخ الإصدار';
$string['dateearned'] = 'التاريخ: {$a}';
$string['day'] = 'يوم/أيام';
$string['deactivate'] = 'تعطيل الوصول';
$string['deactivatesuccess'] = 'تم تعطيل الوصول إلى الشارات بنجاح.';
$string['defaultissuercontact'] = 'عنوان البريد الإلكتروني لمُصدر الشارة';
$string['defaultissuercontact_desc'] = 'عنوان بريد الكتروني مرتبط بمصدر الشارة. بالنسبة إلى حقيبة الظهر المفتوحة Badges v2.0، هذا يستعمل للمصادقة عند نشر الشارات في حقيبة الظهر.';
$string['defaultissuername'] = 'اسم جهة إصدار الشارة';
$string['defaultissuername_desc'] = 'اسم الوكيل أو الجهة المصدرة.';
$string['defaultissuerpassword'] = 'كلمة مرور إصدار الشارة';
$string['defaultissuerpassword_help'] = 'يتطلب الأمر وجود حساب في موقع حقيبة الظهر مع عنوان بريد الكتروني كما هو محدد في إعداد عنوان البريد الإلكتروني لمصدر الشارة ضمن إدارة الموقع / الشارات / إعدادات الشارات. ينبغي إدخال كلمة مرور الحساب هنا.';
$string['delbadge'] = 'هل ترغب في حذف الشارة \'{$a}\' وإزالة جميع الشارات الصادرة؟';
$string['delconfirm'] = 'حذف وإزالة الشارات الصادرة الحالية';
$string['delcritconfirm'] = 'هل أنت متأكد أنك تريد حذف هذا المعيار؟';
$string['deletehelp'] = '<p>إن حذف الشارة بالكامل يعني أن جميع سجلات المعلومات والمعايير الخاصة بها ستتم إزالتها نهائياً. لن يتمكن المستخدمون الذين حصلوا على هذه الشارة من الوصول إليها وعرضها على صفحات ملفاتهم الشخصية.</p>
<p>ملاحظة: المستخدمون الذين اكتسبوا هذه الشارة وسبق لهم نشرها في حقيبة الظهر الخارجية الخاصة بهم، سيظلون محتفظين بها في حقيبة الظهر الخارجية الخاصة بهم. مع ذلك، لن يتمكنوا من الوصول إلى المعايير وصفحات الأدلة ذات الصلة بها والعائدة لهذا الموقع.</p>';
$string['delexternalbackpack'] = 'حذف موقع حقيبة الظهر';
$string['delexternalbackpackconfirm'] = 'هل تريد حذف موقع حقيبة الظهر \'{$a}\'؟';
$string['delparamconfirm'] = 'هل أنت متأكد أنك تريد حذف هذا المعامل؟';
$string['description'] = 'الوصف';
$string['disconnect'] = 'القطع';
$string['donotaward'] = 'حاليًا، هذه الشارة غير نشطة، لذلك لا يمكن منحها للمستخدمين. إذا كنت ترغب في منح هذه الشارة، فيرجى ضبط حالتها إلى نشطة.';
$string['enablebadges'] = 'تمكين الشارات';
$string['endorsement'] = 'المصادقة';
$string['error:backpackdatainvalid'] = 'البيانات الراجعة من حقيبة الظهر غير صالحة.';
$string['error:backpackemailnotfound'] = 'البريد الإلكتروني \'{$a}\' غير مرتبط بحقيبة ظهر. تحتاج إلى <a href="http://backpack.openbadges.org">إنشاء حقيبة ظهر</a> لهذا الحساب أو تسجيل الدخول مستعملاً عنوان بريد إلكتروني آخر.';
$string['error:badgeawardnotfound'] = 'لا يمكن التحقق من هذه الشارة الممنوحة. ربما تم إلغاء هذه الشارة.';
$string['error:badgenotfound'] = 'شارة غير موجودة';
$string['error:cannotact'] = 'لا يمكن تفعيل الشارة.';
$string['error:cannotawardbadge'] = 'لا يمكن منح شارة للمستخدم.';
$string['error:cannotdeletecriterion'] = 'لا يمكن حذف هذا المعيار.';
$string['error:cannotrevokebadge'] = 'لا يمكن إبطال شارة من مستخدم.';
$string['error:clone'] = 'لا يمكن استنساخ الشارة.';
$string['error:connectionunknownreason'] = 'كان الاتصال غير ناجح ولكن لم يتم تقديم سبب.';
$string['error:duplicatename'] = 'شارة بهذا الاسم موجودة بالفعل في النظام.';
$string['error:externalbadgedoesntexist'] = 'شارة غير موجود';
$string['error:guestuseraccess'] = 'أنت تستخدم حاليًا وصول الضيف. لرؤية الشارات ، تحتاج إلى تسجيل الدخول باستخدام حساب المستخدم الخاص بك.';
$string['error:invalidcriteriatype'] = 'نوع المعايير غير صالح.';
$string['error:invalidexpiredate'] = 'يجب أن يكون تاريخ انتهاء الصلاحية في المستقبل.';
$string['error:invalidexpireperiod'] = 'لا يمكن أن تكون فترة انتهاء الصلاحية سالبة أو مساوية 0.';
$string['error:invalidparambadge'] = 'شارة غير موجودة.';
$string['error:invalidparamcohort'] = 'الدفعة غير موجودة.';
$string['error:noactivities'] = 'لا توجد نشاطات فيها تمكين لمعايير الإكمال في هذا المساق.';
$string['error:nobadges'] = 'حالياً، لا توجد شارات متاحة للحصول عليها لتُضاف كمعايير. شارة الموقع يمكن أن تكون الشارات الأخرى على مستوى الموقع فقط بمثابة معايير لها. شارة المقرر يمكن أن تكون الشارات الأخرى على مستوى المقرر أو الموقع بمثابة معايير لها.';
$string['error:nocohorts'] = 'بدون دفعات';
$string['error:nocourses'] = 'لم يتم تمكين إكمال المادة لأي من المقررات الدراسية في هذا الموقع ، لذلك لا يمكن عرض أي منها. قد يتم تمكين إكمال المادة في إعدادات المقرر.';
$string['error:nogroupslink'] = '<p>يتم عرض المجموعات العامة فقط. <a href="{$a}" target="_blank" rel="nofollow">قم بزيارة حقيبة الظهر العائدة لك</a> لإنشاء بعض المجموعات العامة.</p>.';
$string['error:nogroupssummary'] = '<p>لا توجد مجموعات عامة من الشارات في حقيبة الظهر العائدة لك.</p>';
$string['error:nopermissiontoview'] = 'ليست لديك صلاحية معاينة مستلمي الشارة';
$string['error:nosuchbadge'] = 'الشارة بالكود {$a} غير موجودة.';
$string['error:nosuchcohort'] = 'تحذير: هذه المجموعة لم تعد متوفرة.';
$string['error:nosuchcourse'] = 'تحذير: هذه المادة لم تعد متوفرة.';
$string['error:nosuchfield'] = 'تحذير: لم يعد حقل ملف تعريف المستخدم هذا متاحًا.';
$string['error:nosuchmod'] = 'تحذير: هذا النشاط لم يعد متوفرًا.';
$string['error:nosuchrole'] = 'تحذير: هذا الدور لم يعد متوفرًا.';
$string['error:nosuchuser'] = 'لا يمتلك المستخدم الذي يحمل عنوان البريد الإلكتروني هذا حسابًا لدى مزود حقيبة الظهر الحالي.';
$string['error:notifycoursedate'] = 'تحذير: لن يتم إصدار الشارات المرتبطة بإكمال  المادة والنشاط حتى تاريخ بدء المادة.';
$string['error:parameter'] = 'تحذير: يجب تحديد معلمة واحدة على الأقل لضمان سير العمل الصحيح لإصدار الشارة.';
$string['error:relatedbadgedoesntexist'] = 'لا توجد شارة عامة بهذا المعرف';
$string['error:requesterror'] = 'فشل طلب الاتصال (رمز الخطأ {$a}).';
$string['error:requesttimeout'] = 'لا يمكن حفظ الشارة.';
$string['error:save'] = 'لا يمكن حفظ الشارة.';
$string['error:userdeleted'] = '{$a->user} (لم يعد هذا المستخدم موجودًا في {$a->site})';
$string['eventbadgearchived'] = 'شارة تمت أرشفتها';
$string['eventbadgeawarded'] = 'شارة تم منحها';
$string['eventbadgecreated'] = 'شارة تم إنشاؤها';
$string['eventbadgecriteriacreated'] = 'معايير شارة تم إنشاؤها';
$string['eventbadgecriteriadeleted'] = 'معايير شارة تم حذفها';
$string['eventbadgecriteriaupdated'] = 'معايير شارة تم تحديثها';
$string['eventbadgedeleted'] = 'شارة تم حذفها';
$string['eventbadgedisabled'] = 'شارة تم تعطيلها';
$string['eventbadgeduplicated'] = 'شارة تم تكرارها';
$string['eventbadgeenabled'] = 'شارة تم تمكينها';
$string['eventbadgelistingviewed'] = 'قائمة شارة تمت معاينتها';
$string['eventbadgerevoked'] = 'شارة تم سحبها';
$string['eventbadgeupdated'] = 'شارة تم تحديثها';
$string['eventbadgeviewed'] = 'شارة تمت معاينتها';
$string['evidence'] = 'دليل';
$string['existingrecipients'] = 'مستلمو الشارة الحاليون';
$string['existsinbackpack'] = 'الشارة موجودة بالفعل في حقيبة الظهر';
$string['expired'] = 'منتهية الصلاحية';
$string['expiredate'] = 'تنتهي هذه الشارة في {$a}.';
$string['expireddate'] = 'انتهت هذه الشارة في {$a}.';
$string['expiredin'] = 'انتهت صلاحيتها في {$a}';
$string['expireperiod'] = 'تنتهي هذه الشارة {$a} يوم (أيام) بعد إصدارها.';
$string['expireperiodh'] = 'تنتهي هذه الشارة {$a} ساعة (ساعات) بعد إصدارها.';
$string['expireperiodm'] = 'تنتهي هذه الشارة {$a} دقيقة (دقائق) بعد إصدارها.';
$string['expireperiods'] = 'تنتهي هذه الشارة {$a} ثانية (ثوان) بعد إصدارها.';
$string['expiresin'] = 'تنتهي صلاحيتها في {$a}';
$string['expirydate'] = 'تاريخ الانتهاء';
$string['expirydate_help'] = 'اختياريا ، يمكن أن تنتهي صلاحية الشارات في تاريخ محدد ، أو يمكن حساب التاريخ بناءً على تاريخ إصدار الشارة للمستخدم.';
$string['externalbackpack_required'] = 'مزود حقيبة الظهر لا يمكن تركه فارغًا';
$string['externalbadges'] = 'شاراتي من مواقع الويب الأخرى';
$string['externalbadges_help'] = 'تعرض هذه المنطقة شاراتك من حقيبة الظهر الخارجية.';
$string['externalbadgesp'] = 'شارات من مواقع الويب الأخرى:';
$string['externalconnectto'] = 'لعرض الشارات الخارجية، تحتاج إلى <a href="{$a}">الاتصال بحقيبة ظهر</a>.';
$string['fixed'] = 'تاريخ ثابت';
$string['hidden'] = 'مخفي';
$string['hiddenbadge'] = 'لسوء الحظ ، لم يجعل مالك الشارة هذه المعلومات متاحة.';
$string['hostedurl'] = 'عنوان الرابط الخارجي';
$string['hostedurldescription'] = 'عنوان الرابط الخارجي حيث تتم استضافة الشارة';
$string['imageauthoremail'] = 'البريد الإلكتروني لمؤلف الصورة';
$string['imageauthoremail_help'] = 'إذا تم تحديد ذلك ، فسيتم عرض عنوان البريد الإلكتروني لمؤلف صورة الشارة على صفحة الشارة.';
$string['imageauthorname'] = 'اسم مؤلف الصورة';
$string['imageauthorname_help'] = 'إذا تم تحديد ذلك ، فسيتم عرض اسم مؤلف صورة الشارة على صفحة الشارة.';
$string['imageauthorurl'] = 'عنوان رابط مؤلف الصورة';
$string['imageauthorurl_help'] = 'إذا تم تحديد ذلك، فسيتم عرض رابط لموقع مؤلف صورة الشارة على صفحة الشارة. يجب أن يحتوي عنوان الرابط على البادئة http:// أو https://.';
$string['imagecaption'] = 'تعليق على الصورة';
$string['imagecaption_help'] = 'في حالة تحديد ذلك ، يتم عرض تعليق توضيحي للصورة على صفحة الشارة.';
$string['includeauthdetails'] = 'تضمين تفاصيل المصادقة مع حقيبة الظهر';
$string['invalidurl'] = 'URL غير صالح';
$string['issuancedetails'] = 'إنتهاء صلاحية الشارة';
$string['issuedbadge'] = 'معلومات الشارة الصادرة';
$string['issuedby'] = 'المُصدَّرة من قبل {$a}';
$string['issuedon'] = 'المُصدَّرة في {$a}';
$string['issuerdetails'] = 'تفاصيل المصدر';
$string['issueremail'] = 'البريد الإلكتروني';
$string['issueremail_help'] = 'عنوان بريد إلكتروني للاتصال بالمنظمة التي تصدر التصديق.';
$string['issuername'] = 'اسم المصدر';
$string['issuername_endorsement'] = 'اسم المصادق';
$string['issuername_endorsement_help'] = 'اسم المؤيد.';
$string['issuername_help'] = 'اسم الوكيل أو الجهة المصدرة.';
$string['issuerurl'] = 'عنوان URL الخاص بالمصدر';
$string['issuerurl_help'] = 'موقع المنظمة التي تصدر التصديق. يجب أن يحتوي عنوان الرابط على البادئة http:// أو https://.';
$string['language'] = 'اللغة';
$string['language_help'] = 'اللغة المستخدمة في صفحة الشارة.';
$string['listbackpacks'] = 'قائمة حقائب الظهر';
$string['localbadges'] = 'شاراتي من موقع الويب {$a}';
$string['localbadgesh'] = 'شاراتي من هذا الموقع';
$string['localbadgesh_help'] = 'جميع الشارات المكتسبة في هذا الموقع عن طريق استكمال المقررات الدراسية وأنشطتها وغيرها من المتطلبات.

يمكنك إدارة الشارات الخاصة بك هنا بجعلها عامة أو خاصة لصفحة ملفك الشخصي.

يمكنك تنزيل كل الشارات الخاصة بك أو كل شارة على حدة وحفظها على جهاز الحاسوب الخاص بك. يمكن إضافة الشارات التي تم تنزيلها إلى خدمة حقيبة الظهر الخارجية العائدة لك.';
$string['localbadgesp'] = 'شارات من {$a}:';
$string['localconnectto'] = 'لمشاركة هذه الشارات خارج موقع الويب هذا، تحتاج إلى <a href="{$a}">الاتصال بحقيبة ظهر</a>.';
$string['loginbackpacktitle'] = '<strong>سجل دخولك إلى حقيبتك</strong>';
$string['makeprivate'] = 'اجعلها شخصية';
$string['makepublic'] = 'اجعلها عامة';
$string['managebackpacks'] = 'إدارة حقائب الظهر';
$string['managebadges'] = 'إدارة الشارات';
$string['message'] = 'نص الرسالة';
$string['messagebody'] = '<p>لقد تم منحك شارة "٪badgename٪"!</p>
<p>يمكن معرفة المزيد من المعلومات عن هذه الشارة من صفحة معلومات الشارة ٪badgelink٪.</p>
<p>يمكنك إدارة الشارة وتنزيلها من صفحة {$a}.</p>';
$string['messagesubject'] = 'تهانينا! لقد ربحت شارة!';
$string['method'] = 'يكتمل هذا المعيار عندما...';
$string['mingrade'] = 'أدنى علامة مطلوبة';
$string['month'] = '(الشهور)';
$string['moredetails'] = 'تفاصيل أكثر';
$string['mybackpack'] = 'إعدادات حقيبة ظهري';
$string['mybadges'] = 'شاراتي';
$string['namewithlink'] = 'الاسم مع الرابط';
$string['never'] = 'أبداً';
$string['newbackpack'] = 'إضافة حقيبة ظهر جديدة';
$string['newbadge'] = 'إضافة شارة جديدة';
$string['newimage'] = 'صورة جديدة';
$string['noalignment'] = 'لا تحتوي هذه الشارة على أي مهارات أو معايير خارجية محددة.';
$string['noawards'] = 'لم يتم الحصول على هذه الشارة بعد.';
$string['nobackpack'] = 'لا توجد خدمة حقيبة ظهر متصلة بهذا الحساب.<br/>';
$string['nobackpackbadgessummary'] = 'لا توجد شارات في المجموعات التي حددتها.';
$string['nobackpackcollectionssummary'] = 'لم يتم اختيار مجموعات شارة.';
$string['nobackpacks'] = 'لا توجد حقائب ظهر متاحة';
$string['nobadges'] = 'لا توجد شارات متاحة هنا للمستخدمين ليكتسبوها.';
$string['nocompetencies'] = 'لم يتم تحديد الكفاءات.';
$string['nocriteria'] = 'لم يتم إعداد معايير هذه الشارة بعد.';
$string['noendorsement'] = 'هذه الشارة ليس لها تأييد.';
$string['noexpiry'] = 'لا تحتوي هذه الشارة على تاريخ انتهاء الصلاحية.';
$string['nomatchingbadges'] = 'ليست هناك شارات مطابقة متاحة ليكتسبها المستخدمون.';
$string['noparamstoadd'] = 'لا توجد معلمات إضافية متاحة للإضافة إلى متطلبات الشارة هذه.';
$string['norelated'] = 'لا تحتوي هذه الشارة على أي شارات ذات صلة.';
$string['notacceptedrole'] = 'مهمة دورك الحالية ليست من بين الأدوار التي يمكنها إصدار هذه الشارة يدويًا.
إذا كنت ترغب في رؤية المستخدمين الذين حصلوا بالفعل على هذه الشارة، يمكنك زيارة صفحة {$a}.';
$string['notconnected'] = 'غير متصل';
$string['notealignment'] = 'قد يتم تحديد المهارات أو المعايير الخارجية التي تتوافق معها الشارة. يتم عرض أي مهارات أو معايير خارجية على صفحة الشارة.';
$string['noteendorsement'] = 'يمكن استخدام مصادقة طرف ثالث لإضافة قيمة إلى الشارة. على سبيل المثال، قد يتم التصديق على شارة صادرة عن معلم من قبل المدرسة، أو قد يتم التصديق على شارة صادرة عن جهة مانحة محلية من قبل الهيئة الوطنية المانحة.';
$string['noterelated'] = 'قد يتم وضع علامة على شارات مع اتصال. على سبيل المثال ، قد يتم وضع علامة على الشارات ذات المعايير نفسها التي يتم عرضها بلغات مختلفة. يتم عرض أي شارات ذات صلة على صفحة الشارة.';
$string['nothingtoadd'] = 'لا توجد معايير متوفرة للإضافة.';
$string['notification'] = 'قم بإشعار منشئ الشارة';
$string['notification_help'] = 'يدير هذا الإعداد الإشعارات المرسلة إلى مُنشئ الشارة لإعلامه بأنه قد تم إصدار الشارة.

تتوفر الخيارات التالية:

* **أبداً** - لا ترسل إشعارات.

* **في كل مرة** - إرسال إشعار في كل مرة يتم فيها منح هذه الشارة.

* **يومياً** - إرسال الإشعارات مرة واحدة في اليوم.

* **أسبوعياً** - إرسال الإشعارات مرة واحدة في الأسبوع.

* **شهرياً** - إرسال الإشعارات مرة واحدة في الشهر.';
$string['notifydaily'] = 'يومياً';
$string['notifyevery'] = 'في كل مرة';
$string['notifymonthly'] = 'شهرياً';
$string['notifyweekly'] = 'أسبوعياً';
$string['numawards'] = 'تم إصدار هذه الشارة إلى {$a->count} مستخدم (مستخدمين).';
$string['numawardstat'] = 'تم إصدار هذه الشارة {$a} مستخدم (مستخدمين).';
$string['oauth2issuer'] = 'خدمات المصادقة OAuth 2';
$string['openbadgesv1'] = 'افتح الشارات v1.0';
$string['openbadgesv2'] = 'افتح الشارات v2.0';
$string['openbadgesv2p1'] = 'الشارات المفتوحة، الإصدار 2.1';
$string['othernavigation'] = 'تنقل آخر ...';
$string['overallcrit'] = 'من المعايير المحددة كاملة.';
$string['password_required'] = 'كلمة المرور لا يمكن أن تكون فارغة';
$string['potentialrecipients'] = 'مستلمو الشارة المحتملون';
$string['preferences'] = 'تفضيلات الشارات';
$string['privacy:metadata:backpack'] = 'سِجل بحقائب ظهر المستخدم';
$string['privacy:metadata:backpack:backpackuid'] = 'المُعرَّف الفريد لحقيبة الظهر';
$string['privacy:metadata:backpack:email'] = 'البريد الالكتروني المرتبط بحقيبة الظهر';
$string['privacy:metadata:backpack:externalbackpackid'] = 'مُعرَّف حقيبة الظهر';
$string['privacy:metadata:backpack:userid'] = 'مُعرَّف المستخدم العائدة له حقيبة الظهر';
$string['privacy:metadata:backpackoauth2'] = 'بيانات مصادقة OAuth 2 عندما يتصل المستخدم بحقيبة ظهر خارجية';
$string['privacy:metadata:backpackoauth2:issuerid'] = 'معرَّف خدمة المصادقة OAuth 2';
$string['privacy:metadata:backpackoauth2:scope'] = 'قائمة نطاق لربط حقيبة الظهر';
$string['privacy:metadata:backpackoauth2:token'] = 'رمز اتصال حقيبة الظهر';
$string['privacy:metadata:backpackoauth2:userid'] = 'مُعرف المستخدم المتصل بحقيبة الظهر';
$string['privacy:metadata:backpackoauth2:usermodified'] = 'مُعرف المستخدم الذي غيَّر الاتصال';
$string['privacy:metadata:badge'] = 'مجموعة من الشارات';
$string['privacy:metadata:badge:timecreated'] = 'الوقت الذي تم فيه إنشاء الشارة';
$string['privacy:metadata:badge:timemodified'] = 'الوقت الذي تم فيه تعديل الشارة';
$string['privacy:metadata:badge:usercreated'] = 'معرف المستخدم الذي قام بإنشاء الشارة';
$string['privacy:metadata:badge:usermodified'] = 'معرف المستخدم الذي قام بتعديل الشارة';
$string['privacy:metadata:criteriamet'] = 'مجموعة من المعايير التي تم الوفاء بها';
$string['privacy:metadata:criteriamet:datemet'] = 'تاريخ استيفاء المعايير';
$string['privacy:metadata:criteriamet:userid'] = 'معرف المستخدم الذي استوفى المعايير';
$string['privacy:metadata:external:backpacks'] = 'المعلومات التي تتم مشاركتها عندما يُسلِّم المستخدمون شاراتهم إلى حقيبة ظهر خارجية';
$string['privacy:metadata:external:backpacks:badge'] = 'اسم الشارة';
$string['privacy:metadata:external:backpacks:description'] = 'وصف الشارة';
$string['privacy:metadata:external:backpacks:image'] = 'صورة الشارة';
$string['privacy:metadata:external:backpacks:issuer'] = 'بعض المعلومات عن المُصدر';
$string['privacy:metadata:external:backpacks:url'] = 'عنوان رابط مودل حيث يمكن رؤية معلومات الشارة الصادرة';
$string['privacy:metadata:issued'] = 'سجل الشارات الممنوحة';
$string['privacy:metadata:issued:dateexpire'] = 'تاريخ انتهاء صلاحية الشارة';
$string['privacy:metadata:issued:dateissued'] = 'تاريخ المنح';
$string['privacy:metadata:issued:userid'] = 'مُعرَّف المستخدم الذي حصل على الشارة';
$string['privacy:metadata:manualaward'] = 'سجل الممنوحات اليدوية';
$string['privacy:metadata:manualaward:datemet'] = 'تاريخ حصول المستخدم على الشارة';
$string['privacy:metadata:manualaward:issuerid'] = 'مُعرَّف المستخدم المانح للشارة';
$string['privacy:metadata:manualaward:issuerrole'] = 'دور المستخدم المانح للشارة';
$string['privacy:metadata:manualaward:recipientid'] = 'مُعرَّف المستخدم الذي تم منحه الشارة يدوياً';
$string['recipient'] = 'الشارة استُلِمت';
$string['recipientdetails'] = 'تفاصيل المستلم';
$string['recipientidentificationproblem'] = 'لا يمكن العثور على مستلم لهذه الشارة بين المستخدمين الحاليين.';
$string['recipients'] = 'مستلمو الشارة';
$string['recipientvalidationproblem'] = 'لا يمكن التحقق من أن هذا المستخدم مستلم لهذه الشارة.';
$string['relatedbages'] = 'شارات ذات صلة';
$string['relative'] = 'التاريخ النسبي';
$string['requiredbadge'] = 'يجب إضافة شارة واحدة على الأقل إلى معيار الشارة.';
$string['requiredcohort'] = 'يجب إضافة مجموعة واحدة على الأقل إلى معيار المجموعة.';
$string['requiredcompetency'] = 'يجب إضافة كفاءة واحدة على الأقل إلى معيار الكفاءة.';
$string['requiredcourse'] = 'يجب إضافة مادة واحدة على الأقل إلى معيار مجموعة المقرر';
$string['reviewbadge'] = 'التغييرات في وصول شارة';
$string['reviewconfirm'] = '<p>سيؤدي ذلك إلى جعل شارتك مرئية للمستخدمين ويسمح لهم بالبدء في كسبها.</p>

<p>من المحتمل أن يكون بعض المستخدمين مستوفين بالفعل لمعايير هذه الشارة وسيحصلون علها بمجرد تمكينها.</p>

<p>بمجرد إصدار الشارة، سيتم <strong>تأمينها</strong> - بحيث لا يعود بالإمكان تغيير بعض إعداداتها بما في ذلك المعايير وإعدادات انتهاء الصلاحية.</p>

<p>هل تريد بالتأكيد تمكين الوصول إلى الشارة \'{$a}\'؟</p>';
$string['revoke'] = 'إبطال الشارة';
$string['save'] = 'حفظ';
$string['searchname'] = 'البحث عن طريق الاسم';
$string['selectaward'] = 'يرجى تحديد الدور الذي ترغب في استخدامه لمنح هذه الشارة:';
$string['selectgroup_end'] = 'يتم عرض المجموعات العامة فقط. <a href="{$a}">قم بزيارة حقيبة الظهر الخاصة بك</a>لإنشاء المزيد من المجموعات العامة.';
$string['selectgroup_start'] = 'إختر مجموعات من حقيبة الظهر الخاصة بك لعرضها في هذا الموقع:';
$string['selecting'] = 'مع الشارات المحددة ...';
$string['setup'] = 'إعداد الاتصال';
$string['sitebackpackdeleted'] = 'موقع حقيبة الظهر قد تم حذفه.';
$string['sitebackpacknotdeleted'] = 'يتعذر حذف حقيبة الظهر هذه نظراً لكونها الافتراضية في الموقع.';
$string['sitebackpackwarning'] = 'تعذر الاتصال بحقيبة الظهر. <br/><br/>تحقق من أن إعداد المسؤول "عنوان البريد الإلكتروني لمصدر الشارة" هو البريد الإلكتروني الصحيح للحساب في موقع حقيبة الظهر. <br/><br/>تحقق من أن "كلمة مرور مُصدر الشارة" في <a href="{$a->url}">صفحة إعدادات حقيبة الظهر للموقع</a>، هي كلمة المرور الصحيحة للحساب في موقع حقيبة الظهر. <br/><br/> حقيبة الظهر أرجعت: "{$a->warning}"';
$string['sitebadges'] = 'شارات الموقع';
$string['sitebadges_help'] = 'لا يمكن منح الشارات للمستخدمين إلا عن الأنشطة المتعلقة بالموقع. تشمل هذه إكمال مجموعة من المقررات الدراسية أو أجزاء من الملفات الشخصية للمستخدمين. يمكن أيضاً منح شارات الموقع يدوياً من قبل مستخدم لآخر.

يجب إنشاء الشارات المتعلقة بأنشطة المساق على مستوى المقرر نفسه. يمكن العثور على شارات المساق ضمن إدارة المقرر الدراسي > الشارات.';
$string['sitebadgetitle'] = 'شارة الموقع {$a}';
$string['status'] = 'حالة الشارة';
$string['status_help'] = 'تحدد حالة الشارة سلوكها في النظام:

* **متاحة** - يمكن للمستخدمين الحصول على هذه الشارة. عندما تكون شارة متاحة للمستخدمين، لا يمكن تعديل معاييرها.

* **غير متاحة** - الشارة غير متاحة للمستخدمين ولا يمكن الحصول عليها أو إصدارها يدوياً. إذا لم تُمنح هذه الشارة من قبل، فيمكن تغيير معاييرها.

بمجرد إصدار شارة لمستخدم واحد على الأقل، تصير تلقائياً
**مؤمنة**. لا يزال بإمكان المستخدمين الحصول على الشارات المؤمنة، ولكن ليس بالإمكان تغيير معاييرها. إذا كنت بحاجة إلى تعديل تفاصيل أو معايير شارة مؤمنة، يمكنك تكرارها وإجراء جميع التغييرات المطلوبة.

*لماذا نقوم بتأمين الشارات؟*

نريد التأكد من أن كل المستخدمين يكملون نفس المتطلبات لكسب شارة. حالياً، لا يمكن سحب الشارات. إذا سمحنا بتعديل متطلبات الشارات في أي وقت، فمن المرجح أن ينتهي الأمر بنا إلى حصول المستخدمين على نفس الشارة لكن بتلبية متطلبات مختلفة تماماً.';
$string['statusmessage_0'] = 'هذه الشارة غير متاحة حاليًا للمستخدمين. مكّن الوصول إذا كنت تريد أن يكسب المستخدمون هذه الشارة.';
$string['statusmessage_1'] = 'هذه الشارة متاحة حاليًا للمستخدمين. عطّل الوصول لإجراء أي تغييرات.';
$string['statusmessage_2'] = 'هذه الشارة غير متاحة حاليًا للمستخدمين، وتم تأمين معاييرها. قم بتمكين الوصول إذا كنت تريد للمستخدمين إحراز هذه الشارة.';
$string['statusmessage_3'] = 'هذه الشارة متاحة حاليًا للمستخدمين، وتم تأمين معاييرها.';
$string['statusmessage_4'] = 'هذه الشارة مؤرشفة حاليًا.';
$string['subject'] = 'موضوع الرسالة';
$string['tagarea_badge'] = 'الشارات';
$string['tags'] = 'الوسوم';
$string['targetcode'] = 'الشفرة';
$string['targetcode_help'] = 'معرف سلسلة فريد للإشارة إلى المهارة أو المعيار الخارجي في إطاره.';
$string['targetdescription'] = 'الوصف';
$string['targetdescription_help'] = 'وصف قصير للمهارة الخارجية أو المعيار.';
$string['targetframework'] = 'الإطار';
$string['targetframework_help'] = 'اسم المهارة الخارجية أو الإطار القياسي.';
$string['targetname'] = 'الاسم';
$string['targetname_help'] = 'المهارة أو المعيار الخارجي الذي تتماشى معه الشارة.';
$string['targeturl'] = 'رابط URL';
$string['targeturl_help'] = 'رابط إلى صفحة تصف المهارة أو المعيار الخارجي. يجب أن يحتوي عنوان الرابط على البادئة http:// أو https://.';
$string['testbackpack'] = 'فحص حقيبة الظهر \'{$a}\\';
$string['testsettings'] = 'فحص الإعدادات';
$string['type'] = 'النوع';
$string['userbadges'] = 'شارات المستخدم';
$string['variablesubstitution'] = 'استبدال متغير في الرسائل.';
$string['variablesubstitution_help'] = 'في رسالة الشارة، يمكن إدراج بعض المتغيرات في موضوع و/أو نص الرسالة بحيث يتم استبدالها بقيم حقيقية عند إرسال الرسالة. ينبغي إدراج المتغيرات في النص كما هو موضح أدناه. يمكن استعمال المتغيرات التالية:

%badgename%
: سيتم استبداله بالاسم الكامل للشارة.

%username%
: سيتم استبداله بالاسم الكامل للمستلم.

%badgelink%
: سيتم استبداله بعنوان الرابط العمومي مع معلومات عن الشارة الممنوحة.';
$string['verifyemail'] = 'التحقق من البريد الالكتروني';
$string['version'] = 'الإصدار';
$string['version_help'] = 'يمكن استخدام حقل الإصدار لتتبع تطور الشارة. إذا تم تحديد ذلك ، فسيتم عرض الإصدار على صفحة الشارة.';
$string['viewbadge'] = 'عرض الشارة الصادرة';
$string['visible'] = 'مرئي';
$string['warnexpired'] = '(انتهت هذه الشارة!)';
$string['year'] = '(سنوات)';
