<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'attendance', language 'ar', version '4.3'.
 *
 * @package     attendance
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['Aacronym'] = 'ح';
$string['Afull'] = 'غائب';
$string['Eacronym'] = 'م';
$string['Efull'] = 'مستأذن';
$string['Lacronym'] = 'خ';
$string['Lfull'] = 'متأخر';
$string['Pacronym'] = 'ح';
$string['Pfull'] = 'حاضر';
$string['absenteereport'] = 'تقرير المتغيب';
$string['acronym'] = 'المختصر';
$string['add'] = 'إضافة';
$string['addedrecip'] = 'تمت إضافة {$a} مستلم جديد';
$string['addedrecips'] = 'تمت إضافة {$a} من المستلمين الجدد';
$string['addmultiplesessions'] = 'جلسات متعددة';
$string['addsession'] = 'إضافة جلسة';
$string['adduser'] = 'إضافة مستخدم';
$string['addwarning'] = 'إضافة تنبيه';
$string['all'] = 'الكل';
$string['allcourses'] = 'كل المقررات الدراسية';
$string['allpast'] = 'كل الماضي';
$string['allsessions'] = 'كل الجلسات';
$string['attendance:addinstance'] = 'إضافة نشاط حضور جديد';
$string['attendance:canbelisted'] = 'يظهر في القائمة';
$string['attendance:changeattendances'] = 'تغيير الحضور';
$string['attendance:changepreferences'] = 'تغيير التفضيلات';
$string['attendance:export'] = 'تصدير التقارير';
$string['attendance:manageattendances'] = 'إدارة الحضور';
$string['attendance:managetemporaryusers'] = 'إدارة المستخدمين المؤقتين';
$string['attendance:takeattendances'] = 'أخذُ الحضور';
$string['attendance:view'] = 'معاينة الحضور';
$string['attendance:viewreports'] = 'معاينة التقارير';
$string['attendance:viewsummaryreports'] = 'معاينة تقارير ملخص المقرر';
$string['attendance:warningemails'] = 'يمكنه الاشتراك برسائل البريد الالكتروني مع المستخدمين المتغيبين';
$string['attendance_already_submitted'] = 'حضورك قد تم تثبيته مسبقاً.';
$string['attendance_no_status'] = 'لا توجد حالة متاحة - ربما أنت متأخر تماماً عن تسجيل الحضور.';
$string['attendancedata'] = 'بيانات الحضور';
$string['attendancefile'] = 'ملف الحضور (صيغة csv)';
$string['attendancefile_help'] = 'ينبغي أن يكون الملف بصيغة CSV يتضمن صف العناوين والتي هي الحقول المطلوبة لتمييز المستخدم ووقت تسجيل الحضور، مثلاً: (email,scantime) أو (username,time)';
$string['attendancegrade'] = 'علامة الحضور';
$string['attendancenotset'] = 'عليك تثبيت حالة حضورك';
$string['attendancenotstarted'] = 'لم يبدأ الحضور بعد لهذا المقرر';
$string['attendancepercent'] = 'النسبة المئوية للحضور';
$string['attendancereport'] = 'تقرير الحضور';
$string['attendanceslogged'] = 'تم تسجيل الحضور في سجل الوقوعات';
$string['attendancestaken'] = 'تم أخذ الحضور';
$string['attendancesuccess'] = 'تم أخذ الحضور بنجاح';
$string['attendanceupdated'] = 'تم تحديث الحضور بنجاح';
$string['attforblockdirstillexists'] = 'المجلد mod/attforblock لا يزال موجوداً - ينبغي عليك حذف هذا المجلد من مخدمك قبل تشغيل هذه الترقية.';
$string['attrecords'] = 'سجلات الحضور';
$string['autoassignstatus'] = 'إختر أعلى حالة تلقائياً';
$string['autoassignstatus_help'] = 'إذا تم إختياره، سيتم منح الطلاب أعلى علامة ممكنة تلقائياً.';
$string['automark'] = 'تأشير تلقائي';
$string['automark_help'] = 'يسمح بإكمال التأشيرات تلقائياً.
إن كان "نعم"، سيتم تأشير حالة الطلبة تلقائياً إعتماداً على أول وصول لهم إلى المقرر الدراسي.
إن كان "إجعله غير مؤشر عند انتهاء الجلسة"، فسيتم ضبط حالة الطلاب الذين لم يؤشروا حضورهم على الوضع غير المؤشر.';
$string['automarkall'] = 'نعم';
$string['automarkclose'] = 'إجعله غير مؤشر عند انتهاء الجلسة';
$string['automarktask'] = 'التحري عن جلسات الحضور التي تتطلب التأشير التلقائي';
$string['autorecorded'] = 'مُسجل تلقائياً من قبل النظام';
$string['averageattendance'] = 'متوسط الحضور';
$string['averageattendancegraded'] = 'متوسط الحضور';
$string['backtoparticipants'] = 'عودة إلى قائمة المشاركين';
$string['below'] = 'أقل من {$a}%';
$string['calclose'] = 'إغلاق';
$string['calendarevent'] = 'إنشاء حدث لجلسة الحضور في التقويم';
$string['calendarevent_help'] = 'عند تمكينه، سيتم إنشاء حدث في التقويم لجلسة الحضور.
عند تعطيله، سيتم حذف أي حدث موجود في التقويم يتعلق بجلسة الحضور.';
$string['caleventcreated'] = 'تم إنشاء حدث التقويم بشأن جلسة الحضور بنجاح';
$string['caleventdeleted'] = 'تم حذف حدث التقويم بشأن جلسة الحضور بنجاح';
$string['calmonths'] = 'يناير,فبراير,مارس,ابريل,مايو,يونيو,يوليو,اغسطس,سبتمبر,اكتوبر,نوفمبر,ديسمبر';
$string['calshow'] = 'حدد التاريخ';
$string['calweekdays'] = 'أح،إث،ثل،أر،خم،جم،سب';
$string['cannottakeforgroup'] = 'لا يمكنكَ أخذ الحضور للمجموعة "{$a}"';
$string['cantaddstatus'] = 'ينبغي عليك وضع المختصر والوصف عند إضافة حالة جديدة.';
$string['categoryreport'] = 'تقرير تصنيف المقرر';
$string['changeattendance'] = 'تغيير الحضور';
$string['changeduration'] = 'تغيير الفترة';
$string['changesession'] = 'تغيير الجلسة';
$string['checkweekdays'] = 'إختر أيام الأسبوع التي تقع ضمن فترة تواريخ الجلسات التي اخترتها.';
$string['closed'] = 'هذه الجسة غير متاحة حالياً للتأشير الذاتي';
$string['column'] = 'العمود';
$string['columnmap'] = 'تعيين الأعمدة';
$string['columnmap_help'] = 'إختر العمود المناظر في ملف csv لكل من الحقول الموجودة.';
$string['columns'] = 'الأعمدة';
$string['commonsession'] = 'كل الطلاب';
$string['commonsessions'] = 'كل الطلاب';
$string['confirm'] = 'التأكيد';
$string['confirmcolumnmappings'] = 'تأكيد تعيين الأعمدة';
$string['confirmdeletehiddensessions'] = 'هل أنت متأكد من رغبتك في حذف {$a->count} جلسات مجدولة قبل تاريخ بدء المقرر الدراسي في ({$a->date})؟';
$string['confirmdeleteuser'] = 'هل أنت متأكد من رغبتك في حذف المستخدم \'{$a->fullname}\' ({$a->email})؟<br/>كل سجلات حضورهم سيتم حذفها نهائياً.';
$string['copyfrom'] = 'نسخ بيانات الحضور من';
$string['countofselected'] = 'عدد ما تم تحديده';
$string['course'] = 'المقرر';
$string['coursemessage'] = 'مراسلة مستخدمي المقرر';
$string['courseshortname'] = 'الاسم المختصر للمقرر الدراسي';
$string['coursesummary'] = 'تقرير ملخص المقرر';
$string['createmultiplesessions'] = 'إنشاء جلسات متعددة';
$string['createmultiplesessions_help'] = 'هذه الوظيفة تسمح لك بإنشاء جلسات متعددة عبر خطوة واحدة بسيطة.
تبدأ الجلسات من تاريخ الجلسة الأساسية وتستمر حتى تاريخ \'الإعادة حتى\'.

  * <strong>Repeat on</strong>: Select the days of the week when your class will meet (for example, Monday/Wednesday/Friday).
  * <strong>Repeat every</strong>: This allows for a frequency setting. If your class will meet every week, select 1; if it will meet every other week, select 2; every 3rd week, select 3, etc.
  * <strong>Repeat until</strong>: Select the last day of class (the last day you want to take attendance).';
$string['createonesession'] = 'أنشئ جلسة واحدة للمساق الدراسي';
$string['csvdelimiter'] = 'مُحدد CSV';
$string['currentlyselectedusers'] = 'المستخدمون المحددون حالياً';
$string['date'] = 'التاريخ';
$string['days'] = 'الأيام';
$string['defaultdisplaymode'] = 'نمط العرض الافتراضي';
$string['defaults'] = 'الافتراضيات';
$string['defaultsessionsettings'] = 'الإعدادات الافتراضية للجلسة';
$string['defaultsessionsettings_help'] = 'هذه الإعدادات تُعرِّف الافتراضيات لكل الجلسات الجديدة';
$string['defaultsettings'] = 'الإعدادات الافتراضية للحضور';
$string['defaultsettings_help'] = 'هذه الإعدادات تُعرِّف الافتراضيات لكل نشاطات الحضور الجديدة';
$string['defaultstatus'] = 'تم ضبط الحالة الافتراضية';
$string['defaultsubnet'] = 'عنوان الشبكة الافتراضي';
$string['defaultsubnet_help'] = 'يمكن جعل تسجيلات الحضور مقيدة بشبكة فرعية معينة عبر تحديد قائمة مفصولة بفوارز لعناوين IP جزئية أو كاملة. هذه هي القيمة الافتراضية المستعملة عند إنشاء جلسات جديدة.';
$string['defaultview'] = 'المعاينة الافتراضية عند الدخول';
$string['defaultview_desc'] = 'هذه هي المعاينة الافتراضية التي تظهر للمعلمين عند دخولهم لأول مرة.';
$string['defaultwarnings'] = 'تم ضبط التنبيه الافتراضي';
$string['defaultwarningsettings'] = 'إعدادات التنبيه الافتراضية';
$string['defaultwarningsettings_help'] = 'هذه الإعدادات تُعرِّف الافتراضيات لكل التنبيهات الجديدة';
$string['delete'] = 'حذف';
$string['deletecheckfull'] = 'هل أنت متأكد تماماً من رغبتك في الحذف الكامل لـ {$a}، متضمناً ذلك مل بيانات المستخدمين؟';
$string['deletedgroup'] = 'لقد تم حذف المجموعة المرتبطة بهذه الجلسة';
$string['deletehiddensessions'] = 'حذف كل الجلسات المخفية';
$string['deletelogs'] = 'حذف بيانات الحضور';
$string['deleteselected'] = 'حذف المختارة';
$string['deletesession'] = 'حذف الجلسة';
$string['deletesessions'] = 'حذف كل الجلسات';
$string['deleteuser'] = 'حذف المستخدم';
$string['deletewarningconfirm'] = 'هل أنت متأكد من رغبتك في حذف هذا التنبيه؟';
$string['deletingsession'] = 'يجري حذف جلسة الحضور من المقرر الدراسي';
$string['deletingstatus'] = 'يجري حذف الحالة من المقرر الدراسي';
$string['description'] = 'الوصف';
$string['display'] = 'العرض';
$string['displaymode'] = 'نمط العرض';
$string['donotusepaging'] = 'لا تستعمل الصفحات';
$string['downloadexcel'] = 'التنزيل بصيغة Excel';
$string['downloadooo'] = 'التنزيل بصيغة OpenOffice';
$string['downloadtext'] = 'التنزيل بصيغة ملف نصي';
$string['duration'] = 'الفترة';
$string['editsession'] = 'تحرير الجلسة';
$string['edituser'] = 'تحرير المستخدم';
$string['emailcontent'] = 'محتوى الرسالة';
$string['emailcontent_default'] = 'مرحباً %userfirstname%،
إن حضورك في %coursename% %attendancename% قد انخفض إلى ما دون %warningpercent% وهو حالياً بنسبة %percent% - نحن نأمل أنك بخير!

لتحصل على أقصى ما هو ممكن من هذا المساق، ينبغي عليك تحسين حالة حضورك فيه، لطفاً، كن على اتصال إذا كنت بحاجة إلى أي مساعدة إضافية.';
$string['emailcontent_help'] = 'عند إرسال التنبيه إلى الطالب، سيأخذ متن الرسالة محتواه من هذا الحقل. يمكن استعمال الرموز البديلة الآتية:
<ul>
<li>%coursename%</li>
<li>%userfirstname%</li>
<li>%userlastname%</li>
<li>%userid%</li>
<li>%warningpercent%</li>
<li>%attendancename%</li>
<li>%cmid%</li>
<li>%numtakensessions%</li>
<li>%points%</li>
<li>%maxpoints%</li>
<li>%percent%</li>
</ul>';
$string['emailsubject'] = 'موضوع الرسالة';
$string['emailsubject_default'] = 'تنبيه الحضور';
$string['emailsubject_help'] = 'عند إرسال التنبيه إلى الطالب، فإنه سيأخذ موضوع الرسالة من هذا الحقل.';
$string['emailuser'] = 'مراسلة المستخدم';
$string['emailuser_help'] = 'إذا تم تأشيره، سيتم إرسال تنبيه إلى الطالب.';
$string['emptyacronym'] = 'لا يُسمح بالمختصرات الفارغة. لم يتم تحديث سجل الحالة.';
$string['emptydescription'] = 'لا يُسمح بالأوصاف الفارغة. لم يتم تحديث سجل الحالة.';
$string['enablecalendar'] = 'إنشاء أحداث التقويم';
$string['enablecalendar_desc'] = 'عند تمكينه، سيتم إنشاء حدث في التقويم لكل جلسة حضور. بعد تغيير هذا الإعداد، ينبغي عليك تشغيل تقرير إعادة تعيين التقويم.';
$string['enablewarnings'] = 'تمكين التنبيهات';
$string['enablewarnings_desc'] = 'هذا يسمح بتعريف طقم التنبيه بالنسبة إلى الحضور وإشعارات البريد الالكتروني الموجهة إلى المستخدمين عندما تنخفض نسبة حضورهم عن مقدار معين. <br/><strong>تحذير: هذه ميزة جديدة ولم يتم اختبارها على نطاق واسع. لطفاً، ستستعملها على مسؤوليتك ونرجو إفادتنا في منتديات مودل إذا وجدتها تعمل بشكل جيد.</strong>';
$string['encoding'] = 'الترميز';
$string['encoding_help'] = 'هذا يشير إلى نوع ترميز الرمز الشريطي المستعمل في البطاقة التعريفية للطالب. الأنواع التقليدية من مخططات الترميزات الشريطية تتضمن Code-39، Code-128 و UPC-A.';
$string['endofperiod'] = 'نهاية الفترة';
$string['endtime'] = 'وقت إنتهاء الجلسة';
$string['enrolmentend'] = 'إنضمام المستخدم ينتهي في {$a}';
$string['enrolmentstart'] = 'إنضمام المستخدم يبدأ في {$a}';
$string['enrolmentsuspended'] = 'تم تعليق الانضمام';
$string['enterpassword'] = 'أدخل كلمة المرور';
$string['error:coursehasnoattendance'] = 'المقرر الدراسي الذي بالاسم المختصر {$a} ليس فيه أي نشاطات من الحضور.';
$string['error:coursenotfound'] = 'تعذر العثور على المقرر الدراسي ذي الاسم المختصر {$a}.';
$string['error:qrcode'] = 'لا بد من تمكين الطلاب من تأشير حضورهم بأنفسهم من أجل استعمال ترميز QR! يجري التخطي.';
$string['error:sessioncourseinvalid'] = 'مساق الجلسة غير صحيح! يجري التخطي.';
$string['error:sessiondateinvalid'] = 'تاريخ الجلسة غير صحيح! يجري التخطي.';
$string['error:sessionendinvalid'] = 'تاريخ إنتهاء الجلسة غير صحيح! يجري التخطي.';
$string['error:sessionstartinvalid'] = 'تاريخ بدء الجلسة غير صحيح! يجري التخطي.';
$string['error:statusnotfound'] = 'المستخدم: {$a->extuser} لديه قيمة لحالة الجلسة تعذر العثور عليها: {$a->status}';
$string['error:timenotreadable'] = 'المستخدم: {$a->extuser} لديه وقت مسح الترميز تعذر تحويله من قبل الدالة strtotime: {$a->scantime}';
$string['error:userduplicate'] = 'تم العثور على المستخدم {$a} مرتين عند الاستيراد. لطفاً، قم بتضمين سجل واحد فقط لكل مستخدم.';
$string['error:usernotfound'] = 'تعذر العثور على المستخدم الذي لديه {$a->userfield} مثبتاً على {$a->extuser}';
$string['errorgroupsnotselected'] = 'إختر مجموعة واحدة أو أكثر';
$string['errorinaddingsession'] = 'إضافة الجلسة';
$string['erroringeneratingsessions'] = 'خطأ عند توليد الجلسات';
$string['eventdurationupdated'] = 'فترة جلسة تم تحديثها';
$string['eventreportviewed'] = 'تقرير حضور تمت معاينته';
$string['eventscreated'] = 'أحداث تقويم تم إنشاؤها';
$string['eventsdeleted'] = 'أحداث تقويم تم حذفها';
$string['eventsessionadded'] = 'جلسة تمت إضافتها';
$string['eventsessiondeleted'] = 'جلسة تم حذفها';
$string['eventsessionipshared'] = 'تضارب عنوان IP لتأشير الحضور الذاتي';
$string['eventsessionsimported'] = 'جلسات تم استيرادها';
$string['eventsessionupdated'] = 'جلسة تم تحديثها';
$string['eventstatusadded'] = 'حالة تمت إضافتها';
$string['eventstatusupdated'] = 'حالة تمت تحديثها';
$string['eventstudentattendancesessionsupdated'] = 'تقرير جلسة تم تحديثه';
$string['eventstudentattendancesessionsviewed'] = 'تقرير جلسة تمت معاينته';
$string['eventtaken'] = 'حضور تم أخذه';
$string['eventtakenbystudent'] = 'حضور تم أخذه من قبل طالب';
$string['export'] = 'تصدير';
$string['extrarestrictions'] = 'تقييدات إضافية';
$string['formattexttype'] = 'التنسيق';
$string['from'] = 'من:';
$string['gradebookexplanation'] = 'الدرجة في سجل التقديرات';
$string['gradebookexplanation_help'] = 'إن وحدة الحضور تعرض درجة حضورك الحالية بناءً على عدد النقاط التي اكتسبتها حتى اليوم وعدد النقاط التي كان من الممكن لك اكتسابها إلى تاريخه؛ إنها لا تشمل فترات الحضور المستقبلية. في سجل التقديرات، ستكون درجة حضورك مبنية على النسبة المئوية لحضورك وعدد النقاط التي من الممكن اكتسابها على امتداد كل مدة المقرر، شاملاً ذلك جلسات الحضور المستقبلية. ولذلك، قد تكون نقاطك في وحدة نشاط الحضور مختلفة عما تشاهده في سجل التقديرات، ولكنهما يشتركان في النسبة المئوية.

على سبيل المثال، إذا كنتَ قد حصلت على 8 من 10 نقاط حتى اليوم (أي حضور بنسبة 80%)، وحضورك بالنسبة إلى إجمالي المقرر مقداره 50 نقطة، فستعرض وحدة الحضور 8/10، وسجل التقديرات سيعرض 40/50. لم تحصل بعد على 40 نقطة، ولكن 40 تمثل القيمة المكافئة من النقاط للنسبة المئوية لحضورك حالياً والبالغة 80%. قيمة النقاط التي اكتسبتها في وحدة الحضور لا يمكنها أن تنقص أبداً؛ نظراً لكونها مبنية فقط على حالة الحضور حتى تاريخه؛ مع ذلك، يمكن لقيمة نقاط الحضور التي يعرضها سجل التقديرات أن تنقص أو تزيد إعتماداً على حضورك مستقبلاً، لأنها مبنية على حالة حضورك على امتداد المقرر بأكمله.';
$string['graded'] = 'الجلسات الداخلة في التقدير';
$string['gridcolumns'] = 'أعمدة الشبكة';
$string['group'] = 'المجموعة';
$string['groups'] = 'المجموعات';
$string['groupsession'] = 'مجموعة من الطلبة';
$string['hiddensessions'] = 'الجلسات المخفية';
$string['hiddensessions_help'] = 'تكون الجلسات مخفية إذا تمت جدولتها قبل تاريخ بدء المقرر الدراسي.

يمكنك استعمال هذه الميزة لإخفاء الجلسات القديمة بدلاً من حذفها. الجلسات المرئية فقط ستظهر في سجل التقديرات.';
$string['hiddensessionsdeleted'] = 'تم حذف كل الجلسات المخفية';
$string['hideextrauserdetails'] = 'إخفاء البيانات الإضافية للمستخدم';
$string['hidensessiondetails'] = 'إخفاء تفاصيل الجلسة';
$string['identifyby'] = 'تحديد هوية الطالب بواسطة';
$string['import'] = 'استيراد';
$string['importfile'] = 'ملف الاستيراد';
$string['importfile_help'] = 'ملف الاستيراد';
$string['importsessions'] = 'استيراد الجلسات';
$string['importstatus'] = 'حقل الحالة';
$string['importstatus_help'] = 'هذا يسمح بتضمين قيمة الحالة من ملف الاستيراد - أي القيم مثل ح، م، أو غ';
$string['includeabsentee'] = 'تضمين الجلسة عند احتساب تقرير المتغيب';
$string['includeabsentee_help'] = 'عند تأشيره، سيتم شمول هذه الجلسة في حسابات تقرير المتغيب.';
$string['includeall'] = 'إختيار كل الجلسات';
$string['includedescription'] = 'تضمين وصف الجلسة';
$string['includenottaken'] = 'تضمين الجلسات غير المأخوذة بعد';
$string['includeqrcode'] = 'تضمين ترميز QR';
$string['includeremarks'] = 'تضمين الملاحظات';
$string['incorrectpassword'] = 'لقد أدخلتَ كلمة مرور خاطئة وحضورك لم يتم تسجيله، لطفاً، أدخل كلمة المرور الصحيحة.';
$string['incorrectpasswordshort'] = 'كلمة مرور خاطئة، لم يتم تسجيل الحضور.';
$string['indetail'] = 'بالتفصيل...';
$string['indicator:cognitivedepth'] = 'الحضور معرفياً';
$string['indicator:cognitivedepth_help'] = 'هذا المؤشر مبني على عمق الحالة المعرفية التي وصلها الطالب في نشاط الحضور.';
$string['indicator:cognitivedepthdef'] = 'الحضور معرفياً';
$string['indicator:cognitivedepthdef_help'] = 'لقد وصل المشارك إلى هذه النسبة المئوية من المشاركة المعرفية التي وفرتها نشاطات الحضور خلال فترة التحليل هذه (المستويات = لا معاينة، معاينة)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'الحضور إجتماعياً';
$string['indicator:socialbreadth_help'] = 'هذا المؤشر مبني على عمق التوسع الاجتماعي الذي وصله الطالب في نشاط الحضور.';
$string['indicator:socialbreadthdef'] = 'الحضور إجتماعياً';
$string['indicator:socialbreadthdef_help'] = 'لقد وصل المشارك إلى هذه النسبة المئوية من المشاركة الاجتماعية التي وفرتها نشاطات الحضور خلال فترة التحليل هذه (المستويات = لا مشاركة، المشاركة منفرداً)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['invalidaction'] = 'ينبغي عليك إختيار الإجراء';
$string['invalidemails'] = 'ينبغي عليك تحديد عناوين مستخدمين موجودين بالفعل، تعذر العثور على: {$a}';
$string['invalidimportfile'] = 'صيغة الملف خاطئة.';
$string['invalidsessionenddate'] = 'لا يمكن أن يكون هذا التاريخ سابقاً لتاريخ الجلسة';
$string['invalidsessionendtime'] = 'وقت الانتهاء ينبغي أن يكون بعد وقت البدء';
$string['invalidstatus'] = 'لقد اخترت حالة غير صحيحة، لطفاً، حاول مجدداً';
$string['iptimemissing'] = 'دقائق الإطلاق غير صحيحة';
$string['jumpto'] = 'القفز إلى';
$string['keepsearching'] = 'واصل البحث';
$string['marksessionimportcsvhelp'] = 'هذا النموذج يسمح لك برفع ملف csv متضمناً مُعرَّف المستخدم والحالة - حقل الحالة يمكن أن يكون مختصر الحالة أو وقت تسجيل الحضور. إذا تم تمرير قيمة الوقت، فستتم محاولة تعيين أعلى قيمة متاحة للحالة عند ذلك الوقت.';
$string['maxpossible'] = 'أقصى ما يمكن';
$string['maxpossible_help'] = 'يظهر الدرجات التي يمكن أن يصل إليها كل مستخدم إذا تلقى أقصى درجة ممكنة في كل جلسة لم تُؤخذ بعد (ماضية ومستقبلية):
    <ul>
    <li><strong>النقاط</strong>: أقصى نقاط يمكن أن يصلها كل مستخدم على امتداد كل الجلسات.</li>
    <li><strong>النسبة المئوية</strong>: أقصى نسبة مئوية يمكن أن يصلها كل مستخدم على امتداد كل الجلسات.</li>
    </ul>';
$string['maxpossiblepercentage'] = 'نسبة أقصى ما يمكن';
$string['maxpossiblepoints'] = 'أقصى نقاط ممكنة';
$string['maxwarn'] = 'أقصى عدد من تنبيهات البريد الالكتروني';
$string['maxwarn_help'] = 'أقصى عدد من المرات لإرسال التنبيهات (يتم إرسال تنبيه واحد لكل جلسة)';
$string['mergeuser'] = 'دمج المستخدم';
$string['mobilesessionfrom'] = 'إظهار الجلسات الأقدم من الأخيرة';
$string['mobilesessionfrom_help'] = 'يسمح بتقييد قائمة الجلسات عند التأشير باستعمال التطبيق - الاقتصار على إظهار الجلسات التي بدأت منذ هذه القيمة';
$string['mobilesessionto'] = 'إظهار الجلسات المستقبلية';
$string['mobilesessionto_help'] = 'يسمح بتقييد قائمة الجلسات بحيث تعرض عدد قليل من الجلسات المستقبلية.';
$string['mobilesettings'] = 'إعدادات تطبيق الجوال';
$string['mobilesettings_help'] = 'هذه الإعدادات تتحكم بسلوك تطبيق مودل في الجوال';
$string['modulename'] = 'الحضور';
$string['modulename_help'] = 'وحدة نشاط الحضور تُمكن المعلم من أخذ الحضور في أثناء المحاضرة وتسمح للطلبة بمعاينة سجلات الحضور الخاصة بهم.

يمكن للمعلم إنشاء جلسات حضور متعددة وتأشير حالة الحضور بمسميات مثل "حاضر"، "غائب"، "متأخر"، "مستأذن" أو حتى تعديل الحالات بما يناسب حاجاته.

تتوفر التقارير عن كل الطلاب أو عن الطالب منفرداً.';
$string['modulenameplural'] = 'الحضور';
$string['months'] = 'الأشهر';
$string['moreattendance'] = 'تم أخذ الحضور بنجاح في هذه الصفحة';
$string['moveleft'] = 'إنتقل يساراً';
$string['moveright'] = 'إنتقل يميناً';
$string['multisessionexpanded'] = 'الجلسات المتعددة موسعة';
$string['multisessionexpanded_desc'] = 'إظهار إعدادات "الجلسات المتعددة" كأنها مُوسعة إفتراضياً عند إنشاء جلسات جديدة.';
$string['mustselectusers'] = 'ينبغي إختيار المستخدمين المزمع تصديرهم';
$string['newdate'] = 'تاريخ جديد';
$string['newduration'] = 'فترة جديدة';
$string['newstatusset'] = 'ضبط جديد من الحالات';
$string['noabsentstatusset'] = 'ضبط الحالة المستعمل ليس له حالة تُستعمل عند عدم التأشير.';
$string['noattendanceusers'] = 'من المستحيل تصدير أي بيانات نظراً لعدم وجود طلبة منضمين إلى المقرر الدراسي.';
$string['noattforuser'] = 'لا توجد تسجيلات حضور للمستخدم';
$string['noautomark'] = 'مُعطَّل';
$string['nodescription'] = 'جلسة الصف الاعتيادية';
$string['noeventstoreset'] = 'لا توجد أحداث في التقويم بحاجة إلى تحديث.';
$string['nogroups'] = 'لا يمكنك إضافة جلسات للمجموعات. لا توجد مجموعات في المقرر الدراسي.';
$string['noguest'] = 'الضيف لا يمكنه مشاهدة الحضور';
$string['noofdaysabsent'] = 'عدد أيام الغياب';
$string['noofdaysexcused'] = 'عدد أيام الاستئذان';
$string['noofdayslate'] = 'عدد أيام التأخر';
$string['noofdayspresent'] = 'عدد أيام التواجد';
$string['nosessiondayselected'] = 'لم يتم اختيار يوم الجلسة';
$string['nosessionexists'] = 'لا توجد جلسات حضور في هذا المقرر الدراسي';
$string['nosessionsselected'] = 'لم يتم اختيار أي جلسات';
$string['notfound'] = 'لم يتم العثور على نشاط الحضور في هذا المقرر الدراسي!';
$string['notifytask'] = 'أرسل التنبيهات إلى المستخدمين';
$string['notmember'] = 'ليس عضواً';
$string['notset'] = 'غير مُعد';
$string['noupgradefromthisversion'] = 'وحدة الحضور لا يمكنها الترقية من إصدار attforblock التي قمت بتنصيبها. - لطفاً، قم بحذف attforblock أو ترقتها إلى آخر إصدار قبل تنصيب وحدة الحضور الجديدة.';
$string['numsessions'] = 'عدد الجلسات';
$string['olddate'] = 'تاريخ قديم';
$string['onlyselectedusers'] = 'تصدير مستخدمين معينين';
$string['overallsessions'] = 'على مدار كل الجلسات';
$string['overallsessions_help'] = 'يظهر الإحصائيات لكل الجلسات شاملة تلك التي لم تؤخذ بعد (الماضية والمستقبلية):
    <ul>
    <li><strong>الجلسات</strong>: إجمالي عدد الجلسات.</li>
    <li><strong>النقاط</strong>: النقاط الممنوحة بناءً على الجلسات المأخوذة.</li>
    <li><strong>النسبة المئوية</strong>: النسبة المئوية للنقاط الممنوحة قياساً بأقصى عدد ممكن من النقاط لكل الجلسات.</li>
    </ul>';
$string['oversessionstaken'] = 'على مدار الجلسات المأخوذة';
$string['oversessionstaken_help'] = 'يظهر الإحصائيات للجلسات التي أُخذ فيها الحضور:
    <ul>
    <li><strong>الجلسات</strong>: عدد الجلسات المأخوذة فعلياً.</li>
    <li><strong>النقاط</strong>: النقاط الممنوحة بناءً على الجلسات المأخوذة.</li>
    <li><strong>النسبة المئوية</strong>: النسبة المئوية للنقاط الممنوحة قياساً بأقصى عدد ممكن من النقاط للجلسات المأخوذة.</li>
    </ul>';
$string['pageof'] = 'الصفحة {$a->page} من {$a->numpages}';
$string['participant'] = 'المشارك';
$string['password'] = 'كلمة المرور';
$string['passwordgrp'] = 'كلمة مرور الطالب';
$string['passwordgrp_help'] = 'عند ضبطه، سيكون لزاماً على الطلبة إدخال كلمة المرور هذه قبل أن يتمكنوا من تثبيت حالة حضورهم للجلسة. إذا تركته فارغاً، لن يتطلب الأمر كلمة مرور.';
$string['passwordrequired'] = 'ينبغي عليك إدخال كلمة مرور الجلسة قبل أن تتمكن من تقديم حضورك';
$string['percentage'] = 'النسبة المئوية';
$string['percentageallsessions'] = 'النسبة المئوية على مدار كل الجلسات';
$string['percentagesessionscompleted'] = 'النسبة المئوية على مدار الجلسات المأخوذة';
$string['pluginadministration'] = 'إدارة الحضور';
$string['pluginname'] = 'الحضور';
$string['points'] = 'نقاط';
$string['pointsallsessions'] = 'النقاط لكل الجلسات';
$string['pointssessionscompleted'] = 'النقاط للجسات المأخوذة';
$string['preferences_desc'] = 'التغييرات في ضبط حالة الجلسات ستؤثر على جلسات الحضور الموجودة وقد تؤثر على الدرجات ايضاً.';
$string['preventsharederror'] = 'تم تعطيل تأشير الحضور الذاتي للجلسة لأن هذا الجهاز يبدو أنه سبق استعماله لتسجيل الحضور لصالح طالب آخر.';
$string['preventsharedip'] = 'منع الطلاب من مشاركة عنوان IP';
$string['preventsharedip_help'] = 'منع الطلاب من استعمال نفس الجهاز (يتم تمييزه من عنوان IP) لتأشير الحضور لطلاب آخرين.';
$string['preventsharediptime'] = 'وقت السماح بإعادة استعمال عنوان IP (بالدقائق)';
$string['preventsharediptime_help'] = 'السماح بإعادة استعمال عنوان IP لتأشير الحضور في هذه الجلسة بعد انقضاء هذه المدة.';
$string['preview'] = 'استعراض الملف';
$string['previewhtml'] = 'استعراض صيغة HTML';
$string['priorto'] = 'تاريخ الجلسة سابق لتاريخ بدء المقرر الدراسي ({$a}) لذلك ستكون الجلسات الجديدة المجدولة قبل هذا التاريخ مخفية (غير قابلة للوصول إليها). يمكنك تغيير تاريخ بدء المقرر في أي وقت (أنظر إعدادات المقرر) من أجل إتاحة الوصول إلى الجلسات الأسبق.<br><br>لطفاً، قم بتغيير تاريخ الجلسة أو فقط أنقر زر "إضافة جلسة" مرة أخرى للتأكيد!';
$string['privacy:metadata:attendancelog'] = 'سجل حضور المستخدم في سجل الوقوعات';
$string['privacy:metadata:attendancesessions'] = 'الجلسات التي سيتم فيها تسجيل الحضور';
$string['privacy:metadata:attendancewarningdone'] = 'سجل وقوعات التنبيهات المرسلة إلى المستخدمين خلال تسجيل حضورهم';
$string['privacy:metadata:duration'] = 'مدة الجلسة بالثواني';
$string['privacy:metadata:groupid'] = 'مُعرَّف المجموعة المرتبطة بالجلسة';
$string['privacy:metadata:ipaddress'] = 'عنوان IP الذي تم منه تأشير الحضور';
$string['privacy:metadata:lasttaken'] = 'الطابع الزمني لوقت أخذ الحضور آخر مرة';
$string['privacy:metadata:lasttakenby'] = 'مُعرَّف المستخدم الأخير الذي أخذ حضوره في هذه الجلسة';
$string['privacy:metadata:notifyid'] = 'مُعرَّف جلسة الحضور المرتبط بها التنبيه';
$string['privacy:metadata:remarks'] = 'التعليقات بشأن حضور المستخدم';
$string['privacy:metadata:sessdate'] = 'الطابع الزمني لوقت بدء الجلسة';
$string['privacy:metadata:sessionid'] = 'مُعرَّف جلسة الحضور';
$string['privacy:metadata:statusid'] = 'مُعرَّف حالة حضور الطالب';
$string['privacy:metadata:statusset'] = 'تثبيت الحالة الذي يعود عليه مُعرَّفها';
$string['privacy:metadata:studentid'] = 'مُعرَّف الطالب الذي تم تأشير حضوره';
$string['privacy:metadata:takenby'] = 'مُعرَّف المستخدم لمن قام بأخذ حضور الطالب';
$string['privacy:metadata:timemodified'] = 'الطابع الزمني لوقت آخر تعديل في الجلسة';
$string['privacy:metadata:timesent'] = 'الطابع الزمني لوقت إرسال التنبيه';
$string['privacy:metadata:timetaken'] = 'الطابع الزمني لوقت أخذ الحضور للطالب';
$string['privacy:metadata:userid'] = 'مُعرَّف المستخدم المزمع إرسال التنبيه إليه';
$string['processingfile'] = 'تجري معالجة الملف';
$string['qr_cookie_error'] = 'جلسة QR قد انتهت صلاحيتها.';
$string['qr_pass_wrong'] = 'كلمة مرور QR خاطئة أو صلاحيتها منتهية.';
$string['qrcode'] = 'ترميز QR';
$string['randompassword'] = 'كلمة مرور عشوائية';
$string['remark'] = 'ملاحظة لـ: {$a}';
$string['remarks'] = 'الملاحظات';
$string['repeatasfollows'] = 'تكرار الجلسة أعلاه كما يأتي';
$string['repeatevery'] = 'التكرار كل';
$string['repeaton'] = 'التكرار في';
$string['repeatuntil'] = 'الإعادة حتى';
$string['report'] = 'التقرير';
$string['required'] = 'مطلوب*';
$string['requiredentries'] = 'السجلات المؤقتة تستبدل سجلات حضور المشاركين';
$string['requiredentry'] = 'دليل المساعدة لدمج المستخدمين المؤقتين';
$string['requiredentry_help'] = '<p align="center"><b>الحضور</b></p>
<p align="right"><strong>دمج الحسابات</strong></p>
<p align="right">
<table border="2" cellpadding="4">
<tr>
<th>مستخدم مودل</th>
<th>مستخدم مؤقت</th>
<th>الإجراء</th>
</tr>
<tr>
<td>بيانات الحضور</td>
<td>بيانات الحضور</td>
<td>المستخدم المؤقت سيتجاوز مستخدم مودل</td>
</tr>
<tr>
<td>لا بيانات حضور</td>
<td>Attendance data</td>
<td>المستخدم المؤقت سيتم تقله إلى مستخدم مودل</td>
</tr>
<tr>
<td>بيانات الحضور</td>
<td>لا بيانات حضور</td>
<td>المستخدم المؤقت سيتم حذفه</td>
</tr>
<tr>
<td>لا بيانات حضور</td>
<td>لا بيانات حضور</td>
<td>المستخدم المؤقت سيتم حذفه</td>
</tr>
</table>

</p>
<p align="right"><strong>سيتم حذف المستخدم المؤقت في كل الأحوال بعد إجراء الدمج</strong></p>';
$string['requiresubnet'] = 'يتطلب عنوان الشبكة';
$string['requiresubnet_help'] = 'يمكن جعل تسجيلات الحضور مقيدة بشبكة فرعية معينة عبر تحديد قائمة مفصولة بفوارز لعناوين IP جزئية أو كاملة.';
$string['resetcaledarcreate'] = 'لقد تم تمكين وضع أحداث الجلسات في التقويم، ولكن عدد من الجلسات الموجودة ليست لها أحداث هناك. هل ترغب بإنشاء أحداث التقويم لكل الجلسات الموجودة؟';
$string['resetcaledardelete'] = 'لقد تم تعطيل وضع أحداث الجلسات في التقويم، ولكن عدد من الجلسات الموجودة لها أحداث هناك ينبغي حذفها. هل ترغب بحذف أحداث التقويم لكل الجلسات الموجودة؟';
$string['resetcalendar'] = 'إعادة تعيين التقويم';
$string['resetdescription'] = 'تذكر بأن حذف بيانات الحضور سيؤدي إلى حذف المعلومات من قاعدة البيانات. يمكنك فقط إخفاء الجلسات القديمة تحسباً لقيامك بتغيير تاريخ بدء المقرر الدراسي!';
$string['resetstatuses'] = 'إعادة تعيين الحالات إلى الوضع الافتراضي';
$string['restoredefaults'] = 'استعادة الافتراضيات';
$string['resultsperpage'] = 'عدد النتائج في الصفحة';
$string['resultsperpage_desc'] = 'عدد الطلبة المعروضين في الصفحة';
$string['rotateqrcode'] = 'تدوير ترميز QR';
$string['rotateqrcode_cleartemppass_task'] = 'مهمة إخلاء كلمات المرور المؤقتة المُولَّدة من قبل وظيفة تدوير ترميز QR.';
$string['rotateqrcodeexpirymargin'] = 'هامش صلاحية تدوير ترميز QR أو كلمة المرور (بالثواني)';
$string['rotateqrcodeexpirymargin_desc'] = 'الفترة الزمنية (بالثواني) للسماح بترميز QR أو كلمة المرور منتهية الصلاحية.';
$string['rotateqrcodeinterval'] = 'فترة تدوير ترميز QR أو كلمة المرور (بالثواني)';
$string['rotateqrcodeinterval_desc'] = 'الفترة الزمنية لتدوير ترميز QR أو كلمة المرور (بالثواني).';
$string['save'] = 'حفظ الحضور';
$string['scantime'] = 'وقت المسح';
$string['scantime_help'] = 'هذا يسمح بتضمين الطابع الزمني في ملف الاستيراد - سيحاول تحويل الطابع الزمني المُمرر باستعمال دالة strtotime من PHP ومن ثم استعمال إعدادات حالة الحضور لتقرير أي حالة ينبغي وضعها للمستخدم';
$string['search:activity'] = 'الحضور - معلومات النشاط';
$string['session'] = 'الجلسة';
$string['session_help'] = 'الجلسة';
$string['sessionadded'] = 'تمت إضافة الجلسة بنجاح';
$string['sessionalreadyexists'] = 'الجلسة موجودة مسبقاً في هذا التاريخ';
$string['sessiondate'] = 'التاريخ';
$string['sessiondays'] = 'أيام الجلسات';
$string['sessiondeleted'] = 'تم حذف الجلسة بنجاح';
$string['sessionduplicate'] = 'توجد جلسة مكررة في المقرر الدراسي: {$a->course} في نشاط الحضور: {$a->activity}';
$string['sessionexist'] = 'لم تتم إضافة الجلسة (موجودة مسبقاً)!';
$string['sessiongenerated'] = 'تم توليد جلسة واحدة بنجاح';
$string['sessions'] = 'الجلسات';
$string['sessionsallcourses'] = 'كل المقررات الدراسية';
$string['sessionscompleted'] = 'الجلسات المأخوذة';
$string['sessionsgenerated'] = '{$a} من الجلسات تم توليدها بنجاح';
$string['sessionsids'] = 'مُعرَّفات الجلسات:';
$string['sessionsnotfound'] = 'لا توجد جلسات ضمن النطاق الزمني المحدد';
$string['sessionstartdate'] = 'تاريخ بدء الجلسة';
$string['sessionstotal'] = 'إجمالي عدد الجلسات';
$string['sessionsupdated'] = 'تم تحديث الجلسات';
$string['sessiontype'] = 'النوع';
$string['sessiontype_help'] = 'يمكنك إضافة الجلسات لكل الطلاب أو لمجموعة منهم. القدرة على إضافة أنواع مختلفة تعتمد على نمط المجموعات للنشاط.

* في نمط المجموعات "لا مجموعات"، يمكنك فقط إضافة الجلسات لجميع الطلاب.
* في نمط المجموعات "مجموعات منفصلة"، يمكنك فقط إضافة الجلسات لمجموعة من الطلاب.
* في نمط المجموعات "مجموعات مرئية"، يمكنك إضافة كلا النوعين من الجلسات.';
$string['sessiontypeshort'] = 'النوع';
$string['sessionunknowngroup'] = 'الجلسة تحدد مجموعة/مجموعات مجهولة: {$a}';
$string['sessionupdated'] = 'تم تحديث الجلسة بنجاح';
$string['set_by_student'] = 'مُسجَّلة ذاتياً';
$string['setallstatuses'] = 'تثبيت الحالة لـ';
$string['setallstatusesto'] = 'تثبيت الحالة على «{$a}»';
$string['setperiod'] = 'يحدد الوقت بالدقائق لإعادة إطلاق عنوان IP';
$string['settings'] = 'الإعدادات';
$string['setunmarked'] = 'التثبيت التلقائي عند عدم التأشير';
$string['setunmarked_help'] = 'إذا تم تمكينه في الجلسة، قم بتثبيت هذه الحالة إذا لم يقم الطالب بتأشير حضوره.';
$string['showdefaults'] = 'إظهار الافتراضيات';
$string['showduration'] = 'إظهار الفترة';
$string['showextrauserdetails'] = 'إظهار تفاصيل المستخدم الإضافية';
$string['showqrcode'] = 'إظهار ترميز QR';
$string['showsessiondescriptiononreport'] = 'إظهار وصف الجلسة في التقرير';
$string['showsessiondescriptiononreport_desc'] = 'إظهار وصف الجلسة عند إدراج تقرير الحضور.';
$string['showsessiondetails'] = 'إظهار تفاصيل الجلسة';
$string['somedisabledstatus'] = '(تمت إزالة بعض الخيارات نظراً لكون الجلسة قد بدأت).';
$string['sortedgrid'] = 'شبكة مفروزة';
$string['sortedlist'] = 'قائمة مفروزة';
$string['startofperiod'] = 'بداية الفترة';
$string['starttime'] = 'وقت البدء';
$string['status'] = 'الحالة';
$string['statusall'] = 'الكل';
$string['statusdeleted'] = 'تم حذف الحالة';
$string['statuses'] = 'الحالات';
$string['statusset'] = 'تم تثبيت الحالة {$a}';
$string['statussetsettings'] = 'ضبط الحالة';
$string['statusunselected'] = 'غير محددة';
$string['strftimedm'] = '%b %d';
$string['strftimedmy'] = '%d %b %Y';
$string['strftimedmyhm'] = '%d %b %Y %I.%M%p';
$string['strftimedmyw'] = '<nobr>%a %d %b %Y</nobr>';
$string['strftimeh'] = '%I%p';
$string['strftimehm'] = '%I:%M%p';
$string['strftimeshortdate'] = '%d.%m.%Y';
$string['studentid'] = 'مُعرَّف الطالب';
$string['studentmarked'] = 'تم تسجيل حضورك في هذه الجلسة.';
$string['studentmarking'] = 'التسجيل من قبل الطلاب';
$string['studentpassword'] = 'كلمة مرور الطالب';
$string['studentrecordingexpanded'] = 'التسجيل من قبل الطلاب موسع';
$string['studentrecordingexpanded_desc'] = 'إظهار إعدادات "التسجيل من قبل الطلاب" موسعة إفتراضياً عند إنشاء الجلسات الجديدة.';
$string['studentscanmark'] = 'السماح للطلاب بتسجيل حضورهم';
$string['studentscanmark_desc'] = 'عند تأشيره، سيكون بإمكان المعلمين أن يسمحوا للطلاب بتسجيل حضورهم بأنفسهم.';
$string['studentscanmark_help'] = 'عند تأشيره، سيكون بإمكان الطلاب تغيير حالة حضورهم للجلسة.';
$string['studentscanmarksessiontime'] = 'الطلبة يسجلون حضورهم خلال وقت الجلسة';
$string['studentscanmarksessiontime_desc'] = 'عند تأشيره، سيقتصر تأشير الطلاب لحضورهم على وقت الجلسة.';
$string['studentscanmarksessiontimeend'] = 'نهاية الجلسة (بالدقائق)';
$string['studentscanmarksessiontimeend_desc'] = 'إذا لم يكن للجلسة موعد إنتهاء، كم من الدقائق ينبغي أن تكون فيها الجلسة متاحة للطلبة ليسجلوا فيها حضورهم.';
$string['submit'] = 'تسليم';
$string['submitattendance'] = 'تسليم الحضور';
$string['submitpassword'] = 'تسليم كلمة المرور';
$string['subnet'] = 'الشبكة الفرعية';
$string['subnetactivitylevel'] = 'السماح بتهيئة الشبكة الفرعية على مستوى النشاط';
$string['subnetactivitylevel_desc'] = 'عند تمكينه، سيكون بإمكان المعلمين تجاوز الشبكة الفرعية الافتراضية على مستوى النشاط عند إنشاء الحضور. بخلاف ذلك، سيتم استعمال القيمة الافتراضية للموقع عند إنشاء الجلسة.';
$string['subnetwrong'] = 'يمكن تسجيل الحضور فقط من مواقع معينة، وهذا الحاسوب ليس ضمن القائمة المسموح بها.';
$string['summary'] = 'الملخص';
$string['tablerenamefailed'] = 'فشلت إعادة تسمية جدول attforblock القديم إلى تسمية attendance';
$string['tactions'] = 'الإجراء';
$string['takeattendance'] = 'أخذ الحضور';
$string['takensessions'] = 'الجلسات المأخوذة';
$string['tcreated'] = 'تم إنشاؤه';
$string['tempaddform'] = 'إضافة مستخدم مؤقت';
$string['tempexists'] = 'هناك مسبقاً مستخدم مؤقت بنفس عنوان البريد الالكتروني هذا';
$string['temptable'] = 'قائمة المستخدمين المؤقتين';
$string['tempuser'] = 'مستخدم مؤقت';
$string['tempusermerge'] = 'دمج المستخدمين المؤقتين';
$string['tempusers'] = 'المستخدمون المؤقتون';
$string['tempusersedit'] = 'تحرير المستخدم المؤقت';
$string['tempuserslist'] = 'المستخدمون المؤقتون';
$string['thirdpartyemails'] = 'إشعار المستخدمين الآخرين';
$string['thirdpartyemails_help'] = 'قائمة بالمستخدمين الآخرين الذين سيتم إشعارهم. (يتطلب الإمكانية mod/attendance:viewreports)';
$string['thirdpartyemailsubject'] = 'تنبيه الحضور';
$string['thirdpartyemailtext'] = 'حضور {$a->firstname} {$a->lastname} ضمن {$a->coursename} {$a->aname} هو أدنى من {$a->warningpercent} ({$a->percent})';
$string['thirdpartyemailtextfooter'] = 'أنت تتلقى هذ الرسالة لأن معلم هذا المقرر قد أضاف عنوان بريدك الالكتروني إلى قائمة المستلمين';
$string['thiscourse'] = 'هذا المقرر';
$string['time'] = 'الوقت';
$string['timeahead'] = 'لا يمكن إنشاء الجلسات المتعددة التي تتجاوز عاماً كاملاً، لطفاً، قم بتعديل تاريخي البدء والانتهاء.';
$string['to'] = 'حتى:';
$string['tuseremail'] = 'البريد الالكتروني';
$string['tusername'] = 'الاسم الكامل';
$string['ungraded'] = 'الجلسات التي تمت ترقيتها';
$string['unknowngroup'] = 'مجموعة مجهولة';
$string['update'] = 'تحديث';
$string['uploadattendance'] = 'رفع الحضور باستعمال CSV';
$string['usedefaultsubnet'] = 'استعمل الافتراضي';
$string['usemessageform'] = 'أو استعمل النموذج أدناه لإرسال رسالة إلى الطلبة المحددين';
$string['userexists'] = 'هناك مسبقاً مستخدم حقيقي بنفس عنوان البريد الالكتروني هذا';
$string['userid'] = 'مُعرَّف المستخدم';
$string['userimportfield'] = 'حقل المستخدم الخارجي';
$string['userimportfield_help'] = 'الحقل من ملف CSV المرفوع والذي يتضمن مُعرَّف المستخدم';
$string['userimportto'] = 'حقل مستخدم مودل';
$string['userimportto_help'] = 'حقل مودل الذي يطابق البيانات من تصدير CSV';
$string['users'] = 'المستخدمون المزمع تصديرهم';
$string['usestatusset'] = 'ضبط الحالة';
$string['variable'] = 'المتغير';
$string['variablesupdated'] = 'تم تحديث المتغيرات بنجاح';
$string['versionforprinting'] = 'الإصدار من أجل الطباعة';
$string['viewmode'] = 'نمط المعاينة';
$string['warnafter'] = 'عدد الجلسات المأخوذة قبل التنبيه';
$string['warnafter_help'] = 'سيتم تحفيز التنبيهات فقط عندما يصل عدد جلسات الحضور المأخوذة إلى هذا العدد على الأقل.';
$string['warningdeleted'] = 'تم حذف التنبيه';
$string['warningdesc'] = 'ستتم إضافة هذه التنبيهات تلقائياً إلى أي نشاط حضور جديد. إذا تم تحفيز أكثر من تنبيه عند نفس الوقت بالضبط، سيتم إرسال التنبيه الذي له عتبة تنبيه أقل فقط.';
$string['warningdesc_course'] = 'عتبة التنبيه المثبتة هنا تؤثر على تقرير المتغيب وتسمح بأن يتم إشعار الطلبة وذويهم. إذا تم تحفيز أكثر من تنبيه عند نفس الوقت بالضبط، سيتم إرسال التنبيه الذي له عتبة تنبيه أقل فقط.';
$string['warningfailed'] = 'لا يمكنك إنشاء تنبيه يستعمل نفس النسبة المئوية للجلسات وعددها.';
$string['warningpercent'] = 'قم بالتنبيه إذا انخفضت النسبة عن';
$string['warningpercent_help'] = 'سيتم تحفيز التنبيه عندما تنخفض النسبة المئوية الشاملة للحضور عن هذا المقدار.';
$string['warnings'] = 'تم وضع التنبيهات';
$string['warningthreshold'] = 'عتبة التنبيه';
$string['warningupdated'] = 'التنبيهات المُحدَّثة';
$string['week'] = 'أسبوع/أسابيع';
$string['weeks'] = 'أسابيع';
$string['youcantdo'] = 'لا يمكنك القيام بشيء';
