<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'reservation', language 'pt_br', version '4.3'.
 *
 * @package     reservation
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addparticipant'] = 'Nova solicitação';
$string['after10min'] = '10 minutos após o início do evento';
$string['after12h'] = '12 horas após o início do evento';
$string['after1d'] = '1 dia após o início do evento';
$string['after1h'] = '1 hora após o início do evento';
$string['after1w'] = '1 semana após o início do evento';
$string['after2d'] = '2 dias após o início do evento';
$string['after2h'] = '2 horas após o início do evento';
$string['after2w'] = '2 semanas após o início do evento';
$string['after30min'] = '30 minutos após o início do evento';
$string['after3w'] = '3 semanas após o início do evento';
$string['after4h'] = '4 horas após o início do evento';
$string['after4w'] = '4 semanas após o início do evento';
$string['after5min'] = '5 minutos após o início do evento';
$string['after6h'] = '6 horas após o início do evento';
$string['alreadybooked'] = 'Você já reservou';
$string['alreadyoverbooked'] = 'Você está na lista de espera';
$string['atstart'] = 'No início do evento';
$string['autohide'] = 'Esconder automaticamente a lista de reserva';
$string['availablerequests'] = 'Cadeiras disponíveis';
$string['badcourse'] = 'O curso não existe';
$string['badparent'] = 'Esta reserva foi conectada a outra reserva não restaurada.
Esta conexão foi removida. Se necessário, reconecte-as manualmente.';
$string['badsection'] = 'Seção "{$a}"  não existe no curso';
$string['badteachers'] = 'E-mail do professor informado com ({$a}) não foi encontrado';
$string['badteachersmail'] = 'E-mail do professor informado com ({$a}) é inválido';
$string['badtimeclose'] = 'Horário de fechamento inválido';
$string['badtimeend'] = 'Horário final inválido';
$string['badtimeopen'] = 'Horário de abertura inválido';
$string['badtimestart'] = 'Horário inicial inválido';
$string['by'] = 'Por';
$string['bydate'] = 'Data do evento';
$string['byname'] = 'Nome';
$string['bysection'] = 'Tópico/Semana';
$string['cancelledon'] = 'Cancelado';
$string['cancellersmail'] = 'Você foi cancelado da reserva "{$a->reservation}".';
$string['cancellersmailhtml'] = 'Você foi cancelado da reserva <em>{$a->reservation}</em>.';
$string['checkclashes'] = 'Verifique os conflitos de locais e horáriosl';
$string['clashesfound'] = 'Foram encontrados alguns locais e horários com conflitos';
$string['clashesreport'] = 'Relatório de conflitos';
$string['cleanview'] = 'Exibir somente as reservas atuais';
$string['close'] = 'Fechar';
$string['closed'] = 'Fechado';
$string['completionreserved'] = 'O estudante deve efetuar a reserva para concluir esta atividade';
$string['config'] = 'Configurações da reserva';
$string['configautohide'] = 'Esta opção define quando as reservas devem ser ocultadas da lista de reservas (mod/reservation/index.php). Isto pode ser útil se usado com listas públicas, ordenadas para exibir uma lista limpa.';
$string['configcheckclashes'] = 'Habilite o botão "Conferir local e horário com conflitos" na página de edição de reservas';
$string['configconnectto'] = 'Defina onde o módulo de busca de reservas deve se conectar';
$string['configdownload'] = 'Esta opção define o formato do arquivo de download padrão para todas as listas de solicitações e reservas.';
$string['configevents'] = 'Esta opção de configuração define quais eventos serão criados para cada reserva';
$string['configfields'] = 'Esta opção configuração define quais campos serão mostrados no formulário de reservas';
$string['configlocations'] = 'Gerenciar local padrão para reservas no site Moodle';
$string['configmanualusers'] = 'Esta opção define qual lista de usuários deve ser exibida no menu suspenso usado para selecionar usuários manualmente.';
$string['configmaxoverbook'] = 'Esta opção define a porcentagem máxima de reservas acima do permitido';
$string['configmaxrequests'] = 'Definir o limite do menu suspenso na página de edição da reserva';
$string['configminduration'] = 'Esta opção indica a duração mínima para um evento reservado. É utilizada para eventos que não foram informados data/hora finais para verificar a disponibilidade de horário e local';
$string['confignotifies'] = 'Esta opção definição define quais notificações devem ser enviadas';
$string['configoverbookstep'] = 'Esta opção define a granularidade do percentual da reserva excedente. Pode ser definidas com menor ou maior granularidade';
$string['configpubliclists'] = 'Esta opção define se as listas de reservas são públicas (podem ser visualizadas sem login) ou não.';
$string['configsortby'] = 'Esta opção define como a lista de reservas deve ser classificada classificada.';
$string['configsublimits'] = 'Esta opção defini o número de linhas de regras de sublimites apresentada na página de edição de reserva';
$string['configupload'] = 'Crie várias reservas fazendo upload por meio de um arquivo de texto';
$string['confirmdelete'] = 'Tem certeza de que deseja excluir as solicitações de reserva selecionadas?';
$string['connectedto'] = 'Reserva conectada a';
$string['connectto'] = 'Reserva conectável de';
$string['description'] = 'Descrição';
$string['downloadas'] = 'Formato padrão de download';
$string['duration10h'] = '10 horas';
$string['duration10min'] = '10 minutos';
$string['duration11h'] = '11 horas';
$string['duration12h'] = '12 horas';
$string['duration15min'] = '15 minutos';
$string['duration20min'] = '20 minutos';
$string['duration2h'] = '2 horas';
$string['duration30min'] = '30 minutos';
$string['duration3h'] = '3 horas';
$string['duration45min'] = '45 minutos';
$string['duration4h'] = '4 horas';
$string['duration5h'] = '5 horas';
$string['duration5min'] = '5 minutos';
$string['duration60min'] = '60 minutos';
$string['duration6h'] = '6 horas';
$string['duration7h'] = '7 horas';
$string['duration8h'] = '8 horas';
$string['duration90min'] = '90 minutos';
$string['duration9h'] = '9 horas';
$string['enablenote'] = 'Ativar anotação de usuários';
$string['equal'] = 'igual a';
$string['err_sublimitsgreater'] = 'A soma dos sublimites é maior que o pedido permitido máximo';
$string['err_timeendlower'] = 'A data final definida para o evento é anterior a data de início';
$string['err_timeopengreater'] = 'A data definida para início da reserva é posterior a data de término';
$string['eventevent'] = 'Criar um evento para o curso com as datas de início e término';
$string['eventreminder'] = '{$a} (reservado)';
$string['eventrequestadded'] = 'Pedido de reserva adicionado';
$string['eventrequestcancelled'] = 'Pedido de reserva cancelado';
$string['eventrequestdeleted'] = 'Pedido de reserva excluído';
$string['events'] = 'Calendário de eventos';
$string['eventsettings'] = 'Configurações do evento';
$string['explainconfig'] = 'Os administradores podem definir aqui as configurações globais do módulo de reserva';
$string['fields'] = 'Campos exibidos';
$string['fullview'] = 'Exibir também as reservas excluídas';
$string['gradedmail'] = '{$a->teacher} postou algum comentário sobre a sua
reserva \'{$a->reservation}\'

Você pode visualizá-los aqui:

     {$a->url}';
$string['gradedmailhtml'] = '{$a->teacher} postou algum comentário sobre a sua reserva \'<i>{$a->reservation}</i>\'<br><br>
Você pode verificar <a href="{$a->url}">aqui</a>.';
$string['importreservations'] = 'Importar Reservas';
$string['invalidreservationid'] = 'ID de reserva inválido';
$string['justbooked'] = 'Você está registrado como: {$a}';
$string['justoverbooked'] = 'Você encontra-se no excesso de reservas como: {$a}';
$string['linenumber'] = '#';
$string['listafterclose'] = 'lista de pedidos de reservas na situação "Fechada"';
$string['listalways'] = 'lista de todas as solicitações de reserva';
$string['location'] = 'Local';
$string['locations'] = 'Gerenciar locais';
$string['locationslist'] = 'Lista de locais';
$string['mail'] = 'A reserva \'{$a->reservation}\' foi fechada.

Você pode baixar lista de reservas de:

    {$a->url}';
$string['mailhtml'] = 'A reserva <em>{$a->reservation}</em> foi encerrada.<br /><br />
Você pode baixar a lista de reservas neste endereço <a href="{$a->url}"></a>.';
$string['mailrequest'] = 'A reserva \'{$a->reservation}\' foi fechada.

Você pode obter o seu número de reserva em:

    {$a->url}';
$string['mailrequesthtml'] = 'A reserva <em>{$a->reservation}</em> foi encerrada. <br> <br>
Pode obter o seu número de reserva neste endereço <a href="{$a->url}"></a>.';
$string['manage'] = 'Gerenciar';
$string['manualusers'] = 'Para reservas manuais exibir usuários do';
$string['maxoverbook'] = 'Porcentagem máxima de reservas excedentes';
$string['maxrequest'] = 'Máximo de reservas';
$string['message'] = 'Mensagem para os participantes';
$string['minduration'] = 'Duração mínima do evento';
$string['modulename'] = 'Reservas';
$string['modulename_help'] = '<p>O principal objetivo desta atividade é agendar/reservar período de laboratório e provas, mas você pode agendar tudo o que quiser. </p><p>O professor pode definir o número de lugares disponíveis para o evento, data do evento, data de abertura e fechamento da reserva.<br />Uma reserva pode ter uma nota ou uma avaliação predefinida em uma escala. <br />Os estudantes podem reservar/cancelar um lugar na reserva e adicionar uma anotação sobre essa reserva.</p><p>Após o início do evento, o professor pode avaliar o evento. Os estudantes serão notificados por e-mail. </p><p>A lista de reservas pode ser baixada em vários formatos.</p>';
$string['modulenameplural'] = 'Reservas';
$string['newlocation'] = 'Nova localização';
$string['noclashcheck'] = 'A verificação de conflitos não está ativada. Por favor, verifique junto ao administrador do site.';
$string['noclashes'] = 'Não foram encontrados conflitos de local e horário';
$string['nocourseswithnsections'] = 'Não foram encontradas seções para o curso {$a}';
$string['nolimit'] = 'Limite de reservas esgotado';
$string['nomorerequest'] = 'Não há mais lugares disponíveis';
$string['none'] = 'não foi encontrada nenhuma informação sobre este pedido de reserva';
$string['nooverbook'] = 'Não há reservas excedentes';
$string['noparent'] = 'Nenhum';
$string['noreservations'] = 'Não foram encontradas reservas para mostrar';
$string['note'] = 'Nota';
$string['noteachers'] = 'Não há professores disponíveis';
$string['notequal'] = 'não é igual a';
$string['notifies'] = 'Notificações enviadas';
$string['notifygrades'] = 'Notificar classificação das reservas para os estudantes';
$string['notifystudents'] = 'Notificar o término da reserva para  os estudantes';
$string['notifyteachers'] = 'Notificar o término da reserva para os professores';
$string['notopened'] = 'Fechado';
$string['novalues'] = 'Campo não preenchido';
$string['number'] = 'Número da reserva';
$string['numberafterclose'] = 'seu número de solicitação de reserva fechada';
$string['numberalways'] = 'seu número de solicitações de todas as reservas';
$string['optional'] = 'Opcional';
$string['otherlocation'] = 'Outro local especifico';
$string['overbook'] = 'Reservas excedentes';
$string['overbookonly'] = 'Lugares disponíveis apenas para reservas excedentes';
$string['overbookstep'] = 'Restam apenas reservas excedentes';
$string['overview'] = 'Visão global';
$string['parent'] = 'Conectar esta reserva com';
$string['pluginadministration'] = 'Administrar reservas';
$string['pluginname'] = 'Reservas';
$string['privacy:metadata:reservation_note'] = 'Gravar observações do usuário de uma solicitação de reserva';
$string['privacy:metadata:reservation_note:note'] = 'Nota do usuário para o pedido de reserva';
$string['privacy:metadata:reservation_request'] = 'Gravar dados do usuário de uma solicitação de reserva';
$string['privacy:metadata:reservation_request:grade'] = 'Classificação do pedido de reserva do usuário';
$string['privacy:metadata:reservation_request:grader'] = 'Identificação da classificação';
$string['privacy:metadata:reservation_request:mailed'] = 'Status da notificação enviado por e-mail';
$string['privacy:metadata:reservation_request:reservationid'] = 'Identificação da reserva';
$string['privacy:metadata:reservation_request:timecancelled'] = 'Data e hora de cancelamento da solicitação';
$string['privacy:metadata:reservation_request:timecreated'] = 'Data e hora de criação da solicitação';
$string['privacy:metadata:reservation_request:timegraded'] = 'Data e hora da solicitação da nota';
$string['privacy:metadata:reservation_request:userid'] = 'Identificação do usuário';
$string['publiclists'] = 'Lista pública das reservas';
$string['requestoverview'] = 'Visão geral de solicitações';
$string['requests'] = 'Solicitações';
$string['required'] = 'Obrigatório';
$string['reservation:addinstance'] = 'Adicionar uma nova reserva';
$string['reservation:downloadrequests'] = 'Lista de solicitações disponíveis para baixar';
$string['reservation:grade'] = 'Disponível  para atribuição de nota';
$string['reservation:manualdelete'] = 'Permitir exclusão de solicitações de outros usuários';
$string['reservation:manualreserve'] = 'Permitir envio de solicitações para outros usuários';
$string['reservation:reserve'] = 'Permitir envio somente de solicitações do próprio usuário';
$string['reservation:uploadreservations'] = 'Permitir realização de upload de reservas';
$string['reservation:viewnote'] = 'Permitir visualizar anotações das solicitações';
$string['reservation:viewrequest'] = 'Permitir visualizar a lista de solicitações';
$string['reservation_listing'] = 'Configurações do índice de página';
$string['reservation_other'] = 'Outras configurações';
$string['reservation_settings'] = 'Editando configurações';
$string['reservation_view'] = 'Visualizar configurações da página';
$string['reservationcancelled'] = 'Reserva cancelada';
$string['reservationclosed'] = 'Reserva fechada';
$string['reservationdenied'] = 'Reservas não permitidas';
$string['reservationevent'] = 'Criar um evento de curso com datas de fechamento em aberto  (tempo de reserva)';
$string['reservationnotopened'] = 'Reservas ainda não abertas';
$string['reservations'] = 'Reservas';
$string['reservationsettings'] = 'Configurações das reservas';
$string['reserve'] = 'Reserva';
$string['reservecancel'] = 'Cancelar reserva';
$string['reserved'] = 'Reservado';
$string['reservedon'] = 'Reservado em';
$string['reservedonconnected'] = 'Você possui um local reservado em uma reserva conectada: {$a}';
$string['reserversmail'] = 'Você está reservado para a reserva "{$a->reservation}".';
$string['reserversmailhtml'] = 'Você está reservado para a reserva <em>{$a->reservation}</em>.';
$string['resetreservation'] = 'Remover todas as reservas';
$string['save'] = 'Salvar nota';
$string['search:activity'] = 'Reserva - informação de atividade';
$string['selectvalue'] = 'Selecione um dos valores disponíveis';
$string['showrequest'] = 'Permitir aos usuários visualizarem a lista de solicitações';
$string['showuserrequest'] = 'Usuários podem ver';
$string['sortby'] = 'Ordenar lista de reservas por';
$string['sublimit'] = 'Sublimite {$a}';
$string['sublimitrules'] = 'Regras para sublimites de reservas';
$string['sublimits'] = 'Sublimites para reservas';
$string['timeclose'] = 'Reserva finalizada em';
$string['timeend'] = 'Data final';
$string['timeopen'] = 'Reserva iniciada em';
$string['timestart'] = 'Data de início';
$string['tools'] = 'Ferramentas para efetuar reservas';
$string['upload'] = 'Envio de reservas';
$string['upload_help'] = '<p>As reservas podem ser enviadas por meio de um arquivo de texto. O formato do arquivo deve ser o seguinte:</p><ul><li>Cada linha do arquivo deve conter somente um registro de reserva</li><li>Cada registro é uma série de dados separados por ponto e vírgula (ou outros delimitadores)</li><li>O primeiro registro contém uma lista de nomes de campos que definem o formato do restante do arquivo</li><li>Os nomes dos campos obrigatórios são: section, name e timestart</li><li>Os nomes dos campos opcionais são: course , intro, teachers, timeend, grade, timeopen, timeclose, maxrequest</li><li>Caso o nome do curso não seja especificado, ele deve ser escolhido após a visualização</li></ul>';
$string['uploadreservations'] = 'Reservas enviadas';
$string['uploadreservationspreview'] = 'Pré-visualização das reservas enviadas';
$string['uploadreservationsresult'] = 'Resultado das reservas enviadas';
$string['useralreadybooked'] = 'Usuário incluído';
$string['userevent'] = 'Criar um evento de usuário com as datas de início e término quando o usuário solicitar uma reserva';
$string['with'] = 'com';
$string['withselected'] = 'Com selecionado...';
$string['yourgrade'] = 'Sua nota referente a essa reserva é: {$a->grade}/{$a->maxgrade}';
$string['yournote'] = 'Sua anotação:';
$string['yourscale'] = 'Sua nota referente a essa reserva é: {$a}';
