<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'block_dash', language 'pt_br', version '4.3'.
 *
 * @package     block_dash
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accordionfield1'] = 'Campo superior esquerdo';
$string['accordionfield1icon'] = 'Ícone do campo superior esquerdo';
$string['accordionfield2'] = 'Campo superior direito';
$string['accordionfield2icon'] = 'Ícone de campo superior direito';
$string['accordionfield3'] = 'Campo inferior esquerdo';
$string['accordionfield3icon'] = 'Ícone do campo inferior esquerdo';
$string['accordionfield4'] = 'Campo inferior direito';
$string['accordionfield4icon'] = 'Ícone do campo inferior direito';
$string['achieved'] = 'Alcançou';
$string['activityprogress'] = 'Progresso (atividades concluídas/total)';
$string['activityprogressbar'] = 'Barra de progresso (atividades concluídas/total)';
$string['addcontent'] = 'Adicionar conteúdo';
$string['addjointable'] = 'Adicione {no} tabela de junção ao formulário';
$string['addnewfield'] = 'Adicionar novo campo';
$string['addtocontacts'] = 'Adicionar aos contatos';
$string['alpha_asc'] = 'Ordenar alfabeticamente de A-Z';
$string['alpha_desc'] = 'Ordenar alfabeticamente Z-A';
$string['anothertrailpath'] = 'Outra tentativa';
$string['arrows'] = 'Mostrar Setas';
$string['arrows_help'] = 'Exibir botões de seta para navegação de slide seguinte/anterior.';
$string['attribute'] = 'Atributo';
$string['auto'] = 'Automático';
$string['autoplay'] = 'Reprodução automática';
$string['autoplaySpeed'] = 'Velocidade de reprodução automática (ms)';
$string['autoplaySpeed_help'] = 'Defina a velocidade da reprodução automática em milissegundos.';
$string['autoplay_help'] = 'Reprodução automática';
$string['availablefields'] = 'Campos disponíveis';
$string['availablefields_help'] = 'Escolha todos os campos possíveis que esta fonte de dados utilizará. O usuário poderá selecionar quais campos incluir para seus próprios fins. Por exemplo, se você estiver exibindo informações do usuário, tente incluir tantos campos de usuário quanto possível.';
$string['backgroundcolor'] = 'Cor de fundo';
$string['backgroundgradient'] = 'Gradiente de fundo';
$string['backgroundgradient_help'] = 'Gerar um gradiente: <a href="https://cssgradient.io/" target="_blank">cssgradient.io</a> . Cole a propriedade background (gradiente linear)';
$string['backgroundimage'] = 'Imagem de fundo';
$string['backgroundimage_help'] = 'Preencher todo o fundo do bloco com esta imagem';
$string['backgroundimagefield'] = 'Imagem de fundo';
$string['backgroundimageurl'] = 'URL da imagem de fundo';
$string['backgroundposition'] = 'Posição de fundo';
$string['backgroundposition_help'] = 'A imagem de fundo será focada na posição fornecida';
$string['backgroundsize'] = 'Tamanho do fundo';
$string['backgroundsize_help'] = 'A imagem de fundo será exibida no tamanho';
$string['badgecolorfield'] = 'Campo de cor do selo';
$string['badgecolorfield_help'] = 'Escolha um campo que retorne as cores a serem usadas nos emblemas dos itens da linha do tempo.';
$string['badges'] = 'Emblemas';
$string['badgestitle'] = 'Emblemas';
$string['blocktitle'] = 'Título do bloco';
$string['blocktitle_help'] = 'Título exibido no cabeçalho do bloco. Insira um título curto e descritivo para o que este bloco exibe ao usuário.';
$string['blockwidth'] = 'Largura do bloco';
$string['bodyfield'] = 'Campo do Body';
$string['bootstrapversion'] = 'Versão de inicialização do tema';
$string['bootstrapversion_desc'] = 'Escolha a versão do Bootstrap que seu tema suporta. Moodle normalmente é 4 e Totara é 3.';
$string['border'] = 'Borda';
$string['border_help'] = 'Valor da propriedade da borda CSS. Defina como <b>nenhum</b> para não ter bordas.';
$string['border_option'] = 'Mostrar borda';
$string['border_option_help'] = 'Você pode adicionar a borda ao bloco.';
$string['bordervalue'] = 'Valor da borda';
$string['buildown'] = 'Construa o seu próprio';
$string['buildown_help'] = 'As fontes de dados são altamente configuráveis. Você pode usar as fontes de dados para diversos fins. Recursos de filtro, classificação e paginação são suportados';
$string['buynow'] = 'Comprar agora';
$string['categories'] = 'Categorias';
$string['categories_help'] = 'A fonte de dados de categorias lista as categorias disponíveis.';
$string['category'] = 'Nome da Categoria';
$string['categorycoursecount'] = 'Contagem dos Cursos';
$string['categoryimage'] = 'Imagem da Categoria';
$string['categoryimagelink'] = 'Link da Categoria';
$string['categoryimageurl'] = 'URL da imagem da Categoria';
$string['categoryimgcategory'] = 'Imagem para categoria {$a->category}';
$string['categoryimgdesc'] = 'Adicione imagens para as categorias';
$string['categoryimgfallback'] = 'Imagem de fallback de categoria';
$string['categoryimgfallbackdesc'] = 'Carregue a imagem para o fallback padrão de categorias. Se novas categorias forem criadas, a imagem fallback será exibida até que uma nova imagem seja adicionada para a categoria';
$string['categoryimgheading'] = 'Imagem da Categoria';
$string['categoryimgheadingsub'] = 'Categorias imagens';
$string['categoryurl'] = 'URL da categoria';
$string['centerMode'] = 'Modo central';
$string['centerMode_help'] = 'Ativa a visualização centralizada com slides anteriores/seguintes parciais. Use com contagens de slidesToShow numeradas ímpares.';
$string['centerPadding'] = 'Preenchimento central (px)';
$string['centerPadding_help'] = 'Preenchimento lateral no modo central (px).';
$string['centerbottom'] = 'Centro Inferior';
$string['centercenter'] = 'Centro Centro';
$string['centertop'] = 'Centro superior';
$string['certificatecodelinked'] = 'Código vinculado';
$string['choosedatasource'] = 'Escolha a fonte de dados';
$string['choosefeature'] = 'Escolha o recurso';
$string['choosefilter'] = 'Choose filter';
$string['chooseskill'] = 'Escolha a habilidade';
$string['circlepath'] = 'Círculo';
$string['cohorts'] = 'Coortes';
$string['columns'] = 'Colunas';
$string['columns_help'] = 'O número de colunas a serem exibidas por linha na grade.';
$string['compentenciesnotfound'] = 'Competência não encontrada.';
$string['competencyappearance'] = 'Aparições de competência';
$string['competencycolor'] = 'Cor da competência';
$string['competencyframework'] = 'Quadro de competências';
$string['competencyheading'] = 'Configurar a aparência da competência';
$string['competencyimage'] = 'Imagem de competência';
$string['completedactivities'] = 'Atividades concluídas';
$string['completedcourse'] = 'Curso concluído';
$string['completedlearningpath'] = 'Caminho de aprendizagem concluído. Bom trabalho!';
$string['completion:completed'] = 'Concluído';
$string['completion:inprogress'] = 'Em andamento';
$string['completion:notstarted'] = 'Ainda nao comecou';
$string['conditionaddfields'] = 'Adicione {nenhuma} condição(ões)';
$string['conditionsection'] = 'Configuração de condição';
$string['conditionstatichdr'] = 'Condição #0';
$string['conditionvalue'] = 'Valor';
$string['conditionvalue_help'] = 'Valor da condição – Insira o valor específico em relação ao qual a condição será verificada. Este valor é crucial para determinar quando a condição é atendida ou satisfeita. Insira os valores com vírgula (,) para condições IN';
$string['confirmleavegroup'] = 'Você realmente quer sair do grupo {$a}';
$string['contacts'] = 'Contatos';
$string['contentdisplay'] = 'Mostrar';
$string['contentdisplayallpage'] = 'Todas as páginas';
$string['contentdisplaysection'] = 'Páginas de seção';
$string['contenteditor'] = 'Contente';
$string['contentlayout'] = 'Layout de conteúdo';
$string['contentmodaltitle'] = 'Atualizar o conteúdo do painel';
$string['contentsectiondisplay'] = 'Exibir seções';
$string['contentsections'] = 'Seções a serem exibidas';
$string['contextid'] = 'Contexto';
$string['contextid_help'] = 'O contexto deste painel. Escolha um curso específico se você planeja limitar os resultados dos dados (exemplo: filtro "Curso atual"). Caso contrário, escolha Sistema para fins gerais.';
$string['contextmissing'] = 'Contexto ausente';
$string['course_enrol_role'] = 'Papel para inscrição usando o widget de inscrição';
$string['course_enrolments:abovecourseform'] = 'Acima dos cursos';
$string['course_enrolments:belowcourseform'] = 'Abaixo dos cursos';
$string['course_enrolments:disabled'] = 'Desabilitado';
$string['course_enrolments:displayaddcourse'] = 'Exibir formulário de adição de curso';
$string['course_enrolments:expandable'] = 'Expansível';
$string['course_enrolments:progress'] = 'Exibir progresso';
$string['course_enrols:viewotherprofiledash'] = 'Ver o bloco de traço do perfil de outros';
$string['course_enrols:viewprofiledash'] = 'Visualizar o bloco de traço do perfil';
$string['coursebutton'] = 'Botão curso';
$string['coursecategories'] = 'Categorias de cursos';
$string['coursecontent'] = 'Conteúdo do curso';
$string['coursedata:past'] = 'Passado';
$string['coursedate:future'] = 'Futuro';
$string['coursedate:present'] = 'Presente';
$string['coursedates'] = 'Datas do curso';
$string['courseimage'] = 'Imagem padrão do curso';
$string['courseimagedesc'] = 'Carregue a imagem do espaço reservado para exibir como imagem do curso para a imagem vazia do curso.';
$string['courseimagelink'] = 'Link da imagem do curso';
$string['courseoverviewfilesurl'] = 'URL da imagem do curso';
$string['courseredirecturl'] = 'URL de redirecionamento do curso';
$string['courseredirecturldesc'] = 'Insira o URL para redirecionar os usuários da página de índice do curso.';
$string['courseshopurl'] = 'URL da loja do curso';
$string['coursestafftitle'] = 'Equipe do curso';
$string['coursestartdate_asc'] = 'Por data de início do curso (o mais recente primeiro)';
$string['coursestartdate_desc'] = 'Por data de início do curso (o mais antigo primeiro)';
$string['coursesummary'] = 'Resumo do curso';
$string['courseurl'] = 'URL do curso';
$string['createcustomdatasource'] = 'Crie uma fonte de dados personalizada';
$string['createcustomlayout'] = 'Crie um layout personalizado';
$string['createdashboard'] = 'Criar painel';
$string['createlayout'] = 'Crie um layout personalizado';
$string['cssclass'] = 'Classe CSS';
$string['currentcourse'] = 'Curso atual';
$string['currentcoursecontext'] = 'Contexto atual do curso';
$string['currentcoursegroups'] = 'Grupos de cursos atuais';
$string['custom'] = 'Personalizado';
$string['customcondition'] = 'Consulta de condição personalizada';
$string['customdatasource'] = 'Fonte de dados personalizada';
$string['customdatasourcecreated'] = 'Fonte de dados <b>{$a->name}</b> criada com sucesso.';
$string['customdatasourcedeleted'] = 'Excluir fonte de dados personalizada';
$string['customdatasourceedited'] = 'Fonte de dados <b>{$a->name}</b> editada com sucesso.';
$string['customdatasources'] = 'Fontes de dados personalizadas';
$string['customfeaturetype'] = 'Tipo de recurso personalizado';
$string['customfield'] = '{$a->name}';
$string['customfields'] = 'Os campos personalizados';
$string['customlayoutcreated'] = 'Layout personalizado <b>{$a->name}</b> criado com sucesso.';
$string['customlayoutdeleted'] = 'Layout personalizado<b>{$a->name}</b> excluído com sucesso.';
$string['customlayoutedited'] = 'Layout personalizado <b>{$a->name}</b> editado com sucesso.';
$string['customsqlfield'] = 'Campo SQL';
$string['customsqlselect'] = 'Seleção SQL';
$string['dash:addinstance'] = 'Adicione um novo bloco Dash';
$string['dash:managedatasource'] = 'Gerenciar fontes de dados';
$string['dash:managewidget'] = 'Gerenciar widgets';
$string['dash:myaddinstance'] = 'Adicione um novo bloco Dash ao painel';
$string['dash:mygroups_addusers'] = 'Adicione usuários em grupos';
$string['dash:mygroups_creategroup'] = 'Criar grupos em cursos inscritos';
$string['dash:mygroups_leavegroup'] = 'Sair dos grupos';
$string['dash:mygroups_view'] = 'Ver meus próprios grupos';
$string['dash:mygroups_viewmembers'] = 'Ver membros em grupos atribuídos';
$string['dashaddoncontentdesc'] = 'Escolha um dos seguintes layouts';
$string['dashboard'] = 'Painel';
$string['dashboardcreated'] = 'Painel <<b>{$a->name}</b> criado com sucesso';
$string['dashboarddeleted'] = 'Painel <b>{$a->name}</b> excluído com sucesso';
$string['dashboardedited'] = 'Painel <b>{$a->name}</b> editado com sucesso';
$string['dashboardlink'] = 'Link do painel';
$string['dashboards'] = 'Painéis';
$string['databaseerror'] = 'Erro no banco de dados. O conteúdo não pode ser exibido.';
$string['datasource'] = 'Fonte de dados';
$string['datasource:competency_widget'] = 'Widget gráfico de habilidades';
$string['datasource:completion_widget'] = 'Widget de conclusões do curso';
$string['datasource:completions_data_source'] = 'Conclusões do curso';
$string['datasource:completions_data_source_help'] = 'Lista de cursos obrigatórios dos usuários.';
$string['datasource:courses_data_source'] = 'Cursos';
$string['datasource:courses_data_source_help'] = 'Lista de cursos disponíveis para o usuário atual.';
$string['datasource:dashboard_data_source'] = 'Painéis';
$string['datasource:dashboard_data_source_help'] = 'Lista de painel';
$string['datasource:enrolments_widget'] = 'Widget de inscrições';
$string['datasource:logstore_data_source'] = 'Registros do site';
$string['datasource:logstore_data_source_help'] = 'Fonte de dados de logs do site';
$string['datasourcedesc'] = 'Adicione conteúdo dinâmico com fontes de dados e layouts';
$string['datasourcemissing'] = 'Fonte de dados ausente';
$string['datasourcename'] = 'Nome da fonte de dados';
$string['datasources'] = 'Fontes de dados';
$string['datecompleted'] = 'Data de conclusão';
$string['daysuntilend'] = 'Dias até a data de término';
$string['daysuntilstart'] = 'Dias até a data de início';
$string['defaultexportdata'] = 'Dash export data';
$string['defaultexportdata_help'] = 'Esta configuração permite que a configuração ative/desative os dados de exportação da fonte de dados do painel.';
$string['defaultsortdirection'] = 'Direção de classificação';
$string['defaultsortfield'] = 'Ordenar por';
$string['defaultsortfield_help'] = 'Classifique os resultados do banco de dados por este campo. Se o layout suportar a classificação do usuário, este será o padrão.';
$string['delete'] = 'Excluir';
$string['deletecondition'] = 'Excluir esta condição';
$string['deleteconfirm'] = 'Tem certeza de que deseja excluir o painel <b>{$a->name}</b> ?';
$string['deleteconfirmcustomdatasource'] = 'Tem certeza de que deseja excluir a fonte de dados personalizada <b>{$a->name}</b> ?';
$string['deleteconfirmcustomlayout'] = 'Tem certeza de que deseja excluir o layout personalizado <b>{$a->name}</b> ?';
$string['deletecustomdatasource'] = 'Excluir fonte de dados personalizada';
$string['deletecustomlayout'] = 'Excluir layout personalizado';
$string['deletedashboard'] = 'Excluir painel';
$string['deletefield'] = 'Excluir este campo';
$string['deletejoin'] = 'Excluir esta tabela de junção';
$string['details_area'] = 'Área de detalhes';
$string['details_area_help'] = 'Escolha como deseja exibir a área de detalhes.';
$string['details_area_locations'] = 'Detalhes da localização da área';
$string['details_area_locations_help'] = 'Insira os detalhes de cada local que deseja exibir na área de detalhes.';
$string['details_area_size'] = 'Tamanho da área de detalhes';
$string['details_area_size_help'] = 'Escolha como deseja dimensionar a área de detalhes.';
$string['details_bg_color'] = 'Detalhes Cor de fundo';
$string['details_body_1'] = 'Details Body 1';
$string['details_body_2'] = 'Details Body 2';
$string['details_body_3'] = 'Details Body 3';
$string['details_footer_left'] = 'Details Footer left';
$string['details_footer_right'] = 'Details Footer right';
$string['details_text_color'] = 'Detalhes Cor do texto';
$string['details_title'] = 'Details Title';
$string['developerfield'] = '{$a}';
$string['developerfieldid'] = 'id';
$string['disableall'] = 'Desative todas as saídas do Dash';
$string['disableall_help'] = 'Aviso: Para fins de solução de problemas ou solução de problemas de páginas quebradas';
$string['disableallmessage'] = 'A saída do Dash está desativada. Verifique as configurações do Dash.';
$string['dots'] = 'Mostrar pontos';
$string['dots_help'] = 'Exibir indicadores de pontos para navegação de slides.';
$string['downloadcsv'] = 'Baixe em formato CSV';
$string['draggable'] = 'Arrastável';
$string['draggable_help'] = 'Permite arrastar e mover slides.';
$string['dragitem'] = 'Arrastar item';
$string['duedate'] = 'Data de entrega';
$string['edit'] = 'Editar';
$string['editcontent'] = 'Editar conteúdo';
$string['editcustomdatasource'] = 'Editar fonte de dados';
$string['editcustomlayout'] = 'Editar layout personalizado';
$string['editdashboard'] = 'Editar painel';
$string['editpreferences'] = 'Edite preferencias';
$string['editthisblock'] = 'Edite as configurações deste bloco para finalizar a configuração.';
$string['edituserenrolment'] = 'Editar a inscrição de {$a}';
$string['emptystateheading'] = 'Estado vazio';
$string['enableconditions'] = 'Habilitar condições';
$string['enabledconditions'] = 'Limitar os dados a';
$string['enabledfields'] = 'Campos habilitados';
$string['enabledfilters'] = 'Filtros ativados';
$string['enabledownload'] = 'Export data';
$string['enabledownload_help'] = 'This setting enables users to download the data in both CSV and XLS formats.';
$string['enablejoins'] = 'Habilitar junções';
$string['enroldate_asc'] = 'Classificar por data de inscrição (o mais antigo primeiro)';
$string['enroldate_desc'] = 'Classificar por data de inscrição (mais recente primeiro)';
$string['enroldetails'] = 'Detalhes de inscrição';
$string['enroled'] = 'Inscrito';
$string['enrollment'] = 'Inscrição';
$string['enrollment_options'] = 'Opções de inscrição';
$string['enrollmentmethod'] = 'Método de inscrição';
$string['enrollmentmethodstatus'] = 'Status do método de inscrição';
$string['enrollmentoptions'] = 'Métodos de inscrição';
$string['enrollmentoptions:cost'] = 'De {$a->currency} {$a->cost}';
$string['enrollmentoptions:credits'] = '{$a} créditos';
$string['enrollmentoptions:free'] = 'Livre';
$string['enrollmentoptions:fromcredits'] = 'De {$a} créditos';
$string['enrollmentoptions:seeoptions'] = 'Ver opções';
$string['enrollments'] = 'Inscrições';
$string['enrollmentself'] = 'Autoinscrições';
$string['enrollmentsnotself'] = 'Inscrições não próprias';
$string['enrollmentstatus'] = 'Status da inscrição';
$string['enrollmenttimeend'] = 'Data final da inscrição';
$string['enrollmenttimestart'] = 'Data de início da inscrição';
$string['enrolmentmethod'] = 'Método de inscrição';
$string['enrolnow'] = 'Inscreva-se agora';
$string['event_desc_core_event_user_enrolment_created'] = '{$a->relateduserfullname} foi inscrito em <a href="{$a->eventurl}" title="Ver {$a->contextname}">{$a->contextname}</a>';
$string['event_desc_generic'] = '{$a->userfullname} {$a->action} <a href="{$a->eventurl}" title="Ver {$a->contextname}">{$a->contextname}</a>';
$string['eventbutton'] = 'Botão de evento';
$string['eventclass'] = 'Classe de evento';
$string['eventcolor'] = 'Cor do evento';
$string['eventdescription'] = 'Descrição do Evento';
$string['eventicon'] = 'Ícone do evento';
$string['eventlink'] = 'Link do evento';
$string['events'] = 'Eventos';
$string['eventtime'] = 'Hora do evento';
$string['eventurl'] = 'URL do evento';
$string['extracontent'] = 'Conteúdo extra';
$string['fade'] = 'Desaparecer';
$string['fade_help'] = 'Ativa o efeito fade na transição de slides.';
$string['field'] = 'Campo';
$string['fieldalert'] = 'O layout escolhido não pode ser personalizado';
$string['fieldattributeshdr'] = 'Transformar formato de dados de campo';
$string['fieldcustomdata'] = 'Valor de formato adicional';
$string['fieldcustomdata_help'] = 'Insira os dados adicionais relacionados ao atributo selecionado
<b>Por exemplo: </b>
1. Para o atributo link, insira o link e use os valores dos campos como parâmetros <br>
2. Para o atributo percentual, use o valor fora de. Para as notas use 10 caso contrário usa 100';
$string['fieldname'] = 'Nome do campo';
$string['fieldnotfound'] = 'Campo não encontrado.';
$string['fields'] = 'Campos';
$string['fieldselect'] = 'Seleção de campo SQL';
$string['fieldssection'] = 'Configuração de campos';
$string['fieldstatichdr'] = 'Campo #0';
$string['fieldtransformdata'] = 'Transforme o formato';
$string['fieldtransformdata_help'] = 'Transformar o formato do valor quando exibido na tabela';
$string['fit_content'] = 'Ajustar conteúdo';
$string['fit_content_help'] = 'Faça com que a altura da área de detalhes seja igual à do cartão e deixe a largura ser determinada pelo conteúdo.';
$string['fontcolor'] = 'Cor da fonte';
$string['fontcolor_help'] = 'Propriedade de cor da fonte CSS (por exemplo, #ffffff, rgb(255, 255, 255), etc)';
$string['footercontent'] = 'Conteúdo do rodapé';
$string['footercontent_help'] = 'Conteúdo exibido no rodapé do bloco.';
$string['footerfield'] = 'Campo de rodapé';
$string['footerrightfield'] = 'Campo de rodapé (direita)';
$string['fullnamelinked'] = 'Nome completo (vinculado ao perfil)';
$string['generalsettings'] = 'Configurações Gerais';
$string['generateattributes'] = 'Gerar atributos de campo';
$string['generatefields'] = 'Gerar campos';
$string['gotoevent'] = 'Ir para o evento';
$string['gridsizeoptions'] = 'Wide Tall Square';
$string['groupby'] = 'Agrupar por';
$string['grouplabel'] = 'Rótulo do grupo';
$string['headercontent'] = 'Conteúdo do cabeçalho';
$string['headercontent_help'] = 'Conteúdo exibido no cabeçalho do bloco.';
$string['headerfooter'] = 'Cabeçalho rodapé';
$string['headingfield'] = 'Campo de título';
$string['hidecoursecategory'] = 'Não mostrar índice de categoria/curso';
$string['hidecoursecategorydesc'] = 'When a user tries to access the URL /course/index.php, they will be automatically
redirected to the site\'s home page, unless a custom URL is specified below.
If a URL is specified, users shall be redirected to that URL';
$string['hidemycourses'] = 'Ocultar meus cursos inscritos';
$string['hidetable'] = 'Oculte o conteúdo da tabela.';
$string['hidetable_help'] = 'Habilitar esta opção permite que os usuários ocultem o conteúdo da tabela na instância do painel. Apenas os blocos de cabeçalho e rodapé permanecerão visíveis.';
$string['hidewhenempty'] = 'Ocultar quando vazio';
$string['iconfield'] = 'Campo de ícone';
$string['imageoverlayfield'] = 'Campo de sobreposição de imagem';
$string['imageoverlayfield_help'] = 'Conteúdo a ser exibido sobre imagem com fundo sólido.';
$string['imageurlfield'] = 'Campo URL da imagem';
$string['imageurlfield_help'] = 'Escolha um campo de URL de imagem que será usado em cada cartão da grade.';
$string['includesubcategories'] = 'Incluir subcategorias';
$string['includesubcategories_help'] = 'Se marcada, as subcategorias das categorias escolhidas também serão incluídas nos resultados.';
$string['infinite'] = 'Loop infinito';
$string['infinite_help'] = 'Permite deslizamento de loop infinito.';
$string['invalididnumberunique'] = 'O número de identificação já existe.';
$string['invalidoperator'] = 'Operador inválido {$a->operator}.';
$string['invalidshortname'] = 'Nome abreviado inválido. Deve conter apenas letras a-zA-Z ou hífens (-).';
$string['invalidshortnametoolong'] = 'Nome abreviado inválido. Deve ter 16 caracteres ou menos.';
$string['invalidshortnameunique'] = 'Este nome abreviado já é usado por outro painel.';
$string['invalidwhereclause'] = 'Cláusula where inválida. Nenhum valor fornecido.';
$string['label'] = 'Rótulo';
$string['layout'] = 'Disposição';
$string['layoutaccordion'] = 'Layout de acordeão (com mesas)';
$string['layoutaccordion2'] = 'Layout de acordeão';
$string['layoutcards'] = 'Layout de grade';
$string['layoutdoesnotsupportfiltering'] = 'O layout escolhido não suporta filtragem';
$string['layoutdoubleequal'] = 'Dupla igual';
$string['layoutdoubleleft'] = 'Duplo (1/3, 2/3)';
$string['layoutdoubleright'] = 'Duplo (2/3, 1/3)';
$string['layoutfull'] = 'Layout completo';
$string['layoutgrid'] = 'Layout da mesa';
$string['layoutmode'] = 'Layout mode';
$string['layoutmode_help'] = 'Select which mode appers on the widget';
$string['layoutonestat'] = 'Uma figura + layout de etiqueta';
$string['layouttimeline'] = 'Layout da linha do tempo';
$string['layouttriple'] = 'Triplo igual';
$string['layouttwostat'] = 'Layout de uma figura/outra figura';
$string['layouttype'] = 'Tipo de layout';
$string['like_item'] = 'Curtir item';
$string['like_item_help'] = 'Deixe a área de detalhes do mesmo tamanho do cartão.';
$string['loggedinuser'] = 'Usuário logado';
$string['maintable'] = 'Selecione a tabela principal <b>(mnt)</b>';
$string['maintable_help'] = 'Escolha a tabela principal para geração de campos';
$string['maintablenotconfigured'] = 'Tabela principal não configurada para a fonte de dados do desenvolvedor';
$string['managecustomdatasources'] = 'Gerenciar fontes de dados personalizadas';
$string['managedashboards'] = 'Gerenciar painéis';
$string['managedatasources'] = 'Gerenciar fontes de dados';
$string['managelayouts'] = 'Gerenciar layouts';
$string['masonrycustomfield'] = 'Dash settings';
$string['maxlimit'] = 'Limitar a';
$string['maxlimit_help'] = 'Limite os resultados da consulta a esse valor máximo.';
$string['messageurl'] = 'URL da mensagem';
$string['minheight'] = 'Altura mínima';
$string['minheight_help'] = 'Altura mínima em pixels para bloco.';
$string['missingmustachetemplate'] = 'Falta Modelo Mustache';
$string['mustachetemplate'] = 'Modelo Mustache';
$string['mydashboards'] = 'Meus painéis';
$string['myenrolledcourses'] = 'Meus cursos inscritos';
$string['myparticipants'] = 'Meus participantes/estudantes';
$string['newblock'] = 'Novo traço';
$string['nocontactsavailable'] = 'Nenhum contato disponível';
$string['nocourses'] = 'Nenhum curso disponível';
$string['nodashboardsforuser'] = 'Nenhum painel está disponível no momento.';
$string['nogroupsavailable'] = 'Nenhum grupo disponível';
$string['none'] = 'Nenhum';
$string['nonpublicdashboards'] = 'Ocultar painéis públicos';
$string['notachieved'] = 'Não alcançado';
$string['notauthorized'] = 'Você não tem acesso a este painel.';
$string['notavailable'] = 'Não disponível';
$string['openmodule'] = 'Módulo aberto';
$string['operator'] = 'Operador';
$string['operatorcondition'] = 'Doença';
$string['operatorcondition_help'] = 'Operador Conjuntivo - Escolha entre "AND" e "OR" para definir como múltiplas condições são combinadas.
- "AND" exige que todas as condições sejam verdadeiras para que a condição geral seja atendida.
- "OR" exige que pelo menos uma das condições seja verdadeira para que a condição geral seja atendida.';
$string['operatorequal'] = '=';
$string['operatorgreaterthan'] = '>';
$string['operatorgreaterthanequal'] = '>=';
$string['operatorin'] = 'IN (...)';
$string['operatorinquery'] = 'IN (Query)';
$string['operatorlessthan'] = '<';
$string['operatorlessthanequal'] = '<=';
$string['operatorlike'] = 'LIKE';
$string['operatorlikebetween'] = 'LIKE %..%';
$string['operatornotequal'] = '!=';
$string['operatornotin'] = 'NOT IN (...)';
$string['operatornotlike'] = 'NOT LIKE';
$string['otheraddons'] = 'Outros complementos';
$string['pagination_summary'] = 'Mostrando  {$a->limit_from} - {$a->limit_to} of {$a->total}';
$string['parentrole'] = 'Usuários que eu gerencio';
$string['parentrole_help'] = 'Inclui apenas usuários que o usuário atual tem um papel atribuído. Consulte  <a href="https://docs.moodle.org/39/en/Parent_role" target="_blank">Papel pai</a>.';
$string['parseerror'] = 'Erro de análise. O conteúdo não pode ser exibido.';
$string['participationnotcurrent'] = 'Não atual';
$string['permissions'] = 'Restringir o acesso a';
$string['permissionscohort'] = 'Coorte';
$string['permissionsloggedin'] = 'Deve estar logado';
$string['permissionspublic'] = 'Público';
$string['perpage'] = 'Por página';
$string['perpage_help'] = 'Número de cartões a serem exibidos em grade por página.';
$string['persistenttablealias'] = 'Tabela personalizada';
$string['pictureofuserlinked'] = 'Foto do usuário (vinculada ao perfil)';
$string['pictureofuserurl'] = 'URL da imagem do usuário';
$string['placeholderfields'] = 'Campos de espaço reservado';
$string['placeholderfields_help'] = 'Selecione os campos e use-os no campo valores personalizados adicionais com {field_name}, que serão substituídos pelos valores correspondentes.';
$string['pluginname'] = 'Dash';
$string['privacy:metadata'] = 'O bloco Dash mostra apenas informações sobre os cursos e não armazena dados em si.';
$string['proficient'] = 'Proficiente';
$string['progress_help'] = 'Exibir o progresso de conclusão do curso';
$string['promotionoptions'] = 'Destaque Normal Esmaecido';
$string['querydebug'] = 'Depuração de consulta';
$string['querytemplate'] = 'Modelo de consulta';
$string['querytemplate_help'] = 'Esta consulta será usada para';
$string['querytemplateinstructions'] = 'Espaços reservados: <ul><li><b>%%SELECT%%</b> - substituídos por todas as seleções com base nas definições de campo. Não inclua suas próprias seleções!</li><li><b>%%WHERE%%</b> - Substituído por cláusulas geradas a partir de filtros. Você pode adicionar mais cláusulas com segurança anexando AND após %%WHERE%%</li><li><b>%%GROUPBY%%</b> - Substituído por campo(s) de agrupamento dependendo da fonte de dados</li> <li><b>%%ORDERBY%%</b> - Substituído pela classificação padrão ou classificação selecionada pelo usuário (clicando no cabeçalho da coluna em uma tabela, por exemplo)</li></ul>';
$string['querytemplatetip'] = 'Dica: pressione Ctrl + Espaço para mostrar intellisense/autocomplete ao digitar sua consulta.';
$string['readymatewidgets'] = 'Widgets prontos para usar';
$string['readymatewidgets_help'] = 'Use os widgets abaixo, os widgets são fáceis de usar, não há necessidade de definir configurações adicionais.';
$string['rows'] = 'Linhas';
$string['rows_help'] = 'Número de linhas a serem exibidas ao usar várias linhas com a opção slidesPerRow.';
$string['savechanges'] = 'Salvar alterações';
$string['secondarynav'] = 'Adicionar à navegação do curso';
$string['selectlayout'] = 'Selecione o layout do conteúdo nas preferências para adicionar conteúdo';
$string['showhiddencourses'] = 'Mostrar cursos ocultos';
$string['slidesPerRow'] = 'Slides por linha';
$string['slidesPerRow_help'] = 'Número de slides a serem exibidos em uma linha.';
$string['slidesToScroll'] = 'Slides para rolar';
$string['slidesToScroll_help'] = 'Número de slides para rolar de uma vez.';
$string['slidesToShow'] = 'Slides para mostrar';
$string['slidesToShow_help'] = 'Número de slides a serem exibidos de uma vez.';
$string['smart_coursebutton'] = 'Botão de curso inteligente';
$string['sortalpha'] = 'Alfabeticamente';
$string['sortcoursestartdate'] = 'Data de início do curso';
$string['sortenrolmentdate'] = 'Data de inscrição';
$string['source'] = 'Fonte';
$string['speed'] = 'Velocidade de transição (ms)';
$string['speed_help'] = 'Defina a velocidade da transição do slide em milissegundos.';
$string['stattodisplay'] = 'Figura para exibir';
$string['stattodisplayother'] = 'Outra figura para exibir';
$string['status'] = 'Status';
$string['status:all'] = 'Todos';
$string['status:completed'] = 'Concluído';
$string['status:enrolled'] = 'Inscrito';
$string['status:inprogress'] = 'Em andamento';
$string['status:notyetstarted'] = 'Ainda nao comecou';
$string['strasc'] = 'Asc';
$string['strcssclass'] = 'CSS classes';
$string['strdatasource'] = 'datasource';
$string['strdesc'] = 'Desc';
$string['strdisabled'] = 'Desabilitado';
$string['strexpanding'] = 'Expandindo';
$string['strfloating'] = 'Flutuando';
$string['strgrid'] = 'Grade';
$string['strgridsize'] = 'Tamanho da grade';
$string['strinfo'] = 'Info';
$string['strmasonry'] = 'Masonry';
$string['strmasonrysearch'] = 'Caixa de pesquisa';
$string['strmasonrysort'] = 'Ordenação';
$string['strmodal'] = 'Modal';
$string['strpromotion'] = 'Promoção';
$string['strslider'] = 'Slider';
$string['styleoptions'] = 'Opções de estilo';
$string['styleoptions_help'] = 'Para aplicar estilos individuais aos itens, você pode usar campos personalizados. Escolha os campos personalizados que você deve aplicar como classe CSS ao item da grade. Nota: Você mesmo deve criar estilos CSS, o Dash não vem com estilos CSS predefinidos (mas planejamos adicioná-los na próxima versão).';
$string['subheadingfield'] = 'Campo de subtítulo';
$string['subheadingfieldicon'] = 'Ícone de subtítulo';
$string['suggestcohort'] = 'Sugerir usuários que tenham o mesmo coorte';
$string['suggestcohort_desc'] = 'Exibir os usuários com os mesmos interesses, bloco de lista de contatos de usuários';
$string['suggestcontacts'] = 'Contatos sugeridos';
$string['suggestgroups'] = 'Sugira usuários que tenham os mesmos grupos';
$string['suggestgroups_desc'] = 'Exibir os usuários com os mesmos interesses, bloco de lista de contatos de usuários';
$string['suggestinterests'] = 'Sugira usuários que tenham os mesmos interesses';
$string['suggestinterests_desc'] = 'Exibir os usuários com os mesmos interesses, bloco de lista de contatos de usuários';
$string['suggestion:cohort'] = 'Também membro de {$a->cohort}';
$string['suggestion:groups'] = 'No seu grupo {$a->group}';
$string['suggestion:interest'] = 'Também interessado em {$a->interest}';
$string['suggestion:users'] = 'Recomendado neste site';
$string['suggestusers'] = 'Sugerir usuários que tenham os mesmos usuários';
$string['suggestusers_desc'] = 'Exibir os usuários com os mesmos interesses, bloco de lista de contatos de usuários';
$string['supportsfieldvisibility'] = 'Suporta visibilidade de campo';
$string['supportsfieldvisibility_help'] = 'Quando ativado, permite que o administrador habilite e desabilite condicionalmente os campos.';
$string['supportsfiltering'] = 'Suporta filtragem';
$string['supportsfiltering_help'] = 'Quando ativado, permite filtrar resultados. Isso é tratado pela fonte de dados.';
$string['supportspagination'] = 'Suporta paginação';
$string['supportspagination_help'] = 'Quando ativado, os resultados serão paginados automaticamente. A barra de paginação será exibida.';
$string['supportssorting'] = 'Suporta classificação';
$string['supportssorting_help'] = 'Quando habilitado, a ordenação é permitida (somente com tabelas).';
$string['swipeToSlide'] = 'Deslize para deslizar';
$string['swipeToSlide_help'] = 'Permite deslizar/arrastar para deslizar até o slide mais próximo após soltar o toque.';
$string['system'] = 'Sistema';
$string['tabconditions'] = 'Condições';
$string['tabfields'] = 'Campos';
$string['tabfilters'] = 'Filtros';
$string['tabgeneral'] = 'Em geral';
$string['tablealias_c'] = 'Curso';
$string['tablealias_cc'] = 'Categoria do curso';
$string['tablealias_ccp'] = 'Conclusão do curso';
$string['tablealias_dd'] = 'Painel';
$string['tablealias_e'] = 'Método de inscrição';
$string['tablealias_g'] = 'Grupo';
$string['tablealias_sl'] = 'Registros do site';
$string['tablealias_u'] = 'Do utilizador';
$string['tablealias_ue'] = 'Cadastro de usuário';
$string['tablejoin'] = 'Selecione Unir tabela';
$string['tablejoin_help'] = 'Escolha a tabela para unir à tabela principal. Use o alias para condições.';
$string['tablejoinon'] = 'Insira a consulta de condição para ingressar';
$string['tablejoinsalias'] = 'Alias de tabela';
$string['tablejoinshdr'] = 'Unir tabelas';
$string['tablejoinstatichdr'] = 'Tabela conjunta #{$a}';
$string['tags'] = 'Tag';
$string['textcolor'] = 'Cor do texto';
$string['timesinceevent'] = 'Tempo desde o evento';
$string['titleoverride'] = 'Substituição de título';
$string['totalactivities'] = 'Atividades totais';
$string['totalactivitiescompletion'] = 'Total de atividades (conclusão relevante)';
$string['transformformat'] = 'Formato de transformação de {$a}';
$string['userprofilelink'] = 'Link do perfil do usuário';
$string['userprofileurl'] = 'URL do perfil de usuário';
$string['users'] = 'Usuários';
$string['users_help'] = 'A fonte de dados de usuários exibe a lista de usuários disponíveis no LMS';
$string['userscompleted'] = 'Usuários concluídos';
$string['usersnotcompleted'] = 'Usuários não concluídos';
$string['userstat'] = 'Estatística do usuário';
$string['variableWidth'] = 'Largura variável';
$string['variableWidth_help'] = 'Permite slides de largura variável.';
$string['vertical'] = 'Vertical';
$string['verticalSwiping'] = 'Deslizar verticalmente';
$string['verticalSwiping_help'] = 'Permite deslizar/arrastar verticalmente os slides.';
$string['vertical_help'] = 'Orientação vertical do slide.';
$string['viewcourse'] = 'Ver curso';
$string['viewdetails'] = 'Ver detalhes';
$string['viewprofile'] = 'Ver perfil';
$string['widget'] = 'Ferramenta';
$string['widget:course_completions'] = 'Conclusões do curso';
$string['widget:course_completions_help'] = 'Relatório de progresso do curso.';
$string['widget:course_enrols'] = 'Widget de inscrições';
$string['widget:course_enrols_help'] = 'Exibir a lista de cursos inscritos com progresso de conclusão';
$string['widget:groups:adduser'] = 'Adicionar usuário';
$string['widget:groups:chat'] = 'Chat';
$string['widget:groups:creategroup'] = 'Criar grupo';
$string['widget:groups:groupmembers'] = 'Ver membros';
$string['widget:groups:leavegroup'] = 'Deixar o grupo';
$string['widget:mycontacts'] = 'Meus contatos';
$string['widget:mycontacts_help'] = 'Lista de usuários disponíveis na lista de contatos.';
$string['widget:mygroups'] = 'Meus grupos';
$string['widget:mygroups_help'] = 'Lista de grupos atribuídos ao usuário, pode visualizar outros membros do grupo, adicionar membros ao grupo, sair dos grupos e muito mais';
$string['widget:mylearning'] = 'Meu aprendizado';
$string['widget:mylearning_help'] = 'Lista de cursos inscritos por usuários com informações básicas do curso, como equipes e crachás disponíveis e lista de seções e módulos do curso';
$string['widget:skill_graph'] = 'Gráfico de habilidades';
$string['widget:skill_graph_help'] = 'Relatório de detalhamento de competências';
$string['widgetsdesc'] = 'Escolha um widget de conteúdo pronto para uso e configure-o';
$string['withroles'] = 'Com papel(is)';
