<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'enrol_authorize', language 'sk', version '4.3'.
 *
 * @package     enrol_authorize
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['adminacceptccs'] = 'Aké typy kreditných kariet prijaté?';
$string['adminaccepts'] = 'Určte povolené platobné metódy a ich typy.';
$string['adminauthorizeccapture'] = 'Kontrola a automatické spracovanie transakcií.';
$string['adminauthorizeemail'] = 'E-mailove upozorňovanie';
$string['adminauthorizesettings'] = 'Nastavenie Authorize.net konta obchodníka';
$string['adminauthorizewide'] = 'Globálne nastavenia';
$string['adminconfighttps'] = 'Prosím zaistite, že máte "<a href="{$a->url}"> zapnuté loginhttps ON</a>" na spustenie tohto plugin<br />in Správa >> Premenné >> Bezpečnosť >> Bezpečnosť HTTP.';
$string['adminconfighttpsgo'] = 'Na konfiguráciu tohto pluginu choďte na <a href="{$a->url}">zabezpečenú stránku</a>';
$string['admincronsetup'] = 'Skript cron.php, ktorý má na starosti bežnú údržbu serveru, nebol behom posledných 24 hodín spustený.<br />Ak chcete používať automatické spracovanie transakcií, musí byť cron v prevádzke.<br /><b>Povoľte</b> zápis cez \'Authorize.net zásuvný modul\' a nastavte správne<b> cron</b>, alebo opäť <b>zrušte voľbu an_review</b>. <br />Pokiaľ deaktivujete automatické spracovanie transakcií, budú transakcie zrušené, ak ich nespracujete do 30 dní.<br />Zaškrtnite voľbu <b>an_review</b> a vložte <b>\'0\' (nulu)</b> do poľa <b>an_capture_day</b>,<br />ak chcete transakcie potvrdiť/zamietnuť <b>ručne</b> behom 30 dní od podania.\';';
$string['adminemailexpiredsort'] = 'Čím sa riadi upozorňovanie na transakcie s blížiacim sa koncom lehoty pre uskutočnenie.';
$string['adminemailexpiredsortcount'] = 'Počet transakcií';
$string['adminemailexpiredsortsum'] = 'Celkový súčet množstva';
$string['adminemailexpsetting'] = '(0=neposielať e-mail, prednastavenia=2, maximum=5)<br />(Nastavenie pre e-mailové upozornenie pri ručnom spracovaní transakcií: cron=v prevádzke, an_review=začiarknuté, an_capture_day=0, an_emailexpired=1-5)';
$string['adminhelpcapturetitle'] = 'Deň automatického spracovania transakcií';
$string['adminhelpreviewtitle'] = 'Kontrola objednávky';
$string['adminneworder'] = 'Administrátor,

dostali ste novú objednávku na spracovanie:

ID požiadavky: {$a->orderid}
ID transakcie: {$a->transid}
Používateľ: {$a->user}
Kurz: {$a->course}
Množstvo: {$a->amount}

STAV SLUŽBY AUTOMATICKÉHO SPRACOVANIA TRANSAKCIÍ: {$a->acstatus}

Ak je aktivované automatické spracovanie transakcií, bude úhrada kreditnou kartou uskutočnená {$a->captureon} a používateľ bude následne zapísaný do kurzu; inak lehota pre transakciu vyprší {$a->expireon} a po to tomto dni nebude mozné platbu uskutočniť.

Platbu a zápis používateľa do kurzu môžeme tiež potvrdiť/zamietnuť na tejto adrese {$a->url}';
$string['adminnewordersubject'] = '{$a->course}; Nová objednávka na spracovenie: {$a->orderid}';
$string['adminpendingorders'] = 'Deaktivovali ste si automatické spracovanie transakcií. <br />Spolu {$a->count} transakcií s štatútom \'autorizované/rezervované\' bude zrušených, pokiaľ ich neskontrolujete. <br />K akceptovaniu/zamietnutiu platieb, choďte na stránku <a href=\'{$a->url}\'>Správa platieb</a>';
$string['adminteachermanagepay'] = 'Učitelia môžu spravovať platby za kurz.';
$string['allpendingorders'] = 'Všetky čakajúce objednávky';
$string['amount'] = 'Množstvo';
$string['anauthcode'] = 'Získať autorizačný kód';
$string['anauthcodedesc'] = 'Ak kreditná karta používateľa nemôže byť zachytená priamo na Internete, získajte autorizačný kód telefonicky z banky klienta.';
$string['anavs'] = 'Adresový verifikačný systém';
$string['ancaptureday'] = 'Zachytiť deň';
$string['anemailexpired'] = 'Upozornenie na ukončenie platnosti.';
$string['anemailexpiredteacher'] = 'Upozornenie na ukončenie platnosti - Učiteľ';
$string['anlogin'] = 'Authorize.net: Prihlasovacie meno';
$string['anpassword'] = 'Authorize.net: Heslo ';
$string['anreferer'] = 'Referer';
$string['anreview'] = 'Prehľad';
$string['anreviewdesc'] = 'Prehľad objednávky pred spracovaním kreditnej karty.';
$string['antestmode'] = 'Testovací režim';
$string['antestmodedesc'] = 'Spustiť transakcie iba v testovacom móde. (peniaze nebudú stiahnuté)';
$string['antrankey'] = 'Authorize.net: Kľúč transakcie';
$string['approvedreview'] = 'Prehľad schválených';
$string['authcaptured'] = 'Autorizované/rezervované';
$string['authcode'] = 'Kód autorizácie';
$string['authorize:config'] = 'Konfigurovať inštancie zápisu Authorize.Net';
$string['authorize:manage'] = 'Spravovať zapísaných účastníkov kurzu';
$string['authorize:managepayments'] = 'Správa platieb';
$string['authorize:unenrol'] = 'Odhlásiť účastníkov z kurzu';
$string['authorize:unenrolself'] = 'Odhlásiť sa z kurzu';
$string['authorize:uploadcsv'] = 'Nahrať CSV súbor';
$string['authorizedpendingcapture'] = 'Autorizované/rezervované';
$string['authorizeerror'] = 'Authorize.Net chyba: {$a}';
$string['avsa'] = 'Adresa (ulica) súhlasia, ale PSČ nie';
$string['avsb'] = 'Neboli zadané údaje o adrese';
$string['avse'] = 'Chyba kontrolného systému AVS';
$string['avsg'] = 'Banka vydávajúca karty nesídli v USA';
$string['avsn'] = 'Adresa (ulica) ani PSČ nesúhlasia';
$string['avsp'] = 'Nemožno použiť kontrolu pomocou AVS';
$string['avsr'] = 'Opakujte - systém je nedostupný, alebo vypršal časový limit žiadosti';
$string['avsresult'] = 'Výsledok AVS kontroly: {$a}';
$string['avss'] = 'Služba nepodporuje vydavateľa';
$string['avsu'] = 'Údaj o adrese nie je k dispozícii';
$string['avsw'] = '9 miestne PSČ súhlasí, ale adresa nie';
$string['avsx'] = '9 miestne PSČ súhlasí a adresa súhlasí';
$string['avsy'] = '5 miestne PSČ súhlasí a adresa súhlasí';
$string['avsz'] = '5 miestne PSČ súhlasí, ale adresa nie';
$string['canbecredit'] = 'Možno fungovať až  do {$a->upto}';
$string['cancelled'] = 'Zrušené';
$string['capture'] = 'Rezervované';
$string['capturedpendingsettle'] = 'Autorizované/Rezervované úhrady';
$string['capturedsettled'] = 'Autorizované/uhradené';
$string['captureyes'] = 'Kreditná karta bude autorizovaná a študent bude prihlásený do kurzu. Pokračovať?';
$string['cccity'] = 'Mesto';
$string['ccexpire'] = 'Dátum zániku platnosti (vypršania)';
$string['ccexpired'] = 'Platnosť kreditnej karty už vypršala';
$string['ccinvalid'] = 'Neplatné číslo karty';
$string['cclastfour'] = 'CC posledné štyri';
$string['ccno'] = 'Číslo kreditnej karty';
$string['ccstate'] = 'Štát';
$string['cctype'] = 'Typ kreditnej karty';
$string['ccvv'] = 'Verifikácia karty';
$string['ccvvhelp'] = 'Pozrite sa na zadnú stranu karty (posledné 3 čísla)';
$string['choosemethod'] = 'Ak poznáte kód k zápisu do kurzu, zadajte ho;<br />  V opačnom prípade budete musieť za tento kurz zaplatiť.';
$string['chooseone'] = 'Vypíšte jedno alebo obidve nasledujúce polia';
$string['cost'] = 'Cena';
$string['costdefaultdesc'] = '<strong> v nastaveniach kurzu vložte hodnotu -1</strong> pre použitie tejto pôvodnej ceny v poli pre cenu';
$string['currency'] = 'mena';
$string['cutofftime'] = 'Čas spracovania transakcií.';
$string['cutofftimedesc'] = 'Čas spracovania transakcií. Kedy je posledná transakcia zobraná na uhradenie?';
$string['dataentered'] = 'Vložené údaje';
$string['delete'] = 'Zrušiť';
$string['description'] = 'Modul Authorize.net umožňuje nastaviť platenie za kurzy pomocou poskytovateľov platieb.Sú dva spôsoby nastavenia ceny kurzu (1) globálne pre všetky kurzy na portáli alebo (2) tiež pre každý kurz osobitne. Pokiaľ je nastavená cena za individuálny kurz, potom sa globálne nastavenie pre všetky kurzy neberie do úvahy.';
$string['echeckabacode'] = 'Bankové číslo ABA';
$string['echeckaccnum'] = 'Číslo bankového účtu';
$string['echeckacctype'] = 'Typ bankového účtu';
$string['echeckbankname'] = 'Názov banky';
$string['echeckbusinesschecking'] = 'Overenie firmy';
$string['echeckchecking'] = 'Overenie';
$string['echeckfirslasttname'] = 'Vlastník bankového účtu';
$string['echecksavings'] = 'Úspory';
$string['enrolenddate'] = 'Dátum ukončenia';
$string['enrolenddaterror'] = 'Koncový dátum prihlásenia sa do kurzu nemôže byť skôr ako začiatočný dátum.';
$string['enrolname'] = 'Authorize.net: Brána pre kreditné karty';
$string['enrolperiod'] = 'Obdobie zápisu do kurzu';
$string['enrolstartdate'] = 'Dátum začatia';
$string['expired'] = 'Vypršané';
$string['expiremonth'] = 'Mesiac ukončenia';
$string['expireyear'] = 'Rok ukončenia';
$string['firstnameoncard'] = 'Meno na karte';
$string['haveauthcode'] = 'Už mám autorizačný kód';
$string['howmuch'] = 'Koľko?';
$string['httpsrequired'] = 'Bohužiaľ Vás musíme informovať, že Vaša žiadosť nemôže byť teraz zpracovaná. Nepodarilo sa vykonať potrebné nastavenia tejto stránky. <br /><br /> Prosím nevkladajte číslo Vašej kreditnej karty, pokiaľ neuvidíte žltý zámok v spodnej lište. Keď ho uvidíte, znamená to, že komunikácia medzi klientom a serverom je šifrovaná. Takže číslo Vašej kreditnej karty počas prenosu po sieti nebude môcť zachytiť žiadna tretia osoba.';
$string['invalidaba'] = 'Neplatné číslo ABA';
$string['invalidaccnum'] = 'Neplatné číslo účtu';
$string['invalidacctype'] = 'Neplatný typ účtu';
$string['lastnameoncard'] = 'Priezvisko na karte';
$string['logindesc'] = 'Táto voľba musí byť zapnutá (ON). <br /><br /> Prosím presvedčte sa, že máte zapnuté <a href="{$a->url}"> loginhttps ON</a> v časti Administratíva >> Premenné >> Zabezpečenie.<br /><br /> Po zapnutí bude Moodle používať bezpečné http spojenia iba pre prihlasovanie a pre stránky s platbami.';
$string['logininfo'] = 'Prihlasovacie meno, heslo a kľúč transakcie nie sú z bezpečnostných dôvodov zobrazené. Nemusíte ich zadávať znovu, ak ste ich už vyplnili. Ak ste niektoré už vyplnili, uvidíte vľavo od rámčeka zelený text. Ak tieto polia vypĺnate prvýkrát, prihlasovacie meno (*) je povinné, musíte vložiť <strong>alebo</strong> kľúč transakcie (#1) <strong>alebo</strong> heslo (#2) do príslušného rámčeku. Z bezpečnostých dôvodov Vám doporučujeme vkladať kľúč transakcie. Ak chcete vymazať súčasné heslo, začiarknite checkbox.';
$string['methodcc'] = 'Kreditná karta';
$string['methodccdesc'] = 'Vyberte kreditnú kartou a akceptované typy nižšie';
$string['methodecheck'] = 'e-šek (ACH)';
$string['methodecheckdesc'] = 'Vyberte e-šek a akceptované typy nižšie';
$string['missingaba'] = 'Chýba číslo ABA';
$string['missingaddress'] = 'Chýba adresa';
$string['missingbankname'] = 'Chýba názov banky';
$string['missingcc'] = 'Chýba číslo karty';
$string['missingccauthcode'] = 'Chýba autorizačný kód';
$string['missingccexpiremonth'] = 'Chýbajúci mesiac ukončenia';
$string['missingccexpireyear'] = 'Chýbajúci rok ukončenia';
$string['missingcctype'] = 'Chýba typ karty';
$string['missingcvv'] = 'Chýba overovací kód';
$string['missingzip'] = 'Chýba PSČ';
$string['mypaymentsonly'] = 'Ukázať len moje platby';
$string['nameoncard'] = 'Meno na karte';
$string['new'] = 'Nový';
$string['nocost'] = 'Pre zápis do tohto kurzu pomocou Authorize.Net nie je potrebná žiadna platba';
$string['noreturns'] = 'Žiadne vrátené platby';
$string['notsettled'] = 'Neuhradené';
$string['orderdetails'] = 'Podrobnosti objednávky';
$string['orderid'] = 'ID objednávky';
$string['paymentmanagement'] = 'Správa platieb';
$string['paymentmethod'] = 'Platobná metóda';
$string['paymentpending'] = 'Vaša platba za tento kurz, pod číslom {$a->orderid}, sa spracováva. Vid <a href=\'{$a->url}\'>Podrobnosti o objednávke</a>.';
$string['pendingecheckemail'] = 'Vážený manažér,

na potvrdenie čaká {$a->count} e-šekov a Vy musíte nahrať csv súbor, aby boli užívatelia zapísaní.

Kliknite na nasledujúci odkaz a prečítajte si nápovedu k tejto stránke:
{$a->url}';
$string['pendingechecksubject'] = '{$a->course}: Rezervované e-šeky ({$a->count})';
$string['pendingordersemail'] = 'Vážený administrátor,

{$a->pending} transakcie pre tento kurz "{$a->course}" vypršia, ak neprijmete platbu v priebehu {$a->days} dní.

Táto správa Vás upozorňuje, že ste neaktivovali systém automatického spracovania transakcií. Takže musíte každú platbu prijať alebo odmietnuť ručne.

Prijatie alebo zamietnutie rezervovaných platieb uskutočníte na adrese: {$a->url}.

Ak chcete zapnúť automatické spracovanie transakcií (nebudete dostávať upozorňovacie e-maily), kliknite na adresu: {$a->enrolurl}';
$string['pendingordersemailteacher'] = 'Vážený učiteľ,

{$a->pending} transakcie o výške {$a->currency} {$a->sumcost} za kurz  "{$a->course}"  vypršia, ak ich neprimete do {$a->days} dní.

Musíte prijať alebo zamietnuť platby ručne, pretože administrátor neaktivoval systém automatického spracovania transakcií.

{$a->url}';
$string['pendingorderssubject'] = 'UPOZORNENIE: {$a->course}, {$a->pending} transakcie vypršia za {$a->days} deň/dní.';
$string['pluginname'] = 'Povoliť';
$string['reason11'] = 'Bola podaná duplikátna transakcia.';
$string['reason13'] = 'Prihlasovacie ID obchodníka je neplatné alebo účet je neaktívny.';
$string['reason16'] = 'transakcia nebola nájdená.';
$string['reason17'] = 'Tento typ kreditnej karty obchodník neprijíma.';
$string['reason245'] = 'Tento typ e-šeku nie je povolený pri použití hosťovaného spôsobu platby';
$string['reason246'] = 'Tento typ e-šeku nie je povolený';
$string['reason27'] = 'Výsledok kontroly AVS pre túto transakciu: nezhodné adresné údaje. Zadaná adresa sa nezhoduje s adresou majiteľa karty.';
$string['reason28'] = 'Tento typ kreditnej arty obchodník neprijíma.';
$string['reason30'] = 'Neplatné nastavenie systému spracovania transakcií. Obráťte sa na spoločnosť zaisťujúcu pre daného obchodníka spracovanie transakcií.';
$string['reason39'] = 'Zadaný kód meny je buď neplatný, alebo nie je podporovaný, alebo nie je povolený pre tohto obchodníka, alebo nemá menový kurz.';
$string['reason43'] = 'Systém spracovania transakcií obsahuje nesprávne informácie o obchodníkovi. Obráťte sa na spoločnosť zaisťujúcu pre daného obchodníka spracovanie transakcií.';
$string['reason44'] = 'Táto transakcia bola zamietnutá. Chyba filtra kódu karty!';
$string['reason45'] = 'Táto transakcia bola zamietnutá. Chyba filtra kódu karty/AVS!';
$string['reason47'] = 'Čiastka požadovaná k úhrade nesmie byť vyššia ako pôvodná autorizovaná čiastka.';
$string['reason5'] = 'Požadovaná je platná čiastka.';
$string['reason50'] = 'Táto transakcia čaká na úhradu a nemôže byť vrátená.';
$string['reason51'] = 'Suma všetkých kreditov proti tejto transakcii je väčšia ako pôvodná čiastka transakcie.';
$string['reason54'] = 'Odkazovaná transakcia sa nezhoduje s kritériami pre vydanie kreditu';
$string['reason55'] = 'Suma všetkých kreditov proti tejto odkazovanej transakcii by prekročila pôvodnú čiastku dlhu.';
$string['reason56'] = 'Tento obchodník príjima e-šek (ACH) transakcie; nie sú povolené transakcie kreditných kariet.';
$string['refund'] = 'Vrátiť';
$string['refunded'] = 'Vrátené';
$string['returns'] = 'Vrátené';
$string['reviewfailed'] = 'Kontrola sa neuskutočnila';
$string['reviewnotify'] = 'Vaša platba bude skontrolovaná. Očakávajte email od vášho učiteľa v priebehu niekoľkých dní.';
$string['sendpaymentbutton'] = 'Odoslať platbu';
$string['settled'] = 'Uhradené';
$string['settlementdate'] = 'Dátum úhrady';
$string['shopper'] = 'Zákazník';
$string['status'] = 'Povoliť zápisy do kurzu metódou Autorize.net';
$string['subvoidyes'] = 'Nahradená transakcia ({$a->transid}) bude zrušená a na váš účet bude pripísaná čiastka {$a->amount}. Pokračovať?';
$string['tested'] = 'Testované';
$string['testmode'] = '[TESTOVACÍ REŽIM]';
$string['testwarning'] = 'Rezervovanie/Rušenie/Vrátenie prebehli bez problémov v testovacom režime, ale v databáze nebol žiaden záznam aktualizovaný ani do nej vložený.';
$string['transid'] = 'ID transakcie';
$string['underreview'] = 'Práve sa kontroluje';
$string['unenrolselfconfirm'] = 'Naozaj sa chcete odhlásiť z kurzu "{$a}" ?';
$string['unenrolstudent'] = 'Vyškrtnúť študenta?';
$string['uploadcsv'] = 'Nahrať CSV súbor';
$string['usingccmethod'] = 'Zapísať s použitím: <a href="{$a->url}"><strong>Kreditná Karta</strong></a>';
$string['usingecheckmethod'] = 'Zapísať s použitím: <a href="{$a->url}"><strong>e-šek</strong></a>';
$string['verifyaccount'] = 'Overiť vaše konto obchodníka authorize.Net.';
$string['verifyaccountresult'] = '<b>Výsledok overovania:</b> {$a}';
$string['void'] = 'Zrušiť';
$string['voidyes'] = 'Transakcia bude zrušená. Pokračovať?';
$string['welcometocoursesemail'] = 'Vážený študent,

Ďakujeme za Vaše platby. Ste zapísaný v týchto kurzoch:

{$a->courses}

Svoj používateľský profil si môžete upraviť tu:
{$a->profileurl}

Detaily Vašich platieb nájtete tu:
{$a->paymenturl}';
$string['youcantdo'] = 'Nemôžete uskutočniť túto akciu:  {$a->action}';
$string['zipcode'] = 'Poštové smerovacie číslo';
