<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'data', language 'sk', version '4.3'.
 *
 * @package     data
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Akcia';
$string['actionsmenu'] = 'Menu aktivít';
$string['add'] = 'Pridať záznam';
$string['addcomment'] = 'Pridať komentár';
$string['addedby'] = 'Pridané';
$string['addentries'] = 'Pridať záznamy';
$string['addtemplate'] = 'Pridať vstupnú šablónu';
$string['advancedsearch'] = 'Pokročilé vyhľadávanie';
$string['allowcomments'] = 'Povoliť komentár k položkám';
$string['alttext'] = 'Alternatívny text';
$string['approvalstatus'] = 'Stav schválenia';
$string['approve'] = 'Odsúhlasiť';
$string['approved'] = 'Odsúhlasené';
$string['areacontent'] = 'Polia';
$string['ascending'] = 'Vzostupne';
$string['asearchtemplate'] = 'Šablóna pokročilého vyhľadávania';
$string['atmaxentry'] = 'Zadali ste maximálny počet dovolených záznamov!';
$string['authorfirstname'] = 'Krstné meno';
$string['authorlastname'] = 'Priezvisko';
$string['autogenallforms'] = 'Generovať všetky štandardné šablóny';
$string['autolinkurl'] = 'Automaticky prepojiť URL';
$string['availablefromdate'] = 'Dostupné od';
$string['availabletags'] = 'Dostupné značky';
$string['availabletags_help'] = '<p>Značky sú zástupné symboly umiestnené v šablóne. Pri zobrazení alebo úprave
záznamu sú značky nahradené obsahom polí alebo tlačidlami.</p>

<p>Značky pre polia majú tento formát: [[názovpoľa]]</p>

<p>Značky pre tlačidlá majú tento formát: ##opistlačidla##</p>

<p>V aktuálnej šablóne možno použiť iba značky uvedené v zozname "Dostupné
značky".</p>';
$string['availabletodate'] = 'Dostupné do';
$string['availabletodatevalidation'] = 'Dátum dostupné do, nemôže byť predtým, ako dátum zahájenia dostupnosti.';
$string['blank'] = 'Prázdny';
$string['buttons'] = 'Akcie';
$string['bynameondate'] = 'kým: {$a->name} - {$a->date}';
$string['calendarend'] = '{$a} - uzavrené';
$string['calendarstart'] = '{$a} - otvorené';
$string['cancel'] = 'Zrušiť';
$string['cannotaccesspresentsother'] = 'Nemáte oprávnenie na prístup k šablónam od iných používateľov';
$string['cannotadd'] = 'Nie je možné pridať záznam';
$string['cannotapplypreset'] = 'Chyba pri použití šablóny.';
$string['cannotdeletepreset'] = 'Chyba pri vymazaní šablóny!';
$string['cannotoverwritepreset'] = 'Chyba pri prepisovaní šablóny';
$string['cannotunziptopreset'] = 'Nie je možné rozbaliť súčasný adresár';
$string['checkbox'] = 'Checkboxy';
$string['chooseexportfields'] = 'Vyberte polia, ktoré chcete exportovať:';
$string['chooseexportformat'] = 'Vyberte formát, do ktorého sa má exportovať:';
$string['chooseorupload'] = 'Vybrať súbor';
$string['choosepreset'] = 'Súbor šablóny';
$string['closebeforeopen'] = 'Dátum ukončenia ste zadali pred dátumom zahájenia.';
$string['columns'] = 'stľpce';
$string['comment'] = 'Komentár';
$string['commentdeleted'] = 'Komentár vymazaný';
$string['commentempty'] = 'Komentár bol prázdny';
$string['comments'] = 'Komentáre';
$string['commentsaved'] = 'Komentár uložený';
$string['commentsn'] = 'Komentáre: {$a}';
$string['commentsoff'] = 'Komentáre nie sú povolené';
$string['completiondetail:entries'] = 'Vytvoriť záznam: {$a}';
$string['completionentries'] = 'Povinná položka';
$string['completionentriescount'] = 'Počet záznamov';
$string['completionentriesdesc'] = 'Minimálny počet požadovaných záznamov:  {$a}';
$string['configenablerssfeeds'] = 'Tento prepínač povolí možnosť RSS sťahovania pre všetky databázy. Avšak, pre každú databázu to budete ešte musieť povoliť manuálne.';
$string['confirmdeletefield'] = 'Naozaj vymazať toto pole?';
$string['confirmdeleterecord'] = 'Naozaj vymazať tento záznam?';
$string['confirmdeleterecords'] = 'Naozaj chcete vymazať tieto položky?';
$string['createactivity'] = 'Vytvorte si vlastné polia na zhromažďovanie údajov alebo použite predvoľbu, ktorá už polia obsahuje.';
$string['createfields'] = 'Vytvorte polia na zhromažďovanie rôznych typov údajov.';
$string['csstemplate'] = 'Používateľské CSS';
$string['csvfailed'] = 'Nepodarilo sa prečítať údaje z CSV súboru';
$string['csvfile'] = 'CSV súbor';
$string['csvimport'] = 'CSV import súboru';
$string['csvimport_help'] = '<p>CSV (Comma-Separated-Values) znamená hodnoty oddelené čiarkami a je
  často používaným formátom pre výmenu textu.</p>

<p>Formát takéhoto súboru je obyčajný text, ktorý obsahuje v prvom
   riadku názvy polí. V ďalších riadkoch nasledujú údaje, v každom
   riadku jeden záznam. </p>

<p>Oddeľovač jednotlivých polí v zázname je čiarka a jednotlivé polia
   nie sú štandardne nijako označené - napríklad uvodzovkami.</p>

<p>Záznamy by mali byť oddelené novými riadkami (normálne
   generovanými klávesou ENTER v textovom eitore). Tabelátory sa dajú
   písať ako t a nové riadky tiež ako n. </p>

<p>Príklad súboru:</p>

<pre>
  name,height,weight
  Kai,180cm,80kg
  Kim,170cm,60kg
  Koo,190cm,20kg
</pre>

<p>Táto verzia modulu dovoľuje iba jednoduché typy polí. Avšak v
   budúcnosti sa plánuje podpora aj u ostatných typov polí.</p>';
$string['csvwithselecteddelimiter'] = '<abbr title="Comma Separated Values">CSV</abbr>';
$string['data:addinstance'] = 'Pridať novú databázu';
$string['data:approve'] = 'Schvaľovať záznamy a rušiť schvaľovanie záznamov';
$string['data:comment'] = 'Písať komentáre';
$string['data:exportallentries'] = 'Exportovať záznamy databázy';
$string['data:exportentry'] = 'Exportovať databázový záznam';
$string['data:exportownentry'] = 'Exportovať vlastný databázový záznam';
$string['data:exportuserinfo'] = 'Exportovať informácie používateľa';
$string['data:managecomments'] = 'Spravovať komentáre';
$string['data:manageentries'] = 'Spravovať záznamy';
$string['data:managetemplates'] = 'Spravovať šablóny';
$string['data:manageuserpresets'] = 'Spravovať šablóony';
$string['data:rate'] = 'Hodnotiť záznamy';
$string['data:readentry'] = 'Čítať záznamy';
$string['data:view'] = 'Zobraziť aktivitu databáza';
$string['data:viewallratings'] = 'Prezerať všetky hodnotenia zadané jednotlivcami';
$string['data:viewalluserpresets'] = 'Prezerať predlohy všetkých užívateľov';
$string['data:viewanyrating'] = 'Prezerať celkové hodnotenia, ktoré získali všetci';
$string['data:viewentry'] = 'Prezerať záznamy';
$string['data:viewrating'] = 'Zobraziť celkové vlastné hodnotenie';
$string['data:writeentry'] = 'Zapisovať záznamy';
$string['date'] = 'Dátum';
$string['dateentered'] = 'Dátum vloženia';
$string['datemodified'] = 'Naposledy upravované:';
$string['defaultfielddelimiter'] = '(štandardne je to znak čiarka)';
$string['defaultfieldenclosure'] = '(štandardne žiaden)';
$string['defaultsortfield'] = 'Štandardné pole pre triedenie';
$string['delcheck'] = 'Zaškrtávacie políčko hromadného odstránenia';
$string['delete'] = 'Vymazať';
$string['deleteallentries'] = 'Vymazať všetky položky';
$string['deletecomment'] = 'Naozaj vymazať tento komentár?';
$string['deleteconfirm'] = 'Odstrániť sablónu {$a}?';
$string['deleted'] = 'vymazaný';
$string['deleteentry'] = 'Odstrániť záznam';
$string['deletefield'] = 'Odstrániť pole';
$string['deletenotenrolled'] = 'Vymazať položky vložené používateľmi, ktorí nie sú zapísaní do kurzu';
$string['deletewarning'] = 'Vymazaním šablóny ju odstránite zo zoznamu dostupných šablón vo všetkých kurzoch.';
$string['descending'] = 'Zostupne';
$string['directorynotapreset'] = '{$a->directory} nie je šablónou: chýbajúce súbory: {$a->missing_files}';
$string['disapprove'] = 'Odvolať schválenie';
$string['download'] = 'Stiahnuť';
$string['edit'] = 'Upraviť';
$string['editcomment'] = 'Upraviť komentár';
$string['editentry'] = 'Upraviť záznam';
$string['editfield'] = 'Upraviť pole';
$string['editordisable'] = 'Zakázať editor';
$string['editorenable'] = 'Povoliť editor kódu';
$string['editpreset'] = 'Upraviť šablónu';
$string['emptyadd'] = 'Pridaná šablóna je prázdna, generujem štandardný formulár...';
$string['emptyaddform'] = 'Nevyplnili ste žiadne polia!';
$string['enabletemplateeditorcheck'] = 'Naozaj chcete povoliť editor? To môže viesť ku zmene obsahu pri ukladaní šablóny.';
$string['entries'] = 'Záznamy';
$string['entrieslefttoadd'] = 'Predtým, ako si budete môcť splniť túto aktivitu, musíte pridať {$a->entriesleft} záznamov.';
$string['entrieslefttoaddtoview'] = 'Musíte pridať ešte {$a->entrieslefttoview} položku/y predtým, ako budete môcť prezerať záznamy od iných účastníkov kurzu.';
$string['entry'] = 'Záznam';
$string['entrysaved'] = 'Váš záznam bol uložený';
$string['errormustbeteacher'] = 'Musíte byť učiteľ pre používanie tejto strany!';
$string['errormustsupplyvalue'] = 'Musíte sem zadať nejakú hodnotu.';
$string['errorpresetexists'] = 'Šablóna s daným názvom už existuje';
$string['eventfieldcreated'] = 'Pole vytvorené';
$string['eventfielddeleted'] = 'Pole odstránené';
$string['eventfieldupdated'] = 'Pole aktualizované';
$string['eventrecordcreated'] = 'Záznam vytvorený';
$string['eventrecorddeleted'] = 'Záznam odstránený';
$string['eventrecordupdated'] = 'Záznam akualizovaný';
$string['eventtemplateupdated'] = 'Šablóna bola aktualizovaná';
$string['eventtemplateviewed'] = 'Šablóna bola zobrazená';
$string['example'] = 'Príklad modulu databáza';
$string['excel'] = 'Excel';
$string['expired'] = 'Prepáčte, táto aktivita, ktorá bola uzatvorená  {$a}, nie je už dostupná.';
$string['export'] = 'Exportovať';
$string['exportaszip'] = 'Exportovať ako zip';
$string['exportaszip_help'] = '<p>
  Táto voľba umožňuje stiahnuť šablóny zo serveru do počítača a neskôr ich
  vložiť do inej databázy Moodle pomocou funkcie Importovať predlohy zo ZIP
  súboru.
</p>';
$string['exportedtozip'] = 'Exportované do dočasného zip súboru ...';
$string['exportentries'] = 'Export záznamov';
$string['exportformat'] = 'Formát exportu';
$string['exportoptions'] = 'Možnosti exportu';
$string['exportownentries'] = 'Exportovať iba vaše vlastné položky? ({$a->mine}/{$a->all})';
$string['exportpreset'] = 'Exportovať predvoľbu';
$string['failedpresetdelete'] = 'Chyba pri odstraňovaní predlohy';
$string['fieldadded'] = 'Pole bolo pridané';
$string['fieldallowautolink'] = 'Povoliť autolink';
$string['fielddeleted'] = 'Pole vymazané';
$string['fielddelimiter'] = 'Oddeľovač poľa';
$string['fielddescription'] = 'Opis poľa';
$string['fieldenclosure'] = 'Uzavretie poľa';
$string['fieldheight'] = 'Výška';
$string['fieldheightlistview'] = 'Výška v zoznamovom zobrazení';
$string['fieldheightsingleview'] = 'Výška v položkovom zobrazení';
$string['fieldids'] = 'Identifikátory polí';
$string['fieldmappings'] = 'Mapovanie polí';
$string['fieldmappings_help'] = 'Tu môžete upraviť nastavenia pre prenos údajov z aktuálnej databázy. Pre uchovanie údajov v poli existujúcej databázy je nutné ich prepojiť (tzv. mapovať) s novým poľom. Údaj o novom poli môžete tiež nechať nevyplnený, v tom prípade bude toto pole odstránené spolu so všetkými záznamami, ktoré v ňom boli uložené.
Mapovať možno iba polia rovnakého typu, každé rozbaľovacie menu bude preto obsahovať rôzne polia. Je tiež treba sa vyvarovať pokusu mapovať jedno pole s viac než jedným novým poľom.';
$string['fieldname'] = 'Meno poľa';
$string['fieldnametype'] = '{$a->name} ({$a->type})';
$string['fieldnotmatched'] = 'Nasledujúce polia vo vašom súbore nie sú známe v tejto databáze: {$a}';
$string['fieldoptions'] = 'Voľby (jedna na riadok)';
$string['fields'] = 'Polia';
$string['fieldsnavigation'] = 'Terciárna navigácia polí';
$string['fieldupdated'] = 'Pole aktualizované';
$string['fieldwidth'] = 'Šírka';
$string['fieldwidthlistview'] = 'Šírka v zoznamovom zobrazení';
$string['fieldwidthsingleview'] = 'Šírka v položkovom zobrazení';
$string['file'] = 'Súbor';
$string['fileencoding'] = 'Kódovanie';
$string['filesnotgenerated'] = 'Neboli vytvorené všetky polia: {$a}';
$string['filtername'] = 'Automatické prepojovanie databázy';
$string['footer'] = 'Päta';
$string['forcelinkname'] = 'Preddefinovaný názov pre odkaz';
$string['foundnorecords'] = 'Žiadne záznamy nenájdené (<a href="{$a->reseturl}">Reset filtrov</a>)';
$string['foundrecords'] = 'Nájdené záznamy: {$a->num}/{$a->max} (<a href="{$a->reseturl}">Reset filtrov</a>)';
$string['fromfile'] = 'Importovať zo zip súboru';
$string['fromfile_help'] = '<p>
  Tu môžete nahrať predlohy, ktoré ste predtým uložili do svojho počítača pomocou exportu modulu Databáza.
</p>';
$string['generateerror'] = 'Nie všetky súbory boli generované!';
$string['header'] = 'Hlavička';
$string['headeraddtemplate'] = 'Definuje interface pri editovaní záznamov';
$string['headerasearchtemplate'] = 'Definuje interface pre pokročilé vyhľadávanie';
$string['headercsstemplate'] = 'Definuje lokálne CSS štýly pre iné šablóny';
$string['headerjstemplate'] = 'Definuje vlastný Javascript pre manipuláciu s tým, ako sa prvky zobrazujú v šablónach Zoznam, Záznam alebo Pridať záznam';
$string['headerlisttemplate'] = 'Definuje prehliadanie pri viacerých záznamoch';
$string['headerrsstemplate'] = 'Definuje výzor záznamov v RSS';
$string['headersingletemplate'] = 'Definuje prehliadací interface pre pohľad na jeden záznam';
$string['importentries'] = 'Import záznamov';
$string['importpreset'] = 'Importovať predvoľbu';
$string['importsuccess'] = 'Predloha bola úspešne aplikovaná';
$string['includeapproval'] = 'Zahrnúť stav schválenia';
$string['includetags'] = 'Zahrnúť štítky';
$string['includetime'] = 'Zahrnúť čas pridania/zmeny';
$string['includeuserdetails'] = 'Zahrnúť údaje používateľa';
$string['indicator:cognitivedepth'] = 'Kognitívna Databáza';
$string['indicator:cognitivedepth_help'] = 'Tento indikátor je založený na študentom získanej kognitívnej hĺbke v aktivite Databáza.';
$string['indicator:cognitivedepthdef'] = 'Kognitívna databáza';
$string['indicator:cognitivedepthdef_help'] = 'Počas tohto intervalu analýzy dosiahol účastník toto percento kognitívnej angažovanosti ponúkanej aktivitami Databáza (Úrovne = Bez zobrazenia, Zobrazenie, Odovzdanie)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Sociálna databáza';
$string['indicator:socialbreadth_help'] = 'Tento indikátor je založený na študentom získanej sociálnej šírke v aktivite Databáza.';
$string['indicator:socialbreadthdef'] = 'Sociálna databáza';
$string['indicator:socialbreadthdef_help'] = 'Počas tohto intervalu analýzy dosiahol účastník toto percento sociálnej angažovanosti ponúkanej aktivitou Databáza (Úrovne = Bez účasti, Účastník sám)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['insufficiententries'] = 'pre prezeranie tejto databázy je potrebné viacero záznamov';
$string['intro'] = 'Opis';
$string['invalidaccess'] = 'Prístup k tejto stránke nebol korektný';
$string['invalidfieldid'] = 'Poľe pre ID nie je správne';
$string['invalidfieldname'] = 'Prosím vyberte iné meno pre toto pole';
$string['invalidfieldtype'] = 'Neplatný typ poľa';
$string['invalidid'] = 'Nesprávne ID údaje';
$string['invalidpreset'] = '{$a} nie je šablónou.';
$string['invalidrecord'] = 'Nesprávny záznam';
$string['invalidurl'] = 'Zadaná URL nie je správna';
$string['jstemplate'] = 'Šablóna Javascript';
$string['latitude'] = 'Zemepisná šírka';
$string['latlong'] = 'Zemepisná šírka/dĺžka';
$string['latlongboth'] = 'Zemepisná šírka a dĺžka sú požadované.';
$string['latlongdownloadallhint'] = 'Stiahnuť odkaz pre všetky záznamy vo formáte KLM';
$string['latlongkmllabelling'] = 'Ako opisovať položky v KML súboroch. KML je formát pre zobrazovanie zemepisných údajov použiteľný napr. v Google Earth';
$string['latlonglinkservicesdisplayed'] = 'Zobrazované služby';
$string['latlongotherfields'] = 'Dalšie polia';
$string['list'] = 'Zoznam';
$string['listtemplate'] = 'Šablóna zoznamu';
$string['listview'] = 'Zobrazenie zoznamu';
$string['longitude'] = 'Zemepisná dĺžka';
$string['manageapproved'] = 'Povoliť úpravu schválených záznamov';
$string['manageapproved_help'] = 'Ak nie je povolené, schválené položky už nie je možné upravovať ani používateľom, ktorý ich vytvoril. Toto nastavenie nemá žiadny vplyv, kým nie je povolené "Vyžadovať schválenie".';
$string['managefields'] = 'Spravovať polia';
$string['mapexistingfield'] = 'Mapovať na {$a}';
$string['mapnewfield'] = 'Vytvoriť nové poľe';
$string['mappingwarning'] = 'Všetky staré polia, ktoré nie sú mapované do nových, budú odstránené a údaje, ktoré obsahujú, budú stratené.';
$string['maxentries'] = 'Maximálny počet záznamov';
$string['maxentries_help'] = 'Koľko záznamov môže užívateľ zadať pre túto aktivitu.';
$string['maxsize'] = 'Maximálna veľkosť';
$string['menu'] = 'Menu';
$string['menuchoose'] = 'Vybrať...';
$string['missingdata'] = 'Musíte poskytnúť identifikátor údajov alebo objekt, ak definujete triedu poľa.';
$string['missingfield'] = 'Chyba programovania: musíte určiť pole a/alebo údaje, keď definujete triedu poľa';
$string['modulename'] = 'Databáza';
$string['modulename_help'] = 'Modul Databáza umožňuje vytvárať, prezerať a prehľadávať kolekciu položiek (tj. Záznamov). Štruktúru príspevkov definuje učiteľ ako rozličné polia.
Typy polí zahrnujú zaškrtávací políčko, prepínače, rozbaľovaciu ponuku, textovú oblasť, adresu URL, obrázok a nahraný súbor.

Vzhľad kolekcie, jednotlivých záznamov aj formulára pre úpravy je možné riadiť pomocou šablón databázy. Databázové aktivity môžu byť zdieľané medzi kurzmi ako prednastavenie a učiteľ môže tiež importovať a exportovať položky databázy.

Ak je povolený filter automatického prepojenia databáz, všetky položky v databáze budú automaticky prepojené tam, kde sa slová alebo frázy objaví v kurze.

Učiteľ môže povoliť komentáre k záznamom. Príspevky je možné hodnotiť učiteľom alebo študentmi (vzájomné hodnotenie). Hodnotenie sa prepočítava na výslednú známku, ktorá môže byť súčasťou výkazu známkovania v kurze.

Databáza má veľa použití napr.

* ako spoločne vytváranú zbierku odkazov na webové stránky, literatúru, články v odborných časopisoch apod.
* ako galériu fotografií a ďalších obrázkov
* ako zbierku študentmi vytvorených prezentácií, plagátov, básní apod.';
$string['modulename_link'] = 'mod/data/view';
$string['modulenameplural'] = 'Databázy';
$string['more'] = 'Viac';
$string['moreurl'] = 'Viac URL';
$string['movezipfailed'] = 'Nedá sa presunúť ZIP súbor';
$string['multientry'] = 'Opakovaný záznam';
$string['multimenu'] = 'Menu (Multi-výber)';
$string['multipletags'] = 'Viaceré tagy nájdené! Šablóna nebola uložená';
$string['newentry'] = 'Nový záznam';
$string['newfield'] = 'Vytvoriť pole';
$string['newfield_help'] = 'Pole umožňuje zadávanie údajov. Každá položka v aktivite databáza môže mať viac polí rôznych typov, napríklad pole dátum, ktoré účastníkom umožňuje vybrať deň, mesiac a rok z rozbaľovacej ponuky, pole obrázku, ktoré umožňuje účastníkom nahrať súbor s obrázkom, alebo zaškrtávací políčko, ktoré účastníkom umožňuje vybrať jednu alebo viac možností.

Každé pole musí mať jedinečný názov poľa. Opis poľa je nepovinný.';
$string['noaccess'] = 'Nemáte prístup k tejto stránke';
$string['nodefinedfields'] = 'Nová salóna nemá definované žiadne polia!';
$string['nofieldcontent'] = 'Nebol nájdený žiaden obsah poľa';
$string['nofieldindatabase'] = 'V tejto databáze nie sú definované polia, vložte nejaké';
$string['nofields'] = 'Zatiaľ žiadne polia';
$string['nolisttemplate'] = 'Šablóna zoznamu ešte nie je definovaná';
$string['nomatch'] = 'Neboli nájdené vyhovujúce záznamy!';
$string['nomaximum'] = 'Žiadne maximum';
$string['nopreviewavailable'] = 'Pre {$a} nie je k dispozícii žiadna ukážka';
$string['norecords'] = 'Žiadne záznamy v databáze';
$string['nosingletemplate'] = 'Šablóna pre jednotlivý záznam ešte nie je definovaná';
$string['notapproved'] = 'Tento záznam ešte nebol schválený.';
$string['notapprovederror'] = 'Položka ešte nie je schválená.';
$string['notemplates'] = 'Zatiaľ žiadne šablóny';
$string['notinjectivemap'] = 'Nie je mapa vkladania';
$string['notopenyet'] = 'Prepáčte, táto aktivita nie je dostupná do {$a}';
$string['number'] = 'Číslo';
$string['numberrssarticles'] = 'Položky v RSS vlákne';
$string['numnotapproved'] = 'Schváliť';
$string['numrecords'] = '{$a} záznamov';
$string['ods'] = '<acronym title="OpenDocument Spreadsheet">ODS</acronym> (OpenOffice)';
$string['openafterclose'] = 'Dátum začiatku ste zadali po dátume ukončenia.';
$string['optionaldescription'] = 'Krátky opis (voliteľný)';
$string['optionalfilename'] = 'Meno súboru (voliteľné)';
$string['other'] = 'Iné';
$string['overrwritedesc'] = 'Prepísať šablónu ak už existuje';
$string['overwrite'] = 'Prepísať';
$string['overwritesettings'] = 'Prepísať súčasné nastavenia';
$string['page-mod-data-x'] = 'Ľubovoľná stránka modulu databáza';
$string['pagesize'] = 'Počet záznamov na strane';
$string['participants'] = 'Účastníci';
$string['picture'] = 'Obrázok';
$string['pleaseaddsome'] = 'Okrem vytvorenia nových polí môžete tiež <a href="{$a}">použiť niektorú z nadefinovaných predlôh</a>.';
$string['pluginadministration'] = 'Správa aktivít databázy';
$string['pluginname'] = 'Databáza';
$string['portfolionotfile'] = 'Exportovať do portfólia a nie do súboru (iba csv a leap2a)';
$string['presetdeleted'] = 'Šablóna vymazaná';
$string['presetinfo'] = 'Ak uložíte túto šablónu ako predlohu, budú ju môcť ostatní používatelia na tomto serveri používať vo svojich kurzoch.';
$string['presetnotselected'] = 'Nebola vybratá žiadna predvoľba.';
$string['presets'] = 'Predlohy';
$string['preview'] = 'Ukážka {$a}';
$string['privacy:metadata:commentpurpose'] = 'Komentáre k databázovým záznamom';
$string['privacy:metadata:data_content'] = 'Predstavuje jednu odpoveď na jedno pole v module aktivity databáza';
$string['privacy:metadata:data_content:content'] = 'Obsah';
$string['privacy:metadata:data_content:content1'] = 'Ďalší obsah 1';
$string['privacy:metadata:data_content:content2'] = 'Ďalší obsah 2';
$string['privacy:metadata:data_content:content3'] = 'Ďalší obsah 3';
$string['privacy:metadata:data_content:content4'] = 'Ďalší obsah 4';
$string['privacy:metadata:data_content:fieldid'] = 'ID definícia poľa';
$string['privacy:metadata:data_records'] = 'Predstavuje záznamy v module aktivity databáza';
$string['privacy:metadata:data_records:approved'] = 'Stav schválenia';
$string['privacy:metadata:data_records:groupid'] = 'Skupina';
$string['privacy:metadata:data_records:timecreated'] = 'Čas vytvorenia záznamu';
$string['privacy:metadata:data_records:timemodified'] = 'Čas poslednej úpravy záznamu';
$string['privacy:metadata:data_records:userid'] = 'Používateľ, ktorý vytvoril záznam';
$string['privacy:metadata:datafieldnpluginsummary'] = 'Pole pre modul aktivity databáza';
$string['privacy:metadata:filepurpose'] = 'Súbor pripojený k databázovému záznamu';
$string['privacy:metadata:ratingpurpose'] = 'Hodnotenie databázových záznamov';
$string['privacy:metadata:tagpurpose'] = 'Štítky v databázových záznamoch';
$string['radiobutton'] = 'Radio tlačidlá';
$string['recordapproved'] = 'Záznam prijatý';
$string['recorddeleted'] = 'Záznam vymazaný';
$string['recorddisapproved'] = 'Neschválený záznam';
$string['recordsnotsaved'] = 'Žiaden záznam nebol uložený. Prosím skontrolujte formát nahraného súboru.';
$string['recordssaved'] = 'záznam(y) uložené';
$string['removealldatatags'] = 'Odstrániť všetky štítky databázy';
$string['requireapproval'] = 'Žiadať povolenie';
$string['requireapproval_help'] = '<p>Je potrebné žiadať povolenie učiteľa predtým, ako budú záznam vidieť
   ostatní študenti? Toto je vhodné v prípadoch, ak by študenti mohli
   publikovať niečo nevhodné.</p>';
$string['required'] = 'Povinné';
$string['requiredentries'] = 'Počet požadovaných záznamov pre splnenie (staré)';
$string['requiredentries_help'] = 'Ak Je nastavené, zobrazí sa správa s uvedením počtu záznamov, ktoré má prispievateľ vložiť pre dokončenie. Všimnite si, že toto nastavenie nie je pripojené k ukončeniu aktivity.

Pre potrebné záznamy pre dokončenie aktivity je nové nastavenie dokončenia aktivity,  mala by byť použitá voľba "Požadovať položky". Ak chcete toto nastavenie úplne odobrať, uložte zmeny.

Namiesto Plnenia aktivity použite Povinné pole.';
$string['requiredentriestoview'] = 'Záznamy požadované pred prezeraním';
$string['requiredentriestoview_help'] = '<p>Počet položiek, ktoré musí užívateľ zadať predtým, kým uvidí
   ostatné položky v tejto databáze.</p>
<p>Poznámka: Táto črta nemôže byť používaná spoločne s databázovým filtrom pre automatické prepájanie odkazov, pretože filter nedokáže správne určiť, či používateľ vložil potrebný počet položiek.</p>';
$string['requiredentrieswarning'] = 'Toto nastavenie bolo nahradené nastavením Plnenie aktivity "Požadovať položky"';
$string['requiredfield'] = 'Povinné pole';
$string['resetsettings'] = 'Reset filtrov';
$string['resettemplate'] = 'Reset šablóny';
$string['resettemplateconfirmtitle'] = 'Resetovať sablónu?';
$string['resizingimages'] = 'Vytváram náhľady obrázkov...';
$string['rows'] = 'riadky';
$string['rssglobaldisabled'] = 'Nepovolené. Viď konfiguračné premenné portálu.';
$string['rsstemplate'] = 'RSS šablóna';
$string['rsstitletemplate'] = 'Nadpis RSS správ';
$string['rsstype'] = 'RSS kanály pre túto aktivitu';
$string['save'] = 'Uložiť';
$string['saveandadd'] = 'Uložiť bez prezerania';
$string['saveandview'] = 'Uložiť a prezrieť';
$string['saveaspreset'] = 'Uložiť ako predlohu';
$string['saveaspreset_help'] = '<p>
  Týmto tlačidlom zverejníte aktuálnu šablónu ako predlohu, ktorú si môže
  prehliadnuť a použiť akýkoľvek iný registrovaný používateľ stránok. Meno
  šablóny sa bude zobrazovať v&nbsp;zozname dostupných predlôh &ndash; na tomto
  mieste ju tiež budete môcť kedykoľvek neskôr odstrániť.
</p>';
$string['saveaspresetmissingcapability'] = 'Používateľ nemá oprávnenie uložiť databázu ako predvoľbu.';
$string['savedataaspreset'] = 'Uložiť všetky polia a šablóny ako prednastavené';
$string['savesettings'] = 'Uložiť nastavenia';
$string['savesuccess'] = 'Uložené. Odteraz môže byť šablóna využívaná ako predloha na celom portáli.';
$string['savetemplate'] = 'Uložiť šablónu';
$string['search'] = 'Vyhľadávanie';
$string['search:activity'] = 'Databáza - informácie';
$string['search:entry'] = 'Databáza - príspevky';
$string['selectedrequired'] = 'Vyžadované všetko vyznačené';
$string['selectexportoptions'] = 'Vybrať možnosti exportu';
$string['selectfields'] = 'Vybrať polia';
$string['showall'] = 'Zobraziť všetky položky';
$string['showmore'] = 'Zobraziť viac';
$string['single'] = 'Prehliadať po jednom';
$string['singletemplate'] = 'Jediná šablóna';
$string['singleview'] = 'Zobrazenie jedného záznamu';
$string['startbuilding'] = 'Začnite vytvárať svoju aktivitu';
$string['subplugintype_datafield'] = 'Typ databázového poľa';
$string['subplugintype_datafield_plural'] = 'Typy databázových polí';
$string['subplugintype_datapreset'] = 'Šablóna';
$string['subplugintype_datapreset_plural'] = 'Predlohy';
$string['tagarea_data_records'] = 'Dátové záznamy';
$string['tags'] = 'Tagy';
$string['tagsdeleted'] = 'Štítky databázy boli odstránené';
$string['teachersandstudents'] = '{$a->teachers} a {$a->students}';
$string['templatereset'] = 'Resetovať šablónu';
$string['templates'] = 'Šablóny';
$string['templatesaved'] = 'Šablóna uložená';
$string['templatesnavigation'] = 'Terciárna navigácia predvolieb';
$string['text'] = 'Text';
$string['textarea'] = 'Textarea';
$string['timeadded'] = 'Čas pridania';
$string['timemodified'] = 'Čas modifikácie';
$string['todatabase'] = 'do tejto databázy';
$string['type'] = 'Typ poľa';
$string['undefinedprocessactionmethod'] = 'V Data_Preset nie je definovaná metóda pre spracovanie činnosti "{$a}".';
$string['unknown'] = 'Neznáme pole';
$string['unsupportedfields'] = 'Nepodporované polia';
$string['unsupportedfieldslist'] = 'Nie je možné exportovať nasledujúce polia:';
$string['updatefield'] = 'Aktualizovať existujúce pole';
$string['uploadfile'] = 'Nahrať súbor';
$string['uploadrecords'] = 'Nahrať záznamy zo súboru';
$string['uploadrecords_help'] = 'Položky je možné nahrávať prostredníctvom textového súboru. Formát súboru by mal byť nasledujúci:

* Každý riadok súboru obsahuje jeden záznam
* Každý záznam je séria údajov, navzájom oddelených čiarkami (alebo inými oddeľovačmi)
* Prvý záznam obsahuje názvy polí, definujúce formát zvyšku súboru.

Každé pole v každom zázname je uzavreté úvodzovkami.  Normálne môže zostať nenastavené.';
$string['uploadrecords_link'] = 'mod/data/import';
$string['url'] = 'URL';
$string['usedate'] = 'Zahrnúť do vyhľadávania';
$string['usepredefinedset'] = 'Použiť preddefinovanú sadu';
$string['usepreset'] = 'Použiť predvoľbu';
$string['usestandard'] = 'Použiť predlohu';
$string['usestandard_help'] = '<p>Tu si môžete vybrať šablónu prístupnú všetkým používateľom stránok.</p>
<p>Ak ste predtým zverejnili niektorú zo svojich šablón pomocou funkcie \'Uložiť
  ako predlohu\', môžete ju tu zo zoznamu zase odstrániť.</p>';
$string['viewfromdate'] = 'Prezerateľné od';
$string['viewnavigation'] = 'Zobraziť terciárnu navigáciu aktivity';
$string['viewtemplates'] = 'Prezerať šablóny';
$string['viewtodate'] = 'Prezerateľné do';
$string['viewtodatevalidation'] = 'Dátum pre ukončenie intervalu pre čítanie, nemôže byť predtým, ako je dátum zahájenia čítania.';
$string['wrongdataid'] = 'Nesprávny identifikátor údajov';
