<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'advmindmap', language 'zh_cn', version '4.3'.
 *
 * @package     advmindmap
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['advmindmap'] = '高级思维导图';
$string['advmindmap:addinstance'] = '增加一个高级思维导图实例';
$string['advmindmap:givecomment'] = '发表评论';
$string['advmindmap:submit'] = '提交';
$string['advmindmap:view'] = '查看';
$string['advmindmap:viewother'] = '查看其他';
$string['advmindmapfieldset'] = '自定义实例字段';
$string['advmindmapintro'] = '思维导图介绍';
$string['advmindmapname'] = '高级思维导图名称';
$string['class'] = '班级';
$string['classno'] = '班级数量';
$string['copylink'] = '（按Ctrl+C复制）';
$string['coursemisconf'] = '课程配置错误';
$string['detail'] = '高级思维导图';
$string['detail_help'] = '</div><div class="indent">
<p>思维导图是用来表示字词、想法、任务、或代表其他链接到中心关键字、想法的项目的一种图表。</p>
<table class="advmindmap_help_table">
<tbody>
    <tr>
        <th width="40%">Function</th>
        <th width="60%">Command</th>
    </tr>
    <tr>
        <td>增加节点</td>
        <td>- 任意位置双击鼠标<br />- 点选绿色 "+" 图标<br />- 按 "Insert" 键来增加一个子节点</td>
    </tr>
    <tr>
        <td>删除标记</td>
        <td>- 按 "Ctrl" 键并按住节点<br />- 点选红色 "-" 图标<br />- 按 "Delete" 键</td>
    </tr>
    <tr>
        <td>撤消/重做</td>
        <td>- 按 "Ctrl"+"Z" 键或 "Ctrl"+"Y" 键<br />- 点选向前或向后的箭头图标<br /></td>
    </tr>
    <tr>
        <td>移动节点</td>
        <td>按住节点并拖动</td>
    </tr>
    <tr>
        <td rowspan="1">保存思维导图</td>
        <td rowspan="1">点选左上角 "disk-like" 图标</td>
    </tr>
</tbody>
</table>
<p>(思维导图模块最早由 <a href="http://ekpenso.com">ekpenso.com</a>所开发。其后由 <a href="http://www.cite.hku.hk">CITE</a>修改。)</p>
</div>';
$string['editable'] = '可编辑';
$string['editingbyuser'] = '该小组的思维导图此时此刻已锁，<span style="font-weight:bold;">{$a}</span>正在编辑。';
$string['errorcannotunlockadvmindmap'] = '事例不正确，无法解锁思维导图。';
$string['errorcannotviewgroupmindmap'] = '你不被允许查看其他小组的思维导图。';
$string['errorcannotviewusermindmap'] = '你不被允许查看其他用户的思维导图。';
$string['errorincorrectcmid'] = '课程模组ID不正确。';
$string['errorinvalidadvmindmap'] = '高级思维导图实例不正确。';
$string['errorinvalidauthor'] = '思维导图作者不是有效用户。';
$string['errornostudentincourse'] = '此课程并无学生';
$string['errornotingroup'] = '此为一群组思维导图，但你并未加入任一小组，或者你未被许可查看其他小组的思维导图。';
$string['errornouseringroup'] = '此小组没有用户。';
$string['eventmindmapunlocked'] = '思维导图已解锁。';
$string['eventmindmapupdated'] = '思维导图已更新';
$string['groupmembers'] = '小组成员';
$string['groupname'] = '小组名称';
$string['instances'] = '高级思维导图管理';
$string['invalidgroupmodefordummygroups'] = '当选择虚拟小组，小组模式应该选定"无小组"';
$string['invalidid'] = '高级思维导图ID不正确';
$string['ismember'] = '(✔你是小组成员)';
$string['largeconvas'] = '放大编辑区';
$string['lastupdated'] = '最近更新';
$string['lockedbyyou'] = '此小组思维导图已为你锁定。按此按钮可解锁并返回到课程。';
$string['modulename'] = '高级思维导图';
$string['modulenameplural'] = '高级思维导图';
$string['notavailable'] = '仍无法使用';
$string['numdummygroups'] = '虚拟小组数量';
$string['pluginadministration'] = '高级思维导图管理';
$string['pluginname'] = '高级思维导图';
$string['print'] = '打印';
$string['removeinstances'] = '删除所有的思维导图实例';
$string['smallconvas'] = '缩小编辑区';
$string['uneditable'] = '思维导图已可编辑';
$string['uniquelink'] = '链接到思维导图';
$string['unlockbutton'] = '解锁并回到课程';
$string['unlockconfirm'] = '你确定你要打开思维导图锁定并返回到课程（所有未保存的改动都将消失）？';
$string['unlocktime'] = '预计解除锁定的时间（假如没有其他用户再更新）：';
$string['viewing'] = '（查看）';
$string['viewingauthor'] = '查看 {$a} 的思维导图';
$string['viewown'] = '查看你自己的思维导图';
