<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'role', language 'no', version '4.3'.
 *
 * @package     role
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addinganewrole'] = 'Legger til en ny rolle';
$string['addrole'] = 'Legg til ny rolle';
$string['advancedoverride'] = 'Avansert rolleoverstyring';
$string['allow'] = 'Tillat';
$string['allowassign'] = 'Tillat å gi roller';
$string['allowed'] = 'Tillatt';
$string['allowoverride'] = 'Tillat rolleunntak';
$string['allowroletoassign'] = 'Tillat brukere med rollen {$a->fromrole} å tildele rollen {$a->targetrole}';
$string['allowroletooverride'] = 'Tillat brukere med rollen {$a->fromrole} å overstyre rollen {$a->targetrole}';
$string['allowroletoswitch'] = 'Tillat brukere med rollen {$a->fromrole} å bytte rolle til rollen {$a->targetrole}';
$string['allowroletoview'] = 'Tillat brukere med rollen {$a->fromrole} å se rollen {$a->targetrole}';
$string['allowswitch'] = 'Tillat rollebytter';
$string['allowview'] = 'Tillat rolle å vise';
$string['allsiteusers'] = 'Alle portalbrukere';
$string['analytics:listinsights'] = 'Filressurs';
$string['analytics:listowninsights'] = 'List egne innsikter';
$string['analytics:managemodels'] = 'Administrer modeller';
$string['archetype'] = 'Rollemal';
$string['archetype_help'] = 'Rollemalen bestemmer tillatelsene for når en rolle når den tilbakestilles til standardverdier. Rollen bestemmer også nye tillatelser for rollen når portalen blir oppgradert.';
$string['archetypecoursecreator'] = 'ROLLEMAL: Kursoppretter';
$string['archetypeeditingteacher'] = 'ROLLEMAL: Lærer og kursutvikler';
$string['archetypefrontpage'] = 'ROLLEMAL: Innlogget bruker på forsiden';
$string['archetypeguest'] = 'ROLLEMAL: Gjest';
$string['archetypemanager'] = 'ROLLEMAL: Administrator';
$string['archetypestudent'] = 'ROLLEMAL: Student';
$string['archetypeteacher'] = 'ROLLEMAL: Gjestelærer';
$string['archetypeuser'] = 'ROLLEMAL: Innlogget bruker';
$string['assignanotherrole'] = 'Tildel en annen rolle';
$string['assignedroles'] = 'Tildelte roller';
$string['assignerror'] = 'Feil ved tildeling av rollen {$a->role} til brukeren {$a->user}.';
$string['assignglobalroles'] = 'Tildel globale roller';
$string['assignmentcontext'] = 'Tildelingskontekst';
$string['assignmentoptions'] = 'Tildelingsvalg';
$string['assignrole'] = 'Tildele rolle';
$string['assignrolenameincontext'] = 'Tildel rollen  \'{$a->role}\' i {$a->context}';
$string['assignroles'] = 'Tildel roller';
$string['assignroles_help'] = 'Når du tildeler en bruker en rolle gir du brukeren alle tillatelser som gjelder for den rollen, gjeldende kontekst og alle underordnede kontekster.

Hvis du for eksempel tildeler en Student-rolle til en deltaker i et kurs, vil de få denne rollen for kurset, men også blokker og aktiviteter i kurset. ';
$string['assignroles_link'] = 'admin/roles/assign';
$string['assignrolesin'] = 'Tildel roller i {$a}';
$string['assignrolesrelativetothisuser'] = 'Tildel rolle relativt for denne brukeren';
$string['backtoallroles'] = 'Tilbake til rolleoversikten';
$string['backup:anonymise'] = 'Anonymiser brukerdata i sikkerhetskopien';
$string['backup:backupactivity'] = 'Sikkerhetskopiaktiviteter';
$string['backup:backupcourse'] = 'Sikkerhetskopier kurs';
$string['backup:backupsection'] = 'Sikkerhetskopier seksjoner';
$string['backup:backuptargetimport'] = 'Sikkerhetskopi for import';
$string['backup:configure'] = 'Konfigurer sikkerhetskopi innstillinger';
$string['backup:downloadfile'] = 'Last ned filer fra sikkerhetskopi-filområder';
$string['backup:userinfo'] = 'Sikkerhetskopiere brukerdata';
$string['badges:awardbadge'] = 'Tildel et merke til en bruker';
$string['badges:configurecriteria'] = 'Sett opp/rediger kriteriene for å få et merke';
$string['badges:configuredetails'] = 'Sett opp/rediger informasjon om utmerkelser';
$string['badges:configuremessages'] = 'Konfigurer merkemeldinger';
$string['badges:createbadge'] = 'Opprett/dupliser utmerkelser';
$string['badges:deletebadge'] = 'Slett utmerkelser';
$string['badges:earnbadge'] = 'Få et merke tildelt';
$string['badges:manageglobalsettings'] = 'Administrer globale innstillinger for utmerkelser';
$string['badges:manageownbadges'] = 'Vis og administrer egne tildelte utmerkelser';
$string['badges:revokebadge'] = 'Tilbakekalle en utmerkelse fra en bruker';
$string['badges:viewawarded'] = 'Vis brukere som har fått et bestemt merke tildelt uten å kunne tildele utmerkelser.';
$string['badges:viewbadges'] = 'Vis tilgjengelige utmerkelser uten å få dem tildelt.';
$string['badges:viewotherbadges'] = 'Vis offentlige utmerkelser i andre brukeres profiler';
$string['block:edit'] = 'Endre en blokks innstillinger';
$string['block:view'] = 'Vis blokk';
$string['blog:create'] = 'Lag nye blogginnlegg';
$string['blog:manageentries'] = 'Rediger og administrer innlegg';
$string['blog:manageexternal'] = 'Endre og administrere eksterne blogger';
$string['blog:search'] = 'Søk blogg-innlegg';
$string['blog:view'] = 'Se logginnlegg';
$string['blog:viewdrafts'] = 'Vis kladd blogginnlegg';
$string['calendar:manageentries'] = 'Administrer alle kalenderinnlegg';
$string['calendar:managegroupentries'] = 'Administrer oppføringer i gruppekalenderen';
$string['calendar:manageownentries'] = 'Administrer egne kalenderinnlegg';
$string['capabilities'] = 'Kvalifikasjoner';
$string['capability'] = 'Kvalifikasjon';
$string['category:create'] = 'Lag kategorier';
$string['category:delete'] = 'Slett kategorier';
$string['category:manage'] = 'Administrer kategorier';
$string['category:update'] = 'Oppdater kategorier';
$string['category:viewcourselist'] = 'Se kurskategori og kursene i den';
$string['category:viewhiddencategories'] = 'Se skjulte kategorier';
$string['category:visibility'] = 'Se skjulte kategorier';
$string['checkglobalpermissions'] = 'Sjekk systemtillatelser';
$string['checkpermissions'] = 'Sjekk tillatelser';
$string['checkpermissionsin'] = 'Sjekk tillatelser i {$a}';
$string['checksystempermissionsfor'] = 'Sjekk systemtillatelser for {$a->fullname}';
$string['checkuserspermissionshere'] = 'Sjekk hvilke rettigheter  {$a->fullname} har på dette {$a->contextlevel}';
$string['chooseroletoassign'] = 'Vennligst velg en rolle å tildele';
$string['cohort:assign'] = 'Legg til og fjern kohort-medlemmer';
$string['cohort:configurecustomfields'] = 'Konfigurer egendefinerte kohortfelt';
$string['cohort:manage'] = 'Opprett, slett og flytt kohorter';
$string['cohort:view'] = 'Vis globale kohorter';
$string['comment:delete'] = 'Slett kommentarer';
$string['comment:post'] = 'Post kommentarer';
$string['comment:view'] = 'Les kommentarer';
$string['competency:competencygrade'] = 'Oppgi vurdering av læringsmål';
$string['competency:competencymanage'] = 'Administrer læringsmålrammeverk';
$string['competency:competencyview'] = 'Vis læringsmålrammeverk';
$string['competency:coursecompetencyconfigure'] = 'Konfigurer læringsmålinnstillinger i kurset';
$string['competency:coursecompetencygradable'] = 'Motta læringsmålmarkeringer';
$string['competency:coursecompetencymanage'] = 'Administrer læringsmål i kurset';
$string['competency:coursecompetencyview'] = 'Vis læringsmål i kurset';
$string['competency:evidencedelete'] = 'Slett bevis';
$string['competency:plancomment'] = 'Kommenter en opplæringsplan';
$string['competency:plancommentown'] = 'Kommenter egen opplæringsplan';
$string['competency:planmanage'] = 'Administrer opplæringsplaner';
$string['competency:planmanagedraft'] = 'Administrer opplæringsplankladder';
$string['competency:planmanageown'] = 'Administrer egen opplæringsplaner';
$string['competency:planmanageowndraft'] = 'Administrer egen opplæringplankladder';
$string['competency:planrequestreview'] = 'Krev vurdering av opplæringsplan';
$string['competency:planrequestreviewown'] = 'Krev vurdering av egen opplæringsplan';
$string['competency:planreview'] = 'Vurder en opplæringsplan';
$string['competency:planview'] = 'Vis alle opplæringsplaner';
$string['competency:planviewdraft'] = 'Vil opplæringsplankladder';
$string['competency:planviewown'] = 'Vis egne opplæringsplaner';
$string['competency:planviewowndraft'] = 'Vis egne opplringsplankladder';
$string['competency:templatemanage'] = 'Administrer opplæringsplanmaler';
$string['competency:templateview'] = 'Vis opplæringsplanmaler';
$string['competency:usercompetencycomment'] = 'Kommenter et læringsmål';
$string['competency:usercompetencycommentown'] = 'Kommenter eget læringsmål';
$string['competency:usercompetencyrequestreview'] = 'Krev vurdering av læringsmål';
$string['competency:usercompetencyrequestreviewown'] = 'Krev vurdering av eget læringsmål';
$string['competency:usercompetencyreview'] = 'Vurder et læringsmål';
$string['competency:usercompetencyview'] = 'Vis et læringsmål';
$string['competency:userevidencemanage'] = 'Administrer bevis på tidligere læring';
$string['competency:userevidencemanageown'] = 'Administrer egne bevis på tidligere læring';
$string['competency:userevidenceview'] = 'Vis bevis på tidligere læring for en bruker';
$string['confirmaddadmin'] = 'Vil du virkelig legge til brukeren <strong>{$a}</strong> som ny portaladministrator?';
$string['confirmaddadmins'] = 'Er du sikker på at du vil legge til følgende brukere i listen over portal-administratorer?';
$string['confirmdeladmin'] = 'Vil du virkelig fjerne brukeren <strong>{$a}</strong> fra listen over portaladministratorer?';
$string['confirmremoveadmins'] = 'Er du sikker på at du vil fjerne følgende brukere fra listen over portal-administratorer?';
$string['confirmroleprevent'] = 'Vil du virkelig fjerne <strong>"{$a->role}"</strong> fra listen over tillatte roller for rettigheten "{$a->cap}" i konteksten "{$a->context}"?';
$string['confirmroleunprohibit'] = 'Vil du virkelig fjerne <strong>"{$a->role}"</strong> fra listen over nektede roller for rettigheten "{$a->cap}" i konteksten "{$a->context}"?';
$string['confirmunassign'] = 'Er du sikker på at du vil fjerne denne rollen fra denne brukeren?';
$string['confirmunassignno'] = 'Avbryt';
$string['confirmunassigntitle'] = 'Bekreft rolleendringen';
$string['confirmunassignyes'] = 'Fjern';
$string['contentbank:access'] = 'Tilgang til innholdsbanken';
$string['contentbank:copyanycontent'] = 'Kopier alt innhold i innholdsbanken';
$string['contentbank:copycontent'] = 'Kopier innhold i innholdsbanken';
$string['contentbank:deleteanycontent'] = 'Slett innhold fra innholdsbanken';
$string['contentbank:deleteowncontent'] = 'Slett innhold fra egen innholdsbank';
$string['contentbank:downloadcontent'] = 'Last ned innhold fra innholdsbanken';
$string['contentbank:manageanycontent'] = 'Administrer innhold fra innholdsbanken';
$string['contentbank:manageowncontent'] = 'Administrer eget innhold fra innholdsbanken';
$string['contentbank:upload'] = 'Last opp nytt innhold til innholdsbanken';
$string['contentbank:useeditor'] = 'Opprett eller rediger innhold med å bruke en innholdseditor.';
$string['contentbank:viewunlistedcontent'] = 'Se ulistet innhold fra innholdsbanken';
$string['context'] = 'Kontekst';
$string['contextrolenotallowed'] = 'Rollen {$a} er ikke tillatt i denne konteksten.';
$string['course:activityvisibility'] = 'Skjul/vis aktiviteter';
$string['course:bulkmessaging'] = 'Send melding til mange brukere';
$string['course:changecategory'] = 'Endre kurskategori';
$string['course:changefullname'] = 'Endre kursets navn';
$string['course:changeidnumber'] = 'Endre kursets ID-nummer';
$string['course:changelockedcustomfields'] = 'Endre låste egendefinerte felt';
$string['course:changeshortname'] = 'Endre kursets kortnavn';
$string['course:changesummary'] = 'Endre kursbeskrivelse';
$string['course:configurecoursecommunication'] = 'Konfigurer innstillinger for kurskommunikasjon';
$string['course:configurecustomfields'] = 'Konfigurer egendefinerte kursfelt';
$string['course:configuredownloadcontent'] = 'Konfigurer nedlasting av kursinnhold';
$string['course:create'] = 'Lag kurs';
$string['course:creategroupconversations'] = 'Opprett gruppesamtale';
$string['course:delete'] = 'Slett kurs';
$string['course:downloadcoursecontent'] = 'Last ned kursinnhold';
$string['course:enrolconfig'] = 'Konfigurer påmeldingsinstanser i kurset';
$string['course:enrolreview'] = 'Se over kurspåmeldinger';
$string['course:ignoreavailabilityrestrictions'] = 'Ignorer tilgjengelighetsrestriksjoner';
$string['course:ignorefilesizelimits'] = 'Bruk filer som er større enn de satte størrelsesbegrensningene';
$string['course:isincompletionreports'] = 'Vises i fullførtrapporter';
$string['course:manageactivities'] = 'Administrer aktiviteter';
$string['course:managefiles'] = 'Administrer filer';
$string['course:managegrades'] = 'Administrer karakterer';
$string['course:managegroups'] = 'Administrer grupper';
$string['course:managescales'] = 'Administrer skalaer';
$string['course:markcomplete'] = 'Merk brukere som fullført i kursfullføringen';
$string['course:movesections'] = 'Flytt seksjoner';
$string['course:overridecompletion'] = 'Overstyr aktivitetsfullføringsstatus';
$string['course:recommendactivity'] = 'Anbefal aktiviteter i aktivitetsvelgeren';
$string['course:renameroles'] = 'Gi roller nye navn';
$string['course:request'] = 'Send inn et kursønske';
$string['course:reset'] = 'Nullstill kurs';
$string['course:reviewotherusers'] = 'Gå gjennom andre brukere';
$string['course:sectionvisibility'] = 'Kontroller seksjonens synlighet';
$string['course:setcurrentsection'] = 'Sett aktiv seksjon';
$string['course:setforcedlanguage'] = 'Tving kurs- eller aktivitetsspråk';
$string['course:tag'] = 'Endre kurstagger';
$string['course:togglecompletion'] = 'Tillat manuell aktivitetsfullføring';
$string['course:update'] = 'Oppdater kursinnstillinger';
$string['course:useremail'] = 'Vis/ikke vis epostadresse';
$string['course:view'] = 'Se kurs uten å være påmeldt';
$string['course:viewcoursegrades'] = 'Se kurskarakterer';
$string['course:viewhiddenactivities'] = 'Se skjulte aktiviteter';
$string['course:viewhiddencourses'] = 'Se skjulte kurs';
$string['course:viewhiddengroups'] = 'Vis skjulte grupper';
$string['course:viewhiddensections'] = 'Se skjulte seksjoner';
$string['course:viewhiddenuserfields'] = 'Se skjulte brukerfelt';
$string['course:viewparticipants'] = 'Se brukere';
$string['course:viewscales'] = 'Se karakterskalaer';
$string['course:viewsuspendedusers'] = 'Vis utestengte brukere.';
$string['course:visibility'] = 'Skjul/vis kurs';
$string['createrolebycopying'] = 'Opprett en ny rolle ved å kopiere {$a}';
$string['createthisrole'] = 'Opprett denne rollen';
$string['currentcontext'] = 'Gjeldende kontekst';
$string['currentrole'] = 'Aktiv rolle';
$string['customroledescription'] = 'Egendefinert beskrivelse';
$string['customroledescription_help'] = 'Beskrivelser av standardroller lokaliseres automatisk hvis egendefinert beskrivelse ikke er oppgitt.';
$string['customrolename'] = 'Egendefinert fullt navn';
$string['customrolename_help'] = 'Navn på standardroller lokaliseres automatisk hvis egendefinert navn ikke er oppgitt. Du må oppgi fullt navn for alle egendefinerte roller.';
$string['defaultrole'] = 'Standard rolle';
$string['defaultx'] = 'Standard: {$a}';
$string['defineroles'] = 'Definer roller';
$string['definitionofrolex'] = 'Definisjon av rollen \'{$a}\'';
$string['deletecourseoverrides'] = 'Slett alle overstyringer i kurset';
$string['deletelocalroles'] = 'Slett alle lokale rolletildelinger';
$string['deleterolesure'] = '<p>Er du sikker på at du vil slette rollen "{$a->name} ({$a->shortname})"?</p><p>Denne er for tiden {$a->count} brukere som har denne rollen.</p>';
$string['deletexrole'] = 'Slett {$a} rollen';
$string['duplicaterole'] = 'Dupliker rolle';
$string['duplicaterolesure'] = '<p>Er du sikker på at du vil duplikere rolle "{$a->name} ({$a->shortname})"?</p>';
$string['editingrolex'] = 'Endrer rollen \'{$a}\'';
$string['editrole'] = 'Rediger rolle';
$string['editxrole'] = 'Endre rollen {$a}';
$string['errorbadrolename'] = 'Feil rollenavn';
$string['errorbadroleshortname'] = 'Ugyldig kortnavn for rolle';
$string['errorexistsrolename'] = 'Rollenavnet finnes allerede';
$string['errorexistsroleshortname'] = 'Rollenavnet finnes allerede';
$string['errorroleshortnametoolong'] = 'Kortnavnet kan ikke være lengre enn 100 tegn.';
$string['eventcapabilityassigned'] = 'Tillatelse lagt til';
$string['eventcapabilityunassigned'] = 'Tillatelse fjernet';
$string['eventroleallowassignupdated'] = 'Tillat rolletildelinger';
$string['eventroleallowoverrideupdated'] = 'Tillat brukeroverstyring';
$string['eventroleallowswitchupdated'] = 'Tillat rollebytter';
$string['eventroleallowviewupdated'] = 'Tillat rollevisning';
$string['eventroleassigned'] = 'Tildelte roller';
$string['eventrolecapabilitiesupdated'] = 'Rollerettigheter oppdatert';
$string['eventrolecreated'] = 'Rolle opprettet';
$string['eventroledeleted'] = 'Rolle slettet';
$string['eventroleunassigned'] = 'Ikke tildelt rolle';
$string['eventroleupdated'] = 'Rolle oppdatert';
$string['existingadmins'] = 'Gjeldende portaladministratorer';
$string['existingusers'] = '{$a} eksisterende brukere';
$string['explanation'] = 'Forklaring';
$string['export'] = 'Eksporter';
$string['extusers'] = 'Eksisterende brukere';
$string['extusersmatching'] = 'Eksisterende brukere som samsvarer med \'{$a}\'';
$string['filter:manage'] = 'Administrere lokale filterinnstillinger';
$string['frontpageuser'] = 'Innlogget bruker på forsiden';
$string['frontpageuserdescription'] = 'Alle innloggede brukere på forsiden.';
$string['globalrole'] = 'Systemrolle';
$string['globalroleswarning'] = 'ADVARSEL! Roller du prøver å tildele fra denne siden vil gjelde de tildelte brukerne over hele portalen, inkludert forsiden og alle kurs.';
$string['gotoassignroles'] = 'Gå til Tildel roller for denne {$a->contextlevel}';
$string['gotoassignsystemroles'] = 'Gå til Tildel systemroller';
$string['grade:edit'] = 'Endre karakterer';
$string['grade:export'] = 'Eksporter karakterer';
$string['grade:hide'] = 'Skjul karakter';
$string['grade:import'] = 'Importer karakterer';
$string['grade:lock'] = 'Lås karakter';
$string['grade:manage'] = 'Administrere karakterelementer';
$string['grade:managegradingforms'] = 'Administrer avanserte karaktersettingsmetoder';
$string['grade:manageletters'] = 'Administrere bokstavkarakterer';
$string['grade:manageoutcomes'] = 'Administrere karakterresultater';
$string['grade:managesharedforms'] = 'Administrer maler for avanserte karaktersettingsmetoder';
$string['grade:override'] = 'Overstyr karakterer';
$string['grade:sharegradingforms'] = 'Del avansert karaktersettingsskjema som mal';
$string['grade:unlock'] = 'Åpne karakterer/elementer for redigering';
$string['grade:view'] = 'Vis egne karakterer';
$string['grade:viewall'] = 'Vis karakterer for andre brukere';
$string['grade:viewhidden'] = 'Se skjult karakter';
$string['group:configurecustomfields'] = 'Konfigurer gruppe/gruppering av egendefinerte felt';
$string['h5p:deploy'] = 'Legg til H5P innhold';
$string['h5p:setdisplayoptions'] = 'H5P visningsvalg';
$string['h5p:updatelibraries'] = 'Administrer H5P innholdstyper';
$string['highlightedcellsshowdefault'] = 'De merkede feltene i tabellen under viser standard tillatelser for rolletypen som ble valgt ovenfor.';
$string['highlightedcellsshowinherit'] = 'De merkede feltene i tabellen under viser rettighetene (hvis noen) som vil bli arvet. Bortsett fra rettigheter du vil tildele bør du la alt stå som arvet.';
$string['inactiveformorethan'] = 'inaktiv for mer enn {$a->timeperiod}';
$string['ingroup'] = 'i gruppen "{$a->group}"';
$string['inherit'] = 'Arv';
$string['invalidpresetfile'] = 'Ugyldig rolledefinisjonsfil';
$string['legacy:admin'] = 'ARVET ROLLE: Administrator';
$string['legacy:coursecreator'] = 'ARVET ROLLE: Kursoppretter';
$string['legacy:editingteacher'] = 'ARVET ROLLE: Lærer (redigerer)';
$string['legacy:guest'] = 'ARVET ROLLE: Gjest';
$string['legacy:student'] = 'ARVET ROLLE: Elev';
$string['legacy:teacher'] = 'ARVET ROLLE: Lærer (ikke-redigerende)';
$string['legacy:user'] = 'ARVET ROLLE: Autentisert bruker';
$string['legacytype'] = 'Arvet rolletype';
$string['listallroles'] = 'List alle roller';
$string['localroles'] = 'Lokalt tildelte roller';
$string['mainadmin'] = 'Hovedadministrator';
$string['mainadminset'] = 'Angi hovedadmin';
$string['manageadmins'] = 'Administrere portaladministratorer';
$string['manager'] = 'Superbruker';
$string['managerdescription'] = 'Superbrukere har tilgang til kurs og kan endre dem, men de er vanligvis ikke kursdeltakere.';
$string['manageroles'] = 'Administrer roller';
$string['maybeassignedin'] = 'Konteksttyper hvor denne rollen kan tildeles';
$string['moodlenet:shareactivity'] = 'Del aktiviteter til MoodleNet';
$string['moodlenet:sharecourse'] = 'Del kurset til MoodleNet';
$string['morethan'] = 'Mer enn {$a}';
$string['multipleroles'] = 'Multiple roller';
$string['my:configsyspages'] = 'Sett opp portalmaler for Dashbord';
$string['my:manageblocks'] = 'Administrer Dashbord-blokker';
$string['neededroles'] = 'Roller med tillatelse';
$string['nocapabilitiesincontext'] = 'Ingen kapasitet er tilgjengelig her';
$string['noneinthisx'] = 'Ingen i denne {$a}';
$string['noneinthisxmatching'] = 'Ingen brukere samsvarer med \'{$a->search}\' i denne {$a->contexttype}';
$string['norole'] = 'Ingen rolle';
$string['noroleassignments'] = 'Denne brukeren har ikke noen rolletildelinger andre steder på denne portalen.';
$string['noroles'] = 'Ingen roller';
$string['notabletoassignroleshere'] = 'Portaladministratoren har ikke tillatt at det tildeles roller i denne konteksten.';
$string['notabletooverrideroleshere'] = 'Du har ikke lov til å overstyre tillatelser på noen roller her';
$string['notes:manage'] = 'Administrer notater';
$string['notes:view'] = 'Se notater';
$string['notset'] = 'Ikke satt';
$string['novisibleroles'] = 'Ingen roller';
$string['overrideanotherrole'] = 'Overstyre en annen rolle';
$string['overridecontext'] = 'Overstyre kontekst';
$string['overridepermissions'] = 'Overstyr tillatelser';
$string['overridepermissions_help'] = '<p>Overstyringer er særskilt tildelte rettigheter for en rolle i en bestemt kontekst. Overstyringer lar deg i detalj skreddersy tillatelser etter behov.</p>

<p>F.eks. hvis du som standard har satt at studenter kan starte nye diskusjoner i et kurs, og har ett bestemt forum hvor du IKKE ønsker dette,  kan du angi en overstyring som begrenser denne rettigheten for dette ene forumet. Du gjør det ved å merke av for "Hindre" på rettigheten "Starte nye diskusjoner".</p>

<p>Overstyringer kan også brukes motsatt, til å "åpne opp" områder på portal og kurs ved å gi brukerne ekstra rettigheter der det er ønskelig. Du kan f.eks. eksperimentere med å la studenter få vurdere noen oppgaver.</p>

<p>Skjermbildet ligner på defininering av roller, med unntak av at bare relevante tildelinger vises. Du vil også se hva som er standard, siden de feltene er merket med en litt mørkere bakgrunn.</p>

<p>Se også
<a href="help.php?file=roles.html">Roller</a>,
<a href="help.php?file=contexts.html">Kontekster</a>,
<a href="help.php?file=assignroles.html">Tildele roller</a> og
<a href="help.php?file=permissions.html">Tillatelser</a>.
</p>';
$string['overridepermissions_link'] = 'admin/roles/override';
$string['overridepermissionsforrole'] = 'Overstyre tillatelser for rollen  \'{$a->role}\' i {$a->context}';
$string['overridepermissionsin'] = 'Overstyr tillatelser i {$a}';
$string['overrideroles'] = 'Overstyr roller';
$string['overriderolesin'] = 'Overstyr roller i {$a}';
$string['overrides'] = 'Overstyringer';
$string['overridesbycontext'] = 'Overstyres (av konteksten)';
$string['payment:manageaccounts'] = 'Administrere kontoer';
$string['payment:viewpayments'] = 'Vis betalinger';
$string['permission'] = 'Tillatelse';
$string['permission_help'] = 'Tillatelser er innstillinger du gir ut for bestemte rettigheter. For hver rolle kan du angi tillatelser for en rettighet ved hjelp av en av fire verdier:

* IKKE SATT
* TILLAT - Ved å velge TILLAT vil du tildele rettigheten til alle brukere som får denne rollen. Denne tillatelsen gjelder der den er tildelt og alle underliggende nivåer. En student som har fått rettigheten til å "Starte nye diskusjoner" vil kunne gjøre dette i alle forum i kurset, UNNTATT de forum hvor det er satt overstyring på samme rettighet.
* FORHINDRE - Ved å angi denne vil du forhindre tillatelse for denne rettigheten, selv om brukeren har rettigheten i en overordnet kontekst. Er det satt FORHINDRE på overordnet nivå kan rettigheten overstyres på lavere nivå.
* NEKT - Denne trengs ganske sjelden, men noen ganger har du bruk for å nekte fullstendig tilgangen til en rettighet i en rolle som IKKE kan overstyres på lavere nivå. Et eksempel kan være en bruker du ønsker å nekte å starte nye diskusjoner i hvilket som helst forum overalt på systemet. I slike tilfeller er det nødvendig å lage en ny rolle hvor denne rettighetene er satt til NEKT, og deretter tildele denne rollen på globalt nivå til aktuell bruker.';
$string['permissions'] = 'Tillatelser';
$string['permissionsforuser'] = 'Tillatelser for bruker {$a}';
$string['permissionsincontext'] = 'Tillatelser i {$a}';
$string['portfolio:export'] = 'Eksporter til porteføljer';
$string['potentialusers'] = '{$a} potensielle brukere';
$string['potusers'] = 'Potensielle brukere';
$string['potusersmatching'] = 'Potensielle brukere som samsvarer med \'{$a}\'';
$string['prevent'] = 'Forhindre';
$string['privacy:metadata:preference:showadvanced'] = 'Håndter knappen for vis avansert modu';
$string['privacy:metadata:role_assignments'] = 'Rolletildelinger';
$string['privacy:metadata:role_assignments:component'] = 'Modul ansvarlig for rolletildelinger, tom når manuelt tildelt.';
$string['privacy:metadata:role_assignments:itemid'] = 'ID\'en til påmeldings- eller autentiseringsmetoden ansvarlig for denne rolletildelingen.';
$string['privacy:metadata:role_assignments:modifierid'] = 'ID\'en til brukeren som opprettet eller endret rolletildelingen.';
$string['privacy:metadata:role_assignments:roleid'] = 'RolleID\'en';
$string['privacy:metadata:role_assignments:tableexplanation'] = 'Denne tabellen lagrer tildelte roller i hver kontekst.';
$string['privacy:metadata:role_assignments:timemodified'] = 'Når rolletildelingen ble opprettet eller endret.';
$string['privacy:metadata:role_assignments:userid'] = 'BrukerID\'en';
$string['privacy:metadata:role_capabilities'] = 'Rolletillatelser';
$string['privacy:metadata:role_capabilities:capability'] = 'Navn på tillatelse';
$string['privacy:metadata:role_capabilities:modifierid'] = 'IDen til brukeren som opprettet eller redigerte ti';
$string['privacy:metadata:role_capabilities:permission'] = 'Tillatelsen for en rettighet; arv, tillat, forhindre eller nekt';
$string['privacy:metadata:role_capabilities:roleid'] = 'RolleID\'en';
$string['privacy:metadata:role_capabilities:tableexplanation'] = 'Rettighetene og overskrevne rettigheter for en bestemt rolle i en beste';
$string['privacy:metadata:role_capabilities:timemodified'] = 'Dato tillatelsen ble opprettet ell';
$string['privacy:metadata:role_cohortroles'] = 'Roller til kohort';
$string['prohibit'] = 'Nekt';
$string['prohibitedroles'] = 'Nektet';
$string['question:add'] = 'Legg til nytt spørsmål';
$string['question:commentall'] = 'Kommentér på alle spørsmål';
$string['question:commentmine'] = 'Kommentér dine egne spørsmål';
$string['question:config'] = 'Konfigurer spørsmålstyper';
$string['question:editall'] = 'Endre alle spørsmålene';
$string['question:editmine'] = 'Endre dine egne spørsmål';
$string['question:flag'] = 'Flagg spørsmål når de forsøkes';
$string['question:managecategory'] = 'Administrere spørsmålskategorier';
$string['question:moveall'] = 'Flytt alle spørsmålene';
$string['question:movemine'] = 'Flytt dine egne spørsmål';
$string['question:tagall'] = 'Tag alle spørsmål';
$string['question:tagmine'] = 'Tag egne spørsmål';
$string['question:useall'] = 'Bruk alle spørsmålene';
$string['question:usemine'] = 'Bruk dine egne spørsmål';
$string['question:viewall'] = 'Vis alle spørsmålene';
$string['question:viewmine'] = 'Vis dine egne spørsmål';
$string['rating:rate'] = 'Legg vurdering til elementer';
$string['rating:view'] = 'Vis alle vurderinger du har mottatt';
$string['rating:viewall'] = 'Vis alle vurderinger gitt av enkeltbrukere';
$string['rating:viewany'] = 'Vis total vurdering på alt som er mottatt';
$string['reportbuilder:edit'] = 'Rediger dine egne tilpassede rapporter';
$string['reportbuilder:editall'] = 'Rediger alle tilpassede rapporter';
$string['reportbuilder:scheduleviewas'] = 'Planlegg rapporter for å bli sett på som andre brukere';
$string['reportbuilder:view'] = 'Se tilpassede rapporter';
$string['resetrole'] = 'Tilbakestill til standard';
$string['resettingrole'] = 'Tilbakestiller rollen \'{$a}\'';
$string['restore:configure'] = 'Konfigurer gjenopprettingsvalg';
$string['restore:createuser'] = 'Opprett brukere ved gjenoppretting';
$string['restore:restoreactivity'] = 'Gjenopprett aktiviteter';
$string['restore:restorecourse'] = 'Gjenopprett kurs';
$string['restore:restoresection'] = 'Gjenopprett seksjoner';
$string['restore:restoretargetimport'] = 'Gjenopprett fra filer merket som import';
$string['restore:rolldates'] = 'Har tillatelse til å rullere datoer for aktiviteter ved gjenoppretting';
$string['restore:uploadfile'] = 'Last opp filer til sikkerhetskopiområder';
$string['restore:userinfo'] = 'Gjenopprett brukerdata';
$string['restore:viewautomatedfilearea'] = 'Gjenopprett kurs fra automatiske sikkerhetskopier';
$string['risks'] = 'Risiko';
$string['role:assign'] = 'Tildel roller til brukere';
$string['role:manage'] = 'Lag og administrer roller';
$string['role:override'] = 'Overstyr tillatelser til andre';
$string['role:review'] = 'Se over tillatelser for andre';
$string['role:safeoverride'] = 'Overstyr sikre tillatelser for andre';
$string['role:switchroles'] = 'Bytt til andre roller';
$string['roleallowheader'] = 'Tillat roller:';
$string['roleallowinfo'] = 'Velg en rolle som skal legges til listen over tillatte roller i konteksten "{$a->context}", rettighet "{$a->cap}":';
$string['roleassignments'] = 'Rolletildelinger';
$string['roledefinitions'] = 'Rolledefinisjoner';
$string['rolefullname'] = 'Navn';
$string['roleincontext'] = '{$a->role} i {$a->context}';
$string['roleprohibitheader'] = 'Nekt rolle';
$string['roleprohibitinfo'] = 'Velg en rolle som skal legges til listen over nektede roller i konteksten "{$a->context}", rettighet "{$a->cap}":';
$string['rolerepreset'] = 'Brukerrolle forhåndsinnstilling';
$string['roleresetdefaults'] = 'Standardverdier';
$string['roleresetrole'] = 'Brukerrolle eller arketypen';
$string['rolerisks'] = 'Rollerisikoer';
$string['roles'] = 'Roller';
$string['roles_help'] = '<p> En rolle er en samling tillatelser som gjelder hele systemet og som kan tildeles brukere fra globalt nivå og nedover til bestemte kontekster i de enkelte kurs og aktiviteter.</p>

<p>F.eks. er Lærer-rollen satt opp med tillatelser til å gjøre bestemte ting i et kurs  (og ikke andre steder). Straks rollen er opprettet kan den tildeles brukere som skal være lærere i et kurs. Dersom rollen "Lærer" tildeles brukere på kategorinivå vil de bli lærere for alle kurs i denne kategorien med underkategorier. Du kan også, f.eks. i et forum, tildele Lærerrollen til en bruker for at brukeren skal få bestemte rettigheter akkurat der.</p>

<p>En rolle må ha et <strong>navn</strong>.  Dersom du trenger å navne rollen i kurs med flerspråkhåndtering kan du legge inn rollenavnene på denne måten:
<pre>
  &lt;span lang="en"&gt;Teacher&lt;/span&gt;
  &lt;span lang="es_es"&gt;Profesor&lt;/span&gt;
  </pre>
Dersom du gjør dette må du sjekke at "Filtrer alle strenger" er aktivert på din installasjon.</p>

<p><strong>kortnavn</strong> er nødvendig for at andre moduler i Moodle skal kunne bruke rollene, sjekke rettigheter osv.</p>

<p><strong>beskrivelse</strong> er ganske enkelt en rollebeskrivelse med dine egne ord, slik at andre forstår hensikten med denne rollen.</p>

<p>
Se også
<a href="help.php?file=contexts.html">Kontekster</a>,
<a href="help.php?file=permissions.html">Tillatelser</a>,
<a href="help.php?file=assignroles.html">Tildele roller</a> og
<a href="help.php?file=overrides.html">Overstyringer</a>.
</p>';
$string['roles_link'] = 'roles';
$string['roleselect'] = 'Velg rolle';
$string['rolesforuser'] = 'Roller for bruker {$a}';
$string['roleshortname'] = 'Kort navn';
$string['roleshortname_help'] = 'Rollers kortnavn er en lavnivå-ID hvor bare ASCII alfanumeriske tegn er tillatt. Ikke endre kortnavn på standardroller.';
$string['roletoassign'] = 'Rolle å tildele';
$string['roletooverride'] = 'Rolle å overstyre';
$string['safeoverridenotice'] = 'OBS: Opsjoner med høyere risiko er låst fordi du ikke har tillatelse til å overstyre sikre opsjoner.';
$string['search:query'] = 'Utfør portalsøk';
$string['selectanotheruser'] = 'Velg en annen bruker';
$string['selectauser'] = 'Velg en bruker';
$string['selectrole'] = 'Velg en rolle';
$string['showallroles'] = 'Vis alle roller';
$string['showthisuserspermissions'] = 'Vis denne brukerens rettigheter';
$string['site:accessallgroups'] = 'Tilgang til alle grupper';
$string['site:approvecourse'] = 'Tillat opprettelse av kurs';
$string['site:backup'] = 'Ta sikkerhetskopi av kurs';
$string['site:config'] = 'Endre kursinnstillinger';
$string['site:configview'] = 'Vis portaladministrasjonstreet (men ikke alle sidene i det)';
$string['site:deleteanymessage'] = 'Slett alle meldinger på portalen';
$string['site:deleteownmessage'] = 'Slett meldinger sent og mottatt av bruker';
$string['site:doanything'] = 'Tillat å gjøre alt';
$string['site:doclinks'] = 'Vis lenker til dokumenter utenfor portalen';
$string['site:forcelanguage'] = 'Overstyre kursspråket';
$string['site:import'] = 'Importer andre kurs til et kurs';
$string['site:maintenanceaccess'] = 'Tilgang når vedlikeholdsmodus er aktivert.';
$string['site:manageallmessaging'] = 'Legg til, fjern, blokker og avblokker kontakter for enhver bruker';
$string['site:manageblocks'] = 'Administrere sideblokker';
$string['site:managecontextlocks'] = 'Administrer låsing av kontekster';
$string['site:messageanyuser'] = 'OVerse personvernpreferansene for å sende melding til enhver bruk';
$string['site:mnetloginfromremote'] = 'Logg inn fra en ekstern Moodle-portal via MNET';
$string['site:mnetlogintoremote'] = 'Gå over til en ekstern Moodle-portal via MNET';
$string['site:readallmessages'] = 'Les alle beskjeder på portalen';
$string['site:restore'] = 'Gjenopprett kurs';
$string['site:senderrormessage'] = 'Send en melding for å gi brukerstøtte til brukeren fra feilmeldingssiden';
$string['site:sendmessage'] = 'Send meldinger til enhver bruker';
$string['site:trustcontent'] = 'Stol på innsendt innhold';
$string['site:uploadusers'] = 'Last opp nye brukere fra fil';
$string['site:viewanonymousevents'] = 'Vis anonyme hendelser i rapporter';
$string['site:viewfullnames'] = 'Se alltid fullt navn for brukerne';
$string['site:viewparticipants'] = 'Se deltakere';
$string['site:viewreports'] = 'Se rapporter';
$string['site:viewuseridentity'] = 'Se full bruker-ID i lister';
$string['siteadministrators'] = 'Portaladministratorer';
$string['siteadministratorsconfigphp'] = 'Listen med portaladministratorer kan ikke endres fordi den er definert i config.php';
$string['tag:edit'] = 'Endre eksisterende tagger';
$string['tag:editblocks'] = 'Endre blokker på tagg-sider';
$string['tag:flag'] = 'Flagg tagger som "upassende"';
$string['tag:manage'] = 'Administrere alle tagger';
$string['thisnewrole'] = 'Denne nye rollen';
$string['thisusersroles'] = 'Denne brukerens rolletildelinger';
$string['unassignarole'] = 'Fradel rolle {$a}';
$string['unassignconfirm'] = 'Ønsker du virkelig å fradele  "{$a->role}" rollen fra brukeren "{$a->user}"?';
$string['unassignerror'] = 'Feil ved fradeling av rollen  {$a->role} fra brukeren {$a->user}.';
$string['user:changeownpassword'] = 'Endre eget passord';
$string['user:create'] = 'Opprett brukere';
$string['user:delete'] = 'Slett brukere';
$string['user:editmessageprofile'] = 'Endre brukerens meldingsprofil';
$string['user:editownmessageprofile'] = 'Endre egen brukers meldingsprofil';
$string['user:editownprofile'] = 'Redigere egen brukerprofil';
$string['user:editprofile'] = 'Rediger brukerprofil';
$string['user:ignoreuserquota'] = 'Se bort ifra brukerkvotegrensen';
$string['user:loginas'] = 'Logg inn som andre brukere';
$string['user:manageblocks'] = 'Administrere blokker på brukerprofilen til andre brukere';
$string['user:manageownblocks'] = 'Administrere blokker på egen offentlig brukerprofil';
$string['user:manageownfiles'] = 'Administrere filer på eget privat filområde';
$string['user:managesyspages'] = 'Sette opp standard sideoppsett for offentlige brukerprofiler';
$string['user:readuserblogs'] = 'Vis alle brukerblogger';
$string['user:readuserposts'] = 'Vis alle brukerinnlegg';
$string['user:update'] = 'Oppdater brukerprofiler';
$string['user:viewalldetails'] = 'Vis full brukerinformasjon';
$string['user:viewdetails'] = 'Se brukerprofiler';
$string['user:viewhiddendetails'] = 'Vis skjulte egenskaper hos brukere';
$string['user:viewlastip'] = 'Vis brukers siste IP-adresse';
$string['user:viewuseractivitiesreport'] = 'Se brukerens aktivitetsrapport';
$string['user:viewusergrades'] = 'Se brukerens karakterer';
$string['usersfrom'] = 'Brukere fra {$a}';
$string['usersfrommatching'] = 'Brukere fra {$a->contextname} som samsvarer med \'{$a->search}\'';
$string['usersinthisx'] = 'Brukere i dette {$a}';
$string['usersinthisxmatching'] = 'Brukere i dette {$a->contexttype} som samsvarer med \'{$a->search}\'';
$string['userswithrole'] = 'Alle brukere med en rolle';
$string['userswiththisrole'] = 'Brukere med rollen';
$string['useshowadvancedtochange'] = 'Bruk "Vis avansert" for å endre';
$string['viewingdefinitionofrolex'] = 'Viser definisjoner for rollen \'{$a}\'';
$string['viewrole'] = 'Se rolledetaljer';
$string['webservice:createmobiletoken'] = 'Opprett et webtjeneste-token for mobiltilgang';
$string['webservice:createtoken'] = 'Oppretter en webtjeneste token';
$string['webservice:managealltokens'] = 'Administrer alle brukeres webservicer';
$string['whydoesuserhavecap'] = 'Hvorfor har {$a->fullname} rettigheten {$a->capability} i konteksten {$a->context}?';
$string['whydoesusernothavecap'] = 'Hvorfor har ikke {$a->fullname} rettigheten {$a->capability} i konteksten {$a->context}?';
$string['xroleassignments'] = '{$a}\'s rolletildelinger';
$string['xuserswiththerole'] = 'Brukere som har rolle "{$a->role}": {$a->number}';
